package waf_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyProtectionRuleStatus invokes the waf_openapi.ModifyProtectionRuleStatus API synchronously
func (client *Client) ModifyProtectionRuleStatus(request *ModifyProtectionRuleStatusRequest) (response *ModifyProtectionRuleStatusResponse, err error) {
	response = CreateModifyProtectionRuleStatusResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyProtectionRuleStatusWithChan invokes the waf_openapi.ModifyProtectionRuleStatus API asynchronously
func (client *Client) ModifyProtectionRuleStatusWithChan(request *ModifyProtectionRuleStatusRequest) (<-chan *ModifyProtectionRuleStatusResponse, <-chan error) {
	responseChan := make(chan *ModifyProtectionRuleStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyProtectionRuleStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyProtectionRuleStatusWithCallback invokes the waf_openapi.ModifyProtectionRuleStatus API asynchronously
func (client *Client) ModifyProtectionRuleStatusWithCallback(request *ModifyProtectionRuleStatusRequest, callback func(response *ModifyProtectionRuleStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyProtectionRuleStatusResponse
		var err error
		defer close(result)
		response, err = client.ModifyProtectionRuleStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyProtectionRuleStatusRequest is the request struct for api ModifyProtectionRuleStatus
type ModifyProtectionRuleStatusRequest struct {
	*requests.RpcRequest
	LockVersion requests.Integer `position:"Query" name:"LockVersion"`
	SourceIp    string           `position:"Query" name:"SourceIp"`
	Defense     string           `position:"Query" name:"Defense"`
	Id          requests.Integer `position:"Query" name:"Id"`
	Lang        string           `position:"Query" name:"Lang"`
	RuleStatus  requests.Integer `position:"Query" name:"RuleStatus"`
	InstanceId  string           `position:"Query" name:"InstanceId"`
	Domain      string           `position:"Query" name:"Domain"`
	Region      string           `position:"Query" name:"Region"`
}

// ModifyProtectionRuleStatusResponse is the response struct for api ModifyProtectionRuleStatus
type ModifyProtectionRuleStatusResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	TaskStatus int    `json:"TaskStatus" xml:"TaskStatus"`
	WafTaskId  int    `json:"WafTaskId" xml:"WafTaskId"`
}

// CreateModifyProtectionRuleStatusRequest creates a request to invoke ModifyProtectionRuleStatus API
func CreateModifyProtectionRuleStatusRequest() (request *ModifyProtectionRuleStatusRequest) {
	request = &ModifyProtectionRuleStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("waf-openapi", "2018-01-17", "ModifyProtectionRuleStatus", "waf", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyProtectionRuleStatusResponse creates a response to parse from ModifyProtectionRuleStatus response
func CreateModifyProtectionRuleStatusResponse() (response *ModifyProtectionRuleStatusResponse) {
	response = &ModifyProtectionRuleStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
