package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteTaobaoOrder invokes the cloudcallcenter.DeleteTaobaoOrder API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/deletetaobaoorder.html
func (client *Client) DeleteTaobaoOrder(request *DeleteTaobaoOrderRequest) (response *DeleteTaobaoOrderResponse, err error) {
	response = CreateDeleteTaobaoOrderResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteTaobaoOrderWithChan invokes the cloudcallcenter.DeleteTaobaoOrder API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/deletetaobaoorder.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteTaobaoOrderWithChan(request *DeleteTaobaoOrderRequest) (<-chan *DeleteTaobaoOrderResponse, <-chan error) {
	responseChan := make(chan *DeleteTaobaoOrderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteTaobaoOrder(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteTaobaoOrderWithCallback invokes the cloudcallcenter.DeleteTaobaoOrder API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/deletetaobaoorder.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteTaobaoOrderWithCallback(request *DeleteTaobaoOrderRequest, callback func(response *DeleteTaobaoOrderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteTaobaoOrderResponse
		var err error
		defer close(result)
		response, err = client.DeleteTaobaoOrder(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteTaobaoOrderRequest is the request struct for api DeleteTaobaoOrder
type DeleteTaobaoOrderRequest struct {
	*requests.RpcRequest
	OrderId requests.Integer `position:"Query" name:"OrderId"`
}

// DeleteTaobaoOrderResponse is the response struct for api DeleteTaobaoOrder
type DeleteTaobaoOrderResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Count          int    `json:"Count" xml:"Count"`
}

// CreateDeleteTaobaoOrderRequest creates a request to invoke DeleteTaobaoOrder API
func CreateDeleteTaobaoOrderRequest() (request *DeleteTaobaoOrderRequest) {
	request = &DeleteTaobaoOrderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "DeleteTaobaoOrder", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteTaobaoOrderResponse creates a response to parse from DeleteTaobaoOrder response
func CreateDeleteTaobaoOrderResponse() (response *DeleteTaobaoOrderResponse) {
	response = &DeleteTaobaoOrderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
