package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RefreshCustomerInfo invokes the companyreg.RefreshCustomerInfo API synchronously
func (client *Client) RefreshCustomerInfo(request *RefreshCustomerInfoRequest) (response *RefreshCustomerInfoResponse, err error) {
	response = CreateRefreshCustomerInfoResponse()
	err = client.DoAction(request, response)
	return
}

// RefreshCustomerInfoWithChan invokes the companyreg.RefreshCustomerInfo API asynchronously
func (client *Client) RefreshCustomerInfoWithChan(request *RefreshCustomerInfoRequest) (<-chan *RefreshCustomerInfoResponse, <-chan error) {
	responseChan := make(chan *RefreshCustomerInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RefreshCustomerInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RefreshCustomerInfoWithCallback invokes the companyreg.RefreshCustomerInfo API asynchronously
func (client *Client) RefreshCustomerInfoWithCallback(request *RefreshCustomerInfoRequest, callback func(response *RefreshCustomerInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RefreshCustomerInfoResponse
		var err error
		defer close(result)
		response, err = client.RefreshCustomerInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RefreshCustomerInfoRequest is the request struct for api RefreshCustomerInfo
type RefreshCustomerInfoRequest struct {
	*requests.RpcRequest
	BizId string `position:"Query" name:"BizId"`
}

// RefreshCustomerInfoResponse is the response struct for api RefreshCustomerInfo
type RefreshCustomerInfoResponse struct {
	*responses.BaseResponse
	AcctgSystem          string `json:"AcctgSystem" xml:"AcctgSystem"`
	BizScope             string `json:"BizScope" xml:"BizScope"`
	CompanyType          string `json:"CompanyType" xml:"CompanyType"`
	CorpAddress          string `json:"CorpAddress" xml:"CorpAddress"`
	EstablishmentDate    string `json:"EstablishmentDate" xml:"EstablishmentDate"`
	ExternalUniqueId     string `json:"ExternalUniqueId" xml:"ExternalUniqueId"`
	IncomeDeclarationPsw string `json:"IncomeDeclarationPsw" xml:"IncomeDeclarationPsw"`
	LegalRepresentative  string `json:"LegalRepresentative" xml:"LegalRepresentative"`
	OrgName              string `json:"OrgName" xml:"OrgName"`
	RegisteredCaptial    string `json:"RegisteredCaptial" xml:"RegisteredCaptial"`
	RequestId            string `json:"RequestId" xml:"RequestId"`
	TaxArea              string `json:"TaxArea" xml:"TaxArea"`
	TaxNo                string `json:"TaxNo" xml:"TaxNo"`
	TaxPreparerName      string `json:"TaxPreparerName" xml:"TaxPreparerName"`
	TaxPreparerPsw       string `json:"TaxPreparerPsw" xml:"TaxPreparerPsw"`
	TaxTypes             string `json:"TaxTypes" xml:"TaxTypes"`
	TaxiationAgentSecret string `json:"TaxiationAgentSecret" xml:"TaxiationAgentSecret"`
	TaxpayerType         string `json:"TaxpayerType" xml:"TaxpayerType"`
	TenantId             int64  `json:"TenantId" xml:"TenantId"`
}

// CreateRefreshCustomerInfoRequest creates a request to invoke RefreshCustomerInfo API
func CreateRefreshCustomerInfoRequest() (request *RefreshCustomerInfoRequest) {
	request = &RefreshCustomerInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-10-22", "RefreshCustomerInfo", "companyreg", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRefreshCustomerInfoResponse creates a response to parse from RefreshCustomerInfo response
func CreateRefreshCustomerInfoResponse() (response *RefreshCustomerInfoResponse) {
	response = &RefreshCustomerInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
