package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopOrRollbackOptimizeTask invokes the das.StopOrRollbackOptimizeTask API synchronously
func (client *Client) StopOrRollbackOptimizeTask(request *StopOrRollbackOptimizeTaskRequest) (response *StopOrRollbackOptimizeTaskResponse, err error) {
	response = CreateStopOrRollbackOptimizeTaskResponse()
	err = client.DoAction(request, response)
	return
}

// StopOrRollbackOptimizeTaskWithChan invokes the das.StopOrRollbackOptimizeTask API asynchronously
func (client *Client) StopOrRollbackOptimizeTaskWithChan(request *StopOrRollbackOptimizeTaskRequest) (<-chan *StopOrRollbackOptimizeTaskResponse, <-chan error) {
	responseChan := make(chan *StopOrRollbackOptimizeTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopOrRollbackOptimizeTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopOrRollbackOptimizeTaskWithCallback invokes the das.StopOrRollbackOptimizeTask API asynchronously
func (client *Client) StopOrRollbackOptimizeTaskWithCallback(request *StopOrRollbackOptimizeTaskRequest, callback func(response *StopOrRollbackOptimizeTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopOrRollbackOptimizeTaskResponse
		var err error
		defer close(result)
		response, err = client.StopOrRollbackOptimizeTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopOrRollbackOptimizeTaskRequest is the request struct for api StopOrRollbackOptimizeTask
type StopOrRollbackOptimizeTaskRequest struct {
	*requests.RpcRequest
	StopOrRollback string `position:"Query" name:"StopOrRollback"`
	TaskType       string `position:"Query" name:"TaskType"`
	Context        string `position:"Query" name:"__context"`
	Signature      string `position:"Query" name:"Signature"`
	UserId         string `position:"Query" name:"UserId"`
	Uid            string `position:"Query" name:"Uid"`
	InstanceId     string `position:"Query" name:"InstanceId"`
	AccessKey      string `position:"Query" name:"AccessKey"`
	TaskUuid       string `position:"Query" name:"TaskUuid"`
}

// StopOrRollbackOptimizeTaskResponse is the response struct for api StopOrRollbackOptimizeTask
type StopOrRollbackOptimizeTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Synchro   string `json:"Synchro" xml:"Synchro"`
	Data      string `json:"Data" xml:"Data"`
	Code      string `json:"Code" xml:"Code"`
	Success   string `json:"Success" xml:"Success"`
}

// CreateStopOrRollbackOptimizeTaskRequest creates a request to invoke StopOrRollbackOptimizeTask API
func CreateStopOrRollbackOptimizeTaskRequest() (request *StopOrRollbackOptimizeTaskRequest) {
	request = &StopOrRollbackOptimizeTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "StopOrRollbackOptimizeTask", "das", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStopOrRollbackOptimizeTaskResponse creates a response to parse from StopOrRollbackOptimizeTask response
func CreateStopOrRollbackOptimizeTaskResponse() (response *StopOrRollbackOptimizeTaskResponse) {
	response = &StopOrRollbackOptimizeTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
