package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckMetaTable invokes the dataworks_public.CheckMetaTable API synchronously
func (client *Client) CheckMetaTable(request *CheckMetaTableRequest) (response *CheckMetaTableResponse, err error) {
	response = CreateCheckMetaTableResponse()
	err = client.DoAction(request, response)
	return
}

// CheckMetaTableWithChan invokes the dataworks_public.CheckMetaTable API asynchronously
func (client *Client) CheckMetaTableWithChan(request *CheckMetaTableRequest) (<-chan *CheckMetaTableResponse, <-chan error) {
	responseChan := make(chan *CheckMetaTableResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckMetaTable(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckMetaTableWithCallback invokes the dataworks_public.CheckMetaTable API asynchronously
func (client *Client) CheckMetaTableWithCallback(request *CheckMetaTableRequest, callback func(response *CheckMetaTableResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckMetaTableResponse
		var err error
		defer close(result)
		response, err = client.CheckMetaTable(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckMetaTableRequest is the request struct for api CheckMetaTable
type CheckMetaTableRequest struct {
	*requests.RpcRequest
	DataSourceType string `position:"Query" name:"DataSourceType"`
	TableGuid      string `position:"Query" name:"TableGuid"`
	DatabaseName   string `position:"Query" name:"DatabaseName"`
	ClusterId      string `position:"Query" name:"ClusterId"`
	TableName      string `position:"Query" name:"TableName"`
}

// CheckMetaTableResponse is the response struct for api CheckMetaTable
type CheckMetaTableResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateCheckMetaTableRequest creates a request to invoke CheckMetaTable API
func CreateCheckMetaTableRequest() (request *CheckMetaTableRequest) {
	request = &CheckMetaTableRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "CheckMetaTable", "", "")
	request.Method = requests.POST
	return
}

// CreateCheckMetaTableResponse creates a response to parse from CheckMetaTable response
func CreateCheckMetaTableResponse() (response *CheckMetaTableResponse) {
	response = &CheckMetaTableResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
