package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDcdnDomain invokes the dcdn.DeleteDcdnDomain API synchronously
func (client *Client) DeleteDcdnDomain(request *DeleteDcdnDomainRequest) (response *DeleteDcdnDomainResponse, err error) {
	response = CreateDeleteDcdnDomainResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDcdnDomainWithChan invokes the dcdn.DeleteDcdnDomain API asynchronously
func (client *Client) DeleteDcdnDomainWithChan(request *DeleteDcdnDomainRequest) (<-chan *DeleteDcdnDomainResponse, <-chan error) {
	responseChan := make(chan *DeleteDcdnDomainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDcdnDomain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDcdnDomainWithCallback invokes the dcdn.DeleteDcdnDomain API asynchronously
func (client *Client) DeleteDcdnDomainWithCallback(request *DeleteDcdnDomainRequest, callback func(response *DeleteDcdnDomainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDcdnDomainResponse
		var err error
		defer close(result)
		response, err = client.DeleteDcdnDomain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDcdnDomainRequest is the request struct for api DeleteDcdnDomain
type DeleteDcdnDomainRequest struct {
	*requests.RpcRequest
	OwnerAccount  string           `position:"Query" name:"OwnerAccount"`
	DomainName    string           `position:"Query" name:"DomainName"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
}

// DeleteDcdnDomainResponse is the response struct for api DeleteDcdnDomain
type DeleteDcdnDomainResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteDcdnDomainRequest creates a request to invoke DeleteDcdnDomain API
func CreateDeleteDcdnDomainRequest() (request *DeleteDcdnDomainRequest) {
	request = &DeleteDcdnDomainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DeleteDcdnDomain", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteDcdnDomainResponse creates a response to parse from DeleteDcdnDomain response
func CreateDeleteDcdnDomainResponse() (response *DeleteDcdnDomainResponse) {
	response = &DeleteDcdnDomainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
