package dts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartSubscriptionInstance invokes the dts.StartSubscriptionInstance API synchronously
func (client *Client) StartSubscriptionInstance(request *StartSubscriptionInstanceRequest) (response *StartSubscriptionInstanceResponse, err error) {
	response = CreateStartSubscriptionInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// StartSubscriptionInstanceWithChan invokes the dts.StartSubscriptionInstance API asynchronously
func (client *Client) StartSubscriptionInstanceWithChan(request *StartSubscriptionInstanceRequest) (<-chan *StartSubscriptionInstanceResponse, <-chan error) {
	responseChan := make(chan *StartSubscriptionInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartSubscriptionInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartSubscriptionInstanceWithCallback invokes the dts.StartSubscriptionInstance API asynchronously
func (client *Client) StartSubscriptionInstanceWithCallback(request *StartSubscriptionInstanceRequest, callback func(response *StartSubscriptionInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartSubscriptionInstanceResponse
		var err error
		defer close(result)
		response, err = client.StartSubscriptionInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartSubscriptionInstanceRequest is the request struct for api StartSubscriptionInstance
type StartSubscriptionInstanceRequest struct {
	*requests.RpcRequest
	SubscriptionInstanceId string `position:"Query" name:"SubscriptionInstanceId"`
	OwnerId                string `position:"Query" name:"OwnerId"`
	AccountId              string `position:"Query" name:"AccountId"`
}

// StartSubscriptionInstanceResponse is the response struct for api StartSubscriptionInstance
type StartSubscriptionInstanceResponse struct {
	*responses.BaseResponse
	ErrCode    string `json:"ErrCode" xml:"ErrCode"`
	ErrMessage string `json:"ErrMessage" xml:"ErrMessage"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Success    string `json:"Success" xml:"Success"`
	TaskId     string `json:"TaskId" xml:"TaskId"`
}

// CreateStartSubscriptionInstanceRequest creates a request to invoke StartSubscriptionInstance API
func CreateStartSubscriptionInstanceRequest() (request *StartSubscriptionInstanceRequest) {
	request = &StartSubscriptionInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2020-01-01", "StartSubscriptionInstance", "dts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStartSubscriptionInstanceResponse creates a response to parse from StartSubscriptionInstance response
func CreateStartSubscriptionInstanceResponse() (response *StartSubscriptionInstanceResponse) {
	response = &StartSubscriptionInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
