package eas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetServiceToken invokes the eas.GetServiceToken API synchronously
// api document: https://help.aliyun.com/api/eas/getservicetoken.html
func (client *Client) GetServiceToken(request *GetServiceTokenRequest) (response *GetServiceTokenResponse, err error) {
	response = CreateGetServiceTokenResponse()
	err = client.DoAction(request, response)
	return
}

// GetServiceTokenWithChan invokes the eas.GetServiceToken API asynchronously
// api document: https://help.aliyun.com/api/eas/getservicetoken.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetServiceTokenWithChan(request *GetServiceTokenRequest) (<-chan *GetServiceTokenResponse, <-chan error) {
	responseChan := make(chan *GetServiceTokenResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetServiceToken(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetServiceTokenWithCallback invokes the eas.GetServiceToken API asynchronously
// api document: https://help.aliyun.com/api/eas/getservicetoken.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetServiceTokenWithCallback(request *GetServiceTokenRequest, callback func(response *GetServiceTokenResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetServiceTokenResponse
		var err error
		defer close(result)
		response, err = client.GetServiceToken(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetServiceTokenRequest is the request struct for api GetServiceToken
type GetServiceTokenRequest struct {
	*requests.RoaRequest
	ServiceName string `position:"Path" name:"service_name"`
	Region      string `position:"Path" name:"region"`
}

// GetServiceTokenResponse is the response struct for api GetServiceToken
type GetServiceTokenResponse struct {
	*responses.BaseResponse
}

// CreateGetServiceTokenRequest creates a request to invoke GetServiceToken API
func CreateGetServiceTokenRequest() (request *GetServiceTokenRequest) {
	request = &GetServiceTokenRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("eas", "2018-05-22", "GetServiceToken", "/api/services/[region]/[service_name]/token", "", "")
	request.Method = requests.GET
	return
}

// CreateGetServiceTokenResponse creates a response to parse from GetServiceToken response
func CreateGetServiceTokenResponse() (response *GetServiceTokenResponse) {
	response = &GetServiceTokenResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
