package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ContinuePipeline invokes the edas.ContinuePipeline API synchronously
func (client *Client) ContinuePipeline(request *ContinuePipelineRequest) (response *ContinuePipelineResponse, err error) {
	response = CreateContinuePipelineResponse()
	err = client.DoAction(request, response)
	return
}

// ContinuePipelineWithChan invokes the edas.ContinuePipeline API asynchronously
func (client *Client) ContinuePipelineWithChan(request *ContinuePipelineRequest) (<-chan *ContinuePipelineResponse, <-chan error) {
	responseChan := make(chan *ContinuePipelineResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ContinuePipeline(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ContinuePipelineWithCallback invokes the edas.ContinuePipeline API asynchronously
func (client *Client) ContinuePipelineWithCallback(request *ContinuePipelineRequest, callback func(response *ContinuePipelineResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ContinuePipelineResponse
		var err error
		defer close(result)
		response, err = client.ContinuePipeline(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ContinuePipelineRequest is the request struct for api ContinuePipeline
type ContinuePipelineRequest struct {
	*requests.RoaRequest
	Confirm    requests.Boolean `position:"Query" name:"Confirm"`
	PipelineId string           `position:"Query" name:"PipelineId"`
}

// ContinuePipelineResponse is the response struct for api ContinuePipeline
type ContinuePipelineResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateContinuePipelineRequest creates a request to invoke ContinuePipeline API
func CreateContinuePipelineRequest() (request *ContinuePipelineRequest) {
	request = &ContinuePipelineRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "ContinuePipeline", "/pop/v5/changeorder/pipeline_batch_confirm", "edas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateContinuePipelineResponse creates a response to parse from ContinuePipeline response
func CreateContinuePipelineResponse() (response *ContinuePipelineResponse) {
	response = &ContinuePipelineResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
