package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteUserDefineRegion invokes the edas.DeleteUserDefineRegion API synchronously
func (client *Client) DeleteUserDefineRegion(request *DeleteUserDefineRegionRequest) (response *DeleteUserDefineRegionResponse, err error) {
	response = CreateDeleteUserDefineRegionResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteUserDefineRegionWithChan invokes the edas.DeleteUserDefineRegion API asynchronously
func (client *Client) DeleteUserDefineRegionWithChan(request *DeleteUserDefineRegionRequest) (<-chan *DeleteUserDefineRegionResponse, <-chan error) {
	responseChan := make(chan *DeleteUserDefineRegionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteUserDefineRegion(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteUserDefineRegionWithCallback invokes the edas.DeleteUserDefineRegion API asynchronously
func (client *Client) DeleteUserDefineRegionWithCallback(request *DeleteUserDefineRegionRequest, callback func(response *DeleteUserDefineRegionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteUserDefineRegionResponse
		var err error
		defer close(result)
		response, err = client.DeleteUserDefineRegion(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteUserDefineRegionRequest is the request struct for api DeleteUserDefineRegion
type DeleteUserDefineRegionRequest struct {
	*requests.RoaRequest
	RegionTag string           `position:"Query" name:"RegionTag"`
	Id        requests.Integer `position:"Query" name:"Id"`
}

// DeleteUserDefineRegionResponse is the response struct for api DeleteUserDefineRegion
type DeleteUserDefineRegionResponse struct {
	*responses.BaseResponse
	Code         int          `json:"Code" xml:"Code"`
	Message      string       `json:"Message" xml:"Message"`
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	RegionDefine RegionDefine `json:"RegionDefine" xml:"RegionDefine"`
}

// CreateDeleteUserDefineRegionRequest creates a request to invoke DeleteUserDefineRegion API
func CreateDeleteUserDefineRegionRequest() (request *DeleteUserDefineRegionRequest) {
	request = &DeleteUserDefineRegionRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "DeleteUserDefineRegion", "/pop/v5/user_region_def", "edas", "openAPI")
	request.Method = requests.DELETE
	return
}

// CreateDeleteUserDefineRegionResponse creates a response to parse from DeleteUserDefineRegion response
func CreateDeleteUserDefineRegionResponse() (response *DeleteUserDefineRegionResponse) {
	response = &DeleteUserDefineRegionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
