package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ValidateK8sResource invokes the edas.ValidateK8sResource API synchronously
func (client *Client) ValidateK8sResource(request *ValidateK8sResourceRequest) (response *ValidateK8sResourceResponse, err error) {
	response = CreateValidateK8sResourceResponse()
	err = client.DoAction(request, response)
	return
}

// ValidateK8sResourceWithChan invokes the edas.ValidateK8sResource API asynchronously
func (client *Client) ValidateK8sResourceWithChan(request *ValidateK8sResourceRequest) (<-chan *ValidateK8sResourceResponse, <-chan error) {
	responseChan := make(chan *ValidateK8sResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ValidateK8sResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ValidateK8sResourceWithCallback invokes the edas.ValidateK8sResource API asynchronously
func (client *Client) ValidateK8sResourceWithCallback(request *ValidateK8sResourceRequest, callback func(response *ValidateK8sResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ValidateK8sResourceResponse
		var err error
		defer close(result)
		response, err = client.ValidateK8sResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ValidateK8sResourceRequest is the request struct for api ValidateK8sResource
type ValidateK8sResourceRequest struct {
	*requests.RoaRequest
	Kind      string `position:"Body" name:"Kind"`
	AppId     string `position:"Body" name:"AppId"`
	Namespace string `position:"Body" name:"Namespace"`
	Format    string `position:"Body" name:"Format"`
	Content   string `position:"Body" name:"Content"`
}

// ValidateK8sResourceResponse is the response struct for api ValidateK8sResource
type ValidateK8sResourceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateValidateK8sResourceRequest creates a request to invoke ValidateK8sResource API
func CreateValidateK8sResourceRequest() (request *ValidateK8sResourceRequest) {
	request = &ValidateK8sResourceRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "ValidateK8sResource", "/pop/v5/k8s/acs/validate_k8s_resource", "edas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateValidateK8sResourceResponse creates a response to parse from ValidateK8sResource response
func CreateValidateK8sResourceResponse() (response *ValidateK8sResourceResponse) {
	response = &ValidateK8sResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
