package facebody

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetectCelebrity invokes the facebody.DetectCelebrity API synchronously
func (client *Client) DetectCelebrity(request *DetectCelebrityRequest) (response *DetectCelebrityResponse, err error) {
	response = CreateDetectCelebrityResponse()
	err = client.DoAction(request, response)
	return
}

// DetectCelebrityWithChan invokes the facebody.DetectCelebrity API asynchronously
func (client *Client) DetectCelebrityWithChan(request *DetectCelebrityRequest) (<-chan *DetectCelebrityResponse, <-chan error) {
	responseChan := make(chan *DetectCelebrityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetectCelebrity(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetectCelebrityWithCallback invokes the facebody.DetectCelebrity API asynchronously
func (client *Client) DetectCelebrityWithCallback(request *DetectCelebrityRequest, callback func(response *DetectCelebrityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetectCelebrityResponse
		var err error
		defer close(result)
		response, err = client.DetectCelebrity(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetectCelebrityRequest is the request struct for api DetectCelebrity
type DetectCelebrityRequest struct {
	*requests.RpcRequest
	ImageURL string `position:"Body" name:"ImageURL"`
}

// DetectCelebrityResponse is the response struct for api DetectCelebrity
type DetectCelebrityResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDetectCelebrityRequest creates a request to invoke DetectCelebrity API
func CreateDetectCelebrityRequest() (request *DetectCelebrityRequest) {
	request = &DetectCelebrityRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("facebody", "2019-12-30", "DetectCelebrity", "", "")
	request.Method = requests.POST
	return
}

// CreateDetectCelebrityResponse creates a response to parse from DetectCelebrity response
func CreateDetectCelebrityResponse() (response *DetectCelebrityResponse) {
	response = &DetectCelebrityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
