package ocr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RecognizeBusinessCard invokes the ocr.RecognizeBusinessCard API synchronously
func (client *Client) RecognizeBusinessCard(request *RecognizeBusinessCardRequest) (response *RecognizeBusinessCardResponse, err error) {
	response = CreateRecognizeBusinessCardResponse()
	err = client.DoAction(request, response)
	return
}

// RecognizeBusinessCardWithChan invokes the ocr.RecognizeBusinessCard API asynchronously
func (client *Client) RecognizeBusinessCardWithChan(request *RecognizeBusinessCardRequest) (<-chan *RecognizeBusinessCardResponse, <-chan error) {
	responseChan := make(chan *RecognizeBusinessCardResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RecognizeBusinessCard(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RecognizeBusinessCardWithCallback invokes the ocr.RecognizeBusinessCard API asynchronously
func (client *Client) RecognizeBusinessCardWithCallback(request *RecognizeBusinessCardRequest, callback func(response *RecognizeBusinessCardResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RecognizeBusinessCardResponse
		var err error
		defer close(result)
		response, err = client.RecognizeBusinessCard(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RecognizeBusinessCardRequest is the request struct for api RecognizeBusinessCard
type RecognizeBusinessCardRequest struct {
	*requests.RpcRequest
	ImageType requests.Integer `position:"Body" name:"ImageType"`
	ImageURL  string           `position:"Body" name:"ImageURL"`
}

// RecognizeBusinessCardResponse is the response struct for api RecognizeBusinessCard
type RecognizeBusinessCardResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateRecognizeBusinessCardRequest creates a request to invoke RecognizeBusinessCard API
func CreateRecognizeBusinessCardRequest() (request *RecognizeBusinessCardRequest) {
	request = &RecognizeBusinessCardRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ocr", "2019-12-30", "RecognizeBusinessCard", "ocr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRecognizeBusinessCardResponse creates a response to parse from RecognizeBusinessCard response
func CreateRecognizeBusinessCardResponse() (response *RecognizeBusinessCardResponse) {
	response = &RecognizeBusinessCardResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
