package rtc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateConference invokes the rtc.CreateConference API synchronously
func (client *Client) CreateConference(request *CreateConferenceRequest) (response *CreateConferenceResponse, err error) {
	response = CreateCreateConferenceResponse()
	err = client.DoAction(request, response)
	return
}

// CreateConferenceWithChan invokes the rtc.CreateConference API asynchronously
func (client *Client) CreateConferenceWithChan(request *CreateConferenceRequest) (<-chan *CreateConferenceResponse, <-chan error) {
	responseChan := make(chan *CreateConferenceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateConference(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateConferenceWithCallback invokes the rtc.CreateConference API asynchronously
func (client *Client) CreateConferenceWithCallback(request *CreateConferenceRequest, callback func(response *CreateConferenceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateConferenceResponse
		var err error
		defer close(result)
		response, err = client.CreateConference(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateConferenceRequest is the request struct for api CreateConference
type CreateConferenceRequest struct {
	*requests.RpcRequest
	ClientToken    string           `position:"Query" name:"ClientToken"`
	StartTime      string           `position:"Query" name:"StartTime"`
	Type           string           `position:"Query" name:"Type"`
	ConferenceName string           `position:"Query" name:"ConferenceName"`
	ShowLog        string           `position:"Query" name:"ShowLog"`
	OwnerId        requests.Integer `position:"Query" name:"OwnerId"`
	AppId          string           `position:"Query" name:"AppId"`
	RemindNotice   requests.Integer `position:"Query" name:"RemindNotice"`
}

// CreateConferenceResponse is the response struct for api CreateConference
type CreateConferenceResponse struct {
	*responses.BaseResponse
	RequestId    string   `json:"RequestId" xml:"RequestId"`
	ConferenceId string   `json:"ConferenceId" xml:"ConferenceId"`
	AuthInfo     AuthInfo `json:"AuthInfo" xml:"AuthInfo"`
}

// CreateCreateConferenceRequest creates a request to invoke CreateConference API
func CreateCreateConferenceRequest() (request *CreateConferenceRequest) {
	request = &CreateConferenceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "CreateConference", "rtc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateConferenceResponse creates a response to parse from CreateConference response
func CreateCreateConferenceResponse() (response *CreateConferenceResponse) {
	response = &CreateConferenceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
