package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeBlockVolumeSnapshots invokes the sgw.DescribeBlockVolumeSnapshots API synchronously
func (client *Client) DescribeBlockVolumeSnapshots(request *DescribeBlockVolumeSnapshotsRequest) (response *DescribeBlockVolumeSnapshotsResponse, err error) {
	response = CreateDescribeBlockVolumeSnapshotsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeBlockVolumeSnapshotsWithChan invokes the sgw.DescribeBlockVolumeSnapshots API asynchronously
func (client *Client) DescribeBlockVolumeSnapshotsWithChan(request *DescribeBlockVolumeSnapshotsRequest) (<-chan *DescribeBlockVolumeSnapshotsResponse, <-chan error) {
	responseChan := make(chan *DescribeBlockVolumeSnapshotsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeBlockVolumeSnapshots(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeBlockVolumeSnapshotsWithCallback invokes the sgw.DescribeBlockVolumeSnapshots API asynchronously
func (client *Client) DescribeBlockVolumeSnapshotsWithCallback(request *DescribeBlockVolumeSnapshotsRequest, callback func(response *DescribeBlockVolumeSnapshotsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeBlockVolumeSnapshotsResponse
		var err error
		defer close(result)
		response, err = client.DescribeBlockVolumeSnapshots(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeBlockVolumeSnapshotsRequest is the request struct for api DescribeBlockVolumeSnapshots
type DescribeBlockVolumeSnapshotsRequest struct {
	*requests.RpcRequest
	PageNumber    requests.Integer `position:"Query" name:"PageNumber"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	IndexId       string           `position:"Query" name:"IndexId"`
	GatewayId     string           `position:"Query" name:"GatewayId"`
}

// DescribeBlockVolumeSnapshotsResponse is the response struct for api DescribeBlockVolumeSnapshots
type DescribeBlockVolumeSnapshotsResponse struct {
	*responses.BaseResponse
	RequestId  string    `json:"RequestId" xml:"RequestId"`
	Success    bool      `json:"Success" xml:"Success"`
	Code       string    `json:"Code" xml:"Code"`
	Message    string    `json:"Message" xml:"Message"`
	TotalCount int       `json:"TotalCount" xml:"TotalCount"`
	PageNumber int       `json:"PageNumber" xml:"PageNumber"`
	PageSize   int       `json:"PageSize" xml:"PageSize"`
	Snapshots  Snapshots `json:"Snapshots" xml:"Snapshots"`
}

// CreateDescribeBlockVolumeSnapshotsRequest creates a request to invoke DescribeBlockVolumeSnapshots API
func CreateDescribeBlockVolumeSnapshotsRequest() (request *DescribeBlockVolumeSnapshotsRequest) {
	request = &DescribeBlockVolumeSnapshotsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "DescribeBlockVolumeSnapshots", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeBlockVolumeSnapshotsResponse creates a response to parse from DescribeBlockVolumeSnapshots response
func CreateDescribeBlockVolumeSnapshotsResponse() (response *DescribeBlockVolumeSnapshotsResponse) {
	response = &DescribeBlockVolumeSnapshotsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
