package sls

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableAlert invokes the sls.EnableAlert API synchronously
func (client *Client) EnableAlert(request *EnableAlertRequest) (response *EnableAlertResponse, err error) {
	response = CreateEnableAlertResponse()
	err = client.DoAction(request, response)
	return
}

// EnableAlertWithChan invokes the sls.EnableAlert API asynchronously
func (client *Client) EnableAlertWithChan(request *EnableAlertRequest) (<-chan *EnableAlertResponse, <-chan error) {
	responseChan := make(chan *EnableAlertResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableAlert(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableAlertWithCallback invokes the sls.EnableAlert API asynchronously
func (client *Client) EnableAlertWithCallback(request *EnableAlertRequest, callback func(response *EnableAlertResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableAlertResponse
		var err error
		defer close(result)
		response, err = client.EnableAlert(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableAlertRequest is the request struct for api EnableAlert
type EnableAlertRequest struct {
	*requests.RpcRequest
	Language    string `position:"Body" name:"Language"`
	RuleVersion string `position:"Body" name:"RuleVersion"`
	Endpoint    string `position:"Body" name:"Endpoint"`
	Tokens      string `position:"Body" name:"Tokens"`
	App         string `position:"Body" name:"App"`
	ProjectName string `position:"Body" name:"ProjectName"`
	AlertId     string `position:"Body" name:"AlertId"`
	RuleId      string `position:"Body" name:"RuleId"`
	Region      string `position:"Body" name:"Region"`
}

// EnableAlertResponse is the response struct for api EnableAlert
type EnableAlertResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateEnableAlertRequest creates a request to invoke EnableAlert API
func CreateEnableAlertRequest() (request *EnableAlertRequest) {
	request = &EnableAlertRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sls", "2019-10-23", "EnableAlert", "", "")
	request.Method = requests.POST
	return
}

// CreateEnableAlertResponse creates a response to parse from EnableAlert response
func CreateEnableAlertResponse() (response *EnableAlertResponse) {
	response = &EnableAlertResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
