package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddWatermark invokes the vod.AddWatermark API synchronously
func (client *Client) AddWatermark(request *AddWatermarkRequest) (response *AddWatermarkResponse, err error) {
	response = CreateAddWatermarkResponse()
	err = client.DoAction(request, response)
	return
}

// AddWatermarkWithChan invokes the vod.AddWatermark API asynchronously
func (client *Client) AddWatermarkWithChan(request *AddWatermarkRequest) (<-chan *AddWatermarkResponse, <-chan error) {
	responseChan := make(chan *AddWatermarkResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddWatermark(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddWatermarkWithCallback invokes the vod.AddWatermark API asynchronously
func (client *Client) AddWatermarkWithCallback(request *AddWatermarkRequest, callback func(response *AddWatermarkResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddWatermarkResponse
		var err error
		defer close(result)
		response, err = client.AddWatermark(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddWatermarkRequest is the request struct for api AddWatermark
type AddWatermarkRequest struct {
	*requests.RpcRequest
	Type            string `position:"Query" name:"Type"`
	WatermarkConfig string `position:"Query" name:"WatermarkConfig"`
	AppId           string `position:"Query" name:"AppId"`
	Name            string `position:"Query" name:"Name"`
	FileUrl         string `position:"Query" name:"FileUrl"`
}

// AddWatermarkResponse is the response struct for api AddWatermark
type AddWatermarkResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	WatermarkInfo WatermarkInfo `json:"WatermarkInfo" xml:"WatermarkInfo"`
}

// CreateAddWatermarkRequest creates a request to invoke AddWatermark API
func CreateAddWatermarkRequest() (request *AddWatermarkRequest) {
	request = &AddWatermarkRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "AddWatermark", "", "")
	request.Method = requests.POST
	return
}

// CreateAddWatermarkResponse creates a response to parse from AddWatermark response
func CreateAddWatermarkResponse() (response *AddWatermarkResponse) {
	response = &AddWatermarkResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
