package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAuditSecurityIp invokes the vod.ListAuditSecurityIp API synchronously
func (client *Client) ListAuditSecurityIp(request *ListAuditSecurityIpRequest) (response *ListAuditSecurityIpResponse, err error) {
	response = CreateListAuditSecurityIpResponse()
	err = client.DoAction(request, response)
	return
}

// ListAuditSecurityIpWithChan invokes the vod.ListAuditSecurityIp API asynchronously
func (client *Client) ListAuditSecurityIpWithChan(request *ListAuditSecurityIpRequest) (<-chan *ListAuditSecurityIpResponse, <-chan error) {
	responseChan := make(chan *ListAuditSecurityIpResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAuditSecurityIp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAuditSecurityIpWithCallback invokes the vod.ListAuditSecurityIp API asynchronously
func (client *Client) ListAuditSecurityIpWithCallback(request *ListAuditSecurityIpRequest, callback func(response *ListAuditSecurityIpResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAuditSecurityIpResponse
		var err error
		defer close(result)
		response, err = client.ListAuditSecurityIp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAuditSecurityIpRequest is the request struct for api ListAuditSecurityIp
type ListAuditSecurityIpRequest struct {
	*requests.RpcRequest
	SecurityGroupName string `position:"Query" name:"SecurityGroupName"`
}

// ListAuditSecurityIpResponse is the response struct for api ListAuditSecurityIp
type ListAuditSecurityIpResponse struct {
	*responses.BaseResponse
	RequestId      string       `json:"RequestId" xml:"RequestId"`
	SecurityIpList []SecurityIp `json:"SecurityIpList" xml:"SecurityIpList"`
}

// CreateListAuditSecurityIpRequest creates a request to invoke ListAuditSecurityIp API
func CreateListAuditSecurityIpRequest() (request *ListAuditSecurityIpRequest) {
	request = &ListAuditSecurityIpRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "ListAuditSecurityIp", "", "")
	request.Method = requests.POST
	return
}

// CreateListAuditSecurityIpResponse creates a response to parse from ListAuditSecurityIp response
func CreateListAuditSecurityIpResponse() (response *ListAuditSecurityIpResponse) {
	response = &ListAuditSecurityIpResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
