package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateDetectionJob invokes the vod.UpdateDetectionJob API synchronously
func (client *Client) UpdateDetectionJob(request *UpdateDetectionJobRequest) (response *UpdateDetectionJobResponse, err error) {
	response = CreateUpdateDetectionJobResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateDetectionJobWithChan invokes the vod.UpdateDetectionJob API asynchronously
func (client *Client) UpdateDetectionJobWithChan(request *UpdateDetectionJobRequest) (<-chan *UpdateDetectionJobResponse, <-chan error) {
	responseChan := make(chan *UpdateDetectionJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateDetectionJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateDetectionJobWithCallback invokes the vod.UpdateDetectionJob API asynchronously
func (client *Client) UpdateDetectionJobWithCallback(request *UpdateDetectionJobRequest, callback func(response *UpdateDetectionJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateDetectionJobResponse
		var err error
		defer close(result)
		response, err = client.UpdateDetectionJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateDetectionJobRequest is the request struct for api UpdateDetectionJob
type UpdateDetectionJobRequest struct {
	*requests.RpcRequest
	WhiteListUrls      string           `position:"Query" name:"WhiteListUrls"`
	CopyrightEndTime   string           `position:"Query" name:"CopyrightEndTime"`
	CopyrightStatus    string           `position:"Query" name:"CopyrightStatus"`
	CopyrightBeginTime string           `position:"Query" name:"CopyrightBeginTime"`
	Duration           requests.Integer `position:"Query" name:"Duration"`
	JobId              string           `position:"Query" name:"JobId"`
	EndTime            string           `position:"Query" name:"EndTime"`
	BeginTime          string           `position:"Query" name:"BeginTime"`
	TemplateId         string           `position:"Query" name:"TemplateId"`
	CopyrightFile      string           `position:"Query" name:"CopyrightFile"`
}

// UpdateDetectionJobResponse is the response struct for api UpdateDetectionJob
type UpdateDetectionJobResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	DetectionJob DetectionJob `json:"DetectionJob" xml:"DetectionJob"`
}

// CreateUpdateDetectionJobRequest creates a request to invoke UpdateDetectionJob API
func CreateUpdateDetectionJobRequest() (request *UpdateDetectionJobRequest) {
	request = &UpdateDetectionJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "UpdateDetectionJob", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateDetectionJobResponse creates a response to parse from UpdateDetectionJob response
func CreateUpdateDetectionJobResponse() (response *UpdateDetectionJobResponse) {
	response = &UpdateDetectionJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
