package voicenavigator

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CollectedNumber invokes the voicenavigator.CollectedNumber API synchronously
func (client *Client) CollectedNumber(request *CollectedNumberRequest) (response *CollectedNumberResponse, err error) {
	response = CreateCollectedNumberResponse()
	err = client.DoAction(request, response)
	return
}

// CollectedNumberWithChan invokes the voicenavigator.CollectedNumber API asynchronously
func (client *Client) CollectedNumberWithChan(request *CollectedNumberRequest) (<-chan *CollectedNumberResponse, <-chan error) {
	responseChan := make(chan *CollectedNumberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CollectedNumber(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CollectedNumberWithCallback invokes the voicenavigator.CollectedNumber API asynchronously
func (client *Client) CollectedNumberWithCallback(request *CollectedNumberRequest, callback func(response *CollectedNumberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CollectedNumberResponse
		var err error
		defer close(result)
		response, err = client.CollectedNumber(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CollectedNumberRequest is the request struct for api CollectedNumber
type CollectedNumberRequest struct {
	*requests.RpcRequest
	ConversationId string `position:"Query" name:"ConversationId"`
	Number         string `position:"Query" name:"Number"`
	InstanceId     string `position:"Query" name:"InstanceId"`
}

// CollectedNumberResponse is the response struct for api CollectedNumber
type CollectedNumberResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	TextResponse  string `json:"TextResponse" xml:"TextResponse"`
	Interruptible bool   `json:"Interruptible" xml:"Interruptible"`
	Action        string `json:"Action" xml:"Action"`
	ActionParams  string `json:"ActionParams" xml:"ActionParams"`
}

// CreateCollectedNumberRequest creates a request to invoke CollectedNumber API
func CreateCollectedNumberRequest() (request *CollectedNumberRequest) {
	request = &CollectedNumberRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("VoiceNavigator", "2018-06-12", "CollectedNumber", "voicebot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCollectedNumberResponse creates a response to parse from CollectedNumber response
func CreateCollectedNumberResponse() (response *CollectedNumberResponse) {
	response = &CollectedNumberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
