package waf_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateCertAndKey invokes the waf_openapi.CreateCertAndKey API synchronously
func (client *Client) CreateCertAndKey(request *CreateCertAndKeyRequest) (response *CreateCertAndKeyResponse, err error) {
	response = CreateCreateCertAndKeyResponse()
	err = client.DoAction(request, response)
	return
}

// CreateCertAndKeyWithChan invokes the waf_openapi.CreateCertAndKey API asynchronously
func (client *Client) CreateCertAndKeyWithChan(request *CreateCertAndKeyRequest) (<-chan *CreateCertAndKeyResponse, <-chan error) {
	responseChan := make(chan *CreateCertAndKeyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateCertAndKey(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateCertAndKeyWithCallback invokes the waf_openapi.CreateCertAndKey API asynchronously
func (client *Client) CreateCertAndKeyWithCallback(request *CreateCertAndKeyRequest, callback func(response *CreateCertAndKeyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateCertAndKeyResponse
		var err error
		defer close(result)
		response, err = client.CreateCertAndKey(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateCertAndKeyRequest is the request struct for api CreateCertAndKey
type CreateCertAndKeyRequest struct {
	*requests.RpcRequest
	Cert          string `position:"Query" name:"Cert"`
	SourceIp      string `position:"Query" name:"SourceIp"`
	HttpsCertName string `position:"Query" name:"HttpsCertName"`
	Lang          string `position:"Query" name:"Lang"`
	Key           string `position:"Query" name:"Key"`
	InstanceId    string `position:"Query" name:"InstanceId"`
	Domain        string `position:"Query" name:"Domain"`
	Region        string `position:"Query" name:"Region"`
}

// CreateCertAndKeyResponse is the response struct for api CreateCertAndKey
type CreateCertAndKeyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateCreateCertAndKeyRequest creates a request to invoke CreateCertAndKey API
func CreateCreateCertAndKeyRequest() (request *CreateCertAndKeyRequest) {
	request = &CreateCertAndKeyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("waf-openapi", "2018-01-17", "CreateCertAndKey", "waf", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateCertAndKeyResponse creates a response to parse from CreateCertAndKey response
func CreateCreateCertAndKeyResponse() (response *CreateCertAndKeyResponse) {
	response = &CreateCertAndKeyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
