package waf_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAclRules invokes the waf_openapi.DescribeAclRules API synchronously
func (client *Client) DescribeAclRules(request *DescribeAclRulesRequest) (response *DescribeAclRulesResponse, err error) {
	response = CreateDescribeAclRulesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAclRulesWithChan invokes the waf_openapi.DescribeAclRules API asynchronously
func (client *Client) DescribeAclRulesWithChan(request *DescribeAclRulesRequest) (<-chan *DescribeAclRulesResponse, <-chan error) {
	responseChan := make(chan *DescribeAclRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAclRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAclRulesWithCallback invokes the waf_openapi.DescribeAclRules API asynchronously
func (client *Client) DescribeAclRulesWithCallback(request *DescribeAclRulesRequest, callback func(response *DescribeAclRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAclRulesResponse
		var err error
		defer close(result)
		response, err = client.DescribeAclRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAclRulesRequest is the request struct for api DescribeAclRules
type DescribeAclRulesRequest struct {
	*requests.RpcRequest
	SourceIp    string           `position:"Query" name:"SourceIp"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	Lang        string           `position:"Query" name:"Lang"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	InstanceId  string           `position:"Query" name:"InstanceId"`
	Domain      string           `position:"Query" name:"Domain"`
	Region      string           `position:"Query" name:"Region"`
}

// DescribeAclRulesResponse is the response struct for api DescribeAclRules
type DescribeAclRulesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateDescribeAclRulesRequest creates a request to invoke DescribeAclRules API
func CreateDescribeAclRulesRequest() (request *DescribeAclRulesRequest) {
	request = &DescribeAclRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("waf-openapi", "2018-01-17", "DescribeAclRules", "waf", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeAclRulesResponse creates a response to parse from DescribeAclRules response
func CreateDescribeAclRulesResponse() (response *DescribeAclRulesResponse) {
	response = &DescribeAclRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
