// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package fms

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAssociateAdminAccount = "AssociateAdminAccount"

// AssociateAdminAccountRequest generates a "aws/request.Request" representing the
// client's request for the AssociateAdminAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateAdminAccount for more information on using the AssociateAdminAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateAdminAccountRequest method.
//    req, resp := client.AssociateAdminAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/AssociateAdminAccount
func (c *FMS) AssociateAdminAccountRequest(input *AssociateAdminAccountInput) (req *request.Request, output *AssociateAdminAccountOutput) {
	op := &request.Operation{
		Name:       opAssociateAdminAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateAdminAccountInput{}
	}

	output = &AssociateAdminAccountOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateAdminAccount API operation for Firewall Management Service.
//
// Sets the AWS Firewall Manager administrator account. AWS Firewall Manager
// must be associated with the master account of your AWS organization or associated
// with a member account that has the appropriate permissions. If the account
// ID that you submit is not an AWS Organizations master account, AWS Firewall
// Manager will set the appropriate permissions for the given member account.
//
// The account that you associate with AWS Firewall Manager is called the AWS
// Firewall Manager administrator account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation AssociateAdminAccount for usage and error information.
//
// Returned Error Types:
//   * InvalidOperationException
//   The operation failed because there was nothing to do. For example, you might
//   have submitted an AssociateAdminAccount request, but the account ID that
//   you submitted was already set as the AWS Firewall Manager administrator.
//
//   * InvalidInputException
//   The parameters of the request were invalid.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/AssociateAdminAccount
func (c *FMS) AssociateAdminAccount(input *AssociateAdminAccountInput) (*AssociateAdminAccountOutput, error) {
	req, out := c.AssociateAdminAccountRequest(input)
	return out, req.Send()
}

// AssociateAdminAccountWithContext is the same as AssociateAdminAccount with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateAdminAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) AssociateAdminAccountWithContext(ctx aws.Context, input *AssociateAdminAccountInput, opts ...request.Option) (*AssociateAdminAccountOutput, error) {
	req, out := c.AssociateAdminAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNotificationChannel = "DeleteNotificationChannel"

// DeleteNotificationChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNotificationChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNotificationChannel for more information on using the DeleteNotificationChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteNotificationChannelRequest method.
//    req, resp := client.DeleteNotificationChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/DeleteNotificationChannel
func (c *FMS) DeleteNotificationChannelRequest(input *DeleteNotificationChannelInput) (req *request.Request, output *DeleteNotificationChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteNotificationChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNotificationChannelInput{}
	}

	output = &DeleteNotificationChannelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteNotificationChannel API operation for Firewall Management Service.
//
// Deletes an AWS Firewall Manager association with the IAM role and the Amazon
// Simple Notification Service (SNS) topic that is used to record AWS Firewall
// Manager SNS logs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation DeleteNotificationChannel for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * InvalidOperationException
//   The operation failed because there was nothing to do. For example, you might
//   have submitted an AssociateAdminAccount request, but the account ID that
//   you submitted was already set as the AWS Firewall Manager administrator.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/DeleteNotificationChannel
func (c *FMS) DeleteNotificationChannel(input *DeleteNotificationChannelInput) (*DeleteNotificationChannelOutput, error) {
	req, out := c.DeleteNotificationChannelRequest(input)
	return out, req.Send()
}

// DeleteNotificationChannelWithContext is the same as DeleteNotificationChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNotificationChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) DeleteNotificationChannelWithContext(ctx aws.Context, input *DeleteNotificationChannelInput, opts ...request.Option) (*DeleteNotificationChannelOutput, error) {
	req, out := c.DeleteNotificationChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePolicy = "DeletePolicy"

// DeletePolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeletePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePolicy for more information on using the DeletePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePolicyRequest method.
//    req, resp := client.DeletePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/DeletePolicy
func (c *FMS) DeletePolicyRequest(input *DeletePolicyInput) (req *request.Request, output *DeletePolicyOutput) {
	op := &request.Operation{
		Name:       opDeletePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePolicyInput{}
	}

	output = &DeletePolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePolicy API operation for Firewall Management Service.
//
// Permanently deletes an AWS Firewall Manager policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation DeletePolicy for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * InvalidOperationException
//   The operation failed because there was nothing to do. For example, you might
//   have submitted an AssociateAdminAccount request, but the account ID that
//   you submitted was already set as the AWS Firewall Manager administrator.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/DeletePolicy
func (c *FMS) DeletePolicy(input *DeletePolicyInput) (*DeletePolicyOutput, error) {
	req, out := c.DeletePolicyRequest(input)
	return out, req.Send()
}

// DeletePolicyWithContext is the same as DeletePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) DeletePolicyWithContext(ctx aws.Context, input *DeletePolicyInput, opts ...request.Option) (*DeletePolicyOutput, error) {
	req, out := c.DeletePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateAdminAccount = "DisassociateAdminAccount"

// DisassociateAdminAccountRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateAdminAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateAdminAccount for more information on using the DisassociateAdminAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateAdminAccountRequest method.
//    req, resp := client.DisassociateAdminAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/DisassociateAdminAccount
func (c *FMS) DisassociateAdminAccountRequest(input *DisassociateAdminAccountInput) (req *request.Request, output *DisassociateAdminAccountOutput) {
	op := &request.Operation{
		Name:       opDisassociateAdminAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateAdminAccountInput{}
	}

	output = &DisassociateAdminAccountOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateAdminAccount API operation for Firewall Management Service.
//
// Disassociates the account that has been set as the AWS Firewall Manager administrator
// account. To set a different account as the administrator account, you must
// submit an AssociateAdminAccount request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation DisassociateAdminAccount for usage and error information.
//
// Returned Error Types:
//   * InvalidOperationException
//   The operation failed because there was nothing to do. For example, you might
//   have submitted an AssociateAdminAccount request, but the account ID that
//   you submitted was already set as the AWS Firewall Manager administrator.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/DisassociateAdminAccount
func (c *FMS) DisassociateAdminAccount(input *DisassociateAdminAccountInput) (*DisassociateAdminAccountOutput, error) {
	req, out := c.DisassociateAdminAccountRequest(input)
	return out, req.Send()
}

// DisassociateAdminAccountWithContext is the same as DisassociateAdminAccount with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateAdminAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) DisassociateAdminAccountWithContext(ctx aws.Context, input *DisassociateAdminAccountInput, opts ...request.Option) (*DisassociateAdminAccountOutput, error) {
	req, out := c.DisassociateAdminAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAdminAccount = "GetAdminAccount"

// GetAdminAccountRequest generates a "aws/request.Request" representing the
// client's request for the GetAdminAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAdminAccount for more information on using the GetAdminAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAdminAccountRequest method.
//    req, resp := client.GetAdminAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetAdminAccount
func (c *FMS) GetAdminAccountRequest(input *GetAdminAccountInput) (req *request.Request, output *GetAdminAccountOutput) {
	op := &request.Operation{
		Name:       opGetAdminAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAdminAccountInput{}
	}

	output = &GetAdminAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAdminAccount API operation for Firewall Management Service.
//
// Returns the AWS Organizations master account that is associated with AWS
// Firewall Manager as the AWS Firewall Manager administrator.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation GetAdminAccount for usage and error information.
//
// Returned Error Types:
//   * InvalidOperationException
//   The operation failed because there was nothing to do. For example, you might
//   have submitted an AssociateAdminAccount request, but the account ID that
//   you submitted was already set as the AWS Firewall Manager administrator.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetAdminAccount
func (c *FMS) GetAdminAccount(input *GetAdminAccountInput) (*GetAdminAccountOutput, error) {
	req, out := c.GetAdminAccountRequest(input)
	return out, req.Send()
}

// GetAdminAccountWithContext is the same as GetAdminAccount with the addition of
// the ability to pass a context and additional request options.
//
// See GetAdminAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) GetAdminAccountWithContext(ctx aws.Context, input *GetAdminAccountInput, opts ...request.Option) (*GetAdminAccountOutput, error) {
	req, out := c.GetAdminAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetComplianceDetail = "GetComplianceDetail"

// GetComplianceDetailRequest generates a "aws/request.Request" representing the
// client's request for the GetComplianceDetail operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetComplianceDetail for more information on using the GetComplianceDetail
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetComplianceDetailRequest method.
//    req, resp := client.GetComplianceDetailRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetComplianceDetail
func (c *FMS) GetComplianceDetailRequest(input *GetComplianceDetailInput) (req *request.Request, output *GetComplianceDetailOutput) {
	op := &request.Operation{
		Name:       opGetComplianceDetail,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetComplianceDetailInput{}
	}

	output = &GetComplianceDetailOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetComplianceDetail API operation for Firewall Management Service.
//
// Returns detailed compliance information about the specified member account.
// Details include resources that are in and out of compliance with the specified
// policy. Resources are considered noncompliant for AWS WAF and Shield Advanced
// policies if the specified policy has not been applied to them. Resources
// are considered noncompliant for security group policies if they are in scope
// of the policy, they violate one or more of the policy rules, and remediation
// is disabled or not possible.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation GetComplianceDetail for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetComplianceDetail
func (c *FMS) GetComplianceDetail(input *GetComplianceDetailInput) (*GetComplianceDetailOutput, error) {
	req, out := c.GetComplianceDetailRequest(input)
	return out, req.Send()
}

// GetComplianceDetailWithContext is the same as GetComplianceDetail with the addition of
// the ability to pass a context and additional request options.
//
// See GetComplianceDetail for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) GetComplianceDetailWithContext(ctx aws.Context, input *GetComplianceDetailInput, opts ...request.Option) (*GetComplianceDetailOutput, error) {
	req, out := c.GetComplianceDetailRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetNotificationChannel = "GetNotificationChannel"

// GetNotificationChannelRequest generates a "aws/request.Request" representing the
// client's request for the GetNotificationChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetNotificationChannel for more information on using the GetNotificationChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetNotificationChannelRequest method.
//    req, resp := client.GetNotificationChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetNotificationChannel
func (c *FMS) GetNotificationChannelRequest(input *GetNotificationChannelInput) (req *request.Request, output *GetNotificationChannelOutput) {
	op := &request.Operation{
		Name:       opGetNotificationChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetNotificationChannelInput{}
	}

	output = &GetNotificationChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetNotificationChannel API operation for Firewall Management Service.
//
// Information about the Amazon Simple Notification Service (SNS) topic that
// is used to record AWS Firewall Manager SNS logs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation GetNotificationChannel for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * InvalidOperationException
//   The operation failed because there was nothing to do. For example, you might
//   have submitted an AssociateAdminAccount request, but the account ID that
//   you submitted was already set as the AWS Firewall Manager administrator.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetNotificationChannel
func (c *FMS) GetNotificationChannel(input *GetNotificationChannelInput) (*GetNotificationChannelOutput, error) {
	req, out := c.GetNotificationChannelRequest(input)
	return out, req.Send()
}

// GetNotificationChannelWithContext is the same as GetNotificationChannel with the addition of
// the ability to pass a context and additional request options.
//
// See GetNotificationChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) GetNotificationChannelWithContext(ctx aws.Context, input *GetNotificationChannelInput, opts ...request.Option) (*GetNotificationChannelOutput, error) {
	req, out := c.GetNotificationChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPolicy = "GetPolicy"

// GetPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPolicy for more information on using the GetPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetPolicyRequest method.
//    req, resp := client.GetPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetPolicy
func (c *FMS) GetPolicyRequest(input *GetPolicyInput) (req *request.Request, output *GetPolicyOutput) {
	op := &request.Operation{
		Name:       opGetPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPolicyInput{}
	}

	output = &GetPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPolicy API operation for Firewall Management Service.
//
// Returns information about the specified AWS Firewall Manager policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation GetPolicy for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * InvalidOperationException
//   The operation failed because there was nothing to do. For example, you might
//   have submitted an AssociateAdminAccount request, but the account ID that
//   you submitted was already set as the AWS Firewall Manager administrator.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidTypeException
//   The value of the Type parameter is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetPolicy
func (c *FMS) GetPolicy(input *GetPolicyInput) (*GetPolicyOutput, error) {
	req, out := c.GetPolicyRequest(input)
	return out, req.Send()
}

// GetPolicyWithContext is the same as GetPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) GetPolicyWithContext(ctx aws.Context, input *GetPolicyInput, opts ...request.Option) (*GetPolicyOutput, error) {
	req, out := c.GetPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetProtectionStatus = "GetProtectionStatus"

// GetProtectionStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetProtectionStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetProtectionStatus for more information on using the GetProtectionStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetProtectionStatusRequest method.
//    req, resp := client.GetProtectionStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetProtectionStatus
func (c *FMS) GetProtectionStatusRequest(input *GetProtectionStatusInput) (req *request.Request, output *GetProtectionStatusOutput) {
	op := &request.Operation{
		Name:       opGetProtectionStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetProtectionStatusInput{}
	}

	output = &GetProtectionStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetProtectionStatus API operation for Firewall Management Service.
//
// If you created a Shield Advanced policy, returns policy-level attack summary
// information in the event of a potential DDoS attack. Other policy types are
// currently unsupported.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation GetProtectionStatus for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The parameters of the request were invalid.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetProtectionStatus
func (c *FMS) GetProtectionStatus(input *GetProtectionStatusInput) (*GetProtectionStatusOutput, error) {
	req, out := c.GetProtectionStatusRequest(input)
	return out, req.Send()
}

// GetProtectionStatusWithContext is the same as GetProtectionStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetProtectionStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) GetProtectionStatusWithContext(ctx aws.Context, input *GetProtectionStatusInput, opts ...request.Option) (*GetProtectionStatusOutput, error) {
	req, out := c.GetProtectionStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListComplianceStatus = "ListComplianceStatus"

// ListComplianceStatusRequest generates a "aws/request.Request" representing the
// client's request for the ListComplianceStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListComplianceStatus for more information on using the ListComplianceStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListComplianceStatusRequest method.
//    req, resp := client.ListComplianceStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListComplianceStatus
func (c *FMS) ListComplianceStatusRequest(input *ListComplianceStatusInput) (req *request.Request, output *ListComplianceStatusOutput) {
	op := &request.Operation{
		Name:       opListComplianceStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListComplianceStatusInput{}
	}

	output = &ListComplianceStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListComplianceStatus API operation for Firewall Management Service.
//
// Returns an array of PolicyComplianceStatus objects in the response. Use PolicyComplianceStatus
// to get a summary of which member accounts are protected by the specified
// policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation ListComplianceStatus for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListComplianceStatus
func (c *FMS) ListComplianceStatus(input *ListComplianceStatusInput) (*ListComplianceStatusOutput, error) {
	req, out := c.ListComplianceStatusRequest(input)
	return out, req.Send()
}

// ListComplianceStatusWithContext is the same as ListComplianceStatus with the addition of
// the ability to pass a context and additional request options.
//
// See ListComplianceStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) ListComplianceStatusWithContext(ctx aws.Context, input *ListComplianceStatusInput, opts ...request.Option) (*ListComplianceStatusOutput, error) {
	req, out := c.ListComplianceStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListComplianceStatusPages iterates over the pages of a ListComplianceStatus operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListComplianceStatus method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListComplianceStatus operation.
//    pageNum := 0
//    err := client.ListComplianceStatusPages(params,
//        func(page *fms.ListComplianceStatusOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *FMS) ListComplianceStatusPages(input *ListComplianceStatusInput, fn func(*ListComplianceStatusOutput, bool) bool) error {
	return c.ListComplianceStatusPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListComplianceStatusPagesWithContext same as ListComplianceStatusPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) ListComplianceStatusPagesWithContext(ctx aws.Context, input *ListComplianceStatusInput, fn func(*ListComplianceStatusOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListComplianceStatusInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListComplianceStatusRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListComplianceStatusOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMemberAccounts = "ListMemberAccounts"

// ListMemberAccountsRequest generates a "aws/request.Request" representing the
// client's request for the ListMemberAccounts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMemberAccounts for more information on using the ListMemberAccounts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListMemberAccountsRequest method.
//    req, resp := client.ListMemberAccountsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListMemberAccounts
func (c *FMS) ListMemberAccountsRequest(input *ListMemberAccountsInput) (req *request.Request, output *ListMemberAccountsOutput) {
	op := &request.Operation{
		Name:       opListMemberAccounts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMemberAccountsInput{}
	}

	output = &ListMemberAccountsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMemberAccounts API operation for Firewall Management Service.
//
// Returns a MemberAccounts object that lists the member accounts in the administrator's
// AWS organization.
//
// The ListMemberAccounts must be submitted by the account that is set as the
// AWS Firewall Manager administrator.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation ListMemberAccounts for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListMemberAccounts
func (c *FMS) ListMemberAccounts(input *ListMemberAccountsInput) (*ListMemberAccountsOutput, error) {
	req, out := c.ListMemberAccountsRequest(input)
	return out, req.Send()
}

// ListMemberAccountsWithContext is the same as ListMemberAccounts with the addition of
// the ability to pass a context and additional request options.
//
// See ListMemberAccounts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) ListMemberAccountsWithContext(ctx aws.Context, input *ListMemberAccountsInput, opts ...request.Option) (*ListMemberAccountsOutput, error) {
	req, out := c.ListMemberAccountsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMemberAccountsPages iterates over the pages of a ListMemberAccounts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMemberAccounts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListMemberAccounts operation.
//    pageNum := 0
//    err := client.ListMemberAccountsPages(params,
//        func(page *fms.ListMemberAccountsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *FMS) ListMemberAccountsPages(input *ListMemberAccountsInput, fn func(*ListMemberAccountsOutput, bool) bool) error {
	return c.ListMemberAccountsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMemberAccountsPagesWithContext same as ListMemberAccountsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) ListMemberAccountsPagesWithContext(ctx aws.Context, input *ListMemberAccountsInput, fn func(*ListMemberAccountsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMemberAccountsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMemberAccountsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMemberAccountsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPolicies = "ListPolicies"

// ListPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the ListPolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPolicies for more information on using the ListPolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPoliciesRequest method.
//    req, resp := client.ListPoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListPolicies
func (c *FMS) ListPoliciesRequest(input *ListPoliciesInput) (req *request.Request, output *ListPoliciesOutput) {
	op := &request.Operation{
		Name:       opListPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPoliciesInput{}
	}

	output = &ListPoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPolicies API operation for Firewall Management Service.
//
// Returns an array of PolicySummary objects in the response.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation ListPolicies for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * InvalidOperationException
//   The operation failed because there was nothing to do. For example, you might
//   have submitted an AssociateAdminAccount request, but the account ID that
//   you submitted was already set as the AWS Firewall Manager administrator.
//
//   * LimitExceededException
//   The operation exceeds a resource limit, for example, the maximum number of
//   policy objects that you can create for an AWS account. For more information,
//   see Firewall Manager Limits (https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html)
//   in the AWS WAF Developer Guide.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListPolicies
func (c *FMS) ListPolicies(input *ListPoliciesInput) (*ListPoliciesOutput, error) {
	req, out := c.ListPoliciesRequest(input)
	return out, req.Send()
}

// ListPoliciesWithContext is the same as ListPolicies with the addition of
// the ability to pass a context and additional request options.
//
// See ListPolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) ListPoliciesWithContext(ctx aws.Context, input *ListPoliciesInput, opts ...request.Option) (*ListPoliciesOutput, error) {
	req, out := c.ListPoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPoliciesPages iterates over the pages of a ListPolicies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPolicies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListPolicies operation.
//    pageNum := 0
//    err := client.ListPoliciesPages(params,
//        func(page *fms.ListPoliciesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *FMS) ListPoliciesPages(input *ListPoliciesInput, fn func(*ListPoliciesOutput, bool) bool) error {
	return c.ListPoliciesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPoliciesPagesWithContext same as ListPoliciesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) ListPoliciesPagesWithContext(ctx aws.Context, input *ListPoliciesInput, fn func(*ListPoliciesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPoliciesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPoliciesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPoliciesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListTagsForResource
func (c *FMS) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Firewall Management Service.
//
// Retrieves the list of tags for the specified AWS resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * InvalidOperationException
//   The operation failed because there was nothing to do. For example, you might
//   have submitted an AssociateAdminAccount request, but the account ID that
//   you submitted was already set as the AWS Firewall Manager administrator.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidInputException
//   The parameters of the request were invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListTagsForResource
func (c *FMS) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutNotificationChannel = "PutNotificationChannel"

// PutNotificationChannelRequest generates a "aws/request.Request" representing the
// client's request for the PutNotificationChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutNotificationChannel for more information on using the PutNotificationChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutNotificationChannelRequest method.
//    req, resp := client.PutNotificationChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/PutNotificationChannel
func (c *FMS) PutNotificationChannelRequest(input *PutNotificationChannelInput) (req *request.Request, output *PutNotificationChannelOutput) {
	op := &request.Operation{
		Name:       opPutNotificationChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutNotificationChannelInput{}
	}

	output = &PutNotificationChannelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutNotificationChannel API operation for Firewall Management Service.
//
// Designates the IAM role and Amazon Simple Notification Service (SNS) topic
// that AWS Firewall Manager uses to record SNS logs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation PutNotificationChannel for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * InvalidOperationException
//   The operation failed because there was nothing to do. For example, you might
//   have submitted an AssociateAdminAccount request, but the account ID that
//   you submitted was already set as the AWS Firewall Manager administrator.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/PutNotificationChannel
func (c *FMS) PutNotificationChannel(input *PutNotificationChannelInput) (*PutNotificationChannelOutput, error) {
	req, out := c.PutNotificationChannelRequest(input)
	return out, req.Send()
}

// PutNotificationChannelWithContext is the same as PutNotificationChannel with the addition of
// the ability to pass a context and additional request options.
//
// See PutNotificationChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) PutNotificationChannelWithContext(ctx aws.Context, input *PutNotificationChannelInput, opts ...request.Option) (*PutNotificationChannelOutput, error) {
	req, out := c.PutNotificationChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutPolicy = "PutPolicy"

// PutPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutPolicy for more information on using the PutPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutPolicyRequest method.
//    req, resp := client.PutPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/PutPolicy
func (c *FMS) PutPolicyRequest(input *PutPolicyInput) (req *request.Request, output *PutPolicyOutput) {
	op := &request.Operation{
		Name:       opPutPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutPolicyInput{}
	}

	output = &PutPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutPolicy API operation for Firewall Management Service.
//
// Creates an AWS Firewall Manager policy.
//
// Firewall Manager provides the following types of policies:
//
//    * A Shield Advanced policy, which applies Shield Advanced protection to
//    specified accounts and resources
//
//    * An AWS WAF policy, which contains a rule group and defines which resources
//    are to be protected by that rule group
//
//    * A security group policy, which manages VPC security groups across your
//    AWS organization.
//
// Each policy is specific to one of the three types. If you want to enforce
// more than one policy type across accounts, you can create multiple policies.
// You can create multiple policies for each type.
//
// You must be subscribed to Shield Advanced to create a Shield Advanced policy.
// For more information about subscribing to Shield Advanced, see CreateSubscription
// (https://docs.aws.amazon.com/waf/latest/DDOSAPIReference/API_CreateSubscription.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation PutPolicy for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * InvalidOperationException
//   The operation failed because there was nothing to do. For example, you might
//   have submitted an AssociateAdminAccount request, but the account ID that
//   you submitted was already set as the AWS Firewall Manager administrator.
//
//   * InvalidInputException
//   The parameters of the request were invalid.
//
//   * LimitExceededException
//   The operation exceeds a resource limit, for example, the maximum number of
//   policy objects that you can create for an AWS account. For more information,
//   see Firewall Manager Limits (https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html)
//   in the AWS WAF Developer Guide.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidTypeException
//   The value of the Type parameter is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/PutPolicy
func (c *FMS) PutPolicy(input *PutPolicyInput) (*PutPolicyOutput, error) {
	req, out := c.PutPolicyRequest(input)
	return out, req.Send()
}

// PutPolicyWithContext is the same as PutPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) PutPolicyWithContext(ctx aws.Context, input *PutPolicyInput, opts ...request.Option) (*PutPolicyOutput, error) {
	req, out := c.PutPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/TagResource
func (c *FMS) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Firewall Management Service.
//
// Adds one or more tags to an AWS resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * InvalidOperationException
//   The operation failed because there was nothing to do. For example, you might
//   have submitted an AssociateAdminAccount request, but the account ID that
//   you submitted was already set as the AWS Firewall Manager administrator.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidInputException
//   The parameters of the request were invalid.
//
//   * LimitExceededException
//   The operation exceeds a resource limit, for example, the maximum number of
//   policy objects that you can create for an AWS account. For more information,
//   see Firewall Manager Limits (https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html)
//   in the AWS WAF Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/TagResource
func (c *FMS) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/UntagResource
func (c *FMS) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Firewall Management Service.
//
// Removes one or more tags from an AWS resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Firewall Management Service's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * InvalidOperationException
//   The operation failed because there was nothing to do. For example, you might
//   have submitted an AssociateAdminAccount request, but the account ID that
//   you submitted was already set as the AWS Firewall Manager administrator.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidInputException
//   The parameters of the request were invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/UntagResource
func (c *FMS) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FMS) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AssociateAdminAccountInput struct {
	_ struct{} `type:"structure"`

	// The AWS account ID to associate with AWS Firewall Manager as the AWS Firewall
	// Manager administrator account. This can be an AWS Organizations master account
	// or a member account. For more information about AWS Organizations and master
	// accounts, see Managing the AWS Accounts in Your Organization (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts.html).
	//
	// AdminAccount is a required field
	AdminAccount *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateAdminAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateAdminAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateAdminAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateAdminAccountInput"}
	if s.AdminAccount == nil {
		invalidParams.Add(request.NewErrParamRequired("AdminAccount"))
	}
	if s.AdminAccount != nil && len(*s.AdminAccount) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AdminAccount", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdminAccount sets the AdminAccount field's value.
func (s *AssociateAdminAccountInput) SetAdminAccount(v string) *AssociateAdminAccountInput {
	s.AdminAccount = &v
	return s
}

type AssociateAdminAccountOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateAdminAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateAdminAccountOutput) GoString() string {
	return s.String()
}

// Details of the resource that is not protected by the policy.
type ComplianceViolator struct {
	_ struct{} `type:"structure"`

	// The resource ID.
	ResourceId *string `min:"1" type:"string"`

	// The resource type. This is in the format shown in the AWS Resource Types
	// Reference (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html).
	// For example: AWS::ElasticLoadBalancingV2::LoadBalancer or AWS::CloudFront::Distribution.
	ResourceType *string `min:"1" type:"string"`

	// The reason that the resource is not protected by the policy.
	ViolationReason *string `type:"string" enum:"ViolationReason"`
}

// String returns the string representation
func (s ComplianceViolator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ComplianceViolator) GoString() string {
	return s.String()
}

// SetResourceId sets the ResourceId field's value.
func (s *ComplianceViolator) SetResourceId(v string) *ComplianceViolator {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ComplianceViolator) SetResourceType(v string) *ComplianceViolator {
	s.ResourceType = &v
	return s
}

// SetViolationReason sets the ViolationReason field's value.
func (s *ComplianceViolator) SetViolationReason(v string) *ComplianceViolator {
	s.ViolationReason = &v
	return s
}

type DeleteNotificationChannelInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteNotificationChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNotificationChannelInput) GoString() string {
	return s.String()
}

type DeleteNotificationChannelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteNotificationChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNotificationChannelOutput) GoString() string {
	return s.String()
}

type DeletePolicyInput struct {
	_ struct{} `type:"structure"`

	// If True, the request performs cleanup according to the policy type.
	//
	// For AWS WAF and Shield Advanced policies, the cleanup does the following:
	//
	//    * Deletes rule groups created by AWS Firewall Manager
	//
	//    * Removes web ACLs from in-scope resources
	//
	//    * Deletes web ACLs that contain no rules or rule groups
	//
	// For security group policies, the cleanup does the following for each security
	// group in the policy:
	//
	//    * Disassociates the security group from in-scope resources
	//
	//    * Deletes the security group if it was created through Firewall Manager
	//    and if it's no longer associated with any resources through another policy
	//
	// After the cleanup, in-scope resources are no longer protected by web ACLs
	// in this policy. Protection of out-of-scope resources remains unchanged. Scope
	// is determined by tags that you create and accounts that you associate with
	// the policy. When creating the policy, if you specify that only resources
	// in specific accounts or with specific tags are in scope of the policy, those
	// accounts and resources are handled by the policy. All others are out of scope.
	// If you don't specify tags or accounts, all resources are in scope.
	DeleteAllPolicyResources *bool `type:"boolean"`

	// The ID of the policy that you want to delete. PolicyId is returned by PutPolicy
	// and by ListPolicies.
	//
	// PolicyId is a required field
	PolicyId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePolicyInput"}
	if s.PolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyId"))
	}
	if s.PolicyId != nil && len(*s.PolicyId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeleteAllPolicyResources sets the DeleteAllPolicyResources field's value.
func (s *DeletePolicyInput) SetDeleteAllPolicyResources(v bool) *DeletePolicyInput {
	s.DeleteAllPolicyResources = &v
	return s
}

// SetPolicyId sets the PolicyId field's value.
func (s *DeletePolicyInput) SetPolicyId(v string) *DeletePolicyInput {
	s.PolicyId = &v
	return s
}

type DeletePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePolicyOutput) GoString() string {
	return s.String()
}

type DisassociateAdminAccountInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateAdminAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateAdminAccountInput) GoString() string {
	return s.String()
}

type DisassociateAdminAccountOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateAdminAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateAdminAccountOutput) GoString() string {
	return s.String()
}

// Describes the compliance status for the account. An account is considered
// noncompliant if it includes resources that are not protected by the specified
// policy or that don't comply with the policy.
type EvaluationResult struct {
	_ struct{} `type:"structure"`

	// Describes an AWS account's compliance with the AWS Firewall Manager policy.
	ComplianceStatus *string `type:"string" enum:"PolicyComplianceStatusType"`

	// Indicates that over 100 resources are noncompliant with the AWS Firewall
	// Manager policy.
	EvaluationLimitExceeded *bool `type:"boolean"`

	// The number of resources that are noncompliant with the specified policy.
	// For AWS WAF and Shield Advanced policies, a resource is considered noncompliant
	// if it is not associated with the policy. For security group policies, a resource
	// is considered noncompliant if it doesn't comply with the rules of the policy
	// and remediation is disabled or not possible.
	ViolatorCount *int64 `type:"long"`
}

// String returns the string representation
func (s EvaluationResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EvaluationResult) GoString() string {
	return s.String()
}

// SetComplianceStatus sets the ComplianceStatus field's value.
func (s *EvaluationResult) SetComplianceStatus(v string) *EvaluationResult {
	s.ComplianceStatus = &v
	return s
}

// SetEvaluationLimitExceeded sets the EvaluationLimitExceeded field's value.
func (s *EvaluationResult) SetEvaluationLimitExceeded(v bool) *EvaluationResult {
	s.EvaluationLimitExceeded = &v
	return s
}

// SetViolatorCount sets the ViolatorCount field's value.
func (s *EvaluationResult) SetViolatorCount(v int64) *EvaluationResult {
	s.ViolatorCount = &v
	return s
}

type GetAdminAccountInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetAdminAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAdminAccountInput) GoString() string {
	return s.String()
}

type GetAdminAccountOutput struct {
	_ struct{} `type:"structure"`

	// The AWS account that is set as the AWS Firewall Manager administrator.
	AdminAccount *string `min:"1" type:"string"`

	// The status of the AWS account that you set as the AWS Firewall Manager administrator.
	RoleStatus *string `type:"string" enum:"AccountRoleStatus"`
}

// String returns the string representation
func (s GetAdminAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAdminAccountOutput) GoString() string {
	return s.String()
}

// SetAdminAccount sets the AdminAccount field's value.
func (s *GetAdminAccountOutput) SetAdminAccount(v string) *GetAdminAccountOutput {
	s.AdminAccount = &v
	return s
}

// SetRoleStatus sets the RoleStatus field's value.
func (s *GetAdminAccountOutput) SetRoleStatus(v string) *GetAdminAccountOutput {
	s.RoleStatus = &v
	return s
}

type GetComplianceDetailInput struct {
	_ struct{} `type:"structure"`

	// The AWS account that owns the resources that you want to get the details
	// for.
	//
	// MemberAccount is a required field
	MemberAccount *string `min:"1" type:"string" required:"true"`

	// The ID of the policy that you want to get the details for. PolicyId is returned
	// by PutPolicy and by ListPolicies.
	//
	// PolicyId is a required field
	PolicyId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s GetComplianceDetailInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetComplianceDetailInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetComplianceDetailInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetComplianceDetailInput"}
	if s.MemberAccount == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberAccount"))
	}
	if s.MemberAccount != nil && len(*s.MemberAccount) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MemberAccount", 1))
	}
	if s.PolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyId"))
	}
	if s.PolicyId != nil && len(*s.PolicyId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMemberAccount sets the MemberAccount field's value.
func (s *GetComplianceDetailInput) SetMemberAccount(v string) *GetComplianceDetailInput {
	s.MemberAccount = &v
	return s
}

// SetPolicyId sets the PolicyId field's value.
func (s *GetComplianceDetailInput) SetPolicyId(v string) *GetComplianceDetailInput {
	s.PolicyId = &v
	return s
}

type GetComplianceDetailOutput struct {
	_ struct{} `type:"structure"`

	// Information about the resources and the policy that you specified in the
	// GetComplianceDetail request.
	PolicyComplianceDetail *PolicyComplianceDetail `type:"structure"`
}

// String returns the string representation
func (s GetComplianceDetailOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetComplianceDetailOutput) GoString() string {
	return s.String()
}

// SetPolicyComplianceDetail sets the PolicyComplianceDetail field's value.
func (s *GetComplianceDetailOutput) SetPolicyComplianceDetail(v *PolicyComplianceDetail) *GetComplianceDetailOutput {
	s.PolicyComplianceDetail = v
	return s
}

type GetNotificationChannelInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetNotificationChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetNotificationChannelInput) GoString() string {
	return s.String()
}

type GetNotificationChannelOutput struct {
	_ struct{} `type:"structure"`

	// The IAM role that is used by AWS Firewall Manager to record activity to SNS.
	SnsRoleName *string `min:"1" type:"string"`

	// The SNS topic that records AWS Firewall Manager activity.
	SnsTopicArn *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetNotificationChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetNotificationChannelOutput) GoString() string {
	return s.String()
}

// SetSnsRoleName sets the SnsRoleName field's value.
func (s *GetNotificationChannelOutput) SetSnsRoleName(v string) *GetNotificationChannelOutput {
	s.SnsRoleName = &v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *GetNotificationChannelOutput) SetSnsTopicArn(v string) *GetNotificationChannelOutput {
	s.SnsTopicArn = &v
	return s
}

type GetPolicyInput struct {
	_ struct{} `type:"structure"`

	// The ID of the AWS Firewall Manager policy that you want the details for.
	//
	// PolicyId is a required field
	PolicyId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s GetPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPolicyInput"}
	if s.PolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyId"))
	}
	if s.PolicyId != nil && len(*s.PolicyId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyId sets the PolicyId field's value.
func (s *GetPolicyInput) SetPolicyId(v string) *GetPolicyInput {
	s.PolicyId = &v
	return s
}

type GetPolicyOutput struct {
	_ struct{} `type:"structure"`

	// Information about the specified AWS Firewall Manager policy.
	Policy *Policy `type:"structure"`

	// The Amazon Resource Name (ARN) of the specified policy.
	PolicyArn *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *GetPolicyOutput) SetPolicy(v *Policy) *GetPolicyOutput {
	s.Policy = v
	return s
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *GetPolicyOutput) SetPolicyArn(v string) *GetPolicyOutput {
	s.PolicyArn = &v
	return s
}

type GetProtectionStatusInput struct {
	_ struct{} `type:"structure"`

	// The end of the time period to query for the attacks. This is a timestamp
	// type. The request syntax listing indicates a number type because the default
	// used by AWS Firewall Manager is Unix time in seconds. However, any valid
	// timestamp format is allowed.
	EndTime *time.Time `type:"timestamp"`

	// Specifies the number of objects that you want AWS Firewall Manager to return
	// for this request. If you have more objects than the number that you specify
	// for MaxResults, the response includes a NextToken value that you can use
	// to get another batch of objects.
	MaxResults *int64 `min:"1" type:"integer"`

	// The AWS account that is in scope of the policy that you want to get the details
	// for.
	MemberAccountId *string `min:"1" type:"string"`

	// If you specify a value for MaxResults and you have more objects than the
	// number that you specify for MaxResults, AWS Firewall Manager returns a NextToken
	// value in the response, which you can use to retrieve another group of objects.
	// For the second and subsequent GetProtectionStatus requests, specify the value
	// of NextToken from the previous response to get information about another
	// batch of objects.
	NextToken *string `min:"1" type:"string"`

	// The ID of the policy for which you want to get the attack information.
	//
	// PolicyId is a required field
	PolicyId *string `min:"36" type:"string" required:"true"`

	// The start of the time period to query for the attacks. This is a timestamp
	// type. The request syntax listing indicates a number type because the default
	// used by AWS Firewall Manager is Unix time in seconds. However, any valid
	// timestamp format is allowed.
	StartTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s GetProtectionStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetProtectionStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetProtectionStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetProtectionStatusInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.MemberAccountId != nil && len(*s.MemberAccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MemberAccountId", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.PolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyId"))
	}
	if s.PolicyId != nil && len(*s.PolicyId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *GetProtectionStatusInput) SetEndTime(v time.Time) *GetProtectionStatusInput {
	s.EndTime = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetProtectionStatusInput) SetMaxResults(v int64) *GetProtectionStatusInput {
	s.MaxResults = &v
	return s
}

// SetMemberAccountId sets the MemberAccountId field's value.
func (s *GetProtectionStatusInput) SetMemberAccountId(v string) *GetProtectionStatusInput {
	s.MemberAccountId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetProtectionStatusInput) SetNextToken(v string) *GetProtectionStatusInput {
	s.NextToken = &v
	return s
}

// SetPolicyId sets the PolicyId field's value.
func (s *GetProtectionStatusInput) SetPolicyId(v string) *GetProtectionStatusInput {
	s.PolicyId = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetProtectionStatusInput) SetStartTime(v time.Time) *GetProtectionStatusInput {
	s.StartTime = &v
	return s
}

type GetProtectionStatusOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the AWS Firewall administrator account for this policy.
	AdminAccountId *string `min:"1" type:"string"`

	// Details about the attack, including the following:
	//
	//    * Attack type
	//
	//    * Account ID
	//
	//    * ARN of the resource attacked
	//
	//    * Start time of the attack
	//
	//    * End time of the attack (ongoing attacks will not have an end time)
	//
	// The details are in JSON format.
	Data *string `type:"string"`

	// If you have more objects than the number that you specified for MaxResults
	// in the request, the response includes a NextToken value. To list more objects,
	// submit another GetProtectionStatus request, and specify the NextToken value
	// from the response in the NextToken value in the next request.
	//
	// AWS SDKs provide auto-pagination that identify NextToken in a response and
	// make subsequent request calls automatically on your behalf. However, this
	// feature is not supported by GetProtectionStatus. You must submit subsequent
	// requests with NextToken using your own processes.
	NextToken *string `min:"1" type:"string"`

	// The service type that is protected by the policy. Currently, this is always
	// SHIELD_ADVANCED.
	ServiceType *string `type:"string" enum:"SecurityServiceType"`
}

// String returns the string representation
func (s GetProtectionStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetProtectionStatusOutput) GoString() string {
	return s.String()
}

// SetAdminAccountId sets the AdminAccountId field's value.
func (s *GetProtectionStatusOutput) SetAdminAccountId(v string) *GetProtectionStatusOutput {
	s.AdminAccountId = &v
	return s
}

// SetData sets the Data field's value.
func (s *GetProtectionStatusOutput) SetData(v string) *GetProtectionStatusOutput {
	s.Data = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetProtectionStatusOutput) SetNextToken(v string) *GetProtectionStatusOutput {
	s.NextToken = &v
	return s
}

// SetServiceType sets the ServiceType field's value.
func (s *GetProtectionStatusOutput) SetServiceType(v string) *GetProtectionStatusOutput {
	s.ServiceType = &v
	return s
}

// The operation failed because of a system problem, even though the request
// was valid. Retry your request.
type InternalErrorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InternalErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalErrorException) GoString() string {
	return s.String()
}

func newErrorInternalErrorException(v protocol.ResponseMetadata) error {
	return &InternalErrorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalErrorException) Code() string {
	return "InternalErrorException"
}

// Message returns the exception's message.
func (s *InternalErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalErrorException) OrigErr() error {
	return nil
}

func (s *InternalErrorException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalErrorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalErrorException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The parameters of the request were invalid.
type InvalidInputException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidInputException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidInputException) GoString() string {
	return s.String()
}

func newErrorInvalidInputException(v protocol.ResponseMetadata) error {
	return &InvalidInputException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidInputException) Code() string {
	return "InvalidInputException"
}

// Message returns the exception's message.
func (s *InvalidInputException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidInputException) OrigErr() error {
	return nil
}

func (s *InvalidInputException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidInputException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidInputException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The operation failed because there was nothing to do. For example, you might
// have submitted an AssociateAdminAccount request, but the account ID that
// you submitted was already set as the AWS Firewall Manager administrator.
type InvalidOperationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidOperationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidOperationException) GoString() string {
	return s.String()
}

func newErrorInvalidOperationException(v protocol.ResponseMetadata) error {
	return &InvalidOperationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidOperationException) Code() string {
	return "InvalidOperationException"
}

// Message returns the exception's message.
func (s *InvalidOperationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidOperationException) OrigErr() error {
	return nil
}

func (s *InvalidOperationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidOperationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidOperationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The value of the Type parameter is invalid.
type InvalidTypeException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidTypeException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidTypeException) GoString() string {
	return s.String()
}

func newErrorInvalidTypeException(v protocol.ResponseMetadata) error {
	return &InvalidTypeException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidTypeException) Code() string {
	return "InvalidTypeException"
}

// Message returns the exception's message.
func (s *InvalidTypeException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidTypeException) OrigErr() error {
	return nil
}

func (s *InvalidTypeException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidTypeException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidTypeException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The operation exceeds a resource limit, for example, the maximum number of
// policy objects that you can create for an AWS account. For more information,
// see Firewall Manager Limits (https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html)
// in the AWS WAF Developer Guide.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListComplianceStatusInput struct {
	_ struct{} `type:"structure"`

	// Specifies the number of PolicyComplianceStatus objects that you want AWS
	// Firewall Manager to return for this request. If you have more PolicyComplianceStatus
	// objects than the number that you specify for MaxResults, the response includes
	// a NextToken value that you can use to get another batch of PolicyComplianceStatus
	// objects.
	MaxResults *int64 `min:"1" type:"integer"`

	// If you specify a value for MaxResults and you have more PolicyComplianceStatus
	// objects than the number that you specify for MaxResults, AWS Firewall Manager
	// returns a NextToken value in the response that allows you to list another
	// group of PolicyComplianceStatus objects. For the second and subsequent ListComplianceStatus
	// requests, specify the value of NextToken from the previous response to get
	// information about another batch of PolicyComplianceStatus objects.
	NextToken *string `min:"1" type:"string"`

	// The ID of the AWS Firewall Manager policy that you want the details for.
	//
	// PolicyId is a required field
	PolicyId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s ListComplianceStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListComplianceStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListComplianceStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListComplianceStatusInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.PolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyId"))
	}
	if s.PolicyId != nil && len(*s.PolicyId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListComplianceStatusInput) SetMaxResults(v int64) *ListComplianceStatusInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListComplianceStatusInput) SetNextToken(v string) *ListComplianceStatusInput {
	s.NextToken = &v
	return s
}

// SetPolicyId sets the PolicyId field's value.
func (s *ListComplianceStatusInput) SetPolicyId(v string) *ListComplianceStatusInput {
	s.PolicyId = &v
	return s
}

type ListComplianceStatusOutput struct {
	_ struct{} `type:"structure"`

	// If you have more PolicyComplianceStatus objects than the number that you
	// specified for MaxResults in the request, the response includes a NextToken
	// value. To list more PolicyComplianceStatus objects, submit another ListComplianceStatus
	// request, and specify the NextToken value from the response in the NextToken
	// value in the next request.
	NextToken *string `min:"1" type:"string"`

	// An array of PolicyComplianceStatus objects.
	PolicyComplianceStatusList []*PolicyComplianceStatus `type:"list"`
}

// String returns the string representation
func (s ListComplianceStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListComplianceStatusOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListComplianceStatusOutput) SetNextToken(v string) *ListComplianceStatusOutput {
	s.NextToken = &v
	return s
}

// SetPolicyComplianceStatusList sets the PolicyComplianceStatusList field's value.
func (s *ListComplianceStatusOutput) SetPolicyComplianceStatusList(v []*PolicyComplianceStatus) *ListComplianceStatusOutput {
	s.PolicyComplianceStatusList = v
	return s
}

type ListMemberAccountsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the number of member account IDs that you want AWS Firewall Manager
	// to return for this request. If you have more IDs than the number that you
	// specify for MaxResults, the response includes a NextToken value that you
	// can use to get another batch of member account IDs.
	MaxResults *int64 `min:"1" type:"integer"`

	// If you specify a value for MaxResults and you have more account IDs than
	// the number that you specify for MaxResults, AWS Firewall Manager returns
	// a NextToken value in the response that allows you to list another group of
	// IDs. For the second and subsequent ListMemberAccountsRequest requests, specify
	// the value of NextToken from the previous response to get information about
	// another batch of member account IDs.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListMemberAccountsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMemberAccountsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMemberAccountsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMemberAccountsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMemberAccountsInput) SetMaxResults(v int64) *ListMemberAccountsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMemberAccountsInput) SetNextToken(v string) *ListMemberAccountsInput {
	s.NextToken = &v
	return s
}

type ListMemberAccountsOutput struct {
	_ struct{} `type:"structure"`

	// An array of account IDs.
	MemberAccounts []*string `type:"list"`

	// If you have more member account IDs than the number that you specified for
	// MaxResults in the request, the response includes a NextToken value. To list
	// more IDs, submit another ListMemberAccounts request, and specify the NextToken
	// value from the response in the NextToken value in the next request.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListMemberAccountsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMemberAccountsOutput) GoString() string {
	return s.String()
}

// SetMemberAccounts sets the MemberAccounts field's value.
func (s *ListMemberAccountsOutput) SetMemberAccounts(v []*string) *ListMemberAccountsOutput {
	s.MemberAccounts = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMemberAccountsOutput) SetNextToken(v string) *ListMemberAccountsOutput {
	s.NextToken = &v
	return s
}

type ListPoliciesInput struct {
	_ struct{} `type:"structure"`

	// Specifies the number of PolicySummary objects that you want AWS Firewall
	// Manager to return for this request. If you have more PolicySummary objects
	// than the number that you specify for MaxResults, the response includes a
	// NextToken value that you can use to get another batch of PolicySummary objects.
	MaxResults *int64 `min:"1" type:"integer"`

	// If you specify a value for MaxResults and you have more PolicySummary objects
	// than the number that you specify for MaxResults, AWS Firewall Manager returns
	// a NextToken value in the response that allows you to list another group of
	// PolicySummary objects. For the second and subsequent ListPolicies requests,
	// specify the value of NextToken from the previous response to get information
	// about another batch of PolicySummary objects.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPoliciesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPoliciesInput) SetMaxResults(v int64) *ListPoliciesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPoliciesInput) SetNextToken(v string) *ListPoliciesInput {
	s.NextToken = &v
	return s
}

type ListPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// If you have more PolicySummary objects than the number that you specified
	// for MaxResults in the request, the response includes a NextToken value. To
	// list more PolicySummary objects, submit another ListPolicies request, and
	// specify the NextToken value from the response in the NextToken value in the
	// next request.
	NextToken *string `min:"1" type:"string"`

	// An array of PolicySummary objects.
	PolicyList []*PolicySummary `type:"list"`
}

// String returns the string representation
func (s ListPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPoliciesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPoliciesOutput) SetNextToken(v string) *ListPoliciesOutput {
	s.NextToken = &v
	return s
}

// SetPolicyList sets the PolicyList field's value.
func (s *ListPoliciesOutput) SetPolicyList(v []*PolicySummary) *ListPoliciesOutput {
	s.PolicyList = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource to return tags for. The Firewall
	// Manager policy is the only AWS resource that supports tagging, so this ARN
	// is a policy ARN..
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags associated with the resource.
	TagList []*Tag `type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTagList sets the TagList field's value.
func (s *ListTagsForResourceOutput) SetTagList(v []*Tag) *ListTagsForResourceOutput {
	s.TagList = v
	return s
}

// An AWS Firewall Manager policy.
type Policy struct {
	_ struct{} `type:"structure"`

	// Specifies the AWS account IDs to exclude from the policy. The IncludeMap
	// values are evaluated first, with all the appropriate account IDs added to
	// the policy. Then the accounts listed in ExcludeMap are removed, resulting
	// in the final list of accounts to add to the policy.
	//
	// The key to the map is ACCOUNT. For example, a valid ExcludeMap would be {“ACCOUNT”
	// : [“accountID1”, “accountID2”]}.
	ExcludeMap map[string][]*string `type:"map"`

	// If set to True, resources with the tags that are specified in the ResourceTag
	// array are not in scope of the policy. If set to False, and the ResourceTag
	// array is not null, only resources with the specified tags are in scope of
	// the policy.
	//
	// ExcludeResourceTags is a required field
	ExcludeResourceTags *bool `type:"boolean" required:"true"`

	// Specifies the AWS account IDs to include in the policy. If IncludeMap is
	// null, all accounts in the organization in AWS Organizations are included
	// in the policy. If IncludeMap is not null, only values listed in IncludeMap
	// are included in the policy.
	//
	// The key to the map is ACCOUNT. For example, a valid IncludeMap would be {“ACCOUNT”
	// : [“accountID1”, “accountID2”]}.
	IncludeMap map[string][]*string `type:"map"`

	// The ID of the AWS Firewall Manager policy.
	PolicyId *string `min:"36" type:"string"`

	// The friendly name of the AWS Firewall Manager policy.
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`

	// A unique identifier for each update to the policy. When issuing a PutPolicy
	// request, the PolicyUpdateToken in the request must match the PolicyUpdateToken
	// of the current policy version. To get the PolicyUpdateToken of the current
	// policy version, use a GetPolicy request.
	PolicyUpdateToken *string `min:"1" type:"string"`

	// Indicates if the policy should be automatically applied to new resources.
	//
	// RemediationEnabled is a required field
	RemediationEnabled *bool `type:"boolean" required:"true"`

	// An array of ResourceTag objects.
	ResourceTags []*ResourceTag `type:"list"`

	// The type of resource protected by or in scope of the policy. This is in the
	// format shown in the AWS Resource Types Reference (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html).
	// For AWS WAF and Shield Advanced, examples include AWS::ElasticLoadBalancingV2::LoadBalancer
	// and AWS::CloudFront::Distribution. For a security group common policy, valid
	// values are AWS::EC2::NetworkInterface and AWS::EC2::Instance. For a security
	// group content audit policy, valid values are AWS::EC2::SecurityGroup, AWS::EC2::NetworkInterface,
	// and AWS::EC2::Instance. For a security group usage audit policy, the value
	// is AWS::EC2::SecurityGroup.
	//
	// ResourceType is a required field
	ResourceType *string `min:"1" type:"string" required:"true"`

	// An array of ResourceType.
	ResourceTypeList []*string `type:"list"`

	// Details about the security service that is being used to protect the resources.
	//
	// SecurityServicePolicyData is a required field
	SecurityServicePolicyData *SecurityServicePolicyData `type:"structure" required:"true"`
}

// String returns the string representation
func (s Policy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Policy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Policy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Policy"}
	if s.ExcludeResourceTags == nil {
		invalidParams.Add(request.NewErrParamRequired("ExcludeResourceTags"))
	}
	if s.PolicyId != nil && len(*s.PolicyId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyId", 36))
	}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}
	if s.PolicyUpdateToken != nil && len(*s.PolicyUpdateToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyUpdateToken", 1))
	}
	if s.RemediationEnabled == nil {
		invalidParams.Add(request.NewErrParamRequired("RemediationEnabled"))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.ResourceType != nil && len(*s.ResourceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceType", 1))
	}
	if s.SecurityServicePolicyData == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityServicePolicyData"))
	}
	if s.ResourceTags != nil {
		for i, v := range s.ResourceTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceTags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SecurityServicePolicyData != nil {
		if err := s.SecurityServicePolicyData.Validate(); err != nil {
			invalidParams.AddNested("SecurityServicePolicyData", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExcludeMap sets the ExcludeMap field's value.
func (s *Policy) SetExcludeMap(v map[string][]*string) *Policy {
	s.ExcludeMap = v
	return s
}

// SetExcludeResourceTags sets the ExcludeResourceTags field's value.
func (s *Policy) SetExcludeResourceTags(v bool) *Policy {
	s.ExcludeResourceTags = &v
	return s
}

// SetIncludeMap sets the IncludeMap field's value.
func (s *Policy) SetIncludeMap(v map[string][]*string) *Policy {
	s.IncludeMap = v
	return s
}

// SetPolicyId sets the PolicyId field's value.
func (s *Policy) SetPolicyId(v string) *Policy {
	s.PolicyId = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *Policy) SetPolicyName(v string) *Policy {
	s.PolicyName = &v
	return s
}

// SetPolicyUpdateToken sets the PolicyUpdateToken field's value.
func (s *Policy) SetPolicyUpdateToken(v string) *Policy {
	s.PolicyUpdateToken = &v
	return s
}

// SetRemediationEnabled sets the RemediationEnabled field's value.
func (s *Policy) SetRemediationEnabled(v bool) *Policy {
	s.RemediationEnabled = &v
	return s
}

// SetResourceTags sets the ResourceTags field's value.
func (s *Policy) SetResourceTags(v []*ResourceTag) *Policy {
	s.ResourceTags = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *Policy) SetResourceType(v string) *Policy {
	s.ResourceType = &v
	return s
}

// SetResourceTypeList sets the ResourceTypeList field's value.
func (s *Policy) SetResourceTypeList(v []*string) *Policy {
	s.ResourceTypeList = v
	return s
}

// SetSecurityServicePolicyData sets the SecurityServicePolicyData field's value.
func (s *Policy) SetSecurityServicePolicyData(v *SecurityServicePolicyData) *Policy {
	s.SecurityServicePolicyData = v
	return s
}

// Describes the noncompliant resources in a member account for a specific AWS
// Firewall Manager policy. A maximum of 100 entries are displayed. If more
// than 100 resources are noncompliant, EvaluationLimitExceeded is set to True.
type PolicyComplianceDetail struct {
	_ struct{} `type:"structure"`

	// Indicates if over 100 resources are noncompliant with the AWS Firewall Manager
	// policy.
	EvaluationLimitExceeded *bool `type:"boolean"`

	// A timestamp that indicates when the returned information should be considered
	// out of date.
	ExpiredAt *time.Time `type:"timestamp"`

	// Details about problems with dependent services, such as AWS WAF or AWS Config,
	// that are causing a resource to be noncompliant. The details include the name
	// of the dependent service and the error message received that indicates the
	// problem with the service.
	IssueInfoMap map[string]*string `type:"map"`

	// The AWS account ID.
	MemberAccount *string `min:"1" type:"string"`

	// The ID of the AWS Firewall Manager policy.
	PolicyId *string `min:"36" type:"string"`

	// The AWS account that created the AWS Firewall Manager policy.
	PolicyOwner *string `min:"1" type:"string"`

	// An array of resources that aren't protected by the AWS WAF or Shield Advanced
	// policy or that aren't in compliance with the security group policy.
	Violators []*ComplianceViolator `type:"list"`
}

// String returns the string representation
func (s PolicyComplianceDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PolicyComplianceDetail) GoString() string {
	return s.String()
}

// SetEvaluationLimitExceeded sets the EvaluationLimitExceeded field's value.
func (s *PolicyComplianceDetail) SetEvaluationLimitExceeded(v bool) *PolicyComplianceDetail {
	s.EvaluationLimitExceeded = &v
	return s
}

// SetExpiredAt sets the ExpiredAt field's value.
func (s *PolicyComplianceDetail) SetExpiredAt(v time.Time) *PolicyComplianceDetail {
	s.ExpiredAt = &v
	return s
}

// SetIssueInfoMap sets the IssueInfoMap field's value.
func (s *PolicyComplianceDetail) SetIssueInfoMap(v map[string]*string) *PolicyComplianceDetail {
	s.IssueInfoMap = v
	return s
}

// SetMemberAccount sets the MemberAccount field's value.
func (s *PolicyComplianceDetail) SetMemberAccount(v string) *PolicyComplianceDetail {
	s.MemberAccount = &v
	return s
}

// SetPolicyId sets the PolicyId field's value.
func (s *PolicyComplianceDetail) SetPolicyId(v string) *PolicyComplianceDetail {
	s.PolicyId = &v
	return s
}

// SetPolicyOwner sets the PolicyOwner field's value.
func (s *PolicyComplianceDetail) SetPolicyOwner(v string) *PolicyComplianceDetail {
	s.PolicyOwner = &v
	return s
}

// SetViolators sets the Violators field's value.
func (s *PolicyComplianceDetail) SetViolators(v []*ComplianceViolator) *PolicyComplianceDetail {
	s.Violators = v
	return s
}

// Indicates whether the account is compliant with the specified policy. An
// account is considered noncompliant if it includes resources that are not
// protected by the policy, for AWS WAF and Shield Advanced policies, or that
// are noncompliant with the policy, for security group policies.
type PolicyComplianceStatus struct {
	_ struct{} `type:"structure"`

	// An array of EvaluationResult objects.
	EvaluationResults []*EvaluationResult `type:"list"`

	// Details about problems with dependent services, such as AWS WAF or AWS Config,
	// that are causing a resource to be noncompliant. The details include the name
	// of the dependent service and the error message received that indicates the
	// problem with the service.
	IssueInfoMap map[string]*string `type:"map"`

	// Timestamp of the last update to the EvaluationResult objects.
	LastUpdated *time.Time `type:"timestamp"`

	// The member account ID.
	MemberAccount *string `min:"1" type:"string"`

	// The ID of the AWS Firewall Manager policy.
	PolicyId *string `min:"36" type:"string"`

	// The friendly name of the AWS Firewall Manager policy.
	PolicyName *string `min:"1" type:"string"`

	// The AWS account that created the AWS Firewall Manager policy.
	PolicyOwner *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PolicyComplianceStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PolicyComplianceStatus) GoString() string {
	return s.String()
}

// SetEvaluationResults sets the EvaluationResults field's value.
func (s *PolicyComplianceStatus) SetEvaluationResults(v []*EvaluationResult) *PolicyComplianceStatus {
	s.EvaluationResults = v
	return s
}

// SetIssueInfoMap sets the IssueInfoMap field's value.
func (s *PolicyComplianceStatus) SetIssueInfoMap(v map[string]*string) *PolicyComplianceStatus {
	s.IssueInfoMap = v
	return s
}

// SetLastUpdated sets the LastUpdated field's value.
func (s *PolicyComplianceStatus) SetLastUpdated(v time.Time) *PolicyComplianceStatus {
	s.LastUpdated = &v
	return s
}

// SetMemberAccount sets the MemberAccount field's value.
func (s *PolicyComplianceStatus) SetMemberAccount(v string) *PolicyComplianceStatus {
	s.MemberAccount = &v
	return s
}

// SetPolicyId sets the PolicyId field's value.
func (s *PolicyComplianceStatus) SetPolicyId(v string) *PolicyComplianceStatus {
	s.PolicyId = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *PolicyComplianceStatus) SetPolicyName(v string) *PolicyComplianceStatus {
	s.PolicyName = &v
	return s
}

// SetPolicyOwner sets the PolicyOwner field's value.
func (s *PolicyComplianceStatus) SetPolicyOwner(v string) *PolicyComplianceStatus {
	s.PolicyOwner = &v
	return s
}

// Details of the AWS Firewall Manager policy.
type PolicySummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the specified policy.
	PolicyArn *string `min:"1" type:"string"`

	// The ID of the specified policy.
	PolicyId *string `min:"36" type:"string"`

	// The friendly name of the specified policy.
	PolicyName *string `min:"1" type:"string"`

	// Indicates if the policy should be automatically applied to new resources.
	RemediationEnabled *bool `type:"boolean"`

	// The type of resource protected by or in scope of the policy. This is in the
	// format shown in the AWS Resource Types Reference (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html).
	// For AWS WAF and Shield Advanced, examples include AWS::ElasticLoadBalancingV2::LoadBalancer
	// and AWS::CloudFront::Distribution. For a security group common policy, valid
	// values are AWS::EC2::NetworkInterface and AWS::EC2::Instance. For a security
	// group content audit policy, valid values are AWS::EC2::SecurityGroup, AWS::EC2::NetworkInterface,
	// and AWS::EC2::Instance. For a security group usage audit policy, the value
	// is AWS::EC2::SecurityGroup.
	ResourceType *string `min:"1" type:"string"`

	// The service that the policy is using to protect the resources. This specifies
	// the type of policy that is created, either an AWS WAF policy, a Shield Advanced
	// policy, or a security group policy.
	SecurityServiceType *string `type:"string" enum:"SecurityServiceType"`
}

// String returns the string representation
func (s PolicySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PolicySummary) GoString() string {
	return s.String()
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *PolicySummary) SetPolicyArn(v string) *PolicySummary {
	s.PolicyArn = &v
	return s
}

// SetPolicyId sets the PolicyId field's value.
func (s *PolicySummary) SetPolicyId(v string) *PolicySummary {
	s.PolicyId = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *PolicySummary) SetPolicyName(v string) *PolicySummary {
	s.PolicyName = &v
	return s
}

// SetRemediationEnabled sets the RemediationEnabled field's value.
func (s *PolicySummary) SetRemediationEnabled(v bool) *PolicySummary {
	s.RemediationEnabled = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *PolicySummary) SetResourceType(v string) *PolicySummary {
	s.ResourceType = &v
	return s
}

// SetSecurityServiceType sets the SecurityServiceType field's value.
func (s *PolicySummary) SetSecurityServiceType(v string) *PolicySummary {
	s.SecurityServiceType = &v
	return s
}

type PutNotificationChannelInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM role that allows Amazon SNS to
	// record AWS Firewall Manager activity.
	//
	// SnsRoleName is a required field
	SnsRoleName *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the SNS topic that collects notifications
	// from AWS Firewall Manager.
	//
	// SnsTopicArn is a required field
	SnsTopicArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutNotificationChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutNotificationChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutNotificationChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutNotificationChannelInput"}
	if s.SnsRoleName == nil {
		invalidParams.Add(request.NewErrParamRequired("SnsRoleName"))
	}
	if s.SnsRoleName != nil && len(*s.SnsRoleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SnsRoleName", 1))
	}
	if s.SnsTopicArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SnsTopicArn"))
	}
	if s.SnsTopicArn != nil && len(*s.SnsTopicArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SnsTopicArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSnsRoleName sets the SnsRoleName field's value.
func (s *PutNotificationChannelInput) SetSnsRoleName(v string) *PutNotificationChannelInput {
	s.SnsRoleName = &v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *PutNotificationChannelInput) SetSnsTopicArn(v string) *PutNotificationChannelInput {
	s.SnsTopicArn = &v
	return s
}

type PutNotificationChannelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutNotificationChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutNotificationChannelOutput) GoString() string {
	return s.String()
}

type PutPolicyInput struct {
	_ struct{} `type:"structure"`

	// The details of the AWS Firewall Manager policy to be created.
	//
	// Policy is a required field
	Policy *Policy `type:"structure" required:"true"`

	// The tags to add to the AWS resource.
	TagList []*Tag `type:"list"`
}

// String returns the string representation
func (s PutPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutPolicyInput"}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}
	if s.Policy != nil {
		if err := s.Policy.Validate(); err != nil {
			invalidParams.AddNested("Policy", err.(request.ErrInvalidParams))
		}
	}
	if s.TagList != nil {
		for i, v := range s.TagList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicy sets the Policy field's value.
func (s *PutPolicyInput) SetPolicy(v *Policy) *PutPolicyInput {
	s.Policy = v
	return s
}

// SetTagList sets the TagList field's value.
func (s *PutPolicyInput) SetTagList(v []*Tag) *PutPolicyInput {
	s.TagList = v
	return s
}

type PutPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The details of the AWS Firewall Manager policy that was created.
	Policy *Policy `type:"structure"`

	// The Amazon Resource Name (ARN) of the policy that was created.
	PolicyArn *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PutPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *PutPolicyOutput) SetPolicy(v *Policy) *PutPolicyOutput {
	s.Policy = v
	return s
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *PutPolicyOutput) SetPolicyArn(v string) *PutPolicyOutput {
	s.PolicyArn = &v
	return s
}

// The specified resource was not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The resource tags that AWS Firewall Manager uses to determine if a particular
// resource should be included or excluded from the AWS Firewall Manager policy.
// Tags enable you to categorize your AWS resources in different ways, for example,
// by purpose, owner, or environment. Each tag consists of a key and an optional
// value. Firewall Manager combines the tags with "AND" so that, if you add
// more than one tag to a policy scope, a resource must have all the specified
// tags to be included or excluded. For more information, see Working with Tag
// Editor (https://docs.aws.amazon.com/awsconsolehelpdocs/latest/gsg/tag-editor.html).
type ResourceTag struct {
	_ struct{} `type:"structure"`

	// The resource tag key.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The resource tag value.
	Value *string `type:"string"`
}

// String returns the string representation
func (s ResourceTag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceTag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceTag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourceTag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *ResourceTag) SetKey(v string) *ResourceTag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ResourceTag) SetValue(v string) *ResourceTag {
	s.Value = &v
	return s
}

// Details about the security service that is being used to protect the resources.
type SecurityServicePolicyData struct {
	_ struct{} `type:"structure"`

	// Details about the service that are specific to the service type, in JSON
	// format. For service type SHIELD_ADVANCED, this is an empty string.
	//
	//    * Example: WAFV2 "SecurityServicePolicyData": "{ \"type\": \"WAFV2\",
	//    \"postProcessRuleGroups\": [ { \"managedRuleGroupIdentifier\": { \"managedRuleGroupName\":
	//    \"AWSManagedRulesAdminProtectionRuleSet\", \"vendor\": \"AWS\" } \"ruleGroupARN\":
	//    \"rule group arn", \"overrideAction\": { \"type\": \"COUNT|\" }, \"excludedRules\":
	//    [ { \"name\" : \"EntityName\" } ], \"type\": \"ManagedRuleGroup|RuleGroup\"
	//    } ], \"preProcessRuleGroups\": [ { \"managedRuleGroupIdentifier\": { \"managedRuleGroupName\":
	//    \"AWSManagedRulesAdminProtectionRuleSet\", \"vendor\": \"AWS\" } \"ruleGroupARN\":
	//    \"rule group arn\", \"overrideAction\": { \"type\": \"COUNT\" }, \"excludedRules\":
	//    [ { \"name\" : \"EntityName\" } ], \"type\": \"ManagedRuleGroup|RuleGroup\"
	//    } ], \"defaultAction\": { \"type\": \"BLOCK\" }}"
	//
	//    * Example: WAF "ManagedServiceData": "{\"type\": \"WAF\", \"ruleGroups\":
	//    [{\"id\": \"12345678-1bcd-9012-efga-0987654321ab\", \"overrideAction\"
	//    : {\"type\": \"COUNT\"}}], \"defaultAction\": {\"type\": \"BLOCK\"}}
	//
	//    * Example: SECURITY_GROUPS_COMMON "SecurityServicePolicyData":{"Type":"SECURITY_GROUPS_COMMON","ManagedServiceData":"{\"type\":\"SECURITY_GROUPS_COMMON\",\"revertManualSecurityGroupChanges\":false,\"exclusiveResourceSecurityGroupManagement\":false,\"securityGroups\":[{\"id\":\"
	//    sg-000e55995d61a06bd\"}]}"},"RemediationEnabled":false,"ResourceType":"AWS::EC2::NetworkInterface"}
	//
	//    * Example: SECURITY_GROUPS_CONTENT_AUDIT "SecurityServicePolicyData":{"Type":"SECURITY_GROUPS_CONTENT_AUDIT","ManagedServiceData":"{\"type\":\"SECURITY_GROUPS_CONTENT_AUDIT\",\"securityGroups\":[{\"id\":\"
	//    sg-000e55995d61a06bd \"}],\"securityGroupAction\":{\"type\":\"ALLOW\"}}"},"RemediationEnabled":false,"ResourceType":"AWS::EC2::NetworkInterface"}
	//    The security group action for content audit can be ALLOW or DENY. For
	//    ALLOW, all in-scope security group rules must be within the allowed range
	//    of the policy's security group rules. For DENY, all in-scope security
	//    group rules must not contain a value or a range that matches a rule value
	//    or range in the policy security group.
	//
	//    * Example: SECURITY_GROUPS_USAGE_AUDIT "SecurityServicePolicyData":{"Type":"SECURITY_GROUPS_USAGE_AUDIT","ManagedServiceData":"{\"type\":\"SECURITY_GROUPS_USAGE_AUDIT\",\"deleteUnusedSecurityGroups\":true,\"coalesceRedundantSecurityGroups\":true}"},"RemediationEnabled":false,"Resou
	//    rceType":"AWS::EC2::SecurityGroup"}
	ManagedServiceData *string `min:"1" type:"string"`

	// The service that the policy is using to protect the resources. This specifies
	// the type of policy that is created, either an AWS WAF policy, a Shield Advanced
	// policy, or a security group policy. For security group policies, Firewall
	// Manager supports one security group for each common policy and for each content
	// audit policy. This is an adjustable limit that you can increase by contacting
	// AWS Support.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"SecurityServiceType"`
}

// String returns the string representation
func (s SecurityServicePolicyData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SecurityServicePolicyData) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SecurityServicePolicyData) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SecurityServicePolicyData"}
	if s.ManagedServiceData != nil && len(*s.ManagedServiceData) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ManagedServiceData", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetManagedServiceData sets the ManagedServiceData field's value.
func (s *SecurityServicePolicyData) SetManagedServiceData(v string) *SecurityServicePolicyData {
	s.ManagedServiceData = &v
	return s
}

// SetType sets the Type field's value.
func (s *SecurityServicePolicyData) SetType(v string) *SecurityServicePolicyData {
	s.Type = &v
	return s
}

// A collection of key:value pairs associated with an AWS resource. The key:value
// pair can be anything you define. Typically, the tag key represents a category
// (such as "environment") and the tag value represents a specific value within
// that category (such as "test," "development," or "production"). You can add
// up to 50 tags to each AWS resource.
type Tag struct {
	_ struct{} `type:"structure"`

	// Part of the key:value pair that defines a tag. You can use a tag key to describe
	// a category of information, such as "customer." Tag keys are case-sensitive.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// Part of the key:value pair that defines a tag. You can use a tag value to
	// describe a specific value within a category, such as "companyA" or "companyB."
	// Tag values are case-sensitive.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource. The Firewall Manager policy
	// is the only AWS resource that supports tagging, so this ARN is a policy ARN.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`

	// The tags to add to the resource.
	//
	// TagList is a required field
	TagList []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagList == nil {
		invalidParams.Add(request.NewErrParamRequired("TagList"))
	}
	if s.TagList != nil {
		for i, v := range s.TagList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagList sets the TagList field's value.
func (s *TagResourceInput) SetTagList(v []*Tag) *TagResourceInput {
	s.TagList = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource. The Firewall Manager policy
	// is the only AWS resource that supports tagging, so this ARN is a policy ARN.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`

	// The keys of the tags to remove from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

const (
	// AccountRoleStatusReady is a AccountRoleStatus enum value
	AccountRoleStatusReady = "READY"

	// AccountRoleStatusCreating is a AccountRoleStatus enum value
	AccountRoleStatusCreating = "CREATING"

	// AccountRoleStatusPendingDeletion is a AccountRoleStatus enum value
	AccountRoleStatusPendingDeletion = "PENDING_DELETION"

	// AccountRoleStatusDeleting is a AccountRoleStatus enum value
	AccountRoleStatusDeleting = "DELETING"

	// AccountRoleStatusDeleted is a AccountRoleStatus enum value
	AccountRoleStatusDeleted = "DELETED"
)

const (
	// CustomerPolicyScopeIdTypeAccount is a CustomerPolicyScopeIdType enum value
	CustomerPolicyScopeIdTypeAccount = "ACCOUNT"
)

const (
	// DependentServiceNameAwsconfig is a DependentServiceName enum value
	DependentServiceNameAwsconfig = "AWSCONFIG"

	// DependentServiceNameAwswaf is a DependentServiceName enum value
	DependentServiceNameAwswaf = "AWSWAF"

	// DependentServiceNameAwsshieldAdvanced is a DependentServiceName enum value
	DependentServiceNameAwsshieldAdvanced = "AWSSHIELD_ADVANCED"

	// DependentServiceNameAwsvpc is a DependentServiceName enum value
	DependentServiceNameAwsvpc = "AWSVPC"
)

const (
	// PolicyComplianceStatusTypeCompliant is a PolicyComplianceStatusType enum value
	PolicyComplianceStatusTypeCompliant = "COMPLIANT"

	// PolicyComplianceStatusTypeNonCompliant is a PolicyComplianceStatusType enum value
	PolicyComplianceStatusTypeNonCompliant = "NON_COMPLIANT"
)

const (
	// SecurityServiceTypeWaf is a SecurityServiceType enum value
	SecurityServiceTypeWaf = "WAF"

	// SecurityServiceTypeWafv2 is a SecurityServiceType enum value
	SecurityServiceTypeWafv2 = "WAFV2"

	// SecurityServiceTypeShieldAdvanced is a SecurityServiceType enum value
	SecurityServiceTypeShieldAdvanced = "SHIELD_ADVANCED"

	// SecurityServiceTypeSecurityGroupsCommon is a SecurityServiceType enum value
	SecurityServiceTypeSecurityGroupsCommon = "SECURITY_GROUPS_COMMON"

	// SecurityServiceTypeSecurityGroupsContentAudit is a SecurityServiceType enum value
	SecurityServiceTypeSecurityGroupsContentAudit = "SECURITY_GROUPS_CONTENT_AUDIT"

	// SecurityServiceTypeSecurityGroupsUsageAudit is a SecurityServiceType enum value
	SecurityServiceTypeSecurityGroupsUsageAudit = "SECURITY_GROUPS_USAGE_AUDIT"
)

const (
	// ViolationReasonWebAclMissingRuleGroup is a ViolationReason enum value
	ViolationReasonWebAclMissingRuleGroup = "WEB_ACL_MISSING_RULE_GROUP"

	// ViolationReasonResourceMissingWebAcl is a ViolationReason enum value
	ViolationReasonResourceMissingWebAcl = "RESOURCE_MISSING_WEB_ACL"

	// ViolationReasonResourceIncorrectWebAcl is a ViolationReason enum value
	ViolationReasonResourceIncorrectWebAcl = "RESOURCE_INCORRECT_WEB_ACL"

	// ViolationReasonResourceMissingShieldProtection is a ViolationReason enum value
	ViolationReasonResourceMissingShieldProtection = "RESOURCE_MISSING_SHIELD_PROTECTION"

	// ViolationReasonResourceMissingWebAclOrShieldProtection is a ViolationReason enum value
	ViolationReasonResourceMissingWebAclOrShieldProtection = "RESOURCE_MISSING_WEB_ACL_OR_SHIELD_PROTECTION"

	// ViolationReasonResourceMissingSecurityGroup is a ViolationReason enum value
	ViolationReasonResourceMissingSecurityGroup = "RESOURCE_MISSING_SECURITY_GROUP"

	// ViolationReasonResourceViolatesAuditSecurityGroup is a ViolationReason enum value
	ViolationReasonResourceViolatesAuditSecurityGroup = "RESOURCE_VIOLATES_AUDIT_SECURITY_GROUP"

	// ViolationReasonSecurityGroupUnused is a ViolationReason enum value
	ViolationReasonSecurityGroupUnused = "SECURITY_GROUP_UNUSED"

	// ViolationReasonSecurityGroupRedundant is a ViolationReason enum value
	ViolationReasonSecurityGroupRedundant = "SECURITY_GROUP_REDUNDANT"
)
