package avs

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/avs/mgmt/2020-03-20/avs"

// AdminCredentials administrative credentials for accessing vCenter and NSX-T
type AdminCredentials struct {
	autorest.Response `json:"-"`
	// NsxtUsername - READ-ONLY; NSX-T Manager username
	NsxtUsername *string `json:"nsxtUsername,omitempty"`
	// NsxtPassword - READ-ONLY; NSX-T Manager password
	NsxtPassword *string `json:"nsxtPassword,omitempty"`
	// VcenterUsername - READ-ONLY; vCenter admin username
	VcenterUsername *string `json:"vcenterUsername,omitempty"`
	// VcenterPassword - READ-ONLY; vCenter admin password
	VcenterPassword *string `json:"vcenterPassword,omitempty"`
}

// AuthorizationsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AuthorizationsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AuthorizationsClient) (ExpressRouteAuthorization, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AuthorizationsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AuthorizationsCreateOrUpdateFuture.Result.
func (future *AuthorizationsCreateOrUpdateFuture) result(client AuthorizationsClient) (era ExpressRouteAuthorization, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.AuthorizationsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("avs.AuthorizationsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if era.Response.Response, err = future.GetResult(sender); err == nil && era.Response.Response.StatusCode != http.StatusNoContent {
		era, err = client.CreateOrUpdateResponder(era.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "avs.AuthorizationsCreateOrUpdateFuture", "Result", era.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AuthorizationsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AuthorizationsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AuthorizationsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AuthorizationsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AuthorizationsDeleteFuture.Result.
func (future *AuthorizationsDeleteFuture) result(client AuthorizationsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.AuthorizationsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("avs.AuthorizationsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// Circuit an ExpressRoute Circuit
type Circuit struct {
	// PrimarySubnet - READ-ONLY; CIDR of primary subnet
	PrimarySubnet *string `json:"primarySubnet,omitempty"`
	// SecondarySubnet - READ-ONLY; CIDR of secondary subnet
	SecondarySubnet *string `json:"secondarySubnet,omitempty"`
	// ExpressRouteID - READ-ONLY; Identifier of the ExpressRoute Circuit (Microsoft Colo only)
	ExpressRouteID *string `json:"expressRouteID,omitempty"`
	// ExpressRoutePrivatePeeringID - READ-ONLY; ExpressRoute Circuit private peering identifier
	ExpressRoutePrivatePeeringID *string `json:"expressRoutePrivatePeeringID,omitempty"`
}

// CloudError API error response
type CloudError struct {
	// Error - An error returned by the API
	Error *ErrorResponse `json:"error,omitempty"`
}

// Cluster a cluster resource
type Cluster struct {
	autorest.Response `json:"-"`
	// Sku - The cluster SKU
	Sku *Sku `json:"sku,omitempty"`
	// ClusterProperties - The properties of a cluster resource
	*ClusterProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Cluster.
func (c Cluster) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.Sku != nil {
		objectMap["sku"] = c.Sku
	}
	if c.ClusterProperties != nil {
		objectMap["properties"] = c.ClusterProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Cluster struct.
func (c *Cluster) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				c.Sku = &sku
			}
		case "properties":
			if v != nil {
				var clusterProperties ClusterProperties
				err = json.Unmarshal(*v, &clusterProperties)
				if err != nil {
					return err
				}
				c.ClusterProperties = &clusterProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		}
	}

	return nil
}

// ClusterList a paged list of clusters
type ClusterList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The items on a page
	Value *[]Cluster `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty"`
}

// ClusterListIterator provides access to a complete listing of Cluster values.
type ClusterListIterator struct {
	i    int
	page ClusterListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ClusterListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ClusterListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ClusterListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ClusterListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ClusterListIterator) Response() ClusterList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ClusterListIterator) Value() Cluster {
	if !iter.page.NotDone() {
		return Cluster{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ClusterListIterator type.
func NewClusterListIterator(page ClusterListPage) ClusterListIterator {
	return ClusterListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cl ClusterList) IsEmpty() bool {
	return cl.Value == nil || len(*cl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cl ClusterList) hasNextLink() bool {
	return cl.NextLink != nil && len(*cl.NextLink) != 0
}

// clusterListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cl ClusterList) clusterListPreparer(ctx context.Context) (*http.Request, error) {
	if !cl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cl.NextLink)))
}

// ClusterListPage contains a page of Cluster values.
type ClusterListPage struct {
	fn func(context.Context, ClusterList) (ClusterList, error)
	cl ClusterList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ClusterListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ClusterListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cl)
		if err != nil {
			return err
		}
		page.cl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ClusterListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ClusterListPage) NotDone() bool {
	return !page.cl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ClusterListPage) Response() ClusterList {
	return page.cl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ClusterListPage) Values() []Cluster {
	if page.cl.IsEmpty() {
		return nil
	}
	return *page.cl.Value
}

// Creates a new instance of the ClusterListPage type.
func NewClusterListPage(cur ClusterList, getNextPage func(context.Context, ClusterList) (ClusterList, error)) ClusterListPage {
	return ClusterListPage{
		fn: getNextPage,
		cl: cur,
	}
}

// ClusterProperties the properties of a cluster
type ClusterProperties struct {
	// ProvisioningState - The state of the cluster provisioning. Possible values include: 'Succeeded', 'Failed', 'Cancelled', 'Deleting', 'Updating'
	ProvisioningState ClusterProvisioningState `json:"provisioningState,omitempty"`
	// ClusterID - READ-ONLY; The identity
	ClusterID *int32 `json:"clusterId,omitempty"`
	// Hosts - READ-ONLY; The hosts
	Hosts *[]string `json:"hosts,omitempty"`
	// ClusterSize - The cluster size
	ClusterSize *int32 `json:"clusterSize,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterProperties.
func (cp ClusterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.ProvisioningState != "" {
		objectMap["provisioningState"] = cp.ProvisioningState
	}
	if cp.ClusterSize != nil {
		objectMap["clusterSize"] = cp.ClusterSize
	}
	return json.Marshal(objectMap)
}

// ClustersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (Cluster, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersCreateOrUpdateFuture.Result.
func (future *ClustersCreateOrUpdateFuture) result(client ClustersClient) (c Cluster, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.ClustersCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("avs.ClustersCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if c.Response.Response, err = future.GetResult(sender); err == nil && c.Response.Response.StatusCode != http.StatusNoContent {
		c, err = client.CreateOrUpdateResponder(c.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "avs.ClustersCreateOrUpdateFuture", "Result", c.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ClustersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersDeleteFuture.Result.
func (future *ClustersDeleteFuture) result(client ClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.ClustersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("avs.ClustersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ClustersUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (Cluster, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersUpdateFuture.Result.
func (future *ClustersUpdateFuture) result(client ClustersClient) (c Cluster, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.ClustersUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("avs.ClustersUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if c.Response.Response, err = future.GetResult(sender); err == nil && c.Response.Response.StatusCode != http.StatusNoContent {
		c, err = client.UpdateResponder(c.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "avs.ClustersUpdateFuture", "Result", c.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ClusterUpdate an update of a cluster resource
type ClusterUpdate struct {
	// ClusterUpdateProperties - The properties of a cluster resource that may be updated
	*ClusterUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterUpdate.
func (cu ClusterUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cu.ClusterUpdateProperties != nil {
		objectMap["properties"] = cu.ClusterUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ClusterUpdate struct.
func (cu *ClusterUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var clusterUpdateProperties ClusterUpdateProperties
				err = json.Unmarshal(*v, &clusterUpdateProperties)
				if err != nil {
					return err
				}
				cu.ClusterUpdateProperties = &clusterUpdateProperties
			}
		}
	}

	return nil
}

// ClusterUpdateProperties the properties of a cluster that may be updated
type ClusterUpdateProperties struct {
	// ClusterSize - The cluster size
	ClusterSize *int32 `json:"clusterSize,omitempty"`
}

// Endpoints endpoint addresses
type Endpoints struct {
	// NsxtManager - READ-ONLY; Endpoint for the NSX-T Data Center manager
	NsxtManager *string `json:"nsxtManager,omitempty"`
	// Vcsa - READ-ONLY; Endpoint for Virtual Center Server Appliance
	Vcsa *string `json:"vcsa,omitempty"`
	// HcxCloudManager - READ-ONLY; Endpoint for the HCX Cloud Manager
	HcxCloudManager *string `json:"hcxCloudManager,omitempty"`
}

// ErrorAdditionalInfo the resource management error additional info.
type ErrorAdditionalInfo struct {
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
}

// ErrorResponse common error response for all Azure Resource Manager APIs to return error details for
// failed operations. (This also follows the OData error response format.)
type ErrorResponse struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]ErrorResponse `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
}

// ExpressRouteAuthorization expressRoute Circuit Authorization
type ExpressRouteAuthorization struct {
	autorest.Response `json:"-"`
	// ExpressRouteAuthorizationProperties - READ-ONLY; The properties of an ExpressRoute Circuit Authorization resource
	*ExpressRouteAuthorizationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteAuthorization.
func (era ExpressRouteAuthorization) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExpressRouteAuthorization struct.
func (era *ExpressRouteAuthorization) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var expressRouteAuthorizationProperties ExpressRouteAuthorizationProperties
				err = json.Unmarshal(*v, &expressRouteAuthorizationProperties)
				if err != nil {
					return err
				}
				era.ExpressRouteAuthorizationProperties = &expressRouteAuthorizationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				era.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				era.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				era.Type = &typeVar
			}
		}
	}

	return nil
}

// ExpressRouteAuthorizationList a paged list of ExpressRoute Circuit Authorizations
type ExpressRouteAuthorizationList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The items on a page
	Value *[]ExpressRouteAuthorization `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty"`
}

// ExpressRouteAuthorizationListIterator provides access to a complete listing of ExpressRouteAuthorization
// values.
type ExpressRouteAuthorizationListIterator struct {
	i    int
	page ExpressRouteAuthorizationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExpressRouteAuthorizationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteAuthorizationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExpressRouteAuthorizationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExpressRouteAuthorizationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExpressRouteAuthorizationListIterator) Response() ExpressRouteAuthorizationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExpressRouteAuthorizationListIterator) Value() ExpressRouteAuthorization {
	if !iter.page.NotDone() {
		return ExpressRouteAuthorization{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExpressRouteAuthorizationListIterator type.
func NewExpressRouteAuthorizationListIterator(page ExpressRouteAuthorizationListPage) ExpressRouteAuthorizationListIterator {
	return ExpressRouteAuthorizationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (eral ExpressRouteAuthorizationList) IsEmpty() bool {
	return eral.Value == nil || len(*eral.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (eral ExpressRouteAuthorizationList) hasNextLink() bool {
	return eral.NextLink != nil && len(*eral.NextLink) != 0
}

// expressRouteAuthorizationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (eral ExpressRouteAuthorizationList) expressRouteAuthorizationListPreparer(ctx context.Context) (*http.Request, error) {
	if !eral.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(eral.NextLink)))
}

// ExpressRouteAuthorizationListPage contains a page of ExpressRouteAuthorization values.
type ExpressRouteAuthorizationListPage struct {
	fn   func(context.Context, ExpressRouteAuthorizationList) (ExpressRouteAuthorizationList, error)
	eral ExpressRouteAuthorizationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExpressRouteAuthorizationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteAuthorizationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.eral)
		if err != nil {
			return err
		}
		page.eral = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExpressRouteAuthorizationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExpressRouteAuthorizationListPage) NotDone() bool {
	return !page.eral.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExpressRouteAuthorizationListPage) Response() ExpressRouteAuthorizationList {
	return page.eral
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExpressRouteAuthorizationListPage) Values() []ExpressRouteAuthorization {
	if page.eral.IsEmpty() {
		return nil
	}
	return *page.eral.Value
}

// Creates a new instance of the ExpressRouteAuthorizationListPage type.
func NewExpressRouteAuthorizationListPage(cur ExpressRouteAuthorizationList, getNextPage func(context.Context, ExpressRouteAuthorizationList) (ExpressRouteAuthorizationList, error)) ExpressRouteAuthorizationListPage {
	return ExpressRouteAuthorizationListPage{
		fn:   getNextPage,
		eral: cur,
	}
}

// ExpressRouteAuthorizationProperties the properties of an ExpressRoute Circuit Authorization resource
type ExpressRouteAuthorizationProperties struct {
	// ProvisioningState - READ-ONLY; The state of the  ExpressRoute Circuit Authorization provisioning. Possible values include: 'ExpressRouteAuthorizationProvisioningStateSucceeded', 'ExpressRouteAuthorizationProvisioningStateFailed', 'ExpressRouteAuthorizationProvisioningStateUpdating'
	ProvisioningState ExpressRouteAuthorizationProvisioningState `json:"provisioningState,omitempty"`
	// ExpressRouteAuthorizationID - READ-ONLY; The ID of the ExpressRoute Circuit Authorization
	ExpressRouteAuthorizationID *string `json:"expressRouteAuthorizationId,omitempty"`
	// ExpressRouteAuthorizationKey - READ-ONLY; The key of the ExpressRoute Circuit Authorization
	ExpressRouteAuthorizationKey *string `json:"expressRouteAuthorizationKey,omitempty"`
}

// HcxEnterpriseSite an HCX Enterprise Site resource
type HcxEnterpriseSite struct {
	autorest.Response `json:"-"`
	// HcxEnterpriseSiteProperties - READ-ONLY; The properties of an HCX Enterprise Site resource
	*HcxEnterpriseSiteProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for HcxEnterpriseSite.
func (hes HcxEnterpriseSite) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for HcxEnterpriseSite struct.
func (hes *HcxEnterpriseSite) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var hcxEnterpriseSiteProperties HcxEnterpriseSiteProperties
				err = json.Unmarshal(*v, &hcxEnterpriseSiteProperties)
				if err != nil {
					return err
				}
				hes.HcxEnterpriseSiteProperties = &hcxEnterpriseSiteProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				hes.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				hes.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				hes.Type = &typeVar
			}
		}
	}

	return nil
}

// HcxEnterpriseSiteList a paged list of HCX Enterprise Sites
type HcxEnterpriseSiteList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The items on a page
	Value *[]HcxEnterpriseSite `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty"`
}

// HcxEnterpriseSiteListIterator provides access to a complete listing of HcxEnterpriseSite values.
type HcxEnterpriseSiteListIterator struct {
	i    int
	page HcxEnterpriseSiteListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *HcxEnterpriseSiteListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HcxEnterpriseSiteListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *HcxEnterpriseSiteListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter HcxEnterpriseSiteListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter HcxEnterpriseSiteListIterator) Response() HcxEnterpriseSiteList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter HcxEnterpriseSiteListIterator) Value() HcxEnterpriseSite {
	if !iter.page.NotDone() {
		return HcxEnterpriseSite{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the HcxEnterpriseSiteListIterator type.
func NewHcxEnterpriseSiteListIterator(page HcxEnterpriseSiteListPage) HcxEnterpriseSiteListIterator {
	return HcxEnterpriseSiteListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (hesl HcxEnterpriseSiteList) IsEmpty() bool {
	return hesl.Value == nil || len(*hesl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (hesl HcxEnterpriseSiteList) hasNextLink() bool {
	return hesl.NextLink != nil && len(*hesl.NextLink) != 0
}

// hcxEnterpriseSiteListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (hesl HcxEnterpriseSiteList) hcxEnterpriseSiteListPreparer(ctx context.Context) (*http.Request, error) {
	if !hesl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(hesl.NextLink)))
}

// HcxEnterpriseSiteListPage contains a page of HcxEnterpriseSite values.
type HcxEnterpriseSiteListPage struct {
	fn   func(context.Context, HcxEnterpriseSiteList) (HcxEnterpriseSiteList, error)
	hesl HcxEnterpriseSiteList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *HcxEnterpriseSiteListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HcxEnterpriseSiteListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.hesl)
		if err != nil {
			return err
		}
		page.hesl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *HcxEnterpriseSiteListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page HcxEnterpriseSiteListPage) NotDone() bool {
	return !page.hesl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page HcxEnterpriseSiteListPage) Response() HcxEnterpriseSiteList {
	return page.hesl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page HcxEnterpriseSiteListPage) Values() []HcxEnterpriseSite {
	if page.hesl.IsEmpty() {
		return nil
	}
	return *page.hesl.Value
}

// Creates a new instance of the HcxEnterpriseSiteListPage type.
func NewHcxEnterpriseSiteListPage(cur HcxEnterpriseSiteList, getNextPage func(context.Context, HcxEnterpriseSiteList) (HcxEnterpriseSiteList, error)) HcxEnterpriseSiteListPage {
	return HcxEnterpriseSiteListPage{
		fn:   getNextPage,
		hesl: cur,
	}
}

// HcxEnterpriseSiteProperties the properties of an HCX Enterprise Site
type HcxEnterpriseSiteProperties struct {
	// ActivationKey - READ-ONLY; The activation key
	ActivationKey *string `json:"activationKey,omitempty"`
	// Status - READ-ONLY; The status of the HCX Enterprise Site. Possible values include: 'Available', 'Consumed', 'Deactivated', 'Deleted'
	Status HcxEnterpriseSiteStatus `json:"status,omitempty"`
}

// IdentitySource vCenter Single Sign On Identity Source
type IdentitySource struct {
	// Name - The name of the identity source
	Name *string `json:"name,omitempty"`
	// Alias - The domain's NetBIOS name
	Alias *string `json:"alias,omitempty"`
	// Domain - The domain's dns name
	Domain *string `json:"domain,omitempty"`
	// BaseUserDN - The base distinguished name for users
	BaseUserDN *string `json:"baseUserDN,omitempty"`
	// BaseGroupDN - The base distinguished name for groups
	BaseGroupDN *string `json:"baseGroupDN,omitempty"`
	// PrimaryServer - Primary server URL
	PrimaryServer *string `json:"primaryServer,omitempty"`
	// SecondaryServer - Secondary server URL
	SecondaryServer *string `json:"secondaryServer,omitempty"`
	// Ssl - Protect LDAP communication using SSL certificate (LDAPS). Possible values include: 'SslEnumEnabled', 'SslEnumDisabled'
	Ssl SslEnum `json:"ssl,omitempty"`
	// Username - The ID of an Active Directory user with a minimum of read-only access to Base DN for users and group
	Username *string `json:"username,omitempty"`
	// Password - The password of the Active Directory user with a minimum of read-only access to Base DN for users and groups.
	Password *string `json:"password,omitempty"`
}

// LogSpecification specifications of the Log for Azure Monitoring
type LogSpecification struct {
	// Name - Name of the log
	Name *string `json:"name,omitempty"`
	// DisplayName - Localized friendly display name of the log
	DisplayName *string `json:"displayName,omitempty"`
	// BlobDuration - Blob duration of the log
	BlobDuration *string `json:"blobDuration,omitempty"`
}

// ManagementCluster the properties of a default cluster
type ManagementCluster struct {
	// ProvisioningState - The state of the cluster provisioning. Possible values include: 'Succeeded', 'Failed', 'Cancelled', 'Deleting', 'Updating'
	ProvisioningState ClusterProvisioningState `json:"provisioningState,omitempty"`
	// ClusterID - READ-ONLY; The identity
	ClusterID *int32 `json:"clusterId,omitempty"`
	// Hosts - READ-ONLY; The hosts
	Hosts *[]string `json:"hosts,omitempty"`
	// ClusterSize - The cluster size
	ClusterSize *int32 `json:"clusterSize,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagementCluster.
func (mc ManagementCluster) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mc.ProvisioningState != "" {
		objectMap["provisioningState"] = mc.ProvisioningState
	}
	if mc.ClusterSize != nil {
		objectMap["clusterSize"] = mc.ClusterSize
	}
	return json.Marshal(objectMap)
}

// MetricDimension specifications of the Dimension of metrics
type MetricDimension struct {
	// Name - Name of the dimension
	Name *string `json:"name,omitempty"`
	// DisplayName - Localized friendly display name of the dimension
	DisplayName *string `json:"displayName,omitempty"`
}

// MetricSpecification specifications of the Metrics for Azure Monitoring
type MetricSpecification struct {
	// Name - Name of the metric
	Name *string `json:"name,omitempty"`
	// DisplayName - Localized friendly display name of the metric
	DisplayName *string `json:"displayName,omitempty"`
	// DisplayDescription - Localized friendly description of the metric
	DisplayDescription *string `json:"displayDescription,omitempty"`
	// Unit - Unit that makes sense for the metric
	Unit *string `json:"unit,omitempty"`
	// Category - Name of the metric category that the metric belongs to. A metric can only belong to a single category.
	Category *string `json:"category,omitempty"`
	// AggregationType - Only provide one value for this field. Valid values: Average, Minimum, Maximum, Total, Count.
	AggregationType *string `json:"aggregationType,omitempty"`
	// SupportedAggregationTypes - Supported aggregation types
	SupportedAggregationTypes *[]string `json:"supportedAggregationTypes,omitempty"`
	// SupportedTimeGrainTypes - Supported time grain types
	SupportedTimeGrainTypes *[]string `json:"supportedTimeGrainTypes,omitempty"`
	// FillGapWithZero - Optional. If set to true, then zero will be returned for time duration where no metric is emitted/published.
	FillGapWithZero *bool `json:"fillGapWithZero,omitempty"`
	// Dimensions - Dimensions of the metric
	Dimensions *[]MetricDimension `json:"dimensions,omitempty"`
	// EnableRegionalMdmAccount - Whether or not the service is using regional MDM accounts.
	EnableRegionalMdmAccount *string `json:"enableRegionalMdmAccount,omitempty"`
	// SourceMdmAccount - The name of the MDM account.
	SourceMdmAccount *string `json:"sourceMdmAccount,omitempty"`
	// SourceMdmNamespace - The name of the MDM namespace.
	SourceMdmNamespace *string `json:"sourceMdmNamespace,omitempty"`
}

// Operation a REST API operation
type Operation struct {
	// Name - READ-ONLY; Name of the operation being performed on this object
	Name *string `json:"name,omitempty"`
	// Display - READ-ONLY; Contains the localized display information for this operation
	Display *OperationDisplay `json:"display,omitempty"`
	// IsDataAction - Gets or sets a value indicating whether the operation is a data action or not
	IsDataAction *bool `json:"isDataAction,omitempty"`
	// Origin - Origin of the operation
	Origin *string `json:"origin,omitempty"`
	// Properties - Properties of the operation
	Properties *OperationProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.IsDataAction != nil {
		objectMap["isDataAction"] = o.IsDataAction
	}
	if o.Origin != nil {
		objectMap["origin"] = o.Origin
	}
	if o.Properties != nil {
		objectMap["properties"] = o.Properties
	}
	return json.Marshal(objectMap)
}

// OperationDisplay contains the localized display information for this operation
type OperationDisplay struct {
	// Provider - READ-ONLY; Localized friendly form of the resource provider name
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; Localized friendly form of the resource type related to this operation
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; Localized friendly name for the operation
	Operation *string `json:"operation,omitempty"`
	// Description - READ-ONLY; Localized friendly description for the operation
	Description *string `json:"description,omitempty"`
}

// OperationList pageable list of operations
type OperationList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of operations
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListIterator provides access to a complete listing of Operation values.
type OperationListIterator struct {
	i    int
	page OperationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListIterator) Response() OperationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListIterator type.
func NewOperationListIterator(page OperationListPage) OperationListIterator {
	return OperationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ol OperationList) IsEmpty() bool {
	return ol.Value == nil || len(*ol.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ol OperationList) hasNextLink() bool {
	return ol.NextLink != nil && len(*ol.NextLink) != 0
}

// operationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ol OperationList) operationListPreparer(ctx context.Context) (*http.Request, error) {
	if !ol.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ol.NextLink)))
}

// OperationListPage contains a page of Operation values.
type OperationListPage struct {
	fn func(context.Context, OperationList) (OperationList, error)
	ol OperationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ol)
		if err != nil {
			return err
		}
		page.ol = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListPage) NotDone() bool {
	return !page.ol.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListPage) Response() OperationList {
	return page.ol
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListPage) Values() []Operation {
	if page.ol.IsEmpty() {
		return nil
	}
	return *page.ol.Value
}

// Creates a new instance of the OperationListPage type.
func NewOperationListPage(cur OperationList, getNextPage func(context.Context, OperationList) (OperationList, error)) OperationListPage {
	return OperationListPage{
		fn: getNextPage,
		ol: cur,
	}
}

// OperationProperties extra Operation properties
type OperationProperties struct {
	// ServiceSpecification - Service specifications of the operation
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// PrivateCloud a private cloud resource
type PrivateCloud struct {
	autorest.Response `json:"-"`
	// Sku - The private cloud SKU
	Sku *Sku `json:"sku,omitempty"`
	// PrivateCloudProperties - The properties of a private cloud resource
	*PrivateCloudProperties `json:"properties,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateCloud.
func (pc PrivateCloud) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pc.Sku != nil {
		objectMap["sku"] = pc.Sku
	}
	if pc.PrivateCloudProperties != nil {
		objectMap["properties"] = pc.PrivateCloudProperties
	}
	if pc.Location != nil {
		objectMap["location"] = pc.Location
	}
	if pc.Tags != nil {
		objectMap["tags"] = pc.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateCloud struct.
func (pc *PrivateCloud) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				pc.Sku = &sku
			}
		case "properties":
			if v != nil {
				var privateCloudProperties PrivateCloudProperties
				err = json.Unmarshal(*v, &privateCloudProperties)
				if err != nil {
					return err
				}
				pc.PrivateCloudProperties = &privateCloudProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				pc.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				pc.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pc.Type = &typeVar
			}
		}
	}

	return nil
}

// PrivateCloudList a paged list of private clouds
type PrivateCloudList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The items on the page
	Value *[]PrivateCloud `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty"`
}

// PrivateCloudListIterator provides access to a complete listing of PrivateCloud values.
type PrivateCloudListIterator struct {
	i    int
	page PrivateCloudListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PrivateCloudListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateCloudListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PrivateCloudListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PrivateCloudListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PrivateCloudListIterator) Response() PrivateCloudList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PrivateCloudListIterator) Value() PrivateCloud {
	if !iter.page.NotDone() {
		return PrivateCloud{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PrivateCloudListIterator type.
func NewPrivateCloudListIterator(page PrivateCloudListPage) PrivateCloudListIterator {
	return PrivateCloudListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pcl PrivateCloudList) IsEmpty() bool {
	return pcl.Value == nil || len(*pcl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pcl PrivateCloudList) hasNextLink() bool {
	return pcl.NextLink != nil && len(*pcl.NextLink) != 0
}

// privateCloudListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pcl PrivateCloudList) privateCloudListPreparer(ctx context.Context) (*http.Request, error) {
	if !pcl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pcl.NextLink)))
}

// PrivateCloudListPage contains a page of PrivateCloud values.
type PrivateCloudListPage struct {
	fn  func(context.Context, PrivateCloudList) (PrivateCloudList, error)
	pcl PrivateCloudList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PrivateCloudListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateCloudListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pcl)
		if err != nil {
			return err
		}
		page.pcl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PrivateCloudListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PrivateCloudListPage) NotDone() bool {
	return !page.pcl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PrivateCloudListPage) Response() PrivateCloudList {
	return page.pcl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PrivateCloudListPage) Values() []PrivateCloud {
	if page.pcl.IsEmpty() {
		return nil
	}
	return *page.pcl.Value
}

// Creates a new instance of the PrivateCloudListPage type.
func NewPrivateCloudListPage(cur PrivateCloudList, getNextPage func(context.Context, PrivateCloudList) (PrivateCloudList, error)) PrivateCloudListPage {
	return PrivateCloudListPage{
		fn:  getNextPage,
		pcl: cur,
	}
}

// PrivateCloudProperties the properties of a private cloud resource
type PrivateCloudProperties struct {
	// ProvisioningState - READ-ONLY; The provisioning state. Possible values include: 'PrivateCloudProvisioningStateSucceeded', 'PrivateCloudProvisioningStateFailed', 'PrivateCloudProvisioningStateCancelled', 'PrivateCloudProvisioningStatePending', 'PrivateCloudProvisioningStateBuilding', 'PrivateCloudProvisioningStateDeleting', 'PrivateCloudProvisioningStateUpdating'
	ProvisioningState PrivateCloudProvisioningState `json:"provisioningState,omitempty"`
	// Circuit - An ExpressRoute Circuit
	Circuit *Circuit `json:"circuit,omitempty"`
	// Endpoints - READ-ONLY; The endpoints
	Endpoints *Endpoints `json:"endpoints,omitempty"`
	// NetworkBlock - The block of addresses should be unique across VNet in your subscription as well as on-premise. Make sure the CIDR format is conformed to (A.B.C.D/X) where A,B,C,D are between 0 and 255, and X is between 0 and 22
	NetworkBlock *string `json:"networkBlock,omitempty"`
	// ManagementNetwork - READ-ONLY; Network used to access vCenter Server and NSX-T Manager
	ManagementNetwork *string `json:"managementNetwork,omitempty"`
	// ProvisioningNetwork - READ-ONLY; Used for virtual machine cold migration, cloning, and snapshot migration
	ProvisioningNetwork *string `json:"provisioningNetwork,omitempty"`
	// VmotionNetwork - READ-ONLY; Used for live migration of virtual machines
	VmotionNetwork *string `json:"vmotionNetwork,omitempty"`
	// VcenterPassword - Optionally, set the vCenter admin password when the private cloud is created
	VcenterPassword *string `json:"vcenterPassword,omitempty"`
	// NsxtPassword - Optionally, set the NSX-T Manager password when the private cloud is created
	NsxtPassword *string `json:"nsxtPassword,omitempty"`
	// VcenterCertificateThumbprint - READ-ONLY; Thumbprint of the vCenter Server SSL certificate
	VcenterCertificateThumbprint *string `json:"vcenterCertificateThumbprint,omitempty"`
	// NsxtCertificateThumbprint - READ-ONLY; Thumbprint of the NSX-T Manager SSL certificate
	NsxtCertificateThumbprint *string `json:"nsxtCertificateThumbprint,omitempty"`
	// ManagementCluster - The default cluster used for management
	ManagementCluster *ManagementCluster `json:"managementCluster,omitempty"`
	// Internet - Connectivity to internet is enabled or disabled. Possible values include: 'Enabled', 'Disabled'
	Internet InternetEnum `json:"internet,omitempty"`
	// IdentitySources - vCenter Single Sign On Identity Sources
	IdentitySources *[]IdentitySource `json:"identitySources,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateCloudProperties.
func (pcp PrivateCloudProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pcp.Circuit != nil {
		objectMap["circuit"] = pcp.Circuit
	}
	if pcp.NetworkBlock != nil {
		objectMap["networkBlock"] = pcp.NetworkBlock
	}
	if pcp.VcenterPassword != nil {
		objectMap["vcenterPassword"] = pcp.VcenterPassword
	}
	if pcp.NsxtPassword != nil {
		objectMap["nsxtPassword"] = pcp.NsxtPassword
	}
	if pcp.ManagementCluster != nil {
		objectMap["managementCluster"] = pcp.ManagementCluster
	}
	if pcp.Internet != "" {
		objectMap["internet"] = pcp.Internet
	}
	if pcp.IdentitySources != nil {
		objectMap["identitySources"] = pcp.IdentitySources
	}
	return json.Marshal(objectMap)
}

// PrivateCloudsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PrivateCloudsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateCloudsClient) (PrivateCloud, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateCloudsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateCloudsCreateOrUpdateFuture.Result.
func (future *PrivateCloudsCreateOrUpdateFuture) result(client PrivateCloudsClient) (pc PrivateCloud, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.PrivateCloudsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("avs.PrivateCloudsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if pc.Response.Response, err = future.GetResult(sender); err == nil && pc.Response.Response.StatusCode != http.StatusNoContent {
		pc, err = client.CreateOrUpdateResponder(pc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "avs.PrivateCloudsCreateOrUpdateFuture", "Result", pc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// PrivateCloudsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PrivateCloudsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateCloudsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateCloudsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateCloudsDeleteFuture.Result.
func (future *PrivateCloudsDeleteFuture) result(client PrivateCloudsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.PrivateCloudsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("avs.PrivateCloudsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// PrivateCloudsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PrivateCloudsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateCloudsClient) (PrivateCloud, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateCloudsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateCloudsUpdateFuture.Result.
func (future *PrivateCloudsUpdateFuture) result(client PrivateCloudsClient) (pc PrivateCloud, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.PrivateCloudsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("avs.PrivateCloudsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if pc.Response.Response, err = future.GetResult(sender); err == nil && pc.Response.Response.StatusCode != http.StatusNoContent {
		pc, err = client.UpdateResponder(pc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "avs.PrivateCloudsUpdateFuture", "Result", pc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// PrivateCloudUpdate an update to a private cloud resource
type PrivateCloudUpdate struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// PrivateCloudUpdateProperties - The updatable properties of a private cloud resource
	*PrivateCloudUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateCloudUpdate.
func (pcu PrivateCloudUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pcu.Tags != nil {
		objectMap["tags"] = pcu.Tags
	}
	if pcu.PrivateCloudUpdateProperties != nil {
		objectMap["properties"] = pcu.PrivateCloudUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateCloudUpdate struct.
func (pcu *PrivateCloudUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				pcu.Tags = tags
			}
		case "properties":
			if v != nil {
				var privateCloudUpdateProperties PrivateCloudUpdateProperties
				err = json.Unmarshal(*v, &privateCloudUpdateProperties)
				if err != nil {
					return err
				}
				pcu.PrivateCloudUpdateProperties = &privateCloudUpdateProperties
			}
		}
	}

	return nil
}

// PrivateCloudUpdateProperties the properties of a private cloud resource that may be updated
type PrivateCloudUpdateProperties struct {
	// ManagementCluster - The default cluster used for management
	ManagementCluster *ManagementCluster `json:"managementCluster,omitempty"`
	// Internet - Connectivity to internet is enabled or disabled. Possible values include: 'Enabled', 'Disabled'
	Internet InternetEnum `json:"internet,omitempty"`
	// IdentitySources - vCenter Single Sign On Identity Sources
	IdentitySources *[]IdentitySource `json:"identitySources,omitempty"`
}

// Quota subscription quotas
type Quota struct {
	autorest.Response `json:"-"`
	// HostsRemaining - READ-ONLY; Remaining hosts quota by sku type
	HostsRemaining map[string]*int32 `json:"hostsRemaining"`
	// QuotaEnabled - READ-ONLY; Host quota is active for current subscription. Possible values include: 'QuotaEnabledEnabled', 'QuotaEnabledDisabled'
	QuotaEnabled QuotaEnabled `json:"quotaEnabled,omitempty"`
}

// MarshalJSON is the custom marshaler for Quota.
func (q Quota) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Resource the core properties of ARM resources
type Resource struct {
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// ServiceSpecification service specification payload
type ServiceSpecification struct {
	// LogSpecifications - Specifications of the Log for Azure Monitoring
	LogSpecifications *[]LogSpecification `json:"logSpecifications,omitempty"`
	// MetricSpecifications - Specifications of the Metrics for Azure Monitoring
	MetricSpecifications *[]MetricSpecification `json:"metricSpecifications,omitempty"`
}

// Sku the resource model definition representing SKU
type Sku struct {
	// Name - The name of the SKU.
	Name *string `json:"name,omitempty"`
}

// TrackedResource the resource model definition for a ARM tracked top level resource
type TrackedResource struct {
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	return json.Marshal(objectMap)
}

// Trial subscription trial availability
type Trial struct {
	autorest.Response `json:"-"`
	// Status - READ-ONLY; Trial status. Possible values include: 'TrialAvailable', 'TrialUsed', 'TrialDisabled'
	Status TrialStatus `json:"status,omitempty"`
	// AvailableHosts - READ-ONLY; Number of trial hosts available
	AvailableHosts *int32 `json:"availableHosts,omitempty"`
}
