package kubernetesconfiguration

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/kubernetesconfiguration/mgmt/2020-07-01-preview/kubernetesconfiguration"

// ComplianceStatus compliance Status details
type ComplianceStatus struct {
	// ComplianceState - READ-ONLY; The compliance state of the configuration. Possible values include: 'Pending', 'Compliant', 'Noncompliant', 'Installed', 'Failed'
	ComplianceState ComplianceStateType `json:"complianceState,omitempty"`
	// LastConfigApplied - Datetime the configuration was last applied.
	LastConfigApplied *date.Time `json:"lastConfigApplied,omitempty"`
	// Message - Message from when the configuration was applied.
	Message *string `json:"message,omitempty"`
	// MessageLevel - Level of the message. Possible values include: 'MessageLevelTypeError', 'MessageLevelTypeWarning', 'MessageLevelTypeInformation'
	MessageLevel MessageLevelType `json:"messageLevel,omitempty"`
}

// MarshalJSON is the custom marshaler for ComplianceStatus.
func (cs ComplianceStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cs.LastConfigApplied != nil {
		objectMap["lastConfigApplied"] = cs.LastConfigApplied
	}
	if cs.Message != nil {
		objectMap["message"] = cs.Message
	}
	if cs.MessageLevel != "" {
		objectMap["messageLevel"] = cs.MessageLevel
	}
	return json.Marshal(objectMap)
}

// ConfigurationIdentity identity for the managed cluster.
type ConfigurationIdentity struct {
	// PrincipalID - READ-ONLY; The principal id of the system assigned identity which is used by the configuration.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant id of the system assigned identity which is used by the configuration.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The type of identity used for the configuration. Type 'SystemAssigned' will use an implicitly created identity. Type 'None' will not use Managed Identity for the configuration. Possible values include: 'SystemAssigned', 'None'
	Type ResourceIdentityType `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ConfigurationIdentity.
func (ci ConfigurationIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ci.Type != "" {
		objectMap["type"] = ci.Type
	}
	return json.Marshal(objectMap)
}

// ErrorDefinition error definition.
type ErrorDefinition struct {
	// Code - Service specific error code which serves as the substatus for the HTTP error code.
	Code *string `json:"code,omitempty"`
	// Message - Description of the error.
	Message *string `json:"message,omitempty"`
}

// ErrorResponse error response.
type ErrorResponse struct {
	// Error - Error definition.
	Error *ErrorDefinition `json:"error,omitempty"`
}

// ExtensionInstance the Extension Instance object.
type ExtensionInstance struct {
	autorest.Response `json:"-"`
	// ExtensionInstanceProperties - Properties of an Extension Instance resource
	*ExtensionInstanceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// SystemData - Top level metadata https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for ExtensionInstance.
func (ei ExtensionInstance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ei.ExtensionInstanceProperties != nil {
		objectMap["properties"] = ei.ExtensionInstanceProperties
	}
	if ei.SystemData != nil {
		objectMap["systemData"] = ei.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExtensionInstance struct.
func (ei *ExtensionInstance) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var extensionInstanceProperties ExtensionInstanceProperties
				err = json.Unmarshal(*v, &extensionInstanceProperties)
				if err != nil {
					return err
				}
				ei.ExtensionInstanceProperties = &extensionInstanceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ei.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ei.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ei.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				ei.SystemData = &systemData
			}
		}
	}

	return nil
}

// ExtensionInstanceProperties properties of an Extension Instance resource
type ExtensionInstanceProperties struct {
	// ExtensionType - Type of the Extension, of which this resource is an instance of.  It must be one of the Extension Types registered with Microsoft.KubernetesConfiguration by the Extension publisher.
	ExtensionType *string `json:"extensionType,omitempty"`
	// AutoUpgradeMinorVersion - Flag to note if this instance participates in auto upgrade of minor version, or not.
	AutoUpgradeMinorVersion *bool `json:"autoUpgradeMinorVersion,omitempty"`
	// ReleaseTrain - ReleaseTrain this extension instance participates in for auto-upgrade (e.g. Stable, Preview, etc.) - only if autoUpgradeMinorVersion is 'true'.
	ReleaseTrain *string `json:"releaseTrain,omitempty"`
	// Version - Version of the extension for this extension instance, if it is 'pinned' to a specific version. autoUpgradeMinorVersion must be 'false'.
	Version *string `json:"version,omitempty"`
	// Scope - Scope at which the extension instance is installed.
	Scope *Scope `json:"scope,omitempty"`
	// ConfigurationSettings - Configuration settings, as name-value pairs for configuring this instance of the extension.
	ConfigurationSettings map[string]*string `json:"configurationSettings"`
	// ConfigurationProtectedSettings - Configuration settings that are sensitive, as name-value pairs for configuring this instance of the extension.
	ConfigurationProtectedSettings map[string]*string `json:"configurationProtectedSettings"`
	// InstallState - Status of installation of this instance of the extension. Possible values include: 'InstallStateTypePending', 'InstallStateTypeInstalled', 'InstallStateTypeFailed'
	InstallState InstallStateType `json:"installState,omitempty"`
	// Statuses - Status from this instance of the extension.
	Statuses *[]ExtensionStatus `json:"statuses,omitempty"`
	// CreationTime - READ-ONLY; DateLiteral (per ISO8601) noting the time the resource was created by the client (user).
	CreationTime *string `json:"creationTime,omitempty"`
	// LastModifiedTime - READ-ONLY; DateLiteral (per ISO8601) noting the time the resource was modified by the client (user).
	LastModifiedTime *string `json:"lastModifiedTime,omitempty"`
	// LastStatusTime - READ-ONLY; DateLiteral (per ISO8601) noting the time of last status from the agent.
	LastStatusTime *string `json:"lastStatusTime,omitempty"`
	// ErrorInfo - READ-ONLY; Error information from the Agent - e.g. errors during installation.
	ErrorInfo *ErrorDefinition `json:"errorInfo,omitempty"`
	// Identity - The identity of the configuration.
	Identity *ConfigurationIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for ExtensionInstanceProperties.
func (ei ExtensionInstanceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ei.ExtensionType != nil {
		objectMap["extensionType"] = ei.ExtensionType
	}
	if ei.AutoUpgradeMinorVersion != nil {
		objectMap["autoUpgradeMinorVersion"] = ei.AutoUpgradeMinorVersion
	}
	if ei.ReleaseTrain != nil {
		objectMap["releaseTrain"] = ei.ReleaseTrain
	}
	if ei.Version != nil {
		objectMap["version"] = ei.Version
	}
	if ei.Scope != nil {
		objectMap["scope"] = ei.Scope
	}
	if ei.ConfigurationSettings != nil {
		objectMap["configurationSettings"] = ei.ConfigurationSettings
	}
	if ei.ConfigurationProtectedSettings != nil {
		objectMap["configurationProtectedSettings"] = ei.ConfigurationProtectedSettings
	}
	if ei.InstallState != "" {
		objectMap["installState"] = ei.InstallState
	}
	if ei.Statuses != nil {
		objectMap["statuses"] = ei.Statuses
	}
	if ei.Identity != nil {
		objectMap["identity"] = ei.Identity
	}
	return json.Marshal(objectMap)
}

// ExtensionInstancesList result of the request to list Extension Instances.  It contains a list of
// ExtensionInstance objects and a URL link to get the next set of results.
type ExtensionInstancesList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of Extension Instances within a Kubernetes cluster.
	Value *[]ExtensionInstance `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of extension instance objects, if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExtensionInstancesListIterator provides access to a complete listing of ExtensionInstance values.
type ExtensionInstancesListIterator struct {
	i    int
	page ExtensionInstancesListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExtensionInstancesListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExtensionInstancesListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExtensionInstancesListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExtensionInstancesListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExtensionInstancesListIterator) Response() ExtensionInstancesList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExtensionInstancesListIterator) Value() ExtensionInstance {
	if !iter.page.NotDone() {
		return ExtensionInstance{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExtensionInstancesListIterator type.
func NewExtensionInstancesListIterator(page ExtensionInstancesListPage) ExtensionInstancesListIterator {
	return ExtensionInstancesListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (eil ExtensionInstancesList) IsEmpty() bool {
	return eil.Value == nil || len(*eil.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (eil ExtensionInstancesList) hasNextLink() bool {
	return eil.NextLink != nil && len(*eil.NextLink) != 0
}

// extensionInstancesListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (eil ExtensionInstancesList) extensionInstancesListPreparer(ctx context.Context) (*http.Request, error) {
	if !eil.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(eil.NextLink)))
}

// ExtensionInstancesListPage contains a page of ExtensionInstance values.
type ExtensionInstancesListPage struct {
	fn  func(context.Context, ExtensionInstancesList) (ExtensionInstancesList, error)
	eil ExtensionInstancesList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExtensionInstancesListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExtensionInstancesListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.eil)
		if err != nil {
			return err
		}
		page.eil = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExtensionInstancesListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExtensionInstancesListPage) NotDone() bool {
	return !page.eil.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExtensionInstancesListPage) Response() ExtensionInstancesList {
	return page.eil
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExtensionInstancesListPage) Values() []ExtensionInstance {
	if page.eil.IsEmpty() {
		return nil
	}
	return *page.eil.Value
}

// Creates a new instance of the ExtensionInstancesListPage type.
func NewExtensionInstancesListPage(cur ExtensionInstancesList, getNextPage func(context.Context, ExtensionInstancesList) (ExtensionInstancesList, error)) ExtensionInstancesListPage {
	return ExtensionInstancesListPage{
		fn:  getNextPage,
		eil: cur,
	}
}

// ExtensionInstanceUpdate update Extension Instance request object.
type ExtensionInstanceUpdate struct {
	// ExtensionInstanceUpdateProperties - Properties to update an Extension Instance resource
	*ExtensionInstanceUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ExtensionInstanceUpdate.
func (eiu ExtensionInstanceUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if eiu.ExtensionInstanceUpdateProperties != nil {
		objectMap["properties"] = eiu.ExtensionInstanceUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExtensionInstanceUpdate struct.
func (eiu *ExtensionInstanceUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var extensionInstanceUpdateProperties ExtensionInstanceUpdateProperties
				err = json.Unmarshal(*v, &extensionInstanceUpdateProperties)
				if err != nil {
					return err
				}
				eiu.ExtensionInstanceUpdateProperties = &extensionInstanceUpdateProperties
			}
		}
	}

	return nil
}

// ExtensionInstanceUpdateProperties properties to update an Extension Instance resource
type ExtensionInstanceUpdateProperties struct {
	// AutoUpgradeMinorVersion - Flag to note if this instance participates in Extension Lifecycle Management or not.
	AutoUpgradeMinorVersion *bool `json:"autoUpgradeMinorVersion,omitempty"`
	// ReleaseTrain - ReleaseTrain this extension instance participates in for auto-upgrade (e.g. Stable, Preview, etc.) - only if autoUpgradeMinorVersion is 'true'.
	ReleaseTrain *string `json:"releaseTrain,omitempty"`
	// Version - Version number of extension, to 'pin' to a specific version.  autoUpgradeMinorVersion must be 'false'.
	Version *string `json:"version,omitempty"`
}

// ExtensionStatus status from this instance of the extension.
type ExtensionStatus struct {
	// Code - Status code provided by the Extension
	Code *string `json:"code,omitempty"`
	// DisplayStatus - Short description of status of this instance of the extension.
	DisplayStatus *string `json:"displayStatus,omitempty"`
	// Level - Level of the status. Possible values include: 'Error', 'Warning', 'Information'
	Level LevelType `json:"level,omitempty"`
	// Message - Detailed message of the status from the Extension instance.
	Message *string `json:"message,omitempty"`
	// Time - DateLiteral (per ISO8601) noting the time of installation status.
	Time *string `json:"time,omitempty"`
}

// HelmOperatorProperties properties for Helm operator.
type HelmOperatorProperties struct {
	// ChartVersion - Version of the operator Helm chart.
	ChartVersion *string `json:"chartVersion,omitempty"`
	// ChartValues - Values override for the operator Helm chart.
	ChartValues *string `json:"chartValues,omitempty"`
}

// ProxyResource ARM proxy resource.
type ProxyResource struct {
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// SystemData - Top level metadata https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pr.SystemData != nil {
		objectMap["systemData"] = pr.SystemData
	}
	return json.Marshal(objectMap)
}

// Resource the Resource model definition.
type Resource struct {
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// SystemData - Top level metadata https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.SystemData != nil {
		objectMap["systemData"] = r.SystemData
	}
	return json.Marshal(objectMap)
}

// ResourceProviderOperation supported operation of this resource provider.
type ResourceProviderOperation struct {
	// Name - Operation name, in format of {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - Display metadata associated with the operation.
	Display *ResourceProviderOperationDisplay `json:"display,omitempty"`
	// IsDataAction - READ-ONLY; The flag that indicates whether the operation applies to data plane.
	IsDataAction *bool `json:"isDataAction,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceProviderOperation.
func (rpo ResourceProviderOperation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rpo.Name != nil {
		objectMap["name"] = rpo.Name
	}
	if rpo.Display != nil {
		objectMap["display"] = rpo.Display
	}
	return json.Marshal(objectMap)
}

// ResourceProviderOperationDisplay display metadata associated with the operation.
type ResourceProviderOperationDisplay struct {
	// Provider - Resource provider: Microsoft KubernetesConfiguration.
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
	// Operation - Type of operation: get, read, delete, etc.
	Operation *string `json:"operation,omitempty"`
	// Description - Description of this operation.
	Description *string `json:"description,omitempty"`
}

// ResourceProviderOperationList result of the request to list operations.
type ResourceProviderOperationList struct {
	autorest.Response `json:"-"`
	// Value - List of operations supported by this resource provider.
	Value *[]ResourceProviderOperation `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to the next set of results, if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceProviderOperationList.
func (rpol ResourceProviderOperationList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rpol.Value != nil {
		objectMap["value"] = rpol.Value
	}
	return json.Marshal(objectMap)
}

// ResourceProviderOperationListIterator provides access to a complete listing of ResourceProviderOperation
// values.
type ResourceProviderOperationListIterator struct {
	i    int
	page ResourceProviderOperationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResourceProviderOperationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceProviderOperationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResourceProviderOperationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResourceProviderOperationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResourceProviderOperationListIterator) Response() ResourceProviderOperationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResourceProviderOperationListIterator) Value() ResourceProviderOperation {
	if !iter.page.NotDone() {
		return ResourceProviderOperation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResourceProviderOperationListIterator type.
func NewResourceProviderOperationListIterator(page ResourceProviderOperationListPage) ResourceProviderOperationListIterator {
	return ResourceProviderOperationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rpol ResourceProviderOperationList) IsEmpty() bool {
	return rpol.Value == nil || len(*rpol.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rpol ResourceProviderOperationList) hasNextLink() bool {
	return rpol.NextLink != nil && len(*rpol.NextLink) != 0
}

// resourceProviderOperationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rpol ResourceProviderOperationList) resourceProviderOperationListPreparer(ctx context.Context) (*http.Request, error) {
	if !rpol.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rpol.NextLink)))
}

// ResourceProviderOperationListPage contains a page of ResourceProviderOperation values.
type ResourceProviderOperationListPage struct {
	fn   func(context.Context, ResourceProviderOperationList) (ResourceProviderOperationList, error)
	rpol ResourceProviderOperationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResourceProviderOperationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceProviderOperationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rpol)
		if err != nil {
			return err
		}
		page.rpol = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResourceProviderOperationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResourceProviderOperationListPage) NotDone() bool {
	return !page.rpol.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResourceProviderOperationListPage) Response() ResourceProviderOperationList {
	return page.rpol
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResourceProviderOperationListPage) Values() []ResourceProviderOperation {
	if page.rpol.IsEmpty() {
		return nil
	}
	return *page.rpol.Value
}

// Creates a new instance of the ResourceProviderOperationListPage type.
func NewResourceProviderOperationListPage(cur ResourceProviderOperationList, getNextPage func(context.Context, ResourceProviderOperationList) (ResourceProviderOperationList, error)) ResourceProviderOperationListPage {
	return ResourceProviderOperationListPage{
		fn:   getNextPage,
		rpol: cur,
	}
}

// Result sample result definition
type Result struct {
	// SampleProperty - Sample property of type string
	SampleProperty *string `json:"sampleProperty,omitempty"`
}

// Scope scope of the extensionInstance. It can be either Cluster or Namespace; but not both.
type Scope struct {
	// Cluster - Specifies that the scope of the extensionInstance is Cluster
	Cluster *ScopeCluster `json:"cluster,omitempty"`
	// Namespace - Specifies that the scope of the extensionInstance is Namespace
	Namespace *ScopeNamespace `json:"namespace,omitempty"`
}

// ScopeCluster specifies that the scope of the extensionInstance is Cluster
type ScopeCluster struct {
	// ReleaseNamespace - Namespace where the extension Release must be placed, for a Cluster scoped extensionInstance.  If this namespace does not exist, it will be created
	ReleaseNamespace *string `json:"releaseNamespace,omitempty"`
}

// ScopeNamespace specifies that the scope of the extensionInstance is Namespace
type ScopeNamespace struct {
	// TargetNamespace - Namespace where the extensionInstance will be created for an Namespace scoped extensionInstance.  If this namespace does not exist, it will be created
	TargetNamespace *string `json:"targetNamespace,omitempty"`
}

// SourceControlConfiguration the SourceControl Configuration object returned in Get & Put response.
type SourceControlConfiguration struct {
	autorest.Response `json:"-"`
	// SourceControlConfigurationProperties - Properties to create a Source Control Configuration resource
	*SourceControlConfigurationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// SystemData - Top level metadata https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for SourceControlConfiguration.
func (scc SourceControlConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scc.SourceControlConfigurationProperties != nil {
		objectMap["properties"] = scc.SourceControlConfigurationProperties
	}
	if scc.SystemData != nil {
		objectMap["systemData"] = scc.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SourceControlConfiguration struct.
func (scc *SourceControlConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var sourceControlConfigurationProperties SourceControlConfigurationProperties
				err = json.Unmarshal(*v, &sourceControlConfigurationProperties)
				if err != nil {
					return err
				}
				scc.SourceControlConfigurationProperties = &sourceControlConfigurationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				scc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				scc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				scc.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				scc.SystemData = &systemData
			}
		}
	}

	return nil
}

// SourceControlConfigurationList result of the request to list Source Control Configurations.  It contains
// a list of SourceControlConfiguration objects and a URL link to get the next set of results.
type SourceControlConfigurationList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of Source Control Configurations within a Kubernetes cluster.
	Value *[]SourceControlConfiguration `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of configuration objects, if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// SourceControlConfigurationListIterator provides access to a complete listing of
// SourceControlConfiguration values.
type SourceControlConfigurationListIterator struct {
	i    int
	page SourceControlConfigurationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SourceControlConfigurationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SourceControlConfigurationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SourceControlConfigurationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SourceControlConfigurationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SourceControlConfigurationListIterator) Response() SourceControlConfigurationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SourceControlConfigurationListIterator) Value() SourceControlConfiguration {
	if !iter.page.NotDone() {
		return SourceControlConfiguration{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SourceControlConfigurationListIterator type.
func NewSourceControlConfigurationListIterator(page SourceControlConfigurationListPage) SourceControlConfigurationListIterator {
	return SourceControlConfigurationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sccl SourceControlConfigurationList) IsEmpty() bool {
	return sccl.Value == nil || len(*sccl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sccl SourceControlConfigurationList) hasNextLink() bool {
	return sccl.NextLink != nil && len(*sccl.NextLink) != 0
}

// sourceControlConfigurationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sccl SourceControlConfigurationList) sourceControlConfigurationListPreparer(ctx context.Context) (*http.Request, error) {
	if !sccl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sccl.NextLink)))
}

// SourceControlConfigurationListPage contains a page of SourceControlConfiguration values.
type SourceControlConfigurationListPage struct {
	fn   func(context.Context, SourceControlConfigurationList) (SourceControlConfigurationList, error)
	sccl SourceControlConfigurationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SourceControlConfigurationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SourceControlConfigurationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sccl)
		if err != nil {
			return err
		}
		page.sccl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SourceControlConfigurationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SourceControlConfigurationListPage) NotDone() bool {
	return !page.sccl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SourceControlConfigurationListPage) Response() SourceControlConfigurationList {
	return page.sccl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SourceControlConfigurationListPage) Values() []SourceControlConfiguration {
	if page.sccl.IsEmpty() {
		return nil
	}
	return *page.sccl.Value
}

// Creates a new instance of the SourceControlConfigurationListPage type.
func NewSourceControlConfigurationListPage(cur SourceControlConfigurationList, getNextPage func(context.Context, SourceControlConfigurationList) (SourceControlConfigurationList, error)) SourceControlConfigurationListPage {
	return SourceControlConfigurationListPage{
		fn:   getNextPage,
		sccl: cur,
	}
}

// SourceControlConfigurationProperties properties to create a Source Control Configuration resource
type SourceControlConfigurationProperties struct {
	// RepositoryURL - Url of the SourceControl Repository.
	RepositoryURL *string `json:"repositoryUrl,omitempty"`
	// OperatorNamespace - The namespace to which this operator is installed to. Maximum of 253 lower case alphanumeric characters, hyphen and period only.
	OperatorNamespace *string `json:"operatorNamespace,omitempty"`
	// OperatorInstanceName - Instance name of the operator - identifying the specific configuration.
	OperatorInstanceName *string `json:"operatorInstanceName,omitempty"`
	// OperatorType - Type of the operator. Possible values include: 'Flux'
	OperatorType OperatorType `json:"operatorType,omitempty"`
	// OperatorParams - Any Parameters for the Operator instance in string format.
	OperatorParams *string `json:"operatorParams,omitempty"`
	// ConfigurationProtectedSettings - Name-value pairs of protected configuration settings for the configuration
	ConfigurationProtectedSettings map[string]*string `json:"configurationProtectedSettings"`
	// OperatorScope - Scope at which the operator will be installed. Possible values include: 'Cluster', 'Namespace'
	OperatorScope OperatorScopeType `json:"operatorScope,omitempty"`
	// RepositoryPublicKey - READ-ONLY; Public Key associated with this SourceControl configuration (either generated within the cluster or provided by the user).
	RepositoryPublicKey *string `json:"repositoryPublicKey,omitempty"`
	// SSHKnownHostsContents - Base64-encoded known_hosts contents containing public SSH keys required to access private Git instances
	SSHKnownHostsContents *string `json:"sshKnownHostsContents,omitempty"`
	// EnableHelmOperator - Option to enable Helm Operator for this git configuration.
	EnableHelmOperator *bool `json:"enableHelmOperator,omitempty"`
	// HelmOperatorProperties - Properties for Helm operator.
	HelmOperatorProperties *HelmOperatorProperties `json:"helmOperatorProperties,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the resource provider. Possible values include: 'ProvisioningStateTypeAccepted', 'ProvisioningStateTypeDeleting', 'ProvisioningStateTypeRunning', 'ProvisioningStateTypeSucceeded', 'ProvisioningStateTypeFailed'
	ProvisioningState ProvisioningStateType `json:"provisioningState,omitempty"`
	// ComplianceStatus - READ-ONLY; Compliance Status of the Configuration
	ComplianceStatus *ComplianceStatus `json:"complianceStatus,omitempty"`
}

// MarshalJSON is the custom marshaler for SourceControlConfigurationProperties.
func (scc SourceControlConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scc.RepositoryURL != nil {
		objectMap["repositoryUrl"] = scc.RepositoryURL
	}
	if scc.OperatorNamespace != nil {
		objectMap["operatorNamespace"] = scc.OperatorNamespace
	}
	if scc.OperatorInstanceName != nil {
		objectMap["operatorInstanceName"] = scc.OperatorInstanceName
	}
	if scc.OperatorType != "" {
		objectMap["operatorType"] = scc.OperatorType
	}
	if scc.OperatorParams != nil {
		objectMap["operatorParams"] = scc.OperatorParams
	}
	if scc.ConfigurationProtectedSettings != nil {
		objectMap["configurationProtectedSettings"] = scc.ConfigurationProtectedSettings
	}
	if scc.OperatorScope != "" {
		objectMap["operatorScope"] = scc.OperatorScope
	}
	if scc.SSHKnownHostsContents != nil {
		objectMap["sshKnownHostsContents"] = scc.SSHKnownHostsContents
	}
	if scc.EnableHelmOperator != nil {
		objectMap["enableHelmOperator"] = scc.EnableHelmOperator
	}
	if scc.HelmOperatorProperties != nil {
		objectMap["helmOperatorProperties"] = scc.HelmOperatorProperties
	}
	return json.Marshal(objectMap)
}

// SourceControlConfigurationsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SourceControlConfigurationsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SourceControlConfigurationsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SourceControlConfigurationsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SourceControlConfigurationsDeleteFuture.Result.
func (future *SourceControlConfigurationsDeleteFuture) result(client SourceControlConfigurationsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kubernetesconfiguration.SourceControlConfigurationsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("kubernetesconfiguration.SourceControlConfigurationsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SystemData top level metadata
// https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources
type SystemData struct {
	// CreatedBy - READ-ONLY; A string identifier for the identity that created the resource
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - READ-ONLY; The type of identity that created the resource: user, application, managedIdentity, key
	CreatedByType *string `json:"createdByType,omitempty"`
	// CreatedAt - READ-ONLY; The timestamp of resource creation (UTC)
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - READ-ONLY; A string identifier for the identity that last modified the resource
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - READ-ONLY; The type of identity that last modified the resource: user, application, managedIdentity, key
	LastModifiedByType *string `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - READ-ONLY; The timestamp of resource last modification (UTC)
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}
