package siterecovery

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/recoveryservices/mgmt/2018-07-10/siterecovery"

// A2AAddDisksInput a2A add disk(s) input.
type A2AAddDisksInput struct {
	// VMDisks - The list of vm disk details.
	VMDisks *[]A2AVMDiskInputDetails `json:"vmDisks,omitempty"`
	// VMManagedDisks - The list of vm managed disk details.
	VMManagedDisks *[]A2AVMManagedDiskInputDetails `json:"vmManagedDisks,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeAddDisksProviderSpecificInput', 'InstanceTypeA2A'
	InstanceType InstanceType `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for A2AAddDisksInput.
func (aadi A2AAddDisksInput) MarshalJSON() ([]byte, error) {
	aadi.InstanceType = InstanceTypeA2A
	objectMap := make(map[string]interface{})
	if aadi.VMDisks != nil {
		objectMap["vmDisks"] = aadi.VMDisks
	}
	if aadi.VMManagedDisks != nil {
		objectMap["vmManagedDisks"] = aadi.VMManagedDisks
	}
	if aadi.InstanceType != "" {
		objectMap["instanceType"] = aadi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AAddDisksInput is the BasicAddDisksProviderSpecificInput implementation for A2AAddDisksInput.
func (aadi A2AAddDisksInput) AsA2AAddDisksInput() (*A2AAddDisksInput, bool) {
	return &aadi, true
}

// AsAddDisksProviderSpecificInput is the BasicAddDisksProviderSpecificInput implementation for A2AAddDisksInput.
func (aadi A2AAddDisksInput) AsAddDisksProviderSpecificInput() (*AddDisksProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicAddDisksProviderSpecificInput is the BasicAddDisksProviderSpecificInput implementation for A2AAddDisksInput.
func (aadi A2AAddDisksInput) AsBasicAddDisksProviderSpecificInput() (BasicAddDisksProviderSpecificInput, bool) {
	return &aadi, true
}

// A2AApplyRecoveryPointInput applyRecoveryPoint input specific to A2A provider.
type A2AApplyRecoveryPointInput struct {
	// InstanceType - Possible values include: 'InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeApplyRecoveryPointProviderSpecificInput', 'InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeA2A', 'InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeInMageRcm'
	InstanceType InstanceTypeBasicApplyRecoveryPointProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for A2AApplyRecoveryPointInput.
func (aarpi A2AApplyRecoveryPointInput) MarshalJSON() ([]byte, error) {
	aarpi.InstanceType = InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeA2A
	objectMap := make(map[string]interface{})
	if aarpi.InstanceType != "" {
		objectMap["instanceType"] = aarpi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AApplyRecoveryPointInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for A2AApplyRecoveryPointInput.
func (aarpi A2AApplyRecoveryPointInput) AsA2AApplyRecoveryPointInput() (*A2AApplyRecoveryPointInput, bool) {
	return &aarpi, true
}

// AsHyperVReplicaAzureApplyRecoveryPointInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for A2AApplyRecoveryPointInput.
func (aarpi A2AApplyRecoveryPointInput) AsHyperVReplicaAzureApplyRecoveryPointInput() (*HyperVReplicaAzureApplyRecoveryPointInput, bool) {
	return nil, false
}

// AsInMageAzureV2ApplyRecoveryPointInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for A2AApplyRecoveryPointInput.
func (aarpi A2AApplyRecoveryPointInput) AsInMageAzureV2ApplyRecoveryPointInput() (*InMageAzureV2ApplyRecoveryPointInput, bool) {
	return nil, false
}

// AsInMageRcmApplyRecoveryPointInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for A2AApplyRecoveryPointInput.
func (aarpi A2AApplyRecoveryPointInput) AsInMageRcmApplyRecoveryPointInput() (*InMageRcmApplyRecoveryPointInput, bool) {
	return nil, false
}

// AsApplyRecoveryPointProviderSpecificInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for A2AApplyRecoveryPointInput.
func (aarpi A2AApplyRecoveryPointInput) AsApplyRecoveryPointProviderSpecificInput() (*ApplyRecoveryPointProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicApplyRecoveryPointProviderSpecificInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for A2AApplyRecoveryPointInput.
func (aarpi A2AApplyRecoveryPointInput) AsBasicApplyRecoveryPointProviderSpecificInput() (BasicApplyRecoveryPointProviderSpecificInput, bool) {
	return &aarpi, true
}

// A2AContainerCreationInput a2A cloud creation input.
type A2AContainerCreationInput struct {
	// InstanceType - Possible values include: 'InstanceTypeBasicReplicationProviderSpecificContainerCreationInputInstanceTypeReplicationProviderSpecificContainerCreationInput', 'InstanceTypeBasicReplicationProviderSpecificContainerCreationInputInstanceTypeA2A', 'InstanceTypeBasicReplicationProviderSpecificContainerCreationInputInstanceTypeSixcSevendaFourFiveFiveFiveZeroSixfFourThreeffAOneSixaEightebOneZeroOneaebbSevenZero'
	InstanceType InstanceTypeBasicReplicationProviderSpecificContainerCreationInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for A2AContainerCreationInput.
func (acci A2AContainerCreationInput) MarshalJSON() ([]byte, error) {
	acci.InstanceType = InstanceTypeBasicReplicationProviderSpecificContainerCreationInputInstanceTypeA2A
	objectMap := make(map[string]interface{})
	if acci.InstanceType != "" {
		objectMap["instanceType"] = acci.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AContainerCreationInput is the BasicReplicationProviderSpecificContainerCreationInput implementation for A2AContainerCreationInput.
func (acci A2AContainerCreationInput) AsA2AContainerCreationInput() (*A2AContainerCreationInput, bool) {
	return &acci, true
}

// AsVMwareCbtContainerCreationInput is the BasicReplicationProviderSpecificContainerCreationInput implementation for A2AContainerCreationInput.
func (acci A2AContainerCreationInput) AsVMwareCbtContainerCreationInput() (*VMwareCbtContainerCreationInput, bool) {
	return nil, false
}

// AsReplicationProviderSpecificContainerCreationInput is the BasicReplicationProviderSpecificContainerCreationInput implementation for A2AContainerCreationInput.
func (acci A2AContainerCreationInput) AsReplicationProviderSpecificContainerCreationInput() (*ReplicationProviderSpecificContainerCreationInput, bool) {
	return nil, false
}

// AsBasicReplicationProviderSpecificContainerCreationInput is the BasicReplicationProviderSpecificContainerCreationInput implementation for A2AContainerCreationInput.
func (acci A2AContainerCreationInput) AsBasicReplicationProviderSpecificContainerCreationInput() (BasicReplicationProviderSpecificContainerCreationInput, bool) {
	return &acci, true
}

// A2AContainerMappingInput a2A container mapping input.
type A2AContainerMappingInput struct {
	// AgentAutoUpdateStatus - A value indicating whether the auto update is enabled. Possible values include: 'Disabled', 'Enabled'
	AgentAutoUpdateStatus AgentAutoUpdateStatus `json:"agentAutoUpdateStatus,omitempty"`
	// AutomationAccountArmID - The automation account arm id.
	AutomationAccountArmID *string `json:"automationAccountArmId,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicReplicationProviderSpecificContainerMappingInputInstanceTypeReplicationProviderSpecificContainerMappingInput', 'InstanceTypeBasicReplicationProviderSpecificContainerMappingInputInstanceTypeA2A', 'InstanceTypeBasicReplicationProviderSpecificContainerMappingInputInstanceTypeVMwareCbt'
	InstanceType InstanceTypeBasicReplicationProviderSpecificContainerMappingInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for A2AContainerMappingInput.
func (acmi A2AContainerMappingInput) MarshalJSON() ([]byte, error) {
	acmi.InstanceType = InstanceTypeBasicReplicationProviderSpecificContainerMappingInputInstanceTypeA2A
	objectMap := make(map[string]interface{})
	if acmi.AgentAutoUpdateStatus != "" {
		objectMap["agentAutoUpdateStatus"] = acmi.AgentAutoUpdateStatus
	}
	if acmi.AutomationAccountArmID != nil {
		objectMap["automationAccountArmId"] = acmi.AutomationAccountArmID
	}
	if acmi.InstanceType != "" {
		objectMap["instanceType"] = acmi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AContainerMappingInput is the BasicReplicationProviderSpecificContainerMappingInput implementation for A2AContainerMappingInput.
func (acmi A2AContainerMappingInput) AsA2AContainerMappingInput() (*A2AContainerMappingInput, bool) {
	return &acmi, true
}

// AsVMwareCbtContainerMappingInput is the BasicReplicationProviderSpecificContainerMappingInput implementation for A2AContainerMappingInput.
func (acmi A2AContainerMappingInput) AsVMwareCbtContainerMappingInput() (*VMwareCbtContainerMappingInput, bool) {
	return nil, false
}

// AsReplicationProviderSpecificContainerMappingInput is the BasicReplicationProviderSpecificContainerMappingInput implementation for A2AContainerMappingInput.
func (acmi A2AContainerMappingInput) AsReplicationProviderSpecificContainerMappingInput() (*ReplicationProviderSpecificContainerMappingInput, bool) {
	return nil, false
}

// AsBasicReplicationProviderSpecificContainerMappingInput is the BasicReplicationProviderSpecificContainerMappingInput implementation for A2AContainerMappingInput.
func (acmi A2AContainerMappingInput) AsBasicReplicationProviderSpecificContainerMappingInput() (BasicReplicationProviderSpecificContainerMappingInput, bool) {
	return &acmi, true
}

// A2ACreateProtectionIntentInput a2A create protection intent input.
type A2ACreateProtectionIntentInput struct {
	// FabricObjectID - The fabric specific object Id of the virtual machine.
	FabricObjectID *string `json:"fabricObjectId,omitempty"`
	// PrimaryLocation - The primary location for the virtual machine.
	PrimaryLocation *string `json:"primaryLocation,omitempty"`
	// RecoveryLocation - The recovery location for the virtual machine.
	RecoveryLocation *string `json:"recoveryLocation,omitempty"`
	// RecoverySubscriptionID - The recovery subscription Id of the virtual machine.
	RecoverySubscriptionID *string `json:"recoverySubscriptionId,omitempty"`
	// RecoveryAvailabilityType - The recovery availability type of the virtual machine. Possible values include: 'Single', 'AvailabilitySet', 'AvailabilityZone'
	RecoveryAvailabilityType A2ARecoveryAvailabilityType `json:"recoveryAvailabilityType,omitempty"`
	// ProtectionProfileCustomInput - The protection profile custom inputs.
	ProtectionProfileCustomInput BasicProtectionProfileCustomDetails `json:"protectionProfileCustomInput,omitempty"`
	// RecoveryResourceGroupID - The recovery resource group Id. Valid for V2 scenarios.
	RecoveryResourceGroupID *string `json:"recoveryResourceGroupId,omitempty"`
	// PrimaryStagingStorageAccountCustomInput - The primary staging storage account input.
	PrimaryStagingStorageAccountCustomInput BasicStorageAccountCustomDetails `json:"primaryStagingStorageAccountCustomInput,omitempty"`
	// RecoveryAvailabilitySetCustomInput - The recovery availability set input.
	RecoveryAvailabilitySetCustomInput BasicRecoveryAvailabilitySetCustomDetails `json:"recoveryAvailabilitySetCustomInput,omitempty"`
	// RecoveryVirtualNetworkCustomInput - The recovery virtual network input.
	RecoveryVirtualNetworkCustomInput BasicRecoveryVirtualNetworkCustomDetails `json:"recoveryVirtualNetworkCustomInput,omitempty"`
	// RecoveryProximityPlacementGroupCustomInput - The recovery proximity placement group custom input.
	RecoveryProximityPlacementGroupCustomInput BasicRecoveryProximityPlacementGroupCustomDetails `json:"recoveryProximityPlacementGroupCustomInput,omitempty"`
	// AutoProtectionOfDataDisk - A value indicating whether the auto protection is enabled. Possible values include: 'AutoProtectionOfDataDiskDisabled', 'AutoProtectionOfDataDiskEnabled'
	AutoProtectionOfDataDisk AutoProtectionOfDataDisk `json:"autoProtectionOfDataDisk,omitempty"`
	// VMDisks - The list of vm disk inputs.
	VMDisks *[]A2AProtectionIntentDiskInputDetails `json:"vmDisks,omitempty"`
	// VMManagedDisks - The list of vm managed disk inputs.
	VMManagedDisks *[]A2AProtectionIntentManagedDiskInputDetails `json:"vmManagedDisks,omitempty"`
	// MultiVMGroupName - The multi vm group name.
	MultiVMGroupName *string `json:"multiVmGroupName,omitempty"`
	// MultiVMGroupID - The multi vm group id.
	MultiVMGroupID *string `json:"multiVmGroupId,omitempty"`
	// RecoveryBootDiagStorageAccount - The boot diagnostic storage account.
	RecoveryBootDiagStorageAccount BasicStorageAccountCustomDetails `json:"recoveryBootDiagStorageAccount,omitempty"`
	// DiskEncryptionInfo - The recovery disk encryption information (for two pass flows).
	DiskEncryptionInfo *DiskEncryptionInfo `json:"diskEncryptionInfo,omitempty"`
	// RecoveryAvailabilityZone - The recovery availability zone.
	RecoveryAvailabilityZone *string `json:"recoveryAvailabilityZone,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicCreateProtectionIntentProviderSpecificDetailsInstanceTypeCreateProtectionIntentProviderSpecificDetails', 'InstanceTypeBasicCreateProtectionIntentProviderSpecificDetailsInstanceTypeA2A'
	InstanceType InstanceTypeBasicCreateProtectionIntentProviderSpecificDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for A2ACreateProtectionIntentInput.
func (acpii A2ACreateProtectionIntentInput) MarshalJSON() ([]byte, error) {
	acpii.InstanceType = InstanceTypeBasicCreateProtectionIntentProviderSpecificDetailsInstanceTypeA2A
	objectMap := make(map[string]interface{})
	if acpii.FabricObjectID != nil {
		objectMap["fabricObjectId"] = acpii.FabricObjectID
	}
	if acpii.PrimaryLocation != nil {
		objectMap["primaryLocation"] = acpii.PrimaryLocation
	}
	if acpii.RecoveryLocation != nil {
		objectMap["recoveryLocation"] = acpii.RecoveryLocation
	}
	if acpii.RecoverySubscriptionID != nil {
		objectMap["recoverySubscriptionId"] = acpii.RecoverySubscriptionID
	}
	if acpii.RecoveryAvailabilityType != "" {
		objectMap["recoveryAvailabilityType"] = acpii.RecoveryAvailabilityType
	}
	objectMap["protectionProfileCustomInput"] = acpii.ProtectionProfileCustomInput
	if acpii.RecoveryResourceGroupID != nil {
		objectMap["recoveryResourceGroupId"] = acpii.RecoveryResourceGroupID
	}
	objectMap["primaryStagingStorageAccountCustomInput"] = acpii.PrimaryStagingStorageAccountCustomInput
	objectMap["recoveryAvailabilitySetCustomInput"] = acpii.RecoveryAvailabilitySetCustomInput
	objectMap["recoveryVirtualNetworkCustomInput"] = acpii.RecoveryVirtualNetworkCustomInput
	objectMap["recoveryProximityPlacementGroupCustomInput"] = acpii.RecoveryProximityPlacementGroupCustomInput
	if acpii.AutoProtectionOfDataDisk != "" {
		objectMap["autoProtectionOfDataDisk"] = acpii.AutoProtectionOfDataDisk
	}
	if acpii.VMDisks != nil {
		objectMap["vmDisks"] = acpii.VMDisks
	}
	if acpii.VMManagedDisks != nil {
		objectMap["vmManagedDisks"] = acpii.VMManagedDisks
	}
	if acpii.MultiVMGroupName != nil {
		objectMap["multiVmGroupName"] = acpii.MultiVMGroupName
	}
	if acpii.MultiVMGroupID != nil {
		objectMap["multiVmGroupId"] = acpii.MultiVMGroupID
	}
	objectMap["recoveryBootDiagStorageAccount"] = acpii.RecoveryBootDiagStorageAccount
	if acpii.DiskEncryptionInfo != nil {
		objectMap["diskEncryptionInfo"] = acpii.DiskEncryptionInfo
	}
	if acpii.RecoveryAvailabilityZone != nil {
		objectMap["recoveryAvailabilityZone"] = acpii.RecoveryAvailabilityZone
	}
	if acpii.InstanceType != "" {
		objectMap["instanceType"] = acpii.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2ACreateProtectionIntentInput is the BasicCreateProtectionIntentProviderSpecificDetails implementation for A2ACreateProtectionIntentInput.
func (acpii A2ACreateProtectionIntentInput) AsA2ACreateProtectionIntentInput() (*A2ACreateProtectionIntentInput, bool) {
	return &acpii, true
}

// AsCreateProtectionIntentProviderSpecificDetails is the BasicCreateProtectionIntentProviderSpecificDetails implementation for A2ACreateProtectionIntentInput.
func (acpii A2ACreateProtectionIntentInput) AsCreateProtectionIntentProviderSpecificDetails() (*CreateProtectionIntentProviderSpecificDetails, bool) {
	return nil, false
}

// AsBasicCreateProtectionIntentProviderSpecificDetails is the BasicCreateProtectionIntentProviderSpecificDetails implementation for A2ACreateProtectionIntentInput.
func (acpii A2ACreateProtectionIntentInput) AsBasicCreateProtectionIntentProviderSpecificDetails() (BasicCreateProtectionIntentProviderSpecificDetails, bool) {
	return &acpii, true
}

// UnmarshalJSON is the custom unmarshaler for A2ACreateProtectionIntentInput struct.
func (acpii *A2ACreateProtectionIntentInput) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "fabricObjectId":
			if v != nil {
				var fabricObjectID string
				err = json.Unmarshal(*v, &fabricObjectID)
				if err != nil {
					return err
				}
				acpii.FabricObjectID = &fabricObjectID
			}
		case "primaryLocation":
			if v != nil {
				var primaryLocation string
				err = json.Unmarshal(*v, &primaryLocation)
				if err != nil {
					return err
				}
				acpii.PrimaryLocation = &primaryLocation
			}
		case "recoveryLocation":
			if v != nil {
				var recoveryLocation string
				err = json.Unmarshal(*v, &recoveryLocation)
				if err != nil {
					return err
				}
				acpii.RecoveryLocation = &recoveryLocation
			}
		case "recoverySubscriptionId":
			if v != nil {
				var recoverySubscriptionID string
				err = json.Unmarshal(*v, &recoverySubscriptionID)
				if err != nil {
					return err
				}
				acpii.RecoverySubscriptionID = &recoverySubscriptionID
			}
		case "recoveryAvailabilityType":
			if v != nil {
				var recoveryAvailabilityType A2ARecoveryAvailabilityType
				err = json.Unmarshal(*v, &recoveryAvailabilityType)
				if err != nil {
					return err
				}
				acpii.RecoveryAvailabilityType = recoveryAvailabilityType
			}
		case "protectionProfileCustomInput":
			if v != nil {
				protectionProfileCustomInput, err := unmarshalBasicProtectionProfileCustomDetails(*v)
				if err != nil {
					return err
				}
				acpii.ProtectionProfileCustomInput = protectionProfileCustomInput
			}
		case "recoveryResourceGroupId":
			if v != nil {
				var recoveryResourceGroupID string
				err = json.Unmarshal(*v, &recoveryResourceGroupID)
				if err != nil {
					return err
				}
				acpii.RecoveryResourceGroupID = &recoveryResourceGroupID
			}
		case "primaryStagingStorageAccountCustomInput":
			if v != nil {
				primaryStagingStorageAccountCustomInput, err := unmarshalBasicStorageAccountCustomDetails(*v)
				if err != nil {
					return err
				}
				acpii.PrimaryStagingStorageAccountCustomInput = primaryStagingStorageAccountCustomInput
			}
		case "recoveryAvailabilitySetCustomInput":
			if v != nil {
				recoveryAvailabilitySetCustomInput, err := unmarshalBasicRecoveryAvailabilitySetCustomDetails(*v)
				if err != nil {
					return err
				}
				acpii.RecoveryAvailabilitySetCustomInput = recoveryAvailabilitySetCustomInput
			}
		case "recoveryVirtualNetworkCustomInput":
			if v != nil {
				recoveryVirtualNetworkCustomInput, err := unmarshalBasicRecoveryVirtualNetworkCustomDetails(*v)
				if err != nil {
					return err
				}
				acpii.RecoveryVirtualNetworkCustomInput = recoveryVirtualNetworkCustomInput
			}
		case "recoveryProximityPlacementGroupCustomInput":
			if v != nil {
				recoveryProximityPlacementGroupCustomInput, err := unmarshalBasicRecoveryProximityPlacementGroupCustomDetails(*v)
				if err != nil {
					return err
				}
				acpii.RecoveryProximityPlacementGroupCustomInput = recoveryProximityPlacementGroupCustomInput
			}
		case "autoProtectionOfDataDisk":
			if v != nil {
				var autoProtectionOfDataDisk AutoProtectionOfDataDisk
				err = json.Unmarshal(*v, &autoProtectionOfDataDisk)
				if err != nil {
					return err
				}
				acpii.AutoProtectionOfDataDisk = autoProtectionOfDataDisk
			}
		case "vmDisks":
			if v != nil {
				var VMDisks []A2AProtectionIntentDiskInputDetails
				err = json.Unmarshal(*v, &VMDisks)
				if err != nil {
					return err
				}
				acpii.VMDisks = &VMDisks
			}
		case "vmManagedDisks":
			if v != nil {
				var VMManagedDisks []A2AProtectionIntentManagedDiskInputDetails
				err = json.Unmarshal(*v, &VMManagedDisks)
				if err != nil {
					return err
				}
				acpii.VMManagedDisks = &VMManagedDisks
			}
		case "multiVmGroupName":
			if v != nil {
				var multiVMGroupName string
				err = json.Unmarshal(*v, &multiVMGroupName)
				if err != nil {
					return err
				}
				acpii.MultiVMGroupName = &multiVMGroupName
			}
		case "multiVmGroupId":
			if v != nil {
				var multiVMGroupID string
				err = json.Unmarshal(*v, &multiVMGroupID)
				if err != nil {
					return err
				}
				acpii.MultiVMGroupID = &multiVMGroupID
			}
		case "recoveryBootDiagStorageAccount":
			if v != nil {
				recoveryBootDiagStorageAccount, err := unmarshalBasicStorageAccountCustomDetails(*v)
				if err != nil {
					return err
				}
				acpii.RecoveryBootDiagStorageAccount = recoveryBootDiagStorageAccount
			}
		case "diskEncryptionInfo":
			if v != nil {
				var diskEncryptionInfo DiskEncryptionInfo
				err = json.Unmarshal(*v, &diskEncryptionInfo)
				if err != nil {
					return err
				}
				acpii.DiskEncryptionInfo = &diskEncryptionInfo
			}
		case "recoveryAvailabilityZone":
			if v != nil {
				var recoveryAvailabilityZone string
				err = json.Unmarshal(*v, &recoveryAvailabilityZone)
				if err != nil {
					return err
				}
				acpii.RecoveryAvailabilityZone = &recoveryAvailabilityZone
			}
		case "instanceType":
			if v != nil {
				var instanceType InstanceTypeBasicCreateProtectionIntentProviderSpecificDetails
				err = json.Unmarshal(*v, &instanceType)
				if err != nil {
					return err
				}
				acpii.InstanceType = instanceType
			}
		}
	}

	return nil
}

// A2AEnableProtectionInput a2A enable protection input.
type A2AEnableProtectionInput struct {
	// FabricObjectID - The fabric specific object Id of the virtual machine.
	FabricObjectID *string `json:"fabricObjectId,omitempty"`
	// RecoveryContainerID - The recovery container Id.
	RecoveryContainerID *string `json:"recoveryContainerId,omitempty"`
	// RecoveryResourceGroupID - The recovery resource group Id. Valid for V2 scenarios.
	RecoveryResourceGroupID *string `json:"recoveryResourceGroupId,omitempty"`
	// RecoveryCloudServiceID - The recovery cloud service Id. Valid for V1 scenarios.
	RecoveryCloudServiceID *string `json:"recoveryCloudServiceId,omitempty"`
	// RecoveryAvailabilitySetID - The recovery availability set Id.
	RecoveryAvailabilitySetID *string `json:"recoveryAvailabilitySetId,omitempty"`
	// RecoveryProximityPlacementGroupID - The recovery proximity placement group Id.
	RecoveryProximityPlacementGroupID *string `json:"recoveryProximityPlacementGroupId,omitempty"`
	// VMDisks - The list of vm disk details.
	VMDisks *[]A2AVMDiskInputDetails `json:"vmDisks,omitempty"`
	// VMManagedDisks - The list of vm managed disk details.
	VMManagedDisks *[]A2AVMManagedDiskInputDetails `json:"vmManagedDisks,omitempty"`
	// MultiVMGroupName - The multi vm group name.
	MultiVMGroupName *string `json:"multiVmGroupName,omitempty"`
	// RecoveryBootDiagStorageAccountID - The boot diagnostic storage account.
	RecoveryBootDiagStorageAccountID *string `json:"recoveryBootDiagStorageAccountId,omitempty"`
	// DiskEncryptionInfo - The recovery disk encryption information.
	DiskEncryptionInfo *DiskEncryptionInfo `json:"diskEncryptionInfo,omitempty"`
	// RecoveryAvailabilityZone - The recovery availability zone.
	RecoveryAvailabilityZone *string `json:"recoveryAvailabilityZone,omitempty"`
	// RecoveryAzureNetworkID - The recovery Azure virtual network ARM id.
	RecoveryAzureNetworkID *string `json:"recoveryAzureNetworkId,omitempty"`
	// RecoverySubnetName - The recovery subnet name.
	RecoverySubnetName *string `json:"recoverySubnetName,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeEnableProtectionProviderSpecificInput', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeA2A', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMage', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMageRcm', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeSan'
	InstanceType InstanceTypeBasicEnableProtectionProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for A2AEnableProtectionInput.
func (aepi A2AEnableProtectionInput) MarshalJSON() ([]byte, error) {
	aepi.InstanceType = InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeA2A
	objectMap := make(map[string]interface{})
	if aepi.FabricObjectID != nil {
		objectMap["fabricObjectId"] = aepi.FabricObjectID
	}
	if aepi.RecoveryContainerID != nil {
		objectMap["recoveryContainerId"] = aepi.RecoveryContainerID
	}
	if aepi.RecoveryResourceGroupID != nil {
		objectMap["recoveryResourceGroupId"] = aepi.RecoveryResourceGroupID
	}
	if aepi.RecoveryCloudServiceID != nil {
		objectMap["recoveryCloudServiceId"] = aepi.RecoveryCloudServiceID
	}
	if aepi.RecoveryAvailabilitySetID != nil {
		objectMap["recoveryAvailabilitySetId"] = aepi.RecoveryAvailabilitySetID
	}
	if aepi.RecoveryProximityPlacementGroupID != nil {
		objectMap["recoveryProximityPlacementGroupId"] = aepi.RecoveryProximityPlacementGroupID
	}
	if aepi.VMDisks != nil {
		objectMap["vmDisks"] = aepi.VMDisks
	}
	if aepi.VMManagedDisks != nil {
		objectMap["vmManagedDisks"] = aepi.VMManagedDisks
	}
	if aepi.MultiVMGroupName != nil {
		objectMap["multiVmGroupName"] = aepi.MultiVMGroupName
	}
	if aepi.RecoveryBootDiagStorageAccountID != nil {
		objectMap["recoveryBootDiagStorageAccountId"] = aepi.RecoveryBootDiagStorageAccountID
	}
	if aepi.DiskEncryptionInfo != nil {
		objectMap["diskEncryptionInfo"] = aepi.DiskEncryptionInfo
	}
	if aepi.RecoveryAvailabilityZone != nil {
		objectMap["recoveryAvailabilityZone"] = aepi.RecoveryAvailabilityZone
	}
	if aepi.RecoveryAzureNetworkID != nil {
		objectMap["recoveryAzureNetworkId"] = aepi.RecoveryAzureNetworkID
	}
	if aepi.RecoverySubnetName != nil {
		objectMap["recoverySubnetName"] = aepi.RecoverySubnetName
	}
	if aepi.InstanceType != "" {
		objectMap["instanceType"] = aepi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for A2AEnableProtectionInput.
func (aepi A2AEnableProtectionInput) AsA2AEnableProtectionInput() (*A2AEnableProtectionInput, bool) {
	return &aepi, true
}

// AsHyperVReplicaAzureEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for A2AEnableProtectionInput.
func (aepi A2AEnableProtectionInput) AsHyperVReplicaAzureEnableProtectionInput() (*HyperVReplicaAzureEnableProtectionInput, bool) {
	return nil, false
}

// AsInMageAzureV2EnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for A2AEnableProtectionInput.
func (aepi A2AEnableProtectionInput) AsInMageAzureV2EnableProtectionInput() (*InMageAzureV2EnableProtectionInput, bool) {
	return nil, false
}

// AsInMageEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for A2AEnableProtectionInput.
func (aepi A2AEnableProtectionInput) AsInMageEnableProtectionInput() (*InMageEnableProtectionInput, bool) {
	return nil, false
}

// AsInMageRcmEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for A2AEnableProtectionInput.
func (aepi A2AEnableProtectionInput) AsInMageRcmEnableProtectionInput() (*InMageRcmEnableProtectionInput, bool) {
	return nil, false
}

// AsSanEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for A2AEnableProtectionInput.
func (aepi A2AEnableProtectionInput) AsSanEnableProtectionInput() (*SanEnableProtectionInput, bool) {
	return nil, false
}

// AsEnableProtectionProviderSpecificInput is the BasicEnableProtectionProviderSpecificInput implementation for A2AEnableProtectionInput.
func (aepi A2AEnableProtectionInput) AsEnableProtectionProviderSpecificInput() (*EnableProtectionProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicEnableProtectionProviderSpecificInput is the BasicEnableProtectionProviderSpecificInput implementation for A2AEnableProtectionInput.
func (aepi A2AEnableProtectionInput) AsBasicEnableProtectionProviderSpecificInput() (BasicEnableProtectionProviderSpecificInput, bool) {
	return &aepi, true
}

// A2AEventDetails model class for event details of a A2A event.
type A2AEventDetails struct {
	// ProtectedItemName - The protected item arm name.
	ProtectedItemName *string `json:"protectedItemName,omitempty"`
	// FabricObjectID - The azure vm arm id.
	FabricObjectID *string `json:"fabricObjectId,omitempty"`
	// FabricName - Fabric arm name.
	FabricName *string `json:"fabricName,omitempty"`
	// FabricLocation - The fabric location.
	FabricLocation *string `json:"fabricLocation,omitempty"`
	// RemoteFabricName - Remote fabric arm name.
	RemoteFabricName *string `json:"remoteFabricName,omitempty"`
	// RemoteFabricLocation - Remote fabric location.
	RemoteFabricLocation *string `json:"remoteFabricLocation,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeEventProviderSpecificDetails', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeA2A', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplicaBaseEventDetails', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeInMageAzureV2', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeInMageRcm'
	InstanceType InstanceTypeBasicEventProviderSpecificDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for A2AEventDetails.
func (aed A2AEventDetails) MarshalJSON() ([]byte, error) {
	aed.InstanceType = InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeA2A
	objectMap := make(map[string]interface{})
	if aed.ProtectedItemName != nil {
		objectMap["protectedItemName"] = aed.ProtectedItemName
	}
	if aed.FabricObjectID != nil {
		objectMap["fabricObjectId"] = aed.FabricObjectID
	}
	if aed.FabricName != nil {
		objectMap["fabricName"] = aed.FabricName
	}
	if aed.FabricLocation != nil {
		objectMap["fabricLocation"] = aed.FabricLocation
	}
	if aed.RemoteFabricName != nil {
		objectMap["remoteFabricName"] = aed.RemoteFabricName
	}
	if aed.RemoteFabricLocation != nil {
		objectMap["remoteFabricLocation"] = aed.RemoteFabricLocation
	}
	if aed.InstanceType != "" {
		objectMap["instanceType"] = aed.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AEventDetails is the BasicEventProviderSpecificDetails implementation for A2AEventDetails.
func (aed A2AEventDetails) AsA2AEventDetails() (*A2AEventDetails, bool) {
	return &aed, true
}

// AsHyperVReplica2012EventDetails is the BasicEventProviderSpecificDetails implementation for A2AEventDetails.
func (aed A2AEventDetails) AsHyperVReplica2012EventDetails() (*HyperVReplica2012EventDetails, bool) {
	return nil, false
}

// AsHyperVReplica2012R2EventDetails is the BasicEventProviderSpecificDetails implementation for A2AEventDetails.
func (aed A2AEventDetails) AsHyperVReplica2012R2EventDetails() (*HyperVReplica2012R2EventDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzureEventDetails is the BasicEventProviderSpecificDetails implementation for A2AEventDetails.
func (aed A2AEventDetails) AsHyperVReplicaAzureEventDetails() (*HyperVReplicaAzureEventDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBaseEventDetails is the BasicEventProviderSpecificDetails implementation for A2AEventDetails.
func (aed A2AEventDetails) AsHyperVReplicaBaseEventDetails() (*HyperVReplicaBaseEventDetails, bool) {
	return nil, false
}

// AsInMageAzureV2EventDetails is the BasicEventProviderSpecificDetails implementation for A2AEventDetails.
func (aed A2AEventDetails) AsInMageAzureV2EventDetails() (*InMageAzureV2EventDetails, bool) {
	return nil, false
}

// AsInMageRcmEventDetails is the BasicEventProviderSpecificDetails implementation for A2AEventDetails.
func (aed A2AEventDetails) AsInMageRcmEventDetails() (*InMageRcmEventDetails, bool) {
	return nil, false
}

// AsEventProviderSpecificDetails is the BasicEventProviderSpecificDetails implementation for A2AEventDetails.
func (aed A2AEventDetails) AsEventProviderSpecificDetails() (*EventProviderSpecificDetails, bool) {
	return nil, false
}

// AsBasicEventProviderSpecificDetails is the BasicEventProviderSpecificDetails implementation for A2AEventDetails.
func (aed A2AEventDetails) AsBasicEventProviderSpecificDetails() (BasicEventProviderSpecificDetails, bool) {
	return &aed, true
}

// A2AFailoverProviderInput a2A provider specific input for failover.
type A2AFailoverProviderInput struct {
	// RecoveryPointID - The recovery point id to be passed to failover to a particular recovery point. In case of latest recovery point, null should be passed.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`
	// CloudServiceCreationOption - A value indicating whether to use recovery cloud service for TFO or not.
	CloudServiceCreationOption *string `json:"cloudServiceCreationOption,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeProviderSpecificFailoverInput', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeA2A', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMage'
	InstanceType InstanceTypeBasicProviderSpecificFailoverInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for A2AFailoverProviderInput.
func (afpi A2AFailoverProviderInput) MarshalJSON() ([]byte, error) {
	afpi.InstanceType = InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeA2A
	objectMap := make(map[string]interface{})
	if afpi.RecoveryPointID != nil {
		objectMap["recoveryPointId"] = afpi.RecoveryPointID
	}
	if afpi.CloudServiceCreationOption != nil {
		objectMap["cloudServiceCreationOption"] = afpi.CloudServiceCreationOption
	}
	if afpi.InstanceType != "" {
		objectMap["instanceType"] = afpi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AFailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for A2AFailoverProviderInput.
func (afpi A2AFailoverProviderInput) AsA2AFailoverProviderInput() (*A2AFailoverProviderInput, bool) {
	return &afpi, true
}

// AsHyperVReplicaAzureFailbackProviderInput is the BasicProviderSpecificFailoverInput implementation for A2AFailoverProviderInput.
func (afpi A2AFailoverProviderInput) AsHyperVReplicaAzureFailbackProviderInput() (*HyperVReplicaAzureFailbackProviderInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzureFailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for A2AFailoverProviderInput.
func (afpi A2AFailoverProviderInput) AsHyperVReplicaAzureFailoverProviderInput() (*HyperVReplicaAzureFailoverProviderInput, bool) {
	return nil, false
}

// AsInMageAzureV2FailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for A2AFailoverProviderInput.
func (afpi A2AFailoverProviderInput) AsInMageAzureV2FailoverProviderInput() (*InMageAzureV2FailoverProviderInput, bool) {
	return nil, false
}

// AsInMageFailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for A2AFailoverProviderInput.
func (afpi A2AFailoverProviderInput) AsInMageFailoverProviderInput() (*InMageFailoverProviderInput, bool) {
	return nil, false
}

// AsProviderSpecificFailoverInput is the BasicProviderSpecificFailoverInput implementation for A2AFailoverProviderInput.
func (afpi A2AFailoverProviderInput) AsProviderSpecificFailoverInput() (*ProviderSpecificFailoverInput, bool) {
	return nil, false
}

// AsBasicProviderSpecificFailoverInput is the BasicProviderSpecificFailoverInput implementation for A2AFailoverProviderInput.
func (afpi A2AFailoverProviderInput) AsBasicProviderSpecificFailoverInput() (BasicProviderSpecificFailoverInput, bool) {
	return &afpi, true
}

// A2APolicyCreationInput a2A Policy creation input.
type A2APolicyCreationInput struct {
	// RecoveryPointHistory - The duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistory *int32 `json:"recoveryPointHistory,omitempty"`
	// CrashConsistentFrequencyInMinutes - The crash consistent snapshot frequency (in minutes).
	CrashConsistentFrequencyInMinutes *int32 `json:"crashConsistentFrequencyInMinutes,omitempty"`
	// AppConsistentFrequencyInMinutes - The app consistent snapshot frequency (in minutes).
	AppConsistentFrequencyInMinutes *int32 `json:"appConsistentFrequencyInMinutes,omitempty"`
	// MultiVMSyncStatus - A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or 'Disabled'. Possible values include: 'Enable', 'Disable'
	MultiVMSyncStatus SetMultiVMSyncStatus `json:"multiVmSyncStatus,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypePolicyProviderSpecificInput', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeA2A', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMage', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMageRcm', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeVMwareCbt'
	InstanceType InstanceTypeBasicPolicyProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for A2APolicyCreationInput.
func (apci A2APolicyCreationInput) MarshalJSON() ([]byte, error) {
	apci.InstanceType = InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeA2A
	objectMap := make(map[string]interface{})
	if apci.RecoveryPointHistory != nil {
		objectMap["recoveryPointHistory"] = apci.RecoveryPointHistory
	}
	if apci.CrashConsistentFrequencyInMinutes != nil {
		objectMap["crashConsistentFrequencyInMinutes"] = apci.CrashConsistentFrequencyInMinutes
	}
	if apci.AppConsistentFrequencyInMinutes != nil {
		objectMap["appConsistentFrequencyInMinutes"] = apci.AppConsistentFrequencyInMinutes
	}
	if apci.MultiVMSyncStatus != "" {
		objectMap["multiVmSyncStatus"] = apci.MultiVMSyncStatus
	}
	if apci.InstanceType != "" {
		objectMap["instanceType"] = apci.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2APolicyCreationInput is the BasicPolicyProviderSpecificInput implementation for A2APolicyCreationInput.
func (apci A2APolicyCreationInput) AsA2APolicyCreationInput() (*A2APolicyCreationInput, bool) {
	return &apci, true
}

// AsHyperVReplicaAzurePolicyInput is the BasicPolicyProviderSpecificInput implementation for A2APolicyCreationInput.
func (apci A2APolicyCreationInput) AsHyperVReplicaAzurePolicyInput() (*HyperVReplicaAzurePolicyInput, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyInput is the BasicPolicyProviderSpecificInput implementation for A2APolicyCreationInput.
func (apci A2APolicyCreationInput) AsHyperVReplicaBluePolicyInput() (*HyperVReplicaBluePolicyInput, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyInput is the BasicPolicyProviderSpecificInput implementation for A2APolicyCreationInput.
func (apci A2APolicyCreationInput) AsHyperVReplicaPolicyInput() (*HyperVReplicaPolicyInput, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyInput is the BasicPolicyProviderSpecificInput implementation for A2APolicyCreationInput.
func (apci A2APolicyCreationInput) AsInMageAzureV2PolicyInput() (*InMageAzureV2PolicyInput, bool) {
	return nil, false
}

// AsInMagePolicyInput is the BasicPolicyProviderSpecificInput implementation for A2APolicyCreationInput.
func (apci A2APolicyCreationInput) AsInMagePolicyInput() (*InMagePolicyInput, bool) {
	return nil, false
}

// AsInMageRcmPolicyCreationInput is the BasicPolicyProviderSpecificInput implementation for A2APolicyCreationInput.
func (apci A2APolicyCreationInput) AsInMageRcmPolicyCreationInput() (*InMageRcmPolicyCreationInput, bool) {
	return nil, false
}

// AsVMwareCbtPolicyCreationInput is the BasicPolicyProviderSpecificInput implementation for A2APolicyCreationInput.
func (apci A2APolicyCreationInput) AsVMwareCbtPolicyCreationInput() (*VMwareCbtPolicyCreationInput, bool) {
	return nil, false
}

// AsPolicyProviderSpecificInput is the BasicPolicyProviderSpecificInput implementation for A2APolicyCreationInput.
func (apci A2APolicyCreationInput) AsPolicyProviderSpecificInput() (*PolicyProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicPolicyProviderSpecificInput is the BasicPolicyProviderSpecificInput implementation for A2APolicyCreationInput.
func (apci A2APolicyCreationInput) AsBasicPolicyProviderSpecificInput() (BasicPolicyProviderSpecificInput, bool) {
	return &apci, true
}

// A2APolicyDetails a2A specific policy details.
type A2APolicyDetails struct {
	// RecoveryPointThresholdInMinutes - The recovery point threshold in minutes.
	RecoveryPointThresholdInMinutes *int32 `json:"recoveryPointThresholdInMinutes,omitempty"`
	// RecoveryPointHistory - The duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistory *int32 `json:"recoveryPointHistory,omitempty"`
	// AppConsistentFrequencyInMinutes - The app consistent snapshot frequency in minutes.
	AppConsistentFrequencyInMinutes *int32 `json:"appConsistentFrequencyInMinutes,omitempty"`
	// MultiVMSyncStatus - A value indicating whether multi-VM sync has to be enabled.
	MultiVMSyncStatus *string `json:"multiVmSyncStatus,omitempty"`
	// CrashConsistentFrequencyInMinutes - The crash consistent snapshot frequency in minutes.
	CrashConsistentFrequencyInMinutes *int32 `json:"crashConsistentFrequencyInMinutes,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypePolicyProviderSpecificDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeA2A', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaBasePolicyDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageAzureV2', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageBasePolicyDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMage', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageRcm', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeRcmAzureMigration', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeVMwareCbt'
	InstanceType InstanceTypeBasicPolicyProviderSpecificDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for A2APolicyDetails.
func (apd A2APolicyDetails) MarshalJSON() ([]byte, error) {
	apd.InstanceType = InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeA2A
	objectMap := make(map[string]interface{})
	if apd.RecoveryPointThresholdInMinutes != nil {
		objectMap["recoveryPointThresholdInMinutes"] = apd.RecoveryPointThresholdInMinutes
	}
	if apd.RecoveryPointHistory != nil {
		objectMap["recoveryPointHistory"] = apd.RecoveryPointHistory
	}
	if apd.AppConsistentFrequencyInMinutes != nil {
		objectMap["appConsistentFrequencyInMinutes"] = apd.AppConsistentFrequencyInMinutes
	}
	if apd.MultiVMSyncStatus != nil {
		objectMap["multiVmSyncStatus"] = apd.MultiVMSyncStatus
	}
	if apd.CrashConsistentFrequencyInMinutes != nil {
		objectMap["crashConsistentFrequencyInMinutes"] = apd.CrashConsistentFrequencyInMinutes
	}
	if apd.InstanceType != "" {
		objectMap["instanceType"] = apd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2APolicyDetails is the BasicPolicyProviderSpecificDetails implementation for A2APolicyDetails.
func (apd A2APolicyDetails) AsA2APolicyDetails() (*A2APolicyDetails, bool) {
	return &apd, true
}

// AsHyperVReplicaAzurePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for A2APolicyDetails.
func (apd A2APolicyDetails) AsHyperVReplicaAzurePolicyDetails() (*HyperVReplicaAzurePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBasePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for A2APolicyDetails.
func (apd A2APolicyDetails) AsHyperVReplicaBasePolicyDetails() (*HyperVReplicaBasePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for A2APolicyDetails.
func (apd A2APolicyDetails) AsHyperVReplicaBluePolicyDetails() (*HyperVReplicaBluePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for A2APolicyDetails.
func (apd A2APolicyDetails) AsHyperVReplicaPolicyDetails() (*HyperVReplicaPolicyDetails, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyDetails is the BasicPolicyProviderSpecificDetails implementation for A2APolicyDetails.
func (apd A2APolicyDetails) AsInMageAzureV2PolicyDetails() (*InMageAzureV2PolicyDetails, bool) {
	return nil, false
}

// AsInMageBasePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for A2APolicyDetails.
func (apd A2APolicyDetails) AsInMageBasePolicyDetails() (*InMageBasePolicyDetails, bool) {
	return nil, false
}

// AsInMagePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for A2APolicyDetails.
func (apd A2APolicyDetails) AsInMagePolicyDetails() (*InMagePolicyDetails, bool) {
	return nil, false
}

// AsInMageRcmPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for A2APolicyDetails.
func (apd A2APolicyDetails) AsInMageRcmPolicyDetails() (*InMageRcmPolicyDetails, bool) {
	return nil, false
}

// AsRcmAzureMigrationPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for A2APolicyDetails.
func (apd A2APolicyDetails) AsRcmAzureMigrationPolicyDetails() (*RcmAzureMigrationPolicyDetails, bool) {
	return nil, false
}

// AsVmwareCbtPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for A2APolicyDetails.
func (apd A2APolicyDetails) AsVmwareCbtPolicyDetails() (*VmwareCbtPolicyDetails, bool) {
	return nil, false
}

// AsPolicyProviderSpecificDetails is the BasicPolicyProviderSpecificDetails implementation for A2APolicyDetails.
func (apd A2APolicyDetails) AsPolicyProviderSpecificDetails() (*PolicyProviderSpecificDetails, bool) {
	return nil, false
}

// AsBasicPolicyProviderSpecificDetails is the BasicPolicyProviderSpecificDetails implementation for A2APolicyDetails.
func (apd A2APolicyDetails) AsBasicPolicyProviderSpecificDetails() (BasicPolicyProviderSpecificDetails, bool) {
	return &apd, true
}

// A2AProtectedDiskDetails a2A protected disk details.
type A2AProtectedDiskDetails struct {
	// DiskURI - The disk uri.
	DiskURI *string `json:"diskUri,omitempty"`
	// RecoveryAzureStorageAccountID - The recovery disk storage account.
	RecoveryAzureStorageAccountID *string `json:"recoveryAzureStorageAccountId,omitempty"`
	// PrimaryDiskAzureStorageAccountID - The primary disk storage account.
	PrimaryDiskAzureStorageAccountID *string `json:"primaryDiskAzureStorageAccountId,omitempty"`
	// RecoveryDiskURI - Recovery disk uri.
	RecoveryDiskURI *string `json:"recoveryDiskUri,omitempty"`
	// DiskName - The disk name.
	DiskName *string `json:"diskName,omitempty"`
	// DiskCapacityInBytes - The disk capacity in bytes.
	DiskCapacityInBytes *int64 `json:"diskCapacityInBytes,omitempty"`
	// PrimaryStagingAzureStorageAccountID - The primary staging storage account.
	PrimaryStagingAzureStorageAccountID *string `json:"primaryStagingAzureStorageAccountId,omitempty"`
	// DiskType - The type of disk.
	DiskType *string `json:"diskType,omitempty"`
	// ResyncRequired - A value indicating whether resync is required for this disk.
	ResyncRequired *bool `json:"resyncRequired,omitempty"`
	// MonitoringPercentageCompletion - The percentage of the monitoring job. The type of the monitoring job is defined by MonitoringJobType property.
	MonitoringPercentageCompletion *int32 `json:"monitoringPercentageCompletion,omitempty"`
	// MonitoringJobType - The type of the monitoring job. The progress is contained in MonitoringPercentageCompletion property.
	MonitoringJobType *string `json:"monitoringJobType,omitempty"`
	// DataPendingInStagingStorageAccountInMB - The data pending for replication in MB at staging account.
	DataPendingInStagingStorageAccountInMB *float64 `json:"dataPendingInStagingStorageAccountInMB,omitempty"`
	// DataPendingAtSourceAgentInMB - The data pending at source virtual machine in MB.
	DataPendingAtSourceAgentInMB *float64 `json:"dataPendingAtSourceAgentInMB,omitempty"`
	// DiskState - The disk state.
	DiskState *string `json:"diskState,omitempty"`
	// AllowedDiskLevelOperation - The disk level operations list.
	AllowedDiskLevelOperation *[]string `json:"allowedDiskLevelOperation,omitempty"`
	// IsDiskEncrypted - A value indicating whether vm has encrypted os disk or not.
	IsDiskEncrypted *bool `json:"isDiskEncrypted,omitempty"`
	// SecretIdentifier - The secret URL / identifier (BEK).
	SecretIdentifier *string `json:"secretIdentifier,omitempty"`
	// DekKeyVaultArmID - The KeyVault resource id for secret (BEK).
	DekKeyVaultArmID *string `json:"dekKeyVaultArmId,omitempty"`
	// IsDiskKeyEncrypted - A value indicating whether disk key got encrypted or not.
	IsDiskKeyEncrypted *bool `json:"isDiskKeyEncrypted,omitempty"`
	// KeyIdentifier - The key URL / identifier (KEK).
	KeyIdentifier *string `json:"keyIdentifier,omitempty"`
	// KekKeyVaultArmID - The KeyVault resource id for key (KEK).
	KekKeyVaultArmID *string `json:"kekKeyVaultArmId,omitempty"`
}

// A2AProtectedManagedDiskDetails a2A protected managed disk details.
type A2AProtectedManagedDiskDetails struct {
	// DiskID - The managed disk Arm id.
	DiskID *string `json:"diskId,omitempty"`
	// RecoveryResourceGroupID - The recovery disk resource group Arm Id.
	RecoveryResourceGroupID *string `json:"recoveryResourceGroupId,omitempty"`
	// RecoveryTargetDiskID - Recovery target disk Arm Id.
	RecoveryTargetDiskID *string `json:"recoveryTargetDiskId,omitempty"`
	// RecoveryReplicaDiskID - Recovery replica disk Arm Id.
	RecoveryReplicaDiskID *string `json:"recoveryReplicaDiskId,omitempty"`
	// RecoveryReplicaDiskAccountType - The replica disk type. Its an optional value and will be same as source disk type if not user provided.
	RecoveryReplicaDiskAccountType *string `json:"recoveryReplicaDiskAccountType,omitempty"`
	// RecoveryTargetDiskAccountType - The target disk type after failover. Its an optional value and will be same as source disk type if not user provided.
	RecoveryTargetDiskAccountType *string `json:"recoveryTargetDiskAccountType,omitempty"`
	// RecoveryDiskEncryptionSetID - The recovery disk encryption set Id.
	RecoveryDiskEncryptionSetID *string `json:"recoveryDiskEncryptionSetId,omitempty"`
	// DiskName - The disk name.
	DiskName *string `json:"diskName,omitempty"`
	// DiskCapacityInBytes - The disk capacity in bytes.
	DiskCapacityInBytes *int64 `json:"diskCapacityInBytes,omitempty"`
	// PrimaryStagingAzureStorageAccountID - The primary staging storage account.
	PrimaryStagingAzureStorageAccountID *string `json:"primaryStagingAzureStorageAccountId,omitempty"`
	// DiskType - The type of disk.
	DiskType *string `json:"diskType,omitempty"`
	// ResyncRequired - A value indicating whether resync is required for this disk.
	ResyncRequired *bool `json:"resyncRequired,omitempty"`
	// MonitoringPercentageCompletion - The percentage of the monitoring job. The type of the monitoring job is defined by MonitoringJobType property.
	MonitoringPercentageCompletion *int32 `json:"monitoringPercentageCompletion,omitempty"`
	// MonitoringJobType - The type of the monitoring job. The progress is contained in MonitoringPercentageCompletion property.
	MonitoringJobType *string `json:"monitoringJobType,omitempty"`
	// DataPendingInStagingStorageAccountInMB - The data pending for replication in MB at staging account.
	DataPendingInStagingStorageAccountInMB *float64 `json:"dataPendingInStagingStorageAccountInMB,omitempty"`
	// DataPendingAtSourceAgentInMB - The data pending at source virtual machine in MB.
	DataPendingAtSourceAgentInMB *float64 `json:"dataPendingAtSourceAgentInMB,omitempty"`
	// DiskState - The disk state.
	DiskState *string `json:"diskState,omitempty"`
	// AllowedDiskLevelOperation - The disk level operations list.
	AllowedDiskLevelOperation *[]string `json:"allowedDiskLevelOperation,omitempty"`
	// IsDiskEncrypted - A value indicating whether vm has encrypted os disk or not.
	IsDiskEncrypted *bool `json:"isDiskEncrypted,omitempty"`
	// SecretIdentifier - The secret URL / identifier (BEK).
	SecretIdentifier *string `json:"secretIdentifier,omitempty"`
	// DekKeyVaultArmID - The KeyVault resource id for secret (BEK).
	DekKeyVaultArmID *string `json:"dekKeyVaultArmId,omitempty"`
	// IsDiskKeyEncrypted - A value indicating whether disk key got encrypted or not.
	IsDiskKeyEncrypted *bool `json:"isDiskKeyEncrypted,omitempty"`
	// KeyIdentifier - The key URL / identifier (KEK).
	KeyIdentifier *string `json:"keyIdentifier,omitempty"`
	// KekKeyVaultArmID - The KeyVault resource id for key (KEK).
	KekKeyVaultArmID *string `json:"kekKeyVaultArmId,omitempty"`
	// FailoverDiskName - The failover name for the managed disk.
	FailoverDiskName *string `json:"failoverDiskName,omitempty"`
	// TfoDiskName - The test failover name for the managed disk.
	TfoDiskName *string `json:"tfoDiskName,omitempty"`
}

// A2AProtectionContainerMappingDetails a2A provider specific settings.
type A2AProtectionContainerMappingDetails struct {
	// AgentAutoUpdateStatus - A value indicating whether the auto update is enabled. Possible values include: 'Disabled', 'Enabled'
	AgentAutoUpdateStatus AgentAutoUpdateStatus `json:"agentAutoUpdateStatus,omitempty"`
	// AutomationAccountArmID - The automation account arm id.
	AutomationAccountArmID *string `json:"automationAccountArmId,omitempty"`
	// ScheduleName - The schedule arm name.
	ScheduleName *string `json:"scheduleName,omitempty"`
	// JobScheduleName - The job schedule arm name.
	JobScheduleName *string `json:"jobScheduleName,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicProtectionContainerMappingProviderSpecificDetailsInstanceTypeProtectionContainerMappingProviderSpecificDetails', 'InstanceTypeBasicProtectionContainerMappingProviderSpecificDetailsInstanceTypeA2A', 'InstanceTypeBasicProtectionContainerMappingProviderSpecificDetailsInstanceTypeVMwareCbt'
	InstanceType InstanceTypeBasicProtectionContainerMappingProviderSpecificDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for A2AProtectionContainerMappingDetails.
func (apcmd A2AProtectionContainerMappingDetails) MarshalJSON() ([]byte, error) {
	apcmd.InstanceType = InstanceTypeBasicProtectionContainerMappingProviderSpecificDetailsInstanceTypeA2A
	objectMap := make(map[string]interface{})
	if apcmd.AgentAutoUpdateStatus != "" {
		objectMap["agentAutoUpdateStatus"] = apcmd.AgentAutoUpdateStatus
	}
	if apcmd.AutomationAccountArmID != nil {
		objectMap["automationAccountArmId"] = apcmd.AutomationAccountArmID
	}
	if apcmd.ScheduleName != nil {
		objectMap["scheduleName"] = apcmd.ScheduleName
	}
	if apcmd.JobScheduleName != nil {
		objectMap["jobScheduleName"] = apcmd.JobScheduleName
	}
	if apcmd.InstanceType != "" {
		objectMap["instanceType"] = apcmd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AProtectionContainerMappingDetails is the BasicProtectionContainerMappingProviderSpecificDetails implementation for A2AProtectionContainerMappingDetails.
func (apcmd A2AProtectionContainerMappingDetails) AsA2AProtectionContainerMappingDetails() (*A2AProtectionContainerMappingDetails, bool) {
	return &apcmd, true
}

// AsVMwareCbtProtectionContainerMappingDetails is the BasicProtectionContainerMappingProviderSpecificDetails implementation for A2AProtectionContainerMappingDetails.
func (apcmd A2AProtectionContainerMappingDetails) AsVMwareCbtProtectionContainerMappingDetails() (*VMwareCbtProtectionContainerMappingDetails, bool) {
	return nil, false
}

// AsProtectionContainerMappingProviderSpecificDetails is the BasicProtectionContainerMappingProviderSpecificDetails implementation for A2AProtectionContainerMappingDetails.
func (apcmd A2AProtectionContainerMappingDetails) AsProtectionContainerMappingProviderSpecificDetails() (*ProtectionContainerMappingProviderSpecificDetails, bool) {
	return nil, false
}

// AsBasicProtectionContainerMappingProviderSpecificDetails is the BasicProtectionContainerMappingProviderSpecificDetails implementation for A2AProtectionContainerMappingDetails.
func (apcmd A2AProtectionContainerMappingDetails) AsBasicProtectionContainerMappingProviderSpecificDetails() (BasicProtectionContainerMappingProviderSpecificDetails, bool) {
	return &apcmd, true
}

// A2AProtectionIntentDiskInputDetails azure VM disk input details.
type A2AProtectionIntentDiskInputDetails struct {
	// DiskURI - The disk Uri.
	DiskURI *string `json:"diskUri,omitempty"`
	// RecoveryAzureStorageAccountCustomInput - The recovery VHD storage account input.
	RecoveryAzureStorageAccountCustomInput BasicStorageAccountCustomDetails `json:"recoveryAzureStorageAccountCustomInput,omitempty"`
	// PrimaryStagingStorageAccountCustomInput - The primary staging storage account input.
	PrimaryStagingStorageAccountCustomInput BasicStorageAccountCustomDetails `json:"primaryStagingStorageAccountCustomInput,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for A2AProtectionIntentDiskInputDetails struct.
func (apidid *A2AProtectionIntentDiskInputDetails) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "diskUri":
			if v != nil {
				var diskURI string
				err = json.Unmarshal(*v, &diskURI)
				if err != nil {
					return err
				}
				apidid.DiskURI = &diskURI
			}
		case "recoveryAzureStorageAccountCustomInput":
			if v != nil {
				recoveryAzureStorageAccountCustomInput, err := unmarshalBasicStorageAccountCustomDetails(*v)
				if err != nil {
					return err
				}
				apidid.RecoveryAzureStorageAccountCustomInput = recoveryAzureStorageAccountCustomInput
			}
		case "primaryStagingStorageAccountCustomInput":
			if v != nil {
				primaryStagingStorageAccountCustomInput, err := unmarshalBasicStorageAccountCustomDetails(*v)
				if err != nil {
					return err
				}
				apidid.PrimaryStagingStorageAccountCustomInput = primaryStagingStorageAccountCustomInput
			}
		}
	}

	return nil
}

// A2AProtectionIntentManagedDiskInputDetails azure VM managed disk input details.
type A2AProtectionIntentManagedDiskInputDetails struct {
	// DiskID - The disk Id.
	DiskID *string `json:"diskId,omitempty"`
	// PrimaryStagingStorageAccountCustomInput - The primary staging storage account input.
	PrimaryStagingStorageAccountCustomInput BasicStorageAccountCustomDetails `json:"primaryStagingStorageAccountCustomInput,omitempty"`
	// RecoveryResourceGroupCustomInput - The recovery resource group input.
	RecoveryResourceGroupCustomInput BasicRecoveryResourceGroupCustomDetails `json:"recoveryResourceGroupCustomInput,omitempty"`
	// RecoveryReplicaDiskAccountType - The replica disk type. Its an optional value and will be same as source disk type if not user provided.
	RecoveryReplicaDiskAccountType *string `json:"recoveryReplicaDiskAccountType,omitempty"`
	// RecoveryTargetDiskAccountType - The target disk type after failover. Its an optional value and will be same as source disk type if not user provided.
	RecoveryTargetDiskAccountType *string `json:"recoveryTargetDiskAccountType,omitempty"`
	// RecoveryDiskEncryptionSetID - The recovery disk encryption set Id.
	RecoveryDiskEncryptionSetID *string `json:"recoveryDiskEncryptionSetId,omitempty"`
	// DiskEncryptionInfo - The recovery disk encryption information (for one / single pass flows).
	DiskEncryptionInfo *DiskEncryptionInfo `json:"diskEncryptionInfo,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for A2AProtectionIntentManagedDiskInputDetails struct.
func (apimdid *A2AProtectionIntentManagedDiskInputDetails) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "diskId":
			if v != nil {
				var diskID string
				err = json.Unmarshal(*v, &diskID)
				if err != nil {
					return err
				}
				apimdid.DiskID = &diskID
			}
		case "primaryStagingStorageAccountCustomInput":
			if v != nil {
				primaryStagingStorageAccountCustomInput, err := unmarshalBasicStorageAccountCustomDetails(*v)
				if err != nil {
					return err
				}
				apimdid.PrimaryStagingStorageAccountCustomInput = primaryStagingStorageAccountCustomInput
			}
		case "recoveryResourceGroupCustomInput":
			if v != nil {
				recoveryResourceGroupCustomInput, err := unmarshalBasicRecoveryResourceGroupCustomDetails(*v)
				if err != nil {
					return err
				}
				apimdid.RecoveryResourceGroupCustomInput = recoveryResourceGroupCustomInput
			}
		case "recoveryReplicaDiskAccountType":
			if v != nil {
				var recoveryReplicaDiskAccountType string
				err = json.Unmarshal(*v, &recoveryReplicaDiskAccountType)
				if err != nil {
					return err
				}
				apimdid.RecoveryReplicaDiskAccountType = &recoveryReplicaDiskAccountType
			}
		case "recoveryTargetDiskAccountType":
			if v != nil {
				var recoveryTargetDiskAccountType string
				err = json.Unmarshal(*v, &recoveryTargetDiskAccountType)
				if err != nil {
					return err
				}
				apimdid.RecoveryTargetDiskAccountType = &recoveryTargetDiskAccountType
			}
		case "recoveryDiskEncryptionSetId":
			if v != nil {
				var recoveryDiskEncryptionSetID string
				err = json.Unmarshal(*v, &recoveryDiskEncryptionSetID)
				if err != nil {
					return err
				}
				apimdid.RecoveryDiskEncryptionSetID = &recoveryDiskEncryptionSetID
			}
		case "diskEncryptionInfo":
			if v != nil {
				var diskEncryptionInfo DiskEncryptionInfo
				err = json.Unmarshal(*v, &diskEncryptionInfo)
				if err != nil {
					return err
				}
				apimdid.DiskEncryptionInfo = &diskEncryptionInfo
			}
		}
	}

	return nil
}

// A2ARecoveryPointDetails a2A provider specific recovery point details.
type A2ARecoveryPointDetails struct {
	// RecoveryPointSyncType - A value indicating whether the recovery point is multi VM consistent. Possible values include: 'MultiVMSyncRecoveryPoint', 'PerVMRecoveryPoint'
	RecoveryPointSyncType RecoveryPointSyncType `json:"recoveryPointSyncType,omitempty"`
	// Disks - List of disk ids representing a recovery point.
	Disks *[]string `json:"disks,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicProviderSpecificRecoveryPointDetailsInstanceTypeProviderSpecificRecoveryPointDetails', 'InstanceTypeBasicProviderSpecificRecoveryPointDetailsInstanceTypeA2A', 'InstanceTypeBasicProviderSpecificRecoveryPointDetailsInstanceTypeInMageAzureV2', 'InstanceTypeBasicProviderSpecificRecoveryPointDetailsInstanceTypeInMageRcm'
	InstanceType InstanceTypeBasicProviderSpecificRecoveryPointDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for A2ARecoveryPointDetails.
func (arpd A2ARecoveryPointDetails) MarshalJSON() ([]byte, error) {
	arpd.InstanceType = InstanceTypeBasicProviderSpecificRecoveryPointDetailsInstanceTypeA2A
	objectMap := make(map[string]interface{})
	if arpd.RecoveryPointSyncType != "" {
		objectMap["recoveryPointSyncType"] = arpd.RecoveryPointSyncType
	}
	if arpd.Disks != nil {
		objectMap["disks"] = arpd.Disks
	}
	if arpd.InstanceType != "" {
		objectMap["instanceType"] = arpd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2ARecoveryPointDetails is the BasicProviderSpecificRecoveryPointDetails implementation for A2ARecoveryPointDetails.
func (arpd A2ARecoveryPointDetails) AsA2ARecoveryPointDetails() (*A2ARecoveryPointDetails, bool) {
	return &arpd, true
}

// AsInMageAzureV2RecoveryPointDetails is the BasicProviderSpecificRecoveryPointDetails implementation for A2ARecoveryPointDetails.
func (arpd A2ARecoveryPointDetails) AsInMageAzureV2RecoveryPointDetails() (*InMageAzureV2RecoveryPointDetails, bool) {
	return nil, false
}

// AsInMageRcmRecoveryPointDetails is the BasicProviderSpecificRecoveryPointDetails implementation for A2ARecoveryPointDetails.
func (arpd A2ARecoveryPointDetails) AsInMageRcmRecoveryPointDetails() (*InMageRcmRecoveryPointDetails, bool) {
	return nil, false
}

// AsProviderSpecificRecoveryPointDetails is the BasicProviderSpecificRecoveryPointDetails implementation for A2ARecoveryPointDetails.
func (arpd A2ARecoveryPointDetails) AsProviderSpecificRecoveryPointDetails() (*ProviderSpecificRecoveryPointDetails, bool) {
	return nil, false
}

// AsBasicProviderSpecificRecoveryPointDetails is the BasicProviderSpecificRecoveryPointDetails implementation for A2ARecoveryPointDetails.
func (arpd A2ARecoveryPointDetails) AsBasicProviderSpecificRecoveryPointDetails() (BasicProviderSpecificRecoveryPointDetails, bool) {
	return &arpd, true
}

// A2ARemoveDisksInput a2A remove disk(s) input.
type A2ARemoveDisksInput struct {
	// VMDisksUris - The list of vm disk vhd URIs.
	VMDisksUris *[]string `json:"vmDisksUris,omitempty"`
	// VMManagedDisksIds - The list of vm managed disk Ids.
	VMManagedDisksIds *[]string `json:"vmManagedDisksIds,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicRemoveDisksProviderSpecificInputInstanceTypeRemoveDisksProviderSpecificInput', 'InstanceTypeBasicRemoveDisksProviderSpecificInputInstanceTypeA2A'
	InstanceType InstanceTypeBasicRemoveDisksProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for A2ARemoveDisksInput.
func (ardi A2ARemoveDisksInput) MarshalJSON() ([]byte, error) {
	ardi.InstanceType = InstanceTypeBasicRemoveDisksProviderSpecificInputInstanceTypeA2A
	objectMap := make(map[string]interface{})
	if ardi.VMDisksUris != nil {
		objectMap["vmDisksUris"] = ardi.VMDisksUris
	}
	if ardi.VMManagedDisksIds != nil {
		objectMap["vmManagedDisksIds"] = ardi.VMManagedDisksIds
	}
	if ardi.InstanceType != "" {
		objectMap["instanceType"] = ardi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2ARemoveDisksInput is the BasicRemoveDisksProviderSpecificInput implementation for A2ARemoveDisksInput.
func (ardi A2ARemoveDisksInput) AsA2ARemoveDisksInput() (*A2ARemoveDisksInput, bool) {
	return &ardi, true
}

// AsRemoveDisksProviderSpecificInput is the BasicRemoveDisksProviderSpecificInput implementation for A2ARemoveDisksInput.
func (ardi A2ARemoveDisksInput) AsRemoveDisksProviderSpecificInput() (*RemoveDisksProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicRemoveDisksProviderSpecificInput is the BasicRemoveDisksProviderSpecificInput implementation for A2ARemoveDisksInput.
func (ardi A2ARemoveDisksInput) AsBasicRemoveDisksProviderSpecificInput() (BasicRemoveDisksProviderSpecificInput, bool) {
	return &ardi, true
}

// A2AReplicationDetails a2A provider specific settings.
type A2AReplicationDetails struct {
	// FabricObjectID - The fabric specific object Id of the virtual machine.
	FabricObjectID *string `json:"fabricObjectId,omitempty"`
	// InitialPrimaryFabricLocation - READ-ONLY; The initial primary fabric location.
	InitialPrimaryFabricLocation *string `json:"initialPrimaryFabricLocation,omitempty"`
	// InitialRecoveryFabricLocation - READ-ONLY; The initial recovery fabric location.
	InitialRecoveryFabricLocation *string `json:"initialRecoveryFabricLocation,omitempty"`
	// InitialPrimaryZone - READ-ONLY; The initial primary availability zone.
	InitialPrimaryZone *string `json:"initialPrimaryZone,omitempty"`
	// InitialRecoveryZone - READ-ONLY; The initial recovery availability zone.
	InitialRecoveryZone *string `json:"initialRecoveryZone,omitempty"`
	// MultiVMGroupID - The multi vm group Id.
	MultiVMGroupID *string `json:"multiVmGroupId,omitempty"`
	// MultiVMGroupName - The multi vm group name.
	MultiVMGroupName *string `json:"multiVmGroupName,omitempty"`
	// MultiVMGroupCreateOption - Whether Multi VM group is auto created or specified by user. Possible values include: 'AutoCreated', 'UserSpecified'
	MultiVMGroupCreateOption MultiVMGroupCreateOption `json:"multiVmGroupCreateOption,omitempty"`
	// ManagementID - The management Id.
	ManagementID *string `json:"managementId,omitempty"`
	// ProtectedDisks - The list of protected disks.
	ProtectedDisks *[]A2AProtectedDiskDetails `json:"protectedDisks,omitempty"`
	// UnprotectedDisks - The list of unprotected disks.
	UnprotectedDisks *[]A2AUnprotectedDiskDetails `json:"unprotectedDisks,omitempty"`
	// ProtectedManagedDisks - The list of protected managed disks.
	ProtectedManagedDisks *[]A2AProtectedManagedDiskDetails `json:"protectedManagedDisks,omitempty"`
	// RecoveryBootDiagStorageAccountID - The recovery boot diagnostic storage account Arm Id.
	RecoveryBootDiagStorageAccountID *string `json:"recoveryBootDiagStorageAccountId,omitempty"`
	// PrimaryFabricLocation - Primary fabric location.
	PrimaryFabricLocation *string `json:"primaryFabricLocation,omitempty"`
	// RecoveryFabricLocation - The recovery fabric location.
	RecoveryFabricLocation *string `json:"recoveryFabricLocation,omitempty"`
	// OsType - The type of operating system.
	OsType *string `json:"osType,omitempty"`
	// RecoveryAzureVMSize - The size of recovery virtual machine.
	RecoveryAzureVMSize *string `json:"recoveryAzureVMSize,omitempty"`
	// RecoveryAzureVMName - The name of recovery virtual machine.
	RecoveryAzureVMName *string `json:"recoveryAzureVMName,omitempty"`
	// RecoveryAzureResourceGroupID - The recovery resource group.
	RecoveryAzureResourceGroupID *string `json:"recoveryAzureResourceGroupId,omitempty"`
	// RecoveryCloudService - The recovery cloud service.
	RecoveryCloudService *string `json:"recoveryCloudService,omitempty"`
	// RecoveryAvailabilitySet - The recovery availability set.
	RecoveryAvailabilitySet *string `json:"recoveryAvailabilitySet,omitempty"`
	// SelectedRecoveryAzureNetworkID - The recovery virtual network.
	SelectedRecoveryAzureNetworkID *string `json:"selectedRecoveryAzureNetworkId,omitempty"`
	// SelectedTfoAzureNetworkID - The test failover virtual network.
	SelectedTfoAzureNetworkID *string `json:"selectedTfoAzureNetworkId,omitempty"`
	// VMNics - The virtual machine nic details.
	VMNics *[]VMNicDetails `json:"vmNics,omitempty"`
	// VMSyncedConfigDetails - The synced configuration details.
	VMSyncedConfigDetails *AzureToAzureVMSyncedConfigDetails `json:"vmSyncedConfigDetails,omitempty"`
	// MonitoringPercentageCompletion - The percentage of the monitoring job. The type of the monitoring job is defined by MonitoringJobType property.
	MonitoringPercentageCompletion *int32 `json:"monitoringPercentageCompletion,omitempty"`
	// MonitoringJobType - The type of the monitoring job. The progress is contained in MonitoringPercentageCompletion property.
	MonitoringJobType *string `json:"monitoringJobType,omitempty"`
	// LastHeartbeat - The last heartbeat received from the source server.
	LastHeartbeat *date.Time `json:"lastHeartbeat,omitempty"`
	// AgentVersion - The agent version.
	AgentVersion *string `json:"agentVersion,omitempty"`
	// IsReplicationAgentUpdateRequired - A value indicating whether replication agent update is required.
	IsReplicationAgentUpdateRequired *bool `json:"isReplicationAgentUpdateRequired,omitempty"`
	// RecoveryFabricObjectID - The recovery fabric object Id.
	RecoveryFabricObjectID *string `json:"recoveryFabricObjectId,omitempty"`
	// VMProtectionState - The protection state for the vm.
	VMProtectionState *string `json:"vmProtectionState,omitempty"`
	// VMProtectionStateDescription - The protection state description for the vm.
	VMProtectionStateDescription *string `json:"vmProtectionStateDescription,omitempty"`
	// LifecycleID - An id associated with the PE that survives actions like switch protection which change the backing PE/CPE objects internally.The lifecycle id gets carried forward to have a link/continuity in being able to have an Id that denotes the "same" protected item even though other internal Ids/ARM Id might be changing.
	LifecycleID *string `json:"lifecycleId,omitempty"`
	// TestFailoverRecoveryFabricObjectID - The test failover fabric object Id.
	TestFailoverRecoveryFabricObjectID *string `json:"testFailoverRecoveryFabricObjectId,omitempty"`
	// RpoInSeconds - The last RPO value in seconds.
	RpoInSeconds *int64 `json:"rpoInSeconds,omitempty"`
	// LastRpoCalculatedTime - The time (in UTC) when the last RPO value was calculated by Protection Service.
	LastRpoCalculatedTime *date.Time `json:"lastRpoCalculatedTime,omitempty"`
	// RecoveryAvailabilityZone - The recovery availability zone.
	RecoveryAvailabilityZone *string `json:"recoveryAvailabilityZone,omitempty"`
	// VMEncryptionType - READ-ONLY; The encryption type of the VM. Possible values include: 'NotEncrypted', 'OnePassEncrypted', 'TwoPassEncrypted'
	VMEncryptionType VMEncryptionType `json:"vmEncryptionType,omitempty"`
	// TfoAzureVMName - The test failover VM name.
	TfoAzureVMName *string `json:"tfoAzureVMName,omitempty"`
	// RecoveryProximityPlacementGroupID - The recovery proximity placement group Id.
	RecoveryProximityPlacementGroupID *string `json:"recoveryProximityPlacementGroupId,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeReplicationProviderSpecificSettings', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeA2A', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaBaseReplicationDetails', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMageAzureV2', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMageRcm', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMage'
	InstanceType InstanceTypeBasicReplicationProviderSpecificSettings `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for A2AReplicationDetails.
func (ard A2AReplicationDetails) MarshalJSON() ([]byte, error) {
	ard.InstanceType = InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeA2A
	objectMap := make(map[string]interface{})
	if ard.FabricObjectID != nil {
		objectMap["fabricObjectId"] = ard.FabricObjectID
	}
	if ard.MultiVMGroupID != nil {
		objectMap["multiVmGroupId"] = ard.MultiVMGroupID
	}
	if ard.MultiVMGroupName != nil {
		objectMap["multiVmGroupName"] = ard.MultiVMGroupName
	}
	if ard.MultiVMGroupCreateOption != "" {
		objectMap["multiVmGroupCreateOption"] = ard.MultiVMGroupCreateOption
	}
	if ard.ManagementID != nil {
		objectMap["managementId"] = ard.ManagementID
	}
	if ard.ProtectedDisks != nil {
		objectMap["protectedDisks"] = ard.ProtectedDisks
	}
	if ard.UnprotectedDisks != nil {
		objectMap["unprotectedDisks"] = ard.UnprotectedDisks
	}
	if ard.ProtectedManagedDisks != nil {
		objectMap["protectedManagedDisks"] = ard.ProtectedManagedDisks
	}
	if ard.RecoveryBootDiagStorageAccountID != nil {
		objectMap["recoveryBootDiagStorageAccountId"] = ard.RecoveryBootDiagStorageAccountID
	}
	if ard.PrimaryFabricLocation != nil {
		objectMap["primaryFabricLocation"] = ard.PrimaryFabricLocation
	}
	if ard.RecoveryFabricLocation != nil {
		objectMap["recoveryFabricLocation"] = ard.RecoveryFabricLocation
	}
	if ard.OsType != nil {
		objectMap["osType"] = ard.OsType
	}
	if ard.RecoveryAzureVMSize != nil {
		objectMap["recoveryAzureVMSize"] = ard.RecoveryAzureVMSize
	}
	if ard.RecoveryAzureVMName != nil {
		objectMap["recoveryAzureVMName"] = ard.RecoveryAzureVMName
	}
	if ard.RecoveryAzureResourceGroupID != nil {
		objectMap["recoveryAzureResourceGroupId"] = ard.RecoveryAzureResourceGroupID
	}
	if ard.RecoveryCloudService != nil {
		objectMap["recoveryCloudService"] = ard.RecoveryCloudService
	}
	if ard.RecoveryAvailabilitySet != nil {
		objectMap["recoveryAvailabilitySet"] = ard.RecoveryAvailabilitySet
	}
	if ard.SelectedRecoveryAzureNetworkID != nil {
		objectMap["selectedRecoveryAzureNetworkId"] = ard.SelectedRecoveryAzureNetworkID
	}
	if ard.SelectedTfoAzureNetworkID != nil {
		objectMap["selectedTfoAzureNetworkId"] = ard.SelectedTfoAzureNetworkID
	}
	if ard.VMNics != nil {
		objectMap["vmNics"] = ard.VMNics
	}
	if ard.VMSyncedConfigDetails != nil {
		objectMap["vmSyncedConfigDetails"] = ard.VMSyncedConfigDetails
	}
	if ard.MonitoringPercentageCompletion != nil {
		objectMap["monitoringPercentageCompletion"] = ard.MonitoringPercentageCompletion
	}
	if ard.MonitoringJobType != nil {
		objectMap["monitoringJobType"] = ard.MonitoringJobType
	}
	if ard.LastHeartbeat != nil {
		objectMap["lastHeartbeat"] = ard.LastHeartbeat
	}
	if ard.AgentVersion != nil {
		objectMap["agentVersion"] = ard.AgentVersion
	}
	if ard.IsReplicationAgentUpdateRequired != nil {
		objectMap["isReplicationAgentUpdateRequired"] = ard.IsReplicationAgentUpdateRequired
	}
	if ard.RecoveryFabricObjectID != nil {
		objectMap["recoveryFabricObjectId"] = ard.RecoveryFabricObjectID
	}
	if ard.VMProtectionState != nil {
		objectMap["vmProtectionState"] = ard.VMProtectionState
	}
	if ard.VMProtectionStateDescription != nil {
		objectMap["vmProtectionStateDescription"] = ard.VMProtectionStateDescription
	}
	if ard.LifecycleID != nil {
		objectMap["lifecycleId"] = ard.LifecycleID
	}
	if ard.TestFailoverRecoveryFabricObjectID != nil {
		objectMap["testFailoverRecoveryFabricObjectId"] = ard.TestFailoverRecoveryFabricObjectID
	}
	if ard.RpoInSeconds != nil {
		objectMap["rpoInSeconds"] = ard.RpoInSeconds
	}
	if ard.LastRpoCalculatedTime != nil {
		objectMap["lastRpoCalculatedTime"] = ard.LastRpoCalculatedTime
	}
	if ard.RecoveryAvailabilityZone != nil {
		objectMap["recoveryAvailabilityZone"] = ard.RecoveryAvailabilityZone
	}
	if ard.TfoAzureVMName != nil {
		objectMap["tfoAzureVMName"] = ard.TfoAzureVMName
	}
	if ard.RecoveryProximityPlacementGroupID != nil {
		objectMap["recoveryProximityPlacementGroupId"] = ard.RecoveryProximityPlacementGroupID
	}
	if ard.InstanceType != "" {
		objectMap["instanceType"] = ard.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for A2AReplicationDetails.
func (ard A2AReplicationDetails) AsA2AReplicationDetails() (*A2AReplicationDetails, bool) {
	return &ard, true
}

// AsHyperVReplicaAzureReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for A2AReplicationDetails.
func (ard A2AReplicationDetails) AsHyperVReplicaAzureReplicationDetails() (*HyperVReplicaAzureReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBaseReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for A2AReplicationDetails.
func (ard A2AReplicationDetails) AsHyperVReplicaBaseReplicationDetails() (*HyperVReplicaBaseReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBlueReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for A2AReplicationDetails.
func (ard A2AReplicationDetails) AsHyperVReplicaBlueReplicationDetails() (*HyperVReplicaBlueReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for A2AReplicationDetails.
func (ard A2AReplicationDetails) AsHyperVReplicaReplicationDetails() (*HyperVReplicaReplicationDetails, bool) {
	return nil, false
}

// AsInMageAzureV2ReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for A2AReplicationDetails.
func (ard A2AReplicationDetails) AsInMageAzureV2ReplicationDetails() (*InMageAzureV2ReplicationDetails, bool) {
	return nil, false
}

// AsInMageRcmReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for A2AReplicationDetails.
func (ard A2AReplicationDetails) AsInMageRcmReplicationDetails() (*InMageRcmReplicationDetails, bool) {
	return nil, false
}

// AsInMageReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for A2AReplicationDetails.
func (ard A2AReplicationDetails) AsInMageReplicationDetails() (*InMageReplicationDetails, bool) {
	return nil, false
}

// AsReplicationProviderSpecificSettings is the BasicReplicationProviderSpecificSettings implementation for A2AReplicationDetails.
func (ard A2AReplicationDetails) AsReplicationProviderSpecificSettings() (*ReplicationProviderSpecificSettings, bool) {
	return nil, false
}

// AsBasicReplicationProviderSpecificSettings is the BasicReplicationProviderSpecificSettings implementation for A2AReplicationDetails.
func (ard A2AReplicationDetails) AsBasicReplicationProviderSpecificSettings() (BasicReplicationProviderSpecificSettings, bool) {
	return &ard, true
}

// A2AReplicationIntentDetails a2A provider specific settings.
type A2AReplicationIntentDetails struct {
	// FabricObjectID - The fabric specific object Id of the virtual machine.
	FabricObjectID *string `json:"fabricObjectId,omitempty"`
	// PolicyID - The ID of Policy governing this PE.
	PolicyID *string `json:"policyId,omitempty"`
	// PrimaryLocation - The primary location for the virtual machine.
	PrimaryLocation *string `json:"primaryLocation,omitempty"`
	// RecoveryLocation - The recovery location for the virtual machine.
	RecoveryLocation *string `json:"recoveryLocation,omitempty"`
	// RecoverySubscriptionID - The recovery subscription Id of the virtual machine.
	RecoverySubscriptionID *string `json:"recoverySubscriptionId,omitempty"`
	// PrimaryFabricFriendlyName - The recovery fabric Name.
	PrimaryFabricFriendlyName *string `json:"primaryFabricFriendlyName,omitempty"`
	// RecoveryFabricFriendlyName - The recovery fabric Name.
	RecoveryFabricFriendlyName *string `json:"recoveryFabricFriendlyName,omitempty"`
	// PrimaryContainerFriendlyName - The primary container Name.
	PrimaryContainerFriendlyName *string `json:"primaryContainerFriendlyName,omitempty"`
	// RecoveryContainerFriendlyName - The recovery container Name.
	RecoveryContainerFriendlyName *string `json:"recoveryContainerFriendlyName,omitempty"`
	// RecoveryAvailabilityType - The recovery availability type of the virtual machine.
	RecoveryAvailabilityType *string `json:"recoveryAvailabilityType,omitempty"`
	// VMDisks - The list of vm disk details.
	VMDisks *[]A2AVMDiskDetails `json:"vmDisks,omitempty"`
	// VMManagedDisks - The list of vm managed disk details.
	VMManagedDisks *[]A2AVMManagedDiskDetails `json:"vmManagedDisks,omitempty"`
	// RecoveryResourceGroupID - The recovery resource group id.
	RecoveryResourceGroupID *string `json:"recoveryResourceGroupId,omitempty"`
	// RecoveryAvailabilitySetID - The recovery availability set Id.
	RecoveryAvailabilitySetID *string `json:"recoveryAvailabilitySetId,omitempty"`
	// RecoveryVirtualNetworkID - The recovery virtual network Id.
	RecoveryVirtualNetworkID *string `json:"recoveryVirtualNetworkId,omitempty"`
	// RecoveryProximityPlacementGroupID - The recovery proximity placement group custom details.
	RecoveryProximityPlacementGroupID *string `json:"recoveryProximityPlacementGroupId,omitempty"`
	// AutoProtectionOfDataDiskStatus - A value indicating whether the auto protection is enabled. Possible values include: 'AutoProtectionOfDataDiskStatusDisabled', 'AutoProtectionOfDataDiskStatusEnabled'
	AutoProtectionOfDataDiskStatus AutoProtectionOfDataDiskStatus `json:"autoProtectionOfDataDiskStatus,omitempty"`
	// MultiVMGroupName - The multi vm group name.
	MultiVMGroupName *string `json:"multiVmGroupName,omitempty"`
	// MultiVMGroupID - The multi vm group id.
	MultiVMGroupID *string `json:"multiVmGroupId,omitempty"`
	// RecoveryBootDiagStorageAccountID - The boot diagnostic storage account.
	RecoveryBootDiagStorageAccountID *string `json:"recoveryBootDiagStorageAccountId,omitempty"`
	// DiskEncryptionInfo - The recovery disk encryption information (for two pass flows).
	DiskEncryptionInfo *DiskEncryptionInfo `json:"diskEncryptionInfo,omitempty"`
	// RecoveryAvailabilityZone - The recovery availability zone.
	RecoveryAvailabilityZone *string `json:"recoveryAvailabilityZone,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicReplicationProtectionIntentProviderSpecificSettingsInstanceTypeReplicationProtectionIntentProviderSpecificSettings', 'InstanceTypeBasicReplicationProtectionIntentProviderSpecificSettingsInstanceTypeA2A'
	InstanceType InstanceTypeBasicReplicationProtectionIntentProviderSpecificSettings `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for A2AReplicationIntentDetails.
func (arid A2AReplicationIntentDetails) MarshalJSON() ([]byte, error) {
	arid.InstanceType = InstanceTypeBasicReplicationProtectionIntentProviderSpecificSettingsInstanceTypeA2A
	objectMap := make(map[string]interface{})
	if arid.FabricObjectID != nil {
		objectMap["fabricObjectId"] = arid.FabricObjectID
	}
	if arid.PolicyID != nil {
		objectMap["policyId"] = arid.PolicyID
	}
	if arid.PrimaryLocation != nil {
		objectMap["primaryLocation"] = arid.PrimaryLocation
	}
	if arid.RecoveryLocation != nil {
		objectMap["recoveryLocation"] = arid.RecoveryLocation
	}
	if arid.RecoverySubscriptionID != nil {
		objectMap["recoverySubscriptionId"] = arid.RecoverySubscriptionID
	}
	if arid.PrimaryFabricFriendlyName != nil {
		objectMap["primaryFabricFriendlyName"] = arid.PrimaryFabricFriendlyName
	}
	if arid.RecoveryFabricFriendlyName != nil {
		objectMap["recoveryFabricFriendlyName"] = arid.RecoveryFabricFriendlyName
	}
	if arid.PrimaryContainerFriendlyName != nil {
		objectMap["primaryContainerFriendlyName"] = arid.PrimaryContainerFriendlyName
	}
	if arid.RecoveryContainerFriendlyName != nil {
		objectMap["recoveryContainerFriendlyName"] = arid.RecoveryContainerFriendlyName
	}
	if arid.RecoveryAvailabilityType != nil {
		objectMap["recoveryAvailabilityType"] = arid.RecoveryAvailabilityType
	}
	if arid.VMDisks != nil {
		objectMap["vmDisks"] = arid.VMDisks
	}
	if arid.VMManagedDisks != nil {
		objectMap["vmManagedDisks"] = arid.VMManagedDisks
	}
	if arid.RecoveryResourceGroupID != nil {
		objectMap["recoveryResourceGroupId"] = arid.RecoveryResourceGroupID
	}
	if arid.RecoveryAvailabilitySetID != nil {
		objectMap["recoveryAvailabilitySetId"] = arid.RecoveryAvailabilitySetID
	}
	if arid.RecoveryVirtualNetworkID != nil {
		objectMap["recoveryVirtualNetworkId"] = arid.RecoveryVirtualNetworkID
	}
	if arid.RecoveryProximityPlacementGroupID != nil {
		objectMap["recoveryProximityPlacementGroupId"] = arid.RecoveryProximityPlacementGroupID
	}
	if arid.AutoProtectionOfDataDiskStatus != "" {
		objectMap["autoProtectionOfDataDiskStatus"] = arid.AutoProtectionOfDataDiskStatus
	}
	if arid.MultiVMGroupName != nil {
		objectMap["multiVmGroupName"] = arid.MultiVMGroupName
	}
	if arid.MultiVMGroupID != nil {
		objectMap["multiVmGroupId"] = arid.MultiVMGroupID
	}
	if arid.RecoveryBootDiagStorageAccountID != nil {
		objectMap["recoveryBootDiagStorageAccountId"] = arid.RecoveryBootDiagStorageAccountID
	}
	if arid.DiskEncryptionInfo != nil {
		objectMap["diskEncryptionInfo"] = arid.DiskEncryptionInfo
	}
	if arid.RecoveryAvailabilityZone != nil {
		objectMap["recoveryAvailabilityZone"] = arid.RecoveryAvailabilityZone
	}
	if arid.InstanceType != "" {
		objectMap["instanceType"] = arid.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AReplicationIntentDetails is the BasicReplicationProtectionIntentProviderSpecificSettings implementation for A2AReplicationIntentDetails.
func (arid A2AReplicationIntentDetails) AsA2AReplicationIntentDetails() (*A2AReplicationIntentDetails, bool) {
	return &arid, true
}

// AsReplicationProtectionIntentProviderSpecificSettings is the BasicReplicationProtectionIntentProviderSpecificSettings implementation for A2AReplicationIntentDetails.
func (arid A2AReplicationIntentDetails) AsReplicationProtectionIntentProviderSpecificSettings() (*ReplicationProtectionIntentProviderSpecificSettings, bool) {
	return nil, false
}

// AsBasicReplicationProtectionIntentProviderSpecificSettings is the BasicReplicationProtectionIntentProviderSpecificSettings implementation for A2AReplicationIntentDetails.
func (arid A2AReplicationIntentDetails) AsBasicReplicationProtectionIntentProviderSpecificSettings() (BasicReplicationProtectionIntentProviderSpecificSettings, bool) {
	return &arid, true
}

// A2AReprotectInput azure specific reprotect input.
type A2AReprotectInput struct {
	// RecoveryContainerID - The recovery container Id.
	RecoveryContainerID *string `json:"recoveryContainerId,omitempty"`
	// VMDisks - The list of vm disk details.
	VMDisks *[]A2AVMDiskInputDetails `json:"vmDisks,omitempty"`
	// RecoveryResourceGroupID - The recovery resource group Id. Valid for V2 scenarios.
	RecoveryResourceGroupID *string `json:"recoveryResourceGroupId,omitempty"`
	// RecoveryCloudServiceID - The recovery cloud service Id. Valid for V1 scenarios.
	RecoveryCloudServiceID *string `json:"recoveryCloudServiceId,omitempty"`
	// RecoveryAvailabilitySetID - The recovery availability set.
	RecoveryAvailabilitySetID *string `json:"recoveryAvailabilitySetId,omitempty"`
	// PolicyID - The Policy Id.
	PolicyID *string `json:"policyId,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeReverseReplicationProviderSpecificInput', 'InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeA2A', 'InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeInMage'
	InstanceType InstanceTypeBasicReverseReplicationProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for A2AReprotectInput.
func (ari A2AReprotectInput) MarshalJSON() ([]byte, error) {
	ari.InstanceType = InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeA2A
	objectMap := make(map[string]interface{})
	if ari.RecoveryContainerID != nil {
		objectMap["recoveryContainerId"] = ari.RecoveryContainerID
	}
	if ari.VMDisks != nil {
		objectMap["vmDisks"] = ari.VMDisks
	}
	if ari.RecoveryResourceGroupID != nil {
		objectMap["recoveryResourceGroupId"] = ari.RecoveryResourceGroupID
	}
	if ari.RecoveryCloudServiceID != nil {
		objectMap["recoveryCloudServiceId"] = ari.RecoveryCloudServiceID
	}
	if ari.RecoveryAvailabilitySetID != nil {
		objectMap["recoveryAvailabilitySetId"] = ari.RecoveryAvailabilitySetID
	}
	if ari.PolicyID != nil {
		objectMap["policyId"] = ari.PolicyID
	}
	if ari.InstanceType != "" {
		objectMap["instanceType"] = ari.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AReprotectInput is the BasicReverseReplicationProviderSpecificInput implementation for A2AReprotectInput.
func (ari A2AReprotectInput) AsA2AReprotectInput() (*A2AReprotectInput, bool) {
	return &ari, true
}

// AsHyperVReplicaAzureReprotectInput is the BasicReverseReplicationProviderSpecificInput implementation for A2AReprotectInput.
func (ari A2AReprotectInput) AsHyperVReplicaAzureReprotectInput() (*HyperVReplicaAzureReprotectInput, bool) {
	return nil, false
}

// AsInMageAzureV2ReprotectInput is the BasicReverseReplicationProviderSpecificInput implementation for A2AReprotectInput.
func (ari A2AReprotectInput) AsInMageAzureV2ReprotectInput() (*InMageAzureV2ReprotectInput, bool) {
	return nil, false
}

// AsInMageReprotectInput is the BasicReverseReplicationProviderSpecificInput implementation for A2AReprotectInput.
func (ari A2AReprotectInput) AsInMageReprotectInput() (*InMageReprotectInput, bool) {
	return nil, false
}

// AsReverseReplicationProviderSpecificInput is the BasicReverseReplicationProviderSpecificInput implementation for A2AReprotectInput.
func (ari A2AReprotectInput) AsReverseReplicationProviderSpecificInput() (*ReverseReplicationProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicReverseReplicationProviderSpecificInput is the BasicReverseReplicationProviderSpecificInput implementation for A2AReprotectInput.
func (ari A2AReprotectInput) AsBasicReverseReplicationProviderSpecificInput() (BasicReverseReplicationProviderSpecificInput, bool) {
	return &ari, true
}

// A2ASwitchProtectionInput a2A specific switch protection input.
type A2ASwitchProtectionInput struct {
	// RecoveryContainerID - The recovery container Id.
	RecoveryContainerID *string `json:"recoveryContainerId,omitempty"`
	// VMDisks - The list of vm disk details.
	VMDisks *[]A2AVMDiskInputDetails `json:"vmDisks,omitempty"`
	// VMManagedDisks - The list of vm managed disk details.
	VMManagedDisks *[]A2AVMManagedDiskInputDetails `json:"vmManagedDisks,omitempty"`
	// RecoveryResourceGroupID - The recovery resource group Id. Valid for V2 scenarios.
	RecoveryResourceGroupID *string `json:"recoveryResourceGroupId,omitempty"`
	// RecoveryCloudServiceID - The recovery cloud service Id. Valid for V1 scenarios.
	RecoveryCloudServiceID *string `json:"recoveryCloudServiceId,omitempty"`
	// RecoveryAvailabilitySetID - The recovery availability set.
	RecoveryAvailabilitySetID *string `json:"recoveryAvailabilitySetId,omitempty"`
	// RecoveryProximityPlacementGroupID - The recovery proximity placement group Id.
	RecoveryProximityPlacementGroupID *string `json:"recoveryProximityPlacementGroupId,omitempty"`
	// PolicyID - The Policy Id.
	PolicyID *string `json:"policyId,omitempty"`
	// RecoveryBootDiagStorageAccountID - The boot diagnostic storage account.
	RecoveryBootDiagStorageAccountID *string `json:"recoveryBootDiagStorageAccountId,omitempty"`
	// DiskEncryptionInfo - The recovery disk encryption information.
	DiskEncryptionInfo *DiskEncryptionInfo `json:"diskEncryptionInfo,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicSwitchProtectionProviderSpecificInputInstanceTypeSwitchProtectionProviderSpecificInput', 'InstanceTypeBasicSwitchProtectionProviderSpecificInputInstanceTypeA2A'
	InstanceType InstanceTypeBasicSwitchProtectionProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for A2ASwitchProtectionInput.
func (aspi A2ASwitchProtectionInput) MarshalJSON() ([]byte, error) {
	aspi.InstanceType = InstanceTypeBasicSwitchProtectionProviderSpecificInputInstanceTypeA2A
	objectMap := make(map[string]interface{})
	if aspi.RecoveryContainerID != nil {
		objectMap["recoveryContainerId"] = aspi.RecoveryContainerID
	}
	if aspi.VMDisks != nil {
		objectMap["vmDisks"] = aspi.VMDisks
	}
	if aspi.VMManagedDisks != nil {
		objectMap["vmManagedDisks"] = aspi.VMManagedDisks
	}
	if aspi.RecoveryResourceGroupID != nil {
		objectMap["recoveryResourceGroupId"] = aspi.RecoveryResourceGroupID
	}
	if aspi.RecoveryCloudServiceID != nil {
		objectMap["recoveryCloudServiceId"] = aspi.RecoveryCloudServiceID
	}
	if aspi.RecoveryAvailabilitySetID != nil {
		objectMap["recoveryAvailabilitySetId"] = aspi.RecoveryAvailabilitySetID
	}
	if aspi.RecoveryProximityPlacementGroupID != nil {
		objectMap["recoveryProximityPlacementGroupId"] = aspi.RecoveryProximityPlacementGroupID
	}
	if aspi.PolicyID != nil {
		objectMap["policyId"] = aspi.PolicyID
	}
	if aspi.RecoveryBootDiagStorageAccountID != nil {
		objectMap["recoveryBootDiagStorageAccountId"] = aspi.RecoveryBootDiagStorageAccountID
	}
	if aspi.DiskEncryptionInfo != nil {
		objectMap["diskEncryptionInfo"] = aspi.DiskEncryptionInfo
	}
	if aspi.InstanceType != "" {
		objectMap["instanceType"] = aspi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2ASwitchProtectionInput is the BasicSwitchProtectionProviderSpecificInput implementation for A2ASwitchProtectionInput.
func (aspi A2ASwitchProtectionInput) AsA2ASwitchProtectionInput() (*A2ASwitchProtectionInput, bool) {
	return &aspi, true
}

// AsSwitchProtectionProviderSpecificInput is the BasicSwitchProtectionProviderSpecificInput implementation for A2ASwitchProtectionInput.
func (aspi A2ASwitchProtectionInput) AsSwitchProtectionProviderSpecificInput() (*SwitchProtectionProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicSwitchProtectionProviderSpecificInput is the BasicSwitchProtectionProviderSpecificInput implementation for A2ASwitchProtectionInput.
func (aspi A2ASwitchProtectionInput) AsBasicSwitchProtectionProviderSpecificInput() (BasicSwitchProtectionProviderSpecificInput, bool) {
	return &aspi, true
}

// A2ATestFailoverInput a2A provider specific input for test failover.
type A2ATestFailoverInput struct {
	// RecoveryPointID - The recovery point id to be passed to test failover to a particular recovery point. In case of latest recovery point, null should be passed.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`
	// CloudServiceCreationOption - A value indicating whether to use recovery cloud service for TFO or not.
	CloudServiceCreationOption *string `json:"cloudServiceCreationOption,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeTestFailoverProviderSpecificInput', 'InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeA2A', 'InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeInMageRcm', 'InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeInMage'
	InstanceType InstanceTypeBasicTestFailoverProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for A2ATestFailoverInput.
func (atfi A2ATestFailoverInput) MarshalJSON() ([]byte, error) {
	atfi.InstanceType = InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeA2A
	objectMap := make(map[string]interface{})
	if atfi.RecoveryPointID != nil {
		objectMap["recoveryPointId"] = atfi.RecoveryPointID
	}
	if atfi.CloudServiceCreationOption != nil {
		objectMap["cloudServiceCreationOption"] = atfi.CloudServiceCreationOption
	}
	if atfi.InstanceType != "" {
		objectMap["instanceType"] = atfi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2ATestFailoverInput is the BasicTestFailoverProviderSpecificInput implementation for A2ATestFailoverInput.
func (atfi A2ATestFailoverInput) AsA2ATestFailoverInput() (*A2ATestFailoverInput, bool) {
	return &atfi, true
}

// AsHyperVReplicaAzureTestFailoverInput is the BasicTestFailoverProviderSpecificInput implementation for A2ATestFailoverInput.
func (atfi A2ATestFailoverInput) AsHyperVReplicaAzureTestFailoverInput() (*HyperVReplicaAzureTestFailoverInput, bool) {
	return nil, false
}

// AsInMageAzureV2TestFailoverInput is the BasicTestFailoverProviderSpecificInput implementation for A2ATestFailoverInput.
func (atfi A2ATestFailoverInput) AsInMageAzureV2TestFailoverInput() (*InMageAzureV2TestFailoverInput, bool) {
	return nil, false
}

// AsInMageRcmTestFailoverInput is the BasicTestFailoverProviderSpecificInput implementation for A2ATestFailoverInput.
func (atfi A2ATestFailoverInput) AsInMageRcmTestFailoverInput() (*InMageRcmTestFailoverInput, bool) {
	return nil, false
}

// AsInMageTestFailoverInput is the BasicTestFailoverProviderSpecificInput implementation for A2ATestFailoverInput.
func (atfi A2ATestFailoverInput) AsInMageTestFailoverInput() (*InMageTestFailoverInput, bool) {
	return nil, false
}

// AsTestFailoverProviderSpecificInput is the BasicTestFailoverProviderSpecificInput implementation for A2ATestFailoverInput.
func (atfi A2ATestFailoverInput) AsTestFailoverProviderSpecificInput() (*TestFailoverProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicTestFailoverProviderSpecificInput is the BasicTestFailoverProviderSpecificInput implementation for A2ATestFailoverInput.
func (atfi A2ATestFailoverInput) AsBasicTestFailoverProviderSpecificInput() (BasicTestFailoverProviderSpecificInput, bool) {
	return &atfi, true
}

// A2AUnplannedFailoverInput a2A provider specific input for unplanned failover.
type A2AUnplannedFailoverInput struct {
	// RecoveryPointID - The recovery point id to be passed to failover to a particular recovery point. In case of latest recovery point, null should be passed.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`
	// CloudServiceCreationOption - A value indicating whether to use recovery cloud service for failover or not.
	CloudServiceCreationOption *string `json:"cloudServiceCreationOption,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeUnplannedFailoverProviderSpecificInput', 'InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeA2A', 'InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeInMageRcm', 'InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeInMage'
	InstanceType InstanceTypeBasicUnplannedFailoverProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for A2AUnplannedFailoverInput.
func (aufi A2AUnplannedFailoverInput) MarshalJSON() ([]byte, error) {
	aufi.InstanceType = InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeA2A
	objectMap := make(map[string]interface{})
	if aufi.RecoveryPointID != nil {
		objectMap["recoveryPointId"] = aufi.RecoveryPointID
	}
	if aufi.CloudServiceCreationOption != nil {
		objectMap["cloudServiceCreationOption"] = aufi.CloudServiceCreationOption
	}
	if aufi.InstanceType != "" {
		objectMap["instanceType"] = aufi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AUnplannedFailoverInput is the BasicUnplannedFailoverProviderSpecificInput implementation for A2AUnplannedFailoverInput.
func (aufi A2AUnplannedFailoverInput) AsA2AUnplannedFailoverInput() (*A2AUnplannedFailoverInput, bool) {
	return &aufi, true
}

// AsHyperVReplicaAzureUnplannedFailoverInput is the BasicUnplannedFailoverProviderSpecificInput implementation for A2AUnplannedFailoverInput.
func (aufi A2AUnplannedFailoverInput) AsHyperVReplicaAzureUnplannedFailoverInput() (*HyperVReplicaAzureUnplannedFailoverInput, bool) {
	return nil, false
}

// AsInMageAzureV2UnplannedFailoverInput is the BasicUnplannedFailoverProviderSpecificInput implementation for A2AUnplannedFailoverInput.
func (aufi A2AUnplannedFailoverInput) AsInMageAzureV2UnplannedFailoverInput() (*InMageAzureV2UnplannedFailoverInput, bool) {
	return nil, false
}

// AsInMageRcmUnplannedFailoverInput is the BasicUnplannedFailoverProviderSpecificInput implementation for A2AUnplannedFailoverInput.
func (aufi A2AUnplannedFailoverInput) AsInMageRcmUnplannedFailoverInput() (*InMageRcmUnplannedFailoverInput, bool) {
	return nil, false
}

// AsInMageUnplannedFailoverInput is the BasicUnplannedFailoverProviderSpecificInput implementation for A2AUnplannedFailoverInput.
func (aufi A2AUnplannedFailoverInput) AsInMageUnplannedFailoverInput() (*InMageUnplannedFailoverInput, bool) {
	return nil, false
}

// AsUnplannedFailoverProviderSpecificInput is the BasicUnplannedFailoverProviderSpecificInput implementation for A2AUnplannedFailoverInput.
func (aufi A2AUnplannedFailoverInput) AsUnplannedFailoverProviderSpecificInput() (*UnplannedFailoverProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicUnplannedFailoverProviderSpecificInput is the BasicUnplannedFailoverProviderSpecificInput implementation for A2AUnplannedFailoverInput.
func (aufi A2AUnplannedFailoverInput) AsBasicUnplannedFailoverProviderSpecificInput() (BasicUnplannedFailoverProviderSpecificInput, bool) {
	return &aufi, true
}

// A2AUnprotectedDiskDetails a2A unprotected disk details.
type A2AUnprotectedDiskDetails struct {
	// DiskLunID - The source lun Id for the data disk.
	DiskLunID *int32 `json:"diskLunId,omitempty"`
}

// A2AUpdateContainerMappingInput a2A update protection container mapping.
type A2AUpdateContainerMappingInput struct {
	// AgentAutoUpdateStatus - A value indicating whether the auto update is enabled. Possible values include: 'Disabled', 'Enabled'
	AgentAutoUpdateStatus AgentAutoUpdateStatus `json:"agentAutoUpdateStatus,omitempty"`
	// AutomationAccountArmID - The automation account arm id.
	AutomationAccountArmID *string `json:"automationAccountArmId,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicReplicationProviderSpecificUpdateContainerMappingInputInstanceTypeReplicationProviderSpecificUpdateContainerMappingInput', 'InstanceTypeBasicReplicationProviderSpecificUpdateContainerMappingInputInstanceTypeA2A'
	InstanceType InstanceTypeBasicReplicationProviderSpecificUpdateContainerMappingInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for A2AUpdateContainerMappingInput.
func (aucmi A2AUpdateContainerMappingInput) MarshalJSON() ([]byte, error) {
	aucmi.InstanceType = InstanceTypeBasicReplicationProviderSpecificUpdateContainerMappingInputInstanceTypeA2A
	objectMap := make(map[string]interface{})
	if aucmi.AgentAutoUpdateStatus != "" {
		objectMap["agentAutoUpdateStatus"] = aucmi.AgentAutoUpdateStatus
	}
	if aucmi.AutomationAccountArmID != nil {
		objectMap["automationAccountArmId"] = aucmi.AutomationAccountArmID
	}
	if aucmi.InstanceType != "" {
		objectMap["instanceType"] = aucmi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AUpdateContainerMappingInput is the BasicReplicationProviderSpecificUpdateContainerMappingInput implementation for A2AUpdateContainerMappingInput.
func (aucmi A2AUpdateContainerMappingInput) AsA2AUpdateContainerMappingInput() (*A2AUpdateContainerMappingInput, bool) {
	return &aucmi, true
}

// AsReplicationProviderSpecificUpdateContainerMappingInput is the BasicReplicationProviderSpecificUpdateContainerMappingInput implementation for A2AUpdateContainerMappingInput.
func (aucmi A2AUpdateContainerMappingInput) AsReplicationProviderSpecificUpdateContainerMappingInput() (*ReplicationProviderSpecificUpdateContainerMappingInput, bool) {
	return nil, false
}

// AsBasicReplicationProviderSpecificUpdateContainerMappingInput is the BasicReplicationProviderSpecificUpdateContainerMappingInput implementation for A2AUpdateContainerMappingInput.
func (aucmi A2AUpdateContainerMappingInput) AsBasicReplicationProviderSpecificUpdateContainerMappingInput() (BasicReplicationProviderSpecificUpdateContainerMappingInput, bool) {
	return &aucmi, true
}

// A2AUpdateReplicationProtectedItemInput inMage Azure V2 input to update replication protected item.
type A2AUpdateReplicationProtectedItemInput struct {
	// RecoveryCloudServiceID - The target cloud service ARM Id (for V1).
	RecoveryCloudServiceID *string `json:"recoveryCloudServiceId,omitempty"`
	// RecoveryResourceGroupID - The target resource group ARM Id (for V2).
	RecoveryResourceGroupID *string `json:"recoveryResourceGroupId,omitempty"`
	// ManagedDiskUpdateDetails - Managed disk update details.
	ManagedDiskUpdateDetails *[]A2AVMManagedDiskUpdateDetails `json:"managedDiskUpdateDetails,omitempty"`
	// RecoveryBootDiagStorageAccountID - The boot diagnostic storage account.
	RecoveryBootDiagStorageAccountID *string `json:"recoveryBootDiagStorageAccountId,omitempty"`
	// DiskEncryptionInfo - The recovery os disk encryption information.
	DiskEncryptionInfo *DiskEncryptionInfo `json:"diskEncryptionInfo,omitempty"`
	// RecoveryProximityPlacementGroupID - The recovery proximity placement group Id.
	RecoveryProximityPlacementGroupID *string `json:"recoveryProximityPlacementGroupId,omitempty"`
	// TfoAzureVMName - The user given name for test failover VM.
	TfoAzureVMName *string `json:"tfoAzureVMName,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeUpdateReplicationProtectedItemProviderInput', 'InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeA2A', 'InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeInMageRcm'
	InstanceType InstanceTypeBasicUpdateReplicationProtectedItemProviderInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for A2AUpdateReplicationProtectedItemInput.
func (aurpii A2AUpdateReplicationProtectedItemInput) MarshalJSON() ([]byte, error) {
	aurpii.InstanceType = InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeA2A
	objectMap := make(map[string]interface{})
	if aurpii.RecoveryCloudServiceID != nil {
		objectMap["recoveryCloudServiceId"] = aurpii.RecoveryCloudServiceID
	}
	if aurpii.RecoveryResourceGroupID != nil {
		objectMap["recoveryResourceGroupId"] = aurpii.RecoveryResourceGroupID
	}
	if aurpii.ManagedDiskUpdateDetails != nil {
		objectMap["managedDiskUpdateDetails"] = aurpii.ManagedDiskUpdateDetails
	}
	if aurpii.RecoveryBootDiagStorageAccountID != nil {
		objectMap["recoveryBootDiagStorageAccountId"] = aurpii.RecoveryBootDiagStorageAccountID
	}
	if aurpii.DiskEncryptionInfo != nil {
		objectMap["diskEncryptionInfo"] = aurpii.DiskEncryptionInfo
	}
	if aurpii.RecoveryProximityPlacementGroupID != nil {
		objectMap["recoveryProximityPlacementGroupId"] = aurpii.RecoveryProximityPlacementGroupID
	}
	if aurpii.TfoAzureVMName != nil {
		objectMap["tfoAzureVMName"] = aurpii.TfoAzureVMName
	}
	if aurpii.InstanceType != "" {
		objectMap["instanceType"] = aurpii.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AUpdateReplicationProtectedItemInput is the BasicUpdateReplicationProtectedItemProviderInput implementation for A2AUpdateReplicationProtectedItemInput.
func (aurpii A2AUpdateReplicationProtectedItemInput) AsA2AUpdateReplicationProtectedItemInput() (*A2AUpdateReplicationProtectedItemInput, bool) {
	return &aurpii, true
}

// AsHyperVReplicaAzureUpdateReplicationProtectedItemInput is the BasicUpdateReplicationProtectedItemProviderInput implementation for A2AUpdateReplicationProtectedItemInput.
func (aurpii A2AUpdateReplicationProtectedItemInput) AsHyperVReplicaAzureUpdateReplicationProtectedItemInput() (*HyperVReplicaAzureUpdateReplicationProtectedItemInput, bool) {
	return nil, false
}

// AsInMageAzureV2UpdateReplicationProtectedItemInput is the BasicUpdateReplicationProtectedItemProviderInput implementation for A2AUpdateReplicationProtectedItemInput.
func (aurpii A2AUpdateReplicationProtectedItemInput) AsInMageAzureV2UpdateReplicationProtectedItemInput() (*InMageAzureV2UpdateReplicationProtectedItemInput, bool) {
	return nil, false
}

// AsInMageRcmUpdateReplicationProtectedItemInput is the BasicUpdateReplicationProtectedItemProviderInput implementation for A2AUpdateReplicationProtectedItemInput.
func (aurpii A2AUpdateReplicationProtectedItemInput) AsInMageRcmUpdateReplicationProtectedItemInput() (*InMageRcmUpdateReplicationProtectedItemInput, bool) {
	return nil, false
}

// AsUpdateReplicationProtectedItemProviderInput is the BasicUpdateReplicationProtectedItemProviderInput implementation for A2AUpdateReplicationProtectedItemInput.
func (aurpii A2AUpdateReplicationProtectedItemInput) AsUpdateReplicationProtectedItemProviderInput() (*UpdateReplicationProtectedItemProviderInput, bool) {
	return nil, false
}

// AsBasicUpdateReplicationProtectedItemProviderInput is the BasicUpdateReplicationProtectedItemProviderInput implementation for A2AUpdateReplicationProtectedItemInput.
func (aurpii A2AUpdateReplicationProtectedItemInput) AsBasicUpdateReplicationProtectedItemProviderInput() (BasicUpdateReplicationProtectedItemProviderInput, bool) {
	return &aurpii, true
}

// A2AVMDiskDetails azure VM disk details.
type A2AVMDiskDetails struct {
	// DiskURI - The disk Uri.
	DiskURI *string `json:"diskUri,omitempty"`
	// RecoveryAzureStorageAccountID - The recovery VHD storage account Id.
	RecoveryAzureStorageAccountID *string `json:"recoveryAzureStorageAccountId,omitempty"`
	// PrimaryStagingAzureStorageAccountID - The primary staging storage account Id.
	PrimaryStagingAzureStorageAccountID *string `json:"primaryStagingAzureStorageAccountId,omitempty"`
}

// A2AVMDiskInputDetails azure VM disk input details.
type A2AVMDiskInputDetails struct {
	// DiskURI - The disk Uri.
	DiskURI *string `json:"diskUri,omitempty"`
	// RecoveryAzureStorageAccountID - The recovery VHD storage account Id.
	RecoveryAzureStorageAccountID *string `json:"recoveryAzureStorageAccountId,omitempty"`
	// PrimaryStagingAzureStorageAccountID - The primary staging storage account Id.
	PrimaryStagingAzureStorageAccountID *string `json:"primaryStagingAzureStorageAccountId,omitempty"`
}

// A2AVMManagedDiskDetails azure VM managed disk input details.
type A2AVMManagedDiskDetails struct {
	// DiskID - The disk Id.
	DiskID *string `json:"diskId,omitempty"`
	// PrimaryStagingAzureStorageAccountID - The primary staging storage account Arm Id.
	PrimaryStagingAzureStorageAccountID *string `json:"primaryStagingAzureStorageAccountId,omitempty"`
	// RecoveryResourceGroupID - The target resource group Arm Id.
	RecoveryResourceGroupID *string `json:"recoveryResourceGroupId,omitempty"`
	// RecoveryReplicaDiskAccountType - The replica disk type.
	RecoveryReplicaDiskAccountType *string `json:"recoveryReplicaDiskAccountType,omitempty"`
	// RecoveryTargetDiskAccountType - The target disk type after failover.
	RecoveryTargetDiskAccountType *string `json:"recoveryTargetDiskAccountType,omitempty"`
	// RecoveryDiskEncryptionSetID - The recovery disk encryption set Id.
	RecoveryDiskEncryptionSetID *string `json:"recoveryDiskEncryptionSetId,omitempty"`
	// DiskEncryptionInfo - The recovery disk encryption information (for one / single pass flows).
	DiskEncryptionInfo *DiskEncryptionInfo `json:"diskEncryptionInfo,omitempty"`
}

// A2AVMManagedDiskInputDetails azure VM managed disk input details.
type A2AVMManagedDiskInputDetails struct {
	// DiskID - The disk Id.
	DiskID *string `json:"diskId,omitempty"`
	// PrimaryStagingAzureStorageAccountID - The primary staging storage account Arm Id.
	PrimaryStagingAzureStorageAccountID *string `json:"primaryStagingAzureStorageAccountId,omitempty"`
	// RecoveryResourceGroupID - The target resource group Arm Id.
	RecoveryResourceGroupID *string `json:"recoveryResourceGroupId,omitempty"`
	// RecoveryReplicaDiskAccountType - The replica disk type. Its an optional value and will be same as source disk type if not user provided.
	RecoveryReplicaDiskAccountType *string `json:"recoveryReplicaDiskAccountType,omitempty"`
	// RecoveryTargetDiskAccountType - The target disk type after failover. Its an optional value and will be same as source disk type if not user provided.
	RecoveryTargetDiskAccountType *string `json:"recoveryTargetDiskAccountType,omitempty"`
	// RecoveryDiskEncryptionSetID - The recovery disk encryption set Id.
	RecoveryDiskEncryptionSetID *string `json:"recoveryDiskEncryptionSetId,omitempty"`
	// DiskEncryptionInfo - The recovery disk encryption information (for one / single pass flows).
	DiskEncryptionInfo *DiskEncryptionInfo `json:"diskEncryptionInfo,omitempty"`
}

// A2AVMManagedDiskUpdateDetails azure VM managed disk update input details.
type A2AVMManagedDiskUpdateDetails struct {
	// DiskID - The disk Id.
	DiskID *string `json:"diskId,omitempty"`
	// RecoveryTargetDiskAccountType - The target disk type before failover.
	RecoveryTargetDiskAccountType *string `json:"recoveryTargetDiskAccountType,omitempty"`
	// RecoveryReplicaDiskAccountType - The replica disk type before failover.
	RecoveryReplicaDiskAccountType *string `json:"recoveryReplicaDiskAccountType,omitempty"`
	// DiskEncryptionInfo - The recovery disk encryption information (for one / single pass flows).
	DiskEncryptionInfo *DiskEncryptionInfo `json:"diskEncryptionInfo,omitempty"`
	// FailoverDiskName - The target disk name for unplanned failover operation.
	FailoverDiskName *string `json:"failoverDiskName,omitempty"`
	// TfoDiskName - The target disk name for test failover operation.
	TfoDiskName *string `json:"tfoDiskName,omitempty"`
}

// AddDisksInput input for add disk(s) operation.
type AddDisksInput struct {
	// Properties - Add disks input properties.
	Properties *AddDisksInputProperties `json:"properties,omitempty"`
}

// AddDisksInputProperties add Disks input properties.
type AddDisksInputProperties struct {
	// ProviderSpecificDetails - The ReplicationProviderInput. For HyperVReplicaAzure provider, it will be AzureEnableProtectionInput object. For San provider, it will be SanEnableProtectionInput object. For HyperVReplicaAzure provider, it can be null.
	ProviderSpecificDetails BasicAddDisksProviderSpecificInput `json:"providerSpecificDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AddDisksInputProperties struct.
func (adip *AddDisksInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "providerSpecificDetails":
			if v != nil {
				providerSpecificDetails, err := unmarshalBasicAddDisksProviderSpecificInput(*v)
				if err != nil {
					return err
				}
				adip.ProviderSpecificDetails = providerSpecificDetails
			}
		}
	}

	return nil
}

// BasicAddDisksProviderSpecificInput add Disks provider specific input.
type BasicAddDisksProviderSpecificInput interface {
	AsA2AAddDisksInput() (*A2AAddDisksInput, bool)
	AsAddDisksProviderSpecificInput() (*AddDisksProviderSpecificInput, bool)
}

// AddDisksProviderSpecificInput add Disks provider specific input.
type AddDisksProviderSpecificInput struct {
	// InstanceType - Possible values include: 'InstanceTypeAddDisksProviderSpecificInput', 'InstanceTypeA2A'
	InstanceType InstanceType `json:"instanceType,omitempty"`
}

func unmarshalBasicAddDisksProviderSpecificInput(body []byte) (BasicAddDisksProviderSpecificInput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeA2A):
		var aadi A2AAddDisksInput
		err := json.Unmarshal(body, &aadi)
		return aadi, err
	default:
		var adpsi AddDisksProviderSpecificInput
		err := json.Unmarshal(body, &adpsi)
		return adpsi, err
	}
}
func unmarshalBasicAddDisksProviderSpecificInputArray(body []byte) ([]BasicAddDisksProviderSpecificInput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	adpsiArray := make([]BasicAddDisksProviderSpecificInput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		adpsi, err := unmarshalBasicAddDisksProviderSpecificInput(*rawMessage)
		if err != nil {
			return nil, err
		}
		adpsiArray[index] = adpsi
	}
	return adpsiArray, nil
}

// MarshalJSON is the custom marshaler for AddDisksProviderSpecificInput.
func (adpsi AddDisksProviderSpecificInput) MarshalJSON() ([]byte, error) {
	adpsi.InstanceType = InstanceTypeAddDisksProviderSpecificInput
	objectMap := make(map[string]interface{})
	if adpsi.InstanceType != "" {
		objectMap["instanceType"] = adpsi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AAddDisksInput is the BasicAddDisksProviderSpecificInput implementation for AddDisksProviderSpecificInput.
func (adpsi AddDisksProviderSpecificInput) AsA2AAddDisksInput() (*A2AAddDisksInput, bool) {
	return nil, false
}

// AsAddDisksProviderSpecificInput is the BasicAddDisksProviderSpecificInput implementation for AddDisksProviderSpecificInput.
func (adpsi AddDisksProviderSpecificInput) AsAddDisksProviderSpecificInput() (*AddDisksProviderSpecificInput, bool) {
	return &adpsi, true
}

// AsBasicAddDisksProviderSpecificInput is the BasicAddDisksProviderSpecificInput implementation for AddDisksProviderSpecificInput.
func (adpsi AddDisksProviderSpecificInput) AsBasicAddDisksProviderSpecificInput() (BasicAddDisksProviderSpecificInput, bool) {
	return &adpsi, true
}

// AddRecoveryServicesProviderInput input required to add a provider.
type AddRecoveryServicesProviderInput struct {
	// Properties - The properties of an add provider request.
	Properties *AddRecoveryServicesProviderInputProperties `json:"properties,omitempty"`
}

// AddRecoveryServicesProviderInputProperties the properties of an add provider request.
type AddRecoveryServicesProviderInputProperties struct {
	// MachineName - The name of the machine where the provider is getting added.
	MachineName *string `json:"machineName,omitempty"`
	// MachineID - The Id of the machine where the provider is getting added.
	MachineID *string `json:"machineId,omitempty"`
	// AuthenticationIdentityInput - The identity provider input for DRA authentication.
	AuthenticationIdentityInput *IdentityProviderInput `json:"authenticationIdentityInput,omitempty"`
	// ResourceAccessIdentityInput - The identity provider input for resource access.
	ResourceAccessIdentityInput *IdentityProviderInput `json:"resourceAccessIdentityInput,omitempty"`
	// DataPlaneAuthenticationIdentityInput - The identity provider input for data plane authentication.
	DataPlaneAuthenticationIdentityInput *IdentityProviderInput `json:"dataPlaneAuthenticationIdentityInput,omitempty"`
}

// AddVCenterRequest input required to add vCenter.
type AddVCenterRequest struct {
	// Properties - The properties of an add vCenter request.
	Properties *AddVCenterRequestProperties `json:"properties,omitempty"`
}

// AddVCenterRequestProperties the properties of an add vCenter request.
type AddVCenterRequestProperties struct {
	// FriendlyName - The friendly name of the vCenter.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// IPAddress - The IP address of the vCenter to be discovered.
	IPAddress *string `json:"ipAddress,omitempty"`
	// ProcessServerID - The process server Id from where the discovery is orchestrated.
	ProcessServerID *string `json:"processServerId,omitempty"`
	// Port - The port number for discovery.
	Port *string `json:"port,omitempty"`
	// RunAsAccountID - The account Id which has privileges to discover the vCenter.
	RunAsAccountID *string `json:"runAsAccountId,omitempty"`
}

// AgentDetails agent details.
type AgentDetails struct {
	// AgentID - READ-ONLY; The Id of the agent running on the server.
	AgentID *string `json:"agentId,omitempty"`
	// MachineID - READ-ONLY; The Id of the machine to which the agent is registered.
	MachineID *string `json:"machineId,omitempty"`
	// BiosID - READ-ONLY; The machine BIOS Id.
	BiosID *string `json:"biosId,omitempty"`
	// Fqdn - READ-ONLY; The machine FQDN.
	Fqdn *string `json:"fqdn,omitempty"`
	// Disks - READ-ONLY; The details of agent disks.
	Disks *[]AgentDiskDetails `json:"disks,omitempty"`
}

// AgentDiskDetails agent disk details.
type AgentDiskDetails struct {
	// DiskID - READ-ONLY; The disk Id.
	DiskID *string `json:"diskId,omitempty"`
	// DiskName - READ-ONLY; The disk name.
	DiskName *string `json:"diskName,omitempty"`
	// IsOSDisk - READ-ONLY; A value indicating whether the disk is the OS disk.
	IsOSDisk *string `json:"isOSDisk,omitempty"`
	// CapacityInBytes - READ-ONLY; The disk capacity in bytes.
	CapacityInBytes *int64 `json:"capacityInBytes,omitempty"`
	// LunID - READ-ONLY; The lun of disk.
	LunID *int32 `json:"lunId,omitempty"`
}

// Alert implements the Alert class.
type Alert struct {
	autorest.Response `json:"-"`
	// Properties - Alert related data.
	Properties *AlertProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource Type
	Type *string `json:"type,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for Alert.
func (a Alert) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.Properties != nil {
		objectMap["properties"] = a.Properties
	}
	if a.Location != nil {
		objectMap["location"] = a.Location
	}
	return json.Marshal(objectMap)
}

// AlertCollection collection of alerts.
type AlertCollection struct {
	autorest.Response `json:"-"`
	// Value - The list of alerts.
	Value *[]Alert `json:"value,omitempty"`
	// NextLink - The value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// AlertCollectionIterator provides access to a complete listing of Alert values.
type AlertCollectionIterator struct {
	i    int
	page AlertCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AlertCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AlertCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AlertCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AlertCollectionIterator) Response() AlertCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AlertCollectionIterator) Value() Alert {
	if !iter.page.NotDone() {
		return Alert{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AlertCollectionIterator type.
func NewAlertCollectionIterator(page AlertCollectionPage) AlertCollectionIterator {
	return AlertCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ac AlertCollection) IsEmpty() bool {
	return ac.Value == nil || len(*ac.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ac AlertCollection) hasNextLink() bool {
	return ac.NextLink != nil && len(*ac.NextLink) != 0
}

// alertCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ac AlertCollection) alertCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !ac.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ac.NextLink)))
}

// AlertCollectionPage contains a page of Alert values.
type AlertCollectionPage struct {
	fn func(context.Context, AlertCollection) (AlertCollection, error)
	ac AlertCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AlertCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ac)
		if err != nil {
			return err
		}
		page.ac = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AlertCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AlertCollectionPage) NotDone() bool {
	return !page.ac.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AlertCollectionPage) Response() AlertCollection {
	return page.ac
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AlertCollectionPage) Values() []Alert {
	if page.ac.IsEmpty() {
		return nil
	}
	return *page.ac.Value
}

// Creates a new instance of the AlertCollectionPage type.
func NewAlertCollectionPage(cur AlertCollection, getNextPage func(context.Context, AlertCollection) (AlertCollection, error)) AlertCollectionPage {
	return AlertCollectionPage{
		fn: getNextPage,
		ac: cur,
	}
}

// AlertProperties the properties of an alert.
type AlertProperties struct {
	// SendToOwners - A value indicating whether to send email to subscription administrator.
	SendToOwners *string `json:"sendToOwners,omitempty"`
	// CustomEmailAddresses - The custom email address for sending emails.
	CustomEmailAddresses *[]string `json:"customEmailAddresses,omitempty"`
	// Locale - The locale for the email notification.
	Locale *string `json:"locale,omitempty"`
}

// ApplyRecoveryPointInput input to apply recovery point.
type ApplyRecoveryPointInput struct {
	// Properties - The input properties to apply recovery point.
	Properties *ApplyRecoveryPointInputProperties `json:"properties,omitempty"`
}

// ApplyRecoveryPointInputProperties input properties to apply recovery point.
type ApplyRecoveryPointInputProperties struct {
	// RecoveryPointID - The recovery point Id.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`
	// ProviderSpecificDetails - Provider specific input for applying recovery point.
	ProviderSpecificDetails BasicApplyRecoveryPointProviderSpecificInput `json:"providerSpecificDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ApplyRecoveryPointInputProperties struct.
func (arpip *ApplyRecoveryPointInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "recoveryPointId":
			if v != nil {
				var recoveryPointID string
				err = json.Unmarshal(*v, &recoveryPointID)
				if err != nil {
					return err
				}
				arpip.RecoveryPointID = &recoveryPointID
			}
		case "providerSpecificDetails":
			if v != nil {
				providerSpecificDetails, err := unmarshalBasicApplyRecoveryPointProviderSpecificInput(*v)
				if err != nil {
					return err
				}
				arpip.ProviderSpecificDetails = providerSpecificDetails
			}
		}
	}

	return nil
}

// BasicApplyRecoveryPointProviderSpecificInput provider specific input for apply recovery point.
type BasicApplyRecoveryPointProviderSpecificInput interface {
	AsA2AApplyRecoveryPointInput() (*A2AApplyRecoveryPointInput, bool)
	AsHyperVReplicaAzureApplyRecoveryPointInput() (*HyperVReplicaAzureApplyRecoveryPointInput, bool)
	AsInMageAzureV2ApplyRecoveryPointInput() (*InMageAzureV2ApplyRecoveryPointInput, bool)
	AsInMageRcmApplyRecoveryPointInput() (*InMageRcmApplyRecoveryPointInput, bool)
	AsApplyRecoveryPointProviderSpecificInput() (*ApplyRecoveryPointProviderSpecificInput, bool)
}

// ApplyRecoveryPointProviderSpecificInput provider specific input for apply recovery point.
type ApplyRecoveryPointProviderSpecificInput struct {
	// InstanceType - Possible values include: 'InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeApplyRecoveryPointProviderSpecificInput', 'InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeA2A', 'InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeInMageRcm'
	InstanceType InstanceTypeBasicApplyRecoveryPointProviderSpecificInput `json:"instanceType,omitempty"`
}

func unmarshalBasicApplyRecoveryPointProviderSpecificInput(body []byte) (BasicApplyRecoveryPointProviderSpecificInput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeA2A):
		var aarpi A2AApplyRecoveryPointInput
		err := json.Unmarshal(body, &aarpi)
		return aarpi, err
	case string(InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeHyperVReplicaAzure):
		var hvraarpi HyperVReplicaAzureApplyRecoveryPointInput
		err := json.Unmarshal(body, &hvraarpi)
		return hvraarpi, err
	case string(InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeInMageAzureV2):
		var imavarpi InMageAzureV2ApplyRecoveryPointInput
		err := json.Unmarshal(body, &imavarpi)
		return imavarpi, err
	case string(InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeInMageRcm):
		var imrarpi InMageRcmApplyRecoveryPointInput
		err := json.Unmarshal(body, &imrarpi)
		return imrarpi, err
	default:
		var arppsi ApplyRecoveryPointProviderSpecificInput
		err := json.Unmarshal(body, &arppsi)
		return arppsi, err
	}
}
func unmarshalBasicApplyRecoveryPointProviderSpecificInputArray(body []byte) ([]BasicApplyRecoveryPointProviderSpecificInput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	arppsiArray := make([]BasicApplyRecoveryPointProviderSpecificInput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		arppsi, err := unmarshalBasicApplyRecoveryPointProviderSpecificInput(*rawMessage)
		if err != nil {
			return nil, err
		}
		arppsiArray[index] = arppsi
	}
	return arppsiArray, nil
}

// MarshalJSON is the custom marshaler for ApplyRecoveryPointProviderSpecificInput.
func (arppsi ApplyRecoveryPointProviderSpecificInput) MarshalJSON() ([]byte, error) {
	arppsi.InstanceType = InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeApplyRecoveryPointProviderSpecificInput
	objectMap := make(map[string]interface{})
	if arppsi.InstanceType != "" {
		objectMap["instanceType"] = arppsi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AApplyRecoveryPointInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for ApplyRecoveryPointProviderSpecificInput.
func (arppsi ApplyRecoveryPointProviderSpecificInput) AsA2AApplyRecoveryPointInput() (*A2AApplyRecoveryPointInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzureApplyRecoveryPointInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for ApplyRecoveryPointProviderSpecificInput.
func (arppsi ApplyRecoveryPointProviderSpecificInput) AsHyperVReplicaAzureApplyRecoveryPointInput() (*HyperVReplicaAzureApplyRecoveryPointInput, bool) {
	return nil, false
}

// AsInMageAzureV2ApplyRecoveryPointInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for ApplyRecoveryPointProviderSpecificInput.
func (arppsi ApplyRecoveryPointProviderSpecificInput) AsInMageAzureV2ApplyRecoveryPointInput() (*InMageAzureV2ApplyRecoveryPointInput, bool) {
	return nil, false
}

// AsInMageRcmApplyRecoveryPointInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for ApplyRecoveryPointProviderSpecificInput.
func (arppsi ApplyRecoveryPointProviderSpecificInput) AsInMageRcmApplyRecoveryPointInput() (*InMageRcmApplyRecoveryPointInput, bool) {
	return nil, false
}

// AsApplyRecoveryPointProviderSpecificInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for ApplyRecoveryPointProviderSpecificInput.
func (arppsi ApplyRecoveryPointProviderSpecificInput) AsApplyRecoveryPointProviderSpecificInput() (*ApplyRecoveryPointProviderSpecificInput, bool) {
	return &arppsi, true
}

// AsBasicApplyRecoveryPointProviderSpecificInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for ApplyRecoveryPointProviderSpecificInput.
func (arppsi ApplyRecoveryPointProviderSpecificInput) AsBasicApplyRecoveryPointProviderSpecificInput() (BasicApplyRecoveryPointProviderSpecificInput, bool) {
	return &arppsi, true
}

// AsrJobDetails this class represents job details based on specific job type.
type AsrJobDetails struct {
	// AffectedObjectDetails - The affected object properties like source server, source cloud, target server, target cloud etc. based on the workflow object details.
	AffectedObjectDetails map[string]*string `json:"affectedObjectDetails"`
	// InstanceType - Possible values include: 'InstanceTypeJobDetails', 'InstanceTypeAsrJobDetails', 'InstanceTypeExportJobDetails', 'InstanceTypeFailoverJobDetails', 'InstanceTypeSwitchProtectionJobDetails', 'InstanceTypeTestFailoverJobDetails'
	InstanceType InstanceTypeBasicJobDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for AsrJobDetails.
func (ajd AsrJobDetails) MarshalJSON() ([]byte, error) {
	ajd.InstanceType = InstanceTypeAsrJobDetails
	objectMap := make(map[string]interface{})
	if ajd.AffectedObjectDetails != nil {
		objectMap["affectedObjectDetails"] = ajd.AffectedObjectDetails
	}
	if ajd.InstanceType != "" {
		objectMap["instanceType"] = ajd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAsrJobDetails is the BasicJobDetails implementation for AsrJobDetails.
func (ajd AsrJobDetails) AsAsrJobDetails() (*AsrJobDetails, bool) {
	return &ajd, true
}

// AsExportJobDetails is the BasicJobDetails implementation for AsrJobDetails.
func (ajd AsrJobDetails) AsExportJobDetails() (*ExportJobDetails, bool) {
	return nil, false
}

// AsFailoverJobDetails is the BasicJobDetails implementation for AsrJobDetails.
func (ajd AsrJobDetails) AsFailoverJobDetails() (*FailoverJobDetails, bool) {
	return nil, false
}

// AsSwitchProtectionJobDetails is the BasicJobDetails implementation for AsrJobDetails.
func (ajd AsrJobDetails) AsSwitchProtectionJobDetails() (*SwitchProtectionJobDetails, bool) {
	return nil, false
}

// AsTestFailoverJobDetails is the BasicJobDetails implementation for AsrJobDetails.
func (ajd AsrJobDetails) AsTestFailoverJobDetails() (*TestFailoverJobDetails, bool) {
	return nil, false
}

// AsJobDetails is the BasicJobDetails implementation for AsrJobDetails.
func (ajd AsrJobDetails) AsJobDetails() (*JobDetails, bool) {
	return nil, false
}

// AsBasicJobDetails is the BasicJobDetails implementation for AsrJobDetails.
func (ajd AsrJobDetails) AsBasicJobDetails() (BasicJobDetails, bool) {
	return &ajd, true
}

// ASRTask task of the Job.
type ASRTask struct {
	// TaskID - The Id.
	TaskID *string `json:"taskId,omitempty"`
	// Name - The unique Task name.
	Name *string `json:"name,omitempty"`
	// StartTime - The start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// AllowedActions - The state/actions applicable on this task.
	AllowedActions *[]string `json:"allowedActions,omitempty"`
	// FriendlyName - The name.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// State - The State. It is one of these values - NotStarted, InProgress, Succeeded, Failed, Cancelled, Suspended or Other.
	State *string `json:"state,omitempty"`
	// StateDescription - The description of the task state. For example - For Succeeded state, description can be Completed, PartiallySucceeded, CompletedWithInformation or Skipped.
	StateDescription *string `json:"stateDescription,omitempty"`
	// TaskType - The type of task. Details in CustomDetails property depend on this type.
	TaskType *string `json:"taskType,omitempty"`
	// CustomDetails - The custom task details based on the task type.
	CustomDetails BasicTaskTypeDetails `json:"customDetails,omitempty"`
	// GroupTaskCustomDetails - The custom task details based on the task type, if the task type is GroupTaskDetails or one of the types derived from it.
	GroupTaskCustomDetails BasicGroupTaskDetails `json:"groupTaskCustomDetails,omitempty"`
	// Errors - The task error details.
	Errors *[]JobErrorDetails `json:"errors,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ASRTask struct.
func (at *ASRTask) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "taskId":
			if v != nil {
				var taskID string
				err = json.Unmarshal(*v, &taskID)
				if err != nil {
					return err
				}
				at.TaskID = &taskID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				at.Name = &name
			}
		case "startTime":
			if v != nil {
				var startTime date.Time
				err = json.Unmarshal(*v, &startTime)
				if err != nil {
					return err
				}
				at.StartTime = &startTime
			}
		case "endTime":
			if v != nil {
				var endTime date.Time
				err = json.Unmarshal(*v, &endTime)
				if err != nil {
					return err
				}
				at.EndTime = &endTime
			}
		case "allowedActions":
			if v != nil {
				var allowedActions []string
				err = json.Unmarshal(*v, &allowedActions)
				if err != nil {
					return err
				}
				at.AllowedActions = &allowedActions
			}
		case "friendlyName":
			if v != nil {
				var friendlyName string
				err = json.Unmarshal(*v, &friendlyName)
				if err != nil {
					return err
				}
				at.FriendlyName = &friendlyName
			}
		case "state":
			if v != nil {
				var state string
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				at.State = &state
			}
		case "stateDescription":
			if v != nil {
				var stateDescription string
				err = json.Unmarshal(*v, &stateDescription)
				if err != nil {
					return err
				}
				at.StateDescription = &stateDescription
			}
		case "taskType":
			if v != nil {
				var taskType string
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				at.TaskType = &taskType
			}
		case "customDetails":
			if v != nil {
				customDetails, err := unmarshalBasicTaskTypeDetails(*v)
				if err != nil {
					return err
				}
				at.CustomDetails = customDetails
			}
		case "groupTaskCustomDetails":
			if v != nil {
				groupTaskCustomDetails, err := unmarshalBasicGroupTaskDetails(*v)
				if err != nil {
					return err
				}
				at.GroupTaskCustomDetails = groupTaskCustomDetails
			}
		case "errors":
			if v != nil {
				var errorsVar []JobErrorDetails
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				at.Errors = &errorsVar
			}
		}
	}

	return nil
}

// AutomationRunbookTaskDetails this class represents the task details for an automation runbook.
type AutomationRunbookTaskDetails struct {
	// Name - The recovery plan task name.
	Name *string `json:"name,omitempty"`
	// CloudServiceName - The cloud service of the automation runbook account.
	CloudServiceName *string `json:"cloudServiceName,omitempty"`
	// SubscriptionID - The subscription Id of the automation runbook account.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// AccountName - The automation account name of the runbook.
	AccountName *string `json:"accountName,omitempty"`
	// RunbookID - The runbook Id.
	RunbookID *string `json:"runbookId,omitempty"`
	// RunbookName - The runbook name.
	RunbookName *string `json:"runbookName,omitempty"`
	// JobID - The job Id of the runbook execution.
	JobID *string `json:"jobId,omitempty"`
	// JobOutput - The execution output of the runbook.
	JobOutput *string `json:"jobOutput,omitempty"`
	// IsPrimarySideScript - A value indicating whether it is a primary side script or not.
	IsPrimarySideScript *bool `json:"isPrimarySideScript,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeTaskTypeDetails', 'InstanceTypeAutomationRunbookTaskDetails', 'InstanceTypeConsistencyCheckTaskDetails', 'InstanceTypeFabricReplicationGroupTaskDetails', 'InstanceTypeJobTaskDetails', 'InstanceTypeManualActionTaskDetails', 'InstanceTypeScriptActionTaskDetails', 'InstanceTypeVirtualMachineTaskDetails', 'InstanceTypeVMNicUpdatesTaskDetails'
	InstanceType InstanceTypeBasicTaskTypeDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for AutomationRunbookTaskDetails.
func (artd AutomationRunbookTaskDetails) MarshalJSON() ([]byte, error) {
	artd.InstanceType = InstanceTypeAutomationRunbookTaskDetails
	objectMap := make(map[string]interface{})
	if artd.Name != nil {
		objectMap["name"] = artd.Name
	}
	if artd.CloudServiceName != nil {
		objectMap["cloudServiceName"] = artd.CloudServiceName
	}
	if artd.SubscriptionID != nil {
		objectMap["subscriptionId"] = artd.SubscriptionID
	}
	if artd.AccountName != nil {
		objectMap["accountName"] = artd.AccountName
	}
	if artd.RunbookID != nil {
		objectMap["runbookId"] = artd.RunbookID
	}
	if artd.RunbookName != nil {
		objectMap["runbookName"] = artd.RunbookName
	}
	if artd.JobID != nil {
		objectMap["jobId"] = artd.JobID
	}
	if artd.JobOutput != nil {
		objectMap["jobOutput"] = artd.JobOutput
	}
	if artd.IsPrimarySideScript != nil {
		objectMap["isPrimarySideScript"] = artd.IsPrimarySideScript
	}
	if artd.InstanceType != "" {
		objectMap["instanceType"] = artd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAutomationRunbookTaskDetails is the BasicTaskTypeDetails implementation for AutomationRunbookTaskDetails.
func (artd AutomationRunbookTaskDetails) AsAutomationRunbookTaskDetails() (*AutomationRunbookTaskDetails, bool) {
	return &artd, true
}

// AsConsistencyCheckTaskDetails is the BasicTaskTypeDetails implementation for AutomationRunbookTaskDetails.
func (artd AutomationRunbookTaskDetails) AsConsistencyCheckTaskDetails() (*ConsistencyCheckTaskDetails, bool) {
	return nil, false
}

// AsFabricReplicationGroupTaskDetails is the BasicTaskTypeDetails implementation for AutomationRunbookTaskDetails.
func (artd AutomationRunbookTaskDetails) AsFabricReplicationGroupTaskDetails() (*FabricReplicationGroupTaskDetails, bool) {
	return nil, false
}

// AsJobTaskDetails is the BasicTaskTypeDetails implementation for AutomationRunbookTaskDetails.
func (artd AutomationRunbookTaskDetails) AsJobTaskDetails() (*JobTaskDetails, bool) {
	return nil, false
}

// AsManualActionTaskDetails is the BasicTaskTypeDetails implementation for AutomationRunbookTaskDetails.
func (artd AutomationRunbookTaskDetails) AsManualActionTaskDetails() (*ManualActionTaskDetails, bool) {
	return nil, false
}

// AsScriptActionTaskDetails is the BasicTaskTypeDetails implementation for AutomationRunbookTaskDetails.
func (artd AutomationRunbookTaskDetails) AsScriptActionTaskDetails() (*ScriptActionTaskDetails, bool) {
	return nil, false
}

// AsVirtualMachineTaskDetails is the BasicTaskTypeDetails implementation for AutomationRunbookTaskDetails.
func (artd AutomationRunbookTaskDetails) AsVirtualMachineTaskDetails() (*VirtualMachineTaskDetails, bool) {
	return nil, false
}

// AsVMNicUpdatesTaskDetails is the BasicTaskTypeDetails implementation for AutomationRunbookTaskDetails.
func (artd AutomationRunbookTaskDetails) AsVMNicUpdatesTaskDetails() (*VMNicUpdatesTaskDetails, bool) {
	return nil, false
}

// AsTaskTypeDetails is the BasicTaskTypeDetails implementation for AutomationRunbookTaskDetails.
func (artd AutomationRunbookTaskDetails) AsTaskTypeDetails() (*TaskTypeDetails, bool) {
	return nil, false
}

// AsBasicTaskTypeDetails is the BasicTaskTypeDetails implementation for AutomationRunbookTaskDetails.
func (artd AutomationRunbookTaskDetails) AsBasicTaskTypeDetails() (BasicTaskTypeDetails, bool) {
	return &artd, true
}

// AzureFabricCreationInput fabric provider specific settings.
type AzureFabricCreationInput struct {
	// Location - The Location.
	Location *string `json:"location,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeFabricSpecificCreationInput', 'InstanceTypeAzure', 'InstanceTypeInMageRcm', 'InstanceTypeVMwareV2'
	InstanceType InstanceTypeBasicFabricSpecificCreationInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureFabricCreationInput.
func (afci AzureFabricCreationInput) MarshalJSON() ([]byte, error) {
	afci.InstanceType = InstanceTypeAzure
	objectMap := make(map[string]interface{})
	if afci.Location != nil {
		objectMap["location"] = afci.Location
	}
	if afci.InstanceType != "" {
		objectMap["instanceType"] = afci.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAzureFabricCreationInput is the BasicFabricSpecificCreationInput implementation for AzureFabricCreationInput.
func (afci AzureFabricCreationInput) AsAzureFabricCreationInput() (*AzureFabricCreationInput, bool) {
	return &afci, true
}

// AsInMageRcmFabricCreationInput is the BasicFabricSpecificCreationInput implementation for AzureFabricCreationInput.
func (afci AzureFabricCreationInput) AsInMageRcmFabricCreationInput() (*InMageRcmFabricCreationInput, bool) {
	return nil, false
}

// AsVMwareV2FabricCreationInput is the BasicFabricSpecificCreationInput implementation for AzureFabricCreationInput.
func (afci AzureFabricCreationInput) AsVMwareV2FabricCreationInput() (*VMwareV2FabricCreationInput, bool) {
	return nil, false
}

// AsFabricSpecificCreationInput is the BasicFabricSpecificCreationInput implementation for AzureFabricCreationInput.
func (afci AzureFabricCreationInput) AsFabricSpecificCreationInput() (*FabricSpecificCreationInput, bool) {
	return nil, false
}

// AsBasicFabricSpecificCreationInput is the BasicFabricSpecificCreationInput implementation for AzureFabricCreationInput.
func (afci AzureFabricCreationInput) AsBasicFabricSpecificCreationInput() (BasicFabricSpecificCreationInput, bool) {
	return &afci, true
}

// AzureFabricSpecificDetails azure Fabric Specific Details.
type AzureFabricSpecificDetails struct {
	// Location - The Location for the Azure fabric.
	Location *string `json:"location,omitempty"`
	// ContainerIds - The container Ids for the Azure fabric.
	ContainerIds *[]string `json:"containerIds,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeFabricSpecificDetails', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeAzure', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeHyperVSite', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeInMageRcm', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMM', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMware', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMwareV2'
	InstanceType InstanceTypeBasicFabricSpecificDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureFabricSpecificDetails.
func (afsd AzureFabricSpecificDetails) MarshalJSON() ([]byte, error) {
	afsd.InstanceType = InstanceTypeBasicFabricSpecificDetailsInstanceTypeAzure
	objectMap := make(map[string]interface{})
	if afsd.Location != nil {
		objectMap["location"] = afsd.Location
	}
	if afsd.ContainerIds != nil {
		objectMap["containerIds"] = afsd.ContainerIds
	}
	if afsd.InstanceType != "" {
		objectMap["instanceType"] = afsd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAzureFabricSpecificDetails is the BasicFabricSpecificDetails implementation for AzureFabricSpecificDetails.
func (afsd AzureFabricSpecificDetails) AsAzureFabricSpecificDetails() (*AzureFabricSpecificDetails, bool) {
	return &afsd, true
}

// AsHyperVSiteDetails is the BasicFabricSpecificDetails implementation for AzureFabricSpecificDetails.
func (afsd AzureFabricSpecificDetails) AsHyperVSiteDetails() (*HyperVSiteDetails, bool) {
	return nil, false
}

// AsInMageRcmFabricSpecificDetails is the BasicFabricSpecificDetails implementation for AzureFabricSpecificDetails.
func (afsd AzureFabricSpecificDetails) AsInMageRcmFabricSpecificDetails() (*InMageRcmFabricSpecificDetails, bool) {
	return nil, false
}

// AsVmmDetails is the BasicFabricSpecificDetails implementation for AzureFabricSpecificDetails.
func (afsd AzureFabricSpecificDetails) AsVmmDetails() (*VmmDetails, bool) {
	return nil, false
}

// AsVMwareDetails is the BasicFabricSpecificDetails implementation for AzureFabricSpecificDetails.
func (afsd AzureFabricSpecificDetails) AsVMwareDetails() (*VMwareDetails, bool) {
	return nil, false
}

// AsVMwareV2FabricSpecificDetails is the BasicFabricSpecificDetails implementation for AzureFabricSpecificDetails.
func (afsd AzureFabricSpecificDetails) AsVMwareV2FabricSpecificDetails() (*VMwareV2FabricSpecificDetails, bool) {
	return nil, false
}

// AsFabricSpecificDetails is the BasicFabricSpecificDetails implementation for AzureFabricSpecificDetails.
func (afsd AzureFabricSpecificDetails) AsFabricSpecificDetails() (*FabricSpecificDetails, bool) {
	return nil, false
}

// AsBasicFabricSpecificDetails is the BasicFabricSpecificDetails implementation for AzureFabricSpecificDetails.
func (afsd AzureFabricSpecificDetails) AsBasicFabricSpecificDetails() (BasicFabricSpecificDetails, bool) {
	return &afsd, true
}

// AzureToAzureCreateNetworkMappingInput create network mappings input properties/behavior specific to
// Azure to Azure Network mapping.
type AzureToAzureCreateNetworkMappingInput struct {
	// PrimaryNetworkID - The primary azure vnet Id.
	PrimaryNetworkID *string `json:"primaryNetworkId,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeFabricSpecificCreateNetworkMappingInput', 'InstanceTypeAzureToAzure', 'InstanceTypeVmmToAzure', 'InstanceTypeVmmToVmm'
	InstanceType InstanceTypeBasicFabricSpecificCreateNetworkMappingInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureToAzureCreateNetworkMappingInput.
func (atacnmi AzureToAzureCreateNetworkMappingInput) MarshalJSON() ([]byte, error) {
	atacnmi.InstanceType = InstanceTypeAzureToAzure
	objectMap := make(map[string]interface{})
	if atacnmi.PrimaryNetworkID != nil {
		objectMap["primaryNetworkId"] = atacnmi.PrimaryNetworkID
	}
	if atacnmi.InstanceType != "" {
		objectMap["instanceType"] = atacnmi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAzureToAzureCreateNetworkMappingInput is the BasicFabricSpecificCreateNetworkMappingInput implementation for AzureToAzureCreateNetworkMappingInput.
func (atacnmi AzureToAzureCreateNetworkMappingInput) AsAzureToAzureCreateNetworkMappingInput() (*AzureToAzureCreateNetworkMappingInput, bool) {
	return &atacnmi, true
}

// AsVmmToAzureCreateNetworkMappingInput is the BasicFabricSpecificCreateNetworkMappingInput implementation for AzureToAzureCreateNetworkMappingInput.
func (atacnmi AzureToAzureCreateNetworkMappingInput) AsVmmToAzureCreateNetworkMappingInput() (*VmmToAzureCreateNetworkMappingInput, bool) {
	return nil, false
}

// AsVmmToVmmCreateNetworkMappingInput is the BasicFabricSpecificCreateNetworkMappingInput implementation for AzureToAzureCreateNetworkMappingInput.
func (atacnmi AzureToAzureCreateNetworkMappingInput) AsVmmToVmmCreateNetworkMappingInput() (*VmmToVmmCreateNetworkMappingInput, bool) {
	return nil, false
}

// AsFabricSpecificCreateNetworkMappingInput is the BasicFabricSpecificCreateNetworkMappingInput implementation for AzureToAzureCreateNetworkMappingInput.
func (atacnmi AzureToAzureCreateNetworkMappingInput) AsFabricSpecificCreateNetworkMappingInput() (*FabricSpecificCreateNetworkMappingInput, bool) {
	return nil, false
}

// AsBasicFabricSpecificCreateNetworkMappingInput is the BasicFabricSpecificCreateNetworkMappingInput implementation for AzureToAzureCreateNetworkMappingInput.
func (atacnmi AzureToAzureCreateNetworkMappingInput) AsBasicFabricSpecificCreateNetworkMappingInput() (BasicFabricSpecificCreateNetworkMappingInput, bool) {
	return &atacnmi, true
}

// AzureToAzureNetworkMappingSettings a2A Network Mapping fabric specific settings.
type AzureToAzureNetworkMappingSettings struct {
	// PrimaryFabricLocation - The primary fabric location.
	PrimaryFabricLocation *string `json:"primaryFabricLocation,omitempty"`
	// RecoveryFabricLocation - The recovery fabric location.
	RecoveryFabricLocation *string `json:"recoveryFabricLocation,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeNetworkMappingFabricSpecificSettings', 'InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeAzureToAzure', 'InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeVmmToAzure', 'InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeVmmToVmm'
	InstanceType InstanceTypeBasicNetworkMappingFabricSpecificSettings `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureToAzureNetworkMappingSettings.
func (atanms AzureToAzureNetworkMappingSettings) MarshalJSON() ([]byte, error) {
	atanms.InstanceType = InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeAzureToAzure
	objectMap := make(map[string]interface{})
	if atanms.PrimaryFabricLocation != nil {
		objectMap["primaryFabricLocation"] = atanms.PrimaryFabricLocation
	}
	if atanms.RecoveryFabricLocation != nil {
		objectMap["recoveryFabricLocation"] = atanms.RecoveryFabricLocation
	}
	if atanms.InstanceType != "" {
		objectMap["instanceType"] = atanms.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAzureToAzureNetworkMappingSettings is the BasicNetworkMappingFabricSpecificSettings implementation for AzureToAzureNetworkMappingSettings.
func (atanms AzureToAzureNetworkMappingSettings) AsAzureToAzureNetworkMappingSettings() (*AzureToAzureNetworkMappingSettings, bool) {
	return &atanms, true
}

// AsVmmToAzureNetworkMappingSettings is the BasicNetworkMappingFabricSpecificSettings implementation for AzureToAzureNetworkMappingSettings.
func (atanms AzureToAzureNetworkMappingSettings) AsVmmToAzureNetworkMappingSettings() (*VmmToAzureNetworkMappingSettings, bool) {
	return nil, false
}

// AsVmmToVmmNetworkMappingSettings is the BasicNetworkMappingFabricSpecificSettings implementation for AzureToAzureNetworkMappingSettings.
func (atanms AzureToAzureNetworkMappingSettings) AsVmmToVmmNetworkMappingSettings() (*VmmToVmmNetworkMappingSettings, bool) {
	return nil, false
}

// AsNetworkMappingFabricSpecificSettings is the BasicNetworkMappingFabricSpecificSettings implementation for AzureToAzureNetworkMappingSettings.
func (atanms AzureToAzureNetworkMappingSettings) AsNetworkMappingFabricSpecificSettings() (*NetworkMappingFabricSpecificSettings, bool) {
	return nil, false
}

// AsBasicNetworkMappingFabricSpecificSettings is the BasicNetworkMappingFabricSpecificSettings implementation for AzureToAzureNetworkMappingSettings.
func (atanms AzureToAzureNetworkMappingSettings) AsBasicNetworkMappingFabricSpecificSettings() (BasicNetworkMappingFabricSpecificSettings, bool) {
	return &atanms, true
}

// AzureToAzureUpdateNetworkMappingInput updates network mappings input.
type AzureToAzureUpdateNetworkMappingInput struct {
	// PrimaryNetworkID - The primary azure vnet Id.
	PrimaryNetworkID *string `json:"primaryNetworkId,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeFabricSpecificUpdateNetworkMappingInput', 'InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeAzureToAzure', 'InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToAzure', 'InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToVmm'
	InstanceType InstanceTypeBasicFabricSpecificUpdateNetworkMappingInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureToAzureUpdateNetworkMappingInput.
func (ataunmi AzureToAzureUpdateNetworkMappingInput) MarshalJSON() ([]byte, error) {
	ataunmi.InstanceType = InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeAzureToAzure
	objectMap := make(map[string]interface{})
	if ataunmi.PrimaryNetworkID != nil {
		objectMap["primaryNetworkId"] = ataunmi.PrimaryNetworkID
	}
	if ataunmi.InstanceType != "" {
		objectMap["instanceType"] = ataunmi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAzureToAzureUpdateNetworkMappingInput is the BasicFabricSpecificUpdateNetworkMappingInput implementation for AzureToAzureUpdateNetworkMappingInput.
func (ataunmi AzureToAzureUpdateNetworkMappingInput) AsAzureToAzureUpdateNetworkMappingInput() (*AzureToAzureUpdateNetworkMappingInput, bool) {
	return &ataunmi, true
}

// AsVmmToAzureUpdateNetworkMappingInput is the BasicFabricSpecificUpdateNetworkMappingInput implementation for AzureToAzureUpdateNetworkMappingInput.
func (ataunmi AzureToAzureUpdateNetworkMappingInput) AsVmmToAzureUpdateNetworkMappingInput() (*VmmToAzureUpdateNetworkMappingInput, bool) {
	return nil, false
}

// AsVmmToVmmUpdateNetworkMappingInput is the BasicFabricSpecificUpdateNetworkMappingInput implementation for AzureToAzureUpdateNetworkMappingInput.
func (ataunmi AzureToAzureUpdateNetworkMappingInput) AsVmmToVmmUpdateNetworkMappingInput() (*VmmToVmmUpdateNetworkMappingInput, bool) {
	return nil, false
}

// AsFabricSpecificUpdateNetworkMappingInput is the BasicFabricSpecificUpdateNetworkMappingInput implementation for AzureToAzureUpdateNetworkMappingInput.
func (ataunmi AzureToAzureUpdateNetworkMappingInput) AsFabricSpecificUpdateNetworkMappingInput() (*FabricSpecificUpdateNetworkMappingInput, bool) {
	return nil, false
}

// AsBasicFabricSpecificUpdateNetworkMappingInput is the BasicFabricSpecificUpdateNetworkMappingInput implementation for AzureToAzureUpdateNetworkMappingInput.
func (ataunmi AzureToAzureUpdateNetworkMappingInput) AsBasicFabricSpecificUpdateNetworkMappingInput() (BasicFabricSpecificUpdateNetworkMappingInput, bool) {
	return &ataunmi, true
}

// AzureToAzureVMSyncedConfigDetails azure to Azure VM synced configuration details.
type AzureToAzureVMSyncedConfigDetails struct {
	// Tags - The Azure VM tags.
	Tags map[string]*string `json:"tags"`
	// InputEndpoints - The Azure VM input endpoints.
	InputEndpoints *[]InputEndpoint `json:"inputEndpoints,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureToAzureVMSyncedConfigDetails.
func (atavscd AzureToAzureVMSyncedConfigDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if atavscd.Tags != nil {
		objectMap["tags"] = atavscd.Tags
	}
	if atavscd.InputEndpoints != nil {
		objectMap["inputEndpoints"] = atavscd.InputEndpoints
	}
	return json.Marshal(objectMap)
}

// AzureVMDiskDetails disk details for E2A provider.
type AzureVMDiskDetails struct {
	// VhdType - VHD type.
	VhdType *string `json:"vhdType,omitempty"`
	// VhdID - The VHD id.
	VhdID *string `json:"vhdId,omitempty"`
	// DiskID - The disk resource id.
	DiskID *string `json:"diskId,omitempty"`
	// VhdName - VHD name.
	VhdName *string `json:"vhdName,omitempty"`
	// MaxSizeMB - Max side in MB.
	MaxSizeMB *string `json:"maxSizeMB,omitempty"`
	// TargetDiskLocation - Blob uri of the Azure disk.
	TargetDiskLocation *string `json:"targetDiskLocation,omitempty"`
	// TargetDiskName - The target Azure disk name.
	TargetDiskName *string `json:"targetDiskName,omitempty"`
	// LunID - Ordinal\LunId of the disk for the Azure VM.
	LunID *string `json:"lunId,omitempty"`
	// DiskEncryptionSetID - The DiskEncryptionSet ARM ID.
	DiskEncryptionSetID *string `json:"diskEncryptionSetId,omitempty"`
}

// ComputeSizeErrorDetails represents the error used to indicate why the target compute size is not
// applicable.
type ComputeSizeErrorDetails struct {
	// Message - The error message.
	Message *string `json:"message,omitempty"`
	// Severity - The severity of the error.
	Severity *string `json:"severity,omitempty"`
}

// BasicConfigurationSettings replication provider specific settings.
type BasicConfigurationSettings interface {
	AsHyperVVirtualMachineDetails() (*HyperVVirtualMachineDetails, bool)
	AsReplicationGroupDetails() (*ReplicationGroupDetails, bool)
	AsVmmVirtualMachineDetails() (*VmmVirtualMachineDetails, bool)
	AsVMwareVirtualMachineDetails() (*VMwareVirtualMachineDetails, bool)
	AsConfigurationSettings() (*ConfigurationSettings, bool)
}

// ConfigurationSettings replication provider specific settings.
type ConfigurationSettings struct {
	// InstanceType - Possible values include: 'InstanceTypeConfigurationSettings', 'InstanceTypeHyperVVirtualMachine', 'InstanceTypeReplicationGroupDetails', 'InstanceTypeVmmVirtualMachine', 'InstanceTypeVMwareVirtualMachine'
	InstanceType InstanceTypeBasicConfigurationSettings `json:"instanceType,omitempty"`
}

func unmarshalBasicConfigurationSettings(body []byte) (BasicConfigurationSettings, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeHyperVVirtualMachine):
		var hvvmd HyperVVirtualMachineDetails
		err := json.Unmarshal(body, &hvvmd)
		return hvvmd, err
	case string(InstanceTypeReplicationGroupDetails):
		var rgd ReplicationGroupDetails
		err := json.Unmarshal(body, &rgd)
		return rgd, err
	case string(InstanceTypeVmmVirtualMachine):
		var vvmd VmmVirtualMachineDetails
		err := json.Unmarshal(body, &vvmd)
		return vvmd, err
	case string(InstanceTypeVMwareVirtualMachine):
		var vmvmd VMwareVirtualMachineDetails
		err := json.Unmarshal(body, &vmvmd)
		return vmvmd, err
	default:
		var cs ConfigurationSettings
		err := json.Unmarshal(body, &cs)
		return cs, err
	}
}
func unmarshalBasicConfigurationSettingsArray(body []byte) ([]BasicConfigurationSettings, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	csArray := make([]BasicConfigurationSettings, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cs, err := unmarshalBasicConfigurationSettings(*rawMessage)
		if err != nil {
			return nil, err
		}
		csArray[index] = cs
	}
	return csArray, nil
}

// MarshalJSON is the custom marshaler for ConfigurationSettings.
func (cs ConfigurationSettings) MarshalJSON() ([]byte, error) {
	cs.InstanceType = InstanceTypeConfigurationSettings
	objectMap := make(map[string]interface{})
	if cs.InstanceType != "" {
		objectMap["instanceType"] = cs.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVVirtualMachineDetails is the BasicConfigurationSettings implementation for ConfigurationSettings.
func (cs ConfigurationSettings) AsHyperVVirtualMachineDetails() (*HyperVVirtualMachineDetails, bool) {
	return nil, false
}

// AsReplicationGroupDetails is the BasicConfigurationSettings implementation for ConfigurationSettings.
func (cs ConfigurationSettings) AsReplicationGroupDetails() (*ReplicationGroupDetails, bool) {
	return nil, false
}

// AsVmmVirtualMachineDetails is the BasicConfigurationSettings implementation for ConfigurationSettings.
func (cs ConfigurationSettings) AsVmmVirtualMachineDetails() (*VmmVirtualMachineDetails, bool) {
	return nil, false
}

// AsVMwareVirtualMachineDetails is the BasicConfigurationSettings implementation for ConfigurationSettings.
func (cs ConfigurationSettings) AsVMwareVirtualMachineDetails() (*VMwareVirtualMachineDetails, bool) {
	return nil, false
}

// AsConfigurationSettings is the BasicConfigurationSettings implementation for ConfigurationSettings.
func (cs ConfigurationSettings) AsConfigurationSettings() (*ConfigurationSettings, bool) {
	return &cs, true
}

// AsBasicConfigurationSettings is the BasicConfigurationSettings implementation for ConfigurationSettings.
func (cs ConfigurationSettings) AsBasicConfigurationSettings() (BasicConfigurationSettings, bool) {
	return &cs, true
}

// ConfigureAlertRequest request to configure alerts for the system.
type ConfigureAlertRequest struct {
	// Properties - The properties of a configure alert request.
	Properties *ConfigureAlertRequestProperties `json:"properties,omitempty"`
}

// ConfigureAlertRequestProperties properties of a configure alert request.
type ConfigureAlertRequestProperties struct {
	// SendToOwners - A value indicating whether to send email to subscription administrator.
	SendToOwners *string `json:"sendToOwners,omitempty"`
	// CustomEmailAddresses - The custom email address for sending emails.
	CustomEmailAddresses *[]string `json:"customEmailAddresses,omitempty"`
	// Locale - The locale for the email notification.
	Locale *string `json:"locale,omitempty"`
}

// ConsistencyCheckTaskDetails this class contains monitoring details of all the inconsistent Protected
// Entities in Vmm.
type ConsistencyCheckTaskDetails struct {
	// VMDetails - The list of inconsistent Vm details.
	VMDetails *[]InconsistentVMDetails `json:"vmDetails,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeTaskTypeDetails', 'InstanceTypeAutomationRunbookTaskDetails', 'InstanceTypeConsistencyCheckTaskDetails', 'InstanceTypeFabricReplicationGroupTaskDetails', 'InstanceTypeJobTaskDetails', 'InstanceTypeManualActionTaskDetails', 'InstanceTypeScriptActionTaskDetails', 'InstanceTypeVirtualMachineTaskDetails', 'InstanceTypeVMNicUpdatesTaskDetails'
	InstanceType InstanceTypeBasicTaskTypeDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConsistencyCheckTaskDetails.
func (cctd ConsistencyCheckTaskDetails) MarshalJSON() ([]byte, error) {
	cctd.InstanceType = InstanceTypeConsistencyCheckTaskDetails
	objectMap := make(map[string]interface{})
	if cctd.VMDetails != nil {
		objectMap["vmDetails"] = cctd.VMDetails
	}
	if cctd.InstanceType != "" {
		objectMap["instanceType"] = cctd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAutomationRunbookTaskDetails is the BasicTaskTypeDetails implementation for ConsistencyCheckTaskDetails.
func (cctd ConsistencyCheckTaskDetails) AsAutomationRunbookTaskDetails() (*AutomationRunbookTaskDetails, bool) {
	return nil, false
}

// AsConsistencyCheckTaskDetails is the BasicTaskTypeDetails implementation for ConsistencyCheckTaskDetails.
func (cctd ConsistencyCheckTaskDetails) AsConsistencyCheckTaskDetails() (*ConsistencyCheckTaskDetails, bool) {
	return &cctd, true
}

// AsFabricReplicationGroupTaskDetails is the BasicTaskTypeDetails implementation for ConsistencyCheckTaskDetails.
func (cctd ConsistencyCheckTaskDetails) AsFabricReplicationGroupTaskDetails() (*FabricReplicationGroupTaskDetails, bool) {
	return nil, false
}

// AsJobTaskDetails is the BasicTaskTypeDetails implementation for ConsistencyCheckTaskDetails.
func (cctd ConsistencyCheckTaskDetails) AsJobTaskDetails() (*JobTaskDetails, bool) {
	return nil, false
}

// AsManualActionTaskDetails is the BasicTaskTypeDetails implementation for ConsistencyCheckTaskDetails.
func (cctd ConsistencyCheckTaskDetails) AsManualActionTaskDetails() (*ManualActionTaskDetails, bool) {
	return nil, false
}

// AsScriptActionTaskDetails is the BasicTaskTypeDetails implementation for ConsistencyCheckTaskDetails.
func (cctd ConsistencyCheckTaskDetails) AsScriptActionTaskDetails() (*ScriptActionTaskDetails, bool) {
	return nil, false
}

// AsVirtualMachineTaskDetails is the BasicTaskTypeDetails implementation for ConsistencyCheckTaskDetails.
func (cctd ConsistencyCheckTaskDetails) AsVirtualMachineTaskDetails() (*VirtualMachineTaskDetails, bool) {
	return nil, false
}

// AsVMNicUpdatesTaskDetails is the BasicTaskTypeDetails implementation for ConsistencyCheckTaskDetails.
func (cctd ConsistencyCheckTaskDetails) AsVMNicUpdatesTaskDetails() (*VMNicUpdatesTaskDetails, bool) {
	return nil, false
}

// AsTaskTypeDetails is the BasicTaskTypeDetails implementation for ConsistencyCheckTaskDetails.
func (cctd ConsistencyCheckTaskDetails) AsTaskTypeDetails() (*TaskTypeDetails, bool) {
	return nil, false
}

// AsBasicTaskTypeDetails is the BasicTaskTypeDetails implementation for ConsistencyCheckTaskDetails.
func (cctd ConsistencyCheckTaskDetails) AsBasicTaskTypeDetails() (BasicTaskTypeDetails, bool) {
	return &cctd, true
}

// CreateNetworkMappingInput create network mappings input.
type CreateNetworkMappingInput struct {
	// Properties - Input properties for creating network mapping.
	Properties *CreateNetworkMappingInputProperties `json:"properties,omitempty"`
}

// CreateNetworkMappingInputProperties common input details for network mapping operation.
type CreateNetworkMappingInputProperties struct {
	// RecoveryFabricName - Recovery fabric Name.
	RecoveryFabricName *string `json:"recoveryFabricName,omitempty"`
	// RecoveryNetworkID - Recovery network Id.
	RecoveryNetworkID *string `json:"recoveryNetworkId,omitempty"`
	// FabricSpecificDetails - Fabric specific input properties.
	FabricSpecificDetails BasicFabricSpecificCreateNetworkMappingInput `json:"fabricSpecificDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for CreateNetworkMappingInputProperties struct.
func (cnmip *CreateNetworkMappingInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "recoveryFabricName":
			if v != nil {
				var recoveryFabricName string
				err = json.Unmarshal(*v, &recoveryFabricName)
				if err != nil {
					return err
				}
				cnmip.RecoveryFabricName = &recoveryFabricName
			}
		case "recoveryNetworkId":
			if v != nil {
				var recoveryNetworkID string
				err = json.Unmarshal(*v, &recoveryNetworkID)
				if err != nil {
					return err
				}
				cnmip.RecoveryNetworkID = &recoveryNetworkID
			}
		case "fabricSpecificDetails":
			if v != nil {
				fabricSpecificDetails, err := unmarshalBasicFabricSpecificCreateNetworkMappingInput(*v)
				if err != nil {
					return err
				}
				cnmip.FabricSpecificDetails = fabricSpecificDetails
			}
		}
	}

	return nil
}

// CreatePolicyInput protection Policy input.
type CreatePolicyInput struct {
	// Properties - Policy creation properties.
	Properties *CreatePolicyInputProperties `json:"properties,omitempty"`
}

// CreatePolicyInputProperties policy creation properties.
type CreatePolicyInputProperties struct {
	// ProviderSpecificInput - The ReplicationProviderSettings.
	ProviderSpecificInput BasicPolicyProviderSpecificInput `json:"providerSpecificInput,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for CreatePolicyInputProperties struct.
func (cpip *CreatePolicyInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "providerSpecificInput":
			if v != nil {
				providerSpecificInput, err := unmarshalBasicPolicyProviderSpecificInput(*v)
				if err != nil {
					return err
				}
				cpip.ProviderSpecificInput = providerSpecificInput
			}
		}
	}

	return nil
}

// CreateProtectionContainerInput create protection container input.
type CreateProtectionContainerInput struct {
	// Properties - Create protection container input properties.
	Properties *CreateProtectionContainerInputProperties `json:"properties,omitempty"`
}

// CreateProtectionContainerInputProperties create protection container input properties.
type CreateProtectionContainerInputProperties struct {
	// ProviderSpecificInput - Provider specific inputs for container creation.
	ProviderSpecificInput *[]BasicReplicationProviderSpecificContainerCreationInput `json:"providerSpecificInput,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for CreateProtectionContainerInputProperties struct.
func (cpcip *CreateProtectionContainerInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "providerSpecificInput":
			if v != nil {
				providerSpecificInput, err := unmarshalBasicReplicationProviderSpecificContainerCreationInputArray(*v)
				if err != nil {
					return err
				}
				cpcip.ProviderSpecificInput = &providerSpecificInput
			}
		}
	}

	return nil
}

// CreateProtectionContainerMappingInput configure pairing input.
type CreateProtectionContainerMappingInput struct {
	// Properties - Configure protection input properties.
	Properties *CreateProtectionContainerMappingInputProperties `json:"properties,omitempty"`
}

// CreateProtectionContainerMappingInputProperties configure pairing input properties.
type CreateProtectionContainerMappingInputProperties struct {
	// TargetProtectionContainerID - The target unique protection container name.
	TargetProtectionContainerID *string `json:"targetProtectionContainerId,omitempty"`
	// PolicyID - Applicable policy.
	PolicyID *string `json:"policyId,omitempty"`
	// ProviderSpecificInput - Provider specific input for pairing.
	ProviderSpecificInput BasicReplicationProviderSpecificContainerMappingInput `json:"providerSpecificInput,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for CreateProtectionContainerMappingInputProperties struct.
func (cpcmip *CreateProtectionContainerMappingInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "targetProtectionContainerId":
			if v != nil {
				var targetProtectionContainerID string
				err = json.Unmarshal(*v, &targetProtectionContainerID)
				if err != nil {
					return err
				}
				cpcmip.TargetProtectionContainerID = &targetProtectionContainerID
			}
		case "policyId":
			if v != nil {
				var policyID string
				err = json.Unmarshal(*v, &policyID)
				if err != nil {
					return err
				}
				cpcmip.PolicyID = &policyID
			}
		case "providerSpecificInput":
			if v != nil {
				providerSpecificInput, err := unmarshalBasicReplicationProviderSpecificContainerMappingInput(*v)
				if err != nil {
					return err
				}
				cpcmip.ProviderSpecificInput = providerSpecificInput
			}
		}
	}

	return nil
}

// CreateProtectionIntentInput create protection intent input.
type CreateProtectionIntentInput struct {
	// Properties - Create protection intent input properties.
	Properties *CreateProtectionIntentProperties `json:"properties,omitempty"`
}

// CreateProtectionIntentProperties create protection intent input properties.
type CreateProtectionIntentProperties struct {
	// ProviderSpecificDetails - The ReplicationProviderInput. For A2A provider, it will be A2ACreateProtectionIntentInput object. For other providers, it can be null.
	ProviderSpecificDetails BasicCreateProtectionIntentProviderSpecificDetails `json:"providerSpecificDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for CreateProtectionIntentProperties struct.
func (cpip *CreateProtectionIntentProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "providerSpecificDetails":
			if v != nil {
				providerSpecificDetails, err := unmarshalBasicCreateProtectionIntentProviderSpecificDetails(*v)
				if err != nil {
					return err
				}
				cpip.ProviderSpecificDetails = providerSpecificDetails
			}
		}
	}

	return nil
}

// BasicCreateProtectionIntentProviderSpecificDetails create protection intent provider specific input.
type BasicCreateProtectionIntentProviderSpecificDetails interface {
	AsA2ACreateProtectionIntentInput() (*A2ACreateProtectionIntentInput, bool)
	AsCreateProtectionIntentProviderSpecificDetails() (*CreateProtectionIntentProviderSpecificDetails, bool)
}

// CreateProtectionIntentProviderSpecificDetails create protection intent provider specific input.
type CreateProtectionIntentProviderSpecificDetails struct {
	// InstanceType - Possible values include: 'InstanceTypeBasicCreateProtectionIntentProviderSpecificDetailsInstanceTypeCreateProtectionIntentProviderSpecificDetails', 'InstanceTypeBasicCreateProtectionIntentProviderSpecificDetailsInstanceTypeA2A'
	InstanceType InstanceTypeBasicCreateProtectionIntentProviderSpecificDetails `json:"instanceType,omitempty"`
}

func unmarshalBasicCreateProtectionIntentProviderSpecificDetails(body []byte) (BasicCreateProtectionIntentProviderSpecificDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeBasicCreateProtectionIntentProviderSpecificDetailsInstanceTypeA2A):
		var acpii A2ACreateProtectionIntentInput
		err := json.Unmarshal(body, &acpii)
		return acpii, err
	default:
		var cpipsd CreateProtectionIntentProviderSpecificDetails
		err := json.Unmarshal(body, &cpipsd)
		return cpipsd, err
	}
}
func unmarshalBasicCreateProtectionIntentProviderSpecificDetailsArray(body []byte) ([]BasicCreateProtectionIntentProviderSpecificDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	cpipsdArray := make([]BasicCreateProtectionIntentProviderSpecificDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cpipsd, err := unmarshalBasicCreateProtectionIntentProviderSpecificDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		cpipsdArray[index] = cpipsd
	}
	return cpipsdArray, nil
}

// MarshalJSON is the custom marshaler for CreateProtectionIntentProviderSpecificDetails.
func (cpipsd CreateProtectionIntentProviderSpecificDetails) MarshalJSON() ([]byte, error) {
	cpipsd.InstanceType = InstanceTypeBasicCreateProtectionIntentProviderSpecificDetailsInstanceTypeCreateProtectionIntentProviderSpecificDetails
	objectMap := make(map[string]interface{})
	if cpipsd.InstanceType != "" {
		objectMap["instanceType"] = cpipsd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2ACreateProtectionIntentInput is the BasicCreateProtectionIntentProviderSpecificDetails implementation for CreateProtectionIntentProviderSpecificDetails.
func (cpipsd CreateProtectionIntentProviderSpecificDetails) AsA2ACreateProtectionIntentInput() (*A2ACreateProtectionIntentInput, bool) {
	return nil, false
}

// AsCreateProtectionIntentProviderSpecificDetails is the BasicCreateProtectionIntentProviderSpecificDetails implementation for CreateProtectionIntentProviderSpecificDetails.
func (cpipsd CreateProtectionIntentProviderSpecificDetails) AsCreateProtectionIntentProviderSpecificDetails() (*CreateProtectionIntentProviderSpecificDetails, bool) {
	return &cpipsd, true
}

// AsBasicCreateProtectionIntentProviderSpecificDetails is the BasicCreateProtectionIntentProviderSpecificDetails implementation for CreateProtectionIntentProviderSpecificDetails.
func (cpipsd CreateProtectionIntentProviderSpecificDetails) AsBasicCreateProtectionIntentProviderSpecificDetails() (BasicCreateProtectionIntentProviderSpecificDetails, bool) {
	return &cpipsd, true
}

// CreateRecoveryPlanInput create recovery plan input class.
type CreateRecoveryPlanInput struct {
	// Properties - Recovery plan creation properties.
	Properties *CreateRecoveryPlanInputProperties `json:"properties,omitempty"`
}

// CreateRecoveryPlanInputProperties recovery plan creation properties.
type CreateRecoveryPlanInputProperties struct {
	// PrimaryFabricID - The primary fabric Id.
	PrimaryFabricID *string `json:"primaryFabricId,omitempty"`
	// RecoveryFabricID - The recovery fabric Id.
	RecoveryFabricID *string `json:"recoveryFabricId,omitempty"`
	// FailoverDeploymentModel - The failover deployment model. Possible values include: 'NotApplicable', 'Classic', 'ResourceManager'
	FailoverDeploymentModel FailoverDeploymentModel `json:"failoverDeploymentModel,omitempty"`
	// Groups - The recovery plan groups.
	Groups *[]RecoveryPlanGroup `json:"groups,omitempty"`
	// ProviderSpecificInput - The provider specific input.
	ProviderSpecificInput *[]BasicRecoveryPlanProviderSpecificInput `json:"providerSpecificInput,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for CreateRecoveryPlanInputProperties struct.
func (crpip *CreateRecoveryPlanInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "primaryFabricId":
			if v != nil {
				var primaryFabricID string
				err = json.Unmarshal(*v, &primaryFabricID)
				if err != nil {
					return err
				}
				crpip.PrimaryFabricID = &primaryFabricID
			}
		case "recoveryFabricId":
			if v != nil {
				var recoveryFabricID string
				err = json.Unmarshal(*v, &recoveryFabricID)
				if err != nil {
					return err
				}
				crpip.RecoveryFabricID = &recoveryFabricID
			}
		case "failoverDeploymentModel":
			if v != nil {
				var failoverDeploymentModel FailoverDeploymentModel
				err = json.Unmarshal(*v, &failoverDeploymentModel)
				if err != nil {
					return err
				}
				crpip.FailoverDeploymentModel = failoverDeploymentModel
			}
		case "groups":
			if v != nil {
				var groups []RecoveryPlanGroup
				err = json.Unmarshal(*v, &groups)
				if err != nil {
					return err
				}
				crpip.Groups = &groups
			}
		case "providerSpecificInput":
			if v != nil {
				providerSpecificInput, err := unmarshalBasicRecoveryPlanProviderSpecificInputArray(*v)
				if err != nil {
					return err
				}
				crpip.ProviderSpecificInput = &providerSpecificInput
			}
		}
	}

	return nil
}

// CurrentJobDetails current job details of the migration item.
type CurrentJobDetails struct {
	// JobName - The job name.
	JobName *string `json:"jobName,omitempty"`
	// JobID - The ARM Id of the job being executed.
	JobID *string `json:"jobId,omitempty"`
	// StartTime - The start time of the job.
	StartTime *date.Time `json:"startTime,omitempty"`
}

// CurrentScenarioDetails current scenario details of the protected entity.
type CurrentScenarioDetails struct {
	// ScenarioName - Scenario name.
	ScenarioName *string `json:"scenarioName,omitempty"`
	// JobID - ARM Id of the job being executed.
	JobID *string `json:"jobId,omitempty"`
	// StartTime - Start time of the workflow.
	StartTime *date.Time `json:"startTime,omitempty"`
}

// DataStore the data store details of the MT.
type DataStore struct {
	// SymbolicName - The symbolic name of data store.
	SymbolicName *string `json:"symbolicName,omitempty"`
	// UUID - The uuid of data store.
	UUID *string `json:"uuid,omitempty"`
	// Capacity - The capacity of data store in GBs.
	Capacity *string `json:"capacity,omitempty"`
	// FreeSpace - The free space of data store in GBs.
	FreeSpace *string `json:"freeSpace,omitempty"`
	// Type - The type of data store.
	Type *string `json:"type,omitempty"`
}

// DisableProtectionInput disable protection input.
type DisableProtectionInput struct {
	// Properties - Disable protection input properties.
	Properties *DisableProtectionInputProperties `json:"properties,omitempty"`
}

// DisableProtectionInputProperties disable protection input properties.
type DisableProtectionInputProperties struct {
	// DisableProtectionReason - Disable protection reason. It can have values NotSpecified/MigrationComplete. Possible values include: 'NotSpecified', 'MigrationComplete'
	DisableProtectionReason DisableProtectionReason `json:"disableProtectionReason,omitempty"`
	// ReplicationProviderInput - Replication provider specific input.
	ReplicationProviderInput BasicDisableProtectionProviderSpecificInput `json:"replicationProviderInput,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for DisableProtectionInputProperties struct.
func (dpip *DisableProtectionInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "disableProtectionReason":
			if v != nil {
				var disableProtectionReason DisableProtectionReason
				err = json.Unmarshal(*v, &disableProtectionReason)
				if err != nil {
					return err
				}
				dpip.DisableProtectionReason = disableProtectionReason
			}
		case "replicationProviderInput":
			if v != nil {
				replicationProviderInput, err := unmarshalBasicDisableProtectionProviderSpecificInput(*v)
				if err != nil {
					return err
				}
				dpip.ReplicationProviderInput = replicationProviderInput
			}
		}
	}

	return nil
}

// BasicDisableProtectionProviderSpecificInput disable protection provider specific input.
type BasicDisableProtectionProviderSpecificInput interface {
	AsInMageDisableProtectionProviderSpecificInput() (*InMageDisableProtectionProviderSpecificInput, bool)
	AsDisableProtectionProviderSpecificInput() (*DisableProtectionProviderSpecificInput, bool)
}

// DisableProtectionProviderSpecificInput disable protection provider specific input.
type DisableProtectionProviderSpecificInput struct {
	// InstanceType - Possible values include: 'InstanceTypeDisableProtectionProviderSpecificInput', 'InstanceTypeInMage'
	InstanceType InstanceTypeBasicDisableProtectionProviderSpecificInput `json:"instanceType,omitempty"`
}

func unmarshalBasicDisableProtectionProviderSpecificInput(body []byte) (BasicDisableProtectionProviderSpecificInput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeInMage):
		var imdppsi InMageDisableProtectionProviderSpecificInput
		err := json.Unmarshal(body, &imdppsi)
		return imdppsi, err
	default:
		var dppsi DisableProtectionProviderSpecificInput
		err := json.Unmarshal(body, &dppsi)
		return dppsi, err
	}
}
func unmarshalBasicDisableProtectionProviderSpecificInputArray(body []byte) ([]BasicDisableProtectionProviderSpecificInput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	dppsiArray := make([]BasicDisableProtectionProviderSpecificInput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		dppsi, err := unmarshalBasicDisableProtectionProviderSpecificInput(*rawMessage)
		if err != nil {
			return nil, err
		}
		dppsiArray[index] = dppsi
	}
	return dppsiArray, nil
}

// MarshalJSON is the custom marshaler for DisableProtectionProviderSpecificInput.
func (dppsi DisableProtectionProviderSpecificInput) MarshalJSON() ([]byte, error) {
	dppsi.InstanceType = InstanceTypeDisableProtectionProviderSpecificInput
	objectMap := make(map[string]interface{})
	if dppsi.InstanceType != "" {
		objectMap["instanceType"] = dppsi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsInMageDisableProtectionProviderSpecificInput is the BasicDisableProtectionProviderSpecificInput implementation for DisableProtectionProviderSpecificInput.
func (dppsi DisableProtectionProviderSpecificInput) AsInMageDisableProtectionProviderSpecificInput() (*InMageDisableProtectionProviderSpecificInput, bool) {
	return nil, false
}

// AsDisableProtectionProviderSpecificInput is the BasicDisableProtectionProviderSpecificInput implementation for DisableProtectionProviderSpecificInput.
func (dppsi DisableProtectionProviderSpecificInput) AsDisableProtectionProviderSpecificInput() (*DisableProtectionProviderSpecificInput, bool) {
	return &dppsi, true
}

// AsBasicDisableProtectionProviderSpecificInput is the BasicDisableProtectionProviderSpecificInput implementation for DisableProtectionProviderSpecificInput.
func (dppsi DisableProtectionProviderSpecificInput) AsBasicDisableProtectionProviderSpecificInput() (BasicDisableProtectionProviderSpecificInput, bool) {
	return &dppsi, true
}

// DiscoverProtectableItemRequest request to add a physical machine as a protectable item in a container.
type DiscoverProtectableItemRequest struct {
	// Properties - The properties of a discover protectable item request.
	Properties *DiscoverProtectableItemRequestProperties `json:"properties,omitempty"`
}

// DiscoverProtectableItemRequestProperties discover protectable item properties.
type DiscoverProtectableItemRequestProperties struct {
	// FriendlyName - The friendly name of the physical machine.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// IPAddress - The IP address of the physical machine to be discovered.
	IPAddress *string `json:"ipAddress,omitempty"`
	// OsType - The OS type on the physical machine.
	OsType *string `json:"osType,omitempty"`
}

// DiskDetails on-prem disk details data.
type DiskDetails struct {
	// MaxSizeMB - The hard disk max size in MB.
	MaxSizeMB *int64 `json:"maxSizeMB,omitempty"`
	// VhdType - The type of the volume.
	VhdType *string `json:"vhdType,omitempty"`
	// VhdID - The VHD Id.
	VhdID *string `json:"vhdId,omitempty"`
	// VhdName - The VHD name.
	VhdName *string `json:"vhdName,omitempty"`
}

// DiskEncryptionInfo recovery disk encryption info (BEK and KEK).
type DiskEncryptionInfo struct {
	// DiskEncryptionKeyInfo - The recovery KeyVault reference for secret.
	DiskEncryptionKeyInfo *DiskEncryptionKeyInfo `json:"diskEncryptionKeyInfo,omitempty"`
	// KeyEncryptionKeyInfo - The recovery KeyVault reference for key.
	KeyEncryptionKeyInfo *KeyEncryptionKeyInfo `json:"keyEncryptionKeyInfo,omitempty"`
}

// DiskEncryptionKeyInfo disk Encryption Key Information (BitLocker Encryption Key (BEK) on Windows).
type DiskEncryptionKeyInfo struct {
	// SecretIdentifier - The secret URL / identifier.
	SecretIdentifier *string `json:"secretIdentifier,omitempty"`
	// KeyVaultResourceArmID - The KeyVault resource ARM Id for secret.
	KeyVaultResourceArmID *string `json:"keyVaultResourceArmId,omitempty"`
}

// DiskVolumeDetails volume details.
type DiskVolumeDetails struct {
	// Label - The volume label.
	Label *string `json:"label,omitempty"`
	// Name - The volume name.
	Name *string `json:"name,omitempty"`
}

// Display contains the localized display information for this particular operation / action. These value
// will be used by several clients for (1) custom role definitions for RBAC; (2) complex query filters for
// the event service; and (3) audit history / records for management operations.
type Display struct {
	// Provider - The provider. The localized friendly form of the resource provider name – it is expected to also include the publisher/company responsible. It should use Title Casing and begin with "Microsoft" for 1st party services. e.g. "Microsoft Monitoring Insights" or "Microsoft Compute."
	Provider *string `json:"provider,omitempty"`
	// Resource - The resource. The localized friendly form of the resource related to this action/operation – it should match the public documentation for the resource provider. It should use Title Casing. This value should be unique for a particular URL type (e.g. nested types should *not* reuse their parent’s display.resource field). e.g. "Virtual Machines" or "Scheduler Job Collections", or "Virtual Machine VM Sizes" or "Scheduler Jobs"
	Resource *string `json:"resource,omitempty"`
	// Operation - The operation. The localized friendly name for the operation, as it should be shown to the user. It should be concise (to fit in drop downs) but clear (i.e. self-documenting). It should use Title Casing. Prescriptive guidance: Read Create or Update Delete 'ActionName'
	Operation *string `json:"operation,omitempty"`
	// Description - The description. The localized friendly description for the operation, as it should be shown to the user. It should be thorough, yet concise – it will be used in tool tips and detailed views. Prescriptive guidance for namespaces: Read any 'display.provider' resource Create or Update any 'display.provider' resource Delete any 'display.provider' resource Perform any other action on any 'display.provider' resource Prescriptive guidance for namespaces: Read any 'display.resource' Create or Update any 'display.resource' Delete any 'display.resource' 'ActionName' any 'display.resources'
	Description *string `json:"description,omitempty"`
}

// DraDetails DRA details.
type DraDetails struct {
	// ID - READ-ONLY; The DRA Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The DRA name.
	Name *string `json:"name,omitempty"`
	// Version - READ-ONLY; The DRA version.
	Version *string `json:"version,omitempty"`
	// LastHeartbeatUtc - READ-ONLY; The last heartbeat received from the DRA.
	LastHeartbeatUtc *date.Time `json:"lastHeartbeatUtc,omitempty"`
	// Health - READ-ONLY; The health of the DRA. Possible values include: 'ProtectionHealthNone', 'ProtectionHealthNormal', 'ProtectionHealthWarning', 'ProtectionHealthCritical'
	Health ProtectionHealth `json:"health,omitempty"`
	// HealthErrors - READ-ONLY; The health errors.
	HealthErrors *[]HealthError `json:"healthErrors,omitempty"`
}

// EnableMigrationInput enable migration input.
type EnableMigrationInput struct {
	// Properties - Enable migration input properties.
	Properties *EnableMigrationInputProperties `json:"properties,omitempty"`
}

// EnableMigrationInputProperties enable migration input properties.
type EnableMigrationInputProperties struct {
	// PolicyID - The policy Id.
	PolicyID *string `json:"policyId,omitempty"`
	// ProviderSpecificDetails - The provider specific details.
	ProviderSpecificDetails BasicEnableMigrationProviderSpecificInput `json:"providerSpecificDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for EnableMigrationInputProperties struct.
func (emip *EnableMigrationInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "policyId":
			if v != nil {
				var policyID string
				err = json.Unmarshal(*v, &policyID)
				if err != nil {
					return err
				}
				emip.PolicyID = &policyID
			}
		case "providerSpecificDetails":
			if v != nil {
				providerSpecificDetails, err := unmarshalBasicEnableMigrationProviderSpecificInput(*v)
				if err != nil {
					return err
				}
				emip.ProviderSpecificDetails = providerSpecificDetails
			}
		}
	}

	return nil
}

// BasicEnableMigrationProviderSpecificInput enable migration provider specific input.
type BasicEnableMigrationProviderSpecificInput interface {
	AsVMwareCbtEnableMigrationInput() (*VMwareCbtEnableMigrationInput, bool)
	AsEnableMigrationProviderSpecificInput() (*EnableMigrationProviderSpecificInput, bool)
}

// EnableMigrationProviderSpecificInput enable migration provider specific input.
type EnableMigrationProviderSpecificInput struct {
	// InstanceType - Possible values include: 'InstanceTypeEnableMigrationProviderSpecificInput', 'InstanceTypeVMwareCbt'
	InstanceType InstanceTypeBasicEnableMigrationProviderSpecificInput `json:"instanceType,omitempty"`
}

func unmarshalBasicEnableMigrationProviderSpecificInput(body []byte) (BasicEnableMigrationProviderSpecificInput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeVMwareCbt):
		var vmcemi VMwareCbtEnableMigrationInput
		err := json.Unmarshal(body, &vmcemi)
		return vmcemi, err
	default:
		var empsi EnableMigrationProviderSpecificInput
		err := json.Unmarshal(body, &empsi)
		return empsi, err
	}
}
func unmarshalBasicEnableMigrationProviderSpecificInputArray(body []byte) ([]BasicEnableMigrationProviderSpecificInput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	empsiArray := make([]BasicEnableMigrationProviderSpecificInput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		empsi, err := unmarshalBasicEnableMigrationProviderSpecificInput(*rawMessage)
		if err != nil {
			return nil, err
		}
		empsiArray[index] = empsi
	}
	return empsiArray, nil
}

// MarshalJSON is the custom marshaler for EnableMigrationProviderSpecificInput.
func (empsi EnableMigrationProviderSpecificInput) MarshalJSON() ([]byte, error) {
	empsi.InstanceType = InstanceTypeEnableMigrationProviderSpecificInput
	objectMap := make(map[string]interface{})
	if empsi.InstanceType != "" {
		objectMap["instanceType"] = empsi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsVMwareCbtEnableMigrationInput is the BasicEnableMigrationProviderSpecificInput implementation for EnableMigrationProviderSpecificInput.
func (empsi EnableMigrationProviderSpecificInput) AsVMwareCbtEnableMigrationInput() (*VMwareCbtEnableMigrationInput, bool) {
	return nil, false
}

// AsEnableMigrationProviderSpecificInput is the BasicEnableMigrationProviderSpecificInput implementation for EnableMigrationProviderSpecificInput.
func (empsi EnableMigrationProviderSpecificInput) AsEnableMigrationProviderSpecificInput() (*EnableMigrationProviderSpecificInput, bool) {
	return &empsi, true
}

// AsBasicEnableMigrationProviderSpecificInput is the BasicEnableMigrationProviderSpecificInput implementation for EnableMigrationProviderSpecificInput.
func (empsi EnableMigrationProviderSpecificInput) AsBasicEnableMigrationProviderSpecificInput() (BasicEnableMigrationProviderSpecificInput, bool) {
	return &empsi, true
}

// EnableProtectionInput enable protection input.
type EnableProtectionInput struct {
	// Properties - Enable protection input properties.
	Properties *EnableProtectionInputProperties `json:"properties,omitempty"`
}

// EnableProtectionInputProperties enable protection input properties.
type EnableProtectionInputProperties struct {
	// PolicyID - The Policy Id.
	PolicyID *string `json:"policyId,omitempty"`
	// ProtectableItemID - The protectable item Id.
	ProtectableItemID *string `json:"protectableItemId,omitempty"`
	// ProviderSpecificDetails - The ReplicationProviderInput. For HyperVReplicaAzure provider, it will be AzureEnableProtectionInput object. For San provider, it will be SanEnableProtectionInput object. For HyperVReplicaAzure provider, it can be null.
	ProviderSpecificDetails BasicEnableProtectionProviderSpecificInput `json:"providerSpecificDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for EnableProtectionInputProperties struct.
func (epip *EnableProtectionInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "policyId":
			if v != nil {
				var policyID string
				err = json.Unmarshal(*v, &policyID)
				if err != nil {
					return err
				}
				epip.PolicyID = &policyID
			}
		case "protectableItemId":
			if v != nil {
				var protectableItemID string
				err = json.Unmarshal(*v, &protectableItemID)
				if err != nil {
					return err
				}
				epip.ProtectableItemID = &protectableItemID
			}
		case "providerSpecificDetails":
			if v != nil {
				providerSpecificDetails, err := unmarshalBasicEnableProtectionProviderSpecificInput(*v)
				if err != nil {
					return err
				}
				epip.ProviderSpecificDetails = providerSpecificDetails
			}
		}
	}

	return nil
}

// BasicEnableProtectionProviderSpecificInput enable protection provider specific input.
type BasicEnableProtectionProviderSpecificInput interface {
	AsA2AEnableProtectionInput() (*A2AEnableProtectionInput, bool)
	AsHyperVReplicaAzureEnableProtectionInput() (*HyperVReplicaAzureEnableProtectionInput, bool)
	AsInMageAzureV2EnableProtectionInput() (*InMageAzureV2EnableProtectionInput, bool)
	AsInMageEnableProtectionInput() (*InMageEnableProtectionInput, bool)
	AsInMageRcmEnableProtectionInput() (*InMageRcmEnableProtectionInput, bool)
	AsSanEnableProtectionInput() (*SanEnableProtectionInput, bool)
	AsEnableProtectionProviderSpecificInput() (*EnableProtectionProviderSpecificInput, bool)
}

// EnableProtectionProviderSpecificInput enable protection provider specific input.
type EnableProtectionProviderSpecificInput struct {
	// InstanceType - Possible values include: 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeEnableProtectionProviderSpecificInput', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeA2A', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMage', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMageRcm', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeSan'
	InstanceType InstanceTypeBasicEnableProtectionProviderSpecificInput `json:"instanceType,omitempty"`
}

func unmarshalBasicEnableProtectionProviderSpecificInput(body []byte) (BasicEnableProtectionProviderSpecificInput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeA2A):
		var aepi A2AEnableProtectionInput
		err := json.Unmarshal(body, &aepi)
		return aepi, err
	case string(InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeHyperVReplicaAzure):
		var hvraepi HyperVReplicaAzureEnableProtectionInput
		err := json.Unmarshal(body, &hvraepi)
		return hvraepi, err
	case string(InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMageAzureV2):
		var imavepi InMageAzureV2EnableProtectionInput
		err := json.Unmarshal(body, &imavepi)
		return imavepi, err
	case string(InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMage):
		var imepi InMageEnableProtectionInput
		err := json.Unmarshal(body, &imepi)
		return imepi, err
	case string(InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMageRcm):
		var imrepi InMageRcmEnableProtectionInput
		err := json.Unmarshal(body, &imrepi)
		return imrepi, err
	case string(InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeSan):
		var sepi SanEnableProtectionInput
		err := json.Unmarshal(body, &sepi)
		return sepi, err
	default:
		var eppsi EnableProtectionProviderSpecificInput
		err := json.Unmarshal(body, &eppsi)
		return eppsi, err
	}
}
func unmarshalBasicEnableProtectionProviderSpecificInputArray(body []byte) ([]BasicEnableProtectionProviderSpecificInput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	eppsiArray := make([]BasicEnableProtectionProviderSpecificInput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		eppsi, err := unmarshalBasicEnableProtectionProviderSpecificInput(*rawMessage)
		if err != nil {
			return nil, err
		}
		eppsiArray[index] = eppsi
	}
	return eppsiArray, nil
}

// MarshalJSON is the custom marshaler for EnableProtectionProviderSpecificInput.
func (eppsi EnableProtectionProviderSpecificInput) MarshalJSON() ([]byte, error) {
	eppsi.InstanceType = InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeEnableProtectionProviderSpecificInput
	objectMap := make(map[string]interface{})
	if eppsi.InstanceType != "" {
		objectMap["instanceType"] = eppsi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for EnableProtectionProviderSpecificInput.
func (eppsi EnableProtectionProviderSpecificInput) AsA2AEnableProtectionInput() (*A2AEnableProtectionInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzureEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for EnableProtectionProviderSpecificInput.
func (eppsi EnableProtectionProviderSpecificInput) AsHyperVReplicaAzureEnableProtectionInput() (*HyperVReplicaAzureEnableProtectionInput, bool) {
	return nil, false
}

// AsInMageAzureV2EnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for EnableProtectionProviderSpecificInput.
func (eppsi EnableProtectionProviderSpecificInput) AsInMageAzureV2EnableProtectionInput() (*InMageAzureV2EnableProtectionInput, bool) {
	return nil, false
}

// AsInMageEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for EnableProtectionProviderSpecificInput.
func (eppsi EnableProtectionProviderSpecificInput) AsInMageEnableProtectionInput() (*InMageEnableProtectionInput, bool) {
	return nil, false
}

// AsInMageRcmEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for EnableProtectionProviderSpecificInput.
func (eppsi EnableProtectionProviderSpecificInput) AsInMageRcmEnableProtectionInput() (*InMageRcmEnableProtectionInput, bool) {
	return nil, false
}

// AsSanEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for EnableProtectionProviderSpecificInput.
func (eppsi EnableProtectionProviderSpecificInput) AsSanEnableProtectionInput() (*SanEnableProtectionInput, bool) {
	return nil, false
}

// AsEnableProtectionProviderSpecificInput is the BasicEnableProtectionProviderSpecificInput implementation for EnableProtectionProviderSpecificInput.
func (eppsi EnableProtectionProviderSpecificInput) AsEnableProtectionProviderSpecificInput() (*EnableProtectionProviderSpecificInput, bool) {
	return &eppsi, true
}

// AsBasicEnableProtectionProviderSpecificInput is the BasicEnableProtectionProviderSpecificInput implementation for EnableProtectionProviderSpecificInput.
func (eppsi EnableProtectionProviderSpecificInput) AsBasicEnableProtectionProviderSpecificInput() (BasicEnableProtectionProviderSpecificInput, bool) {
	return &eppsi, true
}

// EncryptionDetails encryption details for the fabric.
type EncryptionDetails struct {
	// KekState - The key encryption key state for the Vmm.
	KekState *string `json:"kekState,omitempty"`
	// KekCertThumbprint - The key encryption key certificate thumbprint.
	KekCertThumbprint *string `json:"kekCertThumbprint,omitempty"`
	// KekCertExpiryDate - The key encryption key certificate expiry date.
	KekCertExpiryDate *date.Time `json:"kekCertExpiryDate,omitempty"`
}

// Event implements the Event class.
type Event struct {
	autorest.Response `json:"-"`
	// Properties - Event related data.
	Properties *EventProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource Type
	Type *string `json:"type,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for Event.
func (e Event) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if e.Properties != nil {
		objectMap["properties"] = e.Properties
	}
	if e.Location != nil {
		objectMap["location"] = e.Location
	}
	return json.Marshal(objectMap)
}

// EventCollection collection of fabric details.
type EventCollection struct {
	autorest.Response `json:"-"`
	// Value - The list of events.
	Value *[]Event `json:"value,omitempty"`
	// NextLink - The value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// EventCollectionIterator provides access to a complete listing of Event values.
type EventCollectionIterator struct {
	i    int
	page EventCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EventCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EventCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EventCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EventCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EventCollectionIterator) Response() EventCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EventCollectionIterator) Value() Event {
	if !iter.page.NotDone() {
		return Event{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EventCollectionIterator type.
func NewEventCollectionIterator(page EventCollectionPage) EventCollectionIterator {
	return EventCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ec EventCollection) IsEmpty() bool {
	return ec.Value == nil || len(*ec.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ec EventCollection) hasNextLink() bool {
	return ec.NextLink != nil && len(*ec.NextLink) != 0
}

// eventCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ec EventCollection) eventCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !ec.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ec.NextLink)))
}

// EventCollectionPage contains a page of Event values.
type EventCollectionPage struct {
	fn func(context.Context, EventCollection) (EventCollection, error)
	ec EventCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EventCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EventCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ec)
		if err != nil {
			return err
		}
		page.ec = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EventCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EventCollectionPage) NotDone() bool {
	return !page.ec.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EventCollectionPage) Response() EventCollection {
	return page.ec
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EventCollectionPage) Values() []Event {
	if page.ec.IsEmpty() {
		return nil
	}
	return *page.ec.Value
}

// Creates a new instance of the EventCollectionPage type.
func NewEventCollectionPage(cur EventCollection, getNextPage func(context.Context, EventCollection) (EventCollection, error)) EventCollectionPage {
	return EventCollectionPage{
		fn: getNextPage,
		ec: cur,
	}
}

// EventProperties the properties of a monitoring event.
type EventProperties struct {
	// EventCode - The Id of the monitoring event.
	EventCode *string `json:"eventCode,omitempty"`
	// Description - The event name.
	Description *string `json:"description,omitempty"`
	// EventType - The type of the event. for example: VM Health, Server Health, Job Failure etc.
	EventType *string `json:"eventType,omitempty"`
	// AffectedObjectFriendlyName - The friendly name of the source of the event on which it is raised (for example, VM, VMM etc).
	AffectedObjectFriendlyName *string `json:"affectedObjectFriendlyName,omitempty"`
	// Severity - The severity of the event.
	Severity *string `json:"severity,omitempty"`
	// TimeOfOccurrence - The time of occurrence of the event.
	TimeOfOccurrence *date.Time `json:"timeOfOccurrence,omitempty"`
	// FabricID - The ARM ID of the fabric.
	FabricID *string `json:"fabricId,omitempty"`
	// ProviderSpecificDetails - The provider specific settings.
	ProviderSpecificDetails BasicEventProviderSpecificDetails `json:"providerSpecificDetails,omitempty"`
	// EventSpecificDetails - The event specific settings.
	EventSpecificDetails BasicEventSpecificDetails `json:"eventSpecificDetails,omitempty"`
	// HealthErrors - The list of errors / warnings capturing details associated with the issue(s).
	HealthErrors *[]HealthError `json:"healthErrors,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for EventProperties struct.
func (ep *EventProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "eventCode":
			if v != nil {
				var eventCode string
				err = json.Unmarshal(*v, &eventCode)
				if err != nil {
					return err
				}
				ep.EventCode = &eventCode
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				ep.Description = &description
			}
		case "eventType":
			if v != nil {
				var eventType string
				err = json.Unmarshal(*v, &eventType)
				if err != nil {
					return err
				}
				ep.EventType = &eventType
			}
		case "affectedObjectFriendlyName":
			if v != nil {
				var affectedObjectFriendlyName string
				err = json.Unmarshal(*v, &affectedObjectFriendlyName)
				if err != nil {
					return err
				}
				ep.AffectedObjectFriendlyName = &affectedObjectFriendlyName
			}
		case "severity":
			if v != nil {
				var severity string
				err = json.Unmarshal(*v, &severity)
				if err != nil {
					return err
				}
				ep.Severity = &severity
			}
		case "timeOfOccurrence":
			if v != nil {
				var timeOfOccurrence date.Time
				err = json.Unmarshal(*v, &timeOfOccurrence)
				if err != nil {
					return err
				}
				ep.TimeOfOccurrence = &timeOfOccurrence
			}
		case "fabricId":
			if v != nil {
				var fabricID string
				err = json.Unmarshal(*v, &fabricID)
				if err != nil {
					return err
				}
				ep.FabricID = &fabricID
			}
		case "providerSpecificDetails":
			if v != nil {
				providerSpecificDetails, err := unmarshalBasicEventProviderSpecificDetails(*v)
				if err != nil {
					return err
				}
				ep.ProviderSpecificDetails = providerSpecificDetails
			}
		case "eventSpecificDetails":
			if v != nil {
				eventSpecificDetails, err := unmarshalBasicEventSpecificDetails(*v)
				if err != nil {
					return err
				}
				ep.EventSpecificDetails = eventSpecificDetails
			}
		case "healthErrors":
			if v != nil {
				var healthErrors []HealthError
				err = json.Unmarshal(*v, &healthErrors)
				if err != nil {
					return err
				}
				ep.HealthErrors = &healthErrors
			}
		}
	}

	return nil
}

// BasicEventProviderSpecificDetails model class for provider specific details for an event.
type BasicEventProviderSpecificDetails interface {
	AsA2AEventDetails() (*A2AEventDetails, bool)
	AsHyperVReplica2012EventDetails() (*HyperVReplica2012EventDetails, bool)
	AsHyperVReplica2012R2EventDetails() (*HyperVReplica2012R2EventDetails, bool)
	AsHyperVReplicaAzureEventDetails() (*HyperVReplicaAzureEventDetails, bool)
	AsHyperVReplicaBaseEventDetails() (*HyperVReplicaBaseEventDetails, bool)
	AsInMageAzureV2EventDetails() (*InMageAzureV2EventDetails, bool)
	AsInMageRcmEventDetails() (*InMageRcmEventDetails, bool)
	AsEventProviderSpecificDetails() (*EventProviderSpecificDetails, bool)
}

// EventProviderSpecificDetails model class for provider specific details for an event.
type EventProviderSpecificDetails struct {
	// InstanceType - Possible values include: 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeEventProviderSpecificDetails', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeA2A', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplicaBaseEventDetails', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeInMageAzureV2', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeInMageRcm'
	InstanceType InstanceTypeBasicEventProviderSpecificDetails `json:"instanceType,omitempty"`
}

func unmarshalBasicEventProviderSpecificDetails(body []byte) (BasicEventProviderSpecificDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeA2A):
		var aed A2AEventDetails
		err := json.Unmarshal(body, &aed)
		return aed, err
	case string(InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplica2012):
		var hvr2ed HyperVReplica2012EventDetails
		err := json.Unmarshal(body, &hvr2ed)
		return hvr2ed, err
	case string(InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplica2012R2):
		var hvr2ed HyperVReplica2012R2EventDetails
		err := json.Unmarshal(body, &hvr2ed)
		return hvr2ed, err
	case string(InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplicaAzure):
		var hvraed HyperVReplicaAzureEventDetails
		err := json.Unmarshal(body, &hvraed)
		return hvraed, err
	case string(InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplicaBaseEventDetails):
		var hvrbed HyperVReplicaBaseEventDetails
		err := json.Unmarshal(body, &hvrbed)
		return hvrbed, err
	case string(InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeInMageAzureV2):
		var imaved InMageAzureV2EventDetails
		err := json.Unmarshal(body, &imaved)
		return imaved, err
	case string(InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeInMageRcm):
		var imred InMageRcmEventDetails
		err := json.Unmarshal(body, &imred)
		return imred, err
	default:
		var epsd EventProviderSpecificDetails
		err := json.Unmarshal(body, &epsd)
		return epsd, err
	}
}
func unmarshalBasicEventProviderSpecificDetailsArray(body []byte) ([]BasicEventProviderSpecificDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	epsdArray := make([]BasicEventProviderSpecificDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		epsd, err := unmarshalBasicEventProviderSpecificDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		epsdArray[index] = epsd
	}
	return epsdArray, nil
}

// MarshalJSON is the custom marshaler for EventProviderSpecificDetails.
func (epsd EventProviderSpecificDetails) MarshalJSON() ([]byte, error) {
	epsd.InstanceType = InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeEventProviderSpecificDetails
	objectMap := make(map[string]interface{})
	if epsd.InstanceType != "" {
		objectMap["instanceType"] = epsd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AEventDetails is the BasicEventProviderSpecificDetails implementation for EventProviderSpecificDetails.
func (epsd EventProviderSpecificDetails) AsA2AEventDetails() (*A2AEventDetails, bool) {
	return nil, false
}

// AsHyperVReplica2012EventDetails is the BasicEventProviderSpecificDetails implementation for EventProviderSpecificDetails.
func (epsd EventProviderSpecificDetails) AsHyperVReplica2012EventDetails() (*HyperVReplica2012EventDetails, bool) {
	return nil, false
}

// AsHyperVReplica2012R2EventDetails is the BasicEventProviderSpecificDetails implementation for EventProviderSpecificDetails.
func (epsd EventProviderSpecificDetails) AsHyperVReplica2012R2EventDetails() (*HyperVReplica2012R2EventDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzureEventDetails is the BasicEventProviderSpecificDetails implementation for EventProviderSpecificDetails.
func (epsd EventProviderSpecificDetails) AsHyperVReplicaAzureEventDetails() (*HyperVReplicaAzureEventDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBaseEventDetails is the BasicEventProviderSpecificDetails implementation for EventProviderSpecificDetails.
func (epsd EventProviderSpecificDetails) AsHyperVReplicaBaseEventDetails() (*HyperVReplicaBaseEventDetails, bool) {
	return nil, false
}

// AsInMageAzureV2EventDetails is the BasicEventProviderSpecificDetails implementation for EventProviderSpecificDetails.
func (epsd EventProviderSpecificDetails) AsInMageAzureV2EventDetails() (*InMageAzureV2EventDetails, bool) {
	return nil, false
}

// AsInMageRcmEventDetails is the BasicEventProviderSpecificDetails implementation for EventProviderSpecificDetails.
func (epsd EventProviderSpecificDetails) AsInMageRcmEventDetails() (*InMageRcmEventDetails, bool) {
	return nil, false
}

// AsEventProviderSpecificDetails is the BasicEventProviderSpecificDetails implementation for EventProviderSpecificDetails.
func (epsd EventProviderSpecificDetails) AsEventProviderSpecificDetails() (*EventProviderSpecificDetails, bool) {
	return &epsd, true
}

// AsBasicEventProviderSpecificDetails is the BasicEventProviderSpecificDetails implementation for EventProviderSpecificDetails.
func (epsd EventProviderSpecificDetails) AsBasicEventProviderSpecificDetails() (BasicEventProviderSpecificDetails, bool) {
	return &epsd, true
}

// EventQueryParameter implements the event query parameter.
type EventQueryParameter struct {
	// EventCode - The source id of the events to be queried.
	EventCode *string `json:"eventCode,omitempty"`
	// Severity - The severity of the events to be queried.
	Severity *string `json:"severity,omitempty"`
	// EventType - The type of the events to be queried.
	EventType *string `json:"eventType,omitempty"`
	// FabricName - The affected object server id of the events to be queried.
	FabricName *string `json:"fabricName,omitempty"`
	// AffectedObjectFriendlyName - The affected object name of the events to be queried.
	AffectedObjectFriendlyName *string `json:"affectedObjectFriendlyName,omitempty"`
	// StartTime - The start time of the time range within which the events are to be queried.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The end time of the time range within which the events are to be queried.
	EndTime *date.Time `json:"endTime,omitempty"`
}

// BasicEventSpecificDetails model class for event specific details for an event.
type BasicEventSpecificDetails interface {
	AsJobStatusEventDetails() (*JobStatusEventDetails, bool)
	AsEventSpecificDetails() (*EventSpecificDetails, bool)
}

// EventSpecificDetails model class for event specific details for an event.
type EventSpecificDetails struct {
	// InstanceType - Possible values include: 'InstanceTypeEventSpecificDetails', 'InstanceTypeJobStatus'
	InstanceType InstanceTypeBasicEventSpecificDetails `json:"instanceType,omitempty"`
}

func unmarshalBasicEventSpecificDetails(body []byte) (BasicEventSpecificDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeJobStatus):
		var jsed JobStatusEventDetails
		err := json.Unmarshal(body, &jsed)
		return jsed, err
	default:
		var esd EventSpecificDetails
		err := json.Unmarshal(body, &esd)
		return esd, err
	}
}
func unmarshalBasicEventSpecificDetailsArray(body []byte) ([]BasicEventSpecificDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	esdArray := make([]BasicEventSpecificDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		esd, err := unmarshalBasicEventSpecificDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		esdArray[index] = esd
	}
	return esdArray, nil
}

// MarshalJSON is the custom marshaler for EventSpecificDetails.
func (esd EventSpecificDetails) MarshalJSON() ([]byte, error) {
	esd.InstanceType = InstanceTypeEventSpecificDetails
	objectMap := make(map[string]interface{})
	if esd.InstanceType != "" {
		objectMap["instanceType"] = esd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsJobStatusEventDetails is the BasicEventSpecificDetails implementation for EventSpecificDetails.
func (esd EventSpecificDetails) AsJobStatusEventDetails() (*JobStatusEventDetails, bool) {
	return nil, false
}

// AsEventSpecificDetails is the BasicEventSpecificDetails implementation for EventSpecificDetails.
func (esd EventSpecificDetails) AsEventSpecificDetails() (*EventSpecificDetails, bool) {
	return &esd, true
}

// AsBasicEventSpecificDetails is the BasicEventSpecificDetails implementation for EventSpecificDetails.
func (esd EventSpecificDetails) AsBasicEventSpecificDetails() (BasicEventSpecificDetails, bool) {
	return &esd, true
}

// ExistingProtectionProfile existing storage account input.
type ExistingProtectionProfile struct {
	// ProtectionProfileID - The protection profile Arm Id. Throw error, if resource does not exists.
	ProtectionProfileID *string `json:"protectionProfileId,omitempty"`
	// ResourceType - Possible values include: 'ResourceTypeProtectionProfileCustomDetails', 'ResourceTypeExisting', 'ResourceTypeNew'
	ResourceType ResourceType `json:"resourceType,omitempty"`
}

// MarshalJSON is the custom marshaler for ExistingProtectionProfile.
func (epp ExistingProtectionProfile) MarshalJSON() ([]byte, error) {
	epp.ResourceType = ResourceTypeExisting
	objectMap := make(map[string]interface{})
	if epp.ProtectionProfileID != nil {
		objectMap["protectionProfileId"] = epp.ProtectionProfileID
	}
	if epp.ResourceType != "" {
		objectMap["resourceType"] = epp.ResourceType
	}
	return json.Marshal(objectMap)
}

// AsExistingProtectionProfile is the BasicProtectionProfileCustomDetails implementation for ExistingProtectionProfile.
func (epp ExistingProtectionProfile) AsExistingProtectionProfile() (*ExistingProtectionProfile, bool) {
	return &epp, true
}

// AsNewProtectionProfile is the BasicProtectionProfileCustomDetails implementation for ExistingProtectionProfile.
func (epp ExistingProtectionProfile) AsNewProtectionProfile() (*NewProtectionProfile, bool) {
	return nil, false
}

// AsProtectionProfileCustomDetails is the BasicProtectionProfileCustomDetails implementation for ExistingProtectionProfile.
func (epp ExistingProtectionProfile) AsProtectionProfileCustomDetails() (*ProtectionProfileCustomDetails, bool) {
	return nil, false
}

// AsBasicProtectionProfileCustomDetails is the BasicProtectionProfileCustomDetails implementation for ExistingProtectionProfile.
func (epp ExistingProtectionProfile) AsBasicProtectionProfileCustomDetails() (BasicProtectionProfileCustomDetails, bool) {
	return &epp, true
}

// ExistingRecoveryAvailabilitySet existing recovery availability set input.
type ExistingRecoveryAvailabilitySet struct {
	// RecoveryAvailabilitySetID - The recovery availability set Id. Will throw error, if resource does not exist.
	RecoveryAvailabilitySetID *string `json:"recoveryAvailabilitySetId,omitempty"`
	// ResourceType - Possible values include: 'ResourceTypeBasicRecoveryAvailabilitySetCustomDetailsResourceTypeRecoveryAvailabilitySetCustomDetails', 'ResourceTypeBasicRecoveryAvailabilitySetCustomDetailsResourceTypeExisting'
	ResourceType ResourceTypeBasicRecoveryAvailabilitySetCustomDetails `json:"resourceType,omitempty"`
}

// MarshalJSON is the custom marshaler for ExistingRecoveryAvailabilitySet.
func (eras ExistingRecoveryAvailabilitySet) MarshalJSON() ([]byte, error) {
	eras.ResourceType = ResourceTypeBasicRecoveryAvailabilitySetCustomDetailsResourceTypeExisting
	objectMap := make(map[string]interface{})
	if eras.RecoveryAvailabilitySetID != nil {
		objectMap["recoveryAvailabilitySetId"] = eras.RecoveryAvailabilitySetID
	}
	if eras.ResourceType != "" {
		objectMap["resourceType"] = eras.ResourceType
	}
	return json.Marshal(objectMap)
}

// AsExistingRecoveryAvailabilitySet is the BasicRecoveryAvailabilitySetCustomDetails implementation for ExistingRecoveryAvailabilitySet.
func (eras ExistingRecoveryAvailabilitySet) AsExistingRecoveryAvailabilitySet() (*ExistingRecoveryAvailabilitySet, bool) {
	return &eras, true
}

// AsRecoveryAvailabilitySetCustomDetails is the BasicRecoveryAvailabilitySetCustomDetails implementation for ExistingRecoveryAvailabilitySet.
func (eras ExistingRecoveryAvailabilitySet) AsRecoveryAvailabilitySetCustomDetails() (*RecoveryAvailabilitySetCustomDetails, bool) {
	return nil, false
}

// AsBasicRecoveryAvailabilitySetCustomDetails is the BasicRecoveryAvailabilitySetCustomDetails implementation for ExistingRecoveryAvailabilitySet.
func (eras ExistingRecoveryAvailabilitySet) AsBasicRecoveryAvailabilitySetCustomDetails() (BasicRecoveryAvailabilitySetCustomDetails, bool) {
	return &eras, true
}

// ExistingRecoveryProximityPlacementGroup existing recovery proximity placement group input.
type ExistingRecoveryProximityPlacementGroup struct {
	// RecoveryProximityPlacementGroupID - The recovery proximity placement group Id. Will throw error, if resource does not exist.
	RecoveryProximityPlacementGroupID *string `json:"recoveryProximityPlacementGroupId,omitempty"`
	// ResourceType - Possible values include: 'ResourceTypeBasicRecoveryProximityPlacementGroupCustomDetailsResourceTypeRecoveryProximityPlacementGroupCustomDetails', 'ResourceTypeBasicRecoveryProximityPlacementGroupCustomDetailsResourceTypeExisting'
	ResourceType ResourceTypeBasicRecoveryProximityPlacementGroupCustomDetails `json:"resourceType,omitempty"`
}

// MarshalJSON is the custom marshaler for ExistingRecoveryProximityPlacementGroup.
func (erppg ExistingRecoveryProximityPlacementGroup) MarshalJSON() ([]byte, error) {
	erppg.ResourceType = ResourceTypeBasicRecoveryProximityPlacementGroupCustomDetailsResourceTypeExisting
	objectMap := make(map[string]interface{})
	if erppg.RecoveryProximityPlacementGroupID != nil {
		objectMap["recoveryProximityPlacementGroupId"] = erppg.RecoveryProximityPlacementGroupID
	}
	if erppg.ResourceType != "" {
		objectMap["resourceType"] = erppg.ResourceType
	}
	return json.Marshal(objectMap)
}

// AsExistingRecoveryProximityPlacementGroup is the BasicRecoveryProximityPlacementGroupCustomDetails implementation for ExistingRecoveryProximityPlacementGroup.
func (erppg ExistingRecoveryProximityPlacementGroup) AsExistingRecoveryProximityPlacementGroup() (*ExistingRecoveryProximityPlacementGroup, bool) {
	return &erppg, true
}

// AsRecoveryProximityPlacementGroupCustomDetails is the BasicRecoveryProximityPlacementGroupCustomDetails implementation for ExistingRecoveryProximityPlacementGroup.
func (erppg ExistingRecoveryProximityPlacementGroup) AsRecoveryProximityPlacementGroupCustomDetails() (*RecoveryProximityPlacementGroupCustomDetails, bool) {
	return nil, false
}

// AsBasicRecoveryProximityPlacementGroupCustomDetails is the BasicRecoveryProximityPlacementGroupCustomDetails implementation for ExistingRecoveryProximityPlacementGroup.
func (erppg ExistingRecoveryProximityPlacementGroup) AsBasicRecoveryProximityPlacementGroupCustomDetails() (BasicRecoveryProximityPlacementGroupCustomDetails, bool) {
	return &erppg, true
}

// ExistingRecoveryRecoveryResourceGroup existing recovery resource group input.
type ExistingRecoveryRecoveryResourceGroup struct {
	// RecoveryResourceGroupID - The recovery resource group Id. Valid for V2 scenarios.
	RecoveryResourceGroupID *string `json:"recoveryResourceGroupId,omitempty"`
	// ResourceType - Possible values include: 'ResourceTypeBasicRecoveryResourceGroupCustomDetailsResourceTypeRecoveryResourceGroupCustomDetails', 'ResourceTypeBasicRecoveryResourceGroupCustomDetailsResourceTypeExisting'
	ResourceType ResourceTypeBasicRecoveryResourceGroupCustomDetails `json:"resourceType,omitempty"`
}

// MarshalJSON is the custom marshaler for ExistingRecoveryRecoveryResourceGroup.
func (errrg ExistingRecoveryRecoveryResourceGroup) MarshalJSON() ([]byte, error) {
	errrg.ResourceType = ResourceTypeBasicRecoveryResourceGroupCustomDetailsResourceTypeExisting
	objectMap := make(map[string]interface{})
	if errrg.RecoveryResourceGroupID != nil {
		objectMap["recoveryResourceGroupId"] = errrg.RecoveryResourceGroupID
	}
	if errrg.ResourceType != "" {
		objectMap["resourceType"] = errrg.ResourceType
	}
	return json.Marshal(objectMap)
}

// AsExistingRecoveryRecoveryResourceGroup is the BasicRecoveryResourceGroupCustomDetails implementation for ExistingRecoveryRecoveryResourceGroup.
func (errrg ExistingRecoveryRecoveryResourceGroup) AsExistingRecoveryRecoveryResourceGroup() (*ExistingRecoveryRecoveryResourceGroup, bool) {
	return &errrg, true
}

// AsRecoveryResourceGroupCustomDetails is the BasicRecoveryResourceGroupCustomDetails implementation for ExistingRecoveryRecoveryResourceGroup.
func (errrg ExistingRecoveryRecoveryResourceGroup) AsRecoveryResourceGroupCustomDetails() (*RecoveryResourceGroupCustomDetails, bool) {
	return nil, false
}

// AsBasicRecoveryResourceGroupCustomDetails is the BasicRecoveryResourceGroupCustomDetails implementation for ExistingRecoveryRecoveryResourceGroup.
func (errrg ExistingRecoveryRecoveryResourceGroup) AsBasicRecoveryResourceGroupCustomDetails() (BasicRecoveryResourceGroupCustomDetails, bool) {
	return &errrg, true
}

// ExistingRecoveryVirtualNetwork existing recovery virtual network input.
type ExistingRecoveryVirtualNetwork struct {
	// RecoveryVirtualNetworkID - The recovery virtual network Id. Will throw error, if resource does not exist.
	RecoveryVirtualNetworkID *string `json:"recoveryVirtualNetworkId,omitempty"`
	// RecoverySubnetName - The recovery subnet name.
	RecoverySubnetName *string `json:"recoverySubnetName,omitempty"`
	// ResourceType - Possible values include: 'ResourceTypeBasicRecoveryVirtualNetworkCustomDetailsResourceTypeRecoveryVirtualNetworkCustomDetails', 'ResourceTypeBasicRecoveryVirtualNetworkCustomDetailsResourceTypeExisting'
	ResourceType ResourceTypeBasicRecoveryVirtualNetworkCustomDetails `json:"resourceType,omitempty"`
}

// MarshalJSON is the custom marshaler for ExistingRecoveryVirtualNetwork.
func (ervn ExistingRecoveryVirtualNetwork) MarshalJSON() ([]byte, error) {
	ervn.ResourceType = ResourceTypeBasicRecoveryVirtualNetworkCustomDetailsResourceTypeExisting
	objectMap := make(map[string]interface{})
	if ervn.RecoveryVirtualNetworkID != nil {
		objectMap["recoveryVirtualNetworkId"] = ervn.RecoveryVirtualNetworkID
	}
	if ervn.RecoverySubnetName != nil {
		objectMap["recoverySubnetName"] = ervn.RecoverySubnetName
	}
	if ervn.ResourceType != "" {
		objectMap["resourceType"] = ervn.ResourceType
	}
	return json.Marshal(objectMap)
}

// AsExistingRecoveryVirtualNetwork is the BasicRecoveryVirtualNetworkCustomDetails implementation for ExistingRecoveryVirtualNetwork.
func (ervn ExistingRecoveryVirtualNetwork) AsExistingRecoveryVirtualNetwork() (*ExistingRecoveryVirtualNetwork, bool) {
	return &ervn, true
}

// AsRecoveryVirtualNetworkCustomDetails is the BasicRecoveryVirtualNetworkCustomDetails implementation for ExistingRecoveryVirtualNetwork.
func (ervn ExistingRecoveryVirtualNetwork) AsRecoveryVirtualNetworkCustomDetails() (*RecoveryVirtualNetworkCustomDetails, bool) {
	return nil, false
}

// AsBasicRecoveryVirtualNetworkCustomDetails is the BasicRecoveryVirtualNetworkCustomDetails implementation for ExistingRecoveryVirtualNetwork.
func (ervn ExistingRecoveryVirtualNetwork) AsBasicRecoveryVirtualNetworkCustomDetails() (BasicRecoveryVirtualNetworkCustomDetails, bool) {
	return &ervn, true
}

// ExistingStorageAccount existing storage account input.
type ExistingStorageAccount struct {
	// AzureStorageAccountID - The storage account Arm Id. Throw error, if resource does not exists.
	AzureStorageAccountID *string `json:"azureStorageAccountId,omitempty"`
	// ResourceType - Possible values include: 'ResourceTypeBasicStorageAccountCustomDetailsResourceTypeStorageAccountCustomDetails', 'ResourceTypeBasicStorageAccountCustomDetailsResourceTypeExisting'
	ResourceType ResourceTypeBasicStorageAccountCustomDetails `json:"resourceType,omitempty"`
}

// MarshalJSON is the custom marshaler for ExistingStorageAccount.
func (esa ExistingStorageAccount) MarshalJSON() ([]byte, error) {
	esa.ResourceType = ResourceTypeBasicStorageAccountCustomDetailsResourceTypeExisting
	objectMap := make(map[string]interface{})
	if esa.AzureStorageAccountID != nil {
		objectMap["azureStorageAccountId"] = esa.AzureStorageAccountID
	}
	if esa.ResourceType != "" {
		objectMap["resourceType"] = esa.ResourceType
	}
	return json.Marshal(objectMap)
}

// AsExistingStorageAccount is the BasicStorageAccountCustomDetails implementation for ExistingStorageAccount.
func (esa ExistingStorageAccount) AsExistingStorageAccount() (*ExistingStorageAccount, bool) {
	return &esa, true
}

// AsStorageAccountCustomDetails is the BasicStorageAccountCustomDetails implementation for ExistingStorageAccount.
func (esa ExistingStorageAccount) AsStorageAccountCustomDetails() (*StorageAccountCustomDetails, bool) {
	return nil, false
}

// AsBasicStorageAccountCustomDetails is the BasicStorageAccountCustomDetails implementation for ExistingStorageAccount.
func (esa ExistingStorageAccount) AsBasicStorageAccountCustomDetails() (BasicStorageAccountCustomDetails, bool) {
	return &esa, true
}

// ExportJobDetails this class represents details for export jobs workflow.
type ExportJobDetails struct {
	// BlobURI - BlobUri of the exported jobs.
	BlobURI *string `json:"blobUri,omitempty"`
	// SasToken - The sas token to access blob.
	SasToken *string `json:"sasToken,omitempty"`
	// AffectedObjectDetails - The affected object properties like source server, source cloud, target server, target cloud etc. based on the workflow object details.
	AffectedObjectDetails map[string]*string `json:"affectedObjectDetails"`
	// InstanceType - Possible values include: 'InstanceTypeJobDetails', 'InstanceTypeAsrJobDetails', 'InstanceTypeExportJobDetails', 'InstanceTypeFailoverJobDetails', 'InstanceTypeSwitchProtectionJobDetails', 'InstanceTypeTestFailoverJobDetails'
	InstanceType InstanceTypeBasicJobDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for ExportJobDetails.
func (ejd ExportJobDetails) MarshalJSON() ([]byte, error) {
	ejd.InstanceType = InstanceTypeExportJobDetails
	objectMap := make(map[string]interface{})
	if ejd.BlobURI != nil {
		objectMap["blobUri"] = ejd.BlobURI
	}
	if ejd.SasToken != nil {
		objectMap["sasToken"] = ejd.SasToken
	}
	if ejd.AffectedObjectDetails != nil {
		objectMap["affectedObjectDetails"] = ejd.AffectedObjectDetails
	}
	if ejd.InstanceType != "" {
		objectMap["instanceType"] = ejd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAsrJobDetails is the BasicJobDetails implementation for ExportJobDetails.
func (ejd ExportJobDetails) AsAsrJobDetails() (*AsrJobDetails, bool) {
	return nil, false
}

// AsExportJobDetails is the BasicJobDetails implementation for ExportJobDetails.
func (ejd ExportJobDetails) AsExportJobDetails() (*ExportJobDetails, bool) {
	return &ejd, true
}

// AsFailoverJobDetails is the BasicJobDetails implementation for ExportJobDetails.
func (ejd ExportJobDetails) AsFailoverJobDetails() (*FailoverJobDetails, bool) {
	return nil, false
}

// AsSwitchProtectionJobDetails is the BasicJobDetails implementation for ExportJobDetails.
func (ejd ExportJobDetails) AsSwitchProtectionJobDetails() (*SwitchProtectionJobDetails, bool) {
	return nil, false
}

// AsTestFailoverJobDetails is the BasicJobDetails implementation for ExportJobDetails.
func (ejd ExportJobDetails) AsTestFailoverJobDetails() (*TestFailoverJobDetails, bool) {
	return nil, false
}

// AsJobDetails is the BasicJobDetails implementation for ExportJobDetails.
func (ejd ExportJobDetails) AsJobDetails() (*JobDetails, bool) {
	return nil, false
}

// AsBasicJobDetails is the BasicJobDetails implementation for ExportJobDetails.
func (ejd ExportJobDetails) AsBasicJobDetails() (BasicJobDetails, bool) {
	return &ejd, true
}

// Fabric fabric definition.
type Fabric struct {
	autorest.Response `json:"-"`
	// Properties - Fabric related data.
	Properties *FabricProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource Type
	Type *string `json:"type,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for Fabric.
func (f Fabric) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if f.Properties != nil {
		objectMap["properties"] = f.Properties
	}
	if f.Location != nil {
		objectMap["location"] = f.Location
	}
	return json.Marshal(objectMap)
}

// FabricCollection collection of fabric details.
type FabricCollection struct {
	autorest.Response `json:"-"`
	// Value - The fabric details.
	Value *[]Fabric `json:"value,omitempty"`
	// NextLink - The value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// FabricCollectionIterator provides access to a complete listing of Fabric values.
type FabricCollectionIterator struct {
	i    int
	page FabricCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *FabricCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FabricCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *FabricCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter FabricCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter FabricCollectionIterator) Response() FabricCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter FabricCollectionIterator) Value() Fabric {
	if !iter.page.NotDone() {
		return Fabric{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the FabricCollectionIterator type.
func NewFabricCollectionIterator(page FabricCollectionPage) FabricCollectionIterator {
	return FabricCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (fc FabricCollection) IsEmpty() bool {
	return fc.Value == nil || len(*fc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (fc FabricCollection) hasNextLink() bool {
	return fc.NextLink != nil && len(*fc.NextLink) != 0
}

// fabricCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (fc FabricCollection) fabricCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !fc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(fc.NextLink)))
}

// FabricCollectionPage contains a page of Fabric values.
type FabricCollectionPage struct {
	fn func(context.Context, FabricCollection) (FabricCollection, error)
	fc FabricCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *FabricCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FabricCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.fc)
		if err != nil {
			return err
		}
		page.fc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *FabricCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page FabricCollectionPage) NotDone() bool {
	return !page.fc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page FabricCollectionPage) Response() FabricCollection {
	return page.fc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page FabricCollectionPage) Values() []Fabric {
	if page.fc.IsEmpty() {
		return nil
	}
	return *page.fc.Value
}

// Creates a new instance of the FabricCollectionPage type.
func NewFabricCollectionPage(cur FabricCollection, getNextPage func(context.Context, FabricCollection) (FabricCollection, error)) FabricCollectionPage {
	return FabricCollectionPage{
		fn: getNextPage,
		fc: cur,
	}
}

// FabricCreationInput site details provided during the time of site creation
type FabricCreationInput struct {
	// Properties - Fabric creation input.
	Properties *FabricCreationInputProperties `json:"properties,omitempty"`
}

// FabricCreationInputProperties properties of site details provided during the time of site creation
type FabricCreationInputProperties struct {
	// CustomDetails - Fabric provider specific creation input.
	CustomDetails BasicFabricSpecificCreationInput `json:"customDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for FabricCreationInputProperties struct.
func (fcip *FabricCreationInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "customDetails":
			if v != nil {
				customDetails, err := unmarshalBasicFabricSpecificCreationInput(*v)
				if err != nil {
					return err
				}
				fcip.CustomDetails = customDetails
			}
		}
	}

	return nil
}

// FabricProperties fabric properties.
type FabricProperties struct {
	// FriendlyName - Friendly name of the fabric.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// EncryptionDetails - Encryption details for the fabric.
	EncryptionDetails *EncryptionDetails `json:"encryptionDetails,omitempty"`
	// RolloverEncryptionDetails - Rollover encryption details for the fabric.
	RolloverEncryptionDetails *EncryptionDetails `json:"rolloverEncryptionDetails,omitempty"`
	// InternalIdentifier - Dra Registration Id.
	InternalIdentifier *string `json:"internalIdentifier,omitempty"`
	// BcdrState - BCDR state of the fabric.
	BcdrState *string `json:"bcdrState,omitempty"`
	// CustomDetails - Fabric specific settings.
	CustomDetails BasicFabricSpecificDetails `json:"customDetails,omitempty"`
	// HealthErrorDetails - Fabric health error details.
	HealthErrorDetails *[]HealthError `json:"healthErrorDetails,omitempty"`
	// Health - Health of fabric.
	Health *string `json:"health,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for FabricProperties struct.
func (fp *FabricProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "friendlyName":
			if v != nil {
				var friendlyName string
				err = json.Unmarshal(*v, &friendlyName)
				if err != nil {
					return err
				}
				fp.FriendlyName = &friendlyName
			}
		case "encryptionDetails":
			if v != nil {
				var encryptionDetails EncryptionDetails
				err = json.Unmarshal(*v, &encryptionDetails)
				if err != nil {
					return err
				}
				fp.EncryptionDetails = &encryptionDetails
			}
		case "rolloverEncryptionDetails":
			if v != nil {
				var rolloverEncryptionDetails EncryptionDetails
				err = json.Unmarshal(*v, &rolloverEncryptionDetails)
				if err != nil {
					return err
				}
				fp.RolloverEncryptionDetails = &rolloverEncryptionDetails
			}
		case "internalIdentifier":
			if v != nil {
				var internalIdentifier string
				err = json.Unmarshal(*v, &internalIdentifier)
				if err != nil {
					return err
				}
				fp.InternalIdentifier = &internalIdentifier
			}
		case "bcdrState":
			if v != nil {
				var bcdrState string
				err = json.Unmarshal(*v, &bcdrState)
				if err != nil {
					return err
				}
				fp.BcdrState = &bcdrState
			}
		case "customDetails":
			if v != nil {
				customDetails, err := unmarshalBasicFabricSpecificDetails(*v)
				if err != nil {
					return err
				}
				fp.CustomDetails = customDetails
			}
		case "healthErrorDetails":
			if v != nil {
				var healthErrorDetails []HealthError
				err = json.Unmarshal(*v, &healthErrorDetails)
				if err != nil {
					return err
				}
				fp.HealthErrorDetails = &healthErrorDetails
			}
		case "health":
			if v != nil {
				var health string
				err = json.Unmarshal(*v, &health)
				if err != nil {
					return err
				}
				fp.Health = &health
			}
		}
	}

	return nil
}

// FabricReplicationGroupTaskDetails this class represents the fabric replication group task details.
type FabricReplicationGroupTaskDetails struct {
	// SkippedReason - The skipped reason.
	SkippedReason *string `json:"skippedReason,omitempty"`
	// SkippedReasonString - The skipped reason string.
	SkippedReasonString *string `json:"skippedReasonString,omitempty"`
	// JobTask - The job entity.
	JobTask *JobEntity `json:"jobTask,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeTaskTypeDetails', 'InstanceTypeAutomationRunbookTaskDetails', 'InstanceTypeConsistencyCheckTaskDetails', 'InstanceTypeFabricReplicationGroupTaskDetails', 'InstanceTypeJobTaskDetails', 'InstanceTypeManualActionTaskDetails', 'InstanceTypeScriptActionTaskDetails', 'InstanceTypeVirtualMachineTaskDetails', 'InstanceTypeVMNicUpdatesTaskDetails'
	InstanceType InstanceTypeBasicTaskTypeDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for FabricReplicationGroupTaskDetails.
func (frgtd FabricReplicationGroupTaskDetails) MarshalJSON() ([]byte, error) {
	frgtd.InstanceType = InstanceTypeFabricReplicationGroupTaskDetails
	objectMap := make(map[string]interface{})
	if frgtd.SkippedReason != nil {
		objectMap["skippedReason"] = frgtd.SkippedReason
	}
	if frgtd.SkippedReasonString != nil {
		objectMap["skippedReasonString"] = frgtd.SkippedReasonString
	}
	if frgtd.JobTask != nil {
		objectMap["jobTask"] = frgtd.JobTask
	}
	if frgtd.InstanceType != "" {
		objectMap["instanceType"] = frgtd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAutomationRunbookTaskDetails is the BasicTaskTypeDetails implementation for FabricReplicationGroupTaskDetails.
func (frgtd FabricReplicationGroupTaskDetails) AsAutomationRunbookTaskDetails() (*AutomationRunbookTaskDetails, bool) {
	return nil, false
}

// AsConsistencyCheckTaskDetails is the BasicTaskTypeDetails implementation for FabricReplicationGroupTaskDetails.
func (frgtd FabricReplicationGroupTaskDetails) AsConsistencyCheckTaskDetails() (*ConsistencyCheckTaskDetails, bool) {
	return nil, false
}

// AsFabricReplicationGroupTaskDetails is the BasicTaskTypeDetails implementation for FabricReplicationGroupTaskDetails.
func (frgtd FabricReplicationGroupTaskDetails) AsFabricReplicationGroupTaskDetails() (*FabricReplicationGroupTaskDetails, bool) {
	return &frgtd, true
}

// AsJobTaskDetails is the BasicTaskTypeDetails implementation for FabricReplicationGroupTaskDetails.
func (frgtd FabricReplicationGroupTaskDetails) AsJobTaskDetails() (*JobTaskDetails, bool) {
	return nil, false
}

// AsManualActionTaskDetails is the BasicTaskTypeDetails implementation for FabricReplicationGroupTaskDetails.
func (frgtd FabricReplicationGroupTaskDetails) AsManualActionTaskDetails() (*ManualActionTaskDetails, bool) {
	return nil, false
}

// AsScriptActionTaskDetails is the BasicTaskTypeDetails implementation for FabricReplicationGroupTaskDetails.
func (frgtd FabricReplicationGroupTaskDetails) AsScriptActionTaskDetails() (*ScriptActionTaskDetails, bool) {
	return nil, false
}

// AsVirtualMachineTaskDetails is the BasicTaskTypeDetails implementation for FabricReplicationGroupTaskDetails.
func (frgtd FabricReplicationGroupTaskDetails) AsVirtualMachineTaskDetails() (*VirtualMachineTaskDetails, bool) {
	return nil, false
}

// AsVMNicUpdatesTaskDetails is the BasicTaskTypeDetails implementation for FabricReplicationGroupTaskDetails.
func (frgtd FabricReplicationGroupTaskDetails) AsVMNicUpdatesTaskDetails() (*VMNicUpdatesTaskDetails, bool) {
	return nil, false
}

// AsTaskTypeDetails is the BasicTaskTypeDetails implementation for FabricReplicationGroupTaskDetails.
func (frgtd FabricReplicationGroupTaskDetails) AsTaskTypeDetails() (*TaskTypeDetails, bool) {
	return nil, false
}

// AsBasicTaskTypeDetails is the BasicTaskTypeDetails implementation for FabricReplicationGroupTaskDetails.
func (frgtd FabricReplicationGroupTaskDetails) AsBasicTaskTypeDetails() (BasicTaskTypeDetails, bool) {
	return &frgtd, true
}

// BasicFabricSpecificCreateNetworkMappingInput input details specific to fabrics during Network Mapping.
type BasicFabricSpecificCreateNetworkMappingInput interface {
	AsAzureToAzureCreateNetworkMappingInput() (*AzureToAzureCreateNetworkMappingInput, bool)
	AsVmmToAzureCreateNetworkMappingInput() (*VmmToAzureCreateNetworkMappingInput, bool)
	AsVmmToVmmCreateNetworkMappingInput() (*VmmToVmmCreateNetworkMappingInput, bool)
	AsFabricSpecificCreateNetworkMappingInput() (*FabricSpecificCreateNetworkMappingInput, bool)
}

// FabricSpecificCreateNetworkMappingInput input details specific to fabrics during Network Mapping.
type FabricSpecificCreateNetworkMappingInput struct {
	// InstanceType - Possible values include: 'InstanceTypeFabricSpecificCreateNetworkMappingInput', 'InstanceTypeAzureToAzure', 'InstanceTypeVmmToAzure', 'InstanceTypeVmmToVmm'
	InstanceType InstanceTypeBasicFabricSpecificCreateNetworkMappingInput `json:"instanceType,omitempty"`
}

func unmarshalBasicFabricSpecificCreateNetworkMappingInput(body []byte) (BasicFabricSpecificCreateNetworkMappingInput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeAzureToAzure):
		var atacnmi AzureToAzureCreateNetworkMappingInput
		err := json.Unmarshal(body, &atacnmi)
		return atacnmi, err
	case string(InstanceTypeVmmToAzure):
		var vtacnmi VmmToAzureCreateNetworkMappingInput
		err := json.Unmarshal(body, &vtacnmi)
		return vtacnmi, err
	case string(InstanceTypeVmmToVmm):
		var vtvcnmi VmmToVmmCreateNetworkMappingInput
		err := json.Unmarshal(body, &vtvcnmi)
		return vtvcnmi, err
	default:
		var fscnmi FabricSpecificCreateNetworkMappingInput
		err := json.Unmarshal(body, &fscnmi)
		return fscnmi, err
	}
}
func unmarshalBasicFabricSpecificCreateNetworkMappingInputArray(body []byte) ([]BasicFabricSpecificCreateNetworkMappingInput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	fscnmiArray := make([]BasicFabricSpecificCreateNetworkMappingInput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		fscnmi, err := unmarshalBasicFabricSpecificCreateNetworkMappingInput(*rawMessage)
		if err != nil {
			return nil, err
		}
		fscnmiArray[index] = fscnmi
	}
	return fscnmiArray, nil
}

// MarshalJSON is the custom marshaler for FabricSpecificCreateNetworkMappingInput.
func (fscnmi FabricSpecificCreateNetworkMappingInput) MarshalJSON() ([]byte, error) {
	fscnmi.InstanceType = InstanceTypeFabricSpecificCreateNetworkMappingInput
	objectMap := make(map[string]interface{})
	if fscnmi.InstanceType != "" {
		objectMap["instanceType"] = fscnmi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAzureToAzureCreateNetworkMappingInput is the BasicFabricSpecificCreateNetworkMappingInput implementation for FabricSpecificCreateNetworkMappingInput.
func (fscnmi FabricSpecificCreateNetworkMappingInput) AsAzureToAzureCreateNetworkMappingInput() (*AzureToAzureCreateNetworkMappingInput, bool) {
	return nil, false
}

// AsVmmToAzureCreateNetworkMappingInput is the BasicFabricSpecificCreateNetworkMappingInput implementation for FabricSpecificCreateNetworkMappingInput.
func (fscnmi FabricSpecificCreateNetworkMappingInput) AsVmmToAzureCreateNetworkMappingInput() (*VmmToAzureCreateNetworkMappingInput, bool) {
	return nil, false
}

// AsVmmToVmmCreateNetworkMappingInput is the BasicFabricSpecificCreateNetworkMappingInput implementation for FabricSpecificCreateNetworkMappingInput.
func (fscnmi FabricSpecificCreateNetworkMappingInput) AsVmmToVmmCreateNetworkMappingInput() (*VmmToVmmCreateNetworkMappingInput, bool) {
	return nil, false
}

// AsFabricSpecificCreateNetworkMappingInput is the BasicFabricSpecificCreateNetworkMappingInput implementation for FabricSpecificCreateNetworkMappingInput.
func (fscnmi FabricSpecificCreateNetworkMappingInput) AsFabricSpecificCreateNetworkMappingInput() (*FabricSpecificCreateNetworkMappingInput, bool) {
	return &fscnmi, true
}

// AsBasicFabricSpecificCreateNetworkMappingInput is the BasicFabricSpecificCreateNetworkMappingInput implementation for FabricSpecificCreateNetworkMappingInput.
func (fscnmi FabricSpecificCreateNetworkMappingInput) AsBasicFabricSpecificCreateNetworkMappingInput() (BasicFabricSpecificCreateNetworkMappingInput, bool) {
	return &fscnmi, true
}

// BasicFabricSpecificCreationInput fabric provider specific settings.
type BasicFabricSpecificCreationInput interface {
	AsAzureFabricCreationInput() (*AzureFabricCreationInput, bool)
	AsInMageRcmFabricCreationInput() (*InMageRcmFabricCreationInput, bool)
	AsVMwareV2FabricCreationInput() (*VMwareV2FabricCreationInput, bool)
	AsFabricSpecificCreationInput() (*FabricSpecificCreationInput, bool)
}

// FabricSpecificCreationInput fabric provider specific settings.
type FabricSpecificCreationInput struct {
	// InstanceType - Possible values include: 'InstanceTypeFabricSpecificCreationInput', 'InstanceTypeAzure', 'InstanceTypeInMageRcm', 'InstanceTypeVMwareV2'
	InstanceType InstanceTypeBasicFabricSpecificCreationInput `json:"instanceType,omitempty"`
}

func unmarshalBasicFabricSpecificCreationInput(body []byte) (BasicFabricSpecificCreationInput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeAzure):
		var afci AzureFabricCreationInput
		err := json.Unmarshal(body, &afci)
		return afci, err
	case string(InstanceTypeInMageRcm):
		var imrfci InMageRcmFabricCreationInput
		err := json.Unmarshal(body, &imrfci)
		return imrfci, err
	case string(InstanceTypeVMwareV2):
		var vmvfci VMwareV2FabricCreationInput
		err := json.Unmarshal(body, &vmvfci)
		return vmvfci, err
	default:
		var fsci FabricSpecificCreationInput
		err := json.Unmarshal(body, &fsci)
		return fsci, err
	}
}
func unmarshalBasicFabricSpecificCreationInputArray(body []byte) ([]BasicFabricSpecificCreationInput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	fsciArray := make([]BasicFabricSpecificCreationInput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		fsci, err := unmarshalBasicFabricSpecificCreationInput(*rawMessage)
		if err != nil {
			return nil, err
		}
		fsciArray[index] = fsci
	}
	return fsciArray, nil
}

// MarshalJSON is the custom marshaler for FabricSpecificCreationInput.
func (fsci FabricSpecificCreationInput) MarshalJSON() ([]byte, error) {
	fsci.InstanceType = InstanceTypeFabricSpecificCreationInput
	objectMap := make(map[string]interface{})
	if fsci.InstanceType != "" {
		objectMap["instanceType"] = fsci.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAzureFabricCreationInput is the BasicFabricSpecificCreationInput implementation for FabricSpecificCreationInput.
func (fsci FabricSpecificCreationInput) AsAzureFabricCreationInput() (*AzureFabricCreationInput, bool) {
	return nil, false
}

// AsInMageRcmFabricCreationInput is the BasicFabricSpecificCreationInput implementation for FabricSpecificCreationInput.
func (fsci FabricSpecificCreationInput) AsInMageRcmFabricCreationInput() (*InMageRcmFabricCreationInput, bool) {
	return nil, false
}

// AsVMwareV2FabricCreationInput is the BasicFabricSpecificCreationInput implementation for FabricSpecificCreationInput.
func (fsci FabricSpecificCreationInput) AsVMwareV2FabricCreationInput() (*VMwareV2FabricCreationInput, bool) {
	return nil, false
}

// AsFabricSpecificCreationInput is the BasicFabricSpecificCreationInput implementation for FabricSpecificCreationInput.
func (fsci FabricSpecificCreationInput) AsFabricSpecificCreationInput() (*FabricSpecificCreationInput, bool) {
	return &fsci, true
}

// AsBasicFabricSpecificCreationInput is the BasicFabricSpecificCreationInput implementation for FabricSpecificCreationInput.
func (fsci FabricSpecificCreationInput) AsBasicFabricSpecificCreationInput() (BasicFabricSpecificCreationInput, bool) {
	return &fsci, true
}

// BasicFabricSpecificDetails fabric specific details.
type BasicFabricSpecificDetails interface {
	AsAzureFabricSpecificDetails() (*AzureFabricSpecificDetails, bool)
	AsHyperVSiteDetails() (*HyperVSiteDetails, bool)
	AsInMageRcmFabricSpecificDetails() (*InMageRcmFabricSpecificDetails, bool)
	AsVmmDetails() (*VmmDetails, bool)
	AsVMwareDetails() (*VMwareDetails, bool)
	AsVMwareV2FabricSpecificDetails() (*VMwareV2FabricSpecificDetails, bool)
	AsFabricSpecificDetails() (*FabricSpecificDetails, bool)
}

// FabricSpecificDetails fabric specific details.
type FabricSpecificDetails struct {
	// InstanceType - Possible values include: 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeFabricSpecificDetails', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeAzure', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeHyperVSite', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeInMageRcm', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMM', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMware', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMwareV2'
	InstanceType InstanceTypeBasicFabricSpecificDetails `json:"instanceType,omitempty"`
}

func unmarshalBasicFabricSpecificDetails(body []byte) (BasicFabricSpecificDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeBasicFabricSpecificDetailsInstanceTypeAzure):
		var afsd AzureFabricSpecificDetails
		err := json.Unmarshal(body, &afsd)
		return afsd, err
	case string(InstanceTypeBasicFabricSpecificDetailsInstanceTypeHyperVSite):
		var hvsd HyperVSiteDetails
		err := json.Unmarshal(body, &hvsd)
		return hvsd, err
	case string(InstanceTypeBasicFabricSpecificDetailsInstanceTypeInMageRcm):
		var imrfsd InMageRcmFabricSpecificDetails
		err := json.Unmarshal(body, &imrfsd)
		return imrfsd, err
	case string(InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMM):
		var vd VmmDetails
		err := json.Unmarshal(body, &vd)
		return vd, err
	case string(InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMware):
		var vmd VMwareDetails
		err := json.Unmarshal(body, &vmd)
		return vmd, err
	case string(InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMwareV2):
		var vmvfsd VMwareV2FabricSpecificDetails
		err := json.Unmarshal(body, &vmvfsd)
		return vmvfsd, err
	default:
		var fsd FabricSpecificDetails
		err := json.Unmarshal(body, &fsd)
		return fsd, err
	}
}
func unmarshalBasicFabricSpecificDetailsArray(body []byte) ([]BasicFabricSpecificDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	fsdArray := make([]BasicFabricSpecificDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		fsd, err := unmarshalBasicFabricSpecificDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		fsdArray[index] = fsd
	}
	return fsdArray, nil
}

// MarshalJSON is the custom marshaler for FabricSpecificDetails.
func (fsd FabricSpecificDetails) MarshalJSON() ([]byte, error) {
	fsd.InstanceType = InstanceTypeBasicFabricSpecificDetailsInstanceTypeFabricSpecificDetails
	objectMap := make(map[string]interface{})
	if fsd.InstanceType != "" {
		objectMap["instanceType"] = fsd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAzureFabricSpecificDetails is the BasicFabricSpecificDetails implementation for FabricSpecificDetails.
func (fsd FabricSpecificDetails) AsAzureFabricSpecificDetails() (*AzureFabricSpecificDetails, bool) {
	return nil, false
}

// AsHyperVSiteDetails is the BasicFabricSpecificDetails implementation for FabricSpecificDetails.
func (fsd FabricSpecificDetails) AsHyperVSiteDetails() (*HyperVSiteDetails, bool) {
	return nil, false
}

// AsInMageRcmFabricSpecificDetails is the BasicFabricSpecificDetails implementation for FabricSpecificDetails.
func (fsd FabricSpecificDetails) AsInMageRcmFabricSpecificDetails() (*InMageRcmFabricSpecificDetails, bool) {
	return nil, false
}

// AsVmmDetails is the BasicFabricSpecificDetails implementation for FabricSpecificDetails.
func (fsd FabricSpecificDetails) AsVmmDetails() (*VmmDetails, bool) {
	return nil, false
}

// AsVMwareDetails is the BasicFabricSpecificDetails implementation for FabricSpecificDetails.
func (fsd FabricSpecificDetails) AsVMwareDetails() (*VMwareDetails, bool) {
	return nil, false
}

// AsVMwareV2FabricSpecificDetails is the BasicFabricSpecificDetails implementation for FabricSpecificDetails.
func (fsd FabricSpecificDetails) AsVMwareV2FabricSpecificDetails() (*VMwareV2FabricSpecificDetails, bool) {
	return nil, false
}

// AsFabricSpecificDetails is the BasicFabricSpecificDetails implementation for FabricSpecificDetails.
func (fsd FabricSpecificDetails) AsFabricSpecificDetails() (*FabricSpecificDetails, bool) {
	return &fsd, true
}

// AsBasicFabricSpecificDetails is the BasicFabricSpecificDetails implementation for FabricSpecificDetails.
func (fsd FabricSpecificDetails) AsBasicFabricSpecificDetails() (BasicFabricSpecificDetails, bool) {
	return &fsd, true
}

// BasicFabricSpecificUpdateNetworkMappingInput input details specific to fabrics during Network Mapping.
type BasicFabricSpecificUpdateNetworkMappingInput interface {
	AsAzureToAzureUpdateNetworkMappingInput() (*AzureToAzureUpdateNetworkMappingInput, bool)
	AsVmmToAzureUpdateNetworkMappingInput() (*VmmToAzureUpdateNetworkMappingInput, bool)
	AsVmmToVmmUpdateNetworkMappingInput() (*VmmToVmmUpdateNetworkMappingInput, bool)
	AsFabricSpecificUpdateNetworkMappingInput() (*FabricSpecificUpdateNetworkMappingInput, bool)
}

// FabricSpecificUpdateNetworkMappingInput input details specific to fabrics during Network Mapping.
type FabricSpecificUpdateNetworkMappingInput struct {
	// InstanceType - Possible values include: 'InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeFabricSpecificUpdateNetworkMappingInput', 'InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeAzureToAzure', 'InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToAzure', 'InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToVmm'
	InstanceType InstanceTypeBasicFabricSpecificUpdateNetworkMappingInput `json:"instanceType,omitempty"`
}

func unmarshalBasicFabricSpecificUpdateNetworkMappingInput(body []byte) (BasicFabricSpecificUpdateNetworkMappingInput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeAzureToAzure):
		var ataunmi AzureToAzureUpdateNetworkMappingInput
		err := json.Unmarshal(body, &ataunmi)
		return ataunmi, err
	case string(InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToAzure):
		var vtaunmi VmmToAzureUpdateNetworkMappingInput
		err := json.Unmarshal(body, &vtaunmi)
		return vtaunmi, err
	case string(InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToVmm):
		var vtvunmi VmmToVmmUpdateNetworkMappingInput
		err := json.Unmarshal(body, &vtvunmi)
		return vtvunmi, err
	default:
		var fsunmi FabricSpecificUpdateNetworkMappingInput
		err := json.Unmarshal(body, &fsunmi)
		return fsunmi, err
	}
}
func unmarshalBasicFabricSpecificUpdateNetworkMappingInputArray(body []byte) ([]BasicFabricSpecificUpdateNetworkMappingInput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	fsunmiArray := make([]BasicFabricSpecificUpdateNetworkMappingInput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		fsunmi, err := unmarshalBasicFabricSpecificUpdateNetworkMappingInput(*rawMessage)
		if err != nil {
			return nil, err
		}
		fsunmiArray[index] = fsunmi
	}
	return fsunmiArray, nil
}

// MarshalJSON is the custom marshaler for FabricSpecificUpdateNetworkMappingInput.
func (fsunmi FabricSpecificUpdateNetworkMappingInput) MarshalJSON() ([]byte, error) {
	fsunmi.InstanceType = InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeFabricSpecificUpdateNetworkMappingInput
	objectMap := make(map[string]interface{})
	if fsunmi.InstanceType != "" {
		objectMap["instanceType"] = fsunmi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAzureToAzureUpdateNetworkMappingInput is the BasicFabricSpecificUpdateNetworkMappingInput implementation for FabricSpecificUpdateNetworkMappingInput.
func (fsunmi FabricSpecificUpdateNetworkMappingInput) AsAzureToAzureUpdateNetworkMappingInput() (*AzureToAzureUpdateNetworkMappingInput, bool) {
	return nil, false
}

// AsVmmToAzureUpdateNetworkMappingInput is the BasicFabricSpecificUpdateNetworkMappingInput implementation for FabricSpecificUpdateNetworkMappingInput.
func (fsunmi FabricSpecificUpdateNetworkMappingInput) AsVmmToAzureUpdateNetworkMappingInput() (*VmmToAzureUpdateNetworkMappingInput, bool) {
	return nil, false
}

// AsVmmToVmmUpdateNetworkMappingInput is the BasicFabricSpecificUpdateNetworkMappingInput implementation for FabricSpecificUpdateNetworkMappingInput.
func (fsunmi FabricSpecificUpdateNetworkMappingInput) AsVmmToVmmUpdateNetworkMappingInput() (*VmmToVmmUpdateNetworkMappingInput, bool) {
	return nil, false
}

// AsFabricSpecificUpdateNetworkMappingInput is the BasicFabricSpecificUpdateNetworkMappingInput implementation for FabricSpecificUpdateNetworkMappingInput.
func (fsunmi FabricSpecificUpdateNetworkMappingInput) AsFabricSpecificUpdateNetworkMappingInput() (*FabricSpecificUpdateNetworkMappingInput, bool) {
	return &fsunmi, true
}

// AsBasicFabricSpecificUpdateNetworkMappingInput is the BasicFabricSpecificUpdateNetworkMappingInput implementation for FabricSpecificUpdateNetworkMappingInput.
func (fsunmi FabricSpecificUpdateNetworkMappingInput) AsBasicFabricSpecificUpdateNetworkMappingInput() (BasicFabricSpecificUpdateNetworkMappingInput, bool) {
	return &fsunmi, true
}

// FailoverJobDetails this class represents the details for a failover job.
type FailoverJobDetails struct {
	// ProtectedItemDetails - The test VM details.
	ProtectedItemDetails *[]FailoverReplicationProtectedItemDetails `json:"protectedItemDetails,omitempty"`
	// AffectedObjectDetails - The affected object properties like source server, source cloud, target server, target cloud etc. based on the workflow object details.
	AffectedObjectDetails map[string]*string `json:"affectedObjectDetails"`
	// InstanceType - Possible values include: 'InstanceTypeJobDetails', 'InstanceTypeAsrJobDetails', 'InstanceTypeExportJobDetails', 'InstanceTypeFailoverJobDetails', 'InstanceTypeSwitchProtectionJobDetails', 'InstanceTypeTestFailoverJobDetails'
	InstanceType InstanceTypeBasicJobDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for FailoverJobDetails.
func (fjd FailoverJobDetails) MarshalJSON() ([]byte, error) {
	fjd.InstanceType = InstanceTypeFailoverJobDetails
	objectMap := make(map[string]interface{})
	if fjd.ProtectedItemDetails != nil {
		objectMap["protectedItemDetails"] = fjd.ProtectedItemDetails
	}
	if fjd.AffectedObjectDetails != nil {
		objectMap["affectedObjectDetails"] = fjd.AffectedObjectDetails
	}
	if fjd.InstanceType != "" {
		objectMap["instanceType"] = fjd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAsrJobDetails is the BasicJobDetails implementation for FailoverJobDetails.
func (fjd FailoverJobDetails) AsAsrJobDetails() (*AsrJobDetails, bool) {
	return nil, false
}

// AsExportJobDetails is the BasicJobDetails implementation for FailoverJobDetails.
func (fjd FailoverJobDetails) AsExportJobDetails() (*ExportJobDetails, bool) {
	return nil, false
}

// AsFailoverJobDetails is the BasicJobDetails implementation for FailoverJobDetails.
func (fjd FailoverJobDetails) AsFailoverJobDetails() (*FailoverJobDetails, bool) {
	return &fjd, true
}

// AsSwitchProtectionJobDetails is the BasicJobDetails implementation for FailoverJobDetails.
func (fjd FailoverJobDetails) AsSwitchProtectionJobDetails() (*SwitchProtectionJobDetails, bool) {
	return nil, false
}

// AsTestFailoverJobDetails is the BasicJobDetails implementation for FailoverJobDetails.
func (fjd FailoverJobDetails) AsTestFailoverJobDetails() (*TestFailoverJobDetails, bool) {
	return nil, false
}

// AsJobDetails is the BasicJobDetails implementation for FailoverJobDetails.
func (fjd FailoverJobDetails) AsJobDetails() (*JobDetails, bool) {
	return nil, false
}

// AsBasicJobDetails is the BasicJobDetails implementation for FailoverJobDetails.
func (fjd FailoverJobDetails) AsBasicJobDetails() (BasicJobDetails, bool) {
	return &fjd, true
}

// FailoverProcessServerRequest request to failover a process server.
type FailoverProcessServerRequest struct {
	// Properties - The properties of the PS Failover request.
	Properties *FailoverProcessServerRequestProperties `json:"properties,omitempty"`
}

// FailoverProcessServerRequestProperties the properties of the Failover Process Server request.
type FailoverProcessServerRequestProperties struct {
	// ContainerName - The container identifier.
	ContainerName *string `json:"containerName,omitempty"`
	// SourceProcessServerID - The source process server.
	SourceProcessServerID *string `json:"sourceProcessServerId,omitempty"`
	// TargetProcessServerID - The new process server.
	TargetProcessServerID *string `json:"targetProcessServerId,omitempty"`
	// VmsToMigrate - The VMS to migrate.
	VmsToMigrate *[]string `json:"vmsToMigrate,omitempty"`
	// UpdateType - A value for failover type. It can be systemlevel/serverlevel
	UpdateType *string `json:"updateType,omitempty"`
}

// FailoverReplicationProtectedItemDetails failover details for a replication protected item.
type FailoverReplicationProtectedItemDetails struct {
	// Name - The name.
	Name *string `json:"name,omitempty"`
	// FriendlyName - The friendly name.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// TestVMName - The test Vm name.
	TestVMName *string `json:"testVmName,omitempty"`
	// TestVMFriendlyName - The test Vm friendly name.
	TestVMFriendlyName *string `json:"testVmFriendlyName,omitempty"`
	// NetworkConnectionStatus - The network connection status.
	NetworkConnectionStatus *string `json:"networkConnectionStatus,omitempty"`
	// NetworkFriendlyName - The network friendly name.
	NetworkFriendlyName *string `json:"networkFriendlyName,omitempty"`
	// Subnet - The network subnet.
	Subnet *string `json:"subnet,omitempty"`
	// RecoveryPointID - The recovery point Id.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`
	// RecoveryPointTime - The recovery point time.
	RecoveryPointTime *date.Time `json:"recoveryPointTime,omitempty"`
}

// BasicGroupTaskDetails this class represents the group task details when parent child relationship exists in the
// drill down.
type BasicGroupTaskDetails interface {
	AsInlineWorkflowTaskDetails() (*InlineWorkflowTaskDetails, bool)
	AsRecoveryPlanGroupTaskDetails() (*RecoveryPlanGroupTaskDetails, bool)
	AsRecoveryPlanShutdownGroupTaskDetails() (*RecoveryPlanShutdownGroupTaskDetails, bool)
	AsGroupTaskDetails() (*GroupTaskDetails, bool)
}

// GroupTaskDetails this class represents the group task details when parent child relationship exists in the
// drill down.
type GroupTaskDetails struct {
	// ChildTasks - The child tasks.
	ChildTasks *[]ASRTask `json:"childTasks,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeGroupTaskDetails', 'InstanceTypeInlineWorkflowTaskDetails', 'InstanceTypeRecoveryPlanGroupTaskDetails', 'InstanceTypeRecoveryPlanShutdownGroupTaskDetails'
	InstanceType InstanceTypeBasicGroupTaskDetails `json:"instanceType,omitempty"`
}

func unmarshalBasicGroupTaskDetails(body []byte) (BasicGroupTaskDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeInlineWorkflowTaskDetails):
		var iwtd InlineWorkflowTaskDetails
		err := json.Unmarshal(body, &iwtd)
		return iwtd, err
	case string(InstanceTypeRecoveryPlanGroupTaskDetails):
		var rpgtd RecoveryPlanGroupTaskDetails
		err := json.Unmarshal(body, &rpgtd)
		return rpgtd, err
	case string(InstanceTypeRecoveryPlanShutdownGroupTaskDetails):
		var rpsgtd RecoveryPlanShutdownGroupTaskDetails
		err := json.Unmarshal(body, &rpsgtd)
		return rpsgtd, err
	default:
		var gtd GroupTaskDetails
		err := json.Unmarshal(body, &gtd)
		return gtd, err
	}
}
func unmarshalBasicGroupTaskDetailsArray(body []byte) ([]BasicGroupTaskDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	gtdArray := make([]BasicGroupTaskDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		gtd, err := unmarshalBasicGroupTaskDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		gtdArray[index] = gtd
	}
	return gtdArray, nil
}

// MarshalJSON is the custom marshaler for GroupTaskDetails.
func (gtd GroupTaskDetails) MarshalJSON() ([]byte, error) {
	gtd.InstanceType = InstanceTypeGroupTaskDetails
	objectMap := make(map[string]interface{})
	if gtd.ChildTasks != nil {
		objectMap["childTasks"] = gtd.ChildTasks
	}
	if gtd.InstanceType != "" {
		objectMap["instanceType"] = gtd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsInlineWorkflowTaskDetails is the BasicGroupTaskDetails implementation for GroupTaskDetails.
func (gtd GroupTaskDetails) AsInlineWorkflowTaskDetails() (*InlineWorkflowTaskDetails, bool) {
	return nil, false
}

// AsRecoveryPlanGroupTaskDetails is the BasicGroupTaskDetails implementation for GroupTaskDetails.
func (gtd GroupTaskDetails) AsRecoveryPlanGroupTaskDetails() (*RecoveryPlanGroupTaskDetails, bool) {
	return nil, false
}

// AsRecoveryPlanShutdownGroupTaskDetails is the BasicGroupTaskDetails implementation for GroupTaskDetails.
func (gtd GroupTaskDetails) AsRecoveryPlanShutdownGroupTaskDetails() (*RecoveryPlanShutdownGroupTaskDetails, bool) {
	return nil, false
}

// AsGroupTaskDetails is the BasicGroupTaskDetails implementation for GroupTaskDetails.
func (gtd GroupTaskDetails) AsGroupTaskDetails() (*GroupTaskDetails, bool) {
	return &gtd, true
}

// AsBasicGroupTaskDetails is the BasicGroupTaskDetails implementation for GroupTaskDetails.
func (gtd GroupTaskDetails) AsBasicGroupTaskDetails() (BasicGroupTaskDetails, bool) {
	return &gtd, true
}

// HealthError health Error
type HealthError struct {
	// InnerHealthErrors - The inner health errors. HealthError having a list of HealthError as child errors is problematic. InnerHealthError is used because this will prevent an infinite loop of structures when Hydra tries to auto-generate the contract. We are exposing the related health errors as inner health errors and all API consumers can utilize this in the same fashion as Exception -&gt; InnerException.
	InnerHealthErrors *[]InnerHealthError `json:"innerHealthErrors,omitempty"`
	// ErrorSource - Source of error.
	ErrorSource *string `json:"errorSource,omitempty"`
	// ErrorType - Type of error.
	ErrorType *string `json:"errorType,omitempty"`
	// ErrorLevel - Level of error.
	ErrorLevel *string `json:"errorLevel,omitempty"`
	// ErrorCategory - Category of error.
	ErrorCategory *string `json:"errorCategory,omitempty"`
	// ErrorCode - Error code.
	ErrorCode *string `json:"errorCode,omitempty"`
	// SummaryMessage - Summary message of the entity.
	SummaryMessage *string `json:"summaryMessage,omitempty"`
	// ErrorMessage - Error message.
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// PossibleCauses - Possible causes of error.
	PossibleCauses *string `json:"possibleCauses,omitempty"`
	// RecommendedAction - Recommended action to resolve error.
	RecommendedAction *string `json:"recommendedAction,omitempty"`
	// CreationTimeUtc - Error creation time (UTC)
	CreationTimeUtc *date.Time `json:"creationTimeUtc,omitempty"`
	// RecoveryProviderErrorMessage - DRA error message.
	RecoveryProviderErrorMessage *string `json:"recoveryProviderErrorMessage,omitempty"`
	// EntityID - ID of the entity.
	EntityID *string `json:"entityId,omitempty"`
	// ErrorID - The health error unique id.
	ErrorID *string `json:"errorId,omitempty"`
	// CustomerResolvability - Value indicating whether the health error is customer resolvable. Possible values include: 'Allowed', 'NotAllowed'
	CustomerResolvability HealthErrorCustomerResolvability `json:"customerResolvability,omitempty"`
}

// HealthErrorSummary class to define the summary of the health error details.
type HealthErrorSummary struct {
	// SummaryCode - The code of the health error.
	SummaryCode *string `json:"summaryCode,omitempty"`
	// Category - The category of the health error. Possible values include: 'None', 'Replication', 'TestFailover', 'Configuration', 'FabricInfrastructure', 'VersionExpiry', 'AgentAutoUpdate'
	Category HealthErrorCategory `json:"category,omitempty"`
	// Severity - Severity of error. Possible values include: 'NONE', 'Warning', 'Error', 'Info'
	Severity Severity `json:"severity,omitempty"`
	// SummaryMessage - The summary message of the health error.
	SummaryMessage *string `json:"summaryMessage,omitempty"`
	// AffectedResourceType - The type of affected ARM resource.
	AffectedResourceType *string `json:"affectedResourceType,omitempty"`
	// AffectedResourceSubtype - The sub type of any subcomponent within the ARM resource that this might be applicable. Value remains null if not applicable.
	AffectedResourceSubtype *string `json:"affectedResourceSubtype,omitempty"`
	// AffectedResourceCorrelationIds - The list of affected resource correlation Ids. This can be used to uniquely identify the count of items affected by a specific category and severity as well as count of item affected by an specific issue.
	AffectedResourceCorrelationIds *[]string `json:"affectedResourceCorrelationIds,omitempty"`
}

// HyperVReplica2012EventDetails model class for event details of a HyperVReplica E2E event.
type HyperVReplica2012EventDetails struct {
	// ContainerName - The container friendly name.
	ContainerName *string `json:"containerName,omitempty"`
	// FabricName - The fabric friendly name.
	FabricName *string `json:"fabricName,omitempty"`
	// RemoteContainerName - The remote container name.
	RemoteContainerName *string `json:"remoteContainerName,omitempty"`
	// RemoteFabricName - The remote fabric name.
	RemoteFabricName *string `json:"remoteFabricName,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeEventProviderSpecificDetails', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeA2A', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplicaBaseEventDetails', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeInMageAzureV2', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeInMageRcm'
	InstanceType InstanceTypeBasicEventProviderSpecificDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplica2012EventDetails.
func (hvr2ed HyperVReplica2012EventDetails) MarshalJSON() ([]byte, error) {
	hvr2ed.InstanceType = InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplica2012
	objectMap := make(map[string]interface{})
	if hvr2ed.ContainerName != nil {
		objectMap["containerName"] = hvr2ed.ContainerName
	}
	if hvr2ed.FabricName != nil {
		objectMap["fabricName"] = hvr2ed.FabricName
	}
	if hvr2ed.RemoteContainerName != nil {
		objectMap["remoteContainerName"] = hvr2ed.RemoteContainerName
	}
	if hvr2ed.RemoteFabricName != nil {
		objectMap["remoteFabricName"] = hvr2ed.RemoteFabricName
	}
	if hvr2ed.InstanceType != "" {
		objectMap["instanceType"] = hvr2ed.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AEventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplica2012EventDetails.
func (hvr2ed HyperVReplica2012EventDetails) AsA2AEventDetails() (*A2AEventDetails, bool) {
	return nil, false
}

// AsHyperVReplica2012EventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplica2012EventDetails.
func (hvr2ed HyperVReplica2012EventDetails) AsHyperVReplica2012EventDetails() (*HyperVReplica2012EventDetails, bool) {
	return &hvr2ed, true
}

// AsHyperVReplica2012R2EventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplica2012EventDetails.
func (hvr2ed HyperVReplica2012EventDetails) AsHyperVReplica2012R2EventDetails() (*HyperVReplica2012R2EventDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzureEventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplica2012EventDetails.
func (hvr2ed HyperVReplica2012EventDetails) AsHyperVReplicaAzureEventDetails() (*HyperVReplicaAzureEventDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBaseEventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplica2012EventDetails.
func (hvr2ed HyperVReplica2012EventDetails) AsHyperVReplicaBaseEventDetails() (*HyperVReplicaBaseEventDetails, bool) {
	return nil, false
}

// AsInMageAzureV2EventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplica2012EventDetails.
func (hvr2ed HyperVReplica2012EventDetails) AsInMageAzureV2EventDetails() (*InMageAzureV2EventDetails, bool) {
	return nil, false
}

// AsInMageRcmEventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplica2012EventDetails.
func (hvr2ed HyperVReplica2012EventDetails) AsInMageRcmEventDetails() (*InMageRcmEventDetails, bool) {
	return nil, false
}

// AsEventProviderSpecificDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplica2012EventDetails.
func (hvr2ed HyperVReplica2012EventDetails) AsEventProviderSpecificDetails() (*EventProviderSpecificDetails, bool) {
	return nil, false
}

// AsBasicEventProviderSpecificDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplica2012EventDetails.
func (hvr2ed HyperVReplica2012EventDetails) AsBasicEventProviderSpecificDetails() (BasicEventProviderSpecificDetails, bool) {
	return &hvr2ed, true
}

// HyperVReplica2012R2EventDetails model class for event details of a HyperVReplica blue E2E event.
type HyperVReplica2012R2EventDetails struct {
	// ContainerName - The container friendly name.
	ContainerName *string `json:"containerName,omitempty"`
	// FabricName - The fabric friendly name.
	FabricName *string `json:"fabricName,omitempty"`
	// RemoteContainerName - The remote container name.
	RemoteContainerName *string `json:"remoteContainerName,omitempty"`
	// RemoteFabricName - The remote fabric name.
	RemoteFabricName *string `json:"remoteFabricName,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeEventProviderSpecificDetails', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeA2A', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplicaBaseEventDetails', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeInMageAzureV2', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeInMageRcm'
	InstanceType InstanceTypeBasicEventProviderSpecificDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplica2012R2EventDetails.
func (hvr2ed HyperVReplica2012R2EventDetails) MarshalJSON() ([]byte, error) {
	hvr2ed.InstanceType = InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplica2012R2
	objectMap := make(map[string]interface{})
	if hvr2ed.ContainerName != nil {
		objectMap["containerName"] = hvr2ed.ContainerName
	}
	if hvr2ed.FabricName != nil {
		objectMap["fabricName"] = hvr2ed.FabricName
	}
	if hvr2ed.RemoteContainerName != nil {
		objectMap["remoteContainerName"] = hvr2ed.RemoteContainerName
	}
	if hvr2ed.RemoteFabricName != nil {
		objectMap["remoteFabricName"] = hvr2ed.RemoteFabricName
	}
	if hvr2ed.InstanceType != "" {
		objectMap["instanceType"] = hvr2ed.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AEventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplica2012R2EventDetails.
func (hvr2ed HyperVReplica2012R2EventDetails) AsA2AEventDetails() (*A2AEventDetails, bool) {
	return nil, false
}

// AsHyperVReplica2012EventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplica2012R2EventDetails.
func (hvr2ed HyperVReplica2012R2EventDetails) AsHyperVReplica2012EventDetails() (*HyperVReplica2012EventDetails, bool) {
	return nil, false
}

// AsHyperVReplica2012R2EventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplica2012R2EventDetails.
func (hvr2ed HyperVReplica2012R2EventDetails) AsHyperVReplica2012R2EventDetails() (*HyperVReplica2012R2EventDetails, bool) {
	return &hvr2ed, true
}

// AsHyperVReplicaAzureEventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplica2012R2EventDetails.
func (hvr2ed HyperVReplica2012R2EventDetails) AsHyperVReplicaAzureEventDetails() (*HyperVReplicaAzureEventDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBaseEventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplica2012R2EventDetails.
func (hvr2ed HyperVReplica2012R2EventDetails) AsHyperVReplicaBaseEventDetails() (*HyperVReplicaBaseEventDetails, bool) {
	return nil, false
}

// AsInMageAzureV2EventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplica2012R2EventDetails.
func (hvr2ed HyperVReplica2012R2EventDetails) AsInMageAzureV2EventDetails() (*InMageAzureV2EventDetails, bool) {
	return nil, false
}

// AsInMageRcmEventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplica2012R2EventDetails.
func (hvr2ed HyperVReplica2012R2EventDetails) AsInMageRcmEventDetails() (*InMageRcmEventDetails, bool) {
	return nil, false
}

// AsEventProviderSpecificDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplica2012R2EventDetails.
func (hvr2ed HyperVReplica2012R2EventDetails) AsEventProviderSpecificDetails() (*EventProviderSpecificDetails, bool) {
	return nil, false
}

// AsBasicEventProviderSpecificDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplica2012R2EventDetails.
func (hvr2ed HyperVReplica2012R2EventDetails) AsBasicEventProviderSpecificDetails() (BasicEventProviderSpecificDetails, bool) {
	return &hvr2ed, true
}

// HyperVReplicaAzureApplyRecoveryPointInput applyRecoveryPoint input specific to HyperVReplicaAzure
// provider.
type HyperVReplicaAzureApplyRecoveryPointInput struct {
	// VaultLocation - The vault location where the recovery Vm resides.
	VaultLocation *string `json:"vaultLocation,omitempty"`
	// PrimaryKekCertificatePfx - The primary kek certificate pfx.
	PrimaryKekCertificatePfx *string `json:"primaryKekCertificatePfx,omitempty"`
	// SecondaryKekCertificatePfx - The secondary kek certificate pfx.
	SecondaryKekCertificatePfx *string `json:"secondaryKekCertificatePfx,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeApplyRecoveryPointProviderSpecificInput', 'InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeA2A', 'InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeInMageRcm'
	InstanceType InstanceTypeBasicApplyRecoveryPointProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaAzureApplyRecoveryPointInput.
func (hvraarpi HyperVReplicaAzureApplyRecoveryPointInput) MarshalJSON() ([]byte, error) {
	hvraarpi.InstanceType = InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeHyperVReplicaAzure
	objectMap := make(map[string]interface{})
	if hvraarpi.VaultLocation != nil {
		objectMap["vaultLocation"] = hvraarpi.VaultLocation
	}
	if hvraarpi.PrimaryKekCertificatePfx != nil {
		objectMap["primaryKekCertificatePfx"] = hvraarpi.PrimaryKekCertificatePfx
	}
	if hvraarpi.SecondaryKekCertificatePfx != nil {
		objectMap["secondaryKekCertificatePfx"] = hvraarpi.SecondaryKekCertificatePfx
	}
	if hvraarpi.InstanceType != "" {
		objectMap["instanceType"] = hvraarpi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AApplyRecoveryPointInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for HyperVReplicaAzureApplyRecoveryPointInput.
func (hvraarpi HyperVReplicaAzureApplyRecoveryPointInput) AsA2AApplyRecoveryPointInput() (*A2AApplyRecoveryPointInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzureApplyRecoveryPointInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for HyperVReplicaAzureApplyRecoveryPointInput.
func (hvraarpi HyperVReplicaAzureApplyRecoveryPointInput) AsHyperVReplicaAzureApplyRecoveryPointInput() (*HyperVReplicaAzureApplyRecoveryPointInput, bool) {
	return &hvraarpi, true
}

// AsInMageAzureV2ApplyRecoveryPointInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for HyperVReplicaAzureApplyRecoveryPointInput.
func (hvraarpi HyperVReplicaAzureApplyRecoveryPointInput) AsInMageAzureV2ApplyRecoveryPointInput() (*InMageAzureV2ApplyRecoveryPointInput, bool) {
	return nil, false
}

// AsInMageRcmApplyRecoveryPointInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for HyperVReplicaAzureApplyRecoveryPointInput.
func (hvraarpi HyperVReplicaAzureApplyRecoveryPointInput) AsInMageRcmApplyRecoveryPointInput() (*InMageRcmApplyRecoveryPointInput, bool) {
	return nil, false
}

// AsApplyRecoveryPointProviderSpecificInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for HyperVReplicaAzureApplyRecoveryPointInput.
func (hvraarpi HyperVReplicaAzureApplyRecoveryPointInput) AsApplyRecoveryPointProviderSpecificInput() (*ApplyRecoveryPointProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicApplyRecoveryPointProviderSpecificInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for HyperVReplicaAzureApplyRecoveryPointInput.
func (hvraarpi HyperVReplicaAzureApplyRecoveryPointInput) AsBasicApplyRecoveryPointProviderSpecificInput() (BasicApplyRecoveryPointProviderSpecificInput, bool) {
	return &hvraarpi, true
}

// HyperVReplicaAzureEnableProtectionInput azure specific enable protection input.
type HyperVReplicaAzureEnableProtectionInput struct {
	// HvHostVMID - The Hyper-V host Vm Id.
	HvHostVMID *string `json:"hvHostVmId,omitempty"`
	// VMName - The Vm Name.
	VMName *string `json:"vmName,omitempty"`
	// OsType - The OS type associated with vm.
	OsType *string `json:"osType,omitempty"`
	// VhdID - The OS disk VHD id associated with vm.
	VhdID *string `json:"vhdId,omitempty"`
	// TargetStorageAccountID - The storage account name.
	TargetStorageAccountID *string `json:"targetStorageAccountId,omitempty"`
	// TargetAzureNetworkID - The selected target Azure network Id.
	TargetAzureNetworkID *string `json:"targetAzureNetworkId,omitempty"`
	// TargetAzureSubnetID - The selected target Azure subnet Id.
	TargetAzureSubnetID *string `json:"targetAzureSubnetId,omitempty"`
	// EnableRdpOnTargetOption - The selected option to enable RDP\SSH on target vm after failover. String value of {SrsDataContract.EnableRDPOnTargetOption} enum.
	EnableRdpOnTargetOption *string `json:"enableRdpOnTargetOption,omitempty"`
	// TargetAzureVMName - The target azure Vm Name.
	TargetAzureVMName *string `json:"targetAzureVmName,omitempty"`
	// LogStorageAccountID - The storage account to be used for logging during replication.
	LogStorageAccountID *string `json:"logStorageAccountId,omitempty"`
	// DisksToInclude - The list of VHD IDs of disks to be protected.
	DisksToInclude *[]string `json:"disksToInclude,omitempty"`
	// TargetAzureV1ResourceGroupID - The Id of the target resource group (for classic deployment) in which the failover VM is to be created.
	TargetAzureV1ResourceGroupID *string `json:"targetAzureV1ResourceGroupId,omitempty"`
	// TargetAzureV2ResourceGroupID - The Id of the target resource group (for resource manager deployment) in which the failover VM is to be created.
	TargetAzureV2ResourceGroupID *string `json:"targetAzureV2ResourceGroupId,omitempty"`
	// UseManagedDisks - A value indicating whether managed disks should be used during failover.
	UseManagedDisks *string `json:"useManagedDisks,omitempty"`
	// TargetAvailabilityZone - The target availability zone.
	TargetAvailabilityZone *string `json:"targetAvailabilityZone,omitempty"`
	// TargetProximityPlacementGroupID - The proximity placement group ARM Id.
	TargetProximityPlacementGroupID *string `json:"targetProximityPlacementGroupId,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeEnableProtectionProviderSpecificInput', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeA2A', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMage', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMageRcm', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeSan'
	InstanceType InstanceTypeBasicEnableProtectionProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaAzureEnableProtectionInput.
func (hvraepi HyperVReplicaAzureEnableProtectionInput) MarshalJSON() ([]byte, error) {
	hvraepi.InstanceType = InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeHyperVReplicaAzure
	objectMap := make(map[string]interface{})
	if hvraepi.HvHostVMID != nil {
		objectMap["hvHostVmId"] = hvraepi.HvHostVMID
	}
	if hvraepi.VMName != nil {
		objectMap["vmName"] = hvraepi.VMName
	}
	if hvraepi.OsType != nil {
		objectMap["osType"] = hvraepi.OsType
	}
	if hvraepi.VhdID != nil {
		objectMap["vhdId"] = hvraepi.VhdID
	}
	if hvraepi.TargetStorageAccountID != nil {
		objectMap["targetStorageAccountId"] = hvraepi.TargetStorageAccountID
	}
	if hvraepi.TargetAzureNetworkID != nil {
		objectMap["targetAzureNetworkId"] = hvraepi.TargetAzureNetworkID
	}
	if hvraepi.TargetAzureSubnetID != nil {
		objectMap["targetAzureSubnetId"] = hvraepi.TargetAzureSubnetID
	}
	if hvraepi.EnableRdpOnTargetOption != nil {
		objectMap["enableRdpOnTargetOption"] = hvraepi.EnableRdpOnTargetOption
	}
	if hvraepi.TargetAzureVMName != nil {
		objectMap["targetAzureVmName"] = hvraepi.TargetAzureVMName
	}
	if hvraepi.LogStorageAccountID != nil {
		objectMap["logStorageAccountId"] = hvraepi.LogStorageAccountID
	}
	if hvraepi.DisksToInclude != nil {
		objectMap["disksToInclude"] = hvraepi.DisksToInclude
	}
	if hvraepi.TargetAzureV1ResourceGroupID != nil {
		objectMap["targetAzureV1ResourceGroupId"] = hvraepi.TargetAzureV1ResourceGroupID
	}
	if hvraepi.TargetAzureV2ResourceGroupID != nil {
		objectMap["targetAzureV2ResourceGroupId"] = hvraepi.TargetAzureV2ResourceGroupID
	}
	if hvraepi.UseManagedDisks != nil {
		objectMap["useManagedDisks"] = hvraepi.UseManagedDisks
	}
	if hvraepi.TargetAvailabilityZone != nil {
		objectMap["targetAvailabilityZone"] = hvraepi.TargetAvailabilityZone
	}
	if hvraepi.TargetProximityPlacementGroupID != nil {
		objectMap["targetProximityPlacementGroupId"] = hvraepi.TargetProximityPlacementGroupID
	}
	if hvraepi.InstanceType != "" {
		objectMap["instanceType"] = hvraepi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for HyperVReplicaAzureEnableProtectionInput.
func (hvraepi HyperVReplicaAzureEnableProtectionInput) AsA2AEnableProtectionInput() (*A2AEnableProtectionInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzureEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for HyperVReplicaAzureEnableProtectionInput.
func (hvraepi HyperVReplicaAzureEnableProtectionInput) AsHyperVReplicaAzureEnableProtectionInput() (*HyperVReplicaAzureEnableProtectionInput, bool) {
	return &hvraepi, true
}

// AsInMageAzureV2EnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for HyperVReplicaAzureEnableProtectionInput.
func (hvraepi HyperVReplicaAzureEnableProtectionInput) AsInMageAzureV2EnableProtectionInput() (*InMageAzureV2EnableProtectionInput, bool) {
	return nil, false
}

// AsInMageEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for HyperVReplicaAzureEnableProtectionInput.
func (hvraepi HyperVReplicaAzureEnableProtectionInput) AsInMageEnableProtectionInput() (*InMageEnableProtectionInput, bool) {
	return nil, false
}

// AsInMageRcmEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for HyperVReplicaAzureEnableProtectionInput.
func (hvraepi HyperVReplicaAzureEnableProtectionInput) AsInMageRcmEnableProtectionInput() (*InMageRcmEnableProtectionInput, bool) {
	return nil, false
}

// AsSanEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for HyperVReplicaAzureEnableProtectionInput.
func (hvraepi HyperVReplicaAzureEnableProtectionInput) AsSanEnableProtectionInput() (*SanEnableProtectionInput, bool) {
	return nil, false
}

// AsEnableProtectionProviderSpecificInput is the BasicEnableProtectionProviderSpecificInput implementation for HyperVReplicaAzureEnableProtectionInput.
func (hvraepi HyperVReplicaAzureEnableProtectionInput) AsEnableProtectionProviderSpecificInput() (*EnableProtectionProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicEnableProtectionProviderSpecificInput is the BasicEnableProtectionProviderSpecificInput implementation for HyperVReplicaAzureEnableProtectionInput.
func (hvraepi HyperVReplicaAzureEnableProtectionInput) AsBasicEnableProtectionProviderSpecificInput() (BasicEnableProtectionProviderSpecificInput, bool) {
	return &hvraepi, true
}

// HyperVReplicaAzureEventDetails model class for event details of a HyperVReplica E2A event.
type HyperVReplicaAzureEventDetails struct {
	// ContainerName - The container friendly name.
	ContainerName *string `json:"containerName,omitempty"`
	// FabricName - The fabric friendly name.
	FabricName *string `json:"fabricName,omitempty"`
	// RemoteContainerName - The remote container name.
	RemoteContainerName *string `json:"remoteContainerName,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeEventProviderSpecificDetails', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeA2A', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplicaBaseEventDetails', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeInMageAzureV2', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeInMageRcm'
	InstanceType InstanceTypeBasicEventProviderSpecificDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaAzureEventDetails.
func (hvraed HyperVReplicaAzureEventDetails) MarshalJSON() ([]byte, error) {
	hvraed.InstanceType = InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplicaAzure
	objectMap := make(map[string]interface{})
	if hvraed.ContainerName != nil {
		objectMap["containerName"] = hvraed.ContainerName
	}
	if hvraed.FabricName != nil {
		objectMap["fabricName"] = hvraed.FabricName
	}
	if hvraed.RemoteContainerName != nil {
		objectMap["remoteContainerName"] = hvraed.RemoteContainerName
	}
	if hvraed.InstanceType != "" {
		objectMap["instanceType"] = hvraed.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AEventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplicaAzureEventDetails.
func (hvraed HyperVReplicaAzureEventDetails) AsA2AEventDetails() (*A2AEventDetails, bool) {
	return nil, false
}

// AsHyperVReplica2012EventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplicaAzureEventDetails.
func (hvraed HyperVReplicaAzureEventDetails) AsHyperVReplica2012EventDetails() (*HyperVReplica2012EventDetails, bool) {
	return nil, false
}

// AsHyperVReplica2012R2EventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplicaAzureEventDetails.
func (hvraed HyperVReplicaAzureEventDetails) AsHyperVReplica2012R2EventDetails() (*HyperVReplica2012R2EventDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzureEventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplicaAzureEventDetails.
func (hvraed HyperVReplicaAzureEventDetails) AsHyperVReplicaAzureEventDetails() (*HyperVReplicaAzureEventDetails, bool) {
	return &hvraed, true
}

// AsHyperVReplicaBaseEventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplicaAzureEventDetails.
func (hvraed HyperVReplicaAzureEventDetails) AsHyperVReplicaBaseEventDetails() (*HyperVReplicaBaseEventDetails, bool) {
	return nil, false
}

// AsInMageAzureV2EventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplicaAzureEventDetails.
func (hvraed HyperVReplicaAzureEventDetails) AsInMageAzureV2EventDetails() (*InMageAzureV2EventDetails, bool) {
	return nil, false
}

// AsInMageRcmEventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplicaAzureEventDetails.
func (hvraed HyperVReplicaAzureEventDetails) AsInMageRcmEventDetails() (*InMageRcmEventDetails, bool) {
	return nil, false
}

// AsEventProviderSpecificDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplicaAzureEventDetails.
func (hvraed HyperVReplicaAzureEventDetails) AsEventProviderSpecificDetails() (*EventProviderSpecificDetails, bool) {
	return nil, false
}

// AsBasicEventProviderSpecificDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplicaAzureEventDetails.
func (hvraed HyperVReplicaAzureEventDetails) AsBasicEventProviderSpecificDetails() (BasicEventProviderSpecificDetails, bool) {
	return &hvraed, true
}

// HyperVReplicaAzureFailbackProviderInput hvrA provider specific input for failback.
type HyperVReplicaAzureFailbackProviderInput struct {
	// DataSyncOption - Data sync option.
	DataSyncOption *string `json:"dataSyncOption,omitempty"`
	// RecoveryVMCreationOption - ALR options to create alternate recovery.
	RecoveryVMCreationOption *string `json:"recoveryVmCreationOption,omitempty"`
	// ProviderIDForAlternateRecovery - Provider ID for alternate location
	ProviderIDForAlternateRecovery *string `json:"providerIdForAlternateRecovery,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeProviderSpecificFailoverInput', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeA2A', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMage'
	InstanceType InstanceTypeBasicProviderSpecificFailoverInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaAzureFailbackProviderInput.
func (hvrafpi HyperVReplicaAzureFailbackProviderInput) MarshalJSON() ([]byte, error) {
	hvrafpi.InstanceType = InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback
	objectMap := make(map[string]interface{})
	if hvrafpi.DataSyncOption != nil {
		objectMap["dataSyncOption"] = hvrafpi.DataSyncOption
	}
	if hvrafpi.RecoveryVMCreationOption != nil {
		objectMap["recoveryVmCreationOption"] = hvrafpi.RecoveryVMCreationOption
	}
	if hvrafpi.ProviderIDForAlternateRecovery != nil {
		objectMap["providerIdForAlternateRecovery"] = hvrafpi.ProviderIDForAlternateRecovery
	}
	if hvrafpi.InstanceType != "" {
		objectMap["instanceType"] = hvrafpi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AFailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for HyperVReplicaAzureFailbackProviderInput.
func (hvrafpi HyperVReplicaAzureFailbackProviderInput) AsA2AFailoverProviderInput() (*A2AFailoverProviderInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzureFailbackProviderInput is the BasicProviderSpecificFailoverInput implementation for HyperVReplicaAzureFailbackProviderInput.
func (hvrafpi HyperVReplicaAzureFailbackProviderInput) AsHyperVReplicaAzureFailbackProviderInput() (*HyperVReplicaAzureFailbackProviderInput, bool) {
	return &hvrafpi, true
}

// AsHyperVReplicaAzureFailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for HyperVReplicaAzureFailbackProviderInput.
func (hvrafpi HyperVReplicaAzureFailbackProviderInput) AsHyperVReplicaAzureFailoverProviderInput() (*HyperVReplicaAzureFailoverProviderInput, bool) {
	return nil, false
}

// AsInMageAzureV2FailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for HyperVReplicaAzureFailbackProviderInput.
func (hvrafpi HyperVReplicaAzureFailbackProviderInput) AsInMageAzureV2FailoverProviderInput() (*InMageAzureV2FailoverProviderInput, bool) {
	return nil, false
}

// AsInMageFailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for HyperVReplicaAzureFailbackProviderInput.
func (hvrafpi HyperVReplicaAzureFailbackProviderInput) AsInMageFailoverProviderInput() (*InMageFailoverProviderInput, bool) {
	return nil, false
}

// AsProviderSpecificFailoverInput is the BasicProviderSpecificFailoverInput implementation for HyperVReplicaAzureFailbackProviderInput.
func (hvrafpi HyperVReplicaAzureFailbackProviderInput) AsProviderSpecificFailoverInput() (*ProviderSpecificFailoverInput, bool) {
	return nil, false
}

// AsBasicProviderSpecificFailoverInput is the BasicProviderSpecificFailoverInput implementation for HyperVReplicaAzureFailbackProviderInput.
func (hvrafpi HyperVReplicaAzureFailbackProviderInput) AsBasicProviderSpecificFailoverInput() (BasicProviderSpecificFailoverInput, bool) {
	return &hvrafpi, true
}

// HyperVReplicaAzureFailoverProviderInput hvrA provider specific input for failover.
type HyperVReplicaAzureFailoverProviderInput struct {
	// VaultLocation - Location of the vault.
	VaultLocation *string `json:"vaultLocation,omitempty"`
	// PrimaryKekCertificatePfx - Primary kek certificate pfx.
	PrimaryKekCertificatePfx *string `json:"primaryKekCertificatePfx,omitempty"`
	// SecondaryKekCertificatePfx - Secondary kek certificate pfx.
	SecondaryKekCertificatePfx *string `json:"secondaryKekCertificatePfx,omitempty"`
	// RecoveryPointID - The recovery point id to be passed to failover to a particular recovery point. In case of latest recovery point, null should be passed.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeProviderSpecificFailoverInput', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeA2A', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMage'
	InstanceType InstanceTypeBasicProviderSpecificFailoverInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaAzureFailoverProviderInput.
func (hvrafpi HyperVReplicaAzureFailoverProviderInput) MarshalJSON() ([]byte, error) {
	hvrafpi.InstanceType = InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure
	objectMap := make(map[string]interface{})
	if hvrafpi.VaultLocation != nil {
		objectMap["vaultLocation"] = hvrafpi.VaultLocation
	}
	if hvrafpi.PrimaryKekCertificatePfx != nil {
		objectMap["primaryKekCertificatePfx"] = hvrafpi.PrimaryKekCertificatePfx
	}
	if hvrafpi.SecondaryKekCertificatePfx != nil {
		objectMap["secondaryKekCertificatePfx"] = hvrafpi.SecondaryKekCertificatePfx
	}
	if hvrafpi.RecoveryPointID != nil {
		objectMap["recoveryPointId"] = hvrafpi.RecoveryPointID
	}
	if hvrafpi.InstanceType != "" {
		objectMap["instanceType"] = hvrafpi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AFailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for HyperVReplicaAzureFailoverProviderInput.
func (hvrafpi HyperVReplicaAzureFailoverProviderInput) AsA2AFailoverProviderInput() (*A2AFailoverProviderInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzureFailbackProviderInput is the BasicProviderSpecificFailoverInput implementation for HyperVReplicaAzureFailoverProviderInput.
func (hvrafpi HyperVReplicaAzureFailoverProviderInput) AsHyperVReplicaAzureFailbackProviderInput() (*HyperVReplicaAzureFailbackProviderInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzureFailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for HyperVReplicaAzureFailoverProviderInput.
func (hvrafpi HyperVReplicaAzureFailoverProviderInput) AsHyperVReplicaAzureFailoverProviderInput() (*HyperVReplicaAzureFailoverProviderInput, bool) {
	return &hvrafpi, true
}

// AsInMageAzureV2FailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for HyperVReplicaAzureFailoverProviderInput.
func (hvrafpi HyperVReplicaAzureFailoverProviderInput) AsInMageAzureV2FailoverProviderInput() (*InMageAzureV2FailoverProviderInput, bool) {
	return nil, false
}

// AsInMageFailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for HyperVReplicaAzureFailoverProviderInput.
func (hvrafpi HyperVReplicaAzureFailoverProviderInput) AsInMageFailoverProviderInput() (*InMageFailoverProviderInput, bool) {
	return nil, false
}

// AsProviderSpecificFailoverInput is the BasicProviderSpecificFailoverInput implementation for HyperVReplicaAzureFailoverProviderInput.
func (hvrafpi HyperVReplicaAzureFailoverProviderInput) AsProviderSpecificFailoverInput() (*ProviderSpecificFailoverInput, bool) {
	return nil, false
}

// AsBasicProviderSpecificFailoverInput is the BasicProviderSpecificFailoverInput implementation for HyperVReplicaAzureFailoverProviderInput.
func (hvrafpi HyperVReplicaAzureFailoverProviderInput) AsBasicProviderSpecificFailoverInput() (BasicProviderSpecificFailoverInput, bool) {
	return &hvrafpi, true
}

// HyperVReplicaAzurePolicyDetails hyper-V Replica Azure specific protection profile details.
type HyperVReplicaAzurePolicyDetails struct {
	// RecoveryPointHistoryDurationInHours - The duration (in hours) to which point the recovery history needs to be maintained.
	RecoveryPointHistoryDurationInHours *int32 `json:"recoveryPointHistoryDurationInHours,omitempty"`
	// ApplicationConsistentSnapshotFrequencyInHours - The interval (in hours) at which Hyper-V Replica should create an application consistent snapshot within the VM.
	ApplicationConsistentSnapshotFrequencyInHours *int32 `json:"applicationConsistentSnapshotFrequencyInHours,omitempty"`
	// ReplicationInterval - The replication interval.
	ReplicationInterval *int32 `json:"replicationInterval,omitempty"`
	// OnlineReplicationStartTime - The scheduled start time for the initial replication. If this parameter is Null, the initial replication starts immediately.
	OnlineReplicationStartTime *string `json:"onlineReplicationStartTime,omitempty"`
	// Encryption - A value indicating whether encryption is enabled for virtual machines in this cloud.
	Encryption *string `json:"encryption,omitempty"`
	// ActiveStorageAccountID - The active storage account Id.
	ActiveStorageAccountID *string `json:"activeStorageAccountId,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypePolicyProviderSpecificDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeA2A', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaBasePolicyDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageAzureV2', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageBasePolicyDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMage', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageRcm', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeRcmAzureMigration', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeVMwareCbt'
	InstanceType InstanceTypeBasicPolicyProviderSpecificDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaAzurePolicyDetails.
func (hvrapd HyperVReplicaAzurePolicyDetails) MarshalJSON() ([]byte, error) {
	hvrapd.InstanceType = InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaAzure
	objectMap := make(map[string]interface{})
	if hvrapd.RecoveryPointHistoryDurationInHours != nil {
		objectMap["recoveryPointHistoryDurationInHours"] = hvrapd.RecoveryPointHistoryDurationInHours
	}
	if hvrapd.ApplicationConsistentSnapshotFrequencyInHours != nil {
		objectMap["applicationConsistentSnapshotFrequencyInHours"] = hvrapd.ApplicationConsistentSnapshotFrequencyInHours
	}
	if hvrapd.ReplicationInterval != nil {
		objectMap["replicationInterval"] = hvrapd.ReplicationInterval
	}
	if hvrapd.OnlineReplicationStartTime != nil {
		objectMap["onlineReplicationStartTime"] = hvrapd.OnlineReplicationStartTime
	}
	if hvrapd.Encryption != nil {
		objectMap["encryption"] = hvrapd.Encryption
	}
	if hvrapd.ActiveStorageAccountID != nil {
		objectMap["activeStorageAccountId"] = hvrapd.ActiveStorageAccountID
	}
	if hvrapd.InstanceType != "" {
		objectMap["instanceType"] = hvrapd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2APolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaAzurePolicyDetails.
func (hvrapd HyperVReplicaAzurePolicyDetails) AsA2APolicyDetails() (*A2APolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzurePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaAzurePolicyDetails.
func (hvrapd HyperVReplicaAzurePolicyDetails) AsHyperVReplicaAzurePolicyDetails() (*HyperVReplicaAzurePolicyDetails, bool) {
	return &hvrapd, true
}

// AsHyperVReplicaBasePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaAzurePolicyDetails.
func (hvrapd HyperVReplicaAzurePolicyDetails) AsHyperVReplicaBasePolicyDetails() (*HyperVReplicaBasePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaAzurePolicyDetails.
func (hvrapd HyperVReplicaAzurePolicyDetails) AsHyperVReplicaBluePolicyDetails() (*HyperVReplicaBluePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaAzurePolicyDetails.
func (hvrapd HyperVReplicaAzurePolicyDetails) AsHyperVReplicaPolicyDetails() (*HyperVReplicaPolicyDetails, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaAzurePolicyDetails.
func (hvrapd HyperVReplicaAzurePolicyDetails) AsInMageAzureV2PolicyDetails() (*InMageAzureV2PolicyDetails, bool) {
	return nil, false
}

// AsInMageBasePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaAzurePolicyDetails.
func (hvrapd HyperVReplicaAzurePolicyDetails) AsInMageBasePolicyDetails() (*InMageBasePolicyDetails, bool) {
	return nil, false
}

// AsInMagePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaAzurePolicyDetails.
func (hvrapd HyperVReplicaAzurePolicyDetails) AsInMagePolicyDetails() (*InMagePolicyDetails, bool) {
	return nil, false
}

// AsInMageRcmPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaAzurePolicyDetails.
func (hvrapd HyperVReplicaAzurePolicyDetails) AsInMageRcmPolicyDetails() (*InMageRcmPolicyDetails, bool) {
	return nil, false
}

// AsRcmAzureMigrationPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaAzurePolicyDetails.
func (hvrapd HyperVReplicaAzurePolicyDetails) AsRcmAzureMigrationPolicyDetails() (*RcmAzureMigrationPolicyDetails, bool) {
	return nil, false
}

// AsVmwareCbtPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaAzurePolicyDetails.
func (hvrapd HyperVReplicaAzurePolicyDetails) AsVmwareCbtPolicyDetails() (*VmwareCbtPolicyDetails, bool) {
	return nil, false
}

// AsPolicyProviderSpecificDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaAzurePolicyDetails.
func (hvrapd HyperVReplicaAzurePolicyDetails) AsPolicyProviderSpecificDetails() (*PolicyProviderSpecificDetails, bool) {
	return nil, false
}

// AsBasicPolicyProviderSpecificDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaAzurePolicyDetails.
func (hvrapd HyperVReplicaAzurePolicyDetails) AsBasicPolicyProviderSpecificDetails() (BasicPolicyProviderSpecificDetails, bool) {
	return &hvrapd, true
}

// HyperVReplicaAzurePolicyInput hyper-V Replica Azure specific input for creating a protection profile.
type HyperVReplicaAzurePolicyInput struct {
	// RecoveryPointHistoryDuration - The duration (in hours) to which point the recovery history needs to be maintained.
	RecoveryPointHistoryDuration *int32 `json:"recoveryPointHistoryDuration,omitempty"`
	// ApplicationConsistentSnapshotFrequencyInHours - The interval (in hours) at which Hyper-V Replica should create an application consistent snapshot within the VM.
	ApplicationConsistentSnapshotFrequencyInHours *int32 `json:"applicationConsistentSnapshotFrequencyInHours,omitempty"`
	// ReplicationInterval - The replication interval.
	ReplicationInterval *int32 `json:"replicationInterval,omitempty"`
	// OnlineReplicationStartTime - The scheduled start time for the initial replication. If this parameter is Null, the initial replication starts immediately.
	OnlineReplicationStartTime *string `json:"onlineReplicationStartTime,omitempty"`
	// StorageAccounts - The list of storage accounts to which the VMs in the primary cloud can replicate to.
	StorageAccounts *[]string `json:"storageAccounts,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypePolicyProviderSpecificInput', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeA2A', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMage', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMageRcm', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeVMwareCbt'
	InstanceType InstanceTypeBasicPolicyProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaAzurePolicyInput.
func (hvrapi HyperVReplicaAzurePolicyInput) MarshalJSON() ([]byte, error) {
	hvrapi.InstanceType = InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplicaAzure
	objectMap := make(map[string]interface{})
	if hvrapi.RecoveryPointHistoryDuration != nil {
		objectMap["recoveryPointHistoryDuration"] = hvrapi.RecoveryPointHistoryDuration
	}
	if hvrapi.ApplicationConsistentSnapshotFrequencyInHours != nil {
		objectMap["applicationConsistentSnapshotFrequencyInHours"] = hvrapi.ApplicationConsistentSnapshotFrequencyInHours
	}
	if hvrapi.ReplicationInterval != nil {
		objectMap["replicationInterval"] = hvrapi.ReplicationInterval
	}
	if hvrapi.OnlineReplicationStartTime != nil {
		objectMap["onlineReplicationStartTime"] = hvrapi.OnlineReplicationStartTime
	}
	if hvrapi.StorageAccounts != nil {
		objectMap["storageAccounts"] = hvrapi.StorageAccounts
	}
	if hvrapi.InstanceType != "" {
		objectMap["instanceType"] = hvrapi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2APolicyCreationInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaAzurePolicyInput.
func (hvrapi HyperVReplicaAzurePolicyInput) AsA2APolicyCreationInput() (*A2APolicyCreationInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzurePolicyInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaAzurePolicyInput.
func (hvrapi HyperVReplicaAzurePolicyInput) AsHyperVReplicaAzurePolicyInput() (*HyperVReplicaAzurePolicyInput, bool) {
	return &hvrapi, true
}

// AsHyperVReplicaBluePolicyInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaAzurePolicyInput.
func (hvrapi HyperVReplicaAzurePolicyInput) AsHyperVReplicaBluePolicyInput() (*HyperVReplicaBluePolicyInput, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaAzurePolicyInput.
func (hvrapi HyperVReplicaAzurePolicyInput) AsHyperVReplicaPolicyInput() (*HyperVReplicaPolicyInput, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaAzurePolicyInput.
func (hvrapi HyperVReplicaAzurePolicyInput) AsInMageAzureV2PolicyInput() (*InMageAzureV2PolicyInput, bool) {
	return nil, false
}

// AsInMagePolicyInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaAzurePolicyInput.
func (hvrapi HyperVReplicaAzurePolicyInput) AsInMagePolicyInput() (*InMagePolicyInput, bool) {
	return nil, false
}

// AsInMageRcmPolicyCreationInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaAzurePolicyInput.
func (hvrapi HyperVReplicaAzurePolicyInput) AsInMageRcmPolicyCreationInput() (*InMageRcmPolicyCreationInput, bool) {
	return nil, false
}

// AsVMwareCbtPolicyCreationInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaAzurePolicyInput.
func (hvrapi HyperVReplicaAzurePolicyInput) AsVMwareCbtPolicyCreationInput() (*VMwareCbtPolicyCreationInput, bool) {
	return nil, false
}

// AsPolicyProviderSpecificInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaAzurePolicyInput.
func (hvrapi HyperVReplicaAzurePolicyInput) AsPolicyProviderSpecificInput() (*PolicyProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicPolicyProviderSpecificInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaAzurePolicyInput.
func (hvrapi HyperVReplicaAzurePolicyInput) AsBasicPolicyProviderSpecificInput() (BasicPolicyProviderSpecificInput, bool) {
	return &hvrapi, true
}

// HyperVReplicaAzureReplicationDetails hyper V Replica Azure provider specific settings.
type HyperVReplicaAzureReplicationDetails struct {
	// AzureVMDiskDetails - Azure VM Disk details.
	AzureVMDiskDetails *[]AzureVMDiskDetails `json:"azureVmDiskDetails,omitempty"`
	// RecoveryAzureVMName - Recovery Azure given name.
	RecoveryAzureVMName *string `json:"recoveryAzureVmName,omitempty"`
	// RecoveryAzureVMSize - The Recovery Azure VM size.
	RecoveryAzureVMSize *string `json:"recoveryAzureVMSize,omitempty"`
	// RecoveryAzureStorageAccount - The recovery Azure storage account.
	RecoveryAzureStorageAccount *string `json:"recoveryAzureStorageAccount,omitempty"`
	// RecoveryAzureLogStorageAccountID - The ARM id of the log storage account used for replication. This will be set to null if no log storage account was provided during enable protection.
	RecoveryAzureLogStorageAccountID *string `json:"recoveryAzureLogStorageAccountId,omitempty"`
	// LastReplicatedTime - The Last replication time.
	LastReplicatedTime *date.Time `json:"lastReplicatedTime,omitempty"`
	// RpoInSeconds - Last RPO value.
	RpoInSeconds *int64 `json:"rpoInSeconds,omitempty"`
	// LastRpoCalculatedTime - The last RPO calculated time.
	LastRpoCalculatedTime *date.Time `json:"lastRpoCalculatedTime,omitempty"`
	// VMID - The virtual machine Id.
	VMID *string `json:"vmId,omitempty"`
	// VMProtectionState - The protection state for the vm.
	VMProtectionState *string `json:"vmProtectionState,omitempty"`
	// VMProtectionStateDescription - The protection state description for the vm.
	VMProtectionStateDescription *string `json:"vmProtectionStateDescription,omitempty"`
	// InitialReplicationDetails - Initial replication details.
	InitialReplicationDetails *InitialReplicationDetails `json:"initialReplicationDetails,omitempty"`
	// VMNics - The PE Network details.
	VMNics *[]VMNicDetails `json:"vmNics,omitempty"`
	// SelectedRecoveryAzureNetworkID - The selected recovery azure network Id.
	SelectedRecoveryAzureNetworkID *string `json:"selectedRecoveryAzureNetworkId,omitempty"`
	// SelectedSourceNicID - The selected source nic Id which will be used as the primary nic during failover.
	SelectedSourceNicID *string `json:"selectedSourceNicId,omitempty"`
	// Encryption - The encryption info.
	Encryption *string `json:"encryption,omitempty"`
	// OSDetails - The operating system info.
	OSDetails *OSDetails `json:"oSDetails,omitempty"`
	// SourceVMRAMSizeInMB - The RAM size of the VM on the primary side.
	SourceVMRAMSizeInMB *int32 `json:"sourceVmRamSizeInMB,omitempty"`
	// SourceVMCPUCount - The CPU count of the VM on the primary side.
	SourceVMCPUCount *int32 `json:"sourceVmCpuCount,omitempty"`
	// EnableRdpOnTargetOption - The selected option to enable RDP\SSH on target vm after failover. String value of {SrsDataContract.EnableRDPOnTargetOption} enum.
	EnableRdpOnTargetOption *string `json:"enableRdpOnTargetOption,omitempty"`
	// RecoveryAzureResourceGroupID - The target resource group Id.
	RecoveryAzureResourceGroupID *string `json:"recoveryAzureResourceGroupId,omitempty"`
	// RecoveryAvailabilitySetID - The recovery availability set Id.
	RecoveryAvailabilitySetID *string `json:"recoveryAvailabilitySetId,omitempty"`
	// TargetAvailabilityZone - The target availability zone.
	TargetAvailabilityZone *string `json:"targetAvailabilityZone,omitempty"`
	// TargetProximityPlacementGroupID - The target proximity placement group Id.
	TargetProximityPlacementGroupID *string `json:"targetProximityPlacementGroupId,omitempty"`
	// UseManagedDisks - A value indicating whether managed disks should be used during failover.
	UseManagedDisks *string `json:"useManagedDisks,omitempty"`
	// LicenseType - License Type of the VM to be used.
	LicenseType *string `json:"licenseType,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeReplicationProviderSpecificSettings', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeA2A', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaBaseReplicationDetails', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMageAzureV2', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMageRcm', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMage'
	InstanceType InstanceTypeBasicReplicationProviderSpecificSettings `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaAzureReplicationDetails.
func (hvrard HyperVReplicaAzureReplicationDetails) MarshalJSON() ([]byte, error) {
	hvrard.InstanceType = InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaAzure
	objectMap := make(map[string]interface{})
	if hvrard.AzureVMDiskDetails != nil {
		objectMap["azureVmDiskDetails"] = hvrard.AzureVMDiskDetails
	}
	if hvrard.RecoveryAzureVMName != nil {
		objectMap["recoveryAzureVmName"] = hvrard.RecoveryAzureVMName
	}
	if hvrard.RecoveryAzureVMSize != nil {
		objectMap["recoveryAzureVMSize"] = hvrard.RecoveryAzureVMSize
	}
	if hvrard.RecoveryAzureStorageAccount != nil {
		objectMap["recoveryAzureStorageAccount"] = hvrard.RecoveryAzureStorageAccount
	}
	if hvrard.RecoveryAzureLogStorageAccountID != nil {
		objectMap["recoveryAzureLogStorageAccountId"] = hvrard.RecoveryAzureLogStorageAccountID
	}
	if hvrard.LastReplicatedTime != nil {
		objectMap["lastReplicatedTime"] = hvrard.LastReplicatedTime
	}
	if hvrard.RpoInSeconds != nil {
		objectMap["rpoInSeconds"] = hvrard.RpoInSeconds
	}
	if hvrard.LastRpoCalculatedTime != nil {
		objectMap["lastRpoCalculatedTime"] = hvrard.LastRpoCalculatedTime
	}
	if hvrard.VMID != nil {
		objectMap["vmId"] = hvrard.VMID
	}
	if hvrard.VMProtectionState != nil {
		objectMap["vmProtectionState"] = hvrard.VMProtectionState
	}
	if hvrard.VMProtectionStateDescription != nil {
		objectMap["vmProtectionStateDescription"] = hvrard.VMProtectionStateDescription
	}
	if hvrard.InitialReplicationDetails != nil {
		objectMap["initialReplicationDetails"] = hvrard.InitialReplicationDetails
	}
	if hvrard.VMNics != nil {
		objectMap["vmNics"] = hvrard.VMNics
	}
	if hvrard.SelectedRecoveryAzureNetworkID != nil {
		objectMap["selectedRecoveryAzureNetworkId"] = hvrard.SelectedRecoveryAzureNetworkID
	}
	if hvrard.SelectedSourceNicID != nil {
		objectMap["selectedSourceNicId"] = hvrard.SelectedSourceNicID
	}
	if hvrard.Encryption != nil {
		objectMap["encryption"] = hvrard.Encryption
	}
	if hvrard.OSDetails != nil {
		objectMap["oSDetails"] = hvrard.OSDetails
	}
	if hvrard.SourceVMRAMSizeInMB != nil {
		objectMap["sourceVmRamSizeInMB"] = hvrard.SourceVMRAMSizeInMB
	}
	if hvrard.SourceVMCPUCount != nil {
		objectMap["sourceVmCpuCount"] = hvrard.SourceVMCPUCount
	}
	if hvrard.EnableRdpOnTargetOption != nil {
		objectMap["enableRdpOnTargetOption"] = hvrard.EnableRdpOnTargetOption
	}
	if hvrard.RecoveryAzureResourceGroupID != nil {
		objectMap["recoveryAzureResourceGroupId"] = hvrard.RecoveryAzureResourceGroupID
	}
	if hvrard.RecoveryAvailabilitySetID != nil {
		objectMap["recoveryAvailabilitySetId"] = hvrard.RecoveryAvailabilitySetID
	}
	if hvrard.TargetAvailabilityZone != nil {
		objectMap["targetAvailabilityZone"] = hvrard.TargetAvailabilityZone
	}
	if hvrard.TargetProximityPlacementGroupID != nil {
		objectMap["targetProximityPlacementGroupId"] = hvrard.TargetProximityPlacementGroupID
	}
	if hvrard.UseManagedDisks != nil {
		objectMap["useManagedDisks"] = hvrard.UseManagedDisks
	}
	if hvrard.LicenseType != nil {
		objectMap["licenseType"] = hvrard.LicenseType
	}
	if hvrard.InstanceType != "" {
		objectMap["instanceType"] = hvrard.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaAzureReplicationDetails.
func (hvrard HyperVReplicaAzureReplicationDetails) AsA2AReplicationDetails() (*A2AReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzureReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaAzureReplicationDetails.
func (hvrard HyperVReplicaAzureReplicationDetails) AsHyperVReplicaAzureReplicationDetails() (*HyperVReplicaAzureReplicationDetails, bool) {
	return &hvrard, true
}

// AsHyperVReplicaBaseReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaAzureReplicationDetails.
func (hvrard HyperVReplicaAzureReplicationDetails) AsHyperVReplicaBaseReplicationDetails() (*HyperVReplicaBaseReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBlueReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaAzureReplicationDetails.
func (hvrard HyperVReplicaAzureReplicationDetails) AsHyperVReplicaBlueReplicationDetails() (*HyperVReplicaBlueReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaAzureReplicationDetails.
func (hvrard HyperVReplicaAzureReplicationDetails) AsHyperVReplicaReplicationDetails() (*HyperVReplicaReplicationDetails, bool) {
	return nil, false
}

// AsInMageAzureV2ReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaAzureReplicationDetails.
func (hvrard HyperVReplicaAzureReplicationDetails) AsInMageAzureV2ReplicationDetails() (*InMageAzureV2ReplicationDetails, bool) {
	return nil, false
}

// AsInMageRcmReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaAzureReplicationDetails.
func (hvrard HyperVReplicaAzureReplicationDetails) AsInMageRcmReplicationDetails() (*InMageRcmReplicationDetails, bool) {
	return nil, false
}

// AsInMageReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaAzureReplicationDetails.
func (hvrard HyperVReplicaAzureReplicationDetails) AsInMageReplicationDetails() (*InMageReplicationDetails, bool) {
	return nil, false
}

// AsReplicationProviderSpecificSettings is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaAzureReplicationDetails.
func (hvrard HyperVReplicaAzureReplicationDetails) AsReplicationProviderSpecificSettings() (*ReplicationProviderSpecificSettings, bool) {
	return nil, false
}

// AsBasicReplicationProviderSpecificSettings is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaAzureReplicationDetails.
func (hvrard HyperVReplicaAzureReplicationDetails) AsBasicReplicationProviderSpecificSettings() (BasicReplicationProviderSpecificSettings, bool) {
	return &hvrard, true
}

// HyperVReplicaAzureReprotectInput azure specific reprotect input.
type HyperVReplicaAzureReprotectInput struct {
	// HvHostVMID - The Hyper-V host Vm Id.
	HvHostVMID *string `json:"hvHostVmId,omitempty"`
	// VMName - The Vm Name.
	VMName *string `json:"vmName,omitempty"`
	// OsType - The OS type associated with vm.
	OsType *string `json:"osType,omitempty"`
	// VHDID - The OS disk VHD id associated with vm.
	VHDID *string `json:"vHDId,omitempty"`
	// StorageAccountID - The storage account name.
	StorageAccountID *string `json:"storageAccountId,omitempty"`
	// LogStorageAccountID - The storage account to be used for logging during replication.
	LogStorageAccountID *string `json:"logStorageAccountId,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeReverseReplicationProviderSpecificInput', 'InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeA2A', 'InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeInMage'
	InstanceType InstanceTypeBasicReverseReplicationProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaAzureReprotectInput.
func (hvrari HyperVReplicaAzureReprotectInput) MarshalJSON() ([]byte, error) {
	hvrari.InstanceType = InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeHyperVReplicaAzure
	objectMap := make(map[string]interface{})
	if hvrari.HvHostVMID != nil {
		objectMap["hvHostVmId"] = hvrari.HvHostVMID
	}
	if hvrari.VMName != nil {
		objectMap["vmName"] = hvrari.VMName
	}
	if hvrari.OsType != nil {
		objectMap["osType"] = hvrari.OsType
	}
	if hvrari.VHDID != nil {
		objectMap["vHDId"] = hvrari.VHDID
	}
	if hvrari.StorageAccountID != nil {
		objectMap["storageAccountId"] = hvrari.StorageAccountID
	}
	if hvrari.LogStorageAccountID != nil {
		objectMap["logStorageAccountId"] = hvrari.LogStorageAccountID
	}
	if hvrari.InstanceType != "" {
		objectMap["instanceType"] = hvrari.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AReprotectInput is the BasicReverseReplicationProviderSpecificInput implementation for HyperVReplicaAzureReprotectInput.
func (hvrari HyperVReplicaAzureReprotectInput) AsA2AReprotectInput() (*A2AReprotectInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzureReprotectInput is the BasicReverseReplicationProviderSpecificInput implementation for HyperVReplicaAzureReprotectInput.
func (hvrari HyperVReplicaAzureReprotectInput) AsHyperVReplicaAzureReprotectInput() (*HyperVReplicaAzureReprotectInput, bool) {
	return &hvrari, true
}

// AsInMageAzureV2ReprotectInput is the BasicReverseReplicationProviderSpecificInput implementation for HyperVReplicaAzureReprotectInput.
func (hvrari HyperVReplicaAzureReprotectInput) AsInMageAzureV2ReprotectInput() (*InMageAzureV2ReprotectInput, bool) {
	return nil, false
}

// AsInMageReprotectInput is the BasicReverseReplicationProviderSpecificInput implementation for HyperVReplicaAzureReprotectInput.
func (hvrari HyperVReplicaAzureReprotectInput) AsInMageReprotectInput() (*InMageReprotectInput, bool) {
	return nil, false
}

// AsReverseReplicationProviderSpecificInput is the BasicReverseReplicationProviderSpecificInput implementation for HyperVReplicaAzureReprotectInput.
func (hvrari HyperVReplicaAzureReprotectInput) AsReverseReplicationProviderSpecificInput() (*ReverseReplicationProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicReverseReplicationProviderSpecificInput is the BasicReverseReplicationProviderSpecificInput implementation for HyperVReplicaAzureReprotectInput.
func (hvrari HyperVReplicaAzureReprotectInput) AsBasicReverseReplicationProviderSpecificInput() (BasicReverseReplicationProviderSpecificInput, bool) {
	return &hvrari, true
}

// HyperVReplicaAzureTestFailoverInput hvrA provider specific input for test failover.
type HyperVReplicaAzureTestFailoverInput struct {
	// VaultLocation - Location of the vault.
	VaultLocation *string `json:"vaultLocation,omitempty"`
	// PrimaryKekCertificatePfx - Primary kek certificate pfx.
	PrimaryKekCertificatePfx *string `json:"primaryKekCertificatePfx,omitempty"`
	// SecondaryKekCertificatePfx - Secondary kek certificate pfx.
	SecondaryKekCertificatePfx *string `json:"secondaryKekCertificatePfx,omitempty"`
	// RecoveryPointID - The recovery point id to be passed to test failover to a particular recovery point. In case of latest recovery point, null should be passed.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeTestFailoverProviderSpecificInput', 'InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeA2A', 'InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeInMageRcm', 'InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeInMage'
	InstanceType InstanceTypeBasicTestFailoverProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaAzureTestFailoverInput.
func (hvratfi HyperVReplicaAzureTestFailoverInput) MarshalJSON() ([]byte, error) {
	hvratfi.InstanceType = InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeHyperVReplicaAzure
	objectMap := make(map[string]interface{})
	if hvratfi.VaultLocation != nil {
		objectMap["vaultLocation"] = hvratfi.VaultLocation
	}
	if hvratfi.PrimaryKekCertificatePfx != nil {
		objectMap["primaryKekCertificatePfx"] = hvratfi.PrimaryKekCertificatePfx
	}
	if hvratfi.SecondaryKekCertificatePfx != nil {
		objectMap["secondaryKekCertificatePfx"] = hvratfi.SecondaryKekCertificatePfx
	}
	if hvratfi.RecoveryPointID != nil {
		objectMap["recoveryPointId"] = hvratfi.RecoveryPointID
	}
	if hvratfi.InstanceType != "" {
		objectMap["instanceType"] = hvratfi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2ATestFailoverInput is the BasicTestFailoverProviderSpecificInput implementation for HyperVReplicaAzureTestFailoverInput.
func (hvratfi HyperVReplicaAzureTestFailoverInput) AsA2ATestFailoverInput() (*A2ATestFailoverInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzureTestFailoverInput is the BasicTestFailoverProviderSpecificInput implementation for HyperVReplicaAzureTestFailoverInput.
func (hvratfi HyperVReplicaAzureTestFailoverInput) AsHyperVReplicaAzureTestFailoverInput() (*HyperVReplicaAzureTestFailoverInput, bool) {
	return &hvratfi, true
}

// AsInMageAzureV2TestFailoverInput is the BasicTestFailoverProviderSpecificInput implementation for HyperVReplicaAzureTestFailoverInput.
func (hvratfi HyperVReplicaAzureTestFailoverInput) AsInMageAzureV2TestFailoverInput() (*InMageAzureV2TestFailoverInput, bool) {
	return nil, false
}

// AsInMageRcmTestFailoverInput is the BasicTestFailoverProviderSpecificInput implementation for HyperVReplicaAzureTestFailoverInput.
func (hvratfi HyperVReplicaAzureTestFailoverInput) AsInMageRcmTestFailoverInput() (*InMageRcmTestFailoverInput, bool) {
	return nil, false
}

// AsInMageTestFailoverInput is the BasicTestFailoverProviderSpecificInput implementation for HyperVReplicaAzureTestFailoverInput.
func (hvratfi HyperVReplicaAzureTestFailoverInput) AsInMageTestFailoverInput() (*InMageTestFailoverInput, bool) {
	return nil, false
}

// AsTestFailoverProviderSpecificInput is the BasicTestFailoverProviderSpecificInput implementation for HyperVReplicaAzureTestFailoverInput.
func (hvratfi HyperVReplicaAzureTestFailoverInput) AsTestFailoverProviderSpecificInput() (*TestFailoverProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicTestFailoverProviderSpecificInput is the BasicTestFailoverProviderSpecificInput implementation for HyperVReplicaAzureTestFailoverInput.
func (hvratfi HyperVReplicaAzureTestFailoverInput) AsBasicTestFailoverProviderSpecificInput() (BasicTestFailoverProviderSpecificInput, bool) {
	return &hvratfi, true
}

// HyperVReplicaAzureUnplannedFailoverInput hvrA provider specific input for unplanned failover.
type HyperVReplicaAzureUnplannedFailoverInput struct {
	// VaultLocation - Location of the vault.
	VaultLocation *string `json:"vaultLocation,omitempty"`
	// PrimaryKekCertificatePfx - Primary kek certificate pfx.
	PrimaryKekCertificatePfx *string `json:"primaryKekCertificatePfx,omitempty"`
	// SecondaryKekCertificatePfx - Secondary kek certificate pfx.
	SecondaryKekCertificatePfx *string `json:"secondaryKekCertificatePfx,omitempty"`
	// RecoveryPointID - The recovery point id to be passed to failover to a particular recovery point. In case of latest recovery point, null should be passed.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeUnplannedFailoverProviderSpecificInput', 'InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeA2A', 'InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeInMageRcm', 'InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeInMage'
	InstanceType InstanceTypeBasicUnplannedFailoverProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaAzureUnplannedFailoverInput.
func (hvraufi HyperVReplicaAzureUnplannedFailoverInput) MarshalJSON() ([]byte, error) {
	hvraufi.InstanceType = InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeHyperVReplicaAzure
	objectMap := make(map[string]interface{})
	if hvraufi.VaultLocation != nil {
		objectMap["vaultLocation"] = hvraufi.VaultLocation
	}
	if hvraufi.PrimaryKekCertificatePfx != nil {
		objectMap["primaryKekCertificatePfx"] = hvraufi.PrimaryKekCertificatePfx
	}
	if hvraufi.SecondaryKekCertificatePfx != nil {
		objectMap["secondaryKekCertificatePfx"] = hvraufi.SecondaryKekCertificatePfx
	}
	if hvraufi.RecoveryPointID != nil {
		objectMap["recoveryPointId"] = hvraufi.RecoveryPointID
	}
	if hvraufi.InstanceType != "" {
		objectMap["instanceType"] = hvraufi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AUnplannedFailoverInput is the BasicUnplannedFailoverProviderSpecificInput implementation for HyperVReplicaAzureUnplannedFailoverInput.
func (hvraufi HyperVReplicaAzureUnplannedFailoverInput) AsA2AUnplannedFailoverInput() (*A2AUnplannedFailoverInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzureUnplannedFailoverInput is the BasicUnplannedFailoverProviderSpecificInput implementation for HyperVReplicaAzureUnplannedFailoverInput.
func (hvraufi HyperVReplicaAzureUnplannedFailoverInput) AsHyperVReplicaAzureUnplannedFailoverInput() (*HyperVReplicaAzureUnplannedFailoverInput, bool) {
	return &hvraufi, true
}

// AsInMageAzureV2UnplannedFailoverInput is the BasicUnplannedFailoverProviderSpecificInput implementation for HyperVReplicaAzureUnplannedFailoverInput.
func (hvraufi HyperVReplicaAzureUnplannedFailoverInput) AsInMageAzureV2UnplannedFailoverInput() (*InMageAzureV2UnplannedFailoverInput, bool) {
	return nil, false
}

// AsInMageRcmUnplannedFailoverInput is the BasicUnplannedFailoverProviderSpecificInput implementation for HyperVReplicaAzureUnplannedFailoverInput.
func (hvraufi HyperVReplicaAzureUnplannedFailoverInput) AsInMageRcmUnplannedFailoverInput() (*InMageRcmUnplannedFailoverInput, bool) {
	return nil, false
}

// AsInMageUnplannedFailoverInput is the BasicUnplannedFailoverProviderSpecificInput implementation for HyperVReplicaAzureUnplannedFailoverInput.
func (hvraufi HyperVReplicaAzureUnplannedFailoverInput) AsInMageUnplannedFailoverInput() (*InMageUnplannedFailoverInput, bool) {
	return nil, false
}

// AsUnplannedFailoverProviderSpecificInput is the BasicUnplannedFailoverProviderSpecificInput implementation for HyperVReplicaAzureUnplannedFailoverInput.
func (hvraufi HyperVReplicaAzureUnplannedFailoverInput) AsUnplannedFailoverProviderSpecificInput() (*UnplannedFailoverProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicUnplannedFailoverProviderSpecificInput is the BasicUnplannedFailoverProviderSpecificInput implementation for HyperVReplicaAzureUnplannedFailoverInput.
func (hvraufi HyperVReplicaAzureUnplannedFailoverInput) AsBasicUnplannedFailoverProviderSpecificInput() (BasicUnplannedFailoverProviderSpecificInput, bool) {
	return &hvraufi, true
}

// HyperVReplicaAzureUpdateReplicationProtectedItemInput hyperV replica Azure input to update replication
// protected item.
type HyperVReplicaAzureUpdateReplicationProtectedItemInput struct {
	// RecoveryAzureV1ResourceGroupID - The recovery Azure resource group Id for classic deployment.
	RecoveryAzureV1ResourceGroupID *string `json:"recoveryAzureV1ResourceGroupId,omitempty"`
	// RecoveryAzureV2ResourceGroupID - The recovery Azure resource group Id for resource manager deployment.
	RecoveryAzureV2ResourceGroupID *string `json:"recoveryAzureV2ResourceGroupId,omitempty"`
	// UseManagedDisks - A value indicating whether managed disks should be used during failover.
	UseManagedDisks *string `json:"useManagedDisks,omitempty"`
	// DiskIDToDiskEncryptionMap - The dictionary of disk resource Id to disk encryption set ARM Id.
	DiskIDToDiskEncryptionMap map[string]*string `json:"diskIdToDiskEncryptionMap"`
	// TargetProximityPlacementGroupID - The target proximity placement group Id.
	TargetProximityPlacementGroupID *string `json:"targetProximityPlacementGroupId,omitempty"`
	// TargetAvailabilityZone - The target availability zone.
	TargetAvailabilityZone *string `json:"targetAvailabilityZone,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeUpdateReplicationProtectedItemProviderInput', 'InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeA2A', 'InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeInMageRcm'
	InstanceType InstanceTypeBasicUpdateReplicationProtectedItemProviderInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaAzureUpdateReplicationProtectedItemInput.
func (hvraurpii HyperVReplicaAzureUpdateReplicationProtectedItemInput) MarshalJSON() ([]byte, error) {
	hvraurpii.InstanceType = InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeHyperVReplicaAzure
	objectMap := make(map[string]interface{})
	if hvraurpii.RecoveryAzureV1ResourceGroupID != nil {
		objectMap["recoveryAzureV1ResourceGroupId"] = hvraurpii.RecoveryAzureV1ResourceGroupID
	}
	if hvraurpii.RecoveryAzureV2ResourceGroupID != nil {
		objectMap["recoveryAzureV2ResourceGroupId"] = hvraurpii.RecoveryAzureV2ResourceGroupID
	}
	if hvraurpii.UseManagedDisks != nil {
		objectMap["useManagedDisks"] = hvraurpii.UseManagedDisks
	}
	if hvraurpii.DiskIDToDiskEncryptionMap != nil {
		objectMap["diskIdToDiskEncryptionMap"] = hvraurpii.DiskIDToDiskEncryptionMap
	}
	if hvraurpii.TargetProximityPlacementGroupID != nil {
		objectMap["targetProximityPlacementGroupId"] = hvraurpii.TargetProximityPlacementGroupID
	}
	if hvraurpii.TargetAvailabilityZone != nil {
		objectMap["targetAvailabilityZone"] = hvraurpii.TargetAvailabilityZone
	}
	if hvraurpii.InstanceType != "" {
		objectMap["instanceType"] = hvraurpii.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AUpdateReplicationProtectedItemInput is the BasicUpdateReplicationProtectedItemProviderInput implementation for HyperVReplicaAzureUpdateReplicationProtectedItemInput.
func (hvraurpii HyperVReplicaAzureUpdateReplicationProtectedItemInput) AsA2AUpdateReplicationProtectedItemInput() (*A2AUpdateReplicationProtectedItemInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzureUpdateReplicationProtectedItemInput is the BasicUpdateReplicationProtectedItemProviderInput implementation for HyperVReplicaAzureUpdateReplicationProtectedItemInput.
func (hvraurpii HyperVReplicaAzureUpdateReplicationProtectedItemInput) AsHyperVReplicaAzureUpdateReplicationProtectedItemInput() (*HyperVReplicaAzureUpdateReplicationProtectedItemInput, bool) {
	return &hvraurpii, true
}

// AsInMageAzureV2UpdateReplicationProtectedItemInput is the BasicUpdateReplicationProtectedItemProviderInput implementation for HyperVReplicaAzureUpdateReplicationProtectedItemInput.
func (hvraurpii HyperVReplicaAzureUpdateReplicationProtectedItemInput) AsInMageAzureV2UpdateReplicationProtectedItemInput() (*InMageAzureV2UpdateReplicationProtectedItemInput, bool) {
	return nil, false
}

// AsInMageRcmUpdateReplicationProtectedItemInput is the BasicUpdateReplicationProtectedItemProviderInput implementation for HyperVReplicaAzureUpdateReplicationProtectedItemInput.
func (hvraurpii HyperVReplicaAzureUpdateReplicationProtectedItemInput) AsInMageRcmUpdateReplicationProtectedItemInput() (*InMageRcmUpdateReplicationProtectedItemInput, bool) {
	return nil, false
}

// AsUpdateReplicationProtectedItemProviderInput is the BasicUpdateReplicationProtectedItemProviderInput implementation for HyperVReplicaAzureUpdateReplicationProtectedItemInput.
func (hvraurpii HyperVReplicaAzureUpdateReplicationProtectedItemInput) AsUpdateReplicationProtectedItemProviderInput() (*UpdateReplicationProtectedItemProviderInput, bool) {
	return nil, false
}

// AsBasicUpdateReplicationProtectedItemProviderInput is the BasicUpdateReplicationProtectedItemProviderInput implementation for HyperVReplicaAzureUpdateReplicationProtectedItemInput.
func (hvraurpii HyperVReplicaAzureUpdateReplicationProtectedItemInput) AsBasicUpdateReplicationProtectedItemProviderInput() (BasicUpdateReplicationProtectedItemProviderInput, bool) {
	return &hvraurpii, true
}

// HyperVReplicaBaseEventDetails abstract model class for event details of a HyperVReplica E2E event.
type HyperVReplicaBaseEventDetails struct {
	// ContainerName - The container friendly name.
	ContainerName *string `json:"containerName,omitempty"`
	// FabricName - The fabric friendly name.
	FabricName *string `json:"fabricName,omitempty"`
	// RemoteContainerName - The remote container name.
	RemoteContainerName *string `json:"remoteContainerName,omitempty"`
	// RemoteFabricName - The remote fabric name.
	RemoteFabricName *string `json:"remoteFabricName,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeEventProviderSpecificDetails', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeA2A', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplicaBaseEventDetails', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeInMageAzureV2', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeInMageRcm'
	InstanceType InstanceTypeBasicEventProviderSpecificDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaBaseEventDetails.
func (hvrbed HyperVReplicaBaseEventDetails) MarshalJSON() ([]byte, error) {
	hvrbed.InstanceType = InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplicaBaseEventDetails
	objectMap := make(map[string]interface{})
	if hvrbed.ContainerName != nil {
		objectMap["containerName"] = hvrbed.ContainerName
	}
	if hvrbed.FabricName != nil {
		objectMap["fabricName"] = hvrbed.FabricName
	}
	if hvrbed.RemoteContainerName != nil {
		objectMap["remoteContainerName"] = hvrbed.RemoteContainerName
	}
	if hvrbed.RemoteFabricName != nil {
		objectMap["remoteFabricName"] = hvrbed.RemoteFabricName
	}
	if hvrbed.InstanceType != "" {
		objectMap["instanceType"] = hvrbed.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AEventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplicaBaseEventDetails.
func (hvrbed HyperVReplicaBaseEventDetails) AsA2AEventDetails() (*A2AEventDetails, bool) {
	return nil, false
}

// AsHyperVReplica2012EventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplicaBaseEventDetails.
func (hvrbed HyperVReplicaBaseEventDetails) AsHyperVReplica2012EventDetails() (*HyperVReplica2012EventDetails, bool) {
	return nil, false
}

// AsHyperVReplica2012R2EventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplicaBaseEventDetails.
func (hvrbed HyperVReplicaBaseEventDetails) AsHyperVReplica2012R2EventDetails() (*HyperVReplica2012R2EventDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzureEventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplicaBaseEventDetails.
func (hvrbed HyperVReplicaBaseEventDetails) AsHyperVReplicaAzureEventDetails() (*HyperVReplicaAzureEventDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBaseEventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplicaBaseEventDetails.
func (hvrbed HyperVReplicaBaseEventDetails) AsHyperVReplicaBaseEventDetails() (*HyperVReplicaBaseEventDetails, bool) {
	return &hvrbed, true
}

// AsInMageAzureV2EventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplicaBaseEventDetails.
func (hvrbed HyperVReplicaBaseEventDetails) AsInMageAzureV2EventDetails() (*InMageAzureV2EventDetails, bool) {
	return nil, false
}

// AsInMageRcmEventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplicaBaseEventDetails.
func (hvrbed HyperVReplicaBaseEventDetails) AsInMageRcmEventDetails() (*InMageRcmEventDetails, bool) {
	return nil, false
}

// AsEventProviderSpecificDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplicaBaseEventDetails.
func (hvrbed HyperVReplicaBaseEventDetails) AsEventProviderSpecificDetails() (*EventProviderSpecificDetails, bool) {
	return nil, false
}

// AsBasicEventProviderSpecificDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplicaBaseEventDetails.
func (hvrbed HyperVReplicaBaseEventDetails) AsBasicEventProviderSpecificDetails() (BasicEventProviderSpecificDetails, bool) {
	return &hvrbed, true
}

// HyperVReplicaBasePolicyDetails base class for HyperVReplica policy details.
type HyperVReplicaBasePolicyDetails struct {
	// RecoveryPoints - A value indicating the number of recovery points.
	RecoveryPoints *int32 `json:"recoveryPoints,omitempty"`
	// ApplicationConsistentSnapshotFrequencyInHours - A value indicating the application consistent frequency.
	ApplicationConsistentSnapshotFrequencyInHours *int32 `json:"applicationConsistentSnapshotFrequencyInHours,omitempty"`
	// Compression - A value indicating whether compression has to be enabled.
	Compression *string `json:"compression,omitempty"`
	// InitialReplicationMethod - A value indicating whether IR is online.
	InitialReplicationMethod *string `json:"initialReplicationMethod,omitempty"`
	// OnlineReplicationStartTime - A value indicating the online IR start time.
	OnlineReplicationStartTime *string `json:"onlineReplicationStartTime,omitempty"`
	// OfflineReplicationImportPath - A value indicating the offline IR import path.
	OfflineReplicationImportPath *string `json:"offlineReplicationImportPath,omitempty"`
	// OfflineReplicationExportPath - A value indicating the offline IR export path.
	OfflineReplicationExportPath *string `json:"offlineReplicationExportPath,omitempty"`
	// ReplicationPort - A value indicating the recovery HTTPS port.
	ReplicationPort *int32 `json:"replicationPort,omitempty"`
	// AllowedAuthenticationType - A value indicating the authentication type.
	AllowedAuthenticationType *int32 `json:"allowedAuthenticationType,omitempty"`
	// ReplicaDeletionOption - A value indicating whether the VM has to be auto deleted. Supported Values: String.Empty, None, OnRecoveryCloud
	ReplicaDeletionOption *string `json:"replicaDeletionOption,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypePolicyProviderSpecificDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeA2A', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaBasePolicyDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageAzureV2', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageBasePolicyDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMage', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageRcm', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeRcmAzureMigration', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeVMwareCbt'
	InstanceType InstanceTypeBasicPolicyProviderSpecificDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaBasePolicyDetails.
func (hvrbpd HyperVReplicaBasePolicyDetails) MarshalJSON() ([]byte, error) {
	hvrbpd.InstanceType = InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaBasePolicyDetails
	objectMap := make(map[string]interface{})
	if hvrbpd.RecoveryPoints != nil {
		objectMap["recoveryPoints"] = hvrbpd.RecoveryPoints
	}
	if hvrbpd.ApplicationConsistentSnapshotFrequencyInHours != nil {
		objectMap["applicationConsistentSnapshotFrequencyInHours"] = hvrbpd.ApplicationConsistentSnapshotFrequencyInHours
	}
	if hvrbpd.Compression != nil {
		objectMap["compression"] = hvrbpd.Compression
	}
	if hvrbpd.InitialReplicationMethod != nil {
		objectMap["initialReplicationMethod"] = hvrbpd.InitialReplicationMethod
	}
	if hvrbpd.OnlineReplicationStartTime != nil {
		objectMap["onlineReplicationStartTime"] = hvrbpd.OnlineReplicationStartTime
	}
	if hvrbpd.OfflineReplicationImportPath != nil {
		objectMap["offlineReplicationImportPath"] = hvrbpd.OfflineReplicationImportPath
	}
	if hvrbpd.OfflineReplicationExportPath != nil {
		objectMap["offlineReplicationExportPath"] = hvrbpd.OfflineReplicationExportPath
	}
	if hvrbpd.ReplicationPort != nil {
		objectMap["replicationPort"] = hvrbpd.ReplicationPort
	}
	if hvrbpd.AllowedAuthenticationType != nil {
		objectMap["allowedAuthenticationType"] = hvrbpd.AllowedAuthenticationType
	}
	if hvrbpd.ReplicaDeletionOption != nil {
		objectMap["replicaDeletionOption"] = hvrbpd.ReplicaDeletionOption
	}
	if hvrbpd.InstanceType != "" {
		objectMap["instanceType"] = hvrbpd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2APolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBasePolicyDetails.
func (hvrbpd HyperVReplicaBasePolicyDetails) AsA2APolicyDetails() (*A2APolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzurePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBasePolicyDetails.
func (hvrbpd HyperVReplicaBasePolicyDetails) AsHyperVReplicaAzurePolicyDetails() (*HyperVReplicaAzurePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBasePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBasePolicyDetails.
func (hvrbpd HyperVReplicaBasePolicyDetails) AsHyperVReplicaBasePolicyDetails() (*HyperVReplicaBasePolicyDetails, bool) {
	return &hvrbpd, true
}

// AsHyperVReplicaBluePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBasePolicyDetails.
func (hvrbpd HyperVReplicaBasePolicyDetails) AsHyperVReplicaBluePolicyDetails() (*HyperVReplicaBluePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBasePolicyDetails.
func (hvrbpd HyperVReplicaBasePolicyDetails) AsHyperVReplicaPolicyDetails() (*HyperVReplicaPolicyDetails, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBasePolicyDetails.
func (hvrbpd HyperVReplicaBasePolicyDetails) AsInMageAzureV2PolicyDetails() (*InMageAzureV2PolicyDetails, bool) {
	return nil, false
}

// AsInMageBasePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBasePolicyDetails.
func (hvrbpd HyperVReplicaBasePolicyDetails) AsInMageBasePolicyDetails() (*InMageBasePolicyDetails, bool) {
	return nil, false
}

// AsInMagePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBasePolicyDetails.
func (hvrbpd HyperVReplicaBasePolicyDetails) AsInMagePolicyDetails() (*InMagePolicyDetails, bool) {
	return nil, false
}

// AsInMageRcmPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBasePolicyDetails.
func (hvrbpd HyperVReplicaBasePolicyDetails) AsInMageRcmPolicyDetails() (*InMageRcmPolicyDetails, bool) {
	return nil, false
}

// AsRcmAzureMigrationPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBasePolicyDetails.
func (hvrbpd HyperVReplicaBasePolicyDetails) AsRcmAzureMigrationPolicyDetails() (*RcmAzureMigrationPolicyDetails, bool) {
	return nil, false
}

// AsVmwareCbtPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBasePolicyDetails.
func (hvrbpd HyperVReplicaBasePolicyDetails) AsVmwareCbtPolicyDetails() (*VmwareCbtPolicyDetails, bool) {
	return nil, false
}

// AsPolicyProviderSpecificDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBasePolicyDetails.
func (hvrbpd HyperVReplicaBasePolicyDetails) AsPolicyProviderSpecificDetails() (*PolicyProviderSpecificDetails, bool) {
	return nil, false
}

// AsBasicPolicyProviderSpecificDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBasePolicyDetails.
func (hvrbpd HyperVReplicaBasePolicyDetails) AsBasicPolicyProviderSpecificDetails() (BasicPolicyProviderSpecificDetails, bool) {
	return &hvrbpd, true
}

// HyperVReplicaBaseReplicationDetails hyper V replica provider specific settings base class.
type HyperVReplicaBaseReplicationDetails struct {
	// LastReplicatedTime - The Last replication time.
	LastReplicatedTime *date.Time `json:"lastReplicatedTime,omitempty"`
	// VMNics - The PE Network details.
	VMNics *[]VMNicDetails `json:"vmNics,omitempty"`
	// VMID - The virtual machine Id.
	VMID *string `json:"vmId,omitempty"`
	// VMProtectionState - The protection state for the vm.
	VMProtectionState *string `json:"vmProtectionState,omitempty"`
	// VMProtectionStateDescription - The protection state description for the vm.
	VMProtectionStateDescription *string `json:"vmProtectionStateDescription,omitempty"`
	// InitialReplicationDetails - Initial replication details.
	InitialReplicationDetails *InitialReplicationDetails `json:"initialReplicationDetails,omitempty"`
	// VMDiskDetails - VM disk details.
	VMDiskDetails *[]DiskDetails `json:"vMDiskDetails,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeReplicationProviderSpecificSettings', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeA2A', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaBaseReplicationDetails', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMageAzureV2', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMageRcm', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMage'
	InstanceType InstanceTypeBasicReplicationProviderSpecificSettings `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaBaseReplicationDetails.
func (hvrbrd HyperVReplicaBaseReplicationDetails) MarshalJSON() ([]byte, error) {
	hvrbrd.InstanceType = InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaBaseReplicationDetails
	objectMap := make(map[string]interface{})
	if hvrbrd.LastReplicatedTime != nil {
		objectMap["lastReplicatedTime"] = hvrbrd.LastReplicatedTime
	}
	if hvrbrd.VMNics != nil {
		objectMap["vmNics"] = hvrbrd.VMNics
	}
	if hvrbrd.VMID != nil {
		objectMap["vmId"] = hvrbrd.VMID
	}
	if hvrbrd.VMProtectionState != nil {
		objectMap["vmProtectionState"] = hvrbrd.VMProtectionState
	}
	if hvrbrd.VMProtectionStateDescription != nil {
		objectMap["vmProtectionStateDescription"] = hvrbrd.VMProtectionStateDescription
	}
	if hvrbrd.InitialReplicationDetails != nil {
		objectMap["initialReplicationDetails"] = hvrbrd.InitialReplicationDetails
	}
	if hvrbrd.VMDiskDetails != nil {
		objectMap["vMDiskDetails"] = hvrbrd.VMDiskDetails
	}
	if hvrbrd.InstanceType != "" {
		objectMap["instanceType"] = hvrbrd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaBaseReplicationDetails.
func (hvrbrd HyperVReplicaBaseReplicationDetails) AsA2AReplicationDetails() (*A2AReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzureReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaBaseReplicationDetails.
func (hvrbrd HyperVReplicaBaseReplicationDetails) AsHyperVReplicaAzureReplicationDetails() (*HyperVReplicaAzureReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBaseReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaBaseReplicationDetails.
func (hvrbrd HyperVReplicaBaseReplicationDetails) AsHyperVReplicaBaseReplicationDetails() (*HyperVReplicaBaseReplicationDetails, bool) {
	return &hvrbrd, true
}

// AsHyperVReplicaBlueReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaBaseReplicationDetails.
func (hvrbrd HyperVReplicaBaseReplicationDetails) AsHyperVReplicaBlueReplicationDetails() (*HyperVReplicaBlueReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaBaseReplicationDetails.
func (hvrbrd HyperVReplicaBaseReplicationDetails) AsHyperVReplicaReplicationDetails() (*HyperVReplicaReplicationDetails, bool) {
	return nil, false
}

// AsInMageAzureV2ReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaBaseReplicationDetails.
func (hvrbrd HyperVReplicaBaseReplicationDetails) AsInMageAzureV2ReplicationDetails() (*InMageAzureV2ReplicationDetails, bool) {
	return nil, false
}

// AsInMageRcmReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaBaseReplicationDetails.
func (hvrbrd HyperVReplicaBaseReplicationDetails) AsInMageRcmReplicationDetails() (*InMageRcmReplicationDetails, bool) {
	return nil, false
}

// AsInMageReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaBaseReplicationDetails.
func (hvrbrd HyperVReplicaBaseReplicationDetails) AsInMageReplicationDetails() (*InMageReplicationDetails, bool) {
	return nil, false
}

// AsReplicationProviderSpecificSettings is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaBaseReplicationDetails.
func (hvrbrd HyperVReplicaBaseReplicationDetails) AsReplicationProviderSpecificSettings() (*ReplicationProviderSpecificSettings, bool) {
	return nil, false
}

// AsBasicReplicationProviderSpecificSettings is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaBaseReplicationDetails.
func (hvrbrd HyperVReplicaBaseReplicationDetails) AsBasicReplicationProviderSpecificSettings() (BasicReplicationProviderSpecificSettings, bool) {
	return &hvrbrd, true
}

// HyperVReplicaBluePolicyDetails hyper-V Replica Blue specific protection profile details.
type HyperVReplicaBluePolicyDetails struct {
	// ReplicationFrequencyInSeconds - A value indicating the replication interval.
	ReplicationFrequencyInSeconds *int32 `json:"replicationFrequencyInSeconds,omitempty"`
	// RecoveryPoints - A value indicating the number of recovery points.
	RecoveryPoints *int32 `json:"recoveryPoints,omitempty"`
	// ApplicationConsistentSnapshotFrequencyInHours - A value indicating the application consistent frequency.
	ApplicationConsistentSnapshotFrequencyInHours *int32 `json:"applicationConsistentSnapshotFrequencyInHours,omitempty"`
	// Compression - A value indicating whether compression has to be enabled.
	Compression *string `json:"compression,omitempty"`
	// InitialReplicationMethod - A value indicating whether IR is online.
	InitialReplicationMethod *string `json:"initialReplicationMethod,omitempty"`
	// OnlineReplicationStartTime - A value indicating the online IR start time.
	OnlineReplicationStartTime *string `json:"onlineReplicationStartTime,omitempty"`
	// OfflineReplicationImportPath - A value indicating the offline IR import path.
	OfflineReplicationImportPath *string `json:"offlineReplicationImportPath,omitempty"`
	// OfflineReplicationExportPath - A value indicating the offline IR export path.
	OfflineReplicationExportPath *string `json:"offlineReplicationExportPath,omitempty"`
	// ReplicationPort - A value indicating the recovery HTTPS port.
	ReplicationPort *int32 `json:"replicationPort,omitempty"`
	// AllowedAuthenticationType - A value indicating the authentication type.
	AllowedAuthenticationType *int32 `json:"allowedAuthenticationType,omitempty"`
	// ReplicaDeletionOption - A value indicating whether the VM has to be auto deleted. Supported Values: String.Empty, None, OnRecoveryCloud
	ReplicaDeletionOption *string `json:"replicaDeletionOption,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypePolicyProviderSpecificDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeA2A', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaBasePolicyDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageAzureV2', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageBasePolicyDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMage', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageRcm', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeRcmAzureMigration', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeVMwareCbt'
	InstanceType InstanceTypeBasicPolicyProviderSpecificDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaBluePolicyDetails.
func (hvrbpd HyperVReplicaBluePolicyDetails) MarshalJSON() ([]byte, error) {
	hvrbpd.InstanceType = InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012R2
	objectMap := make(map[string]interface{})
	if hvrbpd.ReplicationFrequencyInSeconds != nil {
		objectMap["replicationFrequencyInSeconds"] = hvrbpd.ReplicationFrequencyInSeconds
	}
	if hvrbpd.RecoveryPoints != nil {
		objectMap["recoveryPoints"] = hvrbpd.RecoveryPoints
	}
	if hvrbpd.ApplicationConsistentSnapshotFrequencyInHours != nil {
		objectMap["applicationConsistentSnapshotFrequencyInHours"] = hvrbpd.ApplicationConsistentSnapshotFrequencyInHours
	}
	if hvrbpd.Compression != nil {
		objectMap["compression"] = hvrbpd.Compression
	}
	if hvrbpd.InitialReplicationMethod != nil {
		objectMap["initialReplicationMethod"] = hvrbpd.InitialReplicationMethod
	}
	if hvrbpd.OnlineReplicationStartTime != nil {
		objectMap["onlineReplicationStartTime"] = hvrbpd.OnlineReplicationStartTime
	}
	if hvrbpd.OfflineReplicationImportPath != nil {
		objectMap["offlineReplicationImportPath"] = hvrbpd.OfflineReplicationImportPath
	}
	if hvrbpd.OfflineReplicationExportPath != nil {
		objectMap["offlineReplicationExportPath"] = hvrbpd.OfflineReplicationExportPath
	}
	if hvrbpd.ReplicationPort != nil {
		objectMap["replicationPort"] = hvrbpd.ReplicationPort
	}
	if hvrbpd.AllowedAuthenticationType != nil {
		objectMap["allowedAuthenticationType"] = hvrbpd.AllowedAuthenticationType
	}
	if hvrbpd.ReplicaDeletionOption != nil {
		objectMap["replicaDeletionOption"] = hvrbpd.ReplicaDeletionOption
	}
	if hvrbpd.InstanceType != "" {
		objectMap["instanceType"] = hvrbpd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2APolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBluePolicyDetails.
func (hvrbpd HyperVReplicaBluePolicyDetails) AsA2APolicyDetails() (*A2APolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzurePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBluePolicyDetails.
func (hvrbpd HyperVReplicaBluePolicyDetails) AsHyperVReplicaAzurePolicyDetails() (*HyperVReplicaAzurePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBasePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBluePolicyDetails.
func (hvrbpd HyperVReplicaBluePolicyDetails) AsHyperVReplicaBasePolicyDetails() (*HyperVReplicaBasePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBluePolicyDetails.
func (hvrbpd HyperVReplicaBluePolicyDetails) AsHyperVReplicaBluePolicyDetails() (*HyperVReplicaBluePolicyDetails, bool) {
	return &hvrbpd, true
}

// AsHyperVReplicaPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBluePolicyDetails.
func (hvrbpd HyperVReplicaBluePolicyDetails) AsHyperVReplicaPolicyDetails() (*HyperVReplicaPolicyDetails, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBluePolicyDetails.
func (hvrbpd HyperVReplicaBluePolicyDetails) AsInMageAzureV2PolicyDetails() (*InMageAzureV2PolicyDetails, bool) {
	return nil, false
}

// AsInMageBasePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBluePolicyDetails.
func (hvrbpd HyperVReplicaBluePolicyDetails) AsInMageBasePolicyDetails() (*InMageBasePolicyDetails, bool) {
	return nil, false
}

// AsInMagePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBluePolicyDetails.
func (hvrbpd HyperVReplicaBluePolicyDetails) AsInMagePolicyDetails() (*InMagePolicyDetails, bool) {
	return nil, false
}

// AsInMageRcmPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBluePolicyDetails.
func (hvrbpd HyperVReplicaBluePolicyDetails) AsInMageRcmPolicyDetails() (*InMageRcmPolicyDetails, bool) {
	return nil, false
}

// AsRcmAzureMigrationPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBluePolicyDetails.
func (hvrbpd HyperVReplicaBluePolicyDetails) AsRcmAzureMigrationPolicyDetails() (*RcmAzureMigrationPolicyDetails, bool) {
	return nil, false
}

// AsVmwareCbtPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBluePolicyDetails.
func (hvrbpd HyperVReplicaBluePolicyDetails) AsVmwareCbtPolicyDetails() (*VmwareCbtPolicyDetails, bool) {
	return nil, false
}

// AsPolicyProviderSpecificDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBluePolicyDetails.
func (hvrbpd HyperVReplicaBluePolicyDetails) AsPolicyProviderSpecificDetails() (*PolicyProviderSpecificDetails, bool) {
	return nil, false
}

// AsBasicPolicyProviderSpecificDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBluePolicyDetails.
func (hvrbpd HyperVReplicaBluePolicyDetails) AsBasicPolicyProviderSpecificDetails() (BasicPolicyProviderSpecificDetails, bool) {
	return &hvrbpd, true
}

// HyperVReplicaBluePolicyInput hyperV Replica Blue policy input.
type HyperVReplicaBluePolicyInput struct {
	// ReplicationFrequencyInSeconds - A value indicating the replication interval.
	ReplicationFrequencyInSeconds *int32 `json:"replicationFrequencyInSeconds,omitempty"`
	// RecoveryPoints - A value indicating the number of recovery points.
	RecoveryPoints *int32 `json:"recoveryPoints,omitempty"`
	// ApplicationConsistentSnapshotFrequencyInHours - A value indicating the application consistent frequency.
	ApplicationConsistentSnapshotFrequencyInHours *int32 `json:"applicationConsistentSnapshotFrequencyInHours,omitempty"`
	// Compression - A value indicating whether compression has to be enabled.
	Compression *string `json:"compression,omitempty"`
	// InitialReplicationMethod - A value indicating whether IR is online.
	InitialReplicationMethod *string `json:"initialReplicationMethod,omitempty"`
	// OnlineReplicationStartTime - A value indicating the online IR start time.
	OnlineReplicationStartTime *string `json:"onlineReplicationStartTime,omitempty"`
	// OfflineReplicationImportPath - A value indicating the offline IR import path.
	OfflineReplicationImportPath *string `json:"offlineReplicationImportPath,omitempty"`
	// OfflineReplicationExportPath - A value indicating the offline IR export path.
	OfflineReplicationExportPath *string `json:"offlineReplicationExportPath,omitempty"`
	// ReplicationPort - A value indicating the recovery HTTPS port.
	ReplicationPort *int32 `json:"replicationPort,omitempty"`
	// AllowedAuthenticationType - A value indicating the authentication type.
	AllowedAuthenticationType *int32 `json:"allowedAuthenticationType,omitempty"`
	// ReplicaDeletion - A value indicating whether the VM has to be auto deleted.
	ReplicaDeletion *string `json:"replicaDeletion,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypePolicyProviderSpecificInput', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeA2A', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMage', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMageRcm', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeVMwareCbt'
	InstanceType InstanceTypeBasicPolicyProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaBluePolicyInput.
func (hvrbpi HyperVReplicaBluePolicyInput) MarshalJSON() ([]byte, error) {
	hvrbpi.InstanceType = InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012R2
	objectMap := make(map[string]interface{})
	if hvrbpi.ReplicationFrequencyInSeconds != nil {
		objectMap["replicationFrequencyInSeconds"] = hvrbpi.ReplicationFrequencyInSeconds
	}
	if hvrbpi.RecoveryPoints != nil {
		objectMap["recoveryPoints"] = hvrbpi.RecoveryPoints
	}
	if hvrbpi.ApplicationConsistentSnapshotFrequencyInHours != nil {
		objectMap["applicationConsistentSnapshotFrequencyInHours"] = hvrbpi.ApplicationConsistentSnapshotFrequencyInHours
	}
	if hvrbpi.Compression != nil {
		objectMap["compression"] = hvrbpi.Compression
	}
	if hvrbpi.InitialReplicationMethod != nil {
		objectMap["initialReplicationMethod"] = hvrbpi.InitialReplicationMethod
	}
	if hvrbpi.OnlineReplicationStartTime != nil {
		objectMap["onlineReplicationStartTime"] = hvrbpi.OnlineReplicationStartTime
	}
	if hvrbpi.OfflineReplicationImportPath != nil {
		objectMap["offlineReplicationImportPath"] = hvrbpi.OfflineReplicationImportPath
	}
	if hvrbpi.OfflineReplicationExportPath != nil {
		objectMap["offlineReplicationExportPath"] = hvrbpi.OfflineReplicationExportPath
	}
	if hvrbpi.ReplicationPort != nil {
		objectMap["replicationPort"] = hvrbpi.ReplicationPort
	}
	if hvrbpi.AllowedAuthenticationType != nil {
		objectMap["allowedAuthenticationType"] = hvrbpi.AllowedAuthenticationType
	}
	if hvrbpi.ReplicaDeletion != nil {
		objectMap["replicaDeletion"] = hvrbpi.ReplicaDeletion
	}
	if hvrbpi.InstanceType != "" {
		objectMap["instanceType"] = hvrbpi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2APolicyCreationInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaBluePolicyInput.
func (hvrbpi HyperVReplicaBluePolicyInput) AsA2APolicyCreationInput() (*A2APolicyCreationInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzurePolicyInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaBluePolicyInput.
func (hvrbpi HyperVReplicaBluePolicyInput) AsHyperVReplicaAzurePolicyInput() (*HyperVReplicaAzurePolicyInput, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaBluePolicyInput.
func (hvrbpi HyperVReplicaBluePolicyInput) AsHyperVReplicaBluePolicyInput() (*HyperVReplicaBluePolicyInput, bool) {
	return &hvrbpi, true
}

// AsHyperVReplicaPolicyInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaBluePolicyInput.
func (hvrbpi HyperVReplicaBluePolicyInput) AsHyperVReplicaPolicyInput() (*HyperVReplicaPolicyInput, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaBluePolicyInput.
func (hvrbpi HyperVReplicaBluePolicyInput) AsInMageAzureV2PolicyInput() (*InMageAzureV2PolicyInput, bool) {
	return nil, false
}

// AsInMagePolicyInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaBluePolicyInput.
func (hvrbpi HyperVReplicaBluePolicyInput) AsInMagePolicyInput() (*InMagePolicyInput, bool) {
	return nil, false
}

// AsInMageRcmPolicyCreationInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaBluePolicyInput.
func (hvrbpi HyperVReplicaBluePolicyInput) AsInMageRcmPolicyCreationInput() (*InMageRcmPolicyCreationInput, bool) {
	return nil, false
}

// AsVMwareCbtPolicyCreationInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaBluePolicyInput.
func (hvrbpi HyperVReplicaBluePolicyInput) AsVMwareCbtPolicyCreationInput() (*VMwareCbtPolicyCreationInput, bool) {
	return nil, false
}

// AsPolicyProviderSpecificInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaBluePolicyInput.
func (hvrbpi HyperVReplicaBluePolicyInput) AsPolicyProviderSpecificInput() (*PolicyProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicPolicyProviderSpecificInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaBluePolicyInput.
func (hvrbpi HyperVReplicaBluePolicyInput) AsBasicPolicyProviderSpecificInput() (BasicPolicyProviderSpecificInput, bool) {
	return &hvrbpi, true
}

// HyperVReplicaBlueReplicationDetails hyperV replica 2012 R2 (Blue) replication details.
type HyperVReplicaBlueReplicationDetails struct {
	// LastReplicatedTime - The Last replication time.
	LastReplicatedTime *date.Time `json:"lastReplicatedTime,omitempty"`
	// VMNics - The PE Network details.
	VMNics *[]VMNicDetails `json:"vmNics,omitempty"`
	// VMID - The virtual machine Id.
	VMID *string `json:"vmId,omitempty"`
	// VMProtectionState - The protection state for the vm.
	VMProtectionState *string `json:"vmProtectionState,omitempty"`
	// VMProtectionStateDescription - The protection state description for the vm.
	VMProtectionStateDescription *string `json:"vmProtectionStateDescription,omitempty"`
	// InitialReplicationDetails - Initial replication details.
	InitialReplicationDetails *InitialReplicationDetails `json:"initialReplicationDetails,omitempty"`
	// VMDiskDetails - VM disk details.
	VMDiskDetails *[]DiskDetails `json:"vMDiskDetails,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeReplicationProviderSpecificSettings', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeA2A', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaBaseReplicationDetails', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMageAzureV2', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMageRcm', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMage'
	InstanceType InstanceTypeBasicReplicationProviderSpecificSettings `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaBlueReplicationDetails.
func (hvrbrd HyperVReplicaBlueReplicationDetails) MarshalJSON() ([]byte, error) {
	hvrbrd.InstanceType = InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012R2
	objectMap := make(map[string]interface{})
	if hvrbrd.LastReplicatedTime != nil {
		objectMap["lastReplicatedTime"] = hvrbrd.LastReplicatedTime
	}
	if hvrbrd.VMNics != nil {
		objectMap["vmNics"] = hvrbrd.VMNics
	}
	if hvrbrd.VMID != nil {
		objectMap["vmId"] = hvrbrd.VMID
	}
	if hvrbrd.VMProtectionState != nil {
		objectMap["vmProtectionState"] = hvrbrd.VMProtectionState
	}
	if hvrbrd.VMProtectionStateDescription != nil {
		objectMap["vmProtectionStateDescription"] = hvrbrd.VMProtectionStateDescription
	}
	if hvrbrd.InitialReplicationDetails != nil {
		objectMap["initialReplicationDetails"] = hvrbrd.InitialReplicationDetails
	}
	if hvrbrd.VMDiskDetails != nil {
		objectMap["vMDiskDetails"] = hvrbrd.VMDiskDetails
	}
	if hvrbrd.InstanceType != "" {
		objectMap["instanceType"] = hvrbrd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaBlueReplicationDetails.
func (hvrbrd HyperVReplicaBlueReplicationDetails) AsA2AReplicationDetails() (*A2AReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzureReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaBlueReplicationDetails.
func (hvrbrd HyperVReplicaBlueReplicationDetails) AsHyperVReplicaAzureReplicationDetails() (*HyperVReplicaAzureReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBaseReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaBlueReplicationDetails.
func (hvrbrd HyperVReplicaBlueReplicationDetails) AsHyperVReplicaBaseReplicationDetails() (*HyperVReplicaBaseReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBlueReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaBlueReplicationDetails.
func (hvrbrd HyperVReplicaBlueReplicationDetails) AsHyperVReplicaBlueReplicationDetails() (*HyperVReplicaBlueReplicationDetails, bool) {
	return &hvrbrd, true
}

// AsHyperVReplicaReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaBlueReplicationDetails.
func (hvrbrd HyperVReplicaBlueReplicationDetails) AsHyperVReplicaReplicationDetails() (*HyperVReplicaReplicationDetails, bool) {
	return nil, false
}

// AsInMageAzureV2ReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaBlueReplicationDetails.
func (hvrbrd HyperVReplicaBlueReplicationDetails) AsInMageAzureV2ReplicationDetails() (*InMageAzureV2ReplicationDetails, bool) {
	return nil, false
}

// AsInMageRcmReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaBlueReplicationDetails.
func (hvrbrd HyperVReplicaBlueReplicationDetails) AsInMageRcmReplicationDetails() (*InMageRcmReplicationDetails, bool) {
	return nil, false
}

// AsInMageReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaBlueReplicationDetails.
func (hvrbrd HyperVReplicaBlueReplicationDetails) AsInMageReplicationDetails() (*InMageReplicationDetails, bool) {
	return nil, false
}

// AsReplicationProviderSpecificSettings is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaBlueReplicationDetails.
func (hvrbrd HyperVReplicaBlueReplicationDetails) AsReplicationProviderSpecificSettings() (*ReplicationProviderSpecificSettings, bool) {
	return nil, false
}

// AsBasicReplicationProviderSpecificSettings is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaBlueReplicationDetails.
func (hvrbrd HyperVReplicaBlueReplicationDetails) AsBasicReplicationProviderSpecificSettings() (BasicReplicationProviderSpecificSettings, bool) {
	return &hvrbrd, true
}

// HyperVReplicaPolicyDetails hyper-V Replica Blue specific protection profile details.
type HyperVReplicaPolicyDetails struct {
	// RecoveryPoints - A value indicating the number of recovery points.
	RecoveryPoints *int32 `json:"recoveryPoints,omitempty"`
	// ApplicationConsistentSnapshotFrequencyInHours - A value indicating the application consistent frequency.
	ApplicationConsistentSnapshotFrequencyInHours *int32 `json:"applicationConsistentSnapshotFrequencyInHours,omitempty"`
	// Compression - A value indicating whether compression has to be enabled.
	Compression *string `json:"compression,omitempty"`
	// InitialReplicationMethod - A value indicating whether IR is online.
	InitialReplicationMethod *string `json:"initialReplicationMethod,omitempty"`
	// OnlineReplicationStartTime - A value indicating the online IR start time.
	OnlineReplicationStartTime *string `json:"onlineReplicationStartTime,omitempty"`
	// OfflineReplicationImportPath - A value indicating the offline IR import path.
	OfflineReplicationImportPath *string `json:"offlineReplicationImportPath,omitempty"`
	// OfflineReplicationExportPath - A value indicating the offline IR export path.
	OfflineReplicationExportPath *string `json:"offlineReplicationExportPath,omitempty"`
	// ReplicationPort - A value indicating the recovery HTTPS port.
	ReplicationPort *int32 `json:"replicationPort,omitempty"`
	// AllowedAuthenticationType - A value indicating the authentication type.
	AllowedAuthenticationType *int32 `json:"allowedAuthenticationType,omitempty"`
	// ReplicaDeletionOption - A value indicating whether the VM has to be auto deleted. Supported Values: String.Empty, None, OnRecoveryCloud
	ReplicaDeletionOption *string `json:"replicaDeletionOption,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypePolicyProviderSpecificDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeA2A', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaBasePolicyDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageAzureV2', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageBasePolicyDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMage', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageRcm', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeRcmAzureMigration', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeVMwareCbt'
	InstanceType InstanceTypeBasicPolicyProviderSpecificDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaPolicyDetails.
func (hvrpd HyperVReplicaPolicyDetails) MarshalJSON() ([]byte, error) {
	hvrpd.InstanceType = InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012
	objectMap := make(map[string]interface{})
	if hvrpd.RecoveryPoints != nil {
		objectMap["recoveryPoints"] = hvrpd.RecoveryPoints
	}
	if hvrpd.ApplicationConsistentSnapshotFrequencyInHours != nil {
		objectMap["applicationConsistentSnapshotFrequencyInHours"] = hvrpd.ApplicationConsistentSnapshotFrequencyInHours
	}
	if hvrpd.Compression != nil {
		objectMap["compression"] = hvrpd.Compression
	}
	if hvrpd.InitialReplicationMethod != nil {
		objectMap["initialReplicationMethod"] = hvrpd.InitialReplicationMethod
	}
	if hvrpd.OnlineReplicationStartTime != nil {
		objectMap["onlineReplicationStartTime"] = hvrpd.OnlineReplicationStartTime
	}
	if hvrpd.OfflineReplicationImportPath != nil {
		objectMap["offlineReplicationImportPath"] = hvrpd.OfflineReplicationImportPath
	}
	if hvrpd.OfflineReplicationExportPath != nil {
		objectMap["offlineReplicationExportPath"] = hvrpd.OfflineReplicationExportPath
	}
	if hvrpd.ReplicationPort != nil {
		objectMap["replicationPort"] = hvrpd.ReplicationPort
	}
	if hvrpd.AllowedAuthenticationType != nil {
		objectMap["allowedAuthenticationType"] = hvrpd.AllowedAuthenticationType
	}
	if hvrpd.ReplicaDeletionOption != nil {
		objectMap["replicaDeletionOption"] = hvrpd.ReplicaDeletionOption
	}
	if hvrpd.InstanceType != "" {
		objectMap["instanceType"] = hvrpd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2APolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaPolicyDetails.
func (hvrpd HyperVReplicaPolicyDetails) AsA2APolicyDetails() (*A2APolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzurePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaPolicyDetails.
func (hvrpd HyperVReplicaPolicyDetails) AsHyperVReplicaAzurePolicyDetails() (*HyperVReplicaAzurePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBasePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaPolicyDetails.
func (hvrpd HyperVReplicaPolicyDetails) AsHyperVReplicaBasePolicyDetails() (*HyperVReplicaBasePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaPolicyDetails.
func (hvrpd HyperVReplicaPolicyDetails) AsHyperVReplicaBluePolicyDetails() (*HyperVReplicaBluePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaPolicyDetails.
func (hvrpd HyperVReplicaPolicyDetails) AsHyperVReplicaPolicyDetails() (*HyperVReplicaPolicyDetails, bool) {
	return &hvrpd, true
}

// AsInMageAzureV2PolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaPolicyDetails.
func (hvrpd HyperVReplicaPolicyDetails) AsInMageAzureV2PolicyDetails() (*InMageAzureV2PolicyDetails, bool) {
	return nil, false
}

// AsInMageBasePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaPolicyDetails.
func (hvrpd HyperVReplicaPolicyDetails) AsInMageBasePolicyDetails() (*InMageBasePolicyDetails, bool) {
	return nil, false
}

// AsInMagePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaPolicyDetails.
func (hvrpd HyperVReplicaPolicyDetails) AsInMagePolicyDetails() (*InMagePolicyDetails, bool) {
	return nil, false
}

// AsInMageRcmPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaPolicyDetails.
func (hvrpd HyperVReplicaPolicyDetails) AsInMageRcmPolicyDetails() (*InMageRcmPolicyDetails, bool) {
	return nil, false
}

// AsRcmAzureMigrationPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaPolicyDetails.
func (hvrpd HyperVReplicaPolicyDetails) AsRcmAzureMigrationPolicyDetails() (*RcmAzureMigrationPolicyDetails, bool) {
	return nil, false
}

// AsVmwareCbtPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaPolicyDetails.
func (hvrpd HyperVReplicaPolicyDetails) AsVmwareCbtPolicyDetails() (*VmwareCbtPolicyDetails, bool) {
	return nil, false
}

// AsPolicyProviderSpecificDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaPolicyDetails.
func (hvrpd HyperVReplicaPolicyDetails) AsPolicyProviderSpecificDetails() (*PolicyProviderSpecificDetails, bool) {
	return nil, false
}

// AsBasicPolicyProviderSpecificDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaPolicyDetails.
func (hvrpd HyperVReplicaPolicyDetails) AsBasicPolicyProviderSpecificDetails() (BasicPolicyProviderSpecificDetails, bool) {
	return &hvrpd, true
}

// HyperVReplicaPolicyInput hyper-V Replica specific policy Input.
type HyperVReplicaPolicyInput struct {
	// RecoveryPoints - A value indicating the number of recovery points.
	RecoveryPoints *int32 `json:"recoveryPoints,omitempty"`
	// ApplicationConsistentSnapshotFrequencyInHours - A value indicating the application consistent frequency.
	ApplicationConsistentSnapshotFrequencyInHours *int32 `json:"applicationConsistentSnapshotFrequencyInHours,omitempty"`
	// Compression - A value indicating whether compression has to be enabled.
	Compression *string `json:"compression,omitempty"`
	// InitialReplicationMethod - A value indicating whether IR is online.
	InitialReplicationMethod *string `json:"initialReplicationMethod,omitempty"`
	// OnlineReplicationStartTime - A value indicating the online IR start time.
	OnlineReplicationStartTime *string `json:"onlineReplicationStartTime,omitempty"`
	// OfflineReplicationImportPath - A value indicating the offline IR import path.
	OfflineReplicationImportPath *string `json:"offlineReplicationImportPath,omitempty"`
	// OfflineReplicationExportPath - A value indicating the offline IR export path.
	OfflineReplicationExportPath *string `json:"offlineReplicationExportPath,omitempty"`
	// ReplicationPort - A value indicating the recovery HTTPS port.
	ReplicationPort *int32 `json:"replicationPort,omitempty"`
	// AllowedAuthenticationType - A value indicating the authentication type.
	AllowedAuthenticationType *int32 `json:"allowedAuthenticationType,omitempty"`
	// ReplicaDeletion - A value indicating whether the VM has to be auto deleted.
	ReplicaDeletion *string `json:"replicaDeletion,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypePolicyProviderSpecificInput', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeA2A', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMage', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMageRcm', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeVMwareCbt'
	InstanceType InstanceTypeBasicPolicyProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaPolicyInput.
func (hvrpi HyperVReplicaPolicyInput) MarshalJSON() ([]byte, error) {
	hvrpi.InstanceType = InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012
	objectMap := make(map[string]interface{})
	if hvrpi.RecoveryPoints != nil {
		objectMap["recoveryPoints"] = hvrpi.RecoveryPoints
	}
	if hvrpi.ApplicationConsistentSnapshotFrequencyInHours != nil {
		objectMap["applicationConsistentSnapshotFrequencyInHours"] = hvrpi.ApplicationConsistentSnapshotFrequencyInHours
	}
	if hvrpi.Compression != nil {
		objectMap["compression"] = hvrpi.Compression
	}
	if hvrpi.InitialReplicationMethod != nil {
		objectMap["initialReplicationMethod"] = hvrpi.InitialReplicationMethod
	}
	if hvrpi.OnlineReplicationStartTime != nil {
		objectMap["onlineReplicationStartTime"] = hvrpi.OnlineReplicationStartTime
	}
	if hvrpi.OfflineReplicationImportPath != nil {
		objectMap["offlineReplicationImportPath"] = hvrpi.OfflineReplicationImportPath
	}
	if hvrpi.OfflineReplicationExportPath != nil {
		objectMap["offlineReplicationExportPath"] = hvrpi.OfflineReplicationExportPath
	}
	if hvrpi.ReplicationPort != nil {
		objectMap["replicationPort"] = hvrpi.ReplicationPort
	}
	if hvrpi.AllowedAuthenticationType != nil {
		objectMap["allowedAuthenticationType"] = hvrpi.AllowedAuthenticationType
	}
	if hvrpi.ReplicaDeletion != nil {
		objectMap["replicaDeletion"] = hvrpi.ReplicaDeletion
	}
	if hvrpi.InstanceType != "" {
		objectMap["instanceType"] = hvrpi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2APolicyCreationInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaPolicyInput.
func (hvrpi HyperVReplicaPolicyInput) AsA2APolicyCreationInput() (*A2APolicyCreationInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzurePolicyInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaPolicyInput.
func (hvrpi HyperVReplicaPolicyInput) AsHyperVReplicaAzurePolicyInput() (*HyperVReplicaAzurePolicyInput, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaPolicyInput.
func (hvrpi HyperVReplicaPolicyInput) AsHyperVReplicaBluePolicyInput() (*HyperVReplicaBluePolicyInput, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaPolicyInput.
func (hvrpi HyperVReplicaPolicyInput) AsHyperVReplicaPolicyInput() (*HyperVReplicaPolicyInput, bool) {
	return &hvrpi, true
}

// AsInMageAzureV2PolicyInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaPolicyInput.
func (hvrpi HyperVReplicaPolicyInput) AsInMageAzureV2PolicyInput() (*InMageAzureV2PolicyInput, bool) {
	return nil, false
}

// AsInMagePolicyInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaPolicyInput.
func (hvrpi HyperVReplicaPolicyInput) AsInMagePolicyInput() (*InMagePolicyInput, bool) {
	return nil, false
}

// AsInMageRcmPolicyCreationInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaPolicyInput.
func (hvrpi HyperVReplicaPolicyInput) AsInMageRcmPolicyCreationInput() (*InMageRcmPolicyCreationInput, bool) {
	return nil, false
}

// AsVMwareCbtPolicyCreationInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaPolicyInput.
func (hvrpi HyperVReplicaPolicyInput) AsVMwareCbtPolicyCreationInput() (*VMwareCbtPolicyCreationInput, bool) {
	return nil, false
}

// AsPolicyProviderSpecificInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaPolicyInput.
func (hvrpi HyperVReplicaPolicyInput) AsPolicyProviderSpecificInput() (*PolicyProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicPolicyProviderSpecificInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaPolicyInput.
func (hvrpi HyperVReplicaPolicyInput) AsBasicPolicyProviderSpecificInput() (BasicPolicyProviderSpecificInput, bool) {
	return &hvrpi, true
}

// HyperVReplicaReplicationDetails hyperV replica 2012 replication details.
type HyperVReplicaReplicationDetails struct {
	// LastReplicatedTime - The Last replication time.
	LastReplicatedTime *date.Time `json:"lastReplicatedTime,omitempty"`
	// VMNics - The PE Network details.
	VMNics *[]VMNicDetails `json:"vmNics,omitempty"`
	// VMID - The virtual machine Id.
	VMID *string `json:"vmId,omitempty"`
	// VMProtectionState - The protection state for the vm.
	VMProtectionState *string `json:"vmProtectionState,omitempty"`
	// VMProtectionStateDescription - The protection state description for the vm.
	VMProtectionStateDescription *string `json:"vmProtectionStateDescription,omitempty"`
	// InitialReplicationDetails - Initial replication details.
	InitialReplicationDetails *InitialReplicationDetails `json:"initialReplicationDetails,omitempty"`
	// VMDiskDetails - VM disk details.
	VMDiskDetails *[]DiskDetails `json:"vMDiskDetails,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeReplicationProviderSpecificSettings', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeA2A', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaBaseReplicationDetails', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMageAzureV2', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMageRcm', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMage'
	InstanceType InstanceTypeBasicReplicationProviderSpecificSettings `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaReplicationDetails.
func (hvrrd HyperVReplicaReplicationDetails) MarshalJSON() ([]byte, error) {
	hvrrd.InstanceType = InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012
	objectMap := make(map[string]interface{})
	if hvrrd.LastReplicatedTime != nil {
		objectMap["lastReplicatedTime"] = hvrrd.LastReplicatedTime
	}
	if hvrrd.VMNics != nil {
		objectMap["vmNics"] = hvrrd.VMNics
	}
	if hvrrd.VMID != nil {
		objectMap["vmId"] = hvrrd.VMID
	}
	if hvrrd.VMProtectionState != nil {
		objectMap["vmProtectionState"] = hvrrd.VMProtectionState
	}
	if hvrrd.VMProtectionStateDescription != nil {
		objectMap["vmProtectionStateDescription"] = hvrrd.VMProtectionStateDescription
	}
	if hvrrd.InitialReplicationDetails != nil {
		objectMap["initialReplicationDetails"] = hvrrd.InitialReplicationDetails
	}
	if hvrrd.VMDiskDetails != nil {
		objectMap["vMDiskDetails"] = hvrrd.VMDiskDetails
	}
	if hvrrd.InstanceType != "" {
		objectMap["instanceType"] = hvrrd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaReplicationDetails.
func (hvrrd HyperVReplicaReplicationDetails) AsA2AReplicationDetails() (*A2AReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzureReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaReplicationDetails.
func (hvrrd HyperVReplicaReplicationDetails) AsHyperVReplicaAzureReplicationDetails() (*HyperVReplicaAzureReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBaseReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaReplicationDetails.
func (hvrrd HyperVReplicaReplicationDetails) AsHyperVReplicaBaseReplicationDetails() (*HyperVReplicaBaseReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBlueReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaReplicationDetails.
func (hvrrd HyperVReplicaReplicationDetails) AsHyperVReplicaBlueReplicationDetails() (*HyperVReplicaBlueReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaReplicationDetails.
func (hvrrd HyperVReplicaReplicationDetails) AsHyperVReplicaReplicationDetails() (*HyperVReplicaReplicationDetails, bool) {
	return &hvrrd, true
}

// AsInMageAzureV2ReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaReplicationDetails.
func (hvrrd HyperVReplicaReplicationDetails) AsInMageAzureV2ReplicationDetails() (*InMageAzureV2ReplicationDetails, bool) {
	return nil, false
}

// AsInMageRcmReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaReplicationDetails.
func (hvrrd HyperVReplicaReplicationDetails) AsInMageRcmReplicationDetails() (*InMageRcmReplicationDetails, bool) {
	return nil, false
}

// AsInMageReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaReplicationDetails.
func (hvrrd HyperVReplicaReplicationDetails) AsInMageReplicationDetails() (*InMageReplicationDetails, bool) {
	return nil, false
}

// AsReplicationProviderSpecificSettings is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaReplicationDetails.
func (hvrrd HyperVReplicaReplicationDetails) AsReplicationProviderSpecificSettings() (*ReplicationProviderSpecificSettings, bool) {
	return nil, false
}

// AsBasicReplicationProviderSpecificSettings is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaReplicationDetails.
func (hvrrd HyperVReplicaReplicationDetails) AsBasicReplicationProviderSpecificSettings() (BasicReplicationProviderSpecificSettings, bool) {
	return &hvrrd, true
}

// HyperVSiteDetails hyperVSite fabric specific details.
type HyperVSiteDetails struct {
	// InstanceType - Possible values include: 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeFabricSpecificDetails', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeAzure', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeHyperVSite', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeInMageRcm', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMM', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMware', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMwareV2'
	InstanceType InstanceTypeBasicFabricSpecificDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVSiteDetails.
func (hvsd HyperVSiteDetails) MarshalJSON() ([]byte, error) {
	hvsd.InstanceType = InstanceTypeBasicFabricSpecificDetailsInstanceTypeHyperVSite
	objectMap := make(map[string]interface{})
	if hvsd.InstanceType != "" {
		objectMap["instanceType"] = hvsd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAzureFabricSpecificDetails is the BasicFabricSpecificDetails implementation for HyperVSiteDetails.
func (hvsd HyperVSiteDetails) AsAzureFabricSpecificDetails() (*AzureFabricSpecificDetails, bool) {
	return nil, false
}

// AsHyperVSiteDetails is the BasicFabricSpecificDetails implementation for HyperVSiteDetails.
func (hvsd HyperVSiteDetails) AsHyperVSiteDetails() (*HyperVSiteDetails, bool) {
	return &hvsd, true
}

// AsInMageRcmFabricSpecificDetails is the BasicFabricSpecificDetails implementation for HyperVSiteDetails.
func (hvsd HyperVSiteDetails) AsInMageRcmFabricSpecificDetails() (*InMageRcmFabricSpecificDetails, bool) {
	return nil, false
}

// AsVmmDetails is the BasicFabricSpecificDetails implementation for HyperVSiteDetails.
func (hvsd HyperVSiteDetails) AsVmmDetails() (*VmmDetails, bool) {
	return nil, false
}

// AsVMwareDetails is the BasicFabricSpecificDetails implementation for HyperVSiteDetails.
func (hvsd HyperVSiteDetails) AsVMwareDetails() (*VMwareDetails, bool) {
	return nil, false
}

// AsVMwareV2FabricSpecificDetails is the BasicFabricSpecificDetails implementation for HyperVSiteDetails.
func (hvsd HyperVSiteDetails) AsVMwareV2FabricSpecificDetails() (*VMwareV2FabricSpecificDetails, bool) {
	return nil, false
}

// AsFabricSpecificDetails is the BasicFabricSpecificDetails implementation for HyperVSiteDetails.
func (hvsd HyperVSiteDetails) AsFabricSpecificDetails() (*FabricSpecificDetails, bool) {
	return nil, false
}

// AsBasicFabricSpecificDetails is the BasicFabricSpecificDetails implementation for HyperVSiteDetails.
func (hvsd HyperVSiteDetails) AsBasicFabricSpecificDetails() (BasicFabricSpecificDetails, bool) {
	return &hvsd, true
}

// HyperVVirtualMachineDetails single Host fabric provider specific VM settings.
type HyperVVirtualMachineDetails struct {
	// SourceItemID - The source id of the object.
	SourceItemID *string `json:"sourceItemId,omitempty"`
	// Generation - The id of the object in fabric.
	Generation *string `json:"generation,omitempty"`
	// OsDetails - The Last replication time.
	OsDetails *OSDetails `json:"osDetails,omitempty"`
	// DiskDetails - The Last successful failover time.
	DiskDetails *[]DiskDetails `json:"diskDetails,omitempty"`
	// HasPhysicalDisk - A value indicating whether the VM has a physical disk attached. String value of {SrsDataContract.PresenceStatus} enum. Possible values include: 'PresenceStatusUnknown', 'PresenceStatusPresent', 'PresenceStatusNotPresent'
	HasPhysicalDisk PresenceStatus `json:"hasPhysicalDisk,omitempty"`
	// HasFibreChannelAdapter - A value indicating whether the VM has a fibre channel adapter attached. String value of {SrsDataContract.PresenceStatus} enum. Possible values include: 'PresenceStatusUnknown', 'PresenceStatusPresent', 'PresenceStatusNotPresent'
	HasFibreChannelAdapter PresenceStatus `json:"hasFibreChannelAdapter,omitempty"`
	// HasSharedVhd - A value indicating whether the VM has a shared VHD attached. String value of {SrsDataContract.PresenceStatus} enum. Possible values include: 'PresenceStatusUnknown', 'PresenceStatusPresent', 'PresenceStatusNotPresent'
	HasSharedVhd PresenceStatus `json:"hasSharedVhd,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeConfigurationSettings', 'InstanceTypeHyperVVirtualMachine', 'InstanceTypeReplicationGroupDetails', 'InstanceTypeVmmVirtualMachine', 'InstanceTypeVMwareVirtualMachine'
	InstanceType InstanceTypeBasicConfigurationSettings `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVVirtualMachineDetails.
func (hvvmd HyperVVirtualMachineDetails) MarshalJSON() ([]byte, error) {
	hvvmd.InstanceType = InstanceTypeHyperVVirtualMachine
	objectMap := make(map[string]interface{})
	if hvvmd.SourceItemID != nil {
		objectMap["sourceItemId"] = hvvmd.SourceItemID
	}
	if hvvmd.Generation != nil {
		objectMap["generation"] = hvvmd.Generation
	}
	if hvvmd.OsDetails != nil {
		objectMap["osDetails"] = hvvmd.OsDetails
	}
	if hvvmd.DiskDetails != nil {
		objectMap["diskDetails"] = hvvmd.DiskDetails
	}
	if hvvmd.HasPhysicalDisk != "" {
		objectMap["hasPhysicalDisk"] = hvvmd.HasPhysicalDisk
	}
	if hvvmd.HasFibreChannelAdapter != "" {
		objectMap["hasFibreChannelAdapter"] = hvvmd.HasFibreChannelAdapter
	}
	if hvvmd.HasSharedVhd != "" {
		objectMap["hasSharedVhd"] = hvvmd.HasSharedVhd
	}
	if hvvmd.InstanceType != "" {
		objectMap["instanceType"] = hvvmd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVVirtualMachineDetails is the BasicConfigurationSettings implementation for HyperVVirtualMachineDetails.
func (hvvmd HyperVVirtualMachineDetails) AsHyperVVirtualMachineDetails() (*HyperVVirtualMachineDetails, bool) {
	return &hvvmd, true
}

// AsReplicationGroupDetails is the BasicConfigurationSettings implementation for HyperVVirtualMachineDetails.
func (hvvmd HyperVVirtualMachineDetails) AsReplicationGroupDetails() (*ReplicationGroupDetails, bool) {
	return nil, false
}

// AsVmmVirtualMachineDetails is the BasicConfigurationSettings implementation for HyperVVirtualMachineDetails.
func (hvvmd HyperVVirtualMachineDetails) AsVmmVirtualMachineDetails() (*VmmVirtualMachineDetails, bool) {
	return nil, false
}

// AsVMwareVirtualMachineDetails is the BasicConfigurationSettings implementation for HyperVVirtualMachineDetails.
func (hvvmd HyperVVirtualMachineDetails) AsVMwareVirtualMachineDetails() (*VMwareVirtualMachineDetails, bool) {
	return nil, false
}

// AsConfigurationSettings is the BasicConfigurationSettings implementation for HyperVVirtualMachineDetails.
func (hvvmd HyperVVirtualMachineDetails) AsConfigurationSettings() (*ConfigurationSettings, bool) {
	return nil, false
}

// AsBasicConfigurationSettings is the BasicConfigurationSettings implementation for HyperVVirtualMachineDetails.
func (hvvmd HyperVVirtualMachineDetails) AsBasicConfigurationSettings() (BasicConfigurationSettings, bool) {
	return &hvvmd, true
}

// IdentityProviderDetails identity provider details.
type IdentityProviderDetails struct {
	// TenantID - The tenant Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
	TenantID *string `json:"tenantId,omitempty"`
	// ApplicationID - The application/client Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
	ApplicationID *string `json:"applicationId,omitempty"`
	// ObjectID - The object Id of the service principal with which the on-premise management/data plane components would communicate with our Azure services.
	ObjectID *string `json:"objectId,omitempty"`
	// Audience - The intended Audience of the service principal with which the on-premise management/data plane components would communicate with our Azure services.
	Audience *string `json:"audience,omitempty"`
	// AadAuthority - The base authority for Azure Active Directory authentication.
	AadAuthority *string `json:"aadAuthority,omitempty"`
}

// IdentityProviderInput identity provider input.
type IdentityProviderInput struct {
	// TenantID - The tenant Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
	TenantID *string `json:"tenantId,omitempty"`
	// ApplicationID - The application/client Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
	ApplicationID *string `json:"applicationId,omitempty"`
	// ObjectID - The object Id of the service principal with which the on-premise management/data plane components would communicate with our Azure services.
	ObjectID *string `json:"objectId,omitempty"`
	// Audience - The intended Audience of the service principal with which the on-premise management/data plane components would communicate with our Azure services.
	Audience *string `json:"audience,omitempty"`
	// AadAuthority - The base authority for Azure Active Directory authentication.
	AadAuthority *string `json:"aadAuthority,omitempty"`
}

// InconsistentVMDetails this class stores the monitoring details for consistency check of inconsistent
// Protected Entity.
type InconsistentVMDetails struct {
	// VMName - The Vm name.
	VMName *string `json:"vmName,omitempty"`
	// CloudName - The Cloud name.
	CloudName *string `json:"cloudName,omitempty"`
	// Details - The list of details regarding state of the Protected Entity in SRS and On prem.
	Details *[]string `json:"details,omitempty"`
	// ErrorIds - The list of error ids.
	ErrorIds *[]string `json:"errorIds,omitempty"`
}

// InitialReplicationDetails initial replication details.
type InitialReplicationDetails struct {
	// InitialReplicationType - Initial replication type.
	InitialReplicationType *string `json:"initialReplicationType,omitempty"`
	// InitialReplicationProgressPercentage - The initial replication progress percentage.
	InitialReplicationProgressPercentage *string `json:"initialReplicationProgressPercentage,omitempty"`
}

// InlineWorkflowTaskDetails this class represents the inline workflow task details.
type InlineWorkflowTaskDetails struct {
	// WorkflowIds - The list of child workflow ids.
	WorkflowIds *[]string `json:"workflowIds,omitempty"`
	// ChildTasks - The child tasks.
	ChildTasks *[]ASRTask `json:"childTasks,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeGroupTaskDetails', 'InstanceTypeInlineWorkflowTaskDetails', 'InstanceTypeRecoveryPlanGroupTaskDetails', 'InstanceTypeRecoveryPlanShutdownGroupTaskDetails'
	InstanceType InstanceTypeBasicGroupTaskDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InlineWorkflowTaskDetails.
func (iwtd InlineWorkflowTaskDetails) MarshalJSON() ([]byte, error) {
	iwtd.InstanceType = InstanceTypeInlineWorkflowTaskDetails
	objectMap := make(map[string]interface{})
	if iwtd.WorkflowIds != nil {
		objectMap["workflowIds"] = iwtd.WorkflowIds
	}
	if iwtd.ChildTasks != nil {
		objectMap["childTasks"] = iwtd.ChildTasks
	}
	if iwtd.InstanceType != "" {
		objectMap["instanceType"] = iwtd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsInlineWorkflowTaskDetails is the BasicGroupTaskDetails implementation for InlineWorkflowTaskDetails.
func (iwtd InlineWorkflowTaskDetails) AsInlineWorkflowTaskDetails() (*InlineWorkflowTaskDetails, bool) {
	return &iwtd, true
}

// AsRecoveryPlanGroupTaskDetails is the BasicGroupTaskDetails implementation for InlineWorkflowTaskDetails.
func (iwtd InlineWorkflowTaskDetails) AsRecoveryPlanGroupTaskDetails() (*RecoveryPlanGroupTaskDetails, bool) {
	return nil, false
}

// AsRecoveryPlanShutdownGroupTaskDetails is the BasicGroupTaskDetails implementation for InlineWorkflowTaskDetails.
func (iwtd InlineWorkflowTaskDetails) AsRecoveryPlanShutdownGroupTaskDetails() (*RecoveryPlanShutdownGroupTaskDetails, bool) {
	return nil, false
}

// AsGroupTaskDetails is the BasicGroupTaskDetails implementation for InlineWorkflowTaskDetails.
func (iwtd InlineWorkflowTaskDetails) AsGroupTaskDetails() (*GroupTaskDetails, bool) {
	return nil, false
}

// AsBasicGroupTaskDetails is the BasicGroupTaskDetails implementation for InlineWorkflowTaskDetails.
func (iwtd InlineWorkflowTaskDetails) AsBasicGroupTaskDetails() (BasicGroupTaskDetails, bool) {
	return &iwtd, true
}

// InMageAgentDetails the details of the InMage agent.
type InMageAgentDetails struct {
	// AgentVersion - The agent version.
	AgentVersion *string `json:"agentVersion,omitempty"`
	// AgentUpdateStatus - A value indicating whether installed agent needs to be updated.
	AgentUpdateStatus *string `json:"agentUpdateStatus,omitempty"`
	// PostUpdateRebootStatus - A value indicating whether reboot is required after update is applied.
	PostUpdateRebootStatus *string `json:"postUpdateRebootStatus,omitempty"`
	// AgentExpiryDate - Agent expiry date.
	AgentExpiryDate *date.Time `json:"agentExpiryDate,omitempty"`
}

// InMageAgentVersionDetails inMage agent version details.
type InMageAgentVersionDetails struct {
	// PostUpdateRebootStatus - A value indicating whether reboot is required after update is applied.
	PostUpdateRebootStatus *string `json:"postUpdateRebootStatus,omitempty"`
	// Version - The agent version.
	Version *string `json:"version,omitempty"`
	// ExpiryDate - Version expiry date.
	ExpiryDate *date.Time `json:"expiryDate,omitempty"`
	// Status - A value indicating whether security update required. Possible values include: 'Supported', 'NotSupported', 'Deprecated', 'UpdateRequired', 'SecurityUpdateRequired'
	Status AgentVersionStatus `json:"status,omitempty"`
}

// InMageAzureV2ApplyRecoveryPointInput applyRecoveryPoint input specific to InMageAzureV2 provider.
type InMageAzureV2ApplyRecoveryPointInput struct {
	// VaultLocation - The vault location where the recovery Vm resides.
	VaultLocation *string `json:"vaultLocation,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeApplyRecoveryPointProviderSpecificInput', 'InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeA2A', 'InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeInMageRcm'
	InstanceType InstanceTypeBasicApplyRecoveryPointProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageAzureV2ApplyRecoveryPointInput.
func (imavarpi InMageAzureV2ApplyRecoveryPointInput) MarshalJSON() ([]byte, error) {
	imavarpi.InstanceType = InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeInMageAzureV2
	objectMap := make(map[string]interface{})
	if imavarpi.VaultLocation != nil {
		objectMap["vaultLocation"] = imavarpi.VaultLocation
	}
	if imavarpi.InstanceType != "" {
		objectMap["instanceType"] = imavarpi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AApplyRecoveryPointInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for InMageAzureV2ApplyRecoveryPointInput.
func (imavarpi InMageAzureV2ApplyRecoveryPointInput) AsA2AApplyRecoveryPointInput() (*A2AApplyRecoveryPointInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzureApplyRecoveryPointInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for InMageAzureV2ApplyRecoveryPointInput.
func (imavarpi InMageAzureV2ApplyRecoveryPointInput) AsHyperVReplicaAzureApplyRecoveryPointInput() (*HyperVReplicaAzureApplyRecoveryPointInput, bool) {
	return nil, false
}

// AsInMageAzureV2ApplyRecoveryPointInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for InMageAzureV2ApplyRecoveryPointInput.
func (imavarpi InMageAzureV2ApplyRecoveryPointInput) AsInMageAzureV2ApplyRecoveryPointInput() (*InMageAzureV2ApplyRecoveryPointInput, bool) {
	return &imavarpi, true
}

// AsInMageRcmApplyRecoveryPointInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for InMageAzureV2ApplyRecoveryPointInput.
func (imavarpi InMageAzureV2ApplyRecoveryPointInput) AsInMageRcmApplyRecoveryPointInput() (*InMageRcmApplyRecoveryPointInput, bool) {
	return nil, false
}

// AsApplyRecoveryPointProviderSpecificInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for InMageAzureV2ApplyRecoveryPointInput.
func (imavarpi InMageAzureV2ApplyRecoveryPointInput) AsApplyRecoveryPointProviderSpecificInput() (*ApplyRecoveryPointProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicApplyRecoveryPointProviderSpecificInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for InMageAzureV2ApplyRecoveryPointInput.
func (imavarpi InMageAzureV2ApplyRecoveryPointInput) AsBasicApplyRecoveryPointProviderSpecificInput() (BasicApplyRecoveryPointProviderSpecificInput, bool) {
	return &imavarpi, true
}

// InMageAzureV2DiskInputDetails disk input details.
type InMageAzureV2DiskInputDetails struct {
	// DiskID - The DiskId.
	DiskID *string `json:"diskId,omitempty"`
	// LogStorageAccountID - The LogStorageAccountId.
	LogStorageAccountID *string `json:"logStorageAccountId,omitempty"`
	// DiskType - The DiskType. Possible values include: 'StandardLRS', 'PremiumLRS', 'StandardSSDLRS'
	DiskType DiskAccountType `json:"diskType,omitempty"`
	// DiskEncryptionSetID - The DiskEncryptionSet ARM ID.
	DiskEncryptionSetID *string `json:"diskEncryptionSetId,omitempty"`
}

// InMageAzureV2EnableProtectionInput vMware Azure specific enable protection input.
type InMageAzureV2EnableProtectionInput struct {
	// MasterTargetID - The Master target Id.
	MasterTargetID *string `json:"masterTargetId,omitempty"`
	// ProcessServerID - The Process Server Id.
	ProcessServerID *string `json:"processServerId,omitempty"`
	// StorageAccountID - The storage account name.
	StorageAccountID *string `json:"storageAccountId,omitempty"`
	// RunAsAccountID - The CS account Id.
	RunAsAccountID *string `json:"runAsAccountId,omitempty"`
	// MultiVMGroupID - The multi vm group Id.
	MultiVMGroupID *string `json:"multiVmGroupId,omitempty"`
	// MultiVMGroupName - The multi vm group name.
	MultiVMGroupName *string `json:"multiVmGroupName,omitempty"`
	// DisksToInclude - The disks to include list.
	DisksToInclude *[]InMageAzureV2DiskInputDetails `json:"disksToInclude,omitempty"`
	// TargetAzureNetworkID - The selected target Azure network Id.
	TargetAzureNetworkID *string `json:"targetAzureNetworkId,omitempty"`
	// TargetAzureSubnetID - The selected target Azure subnet Id.
	TargetAzureSubnetID *string `json:"targetAzureSubnetId,omitempty"`
	// EnableRdpOnTargetOption - The selected option to enable RDP\SSH on target vm after failover. String value of {SrsDataContract.EnableRDPOnTargetOption} enum.
	EnableRdpOnTargetOption *string `json:"enableRdpOnTargetOption,omitempty"`
	// TargetAzureVMName - The target azure Vm Name.
	TargetAzureVMName *string `json:"targetAzureVmName,omitempty"`
	// LogStorageAccountID - The storage account to be used for logging during replication.
	LogStorageAccountID *string `json:"logStorageAccountId,omitempty"`
	// TargetAzureV1ResourceGroupID - The Id of the target resource group (for classic deployment) in which the failover VM is to be created.
	TargetAzureV1ResourceGroupID *string `json:"targetAzureV1ResourceGroupId,omitempty"`
	// TargetAzureV2ResourceGroupID - The Id of the target resource group (for resource manager deployment) in which the failover VM is to be created.
	TargetAzureV2ResourceGroupID *string `json:"targetAzureV2ResourceGroupId,omitempty"`
	// DiskType - The DiskType. Possible values include: 'StandardLRS', 'PremiumLRS', 'StandardSSDLRS'
	DiskType DiskAccountType `json:"diskType,omitempty"`
	// DiskEncryptionSetID - The DiskEncryptionSet ARM ID.
	DiskEncryptionSetID *string `json:"diskEncryptionSetId,omitempty"`
	// TargetAvailabilityZone - The target availability zone.
	TargetAvailabilityZone *string `json:"targetAvailabilityZone,omitempty"`
	// TargetProximityPlacementGroupID - The proximity placement group ARM Id.
	TargetProximityPlacementGroupID *string `json:"targetProximityPlacementGroupId,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeEnableProtectionProviderSpecificInput', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeA2A', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMage', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMageRcm', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeSan'
	InstanceType InstanceTypeBasicEnableProtectionProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageAzureV2EnableProtectionInput.
func (imavepi InMageAzureV2EnableProtectionInput) MarshalJSON() ([]byte, error) {
	imavepi.InstanceType = InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMageAzureV2
	objectMap := make(map[string]interface{})
	if imavepi.MasterTargetID != nil {
		objectMap["masterTargetId"] = imavepi.MasterTargetID
	}
	if imavepi.ProcessServerID != nil {
		objectMap["processServerId"] = imavepi.ProcessServerID
	}
	if imavepi.StorageAccountID != nil {
		objectMap["storageAccountId"] = imavepi.StorageAccountID
	}
	if imavepi.RunAsAccountID != nil {
		objectMap["runAsAccountId"] = imavepi.RunAsAccountID
	}
	if imavepi.MultiVMGroupID != nil {
		objectMap["multiVmGroupId"] = imavepi.MultiVMGroupID
	}
	if imavepi.MultiVMGroupName != nil {
		objectMap["multiVmGroupName"] = imavepi.MultiVMGroupName
	}
	if imavepi.DisksToInclude != nil {
		objectMap["disksToInclude"] = imavepi.DisksToInclude
	}
	if imavepi.TargetAzureNetworkID != nil {
		objectMap["targetAzureNetworkId"] = imavepi.TargetAzureNetworkID
	}
	if imavepi.TargetAzureSubnetID != nil {
		objectMap["targetAzureSubnetId"] = imavepi.TargetAzureSubnetID
	}
	if imavepi.EnableRdpOnTargetOption != nil {
		objectMap["enableRdpOnTargetOption"] = imavepi.EnableRdpOnTargetOption
	}
	if imavepi.TargetAzureVMName != nil {
		objectMap["targetAzureVmName"] = imavepi.TargetAzureVMName
	}
	if imavepi.LogStorageAccountID != nil {
		objectMap["logStorageAccountId"] = imavepi.LogStorageAccountID
	}
	if imavepi.TargetAzureV1ResourceGroupID != nil {
		objectMap["targetAzureV1ResourceGroupId"] = imavepi.TargetAzureV1ResourceGroupID
	}
	if imavepi.TargetAzureV2ResourceGroupID != nil {
		objectMap["targetAzureV2ResourceGroupId"] = imavepi.TargetAzureV2ResourceGroupID
	}
	if imavepi.DiskType != "" {
		objectMap["diskType"] = imavepi.DiskType
	}
	if imavepi.DiskEncryptionSetID != nil {
		objectMap["diskEncryptionSetId"] = imavepi.DiskEncryptionSetID
	}
	if imavepi.TargetAvailabilityZone != nil {
		objectMap["targetAvailabilityZone"] = imavepi.TargetAvailabilityZone
	}
	if imavepi.TargetProximityPlacementGroupID != nil {
		objectMap["targetProximityPlacementGroupId"] = imavepi.TargetProximityPlacementGroupID
	}
	if imavepi.InstanceType != "" {
		objectMap["instanceType"] = imavepi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for InMageAzureV2EnableProtectionInput.
func (imavepi InMageAzureV2EnableProtectionInput) AsA2AEnableProtectionInput() (*A2AEnableProtectionInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzureEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for InMageAzureV2EnableProtectionInput.
func (imavepi InMageAzureV2EnableProtectionInput) AsHyperVReplicaAzureEnableProtectionInput() (*HyperVReplicaAzureEnableProtectionInput, bool) {
	return nil, false
}

// AsInMageAzureV2EnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for InMageAzureV2EnableProtectionInput.
func (imavepi InMageAzureV2EnableProtectionInput) AsInMageAzureV2EnableProtectionInput() (*InMageAzureV2EnableProtectionInput, bool) {
	return &imavepi, true
}

// AsInMageEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for InMageAzureV2EnableProtectionInput.
func (imavepi InMageAzureV2EnableProtectionInput) AsInMageEnableProtectionInput() (*InMageEnableProtectionInput, bool) {
	return nil, false
}

// AsInMageRcmEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for InMageAzureV2EnableProtectionInput.
func (imavepi InMageAzureV2EnableProtectionInput) AsInMageRcmEnableProtectionInput() (*InMageRcmEnableProtectionInput, bool) {
	return nil, false
}

// AsSanEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for InMageAzureV2EnableProtectionInput.
func (imavepi InMageAzureV2EnableProtectionInput) AsSanEnableProtectionInput() (*SanEnableProtectionInput, bool) {
	return nil, false
}

// AsEnableProtectionProviderSpecificInput is the BasicEnableProtectionProviderSpecificInput implementation for InMageAzureV2EnableProtectionInput.
func (imavepi InMageAzureV2EnableProtectionInput) AsEnableProtectionProviderSpecificInput() (*EnableProtectionProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicEnableProtectionProviderSpecificInput is the BasicEnableProtectionProviderSpecificInput implementation for InMageAzureV2EnableProtectionInput.
func (imavepi InMageAzureV2EnableProtectionInput) AsBasicEnableProtectionProviderSpecificInput() (BasicEnableProtectionProviderSpecificInput, bool) {
	return &imavepi, true
}

// InMageAzureV2EventDetails model class for event details of a VMwareAzureV2 event.
type InMageAzureV2EventDetails struct {
	// EventType - InMage Event type. Takes one of the values of {InMageDataContract.InMageMonitoringEventType}.
	EventType *string `json:"eventType,omitempty"`
	// Category - InMage Event Category.
	Category *string `json:"category,omitempty"`
	// Component - InMage Event Component.
	Component *string `json:"component,omitempty"`
	// CorrectiveAction - Corrective Action string for the event.
	CorrectiveAction *string `json:"correctiveAction,omitempty"`
	// Details - InMage Event Details.
	Details *string `json:"details,omitempty"`
	// Summary - InMage Event Summary.
	Summary *string `json:"summary,omitempty"`
	// SiteName - VMware Site name.
	SiteName *string `json:"siteName,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeEventProviderSpecificDetails', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeA2A', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplicaBaseEventDetails', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeInMageAzureV2', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeInMageRcm'
	InstanceType InstanceTypeBasicEventProviderSpecificDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageAzureV2EventDetails.
func (imaved InMageAzureV2EventDetails) MarshalJSON() ([]byte, error) {
	imaved.InstanceType = InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeInMageAzureV2
	objectMap := make(map[string]interface{})
	if imaved.EventType != nil {
		objectMap["eventType"] = imaved.EventType
	}
	if imaved.Category != nil {
		objectMap["category"] = imaved.Category
	}
	if imaved.Component != nil {
		objectMap["component"] = imaved.Component
	}
	if imaved.CorrectiveAction != nil {
		objectMap["correctiveAction"] = imaved.CorrectiveAction
	}
	if imaved.Details != nil {
		objectMap["details"] = imaved.Details
	}
	if imaved.Summary != nil {
		objectMap["summary"] = imaved.Summary
	}
	if imaved.SiteName != nil {
		objectMap["siteName"] = imaved.SiteName
	}
	if imaved.InstanceType != "" {
		objectMap["instanceType"] = imaved.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AEventDetails is the BasicEventProviderSpecificDetails implementation for InMageAzureV2EventDetails.
func (imaved InMageAzureV2EventDetails) AsA2AEventDetails() (*A2AEventDetails, bool) {
	return nil, false
}

// AsHyperVReplica2012EventDetails is the BasicEventProviderSpecificDetails implementation for InMageAzureV2EventDetails.
func (imaved InMageAzureV2EventDetails) AsHyperVReplica2012EventDetails() (*HyperVReplica2012EventDetails, bool) {
	return nil, false
}

// AsHyperVReplica2012R2EventDetails is the BasicEventProviderSpecificDetails implementation for InMageAzureV2EventDetails.
func (imaved InMageAzureV2EventDetails) AsHyperVReplica2012R2EventDetails() (*HyperVReplica2012R2EventDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzureEventDetails is the BasicEventProviderSpecificDetails implementation for InMageAzureV2EventDetails.
func (imaved InMageAzureV2EventDetails) AsHyperVReplicaAzureEventDetails() (*HyperVReplicaAzureEventDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBaseEventDetails is the BasicEventProviderSpecificDetails implementation for InMageAzureV2EventDetails.
func (imaved InMageAzureV2EventDetails) AsHyperVReplicaBaseEventDetails() (*HyperVReplicaBaseEventDetails, bool) {
	return nil, false
}

// AsInMageAzureV2EventDetails is the BasicEventProviderSpecificDetails implementation for InMageAzureV2EventDetails.
func (imaved InMageAzureV2EventDetails) AsInMageAzureV2EventDetails() (*InMageAzureV2EventDetails, bool) {
	return &imaved, true
}

// AsInMageRcmEventDetails is the BasicEventProviderSpecificDetails implementation for InMageAzureV2EventDetails.
func (imaved InMageAzureV2EventDetails) AsInMageRcmEventDetails() (*InMageRcmEventDetails, bool) {
	return nil, false
}

// AsEventProviderSpecificDetails is the BasicEventProviderSpecificDetails implementation for InMageAzureV2EventDetails.
func (imaved InMageAzureV2EventDetails) AsEventProviderSpecificDetails() (*EventProviderSpecificDetails, bool) {
	return nil, false
}

// AsBasicEventProviderSpecificDetails is the BasicEventProviderSpecificDetails implementation for InMageAzureV2EventDetails.
func (imaved InMageAzureV2EventDetails) AsBasicEventProviderSpecificDetails() (BasicEventProviderSpecificDetails, bool) {
	return &imaved, true
}

// InMageAzureV2FailoverProviderInput inMageAzureV2 provider specific input for failover.
type InMageAzureV2FailoverProviderInput struct {
	// VaultLocation - Location of the vault.
	VaultLocation *string `json:"vaultLocation,omitempty"`
	// RecoveryPointID - The recovery point id to be passed to failover to a particular recovery point. In case of latest recovery point, null should be passed.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeProviderSpecificFailoverInput', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeA2A', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMage'
	InstanceType InstanceTypeBasicProviderSpecificFailoverInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageAzureV2FailoverProviderInput.
func (imavfpi InMageAzureV2FailoverProviderInput) MarshalJSON() ([]byte, error) {
	imavfpi.InstanceType = InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMageAzureV2
	objectMap := make(map[string]interface{})
	if imavfpi.VaultLocation != nil {
		objectMap["vaultLocation"] = imavfpi.VaultLocation
	}
	if imavfpi.RecoveryPointID != nil {
		objectMap["recoveryPointId"] = imavfpi.RecoveryPointID
	}
	if imavfpi.InstanceType != "" {
		objectMap["instanceType"] = imavfpi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AFailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for InMageAzureV2FailoverProviderInput.
func (imavfpi InMageAzureV2FailoverProviderInput) AsA2AFailoverProviderInput() (*A2AFailoverProviderInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzureFailbackProviderInput is the BasicProviderSpecificFailoverInput implementation for InMageAzureV2FailoverProviderInput.
func (imavfpi InMageAzureV2FailoverProviderInput) AsHyperVReplicaAzureFailbackProviderInput() (*HyperVReplicaAzureFailbackProviderInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzureFailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for InMageAzureV2FailoverProviderInput.
func (imavfpi InMageAzureV2FailoverProviderInput) AsHyperVReplicaAzureFailoverProviderInput() (*HyperVReplicaAzureFailoverProviderInput, bool) {
	return nil, false
}

// AsInMageAzureV2FailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for InMageAzureV2FailoverProviderInput.
func (imavfpi InMageAzureV2FailoverProviderInput) AsInMageAzureV2FailoverProviderInput() (*InMageAzureV2FailoverProviderInput, bool) {
	return &imavfpi, true
}

// AsInMageFailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for InMageAzureV2FailoverProviderInput.
func (imavfpi InMageAzureV2FailoverProviderInput) AsInMageFailoverProviderInput() (*InMageFailoverProviderInput, bool) {
	return nil, false
}

// AsProviderSpecificFailoverInput is the BasicProviderSpecificFailoverInput implementation for InMageAzureV2FailoverProviderInput.
func (imavfpi InMageAzureV2FailoverProviderInput) AsProviderSpecificFailoverInput() (*ProviderSpecificFailoverInput, bool) {
	return nil, false
}

// AsBasicProviderSpecificFailoverInput is the BasicProviderSpecificFailoverInput implementation for InMageAzureV2FailoverProviderInput.
func (imavfpi InMageAzureV2FailoverProviderInput) AsBasicProviderSpecificFailoverInput() (BasicProviderSpecificFailoverInput, bool) {
	return &imavfpi, true
}

// InMageAzureV2ManagedDiskDetails inMageAzureV2 Managed disk details.
type InMageAzureV2ManagedDiskDetails struct {
	// DiskID - The disk id.
	DiskID *string `json:"diskId,omitempty"`
	// SeedManagedDiskID - Seed managed disk Id.
	SeedManagedDiskID *string `json:"seedManagedDiskId,omitempty"`
	// ReplicaDiskType - The replica disk type.
	ReplicaDiskType *string `json:"replicaDiskType,omitempty"`
}

// InMageAzureV2PolicyDetails inMage Azure v2 specific protection profile details.
type InMageAzureV2PolicyDetails struct {
	// CrashConsistentFrequencyInMinutes - The crash consistent snapshot frequency in minutes.
	CrashConsistentFrequencyInMinutes *int32 `json:"crashConsistentFrequencyInMinutes,omitempty"`
	// RecoveryPointThresholdInMinutes - The recovery point threshold in minutes.
	RecoveryPointThresholdInMinutes *int32 `json:"recoveryPointThresholdInMinutes,omitempty"`
	// RecoveryPointHistory - The duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistory *int32 `json:"recoveryPointHistory,omitempty"`
	// AppConsistentFrequencyInMinutes - The app consistent snapshot frequency in minutes.
	AppConsistentFrequencyInMinutes *int32 `json:"appConsistentFrequencyInMinutes,omitempty"`
	// MultiVMSyncStatus - A value indicating whether multi-VM sync has to be enabled.
	MultiVMSyncStatus *string `json:"multiVmSyncStatus,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypePolicyProviderSpecificDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeA2A', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaBasePolicyDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageAzureV2', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageBasePolicyDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMage', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageRcm', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeRcmAzureMigration', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeVMwareCbt'
	InstanceType InstanceTypeBasicPolicyProviderSpecificDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageAzureV2PolicyDetails.
func (imavpd InMageAzureV2PolicyDetails) MarshalJSON() ([]byte, error) {
	imavpd.InstanceType = InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageAzureV2
	objectMap := make(map[string]interface{})
	if imavpd.CrashConsistentFrequencyInMinutes != nil {
		objectMap["crashConsistentFrequencyInMinutes"] = imavpd.CrashConsistentFrequencyInMinutes
	}
	if imavpd.RecoveryPointThresholdInMinutes != nil {
		objectMap["recoveryPointThresholdInMinutes"] = imavpd.RecoveryPointThresholdInMinutes
	}
	if imavpd.RecoveryPointHistory != nil {
		objectMap["recoveryPointHistory"] = imavpd.RecoveryPointHistory
	}
	if imavpd.AppConsistentFrequencyInMinutes != nil {
		objectMap["appConsistentFrequencyInMinutes"] = imavpd.AppConsistentFrequencyInMinutes
	}
	if imavpd.MultiVMSyncStatus != nil {
		objectMap["multiVmSyncStatus"] = imavpd.MultiVMSyncStatus
	}
	if imavpd.InstanceType != "" {
		objectMap["instanceType"] = imavpd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2APolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageAzureV2PolicyDetails.
func (imavpd InMageAzureV2PolicyDetails) AsA2APolicyDetails() (*A2APolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzurePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageAzureV2PolicyDetails.
func (imavpd InMageAzureV2PolicyDetails) AsHyperVReplicaAzurePolicyDetails() (*HyperVReplicaAzurePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBasePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageAzureV2PolicyDetails.
func (imavpd InMageAzureV2PolicyDetails) AsHyperVReplicaBasePolicyDetails() (*HyperVReplicaBasePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageAzureV2PolicyDetails.
func (imavpd InMageAzureV2PolicyDetails) AsHyperVReplicaBluePolicyDetails() (*HyperVReplicaBluePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageAzureV2PolicyDetails.
func (imavpd InMageAzureV2PolicyDetails) AsHyperVReplicaPolicyDetails() (*HyperVReplicaPolicyDetails, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageAzureV2PolicyDetails.
func (imavpd InMageAzureV2PolicyDetails) AsInMageAzureV2PolicyDetails() (*InMageAzureV2PolicyDetails, bool) {
	return &imavpd, true
}

// AsInMageBasePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageAzureV2PolicyDetails.
func (imavpd InMageAzureV2PolicyDetails) AsInMageBasePolicyDetails() (*InMageBasePolicyDetails, bool) {
	return nil, false
}

// AsInMagePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageAzureV2PolicyDetails.
func (imavpd InMageAzureV2PolicyDetails) AsInMagePolicyDetails() (*InMagePolicyDetails, bool) {
	return nil, false
}

// AsInMageRcmPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageAzureV2PolicyDetails.
func (imavpd InMageAzureV2PolicyDetails) AsInMageRcmPolicyDetails() (*InMageRcmPolicyDetails, bool) {
	return nil, false
}

// AsRcmAzureMigrationPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageAzureV2PolicyDetails.
func (imavpd InMageAzureV2PolicyDetails) AsRcmAzureMigrationPolicyDetails() (*RcmAzureMigrationPolicyDetails, bool) {
	return nil, false
}

// AsVmwareCbtPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageAzureV2PolicyDetails.
func (imavpd InMageAzureV2PolicyDetails) AsVmwareCbtPolicyDetails() (*VmwareCbtPolicyDetails, bool) {
	return nil, false
}

// AsPolicyProviderSpecificDetails is the BasicPolicyProviderSpecificDetails implementation for InMageAzureV2PolicyDetails.
func (imavpd InMageAzureV2PolicyDetails) AsPolicyProviderSpecificDetails() (*PolicyProviderSpecificDetails, bool) {
	return nil, false
}

// AsBasicPolicyProviderSpecificDetails is the BasicPolicyProviderSpecificDetails implementation for InMageAzureV2PolicyDetails.
func (imavpd InMageAzureV2PolicyDetails) AsBasicPolicyProviderSpecificDetails() (BasicPolicyProviderSpecificDetails, bool) {
	return &imavpd, true
}

// InMageAzureV2PolicyInput vMWare Azure specific policy Input.
type InMageAzureV2PolicyInput struct {
	// RecoveryPointThresholdInMinutes - The recovery point threshold in minutes.
	RecoveryPointThresholdInMinutes *int32 `json:"recoveryPointThresholdInMinutes,omitempty"`
	// RecoveryPointHistory - The duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistory *int32 `json:"recoveryPointHistory,omitempty"`
	// CrashConsistentFrequencyInMinutes - The crash consistent snapshot frequency (in minutes).
	CrashConsistentFrequencyInMinutes *int32 `json:"crashConsistentFrequencyInMinutes,omitempty"`
	// AppConsistentFrequencyInMinutes - The app consistent snapshot frequency (in minutes).
	AppConsistentFrequencyInMinutes *int32 `json:"appConsistentFrequencyInMinutes,omitempty"`
	// MultiVMSyncStatus - A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or 'Disabled'. Possible values include: 'Enable', 'Disable'
	MultiVMSyncStatus SetMultiVMSyncStatus `json:"multiVmSyncStatus,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypePolicyProviderSpecificInput', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeA2A', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMage', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMageRcm', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeVMwareCbt'
	InstanceType InstanceTypeBasicPolicyProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageAzureV2PolicyInput.
func (imavpi InMageAzureV2PolicyInput) MarshalJSON() ([]byte, error) {
	imavpi.InstanceType = InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMageAzureV2
	objectMap := make(map[string]interface{})
	if imavpi.RecoveryPointThresholdInMinutes != nil {
		objectMap["recoveryPointThresholdInMinutes"] = imavpi.RecoveryPointThresholdInMinutes
	}
	if imavpi.RecoveryPointHistory != nil {
		objectMap["recoveryPointHistory"] = imavpi.RecoveryPointHistory
	}
	if imavpi.CrashConsistentFrequencyInMinutes != nil {
		objectMap["crashConsistentFrequencyInMinutes"] = imavpi.CrashConsistentFrequencyInMinutes
	}
	if imavpi.AppConsistentFrequencyInMinutes != nil {
		objectMap["appConsistentFrequencyInMinutes"] = imavpi.AppConsistentFrequencyInMinutes
	}
	if imavpi.MultiVMSyncStatus != "" {
		objectMap["multiVmSyncStatus"] = imavpi.MultiVMSyncStatus
	}
	if imavpi.InstanceType != "" {
		objectMap["instanceType"] = imavpi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2APolicyCreationInput is the BasicPolicyProviderSpecificInput implementation for InMageAzureV2PolicyInput.
func (imavpi InMageAzureV2PolicyInput) AsA2APolicyCreationInput() (*A2APolicyCreationInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzurePolicyInput is the BasicPolicyProviderSpecificInput implementation for InMageAzureV2PolicyInput.
func (imavpi InMageAzureV2PolicyInput) AsHyperVReplicaAzurePolicyInput() (*HyperVReplicaAzurePolicyInput, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyInput is the BasicPolicyProviderSpecificInput implementation for InMageAzureV2PolicyInput.
func (imavpi InMageAzureV2PolicyInput) AsHyperVReplicaBluePolicyInput() (*HyperVReplicaBluePolicyInput, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyInput is the BasicPolicyProviderSpecificInput implementation for InMageAzureV2PolicyInput.
func (imavpi InMageAzureV2PolicyInput) AsHyperVReplicaPolicyInput() (*HyperVReplicaPolicyInput, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyInput is the BasicPolicyProviderSpecificInput implementation for InMageAzureV2PolicyInput.
func (imavpi InMageAzureV2PolicyInput) AsInMageAzureV2PolicyInput() (*InMageAzureV2PolicyInput, bool) {
	return &imavpi, true
}

// AsInMagePolicyInput is the BasicPolicyProviderSpecificInput implementation for InMageAzureV2PolicyInput.
func (imavpi InMageAzureV2PolicyInput) AsInMagePolicyInput() (*InMagePolicyInput, bool) {
	return nil, false
}

// AsInMageRcmPolicyCreationInput is the BasicPolicyProviderSpecificInput implementation for InMageAzureV2PolicyInput.
func (imavpi InMageAzureV2PolicyInput) AsInMageRcmPolicyCreationInput() (*InMageRcmPolicyCreationInput, bool) {
	return nil, false
}

// AsVMwareCbtPolicyCreationInput is the BasicPolicyProviderSpecificInput implementation for InMageAzureV2PolicyInput.
func (imavpi InMageAzureV2PolicyInput) AsVMwareCbtPolicyCreationInput() (*VMwareCbtPolicyCreationInput, bool) {
	return nil, false
}

// AsPolicyProviderSpecificInput is the BasicPolicyProviderSpecificInput implementation for InMageAzureV2PolicyInput.
func (imavpi InMageAzureV2PolicyInput) AsPolicyProviderSpecificInput() (*PolicyProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicPolicyProviderSpecificInput is the BasicPolicyProviderSpecificInput implementation for InMageAzureV2PolicyInput.
func (imavpi InMageAzureV2PolicyInput) AsBasicPolicyProviderSpecificInput() (BasicPolicyProviderSpecificInput, bool) {
	return &imavpi, true
}

// InMageAzureV2ProtectedDiskDetails inMageAzureV2 protected disk details.
type InMageAzureV2ProtectedDiskDetails struct {
	// DiskID - The disk id.
	DiskID *string `json:"diskId,omitempty"`
	// DiskName - The disk name.
	DiskName *string `json:"diskName,omitempty"`
	// ProtectionStage - The protection stage.
	ProtectionStage *string `json:"protectionStage,omitempty"`
	// HealthErrorCode - The health error code for the disk.
	HealthErrorCode *string `json:"healthErrorCode,omitempty"`
	// RpoInSeconds - The RPO in seconds.
	RpoInSeconds *int64 `json:"rpoInSeconds,omitempty"`
	// ResyncRequired - A value indicating whether resync is required for this disk.
	ResyncRequired *string `json:"resyncRequired,omitempty"`
	// ResyncProgressPercentage - The resync progress percentage.
	ResyncProgressPercentage *int32 `json:"resyncProgressPercentage,omitempty"`
	// ResyncDurationInSeconds - The resync duration in seconds.
	ResyncDurationInSeconds *int64 `json:"resyncDurationInSeconds,omitempty"`
	// DiskCapacityInBytes - The disk capacity in bytes.
	DiskCapacityInBytes *int64 `json:"diskCapacityInBytes,omitempty"`
	// FileSystemCapacityInBytes - The disk file system capacity in bytes.
	FileSystemCapacityInBytes *int64 `json:"fileSystemCapacityInBytes,omitempty"`
	// SourceDataInMegaBytes - The source data transit in MB.
	SourceDataInMegaBytes *float64 `json:"sourceDataInMegaBytes,omitempty"`
	// PsDataInMegaBytes - The PS data transit in MB.
	PsDataInMegaBytes *float64 `json:"psDataInMegaBytes,omitempty"`
	// TargetDataInMegaBytes - The target data transit in MB.
	TargetDataInMegaBytes *float64 `json:"targetDataInMegaBytes,omitempty"`
	// DiskResized - A value indicating whether disk is resized.
	DiskResized *string `json:"diskResized,omitempty"`
	// LastRpoCalculatedTime - The last RPO calculated time.
	LastRpoCalculatedTime *date.Time `json:"lastRpoCalculatedTime,omitempty"`
}

// InMageAzureV2RecoveryPointDetails inMage Azure V2 provider specific recovery point details.
type InMageAzureV2RecoveryPointDetails struct {
	// IsMultiVMSyncPoint - A value indicating whether the recovery point is multi VM consistent.
	IsMultiVMSyncPoint *string `json:"isMultiVmSyncPoint,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicProviderSpecificRecoveryPointDetailsInstanceTypeProviderSpecificRecoveryPointDetails', 'InstanceTypeBasicProviderSpecificRecoveryPointDetailsInstanceTypeA2A', 'InstanceTypeBasicProviderSpecificRecoveryPointDetailsInstanceTypeInMageAzureV2', 'InstanceTypeBasicProviderSpecificRecoveryPointDetailsInstanceTypeInMageRcm'
	InstanceType InstanceTypeBasicProviderSpecificRecoveryPointDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageAzureV2RecoveryPointDetails.
func (imavrpd InMageAzureV2RecoveryPointDetails) MarshalJSON() ([]byte, error) {
	imavrpd.InstanceType = InstanceTypeBasicProviderSpecificRecoveryPointDetailsInstanceTypeInMageAzureV2
	objectMap := make(map[string]interface{})
	if imavrpd.IsMultiVMSyncPoint != nil {
		objectMap["isMultiVmSyncPoint"] = imavrpd.IsMultiVMSyncPoint
	}
	if imavrpd.InstanceType != "" {
		objectMap["instanceType"] = imavrpd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2ARecoveryPointDetails is the BasicProviderSpecificRecoveryPointDetails implementation for InMageAzureV2RecoveryPointDetails.
func (imavrpd InMageAzureV2RecoveryPointDetails) AsA2ARecoveryPointDetails() (*A2ARecoveryPointDetails, bool) {
	return nil, false
}

// AsInMageAzureV2RecoveryPointDetails is the BasicProviderSpecificRecoveryPointDetails implementation for InMageAzureV2RecoveryPointDetails.
func (imavrpd InMageAzureV2RecoveryPointDetails) AsInMageAzureV2RecoveryPointDetails() (*InMageAzureV2RecoveryPointDetails, bool) {
	return &imavrpd, true
}

// AsInMageRcmRecoveryPointDetails is the BasicProviderSpecificRecoveryPointDetails implementation for InMageAzureV2RecoveryPointDetails.
func (imavrpd InMageAzureV2RecoveryPointDetails) AsInMageRcmRecoveryPointDetails() (*InMageRcmRecoveryPointDetails, bool) {
	return nil, false
}

// AsProviderSpecificRecoveryPointDetails is the BasicProviderSpecificRecoveryPointDetails implementation for InMageAzureV2RecoveryPointDetails.
func (imavrpd InMageAzureV2RecoveryPointDetails) AsProviderSpecificRecoveryPointDetails() (*ProviderSpecificRecoveryPointDetails, bool) {
	return nil, false
}

// AsBasicProviderSpecificRecoveryPointDetails is the BasicProviderSpecificRecoveryPointDetails implementation for InMageAzureV2RecoveryPointDetails.
func (imavrpd InMageAzureV2RecoveryPointDetails) AsBasicProviderSpecificRecoveryPointDetails() (BasicProviderSpecificRecoveryPointDetails, bool) {
	return &imavrpd, true
}

// InMageAzureV2ReplicationDetails inMageAzureV2 provider specific settings
type InMageAzureV2ReplicationDetails struct {
	// InfrastructureVMID - The infrastructure VM Id.
	InfrastructureVMID *string `json:"infrastructureVmId,omitempty"`
	// VCenterInfrastructureID - The vCenter infrastructure Id.
	VCenterInfrastructureID *string `json:"vCenterInfrastructureId,omitempty"`
	// ProtectionStage - The protection stage.
	ProtectionStage *string `json:"protectionStage,omitempty"`
	// VMID - The virtual machine Id.
	VMID *string `json:"vmId,omitempty"`
	// VMProtectionState - The protection state for the vm.
	VMProtectionState *string `json:"vmProtectionState,omitempty"`
	// VMProtectionStateDescription - The protection state description for the vm.
	VMProtectionStateDescription *string `json:"vmProtectionStateDescription,omitempty"`
	// ResyncProgressPercentage - The resync progress percentage.
	ResyncProgressPercentage *int32 `json:"resyncProgressPercentage,omitempty"`
	// RpoInSeconds - The RPO in seconds.
	RpoInSeconds *int64 `json:"rpoInSeconds,omitempty"`
	// CompressedDataRateInMB - The compressed data change rate in MB.
	CompressedDataRateInMB *float64 `json:"compressedDataRateInMB,omitempty"`
	// UncompressedDataRateInMB - The uncompressed data change rate in MB.
	UncompressedDataRateInMB *float64 `json:"uncompressedDataRateInMB,omitempty"`
	// IPAddress - The source IP address.
	IPAddress *string `json:"ipAddress,omitempty"`
	// AgentVersion - The agent version.
	AgentVersion *string `json:"agentVersion,omitempty"`
	// AgentExpiryDate - Agent expiry date.
	AgentExpiryDate *date.Time `json:"agentExpiryDate,omitempty"`
	// IsAgentUpdateRequired - A value indicating whether installed agent needs to be updated.
	IsAgentUpdateRequired *string `json:"isAgentUpdateRequired,omitempty"`
	// IsRebootAfterUpdateRequired - A value indicating whether the source server requires a restart after update.
	IsRebootAfterUpdateRequired *string `json:"isRebootAfterUpdateRequired,omitempty"`
	// LastHeartbeat - The last heartbeat received from the source server.
	LastHeartbeat *date.Time `json:"lastHeartbeat,omitempty"`
	// ProcessServerID - The process server Id.
	ProcessServerID *string `json:"processServerId,omitempty"`
	// ProcessServerName - READ-ONLY; The process server name.
	ProcessServerName *string `json:"processServerName,omitempty"`
	// MultiVMGroupID - The multi vm group Id.
	MultiVMGroupID *string `json:"multiVmGroupId,omitempty"`
	// MultiVMGroupName - The multi vm group name.
	MultiVMGroupName *string `json:"multiVmGroupName,omitempty"`
	// MultiVMSyncStatus - A value indicating whether multi vm sync is enabled or disabled.
	MultiVMSyncStatus *string `json:"multiVmSyncStatus,omitempty"`
	// ProtectedDisks - The list of protected disks.
	ProtectedDisks *[]InMageAzureV2ProtectedDiskDetails `json:"protectedDisks,omitempty"`
	// DiskResized - A value indicating whether any disk is resized for this VM.
	DiskResized *string `json:"diskResized,omitempty"`
	// MasterTargetID - The master target Id.
	MasterTargetID *string `json:"masterTargetId,omitempty"`
	// SourceVMCPUCount - The CPU count of the VM on the primary side.
	SourceVMCPUCount *int32 `json:"sourceVmCpuCount,omitempty"`
	// SourceVMRAMSizeInMB - The RAM size of the VM on the primary side.
	SourceVMRAMSizeInMB *int32 `json:"sourceVmRamSizeInMB,omitempty"`
	// OsType - The type of the OS on the VM.
	OsType *string `json:"osType,omitempty"`
	// VhdName - The OS disk VHD name.
	VhdName *string `json:"vhdName,omitempty"`
	// OsDiskID - The id of the disk containing the OS.
	OsDiskID *string `json:"osDiskId,omitempty"`
	// AzureVMDiskDetails - Azure VM Disk details.
	AzureVMDiskDetails *[]AzureVMDiskDetails `json:"azureVMDiskDetails,omitempty"`
	// RecoveryAzureVMName - Recovery Azure given name.
	RecoveryAzureVMName *string `json:"recoveryAzureVMName,omitempty"`
	// RecoveryAzureVMSize - The Recovery Azure VM size.
	RecoveryAzureVMSize *string `json:"recoveryAzureVMSize,omitempty"`
	// RecoveryAzureStorageAccount - The recovery Azure storage account.
	RecoveryAzureStorageAccount *string `json:"recoveryAzureStorageAccount,omitempty"`
	// RecoveryAzureLogStorageAccountID - The ARM id of the log storage account used for replication. This will be set to null if no log storage account was provided during enable protection.
	RecoveryAzureLogStorageAccountID *string `json:"recoveryAzureLogStorageAccountId,omitempty"`
	// VMNics - The PE Network details.
	VMNics *[]VMNicDetails `json:"vmNics,omitempty"`
	// SelectedRecoveryAzureNetworkID - The selected recovery azure network Id.
	SelectedRecoveryAzureNetworkID *string `json:"selectedRecoveryAzureNetworkId,omitempty"`
	// SelectedTfoAzureNetworkID - The test failover virtual network.
	SelectedTfoAzureNetworkID *string `json:"selectedTfoAzureNetworkId,omitempty"`
	// SelectedSourceNicID - The selected source nic Id which will be used as the primary nic during failover.
	SelectedSourceNicID *string `json:"selectedSourceNicId,omitempty"`
	// DiscoveryType - A value indicating the discovery type of the machine. Value can be vCenter or physical.
	DiscoveryType *string `json:"discoveryType,omitempty"`
	// EnableRdpOnTargetOption - The selected option to enable RDP\SSH on target vm after failover. String value of {SrsDataContract.EnableRDPOnTargetOption} enum.
	EnableRdpOnTargetOption *string `json:"enableRdpOnTargetOption,omitempty"`
	// Datastores - The data stores of the on-premise machine. Value can be list of strings that contain data store names.
	Datastores *[]string `json:"datastores,omitempty"`
	// TargetVMID - The ARM Id of the target Azure VM. This value will be null until the VM is failed over. Only after failure it will be populated with the ARM Id of the Azure VM.
	TargetVMID *string `json:"targetVmId,omitempty"`
	// RecoveryAzureResourceGroupID - The target resource group Id.
	RecoveryAzureResourceGroupID *string `json:"recoveryAzureResourceGroupId,omitempty"`
	// RecoveryAvailabilitySetID - The recovery availability set Id.
	RecoveryAvailabilitySetID *string `json:"recoveryAvailabilitySetId,omitempty"`
	// TargetAvailabilityZone - The target availability zone.
	TargetAvailabilityZone *string `json:"targetAvailabilityZone,omitempty"`
	// TargetProximityPlacementGroupID - The target proximity placement group Id.
	TargetProximityPlacementGroupID *string `json:"targetProximityPlacementGroupId,omitempty"`
	// UseManagedDisks - A value indicating whether managed disks should be used during failover.
	UseManagedDisks *string `json:"useManagedDisks,omitempty"`
	// LicenseType - License Type of the VM to be used.
	LicenseType *string `json:"licenseType,omitempty"`
	// ValidationErrors - The validation errors of the on-premise machine Value can be list of validation errors.
	ValidationErrors *[]HealthError `json:"validationErrors,omitempty"`
	// LastRpoCalculatedTime - The last RPO calculated time.
	LastRpoCalculatedTime *date.Time `json:"lastRpoCalculatedTime,omitempty"`
	// LastUpdateReceivedTime - The last update time received from on-prem components.
	LastUpdateReceivedTime *date.Time `json:"lastUpdateReceivedTime,omitempty"`
	// ReplicaID - The replica id of the protected item.
	ReplicaID *string `json:"replicaId,omitempty"`
	// OsVersion - The OS Version of the protected item.
	OsVersion *string `json:"osVersion,omitempty"`
	// ProtectedManagedDisks - The list of protected managed disks.
	ProtectedManagedDisks *[]InMageAzureV2ManagedDiskDetails `json:"protectedManagedDisks,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeReplicationProviderSpecificSettings', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeA2A', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaBaseReplicationDetails', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMageAzureV2', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMageRcm', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMage'
	InstanceType InstanceTypeBasicReplicationProviderSpecificSettings `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageAzureV2ReplicationDetails.
func (imavrd InMageAzureV2ReplicationDetails) MarshalJSON() ([]byte, error) {
	imavrd.InstanceType = InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMageAzureV2
	objectMap := make(map[string]interface{})
	if imavrd.InfrastructureVMID != nil {
		objectMap["infrastructureVmId"] = imavrd.InfrastructureVMID
	}
	if imavrd.VCenterInfrastructureID != nil {
		objectMap["vCenterInfrastructureId"] = imavrd.VCenterInfrastructureID
	}
	if imavrd.ProtectionStage != nil {
		objectMap["protectionStage"] = imavrd.ProtectionStage
	}
	if imavrd.VMID != nil {
		objectMap["vmId"] = imavrd.VMID
	}
	if imavrd.VMProtectionState != nil {
		objectMap["vmProtectionState"] = imavrd.VMProtectionState
	}
	if imavrd.VMProtectionStateDescription != nil {
		objectMap["vmProtectionStateDescription"] = imavrd.VMProtectionStateDescription
	}
	if imavrd.ResyncProgressPercentage != nil {
		objectMap["resyncProgressPercentage"] = imavrd.ResyncProgressPercentage
	}
	if imavrd.RpoInSeconds != nil {
		objectMap["rpoInSeconds"] = imavrd.RpoInSeconds
	}
	if imavrd.CompressedDataRateInMB != nil {
		objectMap["compressedDataRateInMB"] = imavrd.CompressedDataRateInMB
	}
	if imavrd.UncompressedDataRateInMB != nil {
		objectMap["uncompressedDataRateInMB"] = imavrd.UncompressedDataRateInMB
	}
	if imavrd.IPAddress != nil {
		objectMap["ipAddress"] = imavrd.IPAddress
	}
	if imavrd.AgentVersion != nil {
		objectMap["agentVersion"] = imavrd.AgentVersion
	}
	if imavrd.AgentExpiryDate != nil {
		objectMap["agentExpiryDate"] = imavrd.AgentExpiryDate
	}
	if imavrd.IsAgentUpdateRequired != nil {
		objectMap["isAgentUpdateRequired"] = imavrd.IsAgentUpdateRequired
	}
	if imavrd.IsRebootAfterUpdateRequired != nil {
		objectMap["isRebootAfterUpdateRequired"] = imavrd.IsRebootAfterUpdateRequired
	}
	if imavrd.LastHeartbeat != nil {
		objectMap["lastHeartbeat"] = imavrd.LastHeartbeat
	}
	if imavrd.ProcessServerID != nil {
		objectMap["processServerId"] = imavrd.ProcessServerID
	}
	if imavrd.MultiVMGroupID != nil {
		objectMap["multiVmGroupId"] = imavrd.MultiVMGroupID
	}
	if imavrd.MultiVMGroupName != nil {
		objectMap["multiVmGroupName"] = imavrd.MultiVMGroupName
	}
	if imavrd.MultiVMSyncStatus != nil {
		objectMap["multiVmSyncStatus"] = imavrd.MultiVMSyncStatus
	}
	if imavrd.ProtectedDisks != nil {
		objectMap["protectedDisks"] = imavrd.ProtectedDisks
	}
	if imavrd.DiskResized != nil {
		objectMap["diskResized"] = imavrd.DiskResized
	}
	if imavrd.MasterTargetID != nil {
		objectMap["masterTargetId"] = imavrd.MasterTargetID
	}
	if imavrd.SourceVMCPUCount != nil {
		objectMap["sourceVmCpuCount"] = imavrd.SourceVMCPUCount
	}
	if imavrd.SourceVMRAMSizeInMB != nil {
		objectMap["sourceVmRamSizeInMB"] = imavrd.SourceVMRAMSizeInMB
	}
	if imavrd.OsType != nil {
		objectMap["osType"] = imavrd.OsType
	}
	if imavrd.VhdName != nil {
		objectMap["vhdName"] = imavrd.VhdName
	}
	if imavrd.OsDiskID != nil {
		objectMap["osDiskId"] = imavrd.OsDiskID
	}
	if imavrd.AzureVMDiskDetails != nil {
		objectMap["azureVMDiskDetails"] = imavrd.AzureVMDiskDetails
	}
	if imavrd.RecoveryAzureVMName != nil {
		objectMap["recoveryAzureVMName"] = imavrd.RecoveryAzureVMName
	}
	if imavrd.RecoveryAzureVMSize != nil {
		objectMap["recoveryAzureVMSize"] = imavrd.RecoveryAzureVMSize
	}
	if imavrd.RecoveryAzureStorageAccount != nil {
		objectMap["recoveryAzureStorageAccount"] = imavrd.RecoveryAzureStorageAccount
	}
	if imavrd.RecoveryAzureLogStorageAccountID != nil {
		objectMap["recoveryAzureLogStorageAccountId"] = imavrd.RecoveryAzureLogStorageAccountID
	}
	if imavrd.VMNics != nil {
		objectMap["vmNics"] = imavrd.VMNics
	}
	if imavrd.SelectedRecoveryAzureNetworkID != nil {
		objectMap["selectedRecoveryAzureNetworkId"] = imavrd.SelectedRecoveryAzureNetworkID
	}
	if imavrd.SelectedTfoAzureNetworkID != nil {
		objectMap["selectedTfoAzureNetworkId"] = imavrd.SelectedTfoAzureNetworkID
	}
	if imavrd.SelectedSourceNicID != nil {
		objectMap["selectedSourceNicId"] = imavrd.SelectedSourceNicID
	}
	if imavrd.DiscoveryType != nil {
		objectMap["discoveryType"] = imavrd.DiscoveryType
	}
	if imavrd.EnableRdpOnTargetOption != nil {
		objectMap["enableRdpOnTargetOption"] = imavrd.EnableRdpOnTargetOption
	}
	if imavrd.Datastores != nil {
		objectMap["datastores"] = imavrd.Datastores
	}
	if imavrd.TargetVMID != nil {
		objectMap["targetVmId"] = imavrd.TargetVMID
	}
	if imavrd.RecoveryAzureResourceGroupID != nil {
		objectMap["recoveryAzureResourceGroupId"] = imavrd.RecoveryAzureResourceGroupID
	}
	if imavrd.RecoveryAvailabilitySetID != nil {
		objectMap["recoveryAvailabilitySetId"] = imavrd.RecoveryAvailabilitySetID
	}
	if imavrd.TargetAvailabilityZone != nil {
		objectMap["targetAvailabilityZone"] = imavrd.TargetAvailabilityZone
	}
	if imavrd.TargetProximityPlacementGroupID != nil {
		objectMap["targetProximityPlacementGroupId"] = imavrd.TargetProximityPlacementGroupID
	}
	if imavrd.UseManagedDisks != nil {
		objectMap["useManagedDisks"] = imavrd.UseManagedDisks
	}
	if imavrd.LicenseType != nil {
		objectMap["licenseType"] = imavrd.LicenseType
	}
	if imavrd.ValidationErrors != nil {
		objectMap["validationErrors"] = imavrd.ValidationErrors
	}
	if imavrd.LastRpoCalculatedTime != nil {
		objectMap["lastRpoCalculatedTime"] = imavrd.LastRpoCalculatedTime
	}
	if imavrd.LastUpdateReceivedTime != nil {
		objectMap["lastUpdateReceivedTime"] = imavrd.LastUpdateReceivedTime
	}
	if imavrd.ReplicaID != nil {
		objectMap["replicaId"] = imavrd.ReplicaID
	}
	if imavrd.OsVersion != nil {
		objectMap["osVersion"] = imavrd.OsVersion
	}
	if imavrd.ProtectedManagedDisks != nil {
		objectMap["protectedManagedDisks"] = imavrd.ProtectedManagedDisks
	}
	if imavrd.InstanceType != "" {
		objectMap["instanceType"] = imavrd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for InMageAzureV2ReplicationDetails.
func (imavrd InMageAzureV2ReplicationDetails) AsA2AReplicationDetails() (*A2AReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzureReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for InMageAzureV2ReplicationDetails.
func (imavrd InMageAzureV2ReplicationDetails) AsHyperVReplicaAzureReplicationDetails() (*HyperVReplicaAzureReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBaseReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for InMageAzureV2ReplicationDetails.
func (imavrd InMageAzureV2ReplicationDetails) AsHyperVReplicaBaseReplicationDetails() (*HyperVReplicaBaseReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBlueReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for InMageAzureV2ReplicationDetails.
func (imavrd InMageAzureV2ReplicationDetails) AsHyperVReplicaBlueReplicationDetails() (*HyperVReplicaBlueReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for InMageAzureV2ReplicationDetails.
func (imavrd InMageAzureV2ReplicationDetails) AsHyperVReplicaReplicationDetails() (*HyperVReplicaReplicationDetails, bool) {
	return nil, false
}

// AsInMageAzureV2ReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for InMageAzureV2ReplicationDetails.
func (imavrd InMageAzureV2ReplicationDetails) AsInMageAzureV2ReplicationDetails() (*InMageAzureV2ReplicationDetails, bool) {
	return &imavrd, true
}

// AsInMageRcmReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for InMageAzureV2ReplicationDetails.
func (imavrd InMageAzureV2ReplicationDetails) AsInMageRcmReplicationDetails() (*InMageRcmReplicationDetails, bool) {
	return nil, false
}

// AsInMageReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for InMageAzureV2ReplicationDetails.
func (imavrd InMageAzureV2ReplicationDetails) AsInMageReplicationDetails() (*InMageReplicationDetails, bool) {
	return nil, false
}

// AsReplicationProviderSpecificSettings is the BasicReplicationProviderSpecificSettings implementation for InMageAzureV2ReplicationDetails.
func (imavrd InMageAzureV2ReplicationDetails) AsReplicationProviderSpecificSettings() (*ReplicationProviderSpecificSettings, bool) {
	return nil, false
}

// AsBasicReplicationProviderSpecificSettings is the BasicReplicationProviderSpecificSettings implementation for InMageAzureV2ReplicationDetails.
func (imavrd InMageAzureV2ReplicationDetails) AsBasicReplicationProviderSpecificSettings() (BasicReplicationProviderSpecificSettings, bool) {
	return &imavrd, true
}

// InMageAzureV2ReprotectInput inMageAzureV2 specific provider input.
type InMageAzureV2ReprotectInput struct {
	// MasterTargetID - The Master target Id.
	MasterTargetID *string `json:"masterTargetId,omitempty"`
	// ProcessServerID - The Process Server Id.
	ProcessServerID *string `json:"processServerId,omitempty"`
	// StorageAccountID - The storage account id.
	StorageAccountID *string `json:"storageAccountId,omitempty"`
	// RunAsAccountID - The CS account Id.
	RunAsAccountID *string `json:"runAsAccountId,omitempty"`
	// PolicyID - The Policy Id.
	PolicyID *string `json:"policyId,omitempty"`
	// LogStorageAccountID - The storage account to be used for logging during replication.
	LogStorageAccountID *string `json:"logStorageAccountId,omitempty"`
	// DisksToInclude - The disks to include list.
	DisksToInclude *[]string `json:"disksToInclude,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeReverseReplicationProviderSpecificInput', 'InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeA2A', 'InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeInMage'
	InstanceType InstanceTypeBasicReverseReplicationProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageAzureV2ReprotectInput.
func (imavri InMageAzureV2ReprotectInput) MarshalJSON() ([]byte, error) {
	imavri.InstanceType = InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeInMageAzureV2
	objectMap := make(map[string]interface{})
	if imavri.MasterTargetID != nil {
		objectMap["masterTargetId"] = imavri.MasterTargetID
	}
	if imavri.ProcessServerID != nil {
		objectMap["processServerId"] = imavri.ProcessServerID
	}
	if imavri.StorageAccountID != nil {
		objectMap["storageAccountId"] = imavri.StorageAccountID
	}
	if imavri.RunAsAccountID != nil {
		objectMap["runAsAccountId"] = imavri.RunAsAccountID
	}
	if imavri.PolicyID != nil {
		objectMap["policyId"] = imavri.PolicyID
	}
	if imavri.LogStorageAccountID != nil {
		objectMap["logStorageAccountId"] = imavri.LogStorageAccountID
	}
	if imavri.DisksToInclude != nil {
		objectMap["disksToInclude"] = imavri.DisksToInclude
	}
	if imavri.InstanceType != "" {
		objectMap["instanceType"] = imavri.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AReprotectInput is the BasicReverseReplicationProviderSpecificInput implementation for InMageAzureV2ReprotectInput.
func (imavri InMageAzureV2ReprotectInput) AsA2AReprotectInput() (*A2AReprotectInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzureReprotectInput is the BasicReverseReplicationProviderSpecificInput implementation for InMageAzureV2ReprotectInput.
func (imavri InMageAzureV2ReprotectInput) AsHyperVReplicaAzureReprotectInput() (*HyperVReplicaAzureReprotectInput, bool) {
	return nil, false
}

// AsInMageAzureV2ReprotectInput is the BasicReverseReplicationProviderSpecificInput implementation for InMageAzureV2ReprotectInput.
func (imavri InMageAzureV2ReprotectInput) AsInMageAzureV2ReprotectInput() (*InMageAzureV2ReprotectInput, bool) {
	return &imavri, true
}

// AsInMageReprotectInput is the BasicReverseReplicationProviderSpecificInput implementation for InMageAzureV2ReprotectInput.
func (imavri InMageAzureV2ReprotectInput) AsInMageReprotectInput() (*InMageReprotectInput, bool) {
	return nil, false
}

// AsReverseReplicationProviderSpecificInput is the BasicReverseReplicationProviderSpecificInput implementation for InMageAzureV2ReprotectInput.
func (imavri InMageAzureV2ReprotectInput) AsReverseReplicationProviderSpecificInput() (*ReverseReplicationProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicReverseReplicationProviderSpecificInput is the BasicReverseReplicationProviderSpecificInput implementation for InMageAzureV2ReprotectInput.
func (imavri InMageAzureV2ReprotectInput) AsBasicReverseReplicationProviderSpecificInput() (BasicReverseReplicationProviderSpecificInput, bool) {
	return &imavri, true
}

// InMageAzureV2TestFailoverInput inMageAzureV2 provider specific input for test failover.
type InMageAzureV2TestFailoverInput struct {
	// VaultLocation - Location of the vault.
	VaultLocation *string `json:"vaultLocation,omitempty"`
	// RecoveryPointID - The recovery point id to be passed to test failover to a particular recovery point. In case of latest recovery point, null should be passed.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeTestFailoverProviderSpecificInput', 'InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeA2A', 'InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeInMageRcm', 'InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeInMage'
	InstanceType InstanceTypeBasicTestFailoverProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageAzureV2TestFailoverInput.
func (imavtfi InMageAzureV2TestFailoverInput) MarshalJSON() ([]byte, error) {
	imavtfi.InstanceType = InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeInMageAzureV2
	objectMap := make(map[string]interface{})
	if imavtfi.VaultLocation != nil {
		objectMap["vaultLocation"] = imavtfi.VaultLocation
	}
	if imavtfi.RecoveryPointID != nil {
		objectMap["recoveryPointId"] = imavtfi.RecoveryPointID
	}
	if imavtfi.InstanceType != "" {
		objectMap["instanceType"] = imavtfi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2ATestFailoverInput is the BasicTestFailoverProviderSpecificInput implementation for InMageAzureV2TestFailoverInput.
func (imavtfi InMageAzureV2TestFailoverInput) AsA2ATestFailoverInput() (*A2ATestFailoverInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzureTestFailoverInput is the BasicTestFailoverProviderSpecificInput implementation for InMageAzureV2TestFailoverInput.
func (imavtfi InMageAzureV2TestFailoverInput) AsHyperVReplicaAzureTestFailoverInput() (*HyperVReplicaAzureTestFailoverInput, bool) {
	return nil, false
}

// AsInMageAzureV2TestFailoverInput is the BasicTestFailoverProviderSpecificInput implementation for InMageAzureV2TestFailoverInput.
func (imavtfi InMageAzureV2TestFailoverInput) AsInMageAzureV2TestFailoverInput() (*InMageAzureV2TestFailoverInput, bool) {
	return &imavtfi, true
}

// AsInMageRcmTestFailoverInput is the BasicTestFailoverProviderSpecificInput implementation for InMageAzureV2TestFailoverInput.
func (imavtfi InMageAzureV2TestFailoverInput) AsInMageRcmTestFailoverInput() (*InMageRcmTestFailoverInput, bool) {
	return nil, false
}

// AsInMageTestFailoverInput is the BasicTestFailoverProviderSpecificInput implementation for InMageAzureV2TestFailoverInput.
func (imavtfi InMageAzureV2TestFailoverInput) AsInMageTestFailoverInput() (*InMageTestFailoverInput, bool) {
	return nil, false
}

// AsTestFailoverProviderSpecificInput is the BasicTestFailoverProviderSpecificInput implementation for InMageAzureV2TestFailoverInput.
func (imavtfi InMageAzureV2TestFailoverInput) AsTestFailoverProviderSpecificInput() (*TestFailoverProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicTestFailoverProviderSpecificInput is the BasicTestFailoverProviderSpecificInput implementation for InMageAzureV2TestFailoverInput.
func (imavtfi InMageAzureV2TestFailoverInput) AsBasicTestFailoverProviderSpecificInput() (BasicTestFailoverProviderSpecificInput, bool) {
	return &imavtfi, true
}

// InMageAzureV2UnplannedFailoverInput inMageAzureV2 provider specific input for unplanned failover.
type InMageAzureV2UnplannedFailoverInput struct {
	// VaultLocation - Location of the vault.
	VaultLocation *string `json:"vaultLocation,omitempty"`
	// RecoveryPointID - The recovery point id to be passed to failover to a particular recovery point. In case of latest recovery point, null should be passed.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeUnplannedFailoverProviderSpecificInput', 'InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeA2A', 'InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeInMageRcm', 'InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeInMage'
	InstanceType InstanceTypeBasicUnplannedFailoverProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageAzureV2UnplannedFailoverInput.
func (imavufi InMageAzureV2UnplannedFailoverInput) MarshalJSON() ([]byte, error) {
	imavufi.InstanceType = InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeInMageAzureV2
	objectMap := make(map[string]interface{})
	if imavufi.VaultLocation != nil {
		objectMap["vaultLocation"] = imavufi.VaultLocation
	}
	if imavufi.RecoveryPointID != nil {
		objectMap["recoveryPointId"] = imavufi.RecoveryPointID
	}
	if imavufi.InstanceType != "" {
		objectMap["instanceType"] = imavufi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AUnplannedFailoverInput is the BasicUnplannedFailoverProviderSpecificInput implementation for InMageAzureV2UnplannedFailoverInput.
func (imavufi InMageAzureV2UnplannedFailoverInput) AsA2AUnplannedFailoverInput() (*A2AUnplannedFailoverInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzureUnplannedFailoverInput is the BasicUnplannedFailoverProviderSpecificInput implementation for InMageAzureV2UnplannedFailoverInput.
func (imavufi InMageAzureV2UnplannedFailoverInput) AsHyperVReplicaAzureUnplannedFailoverInput() (*HyperVReplicaAzureUnplannedFailoverInput, bool) {
	return nil, false
}

// AsInMageAzureV2UnplannedFailoverInput is the BasicUnplannedFailoverProviderSpecificInput implementation for InMageAzureV2UnplannedFailoverInput.
func (imavufi InMageAzureV2UnplannedFailoverInput) AsInMageAzureV2UnplannedFailoverInput() (*InMageAzureV2UnplannedFailoverInput, bool) {
	return &imavufi, true
}

// AsInMageRcmUnplannedFailoverInput is the BasicUnplannedFailoverProviderSpecificInput implementation for InMageAzureV2UnplannedFailoverInput.
func (imavufi InMageAzureV2UnplannedFailoverInput) AsInMageRcmUnplannedFailoverInput() (*InMageRcmUnplannedFailoverInput, bool) {
	return nil, false
}

// AsInMageUnplannedFailoverInput is the BasicUnplannedFailoverProviderSpecificInput implementation for InMageAzureV2UnplannedFailoverInput.
func (imavufi InMageAzureV2UnplannedFailoverInput) AsInMageUnplannedFailoverInput() (*InMageUnplannedFailoverInput, bool) {
	return nil, false
}

// AsUnplannedFailoverProviderSpecificInput is the BasicUnplannedFailoverProviderSpecificInput implementation for InMageAzureV2UnplannedFailoverInput.
func (imavufi InMageAzureV2UnplannedFailoverInput) AsUnplannedFailoverProviderSpecificInput() (*UnplannedFailoverProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicUnplannedFailoverProviderSpecificInput is the BasicUnplannedFailoverProviderSpecificInput implementation for InMageAzureV2UnplannedFailoverInput.
func (imavufi InMageAzureV2UnplannedFailoverInput) AsBasicUnplannedFailoverProviderSpecificInput() (BasicUnplannedFailoverProviderSpecificInput, bool) {
	return &imavufi, true
}

// InMageAzureV2UpdateReplicationProtectedItemInput inMage Azure V2 input to update replication protected
// item.
type InMageAzureV2UpdateReplicationProtectedItemInput struct {
	// RecoveryAzureV1ResourceGroupID - The recovery Azure resource group Id for classic deployment.
	RecoveryAzureV1ResourceGroupID *string `json:"recoveryAzureV1ResourceGroupId,omitempty"`
	// RecoveryAzureV2ResourceGroupID - The recovery Azure resource group Id for resource manager deployment.
	RecoveryAzureV2ResourceGroupID *string `json:"recoveryAzureV2ResourceGroupId,omitempty"`
	// UseManagedDisks - A value indicating whether managed disks should be used during failover.
	UseManagedDisks *string `json:"useManagedDisks,omitempty"`
	// TargetProximityPlacementGroupID - The target proximity placement group Id.
	TargetProximityPlacementGroupID *string `json:"targetProximityPlacementGroupId,omitempty"`
	// TargetAvailabilityZone - The target availability zone.
	TargetAvailabilityZone *string `json:"targetAvailabilityZone,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeUpdateReplicationProtectedItemProviderInput', 'InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeA2A', 'InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeInMageRcm'
	InstanceType InstanceTypeBasicUpdateReplicationProtectedItemProviderInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageAzureV2UpdateReplicationProtectedItemInput.
func (imavurpii InMageAzureV2UpdateReplicationProtectedItemInput) MarshalJSON() ([]byte, error) {
	imavurpii.InstanceType = InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeInMageAzureV2
	objectMap := make(map[string]interface{})
	if imavurpii.RecoveryAzureV1ResourceGroupID != nil {
		objectMap["recoveryAzureV1ResourceGroupId"] = imavurpii.RecoveryAzureV1ResourceGroupID
	}
	if imavurpii.RecoveryAzureV2ResourceGroupID != nil {
		objectMap["recoveryAzureV2ResourceGroupId"] = imavurpii.RecoveryAzureV2ResourceGroupID
	}
	if imavurpii.UseManagedDisks != nil {
		objectMap["useManagedDisks"] = imavurpii.UseManagedDisks
	}
	if imavurpii.TargetProximityPlacementGroupID != nil {
		objectMap["targetProximityPlacementGroupId"] = imavurpii.TargetProximityPlacementGroupID
	}
	if imavurpii.TargetAvailabilityZone != nil {
		objectMap["targetAvailabilityZone"] = imavurpii.TargetAvailabilityZone
	}
	if imavurpii.InstanceType != "" {
		objectMap["instanceType"] = imavurpii.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AUpdateReplicationProtectedItemInput is the BasicUpdateReplicationProtectedItemProviderInput implementation for InMageAzureV2UpdateReplicationProtectedItemInput.
func (imavurpii InMageAzureV2UpdateReplicationProtectedItemInput) AsA2AUpdateReplicationProtectedItemInput() (*A2AUpdateReplicationProtectedItemInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzureUpdateReplicationProtectedItemInput is the BasicUpdateReplicationProtectedItemProviderInput implementation for InMageAzureV2UpdateReplicationProtectedItemInput.
func (imavurpii InMageAzureV2UpdateReplicationProtectedItemInput) AsHyperVReplicaAzureUpdateReplicationProtectedItemInput() (*HyperVReplicaAzureUpdateReplicationProtectedItemInput, bool) {
	return nil, false
}

// AsInMageAzureV2UpdateReplicationProtectedItemInput is the BasicUpdateReplicationProtectedItemProviderInput implementation for InMageAzureV2UpdateReplicationProtectedItemInput.
func (imavurpii InMageAzureV2UpdateReplicationProtectedItemInput) AsInMageAzureV2UpdateReplicationProtectedItemInput() (*InMageAzureV2UpdateReplicationProtectedItemInput, bool) {
	return &imavurpii, true
}

// AsInMageRcmUpdateReplicationProtectedItemInput is the BasicUpdateReplicationProtectedItemProviderInput implementation for InMageAzureV2UpdateReplicationProtectedItemInput.
func (imavurpii InMageAzureV2UpdateReplicationProtectedItemInput) AsInMageRcmUpdateReplicationProtectedItemInput() (*InMageRcmUpdateReplicationProtectedItemInput, bool) {
	return nil, false
}

// AsUpdateReplicationProtectedItemProviderInput is the BasicUpdateReplicationProtectedItemProviderInput implementation for InMageAzureV2UpdateReplicationProtectedItemInput.
func (imavurpii InMageAzureV2UpdateReplicationProtectedItemInput) AsUpdateReplicationProtectedItemProviderInput() (*UpdateReplicationProtectedItemProviderInput, bool) {
	return nil, false
}

// AsBasicUpdateReplicationProtectedItemProviderInput is the BasicUpdateReplicationProtectedItemProviderInput implementation for InMageAzureV2UpdateReplicationProtectedItemInput.
func (imavurpii InMageAzureV2UpdateReplicationProtectedItemInput) AsBasicUpdateReplicationProtectedItemProviderInput() (BasicUpdateReplicationProtectedItemProviderInput, bool) {
	return &imavurpii, true
}

// InMageBasePolicyDetails base class for the policies of providers using InMage replication.
type InMageBasePolicyDetails struct {
	// RecoveryPointThresholdInMinutes - The recovery point threshold in minutes.
	RecoveryPointThresholdInMinutes *int32 `json:"recoveryPointThresholdInMinutes,omitempty"`
	// RecoveryPointHistory - The duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistory *int32 `json:"recoveryPointHistory,omitempty"`
	// AppConsistentFrequencyInMinutes - The app consistent snapshot frequency in minutes.
	AppConsistentFrequencyInMinutes *int32 `json:"appConsistentFrequencyInMinutes,omitempty"`
	// MultiVMSyncStatus - A value indicating whether multi-VM sync has to be enabled.
	MultiVMSyncStatus *string `json:"multiVmSyncStatus,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypePolicyProviderSpecificDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeA2A', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaBasePolicyDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageAzureV2', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageBasePolicyDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMage', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageRcm', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeRcmAzureMigration', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeVMwareCbt'
	InstanceType InstanceTypeBasicPolicyProviderSpecificDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageBasePolicyDetails.
func (imbpd InMageBasePolicyDetails) MarshalJSON() ([]byte, error) {
	imbpd.InstanceType = InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageBasePolicyDetails
	objectMap := make(map[string]interface{})
	if imbpd.RecoveryPointThresholdInMinutes != nil {
		objectMap["recoveryPointThresholdInMinutes"] = imbpd.RecoveryPointThresholdInMinutes
	}
	if imbpd.RecoveryPointHistory != nil {
		objectMap["recoveryPointHistory"] = imbpd.RecoveryPointHistory
	}
	if imbpd.AppConsistentFrequencyInMinutes != nil {
		objectMap["appConsistentFrequencyInMinutes"] = imbpd.AppConsistentFrequencyInMinutes
	}
	if imbpd.MultiVMSyncStatus != nil {
		objectMap["multiVmSyncStatus"] = imbpd.MultiVMSyncStatus
	}
	if imbpd.InstanceType != "" {
		objectMap["instanceType"] = imbpd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2APolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageBasePolicyDetails.
func (imbpd InMageBasePolicyDetails) AsA2APolicyDetails() (*A2APolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzurePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageBasePolicyDetails.
func (imbpd InMageBasePolicyDetails) AsHyperVReplicaAzurePolicyDetails() (*HyperVReplicaAzurePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBasePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageBasePolicyDetails.
func (imbpd InMageBasePolicyDetails) AsHyperVReplicaBasePolicyDetails() (*HyperVReplicaBasePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageBasePolicyDetails.
func (imbpd InMageBasePolicyDetails) AsHyperVReplicaBluePolicyDetails() (*HyperVReplicaBluePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageBasePolicyDetails.
func (imbpd InMageBasePolicyDetails) AsHyperVReplicaPolicyDetails() (*HyperVReplicaPolicyDetails, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageBasePolicyDetails.
func (imbpd InMageBasePolicyDetails) AsInMageAzureV2PolicyDetails() (*InMageAzureV2PolicyDetails, bool) {
	return nil, false
}

// AsInMageBasePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageBasePolicyDetails.
func (imbpd InMageBasePolicyDetails) AsInMageBasePolicyDetails() (*InMageBasePolicyDetails, bool) {
	return &imbpd, true
}

// AsInMagePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageBasePolicyDetails.
func (imbpd InMageBasePolicyDetails) AsInMagePolicyDetails() (*InMagePolicyDetails, bool) {
	return nil, false
}

// AsInMageRcmPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageBasePolicyDetails.
func (imbpd InMageBasePolicyDetails) AsInMageRcmPolicyDetails() (*InMageRcmPolicyDetails, bool) {
	return nil, false
}

// AsRcmAzureMigrationPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageBasePolicyDetails.
func (imbpd InMageBasePolicyDetails) AsRcmAzureMigrationPolicyDetails() (*RcmAzureMigrationPolicyDetails, bool) {
	return nil, false
}

// AsVmwareCbtPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageBasePolicyDetails.
func (imbpd InMageBasePolicyDetails) AsVmwareCbtPolicyDetails() (*VmwareCbtPolicyDetails, bool) {
	return nil, false
}

// AsPolicyProviderSpecificDetails is the BasicPolicyProviderSpecificDetails implementation for InMageBasePolicyDetails.
func (imbpd InMageBasePolicyDetails) AsPolicyProviderSpecificDetails() (*PolicyProviderSpecificDetails, bool) {
	return nil, false
}

// AsBasicPolicyProviderSpecificDetails is the BasicPolicyProviderSpecificDetails implementation for InMageBasePolicyDetails.
func (imbpd InMageBasePolicyDetails) AsBasicPolicyProviderSpecificDetails() (BasicPolicyProviderSpecificDetails, bool) {
	return &imbpd, true
}

// InMageDisableProtectionProviderSpecificInput inMage disable protection provider specific input.
type InMageDisableProtectionProviderSpecificInput struct {
	// ReplicaVMDeletionStatus - A value indicating whether the replica VM should be destroyed or retained. Values from Delete and Retain.
	ReplicaVMDeletionStatus *string `json:"replicaVmDeletionStatus,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeDisableProtectionProviderSpecificInput', 'InstanceTypeInMage'
	InstanceType InstanceTypeBasicDisableProtectionProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageDisableProtectionProviderSpecificInput.
func (imdppsi InMageDisableProtectionProviderSpecificInput) MarshalJSON() ([]byte, error) {
	imdppsi.InstanceType = InstanceTypeInMage
	objectMap := make(map[string]interface{})
	if imdppsi.ReplicaVMDeletionStatus != nil {
		objectMap["replicaVmDeletionStatus"] = imdppsi.ReplicaVMDeletionStatus
	}
	if imdppsi.InstanceType != "" {
		objectMap["instanceType"] = imdppsi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsInMageDisableProtectionProviderSpecificInput is the BasicDisableProtectionProviderSpecificInput implementation for InMageDisableProtectionProviderSpecificInput.
func (imdppsi InMageDisableProtectionProviderSpecificInput) AsInMageDisableProtectionProviderSpecificInput() (*InMageDisableProtectionProviderSpecificInput, bool) {
	return &imdppsi, true
}

// AsDisableProtectionProviderSpecificInput is the BasicDisableProtectionProviderSpecificInput implementation for InMageDisableProtectionProviderSpecificInput.
func (imdppsi InMageDisableProtectionProviderSpecificInput) AsDisableProtectionProviderSpecificInput() (*DisableProtectionProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicDisableProtectionProviderSpecificInput is the BasicDisableProtectionProviderSpecificInput implementation for InMageDisableProtectionProviderSpecificInput.
func (imdppsi InMageDisableProtectionProviderSpecificInput) AsBasicDisableProtectionProviderSpecificInput() (BasicDisableProtectionProviderSpecificInput, bool) {
	return &imdppsi, true
}

// InMageDiskDetails vMware/Physical specific Disk Details
type InMageDiskDetails struct {
	// DiskID - The disk Id.
	DiskID *string `json:"diskId,omitempty"`
	// DiskName - The disk name.
	DiskName *string `json:"diskName,omitempty"`
	// DiskSizeInMB - The disk size in MB.
	DiskSizeInMB *string `json:"diskSizeInMB,omitempty"`
	// DiskType - Whether disk is system disk or data disk.
	DiskType *string `json:"diskType,omitempty"`
	// DiskConfiguration - Whether disk is dynamic disk or basic disk.
	DiskConfiguration *string `json:"diskConfiguration,omitempty"`
	// VolumeList - Volumes of the disk.
	VolumeList *[]DiskVolumeDetails `json:"volumeList,omitempty"`
}

// InMageDiskExclusionInput diskExclusionInput when doing enable protection of virtual machine in InMage
// provider.
type InMageDiskExclusionInput struct {
	// VolumeOptions - The volume label based option for disk exclusion.
	VolumeOptions *[]InMageVolumeExclusionOptions `json:"volumeOptions,omitempty"`
	// DiskSignatureOptions - The guest disk signature based option for disk exclusion.
	DiskSignatureOptions *[]InMageDiskSignatureExclusionOptions `json:"diskSignatureOptions,omitempty"`
}

// InMageDiskSignatureExclusionOptions guest disk signature based disk exclusion option when doing enable
// protection of virtual machine in InMage provider.
type InMageDiskSignatureExclusionOptions struct {
	// DiskSignature - The guest signature of disk to be excluded from replication.
	DiskSignature *string `json:"diskSignature,omitempty"`
}

// InMageEnableProtectionInput vMware Azure specific enable protection input.
type InMageEnableProtectionInput struct {
	// VMFriendlyName - The Vm Name.
	VMFriendlyName *string `json:"vmFriendlyName,omitempty"`
	// MasterTargetID - The Master Target Id.
	MasterTargetID *string `json:"masterTargetId,omitempty"`
	// ProcessServerID - The Process Server Id.
	ProcessServerID *string `json:"processServerId,omitempty"`
	// RetentionDrive - The retention drive to use on the MT.
	RetentionDrive *string `json:"retentionDrive,omitempty"`
	// RunAsAccountID - The CS account Id.
	RunAsAccountID *string `json:"runAsAccountId,omitempty"`
	// MultiVMGroupID - The multi vm group Id.
	MultiVMGroupID *string `json:"multiVmGroupId,omitempty"`
	// MultiVMGroupName - The multi vm group name.
	MultiVMGroupName *string `json:"multiVmGroupName,omitempty"`
	// DatastoreName - The target data store name.
	DatastoreName *string `json:"datastoreName,omitempty"`
	// DiskExclusionInput - The enable disk exclusion input.
	DiskExclusionInput *InMageDiskExclusionInput `json:"diskExclusionInput,omitempty"`
	// DisksToInclude - The disks to include list.
	DisksToInclude *[]string `json:"disksToInclude,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeEnableProtectionProviderSpecificInput', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeA2A', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMage', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMageRcm', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeSan'
	InstanceType InstanceTypeBasicEnableProtectionProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageEnableProtectionInput.
func (imepi InMageEnableProtectionInput) MarshalJSON() ([]byte, error) {
	imepi.InstanceType = InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMage
	objectMap := make(map[string]interface{})
	if imepi.VMFriendlyName != nil {
		objectMap["vmFriendlyName"] = imepi.VMFriendlyName
	}
	if imepi.MasterTargetID != nil {
		objectMap["masterTargetId"] = imepi.MasterTargetID
	}
	if imepi.ProcessServerID != nil {
		objectMap["processServerId"] = imepi.ProcessServerID
	}
	if imepi.RetentionDrive != nil {
		objectMap["retentionDrive"] = imepi.RetentionDrive
	}
	if imepi.RunAsAccountID != nil {
		objectMap["runAsAccountId"] = imepi.RunAsAccountID
	}
	if imepi.MultiVMGroupID != nil {
		objectMap["multiVmGroupId"] = imepi.MultiVMGroupID
	}
	if imepi.MultiVMGroupName != nil {
		objectMap["multiVmGroupName"] = imepi.MultiVMGroupName
	}
	if imepi.DatastoreName != nil {
		objectMap["datastoreName"] = imepi.DatastoreName
	}
	if imepi.DiskExclusionInput != nil {
		objectMap["diskExclusionInput"] = imepi.DiskExclusionInput
	}
	if imepi.DisksToInclude != nil {
		objectMap["disksToInclude"] = imepi.DisksToInclude
	}
	if imepi.InstanceType != "" {
		objectMap["instanceType"] = imepi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for InMageEnableProtectionInput.
func (imepi InMageEnableProtectionInput) AsA2AEnableProtectionInput() (*A2AEnableProtectionInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzureEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for InMageEnableProtectionInput.
func (imepi InMageEnableProtectionInput) AsHyperVReplicaAzureEnableProtectionInput() (*HyperVReplicaAzureEnableProtectionInput, bool) {
	return nil, false
}

// AsInMageAzureV2EnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for InMageEnableProtectionInput.
func (imepi InMageEnableProtectionInput) AsInMageAzureV2EnableProtectionInput() (*InMageAzureV2EnableProtectionInput, bool) {
	return nil, false
}

// AsInMageEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for InMageEnableProtectionInput.
func (imepi InMageEnableProtectionInput) AsInMageEnableProtectionInput() (*InMageEnableProtectionInput, bool) {
	return &imepi, true
}

// AsInMageRcmEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for InMageEnableProtectionInput.
func (imepi InMageEnableProtectionInput) AsInMageRcmEnableProtectionInput() (*InMageRcmEnableProtectionInput, bool) {
	return nil, false
}

// AsSanEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for InMageEnableProtectionInput.
func (imepi InMageEnableProtectionInput) AsSanEnableProtectionInput() (*SanEnableProtectionInput, bool) {
	return nil, false
}

// AsEnableProtectionProviderSpecificInput is the BasicEnableProtectionProviderSpecificInput implementation for InMageEnableProtectionInput.
func (imepi InMageEnableProtectionInput) AsEnableProtectionProviderSpecificInput() (*EnableProtectionProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicEnableProtectionProviderSpecificInput is the BasicEnableProtectionProviderSpecificInput implementation for InMageEnableProtectionInput.
func (imepi InMageEnableProtectionInput) AsBasicEnableProtectionProviderSpecificInput() (BasicEnableProtectionProviderSpecificInput, bool) {
	return &imepi, true
}

// InMageFailoverProviderInput provider specific input for InMage failover.
type InMageFailoverProviderInput struct {
	// RecoveryPointType - The recovery point type. Values from LatestTime, LatestTag or Custom. In the case of custom, the recovery point provided by RecoveryPointId will be used. In the other two cases, recovery point id will be ignored. Possible values include: 'LatestTime', 'LatestTag', 'Custom'
	RecoveryPointType RecoveryPointType `json:"recoveryPointType,omitempty"`
	// RecoveryPointID - The recovery point id to be passed to failover to a particular recovery point. In case of latest recovery point, null should be passed.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeProviderSpecificFailoverInput', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeA2A', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMage'
	InstanceType InstanceTypeBasicProviderSpecificFailoverInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageFailoverProviderInput.
func (imfpi InMageFailoverProviderInput) MarshalJSON() ([]byte, error) {
	imfpi.InstanceType = InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMage
	objectMap := make(map[string]interface{})
	if imfpi.RecoveryPointType != "" {
		objectMap["recoveryPointType"] = imfpi.RecoveryPointType
	}
	if imfpi.RecoveryPointID != nil {
		objectMap["recoveryPointId"] = imfpi.RecoveryPointID
	}
	if imfpi.InstanceType != "" {
		objectMap["instanceType"] = imfpi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AFailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for InMageFailoverProviderInput.
func (imfpi InMageFailoverProviderInput) AsA2AFailoverProviderInput() (*A2AFailoverProviderInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzureFailbackProviderInput is the BasicProviderSpecificFailoverInput implementation for InMageFailoverProviderInput.
func (imfpi InMageFailoverProviderInput) AsHyperVReplicaAzureFailbackProviderInput() (*HyperVReplicaAzureFailbackProviderInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzureFailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for InMageFailoverProviderInput.
func (imfpi InMageFailoverProviderInput) AsHyperVReplicaAzureFailoverProviderInput() (*HyperVReplicaAzureFailoverProviderInput, bool) {
	return nil, false
}

// AsInMageAzureV2FailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for InMageFailoverProviderInput.
func (imfpi InMageFailoverProviderInput) AsInMageAzureV2FailoverProviderInput() (*InMageAzureV2FailoverProviderInput, bool) {
	return nil, false
}

// AsInMageFailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for InMageFailoverProviderInput.
func (imfpi InMageFailoverProviderInput) AsInMageFailoverProviderInput() (*InMageFailoverProviderInput, bool) {
	return &imfpi, true
}

// AsProviderSpecificFailoverInput is the BasicProviderSpecificFailoverInput implementation for InMageFailoverProviderInput.
func (imfpi InMageFailoverProviderInput) AsProviderSpecificFailoverInput() (*ProviderSpecificFailoverInput, bool) {
	return nil, false
}

// AsBasicProviderSpecificFailoverInput is the BasicProviderSpecificFailoverInput implementation for InMageFailoverProviderInput.
func (imfpi InMageFailoverProviderInput) AsBasicProviderSpecificFailoverInput() (BasicProviderSpecificFailoverInput, bool) {
	return &imfpi, true
}

// InMagePolicyDetails inMage specific protection profile details.
type InMagePolicyDetails struct {
	// RecoveryPointThresholdInMinutes - The recovery point threshold in minutes.
	RecoveryPointThresholdInMinutes *int32 `json:"recoveryPointThresholdInMinutes,omitempty"`
	// RecoveryPointHistory - The duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistory *int32 `json:"recoveryPointHistory,omitempty"`
	// AppConsistentFrequencyInMinutes - The app consistent snapshot frequency in minutes.
	AppConsistentFrequencyInMinutes *int32 `json:"appConsistentFrequencyInMinutes,omitempty"`
	// MultiVMSyncStatus - A value indicating whether multi-VM sync has to be enabled.
	MultiVMSyncStatus *string `json:"multiVmSyncStatus,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypePolicyProviderSpecificDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeA2A', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaBasePolicyDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageAzureV2', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageBasePolicyDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMage', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageRcm', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeRcmAzureMigration', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeVMwareCbt'
	InstanceType InstanceTypeBasicPolicyProviderSpecificDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMagePolicyDetails.
func (impd InMagePolicyDetails) MarshalJSON() ([]byte, error) {
	impd.InstanceType = InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMage
	objectMap := make(map[string]interface{})
	if impd.RecoveryPointThresholdInMinutes != nil {
		objectMap["recoveryPointThresholdInMinutes"] = impd.RecoveryPointThresholdInMinutes
	}
	if impd.RecoveryPointHistory != nil {
		objectMap["recoveryPointHistory"] = impd.RecoveryPointHistory
	}
	if impd.AppConsistentFrequencyInMinutes != nil {
		objectMap["appConsistentFrequencyInMinutes"] = impd.AppConsistentFrequencyInMinutes
	}
	if impd.MultiVMSyncStatus != nil {
		objectMap["multiVmSyncStatus"] = impd.MultiVMSyncStatus
	}
	if impd.InstanceType != "" {
		objectMap["instanceType"] = impd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2APolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMagePolicyDetails.
func (impd InMagePolicyDetails) AsA2APolicyDetails() (*A2APolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzurePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMagePolicyDetails.
func (impd InMagePolicyDetails) AsHyperVReplicaAzurePolicyDetails() (*HyperVReplicaAzurePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBasePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMagePolicyDetails.
func (impd InMagePolicyDetails) AsHyperVReplicaBasePolicyDetails() (*HyperVReplicaBasePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMagePolicyDetails.
func (impd InMagePolicyDetails) AsHyperVReplicaBluePolicyDetails() (*HyperVReplicaBluePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMagePolicyDetails.
func (impd InMagePolicyDetails) AsHyperVReplicaPolicyDetails() (*HyperVReplicaPolicyDetails, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMagePolicyDetails.
func (impd InMagePolicyDetails) AsInMageAzureV2PolicyDetails() (*InMageAzureV2PolicyDetails, bool) {
	return nil, false
}

// AsInMageBasePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMagePolicyDetails.
func (impd InMagePolicyDetails) AsInMageBasePolicyDetails() (*InMageBasePolicyDetails, bool) {
	return nil, false
}

// AsInMagePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMagePolicyDetails.
func (impd InMagePolicyDetails) AsInMagePolicyDetails() (*InMagePolicyDetails, bool) {
	return &impd, true
}

// AsInMageRcmPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMagePolicyDetails.
func (impd InMagePolicyDetails) AsInMageRcmPolicyDetails() (*InMageRcmPolicyDetails, bool) {
	return nil, false
}

// AsRcmAzureMigrationPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMagePolicyDetails.
func (impd InMagePolicyDetails) AsRcmAzureMigrationPolicyDetails() (*RcmAzureMigrationPolicyDetails, bool) {
	return nil, false
}

// AsVmwareCbtPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMagePolicyDetails.
func (impd InMagePolicyDetails) AsVmwareCbtPolicyDetails() (*VmwareCbtPolicyDetails, bool) {
	return nil, false
}

// AsPolicyProviderSpecificDetails is the BasicPolicyProviderSpecificDetails implementation for InMagePolicyDetails.
func (impd InMagePolicyDetails) AsPolicyProviderSpecificDetails() (*PolicyProviderSpecificDetails, bool) {
	return nil, false
}

// AsBasicPolicyProviderSpecificDetails is the BasicPolicyProviderSpecificDetails implementation for InMagePolicyDetails.
func (impd InMagePolicyDetails) AsBasicPolicyProviderSpecificDetails() (BasicPolicyProviderSpecificDetails, bool) {
	return &impd, true
}

// InMagePolicyInput vMWare Azure specific protection profile Input.
type InMagePolicyInput struct {
	// RecoveryPointThresholdInMinutes - The recovery point threshold in minutes.
	RecoveryPointThresholdInMinutes *int32 `json:"recoveryPointThresholdInMinutes,omitempty"`
	// RecoveryPointHistory - The duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistory *int32 `json:"recoveryPointHistory,omitempty"`
	// AppConsistentFrequencyInMinutes - The app consistent snapshot frequency (in minutes).
	AppConsistentFrequencyInMinutes *int32 `json:"appConsistentFrequencyInMinutes,omitempty"`
	// MultiVMSyncStatus - A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or 'Disabled'. Possible values include: 'Enable', 'Disable'
	MultiVMSyncStatus SetMultiVMSyncStatus `json:"multiVmSyncStatus,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypePolicyProviderSpecificInput', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeA2A', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMage', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMageRcm', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeVMwareCbt'
	InstanceType InstanceTypeBasicPolicyProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMagePolicyInput.
func (impi InMagePolicyInput) MarshalJSON() ([]byte, error) {
	impi.InstanceType = InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMage
	objectMap := make(map[string]interface{})
	if impi.RecoveryPointThresholdInMinutes != nil {
		objectMap["recoveryPointThresholdInMinutes"] = impi.RecoveryPointThresholdInMinutes
	}
	if impi.RecoveryPointHistory != nil {
		objectMap["recoveryPointHistory"] = impi.RecoveryPointHistory
	}
	if impi.AppConsistentFrequencyInMinutes != nil {
		objectMap["appConsistentFrequencyInMinutes"] = impi.AppConsistentFrequencyInMinutes
	}
	if impi.MultiVMSyncStatus != "" {
		objectMap["multiVmSyncStatus"] = impi.MultiVMSyncStatus
	}
	if impi.InstanceType != "" {
		objectMap["instanceType"] = impi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2APolicyCreationInput is the BasicPolicyProviderSpecificInput implementation for InMagePolicyInput.
func (impi InMagePolicyInput) AsA2APolicyCreationInput() (*A2APolicyCreationInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzurePolicyInput is the BasicPolicyProviderSpecificInput implementation for InMagePolicyInput.
func (impi InMagePolicyInput) AsHyperVReplicaAzurePolicyInput() (*HyperVReplicaAzurePolicyInput, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyInput is the BasicPolicyProviderSpecificInput implementation for InMagePolicyInput.
func (impi InMagePolicyInput) AsHyperVReplicaBluePolicyInput() (*HyperVReplicaBluePolicyInput, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyInput is the BasicPolicyProviderSpecificInput implementation for InMagePolicyInput.
func (impi InMagePolicyInput) AsHyperVReplicaPolicyInput() (*HyperVReplicaPolicyInput, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyInput is the BasicPolicyProviderSpecificInput implementation for InMagePolicyInput.
func (impi InMagePolicyInput) AsInMageAzureV2PolicyInput() (*InMageAzureV2PolicyInput, bool) {
	return nil, false
}

// AsInMagePolicyInput is the BasicPolicyProviderSpecificInput implementation for InMagePolicyInput.
func (impi InMagePolicyInput) AsInMagePolicyInput() (*InMagePolicyInput, bool) {
	return &impi, true
}

// AsInMageRcmPolicyCreationInput is the BasicPolicyProviderSpecificInput implementation for InMagePolicyInput.
func (impi InMagePolicyInput) AsInMageRcmPolicyCreationInput() (*InMageRcmPolicyCreationInput, bool) {
	return nil, false
}

// AsVMwareCbtPolicyCreationInput is the BasicPolicyProviderSpecificInput implementation for InMagePolicyInput.
func (impi InMagePolicyInput) AsVMwareCbtPolicyCreationInput() (*VMwareCbtPolicyCreationInput, bool) {
	return nil, false
}

// AsPolicyProviderSpecificInput is the BasicPolicyProviderSpecificInput implementation for InMagePolicyInput.
func (impi InMagePolicyInput) AsPolicyProviderSpecificInput() (*PolicyProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicPolicyProviderSpecificInput is the BasicPolicyProviderSpecificInput implementation for InMagePolicyInput.
func (impi InMagePolicyInput) AsBasicPolicyProviderSpecificInput() (BasicPolicyProviderSpecificInput, bool) {
	return &impi, true
}

// InMageProtectedDiskDetails inMage protected disk details.
type InMageProtectedDiskDetails struct {
	// DiskID - The disk id.
	DiskID *string `json:"diskId,omitempty"`
	// DiskName - The disk name.
	DiskName *string `json:"diskName,omitempty"`
	// ProtectionStage - The protection stage.
	ProtectionStage *string `json:"protectionStage,omitempty"`
	// HealthErrorCode - The health error code for the disk.
	HealthErrorCode *string `json:"healthErrorCode,omitempty"`
	// RpoInSeconds - The RPO in seconds.
	RpoInSeconds *int64 `json:"rpoInSeconds,omitempty"`
	// ResyncRequired - A value indicating whether resync is required for this disk.
	ResyncRequired *string `json:"resyncRequired,omitempty"`
	// ResyncProgressPercentage - The resync progress percentage.
	ResyncProgressPercentage *int32 `json:"resyncProgressPercentage,omitempty"`
	// ResyncDurationInSeconds - The resync duration in seconds.
	ResyncDurationInSeconds *int64 `json:"resyncDurationInSeconds,omitempty"`
	// DiskCapacityInBytes - The disk capacity in bytes.
	DiskCapacityInBytes *int64 `json:"diskCapacityInBytes,omitempty"`
	// FileSystemCapacityInBytes - The file system capacity in bytes.
	FileSystemCapacityInBytes *int64 `json:"fileSystemCapacityInBytes,omitempty"`
	// SourceDataInMB - The source data transit in MB.
	SourceDataInMB *float64 `json:"sourceDataInMB,omitempty"`
	// PsDataInMB - The PS data transit in MB.
	PsDataInMB *float64 `json:"psDataInMB,omitempty"`
	// TargetDataInMB - The target data transit in MB.
	TargetDataInMB *float64 `json:"targetDataInMB,omitempty"`
	// DiskResized - A value indicating whether disk is resized.
	DiskResized *string `json:"diskResized,omitempty"`
	// LastRpoCalculatedTime - The last RPO calculated time.
	LastRpoCalculatedTime *date.Time `json:"lastRpoCalculatedTime,omitempty"`
}

// InMageRcmAgentUpgradeBlockingErrorDetails inMageRcm source agent upgrade blocking error details.
type InMageRcmAgentUpgradeBlockingErrorDetails struct {
	// ErrorCode - READ-ONLY; The error code.
	ErrorCode *string `json:"errorCode,omitempty"`
	// ErrorMessage - READ-ONLY; The error message.
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// PossibleCauses - READ-ONLY; The possible causes.
	PossibleCauses *string `json:"possibleCauses,omitempty"`
	// RecommendedAction - READ-ONLY; The recommended action.
	RecommendedAction *string `json:"recommendedAction,omitempty"`
	// ErrorMessageParameters - READ-ONLY; The error message parameters.
	ErrorMessageParameters map[string]*string `json:"errorMessageParameters"`
	// ErrorTags - READ-ONLY; The error tags.
	ErrorTags map[string]*string `json:"errorTags"`
}

// MarshalJSON is the custom marshaler for InMageRcmAgentUpgradeBlockingErrorDetails.
func (imraubed InMageRcmAgentUpgradeBlockingErrorDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// InMageRcmApplyRecoveryPointInput applyRecoveryPoint input specific to InMageRcm provider.
type InMageRcmApplyRecoveryPointInput struct {
	// RecoveryPointID - The recovery point Id.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeApplyRecoveryPointProviderSpecificInput', 'InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeA2A', 'InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeInMageRcm'
	InstanceType InstanceTypeBasicApplyRecoveryPointProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageRcmApplyRecoveryPointInput.
func (imrarpi InMageRcmApplyRecoveryPointInput) MarshalJSON() ([]byte, error) {
	imrarpi.InstanceType = InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeInMageRcm
	objectMap := make(map[string]interface{})
	if imrarpi.RecoveryPointID != nil {
		objectMap["recoveryPointId"] = imrarpi.RecoveryPointID
	}
	if imrarpi.InstanceType != "" {
		objectMap["instanceType"] = imrarpi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AApplyRecoveryPointInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for InMageRcmApplyRecoveryPointInput.
func (imrarpi InMageRcmApplyRecoveryPointInput) AsA2AApplyRecoveryPointInput() (*A2AApplyRecoveryPointInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzureApplyRecoveryPointInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for InMageRcmApplyRecoveryPointInput.
func (imrarpi InMageRcmApplyRecoveryPointInput) AsHyperVReplicaAzureApplyRecoveryPointInput() (*HyperVReplicaAzureApplyRecoveryPointInput, bool) {
	return nil, false
}

// AsInMageAzureV2ApplyRecoveryPointInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for InMageRcmApplyRecoveryPointInput.
func (imrarpi InMageRcmApplyRecoveryPointInput) AsInMageAzureV2ApplyRecoveryPointInput() (*InMageAzureV2ApplyRecoveryPointInput, bool) {
	return nil, false
}

// AsInMageRcmApplyRecoveryPointInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for InMageRcmApplyRecoveryPointInput.
func (imrarpi InMageRcmApplyRecoveryPointInput) AsInMageRcmApplyRecoveryPointInput() (*InMageRcmApplyRecoveryPointInput, bool) {
	return &imrarpi, true
}

// AsApplyRecoveryPointProviderSpecificInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for InMageRcmApplyRecoveryPointInput.
func (imrarpi InMageRcmApplyRecoveryPointInput) AsApplyRecoveryPointProviderSpecificInput() (*ApplyRecoveryPointProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicApplyRecoveryPointProviderSpecificInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for InMageRcmApplyRecoveryPointInput.
func (imrarpi InMageRcmApplyRecoveryPointInput) AsBasicApplyRecoveryPointProviderSpecificInput() (BasicApplyRecoveryPointProviderSpecificInput, bool) {
	return &imrarpi, true
}

// InMageRcmDiskInput inMageRcm disk input.
type InMageRcmDiskInput struct {
	// DiskID - The disk Id.
	DiskID *string `json:"diskId,omitempty"`
	// LogStorageAccountID - The log storage account ARM Id.
	LogStorageAccountID *string `json:"logStorageAccountId,omitempty"`
	// DiskType - The disk type. Possible values include: 'StandardLRS', 'PremiumLRS', 'StandardSSDLRS'
	DiskType DiskAccountType `json:"diskType,omitempty"`
	// DiskEncryptionSetID - The disk encryption set ARM Id.
	DiskEncryptionSetID *string `json:"diskEncryptionSetId,omitempty"`
}

// InMageRcmDisksDefaultInput inMageRcm disk input.
type InMageRcmDisksDefaultInput struct {
	// LogStorageAccountID - The log storage account ARM Id.
	LogStorageAccountID *string `json:"logStorageAccountId,omitempty"`
	// DiskType - The disk type. Possible values include: 'StandardLRS', 'PremiumLRS', 'StandardSSDLRS'
	DiskType DiskAccountType `json:"diskType,omitempty"`
	// DiskEncryptionSetID - The disk encryption set ARM Id.
	DiskEncryptionSetID *string `json:"diskEncryptionSetId,omitempty"`
}

// InMageRcmEnableProtectionInput inMageRcm specific enable protection input.
type InMageRcmEnableProtectionInput struct {
	// FabricDiscoveryMachineID - The ARM Id of discovered machine.
	FabricDiscoveryMachineID *string `json:"fabricDiscoveryMachineId,omitempty"`
	// DisksToInclude - The disks to include list.
	DisksToInclude *[]InMageRcmDiskInput `json:"disksToInclude,omitempty"`
	// DisksDefault - The default disk input.
	DisksDefault *InMageRcmDisksDefaultInput `json:"disksDefault,omitempty"`
	// TargetResourceGroupID - The target resource group ARM Id.
	TargetResourceGroupID *string `json:"targetResourceGroupId,omitempty"`
	// TargetNetworkID - The selected target network ARM Id.
	TargetNetworkID *string `json:"targetNetworkId,omitempty"`
	// TestNetworkID - The selected test network ARM Id.
	TestNetworkID *string `json:"testNetworkId,omitempty"`
	// TargetSubnetName - The selected target subnet name.
	TargetSubnetName *string `json:"targetSubnetName,omitempty"`
	// TestSubnetName - The selected test subnet name.
	TestSubnetName *string `json:"testSubnetName,omitempty"`
	// TargetVMName - The target VM name.
	TargetVMName *string `json:"targetVmName,omitempty"`
	// TargetVMSize - The target VM size.
	TargetVMSize *string `json:"targetVmSize,omitempty"`
	// LicenseType - The license type. Possible values include: 'LicenseTypeNotSpecified', 'LicenseTypeNoLicenseType', 'LicenseTypeWindowsServer'
	LicenseType LicenseType `json:"licenseType,omitempty"`
	// TargetAvailabilitySetID - The target availability set ARM Id.
	TargetAvailabilitySetID *string `json:"targetAvailabilitySetId,omitempty"`
	// TargetAvailabilityZone - The target availability zone.
	TargetAvailabilityZone *string `json:"targetAvailabilityZone,omitempty"`
	// TargetProximityPlacementGroupID - The target proximity placement group Id.
	TargetProximityPlacementGroupID *string `json:"targetProximityPlacementGroupId,omitempty"`
	// TargetBootDiagnosticsStorageAccountID - The target boot diagnostics storage account ARM Id.
	TargetBootDiagnosticsStorageAccountID *string `json:"targetBootDiagnosticsStorageAccountId,omitempty"`
	// RunAsAccountID - The run-as account Id.
	RunAsAccountID *string `json:"runAsAccountId,omitempty"`
	// ProcessServerID - The process server Id.
	ProcessServerID *string `json:"processServerId,omitempty"`
	// MultiVMGroupName - The multi VM group name.
	MultiVMGroupName *string `json:"multiVmGroupName,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeEnableProtectionProviderSpecificInput', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeA2A', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMage', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMageRcm', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeSan'
	InstanceType InstanceTypeBasicEnableProtectionProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageRcmEnableProtectionInput.
func (imrepi InMageRcmEnableProtectionInput) MarshalJSON() ([]byte, error) {
	imrepi.InstanceType = InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMageRcm
	objectMap := make(map[string]interface{})
	if imrepi.FabricDiscoveryMachineID != nil {
		objectMap["fabricDiscoveryMachineId"] = imrepi.FabricDiscoveryMachineID
	}
	if imrepi.DisksToInclude != nil {
		objectMap["disksToInclude"] = imrepi.DisksToInclude
	}
	if imrepi.DisksDefault != nil {
		objectMap["disksDefault"] = imrepi.DisksDefault
	}
	if imrepi.TargetResourceGroupID != nil {
		objectMap["targetResourceGroupId"] = imrepi.TargetResourceGroupID
	}
	if imrepi.TargetNetworkID != nil {
		objectMap["targetNetworkId"] = imrepi.TargetNetworkID
	}
	if imrepi.TestNetworkID != nil {
		objectMap["testNetworkId"] = imrepi.TestNetworkID
	}
	if imrepi.TargetSubnetName != nil {
		objectMap["targetSubnetName"] = imrepi.TargetSubnetName
	}
	if imrepi.TestSubnetName != nil {
		objectMap["testSubnetName"] = imrepi.TestSubnetName
	}
	if imrepi.TargetVMName != nil {
		objectMap["targetVmName"] = imrepi.TargetVMName
	}
	if imrepi.TargetVMSize != nil {
		objectMap["targetVmSize"] = imrepi.TargetVMSize
	}
	if imrepi.LicenseType != "" {
		objectMap["licenseType"] = imrepi.LicenseType
	}
	if imrepi.TargetAvailabilitySetID != nil {
		objectMap["targetAvailabilitySetId"] = imrepi.TargetAvailabilitySetID
	}
	if imrepi.TargetAvailabilityZone != nil {
		objectMap["targetAvailabilityZone"] = imrepi.TargetAvailabilityZone
	}
	if imrepi.TargetProximityPlacementGroupID != nil {
		objectMap["targetProximityPlacementGroupId"] = imrepi.TargetProximityPlacementGroupID
	}
	if imrepi.TargetBootDiagnosticsStorageAccountID != nil {
		objectMap["targetBootDiagnosticsStorageAccountId"] = imrepi.TargetBootDiagnosticsStorageAccountID
	}
	if imrepi.RunAsAccountID != nil {
		objectMap["runAsAccountId"] = imrepi.RunAsAccountID
	}
	if imrepi.ProcessServerID != nil {
		objectMap["processServerId"] = imrepi.ProcessServerID
	}
	if imrepi.MultiVMGroupName != nil {
		objectMap["multiVmGroupName"] = imrepi.MultiVMGroupName
	}
	if imrepi.InstanceType != "" {
		objectMap["instanceType"] = imrepi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for InMageRcmEnableProtectionInput.
func (imrepi InMageRcmEnableProtectionInput) AsA2AEnableProtectionInput() (*A2AEnableProtectionInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzureEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for InMageRcmEnableProtectionInput.
func (imrepi InMageRcmEnableProtectionInput) AsHyperVReplicaAzureEnableProtectionInput() (*HyperVReplicaAzureEnableProtectionInput, bool) {
	return nil, false
}

// AsInMageAzureV2EnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for InMageRcmEnableProtectionInput.
func (imrepi InMageRcmEnableProtectionInput) AsInMageAzureV2EnableProtectionInput() (*InMageAzureV2EnableProtectionInput, bool) {
	return nil, false
}

// AsInMageEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for InMageRcmEnableProtectionInput.
func (imrepi InMageRcmEnableProtectionInput) AsInMageEnableProtectionInput() (*InMageEnableProtectionInput, bool) {
	return nil, false
}

// AsInMageRcmEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for InMageRcmEnableProtectionInput.
func (imrepi InMageRcmEnableProtectionInput) AsInMageRcmEnableProtectionInput() (*InMageRcmEnableProtectionInput, bool) {
	return &imrepi, true
}

// AsSanEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for InMageRcmEnableProtectionInput.
func (imrepi InMageRcmEnableProtectionInput) AsSanEnableProtectionInput() (*SanEnableProtectionInput, bool) {
	return nil, false
}

// AsEnableProtectionProviderSpecificInput is the BasicEnableProtectionProviderSpecificInput implementation for InMageRcmEnableProtectionInput.
func (imrepi InMageRcmEnableProtectionInput) AsEnableProtectionProviderSpecificInput() (*EnableProtectionProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicEnableProtectionProviderSpecificInput is the BasicEnableProtectionProviderSpecificInput implementation for InMageRcmEnableProtectionInput.
func (imrepi InMageRcmEnableProtectionInput) AsBasicEnableProtectionProviderSpecificInput() (BasicEnableProtectionProviderSpecificInput, bool) {
	return &imrepi, true
}

// InMageRcmEventDetails event details for InMageRcm provider.
type InMageRcmEventDetails struct {
	// ProtectedItemName - READ-ONLY; The protected item name.
	ProtectedItemName *string `json:"protectedItemName,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeEventProviderSpecificDetails', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeA2A', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplicaBaseEventDetails', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeInMageAzureV2', 'InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeInMageRcm'
	InstanceType InstanceTypeBasicEventProviderSpecificDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageRcmEventDetails.
func (imred InMageRcmEventDetails) MarshalJSON() ([]byte, error) {
	imred.InstanceType = InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeInMageRcm
	objectMap := make(map[string]interface{})
	if imred.InstanceType != "" {
		objectMap["instanceType"] = imred.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AEventDetails is the BasicEventProviderSpecificDetails implementation for InMageRcmEventDetails.
func (imred InMageRcmEventDetails) AsA2AEventDetails() (*A2AEventDetails, bool) {
	return nil, false
}

// AsHyperVReplica2012EventDetails is the BasicEventProviderSpecificDetails implementation for InMageRcmEventDetails.
func (imred InMageRcmEventDetails) AsHyperVReplica2012EventDetails() (*HyperVReplica2012EventDetails, bool) {
	return nil, false
}

// AsHyperVReplica2012R2EventDetails is the BasicEventProviderSpecificDetails implementation for InMageRcmEventDetails.
func (imred InMageRcmEventDetails) AsHyperVReplica2012R2EventDetails() (*HyperVReplica2012R2EventDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzureEventDetails is the BasicEventProviderSpecificDetails implementation for InMageRcmEventDetails.
func (imred InMageRcmEventDetails) AsHyperVReplicaAzureEventDetails() (*HyperVReplicaAzureEventDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBaseEventDetails is the BasicEventProviderSpecificDetails implementation for InMageRcmEventDetails.
func (imred InMageRcmEventDetails) AsHyperVReplicaBaseEventDetails() (*HyperVReplicaBaseEventDetails, bool) {
	return nil, false
}

// AsInMageAzureV2EventDetails is the BasicEventProviderSpecificDetails implementation for InMageRcmEventDetails.
func (imred InMageRcmEventDetails) AsInMageAzureV2EventDetails() (*InMageAzureV2EventDetails, bool) {
	return nil, false
}

// AsInMageRcmEventDetails is the BasicEventProviderSpecificDetails implementation for InMageRcmEventDetails.
func (imred InMageRcmEventDetails) AsInMageRcmEventDetails() (*InMageRcmEventDetails, bool) {
	return &imred, true
}

// AsEventProviderSpecificDetails is the BasicEventProviderSpecificDetails implementation for InMageRcmEventDetails.
func (imred InMageRcmEventDetails) AsEventProviderSpecificDetails() (*EventProviderSpecificDetails, bool) {
	return nil, false
}

// AsBasicEventProviderSpecificDetails is the BasicEventProviderSpecificDetails implementation for InMageRcmEventDetails.
func (imred InMageRcmEventDetails) AsBasicEventProviderSpecificDetails() (BasicEventProviderSpecificDetails, bool) {
	return &imred, true
}

// InMageRcmFabricCreationInput inMageRcm fabric provider specific settings.
type InMageRcmFabricCreationInput struct {
	// VmwareSiteID - The ARM Id of the VMware site.
	VmwareSiteID *string `json:"vmwareSiteId,omitempty"`
	// PhysicalSiteID - The ARM Id of the physical site.
	PhysicalSiteID *string `json:"physicalSiteId,omitempty"`
	// SourceAgentIdentity - The identity provider input for source agent authentication.
	SourceAgentIdentity *IdentityProviderInput `json:"sourceAgentIdentity,omitempty"`
	// AuthCertificate - The certificate to be used for AAD authentication.
	AuthCertificate *string `json:"authCertificate,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeFabricSpecificCreationInput', 'InstanceTypeAzure', 'InstanceTypeInMageRcm', 'InstanceTypeVMwareV2'
	InstanceType InstanceTypeBasicFabricSpecificCreationInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageRcmFabricCreationInput.
func (imrfci InMageRcmFabricCreationInput) MarshalJSON() ([]byte, error) {
	imrfci.InstanceType = InstanceTypeInMageRcm
	objectMap := make(map[string]interface{})
	if imrfci.VmwareSiteID != nil {
		objectMap["vmwareSiteId"] = imrfci.VmwareSiteID
	}
	if imrfci.PhysicalSiteID != nil {
		objectMap["physicalSiteId"] = imrfci.PhysicalSiteID
	}
	if imrfci.SourceAgentIdentity != nil {
		objectMap["sourceAgentIdentity"] = imrfci.SourceAgentIdentity
	}
	if imrfci.AuthCertificate != nil {
		objectMap["authCertificate"] = imrfci.AuthCertificate
	}
	if imrfci.InstanceType != "" {
		objectMap["instanceType"] = imrfci.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAzureFabricCreationInput is the BasicFabricSpecificCreationInput implementation for InMageRcmFabricCreationInput.
func (imrfci InMageRcmFabricCreationInput) AsAzureFabricCreationInput() (*AzureFabricCreationInput, bool) {
	return nil, false
}

// AsInMageRcmFabricCreationInput is the BasicFabricSpecificCreationInput implementation for InMageRcmFabricCreationInput.
func (imrfci InMageRcmFabricCreationInput) AsInMageRcmFabricCreationInput() (*InMageRcmFabricCreationInput, bool) {
	return &imrfci, true
}

// AsVMwareV2FabricCreationInput is the BasicFabricSpecificCreationInput implementation for InMageRcmFabricCreationInput.
func (imrfci InMageRcmFabricCreationInput) AsVMwareV2FabricCreationInput() (*VMwareV2FabricCreationInput, bool) {
	return nil, false
}

// AsFabricSpecificCreationInput is the BasicFabricSpecificCreationInput implementation for InMageRcmFabricCreationInput.
func (imrfci InMageRcmFabricCreationInput) AsFabricSpecificCreationInput() (*FabricSpecificCreationInput, bool) {
	return nil, false
}

// AsBasicFabricSpecificCreationInput is the BasicFabricSpecificCreationInput implementation for InMageRcmFabricCreationInput.
func (imrfci InMageRcmFabricCreationInput) AsBasicFabricSpecificCreationInput() (BasicFabricSpecificCreationInput, bool) {
	return &imrfci, true
}

// InMageRcmFabricSpecificDetails inMageRcm fabric specific details.
type InMageRcmFabricSpecificDetails struct {
	// VmwareSiteID - READ-ONLY; The ARM Id of the VMware site.
	VmwareSiteID *string `json:"vmwareSiteId,omitempty"`
	// PhysicalSiteID - READ-ONLY; The ARM Id of the physical site.
	PhysicalSiteID *string `json:"physicalSiteId,omitempty"`
	// ServiceEndpoint - READ-ONLY; The service endpoint.
	ServiceEndpoint *string `json:"serviceEndpoint,omitempty"`
	// ServiceResourceID - READ-ONLY; The service resource Id.
	ServiceResourceID *string `json:"serviceResourceId,omitempty"`
	// ServiceContainerID - READ-ONLY; The service container Id.
	ServiceContainerID *string `json:"serviceContainerId,omitempty"`
	// DataPlaneURI - READ-ONLY; The data plane Uri.
	DataPlaneURI *string `json:"dataPlaneUri,omitempty"`
	// ControlPlaneURI - READ-ONLY; The control plane Uri.
	ControlPlaneURI *string `json:"controlPlaneUri,omitempty"`
	// ProcessServers - READ-ONLY; The list of process servers.
	ProcessServers *[]ProcessServerDetails `json:"processServers,omitempty"`
	// RcmProxies - READ-ONLY; The list of RCM proxies.
	RcmProxies *[]RcmProxyDetails `json:"rcmProxies,omitempty"`
	// PushInstallers - READ-ONLY; The list of push installers.
	PushInstallers *[]PushInstallerDetails `json:"pushInstallers,omitempty"`
	// ReplicationAgents - READ-ONLY; The list of replication agents.
	ReplicationAgents *[]ReplicationAgentDetails `json:"replicationAgents,omitempty"`
	// ReprotectAgents - READ-ONLY; The list of reprotect agents.
	ReprotectAgents *[]ReprotectAgentDetails `json:"reprotectAgents,omitempty"`
	// Dras - READ-ONLY; The list of DRAs.
	Dras *[]DraDetails `json:"dras,omitempty"`
	// AgentDetails - READ-ONLY; The list of agent details.
	AgentDetails *[]AgentDetails `json:"agentDetails,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeFabricSpecificDetails', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeAzure', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeHyperVSite', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeInMageRcm', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMM', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMware', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMwareV2'
	InstanceType InstanceTypeBasicFabricSpecificDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageRcmFabricSpecificDetails.
func (imrfsd InMageRcmFabricSpecificDetails) MarshalJSON() ([]byte, error) {
	imrfsd.InstanceType = InstanceTypeBasicFabricSpecificDetailsInstanceTypeInMageRcm
	objectMap := make(map[string]interface{})
	if imrfsd.InstanceType != "" {
		objectMap["instanceType"] = imrfsd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAzureFabricSpecificDetails is the BasicFabricSpecificDetails implementation for InMageRcmFabricSpecificDetails.
func (imrfsd InMageRcmFabricSpecificDetails) AsAzureFabricSpecificDetails() (*AzureFabricSpecificDetails, bool) {
	return nil, false
}

// AsHyperVSiteDetails is the BasicFabricSpecificDetails implementation for InMageRcmFabricSpecificDetails.
func (imrfsd InMageRcmFabricSpecificDetails) AsHyperVSiteDetails() (*HyperVSiteDetails, bool) {
	return nil, false
}

// AsInMageRcmFabricSpecificDetails is the BasicFabricSpecificDetails implementation for InMageRcmFabricSpecificDetails.
func (imrfsd InMageRcmFabricSpecificDetails) AsInMageRcmFabricSpecificDetails() (*InMageRcmFabricSpecificDetails, bool) {
	return &imrfsd, true
}

// AsVmmDetails is the BasicFabricSpecificDetails implementation for InMageRcmFabricSpecificDetails.
func (imrfsd InMageRcmFabricSpecificDetails) AsVmmDetails() (*VmmDetails, bool) {
	return nil, false
}

// AsVMwareDetails is the BasicFabricSpecificDetails implementation for InMageRcmFabricSpecificDetails.
func (imrfsd InMageRcmFabricSpecificDetails) AsVMwareDetails() (*VMwareDetails, bool) {
	return nil, false
}

// AsVMwareV2FabricSpecificDetails is the BasicFabricSpecificDetails implementation for InMageRcmFabricSpecificDetails.
func (imrfsd InMageRcmFabricSpecificDetails) AsVMwareV2FabricSpecificDetails() (*VMwareV2FabricSpecificDetails, bool) {
	return nil, false
}

// AsFabricSpecificDetails is the BasicFabricSpecificDetails implementation for InMageRcmFabricSpecificDetails.
func (imrfsd InMageRcmFabricSpecificDetails) AsFabricSpecificDetails() (*FabricSpecificDetails, bool) {
	return nil, false
}

// AsBasicFabricSpecificDetails is the BasicFabricSpecificDetails implementation for InMageRcmFabricSpecificDetails.
func (imrfsd InMageRcmFabricSpecificDetails) AsBasicFabricSpecificDetails() (BasicFabricSpecificDetails, bool) {
	return &imrfsd, true
}

// InMageRcmLastAgentUpgradeErrorDetails inMageRcm last source agent upgrade error details.
type InMageRcmLastAgentUpgradeErrorDetails struct {
	// ErrorCode - READ-ONLY; The error code.
	ErrorCode *string `json:"errorCode,omitempty"`
	// ErrorMessage - READ-ONLY; The error message.
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// PossibleCauses - READ-ONLY; The possible causes.
	PossibleCauses *string `json:"possibleCauses,omitempty"`
	// RecommendedAction - READ-ONLY; The recommended action.
	RecommendedAction *string `json:"recommendedAction,omitempty"`
	// ErrorMessageParameters - READ-ONLY; The error message parameters.
	ErrorMessageParameters map[string]*string `json:"errorMessageParameters"`
	// ErrorTags - READ-ONLY; The error tags.
	ErrorTags map[string]*string `json:"errorTags"`
}

// MarshalJSON is the custom marshaler for InMageRcmLastAgentUpgradeErrorDetails.
func (imrlaued InMageRcmLastAgentUpgradeErrorDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// InMageRcmMobilityAgentDetails inMageRcm mobility agent details.
type InMageRcmMobilityAgentDetails struct {
	// Version - READ-ONLY; The agent version.
	Version *string `json:"version,omitempty"`
	// LatestVersion - READ-ONLY; The latest agent version available.
	LatestVersion *string `json:"latestVersion,omitempty"`
	// DriverVersion - READ-ONLY; The driver version.
	DriverVersion *string `json:"driverVersion,omitempty"`
	// LatestUpgradableVersionWithoutReboot - READ-ONLY; The latest upgradeable version available without reboot.
	LatestUpgradableVersionWithoutReboot *string `json:"latestUpgradableVersionWithoutReboot,omitempty"`
	// AgentVersionExpiryDate - READ-ONLY; The agent version expiry date.
	AgentVersionExpiryDate *date.Time `json:"agentVersionExpiryDate,omitempty"`
	// DriverVersionExpiryDate - READ-ONLY; The driver version expiry date.
	DriverVersionExpiryDate *date.Time `json:"driverVersionExpiryDate,omitempty"`
	// LastHeartbeatUtc - READ-ONLY; The time of the last heartbeat received from the agent.
	LastHeartbeatUtc *date.Time `json:"lastHeartbeatUtc,omitempty"`
	// ReasonsBlockingUpgrade - READ-ONLY; The whether update is possible or not.
	ReasonsBlockingUpgrade *[]AgentUpgradeBlockedReason `json:"reasonsBlockingUpgrade,omitempty"`
	// IsUpgradeable - READ-ONLY; A value indicating whether agent is upgradeable or not.
	IsUpgradeable *string `json:"isUpgradeable,omitempty"`
}

// InMageRcmNicDetails inMageRcm NIC details.
type InMageRcmNicDetails struct {
	// NicID - READ-ONLY; The NIC Id.
	NicID *string `json:"nicId,omitempty"`
	// IsPrimaryNic - READ-ONLY; A value indicating whether this is the primary NIC.
	IsPrimaryNic *string `json:"isPrimaryNic,omitempty"`
	// IsSelectedForFailover - READ-ONLY; A value indicating whether this NIC is selected for failover.
	IsSelectedForFailover *string `json:"isSelectedForFailover,omitempty"`
	// SourceIPAddress - READ-ONLY; The source IP address.
	SourceIPAddress *string `json:"sourceIPAddress,omitempty"`
	// SourceIPAddressType - READ-ONLY; The source IP address type. Possible values include: 'Dynamic', 'Static'
	SourceIPAddressType EthernetAddressType `json:"sourceIPAddressType,omitempty"`
	// SourceNetworkID - READ-ONLY; Source network Id.
	SourceNetworkID *string `json:"sourceNetworkId,omitempty"`
	// SourceSubnetName - READ-ONLY; Source subnet name.
	SourceSubnetName *string `json:"sourceSubnetName,omitempty"`
	// TargetIPAddress - READ-ONLY; The target IP address.
	TargetIPAddress *string `json:"targetIPAddress,omitempty"`
	// TargetIPAddressType - READ-ONLY; The target IP address type. Possible values include: 'Dynamic', 'Static'
	TargetIPAddressType EthernetAddressType `json:"targetIPAddressType,omitempty"`
	// TargetSubnetName - READ-ONLY; Target subnet name.
	TargetSubnetName *string `json:"targetSubnetName,omitempty"`
	// TestSubnetName - READ-ONLY; Test subnet name.
	TestSubnetName *string `json:"testSubnetName,omitempty"`
	// TestIPAddress - READ-ONLY; The test IP address.
	TestIPAddress *string `json:"testIPAddress,omitempty"`
	// TestIPAddressType - READ-ONLY; The test IP address type. Possible values include: 'Dynamic', 'Static'
	TestIPAddressType EthernetAddressType `json:"testIPAddressType,omitempty"`
}

// InMageRcmNicInput inMageRcm NIC input.
type InMageRcmNicInput struct {
	// NicID - The NIC Id.
	NicID *string `json:"nicId,omitempty"`
	// IsPrimaryNic - A value indicating whether this is the primary NIC.
	IsPrimaryNic *string `json:"isPrimaryNic,omitempty"`
	// IsSelectedForFailover - A value indicating whether this NIC is selected for failover.
	IsSelectedForFailover *string `json:"isSelectedForFailover,omitempty"`
	// TargetSubnetName - Target subnet name.
	TargetSubnetName *string `json:"targetSubnetName,omitempty"`
	// TargetStaticIPAddress - The target static IP address.
	TargetStaticIPAddress *string `json:"targetStaticIPAddress,omitempty"`
	// TestSubnetName - The test subnet name.
	TestSubnetName *string `json:"testSubnetName,omitempty"`
	// TestStaticIPAddress - The test static IP address.
	TestStaticIPAddress *string `json:"testStaticIPAddress,omitempty"`
}

// InMageRcmPolicyCreationInput inMageRcm policy creation input.
type InMageRcmPolicyCreationInput struct {
	// RecoveryPointHistoryInMinutes - The duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistoryInMinutes *int32 `json:"recoveryPointHistoryInMinutes,omitempty"`
	// CrashConsistentFrequencyInMinutes - The crash consistent snapshot frequency (in minutes).
	CrashConsistentFrequencyInMinutes *int32 `json:"crashConsistentFrequencyInMinutes,omitempty"`
	// AppConsistentFrequencyInMinutes - The app consistent snapshot frequency (in minutes).
	AppConsistentFrequencyInMinutes *int32 `json:"appConsistentFrequencyInMinutes,omitempty"`
	// EnableMultiVMSync - A value indicating whether multi-VM sync has to be enabled.
	EnableMultiVMSync *string `json:"enableMultiVmSync,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypePolicyProviderSpecificInput', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeA2A', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMage', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMageRcm', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeVMwareCbt'
	InstanceType InstanceTypeBasicPolicyProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageRcmPolicyCreationInput.
func (imrpci InMageRcmPolicyCreationInput) MarshalJSON() ([]byte, error) {
	imrpci.InstanceType = InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMageRcm
	objectMap := make(map[string]interface{})
	if imrpci.RecoveryPointHistoryInMinutes != nil {
		objectMap["recoveryPointHistoryInMinutes"] = imrpci.RecoveryPointHistoryInMinutes
	}
	if imrpci.CrashConsistentFrequencyInMinutes != nil {
		objectMap["crashConsistentFrequencyInMinutes"] = imrpci.CrashConsistentFrequencyInMinutes
	}
	if imrpci.AppConsistentFrequencyInMinutes != nil {
		objectMap["appConsistentFrequencyInMinutes"] = imrpci.AppConsistentFrequencyInMinutes
	}
	if imrpci.EnableMultiVMSync != nil {
		objectMap["enableMultiVmSync"] = imrpci.EnableMultiVMSync
	}
	if imrpci.InstanceType != "" {
		objectMap["instanceType"] = imrpci.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2APolicyCreationInput is the BasicPolicyProviderSpecificInput implementation for InMageRcmPolicyCreationInput.
func (imrpci InMageRcmPolicyCreationInput) AsA2APolicyCreationInput() (*A2APolicyCreationInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzurePolicyInput is the BasicPolicyProviderSpecificInput implementation for InMageRcmPolicyCreationInput.
func (imrpci InMageRcmPolicyCreationInput) AsHyperVReplicaAzurePolicyInput() (*HyperVReplicaAzurePolicyInput, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyInput is the BasicPolicyProviderSpecificInput implementation for InMageRcmPolicyCreationInput.
func (imrpci InMageRcmPolicyCreationInput) AsHyperVReplicaBluePolicyInput() (*HyperVReplicaBluePolicyInput, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyInput is the BasicPolicyProviderSpecificInput implementation for InMageRcmPolicyCreationInput.
func (imrpci InMageRcmPolicyCreationInput) AsHyperVReplicaPolicyInput() (*HyperVReplicaPolicyInput, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyInput is the BasicPolicyProviderSpecificInput implementation for InMageRcmPolicyCreationInput.
func (imrpci InMageRcmPolicyCreationInput) AsInMageAzureV2PolicyInput() (*InMageAzureV2PolicyInput, bool) {
	return nil, false
}

// AsInMagePolicyInput is the BasicPolicyProviderSpecificInput implementation for InMageRcmPolicyCreationInput.
func (imrpci InMageRcmPolicyCreationInput) AsInMagePolicyInput() (*InMagePolicyInput, bool) {
	return nil, false
}

// AsInMageRcmPolicyCreationInput is the BasicPolicyProviderSpecificInput implementation for InMageRcmPolicyCreationInput.
func (imrpci InMageRcmPolicyCreationInput) AsInMageRcmPolicyCreationInput() (*InMageRcmPolicyCreationInput, bool) {
	return &imrpci, true
}

// AsVMwareCbtPolicyCreationInput is the BasicPolicyProviderSpecificInput implementation for InMageRcmPolicyCreationInput.
func (imrpci InMageRcmPolicyCreationInput) AsVMwareCbtPolicyCreationInput() (*VMwareCbtPolicyCreationInput, bool) {
	return nil, false
}

// AsPolicyProviderSpecificInput is the BasicPolicyProviderSpecificInput implementation for InMageRcmPolicyCreationInput.
func (imrpci InMageRcmPolicyCreationInput) AsPolicyProviderSpecificInput() (*PolicyProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicPolicyProviderSpecificInput is the BasicPolicyProviderSpecificInput implementation for InMageRcmPolicyCreationInput.
func (imrpci InMageRcmPolicyCreationInput) AsBasicPolicyProviderSpecificInput() (BasicPolicyProviderSpecificInput, bool) {
	return &imrpci, true
}

// InMageRcmPolicyDetails inMageRcm specific policy details.
type InMageRcmPolicyDetails struct {
	// RecoveryPointHistoryInMinutes - READ-ONLY; The duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistoryInMinutes *int32 `json:"recoveryPointHistoryInMinutes,omitempty"`
	// AppConsistentFrequencyInMinutes - READ-ONLY; The app consistent snapshot frequency in minutes.
	AppConsistentFrequencyInMinutes *int32 `json:"appConsistentFrequencyInMinutes,omitempty"`
	// CrashConsistentFrequencyInMinutes - READ-ONLY; The crash consistent snapshot frequency in minutes.
	CrashConsistentFrequencyInMinutes *int32 `json:"crashConsistentFrequencyInMinutes,omitempty"`
	// EnableMultiVMSync - READ-ONLY; A value indicating whether multi-VM sync has to be enabled.
	EnableMultiVMSync *string `json:"enableMultiVmSync,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypePolicyProviderSpecificDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeA2A', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaBasePolicyDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageAzureV2', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageBasePolicyDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMage', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageRcm', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeRcmAzureMigration', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeVMwareCbt'
	InstanceType InstanceTypeBasicPolicyProviderSpecificDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageRcmPolicyDetails.
func (imrpd InMageRcmPolicyDetails) MarshalJSON() ([]byte, error) {
	imrpd.InstanceType = InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageRcm
	objectMap := make(map[string]interface{})
	if imrpd.InstanceType != "" {
		objectMap["instanceType"] = imrpd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2APolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageRcmPolicyDetails.
func (imrpd InMageRcmPolicyDetails) AsA2APolicyDetails() (*A2APolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzurePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageRcmPolicyDetails.
func (imrpd InMageRcmPolicyDetails) AsHyperVReplicaAzurePolicyDetails() (*HyperVReplicaAzurePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBasePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageRcmPolicyDetails.
func (imrpd InMageRcmPolicyDetails) AsHyperVReplicaBasePolicyDetails() (*HyperVReplicaBasePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageRcmPolicyDetails.
func (imrpd InMageRcmPolicyDetails) AsHyperVReplicaBluePolicyDetails() (*HyperVReplicaBluePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageRcmPolicyDetails.
func (imrpd InMageRcmPolicyDetails) AsHyperVReplicaPolicyDetails() (*HyperVReplicaPolicyDetails, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageRcmPolicyDetails.
func (imrpd InMageRcmPolicyDetails) AsInMageAzureV2PolicyDetails() (*InMageAzureV2PolicyDetails, bool) {
	return nil, false
}

// AsInMageBasePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageRcmPolicyDetails.
func (imrpd InMageRcmPolicyDetails) AsInMageBasePolicyDetails() (*InMageBasePolicyDetails, bool) {
	return nil, false
}

// AsInMagePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageRcmPolicyDetails.
func (imrpd InMageRcmPolicyDetails) AsInMagePolicyDetails() (*InMagePolicyDetails, bool) {
	return nil, false
}

// AsInMageRcmPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageRcmPolicyDetails.
func (imrpd InMageRcmPolicyDetails) AsInMageRcmPolicyDetails() (*InMageRcmPolicyDetails, bool) {
	return &imrpd, true
}

// AsRcmAzureMigrationPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageRcmPolicyDetails.
func (imrpd InMageRcmPolicyDetails) AsRcmAzureMigrationPolicyDetails() (*RcmAzureMigrationPolicyDetails, bool) {
	return nil, false
}

// AsVmwareCbtPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageRcmPolicyDetails.
func (imrpd InMageRcmPolicyDetails) AsVmwareCbtPolicyDetails() (*VmwareCbtPolicyDetails, bool) {
	return nil, false
}

// AsPolicyProviderSpecificDetails is the BasicPolicyProviderSpecificDetails implementation for InMageRcmPolicyDetails.
func (imrpd InMageRcmPolicyDetails) AsPolicyProviderSpecificDetails() (*PolicyProviderSpecificDetails, bool) {
	return nil, false
}

// AsBasicPolicyProviderSpecificDetails is the BasicPolicyProviderSpecificDetails implementation for InMageRcmPolicyDetails.
func (imrpd InMageRcmPolicyDetails) AsBasicPolicyProviderSpecificDetails() (BasicPolicyProviderSpecificDetails, bool) {
	return &imrpd, true
}

// InMageRcmProtectedDiskDetails inMageRcm protected disk details.
type InMageRcmProtectedDiskDetails struct {
	// DiskID - READ-ONLY; The disk Id.
	DiskID *string `json:"diskId,omitempty"`
	// DiskName - READ-ONLY; The disk name.
	DiskName *string `json:"diskName,omitempty"`
	// IsOSDisk - READ-ONLY; A value indicating whether the disk is the OS disk.
	IsOSDisk *string `json:"isOSDisk,omitempty"`
	// CapacityInBytes - READ-ONLY; The disk capacity in bytes.
	CapacityInBytes *int64 `json:"capacityInBytes,omitempty"`
	// LogStorageAccountID - READ-ONLY; The log storage account ARM Id.
	LogStorageAccountID *string `json:"logStorageAccountId,omitempty"`
	// DiskEncryptionSetID - READ-ONLY; The disk encryption set ARM Id.
	DiskEncryptionSetID *string `json:"diskEncryptionSetId,omitempty"`
	// SeedManagedDiskID - READ-ONLY; The ARM Id of the seed managed disk.
	SeedManagedDiskID *string `json:"seedManagedDiskId,omitempty"`
	// TargetManagedDiskID - READ-ONLY; The ARM Id of the target managed disk.
	TargetManagedDiskID *string `json:"targetManagedDiskId,omitempty"`
	// DiskType - READ-ONLY; The disk type. Possible values include: 'StandardLRS', 'PremiumLRS', 'StandardSSDLRS'
	DiskType DiskAccountType `json:"diskType,omitempty"`
}

// InMageRcmRecoveryPointDetails inMageRcm provider specific recovery point details.
type InMageRcmRecoveryPointDetails struct {
	// IsMultiVMSyncPoint - READ-ONLY; A value indicating whether the recovery point is multi VM consistent.
	IsMultiVMSyncPoint *string `json:"isMultiVmSyncPoint,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicProviderSpecificRecoveryPointDetailsInstanceTypeProviderSpecificRecoveryPointDetails', 'InstanceTypeBasicProviderSpecificRecoveryPointDetailsInstanceTypeA2A', 'InstanceTypeBasicProviderSpecificRecoveryPointDetailsInstanceTypeInMageAzureV2', 'InstanceTypeBasicProviderSpecificRecoveryPointDetailsInstanceTypeInMageRcm'
	InstanceType InstanceTypeBasicProviderSpecificRecoveryPointDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageRcmRecoveryPointDetails.
func (imrrpd InMageRcmRecoveryPointDetails) MarshalJSON() ([]byte, error) {
	imrrpd.InstanceType = InstanceTypeBasicProviderSpecificRecoveryPointDetailsInstanceTypeInMageRcm
	objectMap := make(map[string]interface{})
	if imrrpd.InstanceType != "" {
		objectMap["instanceType"] = imrrpd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2ARecoveryPointDetails is the BasicProviderSpecificRecoveryPointDetails implementation for InMageRcmRecoveryPointDetails.
func (imrrpd InMageRcmRecoveryPointDetails) AsA2ARecoveryPointDetails() (*A2ARecoveryPointDetails, bool) {
	return nil, false
}

// AsInMageAzureV2RecoveryPointDetails is the BasicProviderSpecificRecoveryPointDetails implementation for InMageRcmRecoveryPointDetails.
func (imrrpd InMageRcmRecoveryPointDetails) AsInMageAzureV2RecoveryPointDetails() (*InMageAzureV2RecoveryPointDetails, bool) {
	return nil, false
}

// AsInMageRcmRecoveryPointDetails is the BasicProviderSpecificRecoveryPointDetails implementation for InMageRcmRecoveryPointDetails.
func (imrrpd InMageRcmRecoveryPointDetails) AsInMageRcmRecoveryPointDetails() (*InMageRcmRecoveryPointDetails, bool) {
	return &imrrpd, true
}

// AsProviderSpecificRecoveryPointDetails is the BasicProviderSpecificRecoveryPointDetails implementation for InMageRcmRecoveryPointDetails.
func (imrrpd InMageRcmRecoveryPointDetails) AsProviderSpecificRecoveryPointDetails() (*ProviderSpecificRecoveryPointDetails, bool) {
	return nil, false
}

// AsBasicProviderSpecificRecoveryPointDetails is the BasicProviderSpecificRecoveryPointDetails implementation for InMageRcmRecoveryPointDetails.
func (imrrpd InMageRcmRecoveryPointDetails) AsBasicProviderSpecificRecoveryPointDetails() (BasicProviderSpecificRecoveryPointDetails, bool) {
	return &imrrpd, true
}

// InMageRcmReplicationDetails inMageRcm provider specific details.
type InMageRcmReplicationDetails struct {
	// InternalIdentifier - READ-ONLY; The virtual machine internal identifier.
	InternalIdentifier *string `json:"internalIdentifier,omitempty"`
	// FabricDiscoveryMachineID - READ-ONLY; The ARM Id of the discovered VM.
	FabricDiscoveryMachineID *string `json:"fabricDiscoveryMachineId,omitempty"`
	// MultiVMGroupName - READ-ONLY; The multi VM group name.
	MultiVMGroupName *string `json:"multiVmGroupName,omitempty"`
	// DiscoveryType - READ-ONLY; The type of the discovered VM.
	DiscoveryType *string `json:"discoveryType,omitempty"`
	// ProcessServerID - READ-ONLY; The process server Id.
	ProcessServerID *string `json:"processServerId,omitempty"`
	// ProcessorCoreCount - READ-ONLY; The processor core count.
	ProcessorCoreCount *int32 `json:"processorCoreCount,omitempty"`
	// AllocatedMemoryInMB - READ-ONLY; The allocated memory in MB.
	AllocatedMemoryInMB *float64 `json:"allocatedMemoryInMB,omitempty"`
	// ProcessServerName - READ-ONLY; The process server name.
	ProcessServerName *string `json:"processServerName,omitempty"`
	// RunAsAccountID - READ-ONLY; The run-as account Id.
	RunAsAccountID *string `json:"runAsAccountId,omitempty"`
	// OsType - READ-ONLY; The type of the OS on the VM.
	OsType *string `json:"osType,omitempty"`
	// FirmwareType - READ-ONLY; The firmware type.
	FirmwareType *string `json:"firmwareType,omitempty"`
	// TargetGeneration - READ-ONLY; The target generation.
	TargetGeneration *string `json:"targetGeneration,omitempty"`
	// LicenseType - READ-ONLY; License Type of the VM to be used.
	LicenseType *string `json:"licenseType,omitempty"`
	// TargetVMName - READ-ONLY; Target VM name.
	TargetVMName *string `json:"targetVmName,omitempty"`
	// TargetVMSize - READ-ONLY; The target VM size.
	TargetVMSize *string `json:"targetVmSize,omitempty"`
	// TargetResourceGroupID - READ-ONLY; The target resource group Id.
	TargetResourceGroupID *string `json:"targetResourceGroupId,omitempty"`
	// TargetAvailabilitySetID - READ-ONLY; The target availability set Id.
	TargetAvailabilitySetID *string `json:"targetAvailabilitySetId,omitempty"`
	// TargetAvailabilityZone - READ-ONLY; The target availability zone.
	TargetAvailabilityZone *string `json:"targetAvailabilityZone,omitempty"`
	// TargetProximityPlacementGroupID - READ-ONLY; The target proximity placement group Id.
	TargetProximityPlacementGroupID *string `json:"targetProximityPlacementGroupId,omitempty"`
	// TargetBootDiagnosticsStorageAccountID - READ-ONLY; The target boot diagnostics storage account ARM Id.
	TargetBootDiagnosticsStorageAccountID *string `json:"targetBootDiagnosticsStorageAccountId,omitempty"`
	// TargetNetworkID - READ-ONLY; The target network Id.
	TargetNetworkID *string `json:"targetNetworkId,omitempty"`
	// TestNetworkID - READ-ONLY; The test network Id.
	TestNetworkID *string `json:"testNetworkId,omitempty"`
	// FailoverRecoveryPointID - READ-ONLY; The recovery point Id to which the VM was failed over.
	FailoverRecoveryPointID *string `json:"failoverRecoveryPointId,omitempty"`
	// LastRecoveryPointReceived - READ-ONLY; The last recovery point received time.
	LastRecoveryPointReceived *date.Time `json:"lastRecoveryPointReceived,omitempty"`
	// LastRpoInSeconds - READ-ONLY; The last recovery point objective value.
	LastRpoInSeconds *int64 `json:"lastRpoInSeconds,omitempty"`
	// LastRpoCalculatedTime - READ-ONLY; The last recovery point objective calculated time.
	LastRpoCalculatedTime *date.Time `json:"lastRpoCalculatedTime,omitempty"`
	// LastRecoveryPointID - READ-ONLY; The last recovery point Id.
	LastRecoveryPointID *string `json:"lastRecoveryPointId,omitempty"`
	// InitialReplicationProgressPercentage - READ-ONLY; The initial replication progress percentage. This is calculated based on total bytes processed for all disks in the source VM.
	InitialReplicationProgressPercentage *int32 `json:"initialReplicationProgressPercentage,omitempty"`
	// InitialReplicationProcessedBytes - READ-ONLY; The initial replication processed bytes. This includes sum of total bytes transferred and matched bytes on all selected disks in source VM.
	InitialReplicationProcessedBytes *int64 `json:"initialReplicationProcessedBytes,omitempty"`
	// InitialReplicationTransferredBytes - READ-ONLY; The initial replication transferred bytes from source VM to azure for all selected disks on source VM.
	InitialReplicationTransferredBytes *int64 `json:"initialReplicationTransferredBytes,omitempty"`
	// ResyncProgressPercentage - READ-ONLY; The resync progress percentage. This is calculated based on total bytes processed for all disks in the source VM.
	ResyncProgressPercentage *int32 `json:"resyncProgressPercentage,omitempty"`
	// ResyncProcessedBytes - READ-ONLY; The resync processed bytes. This includes sum of total bytes transferred and matched bytes on all selected disks in source VM.
	ResyncProcessedBytes *int64 `json:"resyncProcessedBytes,omitempty"`
	// ResyncTransferredBytes - READ-ONLY; The resync transferred bytes from source VM to azure for all selected disks on source VM.
	ResyncTransferredBytes *int64 `json:"resyncTransferredBytes,omitempty"`
	// ResyncRequired - READ-ONLY; A value indicating whether resync is required.
	ResyncRequired *string `json:"resyncRequired,omitempty"`
	// ResyncState - READ-ONLY; The resync state. Possible values include: 'ResyncStateNone', 'ResyncStatePreparedForResynchronization', 'ResyncStateStartedResynchronization'
	ResyncState ResyncState `json:"resyncState,omitempty"`
	// AgentUpgradeState - READ-ONLY; The agent auto upgrade state. Possible values include: 'MobilityAgentUpgradeStateNone', 'MobilityAgentUpgradeStateStarted', 'MobilityAgentUpgradeStateCompleted', 'MobilityAgentUpgradeStateCommit'
	AgentUpgradeState MobilityAgentUpgradeState `json:"agentUpgradeState,omitempty"`
	// LastAgentUpgradeType - READ-ONLY; The last agent upgrade type.
	LastAgentUpgradeType *string `json:"lastAgentUpgradeType,omitempty"`
	// LastAgentUpgradeFailedJobID - READ-ONLY; The last agent upgrade failed or cancelled job Id.
	LastAgentUpgradeFailedJobID *string `json:"lastAgentUpgradeFailedJobId,omitempty"`
	// ProtectedDisks - READ-ONLY; The list of protected disks.
	ProtectedDisks *[]InMageRcmProtectedDiskDetails `json:"protectedDisks,omitempty"`
	// IsLastUpgradeSuccessful - READ-ONLY; A value indicating whether last agent upgrade was successful or not.
	IsLastUpgradeSuccessful *string `json:"isLastUpgradeSuccessful,omitempty"`
	// MobilityAgentDetails - READ-ONLY; The mobility agent information.
	MobilityAgentDetails *InMageRcmMobilityAgentDetails `json:"mobilityAgentDetails,omitempty"`
	// LastAgentUpgradeErrorDetails - READ-ONLY; The last agent upgrade error information.
	LastAgentUpgradeErrorDetails *[]InMageRcmLastAgentUpgradeErrorDetails `json:"lastAgentUpgradeErrorDetails,omitempty"`
	// AgentUpgradeBlockingErrorDetails - READ-ONLY; The agent upgrade blocking error information.
	AgentUpgradeBlockingErrorDetails *[]InMageRcmAgentUpgradeBlockingErrorDetails `json:"agentUpgradeBlockingErrorDetails,omitempty"`
	// VMNics - READ-ONLY; The network details.
	VMNics *[]InMageRcmNicDetails `json:"vmNics,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeReplicationProviderSpecificSettings', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeA2A', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaBaseReplicationDetails', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMageAzureV2', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMageRcm', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMage'
	InstanceType InstanceTypeBasicReplicationProviderSpecificSettings `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageRcmReplicationDetails.
func (imrrd InMageRcmReplicationDetails) MarshalJSON() ([]byte, error) {
	imrrd.InstanceType = InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMageRcm
	objectMap := make(map[string]interface{})
	if imrrd.InstanceType != "" {
		objectMap["instanceType"] = imrrd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for InMageRcmReplicationDetails.
func (imrrd InMageRcmReplicationDetails) AsA2AReplicationDetails() (*A2AReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzureReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for InMageRcmReplicationDetails.
func (imrrd InMageRcmReplicationDetails) AsHyperVReplicaAzureReplicationDetails() (*HyperVReplicaAzureReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBaseReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for InMageRcmReplicationDetails.
func (imrrd InMageRcmReplicationDetails) AsHyperVReplicaBaseReplicationDetails() (*HyperVReplicaBaseReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBlueReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for InMageRcmReplicationDetails.
func (imrrd InMageRcmReplicationDetails) AsHyperVReplicaBlueReplicationDetails() (*HyperVReplicaBlueReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for InMageRcmReplicationDetails.
func (imrrd InMageRcmReplicationDetails) AsHyperVReplicaReplicationDetails() (*HyperVReplicaReplicationDetails, bool) {
	return nil, false
}

// AsInMageAzureV2ReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for InMageRcmReplicationDetails.
func (imrrd InMageRcmReplicationDetails) AsInMageAzureV2ReplicationDetails() (*InMageAzureV2ReplicationDetails, bool) {
	return nil, false
}

// AsInMageRcmReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for InMageRcmReplicationDetails.
func (imrrd InMageRcmReplicationDetails) AsInMageRcmReplicationDetails() (*InMageRcmReplicationDetails, bool) {
	return &imrrd, true
}

// AsInMageReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for InMageRcmReplicationDetails.
func (imrrd InMageRcmReplicationDetails) AsInMageReplicationDetails() (*InMageReplicationDetails, bool) {
	return nil, false
}

// AsReplicationProviderSpecificSettings is the BasicReplicationProviderSpecificSettings implementation for InMageRcmReplicationDetails.
func (imrrd InMageRcmReplicationDetails) AsReplicationProviderSpecificSettings() (*ReplicationProviderSpecificSettings, bool) {
	return nil, false
}

// AsBasicReplicationProviderSpecificSettings is the BasicReplicationProviderSpecificSettings implementation for InMageRcmReplicationDetails.
func (imrrd InMageRcmReplicationDetails) AsBasicReplicationProviderSpecificSettings() (BasicReplicationProviderSpecificSettings, bool) {
	return &imrrd, true
}

// InMageRcmTestFailoverInput inMageRcm provider specific input for test failover.
type InMageRcmTestFailoverInput struct {
	// NetworkID - The test network Id.
	NetworkID *string `json:"networkId,omitempty"`
	// RecoveryPointID - The recovery point id to be passed to test failover to a particular recovery point. In case of latest recovery point, null should be passed.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeTestFailoverProviderSpecificInput', 'InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeA2A', 'InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeInMageRcm', 'InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeInMage'
	InstanceType InstanceTypeBasicTestFailoverProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageRcmTestFailoverInput.
func (imrtfi InMageRcmTestFailoverInput) MarshalJSON() ([]byte, error) {
	imrtfi.InstanceType = InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeInMageRcm
	objectMap := make(map[string]interface{})
	if imrtfi.NetworkID != nil {
		objectMap["networkId"] = imrtfi.NetworkID
	}
	if imrtfi.RecoveryPointID != nil {
		objectMap["recoveryPointId"] = imrtfi.RecoveryPointID
	}
	if imrtfi.InstanceType != "" {
		objectMap["instanceType"] = imrtfi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2ATestFailoverInput is the BasicTestFailoverProviderSpecificInput implementation for InMageRcmTestFailoverInput.
func (imrtfi InMageRcmTestFailoverInput) AsA2ATestFailoverInput() (*A2ATestFailoverInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzureTestFailoverInput is the BasicTestFailoverProviderSpecificInput implementation for InMageRcmTestFailoverInput.
func (imrtfi InMageRcmTestFailoverInput) AsHyperVReplicaAzureTestFailoverInput() (*HyperVReplicaAzureTestFailoverInput, bool) {
	return nil, false
}

// AsInMageAzureV2TestFailoverInput is the BasicTestFailoverProviderSpecificInput implementation for InMageRcmTestFailoverInput.
func (imrtfi InMageRcmTestFailoverInput) AsInMageAzureV2TestFailoverInput() (*InMageAzureV2TestFailoverInput, bool) {
	return nil, false
}

// AsInMageRcmTestFailoverInput is the BasicTestFailoverProviderSpecificInput implementation for InMageRcmTestFailoverInput.
func (imrtfi InMageRcmTestFailoverInput) AsInMageRcmTestFailoverInput() (*InMageRcmTestFailoverInput, bool) {
	return &imrtfi, true
}

// AsInMageTestFailoverInput is the BasicTestFailoverProviderSpecificInput implementation for InMageRcmTestFailoverInput.
func (imrtfi InMageRcmTestFailoverInput) AsInMageTestFailoverInput() (*InMageTestFailoverInput, bool) {
	return nil, false
}

// AsTestFailoverProviderSpecificInput is the BasicTestFailoverProviderSpecificInput implementation for InMageRcmTestFailoverInput.
func (imrtfi InMageRcmTestFailoverInput) AsTestFailoverProviderSpecificInput() (*TestFailoverProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicTestFailoverProviderSpecificInput is the BasicTestFailoverProviderSpecificInput implementation for InMageRcmTestFailoverInput.
func (imrtfi InMageRcmTestFailoverInput) AsBasicTestFailoverProviderSpecificInput() (BasicTestFailoverProviderSpecificInput, bool) {
	return &imrtfi, true
}

// InMageRcmUnplannedFailoverInput inMageRcm provider specific input for unplanned failover.
type InMageRcmUnplannedFailoverInput struct {
	// PerformShutdown - A value indicating whether VM is to be shutdown.
	PerformShutdown *string `json:"performShutdown,omitempty"`
	// RecoveryPointID - The recovery point id to be passed to failover to a particular recovery point. In case of latest recovery point, null should be passed.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeUnplannedFailoverProviderSpecificInput', 'InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeA2A', 'InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeInMageRcm', 'InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeInMage'
	InstanceType InstanceTypeBasicUnplannedFailoverProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageRcmUnplannedFailoverInput.
func (imrufi InMageRcmUnplannedFailoverInput) MarshalJSON() ([]byte, error) {
	imrufi.InstanceType = InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeInMageRcm
	objectMap := make(map[string]interface{})
	if imrufi.PerformShutdown != nil {
		objectMap["performShutdown"] = imrufi.PerformShutdown
	}
	if imrufi.RecoveryPointID != nil {
		objectMap["recoveryPointId"] = imrufi.RecoveryPointID
	}
	if imrufi.InstanceType != "" {
		objectMap["instanceType"] = imrufi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AUnplannedFailoverInput is the BasicUnplannedFailoverProviderSpecificInput implementation for InMageRcmUnplannedFailoverInput.
func (imrufi InMageRcmUnplannedFailoverInput) AsA2AUnplannedFailoverInput() (*A2AUnplannedFailoverInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzureUnplannedFailoverInput is the BasicUnplannedFailoverProviderSpecificInput implementation for InMageRcmUnplannedFailoverInput.
func (imrufi InMageRcmUnplannedFailoverInput) AsHyperVReplicaAzureUnplannedFailoverInput() (*HyperVReplicaAzureUnplannedFailoverInput, bool) {
	return nil, false
}

// AsInMageAzureV2UnplannedFailoverInput is the BasicUnplannedFailoverProviderSpecificInput implementation for InMageRcmUnplannedFailoverInput.
func (imrufi InMageRcmUnplannedFailoverInput) AsInMageAzureV2UnplannedFailoverInput() (*InMageAzureV2UnplannedFailoverInput, bool) {
	return nil, false
}

// AsInMageRcmUnplannedFailoverInput is the BasicUnplannedFailoverProviderSpecificInput implementation for InMageRcmUnplannedFailoverInput.
func (imrufi InMageRcmUnplannedFailoverInput) AsInMageRcmUnplannedFailoverInput() (*InMageRcmUnplannedFailoverInput, bool) {
	return &imrufi, true
}

// AsInMageUnplannedFailoverInput is the BasicUnplannedFailoverProviderSpecificInput implementation for InMageRcmUnplannedFailoverInput.
func (imrufi InMageRcmUnplannedFailoverInput) AsInMageUnplannedFailoverInput() (*InMageUnplannedFailoverInput, bool) {
	return nil, false
}

// AsUnplannedFailoverProviderSpecificInput is the BasicUnplannedFailoverProviderSpecificInput implementation for InMageRcmUnplannedFailoverInput.
func (imrufi InMageRcmUnplannedFailoverInput) AsUnplannedFailoverProviderSpecificInput() (*UnplannedFailoverProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicUnplannedFailoverProviderSpecificInput is the BasicUnplannedFailoverProviderSpecificInput implementation for InMageRcmUnplannedFailoverInput.
func (imrufi InMageRcmUnplannedFailoverInput) AsBasicUnplannedFailoverProviderSpecificInput() (BasicUnplannedFailoverProviderSpecificInput, bool) {
	return &imrufi, true
}

// InMageRcmUpdateReplicationProtectedItemInput inMageRcm provider specific input to update replication
// protected item.
type InMageRcmUpdateReplicationProtectedItemInput struct {
	// TargetVMName - The target VM name.
	TargetVMName *string `json:"targetVmName,omitempty"`
	// TargetVMSize - The target VM size.
	TargetVMSize *string `json:"targetVmSize,omitempty"`
	// TargetResourceGroupID - The target resource group ARM Id.
	TargetResourceGroupID *string `json:"targetResourceGroupId,omitempty"`
	// TargetAvailabilitySetID - The target availability set ARM Id.
	TargetAvailabilitySetID *string `json:"targetAvailabilitySetId,omitempty"`
	// TargetAvailabilityZone - The target availability zone.
	TargetAvailabilityZone *string `json:"targetAvailabilityZone,omitempty"`
	// TargetProximityPlacementGroupID - The target proximity placement group Id.
	TargetProximityPlacementGroupID *string `json:"targetProximityPlacementGroupId,omitempty"`
	// TargetBootDiagnosticsStorageAccountID - The target boot diagnostics storage account ARM Id.
	TargetBootDiagnosticsStorageAccountID *string `json:"targetBootDiagnosticsStorageAccountId,omitempty"`
	// TargetNetworkID - The target network ARM Id.
	TargetNetworkID *string `json:"targetNetworkId,omitempty"`
	// TestNetworkID - The test network ARM Id.
	TestNetworkID *string `json:"testNetworkId,omitempty"`
	// VMNics - The list of NIC details.
	VMNics *[]InMageRcmNicInput `json:"vmNics,omitempty"`
	// LicenseType - The license type. Possible values include: 'LicenseTypeNotSpecified', 'LicenseTypeNoLicenseType', 'LicenseTypeWindowsServer'
	LicenseType LicenseType `json:"licenseType,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeUpdateReplicationProtectedItemProviderInput', 'InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeA2A', 'InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeInMageRcm'
	InstanceType InstanceTypeBasicUpdateReplicationProtectedItemProviderInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageRcmUpdateReplicationProtectedItemInput.
func (imrurpii InMageRcmUpdateReplicationProtectedItemInput) MarshalJSON() ([]byte, error) {
	imrurpii.InstanceType = InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeInMageRcm
	objectMap := make(map[string]interface{})
	if imrurpii.TargetVMName != nil {
		objectMap["targetVmName"] = imrurpii.TargetVMName
	}
	if imrurpii.TargetVMSize != nil {
		objectMap["targetVmSize"] = imrurpii.TargetVMSize
	}
	if imrurpii.TargetResourceGroupID != nil {
		objectMap["targetResourceGroupId"] = imrurpii.TargetResourceGroupID
	}
	if imrurpii.TargetAvailabilitySetID != nil {
		objectMap["targetAvailabilitySetId"] = imrurpii.TargetAvailabilitySetID
	}
	if imrurpii.TargetAvailabilityZone != nil {
		objectMap["targetAvailabilityZone"] = imrurpii.TargetAvailabilityZone
	}
	if imrurpii.TargetProximityPlacementGroupID != nil {
		objectMap["targetProximityPlacementGroupId"] = imrurpii.TargetProximityPlacementGroupID
	}
	if imrurpii.TargetBootDiagnosticsStorageAccountID != nil {
		objectMap["targetBootDiagnosticsStorageAccountId"] = imrurpii.TargetBootDiagnosticsStorageAccountID
	}
	if imrurpii.TargetNetworkID != nil {
		objectMap["targetNetworkId"] = imrurpii.TargetNetworkID
	}
	if imrurpii.TestNetworkID != nil {
		objectMap["testNetworkId"] = imrurpii.TestNetworkID
	}
	if imrurpii.VMNics != nil {
		objectMap["vmNics"] = imrurpii.VMNics
	}
	if imrurpii.LicenseType != "" {
		objectMap["licenseType"] = imrurpii.LicenseType
	}
	if imrurpii.InstanceType != "" {
		objectMap["instanceType"] = imrurpii.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AUpdateReplicationProtectedItemInput is the BasicUpdateReplicationProtectedItemProviderInput implementation for InMageRcmUpdateReplicationProtectedItemInput.
func (imrurpii InMageRcmUpdateReplicationProtectedItemInput) AsA2AUpdateReplicationProtectedItemInput() (*A2AUpdateReplicationProtectedItemInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzureUpdateReplicationProtectedItemInput is the BasicUpdateReplicationProtectedItemProviderInput implementation for InMageRcmUpdateReplicationProtectedItemInput.
func (imrurpii InMageRcmUpdateReplicationProtectedItemInput) AsHyperVReplicaAzureUpdateReplicationProtectedItemInput() (*HyperVReplicaAzureUpdateReplicationProtectedItemInput, bool) {
	return nil, false
}

// AsInMageAzureV2UpdateReplicationProtectedItemInput is the BasicUpdateReplicationProtectedItemProviderInput implementation for InMageRcmUpdateReplicationProtectedItemInput.
func (imrurpii InMageRcmUpdateReplicationProtectedItemInput) AsInMageAzureV2UpdateReplicationProtectedItemInput() (*InMageAzureV2UpdateReplicationProtectedItemInput, bool) {
	return nil, false
}

// AsInMageRcmUpdateReplicationProtectedItemInput is the BasicUpdateReplicationProtectedItemProviderInput implementation for InMageRcmUpdateReplicationProtectedItemInput.
func (imrurpii InMageRcmUpdateReplicationProtectedItemInput) AsInMageRcmUpdateReplicationProtectedItemInput() (*InMageRcmUpdateReplicationProtectedItemInput, bool) {
	return &imrurpii, true
}

// AsUpdateReplicationProtectedItemProviderInput is the BasicUpdateReplicationProtectedItemProviderInput implementation for InMageRcmUpdateReplicationProtectedItemInput.
func (imrurpii InMageRcmUpdateReplicationProtectedItemInput) AsUpdateReplicationProtectedItemProviderInput() (*UpdateReplicationProtectedItemProviderInput, bool) {
	return nil, false
}

// AsBasicUpdateReplicationProtectedItemProviderInput is the BasicUpdateReplicationProtectedItemProviderInput implementation for InMageRcmUpdateReplicationProtectedItemInput.
func (imrurpii InMageRcmUpdateReplicationProtectedItemInput) AsBasicUpdateReplicationProtectedItemProviderInput() (BasicUpdateReplicationProtectedItemProviderInput, bool) {
	return &imrurpii, true
}

// InMageReplicationDetails inMage provider specific settings
type InMageReplicationDetails struct {
	// ActiveSiteType - The active location of the VM. If the VM is being protected from Azure, this field will take values from { Azure, OnPrem }. If the VM is being protected between two data-centers, this field will be OnPrem always.
	ActiveSiteType *string `json:"activeSiteType,omitempty"`
	// SourceVMCPUCount - The CPU count of the VM on the primary side.
	SourceVMCPUCount *int32 `json:"sourceVmCpuCount,omitempty"`
	// SourceVMRAMSizeInMB - The RAM size of the VM on the primary side.
	SourceVMRAMSizeInMB *int32 `json:"sourceVmRamSizeInMB,omitempty"`
	// OsDetails - The OS details.
	OsDetails *OSDiskDetails `json:"osDetails,omitempty"`
	// ProtectionStage - The protection stage.
	ProtectionStage *string `json:"protectionStage,omitempty"`
	// VMID - The virtual machine Id.
	VMID *string `json:"vmId,omitempty"`
	// VMProtectionState - The protection state for the vm.
	VMProtectionState *string `json:"vmProtectionState,omitempty"`
	// VMProtectionStateDescription - The protection state description for the vm.
	VMProtectionStateDescription *string `json:"vmProtectionStateDescription,omitempty"`
	// ResyncDetails - The resync details of the machine
	ResyncDetails *InitialReplicationDetails `json:"resyncDetails,omitempty"`
	// RetentionWindowStart - The retention window start time.
	RetentionWindowStart *date.Time `json:"retentionWindowStart,omitempty"`
	// RetentionWindowEnd - The retention window end time.
	RetentionWindowEnd *date.Time `json:"retentionWindowEnd,omitempty"`
	// CompressedDataRateInMB - The compressed data change rate in MB.
	CompressedDataRateInMB *float64 `json:"compressedDataRateInMB,omitempty"`
	// UncompressedDataRateInMB - The uncompressed data change rate in MB.
	UncompressedDataRateInMB *float64 `json:"uncompressedDataRateInMB,omitempty"`
	// RpoInSeconds - The RPO in seconds.
	RpoInSeconds *int64 `json:"rpoInSeconds,omitempty"`
	// ProtectedDisks - The list of protected disks.
	ProtectedDisks *[]InMageProtectedDiskDetails `json:"protectedDisks,omitempty"`
	// IPAddress - The source IP address.
	IPAddress *string `json:"ipAddress,omitempty"`
	// LastHeartbeat - The last heartbeat received from the source server.
	LastHeartbeat *date.Time `json:"lastHeartbeat,omitempty"`
	// ProcessServerID - The process server Id.
	ProcessServerID *string `json:"processServerId,omitempty"`
	// MasterTargetID - The master target Id.
	MasterTargetID *string `json:"masterTargetId,omitempty"`
	// ConsistencyPoints - The collection of Consistency points.
	ConsistencyPoints map[string]*date.Time `json:"consistencyPoints"`
	// DiskResized - A value indicating whether any disk is resized for this VM.
	DiskResized *string `json:"diskResized,omitempty"`
	// RebootAfterUpdateStatus - A value indicating whether the source server requires a restart after update.
	RebootAfterUpdateStatus *string `json:"rebootAfterUpdateStatus,omitempty"`
	// MultiVMGroupID - The multi vm group Id, if any.
	MultiVMGroupID *string `json:"multiVmGroupId,omitempty"`
	// MultiVMGroupName - The multi vm group name, if any.
	MultiVMGroupName *string `json:"multiVmGroupName,omitempty"`
	// MultiVMSyncStatus - A value indicating whether the multi vm sync is enabled or disabled.
	MultiVMSyncStatus *string `json:"multiVmSyncStatus,omitempty"`
	// AgentDetails - The agent details.
	AgentDetails *InMageAgentDetails `json:"agentDetails,omitempty"`
	// VCenterInfrastructureID - The vCenter infrastructure Id.
	VCenterInfrastructureID *string `json:"vCenterInfrastructureId,omitempty"`
	// InfrastructureVMID - The infrastructure VM Id.
	InfrastructureVMID *string `json:"infrastructureVmId,omitempty"`
	// VMNics - The PE Network details.
	VMNics *[]VMNicDetails `json:"vmNics,omitempty"`
	// DiscoveryType - A value indicating the discovery type of the machine.
	DiscoveryType *string `json:"discoveryType,omitempty"`
	// AzureStorageAccountID - A value indicating the underlying Azure storage account. If the VM is not running in Azure, this value shall be set to null.
	AzureStorageAccountID *string `json:"azureStorageAccountId,omitempty"`
	// Datastores - The data stores of the on-premise machine Value can be list of strings that contain data store names
	Datastores *[]string `json:"datastores,omitempty"`
	// ValidationErrors - The validation errors of the on-premise machine Value can be list of validation errors
	ValidationErrors *[]HealthError `json:"validationErrors,omitempty"`
	// LastRpoCalculatedTime - The last RPO calculated time.
	LastRpoCalculatedTime *date.Time `json:"lastRpoCalculatedTime,omitempty"`
	// LastUpdateReceivedTime - The last update time received from on-prem components.
	LastUpdateReceivedTime *date.Time `json:"lastUpdateReceivedTime,omitempty"`
	// ReplicaID - The replica id of the protected item.
	ReplicaID *string `json:"replicaId,omitempty"`
	// OsVersion - The OS Version of the protected item.
	OsVersion *string `json:"osVersion,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeReplicationProviderSpecificSettings', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeA2A', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaBaseReplicationDetails', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMageAzureV2', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMageRcm', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMage'
	InstanceType InstanceTypeBasicReplicationProviderSpecificSettings `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageReplicationDetails.
func (imrd InMageReplicationDetails) MarshalJSON() ([]byte, error) {
	imrd.InstanceType = InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMage
	objectMap := make(map[string]interface{})
	if imrd.ActiveSiteType != nil {
		objectMap["activeSiteType"] = imrd.ActiveSiteType
	}
	if imrd.SourceVMCPUCount != nil {
		objectMap["sourceVmCpuCount"] = imrd.SourceVMCPUCount
	}
	if imrd.SourceVMRAMSizeInMB != nil {
		objectMap["sourceVmRamSizeInMB"] = imrd.SourceVMRAMSizeInMB
	}
	if imrd.OsDetails != nil {
		objectMap["osDetails"] = imrd.OsDetails
	}
	if imrd.ProtectionStage != nil {
		objectMap["protectionStage"] = imrd.ProtectionStage
	}
	if imrd.VMID != nil {
		objectMap["vmId"] = imrd.VMID
	}
	if imrd.VMProtectionState != nil {
		objectMap["vmProtectionState"] = imrd.VMProtectionState
	}
	if imrd.VMProtectionStateDescription != nil {
		objectMap["vmProtectionStateDescription"] = imrd.VMProtectionStateDescription
	}
	if imrd.ResyncDetails != nil {
		objectMap["resyncDetails"] = imrd.ResyncDetails
	}
	if imrd.RetentionWindowStart != nil {
		objectMap["retentionWindowStart"] = imrd.RetentionWindowStart
	}
	if imrd.RetentionWindowEnd != nil {
		objectMap["retentionWindowEnd"] = imrd.RetentionWindowEnd
	}
	if imrd.CompressedDataRateInMB != nil {
		objectMap["compressedDataRateInMB"] = imrd.CompressedDataRateInMB
	}
	if imrd.UncompressedDataRateInMB != nil {
		objectMap["uncompressedDataRateInMB"] = imrd.UncompressedDataRateInMB
	}
	if imrd.RpoInSeconds != nil {
		objectMap["rpoInSeconds"] = imrd.RpoInSeconds
	}
	if imrd.ProtectedDisks != nil {
		objectMap["protectedDisks"] = imrd.ProtectedDisks
	}
	if imrd.IPAddress != nil {
		objectMap["ipAddress"] = imrd.IPAddress
	}
	if imrd.LastHeartbeat != nil {
		objectMap["lastHeartbeat"] = imrd.LastHeartbeat
	}
	if imrd.ProcessServerID != nil {
		objectMap["processServerId"] = imrd.ProcessServerID
	}
	if imrd.MasterTargetID != nil {
		objectMap["masterTargetId"] = imrd.MasterTargetID
	}
	if imrd.ConsistencyPoints != nil {
		objectMap["consistencyPoints"] = imrd.ConsistencyPoints
	}
	if imrd.DiskResized != nil {
		objectMap["diskResized"] = imrd.DiskResized
	}
	if imrd.RebootAfterUpdateStatus != nil {
		objectMap["rebootAfterUpdateStatus"] = imrd.RebootAfterUpdateStatus
	}
	if imrd.MultiVMGroupID != nil {
		objectMap["multiVmGroupId"] = imrd.MultiVMGroupID
	}
	if imrd.MultiVMGroupName != nil {
		objectMap["multiVmGroupName"] = imrd.MultiVMGroupName
	}
	if imrd.MultiVMSyncStatus != nil {
		objectMap["multiVmSyncStatus"] = imrd.MultiVMSyncStatus
	}
	if imrd.AgentDetails != nil {
		objectMap["agentDetails"] = imrd.AgentDetails
	}
	if imrd.VCenterInfrastructureID != nil {
		objectMap["vCenterInfrastructureId"] = imrd.VCenterInfrastructureID
	}
	if imrd.InfrastructureVMID != nil {
		objectMap["infrastructureVmId"] = imrd.InfrastructureVMID
	}
	if imrd.VMNics != nil {
		objectMap["vmNics"] = imrd.VMNics
	}
	if imrd.DiscoveryType != nil {
		objectMap["discoveryType"] = imrd.DiscoveryType
	}
	if imrd.AzureStorageAccountID != nil {
		objectMap["azureStorageAccountId"] = imrd.AzureStorageAccountID
	}
	if imrd.Datastores != nil {
		objectMap["datastores"] = imrd.Datastores
	}
	if imrd.ValidationErrors != nil {
		objectMap["validationErrors"] = imrd.ValidationErrors
	}
	if imrd.LastRpoCalculatedTime != nil {
		objectMap["lastRpoCalculatedTime"] = imrd.LastRpoCalculatedTime
	}
	if imrd.LastUpdateReceivedTime != nil {
		objectMap["lastUpdateReceivedTime"] = imrd.LastUpdateReceivedTime
	}
	if imrd.ReplicaID != nil {
		objectMap["replicaId"] = imrd.ReplicaID
	}
	if imrd.OsVersion != nil {
		objectMap["osVersion"] = imrd.OsVersion
	}
	if imrd.InstanceType != "" {
		objectMap["instanceType"] = imrd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for InMageReplicationDetails.
func (imrd InMageReplicationDetails) AsA2AReplicationDetails() (*A2AReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzureReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for InMageReplicationDetails.
func (imrd InMageReplicationDetails) AsHyperVReplicaAzureReplicationDetails() (*HyperVReplicaAzureReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBaseReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for InMageReplicationDetails.
func (imrd InMageReplicationDetails) AsHyperVReplicaBaseReplicationDetails() (*HyperVReplicaBaseReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBlueReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for InMageReplicationDetails.
func (imrd InMageReplicationDetails) AsHyperVReplicaBlueReplicationDetails() (*HyperVReplicaBlueReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for InMageReplicationDetails.
func (imrd InMageReplicationDetails) AsHyperVReplicaReplicationDetails() (*HyperVReplicaReplicationDetails, bool) {
	return nil, false
}

// AsInMageAzureV2ReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for InMageReplicationDetails.
func (imrd InMageReplicationDetails) AsInMageAzureV2ReplicationDetails() (*InMageAzureV2ReplicationDetails, bool) {
	return nil, false
}

// AsInMageRcmReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for InMageReplicationDetails.
func (imrd InMageReplicationDetails) AsInMageRcmReplicationDetails() (*InMageRcmReplicationDetails, bool) {
	return nil, false
}

// AsInMageReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for InMageReplicationDetails.
func (imrd InMageReplicationDetails) AsInMageReplicationDetails() (*InMageReplicationDetails, bool) {
	return &imrd, true
}

// AsReplicationProviderSpecificSettings is the BasicReplicationProviderSpecificSettings implementation for InMageReplicationDetails.
func (imrd InMageReplicationDetails) AsReplicationProviderSpecificSettings() (*ReplicationProviderSpecificSettings, bool) {
	return nil, false
}

// AsBasicReplicationProviderSpecificSettings is the BasicReplicationProviderSpecificSettings implementation for InMageReplicationDetails.
func (imrd InMageReplicationDetails) AsBasicReplicationProviderSpecificSettings() (BasicReplicationProviderSpecificSettings, bool) {
	return &imrd, true
}

// InMageReprotectInput inMageAzureV2 specific provider input.
type InMageReprotectInput struct {
	// MasterTargetID - The Master Target Id.
	MasterTargetID *string `json:"masterTargetId,omitempty"`
	// ProcessServerID - The Process Server Id.
	ProcessServerID *string `json:"processServerId,omitempty"`
	// RetentionDrive - The retention drive to use on the MT.
	RetentionDrive *string `json:"retentionDrive,omitempty"`
	// RunAsAccountID - The CS account Id.
	RunAsAccountID *string `json:"runAsAccountId,omitempty"`
	// DatastoreName - The target data store name.
	DatastoreName *string `json:"datastoreName,omitempty"`
	// DiskExclusionInput - The enable disk exclusion input.
	DiskExclusionInput *InMageDiskExclusionInput `json:"diskExclusionInput,omitempty"`
	// ProfileID - The Policy Id.
	ProfileID *string `json:"profileId,omitempty"`
	// DisksToInclude - The disks to include list.
	DisksToInclude *[]string `json:"disksToInclude,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeReverseReplicationProviderSpecificInput', 'InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeA2A', 'InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeInMage'
	InstanceType InstanceTypeBasicReverseReplicationProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageReprotectInput.
func (imri InMageReprotectInput) MarshalJSON() ([]byte, error) {
	imri.InstanceType = InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeInMage
	objectMap := make(map[string]interface{})
	if imri.MasterTargetID != nil {
		objectMap["masterTargetId"] = imri.MasterTargetID
	}
	if imri.ProcessServerID != nil {
		objectMap["processServerId"] = imri.ProcessServerID
	}
	if imri.RetentionDrive != nil {
		objectMap["retentionDrive"] = imri.RetentionDrive
	}
	if imri.RunAsAccountID != nil {
		objectMap["runAsAccountId"] = imri.RunAsAccountID
	}
	if imri.DatastoreName != nil {
		objectMap["datastoreName"] = imri.DatastoreName
	}
	if imri.DiskExclusionInput != nil {
		objectMap["diskExclusionInput"] = imri.DiskExclusionInput
	}
	if imri.ProfileID != nil {
		objectMap["profileId"] = imri.ProfileID
	}
	if imri.DisksToInclude != nil {
		objectMap["disksToInclude"] = imri.DisksToInclude
	}
	if imri.InstanceType != "" {
		objectMap["instanceType"] = imri.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AReprotectInput is the BasicReverseReplicationProviderSpecificInput implementation for InMageReprotectInput.
func (imri InMageReprotectInput) AsA2AReprotectInput() (*A2AReprotectInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzureReprotectInput is the BasicReverseReplicationProviderSpecificInput implementation for InMageReprotectInput.
func (imri InMageReprotectInput) AsHyperVReplicaAzureReprotectInput() (*HyperVReplicaAzureReprotectInput, bool) {
	return nil, false
}

// AsInMageAzureV2ReprotectInput is the BasicReverseReplicationProviderSpecificInput implementation for InMageReprotectInput.
func (imri InMageReprotectInput) AsInMageAzureV2ReprotectInput() (*InMageAzureV2ReprotectInput, bool) {
	return nil, false
}

// AsInMageReprotectInput is the BasicReverseReplicationProviderSpecificInput implementation for InMageReprotectInput.
func (imri InMageReprotectInput) AsInMageReprotectInput() (*InMageReprotectInput, bool) {
	return &imri, true
}

// AsReverseReplicationProviderSpecificInput is the BasicReverseReplicationProviderSpecificInput implementation for InMageReprotectInput.
func (imri InMageReprotectInput) AsReverseReplicationProviderSpecificInput() (*ReverseReplicationProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicReverseReplicationProviderSpecificInput is the BasicReverseReplicationProviderSpecificInput implementation for InMageReprotectInput.
func (imri InMageReprotectInput) AsBasicReverseReplicationProviderSpecificInput() (BasicReverseReplicationProviderSpecificInput, bool) {
	return &imri, true
}

// InMageTestFailoverInput provider specific input for InMage test failover.
type InMageTestFailoverInput struct {
	// RecoveryPointType - The recovery point type. Values from LatestTime, LatestTag or Custom. In the case of custom, the recovery point provided by RecoveryPointId will be used. In the other two cases, recovery point id will be ignored. Possible values include: 'LatestTime', 'LatestTag', 'Custom'
	RecoveryPointType RecoveryPointType `json:"recoveryPointType,omitempty"`
	// RecoveryPointID - The recovery point id to be passed to test failover to a particular recovery point. In case of latest recovery point, null should be passed.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeTestFailoverProviderSpecificInput', 'InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeA2A', 'InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeInMageRcm', 'InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeInMage'
	InstanceType InstanceTypeBasicTestFailoverProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageTestFailoverInput.
func (imtfi InMageTestFailoverInput) MarshalJSON() ([]byte, error) {
	imtfi.InstanceType = InstanceTypeBasicTestFailoverProviderSpecificInputInstanceTypeInMage
	objectMap := make(map[string]interface{})
	if imtfi.RecoveryPointType != "" {
		objectMap["recoveryPointType"] = imtfi.RecoveryPointType
	}
	if imtfi.RecoveryPointID != nil {
		objectMap["recoveryPointId"] = imtfi.RecoveryPointID
	}
	if imtfi.InstanceType != "" {
		objectMap["instanceType"] = imtfi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2ATestFailoverInput is the BasicTestFailoverProviderSpecificInput implementation for InMageTestFailoverInput.
func (imtfi InMageTestFailoverInput) AsA2ATestFailoverInput() (*A2ATestFailoverInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzureTestFailoverInput is the BasicTestFailoverProviderSpecificInput implementation for InMageTestFailoverInput.
func (imtfi InMageTestFailoverInput) AsHyperVReplicaAzureTestFailoverInput() (*HyperVReplicaAzureTestFailoverInput, bool) {
	return nil, false
}

// AsInMageAzureV2TestFailoverInput is the BasicTestFailoverProviderSpecificInput implementation for InMageTestFailoverInput.
func (imtfi InMageTestFailoverInput) AsInMageAzureV2TestFailoverInput() (*InMageAzureV2TestFailoverInput, bool) {
	return nil, false
}

// AsInMageRcmTestFailoverInput is the BasicTestFailoverProviderSpecificInput implementation for InMageTestFailoverInput.
func (imtfi InMageTestFailoverInput) AsInMageRcmTestFailoverInput() (*InMageRcmTestFailoverInput, bool) {
	return nil, false
}

// AsInMageTestFailoverInput is the BasicTestFailoverProviderSpecificInput implementation for InMageTestFailoverInput.
func (imtfi InMageTestFailoverInput) AsInMageTestFailoverInput() (*InMageTestFailoverInput, bool) {
	return &imtfi, true
}

// AsTestFailoverProviderSpecificInput is the BasicTestFailoverProviderSpecificInput implementation for InMageTestFailoverInput.
func (imtfi InMageTestFailoverInput) AsTestFailoverProviderSpecificInput() (*TestFailoverProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicTestFailoverProviderSpecificInput is the BasicTestFailoverProviderSpecificInput implementation for InMageTestFailoverInput.
func (imtfi InMageTestFailoverInput) AsBasicTestFailoverProviderSpecificInput() (BasicTestFailoverProviderSpecificInput, bool) {
	return &imtfi, true
}

// InMageUnplannedFailoverInput provider specific input for InMage unplanned failover.
type InMageUnplannedFailoverInput struct {
	// RecoveryPointType - The recovery point type. Values from LatestTime, LatestTag or Custom. In the case of custom, the recovery point provided by RecoveryPointId will be used. In the other two cases, recovery point id will be ignored. Possible values include: 'LatestTime', 'LatestTag', 'Custom'
	RecoveryPointType RecoveryPointType `json:"recoveryPointType,omitempty"`
	// RecoveryPointID - The recovery point id to be passed to failover to a particular recovery point. In case of latest recovery point, null should be passed.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeUnplannedFailoverProviderSpecificInput', 'InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeA2A', 'InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeInMageRcm', 'InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeInMage'
	InstanceType InstanceTypeBasicUnplannedFailoverProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageUnplannedFailoverInput.
func (imufi InMageUnplannedFailoverInput) MarshalJSON() ([]byte, error) {
	imufi.InstanceType = InstanceTypeBasicUnplannedFailoverProviderSpecificInputInstanceTypeInMage
	objectMap := make(map[string]interface{})
	if imufi.RecoveryPointType != "" {
		objectMap["recoveryPointType"] = imufi.RecoveryPointType
	}
	if imufi.RecoveryPointID != nil {
		objectMap["recoveryPointId"] = imufi.RecoveryPointID
	}
	if imufi.InstanceType != "" {
		objectMap["instanceType"] = imufi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AUnplannedFailoverInput is the BasicUnplannedFailoverProviderSpecificInput implementation for InMageUnplannedFailoverInput.
func (imufi InMageUnplannedFailoverInput) AsA2AUnplannedFailoverInput() (*A2AUnplannedFailoverInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzureUnplannedFailoverInput is the BasicUnplannedFailoverProviderSpecificInput implementation for InMageUnplannedFailoverInput.
func (imufi InMageUnplannedFailoverInput) AsHyperVReplicaAzureUnplannedFailoverInput() (*HyperVReplicaAzureUnplannedFailoverInput, bool) {
	return nil, false
}

// AsInMageAzureV2UnplannedFailoverInput is the BasicUnplannedFailoverProviderSpecificInput implementation for InMageUnplannedFailoverInput.
func (imufi InMageUnplannedFailoverInput) AsInMageAzureV2UnplannedFailoverInput() (*InMageAzureV2UnplannedFailoverInput, bool) {
	return nil, false
}

// AsInMageRcmUnplannedFailoverInput is the BasicUnplannedFailoverProviderSpecificInput implementation for InMageUnplannedFailoverInput.
func (imufi InMageUnplannedFailoverInput) AsInMageRcmUnplannedFailoverInput() (*InMageRcmUnplannedFailoverInput, bool) {
	return nil, false
}

// AsInMageUnplannedFailoverInput is the BasicUnplannedFailoverProviderSpecificInput implementation for InMageUnplannedFailoverInput.
func (imufi InMageUnplannedFailoverInput) AsInMageUnplannedFailoverInput() (*InMageUnplannedFailoverInput, bool) {
	return &imufi, true
}

// AsUnplannedFailoverProviderSpecificInput is the BasicUnplannedFailoverProviderSpecificInput implementation for InMageUnplannedFailoverInput.
func (imufi InMageUnplannedFailoverInput) AsUnplannedFailoverProviderSpecificInput() (*UnplannedFailoverProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicUnplannedFailoverProviderSpecificInput is the BasicUnplannedFailoverProviderSpecificInput implementation for InMageUnplannedFailoverInput.
func (imufi InMageUnplannedFailoverInput) AsBasicUnplannedFailoverProviderSpecificInput() (BasicUnplannedFailoverProviderSpecificInput, bool) {
	return &imufi, true
}

// InMageVolumeExclusionOptions guest disk signature based disk exclusion option when doing enable
// protection of virtual machine in InMage provider.
type InMageVolumeExclusionOptions struct {
	// VolumeLabel - The volume label. The disk having any volume with this label will be excluded from replication.
	VolumeLabel *string `json:"volumeLabel,omitempty"`
	// OnlyExcludeIfSingleVolume - The value indicating whether to exclude multi volume disk or not. If a disk has multiple volumes and one of the volume has label matching with VolumeLabel this disk will be excluded from replication if OnlyExcludeIfSingleVolume is false.
	OnlyExcludeIfSingleVolume *string `json:"onlyExcludeIfSingleVolume,omitempty"`
}

// InnerHealthError implements InnerHealthError class. HealthError object has a list of InnerHealthErrors
// as child errors. InnerHealthError is used because this will prevent an infinite loop of structures when
// Hydra tries to auto-generate the contract. We are exposing the related health errors as inner health
// errors and all API consumers can utilize this in the same fashion as Exception -&gt; InnerException.
type InnerHealthError struct {
	// ErrorSource - Source of error.
	ErrorSource *string `json:"errorSource,omitempty"`
	// ErrorType - Type of error.
	ErrorType *string `json:"errorType,omitempty"`
	// ErrorLevel - Level of error.
	ErrorLevel *string `json:"errorLevel,omitempty"`
	// ErrorCategory - Category of error.
	ErrorCategory *string `json:"errorCategory,omitempty"`
	// ErrorCode - Error code.
	ErrorCode *string `json:"errorCode,omitempty"`
	// SummaryMessage - Summary message of the entity.
	SummaryMessage *string `json:"summaryMessage,omitempty"`
	// ErrorMessage - Error message.
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// PossibleCauses - Possible causes of error.
	PossibleCauses *string `json:"possibleCauses,omitempty"`
	// RecommendedAction - Recommended action to resolve error.
	RecommendedAction *string `json:"recommendedAction,omitempty"`
	// CreationTimeUtc - Error creation time (UTC)
	CreationTimeUtc *date.Time `json:"creationTimeUtc,omitempty"`
	// RecoveryProviderErrorMessage - DRA error message.
	RecoveryProviderErrorMessage *string `json:"recoveryProviderErrorMessage,omitempty"`
	// EntityID - ID of the entity.
	EntityID *string `json:"entityId,omitempty"`
}

// InputEndpoint azure VM input endpoint details.
type InputEndpoint struct {
	// EndpointName - The input endpoint name.
	EndpointName *string `json:"endpointName,omitempty"`
	// PrivatePort - The input endpoint private port.
	PrivatePort *int32 `json:"privatePort,omitempty"`
	// PublicPort - The input endpoint public port.
	PublicPort *int32 `json:"publicPort,omitempty"`
	// Protocol - The input endpoint protocol.
	Protocol *string `json:"protocol,omitempty"`
}

// IPConfig IP configuration details.
type IPConfig struct {
	// StaticIPAddress - The static IP address of the IP configuration.
	StaticIPAddress *string `json:"staticIPAddress,omitempty"`
	// PublicIPAddressID - The Id of the public IP address associated with the IP configuration.
	PublicIPAddressID *string `json:"publicIpAddressId,omitempty"`
	// LBBackendAddressPoolIds - The backend address pools associated with the IP configuration.
	LBBackendAddressPoolIds *[]string `json:"lBBackendAddressPoolIds,omitempty"`
}

// Job job details.
type Job struct {
	autorest.Response `json:"-"`
	// Properties - The custom data.
	Properties *JobProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource Type
	Type *string `json:"type,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for Job.
func (j Job) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if j.Properties != nil {
		objectMap["properties"] = j.Properties
	}
	if j.Location != nil {
		objectMap["location"] = j.Location
	}
	return json.Marshal(objectMap)
}

// JobCollection collection of jobs.
type JobCollection struct {
	autorest.Response `json:"-"`
	// Value - The list of jobs.
	Value *[]Job `json:"value,omitempty"`
	// NextLink - The value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// JobCollectionIterator provides access to a complete listing of Job values.
type JobCollectionIterator struct {
	i    int
	page JobCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobCollectionIterator) Response() JobCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobCollectionIterator) Value() Job {
	if !iter.page.NotDone() {
		return Job{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobCollectionIterator type.
func NewJobCollectionIterator(page JobCollectionPage) JobCollectionIterator {
	return JobCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jc JobCollection) IsEmpty() bool {
	return jc.Value == nil || len(*jc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (jc JobCollection) hasNextLink() bool {
	return jc.NextLink != nil && len(*jc.NextLink) != 0
}

// jobCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jc JobCollection) jobCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !jc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jc.NextLink)))
}

// JobCollectionPage contains a page of Job values.
type JobCollectionPage struct {
	fn func(context.Context, JobCollection) (JobCollection, error)
	jc JobCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.jc)
		if err != nil {
			return err
		}
		page.jc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobCollectionPage) NotDone() bool {
	return !page.jc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobCollectionPage) Response() JobCollection {
	return page.jc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobCollectionPage) Values() []Job {
	if page.jc.IsEmpty() {
		return nil
	}
	return *page.jc.Value
}

// Creates a new instance of the JobCollectionPage type.
func NewJobCollectionPage(cur JobCollection, getNextPage func(context.Context, JobCollection) (JobCollection, error)) JobCollectionPage {
	return JobCollectionPage{
		fn: getNextPage,
		jc: cur,
	}
}

// BasicJobDetails job details based on specific job type.
type BasicJobDetails interface {
	AsAsrJobDetails() (*AsrJobDetails, bool)
	AsExportJobDetails() (*ExportJobDetails, bool)
	AsFailoverJobDetails() (*FailoverJobDetails, bool)
	AsSwitchProtectionJobDetails() (*SwitchProtectionJobDetails, bool)
	AsTestFailoverJobDetails() (*TestFailoverJobDetails, bool)
	AsJobDetails() (*JobDetails, bool)
}

// JobDetails job details based on specific job type.
type JobDetails struct {
	// AffectedObjectDetails - The affected object properties like source server, source cloud, target server, target cloud etc. based on the workflow object details.
	AffectedObjectDetails map[string]*string `json:"affectedObjectDetails"`
	// InstanceType - Possible values include: 'InstanceTypeJobDetails', 'InstanceTypeAsrJobDetails', 'InstanceTypeExportJobDetails', 'InstanceTypeFailoverJobDetails', 'InstanceTypeSwitchProtectionJobDetails', 'InstanceTypeTestFailoverJobDetails'
	InstanceType InstanceTypeBasicJobDetails `json:"instanceType,omitempty"`
}

func unmarshalBasicJobDetails(body []byte) (BasicJobDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeAsrJobDetails):
		var ajd AsrJobDetails
		err := json.Unmarshal(body, &ajd)
		return ajd, err
	case string(InstanceTypeExportJobDetails):
		var ejd ExportJobDetails
		err := json.Unmarshal(body, &ejd)
		return ejd, err
	case string(InstanceTypeFailoverJobDetails):
		var fjd FailoverJobDetails
		err := json.Unmarshal(body, &fjd)
		return fjd, err
	case string(InstanceTypeSwitchProtectionJobDetails):
		var spjd SwitchProtectionJobDetails
		err := json.Unmarshal(body, &spjd)
		return spjd, err
	case string(InstanceTypeTestFailoverJobDetails):
		var tfjd TestFailoverJobDetails
		err := json.Unmarshal(body, &tfjd)
		return tfjd, err
	default:
		var jd JobDetails
		err := json.Unmarshal(body, &jd)
		return jd, err
	}
}
func unmarshalBasicJobDetailsArray(body []byte) ([]BasicJobDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	jdArray := make([]BasicJobDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		jd, err := unmarshalBasicJobDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		jdArray[index] = jd
	}
	return jdArray, nil
}

// MarshalJSON is the custom marshaler for JobDetails.
func (jd JobDetails) MarshalJSON() ([]byte, error) {
	jd.InstanceType = InstanceTypeJobDetails
	objectMap := make(map[string]interface{})
	if jd.AffectedObjectDetails != nil {
		objectMap["affectedObjectDetails"] = jd.AffectedObjectDetails
	}
	if jd.InstanceType != "" {
		objectMap["instanceType"] = jd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAsrJobDetails is the BasicJobDetails implementation for JobDetails.
func (jd JobDetails) AsAsrJobDetails() (*AsrJobDetails, bool) {
	return nil, false
}

// AsExportJobDetails is the BasicJobDetails implementation for JobDetails.
func (jd JobDetails) AsExportJobDetails() (*ExportJobDetails, bool) {
	return nil, false
}

// AsFailoverJobDetails is the BasicJobDetails implementation for JobDetails.
func (jd JobDetails) AsFailoverJobDetails() (*FailoverJobDetails, bool) {
	return nil, false
}

// AsSwitchProtectionJobDetails is the BasicJobDetails implementation for JobDetails.
func (jd JobDetails) AsSwitchProtectionJobDetails() (*SwitchProtectionJobDetails, bool) {
	return nil, false
}

// AsTestFailoverJobDetails is the BasicJobDetails implementation for JobDetails.
func (jd JobDetails) AsTestFailoverJobDetails() (*TestFailoverJobDetails, bool) {
	return nil, false
}

// AsJobDetails is the BasicJobDetails implementation for JobDetails.
func (jd JobDetails) AsJobDetails() (*JobDetails, bool) {
	return &jd, true
}

// AsBasicJobDetails is the BasicJobDetails implementation for JobDetails.
func (jd JobDetails) AsBasicJobDetails() (BasicJobDetails, bool) {
	return &jd, true
}

// JobEntity this class contains the minimal job details required to navigate to the desired drill down.
type JobEntity struct {
	// JobID - The job id.
	JobID *string `json:"jobId,omitempty"`
	// JobFriendlyName - The job display name.
	JobFriendlyName *string `json:"jobFriendlyName,omitempty"`
	// TargetObjectID - The object id.
	TargetObjectID *string `json:"targetObjectId,omitempty"`
	// TargetObjectName - The object name.
	TargetObjectName *string `json:"targetObjectName,omitempty"`
	// TargetInstanceType - The workflow affected object type.
	TargetInstanceType *string `json:"targetInstanceType,omitempty"`
	// JobScenarioName - The job name. Enum type ScenarioName.
	JobScenarioName *string `json:"jobScenarioName,omitempty"`
}

// JobErrorDetails this class contains the error details per object.
type JobErrorDetails struct {
	// ServiceErrorDetails - The Service error details.
	ServiceErrorDetails *ServiceError `json:"serviceErrorDetails,omitempty"`
	// ProviderErrorDetails - The Provider error details.
	ProviderErrorDetails *ProviderError `json:"providerErrorDetails,omitempty"`
	// ErrorLevel - Error level of error.
	ErrorLevel *string `json:"errorLevel,omitempty"`
	// CreationTime - The creation time of job error.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// TaskID - The Id of the task.
	TaskID *string `json:"taskId,omitempty"`
}

// JobProperties job custom data details.
type JobProperties struct {
	// ActivityID - The activity id.
	ActivityID *string `json:"activityId,omitempty"`
	// ScenarioName - The ScenarioName.
	ScenarioName *string `json:"scenarioName,omitempty"`
	// FriendlyName - The DisplayName.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// State - The status of the Job. It is one of these values - NotStarted, InProgress, Succeeded, Failed, Cancelled, Suspended or Other.
	State *string `json:"state,omitempty"`
	// StateDescription - The description of the state of the Job. For e.g. - For Succeeded state, description can be Completed, PartiallySucceeded, CompletedWithInformation or Skipped.
	StateDescription *string `json:"stateDescription,omitempty"`
	// Tasks - The tasks.
	Tasks *[]ASRTask `json:"tasks,omitempty"`
	// Errors - The errors.
	Errors *[]JobErrorDetails `json:"errors,omitempty"`
	// StartTime - The start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// AllowedActions - The Allowed action the job.
	AllowedActions *[]string `json:"allowedActions,omitempty"`
	// TargetObjectID - The affected Object Id.
	TargetObjectID *string `json:"targetObjectId,omitempty"`
	// TargetObjectName - The name of the affected object.
	TargetObjectName *string `json:"targetObjectName,omitempty"`
	// TargetInstanceType - The type of the affected object which is of {Microsoft.Azure.SiteRecovery.V2015_11_10.AffectedObjectType} class.
	TargetInstanceType *string `json:"targetInstanceType,omitempty"`
	// CustomDetails - The custom job details like test failover job details.
	CustomDetails BasicJobDetails `json:"customDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for JobProperties struct.
func (jp *JobProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "activityId":
			if v != nil {
				var activityID string
				err = json.Unmarshal(*v, &activityID)
				if err != nil {
					return err
				}
				jp.ActivityID = &activityID
			}
		case "scenarioName":
			if v != nil {
				var scenarioName string
				err = json.Unmarshal(*v, &scenarioName)
				if err != nil {
					return err
				}
				jp.ScenarioName = &scenarioName
			}
		case "friendlyName":
			if v != nil {
				var friendlyName string
				err = json.Unmarshal(*v, &friendlyName)
				if err != nil {
					return err
				}
				jp.FriendlyName = &friendlyName
			}
		case "state":
			if v != nil {
				var state string
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				jp.State = &state
			}
		case "stateDescription":
			if v != nil {
				var stateDescription string
				err = json.Unmarshal(*v, &stateDescription)
				if err != nil {
					return err
				}
				jp.StateDescription = &stateDescription
			}
		case "tasks":
			if v != nil {
				var tasks []ASRTask
				err = json.Unmarshal(*v, &tasks)
				if err != nil {
					return err
				}
				jp.Tasks = &tasks
			}
		case "errors":
			if v != nil {
				var errorsVar []JobErrorDetails
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				jp.Errors = &errorsVar
			}
		case "startTime":
			if v != nil {
				var startTime date.Time
				err = json.Unmarshal(*v, &startTime)
				if err != nil {
					return err
				}
				jp.StartTime = &startTime
			}
		case "endTime":
			if v != nil {
				var endTime date.Time
				err = json.Unmarshal(*v, &endTime)
				if err != nil {
					return err
				}
				jp.EndTime = &endTime
			}
		case "allowedActions":
			if v != nil {
				var allowedActions []string
				err = json.Unmarshal(*v, &allowedActions)
				if err != nil {
					return err
				}
				jp.AllowedActions = &allowedActions
			}
		case "targetObjectId":
			if v != nil {
				var targetObjectID string
				err = json.Unmarshal(*v, &targetObjectID)
				if err != nil {
					return err
				}
				jp.TargetObjectID = &targetObjectID
			}
		case "targetObjectName":
			if v != nil {
				var targetObjectName string
				err = json.Unmarshal(*v, &targetObjectName)
				if err != nil {
					return err
				}
				jp.TargetObjectName = &targetObjectName
			}
		case "targetInstanceType":
			if v != nil {
				var targetInstanceType string
				err = json.Unmarshal(*v, &targetInstanceType)
				if err != nil {
					return err
				}
				jp.TargetInstanceType = &targetInstanceType
			}
		case "customDetails":
			if v != nil {
				customDetails, err := unmarshalBasicJobDetails(*v)
				if err != nil {
					return err
				}
				jp.CustomDetails = customDetails
			}
		}
	}

	return nil
}

// JobQueryParameter query parameter to enumerate jobs.
type JobQueryParameter struct {
	// StartTime - Date time to get jobs from.
	StartTime *string `json:"startTime,omitempty"`
	// EndTime - Date time to get jobs up to.
	EndTime *string `json:"endTime,omitempty"`
	// FabricID - The Id of the fabric to search jobs under.
	FabricID *string `json:"fabricId,omitempty"`
	// AffectedObjectTypes - The type of objects.
	AffectedObjectTypes *string `json:"affectedObjectTypes,omitempty"`
	// JobStatus - The states of the job to be filtered can be in.
	JobStatus *string `json:"jobStatus,omitempty"`
}

// JobStatusEventDetails model class for event details of a job status event.
type JobStatusEventDetails struct {
	// JobID - Job arm id for the event.
	JobID *string `json:"jobId,omitempty"`
	// JobFriendlyName - JobName for the Event.
	JobFriendlyName *string `json:"jobFriendlyName,omitempty"`
	// JobStatus - JobStatus for the Event.
	JobStatus *string `json:"jobStatus,omitempty"`
	// AffectedObjectType - AffectedObjectType for the event.
	AffectedObjectType *string `json:"affectedObjectType,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeEventSpecificDetails', 'InstanceTypeJobStatus'
	InstanceType InstanceTypeBasicEventSpecificDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for JobStatusEventDetails.
func (jsed JobStatusEventDetails) MarshalJSON() ([]byte, error) {
	jsed.InstanceType = InstanceTypeJobStatus
	objectMap := make(map[string]interface{})
	if jsed.JobID != nil {
		objectMap["jobId"] = jsed.JobID
	}
	if jsed.JobFriendlyName != nil {
		objectMap["jobFriendlyName"] = jsed.JobFriendlyName
	}
	if jsed.JobStatus != nil {
		objectMap["jobStatus"] = jsed.JobStatus
	}
	if jsed.AffectedObjectType != nil {
		objectMap["affectedObjectType"] = jsed.AffectedObjectType
	}
	if jsed.InstanceType != "" {
		objectMap["instanceType"] = jsed.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsJobStatusEventDetails is the BasicEventSpecificDetails implementation for JobStatusEventDetails.
func (jsed JobStatusEventDetails) AsJobStatusEventDetails() (*JobStatusEventDetails, bool) {
	return &jsed, true
}

// AsEventSpecificDetails is the BasicEventSpecificDetails implementation for JobStatusEventDetails.
func (jsed JobStatusEventDetails) AsEventSpecificDetails() (*EventSpecificDetails, bool) {
	return nil, false
}

// AsBasicEventSpecificDetails is the BasicEventSpecificDetails implementation for JobStatusEventDetails.
func (jsed JobStatusEventDetails) AsBasicEventSpecificDetails() (BasicEventSpecificDetails, bool) {
	return &jsed, true
}

// JobTaskDetails this class represents a task which is actually a workflow so that one can navigate to its
// individual drill down.
type JobTaskDetails struct {
	// JobTask - The job entity.
	JobTask *JobEntity `json:"jobTask,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeTaskTypeDetails', 'InstanceTypeAutomationRunbookTaskDetails', 'InstanceTypeConsistencyCheckTaskDetails', 'InstanceTypeFabricReplicationGroupTaskDetails', 'InstanceTypeJobTaskDetails', 'InstanceTypeManualActionTaskDetails', 'InstanceTypeScriptActionTaskDetails', 'InstanceTypeVirtualMachineTaskDetails', 'InstanceTypeVMNicUpdatesTaskDetails'
	InstanceType InstanceTypeBasicTaskTypeDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for JobTaskDetails.
func (jtd JobTaskDetails) MarshalJSON() ([]byte, error) {
	jtd.InstanceType = InstanceTypeJobTaskDetails
	objectMap := make(map[string]interface{})
	if jtd.JobTask != nil {
		objectMap["jobTask"] = jtd.JobTask
	}
	if jtd.InstanceType != "" {
		objectMap["instanceType"] = jtd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAutomationRunbookTaskDetails is the BasicTaskTypeDetails implementation for JobTaskDetails.
func (jtd JobTaskDetails) AsAutomationRunbookTaskDetails() (*AutomationRunbookTaskDetails, bool) {
	return nil, false
}

// AsConsistencyCheckTaskDetails is the BasicTaskTypeDetails implementation for JobTaskDetails.
func (jtd JobTaskDetails) AsConsistencyCheckTaskDetails() (*ConsistencyCheckTaskDetails, bool) {
	return nil, false
}

// AsFabricReplicationGroupTaskDetails is the BasicTaskTypeDetails implementation for JobTaskDetails.
func (jtd JobTaskDetails) AsFabricReplicationGroupTaskDetails() (*FabricReplicationGroupTaskDetails, bool) {
	return nil, false
}

// AsJobTaskDetails is the BasicTaskTypeDetails implementation for JobTaskDetails.
func (jtd JobTaskDetails) AsJobTaskDetails() (*JobTaskDetails, bool) {
	return &jtd, true
}

// AsManualActionTaskDetails is the BasicTaskTypeDetails implementation for JobTaskDetails.
func (jtd JobTaskDetails) AsManualActionTaskDetails() (*ManualActionTaskDetails, bool) {
	return nil, false
}

// AsScriptActionTaskDetails is the BasicTaskTypeDetails implementation for JobTaskDetails.
func (jtd JobTaskDetails) AsScriptActionTaskDetails() (*ScriptActionTaskDetails, bool) {
	return nil, false
}

// AsVirtualMachineTaskDetails is the BasicTaskTypeDetails implementation for JobTaskDetails.
func (jtd JobTaskDetails) AsVirtualMachineTaskDetails() (*VirtualMachineTaskDetails, bool) {
	return nil, false
}

// AsVMNicUpdatesTaskDetails is the BasicTaskTypeDetails implementation for JobTaskDetails.
func (jtd JobTaskDetails) AsVMNicUpdatesTaskDetails() (*VMNicUpdatesTaskDetails, bool) {
	return nil, false
}

// AsTaskTypeDetails is the BasicTaskTypeDetails implementation for JobTaskDetails.
func (jtd JobTaskDetails) AsTaskTypeDetails() (*TaskTypeDetails, bool) {
	return nil, false
}

// AsBasicTaskTypeDetails is the BasicTaskTypeDetails implementation for JobTaskDetails.
func (jtd JobTaskDetails) AsBasicTaskTypeDetails() (BasicTaskTypeDetails, bool) {
	return &jtd, true
}

// KeyEncryptionKeyInfo key Encryption Key (KEK) information.
type KeyEncryptionKeyInfo struct {
	// KeyIdentifier - The key URL / identifier.
	KeyIdentifier *string `json:"keyIdentifier,omitempty"`
	// KeyVaultResourceArmID - The KeyVault resource ARM Id for key.
	KeyVaultResourceArmID *string `json:"keyVaultResourceArmId,omitempty"`
}

// LogicalNetwork logical network data model.
type LogicalNetwork struct {
	autorest.Response `json:"-"`
	// Properties - The Logical Network Properties.
	Properties *LogicalNetworkProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource Type
	Type *string `json:"type,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for LogicalNetwork.
func (ln LogicalNetwork) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ln.Properties != nil {
		objectMap["properties"] = ln.Properties
	}
	if ln.Location != nil {
		objectMap["location"] = ln.Location
	}
	return json.Marshal(objectMap)
}

// LogicalNetworkCollection list of logical networks.
type LogicalNetworkCollection struct {
	autorest.Response `json:"-"`
	// Value - The Logical Networks list details.
	Value *[]LogicalNetwork `json:"value,omitempty"`
	// NextLink - The value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// LogicalNetworkCollectionIterator provides access to a complete listing of LogicalNetwork values.
type LogicalNetworkCollectionIterator struct {
	i    int
	page LogicalNetworkCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LogicalNetworkCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LogicalNetworkCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *LogicalNetworkCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LogicalNetworkCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LogicalNetworkCollectionIterator) Response() LogicalNetworkCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LogicalNetworkCollectionIterator) Value() LogicalNetwork {
	if !iter.page.NotDone() {
		return LogicalNetwork{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the LogicalNetworkCollectionIterator type.
func NewLogicalNetworkCollectionIterator(page LogicalNetworkCollectionPage) LogicalNetworkCollectionIterator {
	return LogicalNetworkCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lnc LogicalNetworkCollection) IsEmpty() bool {
	return lnc.Value == nil || len(*lnc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lnc LogicalNetworkCollection) hasNextLink() bool {
	return lnc.NextLink != nil && len(*lnc.NextLink) != 0
}

// logicalNetworkCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lnc LogicalNetworkCollection) logicalNetworkCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !lnc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lnc.NextLink)))
}

// LogicalNetworkCollectionPage contains a page of LogicalNetwork values.
type LogicalNetworkCollectionPage struct {
	fn  func(context.Context, LogicalNetworkCollection) (LogicalNetworkCollection, error)
	lnc LogicalNetworkCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LogicalNetworkCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LogicalNetworkCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lnc)
		if err != nil {
			return err
		}
		page.lnc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *LogicalNetworkCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LogicalNetworkCollectionPage) NotDone() bool {
	return !page.lnc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LogicalNetworkCollectionPage) Response() LogicalNetworkCollection {
	return page.lnc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LogicalNetworkCollectionPage) Values() []LogicalNetwork {
	if page.lnc.IsEmpty() {
		return nil
	}
	return *page.lnc.Value
}

// Creates a new instance of the LogicalNetworkCollectionPage type.
func NewLogicalNetworkCollectionPage(cur LogicalNetworkCollection, getNextPage func(context.Context, LogicalNetworkCollection) (LogicalNetworkCollection, error)) LogicalNetworkCollectionPage {
	return LogicalNetworkCollectionPage{
		fn:  getNextPage,
		lnc: cur,
	}
}

// LogicalNetworkProperties logical Network Properties.
type LogicalNetworkProperties struct {
	// FriendlyName - The Friendly Name.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// NetworkVirtualizationStatus - A value indicating whether Network Virtualization is enabled for the logical network.
	NetworkVirtualizationStatus *string `json:"networkVirtualizationStatus,omitempty"`
	// LogicalNetworkUsage - A value indicating whether logical network is used as private test network by test failover.
	LogicalNetworkUsage *string `json:"logicalNetworkUsage,omitempty"`
	// LogicalNetworkDefinitionsStatus - A value indicating whether logical network definitions are isolated.
	LogicalNetworkDefinitionsStatus *string `json:"logicalNetworkDefinitionsStatus,omitempty"`
}

// ManualActionTaskDetails this class represents the manual action task details.
type ManualActionTaskDetails struct {
	// Name - The name.
	Name *string `json:"name,omitempty"`
	// Instructions - The instructions.
	Instructions *string `json:"instructions,omitempty"`
	// Observation - The observation.
	Observation *string `json:"observation,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeTaskTypeDetails', 'InstanceTypeAutomationRunbookTaskDetails', 'InstanceTypeConsistencyCheckTaskDetails', 'InstanceTypeFabricReplicationGroupTaskDetails', 'InstanceTypeJobTaskDetails', 'InstanceTypeManualActionTaskDetails', 'InstanceTypeScriptActionTaskDetails', 'InstanceTypeVirtualMachineTaskDetails', 'InstanceTypeVMNicUpdatesTaskDetails'
	InstanceType InstanceTypeBasicTaskTypeDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for ManualActionTaskDetails.
func (matd ManualActionTaskDetails) MarshalJSON() ([]byte, error) {
	matd.InstanceType = InstanceTypeManualActionTaskDetails
	objectMap := make(map[string]interface{})
	if matd.Name != nil {
		objectMap["name"] = matd.Name
	}
	if matd.Instructions != nil {
		objectMap["instructions"] = matd.Instructions
	}
	if matd.Observation != nil {
		objectMap["observation"] = matd.Observation
	}
	if matd.InstanceType != "" {
		objectMap["instanceType"] = matd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAutomationRunbookTaskDetails is the BasicTaskTypeDetails implementation for ManualActionTaskDetails.
func (matd ManualActionTaskDetails) AsAutomationRunbookTaskDetails() (*AutomationRunbookTaskDetails, bool) {
	return nil, false
}

// AsConsistencyCheckTaskDetails is the BasicTaskTypeDetails implementation for ManualActionTaskDetails.
func (matd ManualActionTaskDetails) AsConsistencyCheckTaskDetails() (*ConsistencyCheckTaskDetails, bool) {
	return nil, false
}

// AsFabricReplicationGroupTaskDetails is the BasicTaskTypeDetails implementation for ManualActionTaskDetails.
func (matd ManualActionTaskDetails) AsFabricReplicationGroupTaskDetails() (*FabricReplicationGroupTaskDetails, bool) {
	return nil, false
}

// AsJobTaskDetails is the BasicTaskTypeDetails implementation for ManualActionTaskDetails.
func (matd ManualActionTaskDetails) AsJobTaskDetails() (*JobTaskDetails, bool) {
	return nil, false
}

// AsManualActionTaskDetails is the BasicTaskTypeDetails implementation for ManualActionTaskDetails.
func (matd ManualActionTaskDetails) AsManualActionTaskDetails() (*ManualActionTaskDetails, bool) {
	return &matd, true
}

// AsScriptActionTaskDetails is the BasicTaskTypeDetails implementation for ManualActionTaskDetails.
func (matd ManualActionTaskDetails) AsScriptActionTaskDetails() (*ScriptActionTaskDetails, bool) {
	return nil, false
}

// AsVirtualMachineTaskDetails is the BasicTaskTypeDetails implementation for ManualActionTaskDetails.
func (matd ManualActionTaskDetails) AsVirtualMachineTaskDetails() (*VirtualMachineTaskDetails, bool) {
	return nil, false
}

// AsVMNicUpdatesTaskDetails is the BasicTaskTypeDetails implementation for ManualActionTaskDetails.
func (matd ManualActionTaskDetails) AsVMNicUpdatesTaskDetails() (*VMNicUpdatesTaskDetails, bool) {
	return nil, false
}

// AsTaskTypeDetails is the BasicTaskTypeDetails implementation for ManualActionTaskDetails.
func (matd ManualActionTaskDetails) AsTaskTypeDetails() (*TaskTypeDetails, bool) {
	return nil, false
}

// AsBasicTaskTypeDetails is the BasicTaskTypeDetails implementation for ManualActionTaskDetails.
func (matd ManualActionTaskDetails) AsBasicTaskTypeDetails() (BasicTaskTypeDetails, bool) {
	return &matd, true
}

// MasterTargetServer details of a Master Target Server.
type MasterTargetServer struct {
	// ID - The server Id.
	ID *string `json:"id,omitempty"`
	// IPAddress - The IP address of the server.
	IPAddress *string `json:"ipAddress,omitempty"`
	// Name - The server name.
	Name *string `json:"name,omitempty"`
	// OsType - The OS type of the server.
	OsType *string `json:"osType,omitempty"`
	// AgentVersion - The version of the scout component on the server.
	AgentVersion *string `json:"agentVersion,omitempty"`
	// LastHeartbeat - The last heartbeat received from the server.
	LastHeartbeat *date.Time `json:"lastHeartbeat,omitempty"`
	// VersionStatus - Version status
	VersionStatus *string `json:"versionStatus,omitempty"`
	// RetentionVolumes - The retention volumes of Master target Server.
	RetentionVolumes *[]RetentionVolume `json:"retentionVolumes,omitempty"`
	// DataStores - The list of data stores in the fabric.
	DataStores *[]DataStore `json:"dataStores,omitempty"`
	// ValidationErrors - Validation errors.
	ValidationErrors *[]HealthError `json:"validationErrors,omitempty"`
	// HealthErrors - Health errors.
	HealthErrors *[]HealthError `json:"healthErrors,omitempty"`
	// DiskCount - Disk count of the master target.
	DiskCount *int32 `json:"diskCount,omitempty"`
	// OsVersion - OS Version of the master target.
	OsVersion *string `json:"osVersion,omitempty"`
	// AgentExpiryDate - Agent expiry date.
	AgentExpiryDate *date.Time `json:"agentExpiryDate,omitempty"`
	// MarsAgentVersion - MARS agent version.
	MarsAgentVersion *string `json:"marsAgentVersion,omitempty"`
	// MarsAgentExpiryDate - MARS agent expiry date.
	MarsAgentExpiryDate *date.Time `json:"marsAgentExpiryDate,omitempty"`
	// AgentVersionDetails - Agent version details.
	AgentVersionDetails *VersionDetails `json:"agentVersionDetails,omitempty"`
	// MarsAgentVersionDetails - Mars agent version details.
	MarsAgentVersionDetails *VersionDetails `json:"marsAgentVersionDetails,omitempty"`
}

// MigrateInput input for migrate.
type MigrateInput struct {
	// Properties - Migrate input properties.
	Properties *MigrateInputProperties `json:"properties,omitempty"`
}

// MigrateInputProperties migrate input properties.
type MigrateInputProperties struct {
	// ProviderSpecificDetails - The provider specific details.
	ProviderSpecificDetails BasicMigrateProviderSpecificInput `json:"providerSpecificDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for MigrateInputProperties struct.
func (mip *MigrateInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "providerSpecificDetails":
			if v != nil {
				providerSpecificDetails, err := unmarshalBasicMigrateProviderSpecificInput(*v)
				if err != nil {
					return err
				}
				mip.ProviderSpecificDetails = providerSpecificDetails
			}
		}
	}

	return nil
}

// BasicMigrateProviderSpecificInput migrate provider specific input.
type BasicMigrateProviderSpecificInput interface {
	AsVMwareCbtMigrateInput() (*VMwareCbtMigrateInput, bool)
	AsMigrateProviderSpecificInput() (*MigrateProviderSpecificInput, bool)
}

// MigrateProviderSpecificInput migrate provider specific input.
type MigrateProviderSpecificInput struct {
	// InstanceType - Possible values include: 'InstanceTypeBasicMigrateProviderSpecificInputInstanceTypeMigrateProviderSpecificInput', 'InstanceTypeBasicMigrateProviderSpecificInputInstanceTypeVMwareCbt'
	InstanceType InstanceTypeBasicMigrateProviderSpecificInput `json:"instanceType,omitempty"`
}

func unmarshalBasicMigrateProviderSpecificInput(body []byte) (BasicMigrateProviderSpecificInput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeBasicMigrateProviderSpecificInputInstanceTypeVMwareCbt):
		var vmcmi VMwareCbtMigrateInput
		err := json.Unmarshal(body, &vmcmi)
		return vmcmi, err
	default:
		var mpsi MigrateProviderSpecificInput
		err := json.Unmarshal(body, &mpsi)
		return mpsi, err
	}
}
func unmarshalBasicMigrateProviderSpecificInputArray(body []byte) ([]BasicMigrateProviderSpecificInput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	mpsiArray := make([]BasicMigrateProviderSpecificInput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		mpsi, err := unmarshalBasicMigrateProviderSpecificInput(*rawMessage)
		if err != nil {
			return nil, err
		}
		mpsiArray[index] = mpsi
	}
	return mpsiArray, nil
}

// MarshalJSON is the custom marshaler for MigrateProviderSpecificInput.
func (mpsi MigrateProviderSpecificInput) MarshalJSON() ([]byte, error) {
	mpsi.InstanceType = InstanceTypeBasicMigrateProviderSpecificInputInstanceTypeMigrateProviderSpecificInput
	objectMap := make(map[string]interface{})
	if mpsi.InstanceType != "" {
		objectMap["instanceType"] = mpsi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsVMwareCbtMigrateInput is the BasicMigrateProviderSpecificInput implementation for MigrateProviderSpecificInput.
func (mpsi MigrateProviderSpecificInput) AsVMwareCbtMigrateInput() (*VMwareCbtMigrateInput, bool) {
	return nil, false
}

// AsMigrateProviderSpecificInput is the BasicMigrateProviderSpecificInput implementation for MigrateProviderSpecificInput.
func (mpsi MigrateProviderSpecificInput) AsMigrateProviderSpecificInput() (*MigrateProviderSpecificInput, bool) {
	return &mpsi, true
}

// AsBasicMigrateProviderSpecificInput is the BasicMigrateProviderSpecificInput implementation for MigrateProviderSpecificInput.
func (mpsi MigrateProviderSpecificInput) AsBasicMigrateProviderSpecificInput() (BasicMigrateProviderSpecificInput, bool) {
	return &mpsi, true
}

// MigrationItem migration item.
type MigrationItem struct {
	autorest.Response `json:"-"`
	// Properties - The migration item properties.
	Properties *MigrationItemProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource Type
	Type *string `json:"type,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrationItem.
func (mi MigrationItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mi.Properties != nil {
		objectMap["properties"] = mi.Properties
	}
	if mi.Location != nil {
		objectMap["location"] = mi.Location
	}
	return json.Marshal(objectMap)
}

// MigrationItemCollection migration item collection.
type MigrationItemCollection struct {
	autorest.Response `json:"-"`
	// Value - The list of migration items.
	Value *[]MigrationItem `json:"value,omitempty"`
	// NextLink - The value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// MigrationItemCollectionIterator provides access to a complete listing of MigrationItem values.
type MigrationItemCollectionIterator struct {
	i    int
	page MigrationItemCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *MigrationItemCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MigrationItemCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *MigrationItemCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter MigrationItemCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter MigrationItemCollectionIterator) Response() MigrationItemCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter MigrationItemCollectionIterator) Value() MigrationItem {
	if !iter.page.NotDone() {
		return MigrationItem{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the MigrationItemCollectionIterator type.
func NewMigrationItemCollectionIterator(page MigrationItemCollectionPage) MigrationItemCollectionIterator {
	return MigrationItemCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mic MigrationItemCollection) IsEmpty() bool {
	return mic.Value == nil || len(*mic.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mic MigrationItemCollection) hasNextLink() bool {
	return mic.NextLink != nil && len(*mic.NextLink) != 0
}

// migrationItemCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mic MigrationItemCollection) migrationItemCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !mic.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mic.NextLink)))
}

// MigrationItemCollectionPage contains a page of MigrationItem values.
type MigrationItemCollectionPage struct {
	fn  func(context.Context, MigrationItemCollection) (MigrationItemCollection, error)
	mic MigrationItemCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *MigrationItemCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MigrationItemCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mic)
		if err != nil {
			return err
		}
		page.mic = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *MigrationItemCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page MigrationItemCollectionPage) NotDone() bool {
	return !page.mic.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page MigrationItemCollectionPage) Response() MigrationItemCollection {
	return page.mic
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page MigrationItemCollectionPage) Values() []MigrationItem {
	if page.mic.IsEmpty() {
		return nil
	}
	return *page.mic.Value
}

// Creates a new instance of the MigrationItemCollectionPage type.
func NewMigrationItemCollectionPage(cur MigrationItemCollection, getNextPage func(context.Context, MigrationItemCollection) (MigrationItemCollection, error)) MigrationItemCollectionPage {
	return MigrationItemCollectionPage{
		fn:  getNextPage,
		mic: cur,
	}
}

// MigrationItemProperties migration item properties.
type MigrationItemProperties struct {
	// MachineName - READ-ONLY; The on-premise virtual machine name.
	MachineName *string `json:"machineName,omitempty"`
	// PolicyID - READ-ONLY; The ARM Id of policy governing this item.
	PolicyID *string `json:"policyId,omitempty"`
	// PolicyFriendlyName - READ-ONLY; The name of policy governing this item.
	PolicyFriendlyName *string `json:"policyFriendlyName,omitempty"`
	// RecoveryServicesProviderID - READ-ONLY; The recovery services provider ARM Id.
	RecoveryServicesProviderID *string `json:"recoveryServicesProviderId,omitempty"`
	// MigrationState - READ-ONLY; The migration status. Possible values include: 'MigrationStateNone', 'MigrationStateEnableMigrationInProgress', 'MigrationStateEnableMigrationFailed', 'MigrationStateDisableMigrationInProgress', 'MigrationStateDisableMigrationFailed', 'MigrationStateInitialSeedingInProgress', 'MigrationStateInitialSeedingFailed', 'MigrationStateReplicating', 'MigrationStateMigrationInProgress', 'MigrationStateMigrationSucceeded', 'MigrationStateMigrationFailed'
	MigrationState MigrationState `json:"migrationState,omitempty"`
	// MigrationStateDescription - READ-ONLY; The migration state description.
	MigrationStateDescription *string `json:"migrationStateDescription,omitempty"`
	// TestMigrateState - READ-ONLY; The test migrate state. Possible values include: 'TestMigrationStateNone', 'TestMigrationStateTestMigrationInProgress', 'TestMigrationStateTestMigrationSucceeded', 'TestMigrationStateTestMigrationFailed', 'TestMigrationStateTestMigrationCleanupInProgress'
	TestMigrateState TestMigrationState `json:"testMigrateState,omitempty"`
	// TestMigrateStateDescription - READ-ONLY; The test migrate state description.
	TestMigrateStateDescription *string `json:"testMigrateStateDescription,omitempty"`
	// Health - READ-ONLY; The consolidated health.
	Health *string `json:"health,omitempty"`
	// HealthErrors - READ-ONLY; The list of health errors.
	HealthErrors *[]HealthError `json:"healthErrors,omitempty"`
	// AllowedOperations - READ-ONLY; The allowed operations on the migration item, based on the current migration state of the item.
	AllowedOperations *[]MigrationItemOperation `json:"allowedOperations,omitempty"`
	// CurrentJob - READ-ONLY; The current job details.
	CurrentJob *CurrentJobDetails `json:"currentJob,omitempty"`
	// ProviderSpecificDetails - The migration provider custom settings.
	ProviderSpecificDetails BasicMigrationProviderSpecificSettings `json:"providerSpecificDetails,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrationItemProperties.
func (mip MigrationItemProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["providerSpecificDetails"] = mip.ProviderSpecificDetails
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MigrationItemProperties struct.
func (mip *MigrationItemProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "machineName":
			if v != nil {
				var machineName string
				err = json.Unmarshal(*v, &machineName)
				if err != nil {
					return err
				}
				mip.MachineName = &machineName
			}
		case "policyId":
			if v != nil {
				var policyID string
				err = json.Unmarshal(*v, &policyID)
				if err != nil {
					return err
				}
				mip.PolicyID = &policyID
			}
		case "policyFriendlyName":
			if v != nil {
				var policyFriendlyName string
				err = json.Unmarshal(*v, &policyFriendlyName)
				if err != nil {
					return err
				}
				mip.PolicyFriendlyName = &policyFriendlyName
			}
		case "recoveryServicesProviderId":
			if v != nil {
				var recoveryServicesProviderID string
				err = json.Unmarshal(*v, &recoveryServicesProviderID)
				if err != nil {
					return err
				}
				mip.RecoveryServicesProviderID = &recoveryServicesProviderID
			}
		case "migrationState":
			if v != nil {
				var migrationState MigrationState
				err = json.Unmarshal(*v, &migrationState)
				if err != nil {
					return err
				}
				mip.MigrationState = migrationState
			}
		case "migrationStateDescription":
			if v != nil {
				var migrationStateDescription string
				err = json.Unmarshal(*v, &migrationStateDescription)
				if err != nil {
					return err
				}
				mip.MigrationStateDescription = &migrationStateDescription
			}
		case "testMigrateState":
			if v != nil {
				var testMigrateState TestMigrationState
				err = json.Unmarshal(*v, &testMigrateState)
				if err != nil {
					return err
				}
				mip.TestMigrateState = testMigrateState
			}
		case "testMigrateStateDescription":
			if v != nil {
				var testMigrateStateDescription string
				err = json.Unmarshal(*v, &testMigrateStateDescription)
				if err != nil {
					return err
				}
				mip.TestMigrateStateDescription = &testMigrateStateDescription
			}
		case "health":
			if v != nil {
				var health string
				err = json.Unmarshal(*v, &health)
				if err != nil {
					return err
				}
				mip.Health = &health
			}
		case "healthErrors":
			if v != nil {
				var healthErrors []HealthError
				err = json.Unmarshal(*v, &healthErrors)
				if err != nil {
					return err
				}
				mip.HealthErrors = &healthErrors
			}
		case "allowedOperations":
			if v != nil {
				var allowedOperations []MigrationItemOperation
				err = json.Unmarshal(*v, &allowedOperations)
				if err != nil {
					return err
				}
				mip.AllowedOperations = &allowedOperations
			}
		case "currentJob":
			if v != nil {
				var currentJob CurrentJobDetails
				err = json.Unmarshal(*v, &currentJob)
				if err != nil {
					return err
				}
				mip.CurrentJob = &currentJob
			}
		case "providerSpecificDetails":
			if v != nil {
				providerSpecificDetails, err := unmarshalBasicMigrationProviderSpecificSettings(*v)
				if err != nil {
					return err
				}
				mip.ProviderSpecificDetails = providerSpecificDetails
			}
		}
	}

	return nil
}

// MigrationItemsQueryParameter query parameter to enumerate migration items.
type MigrationItemsQueryParameter struct {
	// SourceFabricName - The source fabric name filter.
	SourceFabricName *string `json:"sourceFabricName,omitempty"`
	// InstanceType - The replication provider type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// BasicMigrationProviderSpecificSettings migration provider specific settings.
type BasicMigrationProviderSpecificSettings interface {
	AsVMwareCbtMigrationDetails() (*VMwareCbtMigrationDetails, bool)
	AsMigrationProviderSpecificSettings() (*MigrationProviderSpecificSettings, bool)
}

// MigrationProviderSpecificSettings migration provider specific settings.
type MigrationProviderSpecificSettings struct {
	// InstanceType - Possible values include: 'InstanceTypeBasicMigrationProviderSpecificSettingsInstanceTypeMigrationProviderSpecificSettings', 'InstanceTypeBasicMigrationProviderSpecificSettingsInstanceTypeVMwareCbt'
	InstanceType InstanceTypeBasicMigrationProviderSpecificSettings `json:"instanceType,omitempty"`
}

func unmarshalBasicMigrationProviderSpecificSettings(body []byte) (BasicMigrationProviderSpecificSettings, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeBasicMigrationProviderSpecificSettingsInstanceTypeVMwareCbt):
		var vmcmd VMwareCbtMigrationDetails
		err := json.Unmarshal(body, &vmcmd)
		return vmcmd, err
	default:
		var mpss MigrationProviderSpecificSettings
		err := json.Unmarshal(body, &mpss)
		return mpss, err
	}
}
func unmarshalBasicMigrationProviderSpecificSettingsArray(body []byte) ([]BasicMigrationProviderSpecificSettings, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	mpssArray := make([]BasicMigrationProviderSpecificSettings, len(rawMessages))

	for index, rawMessage := range rawMessages {
		mpss, err := unmarshalBasicMigrationProviderSpecificSettings(*rawMessage)
		if err != nil {
			return nil, err
		}
		mpssArray[index] = mpss
	}
	return mpssArray, nil
}

// MarshalJSON is the custom marshaler for MigrationProviderSpecificSettings.
func (mpss MigrationProviderSpecificSettings) MarshalJSON() ([]byte, error) {
	mpss.InstanceType = InstanceTypeBasicMigrationProviderSpecificSettingsInstanceTypeMigrationProviderSpecificSettings
	objectMap := make(map[string]interface{})
	if mpss.InstanceType != "" {
		objectMap["instanceType"] = mpss.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsVMwareCbtMigrationDetails is the BasicMigrationProviderSpecificSettings implementation for MigrationProviderSpecificSettings.
func (mpss MigrationProviderSpecificSettings) AsVMwareCbtMigrationDetails() (*VMwareCbtMigrationDetails, bool) {
	return nil, false
}

// AsMigrationProviderSpecificSettings is the BasicMigrationProviderSpecificSettings implementation for MigrationProviderSpecificSettings.
func (mpss MigrationProviderSpecificSettings) AsMigrationProviderSpecificSettings() (*MigrationProviderSpecificSettings, bool) {
	return &mpss, true
}

// AsBasicMigrationProviderSpecificSettings is the BasicMigrationProviderSpecificSettings implementation for MigrationProviderSpecificSettings.
func (mpss MigrationProviderSpecificSettings) AsBasicMigrationProviderSpecificSettings() (BasicMigrationProviderSpecificSettings, bool) {
	return &mpss, true
}

// MigrationRecoveryPoint recovery point for a migration item.
type MigrationRecoveryPoint struct {
	autorest.Response `json:"-"`
	// Properties - Recovery point properties.
	Properties *MigrationRecoveryPointProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource Type
	Type *string `json:"type,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrationRecoveryPoint.
func (mrp MigrationRecoveryPoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mrp.Properties != nil {
		objectMap["properties"] = mrp.Properties
	}
	if mrp.Location != nil {
		objectMap["location"] = mrp.Location
	}
	return json.Marshal(objectMap)
}

// MigrationRecoveryPointCollection collection of migration recovery points.
type MigrationRecoveryPointCollection struct {
	autorest.Response `json:"-"`
	// Value - The migration recovery point details.
	Value *[]MigrationRecoveryPoint `json:"value,omitempty"`
	// NextLink - The value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// MigrationRecoveryPointCollectionIterator provides access to a complete listing of MigrationRecoveryPoint
// values.
type MigrationRecoveryPointCollectionIterator struct {
	i    int
	page MigrationRecoveryPointCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *MigrationRecoveryPointCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MigrationRecoveryPointCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *MigrationRecoveryPointCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter MigrationRecoveryPointCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter MigrationRecoveryPointCollectionIterator) Response() MigrationRecoveryPointCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter MigrationRecoveryPointCollectionIterator) Value() MigrationRecoveryPoint {
	if !iter.page.NotDone() {
		return MigrationRecoveryPoint{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the MigrationRecoveryPointCollectionIterator type.
func NewMigrationRecoveryPointCollectionIterator(page MigrationRecoveryPointCollectionPage) MigrationRecoveryPointCollectionIterator {
	return MigrationRecoveryPointCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mrpc MigrationRecoveryPointCollection) IsEmpty() bool {
	return mrpc.Value == nil || len(*mrpc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mrpc MigrationRecoveryPointCollection) hasNextLink() bool {
	return mrpc.NextLink != nil && len(*mrpc.NextLink) != 0
}

// migrationRecoveryPointCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mrpc MigrationRecoveryPointCollection) migrationRecoveryPointCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !mrpc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mrpc.NextLink)))
}

// MigrationRecoveryPointCollectionPage contains a page of MigrationRecoveryPoint values.
type MigrationRecoveryPointCollectionPage struct {
	fn   func(context.Context, MigrationRecoveryPointCollection) (MigrationRecoveryPointCollection, error)
	mrpc MigrationRecoveryPointCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *MigrationRecoveryPointCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MigrationRecoveryPointCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mrpc)
		if err != nil {
			return err
		}
		page.mrpc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *MigrationRecoveryPointCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page MigrationRecoveryPointCollectionPage) NotDone() bool {
	return !page.mrpc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page MigrationRecoveryPointCollectionPage) Response() MigrationRecoveryPointCollection {
	return page.mrpc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page MigrationRecoveryPointCollectionPage) Values() []MigrationRecoveryPoint {
	if page.mrpc.IsEmpty() {
		return nil
	}
	return *page.mrpc.Value
}

// Creates a new instance of the MigrationRecoveryPointCollectionPage type.
func NewMigrationRecoveryPointCollectionPage(cur MigrationRecoveryPointCollection, getNextPage func(context.Context, MigrationRecoveryPointCollection) (MigrationRecoveryPointCollection, error)) MigrationRecoveryPointCollectionPage {
	return MigrationRecoveryPointCollectionPage{
		fn:   getNextPage,
		mrpc: cur,
	}
}

// MigrationRecoveryPointProperties migration item recovery point properties.
type MigrationRecoveryPointProperties struct {
	// RecoveryPointTime - READ-ONLY; The recovery point time.
	RecoveryPointTime *date.Time `json:"recoveryPointTime,omitempty"`
	// RecoveryPointType - READ-ONLY; The recovery point type. Possible values include: 'MigrationRecoveryPointTypeNotSpecified', 'MigrationRecoveryPointTypeApplicationConsistent', 'MigrationRecoveryPointTypeCrashConsistent'
	RecoveryPointType MigrationRecoveryPointType `json:"recoveryPointType,omitempty"`
}

// MobilityServiceUpdate the Mobility Service update details.
type MobilityServiceUpdate struct {
	// Version - The version of the latest update.
	Version *string `json:"version,omitempty"`
	// RebootStatus - The reboot status of the update - whether it is required or not.
	RebootStatus *string `json:"rebootStatus,omitempty"`
	// OsType - The OS type.
	OsType *string `json:"osType,omitempty"`
}

// Network network model.
type Network struct {
	autorest.Response `json:"-"`
	// Properties - The Network Properties.
	Properties *NetworkProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource Type
	Type *string `json:"type,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for Network.
func (n Network) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if n.Properties != nil {
		objectMap["properties"] = n.Properties
	}
	if n.Location != nil {
		objectMap["location"] = n.Location
	}
	return json.Marshal(objectMap)
}

// NetworkCollection list of networks.
type NetworkCollection struct {
	autorest.Response `json:"-"`
	// Value - The Networks list details.
	Value *[]Network `json:"value,omitempty"`
	// NextLink - The value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// NetworkCollectionIterator provides access to a complete listing of Network values.
type NetworkCollectionIterator struct {
	i    int
	page NetworkCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *NetworkCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NetworkCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *NetworkCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter NetworkCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter NetworkCollectionIterator) Response() NetworkCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter NetworkCollectionIterator) Value() Network {
	if !iter.page.NotDone() {
		return Network{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the NetworkCollectionIterator type.
func NewNetworkCollectionIterator(page NetworkCollectionPage) NetworkCollectionIterator {
	return NetworkCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (nc NetworkCollection) IsEmpty() bool {
	return nc.Value == nil || len(*nc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (nc NetworkCollection) hasNextLink() bool {
	return nc.NextLink != nil && len(*nc.NextLink) != 0
}

// networkCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (nc NetworkCollection) networkCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !nc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(nc.NextLink)))
}

// NetworkCollectionPage contains a page of Network values.
type NetworkCollectionPage struct {
	fn func(context.Context, NetworkCollection) (NetworkCollection, error)
	nc NetworkCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *NetworkCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NetworkCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.nc)
		if err != nil {
			return err
		}
		page.nc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *NetworkCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page NetworkCollectionPage) NotDone() bool {
	return !page.nc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page NetworkCollectionPage) Response() NetworkCollection {
	return page.nc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page NetworkCollectionPage) Values() []Network {
	if page.nc.IsEmpty() {
		return nil
	}
	return *page.nc.Value
}

// Creates a new instance of the NetworkCollectionPage type.
func NewNetworkCollectionPage(cur NetworkCollection, getNextPage func(context.Context, NetworkCollection) (NetworkCollection, error)) NetworkCollectionPage {
	return NetworkCollectionPage{
		fn: getNextPage,
		nc: cur,
	}
}

// NetworkMapping network Mapping model. Ideally it should have been possible to inherit this class from
// prev version in InheritedModels as long as there is no difference in structure or method signature.
// Since there were no base Models for certain fields and methods viz NetworkMappingProperties and Load
// with required return type, the class has been introduced in its entirety with references to base models
// to facilitate extensions in subsequent versions.
type NetworkMapping struct {
	autorest.Response `json:"-"`
	// Properties - The Network Mapping Properties.
	Properties *NetworkMappingProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource Type
	Type *string `json:"type,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for NetworkMapping.
func (nm NetworkMapping) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if nm.Properties != nil {
		objectMap["properties"] = nm.Properties
	}
	if nm.Location != nil {
		objectMap["location"] = nm.Location
	}
	return json.Marshal(objectMap)
}

// NetworkMappingCollection list of network mappings. As with NetworkMapping, it should be possible to
// reuse a prev version of this class. It doesn't seem likely this class could be anything more than a
// slightly bespoke collection of NetworkMapping. Hence it makes sense to override Load with
// Base.NetworkMapping instead of existing CurrentVersion.NetworkMapping.
type NetworkMappingCollection struct {
	autorest.Response `json:"-"`
	// Value - The Network Mappings list.
	Value *[]NetworkMapping `json:"value,omitempty"`
	// NextLink - The value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// NetworkMappingCollectionIterator provides access to a complete listing of NetworkMapping values.
type NetworkMappingCollectionIterator struct {
	i    int
	page NetworkMappingCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *NetworkMappingCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NetworkMappingCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *NetworkMappingCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter NetworkMappingCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter NetworkMappingCollectionIterator) Response() NetworkMappingCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter NetworkMappingCollectionIterator) Value() NetworkMapping {
	if !iter.page.NotDone() {
		return NetworkMapping{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the NetworkMappingCollectionIterator type.
func NewNetworkMappingCollectionIterator(page NetworkMappingCollectionPage) NetworkMappingCollectionIterator {
	return NetworkMappingCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (nmc NetworkMappingCollection) IsEmpty() bool {
	return nmc.Value == nil || len(*nmc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (nmc NetworkMappingCollection) hasNextLink() bool {
	return nmc.NextLink != nil && len(*nmc.NextLink) != 0
}

// networkMappingCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (nmc NetworkMappingCollection) networkMappingCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !nmc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(nmc.NextLink)))
}

// NetworkMappingCollectionPage contains a page of NetworkMapping values.
type NetworkMappingCollectionPage struct {
	fn  func(context.Context, NetworkMappingCollection) (NetworkMappingCollection, error)
	nmc NetworkMappingCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *NetworkMappingCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NetworkMappingCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.nmc)
		if err != nil {
			return err
		}
		page.nmc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *NetworkMappingCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page NetworkMappingCollectionPage) NotDone() bool {
	return !page.nmc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page NetworkMappingCollectionPage) Response() NetworkMappingCollection {
	return page.nmc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page NetworkMappingCollectionPage) Values() []NetworkMapping {
	if page.nmc.IsEmpty() {
		return nil
	}
	return *page.nmc.Value
}

// Creates a new instance of the NetworkMappingCollectionPage type.
func NewNetworkMappingCollectionPage(cur NetworkMappingCollection, getNextPage func(context.Context, NetworkMappingCollection) (NetworkMappingCollection, error)) NetworkMappingCollectionPage {
	return NetworkMappingCollectionPage{
		fn:  getNextPage,
		nmc: cur,
	}
}

// BasicNetworkMappingFabricSpecificSettings network Mapping fabric specific settings.
type BasicNetworkMappingFabricSpecificSettings interface {
	AsAzureToAzureNetworkMappingSettings() (*AzureToAzureNetworkMappingSettings, bool)
	AsVmmToAzureNetworkMappingSettings() (*VmmToAzureNetworkMappingSettings, bool)
	AsVmmToVmmNetworkMappingSettings() (*VmmToVmmNetworkMappingSettings, bool)
	AsNetworkMappingFabricSpecificSettings() (*NetworkMappingFabricSpecificSettings, bool)
}

// NetworkMappingFabricSpecificSettings network Mapping fabric specific settings.
type NetworkMappingFabricSpecificSettings struct {
	// InstanceType - Possible values include: 'InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeNetworkMappingFabricSpecificSettings', 'InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeAzureToAzure', 'InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeVmmToAzure', 'InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeVmmToVmm'
	InstanceType InstanceTypeBasicNetworkMappingFabricSpecificSettings `json:"instanceType,omitempty"`
}

func unmarshalBasicNetworkMappingFabricSpecificSettings(body []byte) (BasicNetworkMappingFabricSpecificSettings, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeAzureToAzure):
		var atanms AzureToAzureNetworkMappingSettings
		err := json.Unmarshal(body, &atanms)
		return atanms, err
	case string(InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeVmmToAzure):
		var vtanms VmmToAzureNetworkMappingSettings
		err := json.Unmarshal(body, &vtanms)
		return vtanms, err
	case string(InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeVmmToVmm):
		var vtvnms VmmToVmmNetworkMappingSettings
		err := json.Unmarshal(body, &vtvnms)
		return vtvnms, err
	default:
		var nmfss NetworkMappingFabricSpecificSettings
		err := json.Unmarshal(body, &nmfss)
		return nmfss, err
	}
}
func unmarshalBasicNetworkMappingFabricSpecificSettingsArray(body []byte) ([]BasicNetworkMappingFabricSpecificSettings, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	nmfssArray := make([]BasicNetworkMappingFabricSpecificSettings, len(rawMessages))

	for index, rawMessage := range rawMessages {
		nmfss, err := unmarshalBasicNetworkMappingFabricSpecificSettings(*rawMessage)
		if err != nil {
			return nil, err
		}
		nmfssArray[index] = nmfss
	}
	return nmfssArray, nil
}

// MarshalJSON is the custom marshaler for NetworkMappingFabricSpecificSettings.
func (nmfss NetworkMappingFabricSpecificSettings) MarshalJSON() ([]byte, error) {
	nmfss.InstanceType = InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeNetworkMappingFabricSpecificSettings
	objectMap := make(map[string]interface{})
	if nmfss.InstanceType != "" {
		objectMap["instanceType"] = nmfss.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAzureToAzureNetworkMappingSettings is the BasicNetworkMappingFabricSpecificSettings implementation for NetworkMappingFabricSpecificSettings.
func (nmfss NetworkMappingFabricSpecificSettings) AsAzureToAzureNetworkMappingSettings() (*AzureToAzureNetworkMappingSettings, bool) {
	return nil, false
}

// AsVmmToAzureNetworkMappingSettings is the BasicNetworkMappingFabricSpecificSettings implementation for NetworkMappingFabricSpecificSettings.
func (nmfss NetworkMappingFabricSpecificSettings) AsVmmToAzureNetworkMappingSettings() (*VmmToAzureNetworkMappingSettings, bool) {
	return nil, false
}

// AsVmmToVmmNetworkMappingSettings is the BasicNetworkMappingFabricSpecificSettings implementation for NetworkMappingFabricSpecificSettings.
func (nmfss NetworkMappingFabricSpecificSettings) AsVmmToVmmNetworkMappingSettings() (*VmmToVmmNetworkMappingSettings, bool) {
	return nil, false
}

// AsNetworkMappingFabricSpecificSettings is the BasicNetworkMappingFabricSpecificSettings implementation for NetworkMappingFabricSpecificSettings.
func (nmfss NetworkMappingFabricSpecificSettings) AsNetworkMappingFabricSpecificSettings() (*NetworkMappingFabricSpecificSettings, bool) {
	return &nmfss, true
}

// AsBasicNetworkMappingFabricSpecificSettings is the BasicNetworkMappingFabricSpecificSettings implementation for NetworkMappingFabricSpecificSettings.
func (nmfss NetworkMappingFabricSpecificSettings) AsBasicNetworkMappingFabricSpecificSettings() (BasicNetworkMappingFabricSpecificSettings, bool) {
	return &nmfss, true
}

// NetworkMappingProperties network Mapping Properties.
type NetworkMappingProperties struct {
	// State - The pairing state for network mapping.
	State *string `json:"state,omitempty"`
	// PrimaryNetworkFriendlyName - The primary network friendly name.
	PrimaryNetworkFriendlyName *string `json:"primaryNetworkFriendlyName,omitempty"`
	// PrimaryNetworkID - The primary network id for network mapping.
	PrimaryNetworkID *string `json:"primaryNetworkId,omitempty"`
	// PrimaryFabricFriendlyName - The primary fabric friendly name.
	PrimaryFabricFriendlyName *string `json:"primaryFabricFriendlyName,omitempty"`
	// RecoveryNetworkFriendlyName - The recovery network friendly name.
	RecoveryNetworkFriendlyName *string `json:"recoveryNetworkFriendlyName,omitempty"`
	// RecoveryNetworkID - The recovery network id for network mapping.
	RecoveryNetworkID *string `json:"recoveryNetworkId,omitempty"`
	// RecoveryFabricArmID - The recovery fabric ARM id.
	RecoveryFabricArmID *string `json:"recoveryFabricArmId,omitempty"`
	// RecoveryFabricFriendlyName - The recovery fabric friendly name.
	RecoveryFabricFriendlyName *string `json:"recoveryFabricFriendlyName,omitempty"`
	// FabricSpecificSettings - The fabric specific settings.
	FabricSpecificSettings BasicNetworkMappingFabricSpecificSettings `json:"fabricSpecificSettings,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for NetworkMappingProperties struct.
func (nmp *NetworkMappingProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "state":
			if v != nil {
				var state string
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				nmp.State = &state
			}
		case "primaryNetworkFriendlyName":
			if v != nil {
				var primaryNetworkFriendlyName string
				err = json.Unmarshal(*v, &primaryNetworkFriendlyName)
				if err != nil {
					return err
				}
				nmp.PrimaryNetworkFriendlyName = &primaryNetworkFriendlyName
			}
		case "primaryNetworkId":
			if v != nil {
				var primaryNetworkID string
				err = json.Unmarshal(*v, &primaryNetworkID)
				if err != nil {
					return err
				}
				nmp.PrimaryNetworkID = &primaryNetworkID
			}
		case "primaryFabricFriendlyName":
			if v != nil {
				var primaryFabricFriendlyName string
				err = json.Unmarshal(*v, &primaryFabricFriendlyName)
				if err != nil {
					return err
				}
				nmp.PrimaryFabricFriendlyName = &primaryFabricFriendlyName
			}
		case "recoveryNetworkFriendlyName":
			if v != nil {
				var recoveryNetworkFriendlyName string
				err = json.Unmarshal(*v, &recoveryNetworkFriendlyName)
				if err != nil {
					return err
				}
				nmp.RecoveryNetworkFriendlyName = &recoveryNetworkFriendlyName
			}
		case "recoveryNetworkId":
			if v != nil {
				var recoveryNetworkID string
				err = json.Unmarshal(*v, &recoveryNetworkID)
				if err != nil {
					return err
				}
				nmp.RecoveryNetworkID = &recoveryNetworkID
			}
		case "recoveryFabricArmId":
			if v != nil {
				var recoveryFabricArmID string
				err = json.Unmarshal(*v, &recoveryFabricArmID)
				if err != nil {
					return err
				}
				nmp.RecoveryFabricArmID = &recoveryFabricArmID
			}
		case "recoveryFabricFriendlyName":
			if v != nil {
				var recoveryFabricFriendlyName string
				err = json.Unmarshal(*v, &recoveryFabricFriendlyName)
				if err != nil {
					return err
				}
				nmp.RecoveryFabricFriendlyName = &recoveryFabricFriendlyName
			}
		case "fabricSpecificSettings":
			if v != nil {
				fabricSpecificSettings, err := unmarshalBasicNetworkMappingFabricSpecificSettings(*v)
				if err != nil {
					return err
				}
				nmp.FabricSpecificSettings = fabricSpecificSettings
			}
		}
	}

	return nil
}

// NetworkProperties network Properties
type NetworkProperties struct {
	// FabricType - The Fabric Type.
	FabricType *string `json:"fabricType,omitempty"`
	// Subnets - The List of subnets.
	Subnets *[]Subnet `json:"subnets,omitempty"`
	// FriendlyName - The Friendly Name.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// NetworkType - The Network Type.
	NetworkType *string `json:"networkType,omitempty"`
}

// NewProtectionProfile new Protection profile input.
type NewProtectionProfile struct {
	// PolicyName - The protection profile input.
	PolicyName *string `json:"policyName,omitempty"`
	// RecoveryPointHistory - The duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistory *int32 `json:"recoveryPointHistory,omitempty"`
	// CrashConsistentFrequencyInMinutes - The crash consistent snapshot frequency (in minutes).
	CrashConsistentFrequencyInMinutes *int32 `json:"crashConsistentFrequencyInMinutes,omitempty"`
	// AppConsistentFrequencyInMinutes - The app consistent snapshot frequency (in minutes).
	AppConsistentFrequencyInMinutes *int32 `json:"appConsistentFrequencyInMinutes,omitempty"`
	// MultiVMSyncStatus - A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or 'Disabled'. Possible values include: 'Enable', 'Disable'
	MultiVMSyncStatus SetMultiVMSyncStatus `json:"multiVmSyncStatus,omitempty"`
	// ResourceType - Possible values include: 'ResourceTypeProtectionProfileCustomDetails', 'ResourceTypeExisting', 'ResourceTypeNew'
	ResourceType ResourceType `json:"resourceType,omitempty"`
}

// MarshalJSON is the custom marshaler for NewProtectionProfile.
func (npp NewProtectionProfile) MarshalJSON() ([]byte, error) {
	npp.ResourceType = ResourceTypeNew
	objectMap := make(map[string]interface{})
	if npp.PolicyName != nil {
		objectMap["policyName"] = npp.PolicyName
	}
	if npp.RecoveryPointHistory != nil {
		objectMap["recoveryPointHistory"] = npp.RecoveryPointHistory
	}
	if npp.CrashConsistentFrequencyInMinutes != nil {
		objectMap["crashConsistentFrequencyInMinutes"] = npp.CrashConsistentFrequencyInMinutes
	}
	if npp.AppConsistentFrequencyInMinutes != nil {
		objectMap["appConsistentFrequencyInMinutes"] = npp.AppConsistentFrequencyInMinutes
	}
	if npp.MultiVMSyncStatus != "" {
		objectMap["multiVmSyncStatus"] = npp.MultiVMSyncStatus
	}
	if npp.ResourceType != "" {
		objectMap["resourceType"] = npp.ResourceType
	}
	return json.Marshal(objectMap)
}

// AsExistingProtectionProfile is the BasicProtectionProfileCustomDetails implementation for NewProtectionProfile.
func (npp NewProtectionProfile) AsExistingProtectionProfile() (*ExistingProtectionProfile, bool) {
	return nil, false
}

// AsNewProtectionProfile is the BasicProtectionProfileCustomDetails implementation for NewProtectionProfile.
func (npp NewProtectionProfile) AsNewProtectionProfile() (*NewProtectionProfile, bool) {
	return &npp, true
}

// AsProtectionProfileCustomDetails is the BasicProtectionProfileCustomDetails implementation for NewProtectionProfile.
func (npp NewProtectionProfile) AsProtectionProfileCustomDetails() (*ProtectionProfileCustomDetails, bool) {
	return nil, false
}

// AsBasicProtectionProfileCustomDetails is the BasicProtectionProfileCustomDetails implementation for NewProtectionProfile.
func (npp NewProtectionProfile) AsBasicProtectionProfileCustomDetails() (BasicProtectionProfileCustomDetails, bool) {
	return &npp, true
}

// OperationsDiscovery operations discovery class.
type OperationsDiscovery struct {
	// Name - Name of the API. The name of the operation being performed on this particular object. It should match the action name that appears in RBAC / the event service. Examples of operations include: * Microsoft.Compute/virtualMachine/capture/action * Microsoft.Compute/virtualMachine/restart/action * Microsoft.Compute/virtualMachine/write * Microsoft.Compute/virtualMachine/read * Microsoft.Compute/virtualMachine/delete Each action should include, in order: (1) Resource Provider Namespace (2) Type hierarchy for which the action applies (e.g. server/databases for a SQL Azure database) (3) Read, Write, Action or Delete indicating which type applies. If it is a PUT/PATCH on a collection or named value, Write should be used. If it is a GET, Read should be used. If it is a DELETE, Delete should be used. If it is a POST, Action should be used. As a note: all resource providers would need to include the "{Resource Provider Namespace}/register/action" operation in their response. This API is used to register for their service, and should include details about the operation (e.g. a localized name for the resource provider + any special considerations like PII release)
	Name *string `json:"name,omitempty"`
	// Display - Object type
	Display *Display `json:"display,omitempty"`
	// Origin - Origin. The intended executor of the operation; governs the display of the operation in the RBAC UX and the audit logs UX. Default value is "user,system"
	Origin *string `json:"origin,omitempty"`
	// Properties - Properties. Reserved for future use.
	Properties interface{} `json:"properties,omitempty"`
}

// OperationsDiscoveryCollection collection of ClientDiscovery details.
type OperationsDiscoveryCollection struct {
	autorest.Response `json:"-"`
	// Value - The ClientDiscovery details.
	Value *[]OperationsDiscovery `json:"value,omitempty"`
	// NextLink - The value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationsDiscoveryCollectionIterator provides access to a complete listing of OperationsDiscovery
// values.
type OperationsDiscoveryCollectionIterator struct {
	i    int
	page OperationsDiscoveryCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationsDiscoveryCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationsDiscoveryCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationsDiscoveryCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationsDiscoveryCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationsDiscoveryCollectionIterator) Response() OperationsDiscoveryCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationsDiscoveryCollectionIterator) Value() OperationsDiscovery {
	if !iter.page.NotDone() {
		return OperationsDiscovery{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationsDiscoveryCollectionIterator type.
func NewOperationsDiscoveryCollectionIterator(page OperationsDiscoveryCollectionPage) OperationsDiscoveryCollectionIterator {
	return OperationsDiscoveryCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (odc OperationsDiscoveryCollection) IsEmpty() bool {
	return odc.Value == nil || len(*odc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (odc OperationsDiscoveryCollection) hasNextLink() bool {
	return odc.NextLink != nil && len(*odc.NextLink) != 0
}

// operationsDiscoveryCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (odc OperationsDiscoveryCollection) operationsDiscoveryCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !odc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(odc.NextLink)))
}

// OperationsDiscoveryCollectionPage contains a page of OperationsDiscovery values.
type OperationsDiscoveryCollectionPage struct {
	fn  func(context.Context, OperationsDiscoveryCollection) (OperationsDiscoveryCollection, error)
	odc OperationsDiscoveryCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationsDiscoveryCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationsDiscoveryCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.odc)
		if err != nil {
			return err
		}
		page.odc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationsDiscoveryCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationsDiscoveryCollectionPage) NotDone() bool {
	return !page.odc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationsDiscoveryCollectionPage) Response() OperationsDiscoveryCollection {
	return page.odc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationsDiscoveryCollectionPage) Values() []OperationsDiscovery {
	if page.odc.IsEmpty() {
		return nil
	}
	return *page.odc.Value
}

// Creates a new instance of the OperationsDiscoveryCollectionPage type.
func NewOperationsDiscoveryCollectionPage(cur OperationsDiscoveryCollection, getNextPage func(context.Context, OperationsDiscoveryCollection) (OperationsDiscoveryCollection, error)) OperationsDiscoveryCollectionPage {
	return OperationsDiscoveryCollectionPage{
		fn:  getNextPage,
		odc: cur,
	}
}

// OSDetails disk Details.
type OSDetails struct {
	// OsType - VM Disk details.
	OsType *string `json:"osType,omitempty"`
	// ProductType - Product type.
	ProductType *string `json:"productType,omitempty"`
	// OsEdition - The OSEdition.
	OsEdition *string `json:"osEdition,omitempty"`
	// OSVersion - The OS Version.
	OSVersion *string `json:"oSVersion,omitempty"`
	// OSMajorVersion - The OS Major Version.
	OSMajorVersion *string `json:"oSMajorVersion,omitempty"`
	// OSMinorVersion - The OS Minor Version.
	OSMinorVersion *string `json:"oSMinorVersion,omitempty"`
}

// OSDiskDetails details of the OS Disk.
type OSDiskDetails struct {
	// OsVhdID - The id of the disk containing the OS.
	OsVhdID *string `json:"osVhdId,omitempty"`
	// OsType - The type of the OS on the VM.
	OsType *string `json:"osType,omitempty"`
	// VhdName - The OS disk VHD name.
	VhdName *string `json:"vhdName,omitempty"`
}

// OSVersionWrapper wrapper model for OSVersion to include version and service pack info.
type OSVersionWrapper struct {
	// Version - The version.
	Version *string `json:"version,omitempty"`
	// ServicePack - Service pack.
	ServicePack *string `json:"servicePack,omitempty"`
}

// PlannedFailoverInput input definition for planned failover.
type PlannedFailoverInput struct {
	// Properties - Planned failover input properties
	Properties *PlannedFailoverInputProperties `json:"properties,omitempty"`
}

// PlannedFailoverInputProperties input definition for planned failover input properties.
type PlannedFailoverInputProperties struct {
	// FailoverDirection - Failover direction.
	FailoverDirection *string `json:"failoverDirection,omitempty"`
	// ProviderSpecificDetails - Provider specific settings
	ProviderSpecificDetails BasicProviderSpecificFailoverInput `json:"providerSpecificDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for PlannedFailoverInputProperties struct.
func (pfip *PlannedFailoverInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "failoverDirection":
			if v != nil {
				var failoverDirection string
				err = json.Unmarshal(*v, &failoverDirection)
				if err != nil {
					return err
				}
				pfip.FailoverDirection = &failoverDirection
			}
		case "providerSpecificDetails":
			if v != nil {
				providerSpecificDetails, err := unmarshalBasicProviderSpecificFailoverInput(*v)
				if err != nil {
					return err
				}
				pfip.ProviderSpecificDetails = providerSpecificDetails
			}
		}
	}

	return nil
}

// Policy protection profile details.
type Policy struct {
	autorest.Response `json:"-"`
	// Properties - The custom data.
	Properties *PolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource Type
	Type *string `json:"type,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for Policy.
func (p Policy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.Properties != nil {
		objectMap["properties"] = p.Properties
	}
	if p.Location != nil {
		objectMap["location"] = p.Location
	}
	return json.Marshal(objectMap)
}

// PolicyCollection protection Profile Collection details.
type PolicyCollection struct {
	autorest.Response `json:"-"`
	// Value - The policy details.
	Value *[]Policy `json:"value,omitempty"`
	// NextLink - The value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// PolicyCollectionIterator provides access to a complete listing of Policy values.
type PolicyCollectionIterator struct {
	i    int
	page PolicyCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PolicyCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PolicyCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PolicyCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PolicyCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PolicyCollectionIterator) Response() PolicyCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PolicyCollectionIterator) Value() Policy {
	if !iter.page.NotDone() {
		return Policy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PolicyCollectionIterator type.
func NewPolicyCollectionIterator(page PolicyCollectionPage) PolicyCollectionIterator {
	return PolicyCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pc PolicyCollection) IsEmpty() bool {
	return pc.Value == nil || len(*pc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pc PolicyCollection) hasNextLink() bool {
	return pc.NextLink != nil && len(*pc.NextLink) != 0
}

// policyCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pc PolicyCollection) policyCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !pc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pc.NextLink)))
}

// PolicyCollectionPage contains a page of Policy values.
type PolicyCollectionPage struct {
	fn func(context.Context, PolicyCollection) (PolicyCollection, error)
	pc PolicyCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PolicyCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PolicyCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pc)
		if err != nil {
			return err
		}
		page.pc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PolicyCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PolicyCollectionPage) NotDone() bool {
	return !page.pc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PolicyCollectionPage) Response() PolicyCollection {
	return page.pc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PolicyCollectionPage) Values() []Policy {
	if page.pc.IsEmpty() {
		return nil
	}
	return *page.pc.Value
}

// Creates a new instance of the PolicyCollectionPage type.
func NewPolicyCollectionPage(cur PolicyCollection, getNextPage func(context.Context, PolicyCollection) (PolicyCollection, error)) PolicyCollectionPage {
	return PolicyCollectionPage{
		fn: getNextPage,
		pc: cur,
	}
}

// PolicyProperties protection profile custom data details.
type PolicyProperties struct {
	// FriendlyName - The FriendlyName.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProviderSpecificDetails - The ReplicationChannelSetting.
	ProviderSpecificDetails BasicPolicyProviderSpecificDetails `json:"providerSpecificDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for PolicyProperties struct.
func (pp *PolicyProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "friendlyName":
			if v != nil {
				var friendlyName string
				err = json.Unmarshal(*v, &friendlyName)
				if err != nil {
					return err
				}
				pp.FriendlyName = &friendlyName
			}
		case "providerSpecificDetails":
			if v != nil {
				providerSpecificDetails, err := unmarshalBasicPolicyProviderSpecificDetails(*v)
				if err != nil {
					return err
				}
				pp.ProviderSpecificDetails = providerSpecificDetails
			}
		}
	}

	return nil
}

// BasicPolicyProviderSpecificDetails base class for Provider specific details for policies.
type BasicPolicyProviderSpecificDetails interface {
	AsA2APolicyDetails() (*A2APolicyDetails, bool)
	AsHyperVReplicaAzurePolicyDetails() (*HyperVReplicaAzurePolicyDetails, bool)
	AsHyperVReplicaBasePolicyDetails() (*HyperVReplicaBasePolicyDetails, bool)
	AsHyperVReplicaBluePolicyDetails() (*HyperVReplicaBluePolicyDetails, bool)
	AsHyperVReplicaPolicyDetails() (*HyperVReplicaPolicyDetails, bool)
	AsInMageAzureV2PolicyDetails() (*InMageAzureV2PolicyDetails, bool)
	AsInMageBasePolicyDetails() (*InMageBasePolicyDetails, bool)
	AsInMagePolicyDetails() (*InMagePolicyDetails, bool)
	AsInMageRcmPolicyDetails() (*InMageRcmPolicyDetails, bool)
	AsRcmAzureMigrationPolicyDetails() (*RcmAzureMigrationPolicyDetails, bool)
	AsVmwareCbtPolicyDetails() (*VmwareCbtPolicyDetails, bool)
	AsPolicyProviderSpecificDetails() (*PolicyProviderSpecificDetails, bool)
}

// PolicyProviderSpecificDetails base class for Provider specific details for policies.
type PolicyProviderSpecificDetails struct {
	// InstanceType - Possible values include: 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypePolicyProviderSpecificDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeA2A', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaBasePolicyDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageAzureV2', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageBasePolicyDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMage', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageRcm', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeRcmAzureMigration', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeVMwareCbt'
	InstanceType InstanceTypeBasicPolicyProviderSpecificDetails `json:"instanceType,omitempty"`
}

func unmarshalBasicPolicyProviderSpecificDetails(body []byte) (BasicPolicyProviderSpecificDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeA2A):
		var apd A2APolicyDetails
		err := json.Unmarshal(body, &apd)
		return apd, err
	case string(InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaAzure):
		var hvrapd HyperVReplicaAzurePolicyDetails
		err := json.Unmarshal(body, &hvrapd)
		return hvrapd, err
	case string(InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaBasePolicyDetails):
		var hvrbpd HyperVReplicaBasePolicyDetails
		err := json.Unmarshal(body, &hvrbpd)
		return hvrbpd, err
	case string(InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012R2):
		var hvrbpd HyperVReplicaBluePolicyDetails
		err := json.Unmarshal(body, &hvrbpd)
		return hvrbpd, err
	case string(InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012):
		var hvrpd HyperVReplicaPolicyDetails
		err := json.Unmarshal(body, &hvrpd)
		return hvrpd, err
	case string(InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageAzureV2):
		var imavpd InMageAzureV2PolicyDetails
		err := json.Unmarshal(body, &imavpd)
		return imavpd, err
	case string(InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageBasePolicyDetails):
		var imbpd InMageBasePolicyDetails
		err := json.Unmarshal(body, &imbpd)
		return imbpd, err
	case string(InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMage):
		var impd InMagePolicyDetails
		err := json.Unmarshal(body, &impd)
		return impd, err
	case string(InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageRcm):
		var imrpd InMageRcmPolicyDetails
		err := json.Unmarshal(body, &imrpd)
		return imrpd, err
	case string(InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeRcmAzureMigration):
		var rampd RcmAzureMigrationPolicyDetails
		err := json.Unmarshal(body, &rampd)
		return rampd, err
	case string(InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeVMwareCbt):
		var vcpd VmwareCbtPolicyDetails
		err := json.Unmarshal(body, &vcpd)
		return vcpd, err
	default:
		var ppsd PolicyProviderSpecificDetails
		err := json.Unmarshal(body, &ppsd)
		return ppsd, err
	}
}
func unmarshalBasicPolicyProviderSpecificDetailsArray(body []byte) ([]BasicPolicyProviderSpecificDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ppsdArray := make([]BasicPolicyProviderSpecificDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ppsd, err := unmarshalBasicPolicyProviderSpecificDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		ppsdArray[index] = ppsd
	}
	return ppsdArray, nil
}

// MarshalJSON is the custom marshaler for PolicyProviderSpecificDetails.
func (ppsd PolicyProviderSpecificDetails) MarshalJSON() ([]byte, error) {
	ppsd.InstanceType = InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypePolicyProviderSpecificDetails
	objectMap := make(map[string]interface{})
	if ppsd.InstanceType != "" {
		objectMap["instanceType"] = ppsd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2APolicyDetails is the BasicPolicyProviderSpecificDetails implementation for PolicyProviderSpecificDetails.
func (ppsd PolicyProviderSpecificDetails) AsA2APolicyDetails() (*A2APolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzurePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for PolicyProviderSpecificDetails.
func (ppsd PolicyProviderSpecificDetails) AsHyperVReplicaAzurePolicyDetails() (*HyperVReplicaAzurePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBasePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for PolicyProviderSpecificDetails.
func (ppsd PolicyProviderSpecificDetails) AsHyperVReplicaBasePolicyDetails() (*HyperVReplicaBasePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for PolicyProviderSpecificDetails.
func (ppsd PolicyProviderSpecificDetails) AsHyperVReplicaBluePolicyDetails() (*HyperVReplicaBluePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for PolicyProviderSpecificDetails.
func (ppsd PolicyProviderSpecificDetails) AsHyperVReplicaPolicyDetails() (*HyperVReplicaPolicyDetails, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyDetails is the BasicPolicyProviderSpecificDetails implementation for PolicyProviderSpecificDetails.
func (ppsd PolicyProviderSpecificDetails) AsInMageAzureV2PolicyDetails() (*InMageAzureV2PolicyDetails, bool) {
	return nil, false
}

// AsInMageBasePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for PolicyProviderSpecificDetails.
func (ppsd PolicyProviderSpecificDetails) AsInMageBasePolicyDetails() (*InMageBasePolicyDetails, bool) {
	return nil, false
}

// AsInMagePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for PolicyProviderSpecificDetails.
func (ppsd PolicyProviderSpecificDetails) AsInMagePolicyDetails() (*InMagePolicyDetails, bool) {
	return nil, false
}

// AsInMageRcmPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for PolicyProviderSpecificDetails.
func (ppsd PolicyProviderSpecificDetails) AsInMageRcmPolicyDetails() (*InMageRcmPolicyDetails, bool) {
	return nil, false
}

// AsRcmAzureMigrationPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for PolicyProviderSpecificDetails.
func (ppsd PolicyProviderSpecificDetails) AsRcmAzureMigrationPolicyDetails() (*RcmAzureMigrationPolicyDetails, bool) {
	return nil, false
}

// AsVmwareCbtPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for PolicyProviderSpecificDetails.
func (ppsd PolicyProviderSpecificDetails) AsVmwareCbtPolicyDetails() (*VmwareCbtPolicyDetails, bool) {
	return nil, false
}

// AsPolicyProviderSpecificDetails is the BasicPolicyProviderSpecificDetails implementation for PolicyProviderSpecificDetails.
func (ppsd PolicyProviderSpecificDetails) AsPolicyProviderSpecificDetails() (*PolicyProviderSpecificDetails, bool) {
	return &ppsd, true
}

// AsBasicPolicyProviderSpecificDetails is the BasicPolicyProviderSpecificDetails implementation for PolicyProviderSpecificDetails.
func (ppsd PolicyProviderSpecificDetails) AsBasicPolicyProviderSpecificDetails() (BasicPolicyProviderSpecificDetails, bool) {
	return &ppsd, true
}

// BasicPolicyProviderSpecificInput base class for provider specific input
type BasicPolicyProviderSpecificInput interface {
	AsA2APolicyCreationInput() (*A2APolicyCreationInput, bool)
	AsHyperVReplicaAzurePolicyInput() (*HyperVReplicaAzurePolicyInput, bool)
	AsHyperVReplicaBluePolicyInput() (*HyperVReplicaBluePolicyInput, bool)
	AsHyperVReplicaPolicyInput() (*HyperVReplicaPolicyInput, bool)
	AsInMageAzureV2PolicyInput() (*InMageAzureV2PolicyInput, bool)
	AsInMagePolicyInput() (*InMagePolicyInput, bool)
	AsInMageRcmPolicyCreationInput() (*InMageRcmPolicyCreationInput, bool)
	AsVMwareCbtPolicyCreationInput() (*VMwareCbtPolicyCreationInput, bool)
	AsPolicyProviderSpecificInput() (*PolicyProviderSpecificInput, bool)
}

// PolicyProviderSpecificInput base class for provider specific input
type PolicyProviderSpecificInput struct {
	// InstanceType - Possible values include: 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypePolicyProviderSpecificInput', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeA2A', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMage', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMageRcm', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeVMwareCbt'
	InstanceType InstanceTypeBasicPolicyProviderSpecificInput `json:"instanceType,omitempty"`
}

func unmarshalBasicPolicyProviderSpecificInput(body []byte) (BasicPolicyProviderSpecificInput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeA2A):
		var apci A2APolicyCreationInput
		err := json.Unmarshal(body, &apci)
		return apci, err
	case string(InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplicaAzure):
		var hvrapi HyperVReplicaAzurePolicyInput
		err := json.Unmarshal(body, &hvrapi)
		return hvrapi, err
	case string(InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012R2):
		var hvrbpi HyperVReplicaBluePolicyInput
		err := json.Unmarshal(body, &hvrbpi)
		return hvrbpi, err
	case string(InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012):
		var hvrpi HyperVReplicaPolicyInput
		err := json.Unmarshal(body, &hvrpi)
		return hvrpi, err
	case string(InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMageAzureV2):
		var imavpi InMageAzureV2PolicyInput
		err := json.Unmarshal(body, &imavpi)
		return imavpi, err
	case string(InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMage):
		var impi InMagePolicyInput
		err := json.Unmarshal(body, &impi)
		return impi, err
	case string(InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMageRcm):
		var imrpci InMageRcmPolicyCreationInput
		err := json.Unmarshal(body, &imrpci)
		return imrpci, err
	case string(InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeVMwareCbt):
		var vmcpci VMwareCbtPolicyCreationInput
		err := json.Unmarshal(body, &vmcpci)
		return vmcpci, err
	default:
		var ppsi PolicyProviderSpecificInput
		err := json.Unmarshal(body, &ppsi)
		return ppsi, err
	}
}
func unmarshalBasicPolicyProviderSpecificInputArray(body []byte) ([]BasicPolicyProviderSpecificInput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ppsiArray := make([]BasicPolicyProviderSpecificInput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ppsi, err := unmarshalBasicPolicyProviderSpecificInput(*rawMessage)
		if err != nil {
			return nil, err
		}
		ppsiArray[index] = ppsi
	}
	return ppsiArray, nil
}

// MarshalJSON is the custom marshaler for PolicyProviderSpecificInput.
func (ppsi PolicyProviderSpecificInput) MarshalJSON() ([]byte, error) {
	ppsi.InstanceType = InstanceTypeBasicPolicyProviderSpecificInputInstanceTypePolicyProviderSpecificInput
	objectMap := make(map[string]interface{})
	if ppsi.InstanceType != "" {
		objectMap["instanceType"] = ppsi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2APolicyCreationInput is the BasicPolicyProviderSpecificInput implementation for PolicyProviderSpecificInput.
func (ppsi PolicyProviderSpecificInput) AsA2APolicyCreationInput() (*A2APolicyCreationInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzurePolicyInput is the BasicPolicyProviderSpecificInput implementation for PolicyProviderSpecificInput.
func (ppsi PolicyProviderSpecificInput) AsHyperVReplicaAzurePolicyInput() (*HyperVReplicaAzurePolicyInput, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyInput is the BasicPolicyProviderSpecificInput implementation for PolicyProviderSpecificInput.
func (ppsi PolicyProviderSpecificInput) AsHyperVReplicaBluePolicyInput() (*HyperVReplicaBluePolicyInput, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyInput is the BasicPolicyProviderSpecificInput implementation for PolicyProviderSpecificInput.
func (ppsi PolicyProviderSpecificInput) AsHyperVReplicaPolicyInput() (*HyperVReplicaPolicyInput, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyInput is the BasicPolicyProviderSpecificInput implementation for PolicyProviderSpecificInput.
func (ppsi PolicyProviderSpecificInput) AsInMageAzureV2PolicyInput() (*InMageAzureV2PolicyInput, bool) {
	return nil, false
}

// AsInMagePolicyInput is the BasicPolicyProviderSpecificInput implementation for PolicyProviderSpecificInput.
func (ppsi PolicyProviderSpecificInput) AsInMagePolicyInput() (*InMagePolicyInput, bool) {
	return nil, false
}

// AsInMageRcmPolicyCreationInput is the BasicPolicyProviderSpecificInput implementation for PolicyProviderSpecificInput.
func (ppsi PolicyProviderSpecificInput) AsInMageRcmPolicyCreationInput() (*InMageRcmPolicyCreationInput, bool) {
	return nil, false
}

// AsVMwareCbtPolicyCreationInput is the BasicPolicyProviderSpecificInput implementation for PolicyProviderSpecificInput.
func (ppsi PolicyProviderSpecificInput) AsVMwareCbtPolicyCreationInput() (*VMwareCbtPolicyCreationInput, bool) {
	return nil, false
}

// AsPolicyProviderSpecificInput is the BasicPolicyProviderSpecificInput implementation for PolicyProviderSpecificInput.
func (ppsi PolicyProviderSpecificInput) AsPolicyProviderSpecificInput() (*PolicyProviderSpecificInput, bool) {
	return &ppsi, true
}

// AsBasicPolicyProviderSpecificInput is the BasicPolicyProviderSpecificInput implementation for PolicyProviderSpecificInput.
func (ppsi PolicyProviderSpecificInput) AsBasicPolicyProviderSpecificInput() (BasicPolicyProviderSpecificInput, bool) {
	return &ppsi, true
}

// ProcessServer details of the Process Server.
type ProcessServer struct {
	// FriendlyName - The Process Server's friendly name.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ID - The Process Server Id.
	ID *string `json:"id,omitempty"`
	// IPAddress - The IP address of the server.
	IPAddress *string `json:"ipAddress,omitempty"`
	// OsType - The OS type of the server.
	OsType *string `json:"osType,omitempty"`
	// AgentVersion - The version of the scout component on the server.
	AgentVersion *string `json:"agentVersion,omitempty"`
	// LastHeartbeat - The last heartbeat received from the server.
	LastHeartbeat *date.Time `json:"lastHeartbeat,omitempty"`
	// VersionStatus - Version status
	VersionStatus *string `json:"versionStatus,omitempty"`
	// MobilityServiceUpdates - The list of the mobility service updates available on the Process Server.
	MobilityServiceUpdates *[]MobilityServiceUpdate `json:"mobilityServiceUpdates,omitempty"`
	// HostID - The agent generated Id.
	HostID *string `json:"hostId,omitempty"`
	// MachineCount - The servers configured with this PS.
	MachineCount *string `json:"machineCount,omitempty"`
	// ReplicationPairCount - The number of replication pairs configured in this PS.
	ReplicationPairCount *string `json:"replicationPairCount,omitempty"`
	// SystemLoad - The percentage of the system load.
	SystemLoad *string `json:"systemLoad,omitempty"`
	// SystemLoadStatus - The system load status.
	SystemLoadStatus *string `json:"systemLoadStatus,omitempty"`
	// CPULoad - The percentage of the CPU load.
	CPULoad *string `json:"cpuLoad,omitempty"`
	// CPULoadStatus - The CPU load status.
	CPULoadStatus *string `json:"cpuLoadStatus,omitempty"`
	// TotalMemoryInBytes - The total memory.
	TotalMemoryInBytes *int64 `json:"totalMemoryInBytes,omitempty"`
	// AvailableMemoryInBytes - The available memory.
	AvailableMemoryInBytes *int64 `json:"availableMemoryInBytes,omitempty"`
	// MemoryUsageStatus - The memory usage status.
	MemoryUsageStatus *string `json:"memoryUsageStatus,omitempty"`
	// TotalSpaceInBytes - The total space.
	TotalSpaceInBytes *int64 `json:"totalSpaceInBytes,omitempty"`
	// AvailableSpaceInBytes - The available space.
	AvailableSpaceInBytes *int64 `json:"availableSpaceInBytes,omitempty"`
	// SpaceUsageStatus - The space usage status.
	SpaceUsageStatus *string `json:"spaceUsageStatus,omitempty"`
	// PsServiceStatus - The PS service status.
	PsServiceStatus *string `json:"psServiceStatus,omitempty"`
	// SslCertExpiryDate - The PS SSL cert expiry date.
	SslCertExpiryDate *date.Time `json:"sslCertExpiryDate,omitempty"`
	// SslCertExpiryRemainingDays - CS SSL cert expiry date.
	SslCertExpiryRemainingDays *int32 `json:"sslCertExpiryRemainingDays,omitempty"`
	// OsVersion - OS Version of the process server. Note: This will get populated if user has CS version greater than 9.12.0.0.
	OsVersion *string `json:"osVersion,omitempty"`
	// HealthErrors - Health errors.
	HealthErrors *[]HealthError `json:"healthErrors,omitempty"`
	// AgentExpiryDate - Agent expiry date.
	AgentExpiryDate *date.Time `json:"agentExpiryDate,omitempty"`
	// AgentVersionDetails - The agent version details.
	AgentVersionDetails *VersionDetails `json:"agentVersionDetails,omitempty"`
	// Health - READ-ONLY; The health of Process Server. Possible values include: 'ProtectionHealthNone', 'ProtectionHealthNormal', 'ProtectionHealthWarning', 'ProtectionHealthCritical'
	Health ProtectionHealth `json:"health,omitempty"`
	// PsStatsRefreshTime - READ-ONLY; The process server stats refresh time.
	PsStatsRefreshTime *date.Time `json:"psStatsRefreshTime,omitempty"`
	// ThroughputUploadPendingDataInBytes - READ-ONLY; The uploading pending data in bytes.
	ThroughputUploadPendingDataInBytes *int64 `json:"throughputUploadPendingDataInBytes,omitempty"`
	// ThroughputInMBps - READ-ONLY; The throughput in MBps.
	ThroughputInMBps *int64 `json:"throughputInMBps,omitempty"`
	// ThroughputInBytes - READ-ONLY; The throughput in bytes.
	ThroughputInBytes *int64 `json:"throughputInBytes,omitempty"`
	// ThroughputStatus - READ-ONLY; The throughput status.
	ThroughputStatus *string `json:"throughputStatus,omitempty"`
	// MarsCommunicationStatus - READ-ONLY; The MARS communication status.
	MarsCommunicationStatus *string `json:"marsCommunicationStatus,omitempty"`
	// MarsRegistrationStatus - READ-ONLY; The MARS registration status.
	MarsRegistrationStatus *string `json:"marsRegistrationStatus,omitempty"`
}

// MarshalJSON is the custom marshaler for ProcessServer.
func (ps ProcessServer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ps.FriendlyName != nil {
		objectMap["friendlyName"] = ps.FriendlyName
	}
	if ps.ID != nil {
		objectMap["id"] = ps.ID
	}
	if ps.IPAddress != nil {
		objectMap["ipAddress"] = ps.IPAddress
	}
	if ps.OsType != nil {
		objectMap["osType"] = ps.OsType
	}
	if ps.AgentVersion != nil {
		objectMap["agentVersion"] = ps.AgentVersion
	}
	if ps.LastHeartbeat != nil {
		objectMap["lastHeartbeat"] = ps.LastHeartbeat
	}
	if ps.VersionStatus != nil {
		objectMap["versionStatus"] = ps.VersionStatus
	}
	if ps.MobilityServiceUpdates != nil {
		objectMap["mobilityServiceUpdates"] = ps.MobilityServiceUpdates
	}
	if ps.HostID != nil {
		objectMap["hostId"] = ps.HostID
	}
	if ps.MachineCount != nil {
		objectMap["machineCount"] = ps.MachineCount
	}
	if ps.ReplicationPairCount != nil {
		objectMap["replicationPairCount"] = ps.ReplicationPairCount
	}
	if ps.SystemLoad != nil {
		objectMap["systemLoad"] = ps.SystemLoad
	}
	if ps.SystemLoadStatus != nil {
		objectMap["systemLoadStatus"] = ps.SystemLoadStatus
	}
	if ps.CPULoad != nil {
		objectMap["cpuLoad"] = ps.CPULoad
	}
	if ps.CPULoadStatus != nil {
		objectMap["cpuLoadStatus"] = ps.CPULoadStatus
	}
	if ps.TotalMemoryInBytes != nil {
		objectMap["totalMemoryInBytes"] = ps.TotalMemoryInBytes
	}
	if ps.AvailableMemoryInBytes != nil {
		objectMap["availableMemoryInBytes"] = ps.AvailableMemoryInBytes
	}
	if ps.MemoryUsageStatus != nil {
		objectMap["memoryUsageStatus"] = ps.MemoryUsageStatus
	}
	if ps.TotalSpaceInBytes != nil {
		objectMap["totalSpaceInBytes"] = ps.TotalSpaceInBytes
	}
	if ps.AvailableSpaceInBytes != nil {
		objectMap["availableSpaceInBytes"] = ps.AvailableSpaceInBytes
	}
	if ps.SpaceUsageStatus != nil {
		objectMap["spaceUsageStatus"] = ps.SpaceUsageStatus
	}
	if ps.PsServiceStatus != nil {
		objectMap["psServiceStatus"] = ps.PsServiceStatus
	}
	if ps.SslCertExpiryDate != nil {
		objectMap["sslCertExpiryDate"] = ps.SslCertExpiryDate
	}
	if ps.SslCertExpiryRemainingDays != nil {
		objectMap["sslCertExpiryRemainingDays"] = ps.SslCertExpiryRemainingDays
	}
	if ps.OsVersion != nil {
		objectMap["osVersion"] = ps.OsVersion
	}
	if ps.HealthErrors != nil {
		objectMap["healthErrors"] = ps.HealthErrors
	}
	if ps.AgentExpiryDate != nil {
		objectMap["agentExpiryDate"] = ps.AgentExpiryDate
	}
	if ps.AgentVersionDetails != nil {
		objectMap["agentVersionDetails"] = ps.AgentVersionDetails
	}
	return json.Marshal(objectMap)
}

// ProcessServerDetails process server details.
type ProcessServerDetails struct {
	// ID - READ-ONLY; The process server Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The process server name.
	Name *string `json:"name,omitempty"`
	// Version - READ-ONLY; The process server version.
	Version *string `json:"version,omitempty"`
	// LastHeartbeatUtc - READ-ONLY; The last heartbeat received from the process server.
	LastHeartbeatUtc *date.Time `json:"lastHeartbeatUtc,omitempty"`
	// TotalMemoryInBytes - READ-ONLY; The total memory.
	TotalMemoryInBytes *int64 `json:"totalMemoryInBytes,omitempty"`
	// AvailableMemoryInBytes - READ-ONLY; The available memory.
	AvailableMemoryInBytes *int64 `json:"availableMemoryInBytes,omitempty"`
	// UsedMemoryInBytes - READ-ONLY; The used memory.
	UsedMemoryInBytes *int64 `json:"usedMemoryInBytes,omitempty"`
	// MemoryUsagePercentage - READ-ONLY; The memory usage percentage.
	MemoryUsagePercentage *float64 `json:"memoryUsagePercentage,omitempty"`
	// TotalSpaceInBytes - READ-ONLY; The total disk space.
	TotalSpaceInBytes *int64 `json:"totalSpaceInBytes,omitempty"`
	// AvailableSpaceInBytes - READ-ONLY; The available disk space.
	AvailableSpaceInBytes *int64 `json:"availableSpaceInBytes,omitempty"`
	// UsedSpaceInBytes - READ-ONLY; The used disk space.
	UsedSpaceInBytes *int64 `json:"usedSpaceInBytes,omitempty"`
	// FreeSpacePercentage - READ-ONLY; The free disk space percentage.
	FreeSpacePercentage *float64 `json:"freeSpacePercentage,omitempty"`
	// ThroughputUploadPendingDataInBytes - READ-ONLY; The uploading pending data in bytes.
	ThroughputUploadPendingDataInBytes *int64 `json:"throughputUploadPendingDataInBytes,omitempty"`
	// ThroughputInBytes - READ-ONLY; The throughput in bytes.
	ThroughputInBytes *int64 `json:"throughputInBytes,omitempty"`
	// ProcessorUsagePercentage - READ-ONLY; The processor usage percentage.
	ProcessorUsagePercentage *float64 `json:"processorUsagePercentage,omitempty"`
	// Health - READ-ONLY; The health of the process server. Possible values include: 'ProtectionHealthNone', 'ProtectionHealthNormal', 'ProtectionHealthWarning', 'ProtectionHealthCritical'
	Health ProtectionHealth `json:"health,omitempty"`
	// HealthErrors - READ-ONLY; The health errors.
	HealthErrors *[]HealthError `json:"healthErrors,omitempty"`
	// HistoricHealth - READ-ONLY; The historic health of the process server based on the health in last 24 hours. Possible values include: 'ProtectionHealthNone', 'ProtectionHealthNormal', 'ProtectionHealthWarning', 'ProtectionHealthCritical'
	HistoricHealth ProtectionHealth `json:"historicHealth,omitempty"`
}

// ProtectableItem replication protected item
type ProtectableItem struct {
	autorest.Response `json:"-"`
	// Properties - The custom data.
	Properties *ProtectableItemProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource Type
	Type *string `json:"type,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for ProtectableItem.
func (pi ProtectableItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pi.Properties != nil {
		objectMap["properties"] = pi.Properties
	}
	if pi.Location != nil {
		objectMap["location"] = pi.Location
	}
	return json.Marshal(objectMap)
}

// ProtectableItemCollection protectable item collection.
type ProtectableItemCollection struct {
	autorest.Response `json:"-"`
	// Value - The Protectable item details.
	Value *[]ProtectableItem `json:"value,omitempty"`
	// NextLink - The value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProtectableItemCollectionIterator provides access to a complete listing of ProtectableItem values.
type ProtectableItemCollectionIterator struct {
	i    int
	page ProtectableItemCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProtectableItemCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProtectableItemCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProtectableItemCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProtectableItemCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProtectableItemCollectionIterator) Response() ProtectableItemCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProtectableItemCollectionIterator) Value() ProtectableItem {
	if !iter.page.NotDone() {
		return ProtectableItem{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProtectableItemCollectionIterator type.
func NewProtectableItemCollectionIterator(page ProtectableItemCollectionPage) ProtectableItemCollectionIterator {
	return ProtectableItemCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pic ProtectableItemCollection) IsEmpty() bool {
	return pic.Value == nil || len(*pic.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pic ProtectableItemCollection) hasNextLink() bool {
	return pic.NextLink != nil && len(*pic.NextLink) != 0
}

// protectableItemCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pic ProtectableItemCollection) protectableItemCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !pic.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pic.NextLink)))
}

// ProtectableItemCollectionPage contains a page of ProtectableItem values.
type ProtectableItemCollectionPage struct {
	fn  func(context.Context, ProtectableItemCollection) (ProtectableItemCollection, error)
	pic ProtectableItemCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProtectableItemCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProtectableItemCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pic)
		if err != nil {
			return err
		}
		page.pic = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProtectableItemCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProtectableItemCollectionPage) NotDone() bool {
	return !page.pic.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProtectableItemCollectionPage) Response() ProtectableItemCollection {
	return page.pic
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProtectableItemCollectionPage) Values() []ProtectableItem {
	if page.pic.IsEmpty() {
		return nil
	}
	return *page.pic.Value
}

// Creates a new instance of the ProtectableItemCollectionPage type.
func NewProtectableItemCollectionPage(cur ProtectableItemCollection, getNextPage func(context.Context, ProtectableItemCollection) (ProtectableItemCollection, error)) ProtectableItemCollectionPage {
	return ProtectableItemCollectionPage{
		fn:  getNextPage,
		pic: cur,
	}
}

// ProtectableItemProperties replication protected item custom data details.
type ProtectableItemProperties struct {
	// FriendlyName - The name.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionStatus - The protection status.
	ProtectionStatus *string `json:"protectionStatus,omitempty"`
	// ReplicationProtectedItemID - The ARM resource of protected items.
	ReplicationProtectedItemID *string `json:"replicationProtectedItemId,omitempty"`
	// RecoveryServicesProviderID - The recovery provider ARM Id.
	RecoveryServicesProviderID *string `json:"recoveryServicesProviderId,omitempty"`
	// ProtectionReadinessErrors - The Current protection readiness errors.
	ProtectionReadinessErrors *[]string `json:"protectionReadinessErrors,omitempty"`
	// SupportedReplicationProviders - The list of replication providers supported for the protectable item.
	SupportedReplicationProviders *[]string `json:"supportedReplicationProviders,omitempty"`
	// CustomDetails - The Replication provider custom settings.
	CustomDetails BasicConfigurationSettings `json:"customDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ProtectableItemProperties struct.
func (pip *ProtectableItemProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "friendlyName":
			if v != nil {
				var friendlyName string
				err = json.Unmarshal(*v, &friendlyName)
				if err != nil {
					return err
				}
				pip.FriendlyName = &friendlyName
			}
		case "protectionStatus":
			if v != nil {
				var protectionStatus string
				err = json.Unmarshal(*v, &protectionStatus)
				if err != nil {
					return err
				}
				pip.ProtectionStatus = &protectionStatus
			}
		case "replicationProtectedItemId":
			if v != nil {
				var replicationProtectedItemID string
				err = json.Unmarshal(*v, &replicationProtectedItemID)
				if err != nil {
					return err
				}
				pip.ReplicationProtectedItemID = &replicationProtectedItemID
			}
		case "recoveryServicesProviderId":
			if v != nil {
				var recoveryServicesProviderID string
				err = json.Unmarshal(*v, &recoveryServicesProviderID)
				if err != nil {
					return err
				}
				pip.RecoveryServicesProviderID = &recoveryServicesProviderID
			}
		case "protectionReadinessErrors":
			if v != nil {
				var protectionReadinessErrors []string
				err = json.Unmarshal(*v, &protectionReadinessErrors)
				if err != nil {
					return err
				}
				pip.ProtectionReadinessErrors = &protectionReadinessErrors
			}
		case "supportedReplicationProviders":
			if v != nil {
				var supportedReplicationProviders []string
				err = json.Unmarshal(*v, &supportedReplicationProviders)
				if err != nil {
					return err
				}
				pip.SupportedReplicationProviders = &supportedReplicationProviders
			}
		case "customDetails":
			if v != nil {
				customDetails, err := unmarshalBasicConfigurationSettings(*v)
				if err != nil {
					return err
				}
				pip.CustomDetails = customDetails
			}
		}
	}

	return nil
}

// ProtectableItemQueryParameter query parameter to enumerate Protectable items.
type ProtectableItemQueryParameter struct {
	// State - State of the Protectable item query filter.
	State *string `json:"state,omitempty"`
}

// ProtectedItemsQueryParameter query parameter to enumerate protected items.
type ProtectedItemsQueryParameter struct {
	// SourceFabricName - The source fabric name filter.
	SourceFabricName *string `json:"sourceFabricName,omitempty"`
	// RecoveryPlanName - The recovery plan filter.
	RecoveryPlanName *string `json:"recoveryPlanName,omitempty"`
	// VCenterName - The vCenter name filter.
	VCenterName *string `json:"vCenterName,omitempty"`
	// InstanceType - The replication provider type.
	InstanceType *string `json:"instanceType,omitempty"`
	// MultiVMGroupCreateOption - Whether Multi VM group is auto created or specified by user. Possible values include: 'AutoCreated', 'UserSpecified'
	MultiVMGroupCreateOption MultiVMGroupCreateOption `json:"multiVmGroupCreateOption,omitempty"`
}

// ProtectionContainer protection container details.
type ProtectionContainer struct {
	autorest.Response `json:"-"`
	// Properties - The custom data.
	Properties *ProtectionContainerProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource Type
	Type *string `json:"type,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for ProtectionContainer.
func (pc ProtectionContainer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pc.Properties != nil {
		objectMap["properties"] = pc.Properties
	}
	if pc.Location != nil {
		objectMap["location"] = pc.Location
	}
	return json.Marshal(objectMap)
}

// ProtectionContainerCollection protection Container collection.
type ProtectionContainerCollection struct {
	autorest.Response `json:"-"`
	// Value - The Protection Container details.
	Value *[]ProtectionContainer `json:"value,omitempty"`
	// NextLink - The value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProtectionContainerCollectionIterator provides access to a complete listing of ProtectionContainer
// values.
type ProtectionContainerCollectionIterator struct {
	i    int
	page ProtectionContainerCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProtectionContainerCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProtectionContainerCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProtectionContainerCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProtectionContainerCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProtectionContainerCollectionIterator) Response() ProtectionContainerCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProtectionContainerCollectionIterator) Value() ProtectionContainer {
	if !iter.page.NotDone() {
		return ProtectionContainer{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProtectionContainerCollectionIterator type.
func NewProtectionContainerCollectionIterator(page ProtectionContainerCollectionPage) ProtectionContainerCollectionIterator {
	return ProtectionContainerCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pcc ProtectionContainerCollection) IsEmpty() bool {
	return pcc.Value == nil || len(*pcc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pcc ProtectionContainerCollection) hasNextLink() bool {
	return pcc.NextLink != nil && len(*pcc.NextLink) != 0
}

// protectionContainerCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pcc ProtectionContainerCollection) protectionContainerCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !pcc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pcc.NextLink)))
}

// ProtectionContainerCollectionPage contains a page of ProtectionContainer values.
type ProtectionContainerCollectionPage struct {
	fn  func(context.Context, ProtectionContainerCollection) (ProtectionContainerCollection, error)
	pcc ProtectionContainerCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProtectionContainerCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProtectionContainerCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pcc)
		if err != nil {
			return err
		}
		page.pcc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProtectionContainerCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProtectionContainerCollectionPage) NotDone() bool {
	return !page.pcc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProtectionContainerCollectionPage) Response() ProtectionContainerCollection {
	return page.pcc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProtectionContainerCollectionPage) Values() []ProtectionContainer {
	if page.pcc.IsEmpty() {
		return nil
	}
	return *page.pcc.Value
}

// Creates a new instance of the ProtectionContainerCollectionPage type.
func NewProtectionContainerCollectionPage(cur ProtectionContainerCollection, getNextPage func(context.Context, ProtectionContainerCollection) (ProtectionContainerCollection, error)) ProtectionContainerCollectionPage {
	return ProtectionContainerCollectionPage{
		fn:  getNextPage,
		pcc: cur,
	}
}

// ProtectionContainerFabricSpecificDetails base class for fabric specific details of container.
type ProtectionContainerFabricSpecificDetails struct {
	// InstanceType - READ-ONLY; Gets the class type. Overridden in derived classes.
	InstanceType *string `json:"instanceType,omitempty"`
}

// ProtectionContainerMapping protection container mapping object.
type ProtectionContainerMapping struct {
	autorest.Response `json:"-"`
	// Properties - The custom data.
	Properties *ProtectionContainerMappingProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource Type
	Type *string `json:"type,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for ProtectionContainerMapping.
func (pcm ProtectionContainerMapping) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pcm.Properties != nil {
		objectMap["properties"] = pcm.Properties
	}
	if pcm.Location != nil {
		objectMap["location"] = pcm.Location
	}
	return json.Marshal(objectMap)
}

// ProtectionContainerMappingCollection protection container mapping collection class.
type ProtectionContainerMappingCollection struct {
	autorest.Response `json:"-"`
	// Value - List of container mappings.
	Value *[]ProtectionContainerMapping `json:"value,omitempty"`
	// NextLink - Link to fetch rest of the data.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProtectionContainerMappingCollectionIterator provides access to a complete listing of
// ProtectionContainerMapping values.
type ProtectionContainerMappingCollectionIterator struct {
	i    int
	page ProtectionContainerMappingCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProtectionContainerMappingCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProtectionContainerMappingCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProtectionContainerMappingCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProtectionContainerMappingCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProtectionContainerMappingCollectionIterator) Response() ProtectionContainerMappingCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProtectionContainerMappingCollectionIterator) Value() ProtectionContainerMapping {
	if !iter.page.NotDone() {
		return ProtectionContainerMapping{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProtectionContainerMappingCollectionIterator type.
func NewProtectionContainerMappingCollectionIterator(page ProtectionContainerMappingCollectionPage) ProtectionContainerMappingCollectionIterator {
	return ProtectionContainerMappingCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pcmc ProtectionContainerMappingCollection) IsEmpty() bool {
	return pcmc.Value == nil || len(*pcmc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pcmc ProtectionContainerMappingCollection) hasNextLink() bool {
	return pcmc.NextLink != nil && len(*pcmc.NextLink) != 0
}

// protectionContainerMappingCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pcmc ProtectionContainerMappingCollection) protectionContainerMappingCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !pcmc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pcmc.NextLink)))
}

// ProtectionContainerMappingCollectionPage contains a page of ProtectionContainerMapping values.
type ProtectionContainerMappingCollectionPage struct {
	fn   func(context.Context, ProtectionContainerMappingCollection) (ProtectionContainerMappingCollection, error)
	pcmc ProtectionContainerMappingCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProtectionContainerMappingCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProtectionContainerMappingCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pcmc)
		if err != nil {
			return err
		}
		page.pcmc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProtectionContainerMappingCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProtectionContainerMappingCollectionPage) NotDone() bool {
	return !page.pcmc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProtectionContainerMappingCollectionPage) Response() ProtectionContainerMappingCollection {
	return page.pcmc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProtectionContainerMappingCollectionPage) Values() []ProtectionContainerMapping {
	if page.pcmc.IsEmpty() {
		return nil
	}
	return *page.pcmc.Value
}

// Creates a new instance of the ProtectionContainerMappingCollectionPage type.
func NewProtectionContainerMappingCollectionPage(cur ProtectionContainerMappingCollection, getNextPage func(context.Context, ProtectionContainerMappingCollection) (ProtectionContainerMappingCollection, error)) ProtectionContainerMappingCollectionPage {
	return ProtectionContainerMappingCollectionPage{
		fn:   getNextPage,
		pcmc: cur,
	}
}

// ProtectionContainerMappingProperties protection container mapping properties.
type ProtectionContainerMappingProperties struct {
	// TargetProtectionContainerID - Paired protection container ARM ID.
	TargetProtectionContainerID *string `json:"targetProtectionContainerId,omitempty"`
	// TargetProtectionContainerFriendlyName - Friendly name of paired container.
	TargetProtectionContainerFriendlyName *string `json:"targetProtectionContainerFriendlyName,omitempty"`
	// ProviderSpecificDetails - Provider specific provider details.
	ProviderSpecificDetails BasicProtectionContainerMappingProviderSpecificDetails `json:"providerSpecificDetails,omitempty"`
	// Health - Health of pairing.
	Health *string `json:"health,omitempty"`
	// HealthErrorDetails - Health error.
	HealthErrorDetails *[]HealthError `json:"healthErrorDetails,omitempty"`
	// PolicyID - Policy ARM Id.
	PolicyID *string `json:"policyId,omitempty"`
	// State - Association Status
	State *string `json:"state,omitempty"`
	// SourceProtectionContainerFriendlyName - Friendly name of source protection container.
	SourceProtectionContainerFriendlyName *string `json:"sourceProtectionContainerFriendlyName,omitempty"`
	// SourceFabricFriendlyName - Friendly name of source fabric.
	SourceFabricFriendlyName *string `json:"sourceFabricFriendlyName,omitempty"`
	// TargetFabricFriendlyName - Friendly name of target fabric.
	TargetFabricFriendlyName *string `json:"targetFabricFriendlyName,omitempty"`
	// PolicyFriendlyName - Friendly name of replication policy.
	PolicyFriendlyName *string `json:"policyFriendlyName,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ProtectionContainerMappingProperties struct.
func (pcmp *ProtectionContainerMappingProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "targetProtectionContainerId":
			if v != nil {
				var targetProtectionContainerID string
				err = json.Unmarshal(*v, &targetProtectionContainerID)
				if err != nil {
					return err
				}
				pcmp.TargetProtectionContainerID = &targetProtectionContainerID
			}
		case "targetProtectionContainerFriendlyName":
			if v != nil {
				var targetProtectionContainerFriendlyName string
				err = json.Unmarshal(*v, &targetProtectionContainerFriendlyName)
				if err != nil {
					return err
				}
				pcmp.TargetProtectionContainerFriendlyName = &targetProtectionContainerFriendlyName
			}
		case "providerSpecificDetails":
			if v != nil {
				providerSpecificDetails, err := unmarshalBasicProtectionContainerMappingProviderSpecificDetails(*v)
				if err != nil {
					return err
				}
				pcmp.ProviderSpecificDetails = providerSpecificDetails
			}
		case "health":
			if v != nil {
				var health string
				err = json.Unmarshal(*v, &health)
				if err != nil {
					return err
				}
				pcmp.Health = &health
			}
		case "healthErrorDetails":
			if v != nil {
				var healthErrorDetails []HealthError
				err = json.Unmarshal(*v, &healthErrorDetails)
				if err != nil {
					return err
				}
				pcmp.HealthErrorDetails = &healthErrorDetails
			}
		case "policyId":
			if v != nil {
				var policyID string
				err = json.Unmarshal(*v, &policyID)
				if err != nil {
					return err
				}
				pcmp.PolicyID = &policyID
			}
		case "state":
			if v != nil {
				var state string
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				pcmp.State = &state
			}
		case "sourceProtectionContainerFriendlyName":
			if v != nil {
				var sourceProtectionContainerFriendlyName string
				err = json.Unmarshal(*v, &sourceProtectionContainerFriendlyName)
				if err != nil {
					return err
				}
				pcmp.SourceProtectionContainerFriendlyName = &sourceProtectionContainerFriendlyName
			}
		case "sourceFabricFriendlyName":
			if v != nil {
				var sourceFabricFriendlyName string
				err = json.Unmarshal(*v, &sourceFabricFriendlyName)
				if err != nil {
					return err
				}
				pcmp.SourceFabricFriendlyName = &sourceFabricFriendlyName
			}
		case "targetFabricFriendlyName":
			if v != nil {
				var targetFabricFriendlyName string
				err = json.Unmarshal(*v, &targetFabricFriendlyName)
				if err != nil {
					return err
				}
				pcmp.TargetFabricFriendlyName = &targetFabricFriendlyName
			}
		case "policyFriendlyName":
			if v != nil {
				var policyFriendlyName string
				err = json.Unmarshal(*v, &policyFriendlyName)
				if err != nil {
					return err
				}
				pcmp.PolicyFriendlyName = &policyFriendlyName
			}
		}
	}

	return nil
}

// BasicProtectionContainerMappingProviderSpecificDetails container mapping provider specific details.
type BasicProtectionContainerMappingProviderSpecificDetails interface {
	AsA2AProtectionContainerMappingDetails() (*A2AProtectionContainerMappingDetails, bool)
	AsVMwareCbtProtectionContainerMappingDetails() (*VMwareCbtProtectionContainerMappingDetails, bool)
	AsProtectionContainerMappingProviderSpecificDetails() (*ProtectionContainerMappingProviderSpecificDetails, bool)
}

// ProtectionContainerMappingProviderSpecificDetails container mapping provider specific details.
type ProtectionContainerMappingProviderSpecificDetails struct {
	// InstanceType - Possible values include: 'InstanceTypeBasicProtectionContainerMappingProviderSpecificDetailsInstanceTypeProtectionContainerMappingProviderSpecificDetails', 'InstanceTypeBasicProtectionContainerMappingProviderSpecificDetailsInstanceTypeA2A', 'InstanceTypeBasicProtectionContainerMappingProviderSpecificDetailsInstanceTypeVMwareCbt'
	InstanceType InstanceTypeBasicProtectionContainerMappingProviderSpecificDetails `json:"instanceType,omitempty"`
}

func unmarshalBasicProtectionContainerMappingProviderSpecificDetails(body []byte) (BasicProtectionContainerMappingProviderSpecificDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeBasicProtectionContainerMappingProviderSpecificDetailsInstanceTypeA2A):
		var apcmd A2AProtectionContainerMappingDetails
		err := json.Unmarshal(body, &apcmd)
		return apcmd, err
	case string(InstanceTypeBasicProtectionContainerMappingProviderSpecificDetailsInstanceTypeVMwareCbt):
		var vmcpcmd VMwareCbtProtectionContainerMappingDetails
		err := json.Unmarshal(body, &vmcpcmd)
		return vmcpcmd, err
	default:
		var pcmpsd ProtectionContainerMappingProviderSpecificDetails
		err := json.Unmarshal(body, &pcmpsd)
		return pcmpsd, err
	}
}
func unmarshalBasicProtectionContainerMappingProviderSpecificDetailsArray(body []byte) ([]BasicProtectionContainerMappingProviderSpecificDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	pcmpsdArray := make([]BasicProtectionContainerMappingProviderSpecificDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		pcmpsd, err := unmarshalBasicProtectionContainerMappingProviderSpecificDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		pcmpsdArray[index] = pcmpsd
	}
	return pcmpsdArray, nil
}

// MarshalJSON is the custom marshaler for ProtectionContainerMappingProviderSpecificDetails.
func (pcmpsd ProtectionContainerMappingProviderSpecificDetails) MarshalJSON() ([]byte, error) {
	pcmpsd.InstanceType = InstanceTypeBasicProtectionContainerMappingProviderSpecificDetailsInstanceTypeProtectionContainerMappingProviderSpecificDetails
	objectMap := make(map[string]interface{})
	if pcmpsd.InstanceType != "" {
		objectMap["instanceType"] = pcmpsd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AProtectionContainerMappingDetails is the BasicProtectionContainerMappingProviderSpecificDetails implementation for ProtectionContainerMappingProviderSpecificDetails.
func (pcmpsd ProtectionContainerMappingProviderSpecificDetails) AsA2AProtectionContainerMappingDetails() (*A2AProtectionContainerMappingDetails, bool) {
	return nil, false
}

// AsVMwareCbtProtectionContainerMappingDetails is the BasicProtectionContainerMappingProviderSpecificDetails implementation for ProtectionContainerMappingProviderSpecificDetails.
func (pcmpsd ProtectionContainerMappingProviderSpecificDetails) AsVMwareCbtProtectionContainerMappingDetails() (*VMwareCbtProtectionContainerMappingDetails, bool) {
	return nil, false
}

// AsProtectionContainerMappingProviderSpecificDetails is the BasicProtectionContainerMappingProviderSpecificDetails implementation for ProtectionContainerMappingProviderSpecificDetails.
func (pcmpsd ProtectionContainerMappingProviderSpecificDetails) AsProtectionContainerMappingProviderSpecificDetails() (*ProtectionContainerMappingProviderSpecificDetails, bool) {
	return &pcmpsd, true
}

// AsBasicProtectionContainerMappingProviderSpecificDetails is the BasicProtectionContainerMappingProviderSpecificDetails implementation for ProtectionContainerMappingProviderSpecificDetails.
func (pcmpsd ProtectionContainerMappingProviderSpecificDetails) AsBasicProtectionContainerMappingProviderSpecificDetails() (BasicProtectionContainerMappingProviderSpecificDetails, bool) {
	return &pcmpsd, true
}

// ProtectionContainerProperties protection profile custom data details.
type ProtectionContainerProperties struct {
	// FabricFriendlyName - Fabric friendly name.
	FabricFriendlyName *string `json:"fabricFriendlyName,omitempty"`
	// FriendlyName - The name.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// FabricType - The fabric type.
	FabricType *string `json:"fabricType,omitempty"`
	// ProtectedItemCount - Number of protected PEs
	ProtectedItemCount *int32 `json:"protectedItemCount,omitempty"`
	// PairingStatus - The pairing status of this cloud.
	PairingStatus *string `json:"pairingStatus,omitempty"`
	// Role - The role of this cloud.
	Role *string `json:"role,omitempty"`
	// FabricSpecificDetails - Fabric specific details.
	FabricSpecificDetails *ProtectionContainerFabricSpecificDetails `json:"fabricSpecificDetails,omitempty"`
}

// BasicProtectionProfileCustomDetails protection Profile custom input.
type BasicProtectionProfileCustomDetails interface {
	AsExistingProtectionProfile() (*ExistingProtectionProfile, bool)
	AsNewProtectionProfile() (*NewProtectionProfile, bool)
	AsProtectionProfileCustomDetails() (*ProtectionProfileCustomDetails, bool)
}

// ProtectionProfileCustomDetails protection Profile custom input.
type ProtectionProfileCustomDetails struct {
	// ResourceType - Possible values include: 'ResourceTypeProtectionProfileCustomDetails', 'ResourceTypeExisting', 'ResourceTypeNew'
	ResourceType ResourceType `json:"resourceType,omitempty"`
}

func unmarshalBasicProtectionProfileCustomDetails(body []byte) (BasicProtectionProfileCustomDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["resourceType"] {
	case string(ResourceTypeExisting):
		var epp ExistingProtectionProfile
		err := json.Unmarshal(body, &epp)
		return epp, err
	case string(ResourceTypeNew):
		var npp NewProtectionProfile
		err := json.Unmarshal(body, &npp)
		return npp, err
	default:
		var ppcd ProtectionProfileCustomDetails
		err := json.Unmarshal(body, &ppcd)
		return ppcd, err
	}
}
func unmarshalBasicProtectionProfileCustomDetailsArray(body []byte) ([]BasicProtectionProfileCustomDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ppcdArray := make([]BasicProtectionProfileCustomDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ppcd, err := unmarshalBasicProtectionProfileCustomDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		ppcdArray[index] = ppcd
	}
	return ppcdArray, nil
}

// MarshalJSON is the custom marshaler for ProtectionProfileCustomDetails.
func (ppcd ProtectionProfileCustomDetails) MarshalJSON() ([]byte, error) {
	ppcd.ResourceType = ResourceTypeProtectionProfileCustomDetails
	objectMap := make(map[string]interface{})
	if ppcd.ResourceType != "" {
		objectMap["resourceType"] = ppcd.ResourceType
	}
	return json.Marshal(objectMap)
}

// AsExistingProtectionProfile is the BasicProtectionProfileCustomDetails implementation for ProtectionProfileCustomDetails.
func (ppcd ProtectionProfileCustomDetails) AsExistingProtectionProfile() (*ExistingProtectionProfile, bool) {
	return nil, false
}

// AsNewProtectionProfile is the BasicProtectionProfileCustomDetails implementation for ProtectionProfileCustomDetails.
func (ppcd ProtectionProfileCustomDetails) AsNewProtectionProfile() (*NewProtectionProfile, bool) {
	return nil, false
}

// AsProtectionProfileCustomDetails is the BasicProtectionProfileCustomDetails implementation for ProtectionProfileCustomDetails.
func (ppcd ProtectionProfileCustomDetails) AsProtectionProfileCustomDetails() (*ProtectionProfileCustomDetails, bool) {
	return &ppcd, true
}

// AsBasicProtectionProfileCustomDetails is the BasicProtectionProfileCustomDetails implementation for ProtectionProfileCustomDetails.
func (ppcd ProtectionProfileCustomDetails) AsBasicProtectionProfileCustomDetails() (BasicProtectionProfileCustomDetails, bool) {
	return &ppcd, true
}

// ProviderError this class contains the error details per object.
type ProviderError struct {
	// ErrorCode - The Error code.
	ErrorCode *int32 `json:"errorCode,omitempty"`
	// ErrorMessage - The Error message.
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// ErrorID - The Provider error Id.
	ErrorID *string `json:"errorId,omitempty"`
	// PossibleCauses - The possible causes for the error.
	PossibleCauses *string `json:"possibleCauses,omitempty"`
	// RecommendedAction - The recommended action to resolve the error.
	RecommendedAction *string `json:"recommendedAction,omitempty"`
}

// BasicProviderSpecificFailoverInput provider specific failover input.
type BasicProviderSpecificFailoverInput interface {
	AsA2AFailoverProviderInput() (*A2AFailoverProviderInput, bool)
	AsHyperVReplicaAzureFailbackProviderInput() (*HyperVReplicaAzureFailbackProviderInput, bool)
	AsHyperVReplicaAzureFailoverProviderInput() (*HyperVReplicaAzureFailoverProviderInput, bool)
	AsInMageAzureV2FailoverProviderInput() (*InMageAzureV2FailoverProviderInput, bool)
	AsInMageFailoverProviderInput() (*InMageFailoverProviderInput, bool)
	AsProviderSpecificFailoverInput() (*ProviderSpecificFailoverInput, bool)
}

// ProviderSpecificFailoverInput provider specific failover input.
type ProviderSpecificFailoverInput struct {
	// InstanceType - Possible values include: 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeProviderSpecificFailoverInput', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeA2A', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMage'
	InstanceType InstanceTypeBasicProviderSpecificFailoverInput `json:"instanceType,omitempty"`
}

func unmarshalBasicProviderSpecificFailoverInput(body []byte) (BasicProviderSpecificFailoverInput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeA2A):
		var afpi A2AFailoverProviderInput
		err := json.Unmarshal(body, &afpi)
		return afpi, err
	case string(InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback):
		var hvrafpi HyperVReplicaAzureFailbackProviderInput
		err := json.Unmarshal(body, &hvrafpi)
		return hvrafpi, err
	case string(InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure):
		var hvrafpi HyperVReplicaAzureFailoverProviderInput
		err := json.Unmarshal(body, &hvrafpi)
		return hvrafpi, err
	case string(InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMageAzureV2):
		var imavfpi InMageAzureV2FailoverProviderInput
		err := json.Unmarshal(body, &imavfpi)
		return imavfpi, err
	case string(InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMage):
		var imfpi InMageFailoverProviderInput
		err := json.Unmarshal(body, &imfpi)
		return imfpi, err
	default:
		var psfi ProviderSpecificFailoverInput
		err := json.Unmarshal(body, &psfi)
		return psfi, err
	}
}
func unmarshalBasicProviderSpecificFailoverInputArray(body []byte) ([]BasicProviderSpecificFailoverInput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	psfiArray := make([]BasicProviderSpecificFailoverInput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		psfi, err := unmarshalBasicProviderSpecificFailoverInput(*rawMessage)
		if err != nil {
			return nil, err
		}
		psfiArray[index] = psfi
	}
	return psfiArray, nil
}

// MarshalJSON is the custom marshaler for ProviderSpecificFailoverInput.
func (psfi ProviderSpecificFailoverInput) MarshalJSON() ([]byte, error) {
	psfi.InstanceType = InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeProviderSpecificFailoverInput
	objectMap := make(map[string]interface{})
	if psfi.InstanceType != "" {
		objectMap["instanceType"] = psfi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AFailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for ProviderSpecificFailoverInput.
func (psfi ProviderSpecificFailoverInput) AsA2AFailoverProviderInput() (*A2AFailoverProviderInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzureFailbackProviderInput is the BasicProviderSpecificFailoverInput implementation for ProviderSpecificFailoverInput.
func (psfi ProviderSpecificFailoverInput) AsHyperVReplicaAzureFailbackProviderInput() (*HyperVReplicaAzureFailbackProviderInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzureFailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for ProviderSpecificFailoverInput.
func (psfi ProviderSpecificFailoverInput) AsHyperVReplicaAzureFailoverProviderInput() (*HyperVReplicaAzureFailoverProviderInput, bool) {
	return nil, false
}

// AsInMageAzureV2FailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for ProviderSpecificFailoverInput.
func (psfi ProviderSpecificFailoverInput) AsInMageAzureV2FailoverProviderInput() (*InMageAzureV2FailoverProviderInput, bool) {
	return nil, false
}

// AsInMageFailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for ProviderSpecificFailoverInput.
func (psfi ProviderSpecificFailoverInput) AsInMageFailoverProviderInput() (*InMageFailoverProviderInput, bool) {
	return nil, false
}

// AsProviderSpecificFailoverInput is the BasicProviderSpecificFailoverInput implementation for ProviderSpecificFailoverInput.
func (psfi ProviderSpecificFailoverInput) AsProviderSpecificFailoverInput() (*ProviderSpecificFailoverInput, bool) {
	return &psfi, true
}

// AsBasicProviderSpecificFailoverInput is the BasicProviderSpecificFailoverInput implementation for ProviderSpecificFailoverInput.
func (psfi ProviderSpecificFailoverInput) AsBasicProviderSpecificFailoverInput() (BasicProviderSpecificFailoverInput, bool) {
	return &psfi, true
}

// BasicProviderSpecificRecoveryPointDetails replication provider specific recovery point details.
type BasicProviderSpecificRecoveryPointDetails interface {
	AsA2ARecoveryPointDetails() (*A2ARecoveryPointDetails, bool)
	AsInMageAzureV2RecoveryPointDetails() (*InMageAzureV2RecoveryPointDetails, bool)
	AsInMageRcmRecoveryPointDetails() (*InMageRcmRecoveryPointDetails, bool)
	AsProviderSpecificRecoveryPointDetails() (*ProviderSpecificRecoveryPointDetails, bool)
}

// ProviderSpecificRecoveryPointDetails replication provider specific recovery point details.
type ProviderSpecificRecoveryPointDetails struct {
	// InstanceType - Possible values include: 'InstanceTypeBasicProviderSpecificRecoveryPointDetailsInstanceTypeProviderSpecificRecoveryPointDetails', 'InstanceTypeBasicProviderSpecificRecoveryPointDetailsInstanceTypeA2A', 'InstanceTypeBasicProviderSpecificRecoveryPointDetailsInstanceTypeInMageAzureV2', 'InstanceTypeBasicProviderSpecificRecoveryPointDetailsInstanceTypeInMageRcm'
	InstanceType InstanceTypeBasicProviderSpecificRecoveryPointDetails `json:"instanceType,omitempty"`
}

func unmarshalBasicProviderSpecificRecoveryPointDetails(body []byte) (BasicProviderSpecificRecoveryPointDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeBasicProviderSpecificRecoveryPointDetailsInstanceTypeA2A):
		var arpd A2ARecoveryPointDetails
		err := json.Unmarshal(body, &arpd)
		return arpd, err
	case string(InstanceTypeBasicProviderSpecificRecoveryPointDetailsInstanceTypeInMageAzureV2):
		var imavrpd InMageAzureV2RecoveryPointDetails
		err := json.Unmarshal(body, &imavrpd)
		return imavrpd, err
	case string(InstanceTypeBasicProviderSpecificRecoveryPointDetailsInstanceTypeInMageRcm):
		var imrrpd InMageRcmRecoveryPointDetails
		err := json.Unmarshal(body, &imrrpd)
		return imrrpd, err
	default:
		var psrpd ProviderSpecificRecoveryPointDetails
		err := json.Unmarshal(body, &psrpd)
		return psrpd, err
	}
}
func unmarshalBasicProviderSpecificRecoveryPointDetailsArray(body []byte) ([]BasicProviderSpecificRecoveryPointDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	psrpdArray := make([]BasicProviderSpecificRecoveryPointDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		psrpd, err := unmarshalBasicProviderSpecificRecoveryPointDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		psrpdArray[index] = psrpd
	}
	return psrpdArray, nil
}

// MarshalJSON is the custom marshaler for ProviderSpecificRecoveryPointDetails.
func (psrpd ProviderSpecificRecoveryPointDetails) MarshalJSON() ([]byte, error) {
	psrpd.InstanceType = InstanceTypeBasicProviderSpecificRecoveryPointDetailsInstanceTypeProviderSpecificRecoveryPointDetails
	objectMap := make(map[string]interface{})
	if psrpd.InstanceType != "" {
		objectMap["instanceType"] = psrpd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2ARecoveryPointDetails is the BasicProviderSpecificRecoveryPointDetails implementation for ProviderSpecificRecoveryPointDetails.
func (psrpd ProviderSpecificRecoveryPointDetails) AsA2ARecoveryPointDetails() (*A2ARecoveryPointDetails, bool) {
	return nil, false
}

// AsInMageAzureV2RecoveryPointDetails is the BasicProviderSpecificRecoveryPointDetails implementation for ProviderSpecificRecoveryPointDetails.
func (psrpd ProviderSpecificRecoveryPointDetails) AsInMageAzureV2RecoveryPointDetails() (*InMageAzureV2RecoveryPointDetails, bool) {
	return nil, false
}

// AsInMageRcmRecoveryPointDetails is the BasicProviderSpecificRecoveryPointDetails implementation for ProviderSpecificRecoveryPointDetails.
func (psrpd ProviderSpecificRecoveryPointDetails) AsInMageRcmRecoveryPointDetails() (*InMageRcmRecoveryPointDetails, bool) {
	return nil, false
}

// AsProviderSpecificRecoveryPointDetails is the BasicProviderSpecificRecoveryPointDetails implementation for ProviderSpecificRecoveryPointDetails.
func (psrpd ProviderSpecificRecoveryPointDetails) AsProviderSpecificRecoveryPointDetails() (*ProviderSpecificRecoveryPointDetails, bool) {
	return &psrpd, true
}

// AsBasicProviderSpecificRecoveryPointDetails is the BasicProviderSpecificRecoveryPointDetails implementation for ProviderSpecificRecoveryPointDetails.
func (psrpd ProviderSpecificRecoveryPointDetails) AsBasicProviderSpecificRecoveryPointDetails() (BasicProviderSpecificRecoveryPointDetails, bool) {
	return &psrpd, true
}

// PushInstallerDetails push installer details.
type PushInstallerDetails struct {
	// ID - READ-ONLY; The push installer Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The push installer name.
	Name *string `json:"name,omitempty"`
	// Version - READ-ONLY; The push installer version.
	Version *string `json:"version,omitempty"`
	// LastHeartbeatUtc - READ-ONLY; The last heartbeat received from the push installer.
	LastHeartbeatUtc *date.Time `json:"lastHeartbeatUtc,omitempty"`
	// Health - READ-ONLY; The health of the push installer. Possible values include: 'ProtectionHealthNone', 'ProtectionHealthNormal', 'ProtectionHealthWarning', 'ProtectionHealthCritical'
	Health ProtectionHealth `json:"health,omitempty"`
	// HealthErrors - READ-ONLY; The health errors.
	HealthErrors *[]HealthError `json:"healthErrors,omitempty"`
}

// RcmAzureMigrationPolicyDetails RCM based Azure migration specific policy details.
type RcmAzureMigrationPolicyDetails struct {
	// RecoveryPointThresholdInMinutes - The recovery point threshold in minutes.
	RecoveryPointThresholdInMinutes *int32 `json:"recoveryPointThresholdInMinutes,omitempty"`
	// RecoveryPointHistory - The duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistory *int32 `json:"recoveryPointHistory,omitempty"`
	// AppConsistentFrequencyInMinutes - The app consistent snapshot frequency in minutes.
	AppConsistentFrequencyInMinutes *int32 `json:"appConsistentFrequencyInMinutes,omitempty"`
	// MultiVMSyncStatus - A value indicating whether multi-VM sync has to be enabled. Possible values include: 'MultiVMSyncStatusEnabled', 'MultiVMSyncStatusDisabled'
	MultiVMSyncStatus MultiVMSyncStatus `json:"multiVmSyncStatus,omitempty"`
	// CrashConsistentFrequencyInMinutes - The crash consistent snapshot frequency in minutes.
	CrashConsistentFrequencyInMinutes *int32 `json:"crashConsistentFrequencyInMinutes,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypePolicyProviderSpecificDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeA2A', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaBasePolicyDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageAzureV2', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageBasePolicyDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMage', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageRcm', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeRcmAzureMigration', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeVMwareCbt'
	InstanceType InstanceTypeBasicPolicyProviderSpecificDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for RcmAzureMigrationPolicyDetails.
func (rampd RcmAzureMigrationPolicyDetails) MarshalJSON() ([]byte, error) {
	rampd.InstanceType = InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeRcmAzureMigration
	objectMap := make(map[string]interface{})
	if rampd.RecoveryPointThresholdInMinutes != nil {
		objectMap["recoveryPointThresholdInMinutes"] = rampd.RecoveryPointThresholdInMinutes
	}
	if rampd.RecoveryPointHistory != nil {
		objectMap["recoveryPointHistory"] = rampd.RecoveryPointHistory
	}
	if rampd.AppConsistentFrequencyInMinutes != nil {
		objectMap["appConsistentFrequencyInMinutes"] = rampd.AppConsistentFrequencyInMinutes
	}
	if rampd.MultiVMSyncStatus != "" {
		objectMap["multiVmSyncStatus"] = rampd.MultiVMSyncStatus
	}
	if rampd.CrashConsistentFrequencyInMinutes != nil {
		objectMap["crashConsistentFrequencyInMinutes"] = rampd.CrashConsistentFrequencyInMinutes
	}
	if rampd.InstanceType != "" {
		objectMap["instanceType"] = rampd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2APolicyDetails is the BasicPolicyProviderSpecificDetails implementation for RcmAzureMigrationPolicyDetails.
func (rampd RcmAzureMigrationPolicyDetails) AsA2APolicyDetails() (*A2APolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzurePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for RcmAzureMigrationPolicyDetails.
func (rampd RcmAzureMigrationPolicyDetails) AsHyperVReplicaAzurePolicyDetails() (*HyperVReplicaAzurePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBasePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for RcmAzureMigrationPolicyDetails.
func (rampd RcmAzureMigrationPolicyDetails) AsHyperVReplicaBasePolicyDetails() (*HyperVReplicaBasePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for RcmAzureMigrationPolicyDetails.
func (rampd RcmAzureMigrationPolicyDetails) AsHyperVReplicaBluePolicyDetails() (*HyperVReplicaBluePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for RcmAzureMigrationPolicyDetails.
func (rampd RcmAzureMigrationPolicyDetails) AsHyperVReplicaPolicyDetails() (*HyperVReplicaPolicyDetails, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyDetails is the BasicPolicyProviderSpecificDetails implementation for RcmAzureMigrationPolicyDetails.
func (rampd RcmAzureMigrationPolicyDetails) AsInMageAzureV2PolicyDetails() (*InMageAzureV2PolicyDetails, bool) {
	return nil, false
}

// AsInMageBasePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for RcmAzureMigrationPolicyDetails.
func (rampd RcmAzureMigrationPolicyDetails) AsInMageBasePolicyDetails() (*InMageBasePolicyDetails, bool) {
	return nil, false
}

// AsInMagePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for RcmAzureMigrationPolicyDetails.
func (rampd RcmAzureMigrationPolicyDetails) AsInMagePolicyDetails() (*InMagePolicyDetails, bool) {
	return nil, false
}

// AsInMageRcmPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for RcmAzureMigrationPolicyDetails.
func (rampd RcmAzureMigrationPolicyDetails) AsInMageRcmPolicyDetails() (*InMageRcmPolicyDetails, bool) {
	return nil, false
}

// AsRcmAzureMigrationPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for RcmAzureMigrationPolicyDetails.
func (rampd RcmAzureMigrationPolicyDetails) AsRcmAzureMigrationPolicyDetails() (*RcmAzureMigrationPolicyDetails, bool) {
	return &rampd, true
}

// AsVmwareCbtPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for RcmAzureMigrationPolicyDetails.
func (rampd RcmAzureMigrationPolicyDetails) AsVmwareCbtPolicyDetails() (*VmwareCbtPolicyDetails, bool) {
	return nil, false
}

// AsPolicyProviderSpecificDetails is the BasicPolicyProviderSpecificDetails implementation for RcmAzureMigrationPolicyDetails.
func (rampd RcmAzureMigrationPolicyDetails) AsPolicyProviderSpecificDetails() (*PolicyProviderSpecificDetails, bool) {
	return nil, false
}

// AsBasicPolicyProviderSpecificDetails is the BasicPolicyProviderSpecificDetails implementation for RcmAzureMigrationPolicyDetails.
func (rampd RcmAzureMigrationPolicyDetails) AsBasicPolicyProviderSpecificDetails() (BasicPolicyProviderSpecificDetails, bool) {
	return &rampd, true
}

// RcmProxyDetails RCM proxy details.
type RcmProxyDetails struct {
	// ID - READ-ONLY; The RCM proxy Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The RCM proxy name.
	Name *string `json:"name,omitempty"`
	// Version - READ-ONLY; The RCM proxy version.
	Version *string `json:"version,omitempty"`
	// LastHeartbeatUtc - READ-ONLY; The last heartbeat received from the RCM proxy.
	LastHeartbeatUtc *date.Time `json:"lastHeartbeatUtc,omitempty"`
	// Health - READ-ONLY; The health of the RCM proxy. Possible values include: 'ProtectionHealthNone', 'ProtectionHealthNormal', 'ProtectionHealthWarning', 'ProtectionHealthCritical'
	Health ProtectionHealth `json:"health,omitempty"`
	// HealthErrors - READ-ONLY; The health errors.
	HealthErrors *[]HealthError `json:"healthErrors,omitempty"`
}

// BasicRecoveryAvailabilitySetCustomDetails recovery Availability Set custom input.
type BasicRecoveryAvailabilitySetCustomDetails interface {
	AsExistingRecoveryAvailabilitySet() (*ExistingRecoveryAvailabilitySet, bool)
	AsRecoveryAvailabilitySetCustomDetails() (*RecoveryAvailabilitySetCustomDetails, bool)
}

// RecoveryAvailabilitySetCustomDetails recovery Availability Set custom input.
type RecoveryAvailabilitySetCustomDetails struct {
	// ResourceType - Possible values include: 'ResourceTypeBasicRecoveryAvailabilitySetCustomDetailsResourceTypeRecoveryAvailabilitySetCustomDetails', 'ResourceTypeBasicRecoveryAvailabilitySetCustomDetailsResourceTypeExisting'
	ResourceType ResourceTypeBasicRecoveryAvailabilitySetCustomDetails `json:"resourceType,omitempty"`
}

func unmarshalBasicRecoveryAvailabilitySetCustomDetails(body []byte) (BasicRecoveryAvailabilitySetCustomDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["resourceType"] {
	case string(ResourceTypeBasicRecoveryAvailabilitySetCustomDetailsResourceTypeExisting):
		var eras ExistingRecoveryAvailabilitySet
		err := json.Unmarshal(body, &eras)
		return eras, err
	default:
		var rascd RecoveryAvailabilitySetCustomDetails
		err := json.Unmarshal(body, &rascd)
		return rascd, err
	}
}
func unmarshalBasicRecoveryAvailabilitySetCustomDetailsArray(body []byte) ([]BasicRecoveryAvailabilitySetCustomDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rascdArray := make([]BasicRecoveryAvailabilitySetCustomDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rascd, err := unmarshalBasicRecoveryAvailabilitySetCustomDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		rascdArray[index] = rascd
	}
	return rascdArray, nil
}

// MarshalJSON is the custom marshaler for RecoveryAvailabilitySetCustomDetails.
func (rascd RecoveryAvailabilitySetCustomDetails) MarshalJSON() ([]byte, error) {
	rascd.ResourceType = ResourceTypeBasicRecoveryAvailabilitySetCustomDetailsResourceTypeRecoveryAvailabilitySetCustomDetails
	objectMap := make(map[string]interface{})
	if rascd.ResourceType != "" {
		objectMap["resourceType"] = rascd.ResourceType
	}
	return json.Marshal(objectMap)
}

// AsExistingRecoveryAvailabilitySet is the BasicRecoveryAvailabilitySetCustomDetails implementation for RecoveryAvailabilitySetCustomDetails.
func (rascd RecoveryAvailabilitySetCustomDetails) AsExistingRecoveryAvailabilitySet() (*ExistingRecoveryAvailabilitySet, bool) {
	return nil, false
}

// AsRecoveryAvailabilitySetCustomDetails is the BasicRecoveryAvailabilitySetCustomDetails implementation for RecoveryAvailabilitySetCustomDetails.
func (rascd RecoveryAvailabilitySetCustomDetails) AsRecoveryAvailabilitySetCustomDetails() (*RecoveryAvailabilitySetCustomDetails, bool) {
	return &rascd, true
}

// AsBasicRecoveryAvailabilitySetCustomDetails is the BasicRecoveryAvailabilitySetCustomDetails implementation for RecoveryAvailabilitySetCustomDetails.
func (rascd RecoveryAvailabilitySetCustomDetails) AsBasicRecoveryAvailabilitySetCustomDetails() (BasicRecoveryAvailabilitySetCustomDetails, bool) {
	return &rascd, true
}

// RecoveryPlan recovery plan details.
type RecoveryPlan struct {
	autorest.Response `json:"-"`
	// Properties - The custom details.
	Properties *RecoveryPlanProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource Type
	Type *string `json:"type,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoveryPlan.
func (rp RecoveryPlan) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rp.Properties != nil {
		objectMap["properties"] = rp.Properties
	}
	if rp.Location != nil {
		objectMap["location"] = rp.Location
	}
	return json.Marshal(objectMap)
}

// RecoveryPlanA2ADetails recovery plan A2A specific details.
type RecoveryPlanA2ADetails struct {
	// PrimaryZone - The primary zone.
	PrimaryZone *string `json:"primaryZone,omitempty"`
	// RecoveryZone - The recovery zone.
	RecoveryZone *string `json:"recoveryZone,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicRecoveryPlanProviderSpecificDetailsInstanceTypeRecoveryPlanProviderSpecificDetails', 'InstanceTypeBasicRecoveryPlanProviderSpecificDetailsInstanceTypeA2A'
	InstanceType InstanceTypeBasicRecoveryPlanProviderSpecificDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoveryPlanA2ADetails.
func (rpad RecoveryPlanA2ADetails) MarshalJSON() ([]byte, error) {
	rpad.InstanceType = InstanceTypeBasicRecoveryPlanProviderSpecificDetailsInstanceTypeA2A
	objectMap := make(map[string]interface{})
	if rpad.PrimaryZone != nil {
		objectMap["primaryZone"] = rpad.PrimaryZone
	}
	if rpad.RecoveryZone != nil {
		objectMap["recoveryZone"] = rpad.RecoveryZone
	}
	if rpad.InstanceType != "" {
		objectMap["instanceType"] = rpad.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsRecoveryPlanA2ADetails is the BasicRecoveryPlanProviderSpecificDetails implementation for RecoveryPlanA2ADetails.
func (rpad RecoveryPlanA2ADetails) AsRecoveryPlanA2ADetails() (*RecoveryPlanA2ADetails, bool) {
	return &rpad, true
}

// AsRecoveryPlanProviderSpecificDetails is the BasicRecoveryPlanProviderSpecificDetails implementation for RecoveryPlanA2ADetails.
func (rpad RecoveryPlanA2ADetails) AsRecoveryPlanProviderSpecificDetails() (*RecoveryPlanProviderSpecificDetails, bool) {
	return nil, false
}

// AsBasicRecoveryPlanProviderSpecificDetails is the BasicRecoveryPlanProviderSpecificDetails implementation for RecoveryPlanA2ADetails.
func (rpad RecoveryPlanA2ADetails) AsBasicRecoveryPlanProviderSpecificDetails() (BasicRecoveryPlanProviderSpecificDetails, bool) {
	return &rpad, true
}

// RecoveryPlanA2AFailoverInput recovery plan A2A failover input.
type RecoveryPlanA2AFailoverInput struct {
	// RecoveryPointType - The recovery point type. Possible values include: 'Latest', 'LatestApplicationConsistent', 'LatestCrashConsistent', 'LatestProcessed'
	RecoveryPointType A2ARpRecoveryPointType `json:"recoveryPointType,omitempty"`
	// CloudServiceCreationOption - A value indicating whether to use recovery cloud service for TFO or not.
	CloudServiceCreationOption *string `json:"cloudServiceCreationOption,omitempty"`
	// MultiVMSyncPointOption - A value indicating whether multi VM sync enabled VMs should use multi VM sync points for failover. Possible values include: 'UseMultiVMSyncRecoveryPoint', 'UsePerVMRecoveryPoint'
	MultiVMSyncPointOption MultiVMSyncPointOption `json:"multiVmSyncPointOption,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeRecoveryPlanProviderSpecificFailoverInput', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeA2A', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMage', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMageRcm'
	InstanceType InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoveryPlanA2AFailoverInput.
func (rpafi RecoveryPlanA2AFailoverInput) MarshalJSON() ([]byte, error) {
	rpafi.InstanceType = InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeA2A
	objectMap := make(map[string]interface{})
	if rpafi.RecoveryPointType != "" {
		objectMap["recoveryPointType"] = rpafi.RecoveryPointType
	}
	if rpafi.CloudServiceCreationOption != nil {
		objectMap["cloudServiceCreationOption"] = rpafi.CloudServiceCreationOption
	}
	if rpafi.MultiVMSyncPointOption != "" {
		objectMap["multiVmSyncPointOption"] = rpafi.MultiVMSyncPointOption
	}
	if rpafi.InstanceType != "" {
		objectMap["instanceType"] = rpafi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsRecoveryPlanA2AFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanA2AFailoverInput.
func (rpafi RecoveryPlanA2AFailoverInput) AsRecoveryPlanA2AFailoverInput() (*RecoveryPlanA2AFailoverInput, bool) {
	return &rpafi, true
}

// AsRecoveryPlanHyperVReplicaAzureFailbackInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanA2AFailoverInput.
func (rpafi RecoveryPlanA2AFailoverInput) AsRecoveryPlanHyperVReplicaAzureFailbackInput() (*RecoveryPlanHyperVReplicaAzureFailbackInput, bool) {
	return nil, false
}

// AsRecoveryPlanHyperVReplicaAzureFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanA2AFailoverInput.
func (rpafi RecoveryPlanA2AFailoverInput) AsRecoveryPlanHyperVReplicaAzureFailoverInput() (*RecoveryPlanHyperVReplicaAzureFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanInMageAzureV2FailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanA2AFailoverInput.
func (rpafi RecoveryPlanA2AFailoverInput) AsRecoveryPlanInMageAzureV2FailoverInput() (*RecoveryPlanInMageAzureV2FailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanInMageFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanA2AFailoverInput.
func (rpafi RecoveryPlanA2AFailoverInput) AsRecoveryPlanInMageFailoverInput() (*RecoveryPlanInMageFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanInMageRcmFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanA2AFailoverInput.
func (rpafi RecoveryPlanA2AFailoverInput) AsRecoveryPlanInMageRcmFailoverInput() (*RecoveryPlanInMageRcmFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanProviderSpecificFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanA2AFailoverInput.
func (rpafi RecoveryPlanA2AFailoverInput) AsRecoveryPlanProviderSpecificFailoverInput() (*RecoveryPlanProviderSpecificFailoverInput, bool) {
	return nil, false
}

// AsBasicRecoveryPlanProviderSpecificFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanA2AFailoverInput.
func (rpafi RecoveryPlanA2AFailoverInput) AsBasicRecoveryPlanProviderSpecificFailoverInput() (BasicRecoveryPlanProviderSpecificFailoverInput, bool) {
	return &rpafi, true
}

// RecoveryPlanA2AInput recovery plan A2A input.
type RecoveryPlanA2AInput struct {
	// PrimaryZone - The primary zone.
	PrimaryZone *string `json:"primaryZone,omitempty"`
	// RecoveryZone - The recovery zone.
	RecoveryZone *string `json:"recoveryZone,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicRecoveryPlanProviderSpecificInputInstanceTypeRecoveryPlanProviderSpecificInput', 'InstanceTypeBasicRecoveryPlanProviderSpecificInputInstanceTypeA2A'
	InstanceType InstanceTypeBasicRecoveryPlanProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoveryPlanA2AInput.
func (rpai RecoveryPlanA2AInput) MarshalJSON() ([]byte, error) {
	rpai.InstanceType = InstanceTypeBasicRecoveryPlanProviderSpecificInputInstanceTypeA2A
	objectMap := make(map[string]interface{})
	if rpai.PrimaryZone != nil {
		objectMap["primaryZone"] = rpai.PrimaryZone
	}
	if rpai.RecoveryZone != nil {
		objectMap["recoveryZone"] = rpai.RecoveryZone
	}
	if rpai.InstanceType != "" {
		objectMap["instanceType"] = rpai.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsRecoveryPlanA2AInput is the BasicRecoveryPlanProviderSpecificInput implementation for RecoveryPlanA2AInput.
func (rpai RecoveryPlanA2AInput) AsRecoveryPlanA2AInput() (*RecoveryPlanA2AInput, bool) {
	return &rpai, true
}

// AsRecoveryPlanProviderSpecificInput is the BasicRecoveryPlanProviderSpecificInput implementation for RecoveryPlanA2AInput.
func (rpai RecoveryPlanA2AInput) AsRecoveryPlanProviderSpecificInput() (*RecoveryPlanProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicRecoveryPlanProviderSpecificInput is the BasicRecoveryPlanProviderSpecificInput implementation for RecoveryPlanA2AInput.
func (rpai RecoveryPlanA2AInput) AsBasicRecoveryPlanProviderSpecificInput() (BasicRecoveryPlanProviderSpecificInput, bool) {
	return &rpai, true
}

// RecoveryPlanAction recovery plan action details.
type RecoveryPlanAction struct {
	// ActionName - The action name.
	ActionName *string `json:"actionName,omitempty"`
	// FailoverTypes - The list of failover types.
	FailoverTypes *[]ReplicationProtectedItemOperation `json:"failoverTypes,omitempty"`
	// FailoverDirections - The list of failover directions.
	FailoverDirections *[]PossibleOperationsDirections `json:"failoverDirections,omitempty"`
	// CustomDetails - The custom details.
	CustomDetails BasicRecoveryPlanActionDetails `json:"customDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for RecoveryPlanAction struct.
func (rpa *RecoveryPlanAction) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "actionName":
			if v != nil {
				var actionName string
				err = json.Unmarshal(*v, &actionName)
				if err != nil {
					return err
				}
				rpa.ActionName = &actionName
			}
		case "failoverTypes":
			if v != nil {
				var failoverTypes []ReplicationProtectedItemOperation
				err = json.Unmarshal(*v, &failoverTypes)
				if err != nil {
					return err
				}
				rpa.FailoverTypes = &failoverTypes
			}
		case "failoverDirections":
			if v != nil {
				var failoverDirections []PossibleOperationsDirections
				err = json.Unmarshal(*v, &failoverDirections)
				if err != nil {
					return err
				}
				rpa.FailoverDirections = &failoverDirections
			}
		case "customDetails":
			if v != nil {
				customDetails, err := unmarshalBasicRecoveryPlanActionDetails(*v)
				if err != nil {
					return err
				}
				rpa.CustomDetails = customDetails
			}
		}
	}

	return nil
}

// BasicRecoveryPlanActionDetails recovery plan action custom details.
type BasicRecoveryPlanActionDetails interface {
	AsRecoveryPlanAutomationRunbookActionDetails() (*RecoveryPlanAutomationRunbookActionDetails, bool)
	AsRecoveryPlanManualActionDetails() (*RecoveryPlanManualActionDetails, bool)
	AsRecoveryPlanScriptActionDetails() (*RecoveryPlanScriptActionDetails, bool)
	AsRecoveryPlanActionDetails() (*RecoveryPlanActionDetails, bool)
}

// RecoveryPlanActionDetails recovery plan action custom details.
type RecoveryPlanActionDetails struct {
	// InstanceType - Possible values include: 'InstanceTypeRecoveryPlanActionDetails', 'InstanceTypeAutomationRunbookActionDetails', 'InstanceTypeManualActionDetails', 'InstanceTypeScriptActionDetails'
	InstanceType InstanceTypeBasicRecoveryPlanActionDetails `json:"instanceType,omitempty"`
}

func unmarshalBasicRecoveryPlanActionDetails(body []byte) (BasicRecoveryPlanActionDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeAutomationRunbookActionDetails):
		var rparad RecoveryPlanAutomationRunbookActionDetails
		err := json.Unmarshal(body, &rparad)
		return rparad, err
	case string(InstanceTypeManualActionDetails):
		var rpmad RecoveryPlanManualActionDetails
		err := json.Unmarshal(body, &rpmad)
		return rpmad, err
	case string(InstanceTypeScriptActionDetails):
		var rpsad RecoveryPlanScriptActionDetails
		err := json.Unmarshal(body, &rpsad)
		return rpsad, err
	default:
		var rpad RecoveryPlanActionDetails
		err := json.Unmarshal(body, &rpad)
		return rpad, err
	}
}
func unmarshalBasicRecoveryPlanActionDetailsArray(body []byte) ([]BasicRecoveryPlanActionDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rpadArray := make([]BasicRecoveryPlanActionDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rpad, err := unmarshalBasicRecoveryPlanActionDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		rpadArray[index] = rpad
	}
	return rpadArray, nil
}

// MarshalJSON is the custom marshaler for RecoveryPlanActionDetails.
func (rpad RecoveryPlanActionDetails) MarshalJSON() ([]byte, error) {
	rpad.InstanceType = InstanceTypeRecoveryPlanActionDetails
	objectMap := make(map[string]interface{})
	if rpad.InstanceType != "" {
		objectMap["instanceType"] = rpad.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsRecoveryPlanAutomationRunbookActionDetails is the BasicRecoveryPlanActionDetails implementation for RecoveryPlanActionDetails.
func (rpad RecoveryPlanActionDetails) AsRecoveryPlanAutomationRunbookActionDetails() (*RecoveryPlanAutomationRunbookActionDetails, bool) {
	return nil, false
}

// AsRecoveryPlanManualActionDetails is the BasicRecoveryPlanActionDetails implementation for RecoveryPlanActionDetails.
func (rpad RecoveryPlanActionDetails) AsRecoveryPlanManualActionDetails() (*RecoveryPlanManualActionDetails, bool) {
	return nil, false
}

// AsRecoveryPlanScriptActionDetails is the BasicRecoveryPlanActionDetails implementation for RecoveryPlanActionDetails.
func (rpad RecoveryPlanActionDetails) AsRecoveryPlanScriptActionDetails() (*RecoveryPlanScriptActionDetails, bool) {
	return nil, false
}

// AsRecoveryPlanActionDetails is the BasicRecoveryPlanActionDetails implementation for RecoveryPlanActionDetails.
func (rpad RecoveryPlanActionDetails) AsRecoveryPlanActionDetails() (*RecoveryPlanActionDetails, bool) {
	return &rpad, true
}

// AsBasicRecoveryPlanActionDetails is the BasicRecoveryPlanActionDetails implementation for RecoveryPlanActionDetails.
func (rpad RecoveryPlanActionDetails) AsBasicRecoveryPlanActionDetails() (BasicRecoveryPlanActionDetails, bool) {
	return &rpad, true
}

// RecoveryPlanAutomationRunbookActionDetails recovery plan Automation runbook action details.
type RecoveryPlanAutomationRunbookActionDetails struct {
	// RunbookID - The runbook ARM Id.
	RunbookID *string `json:"runbookId,omitempty"`
	// Timeout - The runbook timeout.
	Timeout *string `json:"timeout,omitempty"`
	// FabricLocation - The fabric location. Possible values include: 'Primary', 'Recovery'
	FabricLocation RecoveryPlanActionLocation `json:"fabricLocation,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeRecoveryPlanActionDetails', 'InstanceTypeAutomationRunbookActionDetails', 'InstanceTypeManualActionDetails', 'InstanceTypeScriptActionDetails'
	InstanceType InstanceTypeBasicRecoveryPlanActionDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoveryPlanAutomationRunbookActionDetails.
func (rparad RecoveryPlanAutomationRunbookActionDetails) MarshalJSON() ([]byte, error) {
	rparad.InstanceType = InstanceTypeAutomationRunbookActionDetails
	objectMap := make(map[string]interface{})
	if rparad.RunbookID != nil {
		objectMap["runbookId"] = rparad.RunbookID
	}
	if rparad.Timeout != nil {
		objectMap["timeout"] = rparad.Timeout
	}
	if rparad.FabricLocation != "" {
		objectMap["fabricLocation"] = rparad.FabricLocation
	}
	if rparad.InstanceType != "" {
		objectMap["instanceType"] = rparad.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsRecoveryPlanAutomationRunbookActionDetails is the BasicRecoveryPlanActionDetails implementation for RecoveryPlanAutomationRunbookActionDetails.
func (rparad RecoveryPlanAutomationRunbookActionDetails) AsRecoveryPlanAutomationRunbookActionDetails() (*RecoveryPlanAutomationRunbookActionDetails, bool) {
	return &rparad, true
}

// AsRecoveryPlanManualActionDetails is the BasicRecoveryPlanActionDetails implementation for RecoveryPlanAutomationRunbookActionDetails.
func (rparad RecoveryPlanAutomationRunbookActionDetails) AsRecoveryPlanManualActionDetails() (*RecoveryPlanManualActionDetails, bool) {
	return nil, false
}

// AsRecoveryPlanScriptActionDetails is the BasicRecoveryPlanActionDetails implementation for RecoveryPlanAutomationRunbookActionDetails.
func (rparad RecoveryPlanAutomationRunbookActionDetails) AsRecoveryPlanScriptActionDetails() (*RecoveryPlanScriptActionDetails, bool) {
	return nil, false
}

// AsRecoveryPlanActionDetails is the BasicRecoveryPlanActionDetails implementation for RecoveryPlanAutomationRunbookActionDetails.
func (rparad RecoveryPlanAutomationRunbookActionDetails) AsRecoveryPlanActionDetails() (*RecoveryPlanActionDetails, bool) {
	return nil, false
}

// AsBasicRecoveryPlanActionDetails is the BasicRecoveryPlanActionDetails implementation for RecoveryPlanAutomationRunbookActionDetails.
func (rparad RecoveryPlanAutomationRunbookActionDetails) AsBasicRecoveryPlanActionDetails() (BasicRecoveryPlanActionDetails, bool) {
	return &rparad, true
}

// RecoveryPlanCollection recovery plan collection details.
type RecoveryPlanCollection struct {
	autorest.Response `json:"-"`
	// Value - The list of recovery plans.
	Value *[]RecoveryPlan `json:"value,omitempty"`
	// NextLink - The value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// RecoveryPlanCollectionIterator provides access to a complete listing of RecoveryPlan values.
type RecoveryPlanCollectionIterator struct {
	i    int
	page RecoveryPlanCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RecoveryPlanCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RecoveryPlanCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RecoveryPlanCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RecoveryPlanCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RecoveryPlanCollectionIterator) Response() RecoveryPlanCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RecoveryPlanCollectionIterator) Value() RecoveryPlan {
	if !iter.page.NotDone() {
		return RecoveryPlan{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RecoveryPlanCollectionIterator type.
func NewRecoveryPlanCollectionIterator(page RecoveryPlanCollectionPage) RecoveryPlanCollectionIterator {
	return RecoveryPlanCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (RPCVar RecoveryPlanCollection) IsEmpty() bool {
	return RPCVar.Value == nil || len(*RPCVar.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (RPCVar RecoveryPlanCollection) hasNextLink() bool {
	return RPCVar.NextLink != nil && len(*RPCVar.NextLink) != 0
}

// recoveryPlanCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (RPCVar RecoveryPlanCollection) recoveryPlanCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !RPCVar.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(RPCVar.NextLink)))
}

// RecoveryPlanCollectionPage contains a page of RecoveryPlan values.
type RecoveryPlanCollectionPage struct {
	fn     func(context.Context, RecoveryPlanCollection) (RecoveryPlanCollection, error)
	RPCVar RecoveryPlanCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RecoveryPlanCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RecoveryPlanCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.RPCVar)
		if err != nil {
			return err
		}
		page.RPCVar = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RecoveryPlanCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RecoveryPlanCollectionPage) NotDone() bool {
	return !page.RPCVar.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RecoveryPlanCollectionPage) Response() RecoveryPlanCollection {
	return page.RPCVar
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RecoveryPlanCollectionPage) Values() []RecoveryPlan {
	if page.RPCVar.IsEmpty() {
		return nil
	}
	return *page.RPCVar.Value
}

// Creates a new instance of the RecoveryPlanCollectionPage type.
func NewRecoveryPlanCollectionPage(cur RecoveryPlanCollection, getNextPage func(context.Context, RecoveryPlanCollection) (RecoveryPlanCollection, error)) RecoveryPlanCollectionPage {
	return RecoveryPlanCollectionPage{
		fn:     getNextPage,
		RPCVar: cur,
	}
}

// RecoveryPlanGroup recovery plan group details.
type RecoveryPlanGroup struct {
	// GroupType - The group type. Possible values include: 'Shutdown', 'Boot', 'Failover'
	GroupType RecoveryPlanGroupType `json:"groupType,omitempty"`
	// ReplicationProtectedItems - The list of protected items.
	ReplicationProtectedItems *[]RecoveryPlanProtectedItem `json:"replicationProtectedItems,omitempty"`
	// StartGroupActions - The start group actions.
	StartGroupActions *[]RecoveryPlanAction `json:"startGroupActions,omitempty"`
	// EndGroupActions - The end group actions.
	EndGroupActions *[]RecoveryPlanAction `json:"endGroupActions,omitempty"`
}

// RecoveryPlanGroupTaskDetails this class represents the recovery plan group task.
type RecoveryPlanGroupTaskDetails struct {
	// Name - The name.
	Name *string `json:"name,omitempty"`
	// GroupID - The group identifier.
	GroupID *string `json:"groupId,omitempty"`
	// RpGroupType - The group type.
	RpGroupType *string `json:"rpGroupType,omitempty"`
	// ChildTasks - The child tasks.
	ChildTasks *[]ASRTask `json:"childTasks,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeGroupTaskDetails', 'InstanceTypeInlineWorkflowTaskDetails', 'InstanceTypeRecoveryPlanGroupTaskDetails', 'InstanceTypeRecoveryPlanShutdownGroupTaskDetails'
	InstanceType InstanceTypeBasicGroupTaskDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoveryPlanGroupTaskDetails.
func (rpgtd RecoveryPlanGroupTaskDetails) MarshalJSON() ([]byte, error) {
	rpgtd.InstanceType = InstanceTypeRecoveryPlanGroupTaskDetails
	objectMap := make(map[string]interface{})
	if rpgtd.Name != nil {
		objectMap["name"] = rpgtd.Name
	}
	if rpgtd.GroupID != nil {
		objectMap["groupId"] = rpgtd.GroupID
	}
	if rpgtd.RpGroupType != nil {
		objectMap["rpGroupType"] = rpgtd.RpGroupType
	}
	if rpgtd.ChildTasks != nil {
		objectMap["childTasks"] = rpgtd.ChildTasks
	}
	if rpgtd.InstanceType != "" {
		objectMap["instanceType"] = rpgtd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsInlineWorkflowTaskDetails is the BasicGroupTaskDetails implementation for RecoveryPlanGroupTaskDetails.
func (rpgtd RecoveryPlanGroupTaskDetails) AsInlineWorkflowTaskDetails() (*InlineWorkflowTaskDetails, bool) {
	return nil, false
}

// AsRecoveryPlanGroupTaskDetails is the BasicGroupTaskDetails implementation for RecoveryPlanGroupTaskDetails.
func (rpgtd RecoveryPlanGroupTaskDetails) AsRecoveryPlanGroupTaskDetails() (*RecoveryPlanGroupTaskDetails, bool) {
	return &rpgtd, true
}

// AsRecoveryPlanShutdownGroupTaskDetails is the BasicGroupTaskDetails implementation for RecoveryPlanGroupTaskDetails.
func (rpgtd RecoveryPlanGroupTaskDetails) AsRecoveryPlanShutdownGroupTaskDetails() (*RecoveryPlanShutdownGroupTaskDetails, bool) {
	return nil, false
}

// AsGroupTaskDetails is the BasicGroupTaskDetails implementation for RecoveryPlanGroupTaskDetails.
func (rpgtd RecoveryPlanGroupTaskDetails) AsGroupTaskDetails() (*GroupTaskDetails, bool) {
	return nil, false
}

// AsBasicGroupTaskDetails is the BasicGroupTaskDetails implementation for RecoveryPlanGroupTaskDetails.
func (rpgtd RecoveryPlanGroupTaskDetails) AsBasicGroupTaskDetails() (BasicGroupTaskDetails, bool) {
	return &rpgtd, true
}

// RecoveryPlanHyperVReplicaAzureFailbackInput recovery plan HVR Azure failback input.
type RecoveryPlanHyperVReplicaAzureFailbackInput struct {
	// DataSyncOption - The data sync option. Possible values include: 'ForDownTime', 'ForSynchronization'
	DataSyncOption DataSyncStatus `json:"dataSyncOption,omitempty"`
	// RecoveryVMCreationOption - The ALR option. Possible values include: 'CreateVMIfNotFound', 'NoAction'
	RecoveryVMCreationOption AlternateLocationRecoveryOption `json:"recoveryVmCreationOption,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeRecoveryPlanProviderSpecificFailoverInput', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeA2A', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMage', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMageRcm'
	InstanceType InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoveryPlanHyperVReplicaAzureFailbackInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailbackInput) MarshalJSON() ([]byte, error) {
	rphvrafi.InstanceType = InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback
	objectMap := make(map[string]interface{})
	if rphvrafi.DataSyncOption != "" {
		objectMap["dataSyncOption"] = rphvrafi.DataSyncOption
	}
	if rphvrafi.RecoveryVMCreationOption != "" {
		objectMap["recoveryVmCreationOption"] = rphvrafi.RecoveryVMCreationOption
	}
	if rphvrafi.InstanceType != "" {
		objectMap["instanceType"] = rphvrafi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsRecoveryPlanA2AFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanHyperVReplicaAzureFailbackInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailbackInput) AsRecoveryPlanA2AFailoverInput() (*RecoveryPlanA2AFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanHyperVReplicaAzureFailbackInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanHyperVReplicaAzureFailbackInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailbackInput) AsRecoveryPlanHyperVReplicaAzureFailbackInput() (*RecoveryPlanHyperVReplicaAzureFailbackInput, bool) {
	return &rphvrafi, true
}

// AsRecoveryPlanHyperVReplicaAzureFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanHyperVReplicaAzureFailbackInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailbackInput) AsRecoveryPlanHyperVReplicaAzureFailoverInput() (*RecoveryPlanHyperVReplicaAzureFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanInMageAzureV2FailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanHyperVReplicaAzureFailbackInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailbackInput) AsRecoveryPlanInMageAzureV2FailoverInput() (*RecoveryPlanInMageAzureV2FailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanInMageFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanHyperVReplicaAzureFailbackInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailbackInput) AsRecoveryPlanInMageFailoverInput() (*RecoveryPlanInMageFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanInMageRcmFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanHyperVReplicaAzureFailbackInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailbackInput) AsRecoveryPlanInMageRcmFailoverInput() (*RecoveryPlanInMageRcmFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanProviderSpecificFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanHyperVReplicaAzureFailbackInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailbackInput) AsRecoveryPlanProviderSpecificFailoverInput() (*RecoveryPlanProviderSpecificFailoverInput, bool) {
	return nil, false
}

// AsBasicRecoveryPlanProviderSpecificFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanHyperVReplicaAzureFailbackInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailbackInput) AsBasicRecoveryPlanProviderSpecificFailoverInput() (BasicRecoveryPlanProviderSpecificFailoverInput, bool) {
	return &rphvrafi, true
}

// RecoveryPlanHyperVReplicaAzureFailoverInput recovery plan HVR Azure failover input.
type RecoveryPlanHyperVReplicaAzureFailoverInput struct {
	// VaultLocation - The vault location.
	VaultLocation *string `json:"vaultLocation,omitempty"`
	// PrimaryKekCertificatePfx - The primary KEK certificate PFX.
	PrimaryKekCertificatePfx *string `json:"primaryKekCertificatePfx,omitempty"`
	// SecondaryKekCertificatePfx - The secondary KEK certificate PFX.
	SecondaryKekCertificatePfx *string `json:"secondaryKekCertificatePfx,omitempty"`
	// RecoveryPointType - The recovery point type. Possible values include: 'HyperVReplicaAzureRpRecoveryPointTypeLatest', 'HyperVReplicaAzureRpRecoveryPointTypeLatestApplicationConsistent', 'HyperVReplicaAzureRpRecoveryPointTypeLatestProcessed'
	RecoveryPointType HyperVReplicaAzureRpRecoveryPointType `json:"recoveryPointType,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeRecoveryPlanProviderSpecificFailoverInput', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeA2A', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMage', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMageRcm'
	InstanceType InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoveryPlanHyperVReplicaAzureFailoverInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailoverInput) MarshalJSON() ([]byte, error) {
	rphvrafi.InstanceType = InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure
	objectMap := make(map[string]interface{})
	if rphvrafi.VaultLocation != nil {
		objectMap["vaultLocation"] = rphvrafi.VaultLocation
	}
	if rphvrafi.PrimaryKekCertificatePfx != nil {
		objectMap["primaryKekCertificatePfx"] = rphvrafi.PrimaryKekCertificatePfx
	}
	if rphvrafi.SecondaryKekCertificatePfx != nil {
		objectMap["secondaryKekCertificatePfx"] = rphvrafi.SecondaryKekCertificatePfx
	}
	if rphvrafi.RecoveryPointType != "" {
		objectMap["recoveryPointType"] = rphvrafi.RecoveryPointType
	}
	if rphvrafi.InstanceType != "" {
		objectMap["instanceType"] = rphvrafi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsRecoveryPlanA2AFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanHyperVReplicaAzureFailoverInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailoverInput) AsRecoveryPlanA2AFailoverInput() (*RecoveryPlanA2AFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanHyperVReplicaAzureFailbackInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanHyperVReplicaAzureFailoverInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailoverInput) AsRecoveryPlanHyperVReplicaAzureFailbackInput() (*RecoveryPlanHyperVReplicaAzureFailbackInput, bool) {
	return nil, false
}

// AsRecoveryPlanHyperVReplicaAzureFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanHyperVReplicaAzureFailoverInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailoverInput) AsRecoveryPlanHyperVReplicaAzureFailoverInput() (*RecoveryPlanHyperVReplicaAzureFailoverInput, bool) {
	return &rphvrafi, true
}

// AsRecoveryPlanInMageAzureV2FailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanHyperVReplicaAzureFailoverInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailoverInput) AsRecoveryPlanInMageAzureV2FailoverInput() (*RecoveryPlanInMageAzureV2FailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanInMageFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanHyperVReplicaAzureFailoverInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailoverInput) AsRecoveryPlanInMageFailoverInput() (*RecoveryPlanInMageFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanInMageRcmFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanHyperVReplicaAzureFailoverInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailoverInput) AsRecoveryPlanInMageRcmFailoverInput() (*RecoveryPlanInMageRcmFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanProviderSpecificFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanHyperVReplicaAzureFailoverInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailoverInput) AsRecoveryPlanProviderSpecificFailoverInput() (*RecoveryPlanProviderSpecificFailoverInput, bool) {
	return nil, false
}

// AsBasicRecoveryPlanProviderSpecificFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanHyperVReplicaAzureFailoverInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailoverInput) AsBasicRecoveryPlanProviderSpecificFailoverInput() (BasicRecoveryPlanProviderSpecificFailoverInput, bool) {
	return &rphvrafi, true
}

// RecoveryPlanInMageAzureV2FailoverInput recovery plan InMageAzureV2 failover input.
type RecoveryPlanInMageAzureV2FailoverInput struct {
	// VaultLocation - The vault location.
	VaultLocation *string `json:"vaultLocation,omitempty"`
	// RecoveryPointType - The recovery point type. Possible values include: 'InMageV2RpRecoveryPointTypeLatest', 'InMageV2RpRecoveryPointTypeLatestApplicationConsistent', 'InMageV2RpRecoveryPointTypeLatestCrashConsistent', 'InMageV2RpRecoveryPointTypeLatestProcessed'
	RecoveryPointType InMageV2RpRecoveryPointType `json:"recoveryPointType,omitempty"`
	// UseMultiVMSyncPoint - A value indicating whether multi VM sync enabled VMs should use multi VM sync points for failover.
	UseMultiVMSyncPoint *string `json:"useMultiVmSyncPoint,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeRecoveryPlanProviderSpecificFailoverInput', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeA2A', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMage', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMageRcm'
	InstanceType InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoveryPlanInMageAzureV2FailoverInput.
func (rpimavfi RecoveryPlanInMageAzureV2FailoverInput) MarshalJSON() ([]byte, error) {
	rpimavfi.InstanceType = InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMageAzureV2
	objectMap := make(map[string]interface{})
	if rpimavfi.VaultLocation != nil {
		objectMap["vaultLocation"] = rpimavfi.VaultLocation
	}
	if rpimavfi.RecoveryPointType != "" {
		objectMap["recoveryPointType"] = rpimavfi.RecoveryPointType
	}
	if rpimavfi.UseMultiVMSyncPoint != nil {
		objectMap["useMultiVmSyncPoint"] = rpimavfi.UseMultiVMSyncPoint
	}
	if rpimavfi.InstanceType != "" {
		objectMap["instanceType"] = rpimavfi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsRecoveryPlanA2AFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageAzureV2FailoverInput.
func (rpimavfi RecoveryPlanInMageAzureV2FailoverInput) AsRecoveryPlanA2AFailoverInput() (*RecoveryPlanA2AFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanHyperVReplicaAzureFailbackInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageAzureV2FailoverInput.
func (rpimavfi RecoveryPlanInMageAzureV2FailoverInput) AsRecoveryPlanHyperVReplicaAzureFailbackInput() (*RecoveryPlanHyperVReplicaAzureFailbackInput, bool) {
	return nil, false
}

// AsRecoveryPlanHyperVReplicaAzureFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageAzureV2FailoverInput.
func (rpimavfi RecoveryPlanInMageAzureV2FailoverInput) AsRecoveryPlanHyperVReplicaAzureFailoverInput() (*RecoveryPlanHyperVReplicaAzureFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanInMageAzureV2FailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageAzureV2FailoverInput.
func (rpimavfi RecoveryPlanInMageAzureV2FailoverInput) AsRecoveryPlanInMageAzureV2FailoverInput() (*RecoveryPlanInMageAzureV2FailoverInput, bool) {
	return &rpimavfi, true
}

// AsRecoveryPlanInMageFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageAzureV2FailoverInput.
func (rpimavfi RecoveryPlanInMageAzureV2FailoverInput) AsRecoveryPlanInMageFailoverInput() (*RecoveryPlanInMageFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanInMageRcmFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageAzureV2FailoverInput.
func (rpimavfi RecoveryPlanInMageAzureV2FailoverInput) AsRecoveryPlanInMageRcmFailoverInput() (*RecoveryPlanInMageRcmFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanProviderSpecificFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageAzureV2FailoverInput.
func (rpimavfi RecoveryPlanInMageAzureV2FailoverInput) AsRecoveryPlanProviderSpecificFailoverInput() (*RecoveryPlanProviderSpecificFailoverInput, bool) {
	return nil, false
}

// AsBasicRecoveryPlanProviderSpecificFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageAzureV2FailoverInput.
func (rpimavfi RecoveryPlanInMageAzureV2FailoverInput) AsBasicRecoveryPlanProviderSpecificFailoverInput() (BasicRecoveryPlanProviderSpecificFailoverInput, bool) {
	return &rpimavfi, true
}

// RecoveryPlanInMageFailoverInput recovery plan InMage failover input.
type RecoveryPlanInMageFailoverInput struct {
	// RecoveryPointType - The recovery point type. Possible values include: 'RpInMageRecoveryPointTypeLatestTime', 'RpInMageRecoveryPointTypeLatestTag', 'RpInMageRecoveryPointTypeCustom'
	RecoveryPointType RpInMageRecoveryPointType `json:"recoveryPointType,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeRecoveryPlanProviderSpecificFailoverInput', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeA2A', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMage', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMageRcm'
	InstanceType InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoveryPlanInMageFailoverInput.
func (rpimfi RecoveryPlanInMageFailoverInput) MarshalJSON() ([]byte, error) {
	rpimfi.InstanceType = InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMage
	objectMap := make(map[string]interface{})
	if rpimfi.RecoveryPointType != "" {
		objectMap["recoveryPointType"] = rpimfi.RecoveryPointType
	}
	if rpimfi.InstanceType != "" {
		objectMap["instanceType"] = rpimfi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsRecoveryPlanA2AFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageFailoverInput.
func (rpimfi RecoveryPlanInMageFailoverInput) AsRecoveryPlanA2AFailoverInput() (*RecoveryPlanA2AFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanHyperVReplicaAzureFailbackInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageFailoverInput.
func (rpimfi RecoveryPlanInMageFailoverInput) AsRecoveryPlanHyperVReplicaAzureFailbackInput() (*RecoveryPlanHyperVReplicaAzureFailbackInput, bool) {
	return nil, false
}

// AsRecoveryPlanHyperVReplicaAzureFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageFailoverInput.
func (rpimfi RecoveryPlanInMageFailoverInput) AsRecoveryPlanHyperVReplicaAzureFailoverInput() (*RecoveryPlanHyperVReplicaAzureFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanInMageAzureV2FailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageFailoverInput.
func (rpimfi RecoveryPlanInMageFailoverInput) AsRecoveryPlanInMageAzureV2FailoverInput() (*RecoveryPlanInMageAzureV2FailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanInMageFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageFailoverInput.
func (rpimfi RecoveryPlanInMageFailoverInput) AsRecoveryPlanInMageFailoverInput() (*RecoveryPlanInMageFailoverInput, bool) {
	return &rpimfi, true
}

// AsRecoveryPlanInMageRcmFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageFailoverInput.
func (rpimfi RecoveryPlanInMageFailoverInput) AsRecoveryPlanInMageRcmFailoverInput() (*RecoveryPlanInMageRcmFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanProviderSpecificFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageFailoverInput.
func (rpimfi RecoveryPlanInMageFailoverInput) AsRecoveryPlanProviderSpecificFailoverInput() (*RecoveryPlanProviderSpecificFailoverInput, bool) {
	return nil, false
}

// AsBasicRecoveryPlanProviderSpecificFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageFailoverInput.
func (rpimfi RecoveryPlanInMageFailoverInput) AsBasicRecoveryPlanProviderSpecificFailoverInput() (BasicRecoveryPlanProviderSpecificFailoverInput, bool) {
	return &rpimfi, true
}

// RecoveryPlanInMageRcmFailoverInput recovery plan InMageRcm failover input.
type RecoveryPlanInMageRcmFailoverInput struct {
	// RecoveryPointType - The recovery point type. Possible values include: 'RecoveryPlanPointTypeLatest', 'RecoveryPlanPointTypeLatestApplicationConsistent', 'RecoveryPlanPointTypeLatestCrashConsistent', 'RecoveryPlanPointTypeLatestProcessed'
	RecoveryPointType RecoveryPlanPointType `json:"recoveryPointType,omitempty"`
	// UseMultiVMSyncPoint - A value indicating whether multi VM sync enabled VMs should use multi VM sync points for failover.
	UseMultiVMSyncPoint *string `json:"useMultiVmSyncPoint,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeRecoveryPlanProviderSpecificFailoverInput', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeA2A', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMage', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMageRcm'
	InstanceType InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoveryPlanInMageRcmFailoverInput.
func (rpimrfi RecoveryPlanInMageRcmFailoverInput) MarshalJSON() ([]byte, error) {
	rpimrfi.InstanceType = InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMageRcm
	objectMap := make(map[string]interface{})
	if rpimrfi.RecoveryPointType != "" {
		objectMap["recoveryPointType"] = rpimrfi.RecoveryPointType
	}
	if rpimrfi.UseMultiVMSyncPoint != nil {
		objectMap["useMultiVmSyncPoint"] = rpimrfi.UseMultiVMSyncPoint
	}
	if rpimrfi.InstanceType != "" {
		objectMap["instanceType"] = rpimrfi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsRecoveryPlanA2AFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageRcmFailoverInput.
func (rpimrfi RecoveryPlanInMageRcmFailoverInput) AsRecoveryPlanA2AFailoverInput() (*RecoveryPlanA2AFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanHyperVReplicaAzureFailbackInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageRcmFailoverInput.
func (rpimrfi RecoveryPlanInMageRcmFailoverInput) AsRecoveryPlanHyperVReplicaAzureFailbackInput() (*RecoveryPlanHyperVReplicaAzureFailbackInput, bool) {
	return nil, false
}

// AsRecoveryPlanHyperVReplicaAzureFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageRcmFailoverInput.
func (rpimrfi RecoveryPlanInMageRcmFailoverInput) AsRecoveryPlanHyperVReplicaAzureFailoverInput() (*RecoveryPlanHyperVReplicaAzureFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanInMageAzureV2FailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageRcmFailoverInput.
func (rpimrfi RecoveryPlanInMageRcmFailoverInput) AsRecoveryPlanInMageAzureV2FailoverInput() (*RecoveryPlanInMageAzureV2FailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanInMageFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageRcmFailoverInput.
func (rpimrfi RecoveryPlanInMageRcmFailoverInput) AsRecoveryPlanInMageFailoverInput() (*RecoveryPlanInMageFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanInMageRcmFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageRcmFailoverInput.
func (rpimrfi RecoveryPlanInMageRcmFailoverInput) AsRecoveryPlanInMageRcmFailoverInput() (*RecoveryPlanInMageRcmFailoverInput, bool) {
	return &rpimrfi, true
}

// AsRecoveryPlanProviderSpecificFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageRcmFailoverInput.
func (rpimrfi RecoveryPlanInMageRcmFailoverInput) AsRecoveryPlanProviderSpecificFailoverInput() (*RecoveryPlanProviderSpecificFailoverInput, bool) {
	return nil, false
}

// AsBasicRecoveryPlanProviderSpecificFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageRcmFailoverInput.
func (rpimrfi RecoveryPlanInMageRcmFailoverInput) AsBasicRecoveryPlanProviderSpecificFailoverInput() (BasicRecoveryPlanProviderSpecificFailoverInput, bool) {
	return &rpimrfi, true
}

// RecoveryPlanManualActionDetails recovery plan manual action details.
type RecoveryPlanManualActionDetails struct {
	// Description - The manual action description.
	Description *string `json:"description,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeRecoveryPlanActionDetails', 'InstanceTypeAutomationRunbookActionDetails', 'InstanceTypeManualActionDetails', 'InstanceTypeScriptActionDetails'
	InstanceType InstanceTypeBasicRecoveryPlanActionDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoveryPlanManualActionDetails.
func (rpmad RecoveryPlanManualActionDetails) MarshalJSON() ([]byte, error) {
	rpmad.InstanceType = InstanceTypeManualActionDetails
	objectMap := make(map[string]interface{})
	if rpmad.Description != nil {
		objectMap["description"] = rpmad.Description
	}
	if rpmad.InstanceType != "" {
		objectMap["instanceType"] = rpmad.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsRecoveryPlanAutomationRunbookActionDetails is the BasicRecoveryPlanActionDetails implementation for RecoveryPlanManualActionDetails.
func (rpmad RecoveryPlanManualActionDetails) AsRecoveryPlanAutomationRunbookActionDetails() (*RecoveryPlanAutomationRunbookActionDetails, bool) {
	return nil, false
}

// AsRecoveryPlanManualActionDetails is the BasicRecoveryPlanActionDetails implementation for RecoveryPlanManualActionDetails.
func (rpmad RecoveryPlanManualActionDetails) AsRecoveryPlanManualActionDetails() (*RecoveryPlanManualActionDetails, bool) {
	return &rpmad, true
}

// AsRecoveryPlanScriptActionDetails is the BasicRecoveryPlanActionDetails implementation for RecoveryPlanManualActionDetails.
func (rpmad RecoveryPlanManualActionDetails) AsRecoveryPlanScriptActionDetails() (*RecoveryPlanScriptActionDetails, bool) {
	return nil, false
}

// AsRecoveryPlanActionDetails is the BasicRecoveryPlanActionDetails implementation for RecoveryPlanManualActionDetails.
func (rpmad RecoveryPlanManualActionDetails) AsRecoveryPlanActionDetails() (*RecoveryPlanActionDetails, bool) {
	return nil, false
}

// AsBasicRecoveryPlanActionDetails is the BasicRecoveryPlanActionDetails implementation for RecoveryPlanManualActionDetails.
func (rpmad RecoveryPlanManualActionDetails) AsBasicRecoveryPlanActionDetails() (BasicRecoveryPlanActionDetails, bool) {
	return &rpmad, true
}

// RecoveryPlanPlannedFailoverInput recovery plan planned failover input.
type RecoveryPlanPlannedFailoverInput struct {
	// Properties - The recovery plan planned failover input properties.
	Properties *RecoveryPlanPlannedFailoverInputProperties `json:"properties,omitempty"`
}

// RecoveryPlanPlannedFailoverInputProperties recovery plan planned failover input properties.
type RecoveryPlanPlannedFailoverInputProperties struct {
	// FailoverDirection - The failover direction. Possible values include: 'PrimaryToRecovery', 'RecoveryToPrimary'
	FailoverDirection PossibleOperationsDirections `json:"failoverDirection,omitempty"`
	// ProviderSpecificDetails - The provider specific properties.
	ProviderSpecificDetails *[]BasicRecoveryPlanProviderSpecificFailoverInput `json:"providerSpecificDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for RecoveryPlanPlannedFailoverInputProperties struct.
func (rppfip *RecoveryPlanPlannedFailoverInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "failoverDirection":
			if v != nil {
				var failoverDirection PossibleOperationsDirections
				err = json.Unmarshal(*v, &failoverDirection)
				if err != nil {
					return err
				}
				rppfip.FailoverDirection = failoverDirection
			}
		case "providerSpecificDetails":
			if v != nil {
				providerSpecificDetails, err := unmarshalBasicRecoveryPlanProviderSpecificFailoverInputArray(*v)
				if err != nil {
					return err
				}
				rppfip.ProviderSpecificDetails = &providerSpecificDetails
			}
		}
	}

	return nil
}

// RecoveryPlanProperties recovery plan custom details.
type RecoveryPlanProperties struct {
	// FriendlyName - The friendly name.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// PrimaryFabricID - The primary fabric Id.
	PrimaryFabricID *string `json:"primaryFabricId,omitempty"`
	// PrimaryFabricFriendlyName - The primary fabric friendly name.
	PrimaryFabricFriendlyName *string `json:"primaryFabricFriendlyName,omitempty"`
	// RecoveryFabricID - The recovery fabric Id.
	RecoveryFabricID *string `json:"recoveryFabricId,omitempty"`
	// RecoveryFabricFriendlyName - The recovery fabric friendly name.
	RecoveryFabricFriendlyName *string `json:"recoveryFabricFriendlyName,omitempty"`
	// FailoverDeploymentModel - The failover deployment model.
	FailoverDeploymentModel *string `json:"failoverDeploymentModel,omitempty"`
	// ReplicationProviders - The list of replication providers.
	ReplicationProviders *[]string `json:"replicationProviders,omitempty"`
	// AllowedOperations - The list of allowed operations.
	AllowedOperations *[]string `json:"allowedOperations,omitempty"`
	// LastPlannedFailoverTime - The start time of the last planned failover.
	LastPlannedFailoverTime *date.Time `json:"lastPlannedFailoverTime,omitempty"`
	// LastUnplannedFailoverTime - The start time of the last unplanned failover.
	LastUnplannedFailoverTime *date.Time `json:"lastUnplannedFailoverTime,omitempty"`
	// LastTestFailoverTime - The start time of the last test failover.
	LastTestFailoverTime *date.Time `json:"lastTestFailoverTime,omitempty"`
	// CurrentScenario - The current scenario details.
	CurrentScenario *CurrentScenarioDetails `json:"currentScenario,omitempty"`
	// CurrentScenarioStatus - The recovery plan status.
	CurrentScenarioStatus *string `json:"currentScenarioStatus,omitempty"`
	// CurrentScenarioStatusDescription - The recovery plan status description.
	CurrentScenarioStatusDescription *string `json:"currentScenarioStatusDescription,omitempty"`
	// Groups - The recovery plan groups.
	Groups *[]RecoveryPlanGroup `json:"groups,omitempty"`
	// ProviderSpecificDetails - READ-ONLY; The provider id and provider specific details.
	ProviderSpecificDetails *[]BasicRecoveryPlanProviderSpecificDetails `json:"providerSpecificDetails,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoveryPlanProperties.
func (rpp RecoveryPlanProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rpp.FriendlyName != nil {
		objectMap["friendlyName"] = rpp.FriendlyName
	}
	if rpp.PrimaryFabricID != nil {
		objectMap["primaryFabricId"] = rpp.PrimaryFabricID
	}
	if rpp.PrimaryFabricFriendlyName != nil {
		objectMap["primaryFabricFriendlyName"] = rpp.PrimaryFabricFriendlyName
	}
	if rpp.RecoveryFabricID != nil {
		objectMap["recoveryFabricId"] = rpp.RecoveryFabricID
	}
	if rpp.RecoveryFabricFriendlyName != nil {
		objectMap["recoveryFabricFriendlyName"] = rpp.RecoveryFabricFriendlyName
	}
	if rpp.FailoverDeploymentModel != nil {
		objectMap["failoverDeploymentModel"] = rpp.FailoverDeploymentModel
	}
	if rpp.ReplicationProviders != nil {
		objectMap["replicationProviders"] = rpp.ReplicationProviders
	}
	if rpp.AllowedOperations != nil {
		objectMap["allowedOperations"] = rpp.AllowedOperations
	}
	if rpp.LastPlannedFailoverTime != nil {
		objectMap["lastPlannedFailoverTime"] = rpp.LastPlannedFailoverTime
	}
	if rpp.LastUnplannedFailoverTime != nil {
		objectMap["lastUnplannedFailoverTime"] = rpp.LastUnplannedFailoverTime
	}
	if rpp.LastTestFailoverTime != nil {
		objectMap["lastTestFailoverTime"] = rpp.LastTestFailoverTime
	}
	if rpp.CurrentScenario != nil {
		objectMap["currentScenario"] = rpp.CurrentScenario
	}
	if rpp.CurrentScenarioStatus != nil {
		objectMap["currentScenarioStatus"] = rpp.CurrentScenarioStatus
	}
	if rpp.CurrentScenarioStatusDescription != nil {
		objectMap["currentScenarioStatusDescription"] = rpp.CurrentScenarioStatusDescription
	}
	if rpp.Groups != nil {
		objectMap["groups"] = rpp.Groups
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RecoveryPlanProperties struct.
func (rpp *RecoveryPlanProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "friendlyName":
			if v != nil {
				var friendlyName string
				err = json.Unmarshal(*v, &friendlyName)
				if err != nil {
					return err
				}
				rpp.FriendlyName = &friendlyName
			}
		case "primaryFabricId":
			if v != nil {
				var primaryFabricID string
				err = json.Unmarshal(*v, &primaryFabricID)
				if err != nil {
					return err
				}
				rpp.PrimaryFabricID = &primaryFabricID
			}
		case "primaryFabricFriendlyName":
			if v != nil {
				var primaryFabricFriendlyName string
				err = json.Unmarshal(*v, &primaryFabricFriendlyName)
				if err != nil {
					return err
				}
				rpp.PrimaryFabricFriendlyName = &primaryFabricFriendlyName
			}
		case "recoveryFabricId":
			if v != nil {
				var recoveryFabricID string
				err = json.Unmarshal(*v, &recoveryFabricID)
				if err != nil {
					return err
				}
				rpp.RecoveryFabricID = &recoveryFabricID
			}
		case "recoveryFabricFriendlyName":
			if v != nil {
				var recoveryFabricFriendlyName string
				err = json.Unmarshal(*v, &recoveryFabricFriendlyName)
				if err != nil {
					return err
				}
				rpp.RecoveryFabricFriendlyName = &recoveryFabricFriendlyName
			}
		case "failoverDeploymentModel":
			if v != nil {
				var failoverDeploymentModel string
				err = json.Unmarshal(*v, &failoverDeploymentModel)
				if err != nil {
					return err
				}
				rpp.FailoverDeploymentModel = &failoverDeploymentModel
			}
		case "replicationProviders":
			if v != nil {
				var replicationProviders []string
				err = json.Unmarshal(*v, &replicationProviders)
				if err != nil {
					return err
				}
				rpp.ReplicationProviders = &replicationProviders
			}
		case "allowedOperations":
			if v != nil {
				var allowedOperations []string
				err = json.Unmarshal(*v, &allowedOperations)
				if err != nil {
					return err
				}
				rpp.AllowedOperations = &allowedOperations
			}
		case "lastPlannedFailoverTime":
			if v != nil {
				var lastPlannedFailoverTime date.Time
				err = json.Unmarshal(*v, &lastPlannedFailoverTime)
				if err != nil {
					return err
				}
				rpp.LastPlannedFailoverTime = &lastPlannedFailoverTime
			}
		case "lastUnplannedFailoverTime":
			if v != nil {
				var lastUnplannedFailoverTime date.Time
				err = json.Unmarshal(*v, &lastUnplannedFailoverTime)
				if err != nil {
					return err
				}
				rpp.LastUnplannedFailoverTime = &lastUnplannedFailoverTime
			}
		case "lastTestFailoverTime":
			if v != nil {
				var lastTestFailoverTime date.Time
				err = json.Unmarshal(*v, &lastTestFailoverTime)
				if err != nil {
					return err
				}
				rpp.LastTestFailoverTime = &lastTestFailoverTime
			}
		case "currentScenario":
			if v != nil {
				var currentScenario CurrentScenarioDetails
				err = json.Unmarshal(*v, &currentScenario)
				if err != nil {
					return err
				}
				rpp.CurrentScenario = &currentScenario
			}
		case "currentScenarioStatus":
			if v != nil {
				var currentScenarioStatus string
				err = json.Unmarshal(*v, &currentScenarioStatus)
				if err != nil {
					return err
				}
				rpp.CurrentScenarioStatus = &currentScenarioStatus
			}
		case "currentScenarioStatusDescription":
			if v != nil {
				var currentScenarioStatusDescription string
				err = json.Unmarshal(*v, &currentScenarioStatusDescription)
				if err != nil {
					return err
				}
				rpp.CurrentScenarioStatusDescription = &currentScenarioStatusDescription
			}
		case "groups":
			if v != nil {
				var groups []RecoveryPlanGroup
				err = json.Unmarshal(*v, &groups)
				if err != nil {
					return err
				}
				rpp.Groups = &groups
			}
		case "providerSpecificDetails":
			if v != nil {
				providerSpecificDetails, err := unmarshalBasicRecoveryPlanProviderSpecificDetailsArray(*v)
				if err != nil {
					return err
				}
				rpp.ProviderSpecificDetails = &providerSpecificDetails
			}
		}
	}

	return nil
}

// RecoveryPlanProtectedItem recovery plan protected item.
type RecoveryPlanProtectedItem struct {
	// ID - The ARM Id of the recovery plan protected item.
	ID *string `json:"id,omitempty"`
	// VirtualMachineID - The virtual machine Id.
	VirtualMachineID *string `json:"virtualMachineId,omitempty"`
}

// BasicRecoveryPlanProviderSpecificDetails recovery plan provider specific details.
type BasicRecoveryPlanProviderSpecificDetails interface {
	AsRecoveryPlanA2ADetails() (*RecoveryPlanA2ADetails, bool)
	AsRecoveryPlanProviderSpecificDetails() (*RecoveryPlanProviderSpecificDetails, bool)
}

// RecoveryPlanProviderSpecificDetails recovery plan provider specific details.
type RecoveryPlanProviderSpecificDetails struct {
	// InstanceType - Possible values include: 'InstanceTypeBasicRecoveryPlanProviderSpecificDetailsInstanceTypeRecoveryPlanProviderSpecificDetails', 'InstanceTypeBasicRecoveryPlanProviderSpecificDetailsInstanceTypeA2A'
	InstanceType InstanceTypeBasicRecoveryPlanProviderSpecificDetails `json:"instanceType,omitempty"`
}

func unmarshalBasicRecoveryPlanProviderSpecificDetails(body []byte) (BasicRecoveryPlanProviderSpecificDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeBasicRecoveryPlanProviderSpecificDetailsInstanceTypeA2A):
		var rpad RecoveryPlanA2ADetails
		err := json.Unmarshal(body, &rpad)
		return rpad, err
	default:
		var rppsd RecoveryPlanProviderSpecificDetails
		err := json.Unmarshal(body, &rppsd)
		return rppsd, err
	}
}
func unmarshalBasicRecoveryPlanProviderSpecificDetailsArray(body []byte) ([]BasicRecoveryPlanProviderSpecificDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rppsdArray := make([]BasicRecoveryPlanProviderSpecificDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rppsd, err := unmarshalBasicRecoveryPlanProviderSpecificDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		rppsdArray[index] = rppsd
	}
	return rppsdArray, nil
}

// MarshalJSON is the custom marshaler for RecoveryPlanProviderSpecificDetails.
func (rppsd RecoveryPlanProviderSpecificDetails) MarshalJSON() ([]byte, error) {
	rppsd.InstanceType = InstanceTypeBasicRecoveryPlanProviderSpecificDetailsInstanceTypeRecoveryPlanProviderSpecificDetails
	objectMap := make(map[string]interface{})
	if rppsd.InstanceType != "" {
		objectMap["instanceType"] = rppsd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsRecoveryPlanA2ADetails is the BasicRecoveryPlanProviderSpecificDetails implementation for RecoveryPlanProviderSpecificDetails.
func (rppsd RecoveryPlanProviderSpecificDetails) AsRecoveryPlanA2ADetails() (*RecoveryPlanA2ADetails, bool) {
	return nil, false
}

// AsRecoveryPlanProviderSpecificDetails is the BasicRecoveryPlanProviderSpecificDetails implementation for RecoveryPlanProviderSpecificDetails.
func (rppsd RecoveryPlanProviderSpecificDetails) AsRecoveryPlanProviderSpecificDetails() (*RecoveryPlanProviderSpecificDetails, bool) {
	return &rppsd, true
}

// AsBasicRecoveryPlanProviderSpecificDetails is the BasicRecoveryPlanProviderSpecificDetails implementation for RecoveryPlanProviderSpecificDetails.
func (rppsd RecoveryPlanProviderSpecificDetails) AsBasicRecoveryPlanProviderSpecificDetails() (BasicRecoveryPlanProviderSpecificDetails, bool) {
	return &rppsd, true
}

// BasicRecoveryPlanProviderSpecificFailoverInput recovery plan provider specific failover input base class.
type BasicRecoveryPlanProviderSpecificFailoverInput interface {
	AsRecoveryPlanA2AFailoverInput() (*RecoveryPlanA2AFailoverInput, bool)
	AsRecoveryPlanHyperVReplicaAzureFailbackInput() (*RecoveryPlanHyperVReplicaAzureFailbackInput, bool)
	AsRecoveryPlanHyperVReplicaAzureFailoverInput() (*RecoveryPlanHyperVReplicaAzureFailoverInput, bool)
	AsRecoveryPlanInMageAzureV2FailoverInput() (*RecoveryPlanInMageAzureV2FailoverInput, bool)
	AsRecoveryPlanInMageFailoverInput() (*RecoveryPlanInMageFailoverInput, bool)
	AsRecoveryPlanInMageRcmFailoverInput() (*RecoveryPlanInMageRcmFailoverInput, bool)
	AsRecoveryPlanProviderSpecificFailoverInput() (*RecoveryPlanProviderSpecificFailoverInput, bool)
}

// RecoveryPlanProviderSpecificFailoverInput recovery plan provider specific failover input base class.
type RecoveryPlanProviderSpecificFailoverInput struct {
	// InstanceType - Possible values include: 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeRecoveryPlanProviderSpecificFailoverInput', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeA2A', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMage', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMageRcm'
	InstanceType InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput `json:"instanceType,omitempty"`
}

func unmarshalBasicRecoveryPlanProviderSpecificFailoverInput(body []byte) (BasicRecoveryPlanProviderSpecificFailoverInput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeA2A):
		var rpafi RecoveryPlanA2AFailoverInput
		err := json.Unmarshal(body, &rpafi)
		return rpafi, err
	case string(InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback):
		var rphvrafi RecoveryPlanHyperVReplicaAzureFailbackInput
		err := json.Unmarshal(body, &rphvrafi)
		return rphvrafi, err
	case string(InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure):
		var rphvrafi RecoveryPlanHyperVReplicaAzureFailoverInput
		err := json.Unmarshal(body, &rphvrafi)
		return rphvrafi, err
	case string(InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMageAzureV2):
		var rpimavfi RecoveryPlanInMageAzureV2FailoverInput
		err := json.Unmarshal(body, &rpimavfi)
		return rpimavfi, err
	case string(InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMage):
		var rpimfi RecoveryPlanInMageFailoverInput
		err := json.Unmarshal(body, &rpimfi)
		return rpimfi, err
	case string(InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMageRcm):
		var rpimrfi RecoveryPlanInMageRcmFailoverInput
		err := json.Unmarshal(body, &rpimrfi)
		return rpimrfi, err
	default:
		var rppsfi RecoveryPlanProviderSpecificFailoverInput
		err := json.Unmarshal(body, &rppsfi)
		return rppsfi, err
	}
}
func unmarshalBasicRecoveryPlanProviderSpecificFailoverInputArray(body []byte) ([]BasicRecoveryPlanProviderSpecificFailoverInput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rppsfiArray := make([]BasicRecoveryPlanProviderSpecificFailoverInput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rppsfi, err := unmarshalBasicRecoveryPlanProviderSpecificFailoverInput(*rawMessage)
		if err != nil {
			return nil, err
		}
		rppsfiArray[index] = rppsfi
	}
	return rppsfiArray, nil
}

// MarshalJSON is the custom marshaler for RecoveryPlanProviderSpecificFailoverInput.
func (rppsfi RecoveryPlanProviderSpecificFailoverInput) MarshalJSON() ([]byte, error) {
	rppsfi.InstanceType = InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeRecoveryPlanProviderSpecificFailoverInput
	objectMap := make(map[string]interface{})
	if rppsfi.InstanceType != "" {
		objectMap["instanceType"] = rppsfi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsRecoveryPlanA2AFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanProviderSpecificFailoverInput.
func (rppsfi RecoveryPlanProviderSpecificFailoverInput) AsRecoveryPlanA2AFailoverInput() (*RecoveryPlanA2AFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanHyperVReplicaAzureFailbackInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanProviderSpecificFailoverInput.
func (rppsfi RecoveryPlanProviderSpecificFailoverInput) AsRecoveryPlanHyperVReplicaAzureFailbackInput() (*RecoveryPlanHyperVReplicaAzureFailbackInput, bool) {
	return nil, false
}

// AsRecoveryPlanHyperVReplicaAzureFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanProviderSpecificFailoverInput.
func (rppsfi RecoveryPlanProviderSpecificFailoverInput) AsRecoveryPlanHyperVReplicaAzureFailoverInput() (*RecoveryPlanHyperVReplicaAzureFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanInMageAzureV2FailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanProviderSpecificFailoverInput.
func (rppsfi RecoveryPlanProviderSpecificFailoverInput) AsRecoveryPlanInMageAzureV2FailoverInput() (*RecoveryPlanInMageAzureV2FailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanInMageFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanProviderSpecificFailoverInput.
func (rppsfi RecoveryPlanProviderSpecificFailoverInput) AsRecoveryPlanInMageFailoverInput() (*RecoveryPlanInMageFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanInMageRcmFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanProviderSpecificFailoverInput.
func (rppsfi RecoveryPlanProviderSpecificFailoverInput) AsRecoveryPlanInMageRcmFailoverInput() (*RecoveryPlanInMageRcmFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanProviderSpecificFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanProviderSpecificFailoverInput.
func (rppsfi RecoveryPlanProviderSpecificFailoverInput) AsRecoveryPlanProviderSpecificFailoverInput() (*RecoveryPlanProviderSpecificFailoverInput, bool) {
	return &rppsfi, true
}

// AsBasicRecoveryPlanProviderSpecificFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanProviderSpecificFailoverInput.
func (rppsfi RecoveryPlanProviderSpecificFailoverInput) AsBasicRecoveryPlanProviderSpecificFailoverInput() (BasicRecoveryPlanProviderSpecificFailoverInput, bool) {
	return &rppsfi, true
}

// BasicRecoveryPlanProviderSpecificInput recovery plan provider specific input base class.
type BasicRecoveryPlanProviderSpecificInput interface {
	AsRecoveryPlanA2AInput() (*RecoveryPlanA2AInput, bool)
	AsRecoveryPlanProviderSpecificInput() (*RecoveryPlanProviderSpecificInput, bool)
}

// RecoveryPlanProviderSpecificInput recovery plan provider specific input base class.
type RecoveryPlanProviderSpecificInput struct {
	// InstanceType - Possible values include: 'InstanceTypeBasicRecoveryPlanProviderSpecificInputInstanceTypeRecoveryPlanProviderSpecificInput', 'InstanceTypeBasicRecoveryPlanProviderSpecificInputInstanceTypeA2A'
	InstanceType InstanceTypeBasicRecoveryPlanProviderSpecificInput `json:"instanceType,omitempty"`
}

func unmarshalBasicRecoveryPlanProviderSpecificInput(body []byte) (BasicRecoveryPlanProviderSpecificInput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeBasicRecoveryPlanProviderSpecificInputInstanceTypeA2A):
		var rpai RecoveryPlanA2AInput
		err := json.Unmarshal(body, &rpai)
		return rpai, err
	default:
		var rppsi RecoveryPlanProviderSpecificInput
		err := json.Unmarshal(body, &rppsi)
		return rppsi, err
	}
}
func unmarshalBasicRecoveryPlanProviderSpecificInputArray(body []byte) ([]BasicRecoveryPlanProviderSpecificInput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rppsiArray := make([]BasicRecoveryPlanProviderSpecificInput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rppsi, err := unmarshalBasicRecoveryPlanProviderSpecificInput(*rawMessage)
		if err != nil {
			return nil, err
		}
		rppsiArray[index] = rppsi
	}
	return rppsiArray, nil
}

// MarshalJSON is the custom marshaler for RecoveryPlanProviderSpecificInput.
func (rppsi RecoveryPlanProviderSpecificInput) MarshalJSON() ([]byte, error) {
	rppsi.InstanceType = InstanceTypeBasicRecoveryPlanProviderSpecificInputInstanceTypeRecoveryPlanProviderSpecificInput
	objectMap := make(map[string]interface{})
	if rppsi.InstanceType != "" {
		objectMap["instanceType"] = rppsi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsRecoveryPlanA2AInput is the BasicRecoveryPlanProviderSpecificInput implementation for RecoveryPlanProviderSpecificInput.
func (rppsi RecoveryPlanProviderSpecificInput) AsRecoveryPlanA2AInput() (*RecoveryPlanA2AInput, bool) {
	return nil, false
}

// AsRecoveryPlanProviderSpecificInput is the BasicRecoveryPlanProviderSpecificInput implementation for RecoveryPlanProviderSpecificInput.
func (rppsi RecoveryPlanProviderSpecificInput) AsRecoveryPlanProviderSpecificInput() (*RecoveryPlanProviderSpecificInput, bool) {
	return &rppsi, true
}

// AsBasicRecoveryPlanProviderSpecificInput is the BasicRecoveryPlanProviderSpecificInput implementation for RecoveryPlanProviderSpecificInput.
func (rppsi RecoveryPlanProviderSpecificInput) AsBasicRecoveryPlanProviderSpecificInput() (BasicRecoveryPlanProviderSpecificInput, bool) {
	return &rppsi, true
}

// RecoveryPlanScriptActionDetails recovery plan script action details.
type RecoveryPlanScriptActionDetails struct {
	// Path - The script path.
	Path *string `json:"path,omitempty"`
	// Timeout - The script timeout.
	Timeout *string `json:"timeout,omitempty"`
	// FabricLocation - The fabric location. Possible values include: 'Primary', 'Recovery'
	FabricLocation RecoveryPlanActionLocation `json:"fabricLocation,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeRecoveryPlanActionDetails', 'InstanceTypeAutomationRunbookActionDetails', 'InstanceTypeManualActionDetails', 'InstanceTypeScriptActionDetails'
	InstanceType InstanceTypeBasicRecoveryPlanActionDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoveryPlanScriptActionDetails.
func (rpsad RecoveryPlanScriptActionDetails) MarshalJSON() ([]byte, error) {
	rpsad.InstanceType = InstanceTypeScriptActionDetails
	objectMap := make(map[string]interface{})
	if rpsad.Path != nil {
		objectMap["path"] = rpsad.Path
	}
	if rpsad.Timeout != nil {
		objectMap["timeout"] = rpsad.Timeout
	}
	if rpsad.FabricLocation != "" {
		objectMap["fabricLocation"] = rpsad.FabricLocation
	}
	if rpsad.InstanceType != "" {
		objectMap["instanceType"] = rpsad.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsRecoveryPlanAutomationRunbookActionDetails is the BasicRecoveryPlanActionDetails implementation for RecoveryPlanScriptActionDetails.
func (rpsad RecoveryPlanScriptActionDetails) AsRecoveryPlanAutomationRunbookActionDetails() (*RecoveryPlanAutomationRunbookActionDetails, bool) {
	return nil, false
}

// AsRecoveryPlanManualActionDetails is the BasicRecoveryPlanActionDetails implementation for RecoveryPlanScriptActionDetails.
func (rpsad RecoveryPlanScriptActionDetails) AsRecoveryPlanManualActionDetails() (*RecoveryPlanManualActionDetails, bool) {
	return nil, false
}

// AsRecoveryPlanScriptActionDetails is the BasicRecoveryPlanActionDetails implementation for RecoveryPlanScriptActionDetails.
func (rpsad RecoveryPlanScriptActionDetails) AsRecoveryPlanScriptActionDetails() (*RecoveryPlanScriptActionDetails, bool) {
	return &rpsad, true
}

// AsRecoveryPlanActionDetails is the BasicRecoveryPlanActionDetails implementation for RecoveryPlanScriptActionDetails.
func (rpsad RecoveryPlanScriptActionDetails) AsRecoveryPlanActionDetails() (*RecoveryPlanActionDetails, bool) {
	return nil, false
}

// AsBasicRecoveryPlanActionDetails is the BasicRecoveryPlanActionDetails implementation for RecoveryPlanScriptActionDetails.
func (rpsad RecoveryPlanScriptActionDetails) AsBasicRecoveryPlanActionDetails() (BasicRecoveryPlanActionDetails, bool) {
	return &rpsad, true
}

// RecoveryPlanShutdownGroupTaskDetails this class represents the recovery plan shutdown group task
// details.
type RecoveryPlanShutdownGroupTaskDetails struct {
	// Name - The name.
	Name *string `json:"name,omitempty"`
	// GroupID - The group identifier.
	GroupID *string `json:"groupId,omitempty"`
	// RpGroupType - The group type.
	RpGroupType *string `json:"rpGroupType,omitempty"`
	// ChildTasks - The child tasks.
	ChildTasks *[]ASRTask `json:"childTasks,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeGroupTaskDetails', 'InstanceTypeInlineWorkflowTaskDetails', 'InstanceTypeRecoveryPlanGroupTaskDetails', 'InstanceTypeRecoveryPlanShutdownGroupTaskDetails'
	InstanceType InstanceTypeBasicGroupTaskDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoveryPlanShutdownGroupTaskDetails.
func (rpsgtd RecoveryPlanShutdownGroupTaskDetails) MarshalJSON() ([]byte, error) {
	rpsgtd.InstanceType = InstanceTypeRecoveryPlanShutdownGroupTaskDetails
	objectMap := make(map[string]interface{})
	if rpsgtd.Name != nil {
		objectMap["name"] = rpsgtd.Name
	}
	if rpsgtd.GroupID != nil {
		objectMap["groupId"] = rpsgtd.GroupID
	}
	if rpsgtd.RpGroupType != nil {
		objectMap["rpGroupType"] = rpsgtd.RpGroupType
	}
	if rpsgtd.ChildTasks != nil {
		objectMap["childTasks"] = rpsgtd.ChildTasks
	}
	if rpsgtd.InstanceType != "" {
		objectMap["instanceType"] = rpsgtd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsInlineWorkflowTaskDetails is the BasicGroupTaskDetails implementation for RecoveryPlanShutdownGroupTaskDetails.
func (rpsgtd RecoveryPlanShutdownGroupTaskDetails) AsInlineWorkflowTaskDetails() (*InlineWorkflowTaskDetails, bool) {
	return nil, false
}

// AsRecoveryPlanGroupTaskDetails is the BasicGroupTaskDetails implementation for RecoveryPlanShutdownGroupTaskDetails.
func (rpsgtd RecoveryPlanShutdownGroupTaskDetails) AsRecoveryPlanGroupTaskDetails() (*RecoveryPlanGroupTaskDetails, bool) {
	return nil, false
}

// AsRecoveryPlanShutdownGroupTaskDetails is the BasicGroupTaskDetails implementation for RecoveryPlanShutdownGroupTaskDetails.
func (rpsgtd RecoveryPlanShutdownGroupTaskDetails) AsRecoveryPlanShutdownGroupTaskDetails() (*RecoveryPlanShutdownGroupTaskDetails, bool) {
	return &rpsgtd, true
}

// AsGroupTaskDetails is the BasicGroupTaskDetails implementation for RecoveryPlanShutdownGroupTaskDetails.
func (rpsgtd RecoveryPlanShutdownGroupTaskDetails) AsGroupTaskDetails() (*GroupTaskDetails, bool) {
	return nil, false
}

// AsBasicGroupTaskDetails is the BasicGroupTaskDetails implementation for RecoveryPlanShutdownGroupTaskDetails.
func (rpsgtd RecoveryPlanShutdownGroupTaskDetails) AsBasicGroupTaskDetails() (BasicGroupTaskDetails, bool) {
	return &rpsgtd, true
}

// RecoveryPlanTestFailoverCleanupInput recovery plan test failover cleanup input.
type RecoveryPlanTestFailoverCleanupInput struct {
	// Properties - The recovery plan test failover cleanup input properties.
	Properties *RecoveryPlanTestFailoverCleanupInputProperties `json:"properties,omitempty"`
}

// RecoveryPlanTestFailoverCleanupInputProperties recovery plan test failover cleanup input properties.
type RecoveryPlanTestFailoverCleanupInputProperties struct {
	// Comments - The test failover cleanup comments.
	Comments *string `json:"comments,omitempty"`
}

// RecoveryPlanTestFailoverInput recovery plan test failover input.
type RecoveryPlanTestFailoverInput struct {
	// Properties - The recovery plan test failover input properties.
	Properties *RecoveryPlanTestFailoverInputProperties `json:"properties,omitempty"`
}

// RecoveryPlanTestFailoverInputProperties recovery plan test failover input properties.
type RecoveryPlanTestFailoverInputProperties struct {
	// FailoverDirection - The failover direction. Possible values include: 'PrimaryToRecovery', 'RecoveryToPrimary'
	FailoverDirection PossibleOperationsDirections `json:"failoverDirection,omitempty"`
	// NetworkType - The network type to be used for test failover.
	NetworkType *string `json:"networkType,omitempty"`
	// NetworkID - The Id of the network to be used for test failover.
	NetworkID *string `json:"networkId,omitempty"`
	// SkipTestFailoverCleanup - A value indicating whether the test failover cleanup is to be skipped.
	SkipTestFailoverCleanup *string `json:"skipTestFailoverCleanup,omitempty"`
	// ProviderSpecificDetails - The provider specific properties.
	ProviderSpecificDetails *[]BasicRecoveryPlanProviderSpecificFailoverInput `json:"providerSpecificDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for RecoveryPlanTestFailoverInputProperties struct.
func (rptfip *RecoveryPlanTestFailoverInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "failoverDirection":
			if v != nil {
				var failoverDirection PossibleOperationsDirections
				err = json.Unmarshal(*v, &failoverDirection)
				if err != nil {
					return err
				}
				rptfip.FailoverDirection = failoverDirection
			}
		case "networkType":
			if v != nil {
				var networkType string
				err = json.Unmarshal(*v, &networkType)
				if err != nil {
					return err
				}
				rptfip.NetworkType = &networkType
			}
		case "networkId":
			if v != nil {
				var networkID string
				err = json.Unmarshal(*v, &networkID)
				if err != nil {
					return err
				}
				rptfip.NetworkID = &networkID
			}
		case "skipTestFailoverCleanup":
			if v != nil {
				var skipTestFailoverCleanup string
				err = json.Unmarshal(*v, &skipTestFailoverCleanup)
				if err != nil {
					return err
				}
				rptfip.SkipTestFailoverCleanup = &skipTestFailoverCleanup
			}
		case "providerSpecificDetails":
			if v != nil {
				providerSpecificDetails, err := unmarshalBasicRecoveryPlanProviderSpecificFailoverInputArray(*v)
				if err != nil {
					return err
				}
				rptfip.ProviderSpecificDetails = &providerSpecificDetails
			}
		}
	}

	return nil
}

// RecoveryPlanUnplannedFailoverInput recovery plan unplanned failover input.
type RecoveryPlanUnplannedFailoverInput struct {
	// Properties - The recovery plan unplanned failover input properties.
	Properties *RecoveryPlanUnplannedFailoverInputProperties `json:"properties,omitempty"`
}

// RecoveryPlanUnplannedFailoverInputProperties recovery plan unplanned failover input properties.
type RecoveryPlanUnplannedFailoverInputProperties struct {
	// FailoverDirection - The failover direction. Possible values include: 'PrimaryToRecovery', 'RecoveryToPrimary'
	FailoverDirection PossibleOperationsDirections `json:"failoverDirection,omitempty"`
	// SourceSiteOperations - A value indicating whether source site operations are required. Possible values include: 'Required', 'NotRequired'
	SourceSiteOperations SourceSiteOperations `json:"sourceSiteOperations,omitempty"`
	// ProviderSpecificDetails - The provider specific properties.
	ProviderSpecificDetails *[]BasicRecoveryPlanProviderSpecificFailoverInput `json:"providerSpecificDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for RecoveryPlanUnplannedFailoverInputProperties struct.
func (rpufip *RecoveryPlanUnplannedFailoverInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "failoverDirection":
			if v != nil {
				var failoverDirection PossibleOperationsDirections
				err = json.Unmarshal(*v, &failoverDirection)
				if err != nil {
					return err
				}
				rpufip.FailoverDirection = failoverDirection
			}
		case "sourceSiteOperations":
			if v != nil {
				var sourceSiteOperations SourceSiteOperations
				err = json.Unmarshal(*v, &sourceSiteOperations)
				if err != nil {
					return err
				}
				rpufip.SourceSiteOperations = sourceSiteOperations
			}
		case "providerSpecificDetails":
			if v != nil {
				providerSpecificDetails, err := unmarshalBasicRecoveryPlanProviderSpecificFailoverInputArray(*v)
				if err != nil {
					return err
				}
				rpufip.ProviderSpecificDetails = &providerSpecificDetails
			}
		}
	}

	return nil
}

// RecoveryPoint base class representing a recovery point.
type RecoveryPoint struct {
	autorest.Response `json:"-"`
	// Properties - Recovery point related data.
	Properties *RecoveryPointProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource Type
	Type *string `json:"type,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoveryPoint.
func (rp RecoveryPoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rp.Properties != nil {
		objectMap["properties"] = rp.Properties
	}
	if rp.Location != nil {
		objectMap["location"] = rp.Location
	}
	return json.Marshal(objectMap)
}

// RecoveryPointCollection collection of recovery point details.
type RecoveryPointCollection struct {
	autorest.Response `json:"-"`
	// Value - The recovery point details.
	Value *[]RecoveryPoint `json:"value,omitempty"`
	// NextLink - The value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// RecoveryPointCollectionIterator provides access to a complete listing of RecoveryPoint values.
type RecoveryPointCollectionIterator struct {
	i    int
	page RecoveryPointCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RecoveryPointCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RecoveryPointCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RecoveryPointCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RecoveryPointCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RecoveryPointCollectionIterator) Response() RecoveryPointCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RecoveryPointCollectionIterator) Value() RecoveryPoint {
	if !iter.page.NotDone() {
		return RecoveryPoint{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RecoveryPointCollectionIterator type.
func NewRecoveryPointCollectionIterator(page RecoveryPointCollectionPage) RecoveryPointCollectionIterator {
	return RecoveryPointCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (RPCVar RecoveryPointCollection) IsEmpty() bool {
	return RPCVar.Value == nil || len(*RPCVar.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (RPCVar RecoveryPointCollection) hasNextLink() bool {
	return RPCVar.NextLink != nil && len(*RPCVar.NextLink) != 0
}

// recoveryPointCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (RPCVar RecoveryPointCollection) recoveryPointCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !RPCVar.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(RPCVar.NextLink)))
}

// RecoveryPointCollectionPage contains a page of RecoveryPoint values.
type RecoveryPointCollectionPage struct {
	fn     func(context.Context, RecoveryPointCollection) (RecoveryPointCollection, error)
	RPCVar RecoveryPointCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RecoveryPointCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RecoveryPointCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.RPCVar)
		if err != nil {
			return err
		}
		page.RPCVar = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RecoveryPointCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RecoveryPointCollectionPage) NotDone() bool {
	return !page.RPCVar.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RecoveryPointCollectionPage) Response() RecoveryPointCollection {
	return page.RPCVar
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RecoveryPointCollectionPage) Values() []RecoveryPoint {
	if page.RPCVar.IsEmpty() {
		return nil
	}
	return *page.RPCVar.Value
}

// Creates a new instance of the RecoveryPointCollectionPage type.
func NewRecoveryPointCollectionPage(cur RecoveryPointCollection, getNextPage func(context.Context, RecoveryPointCollection) (RecoveryPointCollection, error)) RecoveryPointCollectionPage {
	return RecoveryPointCollectionPage{
		fn:     getNextPage,
		RPCVar: cur,
	}
}

// RecoveryPointProperties recovery point properties.
type RecoveryPointProperties struct {
	// RecoveryPointTime - The recovery point time.
	RecoveryPointTime *date.Time `json:"recoveryPointTime,omitempty"`
	// RecoveryPointType - The recovery point type: ApplicationConsistent, CrashConsistent.
	RecoveryPointType *string `json:"recoveryPointType,omitempty"`
	// ProviderSpecificDetails - The provider specific details for the recovery point.
	ProviderSpecificDetails BasicProviderSpecificRecoveryPointDetails `json:"providerSpecificDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for RecoveryPointProperties struct.
func (rpp *RecoveryPointProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "recoveryPointTime":
			if v != nil {
				var recoveryPointTime date.Time
				err = json.Unmarshal(*v, &recoveryPointTime)
				if err != nil {
					return err
				}
				rpp.RecoveryPointTime = &recoveryPointTime
			}
		case "recoveryPointType":
			if v != nil {
				var recoveryPointType string
				err = json.Unmarshal(*v, &recoveryPointType)
				if err != nil {
					return err
				}
				rpp.RecoveryPointType = &recoveryPointType
			}
		case "providerSpecificDetails":
			if v != nil {
				providerSpecificDetails, err := unmarshalBasicProviderSpecificRecoveryPointDetails(*v)
				if err != nil {
					return err
				}
				rpp.ProviderSpecificDetails = providerSpecificDetails
			}
		}
	}

	return nil
}

// BasicRecoveryProximityPlacementGroupCustomDetails recovery Proximity placement group custom input.
type BasicRecoveryProximityPlacementGroupCustomDetails interface {
	AsExistingRecoveryProximityPlacementGroup() (*ExistingRecoveryProximityPlacementGroup, bool)
	AsRecoveryProximityPlacementGroupCustomDetails() (*RecoveryProximityPlacementGroupCustomDetails, bool)
}

// RecoveryProximityPlacementGroupCustomDetails recovery Proximity placement group custom input.
type RecoveryProximityPlacementGroupCustomDetails struct {
	// ResourceType - Possible values include: 'ResourceTypeBasicRecoveryProximityPlacementGroupCustomDetailsResourceTypeRecoveryProximityPlacementGroupCustomDetails', 'ResourceTypeBasicRecoveryProximityPlacementGroupCustomDetailsResourceTypeExisting'
	ResourceType ResourceTypeBasicRecoveryProximityPlacementGroupCustomDetails `json:"resourceType,omitempty"`
}

func unmarshalBasicRecoveryProximityPlacementGroupCustomDetails(body []byte) (BasicRecoveryProximityPlacementGroupCustomDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["resourceType"] {
	case string(ResourceTypeBasicRecoveryProximityPlacementGroupCustomDetailsResourceTypeExisting):
		var erppg ExistingRecoveryProximityPlacementGroup
		err := json.Unmarshal(body, &erppg)
		return erppg, err
	default:
		var rppgcd RecoveryProximityPlacementGroupCustomDetails
		err := json.Unmarshal(body, &rppgcd)
		return rppgcd, err
	}
}
func unmarshalBasicRecoveryProximityPlacementGroupCustomDetailsArray(body []byte) ([]BasicRecoveryProximityPlacementGroupCustomDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rppgcdArray := make([]BasicRecoveryProximityPlacementGroupCustomDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rppgcd, err := unmarshalBasicRecoveryProximityPlacementGroupCustomDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		rppgcdArray[index] = rppgcd
	}
	return rppgcdArray, nil
}

// MarshalJSON is the custom marshaler for RecoveryProximityPlacementGroupCustomDetails.
func (rppgcd RecoveryProximityPlacementGroupCustomDetails) MarshalJSON() ([]byte, error) {
	rppgcd.ResourceType = ResourceTypeBasicRecoveryProximityPlacementGroupCustomDetailsResourceTypeRecoveryProximityPlacementGroupCustomDetails
	objectMap := make(map[string]interface{})
	if rppgcd.ResourceType != "" {
		objectMap["resourceType"] = rppgcd.ResourceType
	}
	return json.Marshal(objectMap)
}

// AsExistingRecoveryProximityPlacementGroup is the BasicRecoveryProximityPlacementGroupCustomDetails implementation for RecoveryProximityPlacementGroupCustomDetails.
func (rppgcd RecoveryProximityPlacementGroupCustomDetails) AsExistingRecoveryProximityPlacementGroup() (*ExistingRecoveryProximityPlacementGroup, bool) {
	return nil, false
}

// AsRecoveryProximityPlacementGroupCustomDetails is the BasicRecoveryProximityPlacementGroupCustomDetails implementation for RecoveryProximityPlacementGroupCustomDetails.
func (rppgcd RecoveryProximityPlacementGroupCustomDetails) AsRecoveryProximityPlacementGroupCustomDetails() (*RecoveryProximityPlacementGroupCustomDetails, bool) {
	return &rppgcd, true
}

// AsBasicRecoveryProximityPlacementGroupCustomDetails is the BasicRecoveryProximityPlacementGroupCustomDetails implementation for RecoveryProximityPlacementGroupCustomDetails.
func (rppgcd RecoveryProximityPlacementGroupCustomDetails) AsBasicRecoveryProximityPlacementGroupCustomDetails() (BasicRecoveryProximityPlacementGroupCustomDetails, bool) {
	return &rppgcd, true
}

// BasicRecoveryResourceGroupCustomDetails recovery Resource Group custom input.
type BasicRecoveryResourceGroupCustomDetails interface {
	AsExistingRecoveryRecoveryResourceGroup() (*ExistingRecoveryRecoveryResourceGroup, bool)
	AsRecoveryResourceGroupCustomDetails() (*RecoveryResourceGroupCustomDetails, bool)
}

// RecoveryResourceGroupCustomDetails recovery Resource Group custom input.
type RecoveryResourceGroupCustomDetails struct {
	// ResourceType - Possible values include: 'ResourceTypeBasicRecoveryResourceGroupCustomDetailsResourceTypeRecoveryResourceGroupCustomDetails', 'ResourceTypeBasicRecoveryResourceGroupCustomDetailsResourceTypeExisting'
	ResourceType ResourceTypeBasicRecoveryResourceGroupCustomDetails `json:"resourceType,omitempty"`
}

func unmarshalBasicRecoveryResourceGroupCustomDetails(body []byte) (BasicRecoveryResourceGroupCustomDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["resourceType"] {
	case string(ResourceTypeBasicRecoveryResourceGroupCustomDetailsResourceTypeExisting):
		var errrg ExistingRecoveryRecoveryResourceGroup
		err := json.Unmarshal(body, &errrg)
		return errrg, err
	default:
		var rrgcd RecoveryResourceGroupCustomDetails
		err := json.Unmarshal(body, &rrgcd)
		return rrgcd, err
	}
}
func unmarshalBasicRecoveryResourceGroupCustomDetailsArray(body []byte) ([]BasicRecoveryResourceGroupCustomDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rrgcdArray := make([]BasicRecoveryResourceGroupCustomDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rrgcd, err := unmarshalBasicRecoveryResourceGroupCustomDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		rrgcdArray[index] = rrgcd
	}
	return rrgcdArray, nil
}

// MarshalJSON is the custom marshaler for RecoveryResourceGroupCustomDetails.
func (rrgcd RecoveryResourceGroupCustomDetails) MarshalJSON() ([]byte, error) {
	rrgcd.ResourceType = ResourceTypeBasicRecoveryResourceGroupCustomDetailsResourceTypeRecoveryResourceGroupCustomDetails
	objectMap := make(map[string]interface{})
	if rrgcd.ResourceType != "" {
		objectMap["resourceType"] = rrgcd.ResourceType
	}
	return json.Marshal(objectMap)
}

// AsExistingRecoveryRecoveryResourceGroup is the BasicRecoveryResourceGroupCustomDetails implementation for RecoveryResourceGroupCustomDetails.
func (rrgcd RecoveryResourceGroupCustomDetails) AsExistingRecoveryRecoveryResourceGroup() (*ExistingRecoveryRecoveryResourceGroup, bool) {
	return nil, false
}

// AsRecoveryResourceGroupCustomDetails is the BasicRecoveryResourceGroupCustomDetails implementation for RecoveryResourceGroupCustomDetails.
func (rrgcd RecoveryResourceGroupCustomDetails) AsRecoveryResourceGroupCustomDetails() (*RecoveryResourceGroupCustomDetails, bool) {
	return &rrgcd, true
}

// AsBasicRecoveryResourceGroupCustomDetails is the BasicRecoveryResourceGroupCustomDetails implementation for RecoveryResourceGroupCustomDetails.
func (rrgcd RecoveryResourceGroupCustomDetails) AsBasicRecoveryResourceGroupCustomDetails() (BasicRecoveryResourceGroupCustomDetails, bool) {
	return &rrgcd, true
}

// RecoveryServicesProvider provider details.
type RecoveryServicesProvider struct {
	autorest.Response `json:"-"`
	// Properties - Provider properties.
	Properties *RecoveryServicesProviderProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource Type
	Type *string `json:"type,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoveryServicesProvider.
func (rsp RecoveryServicesProvider) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rsp.Properties != nil {
		objectMap["properties"] = rsp.Properties
	}
	if rsp.Location != nil {
		objectMap["location"] = rsp.Location
	}
	return json.Marshal(objectMap)
}

// RecoveryServicesProviderCollection collection of providers.
type RecoveryServicesProviderCollection struct {
	autorest.Response `json:"-"`
	// Value - The Servers details.
	Value *[]RecoveryServicesProvider `json:"value,omitempty"`
	// NextLink - The value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// RecoveryServicesProviderCollectionIterator provides access to a complete listing of
// RecoveryServicesProvider values.
type RecoveryServicesProviderCollectionIterator struct {
	i    int
	page RecoveryServicesProviderCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RecoveryServicesProviderCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RecoveryServicesProviderCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RecoveryServicesProviderCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RecoveryServicesProviderCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RecoveryServicesProviderCollectionIterator) Response() RecoveryServicesProviderCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RecoveryServicesProviderCollectionIterator) Value() RecoveryServicesProvider {
	if !iter.page.NotDone() {
		return RecoveryServicesProvider{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RecoveryServicesProviderCollectionIterator type.
func NewRecoveryServicesProviderCollectionIterator(page RecoveryServicesProviderCollectionPage) RecoveryServicesProviderCollectionIterator {
	return RecoveryServicesProviderCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rspc RecoveryServicesProviderCollection) IsEmpty() bool {
	return rspc.Value == nil || len(*rspc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rspc RecoveryServicesProviderCollection) hasNextLink() bool {
	return rspc.NextLink != nil && len(*rspc.NextLink) != 0
}

// recoveryServicesProviderCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rspc RecoveryServicesProviderCollection) recoveryServicesProviderCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !rspc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rspc.NextLink)))
}

// RecoveryServicesProviderCollectionPage contains a page of RecoveryServicesProvider values.
type RecoveryServicesProviderCollectionPage struct {
	fn   func(context.Context, RecoveryServicesProviderCollection) (RecoveryServicesProviderCollection, error)
	rspc RecoveryServicesProviderCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RecoveryServicesProviderCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RecoveryServicesProviderCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rspc)
		if err != nil {
			return err
		}
		page.rspc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RecoveryServicesProviderCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RecoveryServicesProviderCollectionPage) NotDone() bool {
	return !page.rspc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RecoveryServicesProviderCollectionPage) Response() RecoveryServicesProviderCollection {
	return page.rspc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RecoveryServicesProviderCollectionPage) Values() []RecoveryServicesProvider {
	if page.rspc.IsEmpty() {
		return nil
	}
	return *page.rspc.Value
}

// Creates a new instance of the RecoveryServicesProviderCollectionPage type.
func NewRecoveryServicesProviderCollectionPage(cur RecoveryServicesProviderCollection, getNextPage func(context.Context, RecoveryServicesProviderCollection) (RecoveryServicesProviderCollection, error)) RecoveryServicesProviderCollectionPage {
	return RecoveryServicesProviderCollectionPage{
		fn:   getNextPage,
		rspc: cur,
	}
}

// RecoveryServicesProviderProperties recovery services provider properties.
type RecoveryServicesProviderProperties struct {
	// FabricType - Type of the site.
	FabricType *string `json:"fabricType,omitempty"`
	// FriendlyName - Friendly name of the DRA.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProviderVersion - The provider version.
	ProviderVersion *string `json:"providerVersion,omitempty"`
	// ServerVersion - The fabric provider.
	ServerVersion *string `json:"serverVersion,omitempty"`
	// ProviderVersionState - DRA version status.
	ProviderVersionState *string `json:"providerVersionState,omitempty"`
	// ProviderVersionExpiryDate - Expiry date of the version.
	ProviderVersionExpiryDate *date.Time `json:"providerVersionExpiryDate,omitempty"`
	// FabricFriendlyName - The fabric friendly name.
	FabricFriendlyName *string `json:"fabricFriendlyName,omitempty"`
	// LastHeartBeat - Time when last heartbeat was sent by the DRA.
	LastHeartBeat *date.Time `json:"lastHeartBeat,omitempty"`
	// ConnectionStatus - A value indicating whether DRA is responsive.
	ConnectionStatus *string `json:"connectionStatus,omitempty"`
	// ProtectedItemCount - Number of protected VMs currently managed by the DRA.
	ProtectedItemCount *int32 `json:"protectedItemCount,omitempty"`
	// AllowedScenarios - The scenarios allowed on this provider.
	AllowedScenarios *[]string `json:"allowedScenarios,omitempty"`
	// HealthErrorDetails - The recovery services provider health error details.
	HealthErrorDetails *[]HealthError `json:"healthErrorDetails,omitempty"`
	// DraIdentifier - The DRA Id.
	DraIdentifier *string `json:"draIdentifier,omitempty"`
	// AuthenticationIdentityDetails - The authentication identity details.
	AuthenticationIdentityDetails *IdentityProviderDetails `json:"authenticationIdentityDetails,omitempty"`
	// ResourceAccessIdentityDetails - The resource access identity details.
	ResourceAccessIdentityDetails *IdentityProviderDetails `json:"resourceAccessIdentityDetails,omitempty"`
	// ProviderVersionDetails - The provider version details.
	ProviderVersionDetails *VersionDetails `json:"providerVersionDetails,omitempty"`
}

// BasicRecoveryVirtualNetworkCustomDetails recovery Virtual network custom input.
type BasicRecoveryVirtualNetworkCustomDetails interface {
	AsExistingRecoveryVirtualNetwork() (*ExistingRecoveryVirtualNetwork, bool)
	AsRecoveryVirtualNetworkCustomDetails() (*RecoveryVirtualNetworkCustomDetails, bool)
}

// RecoveryVirtualNetworkCustomDetails recovery Virtual network custom input.
type RecoveryVirtualNetworkCustomDetails struct {
	// ResourceType - Possible values include: 'ResourceTypeBasicRecoveryVirtualNetworkCustomDetailsResourceTypeRecoveryVirtualNetworkCustomDetails', 'ResourceTypeBasicRecoveryVirtualNetworkCustomDetailsResourceTypeExisting'
	ResourceType ResourceTypeBasicRecoveryVirtualNetworkCustomDetails `json:"resourceType,omitempty"`
}

func unmarshalBasicRecoveryVirtualNetworkCustomDetails(body []byte) (BasicRecoveryVirtualNetworkCustomDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["resourceType"] {
	case string(ResourceTypeBasicRecoveryVirtualNetworkCustomDetailsResourceTypeExisting):
		var ervn ExistingRecoveryVirtualNetwork
		err := json.Unmarshal(body, &ervn)
		return ervn, err
	default:
		var rvncd RecoveryVirtualNetworkCustomDetails
		err := json.Unmarshal(body, &rvncd)
		return rvncd, err
	}
}
func unmarshalBasicRecoveryVirtualNetworkCustomDetailsArray(body []byte) ([]BasicRecoveryVirtualNetworkCustomDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rvncdArray := make([]BasicRecoveryVirtualNetworkCustomDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rvncd, err := unmarshalBasicRecoveryVirtualNetworkCustomDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		rvncdArray[index] = rvncd
	}
	return rvncdArray, nil
}

// MarshalJSON is the custom marshaler for RecoveryVirtualNetworkCustomDetails.
func (rvncd RecoveryVirtualNetworkCustomDetails) MarshalJSON() ([]byte, error) {
	rvncd.ResourceType = ResourceTypeBasicRecoveryVirtualNetworkCustomDetailsResourceTypeRecoveryVirtualNetworkCustomDetails
	objectMap := make(map[string]interface{})
	if rvncd.ResourceType != "" {
		objectMap["resourceType"] = rvncd.ResourceType
	}
	return json.Marshal(objectMap)
}

// AsExistingRecoveryVirtualNetwork is the BasicRecoveryVirtualNetworkCustomDetails implementation for RecoveryVirtualNetworkCustomDetails.
func (rvncd RecoveryVirtualNetworkCustomDetails) AsExistingRecoveryVirtualNetwork() (*ExistingRecoveryVirtualNetwork, bool) {
	return nil, false
}

// AsRecoveryVirtualNetworkCustomDetails is the BasicRecoveryVirtualNetworkCustomDetails implementation for RecoveryVirtualNetworkCustomDetails.
func (rvncd RecoveryVirtualNetworkCustomDetails) AsRecoveryVirtualNetworkCustomDetails() (*RecoveryVirtualNetworkCustomDetails, bool) {
	return &rvncd, true
}

// AsBasicRecoveryVirtualNetworkCustomDetails is the BasicRecoveryVirtualNetworkCustomDetails implementation for RecoveryVirtualNetworkCustomDetails.
func (rvncd RecoveryVirtualNetworkCustomDetails) AsBasicRecoveryVirtualNetworkCustomDetails() (BasicRecoveryVirtualNetworkCustomDetails, bool) {
	return &rvncd, true
}

// RemoveDisksInput input for remove disk(s) operation.
type RemoveDisksInput struct {
	// Properties - Remove disk input properties.
	Properties *RemoveDisksInputProperties `json:"properties,omitempty"`
}

// RemoveDisksInputProperties remove Disk input properties.
type RemoveDisksInputProperties struct {
	// ProviderSpecificDetails - The ReplicationProviderInput. For HyperVReplicaAzure provider, it will be AzureEnableProtectionInput object. For San provider, it will be SanEnableProtectionInput object. For HyperVReplicaAzure provider, it can be null.
	ProviderSpecificDetails BasicRemoveDisksProviderSpecificInput `json:"providerSpecificDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for RemoveDisksInputProperties struct.
func (rdip *RemoveDisksInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "providerSpecificDetails":
			if v != nil {
				providerSpecificDetails, err := unmarshalBasicRemoveDisksProviderSpecificInput(*v)
				if err != nil {
					return err
				}
				rdip.ProviderSpecificDetails = providerSpecificDetails
			}
		}
	}

	return nil
}

// BasicRemoveDisksProviderSpecificInput remove Disk provider specific input.
type BasicRemoveDisksProviderSpecificInput interface {
	AsA2ARemoveDisksInput() (*A2ARemoveDisksInput, bool)
	AsRemoveDisksProviderSpecificInput() (*RemoveDisksProviderSpecificInput, bool)
}

// RemoveDisksProviderSpecificInput remove Disk provider specific input.
type RemoveDisksProviderSpecificInput struct {
	// InstanceType - Possible values include: 'InstanceTypeBasicRemoveDisksProviderSpecificInputInstanceTypeRemoveDisksProviderSpecificInput', 'InstanceTypeBasicRemoveDisksProviderSpecificInputInstanceTypeA2A'
	InstanceType InstanceTypeBasicRemoveDisksProviderSpecificInput `json:"instanceType,omitempty"`
}

func unmarshalBasicRemoveDisksProviderSpecificInput(body []byte) (BasicRemoveDisksProviderSpecificInput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeBasicRemoveDisksProviderSpecificInputInstanceTypeA2A):
		var ardi A2ARemoveDisksInput
		err := json.Unmarshal(body, &ardi)
		return ardi, err
	default:
		var rdpsi RemoveDisksProviderSpecificInput
		err := json.Unmarshal(body, &rdpsi)
		return rdpsi, err
	}
}
func unmarshalBasicRemoveDisksProviderSpecificInputArray(body []byte) ([]BasicRemoveDisksProviderSpecificInput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rdpsiArray := make([]BasicRemoveDisksProviderSpecificInput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rdpsi, err := unmarshalBasicRemoveDisksProviderSpecificInput(*rawMessage)
		if err != nil {
			return nil, err
		}
		rdpsiArray[index] = rdpsi
	}
	return rdpsiArray, nil
}

// MarshalJSON is the custom marshaler for RemoveDisksProviderSpecificInput.
func (rdpsi RemoveDisksProviderSpecificInput) MarshalJSON() ([]byte, error) {
	rdpsi.InstanceType = InstanceTypeBasicRemoveDisksProviderSpecificInputInstanceTypeRemoveDisksProviderSpecificInput
	objectMap := make(map[string]interface{})
	if rdpsi.InstanceType != "" {
		objectMap["instanceType"] = rdpsi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2ARemoveDisksInput is the BasicRemoveDisksProviderSpecificInput implementation for RemoveDisksProviderSpecificInput.
func (rdpsi RemoveDisksProviderSpecificInput) AsA2ARemoveDisksInput() (*A2ARemoveDisksInput, bool) {
	return nil, false
}

// AsRemoveDisksProviderSpecificInput is the BasicRemoveDisksProviderSpecificInput implementation for RemoveDisksProviderSpecificInput.
func (rdpsi RemoveDisksProviderSpecificInput) AsRemoveDisksProviderSpecificInput() (*RemoveDisksProviderSpecificInput, bool) {
	return &rdpsi, true
}

// AsBasicRemoveDisksProviderSpecificInput is the BasicRemoveDisksProviderSpecificInput implementation for RemoveDisksProviderSpecificInput.
func (rdpsi RemoveDisksProviderSpecificInput) AsBasicRemoveDisksProviderSpecificInput() (BasicRemoveDisksProviderSpecificInput, bool) {
	return &rdpsi, true
}

// RemoveProtectionContainerMappingInput container unpairing input.
type RemoveProtectionContainerMappingInput struct {
	// Properties - Configure protection input properties.
	Properties *RemoveProtectionContainerMappingInputProperties `json:"properties,omitempty"`
}

// RemoveProtectionContainerMappingInputProperties unpairing input properties.
type RemoveProtectionContainerMappingInputProperties struct {
	// ProviderSpecificInput - Provider specific input for unpairing.
	ProviderSpecificInput *ReplicationProviderContainerUnmappingInput `json:"providerSpecificInput,omitempty"`
}

// RenewCertificateInput certificate renewal input.
type RenewCertificateInput struct {
	// Properties - Renew certificate input properties.
	Properties *RenewCertificateInputProperties `json:"properties,omitempty"`
}

// RenewCertificateInputProperties renew Certificate input properties.
type RenewCertificateInputProperties struct {
	// RenewCertificateType - Renew certificate type.
	RenewCertificateType *string `json:"renewCertificateType,omitempty"`
}

// ReplicationAgentDetails replication agent details.
type ReplicationAgentDetails struct {
	// ID - READ-ONLY; The replication agent Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The replication agent name.
	Name *string `json:"name,omitempty"`
	// Version - READ-ONLY; The replication agent version.
	Version *string `json:"version,omitempty"`
	// LastHeartbeatUtc - READ-ONLY; The last heartbeat received from the replication agent.
	LastHeartbeatUtc *date.Time `json:"lastHeartbeatUtc,omitempty"`
	// Health - READ-ONLY; The health of the replication agent. Possible values include: 'ProtectionHealthNone', 'ProtectionHealthNormal', 'ProtectionHealthWarning', 'ProtectionHealthCritical'
	Health ProtectionHealth `json:"health,omitempty"`
	// HealthErrors - READ-ONLY; The health errors.
	HealthErrors *[]HealthError `json:"healthErrors,omitempty"`
}

// ReplicationEligibilityResults replication eligibility results response model.
type ReplicationEligibilityResults struct {
	autorest.Response `json:"-"`
	// Name - READ-ONLY; Gets the name of this object.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Gets the object type.
	Type *string `json:"type,omitempty"`
	// ID - READ-ONLY; Gets Unique ARM identifier for this object.
	ID *string `json:"id,omitempty"`
	// Properties - READ-ONLY; Gets properties model for replication eligibility results API.
	Properties *ReplicationEligibilityResultsProperties `json:"properties,omitempty"`
}

// ReplicationEligibilityResultsCollection replication eligibility results collection response model.
type ReplicationEligibilityResultsCollection struct {
	autorest.Response `json:"-"`
	// Value - The replication eligibility results details.
	Value *[]ReplicationEligibilityResults `json:"value,omitempty"`
}

// ReplicationEligibilityResultsErrorInfo error model that can be exposed to the user.
type ReplicationEligibilityResultsErrorInfo struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// PossibleCauses - READ-ONLY; The possible causes.
	PossibleCauses *string `json:"possibleCauses,omitempty"`
	// RecommendedAction - READ-ONLY; The recommended action.
	RecommendedAction *string `json:"recommendedAction,omitempty"`
	// Status - READ-ONLY; The error status.
	Status *string `json:"status,omitempty"`
}

// ReplicationEligibilityResultsProperties properties model for replication eligibility results API.
type ReplicationEligibilityResultsProperties struct {
	// ClientRequestID - READ-ONLY; The client request Id.
	ClientRequestID *string `json:"clientRequestId,omitempty"`
	// Errors - The error details.
	Errors *[]ReplicationEligibilityResultsErrorInfo `json:"errors,omitempty"`
}

// MarshalJSON is the custom marshaler for ReplicationEligibilityResultsProperties.
func (rerp ReplicationEligibilityResultsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rerp.Errors != nil {
		objectMap["errors"] = rerp.Errors
	}
	return json.Marshal(objectMap)
}

// ReplicationFabricsCheckConsistencyFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationFabricsCheckConsistencyFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ReplicationFabricsClient) (Fabric, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ReplicationFabricsCheckConsistencyFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ReplicationFabricsCheckConsistencyFuture.Result.
func (future *ReplicationFabricsCheckConsistencyFuture) result(client ReplicationFabricsClient) (f Fabric, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationFabricsCheckConsistencyFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationFabricsCheckConsistencyFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if f.Response.Response, err = future.GetResult(sender); err == nil && f.Response.Response.StatusCode != http.StatusNoContent {
		f, err = client.CheckConsistencyResponder(f.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationFabricsCheckConsistencyFuture", "Result", f.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationFabricsCreateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationFabricsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ReplicationFabricsClient) (Fabric, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ReplicationFabricsCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ReplicationFabricsCreateFuture.Result.
func (future *ReplicationFabricsCreateFuture) result(client ReplicationFabricsClient) (f Fabric, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationFabricsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationFabricsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if f.Response.Response, err = future.GetResult(sender); err == nil && f.Response.Response.StatusCode != http.StatusNoContent {
		f, err = client.CreateResponder(f.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationFabricsCreateFuture", "Result", f.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationFabricsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationFabricsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ReplicationFabricsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ReplicationFabricsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ReplicationFabricsDeleteFuture.Result.
func (future *ReplicationFabricsDeleteFuture) result(client ReplicationFabricsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationFabricsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationFabricsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ReplicationFabricsMigrateToAadFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationFabricsMigrateToAadFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ReplicationFabricsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ReplicationFabricsMigrateToAadFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ReplicationFabricsMigrateToAadFuture.Result.
func (future *ReplicationFabricsMigrateToAadFuture) result(client ReplicationFabricsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationFabricsMigrateToAadFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationFabricsMigrateToAadFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ReplicationFabricsPurgeFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReplicationFabricsPurgeFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ReplicationFabricsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ReplicationFabricsPurgeFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ReplicationFabricsPurgeFuture.Result.
func (future *ReplicationFabricsPurgeFuture) result(client ReplicationFabricsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationFabricsPurgeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationFabricsPurgeFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ReplicationFabricsReassociateGatewayFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationFabricsReassociateGatewayFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ReplicationFabricsClient) (Fabric, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ReplicationFabricsReassociateGatewayFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ReplicationFabricsReassociateGatewayFuture.Result.
func (future *ReplicationFabricsReassociateGatewayFuture) result(client ReplicationFabricsClient) (f Fabric, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationFabricsReassociateGatewayFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationFabricsReassociateGatewayFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if f.Response.Response, err = future.GetResult(sender); err == nil && f.Response.Response.StatusCode != http.StatusNoContent {
		f, err = client.ReassociateGatewayResponder(f.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationFabricsReassociateGatewayFuture", "Result", f.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationFabricsRenewCertificateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationFabricsRenewCertificateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ReplicationFabricsClient) (Fabric, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ReplicationFabricsRenewCertificateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ReplicationFabricsRenewCertificateFuture.Result.
func (future *ReplicationFabricsRenewCertificateFuture) result(client ReplicationFabricsClient) (f Fabric, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationFabricsRenewCertificateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationFabricsRenewCertificateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if f.Response.Response, err = future.GetResult(sender); err == nil && f.Response.Response.StatusCode != http.StatusNoContent {
		f, err = client.RenewCertificateResponder(f.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationFabricsRenewCertificateFuture", "Result", f.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationGroupDetails replication group details. This will be used in case of San and Wvr.
type ReplicationGroupDetails struct {
	// InstanceType - Possible values include: 'InstanceTypeConfigurationSettings', 'InstanceTypeHyperVVirtualMachine', 'InstanceTypeReplicationGroupDetails', 'InstanceTypeVmmVirtualMachine', 'InstanceTypeVMwareVirtualMachine'
	InstanceType InstanceTypeBasicConfigurationSettings `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for ReplicationGroupDetails.
func (rgd ReplicationGroupDetails) MarshalJSON() ([]byte, error) {
	rgd.InstanceType = InstanceTypeReplicationGroupDetails
	objectMap := make(map[string]interface{})
	if rgd.InstanceType != "" {
		objectMap["instanceType"] = rgd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVVirtualMachineDetails is the BasicConfigurationSettings implementation for ReplicationGroupDetails.
func (rgd ReplicationGroupDetails) AsHyperVVirtualMachineDetails() (*HyperVVirtualMachineDetails, bool) {
	return nil, false
}

// AsReplicationGroupDetails is the BasicConfigurationSettings implementation for ReplicationGroupDetails.
func (rgd ReplicationGroupDetails) AsReplicationGroupDetails() (*ReplicationGroupDetails, bool) {
	return &rgd, true
}

// AsVmmVirtualMachineDetails is the BasicConfigurationSettings implementation for ReplicationGroupDetails.
func (rgd ReplicationGroupDetails) AsVmmVirtualMachineDetails() (*VmmVirtualMachineDetails, bool) {
	return nil, false
}

// AsVMwareVirtualMachineDetails is the BasicConfigurationSettings implementation for ReplicationGroupDetails.
func (rgd ReplicationGroupDetails) AsVMwareVirtualMachineDetails() (*VMwareVirtualMachineDetails, bool) {
	return nil, false
}

// AsConfigurationSettings is the BasicConfigurationSettings implementation for ReplicationGroupDetails.
func (rgd ReplicationGroupDetails) AsConfigurationSettings() (*ConfigurationSettings, bool) {
	return nil, false
}

// AsBasicConfigurationSettings is the BasicConfigurationSettings implementation for ReplicationGroupDetails.
func (rgd ReplicationGroupDetails) AsBasicConfigurationSettings() (BasicConfigurationSettings, bool) {
	return &rgd, true
}

// ReplicationJobsCancelFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReplicationJobsCancelFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ReplicationJobsClient) (Job, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ReplicationJobsCancelFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ReplicationJobsCancelFuture.Result.
func (future *ReplicationJobsCancelFuture) result(client ReplicationJobsClient) (j Job, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationJobsCancelFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationJobsCancelFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if j.Response.Response, err = future.GetResult(sender); err == nil && j.Response.Response.StatusCode != http.StatusNoContent {
		j, err = client.CancelResponder(j.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationJobsCancelFuture", "Result", j.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationJobsExportFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReplicationJobsExportFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ReplicationJobsClient) (Job, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ReplicationJobsExportFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ReplicationJobsExportFuture.Result.
func (future *ReplicationJobsExportFuture) result(client ReplicationJobsClient) (j Job, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationJobsExportFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationJobsExportFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if j.Response.Response, err = future.GetResult(sender); err == nil && j.Response.Response.StatusCode != http.StatusNoContent {
		j, err = client.ExportResponder(j.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationJobsExportFuture", "Result", j.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationJobsRestartFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReplicationJobsRestartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ReplicationJobsClient) (Job, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ReplicationJobsRestartFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ReplicationJobsRestartFuture.Result.
func (future *ReplicationJobsRestartFuture) result(client ReplicationJobsClient) (j Job, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationJobsRestartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationJobsRestartFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if j.Response.Response, err = future.GetResult(sender); err == nil && j.Response.Response.StatusCode != http.StatusNoContent {
		j, err = client.RestartResponder(j.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationJobsRestartFuture", "Result", j.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationJobsResumeFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReplicationJobsResumeFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ReplicationJobsClient) (Job, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ReplicationJobsResumeFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ReplicationJobsResumeFuture.Result.
func (future *ReplicationJobsResumeFuture) result(client ReplicationJobsClient) (j Job, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationJobsResumeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationJobsResumeFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if j.Response.Response, err = future.GetResult(sender); err == nil && j.Response.Response.StatusCode != http.StatusNoContent {
		j, err = client.ResumeResponder(j.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationJobsResumeFuture", "Result", j.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationMigrationItemsCreateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationMigrationItemsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ReplicationMigrationItemsClient) (MigrationItem, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ReplicationMigrationItemsCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ReplicationMigrationItemsCreateFuture.Result.
func (future *ReplicationMigrationItemsCreateFuture) result(client ReplicationMigrationItemsClient) (mi MigrationItem, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationMigrationItemsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationMigrationItemsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mi.Response.Response, err = future.GetResult(sender); err == nil && mi.Response.Response.StatusCode != http.StatusNoContent {
		mi, err = client.CreateResponder(mi.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationMigrationItemsCreateFuture", "Result", mi.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationMigrationItemsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationMigrationItemsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ReplicationMigrationItemsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ReplicationMigrationItemsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ReplicationMigrationItemsDeleteFuture.Result.
func (future *ReplicationMigrationItemsDeleteFuture) result(client ReplicationMigrationItemsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationMigrationItemsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationMigrationItemsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ReplicationMigrationItemsMigrateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationMigrationItemsMigrateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ReplicationMigrationItemsClient) (MigrationItem, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ReplicationMigrationItemsMigrateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ReplicationMigrationItemsMigrateFuture.Result.
func (future *ReplicationMigrationItemsMigrateFuture) result(client ReplicationMigrationItemsClient) (mi MigrationItem, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationMigrationItemsMigrateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationMigrationItemsMigrateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mi.Response.Response, err = future.GetResult(sender); err == nil && mi.Response.Response.StatusCode != http.StatusNoContent {
		mi, err = client.MigrateResponder(mi.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationMigrationItemsMigrateFuture", "Result", mi.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationMigrationItemsTestMigrateCleanupFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type ReplicationMigrationItemsTestMigrateCleanupFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ReplicationMigrationItemsClient) (MigrationItem, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ReplicationMigrationItemsTestMigrateCleanupFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ReplicationMigrationItemsTestMigrateCleanupFuture.Result.
func (future *ReplicationMigrationItemsTestMigrateCleanupFuture) result(client ReplicationMigrationItemsClient) (mi MigrationItem, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationMigrationItemsTestMigrateCleanupFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationMigrationItemsTestMigrateCleanupFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mi.Response.Response, err = future.GetResult(sender); err == nil && mi.Response.Response.StatusCode != http.StatusNoContent {
		mi, err = client.TestMigrateCleanupResponder(mi.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationMigrationItemsTestMigrateCleanupFuture", "Result", mi.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationMigrationItemsTestMigrateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationMigrationItemsTestMigrateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ReplicationMigrationItemsClient) (MigrationItem, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ReplicationMigrationItemsTestMigrateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ReplicationMigrationItemsTestMigrateFuture.Result.
func (future *ReplicationMigrationItemsTestMigrateFuture) result(client ReplicationMigrationItemsClient) (mi MigrationItem, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationMigrationItemsTestMigrateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationMigrationItemsTestMigrateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mi.Response.Response, err = future.GetResult(sender); err == nil && mi.Response.Response.StatusCode != http.StatusNoContent {
		mi, err = client.TestMigrateResponder(mi.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationMigrationItemsTestMigrateFuture", "Result", mi.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationMigrationItemsUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationMigrationItemsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ReplicationMigrationItemsClient) (MigrationItem, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ReplicationMigrationItemsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ReplicationMigrationItemsUpdateFuture.Result.
func (future *ReplicationMigrationItemsUpdateFuture) result(client ReplicationMigrationItemsClient) (mi MigrationItem, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationMigrationItemsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationMigrationItemsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mi.Response.Response, err = future.GetResult(sender); err == nil && mi.Response.Response.StatusCode != http.StatusNoContent {
		mi, err = client.UpdateResponder(mi.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationMigrationItemsUpdateFuture", "Result", mi.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationNetworkMappingsCreateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationNetworkMappingsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ReplicationNetworkMappingsClient) (NetworkMapping, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ReplicationNetworkMappingsCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ReplicationNetworkMappingsCreateFuture.Result.
func (future *ReplicationNetworkMappingsCreateFuture) result(client ReplicationNetworkMappingsClient) (nm NetworkMapping, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationNetworkMappingsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationNetworkMappingsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if nm.Response.Response, err = future.GetResult(sender); err == nil && nm.Response.Response.StatusCode != http.StatusNoContent {
		nm, err = client.CreateResponder(nm.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationNetworkMappingsCreateFuture", "Result", nm.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationNetworkMappingsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationNetworkMappingsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ReplicationNetworkMappingsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ReplicationNetworkMappingsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ReplicationNetworkMappingsDeleteFuture.Result.
func (future *ReplicationNetworkMappingsDeleteFuture) result(client ReplicationNetworkMappingsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationNetworkMappingsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationNetworkMappingsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ReplicationNetworkMappingsUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationNetworkMappingsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ReplicationNetworkMappingsClient) (NetworkMapping, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ReplicationNetworkMappingsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ReplicationNetworkMappingsUpdateFuture.Result.
func (future *ReplicationNetworkMappingsUpdateFuture) result(client ReplicationNetworkMappingsClient) (nm NetworkMapping, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationNetworkMappingsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationNetworkMappingsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if nm.Response.Response, err = future.GetResult(sender); err == nil && nm.Response.Response.StatusCode != http.StatusNoContent {
		nm, err = client.UpdateResponder(nm.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationNetworkMappingsUpdateFuture", "Result", nm.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationPoliciesCreateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationPoliciesCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ReplicationPoliciesClient) (Policy, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ReplicationPoliciesCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ReplicationPoliciesCreateFuture.Result.
func (future *ReplicationPoliciesCreateFuture) result(client ReplicationPoliciesClient) (p Policy, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationPoliciesCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationPoliciesCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if p.Response.Response, err = future.GetResult(sender); err == nil && p.Response.Response.StatusCode != http.StatusNoContent {
		p, err = client.CreateResponder(p.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationPoliciesCreateFuture", "Result", p.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationPoliciesDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationPoliciesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ReplicationPoliciesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ReplicationPoliciesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ReplicationPoliciesDeleteFuture.Result.
func (future *ReplicationPoliciesDeleteFuture) result(client ReplicationPoliciesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationPoliciesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationPoliciesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ReplicationPoliciesUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationPoliciesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ReplicationPoliciesClient) (Policy, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ReplicationPoliciesUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ReplicationPoliciesUpdateFuture.Result.
func (future *ReplicationPoliciesUpdateFuture) result(client ReplicationPoliciesClient) (p Policy, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationPoliciesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationPoliciesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if p.Response.Response, err = future.GetResult(sender); err == nil && p.Response.Response.StatusCode != http.StatusNoContent {
		p, err = client.UpdateResponder(p.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationPoliciesUpdateFuture", "Result", p.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationProtectedItem replication protected item.
type ReplicationProtectedItem struct {
	autorest.Response `json:"-"`
	// Properties - The custom data.
	Properties *ReplicationProtectedItemProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource Type
	Type *string `json:"type,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for ReplicationProtectedItem.
func (rpi ReplicationProtectedItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rpi.Properties != nil {
		objectMap["properties"] = rpi.Properties
	}
	if rpi.Location != nil {
		objectMap["location"] = rpi.Location
	}
	return json.Marshal(objectMap)
}

// ReplicationProtectedItemCollection replication protected item collection.
type ReplicationProtectedItemCollection struct {
	autorest.Response `json:"-"`
	// Value - The Replication protected item details.
	Value *[]ReplicationProtectedItem `json:"value,omitempty"`
	// NextLink - The value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// ReplicationProtectedItemCollectionIterator provides access to a complete listing of
// ReplicationProtectedItem values.
type ReplicationProtectedItemCollectionIterator struct {
	i    int
	page ReplicationProtectedItemCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ReplicationProtectedItemCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReplicationProtectedItemCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ReplicationProtectedItemCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ReplicationProtectedItemCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ReplicationProtectedItemCollectionIterator) Response() ReplicationProtectedItemCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ReplicationProtectedItemCollectionIterator) Value() ReplicationProtectedItem {
	if !iter.page.NotDone() {
		return ReplicationProtectedItem{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ReplicationProtectedItemCollectionIterator type.
func NewReplicationProtectedItemCollectionIterator(page ReplicationProtectedItemCollectionPage) ReplicationProtectedItemCollectionIterator {
	return ReplicationProtectedItemCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rpic ReplicationProtectedItemCollection) IsEmpty() bool {
	return rpic.Value == nil || len(*rpic.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rpic ReplicationProtectedItemCollection) hasNextLink() bool {
	return rpic.NextLink != nil && len(*rpic.NextLink) != 0
}

// replicationProtectedItemCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rpic ReplicationProtectedItemCollection) replicationProtectedItemCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !rpic.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rpic.NextLink)))
}

// ReplicationProtectedItemCollectionPage contains a page of ReplicationProtectedItem values.
type ReplicationProtectedItemCollectionPage struct {
	fn   func(context.Context, ReplicationProtectedItemCollection) (ReplicationProtectedItemCollection, error)
	rpic ReplicationProtectedItemCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ReplicationProtectedItemCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReplicationProtectedItemCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rpic)
		if err != nil {
			return err
		}
		page.rpic = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ReplicationProtectedItemCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ReplicationProtectedItemCollectionPage) NotDone() bool {
	return !page.rpic.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ReplicationProtectedItemCollectionPage) Response() ReplicationProtectedItemCollection {
	return page.rpic
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ReplicationProtectedItemCollectionPage) Values() []ReplicationProtectedItem {
	if page.rpic.IsEmpty() {
		return nil
	}
	return *page.rpic.Value
}

// Creates a new instance of the ReplicationProtectedItemCollectionPage type.
func NewReplicationProtectedItemCollectionPage(cur ReplicationProtectedItemCollection, getNextPage func(context.Context, ReplicationProtectedItemCollection) (ReplicationProtectedItemCollection, error)) ReplicationProtectedItemCollectionPage {
	return ReplicationProtectedItemCollectionPage{
		fn:   getNextPage,
		rpic: cur,
	}
}

// ReplicationProtectedItemProperties replication protected item custom data details.
type ReplicationProtectedItemProperties struct {
	// FriendlyName - The name.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectedItemType - The type of protected item type.
	ProtectedItemType *string `json:"protectedItemType,omitempty"`
	// ProtectableItemID - The protected item ARM Id.
	ProtectableItemID *string `json:"protectableItemId,omitempty"`
	// RecoveryServicesProviderID - The recovery provider ARM Id.
	RecoveryServicesProviderID *string `json:"recoveryServicesProviderId,omitempty"`
	// PrimaryFabricFriendlyName - The friendly name of the primary fabric.
	PrimaryFabricFriendlyName *string `json:"primaryFabricFriendlyName,omitempty"`
	// PrimaryFabricProvider - The fabric provider of the primary fabric.
	PrimaryFabricProvider *string `json:"primaryFabricProvider,omitempty"`
	// RecoveryFabricFriendlyName - The friendly name of recovery fabric.
	RecoveryFabricFriendlyName *string `json:"recoveryFabricFriendlyName,omitempty"`
	// RecoveryFabricID - The Arm Id of recovery fabric.
	RecoveryFabricID *string `json:"recoveryFabricId,omitempty"`
	// PrimaryProtectionContainerFriendlyName - The name of primary protection container friendly name.
	PrimaryProtectionContainerFriendlyName *string `json:"primaryProtectionContainerFriendlyName,omitempty"`
	// RecoveryProtectionContainerFriendlyName - The name of recovery container friendly name.
	RecoveryProtectionContainerFriendlyName *string `json:"recoveryProtectionContainerFriendlyName,omitempty"`
	// ProtectionState - The protection status.
	ProtectionState *string `json:"protectionState,omitempty"`
	// ProtectionStateDescription - The protection state description.
	ProtectionStateDescription *string `json:"protectionStateDescription,omitempty"`
	// ActiveLocation - The Current active location of the PE.
	ActiveLocation *string `json:"activeLocation,omitempty"`
	// TestFailoverState - The Test failover state.
	TestFailoverState *string `json:"testFailoverState,omitempty"`
	// TestFailoverStateDescription - The Test failover state description.
	TestFailoverStateDescription *string `json:"testFailoverStateDescription,omitempty"`
	// AllowedOperations - The allowed operations on the Replication protected item.
	AllowedOperations *[]string `json:"allowedOperations,omitempty"`
	// ReplicationHealth - The consolidated protection health for the VM taking any issues with SRS as well as all the replication units associated with the VM's replication group into account. This is a string representation of the ProtectionHealth enumeration.
	ReplicationHealth *string `json:"replicationHealth,omitempty"`
	// FailoverHealth - The consolidated failover health for the VM.
	FailoverHealth *string `json:"failoverHealth,omitempty"`
	// HealthErrors - List of health errors.
	HealthErrors *[]HealthError `json:"healthErrors,omitempty"`
	// PolicyID - The ID of Policy governing this PE.
	PolicyID *string `json:"policyId,omitempty"`
	// PolicyFriendlyName - The name of Policy governing this PE.
	PolicyFriendlyName *string `json:"policyFriendlyName,omitempty"`
	// LastSuccessfulFailoverTime - The Last successful failover time.
	LastSuccessfulFailoverTime *date.Time `json:"lastSuccessfulFailoverTime,omitempty"`
	// LastSuccessfulTestFailoverTime - The Last successful test failover time.
	LastSuccessfulTestFailoverTime *date.Time `json:"lastSuccessfulTestFailoverTime,omitempty"`
	// CurrentScenario - The current scenario.
	CurrentScenario *CurrentScenarioDetails `json:"currentScenario,omitempty"`
	// FailoverRecoveryPointID - The recovery point ARM Id to which the Vm was failed over.
	FailoverRecoveryPointID *string `json:"failoverRecoveryPointId,omitempty"`
	// ProviderSpecificDetails - The Replication provider custom settings.
	ProviderSpecificDetails BasicReplicationProviderSpecificSettings `json:"providerSpecificDetails,omitempty"`
	// RecoveryContainerID - The recovery container Id.
	RecoveryContainerID *string `json:"recoveryContainerId,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ReplicationProtectedItemProperties struct.
func (rpip *ReplicationProtectedItemProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "friendlyName":
			if v != nil {
				var friendlyName string
				err = json.Unmarshal(*v, &friendlyName)
				if err != nil {
					return err
				}
				rpip.FriendlyName = &friendlyName
			}
		case "protectedItemType":
			if v != nil {
				var protectedItemType string
				err = json.Unmarshal(*v, &protectedItemType)
				if err != nil {
					return err
				}
				rpip.ProtectedItemType = &protectedItemType
			}
		case "protectableItemId":
			if v != nil {
				var protectableItemID string
				err = json.Unmarshal(*v, &protectableItemID)
				if err != nil {
					return err
				}
				rpip.ProtectableItemID = &protectableItemID
			}
		case "recoveryServicesProviderId":
			if v != nil {
				var recoveryServi