package backup

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/recoveryservices/mgmt/2016-12-01/backup"

// AzureBackupServerContainer azureBackupServer (DPMVenus) workload-specific protection container.
type AzureBackupServerContainer struct {
	// CanReRegister - Specifies whether the container is re-registrable.
	CanReRegister *bool `json:"canReRegister,omitempty"`
	// ContainerID - ID of container.
	ContainerID *string `json:"containerId,omitempty"`
	// ProtectedItemCount - Number of protected items in the BackupEngine
	ProtectedItemCount *int64 `json:"protectedItemCount,omitempty"`
	// DpmAgentVersion - Backup engine Agent version
	DpmAgentVersion *string `json:"dpmAgentVersion,omitempty"`
	// DpmServers - List of BackupEngines protecting the container
	DpmServers *[]string `json:"dpmServers,omitempty"`
	// UpgradeAvailable - To check if upgrade available
	UpgradeAvailable *bool `json:"upgradeAvailable,omitempty"`
	// ProtectionStatus - Protection status of the container.
	ProtectionStatus *string `json:"protectionStatus,omitempty"`
	// ExtendedInfo - Extended Info of the container.
	ExtendedInfo *DPMContainerExtendedInfo `json:"extendedInfo,omitempty"`
	// FriendlyName - Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - Type of backup management for the container. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// RegistrationStatus - Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
	// HealthStatus - Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// ContainerType - Possible values include: 'ContainerTypeProtectionContainer', 'ContainerTypeAzureBackupServerContainer1', 'ContainerTypeMicrosoftClassicComputevirtualMachines', 'ContainerTypeMicrosoftComputevirtualMachines', 'ContainerTypeSQLAGWorkLoadContainer1', 'ContainerTypeAzureSQLContainer1', 'ContainerTypeStorageContainer1', 'ContainerTypeVMAppContainer1', 'ContainerTypeAzureWorkloadContainer', 'ContainerTypeDPMContainer1', 'ContainerTypeGenericContainer1', 'ContainerTypeIaaSVMContainer', 'ContainerTypeWindows1'
	ContainerType ContainerTypeBasicProtectionContainer `json:"containerType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBackupServerContainer.
func (absc AzureBackupServerContainer) MarshalJSON() ([]byte, error) {
	absc.ContainerType = ContainerTypeAzureBackupServerContainer1
	objectMap := make(map[string]interface{})
	if absc.CanReRegister != nil {
		objectMap["canReRegister"] = absc.CanReRegister
	}
	if absc.ContainerID != nil {
		objectMap["containerId"] = absc.ContainerID
	}
	if absc.ProtectedItemCount != nil {
		objectMap["protectedItemCount"] = absc.ProtectedItemCount
	}
	if absc.DpmAgentVersion != nil {
		objectMap["dpmAgentVersion"] = absc.DpmAgentVersion
	}
	if absc.DpmServers != nil {
		objectMap["dpmServers"] = absc.DpmServers
	}
	if absc.UpgradeAvailable != nil {
		objectMap["upgradeAvailable"] = absc.UpgradeAvailable
	}
	if absc.ProtectionStatus != nil {
		objectMap["protectionStatus"] = absc.ProtectionStatus
	}
	if absc.ExtendedInfo != nil {
		objectMap["extendedInfo"] = absc.ExtendedInfo
	}
	if absc.FriendlyName != nil {
		objectMap["friendlyName"] = absc.FriendlyName
	}
	if absc.BackupManagementType != "" {
		objectMap["backupManagementType"] = absc.BackupManagementType
	}
	if absc.RegistrationStatus != nil {
		objectMap["registrationStatus"] = absc.RegistrationStatus
	}
	if absc.HealthStatus != nil {
		objectMap["healthStatus"] = absc.HealthStatus
	}
	if absc.ContainerType != "" {
		objectMap["containerType"] = absc.ContainerType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupServerContainer is the BasicProtectionContainer implementation for AzureBackupServerContainer.
func (absc AzureBackupServerContainer) AsAzureBackupServerContainer() (*AzureBackupServerContainer, bool) {
	return &absc, true
}

// AsAzureIaaSClassicComputeVMContainer is the BasicProtectionContainer implementation for AzureBackupServerContainer.
func (absc AzureBackupServerContainer) AsAzureIaaSClassicComputeVMContainer() (*AzureIaaSClassicComputeVMContainer, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMContainer is the BasicProtectionContainer implementation for AzureBackupServerContainer.
func (absc AzureBackupServerContainer) AsAzureIaaSComputeVMContainer() (*AzureIaaSComputeVMContainer, bool) {
	return nil, false
}

// AsAzureSQLAGWorkloadContainerProtectionContainer is the BasicProtectionContainer implementation for AzureBackupServerContainer.
func (absc AzureBackupServerContainer) AsAzureSQLAGWorkloadContainerProtectionContainer() (*AzureSQLAGWorkloadContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureSQLContainer is the BasicProtectionContainer implementation for AzureBackupServerContainer.
func (absc AzureBackupServerContainer) AsAzureSQLContainer() (*AzureSQLContainer, bool) {
	return nil, false
}

// AsAzureStorageContainer is the BasicProtectionContainer implementation for AzureBackupServerContainer.
func (absc AzureBackupServerContainer) AsAzureStorageContainer() (*AzureStorageContainer, bool) {
	return nil, false
}

// AsAzureVMAppContainerProtectionContainer is the BasicProtectionContainer implementation for AzureBackupServerContainer.
func (absc AzureBackupServerContainer) AsAzureVMAppContainerProtectionContainer() (*AzureVMAppContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureWorkloadContainer is the BasicProtectionContainer implementation for AzureBackupServerContainer.
func (absc AzureBackupServerContainer) AsAzureWorkloadContainer() (*AzureWorkloadContainer, bool) {
	return nil, false
}

// AsBasicAzureWorkloadContainer is the BasicProtectionContainer implementation for AzureBackupServerContainer.
func (absc AzureBackupServerContainer) AsBasicAzureWorkloadContainer() (BasicAzureWorkloadContainer, bool) {
	return nil, false
}

// AsDpmContainer is the BasicProtectionContainer implementation for AzureBackupServerContainer.
func (absc AzureBackupServerContainer) AsDpmContainer() (*DpmContainer, bool) {
	return nil, false
}

// AsBasicDpmContainer is the BasicProtectionContainer implementation for AzureBackupServerContainer.
func (absc AzureBackupServerContainer) AsBasicDpmContainer() (BasicDpmContainer, bool) {
	return &absc, true
}

// AsGenericContainer is the BasicProtectionContainer implementation for AzureBackupServerContainer.
func (absc AzureBackupServerContainer) AsGenericContainer() (*GenericContainer, bool) {
	return nil, false
}

// AsIaaSVMContainer is the BasicProtectionContainer implementation for AzureBackupServerContainer.
func (absc AzureBackupServerContainer) AsIaaSVMContainer() (*IaaSVMContainer, bool) {
	return nil, false
}

// AsBasicIaaSVMContainer is the BasicProtectionContainer implementation for AzureBackupServerContainer.
func (absc AzureBackupServerContainer) AsBasicIaaSVMContainer() (BasicIaaSVMContainer, bool) {
	return nil, false
}

// AsMabContainer is the BasicProtectionContainer implementation for AzureBackupServerContainer.
func (absc AzureBackupServerContainer) AsMabContainer() (*MabContainer, bool) {
	return nil, false
}

// AsProtectionContainer is the BasicProtectionContainer implementation for AzureBackupServerContainer.
func (absc AzureBackupServerContainer) AsProtectionContainer() (*ProtectionContainer, bool) {
	return nil, false
}

// AsBasicProtectionContainer is the BasicProtectionContainer implementation for AzureBackupServerContainer.
func (absc AzureBackupServerContainer) AsBasicProtectionContainer() (BasicProtectionContainer, bool) {
	return &absc, true
}

// AzureBackupServerEngine backup engine type when Azure Backup Server is used to manage the backups.
type AzureBackupServerEngine struct {
	// FriendlyName - Friendly name of the backup engine.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - Type of backup management for the backup engine. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// RegistrationStatus - Registration status of the backup engine with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
	// BackupEngineState - Status of the backup engine with the Recovery Services Vault. = {Active/Deleting/DeleteFailed}
	BackupEngineState *string `json:"backupEngineState,omitempty"`
	// HealthStatus - Backup status of the backup engine.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// CanReRegister - Flag indicating if the backup engine be registered, once already registered.
	CanReRegister *bool `json:"canReRegister,omitempty"`
	// BackupEngineID - ID of the backup engine.
	BackupEngineID *string `json:"backupEngineId,omitempty"`
	// DpmVersion - Backup engine version
	DpmVersion *string `json:"dpmVersion,omitempty"`
	// AzureBackupAgentVersion - Backup agent version
	AzureBackupAgentVersion *string `json:"azureBackupAgentVersion,omitempty"`
	// IsAzureBackupAgentUpgradeAvailable - To check if backup agent upgrade available
	IsAzureBackupAgentUpgradeAvailable *bool `json:"isAzureBackupAgentUpgradeAvailable,omitempty"`
	// IsDpmUpgradeAvailable - To check if backup engine upgrade available
	IsDpmUpgradeAvailable *bool `json:"isDpmUpgradeAvailable,omitempty"`
	// ExtendedInfo - Extended info of the backupengine
	ExtendedInfo *EngineExtendedInfo `json:"extendedInfo,omitempty"`
	// BackupEngineType - Possible values include: 'BackupEngineTypeBackupEngineBase', 'BackupEngineTypeAzureBackupServerEngine', 'BackupEngineTypeDpmBackupEngine'
	BackupEngineType EngineType `json:"backupEngineType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBackupServerEngine.
func (abse AzureBackupServerEngine) MarshalJSON() ([]byte, error) {
	abse.BackupEngineType = BackupEngineTypeAzureBackupServerEngine
	objectMap := make(map[string]interface{})
	if abse.FriendlyName != nil {
		objectMap["friendlyName"] = abse.FriendlyName
	}
	if abse.BackupManagementType != "" {
		objectMap["backupManagementType"] = abse.BackupManagementType
	}
	if abse.RegistrationStatus != nil {
		objectMap["registrationStatus"] = abse.RegistrationStatus
	}
	if abse.BackupEngineState != nil {
		objectMap["backupEngineState"] = abse.BackupEngineState
	}
	if abse.HealthStatus != nil {
		objectMap["healthStatus"] = abse.HealthStatus
	}
	if abse.CanReRegister != nil {
		objectMap["canReRegister"] = abse.CanReRegister
	}
	if abse.BackupEngineID != nil {
		objectMap["backupEngineId"] = abse.BackupEngineID
	}
	if abse.DpmVersion != nil {
		objectMap["dpmVersion"] = abse.DpmVersion
	}
	if abse.AzureBackupAgentVersion != nil {
		objectMap["azureBackupAgentVersion"] = abse.AzureBackupAgentVersion
	}
	if abse.IsAzureBackupAgentUpgradeAvailable != nil {
		objectMap["isAzureBackupAgentUpgradeAvailable"] = abse.IsAzureBackupAgentUpgradeAvailable
	}
	if abse.IsDpmUpgradeAvailable != nil {
		objectMap["isDpmUpgradeAvailable"] = abse.IsDpmUpgradeAvailable
	}
	if abse.ExtendedInfo != nil {
		objectMap["extendedInfo"] = abse.ExtendedInfo
	}
	if abse.BackupEngineType != "" {
		objectMap["backupEngineType"] = abse.BackupEngineType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupServerEngine is the BasicEngineBase implementation for AzureBackupServerEngine.
func (abse AzureBackupServerEngine) AsAzureBackupServerEngine() (*AzureBackupServerEngine, bool) {
	return &abse, true
}

// AsDpmBackupEngine is the BasicEngineBase implementation for AzureBackupServerEngine.
func (abse AzureBackupServerEngine) AsDpmBackupEngine() (*DpmBackupEngine, bool) {
	return nil, false
}

// AsEngineBase is the BasicEngineBase implementation for AzureBackupServerEngine.
func (abse AzureBackupServerEngine) AsEngineBase() (*EngineBase, bool) {
	return nil, false
}

// AsBasicEngineBase is the BasicEngineBase implementation for AzureBackupServerEngine.
func (abse AzureBackupServerEngine) AsBasicEngineBase() (BasicEngineBase, bool) {
	return &abse, true
}

// AzureFileShareBackupRequest azureFileShare workload-specific backup request.
type AzureFileShareBackupRequest struct {
	// RecoveryPointExpiryTimeInUTC - Backup copy will expire after the time specified (UTC).
	RecoveryPointExpiryTimeInUTC *date.Time `json:"recoveryPointExpiryTimeInUTC,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeBackupRequest', 'ObjectTypeAzureFileShareBackupRequest', 'ObjectTypeAzureWorkloadBackupRequest', 'ObjectTypeIaasVMBackupRequest'
	ObjectType ObjectType `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureFileShareBackupRequest.
func (afsbr AzureFileShareBackupRequest) MarshalJSON() ([]byte, error) {
	afsbr.ObjectType = ObjectTypeAzureFileShareBackupRequest
	objectMap := make(map[string]interface{})
	if afsbr.RecoveryPointExpiryTimeInUTC != nil {
		objectMap["recoveryPointExpiryTimeInUTC"] = afsbr.RecoveryPointExpiryTimeInUTC
	}
	if afsbr.ObjectType != "" {
		objectMap["objectType"] = afsbr.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareBackupRequest is the BasicRequest implementation for AzureFileShareBackupRequest.
func (afsbr AzureFileShareBackupRequest) AsAzureFileShareBackupRequest() (*AzureFileShareBackupRequest, bool) {
	return &afsbr, true
}

// AsAzureWorkloadBackupRequest is the BasicRequest implementation for AzureFileShareBackupRequest.
func (afsbr AzureFileShareBackupRequest) AsAzureWorkloadBackupRequest() (*AzureWorkloadBackupRequest, bool) {
	return nil, false
}

// AsIaasVMBackupRequest is the BasicRequest implementation for AzureFileShareBackupRequest.
func (afsbr AzureFileShareBackupRequest) AsIaasVMBackupRequest() (*IaasVMBackupRequest, bool) {
	return nil, false
}

// AsRequest is the BasicRequest implementation for AzureFileShareBackupRequest.
func (afsbr AzureFileShareBackupRequest) AsRequest() (*Request, bool) {
	return nil, false
}

// AsBasicRequest is the BasicRequest implementation for AzureFileShareBackupRequest.
func (afsbr AzureFileShareBackupRequest) AsBasicRequest() (BasicRequest, bool) {
	return &afsbr, true
}

// AzureFileShareProtectableItem protectable item for Azure Fileshare workloads.
type AzureFileShareProtectableItem struct {
	// ParentContainerFabricID - Full Fabric ID of container to which this protectable item belongs. For example, ARM ID.
	ParentContainerFabricID *string `json:"parentContainerFabricId,omitempty"`
	// ParentContainerFriendlyName - Friendly name of container to which this protectable item belongs.
	ParentContainerFriendlyName *string `json:"parentContainerFriendlyName,omitempty"`
	// AzureFileShareType - File Share type XSync or XSMB. Possible values include: 'Invalid', 'XSMB', 'XSync'
	AzureFileShareType AzureFileShareType `json:"azureFileShareType,omitempty"`
	// BackupManagementType - Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
	// FriendlyName - Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionState - State of the back up item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// ProtectableItemType - Possible values include: 'ProtectableItemTypeWorkloadProtectableItem', 'ProtectableItemTypeAzureFileShare', 'ProtectableItemTypeMicrosoftClassicComputevirtualMachines', 'ProtectableItemTypeMicrosoftComputevirtualMachines', 'ProtectableItemTypeAzureVMWorkloadProtectableItem', 'ProtectableItemTypeSAPAseSystem', 'ProtectableItemTypeSAPHanaDatabase', 'ProtectableItemTypeSAPHanaSystem', 'ProtectableItemTypeSQLAvailabilityGroupContainer', 'ProtectableItemTypeSQLDataBase', 'ProtectableItemTypeSQLInstance', 'ProtectableItemTypeIaaSVMProtectableItem'
	ProtectableItemType ProtectableItemType `json:"protectableItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureFileShareProtectableItem.
func (afspi AzureFileShareProtectableItem) MarshalJSON() ([]byte, error) {
	afspi.ProtectableItemType = ProtectableItemTypeAzureFileShare
	objectMap := make(map[string]interface{})
	if afspi.ParentContainerFabricID != nil {
		objectMap["parentContainerFabricId"] = afspi.ParentContainerFabricID
	}
	if afspi.ParentContainerFriendlyName != nil {
		objectMap["parentContainerFriendlyName"] = afspi.ParentContainerFriendlyName
	}
	if afspi.AzureFileShareType != "" {
		objectMap["azureFileShareType"] = afspi.AzureFileShareType
	}
	if afspi.BackupManagementType != nil {
		objectMap["backupManagementType"] = afspi.BackupManagementType
	}
	if afspi.WorkloadType != nil {
		objectMap["workloadType"] = afspi.WorkloadType
	}
	if afspi.FriendlyName != nil {
		objectMap["friendlyName"] = afspi.FriendlyName
	}
	if afspi.ProtectionState != "" {
		objectMap["protectionState"] = afspi.ProtectionState
	}
	if afspi.ProtectableItemType != "" {
		objectMap["protectableItemType"] = afspi.ProtectableItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareProtectableItem is the BasicWorkloadProtectableItem implementation for AzureFileShareProtectableItem.
func (afspi AzureFileShareProtectableItem) AsAzureFileShareProtectableItem() (*AzureFileShareProtectableItem, bool) {
	return &afspi, true
}

// AsAzureIaaSClassicComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureFileShareProtectableItem.
func (afspi AzureFileShareProtectableItem) AsAzureIaaSClassicComputeVMProtectableItem() (*AzureIaaSClassicComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureFileShareProtectableItem.
func (afspi AzureFileShareProtectableItem) AsAzureIaaSComputeVMProtectableItem() (*AzureIaaSComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureFileShareProtectableItem.
func (afspi AzureFileShareProtectableItem) AsAzureVMWorkloadProtectableItem() (*AzureVMWorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureFileShareProtectableItem.
func (afspi AzureFileShareProtectableItem) AsBasicAzureVMWorkloadProtectableItem() (BasicAzureVMWorkloadProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPAseSystemProtectableItem is the BasicWorkloadProtectableItem implementation for AzureFileShareProtectableItem.
func (afspi AzureFileShareProtectableItem) AsAzureVMWorkloadSAPAseSystemProtectableItem() (*AzureVMWorkloadSAPAseSystemProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for AzureFileShareProtectableItem.
func (afspi AzureFileShareProtectableItem) AsAzureVMWorkloadSAPHanaDatabaseProtectableItem() (*AzureVMWorkloadSAPHanaDatabaseProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaSystemProtectableItem is the BasicWorkloadProtectableItem implementation for AzureFileShareProtectableItem.
func (afspi AzureFileShareProtectableItem) AsAzureVMWorkloadSAPHanaSystemProtectableItem() (*AzureVMWorkloadSAPHanaSystemProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem is the BasicWorkloadProtectableItem implementation for AzureFileShareProtectableItem.
func (afspi AzureFileShareProtectableItem) AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem() (*AzureVMWorkloadSQLAvailabilityGroupProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for AzureFileShareProtectableItem.
func (afspi AzureFileShareProtectableItem) AsAzureVMWorkloadSQLDatabaseProtectableItem() (*AzureVMWorkloadSQLDatabaseProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLInstanceProtectableItem is the BasicWorkloadProtectableItem implementation for AzureFileShareProtectableItem.
func (afspi AzureFileShareProtectableItem) AsAzureVMWorkloadSQLInstanceProtectableItem() (*AzureVMWorkloadSQLInstanceProtectableItem, bool) {
	return nil, false
}

// AsIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureFileShareProtectableItem.
func (afspi AzureFileShareProtectableItem) AsIaaSVMProtectableItem() (*IaaSVMProtectableItem, bool) {
	return nil, false
}

// AsBasicIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureFileShareProtectableItem.
func (afspi AzureFileShareProtectableItem) AsBasicIaaSVMProtectableItem() (BasicIaaSVMProtectableItem, bool) {
	return nil, false
}

// AsWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureFileShareProtectableItem.
func (afspi AzureFileShareProtectableItem) AsWorkloadProtectableItem() (*WorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureFileShareProtectableItem.
func (afspi AzureFileShareProtectableItem) AsBasicWorkloadProtectableItem() (BasicWorkloadProtectableItem, bool) {
	return &afspi, true
}

// AzureFileShareProvisionILRRequest update snapshot Uri with the correct friendly Name of the source Azure
// file share.
type AzureFileShareProvisionILRRequest struct {
	// RecoveryPointID - Recovery point ID.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`
	// SourceResourceID - Source Storage account ARM Id
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeILRRequest', 'ObjectTypeAzureFileShareProvisionILRRequest', 'ObjectTypeIaasVMILRRegistrationRequest'
	ObjectType ObjectTypeBasicILRRequest `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureFileShareProvisionILRRequest.
func (afspir AzureFileShareProvisionILRRequest) MarshalJSON() ([]byte, error) {
	afspir.ObjectType = ObjectTypeAzureFileShareProvisionILRRequest
	objectMap := make(map[string]interface{})
	if afspir.RecoveryPointID != nil {
		objectMap["recoveryPointId"] = afspir.RecoveryPointID
	}
	if afspir.SourceResourceID != nil {
		objectMap["sourceResourceId"] = afspir.SourceResourceID
	}
	if afspir.ObjectType != "" {
		objectMap["objectType"] = afspir.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareProvisionILRRequest is the BasicILRRequest implementation for AzureFileShareProvisionILRRequest.
func (afspir AzureFileShareProvisionILRRequest) AsAzureFileShareProvisionILRRequest() (*AzureFileShareProvisionILRRequest, bool) {
	return &afspir, true
}

// AsIaasVMILRRegistrationRequest is the BasicILRRequest implementation for AzureFileShareProvisionILRRequest.
func (afspir AzureFileShareProvisionILRRequest) AsIaasVMILRRegistrationRequest() (*IaasVMILRRegistrationRequest, bool) {
	return nil, false
}

// AsILRRequest is the BasicILRRequest implementation for AzureFileShareProvisionILRRequest.
func (afspir AzureFileShareProvisionILRRequest) AsILRRequest() (*ILRRequest, bool) {
	return nil, false
}

// AsBasicILRRequest is the BasicILRRequest implementation for AzureFileShareProvisionILRRequest.
func (afspir AzureFileShareProvisionILRRequest) AsBasicILRRequest() (BasicILRRequest, bool) {
	return &afspir, true
}

// AzureIaaSClassicComputeVMContainer iaaS VM workload-specific backup item representing a classic virtual
// machine.
type AzureIaaSClassicComputeVMContainer struct {
	// VirtualMachineID - Fully qualified ARM url of the virtual machine represented by this Azure IaaS VM container.
	VirtualMachineID *string `json:"virtualMachineId,omitempty"`
	// VirtualMachineVersion - Specifies whether the container represents a Classic or an Azure Resource Manager VM.
	VirtualMachineVersion *string `json:"virtualMachineVersion,omitempty"`
	// ResourceGroup - Resource group name of Recovery Services Vault.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// FriendlyName - Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - Type of backup management for the container. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// RegistrationStatus - Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
	// HealthStatus - Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// ContainerType - Possible values include: 'ContainerTypeProtectionContainer', 'ContainerTypeAzureBackupServerContainer1', 'ContainerTypeMicrosoftClassicComputevirtualMachines', 'ContainerTypeMicrosoftComputevirtualMachines', 'ContainerTypeSQLAGWorkLoadContainer1', 'ContainerTypeAzureSQLContainer1', 'ContainerTypeStorageContainer1', 'ContainerTypeVMAppContainer1', 'ContainerTypeAzureWorkloadContainer', 'ContainerTypeDPMContainer1', 'ContainerTypeGenericContainer1', 'ContainerTypeIaaSVMContainer', 'ContainerTypeWindows1'
	ContainerType ContainerTypeBasicProtectionContainer `json:"containerType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureIaaSClassicComputeVMContainer.
func (aisccvc AzureIaaSClassicComputeVMContainer) MarshalJSON() ([]byte, error) {
	aisccvc.ContainerType = ContainerTypeMicrosoftClassicComputevirtualMachines
	objectMap := make(map[string]interface{})
	if aisccvc.VirtualMachineID != nil {
		objectMap["virtualMachineId"] = aisccvc.VirtualMachineID
	}
	if aisccvc.VirtualMachineVersion != nil {
		objectMap["virtualMachineVersion"] = aisccvc.VirtualMachineVersion
	}
	if aisccvc.ResourceGroup != nil {
		objectMap["resourceGroup"] = aisccvc.ResourceGroup
	}
	if aisccvc.FriendlyName != nil {
		objectMap["friendlyName"] = aisccvc.FriendlyName
	}
	if aisccvc.BackupManagementType != "" {
		objectMap["backupManagementType"] = aisccvc.BackupManagementType
	}
	if aisccvc.RegistrationStatus != nil {
		objectMap["registrationStatus"] = aisccvc.RegistrationStatus
	}
	if aisccvc.HealthStatus != nil {
		objectMap["healthStatus"] = aisccvc.HealthStatus
	}
	if aisccvc.ContainerType != "" {
		objectMap["containerType"] = aisccvc.ContainerType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupServerContainer is the BasicProtectionContainer implementation for AzureIaaSClassicComputeVMContainer.
func (aisccvc AzureIaaSClassicComputeVMContainer) AsAzureBackupServerContainer() (*AzureBackupServerContainer, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMContainer is the BasicProtectionContainer implementation for AzureIaaSClassicComputeVMContainer.
func (aisccvc AzureIaaSClassicComputeVMContainer) AsAzureIaaSClassicComputeVMContainer() (*AzureIaaSClassicComputeVMContainer, bool) {
	return &aisccvc, true
}

// AsAzureIaaSComputeVMContainer is the BasicProtectionContainer implementation for AzureIaaSClassicComputeVMContainer.
func (aisccvc AzureIaaSClassicComputeVMContainer) AsAzureIaaSComputeVMContainer() (*AzureIaaSComputeVMContainer, bool) {
	return nil, false
}

// AsAzureSQLAGWorkloadContainerProtectionContainer is the BasicProtectionContainer implementation for AzureIaaSClassicComputeVMContainer.
func (aisccvc AzureIaaSClassicComputeVMContainer) AsAzureSQLAGWorkloadContainerProtectionContainer() (*AzureSQLAGWorkloadContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureSQLContainer is the BasicProtectionContainer implementation for AzureIaaSClassicComputeVMContainer.
func (aisccvc AzureIaaSClassicComputeVMContainer) AsAzureSQLContainer() (*AzureSQLContainer, bool) {
	return nil, false
}

// AsAzureStorageContainer is the BasicProtectionContainer implementation for AzureIaaSClassicComputeVMContainer.
func (aisccvc AzureIaaSClassicComputeVMContainer) AsAzureStorageContainer() (*AzureStorageContainer, bool) {
	return nil, false
}

// AsAzureVMAppContainerProtectionContainer is the BasicProtectionContainer implementation for AzureIaaSClassicComputeVMContainer.
func (aisccvc AzureIaaSClassicComputeVMContainer) AsAzureVMAppContainerProtectionContainer() (*AzureVMAppContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureWorkloadContainer is the BasicProtectionContainer implementation for AzureIaaSClassicComputeVMContainer.
func (aisccvc AzureIaaSClassicComputeVMContainer) AsAzureWorkloadContainer() (*AzureWorkloadContainer, bool) {
	return nil, false
}

// AsBasicAzureWorkloadContainer is the BasicProtectionContainer implementation for AzureIaaSClassicComputeVMContainer.
func (aisccvc AzureIaaSClassicComputeVMContainer) AsBasicAzureWorkloadContainer() (BasicAzureWorkloadContainer, bool) {
	return nil, false
}

// AsDpmContainer is the BasicProtectionContainer implementation for AzureIaaSClassicComputeVMContainer.
func (aisccvc AzureIaaSClassicComputeVMContainer) AsDpmContainer() (*DpmContainer, bool) {
	return nil, false
}

// AsBasicDpmContainer is the BasicProtectionContainer implementation for AzureIaaSClassicComputeVMContainer.
func (aisccvc AzureIaaSClassicComputeVMContainer) AsBasicDpmContainer() (BasicDpmContainer, bool) {
	return nil, false
}

// AsGenericContainer is the BasicProtectionContainer implementation for AzureIaaSClassicComputeVMContainer.
func (aisccvc AzureIaaSClassicComputeVMContainer) AsGenericContainer() (*GenericContainer, bool) {
	return nil, false
}

// AsIaaSVMContainer is the BasicProtectionContainer implementation for AzureIaaSClassicComputeVMContainer.
func (aisccvc AzureIaaSClassicComputeVMContainer) AsIaaSVMContainer() (*IaaSVMContainer, bool) {
	return nil, false
}

// AsBasicIaaSVMContainer is the BasicProtectionContainer implementation for AzureIaaSClassicComputeVMContainer.
func (aisccvc AzureIaaSClassicComputeVMContainer) AsBasicIaaSVMContainer() (BasicIaaSVMContainer, bool) {
	return &aisccvc, true
}

// AsMabContainer is the BasicProtectionContainer implementation for AzureIaaSClassicComputeVMContainer.
func (aisccvc AzureIaaSClassicComputeVMContainer) AsMabContainer() (*MabContainer, bool) {
	return nil, false
}

// AsProtectionContainer is the BasicProtectionContainer implementation for AzureIaaSClassicComputeVMContainer.
func (aisccvc AzureIaaSClassicComputeVMContainer) AsProtectionContainer() (*ProtectionContainer, bool) {
	return nil, false
}

// AsBasicProtectionContainer is the BasicProtectionContainer implementation for AzureIaaSClassicComputeVMContainer.
func (aisccvc AzureIaaSClassicComputeVMContainer) AsBasicProtectionContainer() (BasicProtectionContainer, bool) {
	return &aisccvc, true
}

// AzureIaaSClassicComputeVMProtectableItem iaaS VM workload-specific backup item representing the Classic
// Compute VM.
type AzureIaaSClassicComputeVMProtectableItem struct {
	// VirtualMachineID - Fully qualified ARM ID of the virtual machine.
	VirtualMachineID *string `json:"virtualMachineId,omitempty"`
	// BackupManagementType - Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
	// FriendlyName - Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionState - State of the back up item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// ProtectableItemType - Possible values include: 'ProtectableItemTypeWorkloadProtectableItem', 'ProtectableItemTypeAzureFileShare', 'ProtectableItemTypeMicrosoftClassicComputevirtualMachines', 'ProtectableItemTypeMicrosoftComputevirtualMachines', 'ProtectableItemTypeAzureVMWorkloadProtectableItem', 'ProtectableItemTypeSAPAseSystem', 'ProtectableItemTypeSAPHanaDatabase', 'ProtectableItemTypeSAPHanaSystem', 'ProtectableItemTypeSQLAvailabilityGroupContainer', 'ProtectableItemTypeSQLDataBase', 'ProtectableItemTypeSQLInstance', 'ProtectableItemTypeIaaSVMProtectableItem'
	ProtectableItemType ProtectableItemType `json:"protectableItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureIaaSClassicComputeVMProtectableItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectableItem) MarshalJSON() ([]byte, error) {
	aisccvpi.ProtectableItemType = ProtectableItemTypeMicrosoftClassicComputevirtualMachines
	objectMap := make(map[string]interface{})
	if aisccvpi.VirtualMachineID != nil {
		objectMap["virtualMachineId"] = aisccvpi.VirtualMachineID
	}
	if aisccvpi.BackupManagementType != nil {
		objectMap["backupManagementType"] = aisccvpi.BackupManagementType
	}
	if aisccvpi.WorkloadType != nil {
		objectMap["workloadType"] = aisccvpi.WorkloadType
	}
	if aisccvpi.FriendlyName != nil {
		objectMap["friendlyName"] = aisccvpi.FriendlyName
	}
	if aisccvpi.ProtectionState != "" {
		objectMap["protectionState"] = aisccvpi.ProtectionState
	}
	if aisccvpi.ProtectableItemType != "" {
		objectMap["protectableItemType"] = aisccvpi.ProtectableItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSClassicComputeVMProtectableItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectableItem) AsAzureFileShareProtectableItem() (*AzureFileShareProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSClassicComputeVMProtectableItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectableItem) AsAzureIaaSClassicComputeVMProtectableItem() (*AzureIaaSClassicComputeVMProtectableItem, bool) {
	return &aisccvpi, true
}

// AsAzureIaaSComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSClassicComputeVMProtectableItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectableItem) AsAzureIaaSComputeVMProtectableItem() (*AzureIaaSComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSClassicComputeVMProtectableItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectableItem) AsAzureVMWorkloadProtectableItem() (*AzureVMWorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSClassicComputeVMProtectableItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectableItem) AsBasicAzureVMWorkloadProtectableItem() (BasicAzureVMWorkloadProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPAseSystemProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSClassicComputeVMProtectableItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectableItem) AsAzureVMWorkloadSAPAseSystemProtectableItem() (*AzureVMWorkloadSAPAseSystemProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSClassicComputeVMProtectableItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectableItem) AsAzureVMWorkloadSAPHanaDatabaseProtectableItem() (*AzureVMWorkloadSAPHanaDatabaseProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaSystemProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSClassicComputeVMProtectableItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectableItem) AsAzureVMWorkloadSAPHanaSystemProtectableItem() (*AzureVMWorkloadSAPHanaSystemProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSClassicComputeVMProtectableItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectableItem) AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem() (*AzureVMWorkloadSQLAvailabilityGroupProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSClassicComputeVMProtectableItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectableItem) AsAzureVMWorkloadSQLDatabaseProtectableItem() (*AzureVMWorkloadSQLDatabaseProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLInstanceProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSClassicComputeVMProtectableItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectableItem) AsAzureVMWorkloadSQLInstanceProtectableItem() (*AzureVMWorkloadSQLInstanceProtectableItem, bool) {
	return nil, false
}

// AsIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSClassicComputeVMProtectableItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectableItem) AsIaaSVMProtectableItem() (*IaaSVMProtectableItem, bool) {
	return nil, false
}

// AsBasicIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSClassicComputeVMProtectableItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectableItem) AsBasicIaaSVMProtectableItem() (BasicIaaSVMProtectableItem, bool) {
	return &aisccvpi, true
}

// AsWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSClassicComputeVMProtectableItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectableItem) AsWorkloadProtectableItem() (*WorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSClassicComputeVMProtectableItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectableItem) AsBasicWorkloadProtectableItem() (BasicWorkloadProtectableItem, bool) {
	return &aisccvpi, true
}

// AzureIaaSComputeVMContainer iaaS VM workload-specific backup item representing an Azure Resource Manager
// virtual machine.
type AzureIaaSComputeVMContainer struct {
	// VirtualMachineID - Fully qualified ARM url of the virtual machine represented by this Azure IaaS VM container.
	VirtualMachineID *string `json:"virtualMachineId,omitempty"`
	// VirtualMachineVersion - Specifies whether the container represents a Classic or an Azure Resource Manager VM.
	VirtualMachineVersion *string `json:"virtualMachineVersion,omitempty"`
	// ResourceGroup - Resource group name of Recovery Services Vault.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// FriendlyName - Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - Type of backup management for the container. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// RegistrationStatus - Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
	// HealthStatus - Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// ContainerType - Possible values include: 'ContainerTypeProtectionContainer', 'ContainerTypeAzureBackupServerContainer1', 'ContainerTypeMicrosoftClassicComputevirtualMachines', 'ContainerTypeMicrosoftComputevirtualMachines', 'ContainerTypeSQLAGWorkLoadContainer1', 'ContainerTypeAzureSQLContainer1', 'ContainerTypeStorageContainer1', 'ContainerTypeVMAppContainer1', 'ContainerTypeAzureWorkloadContainer', 'ContainerTypeDPMContainer1', 'ContainerTypeGenericContainer1', 'ContainerTypeIaaSVMContainer', 'ContainerTypeWindows1'
	ContainerType ContainerTypeBasicProtectionContainer `json:"containerType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureIaaSComputeVMContainer.
func (aiscvc AzureIaaSComputeVMContainer) MarshalJSON() ([]byte, error) {
	aiscvc.ContainerType = ContainerTypeMicrosoftComputevirtualMachines
	objectMap := make(map[string]interface{})
	if aiscvc.VirtualMachineID != nil {
		objectMap["virtualMachineId"] = aiscvc.VirtualMachineID
	}
	if aiscvc.VirtualMachineVersion != nil {
		objectMap["virtualMachineVersion"] = aiscvc.VirtualMachineVersion
	}
	if aiscvc.ResourceGroup != nil {
		objectMap["resourceGroup"] = aiscvc.ResourceGroup
	}
	if aiscvc.FriendlyName != nil {
		objectMap["friendlyName"] = aiscvc.FriendlyName
	}
	if aiscvc.BackupManagementType != "" {
		objectMap["backupManagementType"] = aiscvc.BackupManagementType
	}
	if aiscvc.RegistrationStatus != nil {
		objectMap["registrationStatus"] = aiscvc.RegistrationStatus
	}
	if aiscvc.HealthStatus != nil {
		objectMap["healthStatus"] = aiscvc.HealthStatus
	}
	if aiscvc.ContainerType != "" {
		objectMap["containerType"] = aiscvc.ContainerType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupServerContainer is the BasicProtectionContainer implementation for AzureIaaSComputeVMContainer.
func (aiscvc AzureIaaSComputeVMContainer) AsAzureBackupServerContainer() (*AzureBackupServerContainer, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMContainer is the BasicProtectionContainer implementation for AzureIaaSComputeVMContainer.
func (aiscvc AzureIaaSComputeVMContainer) AsAzureIaaSClassicComputeVMContainer() (*AzureIaaSClassicComputeVMContainer, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMContainer is the BasicProtectionContainer implementation for AzureIaaSComputeVMContainer.
func (aiscvc AzureIaaSComputeVMContainer) AsAzureIaaSComputeVMContainer() (*AzureIaaSComputeVMContainer, bool) {
	return &aiscvc, true
}

// AsAzureSQLAGWorkloadContainerProtectionContainer is the BasicProtectionContainer implementation for AzureIaaSComputeVMContainer.
func (aiscvc AzureIaaSComputeVMContainer) AsAzureSQLAGWorkloadContainerProtectionContainer() (*AzureSQLAGWorkloadContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureSQLContainer is the BasicProtectionContainer implementation for AzureIaaSComputeVMContainer.
func (aiscvc AzureIaaSComputeVMContainer) AsAzureSQLContainer() (*AzureSQLContainer, bool) {
	return nil, false
}

// AsAzureStorageContainer is the BasicProtectionContainer implementation for AzureIaaSComputeVMContainer.
func (aiscvc AzureIaaSComputeVMContainer) AsAzureStorageContainer() (*AzureStorageContainer, bool) {
	return nil, false
}

// AsAzureVMAppContainerProtectionContainer is the BasicProtectionContainer implementation for AzureIaaSComputeVMContainer.
func (aiscvc AzureIaaSComputeVMContainer) AsAzureVMAppContainerProtectionContainer() (*AzureVMAppContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureWorkloadContainer is the BasicProtectionContainer implementation for AzureIaaSComputeVMContainer.
func (aiscvc AzureIaaSComputeVMContainer) AsAzureWorkloadContainer() (*AzureWorkloadContainer, bool) {
	return nil, false
}

// AsBasicAzureWorkloadContainer is the BasicProtectionContainer implementation for AzureIaaSComputeVMContainer.
func (aiscvc AzureIaaSComputeVMContainer) AsBasicAzureWorkloadContainer() (BasicAzureWorkloadContainer, bool) {
	return nil, false
}

// AsDpmContainer is the BasicProtectionContainer implementation for AzureIaaSComputeVMContainer.
func (aiscvc AzureIaaSComputeVMContainer) AsDpmContainer() (*DpmContainer, bool) {
	return nil, false
}

// AsBasicDpmContainer is the BasicProtectionContainer implementation for AzureIaaSComputeVMContainer.
func (aiscvc AzureIaaSComputeVMContainer) AsBasicDpmContainer() (BasicDpmContainer, bool) {
	return nil, false
}

// AsGenericContainer is the BasicProtectionContainer implementation for AzureIaaSComputeVMContainer.
func (aiscvc AzureIaaSComputeVMContainer) AsGenericContainer() (*GenericContainer, bool) {
	return nil, false
}

// AsIaaSVMContainer is the BasicProtectionContainer implementation for AzureIaaSComputeVMContainer.
func (aiscvc AzureIaaSComputeVMContainer) AsIaaSVMContainer() (*IaaSVMContainer, bool) {
	return nil, false
}

// AsBasicIaaSVMContainer is the BasicProtectionContainer implementation for AzureIaaSComputeVMContainer.
func (aiscvc AzureIaaSComputeVMContainer) AsBasicIaaSVMContainer() (BasicIaaSVMContainer, bool) {
	return &aiscvc, true
}

// AsMabContainer is the BasicProtectionContainer implementation for AzureIaaSComputeVMContainer.
func (aiscvc AzureIaaSComputeVMContainer) AsMabContainer() (*MabContainer, bool) {
	return nil, false
}

// AsProtectionContainer is the BasicProtectionContainer implementation for AzureIaaSComputeVMContainer.
func (aiscvc AzureIaaSComputeVMContainer) AsProtectionContainer() (*ProtectionContainer, bool) {
	return nil, false
}

// AsBasicProtectionContainer is the BasicProtectionContainer implementation for AzureIaaSComputeVMContainer.
func (aiscvc AzureIaaSComputeVMContainer) AsBasicProtectionContainer() (BasicProtectionContainer, bool) {
	return &aiscvc, true
}

// AzureIaaSComputeVMProtectableItem iaaS VM workload-specific backup item representing the Azure Resource
// Manager VM.
type AzureIaaSComputeVMProtectableItem struct {
	// VirtualMachineID - Fully qualified ARM ID of the virtual machine.
	VirtualMachineID *string `json:"virtualMachineId,omitempty"`
	// BackupManagementType - Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
	// FriendlyName - Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionState - State of the back up item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// ProtectableItemType - Possible values include: 'ProtectableItemTypeWorkloadProtectableItem', 'ProtectableItemTypeAzureFileShare', 'ProtectableItemTypeMicrosoftClassicComputevirtualMachines', 'ProtectableItemTypeMicrosoftComputevirtualMachines', 'ProtectableItemTypeAzureVMWorkloadProtectableItem', 'ProtectableItemTypeSAPAseSystem', 'ProtectableItemTypeSAPHanaDatabase', 'ProtectableItemTypeSAPHanaSystem', 'ProtectableItemTypeSQLAvailabilityGroupContainer', 'ProtectableItemTypeSQLDataBase', 'ProtectableItemTypeSQLInstance', 'ProtectableItemTypeIaaSVMProtectableItem'
	ProtectableItemType ProtectableItemType `json:"protectableItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureIaaSComputeVMProtectableItem.
func (aiscvpi AzureIaaSComputeVMProtectableItem) MarshalJSON() ([]byte, error) {
	aiscvpi.ProtectableItemType = ProtectableItemTypeMicrosoftComputevirtualMachines
	objectMap := make(map[string]interface{})
	if aiscvpi.VirtualMachineID != nil {
		objectMap["virtualMachineId"] = aiscvpi.VirtualMachineID
	}
	if aiscvpi.BackupManagementType != nil {
		objectMap["backupManagementType"] = aiscvpi.BackupManagementType
	}
	if aiscvpi.WorkloadType != nil {
		objectMap["workloadType"] = aiscvpi.WorkloadType
	}
	if aiscvpi.FriendlyName != nil {
		objectMap["friendlyName"] = aiscvpi.FriendlyName
	}
	if aiscvpi.ProtectionState != "" {
		objectMap["protectionState"] = aiscvpi.ProtectionState
	}
	if aiscvpi.ProtectableItemType != "" {
		objectMap["protectableItemType"] = aiscvpi.ProtectableItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSComputeVMProtectableItem.
func (aiscvpi AzureIaaSComputeVMProtectableItem) AsAzureFileShareProtectableItem() (*AzureFileShareProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSComputeVMProtectableItem.
func (aiscvpi AzureIaaSComputeVMProtectableItem) AsAzureIaaSClassicComputeVMProtectableItem() (*AzureIaaSClassicComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSComputeVMProtectableItem.
func (aiscvpi AzureIaaSComputeVMProtectableItem) AsAzureIaaSComputeVMProtectableItem() (*AzureIaaSComputeVMProtectableItem, bool) {
	return &aiscvpi, true
}

// AsAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSComputeVMProtectableItem.
func (aiscvpi AzureIaaSComputeVMProtectableItem) AsAzureVMWorkloadProtectableItem() (*AzureVMWorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSComputeVMProtectableItem.
func (aiscvpi AzureIaaSComputeVMProtectableItem) AsBasicAzureVMWorkloadProtectableItem() (BasicAzureVMWorkloadProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPAseSystemProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSComputeVMProtectableItem.
func (aiscvpi AzureIaaSComputeVMProtectableItem) AsAzureVMWorkloadSAPAseSystemProtectableItem() (*AzureVMWorkloadSAPAseSystemProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSComputeVMProtectableItem.
func (aiscvpi AzureIaaSComputeVMProtectableItem) AsAzureVMWorkloadSAPHanaDatabaseProtectableItem() (*AzureVMWorkloadSAPHanaDatabaseProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaSystemProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSComputeVMProtectableItem.
func (aiscvpi AzureIaaSComputeVMProtectableItem) AsAzureVMWorkloadSAPHanaSystemProtectableItem() (*AzureVMWorkloadSAPHanaSystemProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSComputeVMProtectableItem.
func (aiscvpi AzureIaaSComputeVMProtectableItem) AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem() (*AzureVMWorkloadSQLAvailabilityGroupProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSComputeVMProtectableItem.
func (aiscvpi AzureIaaSComputeVMProtectableItem) AsAzureVMWorkloadSQLDatabaseProtectableItem() (*AzureVMWorkloadSQLDatabaseProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLInstanceProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSComputeVMProtectableItem.
func (aiscvpi AzureIaaSComputeVMProtectableItem) AsAzureVMWorkloadSQLInstanceProtectableItem() (*AzureVMWorkloadSQLInstanceProtectableItem, bool) {
	return nil, false
}

// AsIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSComputeVMProtectableItem.
func (aiscvpi AzureIaaSComputeVMProtectableItem) AsIaaSVMProtectableItem() (*IaaSVMProtectableItem, bool) {
	return nil, false
}

// AsBasicIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSComputeVMProtectableItem.
func (aiscvpi AzureIaaSComputeVMProtectableItem) AsBasicIaaSVMProtectableItem() (BasicIaaSVMProtectableItem, bool) {
	return &aiscvpi, true
}

// AsWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSComputeVMProtectableItem.
func (aiscvpi AzureIaaSComputeVMProtectableItem) AsWorkloadProtectableItem() (*WorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSComputeVMProtectableItem.
func (aiscvpi AzureIaaSComputeVMProtectableItem) AsBasicWorkloadProtectableItem() (BasicWorkloadProtectableItem, bool) {
	return &aiscvpi, true
}

// AzureSQLAGWorkloadContainerProtectionContainer container for SQL workloads under SQL Availability Group.
type AzureSQLAGWorkloadContainerProtectionContainer struct {
	// SourceResourceID - ARM ID of the virtual machine represented by this Azure Workload Container
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
	// LastUpdatedTime - Time stamp when this container was updated.
	LastUpdatedTime *date.Time `json:"lastUpdatedTime,omitempty"`
	// ExtendedInfo - Additional details of a workload container.
	ExtendedInfo *AzureWorkloadContainerExtendedInfo `json:"extendedInfo,omitempty"`
	// WorkloadType - Workload type for which registration was sent. Possible values include: 'WorkloadTypeInvalid', 'WorkloadTypeVM', 'WorkloadTypeFileFolder', 'WorkloadTypeAzureSQLDb', 'WorkloadTypeSQLDB', 'WorkloadTypeExchange', 'WorkloadTypeSharepoint', 'WorkloadTypeVMwareVM', 'WorkloadTypeSystemState', 'WorkloadTypeClient', 'WorkloadTypeGenericDataSource', 'WorkloadTypeSQLDataBase', 'WorkloadTypeAzureFileShare', 'WorkloadTypeSAPHanaDatabase', 'WorkloadTypeSAPAseDatabase'
	WorkloadType WorkloadType `json:"workloadType,omitempty"`
	// OperationType - Re-Do Operation. Possible values include: 'OperationTypeInvalid', 'OperationTypeRegister', 'OperationTypeReregister'
	OperationType OperationType `json:"operationType,omitempty"`
	// FriendlyName - Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - Type of backup management for the container. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// RegistrationStatus - Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
	// HealthStatus - Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// ContainerType - Possible values include: 'ContainerTypeProtectionContainer', 'ContainerTypeAzureBackupServerContainer1', 'ContainerTypeMicrosoftClassicComputevirtualMachines', 'ContainerTypeMicrosoftComputevirtualMachines', 'ContainerTypeSQLAGWorkLoadContainer1', 'ContainerTypeAzureSQLContainer1', 'ContainerTypeStorageContainer1', 'ContainerTypeVMAppContainer1', 'ContainerTypeAzureWorkloadContainer', 'ContainerTypeDPMContainer1', 'ContainerTypeGenericContainer1', 'ContainerTypeIaaSVMContainer', 'ContainerTypeWindows1'
	ContainerType ContainerTypeBasicProtectionContainer `json:"containerType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureSQLAGWorkloadContainerProtectionContainer.
func (aswcpc AzureSQLAGWorkloadContainerProtectionContainer) MarshalJSON() ([]byte, error) {
	aswcpc.ContainerType = ContainerTypeSQLAGWorkLoadContainer1
	objectMap := make(map[string]interface{})
	if aswcpc.SourceResourceID != nil {
		objectMap["sourceResourceId"] = aswcpc.SourceResourceID
	}
	if aswcpc.LastUpdatedTime != nil {
		objectMap["lastUpdatedTime"] = aswcpc.LastUpdatedTime
	}
	if aswcpc.ExtendedInfo != nil {
		objectMap["extendedInfo"] = aswcpc.ExtendedInfo
	}
	if aswcpc.WorkloadType != "" {
		objectMap["workloadType"] = aswcpc.WorkloadType
	}
	if aswcpc.OperationType != "" {
		objectMap["operationType"] = aswcpc.OperationType
	}
	if aswcpc.FriendlyName != nil {
		objectMap["friendlyName"] = aswcpc.FriendlyName
	}
	if aswcpc.BackupManagementType != "" {
		objectMap["backupManagementType"] = aswcpc.BackupManagementType
	}
	if aswcpc.RegistrationStatus != nil {
		objectMap["registrationStatus"] = aswcpc.RegistrationStatus
	}
	if aswcpc.HealthStatus != nil {
		objectMap["healthStatus"] = aswcpc.HealthStatus
	}
	if aswcpc.ContainerType != "" {
		objectMap["containerType"] = aswcpc.ContainerType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupServerContainer is the BasicProtectionContainer implementation for AzureSQLAGWorkloadContainerProtectionContainer.
func (aswcpc AzureSQLAGWorkloadContainerProtectionContainer) AsAzureBackupServerContainer() (*AzureBackupServerContainer, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMContainer is the BasicProtectionContainer implementation for AzureSQLAGWorkloadContainerProtectionContainer.
func (aswcpc AzureSQLAGWorkloadContainerProtectionContainer) AsAzureIaaSClassicComputeVMContainer() (*AzureIaaSClassicComputeVMContainer, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMContainer is the BasicProtectionContainer implementation for AzureSQLAGWorkloadContainerProtectionContainer.
func (aswcpc AzureSQLAGWorkloadContainerProtectionContainer) AsAzureIaaSComputeVMContainer() (*AzureIaaSComputeVMContainer, bool) {
	return nil, false
}

// AsAzureSQLAGWorkloadContainerProtectionContainer is the BasicProtectionContainer implementation for AzureSQLAGWorkloadContainerProtectionContainer.
func (aswcpc AzureSQLAGWorkloadContainerProtectionContainer) AsAzureSQLAGWorkloadContainerProtectionContainer() (*AzureSQLAGWorkloadContainerProtectionContainer, bool) {
	return &aswcpc, true
}

// AsAzureSQLContainer is the BasicProtectionContainer implementation for AzureSQLAGWorkloadContainerProtectionContainer.
func (aswcpc AzureSQLAGWorkloadContainerProtectionContainer) AsAzureSQLContainer() (*AzureSQLContainer, bool) {
	return nil, false
}

// AsAzureStorageContainer is the BasicProtectionContainer implementation for AzureSQLAGWorkloadContainerProtectionContainer.
func (aswcpc AzureSQLAGWorkloadContainerProtectionContainer) AsAzureStorageContainer() (*AzureStorageContainer, bool) {
	return nil, false
}

// AsAzureVMAppContainerProtectionContainer is the BasicProtectionContainer implementation for AzureSQLAGWorkloadContainerProtectionContainer.
func (aswcpc AzureSQLAGWorkloadContainerProtectionContainer) AsAzureVMAppContainerProtectionContainer() (*AzureVMAppContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureWorkloadContainer is the BasicProtectionContainer implementation for AzureSQLAGWorkloadContainerProtectionContainer.
func (aswcpc AzureSQLAGWorkloadContainerProtectionContainer) AsAzureWorkloadContainer() (*AzureWorkloadContainer, bool) {
	return nil, false
}

// AsBasicAzureWorkloadContainer is the BasicProtectionContainer implementation for AzureSQLAGWorkloadContainerProtectionContainer.
func (aswcpc AzureSQLAGWorkloadContainerProtectionContainer) AsBasicAzureWorkloadContainer() (BasicAzureWorkloadContainer, bool) {
	return &aswcpc, true
}

// AsDpmContainer is the BasicProtectionContainer implementation for AzureSQLAGWorkloadContainerProtectionContainer.
func (aswcpc AzureSQLAGWorkloadContainerProtectionContainer) AsDpmContainer() (*DpmContainer, bool) {
	return nil, false
}

// AsBasicDpmContainer is the BasicProtectionContainer implementation for AzureSQLAGWorkloadContainerProtectionContainer.
func (aswcpc AzureSQLAGWorkloadContainerProtectionContainer) AsBasicDpmContainer() (BasicDpmContainer, bool) {
	return nil, false
}

// AsGenericContainer is the BasicProtectionContainer implementation for AzureSQLAGWorkloadContainerProtectionContainer.
func (aswcpc AzureSQLAGWorkloadContainerProtectionContainer) AsGenericContainer() (*GenericContainer, bool) {
	return nil, false
}

// AsIaaSVMContainer is the BasicProtectionContainer implementation for AzureSQLAGWorkloadContainerProtectionContainer.
func (aswcpc AzureSQLAGWorkloadContainerProtectionContainer) AsIaaSVMContainer() (*IaaSVMContainer, bool) {
	return nil, false
}

// AsBasicIaaSVMContainer is the BasicProtectionContainer implementation for AzureSQLAGWorkloadContainerProtectionContainer.
func (aswcpc AzureSQLAGWorkloadContainerProtectionContainer) AsBasicIaaSVMContainer() (BasicIaaSVMContainer, bool) {
	return nil, false
}

// AsMabContainer is the BasicProtectionContainer implementation for AzureSQLAGWorkloadContainerProtectionContainer.
func (aswcpc AzureSQLAGWorkloadContainerProtectionContainer) AsMabContainer() (*MabContainer, bool) {
	return nil, false
}

// AsProtectionContainer is the BasicProtectionContainer implementation for AzureSQLAGWorkloadContainerProtectionContainer.
func (aswcpc AzureSQLAGWorkloadContainerProtectionContainer) AsProtectionContainer() (*ProtectionContainer, bool) {
	return nil, false
}

// AsBasicProtectionContainer is the BasicProtectionContainer implementation for AzureSQLAGWorkloadContainerProtectionContainer.
func (aswcpc AzureSQLAGWorkloadContainerProtectionContainer) AsBasicProtectionContainer() (BasicProtectionContainer, bool) {
	return &aswcpc, true
}

// AzureSQLContainer azure Sql workload-specific container.
type AzureSQLContainer struct {
	// FriendlyName - Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - Type of backup management for the container. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// RegistrationStatus - Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
	// HealthStatus - Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// ContainerType - Possible values include: 'ContainerTypeProtectionContainer', 'ContainerTypeAzureBackupServerContainer1', 'ContainerTypeMicrosoftClassicComputevirtualMachines', 'ContainerTypeMicrosoftComputevirtualMachines', 'ContainerTypeSQLAGWorkLoadContainer1', 'ContainerTypeAzureSQLContainer1', 'ContainerTypeStorageContainer1', 'ContainerTypeVMAppContainer1', 'ContainerTypeAzureWorkloadContainer', 'ContainerTypeDPMContainer1', 'ContainerTypeGenericContainer1', 'ContainerTypeIaaSVMContainer', 'ContainerTypeWindows1'
	ContainerType ContainerTypeBasicProtectionContainer `json:"containerType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureSQLContainer.
func (asc AzureSQLContainer) MarshalJSON() ([]byte, error) {
	asc.ContainerType = ContainerTypeAzureSQLContainer1
	objectMap := make(map[string]interface{})
	if asc.FriendlyName != nil {
		objectMap["friendlyName"] = asc.FriendlyName
	}
	if asc.BackupManagementType != "" {
		objectMap["backupManagementType"] = asc.BackupManagementType
	}
	if asc.RegistrationStatus != nil {
		objectMap["registrationStatus"] = asc.RegistrationStatus
	}
	if asc.HealthStatus != nil {
		objectMap["healthStatus"] = asc.HealthStatus
	}
	if asc.ContainerType != "" {
		objectMap["containerType"] = asc.ContainerType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupServerContainer is the BasicProtectionContainer implementation for AzureSQLContainer.
func (asc AzureSQLContainer) AsAzureBackupServerContainer() (*AzureBackupServerContainer, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMContainer is the BasicProtectionContainer implementation for AzureSQLContainer.
func (asc AzureSQLContainer) AsAzureIaaSClassicComputeVMContainer() (*AzureIaaSClassicComputeVMContainer, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMContainer is the BasicProtectionContainer implementation for AzureSQLContainer.
func (asc AzureSQLContainer) AsAzureIaaSComputeVMContainer() (*AzureIaaSComputeVMContainer, bool) {
	return nil, false
}

// AsAzureSQLAGWorkloadContainerProtectionContainer is the BasicProtectionContainer implementation for AzureSQLContainer.
func (asc AzureSQLContainer) AsAzureSQLAGWorkloadContainerProtectionContainer() (*AzureSQLAGWorkloadContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureSQLContainer is the BasicProtectionContainer implementation for AzureSQLContainer.
func (asc AzureSQLContainer) AsAzureSQLContainer() (*AzureSQLContainer, bool) {
	return &asc, true
}

// AsAzureStorageContainer is the BasicProtectionContainer implementation for AzureSQLContainer.
func (asc AzureSQLContainer) AsAzureStorageContainer() (*AzureStorageContainer, bool) {
	return nil, false
}

// AsAzureVMAppContainerProtectionContainer is the BasicProtectionContainer implementation for AzureSQLContainer.
func (asc AzureSQLContainer) AsAzureVMAppContainerProtectionContainer() (*AzureVMAppContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureWorkloadContainer is the BasicProtectionContainer implementation for AzureSQLContainer.
func (asc AzureSQLContainer) AsAzureWorkloadContainer() (*AzureWorkloadContainer, bool) {
	return nil, false
}

// AsBasicAzureWorkloadContainer is the BasicProtectionContainer implementation for AzureSQLContainer.
func (asc AzureSQLContainer) AsBasicAzureWorkloadContainer() (BasicAzureWorkloadContainer, bool) {
	return nil, false
}

// AsDpmContainer is the BasicProtectionContainer implementation for AzureSQLContainer.
func (asc AzureSQLContainer) AsDpmContainer() (*DpmContainer, bool) {
	return nil, false
}

// AsBasicDpmContainer is the BasicProtectionContainer implementation for AzureSQLContainer.
func (asc AzureSQLContainer) AsBasicDpmContainer() (BasicDpmContainer, bool) {
	return nil, false
}

// AsGenericContainer is the BasicProtectionContainer implementation for AzureSQLContainer.
func (asc AzureSQLContainer) AsGenericContainer() (*GenericContainer, bool) {
	return nil, false
}

// AsIaaSVMContainer is the BasicProtectionContainer implementation for AzureSQLContainer.
func (asc AzureSQLContainer) AsIaaSVMContainer() (*IaaSVMContainer, bool) {
	return nil, false
}

// AsBasicIaaSVMContainer is the BasicProtectionContainer implementation for AzureSQLContainer.
func (asc AzureSQLContainer) AsBasicIaaSVMContainer() (BasicIaaSVMContainer, bool) {
	return nil, false
}

// AsMabContainer is the BasicProtectionContainer implementation for AzureSQLContainer.
func (asc AzureSQLContainer) AsMabContainer() (*MabContainer, bool) {
	return nil, false
}

// AsProtectionContainer is the BasicProtectionContainer implementation for AzureSQLContainer.
func (asc AzureSQLContainer) AsProtectionContainer() (*ProtectionContainer, bool) {
	return nil, false
}

// AsBasicProtectionContainer is the BasicProtectionContainer implementation for AzureSQLContainer.
func (asc AzureSQLContainer) AsBasicProtectionContainer() (BasicProtectionContainer, bool) {
	return &asc, true
}

// AzureStorageContainer azure Storage Account workload-specific container.
type AzureStorageContainer struct {
	// SourceResourceID - Fully qualified ARM url.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
	// StorageAccountVersion - Storage account version.
	StorageAccountVersion *string `json:"storageAccountVersion,omitempty"`
	// ResourceGroup - Resource group name of Recovery Services Vault.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// ProtectedItemCount - Number of items backed up in this container.
	ProtectedItemCount *int64 `json:"protectedItemCount,omitempty"`
	// FriendlyName - Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - Type of backup management for the container. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// RegistrationStatus - Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
	// HealthStatus - Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// ContainerType - Possible values include: 'ContainerTypeProtectionContainer', 'ContainerTypeAzureBackupServerContainer1', 'ContainerTypeMicrosoftClassicComputevirtualMachines', 'ContainerTypeMicrosoftComputevirtualMachines', 'ContainerTypeSQLAGWorkLoadContainer1', 'ContainerTypeAzureSQLContainer1', 'ContainerTypeStorageContainer1', 'ContainerTypeVMAppContainer1', 'ContainerTypeAzureWorkloadContainer', 'ContainerTypeDPMContainer1', 'ContainerTypeGenericContainer1', 'ContainerTypeIaaSVMContainer', 'ContainerTypeWindows1'
	ContainerType ContainerTypeBasicProtectionContainer `json:"containerType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureStorageContainer.
func (asc AzureStorageContainer) MarshalJSON() ([]byte, error) {
	asc.ContainerType = ContainerTypeStorageContainer1
	objectMap := make(map[string]interface{})
	if asc.SourceResourceID != nil {
		objectMap["sourceResourceId"] = asc.SourceResourceID
	}
	if asc.StorageAccountVersion != nil {
		objectMap["storageAccountVersion"] = asc.StorageAccountVersion
	}
	if asc.ResourceGroup != nil {
		objectMap["resourceGroup"] = asc.ResourceGroup
	}
	if asc.ProtectedItemCount != nil {
		objectMap["protectedItemCount"] = asc.ProtectedItemCount
	}
	if asc.FriendlyName != nil {
		objectMap["friendlyName"] = asc.FriendlyName
	}
	if asc.BackupManagementType != "" {
		objectMap["backupManagementType"] = asc.BackupManagementType
	}
	if asc.RegistrationStatus != nil {
		objectMap["registrationStatus"] = asc.RegistrationStatus
	}
	if asc.HealthStatus != nil {
		objectMap["healthStatus"] = asc.HealthStatus
	}
	if asc.ContainerType != "" {
		objectMap["containerType"] = asc.ContainerType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupServerContainer is the BasicProtectionContainer implementation for AzureStorageContainer.
func (asc AzureStorageContainer) AsAzureBackupServerContainer() (*AzureBackupServerContainer, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMContainer is the BasicProtectionContainer implementation for AzureStorageContainer.
func (asc AzureStorageContainer) AsAzureIaaSClassicComputeVMContainer() (*AzureIaaSClassicComputeVMContainer, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMContainer is the BasicProtectionContainer implementation for AzureStorageContainer.
func (asc AzureStorageContainer) AsAzureIaaSComputeVMContainer() (*AzureIaaSComputeVMContainer, bool) {
	return nil, false
}

// AsAzureSQLAGWorkloadContainerProtectionContainer is the BasicProtectionContainer implementation for AzureStorageContainer.
func (asc AzureStorageContainer) AsAzureSQLAGWorkloadContainerProtectionContainer() (*AzureSQLAGWorkloadContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureSQLContainer is the BasicProtectionContainer implementation for AzureStorageContainer.
func (asc AzureStorageContainer) AsAzureSQLContainer() (*AzureSQLContainer, bool) {
	return nil, false
}

// AsAzureStorageContainer is the BasicProtectionContainer implementation for AzureStorageContainer.
func (asc AzureStorageContainer) AsAzureStorageContainer() (*AzureStorageContainer, bool) {
	return &asc, true
}

// AsAzureVMAppContainerProtectionContainer is the BasicProtectionContainer implementation for AzureStorageContainer.
func (asc AzureStorageContainer) AsAzureVMAppContainerProtectionContainer() (*AzureVMAppContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureWorkloadContainer is the BasicProtectionContainer implementation for AzureStorageContainer.
func (asc AzureStorageContainer) AsAzureWorkloadContainer() (*AzureWorkloadContainer, bool) {
	return nil, false
}

// AsBasicAzureWorkloadContainer is the BasicProtectionContainer implementation for AzureStorageContainer.
func (asc AzureStorageContainer) AsBasicAzureWorkloadContainer() (BasicAzureWorkloadContainer, bool) {
	return nil, false
}

// AsDpmContainer is the BasicProtectionContainer implementation for AzureStorageContainer.
func (asc AzureStorageContainer) AsDpmContainer() (*DpmContainer, bool) {
	return nil, false
}

// AsBasicDpmContainer is the BasicProtectionContainer implementation for AzureStorageContainer.
func (asc AzureStorageContainer) AsBasicDpmContainer() (BasicDpmContainer, bool) {
	return nil, false
}

// AsGenericContainer is the BasicProtectionContainer implementation for AzureStorageContainer.
func (asc AzureStorageContainer) AsGenericContainer() (*GenericContainer, bool) {
	return nil, false
}

// AsIaaSVMContainer is the BasicProtectionContainer implementation for AzureStorageContainer.
func (asc AzureStorageContainer) AsIaaSVMContainer() (*IaaSVMContainer, bool) {
	return nil, false
}

// AsBasicIaaSVMContainer is the BasicProtectionContainer implementation for AzureStorageContainer.
func (asc AzureStorageContainer) AsBasicIaaSVMContainer() (BasicIaaSVMContainer, bool) {
	return nil, false
}

// AsMabContainer is the BasicProtectionContainer implementation for AzureStorageContainer.
func (asc AzureStorageContainer) AsMabContainer() (*MabContainer, bool) {
	return nil, false
}

// AsProtectionContainer is the BasicProtectionContainer implementation for AzureStorageContainer.
func (asc AzureStorageContainer) AsProtectionContainer() (*ProtectionContainer, bool) {
	return nil, false
}

// AsBasicProtectionContainer is the BasicProtectionContainer implementation for AzureStorageContainer.
func (asc AzureStorageContainer) AsBasicProtectionContainer() (BasicProtectionContainer, bool) {
	return &asc, true
}

// AzureStorageProtectableContainer azure Storage-specific protectable containers
type AzureStorageProtectableContainer struct {
	// FriendlyName - Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - Type of backup management for the container. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// HealthStatus - Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// ContainerID - Fabric Id of the container such as ARM Id.
	ContainerID *string `json:"containerId,omitempty"`
	// ProtectableContainerType - Possible values include: 'ProtectableContainerTypeProtectableContainer', 'ProtectableContainerTypeStorageContainer', 'ProtectableContainerTypeVMAppContainer'
	ProtectableContainerType ProtectableContainerType `json:"protectableContainerType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureStorageProtectableContainer.
func (aspc AzureStorageProtectableContainer) MarshalJSON() ([]byte, error) {
	aspc.ProtectableContainerType = ProtectableContainerTypeStorageContainer
	objectMap := make(map[string]interface{})
	if aspc.FriendlyName != nil {
		objectMap["friendlyName"] = aspc.FriendlyName
	}
	if aspc.BackupManagementType != "" {
		objectMap["backupManagementType"] = aspc.BackupManagementType
	}
	if aspc.HealthStatus != nil {
		objectMap["healthStatus"] = aspc.HealthStatus
	}
	if aspc.ContainerID != nil {
		objectMap["containerId"] = aspc.ContainerID
	}
	if aspc.ProtectableContainerType != "" {
		objectMap["protectableContainerType"] = aspc.ProtectableContainerType
	}
	return json.Marshal(objectMap)
}

// AsAzureStorageProtectableContainer is the BasicProtectableContainer implementation for AzureStorageProtectableContainer.
func (aspc AzureStorageProtectableContainer) AsAzureStorageProtectableContainer() (*AzureStorageProtectableContainer, bool) {
	return &aspc, true
}

// AsAzureVMAppContainerProtectableContainer is the BasicProtectableContainer implementation for AzureStorageProtectableContainer.
func (aspc AzureStorageProtectableContainer) AsAzureVMAppContainerProtectableContainer() (*AzureVMAppContainerProtectableContainer, bool) {
	return nil, false
}

// AsProtectableContainer is the BasicProtectableContainer implementation for AzureStorageProtectableContainer.
func (aspc AzureStorageProtectableContainer) AsProtectableContainer() (*ProtectableContainer, bool) {
	return nil, false
}

// AsBasicProtectableContainer is the BasicProtectableContainer implementation for AzureStorageProtectableContainer.
func (aspc AzureStorageProtectableContainer) AsBasicProtectableContainer() (BasicProtectableContainer, bool) {
	return &aspc, true
}

// AzureVMAppContainerProtectableContainer azure workload-specific container
type AzureVMAppContainerProtectableContainer struct {
	// FriendlyName - Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - Type of backup management for the container. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// HealthStatus - Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// ContainerID - Fabric Id of the container such as ARM Id.
	ContainerID *string `json:"containerId,omitempty"`
	// ProtectableContainerType - Possible values include: 'ProtectableContainerTypeProtectableContainer', 'ProtectableContainerTypeStorageContainer', 'ProtectableContainerTypeVMAppContainer'
	ProtectableContainerType ProtectableContainerType `json:"protectableContainerType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureVMAppContainerProtectableContainer.
func (avacpc AzureVMAppContainerProtectableContainer) MarshalJSON() ([]byte, error) {
	avacpc.ProtectableContainerType = ProtectableContainerTypeVMAppContainer
	objectMap := make(map[string]interface{})
	if avacpc.FriendlyName != nil {
		objectMap["friendlyName"] = avacpc.FriendlyName
	}
	if avacpc.BackupManagementType != "" {
		objectMap["backupManagementType"] = avacpc.BackupManagementType
	}
	if avacpc.HealthStatus != nil {
		objectMap["healthStatus"] = avacpc.HealthStatus
	}
	if avacpc.ContainerID != nil {
		objectMap["containerId"] = avacpc.ContainerID
	}
	if avacpc.ProtectableContainerType != "" {
		objectMap["protectableContainerType"] = avacpc.ProtectableContainerType
	}
	return json.Marshal(objectMap)
}

// AsAzureStorageProtectableContainer is the BasicProtectableContainer implementation for AzureVMAppContainerProtectableContainer.
func (avacpc AzureVMAppContainerProtectableContainer) AsAzureStorageProtectableContainer() (*AzureStorageProtectableContainer, bool) {
	return nil, false
}

// AsAzureVMAppContainerProtectableContainer is the BasicProtectableContainer implementation for AzureVMAppContainerProtectableContainer.
func (avacpc AzureVMAppContainerProtectableContainer) AsAzureVMAppContainerProtectableContainer() (*AzureVMAppContainerProtectableContainer, bool) {
	return &avacpc, true
}

// AsProtectableContainer is the BasicProtectableContainer implementation for AzureVMAppContainerProtectableContainer.
func (avacpc AzureVMAppContainerProtectableContainer) AsProtectableContainer() (*ProtectableContainer, bool) {
	return nil, false
}

// AsBasicProtectableContainer is the BasicProtectableContainer implementation for AzureVMAppContainerProtectableContainer.
func (avacpc AzureVMAppContainerProtectableContainer) AsBasicProtectableContainer() (BasicProtectableContainer, bool) {
	return &avacpc, true
}

// AzureVMAppContainerProtectionContainer container for SQL workloads under Azure Virtual Machines.
type AzureVMAppContainerProtectionContainer struct {
	// SourceResourceID - ARM ID of the virtual machine represented by this Azure Workload Container
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
	// LastUpdatedTime - Time stamp when this container was updated.
	LastUpdatedTime *date.Time `json:"lastUpdatedTime,omitempty"`
	// ExtendedInfo - Additional details of a workload container.
	ExtendedInfo *AzureWorkloadContainerExtendedInfo `json:"extendedInfo,omitempty"`
	// WorkloadType - Workload type for which registration was sent. Possible values include: 'WorkloadTypeInvalid', 'WorkloadTypeVM', 'WorkloadTypeFileFolder', 'WorkloadTypeAzureSQLDb', 'WorkloadTypeSQLDB', 'WorkloadTypeExchange', 'WorkloadTypeSharepoint', 'WorkloadTypeVMwareVM', 'WorkloadTypeSystemState', 'WorkloadTypeClient', 'WorkloadTypeGenericDataSource', 'WorkloadTypeSQLDataBase', 'WorkloadTypeAzureFileShare', 'WorkloadTypeSAPHanaDatabase', 'WorkloadTypeSAPAseDatabase'
	WorkloadType WorkloadType `json:"workloadType,omitempty"`
	// OperationType - Re-Do Operation. Possible values include: 'OperationTypeInvalid', 'OperationTypeRegister', 'OperationTypeReregister'
	OperationType OperationType `json:"operationType,omitempty"`
	// FriendlyName - Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - Type of backup management for the container. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// RegistrationStatus - Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
	// HealthStatus - Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// ContainerType - Possible values include: 'ContainerTypeProtectionContainer', 'ContainerTypeAzureBackupServerContainer1', 'ContainerTypeMicrosoftClassicComputevirtualMachines', 'ContainerTypeMicrosoftComputevirtualMachines', 'ContainerTypeSQLAGWorkLoadContainer1', 'ContainerTypeAzureSQLContainer1', 'ContainerTypeStorageContainer1', 'ContainerTypeVMAppContainer1', 'ContainerTypeAzureWorkloadContainer', 'ContainerTypeDPMContainer1', 'ContainerTypeGenericContainer1', 'ContainerTypeIaaSVMContainer', 'ContainerTypeWindows1'
	ContainerType ContainerTypeBasicProtectionContainer `json:"containerType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureVMAppContainerProtectionContainer.
func (avacpc AzureVMAppContainerProtectionContainer) MarshalJSON() ([]byte, error) {
	avacpc.ContainerType = ContainerTypeVMAppContainer1
	objectMap := make(map[string]interface{})
	if avacpc.SourceResourceID != nil {
		objectMap["sourceResourceId"] = avacpc.SourceResourceID
	}
	if avacpc.LastUpdatedTime != nil {
		objectMap["lastUpdatedTime"] = avacpc.LastUpdatedTime
	}
	if avacpc.ExtendedInfo != nil {
		objectMap["extendedInfo"] = avacpc.ExtendedInfo
	}
	if avacpc.WorkloadType != "" {
		objectMap["workloadType"] = avacpc.WorkloadType
	}
	if avacpc.OperationType != "" {
		objectMap["operationType"] = avacpc.OperationType
	}
	if avacpc.FriendlyName != nil {
		objectMap["friendlyName"] = avacpc.FriendlyName
	}
	if avacpc.BackupManagementType != "" {
		objectMap["backupManagementType"] = avacpc.BackupManagementType
	}
	if avacpc.RegistrationStatus != nil {
		objectMap["registrationStatus"] = avacpc.RegistrationStatus
	}
	if avacpc.HealthStatus != nil {
		objectMap["healthStatus"] = avacpc.HealthStatus
	}
	if avacpc.ContainerType != "" {
		objectMap["containerType"] = avacpc.ContainerType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupServerContainer is the BasicProtectionContainer implementation for AzureVMAppContainerProtectionContainer.
func (avacpc AzureVMAppContainerProtectionContainer) AsAzureBackupServerContainer() (*AzureBackupServerContainer, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMContainer is the BasicProtectionContainer implementation for AzureVMAppContainerProtectionContainer.
func (avacpc AzureVMAppContainerProtectionContainer) AsAzureIaaSClassicComputeVMContainer() (*AzureIaaSClassicComputeVMContainer, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMContainer is the BasicProtectionContainer implementation for AzureVMAppContainerProtectionContainer.
func (avacpc AzureVMAppContainerProtectionContainer) AsAzureIaaSComputeVMContainer() (*AzureIaaSComputeVMContainer, bool) {
	return nil, false
}

// AsAzureSQLAGWorkloadContainerProtectionContainer is the BasicProtectionContainer implementation for AzureVMAppContainerProtectionContainer.
func (avacpc AzureVMAppContainerProtectionContainer) AsAzureSQLAGWorkloadContainerProtectionContainer() (*AzureSQLAGWorkloadContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureSQLContainer is the BasicProtectionContainer implementation for AzureVMAppContainerProtectionContainer.
func (avacpc AzureVMAppContainerProtectionContainer) AsAzureSQLContainer() (*AzureSQLContainer, bool) {
	return nil, false
}

// AsAzureStorageContainer is the BasicProtectionContainer implementation for AzureVMAppContainerProtectionContainer.
func (avacpc AzureVMAppContainerProtectionContainer) AsAzureStorageContainer() (*AzureStorageContainer, bool) {
	return nil, false
}

// AsAzureVMAppContainerProtectionContainer is the BasicProtectionContainer implementation for AzureVMAppContainerProtectionContainer.
func (avacpc AzureVMAppContainerProtectionContainer) AsAzureVMAppContainerProtectionContainer() (*AzureVMAppContainerProtectionContainer, bool) {
	return &avacpc, true
}

// AsAzureWorkloadContainer is the BasicProtectionContainer implementation for AzureVMAppContainerProtectionContainer.
func (avacpc AzureVMAppContainerProtectionContainer) AsAzureWorkloadContainer() (*AzureWorkloadContainer, bool) {
	return nil, false
}

// AsBasicAzureWorkloadContainer is the BasicProtectionContainer implementation for AzureVMAppContainerProtectionContainer.
func (avacpc AzureVMAppContainerProtectionContainer) AsBasicAzureWorkloadContainer() (BasicAzureWorkloadContainer, bool) {
	return &avacpc, true
}

// AsDpmContainer is the BasicProtectionContainer implementation for AzureVMAppContainerProtectionContainer.
func (avacpc AzureVMAppContainerProtectionContainer) AsDpmContainer() (*DpmContainer, bool) {
	return nil, false
}

// AsBasicDpmContainer is the BasicProtectionContainer implementation for AzureVMAppContainerProtectionContainer.
func (avacpc AzureVMAppContainerProtectionContainer) AsBasicDpmContainer() (BasicDpmContainer, bool) {
	return nil, false
}

// AsGenericContainer is the BasicProtectionContainer implementation for AzureVMAppContainerProtectionContainer.
func (avacpc AzureVMAppContainerProtectionContainer) AsGenericContainer() (*GenericContainer, bool) {
	return nil, false
}

// AsIaaSVMContainer is the BasicProtectionContainer implementation for AzureVMAppContainerProtectionContainer.
func (avacpc AzureVMAppContainerProtectionContainer) AsIaaSVMContainer() (*IaaSVMContainer, bool) {
	return nil, false
}

// AsBasicIaaSVMContainer is the BasicProtectionContainer implementation for AzureVMAppContainerProtectionContainer.
func (avacpc AzureVMAppContainerProtectionContainer) AsBasicIaaSVMContainer() (BasicIaaSVMContainer, bool) {
	return nil, false
}

// AsMabContainer is the BasicProtectionContainer implementation for AzureVMAppContainerProtectionContainer.
func (avacpc AzureVMAppContainerProtectionContainer) AsMabContainer() (*MabContainer, bool) {
	return nil, false
}

// AsProtectionContainer is the BasicProtectionContainer implementation for AzureVMAppContainerProtectionContainer.
func (avacpc AzureVMAppContainerProtectionContainer) AsProtectionContainer() (*ProtectionContainer, bool) {
	return nil, false
}

// AsBasicProtectionContainer is the BasicProtectionContainer implementation for AzureVMAppContainerProtectionContainer.
func (avacpc AzureVMAppContainerProtectionContainer) AsBasicProtectionContainer() (BasicProtectionContainer, bool) {
	return &avacpc, true
}

// BasicAzureVMWorkloadItem azure VM workload-specific workload item.
type BasicAzureVMWorkloadItem interface {
	AsAzureVMWorkloadSAPAseDatabaseWorkloadItem() (*AzureVMWorkloadSAPAseDatabaseWorkloadItem, bool)
	AsAzureVMWorkloadSAPAseSystemWorkloadItem() (*AzureVMWorkloadSAPAseSystemWorkloadItem, bool)
	AsAzureVMWorkloadSAPHanaDatabaseWorkloadItem() (*AzureVMWorkloadSAPHanaDatabaseWorkloadItem, bool)
	AsAzureVMWorkloadSAPHanaSystemWorkloadItem() (*AzureVMWorkloadSAPHanaSystemWorkloadItem, bool)
	AsAzureVMWorkloadSQLDatabaseWorkloadItem() (*AzureVMWorkloadSQLDatabaseWorkloadItem, bool)
	AsAzureVMWorkloadSQLInstanceWorkloadItem() (*AzureVMWorkloadSQLInstanceWorkloadItem, bool)
	AsAzureVMWorkloadItem() (*AzureVMWorkloadItem, bool)
}

// AzureVMWorkloadItem azure VM workload-specific workload item.
type AzureVMWorkloadItem struct {
	// ParentName - Name for instance or AG
	ParentName *string `json:"parentName,omitempty"`
	// ServerName - Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`
	// IsAutoProtectable - Indicates if workload item is auto-protectable
	IsAutoProtectable *bool `json:"isAutoProtectable,omitempty"`
	// Subinquireditemcount - For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32 `json:"subinquireditemcount,omitempty"`
	// SubWorkloadItemCount - For instance or AG, indicates number of DB's to be protected
	SubWorkloadItemCount *int32 `json:"subWorkloadItemCount,omitempty"`
	// BackupManagementType - Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
	// FriendlyName - Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionState - State of the back up item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// WorkloadItemType - Possible values include: 'WorkloadItemTypeWorkloadItem', 'WorkloadItemTypeAzureVMWorkloadItem', 'WorkloadItemTypeSAPAseDatabase1', 'WorkloadItemTypeSAPAseSystem1', 'WorkloadItemTypeSAPHanaDatabase1', 'WorkloadItemTypeSAPHanaSystem1', 'WorkloadItemTypeSQLDataBase1', 'WorkloadItemTypeSQLInstance1'
	WorkloadItemType WorkloadItemTypeBasicWorkloadItem `json:"workloadItemType,omitempty"`
}

func unmarshalBasicAzureVMWorkloadItem(body []byte) (BasicAzureVMWorkloadItem, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["workloadItemType"] {
	case string(WorkloadItemTypeSAPAseDatabase1):
		var avwsadwi AzureVMWorkloadSAPAseDatabaseWorkloadItem
		err := json.Unmarshal(body, &avwsadwi)
		return avwsadwi, err
	case string(WorkloadItemTypeSAPAseSystem1):
		var avwsaswi AzureVMWorkloadSAPAseSystemWorkloadItem
		err := json.Unmarshal(body, &avwsaswi)
		return avwsaswi, err
	case string(WorkloadItemTypeSAPHanaDatabase1):
		var avwshdwi AzureVMWorkloadSAPHanaDatabaseWorkloadItem
		err := json.Unmarshal(body, &avwshdwi)
		return avwshdwi, err
	case string(WorkloadItemTypeSAPHanaSystem1):
		var avwshswi AzureVMWorkloadSAPHanaSystemWorkloadItem
		err := json.Unmarshal(body, &avwshswi)
		return avwshswi, err
	case string(WorkloadItemTypeSQLDataBase1):
		var avwsdwi AzureVMWorkloadSQLDatabaseWorkloadItem
		err := json.Unmarshal(body, &avwsdwi)
		return avwsdwi, err
	case string(WorkloadItemTypeSQLInstance1):
		var avwsiwi AzureVMWorkloadSQLInstanceWorkloadItem
		err := json.Unmarshal(body, &avwsiwi)
		return avwsiwi, err
	default:
		var avwi AzureVMWorkloadItem
		err := json.Unmarshal(body, &avwi)
		return avwi, err
	}
}
func unmarshalBasicAzureVMWorkloadItemArray(body []byte) ([]BasicAzureVMWorkloadItem, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	avwiArray := make([]BasicAzureVMWorkloadItem, len(rawMessages))

	for index, rawMessage := range rawMessages {
		avwi, err := unmarshalBasicAzureVMWorkloadItem(*rawMessage)
		if err != nil {
			return nil, err
		}
		avwiArray[index] = avwi
	}
	return avwiArray, nil
}

// MarshalJSON is the custom marshaler for AzureVMWorkloadItem.
func (avwi AzureVMWorkloadItem) MarshalJSON() ([]byte, error) {
	avwi.WorkloadItemType = WorkloadItemTypeAzureVMWorkloadItem
	objectMap := make(map[string]interface{})
	if avwi.ParentName != nil {
		objectMap["parentName"] = avwi.ParentName
	}
	if avwi.ServerName != nil {
		objectMap["serverName"] = avwi.ServerName
	}
	if avwi.IsAutoProtectable != nil {
		objectMap["isAutoProtectable"] = avwi.IsAutoProtectable
	}
	if avwi.Subinquireditemcount != nil {
		objectMap["subinquireditemcount"] = avwi.Subinquireditemcount
	}
	if avwi.SubWorkloadItemCount != nil {
		objectMap["subWorkloadItemCount"] = avwi.SubWorkloadItemCount
	}
	if avwi.BackupManagementType != nil {
		objectMap["backupManagementType"] = avwi.BackupManagementType
	}
	if avwi.WorkloadType != nil {
		objectMap["workloadType"] = avwi.WorkloadType
	}
	if avwi.FriendlyName != nil {
		objectMap["friendlyName"] = avwi.FriendlyName
	}
	if avwi.ProtectionState != "" {
		objectMap["protectionState"] = avwi.ProtectionState
	}
	if avwi.WorkloadItemType != "" {
		objectMap["workloadItemType"] = avwi.WorkloadItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureVMWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadItem.
func (avwi AzureVMWorkloadItem) AsAzureVMWorkloadItem() (*AzureVMWorkloadItem, bool) {
	return &avwi, true
}

// AsBasicAzureVMWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadItem.
func (avwi AzureVMWorkloadItem) AsBasicAzureVMWorkloadItem() (BasicAzureVMWorkloadItem, bool) {
	return &avwi, true
}

// AsAzureVMWorkloadSAPAseDatabaseWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadItem.
func (avwi AzureVMWorkloadItem) AsAzureVMWorkloadSAPAseDatabaseWorkloadItem() (*AzureVMWorkloadSAPAseDatabaseWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPAseSystemWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadItem.
func (avwi AzureVMWorkloadItem) AsAzureVMWorkloadSAPAseSystemWorkloadItem() (*AzureVMWorkloadSAPAseSystemWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadItem.
func (avwi AzureVMWorkloadItem) AsAzureVMWorkloadSAPHanaDatabaseWorkloadItem() (*AzureVMWorkloadSAPHanaDatabaseWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaSystemWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadItem.
func (avwi AzureVMWorkloadItem) AsAzureVMWorkloadSAPHanaSystemWorkloadItem() (*AzureVMWorkloadSAPHanaSystemWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadItem.
func (avwi AzureVMWorkloadItem) AsAzureVMWorkloadSQLDatabaseWorkloadItem() (*AzureVMWorkloadSQLDatabaseWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLInstanceWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadItem.
func (avwi AzureVMWorkloadItem) AsAzureVMWorkloadSQLInstanceWorkloadItem() (*AzureVMWorkloadSQLInstanceWorkloadItem, bool) {
	return nil, false
}

// AsWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadItem.
func (avwi AzureVMWorkloadItem) AsWorkloadItem() (*WorkloadItem, bool) {
	return nil, false
}

// AsBasicWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadItem.
func (avwi AzureVMWorkloadItem) AsBasicWorkloadItem() (BasicWorkloadItem, bool) {
	return &avwi, true
}

// BasicAzureVMWorkloadProtectableItem azure VM workload-specific protectable item.
type BasicAzureVMWorkloadProtectableItem interface {
	AsAzureVMWorkloadSAPAseSystemProtectableItem() (*AzureVMWorkloadSAPAseSystemProtectableItem, bool)
	AsAzureVMWorkloadSAPHanaDatabaseProtectableItem() (*AzureVMWorkloadSAPHanaDatabaseProtectableItem, bool)
	AsAzureVMWorkloadSAPHanaSystemProtectableItem() (*AzureVMWorkloadSAPHanaSystemProtectableItem, bool)
	AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem() (*AzureVMWorkloadSQLAvailabilityGroupProtectableItem, bool)
	AsAzureVMWorkloadSQLDatabaseProtectableItem() (*AzureVMWorkloadSQLDatabaseProtectableItem, bool)
	AsAzureVMWorkloadSQLInstanceProtectableItem() (*AzureVMWorkloadSQLInstanceProtectableItem, bool)
	AsAzureVMWorkloadProtectableItem() (*AzureVMWorkloadProtectableItem, bool)
}

// AzureVMWorkloadProtectableItem azure VM workload-specific protectable item.
type AzureVMWorkloadProtectableItem struct {
	// ParentName - Name for instance or AG
	ParentName *string `json:"parentName,omitempty"`
	// ParentUniqueName - Parent Unique Name is added to provide the service formatted URI Name of the Parent
	// Only Applicable for data bases where the parent would be either Instance or a SQL AG.
	ParentUniqueName *string `json:"parentUniqueName,omitempty"`
	// ServerName - Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`
	// IsAutoProtectable - Indicates if protectable item is auto-protectable
	IsAutoProtectable *bool `json:"isAutoProtectable,omitempty"`
	// IsAutoProtected - Indicates if protectable item is auto-protected
	IsAutoProtected *bool `json:"isAutoProtected,omitempty"`
	// Subinquireditemcount - For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32 `json:"subinquireditemcount,omitempty"`
	// Subprotectableitemcount - For instance or AG, indicates number of DB's to be protected
	Subprotectableitemcount *int32 `json:"subprotectableitemcount,omitempty"`
	// Prebackupvalidation - Pre-backup validation for protectable objects
	Prebackupvalidation *PreBackupValidation `json:"prebackupvalidation,omitempty"`
	// BackupManagementType - Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
	// FriendlyName - Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionState - State of the back up item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// ProtectableItemType - Possible values include: 'ProtectableItemTypeWorkloadProtectableItem', 'ProtectableItemTypeAzureFileShare', 'ProtectableItemTypeMicrosoftClassicComputevirtualMachines', 'ProtectableItemTypeMicrosoftComputevirtualMachines', 'ProtectableItemTypeAzureVMWorkloadProtectableItem', 'ProtectableItemTypeSAPAseSystem', 'ProtectableItemTypeSAPHanaDatabase', 'ProtectableItemTypeSAPHanaSystem', 'ProtectableItemTypeSQLAvailabilityGroupContainer', 'ProtectableItemTypeSQLDataBase', 'ProtectableItemTypeSQLInstance', 'ProtectableItemTypeIaaSVMProtectableItem'
	ProtectableItemType ProtectableItemType `json:"protectableItemType,omitempty"`
}

func unmarshalBasicAzureVMWorkloadProtectableItem(body []byte) (BasicAzureVMWorkloadProtectableItem, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["protectableItemType"] {
	case string(ProtectableItemTypeSAPAseSystem):
		var avwsaspi AzureVMWorkloadSAPAseSystemProtectableItem
		err := json.Unmarshal(body, &avwsaspi)
		return avwsaspi, err
	case string(ProtectableItemTypeSAPHanaDatabase):
		var avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectableItem
		err := json.Unmarshal(body, &avwshdpi)
		return avwshdpi, err
	case string(ProtectableItemTypeSAPHanaSystem):
		var avwshspi AzureVMWorkloadSAPHanaSystemProtectableItem
		err := json.Unmarshal(body, &avwshspi)
		return avwshspi, err
	case string(ProtectableItemTypeSQLAvailabilityGroupContainer):
		var avwsagpi AzureVMWorkloadSQLAvailabilityGroupProtectableItem
		err := json.Unmarshal(body, &avwsagpi)
		return avwsagpi, err
	case string(ProtectableItemTypeSQLDataBase):
		var avwsdpi AzureVMWorkloadSQLDatabaseProtectableItem
		err := json.Unmarshal(body, &avwsdpi)
		return avwsdpi, err
	case string(ProtectableItemTypeSQLInstance):
		var avwsipi AzureVMWorkloadSQLInstanceProtectableItem
		err := json.Unmarshal(body, &avwsipi)
		return avwsipi, err
	default:
		var avwpi AzureVMWorkloadProtectableItem
		err := json.Unmarshal(body, &avwpi)
		return avwpi, err
	}
}
func unmarshalBasicAzureVMWorkloadProtectableItemArray(body []byte) ([]BasicAzureVMWorkloadProtectableItem, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	avwpiArray := make([]BasicAzureVMWorkloadProtectableItem, len(rawMessages))

	for index, rawMessage := range rawMessages {
		avwpi, err := unmarshalBasicAzureVMWorkloadProtectableItem(*rawMessage)
		if err != nil {
			return nil, err
		}
		avwpiArray[index] = avwpi
	}
	return avwpiArray, nil
}

// MarshalJSON is the custom marshaler for AzureVMWorkloadProtectableItem.
func (avwpi AzureVMWorkloadProtectableItem) MarshalJSON() ([]byte, error) {
	avwpi.ProtectableItemType = ProtectableItemTypeAzureVMWorkloadProtectableItem
	objectMap := make(map[string]interface{})
	if avwpi.ParentName != nil {
		objectMap["parentName"] = avwpi.ParentName
	}
	if avwpi.ParentUniqueName != nil {
		objectMap["parentUniqueName"] = avwpi.ParentUniqueName
	}
	if avwpi.ServerName != nil {
		objectMap["serverName"] = avwpi.ServerName
	}
	if avwpi.IsAutoProtectable != nil {
		objectMap["isAutoProtectable"] = avwpi.IsAutoProtectable
	}
	if avwpi.IsAutoProtected != nil {
		objectMap["isAutoProtected"] = avwpi.IsAutoProtected
	}
	if avwpi.Subinquireditemcount != nil {
		objectMap["subinquireditemcount"] = avwpi.Subinquireditemcount
	}
	if avwpi.Subprotectableitemcount != nil {
		objectMap["subprotectableitemcount"] = avwpi.Subprotectableitemcount
	}
	if avwpi.Prebackupvalidation != nil {
		objectMap["prebackupvalidation"] = avwpi.Prebackupvalidation
	}
	if avwpi.BackupManagementType != nil {
		objectMap["backupManagementType"] = avwpi.BackupManagementType
	}
	if avwpi.WorkloadType != nil {
		objectMap["workloadType"] = avwpi.WorkloadType
	}
	if avwpi.FriendlyName != nil {
		objectMap["friendlyName"] = avwpi.FriendlyName
	}
	if avwpi.ProtectionState != "" {
		objectMap["protectionState"] = avwpi.ProtectionState
	}
	if avwpi.ProtectableItemType != "" {
		objectMap["protectableItemType"] = avwpi.ProtectableItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadProtectableItem.
func (avwpi AzureVMWorkloadProtectableItem) AsAzureFileShareProtectableItem() (*AzureFileShareProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadProtectableItem.
func (avwpi AzureVMWorkloadProtectableItem) AsAzureIaaSClassicComputeVMProtectableItem() (*AzureIaaSClassicComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadProtectableItem.
func (avwpi AzureVMWorkloadProtectableItem) AsAzureIaaSComputeVMProtectableItem() (*AzureIaaSComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadProtectableItem.
func (avwpi AzureVMWorkloadProtectableItem) AsAzureVMWorkloadProtectableItem() (*AzureVMWorkloadProtectableItem, bool) {
	return &avwpi, true
}

// AsBasicAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadProtectableItem.
func (avwpi AzureVMWorkloadProtectableItem) AsBasicAzureVMWorkloadProtectableItem() (BasicAzureVMWorkloadProtectableItem, bool) {
	return &avwpi, true
}

// AsAzureVMWorkloadSAPAseSystemProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadProtectableItem.
func (avwpi AzureVMWorkloadProtectableItem) AsAzureVMWorkloadSAPAseSystemProtectableItem() (*AzureVMWorkloadSAPAseSystemProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadProtectableItem.
func (avwpi AzureVMWorkloadProtectableItem) AsAzureVMWorkloadSAPHanaDatabaseProtectableItem() (*AzureVMWorkloadSAPHanaDatabaseProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaSystemProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadProtectableItem.
func (avwpi AzureVMWorkloadProtectableItem) AsAzureVMWorkloadSAPHanaSystemProtectableItem() (*AzureVMWorkloadSAPHanaSystemProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadProtectableItem.
func (avwpi AzureVMWorkloadProtectableItem) AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem() (*AzureVMWorkloadSQLAvailabilityGroupProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadProtectableItem.
func (avwpi AzureVMWorkloadProtectableItem) AsAzureVMWorkloadSQLDatabaseProtectableItem() (*AzureVMWorkloadSQLDatabaseProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLInstanceProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadProtectableItem.
func (avwpi AzureVMWorkloadProtectableItem) AsAzureVMWorkloadSQLInstanceProtectableItem() (*AzureVMWorkloadSQLInstanceProtectableItem, bool) {
	return nil, false
}

// AsIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadProtectableItem.
func (avwpi AzureVMWorkloadProtectableItem) AsIaaSVMProtectableItem() (*IaaSVMProtectableItem, bool) {
	return nil, false
}

// AsBasicIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadProtectableItem.
func (avwpi AzureVMWorkloadProtectableItem) AsBasicIaaSVMProtectableItem() (BasicIaaSVMProtectableItem, bool) {
	return nil, false
}

// AsWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadProtectableItem.
func (avwpi AzureVMWorkloadProtectableItem) AsWorkloadProtectableItem() (*WorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadProtectableItem.
func (avwpi AzureVMWorkloadProtectableItem) AsBasicWorkloadProtectableItem() (BasicWorkloadProtectableItem, bool) {
	return &avwpi, true
}

// AzureVMWorkloadSAPAseDatabaseWorkloadItem azure VM workload-specific workload item representing SAP ASE
// Database.
type AzureVMWorkloadSAPAseDatabaseWorkloadItem struct {
	// ParentName - Name for instance or AG
	ParentName *string `json:"parentName,omitempty"`
	// ServerName - Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`
	// IsAutoProtectable - Indicates if workload item is auto-protectable
	IsAutoProtectable *bool `json:"isAutoProtectable,omitempty"`
	// Subinquireditemcount - For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32 `json:"subinquireditemcount,omitempty"`
	// SubWorkloadItemCount - For instance or AG, indicates number of DB's to be protected
	SubWorkloadItemCount *int32 `json:"subWorkloadItemCount,omitempty"`
	// BackupManagementType - Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
	// FriendlyName - Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionState - State of the back up item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// WorkloadItemType - Possible values include: 'WorkloadItemTypeWorkloadItem', 'WorkloadItemTypeAzureVMWorkloadItem', 'WorkloadItemTypeSAPAseDatabase1', 'WorkloadItemTypeSAPAseSystem1', 'WorkloadItemTypeSAPHanaDatabase1', 'WorkloadItemTypeSAPHanaSystem1', 'WorkloadItemTypeSQLDataBase1', 'WorkloadItemTypeSQLInstance1'
	WorkloadItemType WorkloadItemTypeBasicWorkloadItem `json:"workloadItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureVMWorkloadSAPAseDatabaseWorkloadItem.
func (avwsadwi AzureVMWorkloadSAPAseDatabaseWorkloadItem) MarshalJSON() ([]byte, error) {
	avwsadwi.WorkloadItemType = WorkloadItemTypeSAPAseDatabase1
	objectMap := make(map[string]interface{})
	if avwsadwi.ParentName != nil {
		objectMap["parentName"] = avwsadwi.ParentName
	}
	if avwsadwi.ServerName != nil {
		objectMap["serverName"] = avwsadwi.ServerName
	}
	if avwsadwi.IsAutoProtectable != nil {
		objectMap["isAutoProtectable"] = avwsadwi.IsAutoProtectable
	}
	if avwsadwi.Subinquireditemcount != nil {
		objectMap["subinquireditemcount"] = avwsadwi.Subinquireditemcount
	}
	if avwsadwi.SubWorkloadItemCount != nil {
		objectMap["subWorkloadItemCount"] = avwsadwi.SubWorkloadItemCount
	}
	if avwsadwi.BackupManagementType != nil {
		objectMap["backupManagementType"] = avwsadwi.BackupManagementType
	}
	if avwsadwi.WorkloadType != nil {
		objectMap["workloadType"] = avwsadwi.WorkloadType
	}
	if avwsadwi.FriendlyName != nil {
		objectMap["friendlyName"] = avwsadwi.FriendlyName
	}
	if avwsadwi.ProtectionState != "" {
		objectMap["protectionState"] = avwsadwi.ProtectionState
	}
	if avwsadwi.WorkloadItemType != "" {
		objectMap["workloadItemType"] = avwsadwi.WorkloadItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureVMWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPAseDatabaseWorkloadItem.
func (avwsadwi AzureVMWorkloadSAPAseDatabaseWorkloadItem) AsAzureVMWorkloadItem() (*AzureVMWorkloadItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPAseDatabaseWorkloadItem.
func (avwsadwi AzureVMWorkloadSAPAseDatabaseWorkloadItem) AsBasicAzureVMWorkloadItem() (BasicAzureVMWorkloadItem, bool) {
	return &avwsadwi, true
}

// AsAzureVMWorkloadSAPAseDatabaseWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPAseDatabaseWorkloadItem.
func (avwsadwi AzureVMWorkloadSAPAseDatabaseWorkloadItem) AsAzureVMWorkloadSAPAseDatabaseWorkloadItem() (*AzureVMWorkloadSAPAseDatabaseWorkloadItem, bool) {
	return &avwsadwi, true
}

// AsAzureVMWorkloadSAPAseSystemWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPAseDatabaseWorkloadItem.
func (avwsadwi AzureVMWorkloadSAPAseDatabaseWorkloadItem) AsAzureVMWorkloadSAPAseSystemWorkloadItem() (*AzureVMWorkloadSAPAseSystemWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPAseDatabaseWorkloadItem.
func (avwsadwi AzureVMWorkloadSAPAseDatabaseWorkloadItem) AsAzureVMWorkloadSAPHanaDatabaseWorkloadItem() (*AzureVMWorkloadSAPHanaDatabaseWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaSystemWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPAseDatabaseWorkloadItem.
func (avwsadwi AzureVMWorkloadSAPAseDatabaseWorkloadItem) AsAzureVMWorkloadSAPHanaSystemWorkloadItem() (*AzureVMWorkloadSAPHanaSystemWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPAseDatabaseWorkloadItem.
func (avwsadwi AzureVMWorkloadSAPAseDatabaseWorkloadItem) AsAzureVMWorkloadSQLDatabaseWorkloadItem() (*AzureVMWorkloadSQLDatabaseWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLInstanceWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPAseDatabaseWorkloadItem.
func (avwsadwi AzureVMWorkloadSAPAseDatabaseWorkloadItem) AsAzureVMWorkloadSQLInstanceWorkloadItem() (*AzureVMWorkloadSQLInstanceWorkloadItem, bool) {
	return nil, false
}

// AsWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPAseDatabaseWorkloadItem.
func (avwsadwi AzureVMWorkloadSAPAseDatabaseWorkloadItem) AsWorkloadItem() (*WorkloadItem, bool) {
	return nil, false
}

// AsBasicWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPAseDatabaseWorkloadItem.
func (avwsadwi AzureVMWorkloadSAPAseDatabaseWorkloadItem) AsBasicWorkloadItem() (BasicWorkloadItem, bool) {
	return &avwsadwi, true
}

// AzureVMWorkloadSAPAseSystemProtectableItem azure VM workload-specific protectable item representing SAP
// ASE System.
type AzureVMWorkloadSAPAseSystemProtectableItem struct {
	// ParentName - Name for instance or AG
	ParentName *string `json:"parentName,omitempty"`
	// ParentUniqueName - Parent Unique Name is added to provide the service formatted URI Name of the Parent
	// Only Applicable for data bases where the parent would be either Instance or a SQL AG.
	ParentUniqueName *string `json:"parentUniqueName,omitempty"`
	// ServerName - Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`
	// IsAutoProtectable - Indicates if protectable item is auto-protectable
	IsAutoProtectable *bool `json:"isAutoProtectable,omitempty"`
	// IsAutoProtected - Indicates if protectable item is auto-protected
	IsAutoProtected *bool `json:"isAutoProtected,omitempty"`
	// Subinquireditemcount - For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32 `json:"subinquireditemcount,omitempty"`
	// Subprotectableitemcount - For instance or AG, indicates number of DB's to be protected
	Subprotectableitemcount *int32 `json:"subprotectableitemcount,omitempty"`
	// Prebackupvalidation - Pre-backup validation for protectable objects
	Prebackupvalidation *PreBackupValidation `json:"prebackupvalidation,omitempty"`
	// BackupManagementType - Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
	// FriendlyName - Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionState - State of the back up item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// ProtectableItemType - Possible values include: 'ProtectableItemTypeWorkloadProtectableItem', 'ProtectableItemTypeAzureFileShare', 'ProtectableItemTypeMicrosoftClassicComputevirtualMachines', 'ProtectableItemTypeMicrosoftComputevirtualMachines', 'ProtectableItemTypeAzureVMWorkloadProtectableItem', 'ProtectableItemTypeSAPAseSystem', 'ProtectableItemTypeSAPHanaDatabase', 'ProtectableItemTypeSAPHanaSystem', 'ProtectableItemTypeSQLAvailabilityGroupContainer', 'ProtectableItemTypeSQLDataBase', 'ProtectableItemTypeSQLInstance', 'ProtectableItemTypeIaaSVMProtectableItem'
	ProtectableItemType ProtectableItemType `json:"protectableItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureVMWorkloadSAPAseSystemProtectableItem.
func (avwsaspi AzureVMWorkloadSAPAseSystemProtectableItem) MarshalJSON() ([]byte, error) {
	avwsaspi.ProtectableItemType = ProtectableItemTypeSAPAseSystem
	objectMap := make(map[string]interface{})
	if avwsaspi.ParentName != nil {
		objectMap["parentName"] = avwsaspi.ParentName
	}
	if avwsaspi.ParentUniqueName != nil {
		objectMap["parentUniqueName"] = avwsaspi.ParentUniqueName
	}
	if avwsaspi.ServerName != nil {
		objectMap["serverName"] = avwsaspi.ServerName
	}
	if avwsaspi.IsAutoProtectable != nil {
		objectMap["isAutoProtectable"] = avwsaspi.IsAutoProtectable
	}
	if avwsaspi.IsAutoProtected != nil {
		objectMap["isAutoProtected"] = avwsaspi.IsAutoProtected
	}
	if avwsaspi.Subinquireditemcount != nil {
		objectMap["subinquireditemcount"] = avwsaspi.Subinquireditemcount
	}
	if avwsaspi.Subprotectableitemcount != nil {
		objectMap["subprotectableitemcount"] = avwsaspi.Subprotectableitemcount
	}
	if avwsaspi.Prebackupvalidation != nil {
		objectMap["prebackupvalidation"] = avwsaspi.Prebackupvalidation
	}
	if avwsaspi.BackupManagementType != nil {
		objectMap["backupManagementType"] = avwsaspi.BackupManagementType
	}
	if avwsaspi.WorkloadType != nil {
		objectMap["workloadType"] = avwsaspi.WorkloadType
	}
	if avwsaspi.FriendlyName != nil {
		objectMap["friendlyName"] = avwsaspi.FriendlyName
	}
	if avwsaspi.ProtectionState != "" {
		objectMap["protectionState"] = avwsaspi.ProtectionState
	}
	if avwsaspi.ProtectableItemType != "" {
		objectMap["protectableItemType"] = avwsaspi.ProtectableItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPAseSystemProtectableItem.
func (avwsaspi AzureVMWorkloadSAPAseSystemProtectableItem) AsAzureFileShareProtectableItem() (*AzureFileShareProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPAseSystemProtectableItem.
func (avwsaspi AzureVMWorkloadSAPAseSystemProtectableItem) AsAzureIaaSClassicComputeVMProtectableItem() (*AzureIaaSClassicComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPAseSystemProtectableItem.
func (avwsaspi AzureVMWorkloadSAPAseSystemProtectableItem) AsAzureIaaSComputeVMProtectableItem() (*AzureIaaSComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPAseSystemProtectableItem.
func (avwsaspi AzureVMWorkloadSAPAseSystemProtectableItem) AsAzureVMWorkloadProtectableItem() (*AzureVMWorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPAseSystemProtectableItem.
func (avwsaspi AzureVMWorkloadSAPAseSystemProtectableItem) AsBasicAzureVMWorkloadProtectableItem() (BasicAzureVMWorkloadProtectableItem, bool) {
	return &avwsaspi, true
}

// AsAzureVMWorkloadSAPAseSystemProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPAseSystemProtectableItem.
func (avwsaspi AzureVMWorkloadSAPAseSystemProtectableItem) AsAzureVMWorkloadSAPAseSystemProtectableItem() (*AzureVMWorkloadSAPAseSystemProtectableItem, bool) {
	return &avwsaspi, true
}

// AsAzureVMWorkloadSAPHanaDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPAseSystemProtectableItem.
func (avwsaspi AzureVMWorkloadSAPAseSystemProtectableItem) AsAzureVMWorkloadSAPHanaDatabaseProtectableItem() (*AzureVMWorkloadSAPHanaDatabaseProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaSystemProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPAseSystemProtectableItem.
func (avwsaspi AzureVMWorkloadSAPAseSystemProtectableItem) AsAzureVMWorkloadSAPHanaSystemProtectableItem() (*AzureVMWorkloadSAPHanaSystemProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPAseSystemProtectableItem.
func (avwsaspi AzureVMWorkloadSAPAseSystemProtectableItem) AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem() (*AzureVMWorkloadSQLAvailabilityGroupProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPAseSystemProtectableItem.
func (avwsaspi AzureVMWorkloadSAPAseSystemProtectableItem) AsAzureVMWorkloadSQLDatabaseProtectableItem() (*AzureVMWorkloadSQLDatabaseProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLInstanceProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPAseSystemProtectableItem.
func (avwsaspi AzureVMWorkloadSAPAseSystemProtectableItem) AsAzureVMWorkloadSQLInstanceProtectableItem() (*AzureVMWorkloadSQLInstanceProtectableItem, bool) {
	return nil, false
}

// AsIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPAseSystemProtectableItem.
func (avwsaspi AzureVMWorkloadSAPAseSystemProtectableItem) AsIaaSVMProtectableItem() (*IaaSVMProtectableItem, bool) {
	return nil, false
}

// AsBasicIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPAseSystemProtectableItem.
func (avwsaspi AzureVMWorkloadSAPAseSystemProtectableItem) AsBasicIaaSVMProtectableItem() (BasicIaaSVMProtectableItem, bool) {
	return nil, false
}

// AsWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPAseSystemProtectableItem.
func (avwsaspi AzureVMWorkloadSAPAseSystemProtectableItem) AsWorkloadProtectableItem() (*WorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPAseSystemProtectableItem.
func (avwsaspi AzureVMWorkloadSAPAseSystemProtectableItem) AsBasicWorkloadProtectableItem() (BasicWorkloadProtectableItem, bool) {
	return &avwsaspi, true
}

// AzureVMWorkloadSAPAseSystemWorkloadItem azure VM workload-specific workload item representing SAP ASE
// System.
type AzureVMWorkloadSAPAseSystemWorkloadItem struct {
	// ParentName - Name for instance or AG
	ParentName *string `json:"parentName,omitempty"`
	// ServerName - Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`
	// IsAutoProtectable - Indicates if workload item is auto-protectable
	IsAutoProtectable *bool `json:"isAutoProtectable,omitempty"`
	// Subinquireditemcount - For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32 `json:"subinquireditemcount,omitempty"`
	// SubWorkloadItemCount - For instance or AG, indicates number of DB's to be protected
	SubWorkloadItemCount *int32 `json:"subWorkloadItemCount,omitempty"`
	// BackupManagementType - Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
	// FriendlyName - Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionState - State of the back up item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// WorkloadItemType - Possible values include: 'WorkloadItemTypeWorkloadItem', 'WorkloadItemTypeAzureVMWorkloadItem', 'WorkloadItemTypeSAPAseDatabase1', 'WorkloadItemTypeSAPAseSystem1', 'WorkloadItemTypeSAPHanaDatabase1', 'WorkloadItemTypeSAPHanaSystem1', 'WorkloadItemTypeSQLDataBase1', 'WorkloadItemTypeSQLInstance1'
	WorkloadItemType WorkloadItemTypeBasicWorkloadItem `json:"workloadItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureVMWorkloadSAPAseSystemWorkloadItem.
func (avwsaswi AzureVMWorkloadSAPAseSystemWorkloadItem) MarshalJSON() ([]byte, error) {
	avwsaswi.WorkloadItemType = WorkloadItemTypeSAPAseSystem1
	objectMap := make(map[string]interface{})
	if avwsaswi.ParentName != nil {
		objectMap["parentName"] = avwsaswi.ParentName
	}
	if avwsaswi.ServerName != nil {
		objectMap["serverName"] = avwsaswi.ServerName
	}
	if avwsaswi.IsAutoProtectable != nil {
		objectMap["isAutoProtectable"] = avwsaswi.IsAutoProtectable
	}
	if avwsaswi.Subinquireditemcount != nil {
		objectMap["subinquireditemcount"] = avwsaswi.Subinquireditemcount
	}
	if avwsaswi.SubWorkloadItemCount != nil {
		objectMap["subWorkloadItemCount"] = avwsaswi.SubWorkloadItemCount
	}
	if avwsaswi.BackupManagementType != nil {
		objectMap["backupManagementType"] = avwsaswi.BackupManagementType
	}
	if avwsaswi.WorkloadType != nil {
		objectMap["workloadType"] = avwsaswi.WorkloadType
	}
	if avwsaswi.FriendlyName != nil {
		objectMap["friendlyName"] = avwsaswi.FriendlyName
	}
	if avwsaswi.ProtectionState != "" {
		objectMap["protectionState"] = avwsaswi.ProtectionState
	}
	if avwsaswi.WorkloadItemType != "" {
		objectMap["workloadItemType"] = avwsaswi.WorkloadItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureVMWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPAseSystemWorkloadItem.
func (avwsaswi AzureVMWorkloadSAPAseSystemWorkloadItem) AsAzureVMWorkloadItem() (*AzureVMWorkloadItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPAseSystemWorkloadItem.
func (avwsaswi AzureVMWorkloadSAPAseSystemWorkloadItem) AsBasicAzureVMWorkloadItem() (BasicAzureVMWorkloadItem, bool) {
	return &avwsaswi, true
}

// AsAzureVMWorkloadSAPAseDatabaseWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPAseSystemWorkloadItem.
func (avwsaswi AzureVMWorkloadSAPAseSystemWorkloadItem) AsAzureVMWorkloadSAPAseDatabaseWorkloadItem() (*AzureVMWorkloadSAPAseDatabaseWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPAseSystemWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPAseSystemWorkloadItem.
func (avwsaswi AzureVMWorkloadSAPAseSystemWorkloadItem) AsAzureVMWorkloadSAPAseSystemWorkloadItem() (*AzureVMWorkloadSAPAseSystemWorkloadItem, bool) {
	return &avwsaswi, true
}

// AsAzureVMWorkloadSAPHanaDatabaseWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPAseSystemWorkloadItem.
func (avwsaswi AzureVMWorkloadSAPAseSystemWorkloadItem) AsAzureVMWorkloadSAPHanaDatabaseWorkloadItem() (*AzureVMWorkloadSAPHanaDatabaseWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaSystemWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPAseSystemWorkloadItem.
func (avwsaswi AzureVMWorkloadSAPAseSystemWorkloadItem) AsAzureVMWorkloadSAPHanaSystemWorkloadItem() (*AzureVMWorkloadSAPHanaSystemWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPAseSystemWorkloadItem.
func (avwsaswi AzureVMWorkloadSAPAseSystemWorkloadItem) AsAzureVMWorkloadSQLDatabaseWorkloadItem() (*AzureVMWorkloadSQLDatabaseWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLInstanceWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPAseSystemWorkloadItem.
func (avwsaswi AzureVMWorkloadSAPAseSystemWorkloadItem) AsAzureVMWorkloadSQLInstanceWorkloadItem() (*AzureVMWorkloadSQLInstanceWorkloadItem, bool) {
	return nil, false
}

// AsWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPAseSystemWorkloadItem.
func (avwsaswi AzureVMWorkloadSAPAseSystemWorkloadItem) AsWorkloadItem() (*WorkloadItem, bool) {
	return nil, false
}

// AsBasicWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPAseSystemWorkloadItem.
func (avwsaswi AzureVMWorkloadSAPAseSystemWorkloadItem) AsBasicWorkloadItem() (BasicWorkloadItem, bool) {
	return &avwsaswi, true
}

// AzureVMWorkloadSAPHanaDatabaseProtectableItem azure VM workload-specific protectable item representing
// SAP HANA Database.
type AzureVMWorkloadSAPHanaDatabaseProtectableItem struct {
	// ParentName - Name for instance or AG
	ParentName *string `json:"parentName,omitempty"`
	// ParentUniqueName - Parent Unique Name is added to provide the service formatted URI Name of the Parent
	// Only Applicable for data bases where the parent would be either Instance or a SQL AG.
	ParentUniqueName *string `json:"parentUniqueName,omitempty"`
	// ServerName - Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`
	// IsAutoProtectable - Indicates if protectable item is auto-protectable
	IsAutoProtectable *bool `json:"isAutoProtectable,omitempty"`
	// IsAutoProtected - Indicates if protectable item is auto-protected
	IsAutoProtected *bool `json:"isAutoProtected,omitempty"`
	// Subinquireditemcount - For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32 `json:"subinquireditemcount,omitempty"`
	// Subprotectableitemcount - For instance or AG, indicates number of DB's to be protected
	Subprotectableitemcount *int32 `json:"subprotectableitemcount,omitempty"`
	// Prebackupvalidation - Pre-backup validation for protectable objects
	Prebackupvalidation *PreBackupValidation `json:"prebackupvalidation,omitempty"`
	// BackupManagementType - Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
	// FriendlyName - Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionState - State of the back up item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// ProtectableItemType - Possible values include: 'ProtectableItemTypeWorkloadProtectableItem', 'ProtectableItemTypeAzureFileShare', 'ProtectableItemTypeMicrosoftClassicComputevirtualMachines', 'ProtectableItemTypeMicrosoftComputevirtualMachines', 'ProtectableItemTypeAzureVMWorkloadProtectableItem', 'ProtectableItemTypeSAPAseSystem', 'ProtectableItemTypeSAPHanaDatabase', 'ProtectableItemTypeSAPHanaSystem', 'ProtectableItemTypeSQLAvailabilityGroupContainer', 'ProtectableItemTypeSQLDataBase', 'ProtectableItemTypeSQLInstance', 'ProtectableItemTypeIaaSVMProtectableItem'
	ProtectableItemType ProtectableItemType `json:"protectableItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureVMWorkloadSAPHanaDatabaseProtectableItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectableItem) MarshalJSON() ([]byte, error) {
	avwshdpi.ProtectableItemType = ProtectableItemTypeSAPHanaDatabase
	objectMap := make(map[string]interface{})
	if avwshdpi.ParentName != nil {
		objectMap["parentName"] = avwshdpi.ParentName
	}
	if avwshdpi.ParentUniqueName != nil {
		objectMap["parentUniqueName"] = avwshdpi.ParentUniqueName
	}
	if avwshdpi.ServerName != nil {
		objectMap["serverName"] = avwshdpi.ServerName
	}
	if avwshdpi.IsAutoProtectable != nil {
		objectMap["isAutoProtectable"] = avwshdpi.IsAutoProtectable
	}
	if avwshdpi.IsAutoProtected != nil {
		objectMap["isAutoProtected"] = avwshdpi.IsAutoProtected
	}
	if avwshdpi.Subinquireditemcount != nil {
		objectMap["subinquireditemcount"] = avwshdpi.Subinquireditemcount
	}
	if avwshdpi.Subprotectableitemcount != nil {
		objectMap["subprotectableitemcount"] = avwshdpi.Subprotectableitemcount
	}
	if avwshdpi.Prebackupvalidation != nil {
		objectMap["prebackupvalidation"] = avwshdpi.Prebackupvalidation
	}
	if avwshdpi.BackupManagementType != nil {
		objectMap["backupManagementType"] = avwshdpi.BackupManagementType
	}
	if avwshdpi.WorkloadType != nil {
		objectMap["workloadType"] = avwshdpi.WorkloadType
	}
	if avwshdpi.FriendlyName != nil {
		objectMap["friendlyName"] = avwshdpi.FriendlyName
	}
	if avwshdpi.ProtectionState != "" {
		objectMap["protectionState"] = avwshdpi.ProtectionState
	}
	if avwshdpi.ProtectableItemType != "" {
		objectMap["protectableItemType"] = avwshdpi.ProtectableItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectableItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectableItem) AsAzureFileShareProtectableItem() (*AzureFileShareProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectableItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectableItem) AsAzureIaaSClassicComputeVMProtectableItem() (*AzureIaaSClassicComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectableItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectableItem) AsAzureIaaSComputeVMProtectableItem() (*AzureIaaSComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectableItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectableItem) AsAzureVMWorkloadProtectableItem() (*AzureVMWorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectableItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectableItem) AsBasicAzureVMWorkloadProtectableItem() (BasicAzureVMWorkloadProtectableItem, bool) {
	return &avwshdpi, true
}

// AsAzureVMWorkloadSAPAseSystemProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectableItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectableItem) AsAzureVMWorkloadSAPAseSystemProtectableItem() (*AzureVMWorkloadSAPAseSystemProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectableItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectableItem) AsAzureVMWorkloadSAPHanaDatabaseProtectableItem() (*AzureVMWorkloadSAPHanaDatabaseProtectableItem, bool) {
	return &avwshdpi, true
}

// AsAzureVMWorkloadSAPHanaSystemProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectableItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectableItem) AsAzureVMWorkloadSAPHanaSystemProtectableItem() (*AzureVMWorkloadSAPHanaSystemProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectableItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectableItem) AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem() (*AzureVMWorkloadSQLAvailabilityGroupProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectableItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectableItem) AsAzureVMWorkloadSQLDatabaseProtectableItem() (*AzureVMWorkloadSQLDatabaseProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLInstanceProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectableItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectableItem) AsAzureVMWorkloadSQLInstanceProtectableItem() (*AzureVMWorkloadSQLInstanceProtectableItem, bool) {
	return nil, false
}

// AsIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectableItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectableItem) AsIaaSVMProtectableItem() (*IaaSVMProtectableItem, bool) {
	return nil, false
}

// AsBasicIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectableItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectableItem) AsBasicIaaSVMProtectableItem() (BasicIaaSVMProtectableItem, bool) {
	return nil, false
}

// AsWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectableItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectableItem) AsWorkloadProtectableItem() (*WorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectableItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectableItem) AsBasicWorkloadProtectableItem() (BasicWorkloadProtectableItem, bool) {
	return &avwshdpi, true
}

// AzureVMWorkloadSAPHanaDatabaseWorkloadItem azure VM workload-specific workload item representing SAP
// HANA Database.
type AzureVMWorkloadSAPHanaDatabaseWorkloadItem struct {
	// ParentName - Name for instance or AG
	ParentName *string `json:"parentName,omitempty"`
	// ServerName - Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`
	// IsAutoProtectable - Indicates if workload item is auto-protectable
	IsAutoProtectable *bool `json:"isAutoProtectable,omitempty"`
	// Subinquireditemcount - For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32 `json:"subinquireditemcount,omitempty"`
	// SubWorkloadItemCount - For instance or AG, indicates number of DB's to be protected
	SubWorkloadItemCount *int32 `json:"subWorkloadItemCount,omitempty"`
	// BackupManagementType - Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
	// FriendlyName - Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionState - State of the back up item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// WorkloadItemType - Possible values include: 'WorkloadItemTypeWorkloadItem', 'WorkloadItemTypeAzureVMWorkloadItem', 'WorkloadItemTypeSAPAseDatabase1', 'WorkloadItemTypeSAPAseSystem1', 'WorkloadItemTypeSAPHanaDatabase1', 'WorkloadItemTypeSAPHanaSystem1', 'WorkloadItemTypeSQLDataBase1', 'WorkloadItemTypeSQLInstance1'
	WorkloadItemType WorkloadItemTypeBasicWorkloadItem `json:"workloadItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureVMWorkloadSAPHanaDatabaseWorkloadItem.
func (avwshdwi AzureVMWorkloadSAPHanaDatabaseWorkloadItem) MarshalJSON() ([]byte, error) {
	avwshdwi.WorkloadItemType = WorkloadItemTypeSAPHanaDatabase1
	objectMap := make(map[string]interface{})
	if avwshdwi.ParentName != nil {
		objectMap["parentName"] = avwshdwi.ParentName
	}
	if avwshdwi.ServerName != nil {
		objectMap["serverName"] = avwshdwi.ServerName
	}
	if avwshdwi.IsAutoProtectable != nil {
		objectMap["isAutoProtectable"] = avwshdwi.IsAutoProtectable
	}
	if avwshdwi.Subinquireditemcount != nil {
		objectMap["subinquireditemcount"] = avwshdwi.Subinquireditemcount
	}
	if avwshdwi.SubWorkloadItemCount != nil {
		objectMap["subWorkloadItemCount"] = avwshdwi.SubWorkloadItemCount
	}
	if avwshdwi.BackupManagementType != nil {
		objectMap["backupManagementType"] = avwshdwi.BackupManagementType
	}
	if avwshdwi.WorkloadType != nil {
		objectMap["workloadType"] = avwshdwi.WorkloadType
	}
	if avwshdwi.FriendlyName != nil {
		objectMap["friendlyName"] = avwshdwi.FriendlyName
	}
	if avwshdwi.ProtectionState != "" {
		objectMap["protectionState"] = avwshdwi.ProtectionState
	}
	if avwshdwi.WorkloadItemType != "" {
		objectMap["workloadItemType"] = avwshdwi.WorkloadItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureVMWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPHanaDatabaseWorkloadItem.
func (avwshdwi AzureVMWorkloadSAPHanaDatabaseWorkloadItem) AsAzureVMWorkloadItem() (*AzureVMWorkloadItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPHanaDatabaseWorkloadItem.
func (avwshdwi AzureVMWorkloadSAPHanaDatabaseWorkloadItem) AsBasicAzureVMWorkloadItem() (BasicAzureVMWorkloadItem, bool) {
	return &avwshdwi, true
}

// AsAzureVMWorkloadSAPAseDatabaseWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPHanaDatabaseWorkloadItem.
func (avwshdwi AzureVMWorkloadSAPHanaDatabaseWorkloadItem) AsAzureVMWorkloadSAPAseDatabaseWorkloadItem() (*AzureVMWorkloadSAPAseDatabaseWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPAseSystemWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPHanaDatabaseWorkloadItem.
func (avwshdwi AzureVMWorkloadSAPHanaDatabaseWorkloadItem) AsAzureVMWorkloadSAPAseSystemWorkloadItem() (*AzureVMWorkloadSAPAseSystemWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPHanaDatabaseWorkloadItem.
func (avwshdwi AzureVMWorkloadSAPHanaDatabaseWorkloadItem) AsAzureVMWorkloadSAPHanaDatabaseWorkloadItem() (*AzureVMWorkloadSAPHanaDatabaseWorkloadItem, bool) {
	return &avwshdwi, true
}

// AsAzureVMWorkloadSAPHanaSystemWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPHanaDatabaseWorkloadItem.
func (avwshdwi AzureVMWorkloadSAPHanaDatabaseWorkloadItem) AsAzureVMWorkloadSAPHanaSystemWorkloadItem() (*AzureVMWorkloadSAPHanaSystemWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPHanaDatabaseWorkloadItem.
func (avwshdwi AzureVMWorkloadSAPHanaDatabaseWorkloadItem) AsAzureVMWorkloadSQLDatabaseWorkloadItem() (*AzureVMWorkloadSQLDatabaseWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLInstanceWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPHanaDatabaseWorkloadItem.
func (avwshdwi AzureVMWorkloadSAPHanaDatabaseWorkloadItem) AsAzureVMWorkloadSQLInstanceWorkloadItem() (*AzureVMWorkloadSQLInstanceWorkloadItem, bool) {
	return nil, false
}

// AsWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPHanaDatabaseWorkloadItem.
func (avwshdwi AzureVMWorkloadSAPHanaDatabaseWorkloadItem) AsWorkloadItem() (*WorkloadItem, bool) {
	return nil, false
}

// AsBasicWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPHanaDatabaseWorkloadItem.
func (avwshdwi AzureVMWorkloadSAPHanaDatabaseWorkloadItem) AsBasicWorkloadItem() (BasicWorkloadItem, bool) {
	return &avwshdwi, true
}

// AzureVMWorkloadSAPHanaSystemProtectableItem azure VM workload-specific protectable item representing SAP
// HANA System.
type AzureVMWorkloadSAPHanaSystemProtectableItem struct {
	// ParentName - Name for instance or AG
	ParentName *string `json:"parentName,omitempty"`
	// ParentUniqueName - Parent Unique Name is added to provide the service formatted URI Name of the Parent
	// Only Applicable for data bases where the parent would be either Instance or a SQL AG.
	ParentUniqueName *string `json:"parentUniqueName,omitempty"`
	// ServerName - Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`
	// IsAutoProtectable - Indicates if protectable item is auto-protectable
	IsAutoProtectable *bool `json:"isAutoProtectable,omitempty"`
	// IsAutoProtected - Indicates if protectable item is auto-protected
	IsAutoProtected *bool `json:"isAutoProtected,omitempty"`
	// Subinquireditemcount - For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32 `json:"subinquireditemcount,omitempty"`
	// Subprotectableitemcount - For instance or AG, indicates number of DB's to be protected
	Subprotectableitemcount *int32 `json:"subprotectableitemcount,omitempty"`
	// Prebackupvalidation - Pre-backup validation for protectable objects
	Prebackupvalidation *PreBackupValidation `json:"prebackupvalidation,omitempty"`
	// BackupManagementType - Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
	// FriendlyName - Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionState - State of the back up item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// ProtectableItemType - Possible values include: 'ProtectableItemTypeWorkloadProtectableItem', 'ProtectableItemTypeAzureFileShare', 'ProtectableItemTypeMicrosoftClassicComputevirtualMachines', 'ProtectableItemTypeMicrosoftComputevirtualMachines', 'ProtectableItemTypeAzureVMWorkloadProtectableItem', 'ProtectableItemTypeSAPAseSystem', 'ProtectableItemTypeSAPHanaDatabase', 'ProtectableItemTypeSAPHanaSystem', 'ProtectableItemTypeSQLAvailabilityGroupContainer', 'ProtectableItemTypeSQLDataBase', 'ProtectableItemTypeSQLInstance', 'ProtectableItemTypeIaaSVMProtectableItem'
	ProtectableItemType ProtectableItemType `json:"protectableItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureVMWorkloadSAPHanaSystemProtectableItem.
func (avwshspi AzureVMWorkloadSAPHanaSystemProtectableItem) MarshalJSON() ([]byte, error) {
	avwshspi.ProtectableItemType = ProtectableItemTypeSAPHanaSystem
	objectMap := make(map[string]interface{})
	if avwshspi.ParentName != nil {
		objectMap["parentName"] = avwshspi.ParentName
	}
	if avwshspi.ParentUniqueName != nil {
		objectMap["parentUniqueName"] = avwshspi.ParentUniqueName
	}
	if avwshspi.ServerName != nil {
		objectMap["serverName"] = avwshspi.ServerName
	}
	if avwshspi.IsAutoProtectable != nil {
		objectMap["isAutoProtectable"] = avwshspi.IsAutoProtectable
	}
	if avwshspi.IsAutoProtected != nil {
		objectMap["isAutoProtected"] = avwshspi.IsAutoProtected
	}
	if avwshspi.Subinquireditemcount != nil {
		objectMap["subinquireditemcount"] = avwshspi.Subinquireditemcount
	}
	if avwshspi.Subprotectableitemcount != nil {
		objectMap["subprotectableitemcount"] = avwshspi.Subprotectableitemcount
	}
	if avwshspi.Prebackupvalidation != nil {
		objectMap["prebackupvalidation"] = avwshspi.Prebackupvalidation
	}
	if avwshspi.BackupManagementType != nil {
		objectMap["backupManagementType"] = avwshspi.BackupManagementType
	}
	if avwshspi.WorkloadType != nil {
		objectMap["workloadType"] = avwshspi.WorkloadType
	}
	if avwshspi.FriendlyName != nil {
		objectMap["friendlyName"] = avwshspi.FriendlyName
	}
	if avwshspi.ProtectionState != "" {
		objectMap["protectionState"] = avwshspi.ProtectionState
	}
	if avwshspi.ProtectableItemType != "" {
		objectMap["protectableItemType"] = avwshspi.ProtectableItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaSystemProtectableItem.
func (avwshspi AzureVMWorkloadSAPHanaSystemProtectableItem) AsAzureFileShareProtectableItem() (*AzureFileShareProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaSystemProtectableItem.
func (avwshspi AzureVMWorkloadSAPHanaSystemProtectableItem) AsAzureIaaSClassicComputeVMProtectableItem() (*AzureIaaSClassicComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaSystemProtectableItem.
func (avwshspi AzureVMWorkloadSAPHanaSystemProtectableItem) AsAzureIaaSComputeVMProtectableItem() (*AzureIaaSComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaSystemProtectableItem.
func (avwshspi AzureVMWorkloadSAPHanaSystemProtectableItem) AsAzureVMWorkloadProtectableItem() (*AzureVMWorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaSystemProtectableItem.
func (avwshspi AzureVMWorkloadSAPHanaSystemProtectableItem) AsBasicAzureVMWorkloadProtectableItem() (BasicAzureVMWorkloadProtectableItem, bool) {
	return &avwshspi, true
}

// AsAzureVMWorkloadSAPAseSystemProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaSystemProtectableItem.
func (avwshspi AzureVMWorkloadSAPHanaSystemProtectableItem) AsAzureVMWorkloadSAPAseSystemProtectableItem() (*AzureVMWorkloadSAPAseSystemProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaSystemProtectableItem.
func (avwshspi AzureVMWorkloadSAPHanaSystemProtectableItem) AsAzureVMWorkloadSAPHanaDatabaseProtectableItem() (*AzureVMWorkloadSAPHanaDatabaseProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaSystemProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaSystemProtectableItem.
func (avwshspi AzureVMWorkloadSAPHanaSystemProtectableItem) AsAzureVMWorkloadSAPHanaSystemProtectableItem() (*AzureVMWorkloadSAPHanaSystemProtectableItem, bool) {
	return &avwshspi, true
}

// AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaSystemProtectableItem.
func (avwshspi AzureVMWorkloadSAPHanaSystemProtectableItem) AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem() (*AzureVMWorkloadSQLAvailabilityGroupProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaSystemProtectableItem.
func (avwshspi AzureVMWorkloadSAPHanaSystemProtectableItem) AsAzureVMWorkloadSQLDatabaseProtectableItem() (*AzureVMWorkloadSQLDatabaseProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLInstanceProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaSystemProtectableItem.
func (avwshspi AzureVMWorkloadSAPHanaSystemProtectableItem) AsAzureVMWorkloadSQLInstanceProtectableItem() (*AzureVMWorkloadSQLInstanceProtectableItem, bool) {
	return nil, false
}

// AsIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaSystemProtectableItem.
func (avwshspi AzureVMWorkloadSAPHanaSystemProtectableItem) AsIaaSVMProtectableItem() (*IaaSVMProtectableItem, bool) {
	return nil, false
}

// AsBasicIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaSystemProtectableItem.
func (avwshspi AzureVMWorkloadSAPHanaSystemProtectableItem) AsBasicIaaSVMProtectableItem() (BasicIaaSVMProtectableItem, bool) {
	return nil, false
}

// AsWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaSystemProtectableItem.
func (avwshspi AzureVMWorkloadSAPHanaSystemProtectableItem) AsWorkloadProtectableItem() (*WorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaSystemProtectableItem.
func (avwshspi AzureVMWorkloadSAPHanaSystemProtectableItem) AsBasicWorkloadProtectableItem() (BasicWorkloadProtectableItem, bool) {
	return &avwshspi, true
}

// AzureVMWorkloadSAPHanaSystemWorkloadItem azure VM workload-specific workload item representing SAP HANA
// System.
type AzureVMWorkloadSAPHanaSystemWorkloadItem struct {
	// ParentName - Name for instance or AG
	ParentName *string `json:"parentName,omitempty"`
	// ServerName - Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`
	// IsAutoProtectable - Indicates if workload item is auto-protectable
	IsAutoProtectable *bool `json:"isAutoProtectable,omitempty"`
	// Subinquireditemcount - For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32 `json:"subinquireditemcount,omitempty"`
	// SubWorkloadItemCount - For instance or AG, indicates number of DB's to be protected
	SubWorkloadItemCount *int32 `json:"subWorkloadItemCount,omitempty"`
	// BackupManagementType - Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
	// FriendlyName - Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionState - State of the back up item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// WorkloadItemType - Possible values include: 'WorkloadItemTypeWorkloadItem', 'WorkloadItemTypeAzureVMWorkloadItem', 'WorkloadItemTypeSAPAseDatabase1', 'WorkloadItemTypeSAPAseSystem1', 'WorkloadItemTypeSAPHanaDatabase1', 'WorkloadItemTypeSAPHanaSystem1', 'WorkloadItemTypeSQLDataBase1', 'WorkloadItemTypeSQLInstance1'
	WorkloadItemType WorkloadItemTypeBasicWorkloadItem `json:"workloadItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureVMWorkloadSAPHanaSystemWorkloadItem.
func (avwshswi AzureVMWorkloadSAPHanaSystemWorkloadItem) MarshalJSON() ([]byte, error) {
	avwshswi.WorkloadItemType = WorkloadItemTypeSAPHanaSystem1
	objectMap := make(map[string]interface{})
	if avwshswi.ParentName != nil {
		objectMap["parentName"] = avwshswi.ParentName
	}
	if avwshswi.ServerName != nil {
		objectMap["serverName"] = avwshswi.ServerName
	}
	if avwshswi.IsAutoProtectable != nil {
		objectMap["isAutoProtectable"] = avwshswi.IsAutoProtectable
	}
	if avwshswi.Subinquireditemcount != nil {
		objectMap["subinquireditemcount"] = avwshswi.Subinquireditemcount
	}
	if avwshswi.SubWorkloadItemCount != nil {
		objectMap["subWorkloadItemCount"] = avwshswi.SubWorkloadItemCount
	}
	if avwshswi.BackupManagementType != nil {
		objectMap["backupManagementType"] = avwshswi.BackupManagementType
	}
	if avwshswi.WorkloadType != nil {
		objectMap["workloadType"] = avwshswi.WorkloadType
	}
	if avwshswi.FriendlyName != nil {
		objectMap["friendlyName"] = avwshswi.FriendlyName
	}
	if avwshswi.ProtectionState != "" {
		objectMap["protectionState"] = avwshswi.ProtectionState
	}
	if avwshswi.WorkloadItemType != "" {
		objectMap["workloadItemType"] = avwshswi.WorkloadItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureVMWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPHanaSystemWorkloadItem.
func (avwshswi AzureVMWorkloadSAPHanaSystemWorkloadItem) AsAzureVMWorkloadItem() (*AzureVMWorkloadItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPHanaSystemWorkloadItem.
func (avwshswi AzureVMWorkloadSAPHanaSystemWorkloadItem) AsBasicAzureVMWorkloadItem() (BasicAzureVMWorkloadItem, bool) {
	return &avwshswi, true
}

// AsAzureVMWorkloadSAPAseDatabaseWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPHanaSystemWorkloadItem.
func (avwshswi AzureVMWorkloadSAPHanaSystemWorkloadItem) AsAzureVMWorkloadSAPAseDatabaseWorkloadItem() (*AzureVMWorkloadSAPAseDatabaseWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPAseSystemWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPHanaSystemWorkloadItem.
func (avwshswi AzureVMWorkloadSAPHanaSystemWorkloadItem) AsAzureVMWorkloadSAPAseSystemWorkloadItem() (*AzureVMWorkloadSAPAseSystemWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPHanaSystemWorkloadItem.
func (avwshswi AzureVMWorkloadSAPHanaSystemWorkloadItem) AsAzureVMWorkloadSAPHanaDatabaseWorkloadItem() (*AzureVMWorkloadSAPHanaDatabaseWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaSystemWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPHanaSystemWorkloadItem.
func (avwshswi AzureVMWorkloadSAPHanaSystemWorkloadItem) AsAzureVMWorkloadSAPHanaSystemWorkloadItem() (*AzureVMWorkloadSAPHanaSystemWorkloadItem, bool) {
	return &avwshswi, true
}

// AsAzureVMWorkloadSQLDatabaseWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPHanaSystemWorkloadItem.
func (avwshswi AzureVMWorkloadSAPHanaSystemWorkloadItem) AsAzureVMWorkloadSQLDatabaseWorkloadItem() (*AzureVMWorkloadSQLDatabaseWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLInstanceWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPHanaSystemWorkloadItem.
func (avwshswi AzureVMWorkloadSAPHanaSystemWorkloadItem) AsAzureVMWorkloadSQLInstanceWorkloadItem() (*AzureVMWorkloadSQLInstanceWorkloadItem, bool) {
	return nil, false
}

// AsWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPHanaSystemWorkloadItem.
func (avwshswi AzureVMWorkloadSAPHanaSystemWorkloadItem) AsWorkloadItem() (*WorkloadItem, bool) {
	return nil, false
}

// AsBasicWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPHanaSystemWorkloadItem.
func (avwshswi AzureVMWorkloadSAPHanaSystemWorkloadItem) AsBasicWorkloadItem() (BasicWorkloadItem, bool) {
	return &avwshswi, true
}

// AzureVMWorkloadSQLAvailabilityGroupProtectableItem azure VM workload-specific protectable item
// representing SQL Availability Group.
type AzureVMWorkloadSQLAvailabilityGroupProtectableItem struct {
	// ParentName - Name for instance or AG
	ParentName *string `json:"parentName,omitempty"`
	// ParentUniqueName - Parent Unique Name is added to provide the service formatted URI Name of the Parent
	// Only Applicable for data bases where the parent would be either Instance or a SQL AG.
	ParentUniqueName *string `json:"parentUniqueName,omitempty"`
	// ServerName - Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`
	// IsAutoProtectable - Indicates if protectable item is auto-protectable
	IsAutoProtectable *bool `json:"isAutoProtectable,omitempty"`
	// IsAutoProtected - Indicates if protectable item is auto-protected
	IsAutoProtected *bool `json:"isAutoProtected,omitempty"`
	// Subinquireditemcount - For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32 `json:"subinquireditemcount,omitempty"`
	// Subprotectableitemcount - For instance or AG, indicates number of DB's to be protected
	Subprotectableitemcount *int32 `json:"subprotectableitemcount,omitempty"`
	// Prebackupvalidation - Pre-backup validation for protectable objects
	Prebackupvalidation *PreBackupValidation `json:"prebackupvalidation,omitempty"`
	// BackupManagementType - Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
	// FriendlyName - Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionState - State of the back up item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// ProtectableItemType - Possible values include: 'ProtectableItemTypeWorkloadProtectableItem', 'ProtectableItemTypeAzureFileShare', 'ProtectableItemTypeMicrosoftClassicComputevirtualMachines', 'ProtectableItemTypeMicrosoftComputevirtualMachines', 'ProtectableItemTypeAzureVMWorkloadProtectableItem', 'ProtectableItemTypeSAPAseSystem', 'ProtectableItemTypeSAPHanaDatabase', 'ProtectableItemTypeSAPHanaSystem', 'ProtectableItemTypeSQLAvailabilityGroupContainer', 'ProtectableItemTypeSQLDataBase', 'ProtectableItemTypeSQLInstance', 'ProtectableItemTypeIaaSVMProtectableItem'
	ProtectableItemType ProtectableItemType `json:"protectableItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureVMWorkloadSQLAvailabilityGroupProtectableItem.
func (avwsagpi AzureVMWorkloadSQLAvailabilityGroupProtectableItem) MarshalJSON() ([]byte, error) {
	avwsagpi.ProtectableItemType = ProtectableItemTypeSQLAvailabilityGroupContainer
	objectMap := make(map[string]interface{})
	if avwsagpi.ParentName != nil {
		objectMap["parentName"] = avwsagpi.ParentName
	}
	if avwsagpi.ParentUniqueName != nil {
		objectMap["parentUniqueName"] = avwsagpi.ParentUniqueName
	}
	if avwsagpi.ServerName != nil {
		objectMap["serverName"] = avwsagpi.ServerName
	}
	if avwsagpi.IsAutoProtectable != nil {
		objectMap["isAutoProtectable"] = avwsagpi.IsAutoProtectable
	}
	if avwsagpi.IsAutoProtected != nil {
		objectMap["isAutoProtected"] = avwsagpi.IsAutoProtected
	}
	if avwsagpi.Subinquireditemcount != nil {
		objectMap["subinquireditemcount"] = avwsagpi.Subinquireditemcount
	}
	if avwsagpi.Subprotectableitemcount != nil {
		objectMap["subprotectableitemcount"] = avwsagpi.Subprotectableitemcount
	}
	if avwsagpi.Prebackupvalidation != nil {
		objectMap["prebackupvalidation"] = avwsagpi.Prebackupvalidation
	}
	if avwsagpi.BackupManagementType != nil {
		objectMap["backupManagementType"] = avwsagpi.BackupManagementType
	}
	if avwsagpi.WorkloadType != nil {
		objectMap["workloadType"] = avwsagpi.WorkloadType
	}
	if avwsagpi.FriendlyName != nil {
		objectMap["friendlyName"] = avwsagpi.FriendlyName
	}
	if avwsagpi.ProtectionState != "" {
		objectMap["protectionState"] = avwsagpi.ProtectionState
	}
	if avwsagpi.ProtectableItemType != "" {
		objectMap["protectableItemType"] = avwsagpi.ProtectableItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLAvailabilityGroupProtectableItem.
func (avwsagpi AzureVMWorkloadSQLAvailabilityGroupProtectableItem) AsAzureFileShareProtectableItem() (*AzureFileShareProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLAvailabilityGroupProtectableItem.
func (avwsagpi AzureVMWorkloadSQLAvailabilityGroupProtectableItem) AsAzureIaaSClassicComputeVMProtectableItem() (*AzureIaaSClassicComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLAvailabilityGroupProtectableItem.
func (avwsagpi AzureVMWorkloadSQLAvailabilityGroupProtectableItem) AsAzureIaaSComputeVMProtectableItem() (*AzureIaaSComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLAvailabilityGroupProtectableItem.
func (avwsagpi AzureVMWorkloadSQLAvailabilityGroupProtectableItem) AsAzureVMWorkloadProtectableItem() (*AzureVMWorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLAvailabilityGroupProtectableItem.
func (avwsagpi AzureVMWorkloadSQLAvailabilityGroupProtectableItem) AsBasicAzureVMWorkloadProtectableItem() (BasicAzureVMWorkloadProtectableItem, bool) {
	return &avwsagpi, true
}

// AsAzureVMWorkloadSAPAseSystemProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLAvailabilityGroupProtectableItem.
func (avwsagpi AzureVMWorkloadSQLAvailabilityGroupProtectableItem) AsAzureVMWorkloadSAPAseSystemProtectableItem() (*AzureVMWorkloadSAPAseSystemProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLAvailabilityGroupProtectableItem.
func (avwsagpi AzureVMWorkloadSQLAvailabilityGroupProtectableItem) AsAzureVMWorkloadSAPHanaDatabaseProtectableItem() (*AzureVMWorkloadSAPHanaDatabaseProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaSystemProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLAvailabilityGroupProtectableItem.
func (avwsagpi AzureVMWorkloadSQLAvailabilityGroupProtectableItem) AsAzureVMWorkloadSAPHanaSystemProtectableItem() (*AzureVMWorkloadSAPHanaSystemProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLAvailabilityGroupProtectableItem.
func (avwsagpi AzureVMWorkloadSQLAvailabilityGroupProtectableItem) AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem() (*AzureVMWorkloadSQLAvailabilityGroupProtectableItem, bool) {
	return &avwsagpi, true
}

// AsAzureVMWorkloadSQLDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLAvailabilityGroupProtectableItem.
func (avwsagpi AzureVMWorkloadSQLAvailabilityGroupProtectableItem) AsAzureVMWorkloadSQLDatabaseProtectableItem() (*AzureVMWorkloadSQLDatabaseProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLInstanceProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLAvailabilityGroupProtectableItem.
func (avwsagpi AzureVMWorkloadSQLAvailabilityGroupProtectableItem) AsAzureVMWorkloadSQLInstanceProtectableItem() (*AzureVMWorkloadSQLInstanceProtectableItem, bool) {
	return nil, false
}

// AsIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLAvailabilityGroupProtectableItem.
func (avwsagpi AzureVMWorkloadSQLAvailabilityGroupProtectableItem) AsIaaSVMProtectableItem() (*IaaSVMProtectableItem, bool) {
	return nil, false
}

// AsBasicIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLAvailabilityGroupProtectableItem.
func (avwsagpi AzureVMWorkloadSQLAvailabilityGroupProtectableItem) AsBasicIaaSVMProtectableItem() (BasicIaaSVMProtectableItem, bool) {
	return nil, false
}

// AsWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLAvailabilityGroupProtectableItem.
func (avwsagpi AzureVMWorkloadSQLAvailabilityGroupProtectableItem) AsWorkloadProtectableItem() (*WorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLAvailabilityGroupProtectableItem.
func (avwsagpi AzureVMWorkloadSQLAvailabilityGroupProtectableItem) AsBasicWorkloadProtectableItem() (BasicWorkloadProtectableItem, bool) {
	return &avwsagpi, true
}

// AzureVMWorkloadSQLDatabaseProtectableItem azure VM workload-specific protectable item representing SQL
// Database.
type AzureVMWorkloadSQLDatabaseProtectableItem struct {
	// ParentName - Name for instance or AG
	ParentName *string `json:"parentName,omitempty"`
	// ParentUniqueName - Parent Unique Name is added to provide the service formatted URI Name of the Parent
	// Only Applicable for data bases where the parent would be either Instance or a SQL AG.
	ParentUniqueName *string `json:"parentUniqueName,omitempty"`
	// ServerName - Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`
	// IsAutoProtectable - Indicates if protectable item is auto-protectable
	IsAutoProtectable *bool `json:"isAutoProtectable,omitempty"`
	// IsAutoProtected - Indicates if protectable item is auto-protected
	IsAutoProtected *bool `json:"isAutoProtected,omitempty"`
	// Subinquireditemcount - For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32 `json:"subinquireditemcount,omitempty"`
	// Subprotectableitemcount - For instance or AG, indicates number of DB's to be protected
	Subprotectableitemcount *int32 `json:"subprotectableitemcount,omitempty"`
	// Prebackupvalidation - Pre-backup validation for protectable objects
	Prebackupvalidation *PreBackupValidation `json:"prebackupvalidation,omitempty"`
	// BackupManagementType - Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
	// FriendlyName - Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionState - State of the back up item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// ProtectableItemType - Possible values include: 'ProtectableItemTypeWorkloadProtectableItem', 'ProtectableItemTypeAzureFileShare', 'ProtectableItemTypeMicrosoftClassicComputevirtualMachines', 'ProtectableItemTypeMicrosoftComputevirtualMachines', 'ProtectableItemTypeAzureVMWorkloadProtectableItem', 'ProtectableItemTypeSAPAseSystem', 'ProtectableItemTypeSAPHanaDatabase', 'ProtectableItemTypeSAPHanaSystem', 'ProtectableItemTypeSQLAvailabilityGroupContainer', 'ProtectableItemTypeSQLDataBase', 'ProtectableItemTypeSQLInstance', 'ProtectableItemTypeIaaSVMProtectableItem'
	ProtectableItemType ProtectableItemType `json:"protectableItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureVMWorkloadSQLDatabaseProtectableItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectableItem) MarshalJSON() ([]byte, error) {
	avwsdpi.ProtectableItemType = ProtectableItemTypeSQLDataBase
	objectMap := make(map[string]interface{})
	if avwsdpi.ParentName != nil {
		objectMap["parentName"] = avwsdpi.ParentName
	}
	if avwsdpi.ParentUniqueName != nil {
		objectMap["parentUniqueName"] = avwsdpi.ParentUniqueName
	}
	if avwsdpi.ServerName != nil {
		objectMap["serverName"] = avwsdpi.ServerName
	}
	if avwsdpi.IsAutoProtectable != nil {
		objectMap["isAutoProtectable"] = avwsdpi.IsAutoProtectable
	}
	if avwsdpi.IsAutoProtected != nil {
		objectMap["isAutoProtected"] = avwsdpi.IsAutoProtected
	}
	if avwsdpi.Subinquireditemcount != nil {
		objectMap["subinquireditemcount"] = avwsdpi.Subinquireditemcount
	}
	if avwsdpi.Subprotectableitemcount != nil {
		objectMap["subprotectableitemcount"] = avwsdpi.Subprotectableitemcount
	}
	if avwsdpi.Prebackupvalidation != nil {
		objectMap["prebackupvalidation"] = avwsdpi.Prebackupvalidation
	}
	if avwsdpi.BackupManagementType != nil {
		objectMap["backupManagementType"] = avwsdpi.BackupManagementType
	}
	if avwsdpi.WorkloadType != nil {
		objectMap["workloadType"] = avwsdpi.WorkloadType
	}
	if avwsdpi.FriendlyName != nil {
		objectMap["friendlyName"] = avwsdpi.FriendlyName
	}
	if avwsdpi.ProtectionState != "" {
		objectMap["protectionState"] = avwsdpi.ProtectionState
	}
	if avwsdpi.ProtectableItemType != "" {
		objectMap["protectableItemType"] = avwsdpi.ProtectableItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLDatabaseProtectableItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectableItem) AsAzureFileShareProtectableItem() (*AzureFileShareProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLDatabaseProtectableItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectableItem) AsAzureIaaSClassicComputeVMProtectableItem() (*AzureIaaSClassicComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLDatabaseProtectableItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectableItem) AsAzureIaaSComputeVMProtectableItem() (*AzureIaaSComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLDatabaseProtectableItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectableItem) AsAzureVMWorkloadProtectableItem() (*AzureVMWorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLDatabaseProtectableItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectableItem) AsBasicAzureVMWorkloadProtectableItem() (BasicAzureVMWorkloadProtectableItem, bool) {
	return &avwsdpi, true
}

// AsAzureVMWorkloadSAPAseSystemProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLDatabaseProtectableItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectableItem) AsAzureVMWorkloadSAPAseSystemProtectableItem() (*AzureVMWorkloadSAPAseSystemProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLDatabaseProtectableItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectableItem) AsAzureVMWorkloadSAPHanaDatabaseProtectableItem() (*AzureVMWorkloadSAPHanaDatabaseProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaSystemProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLDatabaseProtectableItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectableItem) AsAzureVMWorkloadSAPHanaSystemProtectableItem() (*AzureVMWorkloadSAPHanaSystemProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLDatabaseProtectableItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectableItem) AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem() (*AzureVMWorkloadSQLAvailabilityGroupProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLDatabaseProtectableItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectableItem) AsAzureVMWorkloadSQLDatabaseProtectableItem() (*AzureVMWorkloadSQLDatabaseProtectableItem, bool) {
	return &avwsdpi, true
}

// AsAzureVMWorkloadSQLInstanceProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLDatabaseProtectableItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectableItem) AsAzureVMWorkloadSQLInstanceProtectableItem() (*AzureVMWorkloadSQLInstanceProtectableItem, bool) {
	return nil, false
}

// AsIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLDatabaseProtectableItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectableItem) AsIaaSVMProtectableItem() (*IaaSVMProtectableItem, bool) {
	return nil, false
}

// AsBasicIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLDatabaseProtectableItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectableItem) AsBasicIaaSVMProtectableItem() (BasicIaaSVMProtectableItem, bool) {
	return nil, false
}

// AsWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLDatabaseProtectableItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectableItem) AsWorkloadProtectableItem() (*WorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLDatabaseProtectableItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectableItem) AsBasicWorkloadProtectableItem() (BasicWorkloadProtectableItem, bool) {
	return &avwsdpi, true
}

// AzureVMWorkloadSQLDatabaseWorkloadItem azure VM workload-specific workload item representing SQL
// Database.
type AzureVMWorkloadSQLDatabaseWorkloadItem struct {
	// ParentName - Name for instance or AG
	ParentName *string `json:"parentName,omitempty"`
	// ServerName - Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`
	// IsAutoProtectable - Indicates if workload item is auto-protectable
	IsAutoProtectable *bool `json:"isAutoProtectable,omitempty"`
	// Subinquireditemcount - For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32 `json:"subinquireditemcount,omitempty"`
	// SubWorkloadItemCount - For instance or AG, indicates number of DB's to be protected
	SubWorkloadItemCount *int32 `json:"subWorkloadItemCount,omitempty"`
	// BackupManagementType - Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
	// FriendlyName - Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionState - State of the back up item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// WorkloadItemType - Possible values include: 'WorkloadItemTypeWorkloadItem', 'WorkloadItemTypeAzureVMWorkloadItem', 'WorkloadItemTypeSAPAseDatabase1', 'WorkloadItemTypeSAPAseSystem1', 'WorkloadItemTypeSAPHanaDatabase1', 'WorkloadItemTypeSAPHanaSystem1', 'WorkloadItemTypeSQLDataBase1', 'WorkloadItemTypeSQLInstance1'
	WorkloadItemType WorkloadItemTypeBasicWorkloadItem `json:"workloadItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureVMWorkloadSQLDatabaseWorkloadItem.
func (avwsdwi AzureVMWorkloadSQLDatabaseWorkloadItem) MarshalJSON() ([]byte, error) {
	avwsdwi.WorkloadItemType = WorkloadItemTypeSQLDataBase1
	objectMap := make(map[string]interface{})
	if avwsdwi.ParentName != nil {
		objectMap["parentName"] = avwsdwi.ParentName
	}
	if avwsdwi.ServerName != nil {
		objectMap["serverName"] = avwsdwi.ServerName
	}
	if avwsdwi.IsAutoProtectable != nil {
		objectMap["isAutoProtectable"] = avwsdwi.IsAutoProtectable
	}
	if avwsdwi.Subinquireditemcount != nil {
		objectMap["subinquireditemcount"] = avwsdwi.Subinquireditemcount
	}
	if avwsdwi.SubWorkloadItemCount != nil {
		objectMap["subWorkloadItemCount"] = avwsdwi.SubWorkloadItemCount
	}
	if avwsdwi.BackupManagementType != nil {
		objectMap["backupManagementType"] = avwsdwi.BackupManagementType
	}
	if avwsdwi.WorkloadType != nil {
		objectMap["workloadType"] = avwsdwi.WorkloadType
	}
	if avwsdwi.FriendlyName != nil {
		objectMap["friendlyName"] = avwsdwi.FriendlyName
	}
	if avwsdwi.ProtectionState != "" {
		objectMap["protectionState"] = avwsdwi.ProtectionState
	}
	if avwsdwi.WorkloadItemType != "" {
		objectMap["workloadItemType"] = avwsdwi.WorkloadItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureVMWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSQLDatabaseWorkloadItem.
func (avwsdwi AzureVMWorkloadSQLDatabaseWorkloadItem) AsAzureVMWorkloadItem() (*AzureVMWorkloadItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSQLDatabaseWorkloadItem.
func (avwsdwi AzureVMWorkloadSQLDatabaseWorkloadItem) AsBasicAzureVMWorkloadItem() (BasicAzureVMWorkloadItem, bool) {
	return &avwsdwi, true
}

// AsAzureVMWorkloadSAPAseDatabaseWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSQLDatabaseWorkloadItem.
func (avwsdwi AzureVMWorkloadSQLDatabaseWorkloadItem) AsAzureVMWorkloadSAPAseDatabaseWorkloadItem() (*AzureVMWorkloadSAPAseDatabaseWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPAseSystemWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSQLDatabaseWorkloadItem.
func (avwsdwi AzureVMWorkloadSQLDatabaseWorkloadItem) AsAzureVMWorkloadSAPAseSystemWorkloadItem() (*AzureVMWorkloadSAPAseSystemWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSQLDatabaseWorkloadItem.
func (avwsdwi AzureVMWorkloadSQLDatabaseWorkloadItem) AsAzureVMWorkloadSAPHanaDatabaseWorkloadItem() (*AzureVMWorkloadSAPHanaDatabaseWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaSystemWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSQLDatabaseWorkloadItem.
func (avwsdwi AzureVMWorkloadSQLDatabaseWorkloadItem) AsAzureVMWorkloadSAPHanaSystemWorkloadItem() (*AzureVMWorkloadSAPHanaSystemWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSQLDatabaseWorkloadItem.
func (avwsdwi AzureVMWorkloadSQLDatabaseWorkloadItem) AsAzureVMWorkloadSQLDatabaseWorkloadItem() (*AzureVMWorkloadSQLDatabaseWorkloadItem, bool) {
	return &avwsdwi, true
}

// AsAzureVMWorkloadSQLInstanceWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSQLDatabaseWorkloadItem.
func (avwsdwi AzureVMWorkloadSQLDatabaseWorkloadItem) AsAzureVMWorkloadSQLInstanceWorkloadItem() (*AzureVMWorkloadSQLInstanceWorkloadItem, bool) {
	return nil, false
}

// AsWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSQLDatabaseWorkloadItem.
func (avwsdwi AzureVMWorkloadSQLDatabaseWorkloadItem) AsWorkloadItem() (*WorkloadItem, bool) {
	return nil, false
}

// AsBasicWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSQLDatabaseWorkloadItem.
func (avwsdwi AzureVMWorkloadSQLDatabaseWorkloadItem) AsBasicWorkloadItem() (BasicWorkloadItem, bool) {
	return &avwsdwi, true
}

// AzureVMWorkloadSQLInstanceProtectableItem azure VM workload-specific protectable item representing SQL
// Instance.
type AzureVMWorkloadSQLInstanceProtectableItem struct {
	// ParentName - Name for instance or AG
	ParentName *string `json:"parentName,omitempty"`
	// ParentUniqueName - Parent Unique Name is added to provide the service formatted URI Name of the Parent
	// Only Applicable for data bases where the parent would be either Instance or a SQL AG.
	ParentUniqueName *string `json:"parentUniqueName,omitempty"`
	// ServerName - Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`
	// IsAutoProtectable - Indicates if protectable item is auto-protectable
	IsAutoProtectable *bool `json:"isAutoProtectable,omitempty"`
	// IsAutoProtected - Indicates if protectable item is auto-protected
	IsAutoProtected *bool `json:"isAutoProtected,omitempty"`
	// Subinquireditemcount - For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32 `json:"subinquireditemcount,omitempty"`
	// Subprotectableitemcount - For instance or AG, indicates number of DB's to be protected
	Subprotectableitemcount *int32 `json:"subprotectableitemcount,omitempty"`
	// Prebackupvalidation - Pre-backup validation for protectable objects
	Prebackupvalidation *PreBackupValidation `json:"prebackupvalidation,omitempty"`
	// BackupManagementType - Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
	// FriendlyName - Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionState - State of the back up item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// ProtectableItemType - Possible values include: 'ProtectableItemTypeWorkloadProtectableItem', 'ProtectableItemTypeAzureFileShare', 'ProtectableItemTypeMicrosoftClassicComputevirtualMachines', 'ProtectableItemTypeMicrosoftComputevirtualMachines', 'ProtectableItemTypeAzureVMWorkloadProtectableItem', 'ProtectableItemTypeSAPAseSystem', 'ProtectableItemTypeSAPHanaDatabase', 'ProtectableItemTypeSAPHanaSystem', 'ProtectableItemTypeSQLAvailabilityGroupContainer', 'ProtectableItemTypeSQLDataBase', 'ProtectableItemTypeSQLInstance', 'ProtectableItemTypeIaaSVMProtectableItem'
	ProtectableItemType ProtectableItemType `json:"protectableItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureVMWorkloadSQLInstanceProtectableItem.
func (avwsipi AzureVMWorkloadSQLInstanceProtectableItem) MarshalJSON() ([]byte, error) {
	avwsipi.ProtectableItemType = ProtectableItemTypeSQLInstance
	objectMap := make(map[string]interface{})
	if avwsipi.ParentName != nil {
		objectMap["parentName"] = avwsipi.ParentName
	}
	if avwsipi.ParentUniqueName != nil {
		objectMap["parentUniqueName"] = avwsipi.ParentUniqueName
	}
	if avwsipi.ServerName != nil {
		objectMap["serverName"] = avwsipi.ServerName
	}
	if avwsipi.IsAutoProtectable != nil {
		objectMap["isAutoProtectable"] = avwsipi.IsAutoProtectable
	}
	if avwsipi.IsAutoProtected != nil {
		objectMap["isAutoProtected"] = avwsipi.IsAutoProtected
	}
	if avwsipi.Subinquireditemcount != nil {
		objectMap["subinquireditemcount"] = avwsipi.Subinquireditemcount
	}
	if avwsipi.Subprotectableitemcount != nil {
		objectMap["subprotectableitemcount"] = avwsipi.Subprotectableitemcount
	}
	if avwsipi.Prebackupvalidation != nil {
		objectMap["prebackupvalidation"] = avwsipi.Prebackupvalidation
	}
	if avwsipi.BackupManagementType != nil {
		objectMap["backupManagementType"] = avwsipi.BackupManagementType
	}
	if avwsipi.WorkloadType != nil {
		objectMap["workloadType"] = avwsipi.WorkloadType
	}
	if avwsipi.FriendlyName != nil {
		objectMap["friendlyName"] = avwsipi.FriendlyName
	}
	if avwsipi.ProtectionState != "" {
		objectMap["protectionState"] = avwsipi.ProtectionState
	}
	if avwsipi.ProtectableItemType != "" {
		objectMap["protectableItemType"] = avwsipi.ProtectableItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLInstanceProtectableItem.
func (avwsipi AzureVMWorkloadSQLInstanceProtectableItem) AsAzureFileShareProtectableItem() (*AzureFileShareProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLInstanceProtectableItem.
func (avwsipi AzureVMWorkloadSQLInstanceProtectableItem) AsAzureIaaSClassicComputeVMProtectableItem() (*AzureIaaSClassicComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLInstanceProtectableItem.
func (avwsipi AzureVMWorkloadSQLInstanceProtectableItem) AsAzureIaaSComputeVMProtectableItem() (*AzureIaaSComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLInstanceProtectableItem.
func (avwsipi AzureVMWorkloadSQLInstanceProtectableItem) AsAzureVMWorkloadProtectableItem() (*AzureVMWorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLInstanceProtectableItem.
func (avwsipi AzureVMWorkloadSQLInstanceProtectableItem) AsBasicAzureVMWorkloadProtectableItem() (BasicAzureVMWorkloadProtectableItem, bool) {
	return &avwsipi, true
}

// AsAzureVMWorkloadSAPAseSystemProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLInstanceProtectableItem.
func (avwsipi AzureVMWorkloadSQLInstanceProtectableItem) AsAzureVMWorkloadSAPAseSystemProtectableItem() (*AzureVMWorkloadSAPAseSystemProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLInstanceProtectableItem.
func (avwsipi AzureVMWorkloadSQLInstanceProtectableItem) AsAzureVMWorkloadSAPHanaDatabaseProtectableItem() (*AzureVMWorkloadSAPHanaDatabaseProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaSystemProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLInstanceProtectableItem.
func (avwsipi AzureVMWorkloadSQLInstanceProtectableItem) AsAzureVMWorkloadSAPHanaSystemProtectableItem() (*AzureVMWorkloadSAPHanaSystemProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLInstanceProtectableItem.
func (avwsipi AzureVMWorkloadSQLInstanceProtectableItem) AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem() (*AzureVMWorkloadSQLAvailabilityGroupProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLInstanceProtectableItem.
func (avwsipi AzureVMWorkloadSQLInstanceProtectableItem) AsAzureVMWorkloadSQLDatabaseProtectableItem() (*AzureVMWorkloadSQLDatabaseProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLInstanceProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLInstanceProtectableItem.
func (avwsipi AzureVMWorkloadSQLInstanceProtectableItem) AsAzureVMWorkloadSQLInstanceProtectableItem() (*AzureVMWorkloadSQLInstanceProtectableItem, bool) {
	return &avwsipi, true
}

// AsIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLInstanceProtectableItem.
func (avwsipi AzureVMWorkloadSQLInstanceProtectableItem) AsIaaSVMProtectableItem() (*IaaSVMProtectableItem, bool) {
	return nil, false
}

// AsBasicIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLInstanceProtectableItem.
func (avwsipi AzureVMWorkloadSQLInstanceProtectableItem) AsBasicIaaSVMProtectableItem() (BasicIaaSVMProtectableItem, bool) {
	return nil, false
}

// AsWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLInstanceProtectableItem.
func (avwsipi AzureVMWorkloadSQLInstanceProtectableItem) AsWorkloadProtectableItem() (*WorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLInstanceProtectableItem.
func (avwsipi AzureVMWorkloadSQLInstanceProtectableItem) AsBasicWorkloadProtectableItem() (BasicWorkloadProtectableItem, bool) {
	return &avwsipi, true
}

// AzureVMWorkloadSQLInstanceWorkloadItem azure VM workload-specific workload item representing SQL
// Instance.
type AzureVMWorkloadSQLInstanceWorkloadItem struct {
	// DataDirectoryPaths - Data Directory Paths for default directories
	DataDirectoryPaths *[]SQLDataDirectory `json:"dataDirectoryPaths,omitempty"`
	// ParentName - Name for instance or AG
	ParentName *string `json:"parentName,omitempty"`
	// ServerName - Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`
	// IsAutoProtectable - Indicates if workload item is auto-protectable
	IsAutoProtectable *bool `json:"isAutoProtectable,omitempty"`
	// Subinquireditemcount - For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32 `json:"subinquireditemcount,omitempty"`
	// SubWorkloadItemCount - For instance or AG, indicates number of DB's to be protected
	SubWorkloadItemCount *int32 `json:"subWorkloadItemCount,omitempty"`
	// BackupManagementType - Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
	// FriendlyName - Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionState - State of the back up item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// WorkloadItemType - Possible values include: 'WorkloadItemTypeWorkloadItem', 'WorkloadItemTypeAzureVMWorkloadItem', 'WorkloadItemTypeSAPAseDatabase1', 'WorkloadItemTypeSAPAseSystem1', 'WorkloadItemTypeSAPHanaDatabase1', 'WorkloadItemTypeSAPHanaSystem1', 'WorkloadItemTypeSQLDataBase1', 'WorkloadItemTypeSQLInstance1'
	WorkloadItemType WorkloadItemTypeBasicWorkloadItem `json:"workloadItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureVMWorkloadSQLInstanceWorkloadItem.
func (avwsiwi AzureVMWorkloadSQLInstanceWorkloadItem) MarshalJSON() ([]byte, error) {
	avwsiwi.WorkloadItemType = WorkloadItemTypeSQLInstance1
	objectMap := make(map[string]interface{})
	if avwsiwi.DataDirectoryPaths != nil {
		objectMap["dataDirectoryPaths"] = avwsiwi.DataDirectoryPaths
	}
	if avwsiwi.ParentName != nil {
		objectMap["parentName"] = avwsiwi.ParentName
	}
	if avwsiwi.ServerName != nil {
		objectMap["serverName"] = avwsiwi.ServerName
	}
	if avwsiwi.IsAutoProtectable != nil {
		objectMap["isAutoProtectable"] = avwsiwi.IsAutoProtectable
	}
	if avwsiwi.Subinquireditemcount != nil {
		objectMap["subinquireditemcount"] = avwsiwi.Subinquireditemcount
	}
	if avwsiwi.SubWorkloadItemCount != nil {
		objectMap["subWorkloadItemCount"] = avwsiwi.SubWorkloadItemCount
	}
	if avwsiwi.BackupManagementType != nil {
		objectMap["backupManagementType"] = avwsiwi.BackupManagementType
	}
	if avwsiwi.WorkloadType != nil {
		objectMap["workloadType"] = avwsiwi.WorkloadType
	}
	if avwsiwi.FriendlyName != nil {
		objectMap["friendlyName"] = avwsiwi.FriendlyName
	}
	if avwsiwi.ProtectionState != "" {
		objectMap["protectionState"] = avwsiwi.ProtectionState
	}
	if avwsiwi.WorkloadItemType != "" {
		objectMap["workloadItemType"] = avwsiwi.WorkloadItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureVMWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSQLInstanceWorkloadItem.
func (avwsiwi AzureVMWorkloadSQLInstanceWorkloadItem) AsAzureVMWorkloadItem() (*AzureVMWorkloadItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSQLInstanceWorkloadItem.
func (avwsiwi AzureVMWorkloadSQLInstanceWorkloadItem) AsBasicAzureVMWorkloadItem() (BasicAzureVMWorkloadItem, bool) {
	return &avwsiwi, true
}

// AsAzureVMWorkloadSAPAseDatabaseWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSQLInstanceWorkloadItem.
func (avwsiwi AzureVMWorkloadSQLInstanceWorkloadItem) AsAzureVMWorkloadSAPAseDatabaseWorkloadItem() (*AzureVMWorkloadSAPAseDatabaseWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPAseSystemWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSQLInstanceWorkloadItem.
func (avwsiwi AzureVMWorkloadSQLInstanceWorkloadItem) AsAzureVMWorkloadSAPAseSystemWorkloadItem() (*AzureVMWorkloadSAPAseSystemWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSQLInstanceWorkloadItem.
func (avwsiwi AzureVMWorkloadSQLInstanceWorkloadItem) AsAzureVMWorkloadSAPHanaDatabaseWorkloadItem() (*AzureVMWorkloadSAPHanaDatabaseWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaSystemWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSQLInstanceWorkloadItem.
func (avwsiwi AzureVMWorkloadSQLInstanceWorkloadItem) AsAzureVMWorkloadSAPHanaSystemWorkloadItem() (*AzureVMWorkloadSAPHanaSystemWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSQLInstanceWorkloadItem.
func (avwsiwi AzureVMWorkloadSQLInstanceWorkloadItem) AsAzureVMWorkloadSQLDatabaseWorkloadItem() (*AzureVMWorkloadSQLDatabaseWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLInstanceWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSQLInstanceWorkloadItem.
func (avwsiwi AzureVMWorkloadSQLInstanceWorkloadItem) AsAzureVMWorkloadSQLInstanceWorkloadItem() (*AzureVMWorkloadSQLInstanceWorkloadItem, bool) {
	return &avwsiwi, true
}

// AsWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSQLInstanceWorkloadItem.
func (avwsiwi AzureVMWorkloadSQLInstanceWorkloadItem) AsWorkloadItem() (*WorkloadItem, bool) {
	return nil, false
}

// AsBasicWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSQLInstanceWorkloadItem.
func (avwsiwi AzureVMWorkloadSQLInstanceWorkloadItem) AsBasicWorkloadItem() (BasicWorkloadItem, bool) {
	return &avwsiwi, true
}

// AzureWorkloadBackupRequest azureWorkload workload-specific backup request.
type AzureWorkloadBackupRequest struct {
	// BackupType - Type of backup, viz. Full, Differential, Log or CopyOnlyFull. Possible values include: 'TypeInvalid', 'TypeFull', 'TypeDifferential', 'TypeLog', 'TypeCopyOnlyFull'
	BackupType Type `json:"backupType,omitempty"`
	// EnableCompression - Bool for Compression setting
	EnableCompression *bool `json:"enableCompression,omitempty"`
	// RecoveryPointExpiryTimeInUTC - Backup copy will expire after the time specified (UTC).
	RecoveryPointExpiryTimeInUTC *date.Time `json:"recoveryPointExpiryTimeInUTC,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeBackupRequest', 'ObjectTypeAzureFileShareBackupRequest', 'ObjectTypeAzureWorkloadBackupRequest', 'ObjectTypeIaasVMBackupRequest'
	ObjectType ObjectType `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureWorkloadBackupRequest.
func (awbr AzureWorkloadBackupRequest) MarshalJSON() ([]byte, error) {
	awbr.ObjectType = ObjectTypeAzureWorkloadBackupRequest
	objectMap := make(map[string]interface{})
	if awbr.BackupType != "" {
		objectMap["backupType"] = awbr.BackupType
	}
	if awbr.EnableCompression != nil {
		objectMap["enableCompression"] = awbr.EnableCompression
	}
	if awbr.RecoveryPointExpiryTimeInUTC != nil {
		objectMap["recoveryPointExpiryTimeInUTC"] = awbr.RecoveryPointExpiryTimeInUTC
	}
	if awbr.ObjectType != "" {
		objectMap["objectType"] = awbr.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareBackupRequest is the BasicRequest implementation for AzureWorkloadBackupRequest.
func (awbr AzureWorkloadBackupRequest) AsAzureFileShareBackupRequest() (*AzureFileShareBackupRequest, bool) {
	return nil, false
}

// AsAzureWorkloadBackupRequest is the BasicRequest implementation for AzureWorkloadBackupRequest.
func (awbr AzureWorkloadBackupRequest) AsAzureWorkloadBackupRequest() (*AzureWorkloadBackupRequest, bool) {
	return &awbr, true
}

// AsIaasVMBackupRequest is the BasicRequest implementation for AzureWorkloadBackupRequest.
func (awbr AzureWorkloadBackupRequest) AsIaasVMBackupRequest() (*IaasVMBackupRequest, bool) {
	return nil, false
}

// AsRequest is the BasicRequest implementation for AzureWorkloadBackupRequest.
func (awbr AzureWorkloadBackupRequest) AsRequest() (*Request, bool) {
	return nil, false
}

// AsBasicRequest is the BasicRequest implementation for AzureWorkloadBackupRequest.
func (awbr AzureWorkloadBackupRequest) AsBasicRequest() (BasicRequest, bool) {
	return &awbr, true
}

// BasicAzureWorkloadContainer container for the workloads running inside Azure Compute or Classic Compute.
type BasicAzureWorkloadContainer interface {
	AsAzureSQLAGWorkloadContainerProtectionContainer() (*AzureSQLAGWorkloadContainerProtectionContainer, bool)
	AsAzureVMAppContainerProtectionContainer() (*AzureVMAppContainerProtectionContainer, bool)
	AsAzureWorkloadContainer() (*AzureWorkloadContainer, bool)
}

// AzureWorkloadContainer container for the workloads running inside Azure Compute or Classic Compute.
type AzureWorkloadContainer struct {
	// SourceResourceID - ARM ID of the virtual machine represented by this Azure Workload Container
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
	// LastUpdatedTime - Time stamp when this container was updated.
	LastUpdatedTime *date.Time `json:"lastUpdatedTime,omitempty"`
	// ExtendedInfo - Additional details of a workload container.
	ExtendedInfo *AzureWorkloadContainerExtendedInfo `json:"extendedInfo,omitempty"`
	// WorkloadType - Workload type for which registration was sent. Possible values include: 'WorkloadTypeInvalid', 'WorkloadTypeVM', 'WorkloadTypeFileFolder', 'WorkloadTypeAzureSQLDb', 'WorkloadTypeSQLDB', 'WorkloadTypeExchange', 'WorkloadTypeSharepoint', 'WorkloadTypeVMwareVM', 'WorkloadTypeSystemState', 'WorkloadTypeClient', 'WorkloadTypeGenericDataSource', 'WorkloadTypeSQLDataBase', 'WorkloadTypeAzureFileShare', 'WorkloadTypeSAPHanaDatabase', 'WorkloadTypeSAPAseDatabase'
	WorkloadType WorkloadType `json:"workloadType,omitempty"`
	// OperationType - Re-Do Operation. Possible values include: 'OperationTypeInvalid', 'OperationTypeRegister', 'OperationTypeReregister'
	OperationType OperationType `json:"operationType,omitempty"`
	// FriendlyName - Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - Type of backup management for the container. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// RegistrationStatus - Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
	// HealthStatus - Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// ContainerType - Possible values include: 'ContainerTypeProtectionContainer', 'ContainerTypeAzureBackupServerContainer1', 'ContainerTypeMicrosoftClassicComputevirtualMachines', 'ContainerTypeMicrosoftComputevirtualMachines', 'ContainerTypeSQLAGWorkLoadContainer1', 'ContainerTypeAzureSQLContainer1', 'ContainerTypeStorageContainer1', 'ContainerTypeVMAppContainer1', 'ContainerTypeAzureWorkloadContainer', 'ContainerTypeDPMContainer1', 'ContainerTypeGenericContainer1', 'ContainerTypeIaaSVMContainer', 'ContainerTypeWindows1'
	ContainerType ContainerTypeBasicProtectionContainer `json:"containerType,omitempty"`
}

func unmarshalBasicAzureWorkloadContainer(body []byte) (BasicAzureWorkloadContainer, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["containerType"] {
	case string(ContainerTypeSQLAGWorkLoadContainer1):
		var aswcpc AzureSQLAGWorkloadContainerProtectionContainer
		err := json.Unmarshal(body, &aswcpc)
		return aswcpc, err
	case string(ContainerTypeVMAppContainer1):
		var avacpc AzureVMAppContainerProtectionContainer
		err := json.Unmarshal(body, &avacpc)
		return avacpc, err
	default:
		var awc AzureWorkloadContainer
		err := json.Unmarshal(body, &awc)
		return awc, err
	}
}
func unmarshalBasicAzureWorkloadContainerArray(body []byte) ([]BasicAzureWorkloadContainer, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	awcArray := make([]BasicAzureWorkloadContainer, len(rawMessages))

	for index, rawMessage := range rawMessages {
		awc, err := unmarshalBasicAzureWorkloadContainer(*rawMessage)
		if err != nil {
			return nil, err
		}
		awcArray[index] = awc
	}
	return awcArray, nil
}

// MarshalJSON is the custom marshaler for AzureWorkloadContainer.
func (awc AzureWorkloadContainer) MarshalJSON() ([]byte, error) {
	awc.ContainerType = ContainerTypeAzureWorkloadContainer
	objectMap := make(map[string]interface{})
	if awc.SourceResourceID != nil {
		objectMap["sourceResourceId"] = awc.SourceResourceID
	}
	if awc.LastUpdatedTime != nil {
		objectMap["lastUpdatedTime"] = awc.LastUpdatedTime
	}
	if awc.ExtendedInfo != nil {
		objectMap["extendedInfo"] = awc.ExtendedInfo
	}
	if awc.WorkloadType != "" {
		objectMap["workloadType"] = awc.WorkloadType
	}
	if awc.OperationType != "" {
		objectMap["operationType"] = awc.OperationType
	}
	if awc.FriendlyName != nil {
		objectMap["friendlyName"] = awc.FriendlyName
	}
	if awc.BackupManagementType != "" {
		objectMap["backupManagementType"] = awc.BackupManagementType
	}
	if awc.RegistrationStatus != nil {
		objectMap["registrationStatus"] = awc.RegistrationStatus
	}
	if awc.HealthStatus != nil {
		objectMap["healthStatus"] = awc.HealthStatus
	}
	if awc.ContainerType != "" {
		objectMap["containerType"] = awc.ContainerType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupServerContainer is the BasicProtectionContainer implementation for AzureWorkloadContainer.
func (awc AzureWorkloadContainer) AsAzureBackupServerContainer() (*AzureBackupServerContainer, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMContainer is the BasicProtectionContainer implementation for AzureWorkloadContainer.
func (awc AzureWorkloadContainer) AsAzureIaaSClassicComputeVMContainer() (*AzureIaaSClassicComputeVMContainer, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMContainer is the BasicProtectionContainer implementation for AzureWorkloadContainer.
func (awc AzureWorkloadContainer) AsAzureIaaSComputeVMContainer() (*AzureIaaSComputeVMContainer, bool) {
	return nil, false
}

// AsAzureSQLAGWorkloadContainerProtectionContainer is the BasicProtectionContainer implementation for AzureWorkloadContainer.
func (awc AzureWorkloadContainer) AsAzureSQLAGWorkloadContainerProtectionContainer() (*AzureSQLAGWorkloadContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureSQLContainer is the BasicProtectionContainer implementation for AzureWorkloadContainer.
func (awc AzureWorkloadContainer) AsAzureSQLContainer() (*AzureSQLContainer, bool) {
	return nil, false
}

// AsAzureStorageContainer is the BasicProtectionContainer implementation for AzureWorkloadContainer.
func (awc AzureWorkloadContainer) AsAzureStorageContainer() (*AzureStorageContainer, bool) {
	return nil, false
}

// AsAzureVMAppContainerProtectionContainer is the BasicProtectionContainer implementation for AzureWorkloadContainer.
func (awc AzureWorkloadContainer) AsAzureVMAppContainerProtectionContainer() (*AzureVMAppContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureWorkloadContainer is the BasicProtectionContainer implementation for AzureWorkloadContainer.
func (awc AzureWorkloadContainer) AsAzureWorkloadContainer() (*AzureWorkloadContainer, bool) {
	return &awc, true
}

// AsBasicAzureWorkloadContainer is the BasicProtectionContainer implementation for AzureWorkloadContainer.
func (awc AzureWorkloadContainer) AsBasicAzureWorkloadContainer() (BasicAzureWorkloadContainer, bool) {
	return &awc, true
}

// AsDpmContainer is the BasicProtectionContainer implementation for AzureWorkloadContainer.
func (awc AzureWorkloadContainer) AsDpmContainer() (*DpmContainer, bool) {
	return nil, false
}

// AsBasicDpmContainer is the BasicProtectionContainer implementation for AzureWorkloadContainer.
func (awc AzureWorkloadContainer) AsBasicDpmContainer() (BasicDpmContainer, bool) {
	return nil, false
}

// AsGenericContainer is the BasicProtectionContainer implementation for AzureWorkloadContainer.
func (awc AzureWorkloadContainer) AsGenericContainer() (*GenericContainer, bool) {
	return nil, false
}

// AsIaaSVMContainer is the BasicProtectionContainer implementation for AzureWorkloadContainer.
func (awc AzureWorkloadContainer) AsIaaSVMContainer() (*IaaSVMContainer, bool) {
	return nil, false
}

// AsBasicIaaSVMContainer is the BasicProtectionContainer implementation for AzureWorkloadContainer.
func (awc AzureWorkloadContainer) AsBasicIaaSVMContainer() (BasicIaaSVMContainer, bool) {
	return nil, false
}

// AsMabContainer is the BasicProtectionContainer implementation for AzureWorkloadContainer.
func (awc AzureWorkloadContainer) AsMabContainer() (*MabContainer, bool) {
	return nil, false
}

// AsProtectionContainer is the BasicProtectionContainer implementation for AzureWorkloadContainer.
func (awc AzureWorkloadContainer) AsProtectionContainer() (*ProtectionContainer, bool) {
	return nil, false
}

// AsBasicProtectionContainer is the BasicProtectionContainer implementation for AzureWorkloadContainer.
func (awc AzureWorkloadContainer) AsBasicProtectionContainer() (BasicProtectionContainer, bool) {
	return &awc, true
}

// AzureWorkloadContainerExtendedInfo extended information of the container.
type AzureWorkloadContainerExtendedInfo struct {
	// HostServerName - Host Os Name in case of Stand Alone and Cluster Name in case of distributed container.
	HostServerName *string `json:"hostServerName,omitempty"`
	// InquiryInfo - Inquiry Status for the container.
	InquiryInfo *InquiryInfo `json:"inquiryInfo,omitempty"`
	// NodesList - List of the nodes in case of distributed container.
	NodesList *[]DistributedNodesInfo `json:"nodesList,omitempty"`
}

// BMSBackupEngineQueryObject query parameters to fetch list of backup engines.
type BMSBackupEngineQueryObject struct {
	// Expand - attribute to add extended info
	Expand *string `json:"expand,omitempty"`
}

// BMSBackupEnginesQueryObject query parameters to fetch list of backup engines.
type BMSBackupEnginesQueryObject struct {
	// BackupManagementType - Backup management type for the backup engine. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// FriendlyName - Friendly name of the backup engine.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// Expand - Attribute to add extended info.
	Expand *string `json:"expand,omitempty"`
}

// BMSContainerQueryObject the query filters that can be used with the list containers API.
type BMSContainerQueryObject struct {
	// BackupManagementType - Backup management type for this container. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// ContainerType - Type of container for filter. Possible values include: 'ContainerTypeInvalid', 'ContainerTypeUnknown', 'ContainerTypeIaasVMContainer', 'ContainerTypeIaasVMServiceContainer', 'ContainerTypeDPMContainer', 'ContainerTypeAzureBackupServerContainer', 'ContainerTypeMABContainer', 'ContainerTypeCluster', 'ContainerTypeAzureSQLContainer', 'ContainerTypeWindows', 'ContainerTypeVCenter', 'ContainerTypeVMAppContainer', 'ContainerTypeSQLAGWorkLoadContainer', 'ContainerTypeStorageContainer', 'ContainerTypeGenericContainer'
	ContainerType ContainerType `json:"containerType,omitempty"`
	// BackupEngineName - Backup engine name
	BackupEngineName *string `json:"backupEngineName,omitempty"`
	// FabricName - Fabric name for filter
	FabricName *string `json:"fabricName,omitempty"`
	// Status - Status of registration of this container with the Recovery Services Vault.
	Status *string `json:"status,omitempty"`
	// FriendlyName - Friendly name of this container.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// BMSContainersInquiryQueryObject the query filters that can be used with the inquire container API.
type BMSContainersInquiryQueryObject struct {
	// BackupManagementType - Backup management type for this container. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// WorkloadType - Workload type for this container. Possible values include: 'WorkloadTypeInvalid', 'WorkloadTypeVM', 'WorkloadTypeFileFolder', 'WorkloadTypeAzureSQLDb', 'WorkloadTypeSQLDB', 'WorkloadTypeExchange', 'WorkloadTypeSharepoint', 'WorkloadTypeVMwareVM', 'WorkloadTypeSystemState', 'WorkloadTypeClient', 'WorkloadTypeGenericDataSource', 'WorkloadTypeSQLDataBase', 'WorkloadTypeAzureFileShare', 'WorkloadTypeSAPHanaDatabase', 'WorkloadTypeSAPAseDatabase'
	WorkloadType WorkloadType `json:"workloadType,omitempty"`
}

// BMSPOQueryObject filters to list items that can be backed up.
type BMSPOQueryObject struct {
	// BackupManagementType - Backup management type. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// WorkloadType - Workload type. Possible values include: 'WorkloadTypeInvalid', 'WorkloadTypeVM', 'WorkloadTypeFileFolder', 'WorkloadTypeAzureSQLDb', 'WorkloadTypeSQLDB', 'WorkloadTypeExchange', 'WorkloadTypeSharepoint', 'WorkloadTypeVMwareVM', 'WorkloadTypeSystemState', 'WorkloadTypeClient', 'WorkloadTypeGenericDataSource', 'WorkloadTypeSQLDataBase', 'WorkloadTypeAzureFileShare', 'WorkloadTypeSAPHanaDatabase', 'WorkloadTypeSAPAseDatabase'
	WorkloadType WorkloadType `json:"workloadType,omitempty"`
	// ContainerName - Full name of the container whose Protectable Objects should be returned.
	ContainerName *string `json:"containerName,omitempty"`
	// Status - Backup status query parameter.
	Status *string `json:"status,omitempty"`
	// FriendlyName - Friendly name.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// BMSRefreshContainersQueryObject the query filters that can be used with the refresh container API.
type BMSRefreshContainersQueryObject struct {
	// BackupManagementType - Backup management type for this container. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
}

// BMSWorkloadItemQueryObject filters to list items that can be backed up.
type BMSWorkloadItemQueryObject struct {
	// BackupManagementType - Backup management type. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// WorkloadItemType - Workload Item type. Possible values include: 'WorkloadItemTypeInvalid', 'WorkloadItemTypeSQLInstance', 'WorkloadItemTypeSQLDataBase', 'WorkloadItemTypeSAPHanaSystem', 'WorkloadItemTypeSAPHanaDatabase', 'WorkloadItemTypeSAPAseSystem', 'WorkloadItemTypeSAPAseDatabase'
	WorkloadItemType WorkloadItemType `json:"workloadItemType,omitempty"`
	// WorkloadType - Workload type. Possible values include: 'WorkloadTypeInvalid', 'WorkloadTypeVM', 'WorkloadTypeFileFolder', 'WorkloadTypeAzureSQLDb', 'WorkloadTypeSQLDB', 'WorkloadTypeExchange', 'WorkloadTypeSharepoint', 'WorkloadTypeVMwareVM', 'WorkloadTypeSystemState', 'WorkloadTypeClient', 'WorkloadTypeGenericDataSource', 'WorkloadTypeSQLDataBase', 'WorkloadTypeAzureFileShare', 'WorkloadTypeSAPHanaDatabase', 'WorkloadTypeSAPAseDatabase'
	WorkloadType WorkloadType `json:"workloadType,omitempty"`
	// ProtectionStatus - Backup status query parameter. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionStatus ProtectionStatus `json:"protectionStatus,omitempty"`
}

// ClientScriptForConnect client script details for file / folder restore.
type ClientScriptForConnect struct {
	// ScriptContent - File content of the client script for file / folder restore.
	ScriptContent *string `json:"scriptContent,omitempty"`
	// ScriptExtension - File extension of the client script for file / folder restore - .ps1 , .sh , etc.
	ScriptExtension *string `json:"scriptExtension,omitempty"`
	// OsType - OS type - Windows, Linux etc. for which this file / folder restore client script works.
	OsType *string `json:"osType,omitempty"`
	// URL - URL of Executable from where to source the content. If this is not null then ScriptContent should not be used
	URL *string `json:"url,omitempty"`
	// ScriptNameSuffix - Mandatory suffix that should be added to the name of script that is given for download to user.
	// If its null or empty then , ignore it.
	ScriptNameSuffix *string `json:"scriptNameSuffix,omitempty"`
}

// ContainerIdentityInfo container identity information
type ContainerIdentityInfo struct {
	// UniqueName - Unique name of the container
	UniqueName *string `json:"uniqueName,omitempty"`
	// AadTenantID - Protection container identity - AAD Tenant
	AadTenantID *string `json:"aadTenantId,omitempty"`
	// ServicePrincipalClientID - Protection container identity - AAD Service Principal
	ServicePrincipalClientID *string `json:"servicePrincipalClientId,omitempty"`
	// Audience - Protection container identity - Audience
	Audience *string `json:"audience,omitempty"`
}

// DistributedNodesInfo this is used to represent the various nodes of the distributed container.
type DistributedNodesInfo struct {
	// NodeName - Name of the node under a distributed container.
	NodeName *string `json:"nodeName,omitempty"`
	// Status - Status of this Node.
	// Failed | Succeeded
	Status *string `json:"status,omitempty"`
	// ErrorDetail - Error Details if the Status is non-success.
	ErrorDetail *ErrorDetail `json:"errorDetail,omitempty"`
}

// DpmBackupEngine data Protection Manager (DPM) specific backup engine.
type DpmBackupEngine struct {
	// FriendlyName - Friendly name of the backup engine.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - Type of backup management for the backup engine. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// RegistrationStatus - Registration status of the backup engine with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
	// BackupEngineState - Status of the backup engine with the Recovery Services Vault. = {Active/Deleting/DeleteFailed}
	BackupEngineState *string `json:"backupEngineState,omitempty"`
	// HealthStatus - Backup status of the backup engine.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// CanReRegister - Flag indicating if the backup engine be registered, once already registered.
	CanReRegister *bool `json:"canReRegister,omitempty"`
	// BackupEngineID - ID of the backup engine.
	BackupEngineID *string `json:"backupEngineId,omitempty"`
	// DpmVersion - Backup engine version
	DpmVersion *string `json:"dpmVersion,omitempty"`
	// AzureBackupAgentVersion - Backup agent version
	AzureBackupAgentVersion *string `json:"azureBackupAgentVersion,omitempty"`
	// IsAzureBackupAgentUpgradeAvailable - To check if backup agent upgrade available
	IsAzureBackupAgentUpgradeAvailable *bool `json:"isAzureBackupAgentUpgradeAvailable,omitempty"`
	// IsDpmUpgradeAvailable - To check if backup engine upgrade available
	IsDpmUpgradeAvailable *bool `json:"isDpmUpgradeAvailable,omitempty"`
	// ExtendedInfo - Extended info of the backupengine
	ExtendedInfo *EngineExtendedInfo `json:"extendedInfo,omitempty"`
	// BackupEngineType - Possible values include: 'BackupEngineTypeBackupEngineBase', 'BackupEngineTypeAzureBackupServerEngine', 'BackupEngineTypeDpmBackupEngine'
	BackupEngineType EngineType `json:"backupEngineType,omitempty"`
}

// MarshalJSON is the custom marshaler for DpmBackupEngine.
func (dbe DpmBackupEngine) MarshalJSON() ([]byte, error) {
	dbe.BackupEngineType = BackupEngineTypeDpmBackupEngine
	objectMap := make(map[string]interface{})
	if dbe.FriendlyName != nil {
		objectMap["friendlyName"] = dbe.FriendlyName
	}
	if dbe.BackupManagementType != "" {
		objectMap["backupManagementType"] = dbe.BackupManagementType
	}
	if dbe.RegistrationStatus != nil {
		objectMap["registrationStatus"] = dbe.RegistrationStatus
	}
	if dbe.BackupEngineState != nil {
		objectMap["backupEngineState"] = dbe.BackupEngineState
	}
	if dbe.HealthStatus != nil {
		objectMap["healthStatus"] = dbe.HealthStatus
	}
	if dbe.CanReRegister != nil {
		objectMap["canReRegister"] = dbe.CanReRegister
	}
	if dbe.BackupEngineID != nil {
		objectMap["backupEngineId"] = dbe.BackupEngineID
	}
	if dbe.DpmVersion != nil {
		objectMap["dpmVersion"] = dbe.DpmVersion
	}
	if dbe.AzureBackupAgentVersion != nil {
		objectMap["azureBackupAgentVersion"] = dbe.AzureBackupAgentVersion
	}
	if dbe.IsAzureBackupAgentUpgradeAvailable != nil {
		objectMap["isAzureBackupAgentUpgradeAvailable"] = dbe.IsAzureBackupAgentUpgradeAvailable
	}
	if dbe.IsDpmUpgradeAvailable != nil {
		objectMap["isDpmUpgradeAvailable"] = dbe.IsDpmUpgradeAvailable
	}
	if dbe.ExtendedInfo != nil {
		objectMap["extendedInfo"] = dbe.ExtendedInfo
	}
	if dbe.BackupEngineType != "" {
		objectMap["backupEngineType"] = dbe.BackupEngineType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupServerEngine is the BasicEngineBase implementation for DpmBackupEngine.
func (dbe DpmBackupEngine) AsAzureBackupServerEngine() (*AzureBackupServerEngine, bool) {
	return nil, false
}

// AsDpmBackupEngine is the BasicEngineBase implementation for DpmBackupEngine.
func (dbe DpmBackupEngine) AsDpmBackupEngine() (*DpmBackupEngine, bool) {
	return &dbe, true
}

// AsEngineBase is the BasicEngineBase implementation for DpmBackupEngine.
func (dbe DpmBackupEngine) AsEngineBase() (*EngineBase, bool) {
	return nil, false
}

// AsBasicEngineBase is the BasicEngineBase implementation for DpmBackupEngine.
func (dbe DpmBackupEngine) AsBasicEngineBase() (BasicEngineBase, bool) {
	return &dbe, true
}

// BasicDpmContainer DPM workload-specific protection container.
type BasicDpmContainer interface {
	AsAzureBackupServerContainer() (*AzureBackupServerContainer, bool)
	AsDpmContainer() (*DpmContainer, bool)
}

// DpmContainer DPM workload-specific protection container.
type DpmContainer struct {
	// CanReRegister - Specifies whether the container is re-registrable.
	CanReRegister *bool `json:"canReRegister,omitempty"`
	// ContainerID - ID of container.
	ContainerID *string `json:"containerId,omitempty"`
	// ProtectedItemCount - Number of protected items in the BackupEngine
	ProtectedItemCount *int64 `json:"protectedItemCount,omitempty"`
	// DpmAgentVersion - Backup engine Agent version
	DpmAgentVersion *string `json:"dpmAgentVersion,omitempty"`
	// DpmServers - List of BackupEngines protecting the container
	DpmServers *[]string `json:"dpmServers,omitempty"`
	// UpgradeAvailable - To check if upgrade available
	UpgradeAvailable *bool `json:"upgradeAvailable,omitempty"`
	// ProtectionStatus - Protection status of the container.
	ProtectionStatus *string `json:"protectionStatus,omitempty"`
	// ExtendedInfo - Extended Info of the container.
	ExtendedInfo *DPMContainerExtendedInfo `json:"extendedInfo,omitempty"`
	// FriendlyName - Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - Type of backup management for the container. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// RegistrationStatus - Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
	// HealthStatus - Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// ContainerType - Possible values include: 'ContainerTypeProtectionContainer', 'ContainerTypeAzureBackupServerContainer1', 'ContainerTypeMicrosoftClassicComputevirtualMachines', 'ContainerTypeMicrosoftComputevirtualMachines', 'ContainerTypeSQLAGWorkLoadContainer1', 'ContainerTypeAzureSQLContainer1', 'ContainerTypeStorageContainer1', 'ContainerTypeVMAppContainer1', 'ContainerTypeAzureWorkloadContainer', 'ContainerTypeDPMContainer1', 'ContainerTypeGenericContainer1', 'ContainerTypeIaaSVMContainer', 'ContainerTypeWindows1'
	ContainerType ContainerTypeBasicProtectionContainer `json:"containerType,omitempty"`
}

func unmarshalBasicDpmContainer(body []byte) (BasicDpmContainer, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["containerType"] {
	case string(ContainerTypeAzureBackupServerContainer1):
		var absc AzureBackupServerContainer
		err := json.Unmarshal(body, &absc)
		return absc, err
	default:
		var dc DpmContainer
		err := json.Unmarshal(body, &dc)
		return dc, err
	}
}
func unmarshalBasicDpmContainerArray(body []byte) ([]BasicDpmContainer, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	dcArray := make([]BasicDpmContainer, len(rawMessages))

	for index, rawMessage := range rawMessages {
		dc, err := unmarshalBasicDpmContainer(*rawMessage)
		if err != nil {
			return nil, err
		}
		dcArray[index] = dc
	}
	return dcArray, nil
}

// MarshalJSON is the custom marshaler for DpmContainer.
func (dc DpmContainer) MarshalJSON() ([]byte, error) {
	dc.ContainerType = ContainerTypeDPMContainer1
	objectMap := make(map[string]interface{})
	if dc.CanReRegister != nil {
		objectMap["canReRegister"] = dc.CanReRegister
	}
	if dc.ContainerID != nil {
		objectMap["containerId"] = dc.ContainerID
	}
	if dc.ProtectedItemCount != nil {
		objectMap["protectedItemCount"] = dc.ProtectedItemCount
	}
	if dc.DpmAgentVersion != nil {
		objectMap["dpmAgentVersion"] = dc.DpmAgentVersion
	}
	if dc.DpmServers != nil {
		objectMap["dpmServers"] = dc.DpmServers
	}
	if dc.UpgradeAvailable != nil {
		objectMap["upgradeAvailable"] = dc.UpgradeAvailable
	}
	if dc.ProtectionStatus != nil {
		objectMap["protectionStatus"] = dc.ProtectionStatus
	}
	if dc.ExtendedInfo != nil {
		objectMap["extendedInfo"] = dc.ExtendedInfo
	}
	if dc.FriendlyName != nil {
		objectMap["friendlyName"] = dc.FriendlyName
	}
	if dc.BackupManagementType != "" {
		objectMap["backupManagementType"] = dc.BackupManagementType
	}
	if dc.RegistrationStatus != nil {
		objectMap["registrationStatus"] = dc.RegistrationStatus
	}
	if dc.HealthStatus != nil {
		objectMap["healthStatus"] = dc.HealthStatus
	}
	if dc.ContainerType != "" {
		objectMap["containerType"] = dc.ContainerType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupServerContainer is the BasicProtectionContainer implementation for DpmContainer.
func (dc DpmContainer) AsAzureBackupServerContainer() (*AzureBackupServerContainer, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMContainer is the BasicProtectionContainer implementation for DpmContainer.
func (dc DpmContainer) AsAzureIaaSClassicComputeVMContainer() (*AzureIaaSClassicComputeVMContainer, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMContainer is the BasicProtectionContainer implementation for DpmContainer.
func (dc DpmContainer) AsAzureIaaSComputeVMContainer() (*AzureIaaSComputeVMContainer, bool) {
	return nil, false
}

// AsAzureSQLAGWorkloadContainerProtectionContainer is the BasicProtectionContainer implementation for DpmContainer.
func (dc DpmContainer) AsAzureSQLAGWorkloadContainerProtectionContainer() (*AzureSQLAGWorkloadContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureSQLContainer is the BasicProtectionContainer implementation for DpmContainer.
func (dc DpmContainer) AsAzureSQLContainer() (*AzureSQLContainer, bool) {
	return nil, false
}

// AsAzureStorageContainer is the BasicProtectionContainer implementation for DpmContainer.
func (dc DpmContainer) AsAzureStorageContainer() (*AzureStorageContainer, bool) {
	return nil, false
}

// AsAzureVMAppContainerProtectionContainer is the BasicProtectionContainer implementation for DpmContainer.
func (dc DpmContainer) AsAzureVMAppContainerProtectionContainer() (*AzureVMAppContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureWorkloadContainer is the BasicProtectionContainer implementation for DpmContainer.
func (dc DpmContainer) AsAzureWorkloadContainer() (*AzureWorkloadContainer, bool) {
	return nil, false
}

// AsBasicAzureWorkloadContainer is the BasicProtectionContainer implementation for DpmContainer.
func (dc DpmContainer) AsBasicAzureWorkloadContainer() (BasicAzureWorkloadContainer, bool) {
	return nil, false
}

// AsDpmContainer is the BasicProtectionContainer implementation for DpmContainer.
func (dc DpmContainer) AsDpmContainer() (*DpmContainer, bool) {
	return &dc, true
}

// AsBasicDpmContainer is the BasicProtectionContainer implementation for DpmContainer.
func (dc DpmContainer) AsBasicDpmContainer() (BasicDpmContainer, bool) {
	return &dc, true
}

// AsGenericContainer is the BasicProtectionContainer implementation for DpmContainer.
func (dc DpmContainer) AsGenericContainer() (*GenericContainer, bool) {
	return nil, false
}

// AsIaaSVMContainer is the BasicProtectionContainer implementation for DpmContainer.
func (dc DpmContainer) AsIaaSVMContainer() (*IaaSVMContainer, bool) {
	return nil, false
}

// AsBasicIaaSVMContainer is the BasicProtectionContainer implementation for DpmContainer.
func (dc DpmContainer) AsBasicIaaSVMContainer() (BasicIaaSVMContainer, bool) {
	return nil, false
}

// AsMabContainer is the BasicProtectionContainer implementation for DpmContainer.
func (dc DpmContainer) AsMabContainer() (*MabContainer, bool) {
	return nil, false
}

// AsProtectionContainer is the BasicProtectionContainer implementation for DpmContainer.
func (dc DpmContainer) AsProtectionContainer() (*ProtectionContainer, bool) {
	return nil, false
}

// AsBasicProtectionContainer is the BasicProtectionContainer implementation for DpmContainer.
func (dc DpmContainer) AsBasicProtectionContainer() (BasicProtectionContainer, bool) {
	return &dc, true
}

// DPMContainerExtendedInfo additional information of the DPMContainer.
type DPMContainerExtendedInfo struct {
	// LastRefreshedAt - Last refresh time of the DPMContainer.
	LastRefreshedAt *date.Time `json:"lastRefreshedAt,omitempty"`
}

// BasicEngineBase the base backup engine class. All workload specific backup engines derive from this class.
type BasicEngineBase interface {
	AsAzureBackupServerEngine() (*AzureBackupServerEngine, bool)
	AsDpmBackupEngine() (*DpmBackupEngine, bool)
	AsEngineBase() (*EngineBase, bool)
}

// EngineBase the base backup engine class. All workload specific backup engines derive from this class.
type EngineBase struct {
	// FriendlyName - Friendly name of the backup engine.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - Type of backup management for the backup engine. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// RegistrationStatus - Registration status of the backup engine with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
	// BackupEngineState - Status of the backup engine with the Recovery Services Vault. = {Active/Deleting/DeleteFailed}
	BackupEngineState *string `json:"backupEngineState,omitempty"`
	// HealthStatus - Backup status of the backup engine.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// CanReRegister - Flag indicating if the backup engine be registered, once already registered.
	CanReRegister *bool `json:"canReRegister,omitempty"`
	// BackupEngineID - ID of the backup engine.
	BackupEngineID *string `json:"backupEngineId,omitempty"`
	// DpmVersion - Backup engine version
	DpmVersion *string `json:"dpmVersion,omitempty"`
	// AzureBackupAgentVersion - Backup agent version
	AzureBackupAgentVersion *string `json:"azureBackupAgentVersion,omitempty"`
	// IsAzureBackupAgentUpgradeAvailable - To check if backup agent upgrade available
	IsAzureBackupAgentUpgradeAvailable *bool `json:"isAzureBackupAgentUpgradeAvailable,omitempty"`
	// IsDpmUpgradeAvailable - To check if backup engine upgrade available
	IsDpmUpgradeAvailable *bool `json:"isDpmUpgradeAvailable,omitempty"`
	// ExtendedInfo - Extended info of the backupengine
	ExtendedInfo *EngineExtendedInfo `json:"extendedInfo,omitempty"`
	// BackupEngineType - Possible values include: 'BackupEngineTypeBackupEngineBase', 'BackupEngineTypeAzureBackupServerEngine', 'BackupEngineTypeDpmBackupEngine'
	BackupEngineType EngineType `json:"backupEngineType,omitempty"`
}

func unmarshalBasicEngineBase(body []byte) (BasicEngineBase, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["backupEngineType"] {
	case string(BackupEngineTypeAzureBackupServerEngine):
		var abse AzureBackupServerEngine
		err := json.Unmarshal(body, &abse)
		return abse, err
	case string(BackupEngineTypeDpmBackupEngine):
		var dbe DpmBackupEngine
		err := json.Unmarshal(body, &dbe)
		return dbe, err
	default:
		var eb EngineBase
		err := json.Unmarshal(body, &eb)
		return eb, err
	}
}
func unmarshalBasicEngineBaseArray(body []byte) ([]BasicEngineBase, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ebArray := make([]BasicEngineBase, len(rawMessages))

	for index, rawMessage := range rawMessages {
		eb, err := unmarshalBasicEngineBase(*rawMessage)
		if err != nil {
			return nil, err
		}
		ebArray[index] = eb
	}
	return ebArray, nil
}

// MarshalJSON is the custom marshaler for EngineBase.
func (eb EngineBase) MarshalJSON() ([]byte, error) {
	eb.BackupEngineType = BackupEngineTypeBackupEngineBase
	objectMap := make(map[string]interface{})
	if eb.FriendlyName != nil {
		objectMap["friendlyName"] = eb.FriendlyName
	}
	if eb.BackupManagementType != "" {
		objectMap["backupManagementType"] = eb.BackupManagementType
	}
	if eb.RegistrationStatus != nil {
		objectMap["registrationStatus"] = eb.RegistrationStatus
	}
	if eb.BackupEngineState != nil {
		objectMap["backupEngineState"] = eb.BackupEngineState
	}
	if eb.HealthStatus != nil {
		objectMap["healthStatus"] = eb.HealthStatus
	}
	if eb.CanReRegister != nil {
		objectMap["canReRegister"] = eb.CanReRegister
	}
	if eb.BackupEngineID != nil {
		objectMap["backupEngineId"] = eb.BackupEngineID
	}
	if eb.DpmVersion != nil {
		objectMap["dpmVersion"] = eb.DpmVersion
	}
	if eb.AzureBackupAgentVersion != nil {
		objectMap["azureBackupAgentVersion"] = eb.AzureBackupAgentVersion
	}
	if eb.IsAzureBackupAgentUpgradeAvailable != nil {
		objectMap["isAzureBackupAgentUpgradeAvailable"] = eb.IsAzureBackupAgentUpgradeAvailable
	}
	if eb.IsDpmUpgradeAvailable != nil {
		objectMap["isDpmUpgradeAvailable"] = eb.IsDpmUpgradeAvailable
	}
	if eb.ExtendedInfo != nil {
		objectMap["extendedInfo"] = eb.ExtendedInfo
	}
	if eb.BackupEngineType != "" {
		objectMap["backupEngineType"] = eb.BackupEngineType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupServerEngine is the BasicEngineBase implementation for EngineBase.
func (eb EngineBase) AsAzureBackupServerEngine() (*AzureBackupServerEngine, bool) {
	return nil, false
}

// AsDpmBackupEngine is the BasicEngineBase implementation for EngineBase.
func (eb EngineBase) AsDpmBackupEngine() (*DpmBackupEngine, bool) {
	return nil, false
}

// AsEngineBase is the BasicEngineBase implementation for EngineBase.
func (eb EngineBase) AsEngineBase() (*EngineBase, bool) {
	return &eb, true
}

// AsBasicEngineBase is the BasicEngineBase implementation for EngineBase.
func (eb EngineBase) AsBasicEngineBase() (BasicEngineBase, bool) {
	return &eb, true
}

// EngineBaseResource the base backup engine class. All workload specific backup engines derive from this
// class.
type EngineBaseResource struct {
	autorest.Response `json:"-"`
	// Properties - BackupEngineBaseResource properties
	Properties BasicEngineBase `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ETag - Optional ETag.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for EngineBaseResource.
func (ebr EngineBaseResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = ebr.Properties
	if ebr.Location != nil {
		objectMap["location"] = ebr.Location
	}
	if ebr.Tags != nil {
		objectMap["tags"] = ebr.Tags
	}
	if ebr.ETag != nil {
		objectMap["eTag"] = ebr.ETag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EngineBaseResource struct.
func (ebr *EngineBaseResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicEngineBase(*v)
				if err != nil {
					return err
				}
				ebr.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ebr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ebr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ebr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ebr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ebr.Tags = tags
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				ebr.ETag = &eTag
			}
		}
	}

	return nil
}

// EngineBaseResourceList list of BackupEngineBase resources
type EngineBaseResourceList struct {
	autorest.Response `json:"-"`
	// Value - List of resources.
	Value *[]EngineBaseResource `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// EngineBaseResourceListIterator provides access to a complete listing of EngineBaseResource values.
type EngineBaseResourceListIterator struct {
	i    int
	page EngineBaseResourceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EngineBaseResourceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EngineBaseResourceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EngineBaseResourceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EngineBaseResourceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EngineBaseResourceListIterator) Response() EngineBaseResourceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EngineBaseResourceListIterator) Value() EngineBaseResource {
	if !iter.page.NotDone() {
		return EngineBaseResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EngineBaseResourceListIterator type.
func NewEngineBaseResourceListIterator(page EngineBaseResourceListPage) EngineBaseResourceListIterator {
	return EngineBaseResourceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ebrl EngineBaseResourceList) IsEmpty() bool {
	return ebrl.Value == nil || len(*ebrl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ebrl EngineBaseResourceList) hasNextLink() bool {
	return ebrl.NextLink != nil && len(*ebrl.NextLink) != 0
}

// engineBaseResourceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ebrl EngineBaseResourceList) engineBaseResourceListPreparer(ctx context.Context) (*http.Request, error) {
	if !ebrl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ebrl.NextLink)))
}

// EngineBaseResourceListPage contains a page of EngineBaseResource values.
type EngineBaseResourceListPage struct {
	fn   func(context.Context, EngineBaseResourceList) (EngineBaseResourceList, error)
	ebrl EngineBaseResourceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EngineBaseResourceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EngineBaseResourceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ebrl)
		if err != nil {
			return err
		}
		page.ebrl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EngineBaseResourceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EngineBaseResourceListPage) NotDone() bool {
	return !page.ebrl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EngineBaseResourceListPage) Response() EngineBaseResourceList {
	return page.ebrl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EngineBaseResourceListPage) Values() []EngineBaseResource {
	if page.ebrl.IsEmpty() {
		return nil
	}
	return *page.ebrl.Value
}

// Creates a new instance of the EngineBaseResourceListPage type.
func NewEngineBaseResourceListPage(cur EngineBaseResourceList, getNextPage func(context.Context, EngineBaseResourceList) (EngineBaseResourceList, error)) EngineBaseResourceListPage {
	return EngineBaseResourceListPage{
		fn:   getNextPage,
		ebrl: cur,
	}
}

// EngineExtendedInfo additional information on backup engine.
type EngineExtendedInfo struct {
	// DatabaseName - Database name of backup engine.
	DatabaseName *string `json:"databaseName,omitempty"`
	// ProtectedItemsCount - Number of protected items in the backup engine.
	ProtectedItemsCount *int32 `json:"protectedItemsCount,omitempty"`
	// ProtectedServersCount - Number of protected servers in the backup engine.
	ProtectedServersCount *int32 `json:"protectedServersCount,omitempty"`
	// DiskCount - Number of disks in the backup engine.
	DiskCount *int32 `json:"diskCount,omitempty"`
	// UsedDiskSpace - Disk space used in the backup engine.
	UsedDiskSpace *float64 `json:"usedDiskSpace,omitempty"`
	// AvailableDiskSpace - Disk space currently available in the backup engine.
	AvailableDiskSpace *float64 `json:"availableDiskSpace,omitempty"`
	// RefreshedAt - Last refresh time in the backup engine.
	RefreshedAt *date.Time `json:"refreshedAt,omitempty"`
	// AzureProtectedInstances - Protected instances in the backup engine.
	AzureProtectedInstances *int32 `json:"azureProtectedInstances,omitempty"`
}

// ErrorDetail error Detail class which encapsulates Code, Message and Recommendations.
type ErrorDetail struct {
	// Code - READ-ONLY; Error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; Error Message related to the Code.
	Message *string `json:"message,omitempty"`
	// Recommendations - READ-ONLY; List of recommendation strings.
	Recommendations *[]string `json:"recommendations,omitempty"`
}

// GenericContainer base class for generic container of backup items
type GenericContainer struct {
	// FabricName - Name of the container's fabric
	FabricName *string `json:"fabricName,omitempty"`
	// ExtendedInformation - Extended information (not returned in List container API calls)
	ExtendedInformation *GenericContainerExtendedInfo `json:"extendedInformation,omitempty"`
	// FriendlyName - Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - Type of backup management for the container. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// RegistrationStatus - Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
	// HealthStatus - Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// ContainerType - Possible values include: 'ContainerTypeProtectionContainer', 'ContainerTypeAzureBackupServerContainer1', 'ContainerTypeMicrosoftClassicComputevirtualMachines', 'ContainerTypeMicrosoftComputevirtualMachines', 'ContainerTypeSQLAGWorkLoadContainer1', 'ContainerTypeAzureSQLContainer1', 'ContainerTypeStorageContainer1', 'ContainerTypeVMAppContainer1', 'ContainerTypeAzureWorkloadContainer', 'ContainerTypeDPMContainer1', 'ContainerTypeGenericContainer1', 'ContainerTypeIaaSVMContainer', 'ContainerTypeWindows1'
	ContainerType ContainerTypeBasicProtectionContainer `json:"containerType,omitempty"`
}

// MarshalJSON is the custom marshaler for GenericContainer.
func (gc GenericContainer) MarshalJSON() ([]byte, error) {
	gc.ContainerType = ContainerTypeGenericContainer1
	objectMap := make(map[string]interface{})
	if gc.FabricName != nil {
		objectMap["fabricName"] = gc.FabricName
	}
	if gc.ExtendedInformation != nil {
		objectMap["extendedInformation"] = gc.ExtendedInformation
	}
	if gc.FriendlyName != nil {
		objectMap["friendlyName"] = gc.FriendlyName
	}
	if gc.BackupManagementType != "" {
		objectMap["backupManagementType"] = gc.BackupManagementType
	}
	if gc.RegistrationStatus != nil {
		objectMap["registrationStatus"] = gc.RegistrationStatus
	}
	if gc.HealthStatus != nil {
		objectMap["healthStatus"] = gc.HealthStatus
	}
	if gc.ContainerType != "" {
		objectMap["containerType"] = gc.ContainerType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupServerContainer is the BasicProtectionContainer implementation for GenericContainer.
func (gc GenericContainer) AsAzureBackupServerContainer() (*AzureBackupServerContainer, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMContainer is the BasicProtectionContainer implementation for GenericContainer.
func (gc GenericContainer) AsAzureIaaSClassicComputeVMContainer() (*AzureIaaSClassicComputeVMContainer, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMContainer is the BasicProtectionContainer implementation for GenericContainer.
func (gc GenericContainer) AsAzureIaaSComputeVMContainer() (*AzureIaaSComputeVMContainer, bool) {
	return nil, false
}

// AsAzureSQLAGWorkloadContainerProtectionContainer is the BasicProtectionContainer implementation for GenericContainer.
func (gc GenericContainer) AsAzureSQLAGWorkloadContainerProtectionContainer() (*AzureSQLAGWorkloadContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureSQLContainer is the BasicProtectionContainer implementation for GenericContainer.
func (gc GenericContainer) AsAzureSQLContainer() (*AzureSQLContainer, bool) {
	return nil, false
}

// AsAzureStorageContainer is the BasicProtectionContainer implementation for GenericContainer.
func (gc GenericContainer) AsAzureStorageContainer() (*AzureStorageContainer, bool) {
	return nil, false
}

// AsAzureVMAppContainerProtectionContainer is the BasicProtectionContainer implementation for GenericContainer.
func (gc GenericContainer) AsAzureVMAppContainerProtectionContainer() (*AzureVMAppContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureWorkloadContainer is the BasicProtectionContainer implementation for GenericContainer.
func (gc GenericContainer) AsAzureWorkloadContainer() (*AzureWorkloadContainer, bool) {
	return nil, false
}

// AsBasicAzureWorkloadContainer is the BasicProtectionContainer implementation for GenericContainer.
func (gc GenericContainer) AsBasicAzureWorkloadContainer() (BasicAzureWorkloadContainer, bool) {
	return nil, false
}

// AsDpmContainer is the BasicProtectionContainer implementation for GenericContainer.
func (gc GenericContainer) AsDpmContainer() (*DpmContainer, bool) {
	return nil, false
}

// AsBasicDpmContainer is the BasicProtectionContainer implementation for GenericContainer.
func (gc GenericContainer) AsBasicDpmContainer() (BasicDpmContainer, bool) {
	return nil, false
}

// AsGenericContainer is the BasicProtectionContainer implementation for GenericContainer.
func (gc GenericContainer) AsGenericContainer() (*GenericContainer, bool) {
	return &gc, true
}

// AsIaaSVMContainer is the BasicProtectionContainer implementation for GenericContainer.
func (gc GenericContainer) AsIaaSVMContainer() (*IaaSVMContainer, bool) {
	return nil, false
}

// AsBasicIaaSVMContainer is the BasicProtectionContainer implementation for GenericContainer.
func (gc GenericContainer) AsBasicIaaSVMContainer() (BasicIaaSVMContainer, bool) {
	return nil, false
}

// AsMabContainer is the BasicProtectionContainer implementation for GenericContainer.
func (gc GenericContainer) AsMabContainer() (*MabContainer, bool) {
	return nil, false
}

// AsProtectionContainer is the BasicProtectionContainer implementation for GenericContainer.
func (gc GenericContainer) AsProtectionContainer() (*ProtectionContainer, bool) {
	return nil, false
}

// AsBasicProtectionContainer is the BasicProtectionContainer implementation for GenericContainer.
func (gc GenericContainer) AsBasicProtectionContainer() (BasicProtectionContainer, bool) {
	return &gc, true
}

// GenericContainerExtendedInfo container extended information
type GenericContainerExtendedInfo struct {
	// RawCertData - Public key of container cert
	RawCertData *string `json:"rawCertData,omitempty"`
	// ContainerIdentityInfo - Container identity information
	ContainerIdentityInfo *ContainerIdentityInfo `json:"containerIdentityInfo,omitempty"`
	// ServiceEndpoints - Azure Backup Service Endpoints for the container
	ServiceEndpoints map[string]*string `json:"serviceEndpoints"`
}

// MarshalJSON is the custom marshaler for GenericContainerExtendedInfo.
func (gcei GenericContainerExtendedInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gcei.RawCertData != nil {
		objectMap["rawCertData"] = gcei.RawCertData
	}
	if gcei.ContainerIdentityInfo != nil {
		objectMap["containerIdentityInfo"] = gcei.ContainerIdentityInfo
	}
	if gcei.ServiceEndpoints != nil {
		objectMap["serviceEndpoints"] = gcei.ServiceEndpoints
	}
	return json.Marshal(objectMap)
}

// IaasVMBackupRequest iaaS VM workload-specific backup request.
type IaasVMBackupRequest struct {
	// RecoveryPointExpiryTimeInUTC - Backup copy will expire after the time specified (UTC).
	RecoveryPointExpiryTimeInUTC *date.Time `json:"recoveryPointExpiryTimeInUTC,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeBackupRequest', 'ObjectTypeAzureFileShareBackupRequest', 'ObjectTypeAzureWorkloadBackupRequest', 'ObjectTypeIaasVMBackupRequest'
	ObjectType ObjectType `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for IaasVMBackupRequest.
func (ivbr IaasVMBackupRequest) MarshalJSON() ([]byte, error) {
	ivbr.ObjectType = ObjectTypeIaasVMBackupRequest
	objectMap := make(map[string]interface{})
	if ivbr.RecoveryPointExpiryTimeInUTC != nil {
		objectMap["recoveryPointExpiryTimeInUTC"] = ivbr.RecoveryPointExpiryTimeInUTC
	}
	if ivbr.ObjectType != "" {
		objectMap["objectType"] = ivbr.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareBackupRequest is the BasicRequest implementation for IaasVMBackupRequest.
func (ivbr IaasVMBackupRequest) AsAzureFileShareBackupRequest() (*AzureFileShareBackupRequest, bool) {
	return nil, false
}

// AsAzureWorkloadBackupRequest is the BasicRequest implementation for IaasVMBackupRequest.
func (ivbr IaasVMBackupRequest) AsAzureWorkloadBackupRequest() (*AzureWorkloadBackupRequest, bool) {
	return nil, false
}

// AsIaasVMBackupRequest is the BasicRequest implementation for IaasVMBackupRequest.
func (ivbr IaasVMBackupRequest) AsIaasVMBackupRequest() (*IaasVMBackupRequest, bool) {
	return &ivbr, true
}

// AsRequest is the BasicRequest implementation for IaasVMBackupRequest.
func (ivbr IaasVMBackupRequest) AsRequest() (*Request, bool) {
	return nil, false
}

// AsBasicRequest is the BasicRequest implementation for IaasVMBackupRequest.
func (ivbr IaasVMBackupRequest) AsBasicRequest() (BasicRequest, bool) {
	return &ivbr, true
}

// BasicIaaSVMContainer iaaS VM workload-specific container.
type BasicIaaSVMContainer interface {
	AsAzureIaaSClassicComputeVMContainer() (*AzureIaaSClassicComputeVMContainer, bool)
	AsAzureIaaSComputeVMContainer() (*AzureIaaSComputeVMContainer, bool)
	AsIaaSVMContainer() (*IaaSVMContainer, bool)
}

// IaaSVMContainer iaaS VM workload-specific container.
type IaaSVMContainer struct {
	// VirtualMachineID - Fully qualified ARM url of the virtual machine represented by this Azure IaaS VM container.
	VirtualMachineID *string `json:"virtualMachineId,omitempty"`
	// VirtualMachineVersion - Specifies whether the container represents a Classic or an Azure Resource Manager VM.
	VirtualMachineVersion *string `json:"virtualMachineVersion,omitempty"`
	// ResourceGroup - Resource group name of Recovery Services Vault.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// FriendlyName - Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - Type of backup management for the container. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// RegistrationStatus - Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
	// HealthStatus - Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// ContainerType - Possible values include: 'ContainerTypeProtectionContainer', 'ContainerTypeAzureBackupServerContainer1', 'ContainerTypeMicrosoftClassicComputevirtualMachines', 'ContainerTypeMicrosoftComputevirtualMachines', 'ContainerTypeSQLAGWorkLoadContainer1', 'ContainerTypeAzureSQLContainer1', 'ContainerTypeStorageContainer1', 'ContainerTypeVMAppContainer1', 'ContainerTypeAzureWorkloadContainer', 'ContainerTypeDPMContainer1', 'ContainerTypeGenericContainer1', 'ContainerTypeIaaSVMContainer', 'ContainerTypeWindows1'
	ContainerType ContainerTypeBasicProtectionContainer `json:"containerType,omitempty"`
}

func unmarshalBasicIaaSVMContainer(body []byte) (BasicIaaSVMContainer, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["containerType"] {
	case string(ContainerTypeMicrosoftClassicComputevirtualMachines):
		var aisccvc AzureIaaSClassicComputeVMContainer
		err := json.Unmarshal(body, &aisccvc)
		return aisccvc, err
	case string(ContainerTypeMicrosoftComputevirtualMachines):
		var aiscvc AzureIaaSComputeVMContainer
		err := json.Unmarshal(body, &aiscvc)
		return aiscvc, err
	default:
		var isc IaaSVMContainer
		err := json.Unmarshal(body, &isc)
		return isc, err
	}
}
func unmarshalBasicIaaSVMContainerArray(body []byte) ([]BasicIaaSVMContainer, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	iscArray := make([]BasicIaaSVMContainer, len(rawMessages))

	for index, rawMessage := range rawMessages {
		isc, err := unmarshalBasicIaaSVMContainer(*rawMessage)
		if err != nil {
			return nil, err
		}
		iscArray[index] = isc
	}
	return iscArray, nil
}

// MarshalJSON is the custom marshaler for IaaSVMContainer.
func (isc IaaSVMContainer) MarshalJSON() ([]byte, error) {
	isc.ContainerType = ContainerTypeIaaSVMContainer
	objectMap := make(map[string]interface{})
	if isc.VirtualMachineID != nil {
		objectMap["virtualMachineId"] = isc.VirtualMachineID
	}
	if isc.VirtualMachineVersion != nil {
		objectMap["virtualMachineVersion"] = isc.VirtualMachineVersion
	}
	if isc.ResourceGroup != nil {
		objectMap["resourceGroup"] = isc.ResourceGroup
	}
	if isc.FriendlyName != nil {
		objectMap["friendlyName"] = isc.FriendlyName
	}
	if isc.BackupManagementType != "" {
		objectMap["backupManagementType"] = isc.BackupManagementType
	}
	if isc.RegistrationStatus != nil {
		objectMap["registrationStatus"] = isc.RegistrationStatus
	}
	if isc.HealthStatus != nil {
		objectMap["healthStatus"] = isc.HealthStatus
	}
	if isc.ContainerType != "" {
		objectMap["containerType"] = isc.ContainerType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupServerContainer is the BasicProtectionContainer implementation for IaaSVMContainer.
func (isc IaaSVMContainer) AsAzureBackupServerContainer() (*AzureBackupServerContainer, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMContainer is the BasicProtectionContainer implementation for IaaSVMContainer.
func (isc IaaSVMContainer) AsAzureIaaSClassicComputeVMContainer() (*AzureIaaSClassicComputeVMContainer, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMContainer is the BasicProtectionContainer implementation for IaaSVMContainer.
func (isc IaaSVMContainer) AsAzureIaaSComputeVMContainer() (*AzureIaaSComputeVMContainer, bool) {
	return nil, false
}

// AsAzureSQLAGWorkloadContainerProtectionContainer is the BasicProtectionContainer implementation for IaaSVMContainer.
func (isc IaaSVMContainer) AsAzureSQLAGWorkloadContainerProtectionContainer() (*AzureSQLAGWorkloadContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureSQLContainer is the BasicProtectionContainer implementation for IaaSVMContainer.
func (isc IaaSVMContainer) AsAzureSQLContainer() (*AzureSQLContainer, bool) {
	return nil, false
}

// AsAzureStorageContainer is the BasicProtectionContainer implementation for IaaSVMContainer.
func (isc IaaSVMContainer) AsAzureStorageContainer() (*AzureStorageContainer, bool) {
	return nil, false
}

// AsAzureVMAppContainerProtectionContainer is the BasicProtectionContainer implementation for IaaSVMContainer.
func (isc IaaSVMContainer) AsAzureVMAppContainerProtectionContainer() (*AzureVMAppContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureWorkloadContainer is the BasicProtectionContainer implementation for IaaSVMContainer.
func (isc IaaSVMContainer) AsAzureWorkloadContainer() (*AzureWorkloadContainer, bool) {
	return nil, false
}

// AsBasicAzureWorkloadContainer is the BasicProtectionContainer implementation for IaaSVMContainer.
func (isc IaaSVMContainer) AsBasicAzureWorkloadContainer() (BasicAzureWorkloadContainer, bool) {
	return nil, false
}

// AsDpmContainer is the BasicProtectionContainer implementation for IaaSVMContainer.
func (isc IaaSVMContainer) AsDpmContainer() (*DpmContainer, bool) {
	return nil, false
}

// AsBasicDpmContainer is the BasicProtectionContainer implementation for IaaSVMContainer.
func (isc IaaSVMContainer) AsBasicDpmContainer() (BasicDpmContainer, bool) {
	return nil, false
}

// AsGenericContainer is the BasicProtectionContainer implementation for IaaSVMContainer.
func (isc IaaSVMContainer) AsGenericContainer() (*GenericContainer, bool) {
	return nil, false
}

// AsIaaSVMContainer is the BasicProtectionContainer implementation for IaaSVMContainer.
func (isc IaaSVMContainer) AsIaaSVMContainer() (*IaaSVMContainer, bool) {
	return &isc, true
}

// AsBasicIaaSVMContainer is the BasicProtectionContainer implementation for IaaSVMContainer.
func (isc IaaSVMContainer) AsBasicIaaSVMContainer() (BasicIaaSVMContainer, bool) {
	return &isc, true
}

// AsMabContainer is the BasicProtectionContainer implementation for IaaSVMContainer.
func (isc IaaSVMContainer) AsMabContainer() (*MabContainer, bool) {
	return nil, false
}

// AsProtectionContainer is the BasicProtectionContainer implementation for IaaSVMContainer.
func (isc IaaSVMContainer) AsProtectionContainer() (*ProtectionContainer, bool) {
	return nil, false
}

// AsBasicProtectionContainer is the BasicProtectionContainer implementation for IaaSVMContainer.
func (isc IaaSVMContainer) AsBasicProtectionContainer() (BasicProtectionContainer, bool) {
	return &isc, true
}

// IaasVMILRRegistrationRequest restore files/folders from a backup copy of IaaS VM.
type IaasVMILRRegistrationRequest struct {
	// RecoveryPointID - ID of the IaaS VM backup copy from where the files/folders have to be restored.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`
	// VirtualMachineID - Fully qualified ARM ID of the virtual machine whose the files / folders have to be restored.
	VirtualMachineID *string `json:"virtualMachineId,omitempty"`
	// InitiatorName - iSCSI initiator name.
	InitiatorName *string `json:"initiatorName,omitempty"`
	// RenewExistingRegistration - Whether to renew existing registration with the iSCSI server.
	RenewExistingRegistration *bool `json:"renewExistingRegistration,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeILRRequest', 'ObjectTypeAzureFileShareProvisionILRRequest', 'ObjectTypeIaasVMILRRegistrationRequest'
	ObjectType ObjectTypeBasicILRRequest `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for IaasVMILRRegistrationRequest.
func (ivrr IaasVMILRRegistrationRequest) MarshalJSON() ([]byte, error) {
	ivrr.ObjectType = ObjectTypeIaasVMILRRegistrationRequest
	objectMap := make(map[string]interface{})
	if ivrr.RecoveryPointID != nil {
		objectMap["recoveryPointId"] = ivrr.RecoveryPointID
	}
	if ivrr.VirtualMachineID != nil {
		objectMap["virtualMachineId"] = ivrr.VirtualMachineID
	}
	if ivrr.InitiatorName != nil {
		objectMap["initiatorName"] = ivrr.InitiatorName
	}
	if ivrr.RenewExistingRegistration != nil {
		objectMap["renewExistingRegistration"] = ivrr.RenewExistingRegistration
	}
	if ivrr.ObjectType != "" {
		objectMap["objectType"] = ivrr.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareProvisionILRRequest is the BasicILRRequest implementation for IaasVMILRRegistrationRequest.
func (ivrr IaasVMILRRegistrationRequest) AsAzureFileShareProvisionILRRequest() (*AzureFileShareProvisionILRRequest, bool) {
	return nil, false
}

// AsIaasVMILRRegistrationRequest is the BasicILRRequest implementation for IaasVMILRRegistrationRequest.
func (ivrr IaasVMILRRegistrationRequest) AsIaasVMILRRegistrationRequest() (*IaasVMILRRegistrationRequest, bool) {
	return &ivrr, true
}

// AsILRRequest is the BasicILRRequest implementation for IaasVMILRRegistrationRequest.
func (ivrr IaasVMILRRegistrationRequest) AsILRRequest() (*ILRRequest, bool) {
	return nil, false
}

// AsBasicILRRequest is the BasicILRRequest implementation for IaasVMILRRegistrationRequest.
func (ivrr IaasVMILRRegistrationRequest) AsBasicILRRequest() (BasicILRRequest, bool) {
	return &ivrr, true
}

// BasicIaaSVMProtectableItem iaaS VM workload-specific backup item.
type BasicIaaSVMProtectableItem interface {
	AsAzureIaaSClassicComputeVMProtectableItem() (*AzureIaaSClassicComputeVMProtectableItem, bool)
	AsAzureIaaSComputeVMProtectableItem() (*AzureIaaSComputeVMProtectableItem, bool)
	AsIaaSVMProtectableItem() (*IaaSVMProtectableItem, bool)
}

// IaaSVMProtectableItem iaaS VM workload-specific backup item.
type IaaSVMProtectableItem struct {
	// VirtualMachineID - Fully qualified ARM ID of the virtual machine.
	VirtualMachineID *string `json:"virtualMachineId,omitempty"`
	// BackupManagementType - Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
	// FriendlyName - Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionState - State of the back up item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// ProtectableItemType - Possible values include: 'ProtectableItemTypeWorkloadProtectableItem', 'ProtectableItemTypeAzureFileShare', 'ProtectableItemTypeMicrosoftClassicComputevirtualMachines', 'ProtectableItemTypeMicrosoftComputevirtualMachines', 'ProtectableItemTypeAzureVMWorkloadProtectableItem', 'ProtectableItemTypeSAPAseSystem', 'ProtectableItemTypeSAPHanaDatabase', 'ProtectableItemTypeSAPHanaSystem', 'ProtectableItemTypeSQLAvailabilityGroupContainer', 'ProtectableItemTypeSQLDataBase', 'ProtectableItemTypeSQLInstance', 'ProtectableItemTypeIaaSVMProtectableItem'
	ProtectableItemType ProtectableItemType `json:"protectableItemType,omitempty"`
}

func unmarshalBasicIaaSVMProtectableItem(body []byte) (BasicIaaSVMProtectableItem, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["protectableItemType"] {
	case string(ProtectableItemTypeMicrosoftClassicComputevirtualMachines):
		var aisccvpi AzureIaaSClassicComputeVMProtectableItem
		err := json.Unmarshal(body, &aisccvpi)
		return aisccvpi, err
	case string(ProtectableItemTypeMicrosoftComputevirtualMachines):
		var aiscvpi AzureIaaSComputeVMProtectableItem
		err := json.Unmarshal(body, &aiscvpi)
		return aiscvpi, err
	default:
		var ispi IaaSVMProtectableItem
		err := json.Unmarshal(body, &ispi)
		return ispi, err
	}
}
func unmarshalBasicIaaSVMProtectableItemArray(body []byte) ([]BasicIaaSVMProtectableItem, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ispiArray := make([]BasicIaaSVMProtectableItem, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ispi, err := unmarshalBasicIaaSVMProtectableItem(*rawMessage)
		if err != nil {
			return nil, err
		}
		ispiArray[index] = ispi
	}
	return ispiArray, nil
}

// MarshalJSON is the custom marshaler for IaaSVMProtectableItem.
func (ispi IaaSVMProtectableItem) MarshalJSON() ([]byte, error) {
	ispi.ProtectableItemType = ProtectableItemTypeIaaSVMProtectableItem
	objectMap := make(map[string]interface{})
	if ispi.VirtualMachineID != nil {
		objectMap["virtualMachineId"] = ispi.VirtualMachineID
	}
	if ispi.BackupManagementType != nil {
		objectMap["backupManagementType"] = ispi.BackupManagementType
	}
	if ispi.WorkloadType != nil {
		objectMap["workloadType"] = ispi.WorkloadType
	}
	if ispi.FriendlyName != nil {
		objectMap["friendlyName"] = ispi.FriendlyName
	}
	if ispi.ProtectionState != "" {
		objectMap["protectionState"] = ispi.ProtectionState
	}
	if ispi.ProtectableItemType != "" {
		objectMap["protectableItemType"] = ispi.ProtectableItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareProtectableItem is the BasicWorkloadProtectableItem implementation for IaaSVMProtectableItem.
func (ispi IaaSVMProtectableItem) AsAzureFileShareProtectableItem() (*AzureFileShareProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for IaaSVMProtectableItem.
func (ispi IaaSVMProtectableItem) AsAzureIaaSClassicComputeVMProtectableItem() (*AzureIaaSClassicComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for IaaSVMProtectableItem.
func (ispi IaaSVMProtectableItem) AsAzureIaaSComputeVMProtectableItem() (*AzureIaaSComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for IaaSVMProtectableItem.
func (ispi IaaSVMProtectableItem) AsAzureVMWorkloadProtectableItem() (*AzureVMWorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for IaaSVMProtectableItem.
func (ispi IaaSVMProtectableItem) AsBasicAzureVMWorkloadProtectableItem() (BasicAzureVMWorkloadProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPAseSystemProtectableItem is the BasicWorkloadProtectableItem implementation for IaaSVMProtectableItem.
func (ispi IaaSVMProtectableItem) AsAzureVMWorkloadSAPAseSystemProtectableItem() (*AzureVMWorkloadSAPAseSystemProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for IaaSVMProtectableItem.
func (ispi IaaSVMProtectableItem) AsAzureVMWorkloadSAPHanaDatabaseProtectableItem() (*AzureVMWorkloadSAPHanaDatabaseProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaSystemProtectableItem is the BasicWorkloadProtectableItem implementation for IaaSVMProtectableItem.
func (ispi IaaSVMProtectableItem) AsAzureVMWorkloadSAPHanaSystemProtectableItem() (*AzureVMWorkloadSAPHanaSystemProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem is the BasicWorkloadProtectableItem implementation for IaaSVMProtectableItem.
func (ispi IaaSVMProtectableItem) AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem() (*AzureVMWorkloadSQLAvailabilityGroupProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for IaaSVMProtectableItem.
func (ispi IaaSVMProtectableItem) AsAzureVMWorkloadSQLDatabaseProtectableItem() (*AzureVMWorkloadSQLDatabaseProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLInstanceProtectableItem is the BasicWorkloadProtectableItem implementation for IaaSVMProtectableItem.
func (ispi IaaSVMProtectableItem) AsAzureVMWorkloadSQLInstanceProtectableItem() (*AzureVMWorkloadSQLInstanceProtectableItem, bool) {
	return nil, false
}

// AsIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for IaaSVMProtectableItem.
func (ispi IaaSVMProtectableItem) AsIaaSVMProtectableItem() (*IaaSVMProtectableItem, bool) {
	return &ispi, true
}

// AsBasicIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for IaaSVMProtectableItem.
func (ispi IaaSVMProtectableItem) AsBasicIaaSVMProtectableItem() (BasicIaaSVMProtectableItem, bool) {
	return &ispi, true
}

// AsWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for IaaSVMProtectableItem.
func (ispi IaaSVMProtectableItem) AsWorkloadProtectableItem() (*WorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for IaaSVMProtectableItem.
func (ispi IaaSVMProtectableItem) AsBasicWorkloadProtectableItem() (BasicWorkloadProtectableItem, bool) {
	return &ispi, true
}

// BasicILRRequest parameters to Provision ILR API.
type BasicILRRequest interface {
	AsAzureFileShareProvisionILRRequest() (*AzureFileShareProvisionILRRequest, bool)
	AsIaasVMILRRegistrationRequest() (*IaasVMILRRegistrationRequest, bool)
	AsILRRequest() (*ILRRequest, bool)
}

// ILRRequest parameters to Provision ILR API.
type ILRRequest struct {
	// ObjectType - Possible values include: 'ObjectTypeILRRequest', 'ObjectTypeAzureFileShareProvisionILRRequest', 'ObjectTypeIaasVMILRRegistrationRequest'
	ObjectType ObjectTypeBasicILRRequest `json:"objectType,omitempty"`
}

func unmarshalBasicILRRequest(body []byte) (BasicILRRequest, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["objectType"] {
	case string(ObjectTypeAzureFileShareProvisionILRRequest):
		var afspir AzureFileShareProvisionILRRequest
		err := json.Unmarshal(body, &afspir)
		return afspir, err
	case string(ObjectTypeIaasVMILRRegistrationRequest):
		var ivrr IaasVMILRRegistrationRequest
		err := json.Unmarshal(body, &ivrr)
		return ivrr, err
	default:
		var ir ILRRequest
		err := json.Unmarshal(body, &ir)
		return ir, err
	}
}
func unmarshalBasicILRRequestArray(body []byte) ([]BasicILRRequest, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	irArray := make([]BasicILRRequest, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ir, err := unmarshalBasicILRRequest(*rawMessage)
		if err != nil {
			return nil, err
		}
		irArray[index] = ir
	}
	return irArray, nil
}

// MarshalJSON is the custom marshaler for ILRRequest.
func (ir ILRRequest) MarshalJSON() ([]byte, error) {
	ir.ObjectType = ObjectTypeILRRequest
	objectMap := make(map[string]interface{})
	if ir.ObjectType != "" {
		objectMap["objectType"] = ir.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareProvisionILRRequest is the BasicILRRequest implementation for ILRRequest.
func (ir ILRRequest) AsAzureFileShareProvisionILRRequest() (*AzureFileShareProvisionILRRequest, bool) {
	return nil, false
}

// AsIaasVMILRRegistrationRequest is the BasicILRRequest implementation for ILRRequest.
func (ir ILRRequest) AsIaasVMILRRegistrationRequest() (*IaasVMILRRegistrationRequest, bool) {
	return nil, false
}

// AsILRRequest is the BasicILRRequest implementation for ILRRequest.
func (ir ILRRequest) AsILRRequest() (*ILRRequest, bool) {
	return &ir, true
}

// AsBasicILRRequest is the BasicILRRequest implementation for ILRRequest.
func (ir ILRRequest) AsBasicILRRequest() (BasicILRRequest, bool) {
	return &ir, true
}

// ILRRequestResource parameters to Provision ILR API.
type ILRRequestResource struct {
	// Properties - ILRRequestResource properties
	Properties BasicILRRequest `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ETag - Optional ETag.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for ILRRequestResource.
func (irr ILRRequestResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = irr.Properties
	if irr.Location != nil {
		objectMap["location"] = irr.Location
	}
	if irr.Tags != nil {
		objectMap["tags"] = irr.Tags
	}
	if irr.ETag != nil {
		objectMap["eTag"] = irr.ETag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ILRRequestResource struct.
func (irr *ILRRequestResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicILRRequest(*v)
				if err != nil {
					return err
				}
				irr.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				irr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				irr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				irr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				irr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				irr.Tags = tags
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				irr.ETag = &eTag
			}
		}
	}

	return nil
}

// InquiryInfo details about inquired protectable items under a given container.
type InquiryInfo struct {
	// Status - Inquiry Status for this container such as
	// InProgress | Failed | Succeeded
	Status *string `json:"status,omitempty"`
	// ErrorDetail - Error Details if the Status is non-success.
	ErrorDetail *ErrorDetail `json:"errorDetail,omitempty"`
	// InquiryDetails - Inquiry Details which will have workload specific details.
	// For e.g. - For SQL and oracle this will contain different details.
	InquiryDetails *[]WorkloadInquiryDetails `json:"inquiryDetails,omitempty"`
}

// InquiryValidation validation for inquired protectable items under a given container.
type InquiryValidation struct {
	// Status - Status for the Inquiry Validation.
	Status *string `json:"status,omitempty"`
	// ErrorDetail - Error Detail in case the status is non-success.
	ErrorDetail *ErrorDetail `json:"errorDetail,omitempty"`
	// AdditionalDetail - READ-ONLY; Error Additional Detail in case the status is non-success.
	AdditionalDetail *string `json:"additionalDetail,omitempty"`
}

// MarshalJSON is the custom marshaler for InquiryValidation.
func (iv InquiryValidation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if iv.Status != nil {
		objectMap["status"] = iv.Status
	}
	if iv.ErrorDetail != nil {
		objectMap["errorDetail"] = iv.ErrorDetail
	}
	return json.Marshal(objectMap)
}

// InstantItemRecoveryTarget target details for file / folder restore.
type InstantItemRecoveryTarget struct {
	// ClientScripts - List of client scripts.
	ClientScripts *[]ClientScriptForConnect `json:"clientScripts,omitempty"`
}

// MabContainer container with items backed up using MAB backup engine.
type MabContainer struct {
	// CanReRegister - Can the container be registered one more time.
	CanReRegister *bool `json:"canReRegister,omitempty"`
	// ContainerID - ContainerID represents the container.
	ContainerID *int64 `json:"containerId,omitempty"`
	// ProtectedItemCount - Number of items backed up in this container.
	ProtectedItemCount *int64 `json:"protectedItemCount,omitempty"`
	// AgentVersion - Agent version of this container.
	AgentVersion *string `json:"agentVersion,omitempty"`
	// ExtendedInfo - Additional information for this container
	ExtendedInfo *MabContainerExtendedInfo `json:"extendedInfo,omitempty"`
	// MabContainerHealthDetails - Health details on this mab container.
	MabContainerHealthDetails *[]MABContainerHealthDetails `json:"mabContainerHealthDetails,omitempty"`
	// ContainerHealthState - Health state of mab container.
	ContainerHealthState *string `json:"containerHealthState,omitempty"`
	// FriendlyName - Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - Type of backup management for the container. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// RegistrationStatus - Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
	// HealthStatus - Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// ContainerType - Possible values include: 'ContainerTypeProtectionContainer', 'ContainerTypeAzureBackupServerContainer1', 'ContainerTypeMicrosoftClassicComputevirtualMachines', 'ContainerTypeMicrosoftComputevirtualMachines', 'ContainerTypeSQLAGWorkLoadContainer1', 'ContainerTypeAzureSQLContainer1', 'ContainerTypeStorageContainer1', 'ContainerTypeVMAppContainer1', 'ContainerTypeAzureWorkloadContainer', 'ContainerTypeDPMContainer1', 'ContainerTypeGenericContainer1', 'ContainerTypeIaaSVMContainer', 'ContainerTypeWindows1'
	ContainerType ContainerTypeBasicProtectionContainer `json:"containerType,omitempty"`
}

// MarshalJSON is the custom marshaler for MabContainer.
func (mc MabContainer) MarshalJSON() ([]byte, error) {
	mc.ContainerType = ContainerTypeWindows1
	objectMap := make(map[string]interface{})
	if mc.CanReRegister != nil {
		objectMap["canReRegister"] = mc.CanReRegister
	}
	if mc.ContainerID != nil {
		objectMap["containerId"] = mc.ContainerID
	}
	if mc.ProtectedItemCount != nil {
		objectMap["protectedItemCount"] = mc.ProtectedItemCount
	}
	if mc.AgentVersion != nil {
		objectMap["agentVersion"] = mc.AgentVersion
	}
	if mc.ExtendedInfo != nil {
		objectMap["extendedInfo"] = mc.ExtendedInfo
	}
	if mc.MabContainerHealthDetails != nil {
		objectMap["mabContainerHealthDetails"] = mc.MabContainerHealthDetails
	}
	if mc.ContainerHealthState != nil {
		objectMap["containerHealthState"] = mc.ContainerHealthState
	}
	if mc.FriendlyName != nil {
		objectMap["friendlyName"] = mc.FriendlyName
	}
	if mc.BackupManagementType != "" {
		objectMap["backupManagementType"] = mc.BackupManagementType
	}
	if mc.RegistrationStatus != nil {
		objectMap["registrationStatus"] = mc.RegistrationStatus
	}
	if mc.HealthStatus != nil {
		objectMap["healthStatus"] = mc.HealthStatus
	}
	if mc.ContainerType != "" {
		objectMap["containerType"] = mc.ContainerType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupServerContainer is the BasicProtectionContainer implementation for MabContainer.
func (mc MabContainer) AsAzureBackupServerContainer() (*AzureBackupServerContainer, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMContainer is the BasicProtectionContainer implementation for MabContainer.
func (mc MabContainer) AsAzureIaaSClassicComputeVMContainer() (*AzureIaaSClassicComputeVMContainer, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMContainer is the BasicProtectionContainer implementation for MabContainer.
func (mc MabContainer) AsAzureIaaSComputeVMContainer() (*AzureIaaSComputeVMContainer, bool) {
	return nil, false
}

// AsAzureSQLAGWorkloadContainerProtectionContainer is the BasicProtectionContainer implementation for MabContainer.
func (mc MabContainer) AsAzureSQLAGWorkloadContainerProtectionContainer() (*AzureSQLAGWorkloadContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureSQLContainer is the BasicProtectionContainer implementation for MabContainer.
func (mc MabContainer) AsAzureSQLContainer() (*AzureSQLContainer, bool) {
	return nil, false
}

// AsAzureStorageContainer is the BasicProtectionContainer implementation for MabContainer.
func (mc MabContainer) AsAzureStorageContainer() (*AzureStorageContainer, bool) {
	return nil, false
}

// AsAzureVMAppContainerProtectionContainer is the BasicProtectionContainer implementation for MabContainer.
func (mc MabContainer) AsAzureVMAppContainerProtectionContainer() (*AzureVMAppContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureWorkloadContainer is the BasicProtectionContainer implementation for MabContainer.
func (mc MabContainer) AsAzureWorkloadContainer() (*AzureWorkloadContainer, bool) {
	return nil, false
}

// AsBasicAzureWorkloadContainer is the BasicProtectionContainer implementation for MabContainer.
func (mc MabContainer) AsBasicAzureWorkloadContainer() (BasicAzureWorkloadContainer, bool) {
	return nil, false
}

// AsDpmContainer is the BasicProtectionContainer implementation for MabContainer.
func (mc MabContainer) AsDpmContainer() (*DpmContainer, bool) {
	return nil, false
}

// AsBasicDpmContainer is the BasicProtectionContainer implementation for MabContainer.
func (mc MabContainer) AsBasicDpmContainer() (BasicDpmContainer, bool) {
	return nil, false
}

// AsGenericContainer is the BasicProtectionContainer implementation for MabContainer.
func (mc MabContainer) AsGenericContainer() (*GenericContainer, bool) {
	return nil, false
}

// AsIaaSVMContainer is the BasicProtectionContainer implementation for MabContainer.
func (mc MabContainer) AsIaaSVMContainer() (*IaaSVMContainer, bool) {
	return nil, false
}

// AsBasicIaaSVMContainer is the BasicProtectionContainer implementation for MabContainer.
func (mc MabContainer) AsBasicIaaSVMContainer() (BasicIaaSVMContainer, bool) {
	return nil, false
}

// AsMabContainer is the BasicProtectionContainer implementation for MabContainer.
func (mc MabContainer) AsMabContainer() (*MabContainer, bool) {
	return &mc, true
}

// AsProtectionContainer is the BasicProtectionContainer implementation for MabContainer.
func (mc MabContainer) AsProtectionContainer() (*ProtectionContainer, bool) {
	return nil, false
}

// AsBasicProtectionContainer is the BasicProtectionContainer implementation for MabContainer.
func (mc MabContainer) AsBasicProtectionContainer() (BasicProtectionContainer, bool) {
	return &mc, true
}

// MabContainerExtendedInfo additional information of the container.
type MabContainerExtendedInfo struct {
	// LastRefreshedAt - Time stamp when this container was refreshed.
	LastRefreshedAt *date.Time `json:"lastRefreshedAt,omitempty"`
	// BackupItemType - Type of backup items associated with this container. Possible values include: 'ItemTypeInvalid', 'ItemTypeVM', 'ItemTypeFileFolder', 'ItemTypeAzureSQLDb', 'ItemTypeSQLDB', 'ItemTypeExchange', 'ItemTypeSharepoint', 'ItemTypeVMwareVM', 'ItemTypeSystemState', 'ItemTypeClient', 'ItemTypeGenericDataSource', 'ItemTypeSQLDataBase', 'ItemTypeAzureFileShare', 'ItemTypeSAPHanaDatabase', 'ItemTypeSAPAseDatabase'
	BackupItemType ItemType `json:"backupItemType,omitempty"`
	// BackupItems - List of backup items associated with this container.
	BackupItems *[]string `json:"backupItems,omitempty"`
	// PolicyName - Backup policy associated with this container.
	PolicyName *string `json:"policyName,omitempty"`
	// LastBackupStatus - Latest backup status of this container.
	LastBackupStatus *string `json:"lastBackupStatus,omitempty"`
}

// MABContainerHealthDetails MAB workload-specific Health Details.
type MABContainerHealthDetails struct {
	// Code - Health Code
	Code *int32 `json:"code,omitempty"`
	// Title - Health Title
	Title *string `json:"title,omitempty"`
	// Message - Health Message
	Message *string `json:"message,omitempty"`
	// Recommendations - Health Recommended Actions
	Recommendations *[]string `json:"recommendations,omitempty"`
}

// OperationStatus operation status.
type OperationStatus struct {
	autorest.Response `json:"-"`
	// ID - ID of the operation.
	ID *string `json:"id,omitempty"`
	// Name - Name of the operation.
	Name *string `json:"name,omitempty"`
	// Status - Operation status. Possible values include: 'OperationStatusValuesInvalid', 'OperationStatusValuesInProgress', 'OperationStatusValuesSucceeded', 'OperationStatusValuesFailed', 'OperationStatusValuesCanceled'
	Status OperationStatusValues `json:"status,omitempty"`
	// StartTime - Operation start time. Format: ISO-8601.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Operation end time. Format: ISO-8601.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Error - Error information related to this operation.
	Error *OperationStatusError `json:"error,omitempty"`
	// Properties - Additional information associated with this operation.
	Properties BasicOperationStatusExtendedInfo `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for OperationStatus struct.
func (osVar *OperationStatus) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				osVar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				osVar.Name = &name
			}
		case "status":
			if v != nil {
				var status OperationStatusValues
				err = json.Unmarshal(*v, &status)
				if err != nil {
					return err
				}
				osVar.Status = status
			}
		case "startTime":
			if v != nil {
				var startTime date.Time
				err = json.Unmarshal(*v, &startTime)
				if err != nil {
					return err
				}
				osVar.StartTime = &startTime
			}
		case "endTime":
			if v != nil {
				var endTime date.Time
				err = json.Unmarshal(*v, &endTime)
				if err != nil {
					return err
				}
				osVar.EndTime = &endTime
			}
		case "error":
			if v != nil {
				var errorVar OperationStatusError
				err = json.Unmarshal(*v, &errorVar)
				if err != nil {
					return err
				}
				osVar.Error = &errorVar
			}
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicOperationStatusExtendedInfo(*v)
				if err != nil {
					return err
				}
				osVar.Properties = properties
			}
		}
	}

	return nil
}

// OperationStatusError error information associated with operation status call.
type OperationStatusError struct {
	// Code - Error code of the operation failure.
	Code *string `json:"code,omitempty"`
	// Message - Error message displayed if the operation failure.
	Message *string `json:"message,omitempty"`
}

// BasicOperationStatusExtendedInfo base class for additional information of operation status.
type BasicOperationStatusExtendedInfo interface {
	AsOperationStatusJobExtendedInfo() (*OperationStatusJobExtendedInfo, bool)
	AsOperationStatusJobsExtendedInfo() (*OperationStatusJobsExtendedInfo, bool)
	AsOperationStatusProvisionILRExtendedInfo() (*OperationStatusProvisionILRExtendedInfo, bool)
	AsOperationStatusExtendedInfo() (*OperationStatusExtendedInfo, bool)
}

// OperationStatusExtendedInfo base class for additional information of operation status.
type OperationStatusExtendedInfo struct {
	// ObjectType - Possible values include: 'ObjectTypeOperationStatusExtendedInfo', 'ObjectTypeOperationStatusJobExtendedInfo', 'ObjectTypeOperationStatusJobsExtendedInfo', 'ObjectTypeOperationStatusProvisionILRExtendedInfo'
	ObjectType ObjectTypeBasicOperationStatusExtendedInfo `json:"objectType,omitempty"`
}

func unmarshalBasicOperationStatusExtendedInfo(body []byte) (BasicOperationStatusExtendedInfo, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["objectType"] {
	case string(ObjectTypeOperationStatusJobExtendedInfo):
		var osjei OperationStatusJobExtendedInfo
		err := json.Unmarshal(body, &osjei)
		return osjei, err
	case string(ObjectTypeOperationStatusJobsExtendedInfo):
		var osjei OperationStatusJobsExtendedInfo
		err := json.Unmarshal(body, &osjei)
		return osjei, err
	case string(ObjectTypeOperationStatusProvisionILRExtendedInfo):
		var ospiei OperationStatusProvisionILRExtendedInfo
		err := json.Unmarshal(body, &ospiei)
		return ospiei, err
	default:
		var osei OperationStatusExtendedInfo
		err := json.Unmarshal(body, &osei)
		return osei, err
	}
}
func unmarshalBasicOperationStatusExtendedInfoArray(body []byte) ([]BasicOperationStatusExtendedInfo, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	oseiArray := make([]BasicOperationStatusExtendedInfo, len(rawMessages))

	for index, rawMessage := range rawMessages {
		osei, err := unmarshalBasicOperationStatusExtendedInfo(*rawMessage)
		if err != nil {
			return nil, err
		}
		oseiArray[index] = osei
	}
	return oseiArray, nil
}

// MarshalJSON is the custom marshaler for OperationStatusExtendedInfo.
func (osei OperationStatusExtendedInfo) MarshalJSON() ([]byte, error) {
	osei.ObjectType = ObjectTypeOperationStatusExtendedInfo
	objectMap := make(map[string]interface{})
	if osei.ObjectType != "" {
		objectMap["objectType"] = osei.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsOperationStatusJobExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusExtendedInfo.
func (osei OperationStatusExtendedInfo) AsOperationStatusJobExtendedInfo() (*OperationStatusJobExtendedInfo, bool) {
	return nil, false
}

// AsOperationStatusJobsExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusExtendedInfo.
func (osei OperationStatusExtendedInfo) AsOperationStatusJobsExtendedInfo() (*OperationStatusJobsExtendedInfo, bool) {
	return nil, false
}

// AsOperationStatusProvisionILRExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusExtendedInfo.
func (osei OperationStatusExtendedInfo) AsOperationStatusProvisionILRExtendedInfo() (*OperationStatusProvisionILRExtendedInfo, bool) {
	return nil, false
}

// AsOperationStatusExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusExtendedInfo.
func (osei OperationStatusExtendedInfo) AsOperationStatusExtendedInfo() (*OperationStatusExtendedInfo, bool) {
	return &osei, true
}

// AsBasicOperationStatusExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusExtendedInfo.
func (osei OperationStatusExtendedInfo) AsBasicOperationStatusExtendedInfo() (BasicOperationStatusExtendedInfo, bool) {
	return &osei, true
}

// OperationStatusJobExtendedInfo operation status job extended info.
type OperationStatusJobExtendedInfo struct {
	// JobID - ID of the job created for this protected item.
	JobID *string `json:"jobId,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeOperationStatusExtendedInfo', 'ObjectTypeOperationStatusJobExtendedInfo', 'ObjectTypeOperationStatusJobsExtendedInfo', 'ObjectTypeOperationStatusProvisionILRExtendedInfo'
	ObjectType ObjectTypeBasicOperationStatusExtendedInfo `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationStatusJobExtendedInfo.
func (osjei OperationStatusJobExtendedInfo) MarshalJSON() ([]byte, error) {
	osjei.ObjectType = ObjectTypeOperationStatusJobExtendedInfo
	objectMap := make(map[string]interface{})
	if osjei.JobID != nil {
		objectMap["jobId"] = osjei.JobID
	}
	if osjei.ObjectType != "" {
		objectMap["objectType"] = osjei.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsOperationStatusJobExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusJobExtendedInfo.
func (osjei OperationStatusJobExtendedInfo) AsOperationStatusJobExtendedInfo() (*OperationStatusJobExtendedInfo, bool) {
	return &osjei, true
}

// AsOperationStatusJobsExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusJobExtendedInfo.
func (osjei OperationStatusJobExtendedInfo) AsOperationStatusJobsExtendedInfo() (*OperationStatusJobsExtendedInfo, bool) {
	return nil, false
}

// AsOperationStatusProvisionILRExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusJobExtendedInfo.
func (osjei OperationStatusJobExtendedInfo) AsOperationStatusProvisionILRExtendedInfo() (*OperationStatusProvisionILRExtendedInfo, bool) {
	return nil, false
}

// AsOperationStatusExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusJobExtendedInfo.
func (osjei OperationStatusJobExtendedInfo) AsOperationStatusExtendedInfo() (*OperationStatusExtendedInfo, bool) {
	return nil, false
}

// AsBasicOperationStatusExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusJobExtendedInfo.
func (osjei OperationStatusJobExtendedInfo) AsBasicOperationStatusExtendedInfo() (BasicOperationStatusExtendedInfo, bool) {
	return &osjei, true
}

// OperationStatusJobsExtendedInfo operation status extended info for list of jobs.
type OperationStatusJobsExtendedInfo struct {
	// JobIds - IDs of the jobs created for the protected item.
	JobIds *[]string `json:"jobIds,omitempty"`
	// FailedJobsError - Stores all the failed jobs along with the corresponding error codes.
	FailedJobsError map[string]*string `json:"failedJobsError"`
	// ObjectType - Possible values include: 'ObjectTypeOperationStatusExtendedInfo', 'ObjectTypeOperationStatusJobExtendedInfo', 'ObjectTypeOperationStatusJobsExtendedInfo', 'ObjectTypeOperationStatusProvisionILRExtendedInfo'
	ObjectType ObjectTypeBasicOperationStatusExtendedInfo `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationStatusJobsExtendedInfo.
func (osjei OperationStatusJobsExtendedInfo) MarshalJSON() ([]byte, error) {
	osjei.ObjectType = ObjectTypeOperationStatusJobsExtendedInfo
	objectMap := make(map[string]interface{})
	if osjei.JobIds != nil {
		objectMap["jobIds"] = osjei.JobIds
	}
	if osjei.FailedJobsError != nil {
		objectMap["failedJobsError"] = osjei.FailedJobsError
	}
	if osjei.ObjectType != "" {
		objectMap["objectType"] = osjei.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsOperationStatusJobExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusJobsExtendedInfo.
func (osjei OperationStatusJobsExtendedInfo) AsOperationStatusJobExtendedInfo() (*OperationStatusJobExtendedInfo, bool) {
	return nil, false
}

// AsOperationStatusJobsExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusJobsExtendedInfo.
func (osjei OperationStatusJobsExtendedInfo) AsOperationStatusJobsExtendedInfo() (*OperationStatusJobsExtendedInfo, bool) {
	return &osjei, true
}

// AsOperationStatusProvisionILRExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusJobsExtendedInfo.
func (osjei OperationStatusJobsExtendedInfo) AsOperationStatusProvisionILRExtendedInfo() (*OperationStatusProvisionILRExtendedInfo, bool) {
	return nil, false
}

// AsOperationStatusExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusJobsExtendedInfo.
func (osjei OperationStatusJobsExtendedInfo) AsOperationStatusExtendedInfo() (*OperationStatusExtendedInfo, bool) {
	return nil, false
}

// AsBasicOperationStatusExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusJobsExtendedInfo.
func (osjei OperationStatusJobsExtendedInfo) AsBasicOperationStatusExtendedInfo() (BasicOperationStatusExtendedInfo, bool) {
	return &osjei, true
}

// OperationStatusProvisionILRExtendedInfo operation status extended info for ILR provision action.
type OperationStatusProvisionILRExtendedInfo struct {
	// RecoveryTarget - Target details for file / folder restore.
	RecoveryTarget *InstantItemRecoveryTarget `json:"recoveryTarget,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeOperationStatusExtendedInfo', 'ObjectTypeOperationStatusJobExtendedInfo', 'ObjectTypeOperationStatusJobsExtendedInfo', 'ObjectTypeOperationStatusProvisionILRExtendedInfo'
	ObjectType ObjectTypeBasicOperationStatusExtendedInfo `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationStatusProvisionILRExtendedInfo.
func (ospiei OperationStatusProvisionILRExtendedInfo) MarshalJSON() ([]byte, error) {
	ospiei.ObjectType = ObjectTypeOperationStatusProvisionILRExtendedInfo
	objectMap := make(map[string]interface{})
	if ospiei.RecoveryTarget != nil {
		objectMap["recoveryTarget"] = ospiei.RecoveryTarget
	}
	if ospiei.ObjectType != "" {
		objectMap["objectType"] = ospiei.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsOperationStatusJobExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusProvisionILRExtendedInfo.
func (ospiei OperationStatusProvisionILRExtendedInfo) AsOperationStatusJobExtendedInfo() (*OperationStatusJobExtendedInfo, bool) {
	return nil, false
}

// AsOperationStatusJobsExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusProvisionILRExtendedInfo.
func (ospiei OperationStatusProvisionILRExtendedInfo) AsOperationStatusJobsExtendedInfo() (*OperationStatusJobsExtendedInfo, bool) {
	return nil, false
}

// AsOperationStatusProvisionILRExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusProvisionILRExtendedInfo.
func (ospiei OperationStatusProvisionILRExtendedInfo) AsOperationStatusProvisionILRExtendedInfo() (*OperationStatusProvisionILRExtendedInfo, bool) {
	return &ospiei, true
}

// AsOperationStatusExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusProvisionILRExtendedInfo.
func (ospiei OperationStatusProvisionILRExtendedInfo) AsOperationStatusExtendedInfo() (*OperationStatusExtendedInfo, bool) {
	return nil, false
}

// AsBasicOperationStatusExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusProvisionILRExtendedInfo.
func (ospiei OperationStatusProvisionILRExtendedInfo) AsBasicOperationStatusExtendedInfo() (BasicOperationStatusExtendedInfo, bool) {
	return &ospiei, true
}

// PreBackupValidation pre-backup validation for Azure VM Workload provider.
type PreBackupValidation struct {
	// Status - Status of protectable item, i.e. InProgress,Succeeded,Failed. Possible values include: 'InquiryStatusInvalid', 'InquiryStatusSuccess', 'InquiryStatusFailed'
	Status InquiryStatus `json:"status,omitempty"`
	// Code - Error code of protectable item
	Code *string `json:"code,omitempty"`
	// Message - Message corresponding to the error code for the protectable item
	Message *string `json:"message,omitempty"`
}

// BasicProtectableContainer protectable Container Class.
type BasicProtectableContainer interface {
	AsAzureStorageProtectableContainer() (*AzureStorageProtectableContainer, bool)
	AsAzureVMAppContainerProtectableContainer() (*AzureVMAppContainerProtectableContainer, bool)
	AsProtectableContainer() (*ProtectableContainer, bool)
}

// ProtectableContainer protectable Container Class.
type ProtectableContainer struct {
	// FriendlyName - Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - Type of backup management for the container. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// HealthStatus - Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// ContainerID - Fabric Id of the container such as ARM Id.
	ContainerID *string `json:"containerId,omitempty"`
	// ProtectableContainerType - Possible values include: 'ProtectableContainerTypeProtectableContainer', 'ProtectableContainerTypeStorageContainer', 'ProtectableContainerTypeVMAppContainer'
	ProtectableContainerType ProtectableContainerType `json:"protectableContainerType,omitempty"`
}

func unmarshalBasicProtectableContainer(body []byte) (BasicProtectableContainer, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["protectableContainerType"] {
	case string(ProtectableContainerTypeStorageContainer):
		var aspc AzureStorageProtectableContainer
		err := json.Unmarshal(body, &aspc)
		return aspc, err
	case string(ProtectableContainerTypeVMAppContainer):
		var avacpc AzureVMAppContainerProtectableContainer
		err := json.Unmarshal(body, &avacpc)
		return avacpc, err
	default:
		var pc ProtectableContainer
		err := json.Unmarshal(body, &pc)
		return pc, err
	}
}
func unmarshalBasicProtectableContainerArray(body []byte) ([]BasicProtectableContainer, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	pcArray := make([]BasicProtectableContainer, len(rawMessages))

	for index, rawMessage := range rawMessages {
		pc, err := unmarshalBasicProtectableContainer(*rawMessage)
		if err != nil {
			return nil, err
		}
		pcArray[index] = pc
	}
	return pcArray, nil
}

// MarshalJSON is the custom marshaler for ProtectableContainer.
func (pc ProtectableContainer) MarshalJSON() ([]byte, error) {
	pc.ProtectableContainerType = ProtectableContainerTypeProtectableContainer
	objectMap := make(map[string]interface{})
	if pc.FriendlyName != nil {
		objectMap["friendlyName"] = pc.FriendlyName
	}
	if pc.BackupManagementType != "" {
		objectMap["backupManagementType"] = pc.BackupManagementType
	}
	if pc.HealthStatus != nil {
		objectMap["healthStatus"] = pc.HealthStatus
	}
	if pc.ContainerID != nil {
		objectMap["containerId"] = pc.ContainerID
	}
	if pc.ProtectableContainerType != "" {
		objectMap["protectableContainerType"] = pc.ProtectableContainerType
	}
	return json.Marshal(objectMap)
}

// AsAzureStorageProtectableContainer is the BasicProtectableContainer implementation for ProtectableContainer.
func (pc ProtectableContainer) AsAzureStorageProtectableContainer() (*AzureStorageProtectableContainer, bool) {
	return nil, false
}

// AsAzureVMAppContainerProtectableContainer is the BasicProtectableContainer implementation for ProtectableContainer.
func (pc ProtectableContainer) AsAzureVMAppContainerProtectableContainer() (*AzureVMAppContainerProtectableContainer, bool) {
	return nil, false
}

// AsProtectableContainer is the BasicProtectableContainer implementation for ProtectableContainer.
func (pc ProtectableContainer) AsProtectableContainer() (*ProtectableContainer, bool) {
	return &pc, true
}

// AsBasicProtectableContainer is the BasicProtectableContainer implementation for ProtectableContainer.
func (pc ProtectableContainer) AsBasicProtectableContainer() (BasicProtectableContainer, bool) {
	return &pc, true
}

// ProtectableContainerResource protectable Container Class.
type ProtectableContainerResource struct {
	// Properties - ProtectableContainerResource properties
	Properties BasicProtectableContainer `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ETag - Optional ETag.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for ProtectableContainerResource.
func (pcr ProtectableContainerResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = pcr.Properties
	if pcr.Location != nil {
		objectMap["location"] = pcr.Location
	}
	if pcr.Tags != nil {
		objectMap["tags"] = pcr.Tags
	}
	if pcr.ETag != nil {
		objectMap["eTag"] = pcr.ETag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ProtectableContainerResource struct.
func (pcr *ProtectableContainerResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicProtectableContainer(*v)
				if err != nil {
					return err
				}
				pcr.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pcr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pcr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pcr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				pcr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				pcr.Tags = tags
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				pcr.ETag = &eTag
			}
		}
	}

	return nil
}

// ProtectableContainerResourceList list of ProtectableContainer resources
type ProtectableContainerResourceList struct {
	autorest.Response `json:"-"`
	// Value - List of resources.
	Value *[]ProtectableContainerResource `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProtectableContainerResourceListIterator provides access to a complete listing of
// ProtectableContainerResource values.
type ProtectableContainerResourceListIterator struct {
	i    int
	page ProtectableContainerResourceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProtectableContainerResourceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProtectableContainerResourceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProtectableContainerResourceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProtectableContainerResourceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProtectableContainerResourceListIterator) Response() ProtectableContainerResourceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProtectableContainerResourceListIterator) Value() ProtectableContainerResource {
	if !iter.page.NotDone() {
		return ProtectableContainerResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProtectableContainerResourceListIterator type.
func NewProtectableContainerResourceListIterator(page ProtectableContainerResourceListPage) ProtectableContainerResourceListIterator {
	return ProtectableContainerResourceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pcrl ProtectableContainerResourceList) IsEmpty() bool {
	return pcrl.Value == nil || len(*pcrl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pcrl ProtectableContainerResourceList) hasNextLink() bool {
	return pcrl.NextLink != nil && len(*pcrl.NextLink) != 0
}

// protectableContainerResourceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pcrl ProtectableContainerResourceList) protectableContainerResourceListPreparer(ctx context.Context) (*http.Request, error) {
	if !pcrl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pcrl.NextLink)))
}

// ProtectableContainerResourceListPage contains a page of ProtectableContainerResource values.
type ProtectableContainerResourceListPage struct {
	fn   func(context.Context, ProtectableContainerResourceList) (ProtectableContainerResourceList, error)
	pcrl ProtectableContainerResourceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProtectableContainerResourceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProtectableContainerResourceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pcrl)
		if err != nil {
			return err
		}
		page.pcrl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProtectableContainerResourceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProtectableContainerResourceListPage) NotDone() bool {
	return !page.pcrl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProtectableContainerResourceListPage) Response() ProtectableContainerResourceList {
	return page.pcrl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProtectableContainerResourceListPage) Values() []ProtectableContainerResource {
	if page.pcrl.IsEmpty() {
		return nil
	}
	return *page.pcrl.Value
}

// Creates a new instance of the ProtectableContainerResourceListPage type.
func NewProtectableContainerResourceListPage(cur ProtectableContainerResourceList, getNextPage func(context.Context, ProtectableContainerResourceList) (ProtectableContainerResourceList, error)) ProtectableContainerResourceListPage {
	return ProtectableContainerResourceListPage{
		fn:   getNextPage,
		pcrl: cur,
	}
}

// BasicProtectionContainer base class for container with backup items. Containers with specific workloads are derived
// from this class.
type BasicProtectionContainer interface {
	AsAzureBackupServerContainer() (*AzureBackupServerContainer, bool)
	AsAzureIaaSClassicComputeVMContainer() (*AzureIaaSClassicComputeVMContainer, bool)
	AsAzureIaaSComputeVMContainer() (*AzureIaaSComputeVMContainer, bool)
	AsAzureSQLAGWorkloadContainerProtectionContainer() (*AzureSQLAGWorkloadContainerProtectionContainer, bool)
	AsAzureSQLContainer() (*AzureSQLContainer, bool)
	AsAzureStorageContainer() (*AzureStorageContainer, bool)
	AsAzureVMAppContainerProtectionContainer() (*AzureVMAppContainerProtectionContainer, bool)
	AsAzureWorkloadContainer() (*AzureWorkloadContainer, bool)
	AsBasicAzureWorkloadContainer() (BasicAzureWorkloadContainer, bool)
	AsDpmContainer() (*DpmContainer, bool)
	AsBasicDpmContainer() (BasicDpmContainer, bool)
	AsGenericContainer() (*GenericContainer, bool)
	AsIaaSVMContainer() (*IaaSVMContainer, bool)
	AsBasicIaaSVMContainer() (BasicIaaSVMContainer, bool)
	AsMabContainer() (*MabContainer, bool)
	AsProtectionContainer() (*ProtectionContainer, bool)
}

// ProtectionContainer base class for container with backup items. Containers with specific workloads are
// derived from this class.
type ProtectionContainer struct {
	// FriendlyName - Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - Type of backup management for the container. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// RegistrationStatus - Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
	// HealthStatus - Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// ContainerType - Possible values include: 'ContainerTypeProtectionContainer', 'ContainerTypeAzureBackupServerContainer1', 'ContainerTypeMicrosoftClassicComputevirtualMachines', 'ContainerTypeMicrosoftComputevirtualMachines', 'ContainerTypeSQLAGWorkLoadContainer1', 'ContainerTypeAzureSQLContainer1', 'ContainerTypeStorageContainer1', 'ContainerTypeVMAppContainer1', 'ContainerTypeAzureWorkloadContainer', 'ContainerTypeDPMContainer1', 'ContainerTypeGenericContainer1', 'ContainerTypeIaaSVMContainer', 'ContainerTypeWindows1'
	ContainerType ContainerTypeBasicProtectionContainer `json:"containerType,omitempty"`
}

func unmarshalBasicProtectionContainer(body []byte) (BasicProtectionContainer, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["containerType"] {
	case string(ContainerTypeAzureBackupServerContainer1):
		var absc AzureBackupServerContainer
		err := json.Unmarshal(body, &absc)
		return absc, err
	case string(ContainerTypeMicrosoftClassicComputevirtualMachines):
		var aisccvc AzureIaaSClassicComputeVMContainer
		err := json.Unmarshal(body, &aisccvc)
		return aisccvc, err
	case string(ContainerTypeMicrosoftComputevirtualMachines):
		var aiscvc AzureIaaSComputeVMContainer
		err := json.Unmarshal(body, &aiscvc)
		return aiscvc, err
	case string(ContainerTypeSQLAGWorkLoadContainer1):
		var aswcpc AzureSQLAGWorkloadContainerProtectionContainer
		err := json.Unmarshal(body, &aswcpc)
		return aswcpc, err
	case string(ContainerTypeAzureSQLContainer1):
		var asc AzureSQLContainer
		err := json.Unmarshal(body, &asc)
		return asc, err
	case string(ContainerTypeStorageContainer1):
		var asc AzureStorageContainer
		err := json.Unmarshal(body, &asc)
		return asc, err
	case string(ContainerTypeVMAppContainer1):
		var avacpc AzureVMAppContainerProtectionContainer
		err := json.Unmarshal(body, &avacpc)
		return avacpc, err
	case string(ContainerTypeAzureWorkloadContainer):
		var awc AzureWorkloadContainer
		err := json.Unmarshal(body, &awc)
		return awc, err
	case string(ContainerTypeDPMContainer1):
		var dc DpmContainer
		err := json.Unmarshal(body, &dc)
		return dc, err
	case string(ContainerTypeGenericContainer1):
		var gc GenericContainer
		err := json.Unmarshal(body, &gc)
		return gc, err
	case string(ContainerTypeIaaSVMContainer):
		var isc IaaSVMContainer
		err := json.Unmarshal(body, &isc)
		return isc, err
	case string(ContainerTypeWindows1):
		var mc MabContainer
		err := json.Unmarshal(body, &mc)
		return mc, err
	default:
		var pc ProtectionContainer
		err := json.Unmarshal(body, &pc)
		return pc, err
	}
}
func unmarshalBasicProtectionContainerArray(body []byte) ([]BasicProtectionContainer, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	pcArray := make([]BasicProtectionContainer, len(rawMessages))

	for index, rawMessage := range rawMessages {
		pc, err := unmarshalBasicProtectionContainer(*rawMessage)
		if err != nil {
			return nil, err
		}
		pcArray[index] = pc
	}
	return pcArray, nil
}

// MarshalJSON is the custom marshaler for ProtectionContainer.
func (pc ProtectionContainer) MarshalJSON() ([]byte, error) {
	pc.ContainerType = ContainerTypeProtectionContainer
	objectMap := make(map[string]interface{})
	if pc.FriendlyName != nil {
		objectMap["friendlyName"] = pc.FriendlyName
	}
	if pc.BackupManagementType != "" {
		objectMap["backupManagementType"] = pc.BackupManagementType
	}
	if pc.RegistrationStatus != nil {
		objectMap["registrationStatus"] = pc.RegistrationStatus
	}
	if pc.HealthStatus != nil {
		objectMap["healthStatus"] = pc.HealthStatus
	}
	if pc.ContainerType != "" {
		objectMap["containerType"] = pc.ContainerType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupServerContainer is the BasicProtectionContainer implementation for ProtectionContainer.
func (pc ProtectionContainer) AsAzureBackupServerContainer() (*AzureBackupServerContainer, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMContainer is the BasicProtectionContainer implementation for ProtectionContainer.
func (pc ProtectionContainer) AsAzureIaaSClassicComputeVMContainer() (*AzureIaaSClassicComputeVMContainer, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMContainer is the BasicProtectionContainer implementation for ProtectionContainer.
func (pc ProtectionContainer) AsAzureIaaSComputeVMContainer() (*AzureIaaSComputeVMContainer, bool) {
	return nil, false
}

// AsAzureSQLAGWorkloadContainerProtectionContainer is the BasicProtectionContainer implementation for ProtectionContainer.
func (pc ProtectionContainer) AsAzureSQLAGWorkloadContainerProtectionContainer() (*AzureSQLAGWorkloadContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureSQLContainer is the BasicProtectionContainer implementation for ProtectionContainer.
func (pc ProtectionContainer) AsAzureSQLContainer() (*AzureSQLContainer, bool) {
	return nil, false
}

// AsAzureStorageContainer is the BasicProtectionContainer implementation for ProtectionContainer.
func (pc ProtectionContainer) AsAzureStorageContainer() (*AzureStorageContainer, bool) {
	return nil, false
}

// AsAzureVMAppContainerProtectionContainer is the BasicProtectionContainer implementation for ProtectionContainer.
func (pc ProtectionContainer) AsAzureVMAppContainerProtectionContainer() (*AzureVMAppContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureWorkloadContainer is the BasicProtectionContainer implementation for ProtectionContainer.
func (pc ProtectionContainer) AsAzureWorkloadContainer() (*AzureWorkloadContainer, bool) {
	return nil, false
}

// AsBasicAzureWorkloadContainer is the BasicProtectionContainer implementation for ProtectionContainer.
func (pc ProtectionContainer) AsBasicAzureWorkloadContainer() (BasicAzureWorkloadContainer, bool) {
	return nil, false
}

// AsDpmContainer is the BasicProtectionContainer implementation for ProtectionContainer.
func (pc ProtectionContainer) AsDpmContainer() (*DpmContainer, bool) {
	return nil, false
}

// AsBasicDpmContainer is the BasicProtectionContainer implementation for ProtectionContainer.
func (pc ProtectionContainer) AsBasicDpmContainer() (BasicDpmContainer, bool) {
	return nil, false
}

// AsGenericContainer is the BasicProtectionContainer implementation for ProtectionContainer.
func (pc ProtectionContainer) AsGenericContainer() (*GenericContainer, bool) {
	return nil, false
}

// AsIaaSVMContainer is the BasicProtectionContainer implementation for ProtectionContainer.
func (pc ProtectionContainer) AsIaaSVMContainer() (*IaaSVMContainer, bool) {
	return nil, false
}

// AsBasicIaaSVMContainer is the BasicProtectionContainer implementation for ProtectionContainer.
func (pc ProtectionContainer) AsBasicIaaSVMContainer() (BasicIaaSVMContainer, bool) {
	return nil, false
}

// AsMabContainer is the BasicProtectionContainer implementation for ProtectionContainer.
func (pc ProtectionContainer) AsMabContainer() (*MabContainer, bool) {
	return nil, false
}

// AsProtectionContainer is the BasicProtectionContainer implementation for ProtectionContainer.
func (pc ProtectionContainer) AsProtectionContainer() (*ProtectionContainer, bool) {
	return &pc, true
}

// AsBasicProtectionContainer is the BasicProtectionContainer implementation for ProtectionContainer.
func (pc ProtectionContainer) AsBasicProtectionContainer() (BasicProtectionContainer, bool) {
	return &pc, true
}

// ProtectionContainerResource base class for container with backup items. Containers with specific
// workloads are derived from this class.
type ProtectionContainerResource struct {
	autorest.Response `json:"-"`
	// Properties - ProtectionContainerResource properties
	Properties BasicProtectionContainer `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ETag - Optional ETag.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for ProtectionContainerResource.
func (pcr ProtectionContainerResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = pcr.Properties
	if pcr.Location != nil {
		objectMap["location"] = pcr.Location
	}
	if pcr.Tags != nil {
		objectMap["tags"] = pcr.Tags
	}
	if pcr.ETag != nil {
		objectMap["eTag"] = pcr.ETag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ProtectionContainerResource struct.
func (pcr *ProtectionContainerResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicProtectionContainer(*v)
				if err != nil {
					return err
				}
				pcr.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pcr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pcr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pcr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				pcr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				pcr.Tags = tags
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				pcr.ETag = &eTag
			}
		}
	}

	return nil
}

// ProtectionContainerResourceList list of ProtectionContainer resources
type ProtectionContainerResourceList struct {
	autorest.Response `json:"-"`
	// Value - List of resources.
	Value *[]ProtectionContainerResource `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProtectionContainerResourceListIterator provides access to a complete listing of
// ProtectionContainerResource values.
type ProtectionContainerResourceListIterator struct {
	i    int
	page ProtectionContainerResourceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProtectionContainerResourceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProtectionContainerResourceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProtectionContainerResourceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProtectionContainerResourceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProtectionContainerResourceListIterator) Response() ProtectionContainerResourceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProtectionContainerResourceListIterator) Value() ProtectionContainerResource {
	if !iter.page.NotDone() {
		return ProtectionContainerResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProtectionContainerResourceListIterator type.
func NewProtectionContainerResourceListIterator(page ProtectionContainerResourceListPage) ProtectionContainerResourceListIterator {
	return ProtectionContainerResourceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pcrl ProtectionContainerResourceList) IsEmpty() bool {
	return pcrl.Value == nil || len(*pcrl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pcrl ProtectionContainerResourceList) hasNextLink() bool {
	return pcrl.NextLink != nil && len(*pcrl.NextLink) != 0
}

// protectionContainerResourceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pcrl ProtectionContainerResourceList) protectionContainerResourceListPreparer(ctx context.Context) (*http.Request, error) {
	if !pcrl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pcrl.NextLink)))
}

// ProtectionContainerResourceListPage contains a page of ProtectionContainerResource values.
type ProtectionContainerResourceListPage struct {
	fn   func(context.Context, ProtectionContainerResourceList) (ProtectionContainerResourceList, error)
	pcrl ProtectionContainerResourceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProtectionContainerResourceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProtectionContainerResourceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pcrl)
		if err != nil {
			return err
		}
		page.pcrl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProtectionContainerResourceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProtectionContainerResourceListPage) NotDone() bool {
	return !page.pcrl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProtectionContainerResourceListPage) Response() ProtectionContainerResourceList {
	return page.pcrl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProtectionContainerResourceListPage) Values() []ProtectionContainerResource {
	if page.pcrl.IsEmpty() {
		return nil
	}
	return *page.pcrl.Value
}

// Creates a new instance of the ProtectionContainerResourceListPage type.
func NewProtectionContainerResourceListPage(cur ProtectionContainerResourceList, getNextPage func(context.Context, ProtectionContainerResourceList) (ProtectionContainerResourceList, error)) ProtectionContainerResourceListPage {
	return ProtectionContainerResourceListPage{
		fn:   getNextPage,
		pcrl: cur,
	}
}

// BasicRecoveryPoint base class for backup copies. Workload-specific backup copies are derived from this class.
type BasicRecoveryPoint interface {
	AsRecoveryPoint() (*RecoveryPoint, bool)
}

// RecoveryPoint base class for backup copies. Workload-specific backup copies are derived from this class.
type RecoveryPoint struct {
	// ObjectType - Possible values include: 'ObjectTypeRecoveryPoint'
	ObjectType ObjectTypeBasicRecoveryPoint `json:"objectType,omitempty"`
}

func unmarshalBasicRecoveryPoint(body []byte) (BasicRecoveryPoint, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["objectType"] {
	default:
		var rp RecoveryPoint
		err := json.Unmarshal(body, &rp)
		return rp, err
	}
}
func unmarshalBasicRecoveryPointArray(body []byte) ([]BasicRecoveryPoint, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rpArray := make([]BasicRecoveryPoint, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rp, err := unmarshalBasicRecoveryPoint(*rawMessage)
		if err != nil {
			return nil, err
		}
		rpArray[index] = rp
	}
	return rpArray, nil
}

// MarshalJSON is the custom marshaler for RecoveryPoint.
func (rp RecoveryPoint) MarshalJSON() ([]byte, error) {
	rp.ObjectType = ObjectTypeRecoveryPoint
	objectMap := make(map[string]interface{})
	if rp.ObjectType != "" {
		objectMap["objectType"] = rp.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsRecoveryPoint is the BasicRecoveryPoint implementation for RecoveryPoint.
func (rp RecoveryPoint) AsRecoveryPoint() (*RecoveryPoint, bool) {
	return &rp, true
}

// AsBasicRecoveryPoint is the BasicRecoveryPoint implementation for RecoveryPoint.
func (rp RecoveryPoint) AsBasicRecoveryPoint() (BasicRecoveryPoint, bool) {
	return &rp, true
}

// BasicRequest base class for backup request. Workload-specific backup requests are derived from this class.
type BasicRequest interface {
	AsAzureFileShareBackupRequest() (*AzureFileShareBackupRequest, bool)
	AsAzureWorkloadBackupRequest() (*AzureWorkloadBackupRequest, bool)
	AsIaasVMBackupRequest() (*IaasVMBackupRequest, bool)
	AsRequest() (*Request, bool)
}

// Request base class for backup request. Workload-specific backup requests are derived from this class.
type Request struct {
	// ObjectType - Possible values include: 'ObjectTypeBackupRequest', 'ObjectTypeAzureFileShareBackupRequest', 'ObjectTypeAzureWorkloadBackupRequest', 'ObjectTypeIaasVMBackupRequest'
	ObjectType ObjectType `json:"objectType,omitempty"`
}

func unmarshalBasicRequest(body []byte) (BasicRequest, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["objectType"] {
	case string(ObjectTypeAzureFileShareBackupRequest):
		var afsbr AzureFileShareBackupRequest
		err := json.Unmarshal(body, &afsbr)
		return afsbr, err
	case string(ObjectTypeAzureWorkloadBackupRequest):
		var awbr AzureWorkloadBackupRequest
		err := json.Unmarshal(body, &awbr)
		return awbr, err
	case string(ObjectTypeIaasVMBackupRequest):
		var ivbr IaasVMBackupRequest
		err := json.Unmarshal(body, &ivbr)
		return ivbr, err
	default:
		var r Request
		err := json.Unmarshal(body, &r)
		return r, err
	}
}
func unmarshalBasicRequestArray(body []byte) ([]BasicRequest, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rArray := make([]BasicRequest, len(rawMessages))

	for index, rawMessage := range rawMessages {
		r, err := unmarshalBasicRequest(*rawMessage)
		if err != nil {
			return nil, err
		}
		rArray[index] = r
	}
	return rArray, nil
}

// MarshalJSON is the custom marshaler for Request.
func (r Request) MarshalJSON() ([]byte, error) {
	r.ObjectType = ObjectTypeBackupRequest
	objectMap := make(map[string]interface{})
	if r.ObjectType != "" {
		objectMap["objectType"] = r.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareBackupRequest is the BasicRequest implementation for Request.
func (r Request) AsAzureFileShareBackupRequest() (*AzureFileShareBackupRequest, bool) {
	return nil, false
}

// AsAzureWorkloadBackupRequest is the BasicRequest implementation for Request.
func (r Request) AsAzureWorkloadBackupRequest() (*AzureWorkloadBackupRequest, bool) {
	return nil, false
}

// AsIaasVMBackupRequest is the BasicRequest implementation for Request.
func (r Request) AsIaasVMBackupRequest() (*IaasVMBackupRequest, bool) {
	return nil, false
}

// AsRequest is the BasicRequest implementation for Request.
func (r Request) AsRequest() (*Request, bool) {
	return &r, true
}

// AsBasicRequest is the BasicRequest implementation for Request.
func (r Request) AsBasicRequest() (BasicRequest, bool) {
	return &r, true
}

// RequestResource base class for backup request. Workload-specific backup requests are derived from this
// class.
type RequestResource struct {
	// Properties - BackupRequestResource properties
	Properties BasicRequest `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ETag - Optional ETag.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for RequestResource.
func (rr RequestResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = rr.Properties
	if rr.Location != nil {
		objectMap["location"] = rr.Location
	}
	if rr.Tags != nil {
		objectMap["tags"] = rr.Tags
	}
	if rr.ETag != nil {
		objectMap["eTag"] = rr.ETag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RequestResource struct.
func (rr *RequestResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicRequest(*v)
				if err != nil {
					return err
				}
				rr.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rr.Tags = tags
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				rr.ETag = &eTag
			}
		}
	}

	return nil
}

// Resource ARM Resource.
type Resource struct {
	// ID - READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ETag - Optional ETag.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	if r.ETag != nil {
		objectMap["eTag"] = r.ETag
	}
	return json.Marshal(objectMap)
}

// ResourceConfig the resource storage details.
type ResourceConfig struct {
	// StorageModelType - Storage type. Possible values include: 'StorageTypeInvalid', 'StorageTypeGeoRedundant', 'StorageTypeLocallyRedundant'
	StorageModelType StorageType `json:"storageModelType,omitempty"`
	// StorageType - Storage type. Possible values include: 'StorageTypeInvalid', 'StorageTypeGeoRedundant', 'StorageTypeLocallyRedundant'
	StorageType StorageType `json:"storageType,omitempty"`
	// StorageTypeState - Locked or Unlocked. Once a machine is registered against a resource, the storageTypeState is always Locked. Possible values include: 'StorageTypeStateInvalid', 'StorageTypeStateLocked', 'StorageTypeStateUnlocked'
	StorageTypeState StorageTypeState `json:"storageTypeState,omitempty"`
}

// ResourceConfigResource the resource storage details.
type ResourceConfigResource struct {
	autorest.Response `json:"-"`
	// Properties - BackupResourceConfigResource properties
	Properties *ResourceConfig `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ETag - Optional ETag.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceConfigResource.
func (rcr ResourceConfigResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rcr.Properties != nil {
		objectMap["properties"] = rcr.Properties
	}
	if rcr.Location != nil {
		objectMap["location"] = rcr.Location
	}
	if rcr.Tags != nil {
		objectMap["tags"] = rcr.Tags
	}
	if rcr.ETag != nil {
		objectMap["eTag"] = rcr.ETag
	}
	return json.Marshal(objectMap)
}

// ResourceList base for all lists of resources.
type ResourceList struct {
	// NextLink - The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// SQLDataDirectory sQLDataDirectory info
type SQLDataDirectory struct {
	// Type - Type of data directory mapping. Possible values include: 'SQLDataDirectoryTypeInvalid', 'SQLDataDirectoryTypeData', 'SQLDataDirectoryTypeLog'
	Type SQLDataDirectoryType `json:"type,omitempty"`
	// Path - File path
	Path *string `json:"path,omitempty"`
	// LogicalName - Logical name of the file
	LogicalName *string `json:"logicalName,omitempty"`
}

// TokenInformation the token information details.
type TokenInformation struct {
	autorest.Response `json:"-"`
	// Token - Token value.
	Token *string `json:"token,omitempty"`
	// ExpiryTimeInUtcTicks - Expiry time of token.
	ExpiryTimeInUtcTicks *int64 `json:"expiryTimeInUtcTicks,omitempty"`
	// SecurityPIN - Security PIN
	SecurityPIN *string `json:"securityPIN,omitempty"`
}

// WorkloadInquiryDetails details of an inquired protectable item.
type WorkloadInquiryDetails struct {
	// Type - Type of the Workload such as SQL, Oracle etc.
	Type *string `json:"type,omitempty"`
	// ItemCount - Contains the protectable item Count inside this Container.
	ItemCount *int64 `json:"itemCount,omitempty"`
	// InquiryValidation - Inquiry validation such as permissions and other backup validations.
	InquiryValidation *InquiryValidation `json:"inquiryValidation,omitempty"`
}

// BasicWorkloadItem base class for backup item. Workload-specific backup items are derived from this class.
type BasicWorkloadItem interface {
	AsAzureVMWorkloadItem() (*AzureVMWorkloadItem, bool)
	AsBasicAzureVMWorkloadItem() (BasicAzureVMWorkloadItem, bool)
	AsAzureVMWorkloadSAPAseDatabaseWorkloadItem() (*AzureVMWorkloadSAPAseDatabaseWorkloadItem, bool)
	AsAzureVMWorkloadSAPAseSystemWorkloadItem() (*AzureVMWorkloadSAPAseSystemWorkloadItem, bool)
	AsAzureVMWorkloadSAPHanaDatabaseWorkloadItem() (*AzureVMWorkloadSAPHanaDatabaseWorkloadItem, bool)
	AsAzureVMWorkloadSAPHanaSystemWorkloadItem() (*AzureVMWorkloadSAPHanaSystemWorkloadItem, bool)
	AsAzureVMWorkloadSQLDatabaseWorkloadItem() (*AzureVMWorkloadSQLDatabaseWorkloadItem, bool)
	AsAzureVMWorkloadSQLInstanceWorkloadItem() (*AzureVMWorkloadSQLInstanceWorkloadItem, bool)
	AsWorkloadItem() (*WorkloadItem, bool)
}

// WorkloadItem base class for backup item. Workload-specific backup items are derived from this class.
type WorkloadItem struct {
	// BackupManagementType - Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
	// FriendlyName - Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionState - State of the back up item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// WorkloadItemType - Possible values include: 'WorkloadItemTypeWorkloadItem', 'WorkloadItemTypeAzureVMWorkloadItem', 'WorkloadItemTypeSAPAseDatabase1', 'WorkloadItemTypeSAPAseSystem1', 'WorkloadItemTypeSAPHanaDatabase1', 'WorkloadItemTypeSAPHanaSystem1', 'WorkloadItemTypeSQLDataBase1', 'WorkloadItemTypeSQLInstance1'
	WorkloadItemType WorkloadItemTypeBasicWorkloadItem `json:"workloadItemType,omitempty"`
}

func unmarshalBasicWorkloadItem(body []byte) (BasicWorkloadItem, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["workloadItemType"] {
	case string(WorkloadItemTypeAzureVMWorkloadItem):
		var avwi AzureVMWorkloadItem
		err := json.Unmarshal(body, &avwi)
		return avwi, err
	case string(WorkloadItemTypeSAPAseDatabase1):
		var avwsadwi AzureVMWorkloadSAPAseDatabaseWorkloadItem
		err := json.Unmarshal(body, &avwsadwi)
		return avwsadwi, err
	case string(WorkloadItemTypeSAPAseSystem1):
		var avwsaswi AzureVMWorkloadSAPAseSystemWorkloadItem
		err := json.Unmarshal(body, &avwsaswi)
		return avwsaswi, err
	case string(WorkloadItemTypeSAPHanaDatabase1):
		var avwshdwi AzureVMWorkloadSAPHanaDatabaseWorkloadItem
		err := json.Unmarshal(body, &avwshdwi)
		return avwshdwi, err
	case string(WorkloadItemTypeSAPHanaSystem1):
		var avwshswi AzureVMWorkloadSAPHanaSystemWorkloadItem
		err := json.Unmarshal(body, &avwshswi)
		return avwshswi, err
	case string(WorkloadItemTypeSQLDataBase1):
		var avwsdwi AzureVMWorkloadSQLDatabaseWorkloadItem
		err := json.Unmarshal(body, &avwsdwi)
		return avwsdwi, err
	case string(WorkloadItemTypeSQLInstance1):
		var avwsiwi AzureVMWorkloadSQLInstanceWorkloadItem
		err := json.Unmarshal(body, &avwsiwi)
		return avwsiwi, err
	default:
		var wi WorkloadItem
		err := json.Unmarshal(body, &wi)
		return wi, err
	}
}
func unmarshalBasicWorkloadItemArray(body []byte) ([]BasicWorkloadItem, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	wiArray := make([]BasicWorkloadItem, len(rawMessages))

	for index, rawMessage := range rawMessages {
		wi, err := unmarshalBasicWorkloadItem(*rawMessage)
		if err != nil {
			return nil, err
		}
		wiArray[index] = wi
	}
	return wiArray, nil
}

// MarshalJSON is the custom marshaler for WorkloadItem.
func (wi WorkloadItem) MarshalJSON() ([]byte, error) {
	wi.WorkloadItemType = WorkloadItemTypeWorkloadItem
	objectMap := make(map[string]interface{})
	if wi.BackupManagementType != nil {
		objectMap["backupManagementType"] = wi.BackupManagementType
	}
	if wi.WorkloadType != nil {
		objectMap["workloadType"] = wi.WorkloadType
	}
	if wi.FriendlyName != nil {
		objectMap["friendlyName"] = wi.FriendlyName
	}
	if wi.ProtectionState != "" {
		objectMap["protectionState"] = wi.ProtectionState
	}
	if wi.WorkloadItemType != "" {
		objectMap["workloadItemType"] = wi.WorkloadItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureVMWorkloadItem is the BasicWorkloadItem implementation for WorkloadItem.
func (wi WorkloadItem) AsAzureVMWorkloadItem() (*AzureVMWorkloadItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadItem is the BasicWorkloadItem implementation for WorkloadItem.
func (wi WorkloadItem) AsBasicAzureVMWorkloadItem() (BasicAzureVMWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPAseDatabaseWorkloadItem is the BasicWorkloadItem implementation for WorkloadItem.
func (wi WorkloadItem) AsAzureVMWorkloadSAPAseDatabaseWorkloadItem() (*AzureVMWorkloadSAPAseDatabaseWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPAseSystemWorkloadItem is the BasicWorkloadItem implementation for WorkloadItem.
func (wi WorkloadItem) AsAzureVMWorkloadSAPAseSystemWorkloadItem() (*AzureVMWorkloadSAPAseSystemWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseWorkloadItem is the BasicWorkloadItem implementation for WorkloadItem.
func (wi WorkloadItem) AsAzureVMWorkloadSAPHanaDatabaseWorkloadItem() (*AzureVMWorkloadSAPHanaDatabaseWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaSystemWorkloadItem is the BasicWorkloadItem implementation for WorkloadItem.
func (wi WorkloadItem) AsAzureVMWorkloadSAPHanaSystemWorkloadItem() (*AzureVMWorkloadSAPHanaSystemWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseWorkloadItem is the BasicWorkloadItem implementation for WorkloadItem.
func (wi WorkloadItem) AsAzureVMWorkloadSQLDatabaseWorkloadItem() (*AzureVMWorkloadSQLDatabaseWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLInstanceWorkloadItem is the BasicWorkloadItem implementation for WorkloadItem.
func (wi WorkloadItem) AsAzureVMWorkloadSQLInstanceWorkloadItem() (*AzureVMWorkloadSQLInstanceWorkloadItem, bool) {
	return nil, false
}

// AsWorkloadItem is the BasicWorkloadItem implementation for WorkloadItem.
func (wi WorkloadItem) AsWorkloadItem() (*WorkloadItem, bool) {
	return &wi, true
}

// AsBasicWorkloadItem is the BasicWorkloadItem implementation for WorkloadItem.
func (wi WorkloadItem) AsBasicWorkloadItem() (BasicWorkloadItem, bool) {
	return &wi, true
}

// WorkloadItemResource base class for backup item. Workload-specific backup items are derived from this
// class.
type WorkloadItemResource struct {
	// Properties - WorkloadItemResource properties
	Properties BasicWorkloadItem `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ETag - Optional ETag.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadItemResource.
func (wir WorkloadItemResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = wir.Properties
	if wir.Location != nil {
		objectMap["location"] = wir.Location
	}
	if wir.Tags != nil {
		objectMap["tags"] = wir.Tags
	}
	if wir.ETag != nil {
		objectMap["eTag"] = wir.ETag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkloadItemResource struct.
func (wir *WorkloadItemResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicWorkloadItem(*v)
				if err != nil {
					return err
				}
				wir.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wir.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wir.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wir.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				wir.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				wir.Tags = tags
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				wir.ETag = &eTag
			}
		}
	}

	return nil
}

// WorkloadItemResourceList list of WorkloadItem resources
type WorkloadItemResourceList struct {
	autorest.Response `json:"-"`
	// Value - List of resources.
	Value *[]WorkloadItemResource `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// WorkloadItemResourceListIterator provides access to a complete listing of WorkloadItemResource values.
type WorkloadItemResourceListIterator struct {
	i    int
	page WorkloadItemResourceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkloadItemResourceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadItemResourceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkloadItemResourceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkloadItemResourceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkloadItemResourceListIterator) Response() WorkloadItemResourceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkloadItemResourceListIterator) Value() WorkloadItemResource {
	if !iter.page.NotDone() {
		return WorkloadItemResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkloadItemResourceListIterator type.
func NewWorkloadItemResourceListIterator(page WorkloadItemResourceListPage) WorkloadItemResourceListIterator {
	return WorkloadItemResourceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wirl WorkloadItemResourceList) IsEmpty() bool {
	return wirl.Value == nil || len(*wirl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wirl WorkloadItemResourceList) hasNextLink() bool {
	return wirl.NextLink != nil && len(*wirl.NextLink) != 0
}

// workloadItemResourceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wirl WorkloadItemResourceList) workloadItemResourceListPreparer(ctx context.Context) (*http.Request, error) {
	if !wirl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wirl.NextLink)))
}

// WorkloadItemResourceListPage contains a page of WorkloadItemResource values.
type WorkloadItemResourceListPage struct {
	fn   func(context.Context, WorkloadItemResourceList) (WorkloadItemResourceList, error)
	wirl WorkloadItemResourceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkloadItemResourceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadItemResourceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wirl)
		if err != nil {
			return err
		}
		page.wirl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkloadItemResourceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkloadItemResourceListPage) NotDone() bool {
	return !page.wirl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkloadItemResourceListPage) Response() WorkloadItemResourceList {
	return page.wirl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkloadItemResourceListPage) Values() []WorkloadItemResource {
	if page.wirl.IsEmpty() {
		return nil
	}
	return *page.wirl.Value
}

// Creates a new instance of the WorkloadItemResourceListPage type.
func NewWorkloadItemResourceListPage(cur WorkloadItemResourceList, getNextPage func(context.Context, WorkloadItemResourceList) (WorkloadItemResourceList, error)) WorkloadItemResourceListPage {
	return WorkloadItemResourceListPage{
		fn:   getNextPage,
		wirl: cur,
	}
}

// BasicWorkloadProtectableItem base class for backup item. Workload-specific backup items are derived from this class.
type BasicWorkloadProtectableItem interface {
	AsAzureFileShareProtectableItem() (*AzureFileShareProtectableItem, bool)
	AsAzureIaaSClassicComputeVMProtectableItem() (*AzureIaaSClassicComputeVMProtectableItem, bool)
	AsAzureIaaSComputeVMProtectableItem() (*AzureIaaSComputeVMProtectableItem, bool)
	AsAzureVMWorkloadProtectableItem() (*AzureVMWorkloadProtectableItem, bool)
	AsBasicAzureVMWorkloadProtectableItem() (BasicAzureVMWorkloadProtectableItem, bool)
	AsAzureVMWorkloadSAPAseSystemProtectableItem() (*AzureVMWorkloadSAPAseSystemProtectableItem, bool)
	AsAzureVMWorkloadSAPHanaDatabaseProtectableItem() (*AzureVMWorkloadSAPHanaDatabaseProtectableItem, bool)
	AsAzureVMWorkloadSAPHanaSystemProtectableItem() (*AzureVMWorkloadSAPHanaSystemProtectableItem, bool)
	AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem() (*AzureVMWorkloadSQLAvailabilityGroupProtectableItem, bool)
	AsAzureVMWorkloadSQLDatabaseProtectableItem() (*AzureVMWorkloadSQLDatabaseProtectableItem, bool)
	AsAzureVMWorkloadSQLInstanceProtectableItem() (*AzureVMWorkloadSQLInstanceProtectableItem, bool)
	AsIaaSVMProtectableItem() (*IaaSVMProtectableItem, bool)
	AsBasicIaaSVMProtectableItem() (BasicIaaSVMProtectableItem, bool)
	AsWorkloadProtectableItem() (*WorkloadProtectableItem, bool)
}

// WorkloadProtectableItem base class for backup item. Workload-specific backup items are derived from this
// class.
type WorkloadProtectableItem struct {
	// BackupManagementType - Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
	// FriendlyName - Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionState - State of the back up item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// ProtectableItemType - Possible values include: 'ProtectableItemTypeWorkloadProtectableItem', 'ProtectableItemTypeAzureFileShare', 'ProtectableItemTypeMicrosoftClassicComputevirtualMachines', 'ProtectableItemTypeMicrosoftComputevirtualMachines', 'ProtectableItemTypeAzureVMWorkloadProtectableItem', 'ProtectableItemTypeSAPAseSystem', 'ProtectableItemTypeSAPHanaDatabase', 'ProtectableItemTypeSAPHanaSystem', 'ProtectableItemTypeSQLAvailabilityGroupContainer', 'ProtectableItemTypeSQLDataBase', 'ProtectableItemTypeSQLInstance', 'ProtectableItemTypeIaaSVMProtectableItem'
	ProtectableItemType ProtectableItemType `json:"protectableItemType,omitempty"`
}

func unmarshalBasicWorkloadProtectableItem(body []byte) (BasicWorkloadProtectableItem, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["protectableItemType"] {
	case string(ProtectableItemTypeAzureFileShare):
		var afspi AzureFileShareProtectableItem
		err := json.Unmarshal(body, &afspi)
		return afspi, err
	case string(ProtectableItemTypeMicrosoftClassicComputevirtualMachines):
		var aisccvpi AzureIaaSClassicComputeVMProtectableItem
		err := json.Unmarshal(body, &aisccvpi)
		return aisccvpi, err
	case string(ProtectableItemTypeMicrosoftComputevirtualMachines):
		var aiscvpi AzureIaaSComputeVMProtectableItem
		err := json.Unmarshal(body, &aiscvpi)
		return aiscvpi, err
	case string(ProtectableItemTypeAzureVMWorkloadProtectableItem):
		var avwpi AzureVMWorkloadProtectableItem
		err := json.Unmarshal(body, &avwpi)
		return avwpi, err
	case string(ProtectableItemTypeSAPAseSystem):
		var avwsaspi AzureVMWorkloadSAPAseSystemProtectableItem
		err := json.Unmarshal(body, &avwsaspi)
		return avwsaspi, err
	case string(ProtectableItemTypeSAPHanaDatabase):
		var avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectableItem
		err := json.Unmarshal(body, &avwshdpi)
		return avwshdpi, err
	case string(ProtectableItemTypeSAPHanaSystem):
		var avwshspi AzureVMWorkloadSAPHanaSystemProtectableItem
		err := json.Unmarshal(body, &avwshspi)
		return avwshspi, err
	case string(ProtectableItemTypeSQLAvailabilityGroupContainer):
		var avwsagpi AzureVMWorkloadSQLAvailabilityGroupProtectableItem
		err := json.Unmarshal(body, &avwsagpi)
		return avwsagpi, err
	case string(ProtectableItemTypeSQLDataBase):
		var avwsdpi AzureVMWorkloadSQLDatabaseProtectableItem
		err := json.Unmarshal(body, &avwsdpi)
		return avwsdpi, err
	case string(ProtectableItemTypeSQLInstance):
		var avwsipi AzureVMWorkloadSQLInstanceProtectableItem
		err := json.Unmarshal(body, &avwsipi)
		return avwsipi, err
	case string(ProtectableItemTypeIaaSVMProtectableItem):
		var ispi IaaSVMProtectableItem
		err := json.Unmarshal(body, &ispi)
		return ispi, err
	default:
		var wpi WorkloadProtectableItem
		err := json.Unmarshal(body, &wpi)
		return wpi, err
	}
}
func unmarshalBasicWorkloadProtectableItemArray(body []byte) ([]BasicWorkloadProtectableItem, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	wpiArray := make([]BasicWorkloadProtectableItem, len(rawMessages))

	for index, rawMessage := range rawMessages {
		wpi, err := unmarshalBasicWorkloadProtectableItem(*rawMessage)
		if err != nil {
			return nil, err
		}
		wpiArray[index] = wpi
	}
	return wpiArray, nil
}

// MarshalJSON is the custom marshaler for WorkloadProtectableItem.
func (wpi WorkloadProtectableItem) MarshalJSON() ([]byte, error) {
	wpi.ProtectableItemType = ProtectableItemTypeWorkloadProtectableItem
	objectMap := make(map[string]interface{})
	if wpi.BackupManagementType != nil {
		objectMap["backupManagementType"] = wpi.BackupManagementType
	}
	if wpi.WorkloadType != nil {
		objectMap["workloadType"] = wpi.WorkloadType
	}
	if wpi.FriendlyName != nil {
		objectMap["friendlyName"] = wpi.FriendlyName
	}
	if wpi.ProtectionState != "" {
		objectMap["protectionState"] = wpi.ProtectionState
	}
	if wpi.ProtectableItemType != "" {
		objectMap["protectableItemType"] = wpi.ProtectableItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareProtectableItem is the BasicWorkloadProtectableItem implementation for WorkloadProtectableItem.
func (wpi WorkloadProtectableItem) AsAzureFileShareProtectableItem() (*AzureFileShareProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for WorkloadProtectableItem.
func (wpi WorkloadProtectableItem) AsAzureIaaSClassicComputeVMProtectableItem() (*AzureIaaSClassicComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for WorkloadProtectableItem.
func (wpi WorkloadProtectableItem) AsAzureIaaSComputeVMProtectableItem() (*AzureIaaSComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for WorkloadProtectableItem.
func (wpi WorkloadProtectableItem) AsAzureVMWorkloadProtectableItem() (*AzureVMWorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for WorkloadProtectableItem.
func (wpi WorkloadProtectableItem) AsBasicAzureVMWorkloadProtectableItem() (BasicAzureVMWorkloadProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPAseSystemProtectableItem is the BasicWorkloadProtectableItem implementation for WorkloadProtectableItem.
func (wpi WorkloadProtectableItem) AsAzureVMWorkloadSAPAseSystemProtectableItem() (*AzureVMWorkloadSAPAseSystemProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for WorkloadProtectableItem.
func (wpi WorkloadProtectableItem) AsAzureVMWorkloadSAPHanaDatabaseProtectableItem() (*AzureVMWorkloadSAPHanaDatabaseProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaSystemProtectableItem is the BasicWorkloadProtectableItem implementation for WorkloadProtectableItem.
func (wpi WorkloadProtectableItem) AsAzureVMWorkloadSAPHanaSystemProtectableItem() (*AzureVMWorkloadSAPHanaSystemProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem is the BasicWorkloadProtectableItem implementation for WorkloadProtectableItem.
func (wpi WorkloadProtectableItem) AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem() (*AzureVMWorkloadSQLAvailabilityGroupProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for WorkloadProtectableItem.
func (wpi WorkloadProtectableItem) AsAzureVMWorkloadSQLDatabaseProtectableItem() (*AzureVMWorkloadSQLDatabaseProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLInstanceProtectableItem is the BasicWorkloadProtectableItem implementation for WorkloadProtectableItem.
func (wpi WorkloadProtectableItem) AsAzureVMWorkloadSQLInstanceProtectableItem() (*AzureVMWorkloadSQLInstanceProtectableItem, bool) {
	return nil, false
}

// AsIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for WorkloadProtectableItem.
func (wpi WorkloadProtectableItem) AsIaaSVMProtectableItem() (*IaaSVMProtectableItem, bool) {
	return nil, false
}

// AsBasicIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for WorkloadProtectableItem.
func (wpi WorkloadProtectableItem) AsBasicIaaSVMProtectableItem() (BasicIaaSVMProtectableItem, bool) {
	return nil, false
}

// AsWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for WorkloadProtectableItem.
func (wpi WorkloadProtectableItem) AsWorkloadProtectableItem() (*WorkloadProtectableItem, bool) {
	return &wpi, true
}

// AsBasicWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for WorkloadProtectableItem.
func (wpi WorkloadProtectableItem) AsBasicWorkloadProtectableItem() (BasicWorkloadProtectableItem, bool) {
	return &wpi, true
}

// WorkloadProtectableItemResource base class for backup item. Workload-specific backup items are derived
// from this class.
type WorkloadProtectableItemResource struct {
	// Properties - WorkloadProtectableItemResource properties
	Properties BasicWorkloadProtectableItem `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ETag - Optional ETag.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadProtectableItemResource.
func (wpir WorkloadProtectableItemResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = wpir.Properties
	if wpir.Location != nil {
		objectMap["location"] = wpir.Location
	}
	if wpir.Tags != nil {
		objectMap["tags"] = wpir.Tags
	}
	if wpir.ETag != nil {
		objectMap["eTag"] = wpir.ETag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkloadProtectableItemResource struct.
func (wpir *WorkloadProtectableItemResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicWorkloadProtectableItem(*v)
				if err != nil {
					return err
				}
				wpir.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wpir.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wpir.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wpir.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				wpir.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				wpir.Tags = tags
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				wpir.ETag = &eTag
			}
		}
	}

	return nil
}

// WorkloadProtectableItemResourceList list of WorkloadProtectableItem resources
type WorkloadProtectableItemResourceList struct {
	autorest.Response `json:"-"`
	// Value - List of resources.
	Value *[]WorkloadProtectableItemResource `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// WorkloadProtectableItemResourceListIterator provides access to a complete listing of
// WorkloadProtectableItemResource values.
type WorkloadProtectableItemResourceListIterator struct {
	i    int
	page WorkloadProtectableItemResourceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkloadProtectableItemResourceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadProtectableItemResourceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkloadProtectableItemResourceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkloadProtectableItemResourceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkloadProtectableItemResourceListIterator) Response() WorkloadProtectableItemResourceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkloadProtectableItemResourceListIterator) Value() WorkloadProtectableItemResource {
	if !iter.page.NotDone() {
		return WorkloadProtectableItemResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkloadProtectableItemResourceListIterator type.
func NewWorkloadProtectableItemResourceListIterator(page WorkloadProtectableItemResourceListPage) WorkloadProtectableItemResourceListIterator {
	return WorkloadProtectableItemResourceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wpirl WorkloadProtectableItemResourceList) IsEmpty() bool {
	return wpirl.Value == nil || len(*wpirl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wpirl WorkloadProtectableItemResourceList) hasNextLink() bool {
	return wpirl.NextLink != nil && len(*wpirl.NextLink) != 0
}

// workloadProtectableItemResourceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wpirl WorkloadProtectableItemResourceList) workloadProtectableItemResourceListPreparer(ctx context.Context) (*http.Request, error) {
	if !wpirl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wpirl.NextLink)))
}

// WorkloadProtectableItemResourceListPage contains a page of WorkloadProtectableItemResource values.
type WorkloadProtectableItemResourceListPage struct {
	fn    func(context.Context, WorkloadProtectableItemResourceList) (WorkloadProtectableItemResourceList, error)
	wpirl WorkloadProtectableItemResourceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkloadProtectableItemResourceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadProtectableItemResourceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wpirl)
		if err != nil {
			return err
		}
		page.wpirl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkloadProtectableItemResourceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkloadProtectableItemResourceListPage) NotDone() bool {
	return !page.wpirl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkloadProtectableItemResourceListPage) Response() WorkloadProtectableItemResourceList {
	return page.wpirl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkloadProtectableItemResourceListPage) Values() []WorkloadProtectableItemResource {
	if page.wpirl.IsEmpty() {
		return nil
	}
	return *page.wpirl.Value
}

// Creates a new instance of the WorkloadProtectableItemResourceListPage type.
func NewWorkloadProtectableItemResourceListPage(cur WorkloadProtectableItemResourceList, getNextPage func(context.Context, WorkloadProtectableItemResourceList) (WorkloadProtectableItemResourceList, error)) WorkloadProtectableItemResourceListPage {
	return WorkloadProtectableItemResourceListPage{
		fn:    getNextPage,
		wpirl: cur,
	}
}
