// +build !ignore_autogenerated_core

/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by conversion-gen. DO NOT EDIT.

package v1alpha3

import (
	unsafe "unsafe"

	v1 "k8s.io/api/core/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"
	intstr "k8s.io/apimachinery/pkg/util/intstr"
	v1beta1 "sigs.k8s.io/cluster-api/api/v1beta1"
	errors "sigs.k8s.io/cluster-api/errors"
)

func init() {
	localSchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(s *runtime.Scheme) error {
	if err := s.AddGeneratedConversionFunc((*APIEndpoint)(nil), (*v1beta1.APIEndpoint)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_APIEndpoint_To_v1beta1_APIEndpoint(a.(*APIEndpoint), b.(*v1beta1.APIEndpoint), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.APIEndpoint)(nil), (*APIEndpoint)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_APIEndpoint_To_v1alpha3_APIEndpoint(a.(*v1beta1.APIEndpoint), b.(*APIEndpoint), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.Bootstrap)(nil), (*Bootstrap)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_Bootstrap_To_v1alpha3_Bootstrap(a.(*v1beta1.Bootstrap), b.(*Bootstrap), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Cluster)(nil), (*v1beta1.Cluster)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_Cluster_To_v1beta1_Cluster(a.(*Cluster), b.(*v1beta1.Cluster), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.Cluster)(nil), (*Cluster)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_Cluster_To_v1alpha3_Cluster(a.(*v1beta1.Cluster), b.(*Cluster), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ClusterList)(nil), (*v1beta1.ClusterList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_ClusterList_To_v1beta1_ClusterList(a.(*ClusterList), b.(*v1beta1.ClusterList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.ClusterList)(nil), (*ClusterList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ClusterList_To_v1alpha3_ClusterList(a.(*v1beta1.ClusterList), b.(*ClusterList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ClusterNetwork)(nil), (*v1beta1.ClusterNetwork)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_ClusterNetwork_To_v1beta1_ClusterNetwork(a.(*ClusterNetwork), b.(*v1beta1.ClusterNetwork), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.ClusterNetwork)(nil), (*ClusterNetwork)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ClusterNetwork_To_v1alpha3_ClusterNetwork(a.(*v1beta1.ClusterNetwork), b.(*ClusterNetwork), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ClusterSpec)(nil), (*v1beta1.ClusterSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_ClusterSpec_To_v1beta1_ClusterSpec(a.(*ClusterSpec), b.(*v1beta1.ClusterSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.ClusterStatus)(nil), (*ClusterStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ClusterStatus_To_v1alpha3_ClusterStatus(a.(*v1beta1.ClusterStatus), b.(*ClusterStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Condition)(nil), (*v1beta1.Condition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_Condition_To_v1beta1_Condition(a.(*Condition), b.(*v1beta1.Condition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.Condition)(nil), (*Condition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_Condition_To_v1alpha3_Condition(a.(*v1beta1.Condition), b.(*Condition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*FailureDomainSpec)(nil), (*v1beta1.FailureDomainSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_FailureDomainSpec_To_v1beta1_FailureDomainSpec(a.(*FailureDomainSpec), b.(*v1beta1.FailureDomainSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.FailureDomainSpec)(nil), (*FailureDomainSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_FailureDomainSpec_To_v1alpha3_FailureDomainSpec(a.(*v1beta1.FailureDomainSpec), b.(*FailureDomainSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Machine)(nil), (*v1beta1.Machine)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_Machine_To_v1beta1_Machine(a.(*Machine), b.(*v1beta1.Machine), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.Machine)(nil), (*Machine)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_Machine_To_v1alpha3_Machine(a.(*v1beta1.Machine), b.(*Machine), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineAddress)(nil), (*v1beta1.MachineAddress)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_MachineAddress_To_v1beta1_MachineAddress(a.(*MachineAddress), b.(*v1beta1.MachineAddress), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.MachineAddress)(nil), (*MachineAddress)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_MachineAddress_To_v1alpha3_MachineAddress(a.(*v1beta1.MachineAddress), b.(*MachineAddress), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineDeployment)(nil), (*v1beta1.MachineDeployment)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_MachineDeployment_To_v1beta1_MachineDeployment(a.(*MachineDeployment), b.(*v1beta1.MachineDeployment), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.MachineDeployment)(nil), (*MachineDeployment)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_MachineDeployment_To_v1alpha3_MachineDeployment(a.(*v1beta1.MachineDeployment), b.(*MachineDeployment), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineDeploymentList)(nil), (*v1beta1.MachineDeploymentList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_MachineDeploymentList_To_v1beta1_MachineDeploymentList(a.(*MachineDeploymentList), b.(*v1beta1.MachineDeploymentList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.MachineDeploymentList)(nil), (*MachineDeploymentList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_MachineDeploymentList_To_v1alpha3_MachineDeploymentList(a.(*v1beta1.MachineDeploymentList), b.(*MachineDeploymentList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineDeploymentSpec)(nil), (*v1beta1.MachineDeploymentSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_MachineDeploymentSpec_To_v1beta1_MachineDeploymentSpec(a.(*MachineDeploymentSpec), b.(*v1beta1.MachineDeploymentSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.MachineDeploymentSpec)(nil), (*MachineDeploymentSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_MachineDeploymentSpec_To_v1alpha3_MachineDeploymentSpec(a.(*v1beta1.MachineDeploymentSpec), b.(*MachineDeploymentSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineDeploymentStatus)(nil), (*v1beta1.MachineDeploymentStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_MachineDeploymentStatus_To_v1beta1_MachineDeploymentStatus(a.(*MachineDeploymentStatus), b.(*v1beta1.MachineDeploymentStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineDeploymentStrategy)(nil), (*v1beta1.MachineDeploymentStrategy)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_MachineDeploymentStrategy_To_v1beta1_MachineDeploymentStrategy(a.(*MachineDeploymentStrategy), b.(*v1beta1.MachineDeploymentStrategy), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.MachineDeploymentStrategy)(nil), (*MachineDeploymentStrategy)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_MachineDeploymentStrategy_To_v1alpha3_MachineDeploymentStrategy(a.(*v1beta1.MachineDeploymentStrategy), b.(*MachineDeploymentStrategy), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineHealthCheck)(nil), (*v1beta1.MachineHealthCheck)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_MachineHealthCheck_To_v1beta1_MachineHealthCheck(a.(*MachineHealthCheck), b.(*v1beta1.MachineHealthCheck), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.MachineHealthCheck)(nil), (*MachineHealthCheck)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_MachineHealthCheck_To_v1alpha3_MachineHealthCheck(a.(*v1beta1.MachineHealthCheck), b.(*MachineHealthCheck), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineHealthCheckList)(nil), (*v1beta1.MachineHealthCheckList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_MachineHealthCheckList_To_v1beta1_MachineHealthCheckList(a.(*MachineHealthCheckList), b.(*v1beta1.MachineHealthCheckList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.MachineHealthCheckList)(nil), (*MachineHealthCheckList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_MachineHealthCheckList_To_v1alpha3_MachineHealthCheckList(a.(*v1beta1.MachineHealthCheckList), b.(*MachineHealthCheckList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineHealthCheckSpec)(nil), (*v1beta1.MachineHealthCheckSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_MachineHealthCheckSpec_To_v1beta1_MachineHealthCheckSpec(a.(*MachineHealthCheckSpec), b.(*v1beta1.MachineHealthCheckSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineHealthCheckStatus)(nil), (*v1beta1.MachineHealthCheckStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_MachineHealthCheckStatus_To_v1beta1_MachineHealthCheckStatus(a.(*MachineHealthCheckStatus), b.(*v1beta1.MachineHealthCheckStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.MachineHealthCheckStatus)(nil), (*MachineHealthCheckStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_MachineHealthCheckStatus_To_v1alpha3_MachineHealthCheckStatus(a.(*v1beta1.MachineHealthCheckStatus), b.(*MachineHealthCheckStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineList)(nil), (*v1beta1.MachineList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_MachineList_To_v1beta1_MachineList(a.(*MachineList), b.(*v1beta1.MachineList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.MachineList)(nil), (*MachineList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_MachineList_To_v1alpha3_MachineList(a.(*v1beta1.MachineList), b.(*MachineList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineRollingUpdateDeployment)(nil), (*v1beta1.MachineRollingUpdateDeployment)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_MachineRollingUpdateDeployment_To_v1beta1_MachineRollingUpdateDeployment(a.(*MachineRollingUpdateDeployment), b.(*v1beta1.MachineRollingUpdateDeployment), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineSet)(nil), (*v1beta1.MachineSet)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_MachineSet_To_v1beta1_MachineSet(a.(*MachineSet), b.(*v1beta1.MachineSet), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.MachineSet)(nil), (*MachineSet)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_MachineSet_To_v1alpha3_MachineSet(a.(*v1beta1.MachineSet), b.(*MachineSet), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineSetList)(nil), (*v1beta1.MachineSetList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_MachineSetList_To_v1beta1_MachineSetList(a.(*MachineSetList), b.(*v1beta1.MachineSetList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.MachineSetList)(nil), (*MachineSetList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_MachineSetList_To_v1alpha3_MachineSetList(a.(*v1beta1.MachineSetList), b.(*MachineSetList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineSetSpec)(nil), (*v1beta1.MachineSetSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_MachineSetSpec_To_v1beta1_MachineSetSpec(a.(*MachineSetSpec), b.(*v1beta1.MachineSetSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.MachineSetSpec)(nil), (*MachineSetSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_MachineSetSpec_To_v1alpha3_MachineSetSpec(a.(*v1beta1.MachineSetSpec), b.(*MachineSetSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineSetStatus)(nil), (*v1beta1.MachineSetStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_MachineSetStatus_To_v1beta1_MachineSetStatus(a.(*MachineSetStatus), b.(*v1beta1.MachineSetStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineSpec)(nil), (*v1beta1.MachineSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_MachineSpec_To_v1beta1_MachineSpec(a.(*MachineSpec), b.(*v1beta1.MachineSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.MachineSpec)(nil), (*MachineSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_MachineSpec_To_v1alpha3_MachineSpec(a.(*v1beta1.MachineSpec), b.(*MachineSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineStatus)(nil), (*v1beta1.MachineStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_MachineStatus_To_v1beta1_MachineStatus(a.(*MachineStatus), b.(*v1beta1.MachineStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineTemplateSpec)(nil), (*v1beta1.MachineTemplateSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_MachineTemplateSpec_To_v1beta1_MachineTemplateSpec(a.(*MachineTemplateSpec), b.(*v1beta1.MachineTemplateSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.MachineTemplateSpec)(nil), (*MachineTemplateSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_MachineTemplateSpec_To_v1alpha3_MachineTemplateSpec(a.(*v1beta1.MachineTemplateSpec), b.(*MachineTemplateSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*NetworkRanges)(nil), (*v1beta1.NetworkRanges)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_NetworkRanges_To_v1beta1_NetworkRanges(a.(*NetworkRanges), b.(*v1beta1.NetworkRanges), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.NetworkRanges)(nil), (*NetworkRanges)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_NetworkRanges_To_v1alpha3_NetworkRanges(a.(*v1beta1.NetworkRanges), b.(*NetworkRanges), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.ObjectMeta)(nil), (*ObjectMeta)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ObjectMeta_To_v1alpha3_ObjectMeta(a.(*v1beta1.ObjectMeta), b.(*ObjectMeta), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*UnhealthyCondition)(nil), (*v1beta1.UnhealthyCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_UnhealthyCondition_To_v1beta1_UnhealthyCondition(a.(*UnhealthyCondition), b.(*v1beta1.UnhealthyCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.UnhealthyCondition)(nil), (*UnhealthyCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_UnhealthyCondition_To_v1alpha3_UnhealthyCondition(a.(*v1beta1.UnhealthyCondition), b.(*UnhealthyCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*Bootstrap)(nil), (*v1beta1.Bootstrap)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_Bootstrap_To_v1beta1_Bootstrap(a.(*Bootstrap), b.(*v1beta1.Bootstrap), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*ClusterStatus)(nil), (*v1beta1.ClusterStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_ClusterStatus_To_v1beta1_ClusterStatus(a.(*ClusterStatus), b.(*v1beta1.ClusterStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*ObjectMeta)(nil), (*v1beta1.ObjectMeta)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_ObjectMeta_To_v1beta1_ObjectMeta(a.(*ObjectMeta), b.(*v1beta1.ObjectMeta), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*v1beta1.ClusterSpec)(nil), (*ClusterSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ClusterSpec_To_v1alpha3_ClusterSpec(a.(*v1beta1.ClusterSpec), b.(*ClusterSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*v1beta1.MachineDeploymentStatus)(nil), (*MachineDeploymentStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_MachineDeploymentStatus_To_v1alpha3_MachineDeploymentStatus(a.(*v1beta1.MachineDeploymentStatus), b.(*MachineDeploymentStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*v1beta1.MachineHealthCheckSpec)(nil), (*MachineHealthCheckSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_MachineHealthCheckSpec_To_v1alpha3_MachineHealthCheckSpec(a.(*v1beta1.MachineHealthCheckSpec), b.(*MachineHealthCheckSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*v1beta1.MachineRollingUpdateDeployment)(nil), (*MachineRollingUpdateDeployment)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_MachineRollingUpdateDeployment_To_v1alpha3_MachineRollingUpdateDeployment(a.(*v1beta1.MachineRollingUpdateDeployment), b.(*MachineRollingUpdateDeployment), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*v1beta1.MachineSetStatus)(nil), (*MachineSetStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_MachineSetStatus_To_v1alpha3_MachineSetStatus(a.(*v1beta1.MachineSetStatus), b.(*MachineSetStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*v1beta1.MachineStatus)(nil), (*MachineStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_MachineStatus_To_v1alpha3_MachineStatus(a.(*v1beta1.MachineStatus), b.(*MachineStatus), scope)
	}); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1alpha3_APIEndpoint_To_v1beta1_APIEndpoint(in *APIEndpoint, out *v1beta1.APIEndpoint, s conversion.Scope) error {
	out.Host = in.Host
	out.Port = in.Port
	return nil
}

// Convert_v1alpha3_APIEndpoint_To_v1beta1_APIEndpoint is an autogenerated conversion function.
func Convert_v1alpha3_APIEndpoint_To_v1beta1_APIEndpoint(in *APIEndpoint, out *v1beta1.APIEndpoint, s conversion.Scope) error {
	return autoConvert_v1alpha3_APIEndpoint_To_v1beta1_APIEndpoint(in, out, s)
}

func autoConvert_v1beta1_APIEndpoint_To_v1alpha3_APIEndpoint(in *v1beta1.APIEndpoint, out *APIEndpoint, s conversion.Scope) error {
	out.Host = in.Host
	out.Port = in.Port
	return nil
}

// Convert_v1beta1_APIEndpoint_To_v1alpha3_APIEndpoint is an autogenerated conversion function.
func Convert_v1beta1_APIEndpoint_To_v1alpha3_APIEndpoint(in *v1beta1.APIEndpoint, out *APIEndpoint, s conversion.Scope) error {
	return autoConvert_v1beta1_APIEndpoint_To_v1alpha3_APIEndpoint(in, out, s)
}

func autoConvert_v1alpha3_Bootstrap_To_v1beta1_Bootstrap(in *Bootstrap, out *v1beta1.Bootstrap, s conversion.Scope) error {
	out.ConfigRef = (*v1.ObjectReference)(unsafe.Pointer(in.ConfigRef))
	// WARNING: in.Data requires manual conversion: does not exist in peer-type
	out.DataSecretName = (*string)(unsafe.Pointer(in.DataSecretName))
	return nil
}

func autoConvert_v1beta1_Bootstrap_To_v1alpha3_Bootstrap(in *v1beta1.Bootstrap, out *Bootstrap, s conversion.Scope) error {
	out.ConfigRef = (*v1.ObjectReference)(unsafe.Pointer(in.ConfigRef))
	out.DataSecretName = (*string)(unsafe.Pointer(in.DataSecretName))
	return nil
}

// Convert_v1beta1_Bootstrap_To_v1alpha3_Bootstrap is an autogenerated conversion function.
func Convert_v1beta1_Bootstrap_To_v1alpha3_Bootstrap(in *v1beta1.Bootstrap, out *Bootstrap, s conversion.Scope) error {
	return autoConvert_v1beta1_Bootstrap_To_v1alpha3_Bootstrap(in, out, s)
}

func autoConvert_v1alpha3_Cluster_To_v1beta1_Cluster(in *Cluster, out *v1beta1.Cluster, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha3_ClusterSpec_To_v1beta1_ClusterSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha3_ClusterStatus_To_v1beta1_ClusterStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_Cluster_To_v1beta1_Cluster is an autogenerated conversion function.
func Convert_v1alpha3_Cluster_To_v1beta1_Cluster(in *Cluster, out *v1beta1.Cluster, s conversion.Scope) error {
	return autoConvert_v1alpha3_Cluster_To_v1beta1_Cluster(in, out, s)
}

func autoConvert_v1beta1_Cluster_To_v1alpha3_Cluster(in *v1beta1.Cluster, out *Cluster, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1beta1_ClusterSpec_To_v1alpha3_ClusterSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1beta1_ClusterStatus_To_v1alpha3_ClusterStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_Cluster_To_v1alpha3_Cluster is an autogenerated conversion function.
func Convert_v1beta1_Cluster_To_v1alpha3_Cluster(in *v1beta1.Cluster, out *Cluster, s conversion.Scope) error {
	return autoConvert_v1beta1_Cluster_To_v1alpha3_Cluster(in, out, s)
}

func autoConvert_v1alpha3_ClusterList_To_v1beta1_ClusterList(in *ClusterList, out *v1beta1.ClusterList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1beta1.Cluster, len(*in))
		for i := range *in {
			if err := Convert_v1alpha3_Cluster_To_v1beta1_Cluster(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha3_ClusterList_To_v1beta1_ClusterList is an autogenerated conversion function.
func Convert_v1alpha3_ClusterList_To_v1beta1_ClusterList(in *ClusterList, out *v1beta1.ClusterList, s conversion.Scope) error {
	return autoConvert_v1alpha3_ClusterList_To_v1beta1_ClusterList(in, out, s)
}

func autoConvert_v1beta1_ClusterList_To_v1alpha3_ClusterList(in *v1beta1.ClusterList, out *ClusterList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]Cluster, len(*in))
		for i := range *in {
			if err := Convert_v1beta1_Cluster_To_v1alpha3_Cluster(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1beta1_ClusterList_To_v1alpha3_ClusterList is an autogenerated conversion function.
func Convert_v1beta1_ClusterList_To_v1alpha3_ClusterList(in *v1beta1.ClusterList, out *ClusterList, s conversion.Scope) error {
	return autoConvert_v1beta1_ClusterList_To_v1alpha3_ClusterList(in, out, s)
}

func autoConvert_v1alpha3_ClusterNetwork_To_v1beta1_ClusterNetwork(in *ClusterNetwork, out *v1beta1.ClusterNetwork, s conversion.Scope) error {
	out.APIServerPort = (*int32)(unsafe.Pointer(in.APIServerPort))
	out.Services = (*v1beta1.NetworkRanges)(unsafe.Pointer(in.Services))
	out.Pods = (*v1beta1.NetworkRanges)(unsafe.Pointer(in.Pods))
	out.ServiceDomain = in.ServiceDomain
	return nil
}

// Convert_v1alpha3_ClusterNetwork_To_v1beta1_ClusterNetwork is an autogenerated conversion function.
func Convert_v1alpha3_ClusterNetwork_To_v1beta1_ClusterNetwork(in *ClusterNetwork, out *v1beta1.ClusterNetwork, s conversion.Scope) error {
	return autoConvert_v1alpha3_ClusterNetwork_To_v1beta1_ClusterNetwork(in, out, s)
}

func autoConvert_v1beta1_ClusterNetwork_To_v1alpha3_ClusterNetwork(in *v1beta1.ClusterNetwork, out *ClusterNetwork, s conversion.Scope) error {
	out.APIServerPort = (*int32)(unsafe.Pointer(in.APIServerPort))
	out.Services = (*NetworkRanges)(unsafe.Pointer(in.Services))
	out.Pods = (*NetworkRanges)(unsafe.Pointer(in.Pods))
	out.ServiceDomain = in.ServiceDomain
	return nil
}

// Convert_v1beta1_ClusterNetwork_To_v1alpha3_ClusterNetwork is an autogenerated conversion function.
func Convert_v1beta1_ClusterNetwork_To_v1alpha3_ClusterNetwork(in *v1beta1.ClusterNetwork, out *ClusterNetwork, s conversion.Scope) error {
	return autoConvert_v1beta1_ClusterNetwork_To_v1alpha3_ClusterNetwork(in, out, s)
}

func autoConvert_v1alpha3_ClusterSpec_To_v1beta1_ClusterSpec(in *ClusterSpec, out *v1beta1.ClusterSpec, s conversion.Scope) error {
	out.Paused = in.Paused
	out.ClusterNetwork = (*v1beta1.ClusterNetwork)(unsafe.Pointer(in.ClusterNetwork))
	if err := Convert_v1alpha3_APIEndpoint_To_v1beta1_APIEndpoint(&in.ControlPlaneEndpoint, &out.ControlPlaneEndpoint, s); err != nil {
		return err
	}
	out.ControlPlaneRef = (*v1.ObjectReference)(unsafe.Pointer(in.ControlPlaneRef))
	out.InfrastructureRef = (*v1.ObjectReference)(unsafe.Pointer(in.InfrastructureRef))
	return nil
}

// Convert_v1alpha3_ClusterSpec_To_v1beta1_ClusterSpec is an autogenerated conversion function.
func Convert_v1alpha3_ClusterSpec_To_v1beta1_ClusterSpec(in *ClusterSpec, out *v1beta1.ClusterSpec, s conversion.Scope) error {
	return autoConvert_v1alpha3_ClusterSpec_To_v1beta1_ClusterSpec(in, out, s)
}

func autoConvert_v1beta1_ClusterSpec_To_v1alpha3_ClusterSpec(in *v1beta1.ClusterSpec, out *ClusterSpec, s conversion.Scope) error {
	out.Paused = in.Paused
	out.ClusterNetwork = (*ClusterNetwork)(unsafe.Pointer(in.ClusterNetwork))
	if err := Convert_v1beta1_APIEndpoint_To_v1alpha3_APIEndpoint(&in.ControlPlaneEndpoint, &out.ControlPlaneEndpoint, s); err != nil {
		return err
	}
	out.ControlPlaneRef = (*v1.ObjectReference)(unsafe.Pointer(in.ControlPlaneRef))
	out.InfrastructureRef = (*v1.ObjectReference)(unsafe.Pointer(in.InfrastructureRef))
	// WARNING: in.Topology requires manual conversion: does not exist in peer-type
	return nil
}

func autoConvert_v1alpha3_ClusterStatus_To_v1beta1_ClusterStatus(in *ClusterStatus, out *v1beta1.ClusterStatus, s conversion.Scope) error {
	out.FailureDomains = *(*v1beta1.FailureDomains)(unsafe.Pointer(&in.FailureDomains))
	out.FailureReason = (*errors.ClusterStatusError)(unsafe.Pointer(in.FailureReason))
	out.FailureMessage = (*string)(unsafe.Pointer(in.FailureMessage))
	out.Phase = in.Phase
	out.InfrastructureReady = in.InfrastructureReady
	// WARNING: in.ControlPlaneInitialized requires manual conversion: does not exist in peer-type
	out.ControlPlaneReady = in.ControlPlaneReady
	out.Conditions = *(*v1beta1.Conditions)(unsafe.Pointer(&in.Conditions))
	out.ObservedGeneration = in.ObservedGeneration
	return nil
}

func autoConvert_v1beta1_ClusterStatus_To_v1alpha3_ClusterStatus(in *v1beta1.ClusterStatus, out *ClusterStatus, s conversion.Scope) error {
	out.FailureDomains = *(*FailureDomains)(unsafe.Pointer(&in.FailureDomains))
	out.FailureReason = (*errors.ClusterStatusError)(unsafe.Pointer(in.FailureReason))
	out.FailureMessage = (*string)(unsafe.Pointer(in.FailureMessage))
	out.Phase = in.Phase
	out.InfrastructureReady = in.InfrastructureReady
	out.ControlPlaneReady = in.ControlPlaneReady
	out.Conditions = *(*Conditions)(unsafe.Pointer(&in.Conditions))
	out.ObservedGeneration = in.ObservedGeneration
	return nil
}

// Convert_v1beta1_ClusterStatus_To_v1alpha3_ClusterStatus is an autogenerated conversion function.
func Convert_v1beta1_ClusterStatus_To_v1alpha3_ClusterStatus(in *v1beta1.ClusterStatus, out *ClusterStatus, s conversion.Scope) error {
	return autoConvert_v1beta1_ClusterStatus_To_v1alpha3_ClusterStatus(in, out, s)
}

func autoConvert_v1alpha3_Condition_To_v1beta1_Condition(in *Condition, out *v1beta1.Condition, s conversion.Scope) error {
	out.Type = v1beta1.ConditionType(in.Type)
	out.Status = v1.ConditionStatus(in.Status)
	out.Severity = v1beta1.ConditionSeverity(in.Severity)
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_v1alpha3_Condition_To_v1beta1_Condition is an autogenerated conversion function.
func Convert_v1alpha3_Condition_To_v1beta1_Condition(in *Condition, out *v1beta1.Condition, s conversion.Scope) error {
	return autoConvert_v1alpha3_Condition_To_v1beta1_Condition(in, out, s)
}

func autoConvert_v1beta1_Condition_To_v1alpha3_Condition(in *v1beta1.Condition, out *Condition, s conversion.Scope) error {
	out.Type = ConditionType(in.Type)
	out.Status = v1.ConditionStatus(in.Status)
	out.Severity = ConditionSeverity(in.Severity)
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_v1beta1_Condition_To_v1alpha3_Condition is an autogenerated conversion function.
func Convert_v1beta1_Condition_To_v1alpha3_Condition(in *v1beta1.Condition, out *Condition, s conversion.Scope) error {
	return autoConvert_v1beta1_Condition_To_v1alpha3_Condition(in, out, s)
}

func autoConvert_v1alpha3_FailureDomainSpec_To_v1beta1_FailureDomainSpec(in *FailureDomainSpec, out *v1beta1.FailureDomainSpec, s conversion.Scope) error {
	out.ControlPlane = in.ControlPlane
	out.Attributes = *(*map[string]string)(unsafe.Pointer(&in.Attributes))
	return nil
}

// Convert_v1alpha3_FailureDomainSpec_To_v1beta1_FailureDomainSpec is an autogenerated conversion function.
func Convert_v1alpha3_FailureDomainSpec_To_v1beta1_FailureDomainSpec(in *FailureDomainSpec, out *v1beta1.FailureDomainSpec, s conversion.Scope) error {
	return autoConvert_v1alpha3_FailureDomainSpec_To_v1beta1_FailureDomainSpec(in, out, s)
}

func autoConvert_v1beta1_FailureDomainSpec_To_v1alpha3_FailureDomainSpec(in *v1beta1.FailureDomainSpec, out *FailureDomainSpec, s conversion.Scope) error {
	out.ControlPlane = in.ControlPlane
	out.Attributes = *(*map[string]string)(unsafe.Pointer(&in.Attributes))
	return nil
}

// Convert_v1beta1_FailureDomainSpec_To_v1alpha3_FailureDomainSpec is an autogenerated conversion function.
func Convert_v1beta1_FailureDomainSpec_To_v1alpha3_FailureDomainSpec(in *v1beta1.FailureDomainSpec, out *FailureDomainSpec, s conversion.Scope) error {
	return autoConvert_v1beta1_FailureDomainSpec_To_v1alpha3_FailureDomainSpec(in, out, s)
}

func autoConvert_v1alpha3_Machine_To_v1beta1_Machine(in *Machine, out *v1beta1.Machine, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha3_MachineSpec_To_v1beta1_MachineSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha3_MachineStatus_To_v1beta1_MachineStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_Machine_To_v1beta1_Machine is an autogenerated conversion function.
func Convert_v1alpha3_Machine_To_v1beta1_Machine(in *Machine, out *v1beta1.Machine, s conversion.Scope) error {
	return autoConvert_v1alpha3_Machine_To_v1beta1_Machine(in, out, s)
}

func autoConvert_v1beta1_Machine_To_v1alpha3_Machine(in *v1beta1.Machine, out *Machine, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1beta1_MachineSpec_To_v1alpha3_MachineSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1beta1_MachineStatus_To_v1alpha3_MachineStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_Machine_To_v1alpha3_Machine is an autogenerated conversion function.
func Convert_v1beta1_Machine_To_v1alpha3_Machine(in *v1beta1.Machine, out *Machine, s conversion.Scope) error {
	return autoConvert_v1beta1_Machine_To_v1alpha3_Machine(in, out, s)
}

func autoConvert_v1alpha3_MachineAddress_To_v1beta1_MachineAddress(in *MachineAddress, out *v1beta1.MachineAddress, s conversion.Scope) error {
	out.Type = v1beta1.MachineAddressType(in.Type)
	out.Address = in.Address
	return nil
}

// Convert_v1alpha3_MachineAddress_To_v1beta1_MachineAddress is an autogenerated conversion function.
func Convert_v1alpha3_MachineAddress_To_v1beta1_MachineAddress(in *MachineAddress, out *v1beta1.MachineAddress, s conversion.Scope) error {
	return autoConvert_v1alpha3_MachineAddress_To_v1beta1_MachineAddress(in, out, s)
}

func autoConvert_v1beta1_MachineAddress_To_v1alpha3_MachineAddress(in *v1beta1.MachineAddress, out *MachineAddress, s conversion.Scope) error {
	out.Type = MachineAddressType(in.Type)
	out.Address = in.Address
	return nil
}

// Convert_v1beta1_MachineAddress_To_v1alpha3_MachineAddress is an autogenerated conversion function.
func Convert_v1beta1_MachineAddress_To_v1alpha3_MachineAddress(in *v1beta1.MachineAddress, out *MachineAddress, s conversion.Scope) error {
	return autoConvert_v1beta1_MachineAddress_To_v1alpha3_MachineAddress(in, out, s)
}

func autoConvert_v1alpha3_MachineDeployment_To_v1beta1_MachineDeployment(in *MachineDeployment, out *v1beta1.MachineDeployment, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha3_MachineDeploymentSpec_To_v1beta1_MachineDeploymentSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha3_MachineDeploymentStatus_To_v1beta1_MachineDeploymentStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_MachineDeployment_To_v1beta1_MachineDeployment is an autogenerated conversion function.
func Convert_v1alpha3_MachineDeployment_To_v1beta1_MachineDeployment(in *MachineDeployment, out *v1beta1.MachineDeployment, s conversion.Scope) error {
	return autoConvert_v1alpha3_MachineDeployment_To_v1beta1_MachineDeployment(in, out, s)
}

func autoConvert_v1beta1_MachineDeployment_To_v1alpha3_MachineDeployment(in *v1beta1.MachineDeployment, out *MachineDeployment, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1beta1_MachineDeploymentSpec_To_v1alpha3_MachineDeploymentSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1beta1_MachineDeploymentStatus_To_v1alpha3_MachineDeploymentStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_MachineDeployment_To_v1alpha3_MachineDeployment is an autogenerated conversion function.
func Convert_v1beta1_MachineDeployment_To_v1alpha3_MachineDeployment(in *v1beta1.MachineDeployment, out *MachineDeployment, s conversion.Scope) error {
	return autoConvert_v1beta1_MachineDeployment_To_v1alpha3_MachineDeployment(in, out, s)
}

func autoConvert_v1alpha3_MachineDeploymentList_To_v1beta1_MachineDeploymentList(in *MachineDeploymentList, out *v1beta1.MachineDeploymentList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1beta1.MachineDeployment, len(*in))
		for i := range *in {
			if err := Convert_v1alpha3_MachineDeployment_To_v1beta1_MachineDeployment(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha3_MachineDeploymentList_To_v1beta1_MachineDeploymentList is an autogenerated conversion function.
func Convert_v1alpha3_MachineDeploymentList_To_v1beta1_MachineDeploymentList(in *MachineDeploymentList, out *v1beta1.MachineDeploymentList, s conversion.Scope) error {
	return autoConvert_v1alpha3_MachineDeploymentList_To_v1beta1_MachineDeploymentList(in, out, s)
}

func autoConvert_v1beta1_MachineDeploymentList_To_v1alpha3_MachineDeploymentList(in *v1beta1.MachineDeploymentList, out *MachineDeploymentList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]MachineDeployment, len(*in))
		for i := range *in {
			if err := Convert_v1beta1_MachineDeployment_To_v1alpha3_MachineDeployment(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1beta1_MachineDeploymentList_To_v1alpha3_MachineDeploymentList is an autogenerated conversion function.
func Convert_v1beta1_MachineDeploymentList_To_v1alpha3_MachineDeploymentList(in *v1beta1.MachineDeploymentList, out *MachineDeploymentList, s conversion.Scope) error {
	return autoConvert_v1beta1_MachineDeploymentList_To_v1alpha3_MachineDeploymentList(in, out, s)
}

func autoConvert_v1alpha3_MachineDeploymentSpec_To_v1beta1_MachineDeploymentSpec(in *MachineDeploymentSpec, out *v1beta1.MachineDeploymentSpec, s conversion.Scope) error {
	out.ClusterName = in.ClusterName
	out.Replicas = (*int32)(unsafe.Pointer(in.Replicas))
	out.Selector = in.Selector
	if err := Convert_v1alpha3_MachineTemplateSpec_To_v1beta1_MachineTemplateSpec(&in.Template, &out.Template, s); err != nil {
		return err
	}
	if in.Strategy != nil {
		in, out := &in.Strategy, &out.Strategy
		*out = new(v1beta1.MachineDeploymentStrategy)
		if err := Convert_v1alpha3_MachineDeploymentStrategy_To_v1beta1_MachineDeploymentStrategy(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Strategy = nil
	}
	out.MinReadySeconds = (*int32)(unsafe.Pointer(in.MinReadySeconds))
	out.RevisionHistoryLimit = (*int32)(unsafe.Pointer(in.RevisionHistoryLimit))
	out.Paused = in.Paused
	out.ProgressDeadlineSeconds = (*int32)(unsafe.Pointer(in.ProgressDeadlineSeconds))
	return nil
}

// Convert_v1alpha3_MachineDeploymentSpec_To_v1beta1_MachineDeploymentSpec is an autogenerated conversion function.
func Convert_v1alpha3_MachineDeploymentSpec_To_v1beta1_MachineDeploymentSpec(in *MachineDeploymentSpec, out *v1beta1.MachineDeploymentSpec, s conversion.Scope) error {
	return autoConvert_v1alpha3_MachineDeploymentSpec_To_v1beta1_MachineDeploymentSpec(in, out, s)
}

func autoConvert_v1beta1_MachineDeploymentSpec_To_v1alpha3_MachineDeploymentSpec(in *v1beta1.MachineDeploymentSpec, out *MachineDeploymentSpec, s conversion.Scope) error {
	out.ClusterName = in.ClusterName
	out.Replicas = (*int32)(unsafe.Pointer(in.Replicas))
	out.Selector = in.Selector
	if err := Convert_v1beta1_MachineTemplateSpec_To_v1alpha3_MachineTemplateSpec(&in.Template, &out.Template, s); err != nil {
		return err
	}
	if in.Strategy != nil {
		in, out := &in.Strategy, &out.Strategy
		*out = new(MachineDeploymentStrategy)
		if err := Convert_v1beta1_MachineDeploymentStrategy_To_v1alpha3_MachineDeploymentStrategy(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Strategy = nil
	}
	out.MinReadySeconds = (*int32)(unsafe.Pointer(in.MinReadySeconds))
	out.RevisionHistoryLimit = (*int32)(unsafe.Pointer(in.RevisionHistoryLimit))
	out.Paused = in.Paused
	out.ProgressDeadlineSeconds = (*int32)(unsafe.Pointer(in.ProgressDeadlineSeconds))
	return nil
}

// Convert_v1beta1_MachineDeploymentSpec_To_v1alpha3_MachineDeploymentSpec is an autogenerated conversion function.
func Convert_v1beta1_MachineDeploymentSpec_To_v1alpha3_MachineDeploymentSpec(in *v1beta1.MachineDeploymentSpec, out *MachineDeploymentSpec, s conversion.Scope) error {
	return autoConvert_v1beta1_MachineDeploymentSpec_To_v1alpha3_MachineDeploymentSpec(in, out, s)
}

func autoConvert_v1alpha3_MachineDeploymentStatus_To_v1beta1_MachineDeploymentStatus(in *MachineDeploymentStatus, out *v1beta1.MachineDeploymentStatus, s conversion.Scope) error {
	out.ObservedGeneration = in.ObservedGeneration
	out.Selector = in.Selector
	out.Replicas = in.Replicas
	out.UpdatedReplicas = in.UpdatedReplicas
	out.ReadyReplicas = in.ReadyReplicas
	out.AvailableReplicas = in.AvailableReplicas
	out.UnavailableReplicas = in.UnavailableReplicas
	out.Phase = in.Phase
	return nil
}

// Convert_v1alpha3_MachineDeploymentStatus_To_v1beta1_MachineDeploymentStatus is an autogenerated conversion function.
func Convert_v1alpha3_MachineDeploymentStatus_To_v1beta1_MachineDeploymentStatus(in *MachineDeploymentStatus, out *v1beta1.MachineDeploymentStatus, s conversion.Scope) error {
	return autoConvert_v1alpha3_MachineDeploymentStatus_To_v1beta1_MachineDeploymentStatus(in, out, s)
}

func autoConvert_v1beta1_MachineDeploymentStatus_To_v1alpha3_MachineDeploymentStatus(in *v1beta1.MachineDeploymentStatus, out *MachineDeploymentStatus, s conversion.Scope) error {
	out.ObservedGeneration = in.ObservedGeneration
	out.Selector = in.Selector
	out.Replicas = in.Replicas
	out.UpdatedReplicas = in.UpdatedReplicas
	out.ReadyReplicas = in.ReadyReplicas
	out.AvailableReplicas = in.AvailableReplicas
	out.UnavailableReplicas = in.UnavailableReplicas
	out.Phase = in.Phase
	// WARNING: in.Conditions requires manual conversion: does not exist in peer-type
	return nil
}

func autoConvert_v1alpha3_MachineDeploymentStrategy_To_v1beta1_MachineDeploymentStrategy(in *MachineDeploymentStrategy, out *v1beta1.MachineDeploymentStrategy, s conversion.Scope) error {
	out.Type = v1beta1.MachineDeploymentStrategyType(in.Type)
	if in.RollingUpdate != nil {
		in, out := &in.RollingUpdate, &out.RollingUpdate
		*out = new(v1beta1.MachineRollingUpdateDeployment)
		if err := Convert_v1alpha3_MachineRollingUpdateDeployment_To_v1beta1_MachineRollingUpdateDeployment(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.RollingUpdate = nil
	}
	return nil
}

// Convert_v1alpha3_MachineDeploymentStrategy_To_v1beta1_MachineDeploymentStrategy is an autogenerated conversion function.
func Convert_v1alpha3_MachineDeploymentStrategy_To_v1beta1_MachineDeploymentStrategy(in *MachineDeploymentStrategy, out *v1beta1.MachineDeploymentStrategy, s conversion.Scope) error {
	return autoConvert_v1alpha3_MachineDeploymentStrategy_To_v1beta1_MachineDeploymentStrategy(in, out, s)
}

func autoConvert_v1beta1_MachineDeploymentStrategy_To_v1alpha3_MachineDeploymentStrategy(in *v1beta1.MachineDeploymentStrategy, out *MachineDeploymentStrategy, s conversion.Scope) error {
	out.Type = MachineDeploymentStrategyType(in.Type)
	if in.RollingUpdate != nil {
		in, out := &in.RollingUpdate, &out.RollingUpdate
		*out = new(MachineRollingUpdateDeployment)
		if err := Convert_v1beta1_MachineRollingUpdateDeployment_To_v1alpha3_MachineRollingUpdateDeployment(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.RollingUpdate = nil
	}
	return nil
}

// Convert_v1beta1_MachineDeploymentStrategy_To_v1alpha3_MachineDeploymentStrategy is an autogenerated conversion function.
func Convert_v1beta1_MachineDeploymentStrategy_To_v1alpha3_MachineDeploymentStrategy(in *v1beta1.MachineDeploymentStrategy, out *MachineDeploymentStrategy, s conversion.Scope) error {
	return autoConvert_v1beta1_MachineDeploymentStrategy_To_v1alpha3_MachineDeploymentStrategy(in, out, s)
}

func autoConvert_v1alpha3_MachineHealthCheck_To_v1beta1_MachineHealthCheck(in *MachineHealthCheck, out *v1beta1.MachineHealthCheck, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha3_MachineHealthCheckSpec_To_v1beta1_MachineHealthCheckSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha3_MachineHealthCheckStatus_To_v1beta1_MachineHealthCheckStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_MachineHealthCheck_To_v1beta1_MachineHealthCheck is an autogenerated conversion function.
func Convert_v1alpha3_MachineHealthCheck_To_v1beta1_MachineHealthCheck(in *MachineHealthCheck, out *v1beta1.MachineHealthCheck, s conversion.Scope) error {
	return autoConvert_v1alpha3_MachineHealthCheck_To_v1beta1_MachineHealthCheck(in, out, s)
}

func autoConvert_v1beta1_MachineHealthCheck_To_v1alpha3_MachineHealthCheck(in *v1beta1.MachineHealthCheck, out *MachineHealthCheck, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1beta1_MachineHealthCheckSpec_To_v1alpha3_MachineHealthCheckSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1beta1_MachineHealthCheckStatus_To_v1alpha3_MachineHealthCheckStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_MachineHealthCheck_To_v1alpha3_MachineHealthCheck is an autogenerated conversion function.
func Convert_v1beta1_MachineHealthCheck_To_v1alpha3_MachineHealthCheck(in *v1beta1.MachineHealthCheck, out *MachineHealthCheck, s conversion.Scope) error {
	return autoConvert_v1beta1_MachineHealthCheck_To_v1alpha3_MachineHealthCheck(in, out, s)
}

func autoConvert_v1alpha3_MachineHealthCheckList_To_v1beta1_MachineHealthCheckList(in *MachineHealthCheckList, out *v1beta1.MachineHealthCheckList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1beta1.MachineHealthCheck, len(*in))
		for i := range *in {
			if err := Convert_v1alpha3_MachineHealthCheck_To_v1beta1_MachineHealthCheck(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha3_MachineHealthCheckList_To_v1beta1_MachineHealthCheckList is an autogenerated conversion function.
func Convert_v1alpha3_MachineHealthCheckList_To_v1beta1_MachineHealthCheckList(in *MachineHealthCheckList, out *v1beta1.MachineHealthCheckList, s conversion.Scope) error {
	return autoConvert_v1alpha3_MachineHealthCheckList_To_v1beta1_MachineHealthCheckList(in, out, s)
}

func autoConvert_v1beta1_MachineHealthCheckList_To_v1alpha3_MachineHealthCheckList(in *v1beta1.MachineHealthCheckList, out *MachineHealthCheckList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]MachineHealthCheck, len(*in))
		for i := range *in {
			if err := Convert_v1beta1_MachineHealthCheck_To_v1alpha3_MachineHealthCheck(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1beta1_MachineHealthCheckList_To_v1alpha3_MachineHealthCheckList is an autogenerated conversion function.
func Convert_v1beta1_MachineHealthCheckList_To_v1alpha3_MachineHealthCheckList(in *v1beta1.MachineHealthCheckList, out *MachineHealthCheckList, s conversion.Scope) error {
	return autoConvert_v1beta1_MachineHealthCheckList_To_v1alpha3_MachineHealthCheckList(in, out, s)
}

func autoConvert_v1alpha3_MachineHealthCheckSpec_To_v1beta1_MachineHealthCheckSpec(in *MachineHealthCheckSpec, out *v1beta1.MachineHealthCheckSpec, s conversion.Scope) error {
	out.ClusterName = in.ClusterName
	out.Selector = in.Selector
	out.UnhealthyConditions = *(*[]v1beta1.UnhealthyCondition)(unsafe.Pointer(&in.UnhealthyConditions))
	out.MaxUnhealthy = (*intstr.IntOrString)(unsafe.Pointer(in.MaxUnhealthy))
	out.NodeStartupTimeout = (*metav1.Duration)(unsafe.Pointer(in.NodeStartupTimeout))
	out.RemediationTemplate = (*v1.ObjectReference)(unsafe.Pointer(in.RemediationTemplate))
	return nil
}

// Convert_v1alpha3_MachineHealthCheckSpec_To_v1beta1_MachineHealthCheckSpec is an autogenerated conversion function.
func Convert_v1alpha3_MachineHealthCheckSpec_To_v1beta1_MachineHealthCheckSpec(in *MachineHealthCheckSpec, out *v1beta1.MachineHealthCheckSpec, s conversion.Scope) error {
	return autoConvert_v1alpha3_MachineHealthCheckSpec_To_v1beta1_MachineHealthCheckSpec(in, out, s)
}

func autoConvert_v1beta1_MachineHealthCheckSpec_To_v1alpha3_MachineHealthCheckSpec(in *v1beta1.MachineHealthCheckSpec, out *MachineHealthCheckSpec, s conversion.Scope) error {
	out.ClusterName = in.ClusterName
	out.Selector = in.Selector
	out.UnhealthyConditions = *(*[]UnhealthyCondition)(unsafe.Pointer(&in.UnhealthyConditions))
	out.MaxUnhealthy = (*intstr.IntOrString)(unsafe.Pointer(in.MaxUnhealthy))
	// WARNING: in.UnhealthyRange requires manual conversion: does not exist in peer-type
	out.NodeStartupTimeout = (*metav1.Duration)(unsafe.Pointer(in.NodeStartupTimeout))
	out.RemediationTemplate = (*v1.ObjectReference)(unsafe.Pointer(in.RemediationTemplate))
	return nil
}

func autoConvert_v1alpha3_MachineHealthCheckStatus_To_v1beta1_MachineHealthCheckStatus(in *MachineHealthCheckStatus, out *v1beta1.MachineHealthCheckStatus, s conversion.Scope) error {
	out.ExpectedMachines = in.ExpectedMachines
	out.CurrentHealthy = in.CurrentHealthy
	out.RemediationsAllowed = in.RemediationsAllowed
	out.ObservedGeneration = in.ObservedGeneration
	out.Targets = *(*[]string)(unsafe.Pointer(&in.Targets))
	out.Conditions = *(*v1beta1.Conditions)(unsafe.Pointer(&in.Conditions))
	return nil
}

// Convert_v1alpha3_MachineHealthCheckStatus_To_v1beta1_MachineHealthCheckStatus is an autogenerated conversion function.
func Convert_v1alpha3_MachineHealthCheckStatus_To_v1beta1_MachineHealthCheckStatus(in *MachineHealthCheckStatus, out *v1beta1.MachineHealthCheckStatus, s conversion.Scope) error {
	return autoConvert_v1alpha3_MachineHealthCheckStatus_To_v1beta1_MachineHealthCheckStatus(in, out, s)
}

func autoConvert_v1beta1_MachineHealthCheckStatus_To_v1alpha3_MachineHealthCheckStatus(in *v1beta1.MachineHealthCheckStatus, out *MachineHealthCheckStatus, s conversion.Scope) error {
	out.ExpectedMachines = in.ExpectedMachines
	out.CurrentHealthy = in.CurrentHealthy
	out.RemediationsAllowed = in.RemediationsAllowed
	out.ObservedGeneration = in.ObservedGeneration
	out.Targets = *(*[]string)(unsafe.Pointer(&in.Targets))
	out.Conditions = *(*Conditions)(unsafe.Pointer(&in.Conditions))
	return nil
}

// Convert_v1beta1_MachineHealthCheckStatus_To_v1alpha3_MachineHealthCheckStatus is an autogenerated conversion function.
func Convert_v1beta1_MachineHealthCheckStatus_To_v1alpha3_MachineHealthCheckStatus(in *v1beta1.MachineHealthCheckStatus, out *MachineHealthCheckStatus, s conversion.Scope) error {
	return autoConvert_v1beta1_MachineHealthCheckStatus_To_v1alpha3_MachineHealthCheckStatus(in, out, s)
}

func autoConvert_v1alpha3_MachineList_To_v1beta1_MachineList(in *MachineList, out *v1beta1.MachineList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1beta1.Machine, len(*in))
		for i := range *in {
			if err := Convert_v1alpha3_Machine_To_v1beta1_Machine(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha3_MachineList_To_v1beta1_MachineList is an autogenerated conversion function.
func Convert_v1alpha3_MachineList_To_v1beta1_MachineList(in *MachineList, out *v1beta1.MachineList, s conversion.Scope) error {
	return autoConvert_v1alpha3_MachineList_To_v1beta1_MachineList(in, out, s)
}

func autoConvert_v1beta1_MachineList_To_v1alpha3_MachineList(in *v1beta1.MachineList, out *MachineList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]Machine, len(*in))
		for i := range *in {
			if err := Convert_v1beta1_Machine_To_v1alpha3_Machine(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1beta1_MachineList_To_v1alpha3_MachineList is an autogenerated conversion function.
func Convert_v1beta1_MachineList_To_v1alpha3_MachineList(in *v1beta1.MachineList, out *MachineList, s conversion.Scope) error {
	return autoConvert_v1beta1_MachineList_To_v1alpha3_MachineList(in, out, s)
}

func autoConvert_v1alpha3_MachineRollingUpdateDeployment_To_v1beta1_MachineRollingUpdateDeployment(in *MachineRollingUpdateDeployment, out *v1beta1.MachineRollingUpdateDeployment, s conversion.Scope) error {
	out.MaxUnavailable = (*intstr.IntOrString)(unsafe.Pointer(in.MaxUnavailable))
	out.MaxSurge = (*intstr.IntOrString)(unsafe.Pointer(in.MaxSurge))
	return nil
}

// Convert_v1alpha3_MachineRollingUpdateDeployment_To_v1beta1_MachineRollingUpdateDeployment is an autogenerated conversion function.
func Convert_v1alpha3_MachineRollingUpdateDeployment_To_v1beta1_MachineRollingUpdateDeployment(in *MachineRollingUpdateDeployment, out *v1beta1.MachineRollingUpdateDeployment, s conversion.Scope) error {
	return autoConvert_v1alpha3_MachineRollingUpdateDeployment_To_v1beta1_MachineRollingUpdateDeployment(in, out, s)
}

func autoConvert_v1beta1_MachineRollingUpdateDeployment_To_v1alpha3_MachineRollingUpdateDeployment(in *v1beta1.MachineRollingUpdateDeployment, out *MachineRollingUpdateDeployment, s conversion.Scope) error {
	out.MaxUnavailable = (*intstr.IntOrString)(unsafe.Pointer(in.MaxUnavailable))
	out.MaxSurge = (*intstr.IntOrString)(unsafe.Pointer(in.MaxSurge))
	// WARNING: in.DeletePolicy requires manual conversion: does not exist in peer-type
	return nil
}

func autoConvert_v1alpha3_MachineSet_To_v1beta1_MachineSet(in *MachineSet, out *v1beta1.MachineSet, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha3_MachineSetSpec_To_v1beta1_MachineSetSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha3_MachineSetStatus_To_v1beta1_MachineSetStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_MachineSet_To_v1beta1_MachineSet is an autogenerated conversion function.
func Convert_v1alpha3_MachineSet_To_v1beta1_MachineSet(in *MachineSet, out *v1beta1.MachineSet, s conversion.Scope) error {
	return autoConvert_v1alpha3_MachineSet_To_v1beta1_MachineSet(in, out, s)
}

func autoConvert_v1beta1_MachineSet_To_v1alpha3_MachineSet(in *v1beta1.MachineSet, out *MachineSet, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1beta1_MachineSetSpec_To_v1alpha3_MachineSetSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1beta1_MachineSetStatus_To_v1alpha3_MachineSetStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_MachineSet_To_v1alpha3_MachineSet is an autogenerated conversion function.
func Convert_v1beta1_MachineSet_To_v1alpha3_MachineSet(in *v1beta1.MachineSet, out *MachineSet, s conversion.Scope) error {
	return autoConvert_v1beta1_MachineSet_To_v1alpha3_MachineSet(in, out, s)
}

func autoConvert_v1alpha3_MachineSetList_To_v1beta1_MachineSetList(in *MachineSetList, out *v1beta1.MachineSetList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1beta1.MachineSet, len(*in))
		for i := range *in {
			if err := Convert_v1alpha3_MachineSet_To_v1beta1_MachineSet(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha3_MachineSetList_To_v1beta1_MachineSetList is an autogenerated conversion function.
func Convert_v1alpha3_MachineSetList_To_v1beta1_MachineSetList(in *MachineSetList, out *v1beta1.MachineSetList, s conversion.Scope) error {
	return autoConvert_v1alpha3_MachineSetList_To_v1beta1_MachineSetList(in, out, s)
}

func autoConvert_v1beta1_MachineSetList_To_v1alpha3_MachineSetList(in *v1beta1.MachineSetList, out *MachineSetList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]MachineSet, len(*in))
		for i := range *in {
			if err := Convert_v1beta1_MachineSet_To_v1alpha3_MachineSet(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1beta1_MachineSetList_To_v1alpha3_MachineSetList is an autogenerated conversion function.
func Convert_v1beta1_MachineSetList_To_v1alpha3_MachineSetList(in *v1beta1.MachineSetList, out *MachineSetList, s conversion.Scope) error {
	return autoConvert_v1beta1_MachineSetList_To_v1alpha3_MachineSetList(in, out, s)
}

func autoConvert_v1alpha3_MachineSetSpec_To_v1beta1_MachineSetSpec(in *MachineSetSpec, out *v1beta1.MachineSetSpec, s conversion.Scope) error {
	out.ClusterName = in.ClusterName
	out.Replicas = (*int32)(unsafe.Pointer(in.Replicas))
	out.MinReadySeconds = in.MinReadySeconds
	out.DeletePolicy = in.DeletePolicy
	out.Selector = in.Selector
	if err := Convert_v1alpha3_MachineTemplateSpec_To_v1beta1_MachineTemplateSpec(&in.Template, &out.Template, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_MachineSetSpec_To_v1beta1_MachineSetSpec is an autogenerated conversion function.
func Convert_v1alpha3_MachineSetSpec_To_v1beta1_MachineSetSpec(in *MachineSetSpec, out *v1beta1.MachineSetSpec, s conversion.Scope) error {
	return autoConvert_v1alpha3_MachineSetSpec_To_v1beta1_MachineSetSpec(in, out, s)
}

func autoConvert_v1beta1_MachineSetSpec_To_v1alpha3_MachineSetSpec(in *v1beta1.MachineSetSpec, out *MachineSetSpec, s conversion.Scope) error {
	out.ClusterName = in.ClusterName
	out.Replicas = (*int32)(unsafe.Pointer(in.Replicas))
	out.MinReadySeconds = in.MinReadySeconds
	out.DeletePolicy = in.DeletePolicy
	out.Selector = in.Selector
	if err := Convert_v1beta1_MachineTemplateSpec_To_v1alpha3_MachineTemplateSpec(&in.Template, &out.Template, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_MachineSetSpec_To_v1alpha3_MachineSetSpec is an autogenerated conversion function.
func Convert_v1beta1_MachineSetSpec_To_v1alpha3_MachineSetSpec(in *v1beta1.MachineSetSpec, out *MachineSetSpec, s conversion.Scope) error {
	return autoConvert_v1beta1_MachineSetSpec_To_v1alpha3_MachineSetSpec(in, out, s)
}

func autoConvert_v1alpha3_MachineSetStatus_To_v1beta1_MachineSetStatus(in *MachineSetStatus, out *v1beta1.MachineSetStatus, s conversion.Scope) error {
	out.Selector = in.Selector
	out.Replicas = in.Replicas
	out.FullyLabeledReplicas = in.FullyLabeledReplicas
	out.ReadyReplicas = in.ReadyReplicas
	out.AvailableReplicas = in.AvailableReplicas
	out.ObservedGeneration = in.ObservedGeneration
	out.FailureReason = (*errors.MachineSetStatusError)(unsafe.Pointer(in.FailureReason))
	out.FailureMessage = (*string)(unsafe.Pointer(in.FailureMessage))
	return nil
}

// Convert_v1alpha3_MachineSetStatus_To_v1beta1_MachineSetStatus is an autogenerated conversion function.
func Convert_v1alpha3_MachineSetStatus_To_v1beta1_MachineSetStatus(in *MachineSetStatus, out *v1beta1.MachineSetStatus, s conversion.Scope) error {
	return autoConvert_v1alpha3_MachineSetStatus_To_v1beta1_MachineSetStatus(in, out, s)
}

func autoConvert_v1beta1_MachineSetStatus_To_v1alpha3_MachineSetStatus(in *v1beta1.MachineSetStatus, out *MachineSetStatus, s conversion.Scope) error {
	out.Selector = in.Selector
	out.Replicas = in.Replicas
	out.FullyLabeledReplicas = in.FullyLabeledReplicas
	out.ReadyReplicas = in.ReadyReplicas
	out.AvailableReplicas = in.AvailableReplicas
	out.ObservedGeneration = in.ObservedGeneration
	out.FailureReason = (*errors.MachineSetStatusError)(unsafe.Pointer(in.FailureReason))
	out.FailureMessage = (*string)(unsafe.Pointer(in.FailureMessage))
	// WARNING: in.Conditions requires manual conversion: does not exist in peer-type
	return nil
}

func autoConvert_v1alpha3_MachineSpec_To_v1beta1_MachineSpec(in *MachineSpec, out *v1beta1.MachineSpec, s conversion.Scope) error {
	out.ClusterName = in.ClusterName
	if err := Convert_v1alpha3_Bootstrap_To_v1beta1_Bootstrap(&in.Bootstrap, &out.Bootstrap, s); err != nil {
		return err
	}
	out.InfrastructureRef = in.InfrastructureRef
	out.Version = (*string)(unsafe.Pointer(in.Version))
	out.ProviderID = (*string)(unsafe.Pointer(in.ProviderID))
	out.FailureDomain = (*string)(unsafe.Pointer(in.FailureDomain))
	out.NodeDrainTimeout = (*metav1.Duration)(unsafe.Pointer(in.NodeDrainTimeout))
	return nil
}

// Convert_v1alpha3_MachineSpec_To_v1beta1_MachineSpec is an autogenerated conversion function.
func Convert_v1alpha3_MachineSpec_To_v1beta1_MachineSpec(in *MachineSpec, out *v1beta1.MachineSpec, s conversion.Scope) error {
	return autoConvert_v1alpha3_MachineSpec_To_v1beta1_MachineSpec(in, out, s)
}

func autoConvert_v1beta1_MachineSpec_To_v1alpha3_MachineSpec(in *v1beta1.MachineSpec, out *MachineSpec, s conversion.Scope) error {
	out.ClusterName = in.ClusterName
	if err := Convert_v1beta1_Bootstrap_To_v1alpha3_Bootstrap(&in.Bootstrap, &out.Bootstrap, s); err != nil {
		return err
	}
	out.InfrastructureRef = in.InfrastructureRef
	out.Version = (*string)(unsafe.Pointer(in.Version))
	out.ProviderID = (*string)(unsafe.Pointer(in.ProviderID))
	out.FailureDomain = (*string)(unsafe.Pointer(in.FailureDomain))
	out.NodeDrainTimeout = (*metav1.Duration)(unsafe.Pointer(in.NodeDrainTimeout))
	return nil
}

// Convert_v1beta1_MachineSpec_To_v1alpha3_MachineSpec is an autogenerated conversion function.
func Convert_v1beta1_MachineSpec_To_v1alpha3_MachineSpec(in *v1beta1.MachineSpec, out *MachineSpec, s conversion.Scope) error {
	return autoConvert_v1beta1_MachineSpec_To_v1alpha3_MachineSpec(in, out, s)
}

func autoConvert_v1alpha3_MachineStatus_To_v1beta1_MachineStatus(in *MachineStatus, out *v1beta1.MachineStatus, s conversion.Scope) error {
	out.NodeRef = (*v1.ObjectReference)(unsafe.Pointer(in.NodeRef))
	out.LastUpdated = (*metav1.Time)(unsafe.Pointer(in.LastUpdated))
	out.Version = (*string)(unsafe.Pointer(in.Version))
	out.FailureReason = (*errors.MachineStatusError)(unsafe.Pointer(in.FailureReason))
	out.FailureMessage = (*string)(unsafe.Pointer(in.FailureMessage))
	out.Addresses = *(*v1beta1.MachineAddresses)(unsafe.Pointer(&in.Addresses))
	out.Phase = in.Phase
	out.BootstrapReady = in.BootstrapReady
	out.InfrastructureReady = in.InfrastructureReady
	out.ObservedGeneration = in.ObservedGeneration
	out.Conditions = *(*v1beta1.Conditions)(unsafe.Pointer(&in.Conditions))
	return nil
}

// Convert_v1alpha3_MachineStatus_To_v1beta1_MachineStatus is an autogenerated conversion function.
func Convert_v1alpha3_MachineStatus_To_v1beta1_MachineStatus(in *MachineStatus, out *v1beta1.MachineStatus, s conversion.Scope) error {
	return autoConvert_v1alpha3_MachineStatus_To_v1beta1_MachineStatus(in, out, s)
}

func autoConvert_v1beta1_MachineStatus_To_v1alpha3_MachineStatus(in *v1beta1.MachineStatus, out *MachineStatus, s conversion.Scope) error {
	out.NodeRef = (*v1.ObjectReference)(unsafe.Pointer(in.NodeRef))
	// WARNING: in.NodeInfo requires manual conversion: does not exist in peer-type
	out.LastUpdated = (*metav1.Time)(unsafe.Pointer(in.LastUpdated))
	out.Version = (*string)(unsafe.Pointer(in.Version))
	out.FailureReason = (*errors.MachineStatusError)(unsafe.Pointer(in.FailureReason))
	out.FailureMessage = (*string)(unsafe.Pointer(in.FailureMessage))
	out.Addresses = *(*MachineAddresses)(unsafe.Pointer(&in.Addresses))
	out.Phase = in.Phase
	out.BootstrapReady = in.BootstrapReady
	out.InfrastructureReady = in.InfrastructureReady
	out.ObservedGeneration = in.ObservedGeneration
	out.Conditions = *(*Conditions)(unsafe.Pointer(&in.Conditions))
	return nil
}

func autoConvert_v1alpha3_MachineTemplateSpec_To_v1beta1_MachineTemplateSpec(in *MachineTemplateSpec, out *v1beta1.MachineTemplateSpec, s conversion.Scope) error {
	if err := Convert_v1alpha3_ObjectMeta_To_v1beta1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	if err := Convert_v1alpha3_MachineSpec_To_v1beta1_MachineSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_MachineTemplateSpec_To_v1beta1_MachineTemplateSpec is an autogenerated conversion function.
func Convert_v1alpha3_MachineTemplateSpec_To_v1beta1_MachineTemplateSpec(in *MachineTemplateSpec, out *v1beta1.MachineTemplateSpec, s conversion.Scope) error {
	return autoConvert_v1alpha3_MachineTemplateSpec_To_v1beta1_MachineTemplateSpec(in, out, s)
}

func autoConvert_v1beta1_MachineTemplateSpec_To_v1alpha3_MachineTemplateSpec(in *v1beta1.MachineTemplateSpec, out *MachineTemplateSpec, s conversion.Scope) error {
	if err := Convert_v1beta1_ObjectMeta_To_v1alpha3_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	if err := Convert_v1beta1_MachineSpec_To_v1alpha3_MachineSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_MachineTemplateSpec_To_v1alpha3_MachineTemplateSpec is an autogenerated conversion function.
func Convert_v1beta1_MachineTemplateSpec_To_v1alpha3_MachineTemplateSpec(in *v1beta1.MachineTemplateSpec, out *MachineTemplateSpec, s conversion.Scope) error {
	return autoConvert_v1beta1_MachineTemplateSpec_To_v1alpha3_MachineTemplateSpec(in, out, s)
}

func autoConvert_v1alpha3_NetworkRanges_To_v1beta1_NetworkRanges(in *NetworkRanges, out *v1beta1.NetworkRanges, s conversion.Scope) error {
	out.CIDRBlocks = *(*[]string)(unsafe.Pointer(&in.CIDRBlocks))
	return nil
}

// Convert_v1alpha3_NetworkRanges_To_v1beta1_NetworkRanges is an autogenerated conversion function.
func Convert_v1alpha3_NetworkRanges_To_v1beta1_NetworkRanges(in *NetworkRanges, out *v1beta1.NetworkRanges, s conversion.Scope) error {
	return autoConvert_v1alpha3_NetworkRanges_To_v1beta1_NetworkRanges(in, out, s)
}

func autoConvert_v1beta1_NetworkRanges_To_v1alpha3_NetworkRanges(in *v1beta1.NetworkRanges, out *NetworkRanges, s conversion.Scope) error {
	out.CIDRBlocks = *(*[]string)(unsafe.Pointer(&in.CIDRBlocks))
	return nil
}

// Convert_v1beta1_NetworkRanges_To_v1alpha3_NetworkRanges is an autogenerated conversion function.
func Convert_v1beta1_NetworkRanges_To_v1alpha3_NetworkRanges(in *v1beta1.NetworkRanges, out *NetworkRanges, s conversion.Scope) error {
	return autoConvert_v1beta1_NetworkRanges_To_v1alpha3_NetworkRanges(in, out, s)
}

func autoConvert_v1alpha3_ObjectMeta_To_v1beta1_ObjectMeta(in *ObjectMeta, out *v1beta1.ObjectMeta, s conversion.Scope) error {
	// WARNING: in.Name requires manual conversion: does not exist in peer-type
	// WARNING: in.GenerateName requires manual conversion: does not exist in peer-type
	// WARNING: in.Namespace requires manual conversion: does not exist in peer-type
	out.Labels = *(*map[string]string)(unsafe.Pointer(&in.Labels))
	out.Annotations = *(*map[string]string)(unsafe.Pointer(&in.Annotations))
	// WARNING: in.OwnerReferences requires manual conversion: does not exist in peer-type
	return nil
}

func autoConvert_v1beta1_ObjectMeta_To_v1alpha3_ObjectMeta(in *v1beta1.ObjectMeta, out *ObjectMeta, s conversion.Scope) error {
	out.Labels = *(*map[string]string)(unsafe.Pointer(&in.Labels))
	out.Annotations = *(*map[string]string)(unsafe.Pointer(&in.Annotations))
	return nil
}

// Convert_v1beta1_ObjectMeta_To_v1alpha3_ObjectMeta is an autogenerated conversion function.
func Convert_v1beta1_ObjectMeta_To_v1alpha3_ObjectMeta(in *v1beta1.ObjectMeta, out *ObjectMeta, s conversion.Scope) error {
	return autoConvert_v1beta1_ObjectMeta_To_v1alpha3_ObjectMeta(in, out, s)
}

func autoConvert_v1alpha3_UnhealthyCondition_To_v1beta1_UnhealthyCondition(in *UnhealthyCondition, out *v1beta1.UnhealthyCondition, s conversion.Scope) error {
	out.Type = v1.NodeConditionType(in.Type)
	out.Status = v1.ConditionStatus(in.Status)
	out.Timeout = in.Timeout
	return nil
}

// Convert_v1alpha3_UnhealthyCondition_To_v1beta1_UnhealthyCondition is an autogenerated conversion function.
func Convert_v1alpha3_UnhealthyCondition_To_v1beta1_UnhealthyCondition(in *UnhealthyCondition, out *v1beta1.UnhealthyCondition, s conversion.Scope) error {
	return autoConvert_v1alpha3_UnhealthyCondition_To_v1beta1_UnhealthyCondition(in, out, s)
}

func autoConvert_v1beta1_UnhealthyCondition_To_v1alpha3_UnhealthyCondition(in *v1beta1.UnhealthyCondition, out *UnhealthyCondition, s conversion.Scope) error {
	out.Type = v1.NodeConditionType(in.Type)
	out.Status = v1.ConditionStatus(in.Status)
	out.Timeout = in.Timeout
	return nil
}

// Convert_v1beta1_UnhealthyCondition_To_v1alpha3_UnhealthyCondition is an autogenerated conversion function.
func Convert_v1beta1_UnhealthyCondition_To_v1alpha3_UnhealthyCondition(in *v1beta1.UnhealthyCondition, out *UnhealthyCondition, s conversion.Scope) error {
	return autoConvert_v1beta1_UnhealthyCondition_To_v1alpha3_UnhealthyCondition(in, out, s)
}
