// Code generated by go-bindata. DO NOT EDIT.
// sources:
// assets/dns/cluster-role-binding.yaml (223B)
// assets/dns/cluster-role.yaml (492B)
// assets/dns/daemonset.yaml (2.828kB)
// assets/dns/metrics/cluster-role-binding.yaml (279B)
// assets/dns/metrics/cluster-role.yaml (246B)
// assets/dns/metrics/role-binding.yaml (293B)
// assets/dns/metrics/role.yaml (284B)
// assets/dns/namespace.yaml (713B)
// assets/dns/service-account.yaml (85B)
// assets/dns/service.yaml (393B)
// assets/node-resolver/service-account.yaml (95B)
// assets/node-resolver/update-node-resolver.sh (2.285kB)

package manifests

import (
	"bytes"
	"compress/gzip"
	"crypto/sha256"
	"fmt"
	"io"
	"io/ioutil"
	"os"
	"path/filepath"
	"strings"
	"time"
)

func bindataRead(data []byte, name string) ([]byte, error) {
	gz, err := gzip.NewReader(bytes.NewBuffer(data))
	if err != nil {
		return nil, fmt.Errorf("Read %q: %v", name, err)
	}

	var buf bytes.Buffer
	_, err = io.Copy(&buf, gz)
	clErr := gz.Close()

	if err != nil {
		return nil, fmt.Errorf("Read %q: %v", name, err)
	}
	if clErr != nil {
		return nil, err
	}

	return buf.Bytes(), nil
}

type asset struct {
	bytes  []byte
	info   os.FileInfo
	digest [sha256.Size]byte
}

type bindataFileInfo struct {
	name    string
	size    int64
	mode    os.FileMode
	modTime time.Time
}

func (fi bindataFileInfo) Name() string {
	return fi.name
}
func (fi bindataFileInfo) Size() int64 {
	return fi.size
}
func (fi bindataFileInfo) Mode() os.FileMode {
	return fi.mode
}
func (fi bindataFileInfo) ModTime() time.Time {
	return fi.modTime
}
func (fi bindataFileInfo) IsDir() bool {
	return false
}
func (fi bindataFileInfo) Sys() interface{} {
	return nil
}

var _assetsDnsClusterRoleBindingYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x6c\xce\x31\x8e\x83\x40\x0c\x05\xd0\x7e\x4e\xe1\x0b\xc0\x6a\xbb\xd5\x74\x9b\xdc\x80\x48\xe9\xcd\x8c\x09\x0e\x60\xa3\xb1\x87\x22\xa7\x8f\x10\x4a\x45\x3a\x17\xfe\xff\xfd\x89\x25\x47\xb8\xce\xd5\x9c\x4a\xa7\x33\x5d\x58\x32\xcb\x23\xe0\xca\x77\x2a\xc6\x2a\x11\x4a\x8f\xa9\xc5\xea\xa3\x16\x7e\xa1\xb3\x4a\x3b\xfd\x59\xcb\xfa\xb3\xfd\x86\x85\x1c\x33\x3a\xc6\x00\x00\x20\xb8\x50\x04\x5d\x49\x6c\xe4\xc1\x9b\x2c\x16\xac\xf6\x4f\x4a\x6e\x31\x34\x70\x78\x37\x2a\x1b\x27\xfa\x4f\x49\xab\x78\xf8\xc4\xf6\xe7\xe3\xb6\x15\xd3\xa9\xa7\xe8\x4c\x1d\x0d\x3b\x74\x9a\x1d\xbe\xd3\xef\x00\x00\x00\xff\xff\xfa\x62\xe7\x50\xdf\x00\x00\x00")

func assetsDnsClusterRoleBindingYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsClusterRoleBindingYaml,
		"assets/dns/cluster-role-binding.yaml",
	)
}

func assetsDnsClusterRoleBindingYaml() (*asset, error) {
	bytes, err := assetsDnsClusterRoleBindingYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/cluster-role-binding.yaml", size: 223, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xd9, 0xf6, 0x2a, 0x3b, 0x84, 0xd7, 0x3e, 0xc4, 0xe1, 0x70, 0x66, 0x31, 0xda, 0xc4, 0x2f, 0x53, 0x27, 0x29, 0x13, 0xfe, 0x80, 0x36, 0xc5, 0xa1, 0x70, 0xdc, 0x2d, 0xef, 0xcf, 0xe0, 0xc4, 0xeb}}
	return a, nil
}

var _assetsDnsClusterRoleYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x94\x90\xb1\x6e\xf3\x30\x0c\x84\x77\x3d\x85\x90\x3d\xfe\xf1\x6f\x85\xd7\x0e\xdd\x3b\x74\xa7\xa5\x2b\xcc\xda\x11\x05\x92\x72\xd0\x3e\x7d\xe1\xd8\x43\x11\xa3\x01\xba\xdd\x1d\xa4\xfb\x88\x9b\xb8\xe4\x3e\x3e\xcf\xcd\x1c\xfa\x2a\x33\x02\x55\x7e\x83\x1a\x4b\xe9\xa3\x0e\x94\x3a\x6a\x3e\x8a\xf2\x17\x39\x4b\xe9\xa6\x27\xeb\x58\xfe\x2d\xff\xc3\x05\x4e\x99\x9c\xfa\x10\x63\xa1\x0b\xfa\x28\x15\xc5\x46\x7e\xf7\x73\x2e\x16\xb4\xcd\xb0\x3e\x9c\x23\x55\x7e\x51\x69\xd5\xd6\x97\xe7\x78\x3a\x85\x18\x15\x26\x4d\x13\xf6\x0c\x25\x57\xe1\xe2\x76\x73\x06\x5d\x38\x61\x33\x55\xf2\x26\x56\x86\x55\xda\xf2\x05\x3a\xec\x7f\x67\x36\xbf\x89\x2b\x79\x1a\xc3\x11\x98\xd9\x92\x2c\xd0\xcf\xfd\xf8\x07\xf8\x99\xff\x5e\xbf\xee\x83\xe2\x9c\x7e\x0e\x74\x64\xb8\x4c\x28\x8a\x85\x71\xbd\x23\x24\x05\x39\x7e\x69\xbe\x5f\xfe\x58\x6c\x6d\xf8\x40\x72\x4a\x09\x66\x8f\x00\xdf\x01\x00\x00\xff\xff\xa8\x4a\xa0\x25\xec\x01\x00\x00")

func assetsDnsClusterRoleYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsClusterRoleYaml,
		"assets/dns/cluster-role.yaml",
	)
}

func assetsDnsClusterRoleYaml() (*asset, error) {
	bytes, err := assetsDnsClusterRoleYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/cluster-role.yaml", size: 492, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xe4, 0x60, 0xec, 0x48, 0xf0, 0xad, 0x2c, 0x47, 0x8d, 0xc7, 0x61, 0xc0, 0x24, 0x2c, 0x57, 0x4e, 0xcc, 0x57, 0x7b, 0x45, 0x8c, 0xcf, 0x81, 0xf7, 0xf7, 0xf5, 0xe0, 0x6e, 0x26, 0x7, 0xef, 0xd6}}
	return a, nil
}

var _assetsDnsDaemonsetYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xa4\x56\xdd\x6e\x1b\x37\x13\xbd\xf7\x53\x0c\x64\x7c\xc8\x57\xc0\xab\x9f\x24\x4a\x5c\x02\xbe\x70\x25\x37\x0e\x10\xc7\x42\xa4\xb4\x17\x45\x21\xd0\xdc\x91\x96\x10\x97\xdc\xce\x0c\x95\x2c\x8a\xbe\x7b\xc1\x95\x25\xaf\x6c\x45\xf9\xe9\x8d\xb0\x9a\x39\x73\x38\x3c\x33\x1c\x72\x65\x7d\xae\x60\xac\xb1\x0c\x7e\x8a\x72\xa2\x2b\xfb\x1b\x12\xdb\xe0\x15\xe8\xaa\xe2\xde\x7a\x70\x72\x0a\x5e\x97\x78\xd6\xfc\x72\xa5\x0d\x82\xf6\x39\x38\x7d\x87\x8e\x41\x13\x02\xa3\x80\x16\xa0\xe8\xc5\x96\x78\xc2\x15\x1a\x75\x02\x20\x58\x56\x4e\x0b\xa6\x6f\x80\x12\x45\xe7\x5a\xf4\xe6\x1f\x80\xf6\x3e\x88\x16\x1b\x3c\x6f\x4d\x00\xa2\x69\x89\xd2\xfd\x14\x68\xe5\x82\xce\xbb\xa1\x42\xcf\x85\x5d\x48\xd7\x86\x5e\xa9\xbd\x5e\x62\x89\x5e\x14\x3c\xfb\xbb\x83\x8b\x05\x1a\xe9\x28\xe8\x4c\x08\x17\x48\x84\xf9\x38\x92\xf5\xcb\xa9\x29\x30\x8f\xce\xfa\x65\xe7\x9f\x67\x0d\xf5\x36\xa3\xe6\x1b\x69\x6d\x0d\x5e\x1a\x13\xa2\x97\xf7\xba\x44\x05\xb9\xe7\x7b\x6f\x45\x36\x90\x95\x7a\xe4\x34\xf3\xc6\xc9\x35\x0b\x96\x99\x0f\x39\x66\x86\xac\x58\xa3\xdd\x3d\xda\x04\x2f\xda\x7a\xa4\xdd\x16\xb2\x46\xa5\x36\x23\xc0\x29\xd8\x52\x2f\x11\x2c\x3f\x56\x6a\x8b\x68\xfc\x93\xe8\xdc\x24\x38\x6b\x6a\x05\x6f\x17\xef\x83\x4c\x08\x19\xbd\x3c\x88\x83\x54\x5a\xdf\x48\x76\x83\xcc\x29\xe4\x1e\xfe\xab\x76\xee\x4e\x9b\xd5\x2c\xbc\x0b\x4b\xbe\xf5\x57\x44\x81\x76\x71\x26\x94\xa5\x4e\x65\xfe\x03\x3a\x26\x10\xe6\x9e\x3b\xf0\xe7\xce\xad\x69\xc9\x8d\x2f\x33\xc1\x2f\x3a\x67\xd0\xe9\xa1\x98\xde\x3d\xb2\x37\x0a\x84\x0b\xeb\xb0\x1d\xb2\x0e\x2e\x96\x78\x93\x04\x6c\x15\x6f\xbb\xf7\x44\x63\x97\xd9\x06\xb4\xf3\x02\x94\x09\x3f\xd1\x52\x28\x68\xaf\xd0\x42\x10\xea\xfc\xd6\xbb\x5a\x81\x50\x7c\x08\xad\x02\xed\xaf\xb3\xd3\x7d\x12\x48\x14\x0c\x5f\x0c\x5f\xb4\x58\x9e\x56\x20\xd5\x35\x48\x30\xc1\x29\xf8\x38\x9e\x7c\x3f\x53\x26\xa6\x3a\xc8\x36\x1b\x3d\xb0\xa5\xec\xad\x47\xe6\x09\x85\x3b\x54\x2d\x7c\x21\x52\xbd\x41\x69\x9b\x00\xaa\x8d\x12\x29\xaa\xde\x77\x34\xa9\x9c\x0f\xce\x07\x7b\x66\x36\x05\xa6\x74\xae\x67\xb3\x49\xcb\x61\xbd\x15\xab\xdd\x18\x9d\xae\xa7\x68\x82\xcf\x59\xc1\xa0\xdf\xce\x16\xc9\x86\x7c\xe7\x6b\x6f\x90\xa3\x31\xc8\x3c\x2b\x08\xb9\x08\x2e\x57\xd0\x5e\x73\xa1\xad\x8b\x84\x2d\x6f\x3b\x36\x75\x70\x88\x72\x80\xd7\xd9\x35\x7e\xb7\x0e\x05\x6a\x27\xc5\x21\x21\xfa\xe7\xfd\x1f\x16\xe2\x55\xff\x48\xc6\xc3\xff\xa0\xc4\xb0\x55\x76\x0e\x91\x0c\xb2\xda\xeb\xe4\xbf\x22\xb2\xf0\xfe\x56\x4d\x15\x15\x0c\xfb\xe5\x9e\xb1\xc4\x32\x50\xad\xe0\x75\xff\xc6\x3e\x9a\x22\xab\x78\x87\x19\xdd\x69\x93\x55\x14\x3e\xd7\xdf\x31\x51\x9a\x43\xdd\xea\xf3\x2c\x73\x61\x29\x81\x25\x47\xa2\x3d\x3b\xa3\x89\x84\x99\xb3\x2c\xe8\x33\x9d\xe7\x84\xcc\x17\xea\xe7\xc1\xf0\xe5\x1e\x4e\x1c\x67\xc6\x56\x05\x52\xc6\xd1\x0a\xf2\xc5\xec\xdd\x74\x7e\x35\x1a\x5f\x5f\xcd\x3f\x4c\x2f\xe7\xbf\xbf\x9d\x5d\xcf\x2f\xaf\xa6\xf3\xc1\xf3\xf3\xf9\x9b\xd1\xcd\x7c\x7a\x7d\xf9\x7c\xf8\xea\xec\x01\x75\x35\x1a\x7f\x05\xf7\x84\x67\xf4\xcb\xe8\x9b\x78\x0e\xe2\x8e\xb0\xed\xed\x2c\x56\x2c\x84\xba\xbc\x48\xed\xa9\x7a\xbd\xc1\xf3\xd7\xdd\x7e\xb7\xdf\x1d\x24\x11\x5e\xf4\x9e\xaa\x80\x24\x59\x1a\x89\x17\xcd\x18\x13\xc7\xbd\x8a\xec\x5a\x0b\xa6\xef\xae\x21\x79\x12\x72\xef\xcf\x56\x58\x1f\x89\x5c\x61\xfd\xcd\x33\x6f\xaf\x3e\xdb\x49\x55\xa2\x90\x35\xfc\xc3\xad\x39\xf8\x42\x6b\xbe\x7c\x68\xcd\x2f\x0f\xff\xc7\xe3\xbd\xb5\xbb\x2f\x25\x9a\xb4\xf9\xda\xf8\xcf\x3d\x6f\xaf\xb9\x31\x2e\x74\x74\x5b\x75\x4f\x21\x5d\xc9\x53\x74\x68\x24\xd0\xd3\xb3\xd0\x3d\x69\xe7\xfb\xe4\x86\x3e\x7c\x4b\x6d\xac\x37\xba\x52\xad\xc3\x96\xde\x01\x47\xce\x1a\x80\x15\x2c\xf7\xf4\xcc\x60\x85\xb5\x82\xed\xdd\x79\x60\xde\x3d\x72\x65\x47\x84\x39\x05\x46\x43\x28\x47\xd3\x38\x05\x09\x0e\x69\xf3\xa0\x3a\x2c\x46\xac\x72\x2d\x38\x15\xd2\x82\xcb\x7a\x93\xae\xd4\x15\x2a\xf8\x10\x5c\x7a\x2e\x7d\x6c\x00\x8d\x9d\xda\x16\xb5\x5b\x63\x76\x3b\xbe\x4d\xb9\x7b\xb6\x39\x52\x5a\x43\xac\x5f\x42\xa9\x3f\x4f\x23\x2d\x11\x24\x80\x86\x2a\xb0\x15\xbb\x46\x58\x6b\x17\x77\x65\xd8\x62\x14\xf4\x77\x74\xef\x83\xa0\x82\x59\x81\x90\x37\x2f\xd0\xa6\xc9\xd3\xd2\x48\x40\x21\xfa\x9c\x41\x0a\x4c\x17\x98\x41\x2f\x69\xe2\xc5\x6a\x17\xfc\xff\xe8\x9d\x5d\x61\x83\xc8\xb1\x72\xa1\x4e\x4f\xc3\x16\xc5\x19\x7c\x2a\xac\x29\xb6\x4c\x79\xf8\xe4\x7f\x6a\x65\xf3\xd1\xeb\xb5\xb6\x4e\xdf\x39\x4c\x9d\xff\xbf\x93\x7f\x03\x00\x00\xff\xff\x44\x37\xeb\xeb\x0c\x0b\x00\x00")

func assetsDnsDaemonsetYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsDaemonsetYaml,
		"assets/dns/daemonset.yaml",
	)
}

func assetsDnsDaemonsetYaml() (*asset, error) {
	bytes, err := assetsDnsDaemonsetYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/daemonset.yaml", size: 2828, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x16, 0x26, 0xcf, 0x8f, 0xfa, 0xb9, 0x58, 0xdd, 0x1b, 0x48, 0x8, 0x80, 0x5e, 0x36, 0x3, 0x9, 0x74, 0xa9, 0xe9, 0x88, 0x18, 0x78, 0xe0, 0x5f, 0x82, 0x86, 0x5b, 0xdc, 0x4, 0x2e, 0x4d, 0xe9}}
	return a, nil
}

var _assetsDnsMetricsClusterRoleBindingYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x7c\x8f\xb1\x4a\x04\x41\x0c\x86\xfb\x79\x8a\xbc\xc0\xae\xd8\x1d\xd3\xa9\x85\xfd\x09\xf6\xb9\x99\x9c\x1b\x77\x27\x19\x92\xcc\x16\x3e\xbd\x2c\x8a\x08\xe2\xb5\x81\x7c\xdf\xff\xad\x2c\x35\xc3\xd3\x36\x3c\xc8\xce\xba\xd1\x23\x4b\x65\x79\x4b\xd8\xf9\x95\xcc\x59\x25\x83\x5d\xb0\xcc\x38\x62\x51\xe3\x0f\x0c\x56\x99\xd7\x93\xcf\xac\x77\xfb\x7d\x6a\x14\x58\x31\x30\x27\x00\xc1\x46\x19\xaa\xf8\xd4\x54\x38\xd4\x0e\x92\x8f\xcb\x3b\x95\xf0\x9c\x26\xf8\xd2\xbd\x90\xed\x5c\xe8\xa1\x14\x1d\x12\x3f\x7f\xdd\xb4\x51\x2c\x34\x7c\x5a\x4f\xfe\x7d\xf6\x8e\x85\x32\x68\x27\xf1\x85\xaf\xf1\x9b\x6c\xba\xd1\x99\xae\x87\xf9\x4f\xc7\x7f\x6b\x00\xb0\xf3\xb3\xe9\xe8\x37\xba\xd2\x67\x00\x00\x00\xff\xff\x5b\x52\x00\xaa\x17\x01\x00\x00")

func assetsDnsMetricsClusterRoleBindingYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsMetricsClusterRoleBindingYaml,
		"assets/dns/metrics/cluster-role-binding.yaml",
	)
}

func assetsDnsMetricsClusterRoleBindingYaml() (*asset, error) {
	bytes, err := assetsDnsMetricsClusterRoleBindingYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/metrics/cluster-role-binding.yaml", size: 279, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x79, 0x95, 0x6f, 0xa4, 0xd5, 0xed, 0x48, 0x27, 0x41, 0x56, 0x5c, 0xea, 0x5c, 0x89, 0xdc, 0xc1, 0x44, 0x91, 0xd4, 0xb, 0x18, 0x85, 0x79, 0x75, 0xaa, 0x6e, 0xb5, 0x98, 0xbe, 0xc6, 0x33, 0x43}}
	return a, nil
}

var _assetsDnsMetricsClusterRoleYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x34\xcd\x31\x4b\x34\x41\x0c\x87\xf1\x7e\x3e\x45\xe0\xad\x77\x5f\xec\x64\x5a\x05\x3b\x0b\x05\xfb\xec\xce\xdf\xdb\x70\x3b\xc9\x90\x64\x0e\xf4\xd3\x8b\x70\xb6\x0f\x3f\x78\xfe\xd1\xd3\x39\x23\xe1\xe4\x76\x22\x48\x81\x86\x46\xdb\x17\x0d\xb7\x8e\x3c\x30\x83\xd2\x28\x76\xe7\x01\x7a\x7e\x7d\xa7\x8e\x74\xd9\x83\xa0\x6d\x98\x68\x16\x1e\xf2\x01\x0f\x31\xad\xe4\x1b\xef\x2b\xcf\x3c\xcc\xe5\x9b\x53\x4c\xd7\xeb\x63\xac\x62\xff\x6f\x0f\xe5\x2a\xda\xea\xdf\xf0\xcd\x4e\x94\x8e\xe4\xc6\xc9\xb5\x10\x29\x77\x54\x6a\x1a\x4b\x37\x95\x34\x17\xbd\x14\x9f\x27\xa2\x96\x85\x78\xc8\x8b\xdb\x1c\xf1\x4b\x17\xb2\x01\xe7\x34\x5f\x6d\x40\xe3\x90\xcf\x5c\xc5\x0a\x91\x23\x6c\xfa\x8e\x3b\x6b\x1a\x88\x42\x74\x83\x6f\xf7\x74\x41\x96\x9f\x00\x00\x00\xff\xff\x9f\xa8\x4d\x6c\xf6\x00\x00\x00")

func assetsDnsMetricsClusterRoleYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsMetricsClusterRoleYaml,
		"assets/dns/metrics/cluster-role.yaml",
	)
}

func assetsDnsMetricsClusterRoleYaml() (*asset, error) {
	bytes, err := assetsDnsMetricsClusterRoleYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/metrics/cluster-role.yaml", size: 246, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x64, 0xdb, 0xe0, 0x95, 0x65, 0xae, 0x53, 0x96, 0x3a, 0x5f, 0x5e, 0x8b, 0x69, 0xe2, 0x7d, 0x5, 0xbf, 0x1f, 0x3a, 0xf, 0xff, 0xd0, 0x6b, 0x23, 0x4f, 0xfd, 0x11, 0x7f, 0x57, 0xd4, 0x4a, 0x8b}}
	return a, nil
}

var _assetsDnsMetricsRoleBindingYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x94\xce\xb1\x4e\xc4\x40\x0c\x04\xd0\x7e\xbf\xc2\x3f\x90\x20\xba\xd3\x76\xd0\xd0\x1f\x12\xbd\x6f\xd7\x97\x98\x64\xed\x95\xed\x4d\xc1\xd7\x23\xa4\x48\x54\x20\x5d\x3b\x9a\xd1\x1b\xec\xfc\x41\xe6\xac\x92\xc1\x6e\x58\x66\x1c\xb1\xaa\xf1\x17\x06\xab\xcc\xdb\xc5\x67\xd6\xa7\xe3\x39\x6d\x2c\x35\xc3\x55\x77\x7a\x65\xa9\x2c\x4b\x6a\x14\x58\x31\x30\x27\x00\xc1\x46\x19\xba\x69\xa3\x58\x69\xf8\xb4\x5d\xfc\x8c\xbd\x63\xa1\x0c\xda\x49\x7c\xe5\x7b\x4c\x55\x3c\x99\xee\x74\xa5\xfb\xcf\x14\x3b\xbf\x99\x8e\xfe\x8f\x9f\x00\x7e\xf9\xbf\x34\x1f\xb7\x4f\x2a\xe1\x39\x4d\x67\xfb\x9d\xec\xe0\x42\x2f\xa5\xe8\x90\x78\xf0\x65\x53\xe1\x50\x63\x59\x20\x7d\x07\x00\x00\xff\xff\xb9\xd9\xab\x8d\x25\x01\x00\x00")

func assetsDnsMetricsRoleBindingYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsMetricsRoleBindingYaml,
		"assets/dns/metrics/role-binding.yaml",
	)
}

func assetsDnsMetricsRoleBindingYaml() (*asset, error) {
	bytes, err := assetsDnsMetricsRoleBindingYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/metrics/role-binding.yaml", size: 293, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xc, 0x7d, 0xc7, 0x45, 0x33, 0xc4, 0xd8, 0xf, 0x8d, 0x89, 0x8d, 0x6, 0x47, 0xa7, 0xa, 0x6b, 0x17, 0xf5, 0x5f, 0x5a, 0x2f, 0xd8, 0xf9, 0x6, 0x71, 0xaa, 0x78, 0x8d, 0xb5, 0x7a, 0xf6, 0x99}}
	return a, nil
}

var _assetsDnsMetricsRoleYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x4c\x8e\xb1\x4e\xec\x40\x0c\x45\xfb\xf9\x0a\x6b\x5f\x9d\x7d\xa2\x5b\x4d\x8d\x44\x47\x01\x12\xbd\x77\xe6\x42\xac\x24\xe3\x91\xed\x04\xc1\xd7\xa3\xcd\x06\x89\xca\xf7\x1e\x59\x3e\xfe\x47\x2f\x3a\xc3\xa9\x01\x15\x95\xae\x5f\xd4\x4d\x17\xc4\x88\xd5\x29\x94\xbc\x18\x77\xd0\xe3\xf3\x2b\x2d\x08\x93\xe2\x84\x56\xbb\x4a\x8b\xc4\x5d\xde\x60\x2e\xda\x32\xd9\x95\xcb\x99\xd7\x18\xd5\xe4\x9b\x43\xb4\x9d\xa7\x8b\x9f\x45\xff\x6f\x0f\x69\x92\x56\xf3\x2e\x4a\x0b\x82\x2b\x07\xe7\x44\xd4\x78\x41\xfe\xe3\x1b\xa6\x8b\x1f\xd8\x3b\x17\x64\xd2\x8e\xe6\xa3\xbc\xc7\x50\x9b\x27\x5b\x67\x78\x4e\x03\x71\x97\x27\xd3\xb5\xfb\xed\xca\x40\xa7\x53\x22\x32\xb8\xae\x56\x70\x30\x87\x6d\x52\xe0\x7b\xf9\xfd\xf8\xde\xba\xd6\x5b\xd8\x60\xd7\x63\xf9\x03\xb1\xcf\x59\xfc\x1e\x3e\x39\xca\x98\x7e\x02\x00\x00\xff\xff\x29\x39\xda\x05\x1c\x01\x00\x00")

func assetsDnsMetricsRoleYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsMetricsRoleYaml,
		"assets/dns/metrics/role.yaml",
	)
}

func assetsDnsMetricsRoleYaml() (*asset, error) {
	bytes, err := assetsDnsMetricsRoleYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/metrics/role.yaml", size: 284, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x8c, 0xf2, 0x4e, 0x40, 0x91, 0xd8, 0x5e, 0x1c, 0x98, 0xb6, 0x2f, 0x11, 0x2a, 0x15, 0x8f, 0xe4, 0x7c, 0xfe, 0xc6, 0x31, 0xf3, 0xb2, 0xa0, 0x38, 0xb2, 0x3f, 0x15, 0x5a, 0x33, 0x12, 0xd2, 0x88}}
	return a, nil
}

var _assetsDnsNamespaceYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x94\x51\xbd\xd2\xd2\x50\x10\xed\x79\x8a\x33\xb1\xfd\x40\x6d\xf3\x06\x16\xda\x38\x63\xbf\xe4\x1e\x60\xe5\x66\x37\x73\x77\x13\xc6\xb7\x77\x02\xe8\x07\x43\xe1\x58\x26\x7b\xfe\xef\x59\xad\xf4\xf8\x26\x23\x63\x92\x81\x1b\x99\xf4\x07\x5b\xa8\x5b\x8f\xe5\xf3\x66\x64\x4a\x91\x94\x7e\x03\x88\x99\xa7\xa4\xba\xc5\xfa\x09\xf8\x44\x8b\x93\x1e\x72\xa7\xfe\xd1\xbc\x70\x1b\xac\x1c\xd2\x5b\x8f\xae\xbb\x42\x2e\xde\xce\xd5\xa5\xec\x9e\xb0\x52\xab\x5f\x58\x7a\x74\xa3\x98\x1c\x39\xd2\x72\xc5\x9b\x8c\xec\xdf\x65\xb7\xc5\x62\x03\x54\xd9\xb3\xde\x2d\x3f\x20\x98\x58\xa4\xce\x44\x3a\x64\x71\x2d\x28\x9c\x68\x45\xed\x08\x37\x9c\xe7\x3d\x21\x65\xd4\x58\x4b\x20\x4f\x92\x77\x40\xac\xe7\xbf\xe2\x90\x49\xe3\xb5\x46\x9b\x6d\x5b\xb9\xb0\xf6\xe8\x3e\x75\x77\xcf\x6b\xde\x87\x5c\xa3\x9b\xa6\xb7\xd5\x31\x1d\xd5\xfd\x8c\x83\x37\x7c\x67\x5b\x74\xe0\xd7\xdb\x15\xbe\xff\xc9\x21\x03\xba\xa6\xd0\xb8\xb6\xbb\x8d\xfc\xe2\x3a\xd4\x39\x92\xed\x41\xb8\x47\x97\x6d\xe6\x73\x82\xeb\xc6\x8d\xe1\x75\x61\x43\x11\x8e\x6e\xeb\x1e\xe9\x98\x24\x02\x7b\x09\x56\x35\x62\xf2\x82\xe0\x30\x37\xcd\x5f\xef\x63\xec\xee\x62\x5f\x12\x73\x30\x70\xf2\x48\x18\x73\x7d\x24\xb5\xe3\xdb\xed\xc7\x24\x79\xc2\xe2\x75\x1e\x19\x6f\x10\x2b\xd0\x80\x60\x6a\xba\x68\xe5\x91\xe5\x26\x33\x79\xd9\xfe\xb1\xd8\xad\xa3\x37\x63\x32\xd6\x36\xb4\x83\xb7\x81\xfd\x03\xe7\x5f\x14\x99\x8b\xe6\xff\x10\x2e\xd2\xec\x09\xff\x3b\x00\x00\xff\xff\x32\x31\x6a\x26\xc9\x02\x00\x00")

func assetsDnsNamespaceYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsNamespaceYaml,
		"assets/dns/namespace.yaml",
	)
}

func assetsDnsNamespaceYaml() (*asset, error) {
	bytes, err := assetsDnsNamespaceYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/namespace.yaml", size: 713, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x8d, 0x10, 0x2c, 0xc1, 0x8, 0x39, 0x7c, 0xf5, 0x5, 0x6, 0x5d, 0x3e, 0xc1, 0x41, 0x2e, 0xa6, 0x25, 0x14, 0x59, 0xa3, 0x20, 0x7c, 0xf2, 0xad, 0xa6, 0xd5, 0x64, 0xd8, 0x12, 0xc4, 0x1b, 0x9f}}
	return a, nil
}

var _assetsDnsServiceAccountYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x2c\xc9\xb1\x09\xc4\x30\x0c\x05\xd0\xde\x53\x68\x81\x2b\xae\x55\x77\x33\x1c\xa4\x17\xf2\x0f\x11\xc1\xb2\xb1\x14\xcf\x1f\x02\xe9\x1e\xbc\xd3\xbc\x32\xfd\x31\x97\x29\x7e\xaa\xfd\xf2\x2c\x32\x6c\xc3\x0c\xeb\xce\xb4\xbe\xa5\x21\xa5\x4a\x0a\x17\x22\x97\x06\xa6\xea\xf1\x3a\x86\x28\x98\xfa\x80\xc7\x61\x7b\x7e\x9e\xba\x03\x00\x00\xff\xff\x8e\x2c\xf1\x2e\x55\x00\x00\x00")

func assetsDnsServiceAccountYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsServiceAccountYaml,
		"assets/dns/service-account.yaml",
	)
}

func assetsDnsServiceAccountYaml() (*asset, error) {
	bytes, err := assetsDnsServiceAccountYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/service-account.yaml", size: 85, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x57, 0x12, 0x50, 0x4d, 0x67, 0x2f, 0x1b, 0x74, 0xa0, 0xa4, 0xbb, 0xa7, 0x59, 0xe9, 0x5a, 0xc6, 0xc1, 0x1a, 0xf8, 0x5f, 0xff, 0x5, 0xdb, 0xc, 0x10, 0x8b, 0xc1, 0x0, 0xcc, 0xf, 0x9f, 0x3a}}
	return a, nil
}

var _assetsDnsServiceYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x84\xce\xbd\x6a\x2b\x31\x10\xc5\xf1\x7e\x9f\xe2\x80\x5b\xfb\x82\xb9\x71\x11\xb5\x49\x93\x6e\x21\x1f\xfd\x58\x3b\x98\x21\xda\x91\x98\x99\x75\xc8\xdb\x87\x28\xe0\x78\x93\x22\x8d\x40\xd2\x9f\x1f\xe7\x55\x74\x4a\x78\x64\x3b\x4b\xe6\x81\x9a\xbc\xb0\xb9\x54\x4d\x38\xef\x87\x0d\x94\x66\xde\xf6\xd3\x1b\x65\xde\x16\x3a\x72\x71\x90\x4e\x20\xd5\x1a\x14\x52\xd5\x41\xc6\x70\x0e\x50\xc0\x16\x0d\x99\x79\xf0\xc6\x39\x0d\xc0\x06\xb9\x2c\x1e\x6c\x0f\x23\xde\xa4\x14\x1c\x19\xb4\x44\x9d\x29\x24\x53\x29\xef\x98\x49\xe9\xc4\xd3\xbf\x1e\x3b\x17\xce\x51\x0d\xe2\x3f\x45\xa0\x55\x0b\xff\x44\x77\x7d\x52\xc2\xa4\x3e\x00\x5f\x1f\x09\x87\xff\xfd\x12\x64\x27\x8e\xb1\x3f\x5d\x02\xab\x51\x73\x2d\x09\xcf\xf7\xe3\x1a\xd8\x45\x6e\x7f\x22\xdf\xd1\x05\x7a\xba\xbb\x86\x66\x0e\x93\x7c\xbd\xe6\x76\x7f\xb8\xf9\x45\xad\xb2\x15\xf5\x11\x00\x00\xff\xff\x6a\xd4\x1f\x50\x89\x01\x00\x00")

func assetsDnsServiceYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsServiceYaml,
		"assets/dns/service.yaml",
	)
}

func assetsDnsServiceYaml() (*asset, error) {
	bytes, err := assetsDnsServiceYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/service.yaml", size: 393, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xf1, 0x8c, 0x63, 0x29, 0x22, 0x87, 0x69, 0x74, 0x0, 0xa6, 0x70, 0x9b, 0x62, 0x49, 0x60, 0xf2, 0xd2, 0x7b, 0x68, 0x8, 0x93, 0x55, 0x97, 0xbb, 0x2, 0xe7, 0xd8, 0xb4, 0x19, 0xa, 0x81, 0x44}}
	return a, nil
}

var _assetsNodeResolverServiceAccountYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x2c\xc8\x31\x0e\x02\x41\x08\x05\xd0\x7e\x4e\xc1\x05\xb6\xb0\xa5\xf3\x0c\x26\xf6\x64\xf8\x46\xa2\x0b\x13\xc0\x39\xbf\xcd\xb6\xef\x63\xae\x4c\x0f\xe4\xb6\x89\xfb\x9c\xf1\xf3\x1e\xb2\xec\x89\x2c\x0b\x67\xda\xb7\x71\xa2\x45\xa5\x85\x07\x91\xcb\x09\x26\x0f\xc5\x91\xa8\xf8\x6e\xe4\xa5\xb5\x64\x82\x29\x16\xbc\xde\xf6\xea\x43\xbd\xc6\x3f\x00\x00\xff\xff\x72\xbb\x64\x48\x5f\x00\x00\x00")

func assetsNodeResolverServiceAccountYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsNodeResolverServiceAccountYaml,
		"assets/node-resolver/service-account.yaml",
	)
}

func assetsNodeResolverServiceAccountYaml() (*asset, error) {
	bytes, err := assetsNodeResolverServiceAccountYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/node-resolver/service-account.yaml", size: 95, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xa6, 0xc3, 0x84, 0x29, 0x3e, 0x8d, 0x36, 0xc3, 0x54, 0x6a, 0x36, 0x40, 0xa6, 0x71, 0x1b, 0x25, 0x6f, 0x72, 0x90, 0xc0, 0x94, 0x34, 0x64, 0xa8, 0x35, 0xc5, 0x5f, 0xe7, 0xbc, 0x41, 0xdb, 0xb4}}
	return a, nil
}

var _assetsNodeResolverUpdateNodeResolverSh = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xb4\x56\x51\x73\xd3\x38\x17\x7d\xf7\xaf\x38\xb8\x19\xd2\x02\x6e\xfb\xcd\xc7\xf0\x40\x09\x4b\x96\xa6\x43\x06\xda\x64\x92\xb0\x3c\x74\xb2\x1d\xc5\xbe\x8e\xb5\x55\x24\x21\xc9\x0e\x99\x36\xff\x7d\x47\xb2\x9d\x14\xca\xee\xd3\x92\x07\x7b\xac\x5c\x9f\x7b\xcf\xd5\xb9\x47\x3e\x78\x72\xb2\xe0\xf2\x64\xc1\x6c\x11\x59\x72\x48\x4a\x05\xcd\x35\xe5\x8c\x8b\x28\x72\x86\x69\x74\xff\x52\x0b\x8b\x44\xe3\x1e\xdf\x98\x59\x5a\xdc\x72\x21\x70\x7f\x0f\x67\x4a\x3a\xc3\x9a\x71\x77\x06\xfa\xc6\x1d\x4e\xbb\x98\x0d\x26\x97\x51\x34\x1a\x0f\xae\xa6\x1f\x86\x17\xb3\x9b\xcb\xfe\xe4\xe3\x60\xd2\x8b\x95\x26\x69\x0b\x9e\xbb\x64\x49\x92\x0c\x73\x94\x25\x52\x65\x94\x18\xb2\x4a\x54\x64\xe2\xe8\xc3\x68\x3a\x9b\xde\x5c\x0c\x3f\x0d\x7a\xf1\x09\xb9\xf4\xa4\x50\xd6\xd9\x38\x9a\x0d\x2e\xc7\x8f\x96\x8f\xdd\x4a\xc7\x51\x34\xbc\x98\xf6\xba\x2f\xd0\x85\x21\x96\x21\x31\x48\x18\x2c\x99\x8a\xa7\x64\xf1\xe6\xcd\x1b\xc4\x9d\xbb\xe9\x60\xf2\xc7\xf0\xfd\x60\xba\x8d\xa3\xe8\x00\x97\xec\x96\xc0\xe0\x68\xa5\x95\x61\x66\x83\x9c\x0b\xc2\x9a\xbb\x02\xae\x20\x28\x91\x21\x24\x08\xeb\x5d\x0b\xe6\x9c\xe1\x8b\xd2\x91\x3d\x8e\x52\x8d\x24\x47\x92\xec\xd7\x12\x25\xc5\xc6\x27\xd9\x17\xbf\x8d\xfd\xf3\xae\x68\x9f\x75\x5d\xf8\x1c\x75\xbb\x32\x15\x01\x19\xa5\x82\x19\x42\xd2\x87\xad\xd2\x1b\xae\x6d\x04\xe4\xca\xf8\x27\x70\xe9\x01\x5a\x16\xd7\xef\xe6\xdb\xb8\x79\x0d\x38\xc0\x05\xb9\xb4\x68\x39\x62\x38\x46\x6e\xd4\x0a\xa9\x28\xad\x23\x83\x4c\x5a\xf0\x1c\xda\x90\x25\xe9\x8e\xf1\x85\xb0\xf2\x84\x2d\x55\x64\x98\x80\x33\x9c\x6c\x83\xe4\x14\x32\x05\xee\x5e\x63\x38\xae\x5e\xbe\xf0\xd7\x57\xe1\xfa\x12\xaa\x22\x83\xd9\xfb\x31\x98\xcc\xc2\xfa\x6e\xe5\x18\xb3\x82\xe0\xd6\x0a\x82\x59\x07\x25\x77\x70\x9e\x8f\xa7\x90\x91\x16\x6a\xb3\x22\xe9\x6c\xdd\xd6\x8f\xa5\xd9\x18\x28\xe9\x7b\x4b\x06\x23\x4d\x72\xea\x58\x7a\x8b\xc3\xd1\x74\xfc\xbf\xff\x1f\x21\x81\x2b\x94\x25\x5f\x8d\x54\xae\x81\xb3\xa5\xd6\xca\x38\x7c\x3e\x1f\x43\x28\x96\x2d\x98\x60\x32\x25\x63\x43\x4d\x86\xbe\x96\xdc\x90\xdf\xf6\xb4\xe0\x72\x89\xf3\xab\x29\x5c\x61\x54\xb9\x2c\x42\x99\x01\x25\x5d\x65\xb6\x77\xd8\xcd\xf8\x12\x89\x43\x1f\xef\xe2\xce\xdd\x55\xff\x72\xe0\x15\x31\x98\x6c\x63\x3c\xb7\x85\xcf\xe1\xdb\x5d\xa5\xdb\xe3\xce\xdd\xfb\x4f\x9f\xa7\xb3\xc1\xe4\xe6\x7c\x74\xd9\x1f\x5e\x6d\xe3\xfb\xa5\x21\x8d\xa4\x42\xfc\xe7\x59\xdc\x0d\xa0\xf5\x6f\x07\xda\xef\xff\x1a\x5c\x3c\x77\xa9\xc6\x73\x43\xce\x6c\x7a\xa7\xbf\xac\xf4\xff\x36\xcb\x51\x48\xe3\x55\xc0\xbd\x8c\x3b\x77\x4f\xfc\x16\x5c\x3f\x9b\x6f\xc3\x1f\x8d\x88\x01\xae\x6d\xef\xb0\x73\x48\x15\x13\x1e\x3b\x04\xf1\xf9\x36\x3e\x3a\x6a\x03\x72\x5c\x5f\x23\xee\xfc\x16\x23\xa1\xaf\x38\xc5\xd3\xa7\x3e\xf0\x80\xeb\x7a\x20\x90\x48\xc2\x29\xe6\xf3\x33\x3f\xb5\x72\xc7\xae\x99\xa6\xeb\xa6\xe0\x78\xde\x8b\x3b\x77\xed\x4b\xbb\xa8\x85\x21\x76\xdb\x3c\xe5\xbc\x29\x4d\x52\xd4\xdc\x22\xaf\xbf\xcf\x3a\x63\x8e\xb0\x77\x1c\x84\x51\xe7\x39\xd6\x84\x25\x39\x54\x4c\xf0\xec\xc1\x20\xda\xf0\xda\x17\xef\x25\x42\x78\x21\xa3\x7c\x04\xb1\x2e\x48\xfa\x82\x0d\x81\x5b\xa4\xca\x90\x1f\xd8\x16\x43\x95\x8e\x2d\x09\xca\x80\x69\x8e\x52\xb2\x8a\x71\xc1\x16\x5c\x70\xb7\x09\xe0\x53\xc7\x04\x81\x64\x98\x62\xa4\xaa\x14\x99\x37\x5e\xeb\x7c\xb3\x1f\xa4\xe1\x79\xf0\xb2\x16\x97\x5b\x64\x24\xc8\x51\x16\xb5\x9d\x4d\x64\xb3\xa7\xa1\x5b\xcf\xe6\xc9\x36\xfe\xbe\x99\x07\xf8\xbd\xe4\x22\x03\x83\xa4\xf5\x03\x47\xac\xed\xe6\x21\x25\x3f\xe2\xaa\x34\x48\x4b\xeb\xd4\x6a\x57\x5d\xce\x85\x23\x43\x99\x67\x15\x10\x77\x42\x39\x40\xe7\xee\xc7\x03\xa2\x36\xcd\xef\x4c\xf4\xed\x23\x1b\xad\xeb\xea\x6b\x4d\xc1\x01\xea\x73\x63\x9f\xd0\xdb\x67\x63\x9a\x3b\x19\xee\xfd\xf4\x49\x4b\xf6\x3b\x3f\x6d\xc4\xaa\x6b\xb5\xb6\x21\xb5\x78\xe6\xdb\x07\x61\x00\xa5\x85\x42\x50\xd3\xb6\x0e\x6d\x6f\x8f\xa7\x02\xff\x40\xf1\xed\x23\x4e\x35\x74\x23\xbe\xbd\xfc\x3c\xcf\xd9\xe8\x7c\xf4\xfa\x27\x32\x64\x4e\xad\x78\xca\x84\xd8\x78\x07\x67\x95\xe2\x19\x98\xdc\x80\xcb\x54\x49\xcb\xad\x23\xe9\xb0\xa0\x82\x55\x5c\x99\x06\x6b\x42\x5a\xb0\x94\x7e\xba\x6f\x2b\x95\xf1\x9c\x53\x86\x8a\x8c\xe5\x4a\x7a\x85\x48\xa2\x2c\xa8\xc5\x7b\xa8\xfe\xa1\xe8\x47\x3b\x75\x7f\x8f\xfa\x64\xfc\xf7\xb8\x96\x57\x1b\xe1\x75\xe9\xc7\xc4\xd0\x4a\x55\x94\xed\xd9\x04\x9d\xa5\x86\x98\xa3\x93\x5a\xb8\xc1\xf3\xf7\xa7\x2e\x52\xa5\x37\x48\x8b\xd2\x78\xb1\x86\x09\xb6\x82\x48\xe3\xd5\x29\x9e\x86\x0f\x92\x08\x28\xa5\xff\x9e\x69\x8f\xd7\xd0\xd9\xbf\x03\x00\x00\xff\xff\xb1\x48\x84\xd4\xed\x08\x00\x00")

func assetsNodeResolverUpdateNodeResolverShBytes() ([]byte, error) {
	return bindataRead(
		_assetsNodeResolverUpdateNodeResolverSh,
		"assets/node-resolver/update-node-resolver.sh",
	)
}

func assetsNodeResolverUpdateNodeResolverSh() (*asset, error) {
	bytes, err := assetsNodeResolverUpdateNodeResolverShBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/node-resolver/update-node-resolver.sh", size: 2285, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x6c, 0x92, 0xb2, 0xf8, 0x92, 0x59, 0xa3, 0xe9, 0x5, 0x26, 0x87, 0xcc, 0x55, 0xc, 0x2a, 0x85, 0x14, 0xd8, 0xc, 0x5, 0x92, 0x5f, 0x18, 0xb1, 0x27, 0x58, 0x79, 0x31, 0x9, 0xe4, 0x3b, 0xe7}}
	return a, nil
}

// Asset loads and returns the asset for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func Asset(name string) ([]byte, error) {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[canonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("Asset %s can't read by error: %v", name, err)
		}
		return a.bytes, nil
	}
	return nil, fmt.Errorf("Asset %s not found", name)
}

// AssetString returns the asset contents as a string (instead of a []byte).
func AssetString(name string) (string, error) {
	data, err := Asset(name)
	return string(data), err
}

// MustAsset is like Asset but panics when Asset would return an error.
// It simplifies safe initialization of global variables.
func MustAsset(name string) []byte {
	a, err := Asset(name)
	if err != nil {
		panic("asset: Asset(" + name + "): " + err.Error())
	}

	return a
}

// MustAssetString is like AssetString but panics when Asset would return an
// error. It simplifies safe initialization of global variables.
func MustAssetString(name string) string {
	return string(MustAsset(name))
}

// AssetInfo loads and returns the asset info for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func AssetInfo(name string) (os.FileInfo, error) {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[canonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("AssetInfo %s can't read by error: %v", name, err)
		}
		return a.info, nil
	}
	return nil, fmt.Errorf("AssetInfo %s not found", name)
}

// AssetDigest returns the digest of the file with the given name. It returns an
// error if the asset could not be found or the digest could not be loaded.
func AssetDigest(name string) ([sha256.Size]byte, error) {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[canonicalName]; ok {
		a, err := f()
		if err != nil {
			return [sha256.Size]byte{}, fmt.Errorf("AssetDigest %s can't read by error: %v", name, err)
		}
		return a.digest, nil
	}
	return [sha256.Size]byte{}, fmt.Errorf("AssetDigest %s not found", name)
}

// Digests returns a map of all known files and their checksums.
func Digests() (map[string][sha256.Size]byte, error) {
	mp := make(map[string][sha256.Size]byte, len(_bindata))
	for name := range _bindata {
		a, err := _bindata[name]()
		if err != nil {
			return nil, err
		}
		mp[name] = a.digest
	}
	return mp, nil
}

// AssetNames returns the names of the assets.
func AssetNames() []string {
	names := make([]string, 0, len(_bindata))
	for name := range _bindata {
		names = append(names, name)
	}
	return names
}

// _bindata is a table, holding each asset generator, mapped to its name.
var _bindata = map[string]func() (*asset, error){
	"assets/dns/cluster-role-binding.yaml": assetsDnsClusterRoleBindingYaml,

	"assets/dns/cluster-role.yaml": assetsDnsClusterRoleYaml,

	"assets/dns/daemonset.yaml": assetsDnsDaemonsetYaml,

	"assets/dns/metrics/cluster-role-binding.yaml": assetsDnsMetricsClusterRoleBindingYaml,

	"assets/dns/metrics/cluster-role.yaml": assetsDnsMetricsClusterRoleYaml,

	"assets/dns/metrics/role-binding.yaml": assetsDnsMetricsRoleBindingYaml,

	"assets/dns/metrics/role.yaml": assetsDnsMetricsRoleYaml,

	"assets/dns/namespace.yaml": assetsDnsNamespaceYaml,

	"assets/dns/service-account.yaml": assetsDnsServiceAccountYaml,

	"assets/dns/service.yaml": assetsDnsServiceYaml,

	"assets/node-resolver/service-account.yaml": assetsNodeResolverServiceAccountYaml,

	"assets/node-resolver/update-node-resolver.sh": assetsNodeResolverUpdateNodeResolverSh,
}

// AssetDir returns the file names below a certain
// directory embedded in the file by go-bindata.
// For example if you run go-bindata on data/... and data contains the
// following hierarchy:
//     data/
//       foo.txt
//       img/
//         a.png
//         b.png
// then AssetDir("data") would return []string{"foo.txt", "img"},
// AssetDir("data/img") would return []string{"a.png", "b.png"},
// AssetDir("foo.txt") and AssetDir("notexist") would return an error, and
// AssetDir("") will return []string{"data"}.
func AssetDir(name string) ([]string, error) {
	node := _bintree
	if len(name) != 0 {
		canonicalName := strings.Replace(name, "\\", "/", -1)
		pathList := strings.Split(canonicalName, "/")
		for _, p := range pathList {
			node = node.Children[p]
			if node == nil {
				return nil, fmt.Errorf("Asset %s not found", name)
			}
		}
	}
	if node.Func != nil {
		return nil, fmt.Errorf("Asset %s not found", name)
	}
	rv := make([]string, 0, len(node.Children))
	for childName := range node.Children {
		rv = append(rv, childName)
	}
	return rv, nil
}

type bintree struct {
	Func     func() (*asset, error)
	Children map[string]*bintree
}

var _bintree = &bintree{nil, map[string]*bintree{
	"assets": {nil, map[string]*bintree{
		"dns": {nil, map[string]*bintree{
			"cluster-role-binding.yaml": {assetsDnsClusterRoleBindingYaml, map[string]*bintree{}},
			"cluster-role.yaml":         {assetsDnsClusterRoleYaml, map[string]*bintree{}},
			"daemonset.yaml":            {assetsDnsDaemonsetYaml, map[string]*bintree{}},
			"metrics": {nil, map[string]*bintree{
				"cluster-role-binding.yaml": {assetsDnsMetricsClusterRoleBindingYaml, map[string]*bintree{}},
				"cluster-role.yaml":         {assetsDnsMetricsClusterRoleYaml, map[string]*bintree{}},
				"role-binding.yaml":         {assetsDnsMetricsRoleBindingYaml, map[string]*bintree{}},
				"role.yaml":                 {assetsDnsMetricsRoleYaml, map[string]*bintree{}},
			}},
			"namespace.yaml":       {assetsDnsNamespaceYaml, map[string]*bintree{}},
			"service-account.yaml": {assetsDnsServiceAccountYaml, map[string]*bintree{}},
			"service.yaml":         {assetsDnsServiceYaml, map[string]*bintree{}},
		}},
		"node-resolver": {nil, map[string]*bintree{
			"service-account.yaml":    {assetsNodeResolverServiceAccountYaml, map[string]*bintree{}},
			"update-node-resolver.sh": {assetsNodeResolverUpdateNodeResolverSh, map[string]*bintree{}},
		}},
	}},
}}

// RestoreAsset restores an asset under the given directory.
func RestoreAsset(dir, name string) error {
	data, err := Asset(name)
	if err != nil {
		return err
	}
	info, err := AssetInfo(name)
	if err != nil {
		return err
	}
	err = os.MkdirAll(_filePath(dir, filepath.Dir(name)), os.FileMode(0755))
	if err != nil {
		return err
	}
	err = ioutil.WriteFile(_filePath(dir, name), data, info.Mode())
	if err != nil {
		return err
	}
	return os.Chtimes(_filePath(dir, name), info.ModTime(), info.ModTime())
}

// RestoreAssets restores an asset under the given directory recursively.
func RestoreAssets(dir, name string) error {
	children, err := AssetDir(name)
	// File
	if err != nil {
		return RestoreAsset(dir, name)
	}
	// Dir
	for _, child := range children {
		err = RestoreAssets(dir, filepath.Join(name, child))
		if err != nil {
			return err
		}
	}
	return nil
}

func _filePath(dir, name string) string {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	return filepath.Join(append([]string{dir}, strings.Split(canonicalName, "/")...)...)
}
