// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigatewayv2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetIntegrationsInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	MaxResults *string `location:"querystring" locationName:"maxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetIntegrationsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIntegrationsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetIntegrationsInput"}

	if s.ApiId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApiId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetIntegrationsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ApiId != nil {
		v := *s.ApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "apiId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetIntegrationsOutput struct {
	_ struct{} `type:"structure"`

	Items []Integration `locationName:"items" type:"list"`

	// The next page of elements from this collection. Not valid for the last element
	// of the collection.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetIntegrationsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetIntegrationsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Items != nil {
		v := s.Items

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "items", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opGetIntegrations = "GetIntegrations"

// GetIntegrationsRequest returns a request value for making API operation for
// AmazonApiGatewayV2.
//
// Gets the Integrations for an API.
//
//    // Example sending a request using GetIntegrationsRequest.
//    req := client.GetIntegrationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetIntegrations
func (c *Client) GetIntegrationsRequest(input *GetIntegrationsInput) GetIntegrationsRequest {
	op := &aws.Operation{
		Name:       opGetIntegrations,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/apis/{apiId}/integrations",
	}

	if input == nil {
		input = &GetIntegrationsInput{}
	}

	req := c.newRequest(op, input, &GetIntegrationsOutput{})
	return GetIntegrationsRequest{Request: req, Input: input, Copy: c.GetIntegrationsRequest}
}

// GetIntegrationsRequest is the request type for the
// GetIntegrations API operation.
type GetIntegrationsRequest struct {
	*aws.Request
	Input *GetIntegrationsInput
	Copy  func(*GetIntegrationsInput) GetIntegrationsRequest
}

// Send marshals and sends the GetIntegrations API request.
func (r GetIntegrationsRequest) Send(ctx context.Context) (*GetIntegrationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetIntegrationsResponse{
		GetIntegrationsOutput: r.Request.Data.(*GetIntegrationsOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetIntegrationsResponse is the response type for the
// GetIntegrations API operation.
type GetIntegrationsResponse struct {
	*GetIntegrationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetIntegrations request.
func (r *GetIntegrationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
