package hdinsight

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/hdinsight/mgmt/2018-06-01-preview/hdinsight"

// AsyncOperationState enumerates the values for async operation state.
type AsyncOperationState string

const (
	// Failed ...
	Failed AsyncOperationState = "Failed"
	// InProgress ...
	InProgress AsyncOperationState = "InProgress"
	// Succeeded ...
	Succeeded AsyncOperationState = "Succeeded"
)

// PossibleAsyncOperationStateValues returns an array of possible values for the AsyncOperationState const type.
func PossibleAsyncOperationStateValues() []AsyncOperationState {
	return []AsyncOperationState{Failed, InProgress, Succeeded}
}

// ClusterProvisioningState enumerates the values for cluster provisioning state.
type ClusterProvisioningState string

const (
	// ClusterProvisioningStateCanceled ...
	ClusterProvisioningStateCanceled ClusterProvisioningState = "Canceled"
	// ClusterProvisioningStateDeleting ...
	ClusterProvisioningStateDeleting ClusterProvisioningState = "Deleting"
	// ClusterProvisioningStateFailed ...
	ClusterProvisioningStateFailed ClusterProvisioningState = "Failed"
	// ClusterProvisioningStateInProgress ...
	ClusterProvisioningStateInProgress ClusterProvisioningState = "InProgress"
	// ClusterProvisioningStateSucceeded ...
	ClusterProvisioningStateSucceeded ClusterProvisioningState = "Succeeded"
)

// PossibleClusterProvisioningStateValues returns an array of possible values for the ClusterProvisioningState const type.
func PossibleClusterProvisioningStateValues() []ClusterProvisioningState {
	return []ClusterProvisioningState{ClusterProvisioningStateCanceled, ClusterProvisioningStateDeleting, ClusterProvisioningStateFailed, ClusterProvisioningStateInProgress, ClusterProvisioningStateSucceeded}
}

// DirectoryType enumerates the values for directory type.
type DirectoryType string

const (
	// ActiveDirectory ...
	ActiveDirectory DirectoryType = "ActiveDirectory"
)

// PossibleDirectoryTypeValues returns an array of possible values for the DirectoryType const type.
func PossibleDirectoryTypeValues() []DirectoryType {
	return []DirectoryType{ActiveDirectory}
}

// JSONWebKeyEncryptionAlgorithm enumerates the values for json web key encryption algorithm.
type JSONWebKeyEncryptionAlgorithm string

const (
	// RSA15 ...
	RSA15 JSONWebKeyEncryptionAlgorithm = "RSA1_5"
	// RSAOAEP ...
	RSAOAEP JSONWebKeyEncryptionAlgorithm = "RSA-OAEP"
	// RSAOAEP256 ...
	RSAOAEP256 JSONWebKeyEncryptionAlgorithm = "RSA-OAEP-256"
)

// PossibleJSONWebKeyEncryptionAlgorithmValues returns an array of possible values for the JSONWebKeyEncryptionAlgorithm const type.
func PossibleJSONWebKeyEncryptionAlgorithmValues() []JSONWebKeyEncryptionAlgorithm {
	return []JSONWebKeyEncryptionAlgorithm{RSA15, RSAOAEP, RSAOAEP256}
}

// OSType enumerates the values for os type.
type OSType string

const (
	// Linux ...
	Linux OSType = "Linux"
	// Windows ...
	Windows OSType = "Windows"
)

// PossibleOSTypeValues returns an array of possible values for the OSType const type.
func PossibleOSTypeValues() []OSType {
	return []OSType{Linux, Windows}
}

// ResourceIdentityType enumerates the values for resource identity type.
type ResourceIdentityType string

const (
	// None ...
	None ResourceIdentityType = "None"
	// SystemAssigned ...
	SystemAssigned ResourceIdentityType = "SystemAssigned"
	// SystemAssignedUserAssigned ...
	SystemAssignedUserAssigned ResourceIdentityType = "SystemAssigned, UserAssigned"
	// UserAssigned ...
	UserAssigned ResourceIdentityType = "UserAssigned"
)

// PossibleResourceIdentityTypeValues returns an array of possible values for the ResourceIdentityType const type.
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return []ResourceIdentityType{None, SystemAssigned, SystemAssignedUserAssigned, UserAssigned}
}

// Tier enumerates the values for tier.
type Tier string

const (
	// Premium ...
	Premium Tier = "Premium"
	// Standard ...
	Standard Tier = "Standard"
)

// PossibleTierValues returns an array of possible values for the Tier const type.
func PossibleTierValues() []Tier {
	return []Tier{Premium, Standard}
}

// Application the HDInsight cluster application
type Application struct {
	autorest.Response `json:"-"`
	// Etag - The ETag for the application
	Etag *string `json:"etag,omitempty"`
	// Tags - The tags for the application.
	Tags map[string]*string `json:"tags"`
	// Properties - The properties of the application.
	Properties *ApplicationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Application.
func (a Application) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.Etag != nil {
		objectMap["etag"] = a.Etag
	}
	if a.Tags != nil {
		objectMap["tags"] = a.Tags
	}
	if a.Properties != nil {
		objectMap["properties"] = a.Properties
	}
	return json.Marshal(objectMap)
}

// ApplicationGetEndpoint gets the application SSH endpoint
type ApplicationGetEndpoint struct {
	// Location - The location of the endpoint.
	Location *string `json:"location,omitempty"`
	// DestinationPort - The destination port to connect to.
	DestinationPort *int32 `json:"destinationPort,omitempty"`
	// PublicPort - The public port to connect to.
	PublicPort *int32 `json:"publicPort,omitempty"`
}

// ApplicationGetHTTPSEndpoint gets the application HTTP endpoints.
type ApplicationGetHTTPSEndpoint struct {
	// AccessModes - The list of access modes for the application.
	AccessModes *[]string `json:"accessModes,omitempty"`
	// Location - The location of the endpoint.
	Location *string `json:"location,omitempty"`
	// DestinationPort - The destination port to connect to.
	DestinationPort *int32 `json:"destinationPort,omitempty"`
	// PublicPort - The public port to connect to.
	PublicPort *int32 `json:"publicPort,omitempty"`
	// SubDomainSuffix - The subDomainSuffix of the application and can not greater than 3 characters.
	SubDomainSuffix *string `json:"subDomainSuffix,omitempty"`
	// DisableGatewayAuth - The value indicates whether to disable GatewayAuth.
	DisableGatewayAuth *bool `json:"disableGatewayAuth,omitempty"`
}

// ApplicationListResult result of the request to list cluster Applications. It contains a list of
// operations and a URL link to get the next set of results.
type ApplicationListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of HDInsight applications installed on HDInsight cluster.
	Value *[]Application `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// ApplicationListResultIterator provides access to a complete listing of Application values.
type ApplicationListResultIterator struct {
	i    int
	page ApplicationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ApplicationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ApplicationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ApplicationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ApplicationListResultIterator) Response() ApplicationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ApplicationListResultIterator) Value() Application {
	if !iter.page.NotDone() {
		return Application{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ApplicationListResultIterator type.
func NewApplicationListResultIterator(page ApplicationListResultPage) ApplicationListResultIterator {
	return ApplicationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (alr ApplicationListResult) IsEmpty() bool {
	return alr.Value == nil || len(*alr.Value) == 0
}

// applicationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (alr ApplicationListResult) applicationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if alr.NextLink == nil || len(to.String(alr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(alr.NextLink)))
}

// ApplicationListResultPage contains a page of Application values.
type ApplicationListResultPage struct {
	fn  func(context.Context, ApplicationListResult) (ApplicationListResult, error)
	alr ApplicationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ApplicationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.alr)
	if err != nil {
		return err
	}
	page.alr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ApplicationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ApplicationListResultPage) NotDone() bool {
	return !page.alr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ApplicationListResultPage) Response() ApplicationListResult {
	return page.alr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ApplicationListResultPage) Values() []Application {
	if page.alr.IsEmpty() {
		return nil
	}
	return *page.alr.Value
}

// Creates a new instance of the ApplicationListResultPage type.
func NewApplicationListResultPage(getNextPage func(context.Context, ApplicationListResult) (ApplicationListResult, error)) ApplicationListResultPage {
	return ApplicationListResultPage{fn: getNextPage}
}

// ApplicationProperties the HDInsight cluster application GET response.
type ApplicationProperties struct {
	// ComputeProfile - The list of roles in the cluster.
	ComputeProfile *ComputeProfile `json:"computeProfile,omitempty"`
	// InstallScriptActions - The list of install script actions.
	InstallScriptActions *[]RuntimeScriptAction `json:"installScriptActions,omitempty"`
	// UninstallScriptActions - The list of uninstall script actions.
	UninstallScriptActions *[]RuntimeScriptAction `json:"uninstallScriptActions,omitempty"`
	// HTTPSEndpoints - The list of application HTTPS endpoints.
	HTTPSEndpoints *[]ApplicationGetHTTPSEndpoint `json:"httpsEndpoints,omitempty"`
	// SSHEndpoints - The list of application SSH endpoints.
	SSHEndpoints *[]ApplicationGetEndpoint `json:"sshEndpoints,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the application.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// ApplicationType - The application type.
	ApplicationType *string `json:"applicationType,omitempty"`
	// ApplicationState - READ-ONLY; The application state.
	ApplicationState *string `json:"applicationState,omitempty"`
	// Errors - The list of errors.
	Errors *[]Errors `json:"errors,omitempty"`
	// CreatedDate - READ-ONLY; The application create date time.
	CreatedDate *string `json:"createdDate,omitempty"`
	// MarketplaceIdentifier - READ-ONLY; The marketplace identifier.
	MarketplaceIdentifier *string `json:"marketplaceIdentifier,omitempty"`
}

// ApplicationsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ApplicationsCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ApplicationsCreateFuture) Result(client ApplicationsClient) (a Application, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ApplicationsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hdinsight.ApplicationsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if a.Response.Response, err = future.GetResult(sender); err == nil && a.Response.Response.StatusCode != http.StatusNoContent {
		a, err = client.CreateResponder(a.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "hdinsight.ApplicationsCreateFuture", "Result", a.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ApplicationsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ApplicationsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ApplicationsDeleteFuture) Result(client ApplicationsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ApplicationsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hdinsight.ApplicationsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// Cluster the HDInsight cluster.
type Cluster struct {
	autorest.Response `json:"-"`
	// Etag - The ETag for the resource
	Etag *string `json:"etag,omitempty"`
	// Properties - The properties of the cluster.
	Properties *ClusterGetProperties `json:"properties,omitempty"`
	// Identity - The identity of the cluster, if configured.
	Identity *ClusterIdentity `json:"identity,omitempty"`
	// Location - The Azure Region where the resource lives
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Cluster.
func (c Cluster) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.Etag != nil {
		objectMap["etag"] = c.Etag
	}
	if c.Properties != nil {
		objectMap["properties"] = c.Properties
	}
	if c.Identity != nil {
		objectMap["identity"] = c.Identity
	}
	if c.Location != nil {
		objectMap["location"] = c.Location
	}
	if c.Tags != nil {
		objectMap["tags"] = c.Tags
	}
	return json.Marshal(objectMap)
}

// ClusterConfigurations the configuration object for the specified cluster.
type ClusterConfigurations struct {
	autorest.Response `json:"-"`
	// Configurations - The configuration object for the specified configuration for the specified cluster.
	Configurations map[string]map[string]*string `json:"configurations"`
}

// MarshalJSON is the custom marshaler for ClusterConfigurations.
func (cc ClusterConfigurations) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cc.Configurations != nil {
		objectMap["configurations"] = cc.Configurations
	}
	return json.Marshal(objectMap)
}

// ClusterCreateParametersExtended the CreateCluster request parameters.
type ClusterCreateParametersExtended struct {
	// Location - The location of the cluster.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
	// Properties - The cluster create parameters.
	Properties *ClusterCreateProperties `json:"properties,omitempty"`
	// Identity - The identity of the cluster, if configured.
	Identity *ClusterIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterCreateParametersExtended.
func (ccpe ClusterCreateParametersExtended) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ccpe.Location != nil {
		objectMap["location"] = ccpe.Location
	}
	if ccpe.Tags != nil {
		objectMap["tags"] = ccpe.Tags
	}
	if ccpe.Properties != nil {
		objectMap["properties"] = ccpe.Properties
	}
	if ccpe.Identity != nil {
		objectMap["identity"] = ccpe.Identity
	}
	return json.Marshal(objectMap)
}

// ClusterCreateProperties the cluster create parameters.
type ClusterCreateProperties struct {
	// ClusterVersion - The version of the cluster.
	ClusterVersion *string `json:"clusterVersion,omitempty"`
	// OsType - The type of operating system. Possible values include: 'Windows', 'Linux'
	OsType OSType `json:"osType,omitempty"`
	// Tier - The cluster tier. Possible values include: 'Standard', 'Premium'
	Tier Tier `json:"tier,omitempty"`
	// ClusterDefinition - The cluster definition.
	ClusterDefinition *ClusterDefinition `json:"clusterDefinition,omitempty"`
	// SecurityProfile - The security profile.
	SecurityProfile *SecurityProfile `json:"securityProfile,omitempty"`
	// ComputeProfile - The compute profile.
	ComputeProfile *ComputeProfile `json:"computeProfile,omitempty"`
	// StorageProfile - The storage profile.
	StorageProfile *StorageProfile `json:"storageProfile,omitempty"`
	// DiskEncryptionProperties - The disk encryption properties.
	DiskEncryptionProperties *DiskEncryptionProperties `json:"diskEncryptionProperties,omitempty"`
}

// ClusterDefinition the cluster definition.
type ClusterDefinition struct {
	// Blueprint - The link to the blueprint.
	Blueprint *string `json:"blueprint,omitempty"`
	// Kind - The type of cluster.
	Kind *string `json:"kind,omitempty"`
	// ComponentVersion - The versions of different services in the cluster.
	ComponentVersion map[string]*string `json:"componentVersion"`
	// Configurations - The cluster configurations.
	Configurations interface{} `json:"configurations,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterDefinition.
func (cd ClusterDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cd.Blueprint != nil {
		objectMap["blueprint"] = cd.Blueprint
	}
	if cd.Kind != nil {
		objectMap["kind"] = cd.Kind
	}
	if cd.ComponentVersion != nil {
		objectMap["componentVersion"] = cd.ComponentVersion
	}
	if cd.Configurations != nil {
		objectMap["configurations"] = cd.Configurations
	}
	return json.Marshal(objectMap)
}

// ClusterDiskEncryptionParameters the Disk Encryption Cluster request parameters.
type ClusterDiskEncryptionParameters struct {
	// VaultURI - Base key vault URI where the customers key is located eg. https://myvault.vault.azure.net
	VaultURI *string `json:"vaultUri,omitempty"`
	// KeyName - Key name that is used for enabling disk encryption.
	KeyName *string `json:"keyName,omitempty"`
	// KeyVersion - Specific key version that is used for enabling disk encryption.
	KeyVersion *string `json:"keyVersion,omitempty"`
}

// ClusterGetProperties the properties of cluster.
type ClusterGetProperties struct {
	// ClusterVersion - The version of the cluster.
	ClusterVersion *string `json:"clusterVersion,omitempty"`
	// OsType - The type of operating system. Possible values include: 'Windows', 'Linux'
	OsType OSType `json:"osType,omitempty"`
	// Tier - The cluster tier. Possible values include: 'Standard', 'Premium'
	Tier Tier `json:"tier,omitempty"`
	// ClusterDefinition - The cluster definition.
	ClusterDefinition *ClusterDefinition `json:"clusterDefinition,omitempty"`
	// SecurityProfile - The security profile.
	SecurityProfile *SecurityProfile `json:"securityProfile,omitempty"`
	// ComputeProfile - The compute profile.
	ComputeProfile *ComputeProfile `json:"computeProfile,omitempty"`
	// ProvisioningState - The provisioning state, which only appears in the response. Possible values include: 'ClusterProvisioningStateInProgress', 'ClusterProvisioningStateFailed', 'ClusterProvisioningStateSucceeded', 'ClusterProvisioningStateCanceled', 'ClusterProvisioningStateDeleting'
	ProvisioningState ClusterProvisioningState `json:"provisioningState,omitempty"`
	// CreatedDate - The date on which the cluster was created.
	CreatedDate *string `json:"createdDate,omitempty"`
	// ClusterState - The state of the cluster.
	ClusterState *string `json:"clusterState,omitempty"`
	// QuotaInfo - The quota information.
	QuotaInfo *QuotaInfo `json:"quotaInfo,omitempty"`
	// Errors - The list of errors.
	Errors *[]Errors `json:"errors,omitempty"`
	// ConnectivityEndpoints - The list of connectivity endpoints.
	ConnectivityEndpoints *[]ConnectivityEndpoint `json:"connectivityEndpoints,omitempty"`
	// DiskEncryptionProperties - The disk encryption properties.
	DiskEncryptionProperties *DiskEncryptionProperties `json:"diskEncryptionProperties,omitempty"`
}

// ClusterIdentity identity for the cluster.
type ClusterIdentity struct {
	// PrincipalID - READ-ONLY; The principal id of cluster identity. This property will only be provided for a system assigned identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant id associated with the cluster. This property will only be provided for a system assigned identity.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The type of identity used for the cluster. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. Possible values include: 'SystemAssigned', 'UserAssigned', 'SystemAssignedUserAssigned', 'None'
	Type ResourceIdentityType `json:"type,omitempty"`
	// UserAssignedIdentities - The list of user identities associated with the cluster. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*ClusterIdentityUserAssignedIdentitiesValue `json:"userAssignedIdentities"`
}

// MarshalJSON is the custom marshaler for ClusterIdentity.
func (ci ClusterIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ci.Type != "" {
		objectMap["type"] = ci.Type
	}
	if ci.UserAssignedIdentities != nil {
		objectMap["userAssignedIdentities"] = ci.UserAssignedIdentities
	}
	return json.Marshal(objectMap)
}

// ClusterIdentityUserAssignedIdentitiesValue ...
type ClusterIdentityUserAssignedIdentitiesValue struct {
	// PrincipalID - READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// ClientID - READ-ONLY; The client id of user assigned identity.
	ClientID *string `json:"clientId,omitempty"`
}

// ClusterListPersistedScriptActionsResult the ListPersistedScriptActions operation response.
type ClusterListPersistedScriptActionsResult struct {
	// Value - The list of Persisted Script Actions.
	Value *[]RuntimeScriptAction `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ClusterListResult the List Cluster operation response.
type ClusterListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of Clusters.
	Value *[]Cluster `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ClusterListResultIterator provides access to a complete listing of Cluster values.
type ClusterListResultIterator struct {
	i    int
	page ClusterListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ClusterListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ClusterListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ClusterListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ClusterListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ClusterListResultIterator) Response() ClusterListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ClusterListResultIterator) Value() Cluster {
	if !iter.page.NotDone() {
		return Cluster{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ClusterListResultIterator type.
func NewClusterListResultIterator(page ClusterListResultPage) ClusterListResultIterator {
	return ClusterListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (clr ClusterListResult) IsEmpty() bool {
	return clr.Value == nil || len(*clr.Value) == 0
}

// clusterListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (clr ClusterListResult) clusterListResultPreparer(ctx context.Context) (*http.Request, error) {
	if clr.NextLink == nil || len(to.String(clr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(clr.NextLink)))
}

// ClusterListResultPage contains a page of Cluster values.
type ClusterListResultPage struct {
	fn  func(context.Context, ClusterListResult) (ClusterListResult, error)
	clr ClusterListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ClusterListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ClusterListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.clr)
	if err != nil {
		return err
	}
	page.clr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ClusterListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ClusterListResultPage) NotDone() bool {
	return !page.clr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ClusterListResultPage) Response() ClusterListResult {
	return page.clr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ClusterListResultPage) Values() []Cluster {
	if page.clr.IsEmpty() {
		return nil
	}
	return *page.clr.Value
}

// Creates a new instance of the ClusterListResultPage type.
func NewClusterListResultPage(getNextPage func(context.Context, ClusterListResult) (ClusterListResult, error)) ClusterListResultPage {
	return ClusterListResultPage{fn: getNextPage}
}

// ClusterListRuntimeScriptActionDetailResult the list runtime script action detail response.
type ClusterListRuntimeScriptActionDetailResult struct {
	// Value - READ-ONLY; The list of persisted script action details for the cluster.
	Value *[]RuntimeScriptActionDetail `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ClusterMonitoringRequest the Operations Management Suite (OMS) parameters.
type ClusterMonitoringRequest struct {
	// WorkspaceID - The Operations Management Suite (OMS) workspace ID.
	WorkspaceID *string `json:"workspaceId,omitempty"`
	// PrimaryKey - The Operations Management Suite (OMS) workspace key.
	PrimaryKey *string `json:"primaryKey,omitempty"`
}

// ClusterMonitoringResponse the Operations Management Suite (OMS) status response
type ClusterMonitoringResponse struct {
	autorest.Response `json:"-"`
	// ClusterMonitoringEnabled - The status of the Operations Management Suite (OMS) on the HDInsight cluster.
	ClusterMonitoringEnabled *bool `json:"clusterMonitoringEnabled,omitempty"`
	// WorkspaceID - The workspace ID of the Operations Management Suite (OMS) on the HDInsight cluster.
	WorkspaceID *string `json:"workspaceId,omitempty"`
}

// ClusterPatchParameters the PatchCluster request parameters
type ClusterPatchParameters struct {
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ClusterPatchParameters.
func (cpp ClusterPatchParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cpp.Tags != nil {
		objectMap["tags"] = cpp.Tags
	}
	return json.Marshal(objectMap)
}

// ClusterResizeParameters the Resize Cluster request parameters.
type ClusterResizeParameters struct {
	// TargetInstanceCount - The target instance count for the operation.
	TargetInstanceCount *int32 `json:"targetInstanceCount,omitempty"`
}

// ClustersCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ClustersCreateFuture) Result(client ClustersClient) (c Cluster, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ClustersCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hdinsight.ClustersCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if c.Response.Response, err = future.GetResult(sender); err == nil && c.Response.Response.StatusCode != http.StatusNoContent {
		c, err = client.CreateResponder(c.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "hdinsight.ClustersCreateFuture", "Result", c.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ClustersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ClustersDeleteFuture) Result(client ClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ClustersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hdinsight.ClustersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ClustersExecuteScriptActionsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ClustersExecuteScriptActionsFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ClustersExecuteScriptActionsFuture) Result(client ClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ClustersExecuteScriptActionsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hdinsight.ClustersExecuteScriptActionsFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ClustersResizeFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersResizeFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ClustersResizeFuture) Result(client ClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ClustersResizeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hdinsight.ClustersResizeFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ClustersRotateDiskEncryptionKeyFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ClustersRotateDiskEncryptionKeyFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ClustersRotateDiskEncryptionKeyFuture) Result(client ClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ClustersRotateDiskEncryptionKeyFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hdinsight.ClustersRotateDiskEncryptionKeyFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ClustersUpdateGatewaySettingsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ClustersUpdateGatewaySettingsFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ClustersUpdateGatewaySettingsFuture) Result(client ClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ClustersUpdateGatewaySettingsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hdinsight.ClustersUpdateGatewaySettingsFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ComputeProfile describes the compute profile.
type ComputeProfile struct {
	// Roles - The list of roles in the cluster.
	Roles *[]Role `json:"roles,omitempty"`
}

// ConfigurationsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ConfigurationsUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ConfigurationsUpdateFuture) Result(client ConfigurationsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ConfigurationsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hdinsight.ConfigurationsUpdateFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ConnectivityEndpoint the connectivity properties
type ConnectivityEndpoint struct {
	// Name - The name of the endpoint.
	Name *string `json:"name,omitempty"`
	// Protocol - The protocol of the endpoint.
	Protocol *string `json:"protocol,omitempty"`
	// Location - The location of the endpoint.
	Location *string `json:"location,omitempty"`
	// Port - The port to connect to.
	Port *int32 `json:"port,omitempty"`
}

// DataDisksGroups the data disks groups for the role.
type DataDisksGroups struct {
	// DisksPerNode - The number of disks per node.
	DisksPerNode *int32 `json:"disksPerNode,omitempty"`
	// StorageAccountType - READ-ONLY; ReadOnly. The storage account type. Do not set this value.
	StorageAccountType *string `json:"storageAccountType,omitempty"`
	// DiskSizeGB - READ-ONLY; ReadOnly. The DiskSize in GB. Do not set this value.
	DiskSizeGB *int32 `json:"diskSizeGB,omitempty"`
}

// DiskEncryptionProperties the disk encryption properties
type DiskEncryptionProperties struct {
	// VaultURI - Base key vault URI where the customers key is located eg. https://myvault.vault.azure.net
	VaultURI *string `json:"vaultUri,omitempty"`
	// KeyName - Key name that is used for enabling disk encryption.
	KeyName *string `json:"keyName,omitempty"`
	// KeyVersion - Specific key version that is used for enabling disk encryption.
	KeyVersion *string `json:"keyVersion,omitempty"`
	// EncryptionAlgorithm - Algorithm identifier for encryption, default RSA-OAEP. Possible values include: 'RSAOAEP', 'RSAOAEP256', 'RSA15'
	EncryptionAlgorithm JSONWebKeyEncryptionAlgorithm `json:"encryptionAlgorithm,omitempty"`
	// MsiResourceID - Resource ID of Managed Identity that is used to access the key vault.
	MsiResourceID *string `json:"msiResourceId,omitempty"`
}

// ErrorResponse describes the format of Error response.
type ErrorResponse struct {
	// Code - Error code
	Code *string `json:"code,omitempty"`
	// Message - Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// Errors the error message associated with the cluster creation.
type Errors struct {
	// Code - The error code.
	Code *string `json:"code,omitempty"`
	// Message - The error message.
	Message *string `json:"message,omitempty"`
}

// ExecuteScriptActionParameters the parameters for the script actions to execute on a running cluster.
type ExecuteScriptActionParameters struct {
	// ScriptActions - The list of run time script actions.
	ScriptActions *[]RuntimeScriptAction `json:"scriptActions,omitempty"`
	// PersistOnSuccess - Gets or sets if the scripts needs to be persisted.
	PersistOnSuccess *bool `json:"persistOnSuccess,omitempty"`
}

// Extension cluster monitoring extensions
type Extension struct {
	autorest.Response `json:"-"`
	// WorkspaceID - The workspace ID for the cluster monitoring extension.
	WorkspaceID *string `json:"workspaceId,omitempty"`
	// PrimaryKey - The certificate for the cluster monitoring extensions.
	PrimaryKey *string `json:"primaryKey,omitempty"`
}

// ExtensionsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ExtensionsCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ExtensionsCreateFuture) Result(client ExtensionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ExtensionsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hdinsight.ExtensionsCreateFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ExtensionsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ExtensionsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ExtensionsDeleteFuture) Result(client ExtensionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ExtensionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hdinsight.ExtensionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ExtensionsDisableMonitoringFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExtensionsDisableMonitoringFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ExtensionsDisableMonitoringFuture) Result(client ExtensionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ExtensionsDisableMonitoringFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hdinsight.ExtensionsDisableMonitoringFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ExtensionsEnableMonitoringFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExtensionsEnableMonitoringFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ExtensionsEnableMonitoringFuture) Result(client ExtensionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ExtensionsEnableMonitoringFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hdinsight.ExtensionsEnableMonitoringFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// GatewaySettings gateway settings.
type GatewaySettings struct {
	autorest.Response `json:"-"`
	// IsCredentialEnabled - READ-ONLY; Indicates whether or not the gateway settings based authorization is enabled.
	IsCredentialEnabled *string `json:"restAuthCredential.isEnabled,omitempty"`
	// UserName - READ-ONLY; The gateway settings user name.
	UserName *string `json:"restAuthCredential.username,omitempty"`
	// Password - READ-ONLY; The gateway settings user password.
	Password *string `json:"restAuthCredential.password,omitempty"`
}

// HardwareProfile the hardware profile.
type HardwareProfile struct {
	// VMSize - The size of the VM
	VMSize *string `json:"vmSize,omitempty"`
}

// LinuxOperatingSystemProfile the ssh username, password, and ssh public key.
type LinuxOperatingSystemProfile struct {
	// Username - The username.
	Username *string `json:"username,omitempty"`
	// Password - The password.
	Password *string `json:"password,omitempty"`
	// SSHProfile - The SSH profile.
	SSHProfile *SSHProfile `json:"sshProfile,omitempty"`
}

// LocalizedName the details about the localizable name of a type of usage.
type LocalizedName struct {
	// Value - The name of the used resource.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - The localized name of the used resource.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// Operation the HDInsight REST API operation.
type Operation struct {
	// Name - The operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - The service provider: Microsoft.HDInsight
	Provider *string `json:"provider,omitempty"`
	// Resource - The resource on which the operation is performed: Cluster, Applications, etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - The operation type: read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`
}

// OperationListResult result of the request to list HDInsight operations. It contains a list of operations
// and a URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of HDInsight operations supported by the HDInsight resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - The URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if olr.NextLink == nil || len(to.String(olr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.olr)
	if err != nil {
		return err
	}
	page.olr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{fn: getNextPage}
}

// OperationResource the azure async operation response.
type OperationResource struct {
	// Status - The async operation state. Possible values include: 'InProgress', 'Succeeded', 'Failed'
	Status AsyncOperationState `json:"status,omitempty"`
	// Error - The operation error information.
	Error *Errors `json:"error,omitempty"`
}

// OsProfile the Linux operation systems profile.
type OsProfile struct {
	// LinuxOperatingSystemProfile - The Linux OS profile.
	LinuxOperatingSystemProfile *LinuxOperatingSystemProfile `json:"linuxOperatingSystemProfile,omitempty"`
}

// ProxyResource the resource model definition for a ARM proxy resource. It will have everything other than
// required location and tags
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// QuotaInfo the quota properties for the cluster.
type QuotaInfo struct {
	// CoresUsed - The cores used by the cluster.
	CoresUsed *int32 `json:"coresUsed,omitempty"`
}

// Resource the core properties of ARM resources
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// Role describes a role on the cluster.
type Role struct {
	// Name - The name of the role.
	Name *string `json:"name,omitempty"`
	// MinInstanceCount - The minimum instance count of the cluster.
	MinInstanceCount *int32 `json:"minInstanceCount,omitempty"`
	// TargetInstanceCount - The instance count of the cluster.
	TargetInstanceCount *int32 `json:"targetInstanceCount,omitempty"`
	// HardwareProfile - The hardware profile.
	HardwareProfile *HardwareProfile `json:"hardwareProfile,omitempty"`
	// OsProfile - The operating system profile.
	OsProfile *OsProfile `json:"osProfile,omitempty"`
	// VirtualNetworkProfile - The virtual network profile.
	VirtualNetworkProfile *VirtualNetworkProfile `json:"virtualNetworkProfile,omitempty"`
	// DataDisksGroups - The data disks groups for the role.
	DataDisksGroups *[]DataDisksGroups `json:"dataDisksGroups,omitempty"`
	// ScriptActions - The list of script actions on the role.
	ScriptActions *[]ScriptAction `json:"scriptActions,omitempty"`
}

// RuntimeScriptAction describes a script action on a running cluster.
type RuntimeScriptAction struct {
	// Name - The name of the script action.
	Name *string `json:"name,omitempty"`
	// URI - The URI to the script.
	URI *string `json:"uri,omitempty"`
	// Parameters - The parameters for the script
	Parameters *string `json:"parameters,omitempty"`
	// Roles - The list of roles where script will be executed.
	Roles *[]string `json:"roles,omitempty"`
	// ApplicationName - READ-ONLY; The application name of the script action, if any.
	ApplicationName *string `json:"applicationName,omitempty"`
}

// RuntimeScriptActionDetail the execution details of a script action.
type RuntimeScriptActionDetail struct {
	autorest.Response `json:"-"`
	// ScriptExecutionID - READ-ONLY; The execution id of the script action.
	ScriptExecutionID *int64 `json:"scriptExecutionId,omitempty"`
	// StartTime - READ-ONLY; The start time of script action execution.
	StartTime *string `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; The end time of script action execution.
	EndTime *string `json:"endTime,omitempty"`
	// Status - READ-ONLY; The current execution status of the script action.
	Status *string `json:"status,omitempty"`
	// Operation - READ-ONLY; The reason why the script action was executed.
	Operation *string `json:"operation,omitempty"`
	// ExecutionSummary - READ-ONLY; The summary of script action execution result.
	ExecutionSummary *[]ScriptActionExecutionSummary `json:"executionSummary,omitempty"`
	// DebugInformation - READ-ONLY; The script action execution debug information.
	DebugInformation *string `json:"debugInformation,omitempty"`
	// Name - The name of the script action.
	Name *string `json:"name,omitempty"`
	// URI - The URI to the script.
	URI *string `json:"uri,omitempty"`
	// Parameters - The parameters for the script
	Parameters *string `json:"parameters,omitempty"`
	// Roles - The list of roles where script will be executed.
	Roles *[]string `json:"roles,omitempty"`
	// ApplicationName - READ-ONLY; The application name of the script action, if any.
	ApplicationName *string `json:"applicationName,omitempty"`
}

// ScriptAction describes a script action on role on the cluster.
type ScriptAction struct {
	// Name - The name of the script action.
	Name *string `json:"name,omitempty"`
	// URI - The URI to the script.
	URI *string `json:"uri,omitempty"`
	// Parameters - The parameters for the script provided.
	Parameters *string `json:"parameters,omitempty"`
}

// ScriptActionExecutionHistoryList the list script execution history response.
type ScriptActionExecutionHistoryList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of persisted script action details for the cluster.
	Value *[]RuntimeScriptActionDetail `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ScriptActionExecutionHistoryListIterator provides access to a complete listing of
// RuntimeScriptActionDetail values.
type ScriptActionExecutionHistoryListIterator struct {
	i    int
	page ScriptActionExecutionHistoryListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ScriptActionExecutionHistoryListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ScriptActionExecutionHistoryListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ScriptActionExecutionHistoryListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ScriptActionExecutionHistoryListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ScriptActionExecutionHistoryListIterator) Response() ScriptActionExecutionHistoryList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ScriptActionExecutionHistoryListIterator) Value() RuntimeScriptActionDetail {
	if !iter.page.NotDone() {
		return RuntimeScriptActionDetail{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ScriptActionExecutionHistoryListIterator type.
func NewScriptActionExecutionHistoryListIterator(page ScriptActionExecutionHistoryListPage) ScriptActionExecutionHistoryListIterator {
	return ScriptActionExecutionHistoryListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (saehl ScriptActionExecutionHistoryList) IsEmpty() bool {
	return saehl.Value == nil || len(*saehl.Value) == 0
}

// scriptActionExecutionHistoryListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (saehl ScriptActionExecutionHistoryList) scriptActionExecutionHistoryListPreparer(ctx context.Context) (*http.Request, error) {
	if saehl.NextLink == nil || len(to.String(saehl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(saehl.NextLink)))
}

// ScriptActionExecutionHistoryListPage contains a page of RuntimeScriptActionDetail values.
type ScriptActionExecutionHistoryListPage struct {
	fn    func(context.Context, ScriptActionExecutionHistoryList) (ScriptActionExecutionHistoryList, error)
	saehl ScriptActionExecutionHistoryList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ScriptActionExecutionHistoryListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ScriptActionExecutionHistoryListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.saehl)
	if err != nil {
		return err
	}
	page.saehl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ScriptActionExecutionHistoryListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ScriptActionExecutionHistoryListPage) NotDone() bool {
	return !page.saehl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ScriptActionExecutionHistoryListPage) Response() ScriptActionExecutionHistoryList {
	return page.saehl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ScriptActionExecutionHistoryListPage) Values() []RuntimeScriptActionDetail {
	if page.saehl.IsEmpty() {
		return nil
	}
	return *page.saehl.Value
}

// Creates a new instance of the ScriptActionExecutionHistoryListPage type.
func NewScriptActionExecutionHistoryListPage(getNextPage func(context.Context, ScriptActionExecutionHistoryList) (ScriptActionExecutionHistoryList, error)) ScriptActionExecutionHistoryListPage {
	return ScriptActionExecutionHistoryListPage{fn: getNextPage}
}

// ScriptActionExecutionSummary the execution summary of a script action.
type ScriptActionExecutionSummary struct {
	// Status - READ-ONLY; The status of script action execution.
	Status *string `json:"status,omitempty"`
	// InstanceCount - READ-ONLY; The instance count for a given script action execution status.
	InstanceCount *int32 `json:"instanceCount,omitempty"`
}

// ScriptActionPersistedGetResponseSpec the persisted script action for cluster.
type ScriptActionPersistedGetResponseSpec struct {
	// Name - The name of script action.
	Name *string `json:"name,omitempty"`
	// URI - The URI to the script.
	URI *string `json:"uri,omitempty"`
	// Parameters - The parameters for the script provided.
	Parameters *string `json:"parameters,omitempty"`
	// Roles - The list of roles where script will be executed.
	Roles *[]string `json:"roles,omitempty"`
	// ApplicationName - The application name for the script action.
	ApplicationName *string `json:"applicationName,omitempty"`
}

// ScriptActionsList the persisted script action for the cluster.
type ScriptActionsList struct {
	autorest.Response `json:"-"`
	// Value - The list of persisted script action details for the cluster.
	Value *[]RuntimeScriptActionDetail `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ScriptActionsListIterator provides access to a complete listing of RuntimeScriptActionDetail values.
type ScriptActionsListIterator struct {
	i    int
	page ScriptActionsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ScriptActionsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ScriptActionsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ScriptActionsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ScriptActionsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ScriptActionsListIterator) Response() ScriptActionsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ScriptActionsListIterator) Value() RuntimeScriptActionDetail {
	if !iter.page.NotDone() {
		return RuntimeScriptActionDetail{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ScriptActionsListIterator type.
func NewScriptActionsListIterator(page ScriptActionsListPage) ScriptActionsListIterator {
	return ScriptActionsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sal ScriptActionsList) IsEmpty() bool {
	return sal.Value == nil || len(*sal.Value) == 0
}

// scriptActionsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sal ScriptActionsList) scriptActionsListPreparer(ctx context.Context) (*http.Request, error) {
	if sal.NextLink == nil || len(to.String(sal.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sal.NextLink)))
}

// ScriptActionsListPage contains a page of RuntimeScriptActionDetail values.
type ScriptActionsListPage struct {
	fn  func(context.Context, ScriptActionsList) (ScriptActionsList, error)
	sal ScriptActionsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ScriptActionsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ScriptActionsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.sal)
	if err != nil {
		return err
	}
	page.sal = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ScriptActionsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ScriptActionsListPage) NotDone() bool {
	return !page.sal.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ScriptActionsListPage) Response() ScriptActionsList {
	return page.sal
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ScriptActionsListPage) Values() []RuntimeScriptActionDetail {
	if page.sal.IsEmpty() {
		return nil
	}
	return *page.sal.Value
}

// Creates a new instance of the ScriptActionsListPage type.
func NewScriptActionsListPage(getNextPage func(context.Context, ScriptActionsList) (ScriptActionsList, error)) ScriptActionsListPage {
	return ScriptActionsListPage{fn: getNextPage}
}

// SecurityProfile the security profile which contains Ssh public key for the HDInsight cluster.
type SecurityProfile struct {
	// DirectoryType - The directory type. Possible values include: 'ActiveDirectory'
	DirectoryType DirectoryType `json:"directoryType,omitempty"`
	// Domain - The organization's active directory domain.
	Domain *string `json:"domain,omitempty"`
	// OrganizationalUnitDN - The organizational unit within the Active Directory to place the cluster and service accounts.
	OrganizationalUnitDN *string `json:"organizationalUnitDN,omitempty"`
	// LdapsUrls - The LDAPS protocol URLs to communicate with the Active Directory.
	LdapsUrls *[]string `json:"ldapsUrls,omitempty"`
	// DomainUsername - The domain user account that will have admin privileges on the cluster.
	DomainUsername *string `json:"domainUsername,omitempty"`
	// DomainUserPassword - The domain admin password.
	DomainUserPassword *string `json:"domainUserPassword,omitempty"`
	// ClusterUsersGroupDNS - Optional. The Distinguished Names for cluster user groups
	ClusterUsersGroupDNS *[]string `json:"clusterUsersGroupDNs,omitempty"`
	// AaddsResourceID - The resource ID of the user's Azure Active Directory Domain Service.
	AaddsResourceID *string `json:"aaddsResourceId,omitempty"`
	// MsiResourceID - User assigned identity that has permissions to read and create cluster-related artifacts in the user's AADDS.
	MsiResourceID *string `json:"msiResourceId,omitempty"`
}

// SetString ...
type SetString struct {
	autorest.Response `json:"-"`
	Value             map[string]*string `json:"value"`
}

// MarshalJSON is the custom marshaler for SetString.
func (ss SetString) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ss.Value != nil {
		objectMap["value"] = ss.Value
	}
	return json.Marshal(objectMap)
}

// SSHProfile the list of SSH public keys.
type SSHProfile struct {
	// PublicKeys - The list of SSH public keys.
	PublicKeys *[]SSHPublicKey `json:"publicKeys,omitempty"`
}

// SSHPublicKey the SSH public key for the cluster nodes.
type SSHPublicKey struct {
	// CertificateData - The certificate for SSH.
	CertificateData *string `json:"certificateData,omitempty"`
}

// StorageAccount the storage Account.
type StorageAccount struct {
	// Name - The name of the storage account.
	Name *string `json:"name,omitempty"`
	// IsDefault - Whether or not the storage account is the default storage account.
	IsDefault *bool `json:"isDefault,omitempty"`
	// Container - The container in the storage account, only to be specified for WASB storage accounts.
	Container *string `json:"container,omitempty"`
	// FileSystem - The filesystem, only to be specified for Azure Data Lake Storage type Gen 2.
	FileSystem *string `json:"fileSystem,omitempty"`
	// Key - The storage account access key.
	Key *string `json:"key,omitempty"`
	// ResourceID - The resource ID of storage account, only to be specified for Azure Data Lake Storage Gen 2.
	ResourceID *string `json:"resourceId,omitempty"`
	// MsiResourceID - The managed identity (MSI) that is allowed to access the storage account, only to be specified for Azure Data Lake Storage Gen 2.
	MsiResourceID *string `json:"msiResourceId,omitempty"`
}

// StorageProfile the storage profile.
type StorageProfile struct {
	// Storageaccounts - The list of storage accounts in the cluster.
	Storageaccounts *[]StorageAccount `json:"storageaccounts,omitempty"`
}

// TrackedResource the resource model definition for a ARM tracked top level resource
type TrackedResource struct {
	// Location - The Azure Region where the resource lives
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	return json.Marshal(objectMap)
}

// UpdateGatewaySettingsParameters the update gateway settings request parameters.
type UpdateGatewaySettingsParameters struct {
	// IsCredentialEnabled - Indicates whether or not the gateway settings based authorization is enabled.
	IsCredentialEnabled *bool `json:"restAuthCredential.isEnabled,omitempty"`
	// UserName - The gateway settings user name.
	UserName *string `json:"restAuthCredential.username,omitempty"`
	// Password - The gateway settings user password.
	Password *string `json:"restAuthCredential.password,omitempty"`
}

// Usage the details about the usage of a particular limited resource.
type Usage struct {
	// Unit - The type of measurement for usage.
	Unit *string `json:"unit,omitempty"`
	// CurrentValue - The current usage.
	CurrentValue *int32 `json:"currentValue,omitempty"`
	// Limit - The maximum allowed usage.
	Limit *int32 `json:"limit,omitempty"`
	// Name - The details about the localizable name of the used resource.
	Name *LocalizedName `json:"name,omitempty"`
}

// UsagesListResult the response for the operation to get regional usages for a subscription.
type UsagesListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of usages.
	Value *[]Usage `json:"value,omitempty"`
}

// VirtualNetworkProfile the virtual network properties.
type VirtualNetworkProfile struct {
	// ID - The ID of the virtual network.
	ID *string `json:"id,omitempty"`
	// Subnet - The name of the subnet.
	Subnet *string `json:"subnet,omitempty"`
}
