package v1

// This file contains a collection of methods that can be used from go-restful to
// generate Swagger API documentation for its models. Please read this PR for more
// information on the implementation: https://github.com/emicklei/go-restful/pull/215
//
// TODOs are ignored from the parser (e.g. TODO(andronat):... || TODO:...) if and only if
// they are on one line! For multiple line or blocks that you want to ignore use ---.
// Any context after a --- is ignored.
//
// Those methods can be generated by using hack/update-swagger-docs.sh

// AUTO-GENERATED FUNCTIONS START HERE
var map_CloudPrivateIPConfig = map[string]string{
	"":       "CloudPrivateIPConfig performs an assignment of a private IP address to the primary NIC associated with cloud VMs. This is done by specifying the IP and Kubernetes node which the IP should be assigned to. This CRD is intended to be used by the network plugin which manages the cluster network. The spec side represents the desired state requested by the network plugin, and the status side represents the current state that this CRD's controller has executed. No users will have permission to modify it, and if a cluster-admin decides to edit it for some reason, their changes will be overwritten the next time the network plugin reconciles the object. Note: the CR's name must specify the requested private IP address (can be IPv4 or IPv6).",
	"spec":   "spec is the definition of the desired private IP request.",
	"status": "status is the observed status of the desired private IP request. Read-only.",
}

func (CloudPrivateIPConfig) SwaggerDoc() map[string]string {
	return map_CloudPrivateIPConfig
}

var map_CloudPrivateIPConfigList = map[string]string{
	"":      "CloudPrivateIPConfigList is the list of CloudPrivateIPConfigList.",
	"items": "List of CloudPrivateIPConfig.",
}

func (CloudPrivateIPConfigList) SwaggerDoc() map[string]string {
	return map_CloudPrivateIPConfigList
}

var map_CloudPrivateIPConfigSpec = map[string]string{
	"":     "CloudPrivateIPConfigSpec consists of a node name which the private IP should be assigned to.",
	"node": "node is the node name, as specified by the Kubernetes field: node.metadata.name",
}

func (CloudPrivateIPConfigSpec) SwaggerDoc() map[string]string {
	return map_CloudPrivateIPConfigSpec
}

var map_CloudPrivateIPConfigStatus = map[string]string{
	"":           "CloudPrivateIPConfigStatus specifies the node assignment together with its assignment condition.",
	"node":       "node is the node name, as specified by the Kubernetes field: node.metadata.name",
	"conditions": "condition is the assignment condition of the private IP and its status",
}

func (CloudPrivateIPConfigStatus) SwaggerDoc() map[string]string {
	return map_CloudPrivateIPConfigStatus
}

// AUTO-GENERATED FUNCTIONS END HERE
