package misspell

import (
	"sort"
	"testing"
)

type sortByLen []string

func (a sortByLen) Len() int      { return len(a) }
func (a sortByLen) Swap(i, j int) { a[i], a[j] = a[j], a[i] }
func (a sortByLen) Less(i, j int) bool {
	if len(a[i]) == len(a[j]) {
		// if words are same size, then use
		// normal alphabetical order
		return a[i] < a[j]
	}
	// INVERTED  -- biggest words first
	return len(a[i]) > len(a[j])
}

func TestWordSort(t *testing.T) {
	if len(DictMain)%2 == 1 {
		t.Errorf("Dictionary is a not a multiple of 2")
	}
	words := make([]string, 0, len(DictMain)/2)
	for i := 0; i < len(DictMain); i += 2 {
		words = append(words, DictMain[i])
	}
	if !sort.IsSorted(sortByLen(words)) {
		t.Errorf("Words not sorted by len, by alpha!")
		t.Errorf("Words.go is autogenerated -- do not edit.")
		t.Errorf("File issue instead.")
	}
}
