---
title: Join the Contour Tech Docs Working Group
excerpt: Announcing Contour Technical Documentation Working Group
author_name: Contour Team
author_avatar: /img/contributors/orlin-vasilev.jpg
categories: [kubernetes]
tags: ['Contour Team', 'Abigail McCarthy', 'Docs' ,'Docs-WG', 'Jonas Rosland', 'Orlin Vasilev']
date: 2021-06-10
slug: docs-wg
---

The Contour team is excited to announce we are launching a technical documentation working group. This group will focus on improving the Contour website, documentation, and processes around content creation.

# Because documentation makes a difference

In 2017, GitHub conducted the [Open Source Survey](https://opensourcesurvey.org/2017/), which sampled 5,500 respondents. One of the key takeaways was that “documentation is highly valued, but often overlooked.” The survey found that outdated or confusing documentation was a major problem, affecting 93% of respondents. Yet 60% of contributors rarely or never contribute to documentation. We want this working group to be an opportunity to give back to the community by helping to improve the docs.

# The purpose and scope of the Working Group

The purpose of the Working Group is to build up a self-sustaining community around documentation for Contour. We have an initial need to rework the existing documentation based on the recommendations outlined in the [CNCF Tech Docs Review](https://github.com/cncf/techdocs/blob/main/assessments/0001-contour.md), and a continuous need for documentation being added/edited/removed for releases going forward.
This group is open to contributors of all levels, the only requirement is being interested in helping with docs!

# How to participate
Join us for our kickoff meeting on June 17th at 1PM Eastern Standard/Daylight Time [Time zone converter](https://www.timeanddate.com/worldclock/usa/boston) as part of the Contour Office Hours. During the kickoff meeting, we’ll have an information session about this working group, covering the following topics

- Working Group participation
- The docs tool chain and how to set up your environment
- How to preview the documentation locally before submitting a pull request
- Anything else you’d like to know about helping with Contour documentation!

We’ll be continuing to hold Working Group meetings and information sessions during the regular Contour Office Hours time every 1st and 3rd Thursday at 1PM after the kickoff meeting. 
Get the invite to the Contour Office Hours by joining the [Contour mailing list](https://lists.cncf.io/g/cncf-contour-users/).

You can find the [Contributing Guide here](/resources/contributing-docs).
# We look forward to seeing you!
Thank you for being willing to take time from your schedule to participate in the Contour Tech Docs Working Group. Your help will drive new user guides and better documentation for the project, enriching the community for everyone by teaching new and experienced contributors and users the fundamental concepts of Contour and how to use it.
We hope to see you soon!

# Authors
- Abigail McCarthy - @a-mccarthy
- Jonas Rosland - @jonasrosland
- Orlin Vasilev - @OrlinVasilev
