/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
	v1alpha1 "sigs.k8s.io/gateway-api/apis/v1alpha1"
	scheme "sigs.k8s.io/gateway-api/pkg/client/clientset/versioned/scheme"
)

// BackendPoliciesGetter has a method to return a BackendPolicyInterface.
// A group's client should implement this interface.
type BackendPoliciesGetter interface {
	BackendPolicies(namespace string) BackendPolicyInterface
}

// BackendPolicyInterface has methods to work with BackendPolicy resources.
type BackendPolicyInterface interface {
	Create(ctx context.Context, backendPolicy *v1alpha1.BackendPolicy, opts v1.CreateOptions) (*v1alpha1.BackendPolicy, error)
	Update(ctx context.Context, backendPolicy *v1alpha1.BackendPolicy, opts v1.UpdateOptions) (*v1alpha1.BackendPolicy, error)
	UpdateStatus(ctx context.Context, backendPolicy *v1alpha1.BackendPolicy, opts v1.UpdateOptions) (*v1alpha1.BackendPolicy, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.BackendPolicy, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.BackendPolicyList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.BackendPolicy, err error)
	BackendPolicyExpansion
}

// backendPolicies implements BackendPolicyInterface
type backendPolicies struct {
	client rest.Interface
	ns     string
}

// newBackendPolicies returns a BackendPolicies
func newBackendPolicies(c *NetworkingV1alpha1Client, namespace string) *backendPolicies {
	return &backendPolicies{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the backendPolicy, and returns the corresponding backendPolicy object, and an error if there is any.
func (c *backendPolicies) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.BackendPolicy, err error) {
	result = &v1alpha1.BackendPolicy{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("backendpolicies").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of BackendPolicies that match those selectors.
func (c *backendPolicies) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.BackendPolicyList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.BackendPolicyList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("backendpolicies").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested backendPolicies.
func (c *backendPolicies) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("backendpolicies").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a backendPolicy and creates it.  Returns the server's representation of the backendPolicy, and an error, if there is any.
func (c *backendPolicies) Create(ctx context.Context, backendPolicy *v1alpha1.BackendPolicy, opts v1.CreateOptions) (result *v1alpha1.BackendPolicy, err error) {
	result = &v1alpha1.BackendPolicy{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("backendpolicies").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(backendPolicy).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a backendPolicy and updates it. Returns the server's representation of the backendPolicy, and an error, if there is any.
func (c *backendPolicies) Update(ctx context.Context, backendPolicy *v1alpha1.BackendPolicy, opts v1.UpdateOptions) (result *v1alpha1.BackendPolicy, err error) {
	result = &v1alpha1.BackendPolicy{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("backendpolicies").
		Name(backendPolicy.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(backendPolicy).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *backendPolicies) UpdateStatus(ctx context.Context, backendPolicy *v1alpha1.BackendPolicy, opts v1.UpdateOptions) (result *v1alpha1.BackendPolicy, err error) {
	result = &v1alpha1.BackendPolicy{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("backendpolicies").
		Name(backendPolicy.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(backendPolicy).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the backendPolicy and deletes it. Returns an error if one occurs.
func (c *backendPolicies) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("backendpolicies").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *backendPolicies) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("backendpolicies").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched backendPolicy.
func (c *backendPolicies) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.BackendPolicy, err error) {
	result = &v1alpha1.BackendPolicy{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("backendpolicies").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
