// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package opsworks

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type SetTimeBasedAutoScalingInput struct {
	_ struct{} `type:"structure"`

	// An AutoScalingSchedule with the instance schedule.
	AutoScalingSchedule *WeeklyAutoScalingSchedule `type:"structure"`

	// The instance ID.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SetTimeBasedAutoScalingInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetTimeBasedAutoScalingInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SetTimeBasedAutoScalingInput"}

	if s.InstanceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type SetTimeBasedAutoScalingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetTimeBasedAutoScalingOutput) String() string {
	return awsutil.Prettify(s)
}

const opSetTimeBasedAutoScaling = "SetTimeBasedAutoScaling"

// SetTimeBasedAutoScalingRequest returns a request value for making API operation for
// AWS OpsWorks.
//
// Specify the time-based auto scaling configuration for a specified instance.
// For more information, see Managing Load with Time-based and Load-based Instances
// (https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-autoscaling.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
//    // Example sending a request using SetTimeBasedAutoScalingRequest.
//    req := client.SetTimeBasedAutoScalingRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/SetTimeBasedAutoScaling
func (c *Client) SetTimeBasedAutoScalingRequest(input *SetTimeBasedAutoScalingInput) SetTimeBasedAutoScalingRequest {
	op := &aws.Operation{
		Name:       opSetTimeBasedAutoScaling,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetTimeBasedAutoScalingInput{}
	}

	req := c.newRequest(op, input, &SetTimeBasedAutoScalingOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return SetTimeBasedAutoScalingRequest{Request: req, Input: input, Copy: c.SetTimeBasedAutoScalingRequest}
}

// SetTimeBasedAutoScalingRequest is the request type for the
// SetTimeBasedAutoScaling API operation.
type SetTimeBasedAutoScalingRequest struct {
	*aws.Request
	Input *SetTimeBasedAutoScalingInput
	Copy  func(*SetTimeBasedAutoScalingInput) SetTimeBasedAutoScalingRequest
}

// Send marshals and sends the SetTimeBasedAutoScaling API request.
func (r SetTimeBasedAutoScalingRequest) Send(ctx context.Context) (*SetTimeBasedAutoScalingResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SetTimeBasedAutoScalingResponse{
		SetTimeBasedAutoScalingOutput: r.Request.Data.(*SetTimeBasedAutoScalingOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SetTimeBasedAutoScalingResponse is the response type for the
// SetTimeBasedAutoScaling API operation.
type SetTimeBasedAutoScalingResponse struct {
	*SetTimeBasedAutoScalingOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SetTimeBasedAutoScaling request.
func (r *SetTimeBasedAutoScalingResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
