---
title: Announcing Contour v1.13.0
excerpt: Contour 1.13 adds Gateway API and global rate limiting support.
author_name: Daneyon Hansen
author_avatar: /img/contributors/daneyon-hansen.jpg
categories: [kubernetes]
tags: ['Contour Team', 'Daneyon Hansen']
date: 2021-02-25
slug: contour_v1130
---

Contour continues to add new features to help you better manage ingress operations in a cluster.
Our latest release, Contour 1.13.0, adds several new features. This post will focus on two of the
features, support for [Gateway API][1] and [global rate limiting][2].

## Gateway API

__FEATURE STATE:__ Contour v1.13.0 [alpha][3]

Contour now provides alpha support for [Gateway API][1], an open source project to evolve service
networking APIs within the Kubernetes ecosystem. Gateway API consists of multiple resources that provide
user interfaces to expose Kubernetes applications- Services, Ingress, and more.

Support for Gateway API is implemented across Contour and [Contour Operator][5]. This approach aligns
with the [personas][15] defined by Gateway API. The operator manages infrastructure-level resources, i.e.
[Gateway][6], while Contour manages application-level resources such as [HTTPRoute][7].

Refer to the [user guide][4] for additional details and to start using Gateway API with Contour.

A big thanks to [@stevesloka](https://github.com/stevesloka) and [@youngnick](https://github.com/youngnick),
for designing and implementing this feature!

## Global Rate Limiting

Contour now supports [global rate limiting][8], where Envoy communicates with an external Rate Limit Service
(RLS) over gRPC to make rate limit decisions for requests. Envoy is configured to produce 1+ descriptors for
incoming requests, containing things like the client IP, header values, etc. Envoy sends these descriptors
to the RLS, and the service returns a rate limiting decision to Envoy based on the descriptors and RLS
configured rate limits.

To use global rate limiting with Contour, you'll need to:
- Choose and deploy an RLS. There is an [Envoy rate limit service][9] implementation, but any service that
  implements the [RateLimitService gRPC interface][10] is supported.
- Configure Contour for the RLS.
- Add a global rate limit policy to your `HTTPProxy`.
- Define rate limits in your RLS config.

Refer to the [Contour global rate limiting guide][11] for using the feature with Envoy RLS as an example.

For more information, see:
- [Contour rate limiting documentation][12]
- [HTTPProxy API reference][13]
- [Envoy HTTP global rate limit filter documentation][14]

A big thanks to [@skriss](https://github.com/skriss) for designing and implementing this feature!

## Additional Information

Refer to the [v1.13.0 release notes][16] for additional information.

## Community Thanks!
We’re immensely grateful for all the community contributions that help make Contour even better!
For version 1.13, special thanks go out to the following contributors:

- [@xtreme-jesse-malone](https://github.com/xtreme-jesse-malone)
- [@abhide](https://github.com/abhide)
- [@seemiller](https://github.com/seemiller)

[1]: https://gateway-api.sigs.k8s.io/
[2]: https://www.envoyproxy.io/docs/envoy/v1.17.0/intro/arch_overview/other_features/global_rate_limiting.html
[3]: https://projectcontour.io/resources/deprecation-policy/
[4]: https://projectcontour.io/guides/gateway-api/
[5]: https://github.com/projectcontour/contour-operator
[6]: https://gateway-api.sigs.k8s.io/gateway/
[7]: https://gateway-api.sigs.k8s.io/httproute/
[8]: https://www.envoyproxy.io/docs/envoy/latest/intro/arch_overview/other_features/global_rate_limiting
[9]: https://github.com/envoyproxy/ratelimit
[10]: https://www.envoyproxy.io/docs/envoy/latest/api-v3/service/ratelimit/v3/rls.proto
[11]: https://projectcontour.io/guides/global-rate-limiting/
[12]: https://projectcontour.io/docs/v1.13.0/config/rate-limiting/
[13]: https://projectcontour.io/docs/v1.13.0/config/api/#projectcontour.io/v1.GlobalRateLimitPolicy
[14]: https://www.envoyproxy.io/docs/envoy/v1.17.0/configuration/http/http_filters/rate_limit_filter
[15]: https://gateway-api.sigs.k8s.io/api-overview/#roles-and-personas
[16]: https://github.com/projectcontour/contour/releases/tag/v1.13.0
