/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
	v1alpha1 "sigs.k8s.io/gateway-api/apis/v1alpha1"
)

// UDPRouteLister helps list UDPRoutes.
// All objects returned here must be treated as read-only.
type UDPRouteLister interface {
	// List lists all UDPRoutes in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1alpha1.UDPRoute, err error)
	// UDPRoutes returns an object that can list and get UDPRoutes.
	UDPRoutes(namespace string) UDPRouteNamespaceLister
	UDPRouteListerExpansion
}

// uDPRouteLister implements the UDPRouteLister interface.
type uDPRouteLister struct {
	indexer cache.Indexer
}

// NewUDPRouteLister returns a new UDPRouteLister.
func NewUDPRouteLister(indexer cache.Indexer) UDPRouteLister {
	return &uDPRouteLister{indexer: indexer}
}

// List lists all UDPRoutes in the indexer.
func (s *uDPRouteLister) List(selector labels.Selector) (ret []*v1alpha1.UDPRoute, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.UDPRoute))
	})
	return ret, err
}

// UDPRoutes returns an object that can list and get UDPRoutes.
func (s *uDPRouteLister) UDPRoutes(namespace string) UDPRouteNamespaceLister {
	return uDPRouteNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// UDPRouteNamespaceLister helps list and get UDPRoutes.
// All objects returned here must be treated as read-only.
type UDPRouteNamespaceLister interface {
	// List lists all UDPRoutes in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1alpha1.UDPRoute, err error)
	// Get retrieves the UDPRoute from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1alpha1.UDPRoute, error)
	UDPRouteNamespaceListerExpansion
}

// uDPRouteNamespaceLister implements the UDPRouteNamespaceLister
// interface.
type uDPRouteNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all UDPRoutes in the indexer for a given namespace.
func (s uDPRouteNamespaceLister) List(selector labels.Selector) (ret []*v1alpha1.UDPRoute, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.UDPRoute))
	})
	return ret, err
}

// Get retrieves the UDPRoute from the indexer for a given namespace and name.
func (s uDPRouteNamespaceLister) Get(name string) (*v1alpha1.UDPRoute, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("udproute"), name)
	}
	return obj.(*v1alpha1.UDPRoute), nil
}
