/*
Copyright 2021 The cert-manager Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package plugins

import (
	"context"

	admissionv1 "k8s.io/api/admission/v1"
	"k8s.io/apimachinery/pkg/runtime"
	"k8s.io/apimachinery/pkg/util/validation/field"
	"k8s.io/client-go/kubernetes"
)

// Plugin is an admission plugin that will run during admission webhook events.
type Plugin interface {
	Init(client kubernetes.Interface)
	Validate(ctx context.Context, admissionSpec *admissionv1.AdmissionRequest, oldObj, obj runtime.Object) *field.Error
}

func All(scheme *runtime.Scheme) []Plugin {
	return []Plugin{
		newApproval(scheme),
	}
}
