// Code generated by gen.go; DO NOT EDIT.

package githubv4

// Input represents one of the Input structs:
//
// AcceptTopicSuggestionInput, AddCommentInput, AddProjectCardInput, AddProjectColumnInput, AddPullRequestReviewCommentInput, AddPullRequestReviewInput, AddReactionInput, AddStarInput, CommitAuthor, CreateProjectInput, DeclineTopicSuggestionInput, DeleteProjectCardInput, DeleteProjectColumnInput, DeleteProjectInput, DeletePullRequestReviewInput, DismissPullRequestReviewInput, DraftPullRequestReviewComment, GistOrder, IssueOrder, LanguageOrder, LockLockableInput, MilestoneOrder, MoveProjectCardInput, MoveProjectColumnInput, ProjectOrder, ReactionOrder, RefOrder, ReleaseOrder, RemoveOutsideCollaboratorInput, RemoveReactionInput, RemoveStarInput, RepositoryOrder, RequestReviewsInput, StarOrder, SubmitPullRequestReviewInput, TeamMemberOrder, TeamOrder, TeamRepositoryOrder, UpdateProjectCardInput, UpdateProjectColumnInput, UpdateProjectInput, UpdatePullRequestReviewCommentInput, UpdatePullRequestReviewInput, UpdateSubscriptionInput, UpdateTopicsInput.
type Input interface{}

// AcceptTopicSuggestionInput is an autogenerated input type of AcceptTopicSuggestion.
type AcceptTopicSuggestionInput struct {
	// The Node ID of the repository. (Required.)
	RepositoryID ID `json:"repositoryId"`
	// The name of the suggested topic. (Required.)
	Name String `json:"name"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// AddCommentInput is an autogenerated input type of AddComment.
type AddCommentInput struct {
	// The Node ID of the subject to modify. (Required.)
	SubjectID ID `json:"subjectId"`
	// The contents of the comment. (Required.)
	Body String `json:"body"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// AddProjectCardInput is an autogenerated input type of AddProjectCard.
type AddProjectCardInput struct {
	// The Node ID of the ProjectColumn. (Required.)
	ProjectColumnID ID `json:"projectColumnId"`

	// The content of the card. Must be a member of the ProjectCardItem union. (Optional.)
	ContentID *ID `json:"contentId,omitempty"`
	// The note on the card. (Optional.)
	Note *String `json:"note,omitempty"`
	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// AddProjectColumnInput is an autogenerated input type of AddProjectColumn.
type AddProjectColumnInput struct {
	// The Node ID of the project. (Required.)
	ProjectID ID `json:"projectId"`
	// The name of the column. (Required.)
	Name String `json:"name"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// AddPullRequestReviewCommentInput is an autogenerated input type of AddPullRequestReviewComment.
type AddPullRequestReviewCommentInput struct {
	// The Node ID of the review to modify. (Required.)
	PullRequestReviewID ID `json:"pullRequestReviewId"`
	// The text of the comment. (Required.)
	Body String `json:"body"`

	// The SHA of the commit to comment on. (Optional.)
	CommitOID *GitObjectID `json:"commitOID,omitempty"`
	// The relative path of the file to comment on. (Optional.)
	Path *String `json:"path,omitempty"`
	// The line index in the diff to comment on. (Optional.)
	Position *Int `json:"position,omitempty"`
	// The comment id to reply to. (Optional.)
	InReplyTo *ID `json:"inReplyTo,omitempty"`
	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// AddPullRequestReviewInput is an autogenerated input type of AddPullRequestReview.
type AddPullRequestReviewInput struct {
	// The Node ID of the pull request to modify. (Required.)
	PullRequestID ID `json:"pullRequestId"`

	// The commit OID the review pertains to. (Optional.)
	CommitOID *GitObjectID `json:"commitOID,omitempty"`
	// The contents of the review body comment. (Optional.)
	Body *String `json:"body,omitempty"`
	// The event to perform on the pull request review. (Optional.)
	Event *PullRequestReviewEvent `json:"event,omitempty"`
	// The review line comments. (Optional.)
	Comments *[]*DraftPullRequestReviewComment `json:"comments,omitempty"`
	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// AddReactionInput is an autogenerated input type of AddReaction.
type AddReactionInput struct {
	// The Node ID of the subject to modify. (Required.)
	SubjectID ID `json:"subjectId"`
	// The name of the emoji to react with. (Required.)
	Content ReactionContent `json:"content"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// AddStarInput is an autogenerated input type of AddStar.
type AddStarInput struct {
	// The Starrable ID to star. (Required.)
	StarrableID ID `json:"starrableId"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// CommitAuthor specifies an author for filtering Git commits.
type CommitAuthor struct {

	// ID of a User to filter by. If non-null, only commits authored by this user will be returned. This field takes precedence over emails. (Optional.)
	ID *ID `json:"id,omitempty"`
	// Email addresses to filter by. Commits authored by any of the specified email addresses will be returned. (Optional.)
	Emails *[]String `json:"emails,omitempty"`
}

// CreateProjectInput is an autogenerated input type of CreateProject.
type CreateProjectInput struct {
	// The owner ID to create the project under. (Required.)
	OwnerID ID `json:"ownerId"`
	// The name of project. (Required.)
	Name String `json:"name"`

	// The description of project. (Optional.)
	Body *String `json:"body,omitempty"`
	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// DeclineTopicSuggestionInput is an autogenerated input type of DeclineTopicSuggestion.
type DeclineTopicSuggestionInput struct {
	// The Node ID of the repository. (Required.)
	RepositoryID ID `json:"repositoryId"`
	// The name of the suggested topic. (Required.)
	Name String `json:"name"`
	// The reason why the suggested topic is declined. (Required.)
	Reason TopicSuggestionDeclineReason `json:"reason"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// DeleteProjectCardInput is an autogenerated input type of DeleteProjectCard.
type DeleteProjectCardInput struct {
	// The id of the card to delete. (Required.)
	CardID ID `json:"cardId"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// DeleteProjectColumnInput is an autogenerated input type of DeleteProjectColumn.
type DeleteProjectColumnInput struct {
	// The id of the column to delete. (Required.)
	ColumnID ID `json:"columnId"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// DeleteProjectInput is an autogenerated input type of DeleteProject.
type DeleteProjectInput struct {
	// The Project ID to update. (Required.)
	ProjectID ID `json:"projectId"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// DeletePullRequestReviewInput is an autogenerated input type of DeletePullRequestReview.
type DeletePullRequestReviewInput struct {
	// The Node ID of the pull request review to delete. (Required.)
	PullRequestReviewID ID `json:"pullRequestReviewId"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// DismissPullRequestReviewInput is an autogenerated input type of DismissPullRequestReview.
type DismissPullRequestReviewInput struct {
	// The Node ID of the pull request review to modify. (Required.)
	PullRequestReviewID ID `json:"pullRequestReviewId"`
	// The contents of the pull request review dismissal message. (Required.)
	Message String `json:"message"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// DraftPullRequestReviewComment specifies a review comment to be left with a Pull Request Review.
type DraftPullRequestReviewComment struct {
	// Path to the file being commented on. (Required.)
	Path String `json:"path"`
	// Position in the file to leave a comment on. (Required.)
	Position Int `json:"position"`
	// Body of the comment to leave. (Required.)
	Body String `json:"body"`
}

// GistOrder represents ordering options for gist connections.
type GistOrder struct {
	// The field to order repositories by. (Required.)
	Field GistOrderField `json:"field"`
	// The ordering direction. (Required.)
	Direction OrderDirection `json:"direction"`
}

// IssueOrder represents ways in which lists of issues can be ordered upon return.
type IssueOrder struct {
	// The field in which to order issues by. (Required.)
	Field IssueOrderField `json:"field"`
	// The direction in which to order issues by the specified field. (Required.)
	Direction OrderDirection `json:"direction"`
}

// LanguageOrder represents ordering options for language connections.
type LanguageOrder struct {
	// The field to order languages by. (Required.)
	Field LanguageOrderField `json:"field"`
	// The ordering direction. (Required.)
	Direction OrderDirection `json:"direction"`
}

// LockLockableInput is an autogenerated input type of LockLockable.
type LockLockableInput struct {
	// ID of the issue or pull request to be locked. (Required.)
	LockableID ID `json:"lockableId"`

	// A reason for why the issue or pull request will be locked. (Optional.)
	LockReason *LockReason `json:"lockReason,omitempty"`
	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// MilestoneOrder represents ordering options for milestone connections.
type MilestoneOrder struct {
	// The field to order milestones by. (Required.)
	Field MilestoneOrderField `json:"field"`
	// The ordering direction. (Required.)
	Direction OrderDirection `json:"direction"`
}

// MoveProjectCardInput is an autogenerated input type of MoveProjectCard.
type MoveProjectCardInput struct {
	// The id of the card to move. (Required.)
	CardID ID `json:"cardId"`
	// The id of the column to move it into. (Required.)
	ColumnID ID `json:"columnId"`

	// Place the new card after the card with this id. Pass null to place it at the top. (Optional.)
	AfterCardID *ID `json:"afterCardId,omitempty"`
	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// MoveProjectColumnInput is an autogenerated input type of MoveProjectColumn.
type MoveProjectColumnInput struct {
	// The id of the column to move. (Required.)
	ColumnID ID `json:"columnId"`

	// Place the new column after the column with this id. Pass null to place it at the front. (Optional.)
	AfterColumnID *ID `json:"afterColumnId,omitempty"`
	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// ProjectOrder represents ways in which lists of projects can be ordered upon return.
type ProjectOrder struct {
	// The field in which to order projects by. (Required.)
	Field ProjectOrderField `json:"field"`
	// The direction in which to order projects by the specified field. (Required.)
	Direction OrderDirection `json:"direction"`
}

// ReactionOrder represents ways in which lists of reactions can be ordered upon return.
type ReactionOrder struct {
	// The field in which to order reactions by. (Required.)
	Field ReactionOrderField `json:"field"`
	// The direction in which to order reactions by the specified field. (Required.)
	Direction OrderDirection `json:"direction"`
}

// RefOrder represents ways in which lists of git refs can be ordered upon return.
type RefOrder struct {
	// The field in which to order refs by. (Required.)
	Field RefOrderField `json:"field"`
	// The direction in which to order refs by the specified field. (Required.)
	Direction OrderDirection `json:"direction"`
}

// ReleaseOrder represents ways in which lists of releases can be ordered upon return.
type ReleaseOrder struct {
	// The field in which to order releases by. (Required.)
	Field ReleaseOrderField `json:"field"`
	// The direction in which to order releases by the specified field. (Required.)
	Direction OrderDirection `json:"direction"`
}

// RemoveOutsideCollaboratorInput is an autogenerated input type of RemoveOutsideCollaborator.
type RemoveOutsideCollaboratorInput struct {
	// The ID of the outside collaborator to remove. (Required.)
	UserID ID `json:"userId"`
	// The ID of the organization to remove the outside collaborator from. (Required.)
	OrganizationID ID `json:"organizationId"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// RemoveReactionInput is an autogenerated input type of RemoveReaction.
type RemoveReactionInput struct {
	// The Node ID of the subject to modify. (Required.)
	SubjectID ID `json:"subjectId"`
	// The name of the emoji reaction to remove. (Required.)
	Content ReactionContent `json:"content"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// RemoveStarInput is an autogenerated input type of RemoveStar.
type RemoveStarInput struct {
	// The Starrable ID to unstar. (Required.)
	StarrableID ID `json:"starrableId"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// RepositoryOrder represents ordering options for repository connections.
type RepositoryOrder struct {
	// The field to order repositories by. (Required.)
	Field RepositoryOrderField `json:"field"`
	// The ordering direction. (Required.)
	Direction OrderDirection `json:"direction"`
}

// RequestReviewsInput is an autogenerated input type of RequestReviews.
type RequestReviewsInput struct {
	// The Node ID of the pull request to modify. (Required.)
	PullRequestID ID `json:"pullRequestId"`

	// The Node IDs of the user to request. (Optional.)
	UserIDs *[]ID `json:"userIds,omitempty"`
	// The Node IDs of the team to request. (Optional.)
	TeamIDs *[]ID `json:"teamIds,omitempty"`
	// Add users to the set rather than replace. (Optional.)
	Union *Boolean `json:"union,omitempty"`
	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// StarOrder represents ways in which star connections can be ordered.
type StarOrder struct {
	// The field in which to order nodes by. (Required.)
	Field StarOrderField `json:"field"`
	// The direction in which to order nodes. (Required.)
	Direction OrderDirection `json:"direction"`
}

// SubmitPullRequestReviewInput is an autogenerated input type of SubmitPullRequestReview.
type SubmitPullRequestReviewInput struct {
	// The Pull Request Review ID to submit. (Required.)
	PullRequestReviewID ID `json:"pullRequestReviewId"`
	// The event to send to the Pull Request Review. (Required.)
	Event PullRequestReviewEvent `json:"event"`

	// The text field to set on the Pull Request Review. (Optional.)
	Body *String `json:"body,omitempty"`
	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// TeamMemberOrder represents ordering options for team member connections.
type TeamMemberOrder struct {
	// The field to order team members by. (Required.)
	Field TeamMemberOrderField `json:"field"`
	// The ordering direction. (Required.)
	Direction OrderDirection `json:"direction"`
}

// TeamOrder represents ways in which team connections can be ordered.
type TeamOrder struct {
	// The field in which to order nodes by. (Required.)
	Field TeamOrderField `json:"field"`
	// The direction in which to order nodes. (Required.)
	Direction OrderDirection `json:"direction"`
}

// TeamRepositoryOrder represents ordering options for team repository connections.
type TeamRepositoryOrder struct {
	// The field to order repositories by. (Required.)
	Field TeamRepositoryOrderField `json:"field"`
	// The ordering direction. (Required.)
	Direction OrderDirection `json:"direction"`
}

// UpdateProjectCardInput is an autogenerated input type of UpdateProjectCard.
type UpdateProjectCardInput struct {
	// The ProjectCard ID to update. (Required.)
	ProjectCardID ID `json:"projectCardId"`
	// The note of ProjectCard. (Required.)
	Note String `json:"note"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// UpdateProjectColumnInput is an autogenerated input type of UpdateProjectColumn.
type UpdateProjectColumnInput struct {
	// The ProjectColumn ID to update. (Required.)
	ProjectColumnID ID `json:"projectColumnId"`
	// The name of project column. (Required.)
	Name String `json:"name"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// UpdateProjectInput is an autogenerated input type of UpdateProject.
type UpdateProjectInput struct {
	// The Project ID to update. (Required.)
	ProjectID ID `json:"projectId"`

	// The name of project. (Optional.)
	Name *String `json:"name,omitempty"`
	// The description of project. (Optional.)
	Body *String `json:"body,omitempty"`
	// Whether the project is open or closed. (Optional.)
	State *ProjectState `json:"state,omitempty"`
	// Whether the project is public or not. (Optional.)
	Public *Boolean `json:"public,omitempty"`
	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// UpdatePullRequestReviewCommentInput is an autogenerated input type of UpdatePullRequestReviewComment.
type UpdatePullRequestReviewCommentInput struct {
	// The Node ID of the comment to modify. (Required.)
	PullRequestReviewCommentID ID `json:"pullRequestReviewCommentId"`
	// The text of the comment. (Required.)
	Body String `json:"body"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// UpdatePullRequestReviewInput is an autogenerated input type of UpdatePullRequestReview.
type UpdatePullRequestReviewInput struct {
	// The Node ID of the pull request review to modify. (Required.)
	PullRequestReviewID ID `json:"pullRequestReviewId"`
	// The contents of the pull request review body. (Required.)
	Body String `json:"body"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// UpdateSubscriptionInput is an autogenerated input type of UpdateSubscription.
type UpdateSubscriptionInput struct {
	// The Node ID of the subscribable object to modify. (Required.)
	SubscribableID ID `json:"subscribableId"`
	// The new state of the subscription. (Required.)
	State SubscriptionState `json:"state"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// UpdateTopicsInput is an autogenerated input type of UpdateTopics.
type UpdateTopicsInput struct {
	// The Node ID of the repository. (Required.)
	RepositoryID ID `json:"repositoryId"`
	// An array of topic names. (Required.)
	TopicNames []String `json:"topicNames"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}
