/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by protoc-gen-go. DO NOT EDIT.
// source: config.proto

package config

import (
	fmt "fmt"
	custom_evaluator "github.com/GoogleCloudPlatform/testgrid/pb/custom_evaluator"
	proto "github.com/golang/protobuf/proto"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type TestGroup_TestsName int32

const (
	TestGroup_TESTS_NAME_MIN     TestGroup_TestsName = 0
	TestGroup_TESTS_NAME_IGNORE  TestGroup_TestsName = 1
	TestGroup_TESTS_NAME_REPLACE TestGroup_TestsName = 2
	TestGroup_TESTS_NAME_APPEND  TestGroup_TestsName = 3
)

var TestGroup_TestsName_name = map[int32]string{
	0: "TESTS_NAME_MIN",
	1: "TESTS_NAME_IGNORE",
	2: "TESTS_NAME_REPLACE",
	3: "TESTS_NAME_APPEND",
}

var TestGroup_TestsName_value = map[string]int32{
	"TESTS_NAME_MIN":     0,
	"TESTS_NAME_IGNORE":  1,
	"TESTS_NAME_REPLACE": 2,
	"TESTS_NAME_APPEND":  3,
}

func (x TestGroup_TestsName) String() string {
	return proto.EnumName(TestGroup_TestsName_name, int32(x))
}

func (TestGroup_TestsName) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{2, 0}
}

type TestGroup_FallbackGrouping int32

const (
	TestGroup_FALLBACK_GROUPING_NONE       TestGroup_FallbackGrouping = 0
	TestGroup_FALLBACK_GROUPING_DATE       TestGroup_FallbackGrouping = 1
	TestGroup_FALLBACK_GROUPING_LABELS     TestGroup_FallbackGrouping = 2
	TestGroup_FALLBACK_GROUPING_ID         TestGroup_FallbackGrouping = 3
	TestGroup_FALLBACK_GROUPING_COMMIT_NUM TestGroup_FallbackGrouping = 4
	// When using this, ensure fallback_grouping_configuration_value is
	// also set.
	TestGroup_FALLBACK_GROUPING_CONFIGURATION_VALUE TestGroup_FallbackGrouping = 5
)

var TestGroup_FallbackGrouping_name = map[int32]string{
	0: "FALLBACK_GROUPING_NONE",
	1: "FALLBACK_GROUPING_DATE",
	2: "FALLBACK_GROUPING_LABELS",
	3: "FALLBACK_GROUPING_ID",
	4: "FALLBACK_GROUPING_COMMIT_NUM",
	5: "FALLBACK_GROUPING_CONFIGURATION_VALUE",
}

var TestGroup_FallbackGrouping_value = map[string]int32{
	"FALLBACK_GROUPING_NONE":                0,
	"FALLBACK_GROUPING_DATE":                1,
	"FALLBACK_GROUPING_LABELS":              2,
	"FALLBACK_GROUPING_ID":                  3,
	"FALLBACK_GROUPING_COMMIT_NUM":          4,
	"FALLBACK_GROUPING_CONFIGURATION_VALUE": 5,
}

func (x TestGroup_FallbackGrouping) String() string {
	return proto.EnumName(TestGroup_FallbackGrouping_name, int32(x))
}

func (TestGroup_FallbackGrouping) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{2, 1}
}

type TestGroup_ColumnSortBy int32

const (
	TestGroup_COLUMN_SORT_DATE       TestGroup_ColumnSortBy = 0
	TestGroup_COLUMN_SORT_COMMIT_NUM TestGroup_ColumnSortBy = 1
)

var TestGroup_ColumnSortBy_name = map[int32]string{
	0: "COLUMN_SORT_DATE",
	1: "COLUMN_SORT_COMMIT_NUM",
}

var TestGroup_ColumnSortBy_value = map[string]int32{
	"COLUMN_SORT_DATE":       0,
	"COLUMN_SORT_COMMIT_NUM": 1,
}

func (x TestGroup_ColumnSortBy) String() string {
	return proto.EnumName(TestGroup_ColumnSortBy_name, int32(x))
}

func (TestGroup_ColumnSortBy) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{2, 2}
}

type TestGroup_PrimaryGrouping int32

const (
	TestGroup_PRIMARY_GROUPING_NONE       TestGroup_PrimaryGrouping = 0
	TestGroup_PRIMARY_GROUPING_COMMIT_NUM TestGroup_PrimaryGrouping = 1
)

var TestGroup_PrimaryGrouping_name = map[int32]string{
	0: "PRIMARY_GROUPING_NONE",
	1: "PRIMARY_GROUPING_COMMIT_NUM",
}

var TestGroup_PrimaryGrouping_value = map[string]int32{
	"PRIMARY_GROUPING_NONE":       0,
	"PRIMARY_GROUPING_COMMIT_NUM": 1,
}

func (x TestGroup_PrimaryGrouping) String() string {
	return proto.EnumName(TestGroup_PrimaryGrouping_name, int32(x))
}

func (TestGroup_PrimaryGrouping) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{2, 3}
}

type TestGroup_Environment int32

const (
	TestGroup_PROD TestGroup_Environment = 0
	TestGroup_QA   TestGroup_Environment = 1
)

var TestGroup_Environment_name = map[int32]string{
	0: "PROD",
	1: "QA",
}

var TestGroup_Environment_value = map[string]int32{
	"PROD": 0,
	"QA":   1,
}

func (x TestGroup_Environment) String() string {
	return proto.EnumName(TestGroup_Environment_name, int32(x))
}

func (TestGroup_Environment) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{2, 4}
}

// Scale of issue priority, used to indicate importance of issue.
type AutoBugOptions_Priority int32

const (
	// Unspecified; may not set priority at all
	AutoBugOptions_PRIORITY_UNSPECIFIED AutoBugOptions_Priority = 0
	// See https://developers.google.com/issue-tracker/concepts/issues
	AutoBugOptions_P0 AutoBugOptions_Priority = 1
	AutoBugOptions_P1 AutoBugOptions_Priority = 2
	AutoBugOptions_P2 AutoBugOptions_Priority = 3
	AutoBugOptions_P3 AutoBugOptions_Priority = 4
	AutoBugOptions_P4 AutoBugOptions_Priority = 5
)

var AutoBugOptions_Priority_name = map[int32]string{
	0: "PRIORITY_UNSPECIFIED",
	1: "P0",
	2: "P1",
	3: "P2",
	4: "P3",
	5: "P4",
}

var AutoBugOptions_Priority_value = map[string]int32{
	"PRIORITY_UNSPECIFIED": 0,
	"P0":                   1,
	"P1":                   2,
	"P2":                   3,
	"P3":                   4,
	"P4":                   5,
}

func (x AutoBugOptions_Priority) String() string {
	return proto.EnumName(AutoBugOptions_Priority_name, int32(x))
}

func (AutoBugOptions_Priority) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{5, 0}
}

// Specifies the test name, and its source
type TestNameConfig struct {
	// The name elements specifying the target test name for this tab.
	NameElements []*TestNameConfig_NameElement `protobuf:"bytes,1,rep,name=name_elements,json=nameElements,proto3" json:"name_elements,omitempty"`
	// Specifies a printf-style format string for name elements. The format
	// string should have as many conversions as there are name_elements.
	// For example, two name_elements could be used with name_format="%s: %s".
	NameFormat           string   `protobuf:"bytes,2,opt,name=name_format,json=nameFormat,proto3" json:"name_format,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TestNameConfig) Reset()         { *m = TestNameConfig{} }
func (m *TestNameConfig) String() string { return proto.CompactTextString(m) }
func (*TestNameConfig) ProtoMessage()    {}
func (*TestNameConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{0}
}

func (m *TestNameConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestNameConfig.Unmarshal(m, b)
}
func (m *TestNameConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestNameConfig.Marshal(b, m, deterministic)
}
func (m *TestNameConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestNameConfig.Merge(m, src)
}
func (m *TestNameConfig) XXX_Size() int {
	return xxx_messageInfo_TestNameConfig.Size(m)
}
func (m *TestNameConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_TestNameConfig.DiscardUnknown(m)
}

var xxx_messageInfo_TestNameConfig proto.InternalMessageInfo

func (m *TestNameConfig) GetNameElements() []*TestNameConfig_NameElement {
	if m != nil {
		return m.NameElements
	}
	return nil
}

func (m *TestNameConfig) GetNameFormat() string {
	if m != nil {
		return m.NameFormat
	}
	return ""
}

// Specifies name elements to be selected from configuration values
type TestNameConfig_NameElement struct {
	// A space-delimited string of labels
	Labels string `protobuf:"bytes,1,opt,name=labels,proto3" json:"labels,omitempty"`
	// Configuration value to use.
	// Valid choice are:
	// 'Tests name': The name of a test case
	// 'Commit': The commit number of the build
	// 'Context', 'Thread': The info extracted from each junit files:
	//    - junit_core-os_01.xml -> Context: core-os, Thread: 01
	//    - junit_runner.xml -> Context: runner
	//    - junit_01.xml -> Thread: 01
	// or any metadata key from finished.json, which is copied from your test suite.
	//
	// A valid sample TestNameConfig looks like:
	// test_name_config:
	//   name_elements:
	//   - target_config: Tests name
	//   - target_config: Context
	//   name_format: '%s [%s]'
	TargetConfig string `protobuf:"bytes,2,opt,name=target_config,json=targetConfig,proto3" json:"target_config,omitempty"`
	// Whether to use the build-target name
	BuildTarget bool `protobuf:"varint,3,opt,name=build_target,json=buildTarget,proto3" json:"build_target,omitempty"`
	// A space-delimited string of Bazel build tags.
	Tags string `protobuf:"bytes,4,opt,name=tags,proto3" json:"tags,omitempty"`
	// The key of a test result's property.
	TestProperty         string   `protobuf:"bytes,5,opt,name=test_property,json=testProperty,proto3" json:"test_property,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TestNameConfig_NameElement) Reset()         { *m = TestNameConfig_NameElement{} }
func (m *TestNameConfig_NameElement) String() string { return proto.CompactTextString(m) }
func (*TestNameConfig_NameElement) ProtoMessage()    {}
func (*TestNameConfig_NameElement) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{0, 0}
}

func (m *TestNameConfig_NameElement) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestNameConfig_NameElement.Unmarshal(m, b)
}
func (m *TestNameConfig_NameElement) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestNameConfig_NameElement.Marshal(b, m, deterministic)
}
func (m *TestNameConfig_NameElement) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestNameConfig_NameElement.Merge(m, src)
}
func (m *TestNameConfig_NameElement) XXX_Size() int {
	return xxx_messageInfo_TestNameConfig_NameElement.Size(m)
}
func (m *TestNameConfig_NameElement) XXX_DiscardUnknown() {
	xxx_messageInfo_TestNameConfig_NameElement.DiscardUnknown(m)
}

var xxx_messageInfo_TestNameConfig_NameElement proto.InternalMessageInfo

func (m *TestNameConfig_NameElement) GetLabels() string {
	if m != nil {
		return m.Labels
	}
	return ""
}

func (m *TestNameConfig_NameElement) GetTargetConfig() string {
	if m != nil {
		return m.TargetConfig
	}
	return ""
}

func (m *TestNameConfig_NameElement) GetBuildTarget() bool {
	if m != nil {
		return m.BuildTarget
	}
	return false
}

func (m *TestNameConfig_NameElement) GetTags() string {
	if m != nil {
		return m.Tags
	}
	return ""
}

func (m *TestNameConfig_NameElement) GetTestProperty() string {
	if m != nil {
		return m.TestProperty
	}
	return ""
}

// A single notification.
type Notification struct {
	// Required: Text summary of the issue or notice.
	Summary string `protobuf:"bytes,1,opt,name=summary,proto3" json:"summary,omitempty"`
	// Optional: Link to further information, such as a bug, email, document, etc.
	ContextLink          string   `protobuf:"bytes,2,opt,name=context_link,json=contextLink,proto3" json:"context_link,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Notification) Reset()         { *m = Notification{} }
func (m *Notification) String() string { return proto.CompactTextString(m) }
func (*Notification) ProtoMessage()    {}
func (*Notification) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{1}
}

func (m *Notification) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Notification.Unmarshal(m, b)
}
func (m *Notification) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Notification.Marshal(b, m, deterministic)
}
func (m *Notification) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Notification.Merge(m, src)
}
func (m *Notification) XXX_Size() int {
	return xxx_messageInfo_Notification.Size(m)
}
func (m *Notification) XXX_DiscardUnknown() {
	xxx_messageInfo_Notification.DiscardUnknown(m)
}

var xxx_messageInfo_Notification proto.InternalMessageInfo

func (m *Notification) GetSummary() string {
	if m != nil {
		return m.Summary
	}
	return ""
}

func (m *Notification) GetContextLink() string {
	if m != nil {
		return m.ContextLink
	}
	return ""
}

// Specifies a group of tests to gather.
type TestGroup struct {
	// Name of this TestGroup, for mapping dashboard tabs to tests.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Path to the test result location, including protocol.
	// The location must be accessible from the Update Server, and not local.
	// GCS is usually used, making this field "gs://<bucket>"
	GcsPrefix string `protobuf:"bytes,2,opt,name=gcs_prefix,json=gcsPrefix,proto3" json:"gcs_prefix,omitempty"`
	// Number of days of test results to gather and serve.
	DaysOfResults int32 `protobuf:"varint,3,opt,name=days_of_results,json=daysOfResults,proto3" json:"days_of_results,omitempty"`
	// Whether to ignore pending (currently running) test results.
	IgnorePending bool `protobuf:"varint,4,opt,name=ignore_pending,json=ignorePending,proto3" json:"ignore_pending,omitempty"`
	// Whether to ignore reported build results. It is recommended that tests
	// report BUILD_FAIL instead of relying on this being disabled.
	IgnoreBuilt bool `protobuf:"varint,5,opt,name=ignore_built,json=ignoreBuilt,proto3" json:"ignore_built,omitempty"`
	// What to do with the 'Tests name' configuration value. It can replace the
	// name of the test, be appended to the name of the test, or ignored. If it is
	// ignored, then the name of the tests will be the build target.
	TestsNamePolicy TestGroup_TestsName `protobuf:"varint,6,opt,name=tests_name_policy,json=testsNamePolicy,proto3,enum=TestGroup_TestsName" json:"tests_name_policy,omitempty"`
	// Whether to infer the test properties from the test results.
	// Deprecated; recommended as "true"
	GatherTestProperties bool `protobuf:"varint,7,opt,name=gather_test_properties,json=gatherTestProperties,proto3" json:"gather_test_properties,omitempty"` // Deprecated: Do not use.
	// Tests with names that include these substrings will be removed from the
	// table.
	IgnoreTestSubstring []string                  `protobuf:"bytes,8,rep,name=ignore_test_substring,json=ignoreTestSubstring,proto3" json:"ignore_test_substring,omitempty"`
	ColumnHeader        []*TestGroup_ColumnHeader `protobuf:"bytes,9,rep,name=column_header,json=columnHeader,proto3" json:"column_header,omitempty"`
	// A test grouping option used if not specified by primary_grouping (#29)
	FallbackGrouping TestGroup_FallbackGrouping `protobuf:"varint,10,opt,name=fallback_grouping,json=fallbackGrouping,proto3,enum=TestGroup_FallbackGrouping" json:"fallback_grouping,omitempty"`
	// Time in hours before an alert will be added to a test results table if the
	// run date of the latest results are older than this time.  If zero, no
	// alerts are raised.
	AlertStaleResultsHours int32 `protobuf:"varint,11,opt,name=alert_stale_results_hours,json=alertStaleResultsHours,proto3" json:"alert_stale_results_hours,omitempty"`
	// The number of consecutive test result failures to see before alerting of
	// a consistent failure. If zero, no alerts are raised.
	NumFailuresToAlert int32 `protobuf:"varint,12,opt,name=num_failures_to_alert,json=numFailuresToAlert,proto3" json:"num_failures_to_alert,omitempty"`
	// Whether to automatically file bugs, and what component to file them to.
	// Requires further implementation of additional components.
	BugComponent int32 `protobuf:"varint,13,opt,name=bug_component,json=bugComponent,proto3" json:"bug_component,omitempty"`
	// Default code search path for searching regressions. Overridden by
	// code_search_path in DashboardTab.
	CodeSearchPath string `protobuf:"bytes,14,opt,name=code_search_path,json=codeSearchPath,proto3" json:"code_search_path,omitempty"`
	// The number of columns to consider "recent" for a variety of purposes.
	NumColumnsRecent int32 `protobuf:"varint,15,opt,name=num_columns_recent,json=numColumnsRecent,proto3" json:"num_columns_recent,omitempty"`
	// Whether to read test metadata from the test results. Information
	// from the test metadata is used to determine where bugs are filed in
	// specific cases.
	UseTestMetadata bool `protobuf:"varint,16,opt,name=use_test_metadata,json=useTestMetadata,proto3" json:"use_test_metadata,omitempty"`
	// The comma-separated addresses to send mail.
	// Note that this can also be configured for particular Dashboard Tabs also
	AlertMailToAddresses string `protobuf:"bytes,17,opt,name=alert_mail_to_addresses,json=alertMailToAddresses,proto3" json:"alert_mail_to_addresses,omitempty"`
	// Subject line of an alert mail.
	AlertMailSubject string `protobuf:"bytes,18,opt,name=alert_mail_subject,json=alertMailSubject,proto3" json:"alert_mail_subject,omitempty"`
	// Failure message in alert mail.
	AlertMailFailureMessage string `protobuf:"bytes,19,opt,name=alert_mail_failure_message,json=alertMailFailureMessage,proto3" json:"alert_mail_failure_message,omitempty"`
	// An url which will help in debugging failure. This will be hyperlinked on
	// failure message.
	AlertMailDebugUrl string `protobuf:"bytes,20,opt,name=alert_mail_debug_url,json=alertMailDebugUrl,proto3" json:"alert_mail_debug_url,omitempty"`
	// Minimum time between sending mails.
	MinElapsedMinutesBetweenMails int32 `protobuf:"varint,21,opt,name=min_elapsed_minutes_between_mails,json=minElapsedMinutesBetweenMails,proto3" json:"min_elapsed_minutes_between_mails,omitempty"`
	// Whether to read configuration values from invocation and use that
	// to send email alerts. If this is true, values for
	// alert_mail_to_addresses, alert_mail_failure_message and
	// alert_mail_debug_url will be gathered from invocation properties and will
	// get precedence.
	UseConfigurationValuesAsAlertParams bool `protobuf:"varint,22,opt,name=use_configuration_values_as_alert_params,json=useConfigurationValuesAsAlertParams,proto3" json:"use_configuration_values_as_alert_params,omitempty"`
	// Whether to treat a combination of passes and failures within one test as a
	// flaky status.
	EnableFlakyStatus bool `protobuf:"varint,23,opt,name=enable_flaky_status,json=enableFlakyStatus,proto3" json:"enable_flaky_status,omitempty"`
	// deprecated - always set to true
	UseKubernetesClient bool `protobuf:"varint,24,opt,name=use_kubernetes_client,json=useKubernetesClient,proto3" json:"use_kubernetes_client,omitempty"`
	// deprecated - always set to true
	IsExternal bool `protobuf:"varint,25,opt,name=is_external,json=isExternal,proto3" json:"is_external,omitempty"`
	// Specifies the test name for a test.
	TestNameConfig *TestNameConfig `protobuf:"bytes,26,opt,name=test_name_config,json=testNameConfig,proto3" json:"test_name_config,omitempty"`
	// A list of notifications attached to this test group.
	// This is displayed on any dashboard tab backed by this test group.
	Notifications []*Notification `protobuf:"bytes,27,rep,name=notifications,proto3" json:"notifications,omitempty"`
	// Specifies how to sort a test group's columns. The default is to sort by
	// date, from most recent to oldest.
	ColumnSortBy TestGroup_ColumnSortBy `protobuf:"varint,28,opt,name=column_sort_by,json=columnSortBy,proto3,enum=TestGroup_ColumnSortBy" json:"column_sort_by,omitempty"`
	// A primary grouping strategy for grouping test results in columns.
	// If a primary grouping is specified, the fallback grouping is ignored.
	PrimaryGrouping TestGroup_PrimaryGrouping `protobuf:"varint,29,opt,name=primary_grouping,json=primaryGrouping,proto3,enum=TestGroup_PrimaryGrouping" json:"primary_grouping,omitempty"`
	// Whether to collect pass-fail data for test methods. Additional test cases
	// will be added for each test method in a target.
	EnableTestMethods bool `protobuf:"varint,30,opt,name=enable_test_methods,json=enableTestMethods,proto3" json:"enable_test_methods,omitempty"`
	// Test annotations to look for. Adds custom short text overlays to results.
	TestAnnotations []*TestGroup_TestAnnotation `protobuf:"bytes,31,rep,name=test_annotations,json=testAnnotations,proto3" json:"test_annotations,omitempty"`
	// Maximum number of individual test methods to collect for any given test row.
	// If a test has more than this many methods, no methods will be displayed.
	MaxTestMethodsPerTest int32 `protobuf:"varint,32,opt,name=max_test_methods_per_test,json=maxTestMethodsPerTest,proto3" json:"max_test_methods_per_test,omitempty"`
	// A regex to select a label that takes the place of the commit number.
	// This is useful for cases where there is no commit or where the
	// commit is not the primary identifier.
	// The regex should have a capturing group; the captured content becomes the value.
	CommitOverrideLabelPattern string `protobuf:"bytes,33,opt,name=commit_override_label_pattern,json=commitOverrideLabelPattern,proto3" json:"commit_override_label_pattern,omitempty"`
	// Default metadata that should be applied for opening bugs, if a given regex
	// matches against a test's name.
	// Requires 'use_test_metadata = true'.
	TestMetadataOptions *TestMetadataOptions `protobuf:"bytes,34,opt,name=test_metadata_options,json=testMetadataOptions,proto3" json:"test_metadata_options,omitempty"`
	// A space-delimited string of tags that are used to filter test targets.
	// A leading - before the tag means this tag should not be present
	// in the target.
	// Example:
	//  contains tag1, but not tag2: test_tag_pattern = 'tag1 -tag2'
	TestTagPattern string `protobuf:"bytes,35,opt,name=test_tag_pattern,json=testTagPattern,proto3" json:"test_tag_pattern,omitempty"`
	// Options for auto-filed bugs, if enabled.
	AutoBugOptions *AutoBugOptions `protobuf:"bytes,36,opt,name=auto_bug_options,json=autoBugOptions,proto3" json:"auto_bug_options,omitempty"`
	// Max number of days any single test can take.
	MaxTestRuntimeHours int32 `protobuf:"varint,37,opt,name=max_test_runtime_hours,json=maxTestRuntimeHours,proto3" json:"max_test_runtime_hours,omitempty"`
	// The number of consecutive test passes to close the alert.
	NumPassesToDisableAlert int32 `protobuf:"varint,38,opt,name=num_passes_to_disable_alert,json=numPassesToDisableAlert,proto3" json:"num_passes_to_disable_alert,omitempty"`
	// If true, also associate bugs with tests if the test result's overview/group
	// ID is in the bug.
	LinkBugsByGroup bool `protobuf:"varint,39,opt,name=link_bugs_by_group,json=linkBugsByGroup,proto3" json:"link_bugs_by_group,omitempty"`
	// Test instance to query for this test group. Optionally used by updater.
	EnvironmentInstance TestGroup_Environment `protobuf:"varint,40,opt,name=environment_instance,json=environmentInstance,proto3,enum=TestGroup_Environment" json:"environment_instance,omitempty"`
	// Only show test methods with all required properties
	TestMethodProperties []*TestGroup_KeyValue `protobuf:"bytes,41,rep,name=test_method_properties,json=testMethodProperties,proto3" json:"test_method_properties,omitempty"`
	// If true, allows gathering and associating bugs with targets in the dashboard.
	// Required in order to auto-file bugs.
	GatherBugs bool `protobuf:"varint,42,opt,name=gather_bugs,json=gatherBugs,proto3" json:"gather_bugs,omitempty"`
	// Numeric property metric value to be used for short text. If this property
	// is present, it will override all the other short text values.
	ShortTextMetric string `protobuf:"bytes,43,opt,name=short_text_metric,json=shortTextMetric,proto3" json:"short_text_metric,omitempty"`
	// A test configuration value that takes the place of the commit number.
	// This is useful for cases where there is no commit or where the
	// commit is not the primary identifier.
	CommitOverrideConfigurationValue string `protobuf:"bytes,44,opt,name=commit_override_configuration_value,json=commitOverrideConfigurationValue,proto3" json:"commit_override_configuration_value,omitempty"`
	// If true, only associate bugs with test methods if that test method is
	// mentioned in the bug. If false, bugs will be associated with all test
	// methods.
	LinkBugsByTestMethods bool `protobuf:"varint,45,opt,name=link_bugs_by_test_methods,json=linkBugsByTestMethods,proto3" json:"link_bugs_by_test_methods,omitempty"`
	// Regex to match test methods. Only tests methods with names that match
	// this regex will be included in the table.
	TestMethodMatchRegex string `protobuf:"bytes,46,opt,name=test_method_match_regex,json=testMethodMatchRegex,proto3" json:"test_method_match_regex,omitempty"`
	// If true, test method names are printed with the full class names.
	UseFullMethodNames bool `protobuf:"varint,47,opt,name=use_full_method_names,json=useFullMethodNames,proto3" json:"use_full_method_names,omitempty"`
	// The string list of full path evaluator rules in the format:
	// <config_directory>.<rule_set_file>.<RuleSetClassName>.<rule_name>
	//
	// Deprecated feature
	CustomResultEvaluatorRules []string `protobuf:"bytes,48,rep,name=custom_result_evaluator_rules,json=customResultEvaluatorRules,proto3" json:"custom_result_evaluator_rules,omitempty"` // Deprecated: Do not use.
	// A configuration value that is used as a fallback grouping.
	// This is useful for cases where there are builds that shared the same
	// commit but are run at separate times of day.
	FallbackGroupingConfigurationValue string `protobuf:"bytes,49,opt,name=fallback_grouping_configuration_value,json=fallbackGroupingConfigurationValue,proto3" json:"fallback_grouping_configuration_value,omitempty"`
	// Configuration type of the result source.
	ResultSource *TestGroup_ResultSource `protobuf:"bytes,50,opt,name=result_source,json=resultSource,proto3" json:"result_source,omitempty"`
	// Set of rules that are evaluated with each test result. If an evaluation is
	// successful, the status of that test result will be whatever is specified
	// for a given rule. For more information, look at RuleSet documention
	CustomEvaluatorRuleSet *custom_evaluator.RuleSet `protobuf:"bytes,51,opt,name=custom_evaluator_rule_set,json=customEvaluatorRuleSet,proto3" json:"custom_evaluator_rule_set,omitempty"`
	// If true, instead of updating the group, read the state proto from storage
	// and update summary, alerts, etc. from that state.
	// This only applies to test group state, not bug state for a test group.
	// This assumes that the state proto is updated through other means (another
	// updater, manually, etc).
	ReadStateFromStorage bool `protobuf:"varint,52,opt,name=read_state_from_storage,json=readStateFromStorage,proto3" json:"read_state_from_storage,omitempty"`
	// If true, only add the most recent result for a test when multiple results
	// for a test with the same name are encountered.
	IgnoreOldResults bool `protobuf:"varint,53,opt,name=ignore_old_results,json=ignoreOldResults,proto3" json:"ignore_old_results,omitempty"`
	// If True, ignore the 'pass with skips' status (show as a blank cell).
	IgnoreSkip           bool     `protobuf:"varint,54,opt,name=ignore_skip,json=ignoreSkip,proto3" json:"ignore_skip,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TestGroup) Reset()         { *m = TestGroup{} }
func (m *TestGroup) String() string { return proto.CompactTextString(m) }
func (*TestGroup) ProtoMessage()    {}
func (*TestGroup) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{2}
}

func (m *TestGroup) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestGroup.Unmarshal(m, b)
}
func (m *TestGroup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestGroup.Marshal(b, m, deterministic)
}
func (m *TestGroup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestGroup.Merge(m, src)
}
func (m *TestGroup) XXX_Size() int {
	return xxx_messageInfo_TestGroup.Size(m)
}
func (m *TestGroup) XXX_DiscardUnknown() {
	xxx_messageInfo_TestGroup.DiscardUnknown(m)
}

var xxx_messageInfo_TestGroup proto.InternalMessageInfo

func (m *TestGroup) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *TestGroup) GetGcsPrefix() string {
	if m != nil {
		return m.GcsPrefix
	}
	return ""
}

func (m *TestGroup) GetDaysOfResults() int32 {
	if m != nil {
		return m.DaysOfResults
	}
	return 0
}

func (m *TestGroup) GetIgnorePending() bool {
	if m != nil {
		return m.IgnorePending
	}
	return false
}

func (m *TestGroup) GetIgnoreBuilt() bool {
	if m != nil {
		return m.IgnoreBuilt
	}
	return false
}

func (m *TestGroup) GetTestsNamePolicy() TestGroup_TestsName {
	if m != nil {
		return m.TestsNamePolicy
	}
	return TestGroup_TESTS_NAME_MIN
}

// Deprecated: Do not use.
func (m *TestGroup) GetGatherTestProperties() bool {
	if m != nil {
		return m.GatherTestProperties
	}
	return false
}

func (m *TestGroup) GetIgnoreTestSubstring() []string {
	if m != nil {
		return m.IgnoreTestSubstring
	}
	return nil
}

func (m *TestGroup) GetColumnHeader() []*TestGroup_ColumnHeader {
	if m != nil {
		return m.ColumnHeader
	}
	return nil
}

func (m *TestGroup) GetFallbackGrouping() TestGroup_FallbackGrouping {
	if m != nil {
		return m.FallbackGrouping
	}
	return TestGroup_FALLBACK_GROUPING_NONE
}

func (m *TestGroup) GetAlertStaleResultsHours() int32 {
	if m != nil {
		return m.AlertStaleResultsHours
	}
	return 0
}

func (m *TestGroup) GetNumFailuresToAlert() int32 {
	if m != nil {
		return m.NumFailuresToAlert
	}
	return 0
}

func (m *TestGroup) GetBugComponent() int32 {
	if m != nil {
		return m.BugComponent
	}
	return 0
}

func (m *TestGroup) GetCodeSearchPath() string {
	if m != nil {
		return m.CodeSearchPath
	}
	return ""
}

func (m *TestGroup) GetNumColumnsRecent() int32 {
	if m != nil {
		return m.NumColumnsRecent
	}
	return 0
}

func (m *TestGroup) GetUseTestMetadata() bool {
	if m != nil {
		return m.UseTestMetadata
	}
	return false
}

func (m *TestGroup) GetAlertMailToAddresses() string {
	if m != nil {
		return m.AlertMailToAddresses
	}
	return ""
}

func (m *TestGroup) GetAlertMailSubject() string {
	if m != nil {
		return m.AlertMailSubject
	}
	return ""
}

func (m *TestGroup) GetAlertMailFailureMessage() string {
	if m != nil {
		return m.AlertMailFailureMessage
	}
	return ""
}

func (m *TestGroup) GetAlertMailDebugUrl() string {
	if m != nil {
		return m.AlertMailDebugUrl
	}
	return ""
}

func (m *TestGroup) GetMinElapsedMinutesBetweenMails() int32 {
	if m != nil {
		return m.MinElapsedMinutesBetweenMails
	}
	return 0
}

func (m *TestGroup) GetUseConfigurationValuesAsAlertParams() bool {
	if m != nil {
		return m.UseConfigurationValuesAsAlertParams
	}
	return false
}

func (m *TestGroup) GetEnableFlakyStatus() bool {
	if m != nil {
		return m.EnableFlakyStatus
	}
	return false
}

func (m *TestGroup) GetUseKubernetesClient() bool {
	if m != nil {
		return m.UseKubernetesClient
	}
	return false
}

func (m *TestGroup) GetIsExternal() bool {
	if m != nil {
		return m.IsExternal
	}
	return false
}

func (m *TestGroup) GetTestNameConfig() *TestNameConfig {
	if m != nil {
		return m.TestNameConfig
	}
	return nil
}

func (m *TestGroup) GetNotifications() []*Notification {
	if m != nil {
		return m.Notifications
	}
	return nil
}

func (m *TestGroup) GetColumnSortBy() TestGroup_ColumnSortBy {
	if m != nil {
		return m.ColumnSortBy
	}
	return TestGroup_COLUMN_SORT_DATE
}

func (m *TestGroup) GetPrimaryGrouping() TestGroup_PrimaryGrouping {
	if m != nil {
		return m.PrimaryGrouping
	}
	return TestGroup_PRIMARY_GROUPING_NONE
}

func (m *TestGroup) GetEnableTestMethods() bool {
	if m != nil {
		return m.EnableTestMethods
	}
	return false
}

func (m *TestGroup) GetTestAnnotations() []*TestGroup_TestAnnotation {
	if m != nil {
		return m.TestAnnotations
	}
	return nil
}

func (m *TestGroup) GetMaxTestMethodsPerTest() int32 {
	if m != nil {
		return m.MaxTestMethodsPerTest
	}
	return 0
}

func (m *TestGroup) GetCommitOverrideLabelPattern() string {
	if m != nil {
		return m.CommitOverrideLabelPattern
	}
	return ""
}

func (m *TestGroup) GetTestMetadataOptions() *TestMetadataOptions {
	if m != nil {
		return m.TestMetadataOptions
	}
	return nil
}

func (m *TestGroup) GetTestTagPattern() string {
	if m != nil {
		return m.TestTagPattern
	}
	return ""
}

func (m *TestGroup) GetAutoBugOptions() *AutoBugOptions {
	if m != nil {
		return m.AutoBugOptions
	}
	return nil
}

func (m *TestGroup) GetMaxTestRuntimeHours() int32 {
	if m != nil {
		return m.MaxTestRuntimeHours
	}
	return 0
}

func (m *TestGroup) GetNumPassesToDisableAlert() int32 {
	if m != nil {
		return m.NumPassesToDisableAlert
	}
	return 0
}

func (m *TestGroup) GetLinkBugsByGroup() bool {
	if m != nil {
		return m.LinkBugsByGroup
	}
	return false
}

func (m *TestGroup) GetEnvironmentInstance() TestGroup_Environment {
	if m != nil {
		return m.EnvironmentInstance
	}
	return TestGroup_PROD
}

func (m *TestGroup) GetTestMethodProperties() []*TestGroup_KeyValue {
	if m != nil {
		return m.TestMethodProperties
	}
	return nil
}

func (m *TestGroup) GetGatherBugs() bool {
	if m != nil {
		return m.GatherBugs
	}
	return false
}

func (m *TestGroup) GetShortTextMetric() string {
	if m != nil {
		return m.ShortTextMetric
	}
	return ""
}

func (m *TestGroup) GetCommitOverrideConfigurationValue() string {
	if m != nil {
		return m.CommitOverrideConfigurationValue
	}
	return ""
}

func (m *TestGroup) GetLinkBugsByTestMethods() bool {
	if m != nil {
		return m.LinkBugsByTestMethods
	}
	return false
}

func (m *TestGroup) GetTestMethodMatchRegex() string {
	if m != nil {
		return m.TestMethodMatchRegex
	}
	return ""
}

func (m *TestGroup) GetUseFullMethodNames() bool {
	if m != nil {
		return m.UseFullMethodNames
	}
	return false
}

// Deprecated: Do not use.
func (m *TestGroup) GetCustomResultEvaluatorRules() []string {
	if m != nil {
		return m.CustomResultEvaluatorRules
	}
	return nil
}

func (m *TestGroup) GetFallbackGroupingConfigurationValue() string {
	if m != nil {
		return m.FallbackGroupingConfigurationValue
	}
	return ""
}

func (m *TestGroup) GetResultSource() *TestGroup_ResultSource {
	if m != nil {
		return m.ResultSource
	}
	return nil
}

func (m *TestGroup) GetCustomEvaluatorRuleSet() *custom_evaluator.RuleSet {
	if m != nil {
		return m.CustomEvaluatorRuleSet
	}
	return nil
}

func (m *TestGroup) GetReadStateFromStorage() bool {
	if m != nil {
		return m.ReadStateFromStorage
	}
	return false
}

func (m *TestGroup) GetIgnoreOldResults() bool {
	if m != nil {
		return m.IgnoreOldResults
	}
	return false
}

func (m *TestGroup) GetIgnoreSkip() bool {
	if m != nil {
		return m.IgnoreSkip
	}
	return false
}

// Custom column headers for defining extra column-heading rows from values in
// the test result.
type TestGroup_ColumnHeader struct {
	ConfigurationValue   string   `protobuf:"bytes,3,opt,name=configuration_value,json=configurationValue,proto3" json:"configuration_value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TestGroup_ColumnHeader) Reset()         { *m = TestGroup_ColumnHeader{} }
func (m *TestGroup_ColumnHeader) String() string { return proto.CompactTextString(m) }
func (*TestGroup_ColumnHeader) ProtoMessage()    {}
func (*TestGroup_ColumnHeader) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{2, 0}
}

func (m *TestGroup_ColumnHeader) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestGroup_ColumnHeader.Unmarshal(m, b)
}
func (m *TestGroup_ColumnHeader) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestGroup_ColumnHeader.Marshal(b, m, deterministic)
}
func (m *TestGroup_ColumnHeader) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestGroup_ColumnHeader.Merge(m, src)
}
func (m *TestGroup_ColumnHeader) XXX_Size() int {
	return xxx_messageInfo_TestGroup_ColumnHeader.Size(m)
}
func (m *TestGroup_ColumnHeader) XXX_DiscardUnknown() {
	xxx_messageInfo_TestGroup_ColumnHeader.DiscardUnknown(m)
}

var xxx_messageInfo_TestGroup_ColumnHeader proto.InternalMessageInfo

func (m *TestGroup_ColumnHeader) GetConfigurationValue() string {
	if m != nil {
		return m.ConfigurationValue
	}
	return ""
}

// Associates the presence of a named test property with a custom short text
// displayed over the results. Short text must be <=5 characters long.
type TestGroup_TestAnnotation struct {
	ShortText string `protobuf:"bytes,1,opt,name=short_text,json=shortText,proto3" json:"short_text,omitempty"`
	// Types that are valid to be assigned to ShortTextMessageSource:
	//	*TestGroup_TestAnnotation_PropertyName
	ShortTextMessageSource isTestGroup_TestAnnotation_ShortTextMessageSource `protobuf_oneof:"short_text_message_source"`
	XXX_NoUnkeyedLiteral   struct{}                                          `json:"-"`
	XXX_unrecognized       []byte                                            `json:"-"`
	XXX_sizecache          int32                                             `json:"-"`
}

func (m *TestGroup_TestAnnotation) Reset()         { *m = TestGroup_TestAnnotation{} }
func (m *TestGroup_TestAnnotation) String() string { return proto.CompactTextString(m) }
func (*TestGroup_TestAnnotation) ProtoMessage()    {}
func (*TestGroup_TestAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{2, 1}
}

func (m *TestGroup_TestAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestGroup_TestAnnotation.Unmarshal(m, b)
}
func (m *TestGroup_TestAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestGroup_TestAnnotation.Marshal(b, m, deterministic)
}
func (m *TestGroup_TestAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestGroup_TestAnnotation.Merge(m, src)
}
func (m *TestGroup_TestAnnotation) XXX_Size() int {
	return xxx_messageInfo_TestGroup_TestAnnotation.Size(m)
}
func (m *TestGroup_TestAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_TestGroup_TestAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_TestGroup_TestAnnotation proto.InternalMessageInfo

func (m *TestGroup_TestAnnotation) GetShortText() string {
	if m != nil {
		return m.ShortText
	}
	return ""
}

type isTestGroup_TestAnnotation_ShortTextMessageSource interface {
	isTestGroup_TestAnnotation_ShortTextMessageSource()
}

type TestGroup_TestAnnotation_PropertyName struct {
	PropertyName string `protobuf:"bytes,2,opt,name=property_name,json=propertyName,proto3,oneof"`
}

func (*TestGroup_TestAnnotation_PropertyName) isTestGroup_TestAnnotation_ShortTextMessageSource() {}

func (m *TestGroup_TestAnnotation) GetShortTextMessageSource() isTestGroup_TestAnnotation_ShortTextMessageSource {
	if m != nil {
		return m.ShortTextMessageSource
	}
	return nil
}

func (m *TestGroup_TestAnnotation) GetPropertyName() string {
	if x, ok := m.GetShortTextMessageSource().(*TestGroup_TestAnnotation_PropertyName); ok {
		return x.PropertyName
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*TestGroup_TestAnnotation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*TestGroup_TestAnnotation_PropertyName)(nil),
	}
}

// A string key value pair message
type TestGroup_KeyValue struct {
	Key                  string   `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Value                string   `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TestGroup_KeyValue) Reset()         { *m = TestGroup_KeyValue{} }
func (m *TestGroup_KeyValue) String() string { return proto.CompactTextString(m) }
func (*TestGroup_KeyValue) ProtoMessage()    {}
func (*TestGroup_KeyValue) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{2, 2}
}

func (m *TestGroup_KeyValue) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestGroup_KeyValue.Unmarshal(m, b)
}
func (m *TestGroup_KeyValue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestGroup_KeyValue.Marshal(b, m, deterministic)
}
func (m *TestGroup_KeyValue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestGroup_KeyValue.Merge(m, src)
}
func (m *TestGroup_KeyValue) XXX_Size() int {
	return xxx_messageInfo_TestGroup_KeyValue.Size(m)
}
func (m *TestGroup_KeyValue) XXX_DiscardUnknown() {
	xxx_messageInfo_TestGroup_KeyValue.DiscardUnknown(m)
}

var xxx_messageInfo_TestGroup_KeyValue proto.InternalMessageInfo

func (m *TestGroup_KeyValue) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *TestGroup_KeyValue) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

type TestGroup_ResultSource struct {
	// Types that are valid to be assigned to ResultSourceConfig:
	//	*TestGroup_ResultSource_JunitConfig
	ResultSourceConfig   isTestGroup_ResultSource_ResultSourceConfig `protobuf_oneof:"result_source_config"`
	XXX_NoUnkeyedLiteral struct{}                                    `json:"-"`
	XXX_unrecognized     []byte                                      `json:"-"`
	XXX_sizecache        int32                                       `json:"-"`
}

func (m *TestGroup_ResultSource) Reset()         { *m = TestGroup_ResultSource{} }
func (m *TestGroup_ResultSource) String() string { return proto.CompactTextString(m) }
func (*TestGroup_ResultSource) ProtoMessage()    {}
func (*TestGroup_ResultSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{2, 3}
}

func (m *TestGroup_ResultSource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestGroup_ResultSource.Unmarshal(m, b)
}
func (m *TestGroup_ResultSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestGroup_ResultSource.Marshal(b, m, deterministic)
}
func (m *TestGroup_ResultSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestGroup_ResultSource.Merge(m, src)
}
func (m *TestGroup_ResultSource) XXX_Size() int {
	return xxx_messageInfo_TestGroup_ResultSource.Size(m)
}
func (m *TestGroup_ResultSource) XXX_DiscardUnknown() {
	xxx_messageInfo_TestGroup_ResultSource.DiscardUnknown(m)
}

var xxx_messageInfo_TestGroup_ResultSource proto.InternalMessageInfo

type isTestGroup_ResultSource_ResultSourceConfig interface {
	isTestGroup_ResultSource_ResultSourceConfig()
}

type TestGroup_ResultSource_JunitConfig struct {
	JunitConfig *JUnitConfig `protobuf:"bytes,2,opt,name=junit_config,json=junitConfig,proto3,oneof"`
}

func (*TestGroup_ResultSource_JunitConfig) isTestGroup_ResultSource_ResultSourceConfig() {}

func (m *TestGroup_ResultSource) GetResultSourceConfig() isTestGroup_ResultSource_ResultSourceConfig {
	if m != nil {
		return m.ResultSourceConfig
	}
	return nil
}

func (m *TestGroup_ResultSource) GetJunitConfig() *JUnitConfig {
	if x, ok := m.GetResultSourceConfig().(*TestGroup_ResultSource_JunitConfig); ok {
		return x.JunitConfig
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*TestGroup_ResultSource) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*TestGroup_ResultSource_JunitConfig)(nil),
	}
}

type JUnitConfig struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *JUnitConfig) Reset()         { *m = JUnitConfig{} }
func (m *JUnitConfig) String() string { return proto.CompactTextString(m) }
func (*JUnitConfig) ProtoMessage()    {}
func (*JUnitConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{3}
}

func (m *JUnitConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JUnitConfig.Unmarshal(m, b)
}
func (m *JUnitConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JUnitConfig.Marshal(b, m, deterministic)
}
func (m *JUnitConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JUnitConfig.Merge(m, src)
}
func (m *JUnitConfig) XXX_Size() int {
	return xxx_messageInfo_JUnitConfig.Size(m)
}
func (m *JUnitConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_JUnitConfig.DiscardUnknown(m)
}

var xxx_messageInfo_JUnitConfig proto.InternalMessageInfo

// Default metadata to apply when opening bugs.
type TestMetadataOptions struct {
	// Apply the following metadata if this regex matches a test's name.
	TestNameRegex string `protobuf:"bytes,1,opt,name=test_name_regex,json=testNameRegex,proto3" json:"test_name_regex,omitempty"`
	// Default bug component to open a bug in.
	BugComponent int32 `protobuf:"varint,2,opt,name=bug_component,json=bugComponent,proto3" json:"bug_component,omitempty"`
	// Default owner to assign a bug to.
	Owner string `protobuf:"bytes,3,opt,name=owner,proto3" json:"owner,omitempty"`
	// List of default users to CC a bug to.
	Cc []string `protobuf:"bytes,4,rep,name=cc,proto3" json:"cc,omitempty"`
	// Apply following metadata if this regex matches a test’s failure message.
	MessageRegex         string   `protobuf:"bytes,5,opt,name=message_regex,json=messageRegex,proto3" json:"message_regex,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TestMetadataOptions) Reset()         { *m = TestMetadataOptions{} }
func (m *TestMetadataOptions) String() string { return proto.CompactTextString(m) }
func (*TestMetadataOptions) ProtoMessage()    {}
func (*TestMetadataOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{4}
}

func (m *TestMetadataOptions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestMetadataOptions.Unmarshal(m, b)
}
func (m *TestMetadataOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestMetadataOptions.Marshal(b, m, deterministic)
}
func (m *TestMetadataOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestMetadataOptions.Merge(m, src)
}
func (m *TestMetadataOptions) XXX_Size() int {
	return xxx_messageInfo_TestMetadataOptions.Size(m)
}
func (m *TestMetadataOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_TestMetadataOptions.DiscardUnknown(m)
}

var xxx_messageInfo_TestMetadataOptions proto.InternalMessageInfo

func (m *TestMetadataOptions) GetTestNameRegex() string {
	if m != nil {
		return m.TestNameRegex
	}
	return ""
}

func (m *TestMetadataOptions) GetBugComponent() int32 {
	if m != nil {
		return m.BugComponent
	}
	return 0
}

func (m *TestMetadataOptions) GetOwner() string {
	if m != nil {
		return m.Owner
	}
	return ""
}

func (m *TestMetadataOptions) GetCc() []string {
	if m != nil {
		return m.Cc
	}
	return nil
}

func (m *TestMetadataOptions) GetMessageRegex() string {
	if m != nil {
		return m.MessageRegex
	}
	return ""
}

type AutoBugOptions struct {
	// Whether to auto-close auto-filed bugs.
	AutoClose bool `protobuf:"varint,1,opt,name=auto_close,json=autoClose,proto3" json:"auto_close,omitempty"`
	// A list of hotlist ids attached to auto-filed bugs.
	HotlistIds []int64 `protobuf:"varint,2,rep,packed,name=hotlist_ids,json=hotlistIds,proto3" json:"hotlist_ids,omitempty"`
	// The priority of the auto-filed bug. If provided, this will overwrite the
	// priority in the component default template
	Priority AutoBugOptions_Priority `protobuf:"varint,3,opt,name=priority,proto3,enum=AutoBugOptions_Priority" json:"priority,omitempty"`
	// A list of hotlist id sources
	// Corresponds with the list hotlist_ids (#2)
	HotlistIdsFromSource []*HotlistIdFromSource `protobuf:"bytes,4,rep,name=hotlist_ids_from_source,json=hotlistIdsFromSource,proto3" json:"hotlist_ids_from_source,omitempty"`
	// If True, files separate bugs for each failing target, instead of one bug
	// for each set of targets failing at the same run.
	FileIndividual bool `protobuf:"varint,5,opt,name=file_individual,json=fileIndividual,proto3" json:"file_individual,omitempty"`
	// If True; keep only one automantic bug per target, regardless of the number of
	// separate failures a target gets. This also requires `auto_close` and
	// `file_individual` to be True.
	// Consider setting `num_passes_to_disable_alert` instead if you're tracking
	// flaky tests.
	SingletonAutobug bool `protobuf:"varint,6,opt,name=singleton_autobug,json=singletonAutobug,proto3" json:"singleton_autobug,omitempty"`
	// If provided: only raise one bug if the number of failures for a single
	// query by testgrid for a single failure group exceeds this value. Requires
	// 'file_individual' to be True.
	MaxAllowedIndividualBugs int32    `protobuf:"varint,7,opt,name=max_allowed_individual_bugs,json=maxAllowedIndividualBugs,proto3" json:"max_allowed_individual_bugs,omitempty"`
	XXX_NoUnkeyedLiteral     struct{} `json:"-"`
	XXX_unrecognized         []byte   `json:"-"`
	XXX_sizecache            int32    `json:"-"`
}

func (m *AutoBugOptions) Reset()         { *m = AutoBugOptions{} }
func (m *AutoBugOptions) String() string { return proto.CompactTextString(m) }
func (*AutoBugOptions) ProtoMessage()    {}
func (*AutoBugOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{5}
}

func (m *AutoBugOptions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AutoBugOptions.Unmarshal(m, b)
}
func (m *AutoBugOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AutoBugOptions.Marshal(b, m, deterministic)
}
func (m *AutoBugOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AutoBugOptions.Merge(m, src)
}
func (m *AutoBugOptions) XXX_Size() int {
	return xxx_messageInfo_AutoBugOptions.Size(m)
}
func (m *AutoBugOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_AutoBugOptions.DiscardUnknown(m)
}

var xxx_messageInfo_AutoBugOptions proto.InternalMessageInfo

func (m *AutoBugOptions) GetAutoClose() bool {
	if m != nil {
		return m.AutoClose
	}
	return false
}

func (m *AutoBugOptions) GetHotlistIds() []int64 {
	if m != nil {
		return m.HotlistIds
	}
	return nil
}

func (m *AutoBugOptions) GetPriority() AutoBugOptions_Priority {
	if m != nil {
		return m.Priority
	}
	return AutoBugOptions_PRIORITY_UNSPECIFIED
}

func (m *AutoBugOptions) GetHotlistIdsFromSource() []*HotlistIdFromSource {
	if m != nil {
		return m.HotlistIdsFromSource
	}
	return nil
}

func (m *AutoBugOptions) GetFileIndividual() bool {
	if m != nil {
		return m.FileIndividual
	}
	return false
}

func (m *AutoBugOptions) GetSingletonAutobug() bool {
	if m != nil {
		return m.SingletonAutobug
	}
	return false
}

func (m *AutoBugOptions) GetMaxAllowedIndividualBugs() int32 {
	if m != nil {
		return m.MaxAllowedIndividualBugs
	}
	return 0
}

type HotlistIdFromSource struct {
	// Types that are valid to be assigned to HotlistIdSource:
	//	*HotlistIdFromSource_Value
	//	*HotlistIdFromSource_Label
	HotlistIdSource      isHotlistIdFromSource_HotlistIdSource `protobuf_oneof:"hotlist_id_source"`
	XXX_NoUnkeyedLiteral struct{}                              `json:"-"`
	XXX_unrecognized     []byte                                `json:"-"`
	XXX_sizecache        int32                                 `json:"-"`
}

func (m *HotlistIdFromSource) Reset()         { *m = HotlistIdFromSource{} }
func (m *HotlistIdFromSource) String() string { return proto.CompactTextString(m) }
func (*HotlistIdFromSource) ProtoMessage()    {}
func (*HotlistIdFromSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{6}
}

func (m *HotlistIdFromSource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HotlistIdFromSource.Unmarshal(m, b)
}
func (m *HotlistIdFromSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HotlistIdFromSource.Marshal(b, m, deterministic)
}
func (m *HotlistIdFromSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HotlistIdFromSource.Merge(m, src)
}
func (m *HotlistIdFromSource) XXX_Size() int {
	return xxx_messageInfo_HotlistIdFromSource.Size(m)
}
func (m *HotlistIdFromSource) XXX_DiscardUnknown() {
	xxx_messageInfo_HotlistIdFromSource.DiscardUnknown(m)
}

var xxx_messageInfo_HotlistIdFromSource proto.InternalMessageInfo

type isHotlistIdFromSource_HotlistIdSource interface {
	isHotlistIdFromSource_HotlistIdSource()
}

type HotlistIdFromSource_Value struct {
	Value int64 `protobuf:"varint,1,opt,name=value,proto3,oneof"`
}

type HotlistIdFromSource_Label struct {
	Label string `protobuf:"bytes,2,opt,name=label,proto3,oneof"`
}

func (*HotlistIdFromSource_Value) isHotlistIdFromSource_HotlistIdSource() {}

func (*HotlistIdFromSource_Label) isHotlistIdFromSource_HotlistIdSource() {}

func (m *HotlistIdFromSource) GetHotlistIdSource() isHotlistIdFromSource_HotlistIdSource {
	if m != nil {
		return m.HotlistIdSource
	}
	return nil
}

func (m *HotlistIdFromSource) GetValue() int64 {
	if x, ok := m.GetHotlistIdSource().(*HotlistIdFromSource_Value); ok {
		return x.Value
	}
	return 0
}

func (m *HotlistIdFromSource) GetLabel() string {
	if x, ok := m.GetHotlistIdSource().(*HotlistIdFromSource_Label); ok {
		return x.Label
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*HotlistIdFromSource) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*HotlistIdFromSource_Value)(nil),
		(*HotlistIdFromSource_Label)(nil),
	}
}

// Specifies a dashboard.
type Dashboard struct {
	// A list of the tabs on the dashboard.
	DashboardTab []*DashboardTab `protobuf:"bytes,1,rep,name=dashboard_tab,json=dashboardTab,proto3" json:"dashboard_tab,omitempty"`
	// A name for the Dashboard.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// A list of notifications attached to this dashboard.
	// This is displayed on any dashboard tab in this dashboard.
	Notifications []*Notification `protobuf:"bytes,3,rep,name=notifications,proto3" json:"notifications,omitempty"`
	// Control which tab is displayed when first opening a dashboard.
	// Defaults to Summary
	DefaultTab           string   `protobuf:"bytes,5,opt,name=default_tab,json=defaultTab,proto3" json:"default_tab,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Dashboard) Reset()         { *m = Dashboard{} }
func (m *Dashboard) String() string { return proto.CompactTextString(m) }
func (*Dashboard) ProtoMessage()    {}
func (*Dashboard) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{7}
}

func (m *Dashboard) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Dashboard.Unmarshal(m, b)
}
func (m *Dashboard) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Dashboard.Marshal(b, m, deterministic)
}
func (m *Dashboard) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Dashboard.Merge(m, src)
}
func (m *Dashboard) XXX_Size() int {
	return xxx_messageInfo_Dashboard.Size(m)
}
func (m *Dashboard) XXX_DiscardUnknown() {
	xxx_messageInfo_Dashboard.DiscardUnknown(m)
}

var xxx_messageInfo_Dashboard proto.InternalMessageInfo

func (m *Dashboard) GetDashboardTab() []*DashboardTab {
	if m != nil {
		return m.DashboardTab
	}
	return nil
}

func (m *Dashboard) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Dashboard) GetNotifications() []*Notification {
	if m != nil {
		return m.Notifications
	}
	return nil
}

func (m *Dashboard) GetDefaultTab() string {
	if m != nil {
		return m.DefaultTab
	}
	return ""
}

type LinkTemplate struct {
	// The URL template.
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	// The options templates.
	Options              []*LinkOptionsTemplate `protobuf:"bytes,2,rep,name=options,proto3" json:"options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *LinkTemplate) Reset()         { *m = LinkTemplate{} }
func (m *LinkTemplate) String() string { return proto.CompactTextString(m) }
func (*LinkTemplate) ProtoMessage()    {}
func (*LinkTemplate) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{8}
}

func (m *LinkTemplate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LinkTemplate.Unmarshal(m, b)
}
func (m *LinkTemplate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LinkTemplate.Marshal(b, m, deterministic)
}
func (m *LinkTemplate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LinkTemplate.Merge(m, src)
}
func (m *LinkTemplate) XXX_Size() int {
	return xxx_messageInfo_LinkTemplate.Size(m)
}
func (m *LinkTemplate) XXX_DiscardUnknown() {
	xxx_messageInfo_LinkTemplate.DiscardUnknown(m)
}

var xxx_messageInfo_LinkTemplate proto.InternalMessageInfo

func (m *LinkTemplate) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *LinkTemplate) GetOptions() []*LinkOptionsTemplate {
	if m != nil {
		return m.Options
	}
	return nil
}

// A simple key/value pair for link options.
type LinkOptionsTemplate struct {
	// The key for the option. This is not expanded.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// The value for the option. This is expanded the same as the LinkTemplate.
	Value                string   `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LinkOptionsTemplate) Reset()         { *m = LinkOptionsTemplate{} }
func (m *LinkOptionsTemplate) String() string { return proto.CompactTextString(m) }
func (*LinkOptionsTemplate) ProtoMessage()    {}
func (*LinkOptionsTemplate) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{9}
}

func (m *LinkOptionsTemplate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LinkOptionsTemplate.Unmarshal(m, b)
}
func (m *LinkOptionsTemplate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LinkOptionsTemplate.Marshal(b, m, deterministic)
}
func (m *LinkOptionsTemplate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LinkOptionsTemplate.Merge(m, src)
}
func (m *LinkOptionsTemplate) XXX_Size() int {
	return xxx_messageInfo_LinkOptionsTemplate.Size(m)
}
func (m *LinkOptionsTemplate) XXX_DiscardUnknown() {
	xxx_messageInfo_LinkOptionsTemplate.DiscardUnknown(m)
}

var xxx_messageInfo_LinkOptionsTemplate proto.InternalMessageInfo

func (m *LinkOptionsTemplate) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *LinkOptionsTemplate) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// A single tab on a dashboard.
type DashboardTab struct {
	// The name of the dashboard tab to display in the client.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The name of the TestGroup specifying the test results for this tab.
	TestGroupName string `protobuf:"bytes,2,opt,name=test_group_name,json=testGroupName,proto3" json:"test_group_name,omitempty"`
	// Default bug component for manually filing bugs from the dashboard
	BugComponent int32 `protobuf:"varint,3,opt,name=bug_component,json=bugComponent,proto3" json:"bug_component,omitempty"`
	// Default code search path for searching regressions. This value overrides
	// the default in the TestGroup config so that dashboards may be customized
	// separately.
	CodeSearchPath string `protobuf:"bytes,4,opt,name=code_search_path,json=codeSearchPath,proto3" json:"code_search_path,omitempty"`
	// See TestGroup.num_columns_recent. This value overrides the default in the
	// TestGroup config so that dashboards may be customized separately.
	NumColumnsRecent int32 `protobuf:"varint,5,opt,name=num_columns_recent,json=numColumnsRecent,proto3" json:"num_columns_recent,omitempty"`
	// Base options to always include, for example:
	// width=20&include-filter-by-regex=level_tests
	// This is taken from the #fragment part of the testgrid url.
	// Best way to create these is to setup the options on testgrid and then
	// copy the #fragment part.
	BaseOptions string `protobuf:"bytes,6,opt,name=base_options,json=baseOptions,proto3" json:"base_options,omitempty"`
	// The URL template to visit after clicking on a cell.
	OpenTestTemplate *LinkTemplate `protobuf:"bytes,7,opt,name=open_test_template,json=openTestTemplate,proto3" json:"open_test_template,omitempty"`
	// The URL template to visit when filing a bug.
	FileBugTemplate *LinkTemplate `protobuf:"bytes,8,opt,name=file_bug_template,json=fileBugTemplate,proto3" json:"file_bug_template,omitempty"`
	// The URL template to visit when attaching a bug
	AttachBugTemplate *LinkTemplate `protobuf:"bytes,9,opt,name=attach_bug_template,json=attachBugTemplate,proto3" json:"attach_bug_template,omitempty"`
	// Text to show in the about menu as a link to another view of the results.
	ResultsText string `protobuf:"bytes,10,opt,name=results_text,json=resultsText,proto3" json:"results_text,omitempty"`
	// The URL template to visit after clicking.
	ResultsUrlTemplate *LinkTemplate `protobuf:"bytes,11,opt,name=results_url_template,json=resultsUrlTemplate,proto3" json:"results_url_template,omitempty"`
	// The URL template to visit when searching for code changes, such as pull requests
	CodeSearchUrlTemplate *LinkTemplate `protobuf:"bytes,12,opt,name=code_search_url_template,json=codeSearchUrlTemplate,proto3" json:"code_search_url_template,omitempty"`
	// A description paragraph to be displayed.
	Description string `protobuf:"bytes,13,opt,name=description,proto3" json:"description,omitempty"`
	// A regular expression that uses the named group syntax to specify how to
	// show names in a table.
	TabularNamesRegex string `protobuf:"bytes,14,opt,name=tabular_names_regex,json=tabularNamesRegex,proto3" json:"tabular_names_regex,omitempty"`
	// Configuration options for dashboard tab alerts.
	AlertOptions *DashboardTabAlertOptions `protobuf:"bytes,15,opt,name=alert_options,json=alertOptions,proto3" json:"alert_options,omitempty"`
	// A URL for the "About this Dashboard" menu option
	AboutDashboardUrl string `protobuf:"bytes,16,opt,name=about_dashboard_url,json=aboutDashboardUrl,proto3" json:"about_dashboard_url,omitempty"`
	// The URL template to visit when viewing an associated bug.
	OpenBugTemplate      *LinkTemplate `protobuf:"bytes,17,opt,name=open_bug_template,json=openBugTemplate,proto3" json:"open_bug_template,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *DashboardTab) Reset()         { *m = DashboardTab{} }
func (m *DashboardTab) String() string { return proto.CompactTextString(m) }
func (*DashboardTab) ProtoMessage()    {}
func (*DashboardTab) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{10}
}

func (m *DashboardTab) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DashboardTab.Unmarshal(m, b)
}
func (m *DashboardTab) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DashboardTab.Marshal(b, m, deterministic)
}
func (m *DashboardTab) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DashboardTab.Merge(m, src)
}
func (m *DashboardTab) XXX_Size() int {
	return xxx_messageInfo_DashboardTab.Size(m)
}
func (m *DashboardTab) XXX_DiscardUnknown() {
	xxx_messageInfo_DashboardTab.DiscardUnknown(m)
}

var xxx_messageInfo_DashboardTab proto.InternalMessageInfo

func (m *DashboardTab) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DashboardTab) GetTestGroupName() string {
	if m != nil {
		return m.TestGroupName
	}
	return ""
}

func (m *DashboardTab) GetBugComponent() int32 {
	if m != nil {
		return m.BugComponent
	}
	return 0
}

func (m *DashboardTab) GetCodeSearchPath() string {
	if m != nil {
		return m.CodeSearchPath
	}
	return ""
}

func (m *DashboardTab) GetNumColumnsRecent() int32 {
	if m != nil {
		return m.NumColumnsRecent
	}
	return 0
}

func (m *DashboardTab) GetBaseOptions() string {
	if m != nil {
		return m.BaseOptions
	}
	return ""
}

func (m *DashboardTab) GetOpenTestTemplate() *LinkTemplate {
	if m != nil {
		return m.OpenTestTemplate
	}
	return nil
}

func (m *DashboardTab) GetFileBugTemplate() *LinkTemplate {
	if m != nil {
		return m.FileBugTemplate
	}
	return nil
}

func (m *DashboardTab) GetAttachBugTemplate() *LinkTemplate {
	if m != nil {
		return m.AttachBugTemplate
	}
	return nil
}

func (m *DashboardTab) GetResultsText() string {
	if m != nil {
		return m.ResultsText
	}
	return ""
}

func (m *DashboardTab) GetResultsUrlTemplate() *LinkTemplate {
	if m != nil {
		return m.ResultsUrlTemplate
	}
	return nil
}

func (m *DashboardTab) GetCodeSearchUrlTemplate() *LinkTemplate {
	if m != nil {
		return m.CodeSearchUrlTemplate
	}
	return nil
}

func (m *DashboardTab) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *DashboardTab) GetTabularNamesRegex() string {
	if m != nil {
		return m.TabularNamesRegex
	}
	return ""
}

func (m *DashboardTab) GetAlertOptions() *DashboardTabAlertOptions {
	if m != nil {
		return m.AlertOptions
	}
	return nil
}

func (m *DashboardTab) GetAboutDashboardUrl() string {
	if m != nil {
		return m.AboutDashboardUrl
	}
	return ""
}

func (m *DashboardTab) GetOpenBugTemplate() *LinkTemplate {
	if m != nil {
		return m.OpenBugTemplate
	}
	return nil
}

// Configuration options for dashboard tab alerts.
type DashboardTabAlertOptions struct {
	// Time in hours before an alert will be added to a test results table if the
	// run date of the latest results are older than this time.  If zero, no
	// alerts are raised.
	AlertStaleResultsHours int32 `protobuf:"varint,1,opt,name=alert_stale_results_hours,json=alertStaleResultsHours,proto3" json:"alert_stale_results_hours,omitempty"`
	// The number of consecutive test result failures to see before alerting of
	// a consistent failure. If zero, no alerts are raised.
	NumFailuresToAlert int32 `protobuf:"varint,2,opt,name=num_failures_to_alert,json=numFailuresToAlert,proto3" json:"num_failures_to_alert,omitempty"`
	// The comma-separated addresses to send mail.
	AlertMailToAddresses string `protobuf:"bytes,3,opt,name=alert_mail_to_addresses,json=alertMailToAddresses,proto3" json:"alert_mail_to_addresses,omitempty"`
	// The number of consecutive test passes to close the alert.
	NumPassesToDisableAlert int32 `protobuf:"varint,4,opt,name=num_passes_to_disable_alert,json=numPassesToDisableAlert,proto3" json:"num_passes_to_disable_alert,omitempty"`
	// Custom subject for alert mails.
	Subject string `protobuf:"bytes,5,opt,name=subject,proto3" json:"subject,omitempty"`
	// Custom link for further help/instructions on debugging this alert.
	DebugUrl string `protobuf:"bytes,6,opt,name=debug_url,json=debugUrl,proto3" json:"debug_url,omitempty"`
	// Custom text to show for the debug link.
	DebugMessage         string   `protobuf:"bytes,7,opt,name=debug_message,json=debugMessage,proto3" json:"debug_message,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DashboardTabAlertOptions) Reset()         { *m = DashboardTabAlertOptions{} }
func (m *DashboardTabAlertOptions) String() string { return proto.CompactTextString(m) }
func (*DashboardTabAlertOptions) ProtoMessage()    {}
func (*DashboardTabAlertOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{11}
}

func (m *DashboardTabAlertOptions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DashboardTabAlertOptions.Unmarshal(m, b)
}
func (m *DashboardTabAlertOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DashboardTabAlertOptions.Marshal(b, m, deterministic)
}
func (m *DashboardTabAlertOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DashboardTabAlertOptions.Merge(m, src)
}
func (m *DashboardTabAlertOptions) XXX_Size() int {
	return xxx_messageInfo_DashboardTabAlertOptions.Size(m)
}
func (m *DashboardTabAlertOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_DashboardTabAlertOptions.DiscardUnknown(m)
}

var xxx_messageInfo_DashboardTabAlertOptions proto.InternalMessageInfo

func (m *DashboardTabAlertOptions) GetAlertStaleResultsHours() int32 {
	if m != nil {
		return m.AlertStaleResultsHours
	}
	return 0
}

func (m *DashboardTabAlertOptions) GetNumFailuresToAlert() int32 {
	if m != nil {
		return m.NumFailuresToAlert
	}
	return 0
}

func (m *DashboardTabAlertOptions) GetAlertMailToAddresses() string {
	if m != nil {
		return m.AlertMailToAddresses
	}
	return ""
}

func (m *DashboardTabAlertOptions) GetNumPassesToDisableAlert() int32 {
	if m != nil {
		return m.NumPassesToDisableAlert
	}
	return 0
}

func (m *DashboardTabAlertOptions) GetSubject() string {
	if m != nil {
		return m.Subject
	}
	return ""
}

func (m *DashboardTabAlertOptions) GetDebugUrl() string {
	if m != nil {
		return m.DebugUrl
	}
	return ""
}

func (m *DashboardTabAlertOptions) GetDebugMessage() string {
	if m != nil {
		return m.DebugMessage
	}
	return ""
}

// Specifies a dashboard group.
type DashboardGroup struct {
	// The name for the dashboard group.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A list of names specifying dashboards to show links to in a separate tabbed
	// bar at the top of the page for each of the given dashboards.
	DashboardNames       []string `protobuf:"bytes,2,rep,name=dashboard_names,json=dashboardNames,proto3" json:"dashboard_names,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DashboardGroup) Reset()         { *m = DashboardGroup{} }
func (m *DashboardGroup) String() string { return proto.CompactTextString(m) }
func (*DashboardGroup) ProtoMessage()    {}
func (*DashboardGroup) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{12}
}

func (m *DashboardGroup) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DashboardGroup.Unmarshal(m, b)
}
func (m *DashboardGroup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DashboardGroup.Marshal(b, m, deterministic)
}
func (m *DashboardGroup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DashboardGroup.Merge(m, src)
}
func (m *DashboardGroup) XXX_Size() int {
	return xxx_messageInfo_DashboardGroup.Size(m)
}
func (m *DashboardGroup) XXX_DiscardUnknown() {
	xxx_messageInfo_DashboardGroup.DiscardUnknown(m)
}

var xxx_messageInfo_DashboardGroup proto.InternalMessageInfo

func (m *DashboardGroup) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DashboardGroup) GetDashboardNames() []string {
	if m != nil {
		return m.DashboardNames
	}
	return nil
}

// A service configuration consisting of multiple test groups and dashboards.
type Configuration struct {
	// A list of groups of tests to gather.
	TestGroups []*TestGroup `protobuf:"bytes,1,rep,name=test_groups,json=testGroups,proto3" json:"test_groups,omitempty"`
	// A list of all of the dashboards for a server.
	Dashboards []*Dashboard `protobuf:"bytes,2,rep,name=dashboards,proto3" json:"dashboards,omitempty"`
	// A list of all the dashboard groups for a server.
	DashboardGroups      []*DashboardGroup `protobuf:"bytes,3,rep,name=dashboard_groups,json=dashboardGroups,proto3" json:"dashboard_groups,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Configuration) Reset()         { *m = Configuration{} }
func (m *Configuration) String() string { return proto.CompactTextString(m) }
func (*Configuration) ProtoMessage()    {}
func (*Configuration) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{13}
}

func (m *Configuration) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Configuration.Unmarshal(m, b)
}
func (m *Configuration) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Configuration.Marshal(b, m, deterministic)
}
func (m *Configuration) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Configuration.Merge(m, src)
}
func (m *Configuration) XXX_Size() int {
	return xxx_messageInfo_Configuration.Size(m)
}
func (m *Configuration) XXX_DiscardUnknown() {
	xxx_messageInfo_Configuration.DiscardUnknown(m)
}

var xxx_messageInfo_Configuration proto.InternalMessageInfo

func (m *Configuration) GetTestGroups() []*TestGroup {
	if m != nil {
		return m.TestGroups
	}
	return nil
}

func (m *Configuration) GetDashboards() []*Dashboard {
	if m != nil {
		return m.Dashboards
	}
	return nil
}

func (m *Configuration) GetDashboardGroups() []*DashboardGroup {
	if m != nil {
		return m.DashboardGroups
	}
	return nil
}

// The DefaultConfiguration Proto is deprecated, and will be deleted after Nov 1, 2019
// For defaulting behavior, use the yamlcfg library instead.
type DefaultConfiguration struct {
	// A default testgroup with default initialization data
	DefaultTestGroup *TestGroup `protobuf:"bytes,1,opt,name=default_test_group,json=defaultTestGroup,proto3" json:"default_test_group,omitempty"` // Deprecated: Do not use.
	// A default dashboard tab with default initialization data
	DefaultDashboardTab  *DashboardTab `protobuf:"bytes,2,opt,name=default_dashboard_tab,json=defaultDashboardTab,proto3" json:"default_dashboard_tab,omitempty"` // Deprecated: Do not use.
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *DefaultConfiguration) Reset()         { *m = DefaultConfiguration{} }
func (m *DefaultConfiguration) String() string { return proto.CompactTextString(m) }
func (*DefaultConfiguration) ProtoMessage()    {}
func (*DefaultConfiguration) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{14}
}

func (m *DefaultConfiguration) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DefaultConfiguration.Unmarshal(m, b)
}
func (m *DefaultConfiguration) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DefaultConfiguration.Marshal(b, m, deterministic)
}
func (m *DefaultConfiguration) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DefaultConfiguration.Merge(m, src)
}
func (m *DefaultConfiguration) XXX_Size() int {
	return xxx_messageInfo_DefaultConfiguration.Size(m)
}
func (m *DefaultConfiguration) XXX_DiscardUnknown() {
	xxx_messageInfo_DefaultConfiguration.DiscardUnknown(m)
}

var xxx_messageInfo_DefaultConfiguration proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *DefaultConfiguration) GetDefaultTestGroup() *TestGroup {
	if m != nil {
		return m.DefaultTestGroup
	}
	return nil
}

// Deprecated: Do not use.
func (m *DefaultConfiguration) GetDefaultDashboardTab() *DashboardTab {
	if m != nil {
		return m.DefaultDashboardTab
	}
	return nil
}

func init() {
	proto.RegisterEnum("TestGroup_TestsName", TestGroup_TestsName_name, TestGroup_TestsName_value)
	proto.RegisterEnum("TestGroup_FallbackGrouping", TestGroup_FallbackGrouping_name, TestGroup_FallbackGrouping_value)
	proto.RegisterEnum("TestGroup_ColumnSortBy", TestGroup_ColumnSortBy_name, TestGroup_ColumnSortBy_value)
	proto.RegisterEnum("TestGroup_PrimaryGrouping", TestGroup_PrimaryGrouping_name, TestGroup_PrimaryGrouping_value)
	proto.RegisterEnum("TestGroup_Environment", TestGroup_Environment_name, TestGroup_Environment_value)
	proto.RegisterEnum("AutoBugOptions_Priority", AutoBugOptions_Priority_name, AutoBugOptions_Priority_value)
	proto.RegisterType((*TestNameConfig)(nil), "TestNameConfig")
	proto.RegisterType((*TestNameConfig_NameElement)(nil), "TestNameConfig.NameElement")
	proto.RegisterType((*Notification)(nil), "Notification")
	proto.RegisterType((*TestGroup)(nil), "TestGroup")
	proto.RegisterType((*TestGroup_ColumnHeader)(nil), "TestGroup.ColumnHeader")
	proto.RegisterType((*TestGroup_TestAnnotation)(nil), "TestGroup.TestAnnotation")
	proto.RegisterType((*TestGroup_KeyValue)(nil), "TestGroup.KeyValue")
	proto.RegisterType((*TestGroup_ResultSource)(nil), "TestGroup.ResultSource")
	proto.RegisterType((*JUnitConfig)(nil), "JUnitConfig")
	proto.RegisterType((*TestMetadataOptions)(nil), "TestMetadataOptions")
	proto.RegisterType((*AutoBugOptions)(nil), "AutoBugOptions")
	proto.RegisterType((*HotlistIdFromSource)(nil), "HotlistIdFromSource")
	proto.RegisterType((*Dashboard)(nil), "Dashboard")
	proto.RegisterType((*LinkTemplate)(nil), "LinkTemplate")
	proto.RegisterType((*LinkOptionsTemplate)(nil), "LinkOptionsTemplate")
	proto.RegisterType((*DashboardTab)(nil), "DashboardTab")
	proto.RegisterType((*DashboardTabAlertOptions)(nil), "DashboardTabAlertOptions")
	proto.RegisterType((*DashboardGroup)(nil), "DashboardGroup")
	proto.RegisterType((*Configuration)(nil), "Configuration")
	proto.RegisterType((*DefaultConfiguration)(nil), "DefaultConfiguration")
}

func init() { proto.RegisterFile("config.proto", fileDescriptor_3eaf2c85e69e9ea4) }

var fileDescriptor_3eaf2c85e69e9ea4 = []byte{
	// 2921 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x59, 0x5f, 0x77, 0x1b, 0xb7,
	0xb1, 0x37, 0x49, 0xc9, 0xa6, 0x86, 0xa4, 0xb4, 0x82, 0x28, 0x79, 0x25, 0xc5, 0xd7, 0x32, 0x7d,
	0x9d, 0x28, 0x71, 0xae, 0x1c, 0xcb, 0xc9, 0x3d, 0xf1, 0x8d, 0x7d, 0x1b, 0x4a, 0xa2, 0x2c, 0xda,
	0xa2, 0xc4, 0x2c, 0xa9, 0x9c, 0x93, 0xbe, 0xe0, 0x80, 0x4b, 0x88, 0xda, 0x68, 0xff, 0xf0, 0x2c,
	0xb0, 0x8e, 0xf4, 0x59, 0xda, 0xc7, 0x9e, 0xbe, 0xf5, 0xf4, 0xad, 0x1f, 0xa2, 0x2f, 0x7d, 0xee,
	0xc7, 0xe8, 0x37, 0xe8, 0xc1, 0x00, 0xbb, 0x5c, 0x4a, 0xb4, 0x9b, 0xf6, 0x89, 0x8b, 0xf9, 0x07,
	0x60, 0x30, 0xf8, 0xcd, 0x0c, 0x08, 0x55, 0x37, 0x0a, 0xcf, 0xbd, 0xd1, 0xce, 0x38, 0x8e, 0x64,
	0xb4, 0xf1, 0xc5, 0x78, 0xf0, 0xcc, 0x4d, 0x84, 0x8c, 0x02, 0xca, 0xdf, 0x33, 0x3f, 0x61, 0x32,
	0x8a, 0x6f, 0x11, 0xb4, 0x6c, 0xe3, 0xf7, 0x45, 0x58, 0xec, 0x73, 0x21, 0x4f, 0x58, 0xc0, 0xf7,
	0xd1, 0x08, 0xf9, 0x1e, 0x6a, 0x21, 0x0b, 0x38, 0xe5, 0x3e, 0x0f, 0x78, 0x28, 0x85, 0x5d, 0xd8,
	0x2a, 0x6d, 0x57, 0x76, 0x37, 0x77, 0xa6, 0xe5, 0x76, 0xd4, 0x67, 0x4b, 0xcb, 0x38, 0xd5, 0x70,
	0x32, 0x10, 0xe4, 0x21, 0x54, 0xd0, 0xc2, 0x79, 0x14, 0x07, 0x4c, 0xda, 0xc5, 0xad, 0xc2, 0xf6,
	0x82, 0x03, 0x8a, 0x74, 0x88, 0x94, 0x8d, 0x3f, 0x16, 0xa0, 0x92, 0x53, 0x27, 0x6b, 0x70, 0xd7,
	0x67, 0x03, 0xee, 0xab, 0xb9, 0x94, 0xac, 0x19, 0x91, 0xc7, 0x50, 0x93, 0x2c, 0x1e, 0x71, 0x49,
	0xf5, 0x06, 0x8d, 0xa9, 0xaa, 0x26, 0x9a, 0xf5, 0x3e, 0x82, 0xea, 0x20, 0xf1, 0xfc, 0x21, 0xd5,
	0x54, 0xbb, 0xb4, 0x55, 0xd8, 0x2e, 0x3b, 0x15, 0xa4, 0xf5, 0x91, 0x44, 0x08, 0xcc, 0x49, 0x36,
	0x12, 0xf6, 0x1c, 0xaa, 0xe3, 0x37, 0xda, 0xe6, 0x42, 0xd2, 0x71, 0x1c, 0x8d, 0x79, 0x2c, 0xaf,
	0xed, 0x79, 0x63, 0x9b, 0x0b, 0xd9, 0x35, 0xb4, 0xc6, 0x3b, 0xa8, 0x9e, 0x44, 0xd2, 0x3b, 0xf7,
	0x5c, 0x26, 0xbd, 0x28, 0x24, 0x36, 0xdc, 0x13, 0x49, 0x10, 0xb0, 0xf8, 0xda, 0xac, 0x34, 0x1d,
	0xaa, 0x55, 0xb8, 0x51, 0x28, 0xf9, 0x95, 0xa4, 0xbe, 0x17, 0x5e, 0x9a, 0x95, 0x56, 0x0c, 0xed,
	0xd8, 0x0b, 0x2f, 0x1b, 0xff, 0x78, 0x00, 0x0b, 0xca, 0x87, 0x6f, 0xe2, 0x28, 0x19, 0xab, 0x35,
	0x29, 0x8f, 0x18, 0x3b, 0xf8, 0x4d, 0x1e, 0x00, 0x8c, 0x5c, 0x41, 0xc7, 0x31, 0x3f, 0xf7, 0xae,
	0x8c, 0x89, 0x85, 0x91, 0x2b, 0xba, 0x48, 0x20, 0x9f, 0xc2, 0xd2, 0x90, 0x5d, 0x0b, 0x1a, 0x9d,
	0xd3, 0x98, 0x8b, 0xc4, 0x97, 0x02, 0x37, 0x3b, 0xef, 0xd4, 0x14, 0xf9, 0xf4, 0xdc, 0xd1, 0x44,
	0xf2, 0x04, 0x16, 0xbd, 0x51, 0x18, 0xc5, 0x9c, 0x8e, 0x79, 0x38, 0xf4, 0xc2, 0x11, 0x6e, 0xbc,
	0xec, 0xd4, 0x34, 0xb5, 0xab, 0x89, 0x6a, 0xc9, 0x46, 0x4c, 0xf9, 0x4a, 0xa2, 0x03, 0xca, 0x4e,
	0x45, 0xd3, 0xf6, 0x14, 0x89, 0x7c, 0x0f, 0xcb, 0xca, 0x1f, 0x82, 0xe2, 0x79, 0x8e, 0x23, 0xdf,
	0x73, 0xaf, 0xed, 0xbb, 0x5b, 0x85, 0xed, 0xc5, 0xdd, 0xfa, 0x4e, 0xb6, 0x17, 0xfc, 0x12, 0xea,
	0x40, 0x9d, 0x25, 0x99, 0x7e, 0x76, 0x51, 0x98, 0x7c, 0x0b, 0x6b, 0x23, 0x26, 0x2f, 0x78, 0x4c,
	0xf3, 0xde, 0xf6, 0xb8, 0xb0, 0xef, 0xa9, 0xe9, 0xf6, 0x8a, 0x76, 0xc1, 0xa9, 0x6b, 0x89, 0xfe,
	0xc4, 0xf3, 0x1e, 0x17, 0x64, 0x17, 0x56, 0xcd, 0xf2, 0x50, 0x53, 0x24, 0x03, 0x21, 0x63, 0xb5,
	0x99, 0xf2, 0x56, 0x69, 0x7b, 0xc1, 0x59, 0xd1, 0x4c, 0xa5, 0xd4, 0x4b, 0x59, 0xe4, 0x15, 0xd4,
	0xdc, 0xc8, 0x4f, 0x82, 0x90, 0x5e, 0x70, 0x36, 0xe4, 0xb1, 0xbd, 0x80, 0xb1, 0x7b, 0x3f, 0xb7,
	0xd6, 0x7d, 0xe4, 0x1f, 0x21, 0xdb, 0xa9, 0xba, 0xb9, 0x11, 0x39, 0x82, 0xe5, 0x73, 0xe6, 0xfb,
	0x03, 0xe6, 0x5e, 0xd2, 0x91, 0x12, 0x56, 0xb3, 0x01, 0xee, 0x76, 0x33, 0x67, 0xe1, 0xd0, 0xc8,
	0xbc, 0x31, 0x22, 0x8e, 0x75, 0x7e, 0x83, 0x42, 0x5e, 0xc2, 0x3a, 0xf3, 0x79, 0x2c, 0xa9, 0x90,
	0xcc, 0xe7, 0xe9, 0x69, 0xd1, 0x8b, 0x28, 0x89, 0x85, 0x5d, 0xc1, 0x33, 0x5b, 0x43, 0x81, 0x9e,
	0xe2, 0x9b, 0x73, 0x3b, 0x52, 0x5c, 0xf2, 0x1c, 0x56, 0xc3, 0x24, 0xa0, 0xe7, 0xcc, 0xf3, 0x93,
	0x98, 0x0b, 0x2a, 0x23, 0x8a, 0x92, 0x76, 0x15, 0xd5, 0x48, 0x98, 0x04, 0x87, 0x86, 0xd7, 0x8f,
	0x9a, 0x8a, 0xa3, 0x42, 0x79, 0x90, 0x8c, 0xa8, 0x1b, 0x05, 0xe3, 0x28, 0xe4, 0xa1, 0xb4, 0x6b,
	0x28, 0x5a, 0x1d, 0x24, 0xa3, 0xfd, 0x94, 0x46, 0xb6, 0xc1, 0x72, 0xa3, 0x21, 0xa7, 0x82, 0xb3,
	0xd8, 0xbd, 0xa0, 0x63, 0x26, 0x2f, 0xec, 0x45, 0x8c, 0xb0, 0x45, 0x45, 0xef, 0x21, 0xb9, 0xcb,
	0xe4, 0x05, 0xf9, 0x12, 0xd4, 0x24, 0x54, 0xbb, 0x46, 0xd0, 0x98, 0xbb, 0xca, 0xe6, 0x12, 0xda,
	0xb4, 0xc2, 0x24, 0xd0, 0x1e, 0x14, 0x0e, 0xd2, 0xc9, 0x17, 0xb0, 0x9c, 0x08, 0x73, 0x46, 0x01,
	0x97, 0x6c, 0xc8, 0x24, 0xb3, 0x2d, 0x0c, 0xa5, 0xa5, 0x44, 0xe0, 0xf9, 0x74, 0x0c, 0x99, 0x7c,
	0x03, 0xf7, 0xb5, 0x5b, 0x02, 0xe6, 0xf9, 0xb8, 0xb3, 0xe1, 0x30, 0xe6, 0x42, 0x70, 0x61, 0x2f,
	0xe3, 0x52, 0xea, 0xc8, 0xee, 0x30, 0xcf, 0xef, 0x47, 0xcd, 0x94, 0xa7, 0x16, 0x94, 0x53, 0x13,
	0xc9, 0xe0, 0x67, 0xee, 0x4a, 0x9b, 0xa0, 0x86, 0x95, 0x69, 0xf4, 0x34, 0x9d, 0x7c, 0x07, 0x1b,
	0x39, 0x69, 0xe3, 0x47, 0x1a, 0x70, 0x21, 0xd8, 0x88, 0xdb, 0x2b, 0xa8, 0x75, 0x3f, 0xd3, 0x32,
	0xbe, 0xec, 0x68, 0x36, 0x79, 0x06, 0xf5, 0x9c, 0xf2, 0x90, 0x2b, 0xbf, 0x26, 0xb1, 0x6f, 0xd7,
	0x51, 0x6d, 0x39, 0x53, 0x3b, 0x50, 0x9c, 0xb3, 0xd8, 0x27, 0x47, 0xf0, 0x28, 0xf0, 0x42, 0xca,
	0x7d, 0x36, 0x16, 0x7c, 0x48, 0x03, 0x2f, 0x4c, 0x24, 0x17, 0x74, 0xc0, 0xe5, 0x2f, 0x9c, 0x87,
	0x68, 0x46, 0xd8, 0xab, 0xe8, 0xbb, 0x07, 0x81, 0x17, 0xb6, 0xb4, 0x5c, 0x47, 0x8b, 0xed, 0x69,
	0x29, 0x65, 0x50, 0x90, 0x33, 0xd8, 0x56, 0x8e, 0xd4, 0x48, 0x97, 0xc4, 0x08, 0x38, 0x54, 0xc1,
	0x35, 0x17, 0x94, 0x09, 0x1d, 0x04, 0x74, 0xcc, 0x62, 0x16, 0x08, 0x7b, 0x0d, 0xfd, 0xfb, 0x38,
	0x11, 0x06, 0x8c, 0x8d, 0xf8, 0x8f, 0x28, 0xdd, 0x14, 0x18, 0x16, 0x5d, 0x14, 0x25, 0x3b, 0xb0,
	0xc2, 0x43, 0x36, 0xf0, 0x39, 0x3d, 0xf7, 0xd9, 0xe5, 0xb5, 0x8a, 0x48, 0x99, 0x08, 0xfb, 0x3e,
	0x5a, 0x58, 0xd6, 0xac, 0x43, 0xc5, 0xe9, 0x21, 0x43, 0x5d, 0x3b, 0xb5, 0x8c, 0xcb, 0x64, 0xc0,
	0xe3, 0x90, 0xab, 0xbd, 0xb8, 0xbe, 0xa7, 0x02, 0xc0, 0x46, 0x8d, 0x95, 0x44, 0xf0, 0x77, 0x19,
	0x6f, 0x1f, 0x59, 0x0a, 0xf0, 0x3d, 0x41, 0xf9, 0x95, 0xe4, 0x71, 0xc8, 0x7c, 0x7b, 0x1d, 0x25,
	0xc1, 0x13, 0x2d, 0x43, 0x21, 0x2f, 0xc1, 0xc2, 0x00, 0x41, 0x18, 0x31, 0x58, 0xbe, 0xb1, 0x55,
	0xd8, 0xae, 0xec, 0x2e, 0xdd, 0x48, 0x2b, 0xce, 0xa2, 0x9c, 0x4e, 0x47, 0x2f, 0xa0, 0x16, 0xe6,
	0x20, 0x58, 0xd8, 0x9b, 0x78, 0xa5, 0x6b, 0x3b, 0x79, 0x60, 0x76, 0xa6, 0x65, 0xc8, 0x6b, 0x58,
	0x34, 0x38, 0x20, 0xa2, 0x58, 0xd2, 0xc1, 0xb5, 0xfd, 0x09, 0x5e, 0xe3, 0xdb, 0x40, 0xd0, 0x8b,
	0x62, 0xb9, 0x77, 0x9d, 0x02, 0x81, 0x1e, 0x91, 0x16, 0x58, 0xe3, 0xd8, 0x53, 0xb8, 0x3e, 0xc1,
	0x81, 0x07, 0x68, 0x60, 0x23, 0x67, 0xa0, 0xab, 0x45, 0x32, 0x18, 0x58, 0x1a, 0x4f, 0x13, 0x72,
	0xae, 0x4f, 0x6f, 0xc7, 0x45, 0x34, 0x14, 0xf6, 0x7f, 0xe5, 0x5d, 0x6f, 0xee, 0x87, 0x62, 0x90,
	0x03, 0xe3, 0x25, 0x16, 0x86, 0x91, 0x34, 0xbb, 0x7d, 0x88, 0xbb, 0x5d, 0xbf, 0x01, 0xb6, 0xcd,
	0x4c, 0x42, 0x23, 0xee, 0x64, 0x2c, 0xc8, 0xb7, 0xb0, 0x1e, 0xb0, 0xab, 0xa9, 0x29, 0xe9, 0xd8,
	0xe0, 0xaf, 0xbd, 0x85, 0x91, 0xb8, 0x1a, 0xb0, 0xab, 0xdc, 0xc4, 0x5d, 0x8d, 0xbd, 0xa4, 0x09,
	0x0f, 0xdc, 0x28, 0x08, 0x3c, 0x49, 0xa3, 0xf7, 0x3c, 0x8e, 0xbd, 0x21, 0xa7, 0x98, 0x88, 0x15,
	0x58, 0xa8, 0x83, 0xb4, 0x1f, 0xe1, 0x2d, 0xd8, 0xd0, 0x42, 0xa7, 0x46, 0xe6, 0x58, 0x89, 0x74,
	0xb5, 0x04, 0x39, 0x82, 0xd5, 0x29, 0x24, 0xa0, 0xd1, 0x58, 0xef, 0xa3, 0x81, 0xa7, 0xad, 0x93,
	0x46, 0x8a, 0x07, 0xa7, 0x9a, 0xe7, 0xac, 0xc8, 0xdb, 0x44, 0x85, 0x57, 0x68, 0x49, 0xb2, 0x51,
	0x36, 0xff, 0x63, 0x8d, 0x57, 0x8a, 0xde, 0x67, 0xa3, 0x74, 0xce, 0x97, 0x60, 0xb1, 0x44, 0x46,
	0x54, 0xdd, 0xd5, 0x74, 0xba, 0xff, 0x36, 0xc1, 0xd5, 0x4c, 0x64, 0xb4, 0x97, 0x8c, 0xd2, 0x99,
	0x16, 0xd9, 0xd4, 0x98, 0xbc, 0x80, 0xb5, 0xcc, 0x57, 0x71, 0x12, 0x4a, 0x2f, 0xe0, 0x06, 0xa4,
	0x9f, 0xa0, 0xa3, 0x56, 0x8c, 0xa3, 0x1c, 0xcd, 0xd3, 0x08, 0xfd, 0x0a, 0x36, 0x15, 0x3e, 0x8e,
	0x99, 0x02, 0x27, 0x85, 0x62, 0x43, 0x4f, 0xe0, 0x29, 0x6b, 0x9c, 0xfe, 0x14, 0x35, 0xef, 0x87,
	0x49, 0xd0, 0x45, 0x89, 0x7e, 0x74, 0xa0, 0xf9, 0x1a, 0xac, 0x9f, 0x02, 0x51, 0x05, 0x82, 0x5a,
	0xad, 0xa0, 0x03, 0x13, 0x60, 0xf6, 0x67, 0x1a, 0x30, 0x15, 0x67, 0x2f, 0x19, 0x89, 0x3d, 0x1d,
	0x44, 0xa4, 0x0d, 0x75, 0x1e, 0xbe, 0xf7, 0xe2, 0x28, 0x54, 0x75, 0x12, 0xf5, 0x42, 0x21, 0x59,
	0xe8, 0x72, 0x7b, 0x1b, 0x83, 0x71, 0x2d, 0x17, 0x15, 0xad, 0x89, 0x98, 0xb3, 0x92, 0xd3, 0x69,
	0x1b, 0x15, 0xd2, 0x86, 0xb5, 0x5c, 0x48, 0xe4, 0x13, 0xf1, 0xe7, 0x18, 0x62, 0x2b, 0x39, 0x63,
	0xef, 0xf8, 0x35, 0x42, 0x89, 0x53, 0x97, 0x59, 0x94, 0xe4, 0x32, 0xf3, 0x43, 0xa8, 0x98, 0x9c,
	0xae, 0x36, 0x61, 0x7f, 0xa1, 0xaf, 0xbb, 0x26, 0xa9, 0xd5, 0xab, 0x9c, 0x20, 0x2e, 0xd4, 0xc5,
	0xc3, 0x7a, 0x28, 0xe0, 0x32, 0xf6, 0x5c, 0xfb, 0x29, 0x1e, 0xde, 0x12, 0x32, 0xfa, 0xfc, 0x4a,
	0x99, 0x8d, 0x3d, 0x97, 0x74, 0xe0, 0xf1, 0xcd, 0xa0, 0x9b, 0x01, 0x81, 0xf6, 0x97, 0xa8, 0xbd,
	0x35, 0x1d, 0x7a, 0xb7, 0xc1, 0x4f, 0x45, 0xff, 0x94, 0x7b, 0xa7, 0x6e, 0xde, 0xff, 0xe0, 0x4a,
	0x57, 0x27, 0x5e, 0xce, 0xdf, 0xbe, 0x6f, 0xe0, 0x7e, 0xde, 0x41, 0x01, 0x93, 0xee, 0x05, 0x8d,
	0xf9, 0x88, 0x5f, 0xd9, 0x3b, 0x3a, 0x39, 0x4d, 0x9c, 0xd1, 0x51, 0x4c, 0x47, 0xf1, 0x54, 0xbe,
	0x56, 0x78, 0x79, 0x9e, 0xf8, 0x7e, 0xaa, 0xaa, 0x50, 0x4e, 0xd8, 0xcf, 0x70, 0x32, 0x92, 0x08,
	0x7e, 0x98, 0xf8, 0xbe, 0xd6, 0x53, 0xb8, 0x26, 0x48, 0x0b, 0x1e, 0x98, 0x72, 0x5c, 0x17, 0x06,
	0x93, 0xaa, 0x9c, 0xc6, 0x89, 0xcf, 0x85, 0xfd, 0x95, 0xaa, 0x70, 0xb0, 0x34, 0xda, 0xd0, 0x82,
	0xba, 0x42, 0x68, 0xa5, 0x62, 0x8e, 0x92, 0x22, 0x3f, 0xc0, 0x93, 0x5b, 0xe5, 0xca, 0x4c, 0xdf,
	0x3d, 0xc7, 0xe5, 0x37, 0x6e, 0x56, 0x29, 0x33, 0xbc, 0xf7, 0x0a, 0x6a, 0x66, 0x49, 0x22, 0x4a,
	0x62, 0x97, 0xdb, 0xbb, 0x78, 0x8f, 0xf2, 0xb0, 0xa9, 0x97, 0xd2, 0x43, 0xb6, 0x53, 0x8d, 0x73,
	0x23, 0xb2, 0x0f, 0xeb, 0x37, 0xdb, 0x0c, 0xdc, 0x10, 0x15, 0x5c, 0xda, 0x2f, 0xd0, 0x52, 0x79,
	0x47, 0xad, 0xbd, 0xc7, 0xa5, 0xb3, 0xa6, 0x45, 0xa7, 0xf6, 0xd4, 0xe3, 0x52, 0x1d, 0x43, 0xcc,
	0xd9, 0x10, 0xf3, 0x14, 0xa7, 0xe7, 0x71, 0x14, 0x50, 0x21, 0xa3, 0x58, 0xe5, 0xee, 0xaf, 0xd1,
	0xa3, 0x75, 0xc5, 0x56, 0xc9, 0x8a, 0x1f, 0xc6, 0x51, 0xd0, 0xd3, 0x3c, 0x55, 0x23, 0x98, 0x6a,
	0x31, 0xf2, 0x87, 0x59, 0x79, 0xfc, 0x0d, 0x6a, 0x58, 0x9a, 0x73, 0xea, 0x0f, 0xd3, 0x0a, 0x59,
	0x25, 0x2c, 0x2d, 0x2d, 0x2e, 0xbd, 0xb1, 0xfd, 0xbf, 0x26, 0x61, 0x21, 0xa9, 0x77, 0xe9, 0x8d,
	0x37, 0xde, 0x41, 0x35, 0x5f, 0x28, 0x92, 0x67, 0xb0, 0x32, 0xcb, 0xb3, 0x25, 0xf4, 0x2c, 0x71,
	0x6f, 0x79, 0xf2, 0xed, 0x5c, 0xb9, 0x60, 0x15, 0xdf, 0xce, 0x95, 0x8b, 0x56, 0x69, 0x43, 0xe8,
	0x1e, 0x6b, 0x02, 0xd2, 0xaa, 0xd0, 0x9f, 0x5c, 0x10, 0xd3, 0x02, 0x2c, 0x64, 0x37, 0x83, 0x3c,
	0x81, 0x5a, 0xda, 0x96, 0x60, 0x30, 0xe9, 0x56, 0xe0, 0xe8, 0x8e, 0x53, 0x4d, 0xc9, 0x2a, 0x90,
	0xf6, 0x36, 0x61, 0x7d, 0xea, 0x9a, 0x61, 0x09, 0x63, 0x4e, 0x6e, 0x63, 0x17, 0xca, 0xe9, 0x35,
	0x26, 0x16, 0x94, 0x2e, 0x79, 0xda, 0xb2, 0xa8, 0x4f, 0x52, 0x87, 0x79, 0xbd, 0x03, 0xdd, 0x64,
	0xe8, 0xc1, 0x06, 0x87, 0x6a, 0xfe, 0x78, 0xc9, 0x73, 0xa8, 0xfe, 0x9c, 0x84, 0xde, 0x54, 0xfb,
	0x55, 0xd9, 0xad, 0xee, 0xbc, 0x3d, 0x0b, 0x3d, 0xd3, 0x7e, 0x1d, 0xdd, 0x71, 0x2a, 0x28, 0xa3,
	0x87, 0x7b, 0x6b, 0x50, 0x9f, 0x8a, 0x20, 0xa3, 0x9a, 0xf9, 0xa3, 0x64, 0xcd, 0x35, 0xb8, 0xee,
	0x83, 0xb0, 0x4d, 0x20, 0x04, 0x16, 0xfb, 0xad, 0x5e, 0xbf, 0x47, 0x4f, 0x9a, 0x9d, 0x16, 0xed,
	0xb4, 0x4f, 0xac, 0x3b, 0x64, 0x15, 0x96, 0x73, 0xb4, 0xf6, 0x9b, 0x93, 0x53, 0xa7, 0x65, 0x15,
	0xc8, 0x1a, 0x90, 0x1c, 0xd9, 0x69, 0x75, 0x8f, 0x9b, 0xfb, 0x2d, 0xab, 0x78, 0x43, 0xbc, 0xd9,
	0xed, 0xb6, 0x4e, 0x0e, 0xac, 0x52, 0xe3, 0x6f, 0x05, 0xb0, 0x6e, 0xd6, 0xea, 0x64, 0x03, 0xd6,
	0x0e, 0x9b, 0xc7, 0xc7, 0x7b, 0xcd, 0xfd, 0x77, 0xf4, 0x8d, 0x73, 0x7a, 0xd6, 0x6d, 0x9f, 0xbc,
	0xa1, 0x27, 0xa7, 0x27, 0x2d, 0xeb, 0xce, 0x6c, 0xde, 0x41, 0xb3, 0xaf, 0xe6, 0xfe, 0x04, 0xec,
	0xdb, 0xbc, 0xe3, 0xe6, 0x5e, 0xeb, 0xb8, 0x67, 0x15, 0x89, 0x0d, 0xf5, 0xdb, 0xdc, 0xf6, 0x81,
	0x55, 0x22, 0x5b, 0xf0, 0xc9, 0x6d, 0xce, 0xfe, 0x69, 0xa7, 0xd3, 0xee, 0xd3, 0x93, 0xb3, 0x8e,
	0x35, 0x47, 0x3e, 0x87, 0x27, 0xb3, 0x24, 0x4e, 0x0e, 0xdb, 0x6f, 0xce, 0x9c, 0x66, 0xbf, 0x7d,
	0x7a, 0x42, 0x7f, 0x6c, 0x1e, 0x9f, 0xb5, 0xac, 0xf9, 0xc6, 0xf7, 0x69, 0x54, 0x9a, 0x3a, 0xa5,
	0x0e, 0xd6, 0xfe, 0xe9, 0xf1, 0x59, 0xe7, 0x84, 0xf6, 0x4e, 0x9d, 0xbe, 0x5e, 0x2a, 0x6e, 0x23,
	0x4f, 0xcd, 0x4d, 0x56, 0x68, 0x74, 0x60, 0xe9, 0x46, 0xd9, 0x42, 0xd6, 0x61, 0xb5, 0xeb, 0xb4,
	0x3b, 0x4d, 0xe7, 0xa7, 0x5b, 0x0e, 0x79, 0x08, 0x9b, 0xb7, 0x58, 0x53, 0xe6, 0x1e, 0x42, 0x25,
	0x97, 0x78, 0x48, 0x19, 0xe6, 0xba, 0xce, 0xe9, 0x81, 0x75, 0x87, 0xdc, 0x85, 0xe2, 0x0f, 0x4d,
	0xab, 0xd0, 0xa8, 0x41, 0x25, 0x17, 0x2c, 0x8d, 0x3f, 0x15, 0x60, 0x65, 0x46, 0x05, 0xa0, 0x3a,
	0xdb, 0x49, 0x7d, 0xa8, 0x31, 0x57, 0x07, 0x6b, 0x2d, 0xad, 0x06, 0x35, 0xd8, 0xde, 0xea, 0x74,
	0x8a, 0x33, 0x3a, 0x9d, 0x3a, 0xcc, 0x47, 0xbf, 0x84, 0x3c, 0x36, 0xb7, 0x53, 0x0f, 0xc8, 0x22,
	0x14, 0x5d, 0xd7, 0x9e, 0xc3, 0xde, 0xb1, 0xe8, 0xba, 0xca, 0x54, 0x7a, 0x63, 0xf4, 0x84, 0xa6,
	0xff, 0x37, 0x44, 0x9c, 0xaf, 0xf1, 0x97, 0x12, 0x2c, 0x4e, 0x97, 0x10, 0xea, 0xea, 0x62, 0xb5,
	0xe1, 0xfa, 0x91, 0xd0, 0xdd, 0x7b, 0xd9, 0x59, 0x50, 0x94, 0x7d, 0x45, 0x50, 0xc8, 0x72, 0x11,
	0x49, 0xdf, 0x13, 0x92, 0x7a, 0x43, 0x61, 0x17, 0xb7, 0x4a, 0xdb, 0x25, 0x07, 0x0c, 0xa9, 0x3d,
	0x14, 0xe4, 0x6b, 0x28, 0x8f, 0x63, 0x2f, 0x8a, 0x3d, 0x79, 0x8d, 0x0b, 0x5c, 0xdc, 0xb5, 0x6f,
	0x54, 0x29, 0xaa, 0xb0, 0x44, 0xbe, 0x93, 0x49, 0x92, 0x77, 0x70, 0x3f, 0x67, 0xd6, 0xc0, 0xa2,
	0x86, 0xe8, 0x39, 0x4c, 0xdf, 0xf5, 0x9d, 0xa3, 0x74, 0x0e, 0x84, 0x45, 0x8d, 0xcf, 0xf5, 0xc9,
	0xc4, 0x13, 0x2a, 0xf9, 0x0c, 0x96, 0xce, 0x3d, 0x9f, 0x53, 0x2f, 0x1c, 0x7a, 0xef, 0xbd, 0x61,
	0xc2, 0x7c, 0xd3, 0xfb, 0x2f, 0x2a, 0x72, 0x3b, 0xa3, 0x92, 0xa7, 0xb0, 0x2c, 0xbc, 0x70, 0xe4,
	0x73, 0x19, 0x85, 0x54, 0xed, 0x71, 0x90, 0x8c, 0xb0, 0xfd, 0x2f, 0x3b, 0x56, 0xc6, 0x68, 0x6a,
	0x3a, 0x79, 0x0d, 0x9b, 0xaa, 0x96, 0x62, 0xbe, 0x1f, 0xfd, 0xc2, 0x87, 0x39, 0xe3, 0xba, 0x4a,
	0xb8, 0x87, 0x27, 0x65, 0x07, 0xec, 0xaa, 0xa9, 0x25, 0x26, 0xf3, 0xa8, 0x5c, 0xdc, 0x38, 0x86,
	0x72, 0xba, 0x6f, 0x75, 0x9d, 0xba, 0x4e, 0xfb, 0xd4, 0x69, 0xf7, 0x7f, 0xa2, 0x67, 0x27, 0xbd,
	0x6e, 0x6b, 0xbf, 0x7d, 0xd8, 0x6e, 0x99, 0xb8, 0xea, 0x7e, 0x65, 0x15, 0xf0, 0xf7, 0xb9, 0x55,
	0xc4, 0xdf, 0x5d, 0xab, 0x84, 0xbf, 0x2f, 0xac, 0x39, 0xfc, 0xfd, 0xda, 0x9a, 0x6f, 0xfc, 0x16,
	0x56, 0x66, 0xf8, 0x83, 0xac, 0xa5, 0xb0, 0xa7, 0xce, 0xad, 0x74, 0x74, 0xc7, 0x00, 0x9f, 0xa2,
	0x63, 0xa5, 0x9b, 0x01, 0xad, 0x1e, 0xee, 0xad, 0xc0, 0xf2, 0xc4, 0xed, 0xc6, 0xe1, 0x8d, 0x3f,
	0x17, 0x60, 0xe1, 0x80, 0x89, 0x8b, 0x41, 0xc4, 0xe2, 0x21, 0xd9, 0x85, 0xda, 0x30, 0x1d, 0x50,
	0xc9, 0x06, 0xe6, 0xb9, 0xac, 0xb6, 0x93, 0x89, 0xf4, 0xd9, 0xc0, 0xa9, 0x0e, 0x73, 0xa3, 0xec,
	0xed, 0xa7, 0x98, 0x7b, 0xfb, 0xb9, 0xd5, 0xe7, 0x94, 0x7e, 0x45, 0x9f, 0xf3, 0x10, 0x2a, 0x43,
	0x7e, 0xce, 0x14, 0xdc, 0xaa, 0xa9, 0x75, 0x08, 0x83, 0x21, 0xf5, 0xd9, 0xe0, 0xed, 0x5c, 0x79,
	0xce, 0x9a, 0x6f, 0x74, 0xa1, 0x7a, 0xec, 0x85, 0x97, 0x7d, 0x1e, 0x8c, 0x7d, 0x26, 0x31, 0x1f,
	0xa8, 0xa6, 0xd6, 0xe4, 0x83, 0x24, 0xf6, 0xc9, 0x0e, 0xdc, 0x4b, 0x4b, 0xe7, 0xa2, 0x89, 0x27,
	0xa5, 0x61, 0x22, 0x32, 0x55, 0x74, 0x52, 0xa1, 0xc6, 0x6b, 0x58, 0x99, 0xc1, 0xff, 0xb5, 0x89,
	0xa6, 0xf1, 0xd7, 0xbb, 0x50, 0x3d, 0x98, 0xe5, 0x91, 0xfc, 0x6b, 0x58, 0x0a, 0x0a, 0x58, 0xdb,
	0xe4, 0xf2, 0xa0, 0x06, 0x05, 0xc4, 0x2f, 0xcc, 0x20, 0xb7, 0x40, 0xa1, 0xf4, 0x2b, 0x9f, 0x3f,
	0xe6, 0xfe, 0x8d, 0xe7, 0x8f, 0xf9, 0x0f, 0x3c, 0x7f, 0x3c, 0x82, 0xea, 0x80, 0x09, 0x9e, 0x35,
	0x1e, 0x77, 0xf5, 0xbb, 0x9f, 0xa2, 0xa5, 0x88, 0xf1, 0x1d, 0x90, 0x68, 0xcc, 0x43, 0x5d, 0x8a,
	0x4a, 0xe3, 0x2a, 0xbc, 0x0f, 0xea, 0x78, 0xf3, 0x07, 0xe3, 0x58, 0x4a, 0x50, 0x01, 0x64, 0xe6,
	0xd1, 0x97, 0xb0, 0x8c, 0x77, 0x55, 0xed, 0x30, 0xd3, 0x2d, 0xcf, 0xd2, 0xc5, 0x3b, 0xbd, 0x97,
	0x8c, 0x32, 0xd5, 0xd7, 0xb0, 0xc2, 0xa4, 0x64, 0xee, 0xc5, 0xb4, 0xf2, 0xc2, 0x2c, 0xe5, 0x65,
	0x2d, 0x99, 0x57, 0x7f, 0x04, 0xd5, 0xf4, 0xdd, 0x0a, 0xab, 0x14, 0xd0, 0x3b, 0x33, 0x34, 0xac,
	0x53, 0x7e, 0x93, 0x26, 0x7b, 0x41, 0x93, 0xd8, 0x9f, 0x4c, 0x51, 0x99, 0x35, 0x05, 0x31, 0xa2,
	0x67, 0xb1, 0x9f, 0xcd, 0x71, 0x08, 0x76, 0xfe, 0x54, 0xa6, 0x8c, 0x54, 0x67, 0x19, 0x59, 0x9d,
	0x1c, 0x56, 0xde, 0xce, 0x96, 0xba, 0x07, 0xc2, 0x8d, 0x3d, 0x74, 0x39, 0xbe, 0x7f, 0x2d, 0x38,
	0x79, 0x92, 0xea, 0xc5, 0x25, 0x1b, 0x24, 0x3e, 0x8b, 0x75, 0x79, 0x6e, 0x40, 0x5f, 0xbf, 0x80,
	0x2d, 0x1b, 0x16, 0x96, 0xe7, 0x3a, 0xd3, 0xfc, 0x3f, 0xd4, 0xf4, 0x8b, 0x4b, 0x7a, 0xb0, 0x4b,
	0xb8, 0x9c, 0xf5, 0xa9, 0x6b, 0x8d, 0x1d, 0x5d, 0xda, 0x5b, 0x56, 0x59, 0x6e, 0xa4, 0xe6, 0x63,
	0x83, 0x28, 0x91, 0x74, 0x02, 0x0e, 0xea, 0xca, 0x59, 0xe6, 0x1d, 0x49, 0xb1, 0x32, 0x4b, 0x67,
	0xb1, 0xaf, 0xce, 0x19, 0x83, 0x64, 0xea, 0xa8, 0x96, 0x67, 0x9e, 0xb3, 0x92, 0xcb, 0x1d, 0x54,
	0xe3, 0xef, 0x45, 0xb0, 0x3f, 0xb4, 0xaa, 0x8f, 0xbf, 0x44, 0x16, 0xfe, 0xb3, 0x97, 0xc8, 0xe2,
	0x07, 0x5f, 0x22, 0x3f, 0xf2, 0xc0, 0x57, 0xfa, 0xc8, 0x03, 0xdf, 0xbf, 0xe8, 0xa8, 0xe7, 0x3e,
	0xde, 0x51, 0xe3, 0xa3, 0xbc, 0x7e, 0x13, 0x9c, 0x4f, 0x1f, 0xe5, 0xf5, 0x53, 0xe0, 0x26, 0x2c,
	0x4c, 0x9e, 0xf0, 0xf4, 0xcd, 0x2c, 0x0f, 0xd3, 0x97, 0xbb, 0xc7, 0x50, 0xd3, 0xcc, 0xf4, 0x69,
	0xf0, 0x9e, 0x2e, 0x00, 0x90, 0x68, 0xde, 0x03, 0x1b, 0x1d, 0x58, 0xcc, 0x5c, 0xfb, 0xe1, 0x77,
	0xfb, 0xcf, 0x60, 0x69, 0x72, 0xcc, 0xba, 0xfb, 0x2b, 0x62, 0xa1, 0xb1, 0x98, 0x91, 0x31, 0xb4,
	0x1a, 0x7f, 0x28, 0x40, 0x6d, 0xaa, 0xed, 0x22, 0x4f, 0xa1, 0x32, 0x01, 0xb9, 0xf4, 0xbf, 0x16,
	0x98, 0xf4, 0x5b, 0x0e, 0x64, 0x60, 0xa7, 0xfa, 0x6a, 0xc8, 0x0c, 0xa6, 0x40, 0x0d, 0x93, 0x88,
	0x74, 0x72, 0x5c, 0xf2, 0x7f, 0x60, 0x4d, 0xd6, 0x64, 0xac, 0xeb, 0x94, 0xb2, 0xb4, 0x33, 0xbd,
	0x25, 0x67, 0xb2, 0x78, 0x3d, 0x4f, 0xe3, 0x77, 0x05, 0xa8, 0x1f, 0xe8, 0x24, 0x32, 0xbd, 0xda,
	0x57, 0x40, 0xb2, 0x7c, 0x93, 0xad, 0x1a, 0x5d, 0x31, 0xb5, 0x68, 0x6c, 0x5d, 0xad, 0x34, 0x0d,
	0x65, 0x7f, 0x79, 0xb4, 0x60, 0x35, 0xd5, 0x9e, 0x4e, 0x99, 0x45, 0x13, 0xe7, 0xf9, 0x28, 0x46,
	0x1b, 0x2b, 0x46, 0x3e, 0xcf, 0x18, 0xdc, 0xc5, 0xbf, 0xae, 0x5e, 0xfc, 0x33, 0x00, 0x00, 0xff,
	0xff, 0xb8, 0xba, 0x9d, 0x33, 0xf6, 0x1a, 0x00, 0x00,
}
