/* Copyright (C) 2002-2015 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, see
   <http://www.gnu.org/licenses/>.  */

#ifndef _BITS_SIGCONTEXT_H
#define _BITS_SIGCONTEXT_H  1

#if !defined _SIGNAL_H && !defined _SYS_UCONTEXT_H
# error "Never use <bits/sigcontext.h> directly; include <signal.h> instead."
#endif

#define FP_XSTATE_MAGIC1	0x46505853U
#define FP_XSTATE_MAGIC2	0x46505845U
#define FP_XSTATE_MAGIC2_SIZE	sizeof(FP_XSTATE_MAGIC2)

struct _fpx_sw_bytes {
	__uint32_t magic1;
	__uint32_t extended_size;
	__uint64_t xstate_bv;
	__uint32_t xstate_size;
	__uint32_t padding[7];
};

struct _fpreg {
	unsigned short significand[4];
	unsigned short exponent;
};

struct _fpxreg {
	unsigned short significand[4];
	unsigned short exponent;
	unsigned short padding[3];
};

struct _xmmreg {
	__uint32_t element[4];
};

#ifndef __x86_64__

struct _fpstate {
	/* Regular FPU environment.  */
	__uint32_t cw;
	__uint32_t sw;
	__uint32_t tag;
	__uint32_t ipoff;
	__uint32_t cssel;
	__uint32_t dataoff;
	__uint32_t datasel;
	struct _fpreg _st[8];
	unsigned short status;
	unsigned short magic;

	/* FXSR FPU environment.  */
	__uint32_t _fxsr_env[6];
	__uint32_t mxcsr;
	__uint32_t reserved;
	struct _fpxreg _fxsr_st[8];
	struct _xmmreg _xmm[8];
	__uint32_t padding[56];
};

#ifndef sigcontext_struct
/* Kernel headers before 2.1.1 define a struct sigcontext_struct, but
   we need sigcontext.  Some packages have come to rely on
   sigcontext_struct being defined on 32-bit x86, so define this for
   their benefit.  */
# define sigcontext_struct sigcontext
#endif

#define X86_FXSR_MAGIC		0x0000

struct sigcontext {
	unsigned short gs, __gsh;
	unsigned short fs, __fsh;
	unsigned short es, __esh;
	unsigned short ds, __dsh;
	unsigned long edi;
	unsigned long esi;
	unsigned long ebp;
	unsigned long esp;
	unsigned long ebx;
	unsigned long edx;
	unsigned long ecx;
	unsigned long eax;
	unsigned long trapno;
	unsigned long err;
	unsigned long eip;
	unsigned short cs, __csh;
	unsigned long eflags;
	unsigned long esp_at_signal;
	unsigned short ss, __ssh;
	struct _fpstate *fpstate;
	unsigned long oldmask;
	unsigned long cr2;
};

#else				/* __x86_64__ */

struct _fpstate {
	/* FPU environment matching the 64-bit FXSAVE layout.  */
	__uint16_t cwd;
	__uint16_t swd;
	__uint16_t ftw;
	__uint16_t fop;
	__uint64_t rip;
	__uint64_t rdp;
	__uint32_t mxcsr;
	__uint32_t mxcr_mask;
	struct _fpxreg _st[8];
	struct _xmmreg _xmm[16];
	__uint32_t padding[24];
};

struct sigcontext {
	__uint64_t r8;
	__uint64_t r9;
	__uint64_t r10;
	__uint64_t r11;
	__uint64_t r12;
	__uint64_t r13;
	__uint64_t r14;
	__uint64_t r15;
	__uint64_t rdi;
	__uint64_t rsi;
	__uint64_t rbp;
	__uint64_t rbx;
	__uint64_t rdx;
	__uint64_t rax;
	__uint64_t rcx;
	__uint64_t rsp;
	__uint64_t rip;
	__uint64_t eflags;
	unsigned short cs;
	unsigned short gs;
	unsigned short fs;
	unsigned short __pad0;
	__uint64_t err;
	__uint64_t trapno;
	__uint64_t oldmask;
	__uint64_t cr2;
	__extension__ union {
		struct _fpstate *fpstate;
		__uint64_t __fpstate_word;
	};
	__uint64_t __reserved1[8];
};

#endif				/* __x86_64__ */

struct _xsave_hdr {
	__uint64_t xstate_bv;
	__uint64_t reserved1[2];
	__uint64_t reserved2[5];
};

struct _ymmh_state {
	__uint32_t ymmh_space[64];
};

struct _xstate {
	struct _fpstate fpstate;
	struct _xsave_hdr xstate_hdr;
	struct _ymmh_state ymmh;
};

#endif				/* _BITS_SIGCONTEXT_H */
