This document is auto-generated by `make gen-doc`

## CRD

collects the specified Custom Resource Definitions.

The following CRDs are gathered:
- volumesnapshots.snapshot.storage.k8s.io (10745 bytes)
- volumesnapshotcontents.snapshot.storage.k8s.io (13149 bytes)

The CRD sizes above are in the raw (uncompressed) state.

Location in archive: config/crd/


## CertificateSigningRequests

collects anonymized CertificateSigningRequests.
Collects CSRs which werent Verified, or when Now < ValidBefore or Now > ValidAfter

The Kubernetes api https://github.com/kubernetes/client-go/blob/master/kubernetes/typed/certificates/v1beta1/certificatesigningrequest.go#L78
Response see https://docs.openshift.com/container-platform/4.3/rest_api/index.html#certificatesigningrequestlist-v1beta1certificates

Location in archive: config/certificatesigningrequests/


## ClusterAuthentication

fetches the cluster Authentication - the Authentication with name cluster.

The Kubernetes api https://github.com/openshift/client-go/blob/master/config/clientset/versioned/typed/config/v1/authentication.go#L50
Response see https://docs.openshift.com/container-platform/4.3/rest_api/index.html#authentication-v1operator-openshift-io

Location in archive: config/authentication/
See: docs/insights-archive-sample/config/authentication


## ClusterFeatureGates

fetches the cluster FeatureGate - the FeatureGate with name cluster.

The Kubernetes api https://github.com/openshift/client-go/blob/master/config/clientset/versioned/typed/config/v1/featuregate.go#L50
Response see https://docs.openshift.com/container-platform/4.3/rest_api/index.html#featuregate-v1-config-openshift-io

Location in archive: config/featuregate/
See: docs/insights-archive-sample/config/featuregate


## ClusterID

stores ClusterID from ClusterVersion version
This method uses data already collected by Get ClusterVersion. In particular field .Spec.ClusterID
The Kubernetes api https://github.com/openshift/client-go/blob/master/config/clientset/versioned/typed/config/v1/clusterversion.go#L50
Response see https://github.com/openshift/api/blob/master/config/v1/types_cluster_version.go#L38

Location in archive: config/id/
See: docs/insights-archive-sample/config/id


## ClusterImagePruner

fetches the image pruner configuration

Location in archive: config/clusteroperator/imageregistry.operator.openshift.io/imagepruner/cluster.json


## ClusterImageRegistry

fetches the cluster Image Registry configuration
If the Image Registry configuration uses some PersistentVolumeClaim for the storage then the corresponding
PersistentVolume definition is gathered

Location in archive: config/clusteroperator/imageregistry.operator.openshift.io/config/cluster.json


## ClusterInfrastructure

fetches the cluster Infrastructure - the Infrastructure with name cluster.

The Kubernetes api https://github.com/openshift/client-go/blob/master/config/clientset/versioned/typed/config/v1/infrastructure.go#L50
Response see https://docs.openshift.com/container-platform/4.3/rest_api/index.html#infrastructure-v1-config-openshift-io

Location in archive: config/infrastructure/
See: docs/insights-archive-sample/config/infrastructure


## ClusterIngress

fetches the cluster Ingress - the Ingress with name cluster.

The Kubernetes api https://github.com/openshift/client-go/blob/master/config/clientset/versioned/typed/config/v1/ingress.go#L50
Response see https://docs.openshift.com/container-platform/4.3/rest_api/index.html#ingress-v1-config-openshift-io

Location in archive: config/ingress/
See: docs/insights-archive-sample/config/ingress


## ClusterNetwork

fetches the cluster Network - the Network with name cluster.

The Kubernetes api https://github.com/openshift/client-go/blob/master/config/clientset/versioned/typed/config/v1/network.go#L50
Response see https://docs.openshift.com/container-platform/4.3/rest_api/index.html#network-v1-config-openshift-io

Location in archive: config/network/
See: docs/insights-archive-sample/config/network


## ClusterOAuth

fetches the cluster OAuth - the OAuth with name cluster.

The Kubernetes api https://github.com/openshift/client-go/blob/master/config/clientset/versioned/typed/config/v1/oauth.go#L50
Response see https://docs.openshift.com/container-platform/4.3/rest_api/index.html#oauth-v1-config-openshift-io

Location in archive: config/oauth/
See: docs/insights-archive-sample/config/oauth


## ClusterOperators

collects all ClusterOperators and their resources.
It finds unhealthy Pods for unhealthy operators

The Kubernetes api https://github.com/openshift/client-go/blob/master/config/clientset/versioned/typed/config/v1/clusteroperator.go#L62
Response see https://docs.openshift.com/container-platform/4.3/rest_api/index.html#clusteroperatorlist-v1config-openshift-io

Location of operators in archive: config/clusteroperator/
See: docs/insights-archive-sample/config/clusteroperator
Location of pods in archive: config/pod/


Output raw size: 245

### Examples

#### ClusterOperators
[{"Name":"config/clusteroperator/","Captured":"0001-01-01T00:00:00Z","Fingerprint":"","Item":{"metadata":{"creationTimestamp":null},"spec":{},"status":{"conditions":[{"type":"Degraded","status":"","lastTransitionTime":null}],"extension":null}}}]

## ClusterProxy

fetches the cluster Proxy - the Proxy with name cluster.

The Kubernetes api https://github.com/openshift/client-go/blob/master/config/clientset/versioned/typed/config/v1/proxy.go#L30
Response see https://docs.openshift.com/container-platform/4.3/rest_api/index.html#proxy-v1-config-openshift-io

Location in archive: config/proxy/
See: docs/insights-archive-sample/config/proxy


## ClusterVersion

fetches the ClusterVersion - the ClusterVersion with name version.

The Kubernetes api https://github.com/openshift/client-go/blob/master/config/clientset/versioned/typed/config/v1/clusterversion.go#L50
Response see https://docs.openshift.com/container-platform/4.3/rest_api/index.html#clusterversion-v1config-openshift-io

Location in archive: config/version/
See: docs/insights-archive-sample/config/version


## ConfigMaps

fetches the ConfigMaps from namespace openshift-config.

Anonymization: If the content of ConfigMap contains a parseable PEM structure (like certificate) it removes the inside of PEM blocks.
For ConfigMap of type BinaryData it is encoded as standard base64.
In the archive under configmaps we store name of ConfigMap and then each ConfigMap Key. For example config/configmaps/CONFIGMAPNAME/CONFIGMAPKEY1

The Kubernetes api https://github.com/kubernetes/client-go/blob/master/kubernetes/typed/core/v1/configmap.go#L80
Response see https://docs.openshift.com/container-platform/4.3/rest_api/index.html#configmaplist-v1core

Location in archive: config/configmaps/
See: docs/insights-archive-sample/config/configmaps


## ContainerImages

collects essential information about running containers.
Specifically, the age of pods, the set of running images and the container names are collected.

Location in archive: config/running_containers.json


## HostSubnet

collects HostSubnet information

The Kubernetes api https://github.com/openshift/client-go/blob/master/network/clientset/versioned/typed/network/v1/hostsubnet.go
Response see https://docs.openshift.com/container-platform/4.3/rest_api/index.html#hostsubnet-v1-network-openshift-io

Location in archive: config/hostsubnet/


## InstallPlans

collects Top x InstallPlans from all openshift namespaces.
Because InstallPlans have unique generated names, it groups them by namespace and the "template"
for name generation from field generateName.
It also collects Total number of all installplans and all non-unique installplans.

The Operators-Framework api https://github.com/operator-framework/api/blob/master/pkg/operators/v1alpha1/installplan_types.go#L26

Location in archive: config/installplans/


## MachineSet

collects MachineSet information

The Kubernetes api https://github.com/openshift/machine-api-operator/blob/master/pkg/generated/clientset/versioned/typed/machine/v1beta1/machineset.go
Response see https://docs.openshift.com/container-platform/4.3/rest_api/index.html#machineset-v1beta1-machine-openshift-io

Location in archive: machinesets/


## MostRecentMetrics

gathers cluster Federated Monitoring metrics.

The GET REST query to URL /federate
Gathered metrics:
  etcd_object_counts
  cluster_installer
  namespace CPU and memory usage
  followed by at most 1000 lines of ALERTS metric

Location in archive: config/metrics/
See: docs/insights-archive-sample/config/metrics


Output raw size: 148

### Examples

#### MostRecentMetrics
[{"Name":"config/metrics","Captured":"0001-01-01T00:00:00Z","Fingerprint":"","Item":"SGVsbG8sIGNsaWVudAojIEFMRVJUUyAyLzEwMDAKSGVsbG8sIGNsaWVudAo="}]

## NetNamespace

collects NetNamespaces networking information

The Kubernetes api https://github.com/openshift/client-go/blob/master/network/clientset/versioned/typed/network/v1/netnamespace.go
Response is an array of netNamespaces. Netnamespace contains Name, EgressIPs and NetID attributes.

Location in archive: config/netnamespaces
Id in config: netnamespaces


## Nodes

collects all Nodes.

The Kubernetes api https://github.com/kubernetes/client-go/blob/master/kubernetes/typed/core/v1/node.go#L78
Response see https://docs.openshift.com/container-platform/4.3/rest_api/index.html#nodelist-v1core

Location in archive: config/node/


Output raw size: 491

### Examples

#### Nodes
[{"Name":"config/node/","Captured":"0001-01-01T00:00:00Z","Fingerprint":"","Item":{"metadata":{"creationTimestamp":null},"spec":{},"status":{"conditions":[{"type":"Ready","status":"False","lastHeartbeatTime":null,"lastTransitionTime":null}],"daemonEndpoints":{"kubeletEndpoint":{"Port":0}},"nodeInfo":{"machineID":"","systemUUID":"","bootID":"","kernelVersion":"","osImage":"","containerRuntimeVersion":"","kubeletVersion":"","kubeProxyVersion":"","operatingSystem":"","architecture":""}}}}]

## OpenshiftSDNLogs

collects logs from pods in openshift-sdn namespace with following substrings:
  - "Got OnEndpointsUpdate for unknown Endpoints",
  - "Got OnEndpointsDelete for unknown Endpoints",
  - "Unable to update proxy firewall for policy",
  - "Failed to update proxy firewall for policy",

The Kubernetes API https://github.com/kubernetes/client-go/blob/master/kubernetes/typed/core/v1/pod_expansion.go#L48
Response see https://docs.openshift.com/container-platform/4.6/rest_api/workloads_apis/pod-core-v1.html#apiv1namespacesnamespacepodsnamelog

Location in archive: config/pod/openshift-sdn/logs/{pod-name}/errors.log


## PodDisruptionBudgets

gathers the cluster's PodDisruptionBudgets.

The Kubernetes api https://github.com/kubernetes/client-go/blob/v11.0.0/kubernetes/typed/policy/v1beta1/poddisruptionbudget.go#L80
Response see https://docs.okd.io/latest/rest_api/policy_apis/poddisruptionbudget-policy-v1beta1.html

Location in archive: config/pdbs/
See: docs/insights-archive-sample/config/pdbs

## MachineConfigPool

gathers the cluster's MachineConfigPools.

The Kubernetes api https://github.com/openshift/machine-config-operator/blob/master/pkg/apis/machineconfiguration.openshift.io/v1/types.go#L197
Response see https://docs.okd.io/latest/rest_api/machine_apis/machineconfigpool-machineconfiguration-openshift-io-v1.html

Location in archive: config/machineconfigpools/
See: docs/insights-archive-sample/config/machineconfigpools/

## ContainerRuntimeConfig

collects ContainerRuntimeConfig information

The Kubernetes api https://github.com/openshift/machine-config-operator/blob/master/pkg/apis/machineconfiguration.openshift.io/v1/types.go#L402
Response see https://docs.okd.io/latest/rest_api/machine_apis/containerruntimeconfig-machineconfiguration-openshift-io-v1.html

Location in archive: config/containerruntimeconfigs/
See: docs/insights-archive-sample/config/containerruntimeconfigs

## ServiceAccounts

collects ServiceAccount stats
from kubernetes default and namespaces starting with openshift.

The Kubernetes api https://github.com/kubernetes/client-go/blob/master/kubernetes/typed/core/v1/serviceaccount.go#L83
Response see https://docs.openshift.com/container-platform/4.3/rest_api/index.html#serviceaccount-v1-core

Location of serviceaccounts in archive: config/serviceaccounts
See: docs/insights-archive-sample/config/serviceaccounts

## SAPConfig

collects selected security context constraints
and cluster role bindings from clusters running a SAP payload.

Relevant OpenShift API docs:
  - https://pkg.go.dev/github.com/openshift/client-go/authorization/clientset/versioned/typed/authorization/v1
  - https://pkg.go.dev/github.com/openshift/client-go/security/clientset/versioned/typed/security/v1

Location in archive: config/securitycontentconstraint/, config/clusterrolebinding/
