// Code generated by go-swagger; DO NOT EDIT.

package service_instances

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/swag"

	strfmt "github.com/go-openapi/strfmt"

	models "github.com/IBM-Cloud/power-go-client/power/models"
)

// NewServiceInstanceUpdateParams creates a new ServiceInstanceUpdateParams object
// with the default values initialized.
func NewServiceInstanceUpdateParams() *ServiceInstanceUpdateParams {
	var ()
	return &ServiceInstanceUpdateParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewServiceInstanceUpdateParamsWithTimeout creates a new ServiceInstanceUpdateParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewServiceInstanceUpdateParamsWithTimeout(timeout time.Duration) *ServiceInstanceUpdateParams {
	var ()
	return &ServiceInstanceUpdateParams{

		timeout: timeout,
	}
}

// NewServiceInstanceUpdateParamsWithContext creates a new ServiceInstanceUpdateParams object
// with the default values initialized, and the ability to set a context for a request
func NewServiceInstanceUpdateParamsWithContext(ctx context.Context) *ServiceInstanceUpdateParams {
	var ()
	return &ServiceInstanceUpdateParams{

		Context: ctx,
	}
}

// NewServiceInstanceUpdateParamsWithHTTPClient creates a new ServiceInstanceUpdateParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewServiceInstanceUpdateParamsWithHTTPClient(client *http.Client) *ServiceInstanceUpdateParams {
	var ()
	return &ServiceInstanceUpdateParams{
		HTTPClient: client,
	}
}

/*ServiceInstanceUpdateParams contains all the parameters to send to the API endpoint
for the service instance update operation typically these are written to a http.Request
*/
type ServiceInstanceUpdateParams struct {

	/*XBrokerAPIOriginatingIdentity
	  identity of the user that initiated the request from the Platform

	*/
	XBrokerAPIOriginatingIdentity *string
	/*XBrokerAPIVersion
	  version number of the Service Broker API that the Platform will use

	*/
	XBrokerAPIVersion string
	/*AcceptsIncomplete
	  asynchronous operations supported

	*/
	AcceptsIncomplete *bool
	/*Body
	  parameters for the requested service instance update

	*/
	Body *models.ServiceInstanceUpdateRequest
	/*InstanceID
	  instance id of instance to provision

	*/
	InstanceID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the service instance update params
func (o *ServiceInstanceUpdateParams) WithTimeout(timeout time.Duration) *ServiceInstanceUpdateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the service instance update params
func (o *ServiceInstanceUpdateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the service instance update params
func (o *ServiceInstanceUpdateParams) WithContext(ctx context.Context) *ServiceInstanceUpdateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the service instance update params
func (o *ServiceInstanceUpdateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the service instance update params
func (o *ServiceInstanceUpdateParams) WithHTTPClient(client *http.Client) *ServiceInstanceUpdateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the service instance update params
func (o *ServiceInstanceUpdateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithXBrokerAPIOriginatingIdentity adds the xBrokerAPIOriginatingIdentity to the service instance update params
func (o *ServiceInstanceUpdateParams) WithXBrokerAPIOriginatingIdentity(xBrokerAPIOriginatingIdentity *string) *ServiceInstanceUpdateParams {
	o.SetXBrokerAPIOriginatingIdentity(xBrokerAPIOriginatingIdentity)
	return o
}

// SetXBrokerAPIOriginatingIdentity adds the xBrokerApiOriginatingIdentity to the service instance update params
func (o *ServiceInstanceUpdateParams) SetXBrokerAPIOriginatingIdentity(xBrokerAPIOriginatingIdentity *string) {
	o.XBrokerAPIOriginatingIdentity = xBrokerAPIOriginatingIdentity
}

// WithXBrokerAPIVersion adds the xBrokerAPIVersion to the service instance update params
func (o *ServiceInstanceUpdateParams) WithXBrokerAPIVersion(xBrokerAPIVersion string) *ServiceInstanceUpdateParams {
	o.SetXBrokerAPIVersion(xBrokerAPIVersion)
	return o
}

// SetXBrokerAPIVersion adds the xBrokerApiVersion to the service instance update params
func (o *ServiceInstanceUpdateParams) SetXBrokerAPIVersion(xBrokerAPIVersion string) {
	o.XBrokerAPIVersion = xBrokerAPIVersion
}

// WithAcceptsIncomplete adds the acceptsIncomplete to the service instance update params
func (o *ServiceInstanceUpdateParams) WithAcceptsIncomplete(acceptsIncomplete *bool) *ServiceInstanceUpdateParams {
	o.SetAcceptsIncomplete(acceptsIncomplete)
	return o
}

// SetAcceptsIncomplete adds the acceptsIncomplete to the service instance update params
func (o *ServiceInstanceUpdateParams) SetAcceptsIncomplete(acceptsIncomplete *bool) {
	o.AcceptsIncomplete = acceptsIncomplete
}

// WithBody adds the body to the service instance update params
func (o *ServiceInstanceUpdateParams) WithBody(body *models.ServiceInstanceUpdateRequest) *ServiceInstanceUpdateParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the service instance update params
func (o *ServiceInstanceUpdateParams) SetBody(body *models.ServiceInstanceUpdateRequest) {
	o.Body = body
}

// WithInstanceID adds the instanceID to the service instance update params
func (o *ServiceInstanceUpdateParams) WithInstanceID(instanceID string) *ServiceInstanceUpdateParams {
	o.SetInstanceID(instanceID)
	return o
}

// SetInstanceID adds the instanceId to the service instance update params
func (o *ServiceInstanceUpdateParams) SetInstanceID(instanceID string) {
	o.InstanceID = instanceID
}

// WriteToRequest writes these params to a swagger request
func (o *ServiceInstanceUpdateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.XBrokerAPIOriginatingIdentity != nil {

		// header param X-Broker-API-Originating-Identity
		if err := r.SetHeaderParam("X-Broker-API-Originating-Identity", *o.XBrokerAPIOriginatingIdentity); err != nil {
			return err
		}

	}

	// header param X-Broker-API-Version
	if err := r.SetHeaderParam("X-Broker-API-Version", o.XBrokerAPIVersion); err != nil {
		return err
	}

	if o.AcceptsIncomplete != nil {

		// query param accepts_incomplete
		var qrAcceptsIncomplete bool
		if o.AcceptsIncomplete != nil {
			qrAcceptsIncomplete = *o.AcceptsIncomplete
		}
		qAcceptsIncomplete := swag.FormatBool(qrAcceptsIncomplete)
		if qAcceptsIncomplete != "" {
			if err := r.SetQueryParam("accepts_incomplete", qAcceptsIncomplete); err != nil {
				return err
			}
		}

	}

	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param instance_id
	if err := r.SetPathParam("instance_id", o.InstanceID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
