// Code generated by go-swagger; DO NOT EDIT.

package service_instances

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"

	strfmt "github.com/go-openapi/strfmt"
)

// New creates a new service instances API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) *Client {
	return &Client{transport: transport, formats: formats}
}

/*
Client for service instances API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

/*
ServiceInstanceDeprovision deprovisions a service instance
*/
func (a *Client) ServiceInstanceDeprovision(params *ServiceInstanceDeprovisionParams, authInfo runtime.ClientAuthInfoWriter) (*ServiceInstanceDeprovisionOK, *ServiceInstanceDeprovisionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewServiceInstanceDeprovisionParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "serviceInstance.deprovision",
		Method:             "DELETE",
		PathPattern:        "/v2/service_instances/{instance_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ServiceInstanceDeprovisionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *ServiceInstanceDeprovisionOK:
		return value, nil, nil
	case *ServiceInstanceDeprovisionAccepted:
		return nil, value, nil
	}
	return nil, nil, nil

}

/*
ServiceInstanceGet gets a service instance
*/
func (a *Client) ServiceInstanceGet(params *ServiceInstanceGetParams, authInfo runtime.ClientAuthInfoWriter) (*ServiceInstanceGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewServiceInstanceGetParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "serviceInstance.get",
		Method:             "GET",
		PathPattern:        "/v2/service_instances/{instance_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ServiceInstanceGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*ServiceInstanceGetOK), nil

}

/*
ServiceInstanceLastOperationGet lasts requested operation state for service instance
*/
func (a *Client) ServiceInstanceLastOperationGet(params *ServiceInstanceLastOperationGetParams, authInfo runtime.ClientAuthInfoWriter) (*ServiceInstanceLastOperationGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewServiceInstanceLastOperationGetParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "serviceInstance.lastOperation.get",
		Method:             "GET",
		PathPattern:        "/v2/service_instances/{instance_id}/last_operation",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ServiceInstanceLastOperationGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*ServiceInstanceLastOperationGetOK), nil

}

/*
ServiceInstanceProvision provisions a service instance
*/
func (a *Client) ServiceInstanceProvision(params *ServiceInstanceProvisionParams, authInfo runtime.ClientAuthInfoWriter) (*ServiceInstanceProvisionOK, *ServiceInstanceProvisionCreated, *ServiceInstanceProvisionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewServiceInstanceProvisionParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "serviceInstance.provision",
		Method:             "PUT",
		PathPattern:        "/v2/service_instances/{instance_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ServiceInstanceProvisionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, nil, nil, err
	}
	switch value := result.(type) {
	case *ServiceInstanceProvisionOK:
		return value, nil, nil, nil
	case *ServiceInstanceProvisionCreated:
		return nil, value, nil, nil
	case *ServiceInstanceProvisionAccepted:
		return nil, nil, value, nil
	}
	return nil, nil, nil, nil

}

/*
ServiceInstanceUpdate updates a service instance
*/
func (a *Client) ServiceInstanceUpdate(params *ServiceInstanceUpdateParams, authInfo runtime.ClientAuthInfoWriter) (*ServiceInstanceUpdateOK, *ServiceInstanceUpdateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewServiceInstanceUpdateParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "serviceInstance.update",
		Method:             "PATCH",
		PathPattern:        "/v2/service_instances/{instance_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ServiceInstanceUpdateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *ServiceInstanceUpdateOK:
		return value, nil, nil
	case *ServiceInstanceUpdateAccepted:
		return nil, value, nil
	}
	return nil, nil, nil

}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
