// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// CloneTaskReference clone task reference
// swagger:model CloneTaskReference
type CloneTaskReference struct {

	// ID of a long running PowerVC clone task
	// Required: true
	CloneTaskID *string `json:"cloneTaskID"`

	// Link to PowerVC clone task resource
	// Required: true
	Href *string `json:"href"`
}

// Validate validates this clone task reference
func (m *CloneTaskReference) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCloneTaskID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHref(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CloneTaskReference) validateCloneTaskID(formats strfmt.Registry) error {

	if err := validate.Required("cloneTaskID", "body", m.CloneTaskID); err != nil {
		return err
	}

	return nil
}

func (m *CloneTaskReference) validateHref(formats strfmt.Registry) error {

	if err := validate.Required("href", "body", m.Href); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CloneTaskReference) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CloneTaskReference) UnmarshalBinary(b []byte) error {
	var res CloneTaskReference
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
