// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"strconv"

	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// CloudInstance cloud instance
// swagger:model CloudInstance
type CloudInstance struct {

	// Cloud Instance Capabilities
	Capabilities []string `json:"capabilities"`

	// Cloud Instance ID
	// Required: true
	CloudInstanceID *string `json:"cloudInstanceID"`

	// Indicates if the cloud instance is enabled
	// Required: true
	Enabled *bool `json:"enabled"`

	// Indicates if the cloud instance is initialized and ready for use
	// Required: true
	Initialized *bool `json:"initialized"`

	// Limits on the cloud instance
	// Required: true
	Limits *CloudInstanceUsageLimits `json:"limits"`

	// Cloud Instance Name
	// Required: true
	Name *string `json:"name"`

	// The open stack ID that controls this cloud instance
	// Required: true
	OpenstackID *string `json:"openstackID"`

	// PVM instances owned by the Cloud Instance
	// Required: true
	PvmInstances []*PVMInstanceReference `json:"pvmInstances"`

	// The region the cloud instance lives
	// Required: true
	Region *string `json:"region"`

	// The tenant ID that owns this cloud instance
	// Required: true
	TenantID *string `json:"tenantID"`

	// Current usage on the cloud instance
	// Required: true
	Usage *CloudInstanceUsageLimits `json:"usage"`
}

// Validate validates this cloud instance
func (m *CloudInstance) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCloudInstanceID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEnabled(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateInitialized(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLimits(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOpenstackID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePvmInstances(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRegion(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTenantID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUsage(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CloudInstance) validateCloudInstanceID(formats strfmt.Registry) error {

	if err := validate.Required("cloudInstanceID", "body", m.CloudInstanceID); err != nil {
		return err
	}

	return nil
}

func (m *CloudInstance) validateEnabled(formats strfmt.Registry) error {

	if err := validate.Required("enabled", "body", m.Enabled); err != nil {
		return err
	}

	return nil
}

func (m *CloudInstance) validateInitialized(formats strfmt.Registry) error {

	if err := validate.Required("initialized", "body", m.Initialized); err != nil {
		return err
	}

	return nil
}

func (m *CloudInstance) validateLimits(formats strfmt.Registry) error {

	if err := validate.Required("limits", "body", m.Limits); err != nil {
		return err
	}

	if m.Limits != nil {
		if err := m.Limits.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("limits")
			}
			return err
		}
	}

	return nil
}

func (m *CloudInstance) validateName(formats strfmt.Registry) error {

	if err := validate.Required("name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *CloudInstance) validateOpenstackID(formats strfmt.Registry) error {

	if err := validate.Required("openstackID", "body", m.OpenstackID); err != nil {
		return err
	}

	return nil
}

func (m *CloudInstance) validatePvmInstances(formats strfmt.Registry) error {

	if err := validate.Required("pvmInstances", "body", m.PvmInstances); err != nil {
		return err
	}

	for i := 0; i < len(m.PvmInstances); i++ {
		if swag.IsZero(m.PvmInstances[i]) { // not required
			continue
		}

		if m.PvmInstances[i] != nil {
			if err := m.PvmInstances[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("pvmInstances" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *CloudInstance) validateRegion(formats strfmt.Registry) error {

	if err := validate.Required("region", "body", m.Region); err != nil {
		return err
	}

	return nil
}

func (m *CloudInstance) validateTenantID(formats strfmt.Registry) error {

	if err := validate.Required("tenantID", "body", m.TenantID); err != nil {
		return err
	}

	return nil
}

func (m *CloudInstance) validateUsage(formats strfmt.Registry) error {

	if err := validate.Required("usage", "body", m.Usage); err != nil {
		return err
	}

	if m.Usage != nil {
		if err := m.Usage.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("usage")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CloudInstance) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CloudInstance) UnmarshalBinary(b []byte) error {
	var res CloudInstance
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
