// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// CloudInstanceCreate cloud instance create
// swagger:model CloudInstanceCreate
type CloudInstanceCreate struct {

	// Number of power instances allowed
	Instances *float64 `json:"instances,omitempty"`

	// Amount of memory allowed
	// Required: true
	Memory *float64 `json:"memory"`

	// Number of processor units allowed
	// Required: true
	ProcUnits *float64 `json:"procUnits"`

	// Number of processors allowed
	// Required: true
	Processors *float64 `json:"processors"`

	// The region the cloud instance lives
	// Required: true
	Region *string `json:"region"`

	// Amount of storage allowed (TB)
	Storage *float64 `json:"storage,omitempty"`

	// The tenant ID that owns this cloud instance
	// Required: true
	TenantID *string `json:"tenantID"`
}

// Validate validates this cloud instance create
func (m *CloudInstanceCreate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMemory(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProcUnits(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProcessors(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRegion(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTenantID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CloudInstanceCreate) validateMemory(formats strfmt.Registry) error {

	if err := validate.Required("memory", "body", m.Memory); err != nil {
		return err
	}

	return nil
}

func (m *CloudInstanceCreate) validateProcUnits(formats strfmt.Registry) error {

	if err := validate.Required("procUnits", "body", m.ProcUnits); err != nil {
		return err
	}

	return nil
}

func (m *CloudInstanceCreate) validateProcessors(formats strfmt.Registry) error {

	if err := validate.Required("processors", "body", m.Processors); err != nil {
		return err
	}

	return nil
}

func (m *CloudInstanceCreate) validateRegion(formats strfmt.Registry) error {

	if err := validate.Required("region", "body", m.Region); err != nil {
		return err
	}

	return nil
}

func (m *CloudInstanceCreate) validateTenantID(formats strfmt.Registry) error {

	if err := validate.Required("tenantID", "body", m.TenantID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CloudInstanceCreate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CloudInstanceCreate) UnmarshalBinary(b []byte) error {
	var res CloudInstanceCreate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
