// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// CloudInstanceUsageLimits cloud instance usage limits
// swagger:model CloudInstanceUsageLimits
type CloudInstanceUsageLimits struct {

	// Maximum memory (in GB) per PVMInstance
	InstanceMemory *float64 `json:"instanceMemory,omitempty"`

	// Maximum proc units per PVMInstance
	InstanceProcUnits *float64 `json:"instanceProcUnits,omitempty"`

	// Number of power instances allowed
	// Required: true
	Instances *float64 `json:"instances"`

	// Amount of memory allowed
	// Required: true
	Memory *float64 `json:"memory"`

	// Maximum network bandwidth to GCP Mbps
	PeeringBandwidth *int64 `json:"peeringBandwidth,omitempty"`

	// Amount of peering networks allowed
	PeeringNetworks *int64 `json:"peeringNetworks,omitempty"`

	// Number of processor units allowed
	// Required: true
	ProcUnits *float64 `json:"procUnits"`

	// Number of processors allowed
	// Required: true
	Processors *float64 `json:"processors"`

	// Amount of storage allowed (TB)
	// Required: true
	Storage *float64 `json:"storage"`

	// Amount of SSD storage allowed (TB)
	StorageSSD *float64 `json:"storageSSD,omitempty"`

	// Amount of standard (HDD) storage allowed (TB)
	StorageStandard *float64 `json:"storageStandard,omitempty"`
}

// Validate validates this cloud instance usage limits
func (m *CloudInstanceUsageLimits) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateInstances(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMemory(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProcUnits(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProcessors(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorage(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CloudInstanceUsageLimits) validateInstances(formats strfmt.Registry) error {

	if err := validate.Required("instances", "body", m.Instances); err != nil {
		return err
	}

	return nil
}

func (m *CloudInstanceUsageLimits) validateMemory(formats strfmt.Registry) error {

	if err := validate.Required("memory", "body", m.Memory); err != nil {
		return err
	}

	return nil
}

func (m *CloudInstanceUsageLimits) validateProcUnits(formats strfmt.Registry) error {

	if err := validate.Required("procUnits", "body", m.ProcUnits); err != nil {
		return err
	}

	return nil
}

func (m *CloudInstanceUsageLimits) validateProcessors(formats strfmt.Registry) error {

	if err := validate.Required("processors", "body", m.Processors); err != nil {
		return err
	}

	return nil
}

func (m *CloudInstanceUsageLimits) validateStorage(formats strfmt.Registry) error {

	if err := validate.Required("storage", "body", m.Storage); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CloudInstanceUsageLimits) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CloudInstanceUsageLimits) UnmarshalBinary(b []byte) error {
	var res CloudInstanceUsageLimits
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
