// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// PeeringNetwork peering network
// swagger:model PeeringNetwork
type PeeringNetwork struct {

	// Network in CIDR notation (192.168.0.0/24)
	// Required: true
	Cidr *string `json:"cidr" datastore:"cidr"`

	// DNS Servers
	DNSServers []string `json:"dnsServers,omitempty" datastore:"dnsServers"`

	// Name of project to be peered
	// Required: true
	ProjectName *string `json:"projectName" datastore:"projectName"`
}

// Validate validates this peering network
func (m *PeeringNetwork) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCidr(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProjectName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PeeringNetwork) validateCidr(formats strfmt.Registry) error {

	if err := validate.Required("cidr", "body", m.Cidr); err != nil {
		return err
	}

	return nil
}

func (m *PeeringNetwork) validateProjectName(formats strfmt.Registry) error {

	if err := validate.Required("projectName", "body", m.ProjectName); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PeeringNetwork) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PeeringNetwork) UnmarshalBinary(b []byte) error {
	var res PeeringNetwork
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
